#pragma once

#include <memory>
#include <string>
#include <utility>

#include "JsiSkHostObjects.h"
#include "third_party/base64.h"

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdocumentation"

#include "JsiSkImage.h"
#include "include/codec/SkEncodedImageFormat.h"
#include "include/core/SkStream.h"

#include "include/android/SkAnimatedImage.h"
#include "include/codec/SkAndroidCodec.h"

#pragma clang diagnostic pop

#include <jsi/jsi.h>

namespace RNSkia {

namespace jsi = facebook::jsi;

class JsiSkAnimatedImage
    : public JsiSkWrappingSkPtrHostObject<SkAnimatedImage> {
public:
  // TODO-API: Properties?
  JSI_HOST_FUNCTION(getCurrentFrame) {
    auto image = getObject()->getCurrentFrame();
    auto hostObjectInstance =
        std::make_shared<JsiSkImage>(getContext(), std::move(image));
    return JSI_CREATE_HOST_OBJECT_WITH_MEMORY_PRESSURE(
        runtime, hostObjectInstance, getContext());
  }

  JSI_HOST_FUNCTION(getFrameCount) {
    return static_cast<int>(getObject()->getFrameCount());
  }

  JSI_HOST_FUNCTION(currentFrameDuration) {
    return static_cast<int>(getObject()->currentFrameDuration());
  }

  JSI_HOST_FUNCTION(decodeNextFrame) {
    return static_cast<int>(getObject()->decodeNextFrame());
  }

  EXPORT_JSI_API_TYPENAME(JsiSkAnimatedImage, AnimatedImage)

  JSI_EXPORT_FUNCTIONS(JSI_EXPORT_FUNC(JsiSkAnimatedImage, dispose),
                       JSI_EXPORT_FUNC(JsiSkAnimatedImage, getFrameCount),
                       JSI_EXPORT_FUNC(JsiSkAnimatedImage, getCurrentFrame),
                       JSI_EXPORT_FUNC(JsiSkAnimatedImage,
                                       currentFrameDuration),
                       JSI_EXPORT_FUNC(JsiSkAnimatedImage, decodeNextFrame))

  JsiSkAnimatedImage(std::shared_ptr<RNSkPlatformContext> context,
                     const sk_sp<SkAnimatedImage> image)
      : JsiSkWrappingSkPtrHostObject<SkAnimatedImage>(std::move(context),
                                                      std::move(image)) {}

  size_t getMemoryPressure() const override { return 8192; }
};

} // namespace RNSkia
