/**
 * List of supported react-native platforms.
 */
export type AllPlatforms = "android" | "ios" | "macos" | "visionos" | "web" | "win32" | "windows";
/**
 * Returns a list of extensions that should be tried for the target platform in
 * prioritized order.
 * @param platform The platform to expand platform extensions for
 * @param extensions A list of extensions to expand
 * @returns A list of extensions
 */
export declare function expandPlatformExtensions(platform: string, extensions: readonly string[]): string[];
/**
 * Get the module suffixes array for a given platform, suitable for use with TypeScript's moduleSuffixes setting
 * in the form of ['.ios', '.native', ''] or ['.windows', '.win', '.native', ''] or similar
 *
 * @param platform platform to get module suffixes for
 * @param appendEmpty finish the suffixes with an empty entry, required for typescript usage
 * @returns an array of suffixes to try to match a module to in order of priority
 */
export declare function getModuleSuffixes(platform: AllPlatforms, appendEmpty?: boolean): string[];
/**
 * Returns a map of available React Native platforms. The result is NOT cached.
 * @param startDir The directory to look for react-native platforms from
 * @param platformMap A platform-to-npm-package map of known packages
 * @returns A platform-to-npm-package map, excluding "core" platforms.
 */
export declare function getAvailablePlatformsUncached(startDir?: string, platformMap?: Record<string, string>): typeof platformMap;
/**
 * Returns a map of available React Native platforms. The result is cached.
 * @param startDir The directory to look for react-native platforms from
 * @returns A platform-to-npm-package map, excluding "core" platforms.
 * @function
 */
export declare const getAvailablePlatforms: (startDir?: string) => Record<string, string>;
/**
 * Returns file extensions that can be mapped to the target platform.
 * @param platform The platform to retrieve extensions for
 * @returns Valid extensions for specified platform
 */
export declare function platformExtensions(platform: string): string[];
/**
 * @returns the given string as a platform value or undefined if it is not a valid platform.
 */
export declare function tryParsePlatform(val: string): AllPlatforms | undefined;
/**
 * Parse a string to ensure it maps to a valid react-native platform.
 *
 * @param val Input string
 * @returns React-native platform name. Throws `Error` on failure.
 */
export declare function parsePlatform(val: string): AllPlatforms;
/**
 * @returns List of all supported react-native platforms.
 */
export declare function platformValues(): readonly AllPlatforms[];
//# sourceMappingURL=platform.d.ts.map