"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyEnhancedResolver = applyEnhancedResolver;
const assets_1 = require("../utils/assets");
const enhancedResolveHelpers_1 = require("../utils/enhancedResolveHelpers");
const package_1 = require("../utils/package");
const getEnhancedResolver = (() => {
    const resolvers = {};
    return (context, platform = "common") => {
        if (!resolvers[platform]) {
            const config = (0, enhancedResolveHelpers_1.makeEnhancedResolveOptions)(context, platform);
            resolvers[platform] =
                (0, package_1.importResolver)("enhanced-resolve").create.sync(config);
        }
        return resolvers[platform];
    };
})();
function applyEnhancedResolver(_resolve, context, moduleName, platform) {
    if (!platform) {
        return { type: "empty" };
    }
    const enhancedResolve = getEnhancedResolver(context, platform);
    const filePath = enhancedResolve((0, enhancedResolveHelpers_1.getFromDir)(context), moduleName);
    if (filePath === false) {
        return { type: "empty" };
    }
    if ((0, assets_1.isAssetFile)(context, moduleName)) {
        return (0, assets_1.resolveAsset)(context, filePath);
    }
    return {
        type: "sourceFile",
        filePath,
    };
}
//# sourceMappingURL=enhanced-resolve.js.map