"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.remapReactNativeModule = void 0;
const platform_1 = require("@rnx-kit/tools-react-native/platform");
const remapReactNativeModule = (_context, moduleName, platform) => {
    const platformImpl = (0, platform_1.getAvailablePlatforms)()[platform];
    if (platformImpl) {
        if (moduleName === "react-native") {
            return platformImpl;
        }
        else if (moduleName.startsWith("react-native/")) {
            return `${platformImpl}/${moduleName.slice("react-native/".length)}`;
        }
    }
    return moduleName;
};
exports.remapReactNativeModule = remapReactNativeModule;
//# sourceMappingURL=remapReactNative.js.map