/**
 * Lighthouse v12.5.1 (Mar 26 2025)
 *
 * Automated auditing, performance metrics, and best practices for the web.
 *
 * @homepage https://github.com/GoogleChrome/lighthouse#readme
 * @author   Copyright 2025 Google LLC
 * @license  Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */
"use strict";(()=>{var yY=Object.create;var dd=Object.defineProperty;var vY=Object.getOwnPropertyDescriptor;var bY=Object.getOwnPropertyNames;var wY=Object.getPrototypeOf,xY=Object.prototype.hasOwnProperty;var i=(e,t)=>dd(e,"name",{value:t,configurable:!0});var g=(e,t)=>()=>(e&&(t=e(e=0)),t);var Ne=(e,t)=>()=>(t||e((t={exports:{}}).exports,t),t.exports),E=(e,t)=>{for(var n in t)dd(e,n,{get:t[n],enumerable:!0})},I_=(e,t,n,r)=>{if(t&&typeof t=="object"||typeof t=="function")for(let a of bY(t))!xY.call(e,a)&&a!==n&&dd(e,a,{get:()=>t[a],enumerable:!(r=vY(t,a))||r.enumerable});return e};var Yn=(e,t,n)=>(n=e!=null?yY(wY(e)):{},I_(t||!e||!e.__esModule?dd(n,"default",{value:e,enumerable:!0}):n,e)),DY=e=>I_(dd({},"__esModule",{value:!0}),e);function A_(){throw new Error("setTimeout has not been defined")}function F_(){throw new Error("clearTimeout has not been defined")}function R_(e){if(Ti===setTimeout)return setTimeout(e,0);if((Ti===A_||!Ti)&&setTimeout)return Ti=setTimeout,setTimeout(e,0);try{return Ti(e,0)}catch{try{return Ti.call(null,e,0)}catch{return Ti.call(this,e,0)}}}function EY(e){if(Si===clearTimeout)return clearTimeout(e);if((Si===F_||!Si)&&clearTimeout)return Si=clearTimeout,clearTimeout(e);try{return Si(e)}catch{try{return Si.call(null,e)}catch{return Si.call(this,e)}}}function TY(){!tu||!js||(tu=!1,js.length?To=js.concat(To):bh=-1,To.length&&__())}function __(){if(!tu){var e=R_(TY);tu=!0;for(var t=To.length;t;){for(js=To,To=[];++bh<t;)js&&js[bh].run();bh=-1,t=To.length}js=null,tu=!1,EY(e)}}function tr(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var n=1;n<arguments.length;n++)t[n-1]=arguments[n];To.push(new M_(e,t)),To.length===1&&!tu&&R_(__)}function M_(e,t){this.fun=e,this.array=t}function qs(){}
function qY(e){throw new Error("process.binding is not supported")}function zY(){return"/"}function HY(e){throw new Error("process.chdir is not supported")}function WY(){return 0}function VY(e){var t=GY.call(eu)*.001,n=Math.floor(t),r=Math.floor(t%1*1e9);return e&&(n=n-e[0],r=r-e[1],r<0&&(n--,r+=1e9)),[n,r]}function YY(){var e=new Date,t=e-$Y;return t/1e3}var Ti,Si,To,tu,js,bh,SY,CY,kY,IY,AY,FY,RY,_Y,MY,OY,NY,PY,LY,BY,UY,jY,eu,GY,$Y,nr,Ci=g(()=>{d();i(A_,"defaultSetTimout");i(F_,"defaultClearTimeout");Ti=A_,Si=F_;typeof globalThis.setTimeout=="function"&&(Ti=setTimeout);typeof globalThis.clearTimeout=="function"&&(Si=clearTimeout);i(R_,"runTimeout");i(EY,"runClearTimeout");To=[],tu=!1,bh=-1;i(TY,"cleanUpNextTick");i(__,"drainQueue");i(tr,"nextTick");i(M_,"Item");M_.prototype.run=function(){this.fun.apply(null,this.array)};SY="browser",CY="browser",kY=!0,IY={},AY=[],FY="",RY={},_Y={},MY={};i(qs,"noop");OY=qs,NY=qs,PY=qs,LY=qs,BY=qs,UY=qs,jY=qs;i(qY,"binding");i(zY,"cwd");i(HY,"chdir");i(
WY,"umask");eu=globalThis.performance||{},GY=eu.now||eu.mozNow||eu.msNow||eu.oNow||eu.webkitNow||function(){return new Date().getTime()};i(VY,"hrtime");$Y=new Date;i(YY,"uptime");nr={nextTick:tr,title:SY,browser:kY,env:IY,argv:AY,version:FY,versions:RY,on:OY,addListener:NY,once:PY,off:LY,removeListener:BY,removeAllListeners:UY,emit:jY,binding:qY,cwd:zY,chdir:HY,umask:WY,hrtime:VY,platform:CY,release:_Y,config:MY,uptime:YY}});var d=g(()=>{"use strict";Ci();globalThis.process=nr});function L_(){ib=!0;for(var e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",t=0,n=e.length;t<n;++t)Ha[t]=e[t],Qr[e.charCodeAt(t)]=t;Qr[45]=62,Qr[95]=63}function JY(e){ib||L_();var t,n,r,a,o,s,c=e.length;if(c%4>0)throw new Error("Invalid string. Length must be a multiple of 4");o=e[c-2]==="="?2:e[c-1]==="="?1:0,s=new KY(c*3/4-o),r=o>0?c-4:c;var u=0;for(t=0,n=0;t<r;t+=4,n+=3)a=Qr[e.charCodeAt(t)]<<18|Qr[e.charCodeAt(t+1)]<<12|Qr[e.charCodeAt(t+2)]<<6|Qr[e.charCodeAt(t+3)],s[u++]=a>>16&255,s[u++]=a>>8&255,s[u++]=a&255;return o===2?(a=Qr[e.charCodeAt(t)]<<2|Qr[e.charCodeAt(t+1)]>>4,s[u++]=a&255):o===1&&(a=Qr[e.charCodeAt(t)]<<10|Qr[e.charCodeAt(t+1)]<<4|Qr[e.charCodeAt(t+2)]>>2,s[u++]=a>>8&255,s[u++]=a&255),s}function XY(e){return Ha[e>>18&63]+Ha[e>>12&63]+Ha[e>>6&63]+Ha[e&63]}function ZY(e,t,n){for(var r,a=[],o=t;o<n;o+=3)r=(e[o]<<16)+(e[o+1]<<8)+e[o+2],a.push(XY(r));return a.join("")}function O_(e){ib||L_();for(var t,n=e.length,r=n%3,a="",o=[],s=16383,c=0,u=n-r;c<u;c+=
s)o.push(ZY(e,c,c+s>u?u:c+s));return r===1?(t=e[n-1],a+=Ha[t>>2],a+=Ha[t<<4&63],a+="=="):r===2&&(t=(e[n-2]<<8)+e[n-1],a+=Ha[t>>10],a+=Ha[t>>4&63],a+=Ha[t<<2&63],a+="="),o.push(a),o.join("")}function Dh(e,t,n,r,a){var o,s,c=a*8-r-1,u=(1<<c)-1,l=u>>1,m=-7,p=n?a-1:0,f=n?-1:1,h=e[t+p];for(p+=f,o=h&(1<<-m)-1,h>>=-m,m+=c;m>0;o=o*256+e[t+p],p+=f,m-=8);for(s=o&(1<<-m)-1,o>>=-m,m+=r;m>0;s=s*256+e[t+p],p+=f,m-=8);if(o===0)o=1-l;else{if(o===u)return s?NaN:(h?-1:1)*(1/0);s=s+Math.pow(2,r),o=o-l}return(h?-1:1)*s*Math.pow(2,o-r)}function B_(e,t,n,r,a,o){var s,c,u,l=o*8-a-1,m=(1<<l)-1,p=m>>1,f=a===23?Math.pow(2,-24)-Math.pow(2,-77):0,h=r?0:o-1,y=r?1:-1,b=t<0||t===0&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(c=isNaN(t)?1:0,s=m):(s=Math.floor(Math.log(t)/Math.LN2),t*(u=Math.pow(2,-s))<1&&(s--,u*=2),s+p>=1?t+=f/u:t+=f*Math.pow(2,1-p),t*u>=2&&(s++,u/=2),s+p>=m?(c=0,s=m):s+p>=1?(c=(t*u-1)*Math.pow(2,a),s=s+p):(c=t*Math.pow(2,p-1)*Math.pow(2,a),s=0));a>=8;e[n+h]=c&255,h+=y,c/=256,a-=8);for(s=s<<a|c,l+=
a;l>0;e[n+h]=s&255,h+=y,s/=256,l-=8);e[n+h-y]|=b*128}function wh(){return re.TYPED_ARRAY_SUPPORT?2147483647:1073741823}function So(e,t){if(wh()<t)throw new RangeError("Invalid typed array length");return re.TYPED_ARRAY_SUPPORT?(e=new Uint8Array(t),e.__proto__=re.prototype):(e===null&&(e=new re(t)),e.length=t),e}function re(e,t,n){if(!re.TYPED_ARRAY_SUPPORT&&!(this instanceof re))return new re(e,t,n);if(typeof e=="number"){if(typeof t=="string")throw new Error("If encoding is specified then the first argument must be a string");return sb(this,e)}return j_(this,e,t,n)}function j_(e,t,n,r){if(typeof t=="number")throw new TypeError('"value" argument must not be a number');return typeof ArrayBuffer<"u"&&t instanceof ArrayBuffer?rK(e,t,n,r):typeof t=="string"?nK(e,t,n):aK(e,t)}function q_(e){if(typeof e!="number")throw new TypeError('"size" argument must be a number');if(e<0)throw new RangeError('"size" argument must not be negative')}function tK(e,t,n,r){return q_(t),t<=0?So(e,t):n!==void 0?
typeof r=="string"?So(e,t).fill(n,r):So(e,t).fill(n):So(e,t)}function sb(e,t){if(q_(t),e=So(e,t<0?0:cb(t)|0),!re.TYPED_ARRAY_SUPPORT)for(var n=0;n<t;++n)e[n]=0;return e}function nK(e,t,n){if((typeof n!="string"||n==="")&&(n="utf8"),!re.isEncoding(n))throw new TypeError('"encoding" must be a valid string encoding');var r=z_(t,n)|0;e=So(e,r);var a=e.write(t,n);return a!==r&&(e=e.slice(0,a)),e}function ob(e,t){var n=t.length<0?0:cb(t.length)|0;e=So(e,n);for(var r=0;r<n;r+=1)e[r]=t[r]&255;return e}function rK(e,t,n,r){if(t.byteLength,n<0||t.byteLength<n)throw new RangeError("'offset' is out of bounds");if(t.byteLength<n+(r||0))throw new RangeError("'length' is out of bounds");return n===void 0&&r===void 0?t=new Uint8Array(t):r===void 0?t=new Uint8Array(t,n):t=new Uint8Array(t,n,r),re.TYPED_ARRAY_SUPPORT?(e=t,e.__proto__=re.prototype):e=ob(e,t),e}function aK(e,t){if(Wa(t)){var n=cb(t.length)|0;return e=So(e,n),e.length===0||t.copy(e,0,0,n),e}if(t){if(typeof ArrayBuffer<"u"&&t.buffer instanceof
ArrayBuffer||"length"in t)return typeof t.length!="number"||EK(t.length)?So(e,0):ob(e,t);if(t.type==="Buffer"&&U_(t.data))return ob(e,t.data)}throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")}function cb(e){if(e>=wh())throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x"+wh().toString(16)+" bytes");return e|0}function Wa(e){return!!(e!=null&&e._isBuffer)}function z_(e,t){if(Wa(e))return e.length;if(typeof ArrayBuffer<"u"&&typeof ArrayBuffer.isView=="function"&&(ArrayBuffer.isView(e)||e instanceof ArrayBuffer))return e.byteLength;typeof e!="string"&&(e=""+e);var n=e.length;if(n===0)return 0;for(var r=!1;;)switch(t){case"ascii":case"latin1":case"binary":return n;case"utf8":case"utf-8":case void 0:return xh(e).length;case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return n*2;case"hex":return n>>>1;case"base64":return K_(e).length;default:if(r)return xh(e).length;t=(""+t).toLowerCase(),r=!0}}function oK(e,t,n){
var r=!1;if((t===void 0||t<0)&&(t=0),t>this.length||((n===void 0||n>this.length)&&(n=this.length),n<=0)||(n>>>=0,t>>>=0,n<=t))return"";for(e||(e="utf8");;)switch(e){case"hex":return hK(this,t,n);case"utf8":case"utf-8":return G_(this,t,n);case"ascii":return pK(this,t,n);case"latin1":case"binary":return fK(this,t,n);case"base64":return dK(this,t,n);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return gK(this,t,n);default:if(r)throw new TypeError("Unknown encoding: "+e);e=(e+"").toLowerCase(),r=!0}}function zs(e,t,n){var r=e[t];e[t]=e[n],e[n]=r}function H_(e,t,n,r,a){if(e.length===0)return-1;if(typeof n=="string"?(r=n,n=0):n>2147483647?n=2147483647:n<-2147483648&&(n=-2147483648),n=+n,isNaN(n)&&(n=a?0:e.length-1),n<0&&(n=e.length+n),n>=e.length){if(a)return-1;n=e.length-1}else if(n<0)if(a)n=0;else return-1;if(typeof t=="string"&&(t=re.from(t,r)),Wa(t))return t.length===0?-1:N_(e,t,n,r,a);if(typeof t=="number")return t=t&255,re.TYPED_ARRAY_SUPPORT&&typeof Uint8Array.prototype.indexOf==
"function"?a?Uint8Array.prototype.indexOf.call(e,t,n):Uint8Array.prototype.lastIndexOf.call(e,t,n):N_(e,[t],n,r,a);throw new TypeError("val must be string, number or Buffer")}function N_(e,t,n,r,a){var o=1,s=e.length,c=t.length;if(r!==void 0&&(r=String(r).toLowerCase(),r==="ucs2"||r==="ucs-2"||r==="utf16le"||r==="utf-16le")){if(e.length<2||t.length<2)return-1;o=2,s/=2,c/=2,n/=2}function u(h,y){return o===1?h[y]:h.readUInt16BE(y*o)}i(u,"read");var l;if(a){var m=-1;for(l=n;l<s;l++)if(u(e,l)===u(t,m===-1?0:l-m)){if(m===-1&&(m=l),l-m+1===c)return m*o}else m!==-1&&(l-=l-m),m=-1}else for(n+c>s&&(n=s-c),l=n;l>=0;l--){for(var p=!0,f=0;f<c;f++)if(u(e,l+f)!==u(t,f)){p=!1;break}if(p)return l}return-1}function iK(e,t,n,r){n=Number(n)||0;var a=e.length-n;r?(r=Number(r),r>a&&(r=a)):r=a;var o=t.length;if(o%2!==0)throw new TypeError("Invalid hex string");r>o/2&&(r=o/2);for(var s=0;s<r;++s){var c=parseInt(t.substr(s*2,2),16);if(isNaN(c))return s;e[n+s]=c}return s}function sK(e,t,n,r){return Sh(xh(t,e.length-
n),e,n,r)}function W_(e,t,n,r){return Sh(xK(t),e,n,r)}function cK(e,t,n,r){return W_(e,t,n,r)}function uK(e,t,n,r){return Sh(K_(t),e,n,r)}function lK(e,t,n,r){return Sh(DK(t,e.length-n),e,n,r)}function dK(e,t,n){return t===0&&n===e.length?O_(e):O_(e.slice(t,n))}function G_(e,t,n){n=Math.min(e.length,n);for(var r=[],a=t;a<n;){var o=e[a],s=null,c=o>239?4:o>223?3:o>191?2:1;if(a+c<=n){var u,l,m,p;switch(c){case 1:o<128&&(s=o);break;case 2:u=e[a+1],(u&192)===128&&(p=(o&31)<<6|u&63,p>127&&(s=p));break;case 3:u=e[a+1],l=e[a+2],(u&192)===128&&(l&192)===128&&(p=(o&15)<<12|(u&63)<<6|l&63,p>2047&&(p<55296||p>57343)&&(s=p));break;case 4:u=e[a+1],l=e[a+2],m=e[a+3],(u&192)===128&&(l&192)===128&&(m&192)===128&&(p=(o&15)<<18|(u&63)<<12|(l&63)<<6|m&63,p>65535&&p<1114112&&(s=p))}}s===null?(s=65533,c=1):s>65535&&(s-=65536,r.push(s>>>10&1023|55296),s=56320|s&1023),r.push(s),a+=c}return mK(r)}function mK(e){var t=e.length;if(t<=P_)return String.fromCharCode.apply(String,e);for(var n="",r=0;r<t;)n+=String.fromCharCode.
apply(String,e.slice(r,r+=P_));return n}function pK(e,t,n){var r="";n=Math.min(e.length,n);for(var a=t;a<n;++a)r+=String.fromCharCode(e[a]&127);return r}function fK(e,t,n){var r="";n=Math.min(e.length,n);for(var a=t;a<n;++a)r+=String.fromCharCode(e[a]);return r}function hK(e,t,n){var r=e.length;(!t||t<0)&&(t=0),(!n||n<0||n>r)&&(n=r);for(var a="",o=t;o<n;++o)a+=wK(e[o]);return a}function gK(e,t,n){for(var r=e.slice(t,n),a="",o=0;o<r.length;o+=2)a+=String.fromCharCode(r[o]+r[o+1]*256);return a}function Ln(e,t,n){if(e%1!==0||e<0)throw new RangeError("offset is not uint");if(e+t>n)throw new RangeError("Trying to access beyond buffer length")}function Ar(e,t,n,r,a,o){if(!Wa(e))throw new TypeError('"buffer" argument must be a Buffer instance');if(t>a||t<o)throw new RangeError('"value" argument is out of bounds');if(n+r>e.length)throw new RangeError("Index out of range")}function Eh(e,t,n,r){t<0&&(t=65535+t+1);for(var a=0,o=Math.min(e.length-n,2);a<o;++a)e[n+a]=(t&255<<8*(r?a:1-a))>>>(r?a:1-a)*
8}function Th(e,t,n,r){t<0&&(t=4294967295+t+1);for(var a=0,o=Math.min(e.length-n,4);a<o;++a)e[n+a]=t>>>(r?a:3-a)*8&255}function V_(e,t,n,r,a,o){if(n+r>e.length)throw new RangeError("Index out of range");if(n<0)throw new RangeError("Index out of range")}function $_(e,t,n,r,a){return a||V_(e,t,n,4),B_(e,t,n,r,23,4),n+4}function Y_(e,t,n,r,a){return a||V_(e,t,n,8),B_(e,t,n,r,52,8),n+8}function vK(e){if(e=bK(e).replace(yK,""),e.length<2)return"";for(;e.length%4!==0;)e=e+"=";return e}function bK(e){return e.trim?e.trim():e.replace(/^\s+|\s+$/g,"")}function wK(e){return e<16?"0"+e.toString(16):e.toString(16)}function xh(e,t){t=t||1/0;for(var n,r=e.length,a=null,o=[],s=0;s<r;++s){if(n=e.charCodeAt(s),n>55295&&n<57344){if(!a){if(n>56319){(t-=3)>-1&&o.push(239,191,189);continue}else if(s+1===r){(t-=3)>-1&&o.push(239,191,189);continue}a=n;continue}if(n<56320){(t-=3)>-1&&o.push(239,191,189),a=n;continue}n=(a-55296<<10|n-56320)+65536}else a&&(t-=3)>-1&&o.push(239,191,189);if(a=null,n<128){if((t-=1)<
0)break;o.push(n)}else if(n<2048){if((t-=2)<0)break;o.push(n>>6|192,n&63|128)}else if(n<65536){if((t-=3)<0)break;o.push(n>>12|224,n>>6&63|128,n&63|128)}else if(n<1114112){if((t-=4)<0)break;o.push(n>>18|240,n>>12&63|128,n>>6&63|128,n&63|128)}else throw new Error("Invalid code point")}return o}function xK(e){for(var t=[],n=0;n<e.length;++n)t.push(e.charCodeAt(n)&255);return t}function DK(e,t){for(var n,r,a,o=[],s=0;s<e.length&&!((t-=2)<0);++s)n=e.charCodeAt(s),r=n>>8,a=n%256,o.push(a),o.push(r);return o}function K_(e){return JY(vK(e))}function Sh(e,t,n,r){for(var a=0;a<r&&!(a+n>=t.length||a>=e.length);++a)t[a+n]=e[a];return a}function EK(e){return e!==e}function TK(e){return e!=null&&(!!e._isBuffer||J_(e)||SK(e))}function J_(e){return!!e.constructor&&typeof e.constructor.isBuffer=="function"&&e.constructor.isBuffer(e)}function SK(e){return typeof e.readFloatLE=="function"&&typeof e.slice=="function"&&J_(e.slice(0,0))}var Ha,Qr,KY,ib,QY,U_,eK,zxe,P_,yK,nu=g(()=>{d();Ha=[],Qr=[],KY=typeof Uint8Array<
"u"?Uint8Array:Array,ib=!1;i(L_,"init");i(JY,"toByteArray");i(XY,"tripletToBase64");i(ZY,"encodeChunk");i(O_,"fromByteArray");i(Dh,"read");i(B_,"write");QY={}.toString,U_=Array.isArray||function(e){return QY.call(e)=="[object Array]"};eK=50;re.TYPED_ARRAY_SUPPORT=globalThis.TYPED_ARRAY_SUPPORT!==void 0?globalThis.TYPED_ARRAY_SUPPORT:!0;zxe=wh();i(wh,"kMaxLength");i(So,"createBuffer");i(re,"Buffer");re.poolSize=8192;re._augment=function(e){return e.__proto__=re.prototype,e};i(j_,"from");re.from=function(e,t,n){return j_(null,e,t,n)};re.TYPED_ARRAY_SUPPORT&&(re.prototype.__proto__=Uint8Array.prototype,re.__proto__=Uint8Array,typeof Symbol<"u"&&Symbol.species&&re[Symbol.species]);i(q_,"assertSize");i(tK,"alloc");re.alloc=function(e,t,n){return tK(null,e,t,n)};i(sb,"allocUnsafe");re.allocUnsafe=function(e){return sb(null,e)};re.allocUnsafeSlow=function(e){return sb(null,e)};i(nK,"fromString");i(ob,"fromArrayLike");i(rK,"fromArrayBuffer");i(aK,"fromObject");i(cb,"checked");re.isBuffer=TK;i(
Wa,"internalIsBuffer");re.compare=i(function(t,n){if(!Wa(t)||!Wa(n))throw new TypeError("Arguments must be Buffers");if(t===n)return 0;for(var r=t.length,a=n.length,o=0,s=Math.min(r,a);o<s;++o)if(t[o]!==n[o]){r=t[o],a=n[o];break}return r<a?-1:a<r?1:0},"compare");re.isEncoding=i(function(t){switch(String(t).toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"latin1":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return!0;default:return!1}},"isEncoding");re.concat=i(function(t,n){if(!U_(t))throw new TypeError('"list" argument must be an Array of Buffers');if(t.length===0)return re.alloc(0);var r;if(n===void 0)for(n=0,r=0;r<t.length;++r)n+=t[r].length;var a=re.allocUnsafe(n),o=0;for(r=0;r<t.length;++r){var s=t[r];if(!Wa(s))throw new TypeError('"list" argument must be an Array of Buffers');s.copy(a,o),o+=s.length}return a},"concat");i(z_,"byteLength");re.byteLength=z_;i(oK,"slowToString");re.prototype._isBuffer=!0;i(zs,"swap");re.prototype.swap16=
i(function(){var t=this.length;if(t%2!==0)throw new RangeError("Buffer size must be a multiple of 16-bits");for(var n=0;n<t;n+=2)zs(this,n,n+1);return this},"swap16");re.prototype.swap32=i(function(){var t=this.length;if(t%4!==0)throw new RangeError("Buffer size must be a multiple of 32-bits");for(var n=0;n<t;n+=4)zs(this,n,n+3),zs(this,n+1,n+2);return this},"swap32");re.prototype.swap64=i(function(){var t=this.length;if(t%8!==0)throw new RangeError("Buffer size must be a multiple of 64-bits");for(var n=0;n<t;n+=8)zs(this,n,n+7),zs(this,n+1,n+6),zs(this,n+2,n+5),zs(this,n+3,n+4);return this},"swap64");re.prototype.toString=i(function(){var t=this.length|0;return t===0?"":arguments.length===0?G_(this,0,t):oK.apply(this,arguments)},"toString");re.prototype.equals=i(function(t){if(!Wa(t))throw new TypeError("Argument must be a Buffer");return this===t?!0:re.compare(this,t)===0},"equals");re.prototype.inspect=i(function(){var t="",n=eK;return this.length>0&&(t=this.toString("hex",0,n).match(
/.{2}/g).join(" "),this.length>n&&(t+=" ... ")),"<Buffer "+t+">"},"inspect");re.prototype.compare=i(function(t,n,r,a,o){if(!Wa(t))throw new TypeError("Argument must be a Buffer");if(n===void 0&&(n=0),r===void 0&&(r=t?t.length:0),a===void 0&&(a=0),o===void 0&&(o=this.length),n<0||r>t.length||a<0||o>this.length)throw new RangeError("out of range index");if(a>=o&&n>=r)return 0;if(a>=o)return-1;if(n>=r)return 1;if(n>>>=0,r>>>=0,a>>>=0,o>>>=0,this===t)return 0;for(var s=o-a,c=r-n,u=Math.min(s,c),l=this.slice(a,o),m=t.slice(n,r),p=0;p<u;++p)if(l[p]!==m[p]){s=l[p],c=m[p];break}return s<c?-1:c<s?1:0},"compare");i(H_,"bidirectionalIndexOf");i(N_,"arrayIndexOf");re.prototype.includes=i(function(t,n,r){return this.indexOf(t,n,r)!==-1},"includes");re.prototype.indexOf=i(function(t,n,r){return H_(this,t,n,r,!0)},"indexOf");re.prototype.lastIndexOf=i(function(t,n,r){return H_(this,t,n,r,!1)},"lastIndexOf");i(iK,"hexWrite");i(sK,"utf8Write");i(W_,"asciiWrite");i(cK,"latin1Write");i(uK,"base64Write");
i(lK,"ucs2Write");re.prototype.write=i(function(t,n,r,a){if(n===void 0)a="utf8",r=this.length,n=0;else if(r===void 0&&typeof n=="string")a=n,r=this.length,n=0;else if(isFinite(n))n=n|0,isFinite(r)?(r=r|0,a===void 0&&(a="utf8")):(a=r,r=void 0);else throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");var o=this.length-n;if((r===void 0||r>o)&&(r=o),t.length>0&&(r<0||n<0)||n>this.length)throw new RangeError("Attempt to write outside buffer bounds");a||(a="utf8");for(var s=!1;;)switch(a){case"hex":return iK(this,t,n,r);case"utf8":case"utf-8":return sK(this,t,n,r);case"ascii":return W_(this,t,n,r);case"latin1":case"binary":return cK(this,t,n,r);case"base64":return uK(this,t,n,r);case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":return lK(this,t,n,r);default:if(s)throw new TypeError("Unknown encoding: "+a);a=(""+a).toLowerCase(),s=!0}},"write");re.prototype.toJSON=i(function(){return{type:"Buffer",data:Array.prototype.slice.call(this._arr||this,0)}},"t\
oJSON");i(dK,"base64Slice");i(G_,"utf8Slice");P_=4096;i(mK,"decodeCodePointsArray");i(pK,"asciiSlice");i(fK,"latin1Slice");i(hK,"hexSlice");i(gK,"utf16leSlice");re.prototype.slice=i(function(t,n){var r=this.length;t=~~t,n=n===void 0?r:~~n,t<0?(t+=r,t<0&&(t=0)):t>r&&(t=r),n<0?(n+=r,n<0&&(n=0)):n>r&&(n=r),n<t&&(n=t);var a;if(re.TYPED_ARRAY_SUPPORT)a=this.subarray(t,n),a.__proto__=re.prototype;else{var o=n-t;a=new re(o,void 0);for(var s=0;s<o;++s)a[s]=this[s+t]}return a},"slice");i(Ln,"checkOffset");re.prototype.readUIntLE=i(function(t,n,r){t=t|0,n=n|0,r||Ln(t,n,this.length);for(var a=this[t],o=1,s=0;++s<n&&(o*=256);)a+=this[t+s]*o;return a},"readUIntLE");re.prototype.readUIntBE=i(function(t,n,r){t=t|0,n=n|0,r||Ln(t,n,this.length);for(var a=this[t+--n],o=1;n>0&&(o*=256);)a+=this[t+--n]*o;return a},"readUIntBE");re.prototype.readUInt8=i(function(t,n){return n||Ln(t,1,this.length),this[t]},"readUInt8");re.prototype.readUInt16LE=i(function(t,n){return n||Ln(t,2,this.length),this[t]|this[t+1]<<
8},"readUInt16LE");re.prototype.readUInt16BE=i(function(t,n){return n||Ln(t,2,this.length),this[t]<<8|this[t+1]},"readUInt16BE");re.prototype.readUInt32LE=i(function(t,n){return n||Ln(t,4,this.length),(this[t]|this[t+1]<<8|this[t+2]<<16)+this[t+3]*16777216},"readUInt32LE");re.prototype.readUInt32BE=i(function(t,n){return n||Ln(t,4,this.length),this[t]*16777216+(this[t+1]<<16|this[t+2]<<8|this[t+3])},"readUInt32BE");re.prototype.readIntLE=i(function(t,n,r){t=t|0,n=n|0,r||Ln(t,n,this.length);for(var a=this[t],o=1,s=0;++s<n&&(o*=256);)a+=this[t+s]*o;return o*=128,a>=o&&(a-=Math.pow(2,8*n)),a},"readIntLE");re.prototype.readIntBE=i(function(t,n,r){t=t|0,n=n|0,r||Ln(t,n,this.length);for(var a=n,o=1,s=this[t+--a];a>0&&(o*=256);)s+=this[t+--a]*o;return o*=128,s>=o&&(s-=Math.pow(2,8*n)),s},"readIntBE");re.prototype.readInt8=i(function(t,n){return n||Ln(t,1,this.length),this[t]&128?(255-this[t]+1)*-1:this[t]},"readInt8");re.prototype.readInt16LE=i(function(t,n){n||Ln(t,2,this.length);var r=this[t]|
this[t+1]<<8;return r&32768?r|4294901760:r},"readInt16LE");re.prototype.readInt16BE=i(function(t,n){n||Ln(t,2,this.length);var r=this[t+1]|this[t]<<8;return r&32768?r|4294901760:r},"readInt16BE");re.prototype.readInt32LE=i(function(t,n){return n||Ln(t,4,this.length),this[t]|this[t+1]<<8|this[t+2]<<16|this[t+3]<<24},"readInt32LE");re.prototype.readInt32BE=i(function(t,n){return n||Ln(t,4,this.length),this[t]<<24|this[t+1]<<16|this[t+2]<<8|this[t+3]},"readInt32BE");re.prototype.readFloatLE=i(function(t,n){return n||Ln(t,4,this.length),Dh(this,t,!0,23,4)},"readFloatLE");re.prototype.readFloatBE=i(function(t,n){return n||Ln(t,4,this.length),Dh(this,t,!1,23,4)},"readFloatBE");re.prototype.readDoubleLE=i(function(t,n){return n||Ln(t,8,this.length),Dh(this,t,!0,52,8)},"readDoubleLE");re.prototype.readDoubleBE=i(function(t,n){return n||Ln(t,8,this.length),Dh(this,t,!1,52,8)},"readDoubleBE");i(Ar,"checkInt");re.prototype.writeUIntLE=i(function(t,n,r,a){if(t=+t,n=n|0,r=r|0,!a){var o=Math.pow(2,8*
r)-1;Ar(this,t,n,r,o,0)}var s=1,c=0;for(this[n]=t&255;++c<r&&(s*=256);)this[n+c]=t/s&255;return n+r},"writeUIntLE");re.prototype.writeUIntBE=i(function(t,n,r,a){if(t=+t,n=n|0,r=r|0,!a){var o=Math.pow(2,8*r)-1;Ar(this,t,n,r,o,0)}var s=r-1,c=1;for(this[n+s]=t&255;--s>=0&&(c*=256);)this[n+s]=t/c&255;return n+r},"writeUIntBE");re.prototype.writeUInt8=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,1,255,0),re.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),this[n]=t&255,n+1},"writeUInt8");i(Eh,"objectWriteUInt16");re.prototype.writeUInt16LE=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,2,65535,0),re.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8):Eh(this,t,n,!0),n+2},"writeUInt16LE");re.prototype.writeUInt16BE=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,2,65535,0),re.TYPED_ARRAY_SUPPORT?(this[n]=t>>>8,this[n+1]=t&255):Eh(this,t,n,!1),n+2},"writeUInt16BE");i(Th,"objectWriteUInt32");re.prototype.writeUInt32LE=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,4,4294967295,0),re.TYPED_ARRAY_SUPPORT?
(this[n+3]=t>>>24,this[n+2]=t>>>16,this[n+1]=t>>>8,this[n]=t&255):Th(this,t,n,!0),n+4},"writeUInt32LE");re.prototype.writeUInt32BE=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,4,4294967295,0),re.TYPED_ARRAY_SUPPORT?(this[n]=t>>>24,this[n+1]=t>>>16,this[n+2]=t>>>8,this[n+3]=t&255):Th(this,t,n,!1),n+4},"writeUInt32BE");re.prototype.writeIntLE=i(function(t,n,r,a){if(t=+t,n=n|0,!a){var o=Math.pow(2,8*r-1);Ar(this,t,n,r,o-1,-o)}var s=0,c=1,u=0;for(this[n]=t&255;++s<r&&(c*=256);)t<0&&u===0&&this[n+s-1]!==0&&(u=1),this[n+s]=(t/c>>0)-u&255;return n+r},"writeIntLE");re.prototype.writeIntBE=i(function(t,n,r,a){if(t=+t,n=n|0,!a){var o=Math.pow(2,8*r-1);Ar(this,t,n,r,o-1,-o)}var s=r-1,c=1,u=0;for(this[n+s]=t&255;--s>=0&&(c*=256);)t<0&&u===0&&this[n+s+1]!==0&&(u=1),this[n+s]=(t/c>>0)-u&255;return n+r},"writeIntBE");re.prototype.writeInt8=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,1,127,-128),re.TYPED_ARRAY_SUPPORT||(t=Math.floor(t)),t<0&&(t=255+t+1),this[n]=t&255,n+1},"writeInt8");re.
prototype.writeInt16LE=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,2,32767,-32768),re.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8):Eh(this,t,n,!0),n+2},"writeInt16LE");re.prototype.writeInt16BE=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,2,32767,-32768),re.TYPED_ARRAY_SUPPORT?(this[n]=t>>>8,this[n+1]=t&255):Eh(this,t,n,!1),n+2},"writeInt16BE");re.prototype.writeInt32LE=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,4,2147483647,-2147483648),re.TYPED_ARRAY_SUPPORT?(this[n]=t&255,this[n+1]=t>>>8,this[n+2]=t>>>16,this[n+3]=t>>>24):Th(this,t,n,!0),n+4},"writeInt32LE");re.prototype.writeInt32BE=i(function(t,n,r){return t=+t,n=n|0,r||Ar(this,t,n,4,2147483647,-2147483648),t<0&&(t=4294967295+t+1),re.TYPED_ARRAY_SUPPORT?(this[n]=t>>>24,this[n+1]=t>>>16,this[n+2]=t>>>8,this[n+3]=t&255):Th(this,t,n,!1),n+4},"writeInt32BE");i(V_,"checkIEEE754");i($_,"writeFloat");re.prototype.writeFloatLE=i(function(t,n,r){return $_(this,t,n,!0,r)},"writeFloatLE");re.prototype.writeFloatBE=
i(function(t,n,r){return $_(this,t,n,!1,r)},"writeFloatBE");i(Y_,"writeDouble");re.prototype.writeDoubleLE=i(function(t,n,r){return Y_(this,t,n,!0,r)},"writeDoubleLE");re.prototype.writeDoubleBE=i(function(t,n,r){return Y_(this,t,n,!1,r)},"writeDoubleBE");re.prototype.copy=i(function(t,n,r,a){if(r||(r=0),!a&&a!==0&&(a=this.length),n>=t.length&&(n=t.length),n||(n=0),a>0&&a<r&&(a=r),a===r||t.length===0||this.length===0)return 0;if(n<0)throw new RangeError("targetStart out of bounds");if(r<0||r>=this.length)throw new RangeError("sourceStart out of bounds");if(a<0)throw new RangeError("sourceEnd out of bounds");a>this.length&&(a=this.length),t.length-n<a-r&&(a=t.length-n+r);var o=a-r,s;if(this===t&&r<n&&n<a)for(s=o-1;s>=0;--s)t[s+n]=this[s+r];else if(o<1e3||!re.TYPED_ARRAY_SUPPORT)for(s=0;s<o;++s)t[s+n]=this[s+r];else Uint8Array.prototype.set.call(t,this.subarray(r,r+o),n);return o},"copy");re.prototype.fill=i(function(t,n,r,a){if(typeof t=="string"){if(typeof n=="string"?(a=n,n=0,r=this.length):
typeof r=="string"&&(a=r,r=this.length),t.length===1){var o=t.charCodeAt(0);o<256&&(t=o)}if(a!==void 0&&typeof a!="string")throw new TypeError("encoding must be a string");if(typeof a=="string"&&!re.isEncoding(a))throw new TypeError("Unknown encoding: "+a)}else typeof t=="number"&&(t=t&255);if(n<0||this.length<n||this.length<r)throw new RangeError("Out of range index");if(r<=n)return this;n=n>>>0,r=r===void 0?this.length:r>>>0,t||(t=0);var s;if(typeof t=="number")for(s=n;s<r;++s)this[s]=t;else{var c=Wa(t)?t:xh(new re(t,a).toString()),u=c.length;for(s=0;s<r-n;++s)this[s+n]=c[s%u]}return this},"fill");yK=/[^+\/0-9A-Za-z-_]/g;i(vK,"base64clean");i(bK,"stringtrim");i(wK,"toHex");i(xh,"utf8ToBytes");i(xK,"asciiToBytes");i(DK,"utf16leToBytes");i(K_,"base64ToBytes");i(Sh,"blitBuffer");i(EK,"isnan");i(TK,"isBuffer");i(J_,"isFastBuffer");i(SK,"isSlowBuffer")});function ki(){}function Et(){Et.init.call(this)}function X_(e){return e._maxListeners===void 0?Et.defaultMaxListeners:e._maxListeners}function CK(e,t,n){if(t)e.call(n);else for(var r=e.length,a=md(e,r),o=0;o<r;++o)a[o].call(n)}function kK(e,t,n,r){if(t)e.call(n,r);else for(var a=e.length,o=md(e,a),s=0;s<a;++s)o[s].call(n,r)}function IK(e,t,n,r,a){if(t)e.call(n,r,a);else for(var o=e.length,s=md(e,o),c=0;c<o;++c)s[c].call(n,r,a)}function AK(e,t,n,r,a,o){if(t)e.call(n,r,a,o);else for(var s=e.length,c=md(e,s),u=0;u<s;++u)c[u].call(n,r,a,o)}function FK(e,t,n,r){if(t)e.apply(n,r);else for(var a=e.length,o=md(e,a),s=0;s<a;++s)o[s].apply(n,r)}function Z_(e,t,n,r){var a,o,s;if(typeof n!="function")throw new TypeError('"listener" argument must be a function');if(o=e._events,o?(o.newListener&&(e.emit("newListener",t,n.listener?n.listener:n),o=e._events),s=o[t]):(o=e._events=new ki,e._eventsCount=0),!s)s=o[t]=n,++e._eventsCount;else if(typeof s=="function"?s=o[t]=r?[n,s]:[s,n]:r?s.unshift(n):s.push(
n),!s.warned&&(a=X_(e),a&&a>0&&s.length>a)){s.warned=!0;var c=new Error("Possible EventEmitter memory leak detected. "+s.length+" "+t+" listeners added. Use emitter.setMaxListeners() to increase limit");c.name="MaxListenersExceededWarning",c.emitter=e,c.type=t,c.count=s.length,RK(c)}return e}function RK(e){typeof console.warn=="function"?console.warn(e):console.log(e)}function Q_(e,t,n){var r=!1;function a(){e.removeListener(t,a),r||(r=!0,n.apply(e,arguments))}return i(a,"g"),a.listener=n,a}function eM(e){var t=this._events;if(t){var n=t[e];if(typeof n=="function")return 1;if(n)return n.length}return 0}function _K(e,t){for(var n=t,r=n+1,a=e.length;r<a;n+=1,r+=1)e[n]=e[r];e.pop()}function md(e,t){for(var n=new Array(t);t--;)n[t]=e[t];return n}function MK(e){for(var t=new Array(e.length),n=0;n<t.length;++n)t[n]=e[n].listener||e[n];return t}var ub,ea,Co=g(()=>{"use strict";d();i(ki,"EventHandlers");ki.prototype=Object.create(null);i(Et,"EventEmitter");ea=Et;Et.EventEmitter=Et;Et.usingDomains=
!1;Et.prototype.domain=void 0;Et.prototype._events=void 0;Et.prototype._maxListeners=void 0;Et.defaultMaxListeners=10;Et.init=function(){this.domain=null,Et.usingDomains&&ub.active&&!(this instanceof ub.Domain)&&(this.domain=ub.active),(!this._events||this._events===Object.getPrototypeOf(this)._events)&&(this._events=new ki,this._eventsCount=0),this._maxListeners=this._maxListeners||void 0};Et.prototype.setMaxListeners=i(function(t){if(typeof t!="number"||t<0||isNaN(t))throw new TypeError('"n" argument must be a positive number');return this._maxListeners=t,this},"setMaxListeners");i(X_,"$getMaxListeners");Et.prototype.getMaxListeners=i(function(){return X_(this)},"getMaxListeners");i(CK,"emitNone");i(kK,"emitOne");i(IK,"emitTwo");i(AK,"emitThree");i(FK,"emitMany");Et.prototype.emit=i(function(t){var n,r,a,o,s,c,u,l=!1,m=t==="error";if(c=this._events,c)m=m&&c.error==null;else if(!m)return!1;if(u=this.domain,m){if(n=arguments[1],u)n||(n=new Error('Uncaught, unspecified "error" event')),
n.domainEmitter=this,n.domain=u,n.domainThrown=!1,u.emit("error",n);else{if(n instanceof Error)throw n;var p=new Error('Uncaught, unspecified "error" event. ('+n+")");throw p.context=n,p}return!1}if(r=c[t],!r)return!1;var f=typeof r=="function";switch(a=arguments.length,a){case 1:CK(r,f,this);break;case 2:kK(r,f,this,arguments[1]);break;case 3:IK(r,f,this,arguments[1],arguments[2]);break;case 4:AK(r,f,this,arguments[1],arguments[2],arguments[3]);break;default:for(o=new Array(a-1),s=1;s<a;s++)o[s-1]=arguments[s];FK(r,f,this,o)}return l&&u.exit(),!0},"emit");i(Z_,"_addListener");i(RK,"emitWarning");Et.prototype.addListener=i(function(t,n){return Z_(this,t,n,!1)},"addListener");Et.prototype.on=Et.prototype.addListener;Et.prototype.prependListener=i(function(t,n){return Z_(this,t,n,!0)},"prependListener");i(Q_,"_onceWrap");Et.prototype.once=i(function(t,n){if(typeof n!="function")throw new TypeError('"listener" argument must be a function');return this.on(t,Q_(this,t,n)),this},"once");Et.prototype.
prependOnceListener=i(function(t,n){if(typeof n!="function")throw new TypeError('"listener" argument must be a function');return this.prependListener(t,Q_(this,t,n)),this},"prependOnceListener");Et.prototype.removeListener=i(function(t,n){var r,a,o,s,c;if(typeof n!="function")throw new TypeError('"listener" argument must be a function');if(a=this._events,!a)return this;if(r=a[t],!r)return this;if(r===n||r.listener&&r.listener===n)--this._eventsCount===0?this._events=new ki:(delete a[t],a.removeListener&&this.emit("removeListener",t,r.listener||n));else if(typeof r!="function"){for(o=-1,s=r.length;s-- >0;)if(r[s]===n||r[s].listener&&r[s].listener===n){c=r[s].listener,o=s;break}if(o<0)return this;if(r.length===1){if(r[0]=void 0,--this._eventsCount===0)return this._events=new ki,this;delete a[t]}else _K(r,o);a.removeListener&&this.emit("removeListener",t,c||n)}return this},"removeListener");Et.prototype.off=function(e,t){return this.removeListener(e,t)};Et.prototype.removeAllListeners=i(function(t){
var n,r;if(r=this._events,!r)return this;if(!r.removeListener)return arguments.length===0?(this._events=new ki,this._eventsCount=0):r[t]&&(--this._eventsCount===0?this._events=new ki:delete r[t]),this;if(arguments.length===0){for(var a=Object.keys(r),o=0,s;o<a.length;++o)s=a[o],s!=="removeListener"&&this.removeAllListeners(s);return this.removeAllListeners("removeListener"),this._events=new ki,this._eventsCount=0,this}if(n=r[t],typeof n=="function")this.removeListener(t,n);else if(n)do this.removeListener(t,n[n.length-1]);while(n[0]);return this},"removeAllListeners");Et.prototype.listeners=i(function(t){var n,r,a=this._events;return a?(n=a[t],n?typeof n=="function"?r=[n.listener||n]:r=MK(n):r=[]):r=[],r},"listeners");Et.listenerCount=function(e,t){return typeof e.listenerCount=="function"?e.listenerCount(t):eM.call(e,t)};Et.prototype.listenerCount=eM;i(eM,"listenerCount");Et.prototype.eventNames=i(function(){return this._eventsCount>0?Reflect.ownKeys(this._events):[]},"eventNames");i(
_K,"spliceOne");i(md,"arrayClone");i(MK,"unwrapListeners")});var nM=Ne((Kxe,tM)=>{d();var ru=1e3,au=ru*60,ou=au*60,Hs=ou*24,OK=Hs*7,NK=Hs*365.25;tM.exports=function(e,t){t=t||{};var n=typeof e;if(n==="string"&&e.length>0)return PK(e);if(n==="number"&&isFinite(e))return t.long?BK(e):LK(e);throw new Error("val is not a non-empty string or a valid number. val="+JSON.stringify(e))};function PK(e){if(e=String(e),!(e.length>100)){var t=/^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(e);if(t){var n=parseFloat(t[1]),r=(t[2]||"ms").toLowerCase();switch(r){case"years":case"year":case"yrs":case"yr":case"y":return n*NK;case"weeks":case"week":case"w":return n*OK;case"days":case"day":case"d":return n*Hs;case"hours":case"hour":case"hrs":case"hr":case"h":return n*ou;case"minutes":case"minute":case"mins":case"min":case"m":return n*au;case"seconds":case"second":case"secs":case"sec":case"s":return n*ru;case"milliseconds":case"millisecond":case"msecs":case"msec":case"ms":return n;default:
return}}}}i(PK,"parse");function LK(e){var t=Math.abs(e);return t>=Hs?Math.round(e/Hs)+"d":t>=ou?Math.round(e/ou)+"h":t>=au?Math.round(e/au)+"m":t>=ru?Math.round(e/ru)+"s":e+"ms"}i(LK,"fmtShort");function BK(e){var t=Math.abs(e);return t>=Hs?Ch(e,t,Hs,"day"):t>=ou?Ch(e,t,ou,"hour"):t>=au?Ch(e,t,au,"minute"):t>=ru?Ch(e,t,ru,"second"):e+" ms"}i(BK,"fmtLong");function Ch(e,t,n,r){var a=t>=n*1.5;return Math.round(e/n)+" "+r+(a?"s":"")}i(Ch,"plural")});var aM=Ne((Zxe,rM)=>{d();function UK(e){n.debug=n,n.default=n,n.coerce=u,n.disable=o,n.enable=a,n.enabled=s,n.humanize=nM(),n.destroy=l,Object.keys(e).forEach(m=>{n[m]=e[m]}),n.names=[],n.skips=[],n.formatters={};function t(m){let p=0;for(let f=0;f<m.length;f++)p=(p<<5)-p+m.charCodeAt(f),p|=0;return n.colors[Math.abs(p)%n.colors.length]}i(t,"selectColor"),n.selectColor=t;function n(m){let p,f=null,h,y;function b(...w){if(!b.enabled)return;let D=b,T=Number(new Date),S=T-(p||T);D.diff=S,D.prev=p,D.curr=T,p=T,w[0]=n.coerce(w[0]),typeof w[0]!="string"&&w.unshift("%O");let k=0;w[0]=w[0].replace(/%([a-zA-Z%])/g,(Y,W)=>{if(Y==="%%")return"%";k++;let oe=n.formatters[W];if(typeof oe=="function"){let me=w[k];Y=oe.call(D,me),w.splice(k,1),k--}return Y}),n.formatArgs.call(D,w),(D.log||n.log).apply(D,w)}return i(b,"debug"),b.namespace=m,b.useColors=n.useColors(),b.color=n.selectColor(m),b.extend=r,b.destroy=n.destroy,Object.defineProperty(b,"enabled",{enumerable:!0,configurable:!1,get:()=>f!==null?
f:(h!==n.namespaces&&(h=n.namespaces,y=n.enabled(m)),y),set:w=>{f=w}}),typeof n.init=="function"&&n.init(b),b}i(n,"createDebug");function r(m,p){let f=n(this.namespace+(typeof p>"u"?":":p)+m);return f.log=this.log,f}i(r,"extend");function a(m){n.save(m),n.namespaces=m,n.names=[],n.skips=[];let p,f=(typeof m=="string"?m:"").split(/[\s,]+/),h=f.length;for(p=0;p<h;p++)f[p]&&(m=f[p].replace(/\*/g,".*?"),m[0]==="-"?n.skips.push(new RegExp("^"+m.slice(1)+"$")):n.names.push(new RegExp("^"+m+"$")))}i(a,"enable");function o(){let m=[...n.names.map(c),...n.skips.map(c).map(p=>"-"+p)].join(",");return n.enable(""),m}i(o,"disable");function s(m){if(m[m.length-1]==="*")return!0;let p,f;for(p=0,f=n.skips.length;p<f;p++)if(n.skips[p].test(m))return!1;for(p=0,f=n.names.length;p<f;p++)if(n.names[p].test(m))return!0;return!1}i(s,"enabled");function c(m){return m.toString().substring(2,m.toString().length-2).replace(/\.\*\?$/,"*")}i(c,"toNamespace");function u(m){return m instanceof Error?m.stack||m.message:
m}i(u,"coerce");function l(){console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.")}return i(l,"destroy"),n.enable(n.load()),n}i(UK,"setup");rM.exports=UK});var oM=Ne((Vr,kh)=>{d();Vr.formatArgs=qK;Vr.save=zK;Vr.load=HK;Vr.useColors=jK;Vr.storage=WK();Vr.destroy=(()=>{let e=!1;return()=>{e||(e=!0,console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."))}})();Vr.colors=["#0000CC","#0000FF","#0033CC","#0033FF","#0066CC","#0066FF","#0099CC","#0099FF","#00CC00","#00CC33","#00CC66","#00CC99","#00CCCC","#00CCFF","#3300CC","#3300FF","#3333CC","#3333FF","#3366CC","#3366FF","#3399CC","#3399FF","#33CC00","#33CC33","#33CC66","#33CC99","#33CCCC","#33CCFF","#6600CC","#6600FF","#6633CC","#6633FF","#66CC00","#66CC33","#9900CC","#9900FF","#9933CC","#9933FF","#99CC00","#99CC33","#CC0000","#CC0033","#CC0066","#CC0099","#CC00CC","#CC00FF","#CC3300","#CC3333","#CC3366","#CC3399","#CC33CC","#CC33FF","#CC6600","#CC6633","#CC9900","#CC9933","#CCCC00","#CCCC33","#FF0000","#FF0033","#FF0066","#FF0099","#FF00CC","#FF00FF","#FF3300","#FF3333","#FF3366","#FF3399","#FF33CC","#\
FF33FF","#FF6600","#FF6633","#FF9900","#FF9933","#FFCC00","#FFCC33"];function jK(){return typeof window<"u"&&window.process&&(window.process.type==="renderer"||window.process.__nwjs)?!0:typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)?!1:typeof document<"u"&&document.documentElement&&document.documentElement.style&&document.documentElement.style.WebkitAppearance||typeof window<"u"&&window.console&&(window.console.firebug||window.console.exception&&window.console.table)||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)&&parseInt(RegExp.$1,10)>=31||typeof navigator<"u"&&navigator.userAgent&&navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/)}i(jK,"useColors");function qK(e){if(e[0]=(this.useColors?"%c":"")+this.namespace+(this.useColors?" %c":" ")+e[0]+(this.useColors?"%c ":" ")+"+"+kh.exports.humanize(this.diff),!this.useColors)return;let t="color: "+this.color;e.splice(
1,0,t,"color: inherit");let n=0,r=0;e[0].replace(/%[a-zA-Z%]/g,a=>{a!=="%%"&&(n++,a==="%c"&&(r=n))}),e.splice(r,0,t)}i(qK,"formatArgs");Vr.log=console.debug||console.log||(()=>{});function zK(e){try{e?Vr.storage.setItem("debug",e):Vr.storage.removeItem("debug")}catch{}}i(zK,"save");function HK(){let e;try{e=Vr.storage.getItem("debug")}catch{}return!e&&typeof process<"u"&&"env"in process&&(e=process.env.DEBUG),e}i(HK,"load");function WK(){try{return localStorage}catch{}}i(WK,"localstorage");kh.exports=aM()(Vr);var{formatters:GK}=kh.exports;GK.j=function(e){try{return JSON.stringify(e)}catch(t){return"[UnexpectedJSONParseError]: "+t.message}}});function Ih(e){if(!e)throw new Error("name must be non-empty")}function VK(e,t){for(var n=0,r=e.length,a;n<r;)a=n+r>>>1,e[a].startTime<t.startTime?n=a+1:r=a;e.splice(n,0,t)}var pr,iM,Rh,_h,pd,Mh,Ah,Fh,sM=g(()=>{d();pr=typeof performance<"u"&&performance,iM=pr&&pr.now?function(){return pr.now()}:function(){return Date.now()};i(Ih,"throwIfEmpty");i(VK,"insertSorted");pr&&pr.mark&&pr.getEntriesByName&&pr.getEntriesByType&&pr.clearMeasures?(Rh=i(function(e){Ih(e),pr.mark("start "+e)},"mark"),_h=i(function(e){Ih(e),pr.mark("end "+e),pr.measure(e,"start "+e,"end "+e);var t=pr.getEntriesByName(e);return t[t.length-1]},"stop"),pd=i(function(){return pr.getEntriesByType("measure")},"getEntries"),Mh=i(function(){pr.clearMarks(),pr.clearMeasures()},"clear")):(Ah={},Fh=[],Rh=i(function(e){Ih(e);var t=iM();Ah["$"+e]=t},"mark"),_h=i(function(e){Ih(e);var t=iM(),n=Ah["$"+e];if(!n)throw new Error("no known mark: "+e);var r={startTime:n,name:e,duration:t-n,entryType:"measure"};return VK(Fh,r),r},"stop"),
pd=i(function(){return Fh},"getEntries"),Mh=i(function(){Ah={},Fh=[]},"clear"))});var Ai,Ii,iu,su,lb,cM,YK,uM,cu,H,ct=g(()=>{d();Ci();Co();Ai=Yn(oM());sM();Ii=nr.platform==="win32",iu=nr.browser,su={red:iu?"crimson":1,yellow:iu?"gold":3,cyan:iu?"darkturquoise":6,green:iu?"forestgreen":2,blue:iu?"steelblue":4,magenta:iu?"palevioletred":5};Ai.default.colors=[su.cyan,su.green,su.blue,su.magenta];lb=class extends Et{static{i(this,"Emitter")}issueStatus(t,n){(t==="status"||t==="statusEnd")&&this.emit(t,[t,...n])}issueWarning(t,n){this.emit("warning",[t,...n])}},cM={},YK=25,cu=class e{static{i(this,"Log")}static _logToStdErr(t,n){e.loggerfn(t)(...n)}static loggerfn(t){t=`LH:${t}`;let n=cM[t];return n||(n=(0,Ai.default)(t),cM[t]=n,t.endsWith("error")?n.color=su.red:t.endsWith("warn")&&(n.color=su.yellow)),n}static setLevel(t){switch(uM=t,t){case"silent":Ai.default.enable("-LH:*");break;case"verbose":Ai.default.enable("LH:*");break;case"warn":Ai.default.enable("-LH:*, LH:*:warn, LH:*:error");break;case"error":Ai.default.enable("-LH:*, LH:*:error");break;default:Ai.default.enable(
"LH:*, -LH:*:verbose")}}static formatProtocol(t,n,r){let a=!nr||nr.browser?1/0:nr.stdout.columns,o=n.method||"?????",s=a-o.length-t.length-YK,c=n.params&&o!=="IO.read"?JSON.stringify(n.params).substr(0,s):"";e._logToStdErr(`${t}:${r||""}`,[o,c])}static isVerbose(){return uM==="verbose"}static time({msg:t,id:n,args:r=[]},a="log"){Rh(n),e[a]("status",t,...r)}static timeEnd({msg:t,id:n,args:r=[]},a="verbose"){e[a]("statusEnd",t,...r),_h(n)}static log(t,...n){return e.events.issueStatus(t,n),e._logToStdErr(t,n)}static warn(t,...n){return e.events.issueWarning(t,n),e._logToStdErr(`${t}:warn`,n)}static error(t,...n){return e._logToStdErr(`${t}:error`,n)}static verbose(t,...n){return e.events.issueStatus(t,n),e._logToStdErr(`${t}:verbose`,n)}static greenify(t){return`${e.green}${t}${e.reset}`}static redify(t){return`${e.red}${t}${e.reset}`}static get green(){return"\x1B[32m"}static get red(){return"\x1B[31m"}static get yellow(){return"\x1B[33m"}static get purple(){return"\x1B[95m"}static get reset(){
return"\x1B[0m"}static get bold(){return"\x1B[1m"}static get dim(){return"\x1B[2m"}static get tick(){return Ii?"√":"✓"}static get cross(){return Ii?"×":"✘"}static get whiteSmallSquare(){return Ii?"·":"▫"}static get heavyHorizontal(){return Ii?"─":"━"}static get heavyVertical(){return Ii?"│ ":"┃ "}static get heavyUpAndRight(){return Ii?"└":"┗"}static get heavyVerticalAndRight(){return Ii?"├":"┣"}static get heavyDownAndHorizontal(){return Ii?"┬":"┳"}static get doubleLightHorizontal(){return"──"}};cu.events=new lb;cu.takeTimeEntries=()=>{let e=pd();return Mh(),e};cu.getTimeEntries=()=>pd();H=cu});var rr=g(()=>{"use strict";d();});var db,Ee,kt=g(()=>{"use strict";d();rr();db=class{static{i(this,"BaseGatherer")}meta={supportedModes:[]};startInstrumentation(t){}startSensitiveInstrumentation(t){}stopSensitiveInstrumentation(t){}stopInstrumentation(t){}getArtifact(t){}},Ee=db});var KK,JK,XK,ZK,QK,eJ,Kn,ko=g(()=>{"use strict";d();ct();KK=/^(chrome|https?):/,JK=16,XK="RunTask",ZK="ThreadControllerImpl::RunTask",QK="ThreadControllerImpl::DoWork",eJ="TaskQueueManager::ProcessTaskFromWorkQueue",Kn=class e{static{i(this,"TraceProcessor")}static get TIMESPAN_MARKER_ID(){return"__lighthouseTimespanStart__"}static createNoNavstartError(){return new Error("No navigationStart event found")}static createNoResourceSendRequestError(){return new Error("No ResourceSendRequest event found")}static createNoTracingStartedError(){return new Error("No tracingStartedInBrowser event found")}static createNoFirstContentfulPaintError(){return new Error("No FirstContentfulPaint event found")}static createNoLighthouseMarkerError(){return new Error("No Lighthouse timespan marker event found")}static _isNavigationStartOfInterest(t){return t.name!=="navigationStart"?!1:t.args.data?.documentLoaderURL===void 0?!0:t.args.data?.documentLoaderURL?KK.test(t.args.data.documentLoaderURL):!1}static _sortTimestampEventGroup(t,n,r,a){
let o=i(p=>n[p],"lookupArrayIndexByTsIndex"),s=i(p=>a[o(p)],"lookupEventByTsIndex"),c=[],u=[],l=[];for(let p of t){let f=o(p),h=s(p);h.ph==="E"?c.push(f):h.ph==="X"||h.ph==="B"?u.push(f):l.push(f)}let m=new Map;for(let p of u){let f=a[p];if(f.ph==="X")m.set(p,f.dur);else{let h=Number.MAX_SAFE_INTEGER,y=0,b=r+t.length;for(let w=b;w<n.length;w++){let D=s(w);if(D.name===f.name&&D.pid===f.pid&&D.tid===f.tid)if(D.ph==="E"&&y===0){h=D.ts-f.ts;break}else D.ph==="E"?y--:D.ph==="B"&&y++}m.set(p,h)}}return u.sort((p,f)=>(m.get(f)||0)-(m.get(p)||0)||p-f),l.sort((p,f)=>p-f),[...c,...u,...l]}static filteredTraceSort(t,n){let r=[];for(let o=0;o<t.length;o++)n(t[o])&&r.push(o);r.sort((o,s)=>t[o].ts-t[s].ts);for(let o=0;o<r.length-1;o++){let s=t[r[o]].ts,c=[o];for(let l=o+1;l<r.length&&t[r[l]].ts===s;l++)c.push(l);if(c.length===1)continue;let u=e._sortTimestampEventGroup(c,r,o,t);r.splice(o,u.length,...u),o+=c.length-1}let a=[];for(let o=0;o<r.length;o++)a.push(t[r[o]]);return a}static assertHasToplevelEvents(t){
if(!t.some(this.isScheduleableTask))throw new Error("Could not find any top level events")}static _riskPercentiles(t,n,r,a=0){let o=0;for(let f=0;f<t.length;f++)o+=t[f];o-=a;let s=n-o,c=0,u=s,l=[],m=-1,p=t.length+1;a>0&&p--;for(let f of r){let h=f*n;for(;u<h&&m<t.length-1;)s+=c,p-=c<0?-1:1,a>0&&a<t[m+1]?(c=-a,a=0):(m++,c=t[m]),u=s+Math.abs(c)*p;l.push({percentile:f,time:Math.max(0,(h-s)/p)+JK})}return l}static getRiskToResponsiveness(t,n,r,a=[.5,.75,.9,.99,1]){let o=r-n;a.sort((c,u)=>c-u);let s=this.getMainThreadTopLevelEventDurations(t,n,r);return this._riskPercentiles(s.durations,o,a,s.clippedLength)}static getMainThreadTopLevelEventDurations(t,n=0,r=1/0){let a=[],o=0;for(let s of t){if(s.end<n||s.start>r)continue;let c=s.duration,u=s.start;u<n&&(u=n,c=s.end-n),s.end>r&&(o=c-(r-u)),a.push(c)}return a.sort((s,c)=>s-c),{durations:a,clippedLength:o}}static getMainThreadTopLevelEvents(t,n=0,r=1/0){let a=[],o;for(let s of t.mainThreadEvents){if(!this.isScheduleableTask(s)||!s.dur)continue;
let c=(s.ts-t.timeOriginEvt.ts)/1e3,u=(s.ts+s.dur-t.timeOriginEvt.ts)/1e3;c>r||u<n||(o&&c<o.end&&(o.end=c-.001),o={start:c,end:u,duration:s.dur/1e3},a.push(o))}return a}static findMainFrameIds(t){let n=t.find(s=>s.name==="TracingStartedInBrowser");if(n?.args.data?.frames){let s=n.args.data.frames.find(l=>!l.parent),c=s?.frame,u=s?.processId;if(u&&c)return{startingPid:u,frameId:c}}let r=t.find(s=>s.name==="TracingStartedInPage");if(r?.args?.data){let s=r.args.data.page;if(s)return{startingPid:r.pid,frameId:s}}let a=t.find(s=>this._isNavigationStartOfInterest(s)&&s.args.data?.isLoadingMainFrame),o=t.find(s=>s.name==="ResourceSendRequest");if(a?.args?.data&&o&&o.pid===a.pid&&o.tid===a.tid){let s=a.args.frame;if(s)return{startingPid:a.pid,frameId:s}}throw this.createNoTracingStartedError()}static findMainFramePidTids(t,n){let r=n.filter(s=>(s.name==="FrameCommittedInBrowser"||s.name==="ProcessReadyInBrowser")&&s.args?.data?.frame===t.frameId&&s?.args?.data?.processId),a=r.length?r.map(s=>s?.
args?.data?.processId):[t.startingPid],o=new Map;for(let s of new Set(a)){let c=n.filter(m=>m.cat==="__metadata"&&m.pid===s&&m.ph==="M"&&m.name==="thread_name"),u=c.find(m=>m.args.name==="CrRendererMain");u||(u=c.find(m=>m.args.name==="CrBrowserMain"));let l=u?.tid;if(!l)throw new Error("Unable to determine tid for renderer process");o.set(s,l)}return o}static isScheduleableTask(t){return t.name===XK||t.name===ZK||t.name===QK||t.name===eJ}static isLCPEvent(t){return t.name!=="largestContentfulPaint::Invalidate"&&t.name!=="largestContentfulPaint::Candidate"?!1:!!t.args?.frame}static isLCPCandidateEvent(t){return!!(t.name==="largestContentfulPaint::Candidate"&&t.args?.frame&&t.args.data&&t.args.data.size!==void 0)}static getFrameId(t){return t.args?.data?.frame||t.args.data?.frameID||t.args.frame}static computeValidLCPAllFrames(t,n){let r=t.filter(this.isLCPEvent).reverse(),a=new Map;for(let s of r){if(s.ts<=n.ts)break;let c=s.args.frame;a.has(c)||a.set(c,s)}let o;for(let s of a.values())
this.isLCPCandidateEvent(s)&&(!o||s.args.data.size>o.args.data.size)&&(o=s);return{lcp:o,invalidated:!!(!o&&a.size)}}static resolveRootFrames(t){let n=new Map;for(let a of t)a.parent&&n.set(a.id,a.parent);let r=new Map;for(let a of t){let o=a.id;for(;n.has(o);)o=n.get(o);if(o===void 0)throw new Error("Unexpected undefined frameId");r.set(a.id,o)}return r}static processTrace(t,n){let{timeOriginDeterminationMethod:r="auto"}=n||{},a=this.filteredTraceSort(t.traceEvents,k=>k.cat.includes("blink.user_timing")||k.cat.includes("loading")||k.cat.includes("devtools.timeline")||k.cat==="__metadata"),o=this.findMainFrameIds(a),s=this.findMainFramePidTids(o,a),c=e.filteredTraceSort(t.traceEvents,k=>s.has(k.pid)),u=new Map,l=a.find(k=>k.name==="TracingStartedInBrowser")?.args?.data?.frames;if(l)for(let k of l)u.set(k.frame,{id:k.frame,url:k.url,parent:k.parent});a.filter(k=>!!(k.name==="FrameCommittedInBrowser"&&k.args.data?.frame&&k.args.data.url!==void 0)).forEach(k=>{u.set(k.args.data.frame,{id:k.
args.data.frame,url:k.args.data.url,parent:k.args.data.parent})});let m=[...u.values()],p=this.resolveRootFrames(m),f=[...p.entries()].filter(([,k])=>k===o.frameId).map(([k])=>k);function h(k){return e.getFrameId(k)===o.frameId}i(h,"associatedToMainFrame");function y(k){let _=e.getFrameId(k);return _?f.includes(_):!1}i(y,"associatedToAllFrames");let b=a.filter(k=>h(k)),w=[];p.has(o.frameId)?w=a.filter(k=>y(k)):(H.warn("TraceProcessor","frameTreeEvents may be incomplete, make sure the trace has frame events"),p.set(o.frameId,o.frameId),w=b);let D=this.computeTimeOrigin({keyEvents:a,frameEvents:b,mainFrameInfo:o},r),T=c.filter(k=>k.tid===s.get(k.pid)),S=this.computeTraceEnd(t.traceEvents,D);return{frames:m,mainThreadEvents:T,frameEvents:b,frameTreeEvents:w,processEvents:c,mainFrameInfo:o,timeOriginEvt:D,timings:{timeOrigin:0,traceEnd:S.timing},timestamps:{timeOrigin:D.ts,traceEnd:S.timestamp},_keyEvents:a,_rendererPidToTid:s}}static processNavigation(t){let{frameEvents:n,frameTreeEvents:r,
timeOriginEvt:a,timings:o,timestamps:s}=t,c=this.computeNavigationTimingsForFrame(n,{timeOriginEvt:a}),u=r.find(f=>f.name==="firstContentfulPaint"&&f.ts>a.ts);if(!u)throw this.createNoFirstContentfulPaintError();let l=this.computeValidLCPAllFrames(r,a).lcp,m=i(f=>(f-a.ts)/1e3,"getTiming"),p=i(f=>f===void 0?void 0:m(f),"maybeGetTiming");return{timings:{timeOrigin:o.timeOrigin,firstPaint:c.timings.firstPaint,firstContentfulPaint:c.timings.firstContentfulPaint,firstContentfulPaintAllFrames:m(u.ts),largestContentfulPaint:c.timings.largestContentfulPaint,largestContentfulPaintAllFrames:p(l?.ts),load:c.timings.load,domContentLoaded:c.timings.domContentLoaded,traceEnd:o.traceEnd},timestamps:{timeOrigin:s.timeOrigin,firstPaint:c.timestamps.firstPaint,firstContentfulPaint:c.timestamps.firstContentfulPaint,firstContentfulPaintAllFrames:u.ts,largestContentfulPaint:c.timestamps.largestContentfulPaint,largestContentfulPaintAllFrames:l?.ts,load:c.timestamps.load,domContentLoaded:c.timestamps.domContentLoaded,
traceEnd:s.traceEnd},firstPaintEvt:c.firstPaintEvt,firstContentfulPaintEvt:c.firstContentfulPaintEvt,firstContentfulPaintAllFramesEvt:u,largestContentfulPaintEvt:c.largestContentfulPaintEvt,largestContentfulPaintAllFramesEvt:l,loadEvt:c.loadEvt,domContentLoadedEvt:c.domContentLoadedEvt,lcpInvalidated:c.lcpInvalidated}}static computeTraceEnd(t,n){let r=-1/0;for(let a of t)r=Math.max(a.ts+(a.dur||0),r);return{timestamp:r,timing:(r-n.ts)/1e3}}static computeTimeOrigin(t,n){let r=i(()=>t.frameEvents.filter(this._isNavigationStartOfInterest).pop(),"lastNavigationStart"),a=i(()=>t.keyEvents.find(s=>s.name==="clock_sync"&&s.args.sync_id===e.TIMESPAN_MARKER_ID),"lighthouseMarker");switch(n){case"firstResourceSendRequest":{let o=t.keyEvents.find(s=>s.name!=="ResourceSendRequest"?!1:(s.args.data||{}).frame===t.mainFrameInfo.frameId);if(!o)throw this.createNoResourceSendRequestError();return o}case"lastNavigationStart":{let o=r();if(!o)throw this.createNoNavstartError();return o}case"lighthouseMar\
ker":{let o=a();if(!o)throw this.createNoLighthouseMarkerError();return o}case"auto":{let o=a()||r();if(!o)throw this.createNoNavstartError();return o}}}static computeNavigationTimingsForFrame(t,n){let{timeOriginEvt:r}=n,a=t.find(y=>y.name==="firstPaint"&&y.ts>r.ts),o=t.find(y=>y.name==="firstContentfulPaint"&&y.ts>r.ts);if(!o)throw this.createNoFirstContentfulPaintError();let s=this.computeValidLCPAllFrames(t,r),c=t.find(y=>y.name==="loadEventEnd"&&y.ts>r.ts),u=t.find(y=>y.name==="domContentLoadedEventEnd"&&y.ts>r.ts),l=i(y=>y?.ts,"getTimestamp"),m={timeOrigin:r.ts,firstPaint:l(a),firstContentfulPaint:o.ts,largestContentfulPaint:l(s.lcp),load:l(c),domContentLoaded:l(u)},p=i(y=>(y-r.ts)/1e3,"getTiming"),f=i(y=>y===void 0?void 0:p(y),"maybeGetTiming");return{timings:{timeOrigin:0,firstPaint:f(m.firstPaint),firstContentfulPaint:p(m.firstContentfulPaint),largestContentfulPaint:f(m.largestContentfulPaint),load:f(m.load),domContentLoaded:f(m.domContentLoaded)},timestamps:m,timeOriginEvt:r,firstPaintEvt:a,
firstContentfulPaintEvt:o,largestContentfulPaintEvt:s.lcp,loadEvt:c,domContentLoadedEvt:u,lcpInvalidated:s.invalidated}}}});var lM={};E(lM,{default:()=>Io});var mb,Io,uu=g(()=>{"use strict";d();kt();ko();mb=class e extends Ee{static{i(this,"Trace")}_trace={traceEvents:[]};static getDefaultTraceCategories(){return["-*","disabled-by-default-lighthouse","loading","v8","v8.execute","blink.user_timing","blink.console","devtools.timeline","disabled-by-default-devtools.timeline","disabled-by-default-devtools.screenshot","disabled-by-default-devtools.timeline.stack","disabled-by-default-devtools.timeline.frame","latencyInfo","disabled-by-default-devtools.target-rundown","disabled-by-default-devtools.v8-source-rundown-sources","disabled-by-default-devtools.v8-source-rundown"]}static async endTraceAndCollectEvents(t){let n=[],r=i(function(a){n.push(...a.value)},"dataListener");return t.on("Tracing.dataCollected",r),new Promise((a,o)=>{t.once("Tracing.tracingComplete",s=>{t.off("Tracing.dataCollected",r),a({traceEvents:n})}),t.sendCommand("Tracing.end").catch(
o)})}static symbol=Symbol("Trace");meta={symbol:e.symbol,supportedModes:["timespan","navigation"]};async startSensitiveInstrumentation({driver:t,gatherMode:n,settings:r}){let a=e.getDefaultTraceCategories().concat(r.additionalTraceCategories||[]);await t.defaultSession.sendCommand("Page.enable"),await t.defaultSession.sendCommand("Tracing.start",{categories:a.join(","),options:"sampling-frequency=10000"}),n==="timespan"&&await t.defaultSession.sendCommand("Tracing.recordClockSyncMarker",{syncId:Kn.TIMESPAN_MARKER_ID})}async stopSensitiveInstrumentation({driver:t}){this._trace=await e.endTraceAndCollectEvents(t.defaultSession)}getDebugData(){return this._trace}getArtifact(){return this._trace}},Io=mb});var dM={};E(dM,{default:()=>ta});var ta,Ao=g(()=>{d();ta={}});function mM(e,t){for(var n=0,r=e.length-1;r>=0;r--){var a=e[r];a==="."?e.splice(r,1):a===".."?(e.splice(r,1),n++):n&&(e.splice(r,1),n--)}if(t)for(;n--;n)e.unshift("..");return e}function pb(){for(var e="",t=!1,n=arguments.length-1;n>=-1&&!t;n--){var r=n>=0?arguments[n]:"/";if(typeof r!="string")throw new TypeError("Arguments to path.resolve must be strings");if(!r)continue;e=r+"/"+e,t=r.charAt(0)==="/"}return e=mM(hb(e.split("/"),function(a){return!!a}),!t).join("/"),(t?"/":"")+e||"."}function pM(e){var t=fM(e),n=uJ(e,-1)==="/";return e=mM(hb(e.split("/"),function(r){return!!r}),!t).join("/"),!e&&!t&&(e="."),e&&n&&(e+="/"),(t?"/":"")+e}function fM(e){return e.charAt(0)==="/"}function nJ(){var e=Array.prototype.slice.call(arguments,0);return pM(hb(e,function(t,n){if(typeof t!="string")throw new TypeError("Arguments to path.join must be strings");return t}).join("/"))}function rJ(e,t){e=pb(e).substr(1),t=pb(t).substr(1);function n(l){for(var m=0;m<l.length&&l[m]==="";m++);for(var p=l.length-
1;p>=0&&l[p]==="";p--);return m>p?[]:l.slice(m,p-m+1)}i(n,"trim");for(var r=n(e.split("/")),a=n(t.split("/")),o=Math.min(r.length,a.length),s=o,c=0;c<o;c++)if(r[c]!==a[c]){s=c;break}for(var u=[],c=s;c<r.length;c++)u.push("..");return u=u.concat(a.slice(s)),u.join("/")}function iJ(e){var t=fb(e),n=t[0],r=t[1];return!n&&!r?".":(r&&(r=r.substr(0,r.length-1)),n+r)}function sJ(e,t){var n=fb(e)[2];return t&&n.substr(-1*t.length)===t&&(n=n.substr(0,n.length-t.length)),n}function cJ(e){return fb(e)[3]}function hb(e,t){if(e.filter)return e.filter(t);for(var n=[],r=0;r<e.length;r++)t(e[r],r,e)&&n.push(e[r]);return n}var tJ,fb,aJ,oJ,un,uJ,Fi=g(()=>{d();i(mM,"normalizeArray");tJ=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/,fb=i(function(e){return tJ.exec(e).slice(1)},"splitPath");i(pb,"resolve");i(pM,"normalize");i(fM,"isAbsolute");i(nJ,"join");i(rJ,"relative");aJ="/",oJ=":";i(iJ,"dirname");i(sJ,"basename");i(cJ,"extname");un={extname:cJ,basename:sJ,dirname:iJ,sep:aJ,delimiter:oJ,
relative:rJ,join:nJ,isAbsolute:fM,normalize:pM,resolve:pb};i(hb,"filter");uJ="ab".substr(-1)==="b"?function(e,t,n){return e.substr(t,n)}:function(e,t,n){return t<0&&(t=e.length+t),e.substr(t,n)}});var lJ,Oh,gb=g(()=>{d();lJ=typeof globalThis=="object"&&globalThis&&globalThis.Object===Object&&globalThis,Oh=lJ});var dJ,mJ,Bn,Ga=g(()=>{d();gb();dJ=typeof self=="object"&&self&&self.Object===Object&&self,mJ=Oh||dJ||Function("return this")(),Bn=mJ});var pJ,Fo,Nh=g(()=>{d();Ga();pJ=Bn.Symbol,Fo=pJ});function gJ(e){var t=fJ.call(e,fd),n=e[fd];try{e[fd]=void 0;var r=!0}catch{}var a=hJ.call(e);return r&&(t?e[fd]=n:delete e[fd]),a}var hM,fJ,hJ,fd,gM,yM=g(()=>{d();Nh();hM=Object.prototype,fJ=hM.hasOwnProperty,hJ=hM.toString,fd=Fo?Fo.toStringTag:void 0;i(gJ,"getRawTag");gM=gJ});function bJ(e){return vJ.call(e)}var yJ,vJ,vM,bM=g(()=>{d();yJ=Object.prototype,vJ=yJ.toString;i(bJ,"objectToString");vM=bJ});function DJ(e){return e==null?e===void 0?xJ:wJ:wM&&wM in Object(e)?gM(e):vM(e)}var wJ,xJ,wM,Ro,hd=g(()=>{d();Nh();yM();bM();wJ="[object Null]",xJ="[object Undefined]",wM=Fo?Fo.toStringTag:void 0;i(DJ,"baseGetTag");Ro=DJ});function EJ(e){return e!=null&&typeof e=="object"}var _o,gd=g(()=>{d();i(EJ,"isObjectLike");_o=EJ});var TJ,Ws,Ph=g(()=>{d();TJ=Array.isArray,Ws=TJ});function SJ(e){var t=typeof e;return e!=null&&(t=="object"||t=="function")}var Lh,yb=g(()=>{d();i(SJ,"isObject");Lh=SJ});function FJ(e){if(!Lh(e))return!1;var t=Ro(e);return t==kJ||t==IJ||t==CJ||t==AJ}var CJ,kJ,IJ,AJ,Bh,vb=g(()=>{d();hd();yb();CJ="[object AsyncFunction]",kJ="[object Function]",IJ="[object GeneratorFunction]",AJ="[object Proxy]";i(FJ,"isFunction");Bh=FJ});var RJ,Uh,xM=g(()=>{d();Ga();RJ=Bn["__core-js_shared__"],Uh=RJ});function _J(e){return!!DM&&DM in e}var DM,EM,TM=g(()=>{d();xM();DM=function(){var e=/[^.]+$/.exec(Uh&&Uh.keys&&Uh.keys.IE_PROTO||"");return e?"Symbol(src)_1."+e:""}();i(_J,"isMasked");EM=_J});function NJ(e){if(e!=null){try{return OJ.call(e)}catch{}try{return e+""}catch{}}return""}var MJ,OJ,Mo,bb=g(()=>{d();MJ=Function.prototype,OJ=MJ.toString;i(NJ,"toSource");Mo=NJ});function HJ(e){if(!Lh(e)||EM(e))return!1;var t=Bh(e)?zJ:LJ;return t.test(Mo(e))}var PJ,LJ,BJ,UJ,jJ,qJ,zJ,SM,CM=g(()=>{d();vb();TM();yb();bb();PJ=/[\\^$.*+?()[\]{}|]/g,LJ=/^\[object .+?Constructor\]$/,BJ=Function.prototype,UJ=Object.prototype,jJ=BJ.toString,qJ=UJ.hasOwnProperty,zJ=RegExp("^"+jJ.call(qJ).replace(PJ,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");i(HJ,"baseIsNative");SM=HJ});function WJ(e,t){return e?.[t]}var kM,IM=g(()=>{d();i(WJ,"getValue");kM=WJ});function GJ(e,t){var n=kM(e,t);return SM(n)?n:void 0}var na,Gs=g(()=>{d();CM();IM();i(GJ,"getNative");na=GJ});var VJ,jh,AM=g(()=>{d();Gs();Ga();VJ=na(Bn,"WeakMap"),jh=VJ});function KJ(e,t){var n=typeof e;return t=t??$J,!!t&&(n=="number"||n!="symbol"&&YJ.test(e))&&e>-1&&e%1==0&&e<t}var $J,YJ,FM,RM=g(()=>{d();$J=9007199254740991,YJ=/^(?:0|[1-9]\d*)$/;i(KJ,"isIndex");FM=KJ});function JJ(e,t){return e===t||e!==e&&t!==t}var qh,wb=g(()=>{d();i(JJ,"eq");qh=JJ});function ZJ(e){return typeof e=="number"&&e>-1&&e%1==0&&e<=XJ}var XJ,zh,xb=g(()=>{d();XJ=9007199254740991;i(ZJ,"isLength");zh=ZJ});function QJ(e){return e!=null&&zh(e.length)&&!Bh(e)}var _M,MM=g(()=>{d();vb();xb();i(QJ,"isArrayLike");_M=QJ});function tX(e){var t=e&&e.constructor,n=typeof t=="function"&&t.prototype||eX;return e===n}var eX,OM,NM=g(()=>{d();eX=Object.prototype;i(tX,"isPrototype");OM=tX});function nX(e,t){for(var n=-1,r=Array(e);++n<e;)r[n]=t(n);return r}var PM,LM=g(()=>{d();i(nX,"baseTimes");PM=nX});function aX(e){return _o(e)&&Ro(e)==rX}var rX,Db,BM=g(()=>{d();hd();gd();rX="[object Arguments]";i(aX,"baseIsArguments");Db=aX});var UM,oX,iX,sX,jM,qM=g(()=>{d();BM();gd();UM=Object.prototype,oX=UM.hasOwnProperty,iX=UM.propertyIsEnumerable,sX=Db(function(){return arguments}())?Db:function(e){return _o(e)&&oX.call(e,"callee")&&!iX.call(e,"callee")},jM=sX});function cX(){return!1}var zM,HM=g(()=>{d();i(cX,"stubFalse");zM=cX});var VM,WM,uX,GM,lX,dX,yd,Eb=g(()=>{d();Ga();HM();VM=typeof exports=="object"&&exports&&!exports.nodeType&&exports,WM=VM&&typeof module=="object"&&module&&!module.nodeType&&module,uX=WM&&WM.exports===VM,GM=uX?Bn.Buffer:void 0,lX=GM?GM.isBuffer:void 0,dX=lX||zM,yd=dX});function PX(e){return _o(e)&&zh(e.length)&&!!an[Ro(e)]}var mX,pX,fX,hX,gX,yX,vX,bX,wX,xX,DX,EX,TX,SX,CX,kX,IX,AX,FX,RX,_X,MX,OX,NX,an,$M,YM=g(()=>{d();hd();xb();gd();mX="[object Arguments]",pX="[object Array]",fX="[object Boolean]",hX="[object Date]",gX="[object Error]",yX="[object Function]",vX="[object Map]",bX="[object Number]",wX="[object Object]",xX="[object RegExp]",DX="[object Set]",EX="[object String]",TX="[object WeakMap]",SX="[object ArrayBuffer]",CX="[object DataView]",kX="[object Float32Array]",IX="[object Float64Array]",AX="[object Int8Array]",FX="[object Int16Array]",RX="[object Int32Array]",_X="[object Uint8Array]",MX="[object Uint8ClampedArray]",OX="[object Uint16Array]",NX="[object Uint32Array]",an={};an[kX]=an[IX]=an[AX]=an[FX]=an[RX]=an[_X]=an[MX]=an[OX]=an[NX]=!0;an[mX]=an[pX]=an[SX]=an[fX]=an[CX]=an[hX]=an[gX]=an[yX]=an[vX]=an[bX]=an[wX]=an[xX]=an[DX]=an[EX]=an[TX]=!1;i(PX,"baseIsTypedArray");$M=PX});function LX(e){return function(t){return e(t)}}var KM,JM=g(()=>{d();i(LX,"baseUnary");KM=LX});var XM,vd,BX,Tb,UX,Sb,ZM=g(()=>{d();gb();XM=typeof exports=="object"&&exports&&!exports.nodeType&&exports,vd=XM&&typeof module=="object"&&module&&!module.nodeType&&module,BX=vd&&vd.exports===XM,Tb=BX&&Oh.process,UX=function(){try{var e=vd&&vd.require&&vd.require("util").types;return e||Tb&&Tb.binding&&Tb.binding("util")}catch{}}(),Sb=UX});var QM,jX,Hh,Cb=g(()=>{d();YM();JM();ZM();QM=Sb&&Sb.isTypedArray,jX=QM?KM(QM):$M,Hh=jX});function HX(e,t){var n=Ws(e),r=!n&&jM(e),a=!n&&!r&&yd(e),o=!n&&!r&&!a&&Hh(e),s=n||r||a||o,c=s?PM(e.length,String):[],u=c.length;for(var l in e)(t||zX.call(e,l))&&!(s&&(l=="length"||a&&(l=="offset"||l=="parent")||o&&(l=="buffer"||l=="byteLength"||l=="byteOffset")||FM(l,u)))&&c.push(l);return c}var qX,zX,e3,t3=g(()=>{d();LM();qM();Ph();Eb();RM();Cb();qX=Object.prototype,zX=qX.hasOwnProperty;i(HX,"arrayLikeKeys");e3=HX});function WX(e,t){return function(n){return e(t(n))}}var n3,r3=g(()=>{d();i(WX,"overArg");n3=WX});var GX,a3,o3=g(()=>{d();r3();GX=n3(Object.keys,Object),a3=GX});function YX(e){if(!OM(e))return a3(e);var t=[];for(var n in Object(e))$X.call(e,n)&&n!="constructor"&&t.push(n);return t}var VX,$X,i3,s3=g(()=>{d();NM();o3();VX=Object.prototype,$X=VX.hasOwnProperty;i(YX,"baseKeys");i3=YX});function KX(e){return _M(e)?e3(e):i3(e)}var c3,u3=g(()=>{d();t3();s3();MM();i(KX,"keys");c3=KX});var JX,Oo,bd=g(()=>{d();Gs();JX=na(Object,"create"),Oo=JX});function XX(){this.__data__=Oo?Oo(null):{},this.size=0}var l3,d3=g(()=>{d();bd();i(XX,"hashClear");l3=XX});function ZX(e){var t=this.has(e)&&delete this.__data__[e];return this.size-=t?1:0,t}var m3,p3=g(()=>{d();i(ZX,"hashDelete");m3=ZX});function nZ(e){var t=this.__data__;if(Oo){var n=t[e];return n===QX?void 0:n}return tZ.call(t,e)?t[e]:void 0}var QX,eZ,tZ,f3,h3=g(()=>{d();bd();QX="__lodash_hash_undefined__",eZ=Object.prototype,tZ=eZ.hasOwnProperty;i(nZ,"hashGet");f3=nZ});function oZ(e){var t=this.__data__;return Oo?t[e]!==void 0:aZ.call(t,e)}var rZ,aZ,g3,y3=g(()=>{d();bd();rZ=Object.prototype,aZ=rZ.hasOwnProperty;i(oZ,"hashHas");g3=oZ});function sZ(e,t){var n=this.__data__;return this.size+=this.has(e)?0:1,n[e]=Oo&&t===void 0?iZ:t,this}var iZ,v3,b3=g(()=>{d();bd();iZ="__lodash_hash_undefined__";i(sZ,"hashSet");v3=sZ});function lu(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}var kb,w3=g(()=>{d();d3();p3();h3();y3();b3();i(lu,"Hash");lu.prototype.clear=l3;lu.prototype.delete=m3;lu.prototype.get=f3;lu.prototype.has=g3;lu.prototype.set=v3;kb=lu});function cZ(){this.__data__=[],this.size=0}var x3,D3=g(()=>{d();i(cZ,"listCacheClear");x3=cZ});function uZ(e,t){for(var n=e.length;n--;)if(qh(e[n][0],t))return n;return-1}var Ri,wd=g(()=>{d();wb();i(uZ,"assocIndexOf");Ri=uZ});function mZ(e){var t=this.__data__,n=Ri(t,e);if(n<0)return!1;var r=t.length-1;return n==r?t.pop():dZ.call(t,n,1),--this.size,!0}var lZ,dZ,E3,T3=g(()=>{d();wd();lZ=Array.prototype,dZ=lZ.splice;i(mZ,"listCacheDelete");E3=mZ});function pZ(e){var t=this.__data__,n=Ri(t,e);return n<0?void 0:t[n][1]}var S3,C3=g(()=>{d();wd();i(pZ,"listCacheGet");S3=pZ});function fZ(e){return Ri(this.__data__,e)>-1}var k3,I3=g(()=>{d();wd();i(fZ,"listCacheHas");k3=fZ});function hZ(e,t){var n=this.__data__,r=Ri(n,e);return r<0?(++this.size,n.push([e,t])):n[r][1]=t,this}var A3,F3=g(()=>{d();wd();i(hZ,"listCacheSet");A3=hZ});function du(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}var _i,xd=g(()=>{d();D3();T3();C3();I3();F3();i(du,"ListCache");du.prototype.clear=x3;du.prototype.delete=E3;du.prototype.get=S3;du.prototype.has=k3;du.prototype.set=A3;_i=du});var gZ,Mi,Wh=g(()=>{d();Gs();Ga();gZ=na(Bn,"Map"),Mi=gZ});function yZ(){this.size=0,this.__data__={hash:new kb,map:new(Mi||_i),string:new kb}}var R3,_3=g(()=>{d();w3();xd();Wh();i(yZ,"mapCacheClear");R3=yZ});function vZ(e){var t=typeof e;return t=="string"||t=="number"||t=="symbol"||t=="boolean"?e!=="__proto__":e===null}var M3,O3=g(()=>{d();i(vZ,"isKeyable");M3=vZ});function bZ(e,t){var n=e.__data__;return M3(t)?n[typeof t=="string"?"string":"hash"]:n.map}var Oi,Dd=g(()=>{d();O3();i(bZ,"getMapData");Oi=bZ});function wZ(e){var t=Oi(this,e).delete(e);return this.size-=t?1:0,t}var N3,P3=g(()=>{d();Dd();i(wZ,"mapCacheDelete");N3=wZ});function xZ(e){return Oi(this,e).get(e)}var L3,B3=g(()=>{d();Dd();i(xZ,"mapCacheGet");L3=xZ});function DZ(e){return Oi(this,e).has(e)}var U3,j3=g(()=>{d();Dd();i(DZ,"mapCacheHas");U3=DZ});function EZ(e,t){var n=Oi(this,e),r=n.size;return n.set(e,t),this.size+=n.size==r?0:1,this}var q3,z3=g(()=>{d();Dd();i(EZ,"mapCacheSet");q3=EZ});function mu(e){var t=-1,n=e==null?0:e.length;for(this.clear();++t<n;){var r=e[t];this.set(r[0],r[1])}}var Gh,Ib=g(()=>{d();_3();P3();B3();j3();z3();i(mu,"MapCache");mu.prototype.clear=R3;mu.prototype.delete=N3;mu.prototype.get=L3;mu.prototype.has=U3;mu.prototype.set=q3;Gh=mu});function TZ(e,t){for(var n=-1,r=t.length,a=e.length;++n<r;)e[a+n]=t[n];return e}var H3,W3=g(()=>{d();i(TZ,"arrayPush");H3=TZ});function SZ(){this.__data__=new _i,this.size=0}var G3,V3=g(()=>{d();xd();i(SZ,"stackClear");G3=SZ});function CZ(e){var t=this.__data__,n=t.delete(e);return this.size=t.size,n}var $3,Y3=g(()=>{d();i(CZ,"stackDelete");$3=CZ});function kZ(e){return this.__data__.get(e)}var K3,J3=g(()=>{d();i(kZ,"stackGet");K3=kZ});function IZ(e){return this.__data__.has(e)}var X3,Z3=g(()=>{d();i(IZ,"stackHas");X3=IZ});function FZ(e,t){var n=this.__data__;if(n instanceof _i){var r=n.__data__;if(!Mi||r.length<AZ-1)return r.push([e,t]),this.size=++n.size,this;n=this.__data__=new Gh(r)}return n.set(e,t),this.size=n.size,this}var AZ,Q3,eO=g(()=>{d();xd();Wh();Ib();AZ=200;i(FZ,"stackSet");Q3=FZ});function pu(e){var t=this.__data__=new _i(e);this.size=t.size}var Vh,tO=g(()=>{d();xd();V3();Y3();J3();Z3();eO();i(pu,"Stack");pu.prototype.clear=G3;pu.prototype.delete=$3;pu.prototype.get=K3;pu.prototype.has=X3;pu.prototype.set=Q3;Vh=pu});function RZ(e,t){for(var n=-1,r=e==null?0:e.length,a=0,o=[];++n<r;){var s=e[n];t(s,n,e)&&(o[a++]=s)}return o}var nO,rO=g(()=>{d();i(RZ,"arrayFilter");nO=RZ});function _Z(){return[]}var aO,oO=g(()=>{d();i(_Z,"stubArray");aO=_Z});var MZ,OZ,iO,NZ,sO,cO=g(()=>{d();rO();oO();MZ=Object.prototype,OZ=MZ.propertyIsEnumerable,iO=Object.getOwnPropertySymbols,NZ=iO?function(e){return e==null?[]:(e=Object(e),nO(iO(e),function(t){return OZ.call(e,t)}))}:aO,sO=NZ});function PZ(e,t,n){var r=t(e);return Ws(e)?r:H3(r,n(e))}var uO,lO=g(()=>{d();W3();Ph();i(PZ,"baseGetAllKeys");uO=PZ});function LZ(e){return uO(e,c3,sO)}var Ab,dO=g(()=>{d();lO();cO();u3();i(LZ,"getAllKeys");Ab=LZ});var BZ,$h,mO=g(()=>{d();Gs();Ga();BZ=na(Bn,"DataView"),$h=BZ});var UZ,Yh,pO=g(()=>{d();Gs();Ga();UZ=na(Bn,"Promise"),Yh=UZ});var jZ,Kh,fO=g(()=>{d();Gs();Ga();jZ=na(Bn,"Set"),Kh=jZ});var hO,qZ,gO,yO,vO,bO,zZ,HZ,WZ,GZ,VZ,Vs,Fb,wO=g(()=>{d();mO();Wh();pO();fO();AM();hd();bb();hO="[object Map]",qZ="[object Object]",gO="[object Promise]",yO="[object Set]",vO="[object WeakMap]",bO="[object DataView]",zZ=Mo($h),HZ=Mo(Mi),WZ=Mo(Yh),GZ=Mo(Kh),VZ=Mo(jh),Vs=Ro;($h&&Vs(new $h(new ArrayBuffer(1)))!=bO||Mi&&Vs(new Mi)!=hO||Yh&&Vs(Yh.resolve())!=gO||Kh&&Vs(new Kh)!=yO||jh&&Vs(new jh)!=vO)&&(Vs=i(function(e){var t=Ro(e),n=t==qZ?e.constructor:void 0,r=n?Mo(n):"";if(r)switch(r){case zZ:return bO;case HZ:return hO;case WZ:return gO;case GZ:return yO;case VZ:return vO}return t},"getTag"));Fb=Vs});var $Z,Rb,xO=g(()=>{d();Ga();$Z=Bn.Uint8Array,Rb=$Z});function KZ(e){return this.__data__.set(e,YZ),this}var YZ,DO,EO=g(()=>{d();YZ="__lodash_hash_undefined__";i(KZ,"setCacheAdd");DO=KZ});function JZ(e){return this.__data__.has(e)}var TO,SO=g(()=>{d();i(JZ,"setCacheHas");TO=JZ});function Jh(e){var t=-1,n=e==null?0:e.length;for(this.__data__=new Gh;++t<n;)this.add(e[t])}var CO,kO=g(()=>{d();Ib();EO();SO();i(Jh,"SetCache");Jh.prototype.add=Jh.prototype.push=DO;Jh.prototype.has=TO;CO=Jh});function XZ(e,t){for(var n=-1,r=e==null?0:e.length;++n<r;)if(t(e[n],n,e))return!0;return!1}var IO,AO=g(()=>{d();i(XZ,"arraySome");IO=XZ});function ZZ(e,t){return e.has(t)}var FO,RO=g(()=>{d();i(ZZ,"cacheHas");FO=ZZ});function tQ(e,t,n,r,a,o){var s=n&QZ,c=e.length,u=t.length;if(c!=u&&!(s&&u>c))return!1;var l=o.get(e),m=o.get(t);if(l&&m)return l==t&&m==e;var p=-1,f=!0,h=n&eQ?new CO:void 0;for(o.set(e,t),o.set(t,e);++p<c;){var y=e[p],b=t[p];if(r)var w=s?r(b,y,p,t,e,o):r(y,b,p,e,t,o);if(w!==void 0){if(w)continue;f=!1;break}if(h){if(!IO(t,function(D,T){if(!FO(h,T)&&(y===D||a(y,D,n,r,o)))return h.push(T)})){f=!1;break}}else if(!(y===b||a(y,b,n,r,o))){f=!1;break}}return o.delete(e),o.delete(t),f}var QZ,eQ,Xh,_b=g(()=>{d();kO();AO();RO();QZ=1,eQ=2;i(tQ,"equalArrays");Xh=tQ});function nQ(e){var t=-1,n=Array(e.size);return e.forEach(function(r,a){n[++t]=[a,r]}),n}var _O,MO=g(()=>{d();i(nQ,"mapToArray");_O=nQ});function rQ(e){var t=-1,n=Array(e.size);return e.forEach(function(r){n[++t]=r}),n}var OO,NO=g(()=>{d();i(rQ,"setToArray");OO=rQ});function yQ(e,t,n,r,a,o,s){switch(n){case gQ:if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case hQ:return!(e.byteLength!=t.byteLength||!o(new Rb(e),new Rb(t)));case iQ:case sQ:case lQ:return qh(+e,+t);case cQ:return e.name==t.name&&e.message==t.message;case dQ:case pQ:return e==t+"";case uQ:var c=_O;case mQ:var u=r&aQ;if(c||(c=OO),e.size!=t.size&&!u)return!1;var l=s.get(e);if(l)return l==t;r|=oQ,s.set(e,t);var m=Xh(c(e),c(t),r,a,o,s);return s.delete(e),m;case fQ:if(Mb)return Mb.call(e)==Mb.call(t)}return!1}var aQ,oQ,iQ,sQ,cQ,uQ,lQ,dQ,mQ,pQ,fQ,hQ,gQ,PO,Mb,LO,BO=g(()=>{d();Nh();xO();wb();_b();MO();NO();aQ=1,oQ=2,iQ="[object Boolean]",sQ="[object Date]",cQ="[object Error]",uQ="[object Map]",lQ="[object Number]",dQ="[object RegExp]",mQ="[object Set]",pQ="[object String]",fQ="[object Symbol]",hQ="[object ArrayBuffer]",gQ="[object DataView]",PO=Fo?Fo.prototype:void 0,Mb=PO?PO.valueOf:void 0;i(yQ,"equalByTag");LO=yQ});function xQ(e,t,n,r,a,o){var s=n&vQ,c=Ab(e),u=c.length,l=Ab(t),m=l.length;if(u!=m&&!s)return!1;for(var p=u;p--;){var f=c[p];if(!(s?f in t:wQ.call(t,f)))return!1}var h=o.get(e),y=o.get(t);if(h&&y)return h==t&&y==e;var b=!0;o.set(e,t),o.set(t,e);for(var w=s;++p<u;){f=c[p];var D=e[f],T=t[f];if(r)var S=s?r(T,D,f,t,e,o):r(D,T,f,e,t,o);if(!(S===void 0?D===T||a(D,T,n,r,o):S)){b=!1;break}w||(w=f=="constructor")}if(b&&!w){var k=e.constructor,_=t.constructor;k!=_&&"constructor"in e&&"constructor"in t&&!(typeof k=="function"&&k instanceof k&&typeof _=="function"&&_ instanceof _)&&(b=!1)}return o.delete(e),o.delete(t),b}var vQ,bQ,wQ,UO,jO=g(()=>{d();dO();vQ=1,bQ=Object.prototype,wQ=bQ.hasOwnProperty;i(xQ,"equalObjects");UO=xQ});function TQ(e,t,n,r,a,o){var s=Ws(e),c=Ws(t),u=s?zO:Fb(e),l=c?zO:Fb(t);u=u==qO?Zh:u,l=l==qO?Zh:l;var m=u==Zh,p=l==Zh,f=u==l;if(f&&yd(e)){if(!yd(t))return!1;s=!0,m=!1}if(f&&!m)return o||(o=new Vh),s||Hh(e)?Xh(e,t,n,r,a,o):LO(e,t,u,n,r,a,o);if(!(n&DQ)){var h=m&&HO.call(e,"__wrapped__"),y=p&&HO.call(t,"__wrapped__");if(h||y){var b=h?e.value():e,w=y?t.value():t;return o||(o=new Vh),a(b,w,n,r,o)}}return f?(o||(o=new Vh),UO(e,t,n,r,a,o)):!1}var DQ,qO,zO,Zh,EQ,HO,WO,GO=g(()=>{d();tO();_b();BO();jO();wO();Ph();Eb();Cb();DQ=1,qO="[object Arguments]",zO="[object Array]",Zh="[object Object]",EQ=Object.prototype,HO=EQ.hasOwnProperty;i(TQ,"baseIsEqualDeep");WO=TQ});function VO(e,t,n,r,a){return e===t?!0:e==null||t==null||!_o(e)&&!_o(t)?e!==e&&t!==t:WO(e,t,n,r,VO,a)}var $O,YO=g(()=>{d();GO();gd();i(VO,"baseIsEqual");$O=VO});function SQ(e,t){return $O(e,t)}var Va,KO=g(()=>{d();YO();i(SQ,"isEqual");Va=SQ});var Ed=g(()=>{d();KO();});var Qh,Ob=g(()=>{"use strict";d();Ci();Qh=!!nr.env.CI||nr.env.NODE_ENV==="test"});function AQ(e){let t=Math.sign(e);e=Math.abs(e);let n=.254829592,r=-.284496736,a=1.421413741,o=-1.453152027,s=1.061405429,u=1/(1+.3275911*e),l=u*(n+u*(r+u*(a+u*(o+u*s))));return t*(1-l*Math.exp(-e*e))}function JO({median:e,p10:t},n){if(e<=0)throw new Error("median must be greater than zero");if(t<=0)throw new Error("p10 must be greater than zero");if(t>=e)throw new Error("p10 must be less than the median");if(n<=0)return 1;let r=.9061938024368232,a=Math.max(Number.MIN_VALUE,n/e),o=Math.log(a),s=Math.max(Number.MIN_VALUE,t/e),c=-Math.log(s),u=o*r/c,l=(1-AQ(u))/2,m;return n<=t?m=Math.max(.9,Math.min(1,l)):n<=e?m=Math.max(kQ,Math.min(CQ,l)):m=Math.max(0,Math.min(IQ,l)),m}function XO(e,t,n,r,a){let o=(r-t)/(n-e);return t+(a-e)*o}var CQ,kQ,IQ,Nb=g(()=>{"use strict";d();CQ=.8999999999999999,kQ=.5,IQ=.49999999999999994;i(AQ,"erf");i(JO,"getLogNormalScore");i(XO,"linearInterpolation")});var No,RQ,ZO,_Q,MQ,zt,Po=g(()=>{"use strict";d();Nb();No="…",RQ=" ",ZO=.9,_Q={PASS:{label:"pass",minScore:ZO},AVERAGE:{label:"average",minScore:.5},FAIL:{label:"fail"},ERROR:{label:"error"}},MQ=["com","co","gov","edu","ac","org","go","gob","or","net","in","ne","nic","gouv","web","spb","blog","jus","kiev","mil","wi","qc","ca","bel","on"],zt=class e{static{i(this,"Util")}static get RATINGS(){return _Q}static get PASS_THRESHOLD(){return ZO}static get MS_DISPLAY_VALUE(){return`%10d${RQ}ms`}static getFinalDisplayedUrl(t){if(t.finalDisplayedUrl)return t.finalDisplayedUrl;if(t.finalUrl)return t.finalUrl;throw new Error("Could not determine final displayed URL")}static getMainDocumentUrl(t){return t.mainDocumentUrl||t.finalUrl}static getFullPageScreenshot(t){return t.fullPageScreenshot?t.fullPageScreenshot:t.audits["full-page-screenshot"]?.details}static getEntityFromUrl(t,n){return n&&n.find(a=>a.origins.find(o=>t.startsWith(o)))||e.getPseudoRootDomain(t)}static splitMarkdownCodeSpans(t){let n=[],
r=t.split(/`(.*?)`/g);for(let a=0;a<r.length;a++){let o=r[a];if(!o)continue;let s=a%2!==0;n.push({isCode:s,text:o})}return n}static splitMarkdownLink(t){let n=[],r=t.split(/\[([^\]]+?)\]\((https?:\/\/.*?)\)/g);for(;r.length;){let[a,o,s]=r.splice(0,3);a&&n.push({isLink:!1,text:a}),o&&s&&n.push({isLink:!0,text:o,linkHref:s})}return n}static truncate(t,n,r="…"){if(t.length<=n)return t;let o=new Intl.Segmenter(void 0,{granularity:"grapheme"}).segment(t)[Symbol.iterator](),s=0;for(let c=0;c<=n-r.length;c++){let u=o.next();if(u.done)return t;s=u.value.index}for(let c=0;c<r.length;c++)if(o.next().done)return t;return t.slice(0,s)+r}static getURLDisplayName(t,n){n=n||{numPathParts:void 0,preserveQuery:void 0,preserveHost:void 0};let r=n.numPathParts!==void 0?n.numPathParts:2,a=n.preserveQuery!==void 0?n.preserveQuery:!0,o=n.preserveHost||!1,s;if(t.protocol==="about:"||t.protocol==="data:")s=t.href;else{s=t.pathname;let u=s.split("/").filter(l=>l.length);r&&u.length>r&&(s=No+u.slice(-1*r).join(
"/")),o&&(s=`${t.host}/${s.replace(/^\//,"")}`),a&&(s=`${s}${t.search}`)}let c=64;if(t.protocol!=="data:"&&(s=s.slice(0,200),s=s.replace(/([a-f0-9]{7})[a-f0-9]{13}[a-f0-9]*/g,`$1${No}`),s=s.replace(/([a-zA-Z0-9-_]{9})(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])[a-zA-Z0-9-_]{10,}/g,`$1${No}`),s=s.replace(/(\d{3})\d{6,}/g,`$1${No}`),s=s.replace(/\u2026+/g,No),s.length>c&&s.includes("?")&&(s=s.replace(/\?([^=]*)(=)?.*/,`?$1$2${No}`),s.length>c&&(s=s.replace(/\?.*/,`?${No}`)))),s.length>c){let u=s.lastIndexOf(".");u>=0?s=s.slice(0,c-1-(s.length-u))+`${No}${s.slice(u)}`:s=s.slice(0,c-1)+No}return s}static getChromeExtensionOrigin(t){let n=new URL(t);return n.protocol+"//"+n.host}static parseURL(t){let n=new URL(t);return{file:e.getURLDisplayName(n),hostname:n.hostname,origin:n.protocol==="chrome-extension:"?e.getChromeExtensionOrigin(t):n.origin}}static createOrReturnURL(t){return t instanceof URL?t:new URL(t)}static getPseudoTld(t){let n=t.split(".").slice(-2);return MQ.includes(n[0])?`.${n.join(".")}`:
`.${n[n.length-1]}`}static getPseudoRootDomain(t){let n=e.createOrReturnURL(t).hostname,a=e.getPseudoTld(n).split(".");return n.split(".").slice(-a.length).join(".")}static filterRelevantLines(t,n,r){if(n.length===0)return t.slice(0,r*2+1);let a=3,o=new Set;return n=n.sort((s,c)=>(s.lineNumber||0)-(c.lineNumber||0)),n.forEach(({lineNumber:s})=>{let c=s-r,u=s+r;for(;c<1;)c++,u++;o.has(c-a-1)&&(c-=a);for(let l=c;l<=u;l++){let m=l;o.add(m)}}),t.filter(s=>o.has(s.lineNumber))}static computeLogNormalScore(t,n){let r=JO(t,n);return r>.9&&(r+=.05*(r-.9)),Math.floor(r*100)/100}}});var OQ,NQ,PQ,v,ie=g(()=>{"use strict";d();rr();Ob();Po();OQ="defaultPass",NQ={FCP:50,LCP:50,INP:50,TBT:50,CLS:.001},PQ=i(e=>Math.round(e*100)/100,"clampTo2Decimals"),v=class e{static{i(this,"Audit")}static get DEFAULT_PASS(){return OQ}static get SCORING_MODES(){return{NUMERIC:"numeric",METRIC_SAVINGS:"metricSavings",BINARY:"binary",MANUAL:"manual",INFORMATIVE:"informative",NOT_APPLICABLE:"notApplicable",ERROR:"error"}}static get meta(){throw new Error("Audit meta information must be overridden.")}static get defaultOptions(){return{}}static audit(t,n){throw new Error("audit() method must be overridden")}static computeLogNormalScore(t,n){return zt.computeLogNormalScore(t,n)}static assertHeadingKeysExist(t,n){if(n.length&&Qh)for(let r of t){if(r.key===null)continue;let a=r.key;if(!n.some(o=>a in o))throw new Error(`"${r.key}" is missing from items`)}}static makeChecklistDetails(t){return{type:"checklist",items:t}}static makeTableDetails(t,n,r={}){let{wastedBytes:a,wastedMs:o,sortedBy:s,skipSumming:c,
isEntityGrouped:u}=r,l=a||o?{wastedBytes:a,wastedMs:o}:void 0;return n.length===0?{type:"table",headings:[],items:[],summary:l}:(e.assertHeadingKeysExist(t,n),{type:"table",headings:t,items:n,summary:l,sortedBy:s,skipSumming:c,isEntityGrouped:u})}static makeListDetails(t){return{type:"list",items:t}}static makeSnippetDetails({content:t,title:n,lineMessages:r,generalMessages:a,node:o,maxLineLength:s=200,maxLinesAroundMessage:c=20}){let u=e._makeSnippetLinesArray(t,s);return{type:"snippet",lines:zt.filterRelevantLines(u,r,c),title:n,lineMessages:r,generalMessages:a,lineCount:u.length,node:o}}static _makeSnippetLinesArray(t,n){return t.split(`
`).map((r,a)=>{let o=a+1,s={content:zt.truncate(r,n),lineNumber:o};return r.length>n&&(s.truncated=!0),s})}static makeOpportunityDetails(t,n,r){e.assertHeadingKeysExist(t,n);let{overallSavingsMs:a,overallSavingsBytes:o,sortedBy:s,skipSumming:c,isEntityGrouped:u}=r;return{type:"opportunity",headings:n.length===0?[]:t,items:n,overallSavingsMs:a,overallSavingsBytes:o,sortedBy:s,skipSumming:c,isEntityGrouped:u}}static makeNodeItem(t){return{type:"node",lhId:t.lhId,path:t.devtoolsNodePath,selector:t.selector,boundingRect:t.boundingRect,snippet:t.snippet,nodeLabel:t.nodeLabel}}static _findOriginalLocation(t,n,r){let a=t?.map.findEntry(n,r);if(a)return{file:a.sourceURL||"",line:a.sourceLineNumber||0,column:a.sourceColumnNumber||0}}static makeSourceLocation(t,n,r,a){return{type:"source-location",url:t,urlProvider:"network",line:n,column:r,original:a&&this._findOriginalLocation(a,n,r)}}static makeSourceLocationFromConsoleMessage(t,n){if(!t.url)return;let r=t.lineNumber||0,a=t.columnNumber||0;return this.
makeSourceLocation(t.url,r,a,n)}static _normalizeAuditScore(t,n,r){if(n===e.SCORING_MODES.INFORMATIVE)return 1;if(n!==e.SCORING_MODES.BINARY&&n!==e.SCORING_MODES.NUMERIC&&n!==e.SCORING_MODES.METRIC_SAVINGS)return null;if(t===null||!Number.isFinite(t))throw new Error(`Invalid score for ${r}: ${t}`);if(t>1)throw new Error(`Audit score for ${r} is > 1`);if(t<0)throw new Error(`Audit score for ${r} is < 0`);return t=PQ(t),t}static _quantizeMetricSavings(t){if(!t)return;let n={...t};for(let r of Object.keys(t)){let a=t[r];if(a===void 0)continue;a=Math.max(a,0);let o=NQ[r];o!==void 0&&(a=Math.round(a/o)*o),n[r]=a}return n}static generateErrorAuditResult(t,n,r){return e.generateAuditResult(t,{score:null,errorMessage:n,errorStack:r})}static generateAuditResult(t,n){if(n.score===void 0)throw new Error("generateAuditResult requires a score");let r=t.meta.scoreDisplayMode||e.SCORING_MODES.BINARY,a=n.score;n.errorMessage!==void 0?r=e.SCORING_MODES.ERROR:n.notApplicable?r=e.SCORING_MODES.NOT_APPLICABLE:
n.scoreDisplayMode&&(r=n.scoreDisplayMode);let o=e._quantizeMetricSavings(n.metricSavings),s=Object.values(o||{}).some(l=>l);r===e.SCORING_MODES.METRIC_SAVINGS&&(a&&a>=zt.PASS_THRESHOLD?a=1:s?a=0:a=.5),a=e._normalizeAuditScore(a,r,t.meta.id);let c=t.meta.title;t.meta.failureTitle&&a!==null&&a<zt.PASS_THRESHOLD&&(c=t.meta.failureTitle);let u="numericUnit"in n?n:void 0;return{id:t.meta.id,title:c,description:t.meta.description,score:a,scoreDisplayMode:r,numericValue:u?.numericValue,numericUnit:u?.numericUnit,displayValue:n.displayValue,explanation:n.explanation,errorMessage:n.errorMessage,errorStack:n.errorStack,warnings:n.warnings,scoringOptions:n.scoringOptions,metricSavings:o,details:n.details,guidanceLevel:t.meta.guidanceLevel,replacesAudits:t.meta.replacesAudits}}static makeMetricComputationDataInput(t,n){let r=t.traces[e.DEFAULT_PASS],a=t.devtoolsLogs[e.DEFAULT_PASS],o=t.GatherContext,{URL:s,SourceMaps:c}=t;return{trace:r,devtoolsLog:a,gatherContext:o,settings:n.settings,URL:s,SourceMaps:c,
simulator:null}}}});var LQ,eg,QO=g(()=>{"use strict";d();ie();LQ=i(e=>Math.round(e*100)/100,"clampTo2Decimals"),eg=class e{static{i(this,"ReportScoring")}static arithmeticMean(t){if(t=t.filter(r=>r.weight>0),t.some(r=>r.score===null))return null;let n=t.reduce((r,a)=>{let o=a.score,s=a.weight;return{weight:r.weight+s,sum:r.sum+o*s}},{weight:0,sum:0});return LQ(n.sum/n.weight||0)}static scoreAllCategories(t,n){let r={};for(let[a,o]of Object.entries(t)){let s=o.auditRefs.map(l=>{let m={...l},p=n[m.id];return(p.scoreDisplayMode===v.SCORING_MODES.NOT_APPLICABLE||p.scoreDisplayMode===v.SCORING_MODES.INFORMATIVE||p.scoreDisplayMode===v.SCORING_MODES.MANUAL)&&(m.weight=0),m}),c=s.map(l=>({score:n[l.id].score,weight:l.weight})),u=e.arithmeticMean(c);r[a]={...o,auditRefs:s,id:a,score:u}}return r}}});function Td(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");Pb(e,t);function n(){this.constructor=e}i(n,"__"),e.prototype=t===null?Object.create(t):(n.prototype=t.prototype,new n)}function eN(e,t){var n={};for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&t.indexOf(r)<0&&(n[r]=e[r]);if(e!=null&&typeof Object.getOwnPropertySymbols=="function")for(var a=0,r=Object.getOwnPropertySymbols(e);a<r.length;a++)t.indexOf(r[a])<0&&Object.prototype.propertyIsEnumerable.call(e,r[a])&&(n[r[a]]=e[r[a]]);return n}function tg(e,t,n){if(n||arguments.length===2)for(var r=0,a=t.length,o;r<a;r++)(o||!(r in t))&&(o||(o=Array.prototype.slice.call(t,0,r)),o[r]=t[r]);return e.concat(o||Array.prototype.slice.call(t))}var Pb,Sa,Lb=g(()=>{d();Pb=i(function(e,t){return Pb=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,r){n.__proto__=r}||function(n,r){for(var a in r)Object.prototype.hasOwnProperty.call(r,a)&&(n[a]=
r[a])},Pb(e,t)},"extendStatics");i(Td,"__extends");Sa=i(function(){return Sa=Object.assign||i(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},"__assign"),Sa.apply(this,arguments)},"__assign");i(eN,"__rest");i(tg,"__spreadArray")});var fu,Bb=g(()=>{d();fu=i(function(){return fu=Object.assign||i(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},"__assign"),fu.apply(this,arguments)},"__assign")});var Tt,Ub=g(()=>{d();(function(e){e[e.EXPECT_ARGUMENT_CLOSING_BRACE=1]="EXPECT_ARGUMENT_CLOSING_BRACE",e[e.EMPTY_ARGUMENT=2]="EMPTY_ARGUMENT",e[e.MALFORMED_ARGUMENT=3]="MALFORMED_ARGUMENT",e[e.EXPECT_ARGUMENT_TYPE=4]="EXPECT_ARGUMENT_TYPE",e[e.INVALID_ARGUMENT_TYPE=5]="INVALID_ARGUMENT_TYPE",e[e.EXPECT_ARGUMENT_STYLE=6]="EXPECT_ARGUMENT_STYLE",e[e.INVALID_NUMBER_SKELETON=7]="INVALID_NUMBER_SKELETON",e[e.INVALID_DATE_TIME_SKELETON=8]="INVALID_DATE_TIME_SKELETON",e[e.EXPECT_NUMBER_SKELETON=9]="EXPECT_NUMBER_SKELETON",e[e.EXPECT_DATE_TIME_SKELETON=10]="EXPECT_DATE_TIME_SKELETON",e[e.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE=11]="UNCLOSED_QUOTE_IN_ARGUMENT_STYLE",e[e.EXPECT_SELECT_ARGUMENT_OPTIONS=12]="EXPECT_SELECT_ARGUMENT_OPTIONS",e[e.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE=13]="EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE=14]="INVALID_PLURAL_ARGUMENT_OFFSET_VALUE",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR=15]="EXPECT_SELECT_ARGUMENT_SELECTOR",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR=
16]="EXPECT_PLURAL_ARGUMENT_SELECTOR",e[e.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT=17]="EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT",e[e.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT=18]="EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT",e[e.INVALID_PLURAL_ARGUMENT_SELECTOR=19]="INVALID_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_PLURAL_ARGUMENT_SELECTOR=20]="DUPLICATE_PLURAL_ARGUMENT_SELECTOR",e[e.DUPLICATE_SELECT_ARGUMENT_SELECTOR=21]="DUPLICATE_SELECT_ARGUMENT_SELECTOR",e[e.MISSING_OTHER_CLAUSE=22]="MISSING_OTHER_CLAUSE",e[e.INVALID_TAG=23]="INVALID_TAG",e[e.INVALID_TAG_NAME=25]="INVALID_TAG_NAME",e[e.UNMATCHED_CLOSING_TAG=26]="UNMATCHED_CLOSING_TAG",e[e.UNCLOSED_TAG=27]="UNCLOSED_TAG"})(Tt||(Tt={}))});function jb(e){return e.type===on.literal}function tN(e){return e.type===on.argument}function ng(e){return e.type===on.number}function rg(e){return e.type===on.date}function ag(e){return e.type===on.time}function og(e){return e.type===on.select}function ig(e){return e.type===on.plural}function nN(e){return e.type===on.pound}function sg(e){return e.type===on.tag}function cg(e){return!!(e&&typeof e=="object"&&e.type===$s.number)}function Sd(e){return!!(e&&typeof e=="object"&&e.type===$s.dateTime)}var on,$s,ug=g(()=>{d();(function(e){e[e.literal=0]="literal",e[e.argument=1]="argument",e[e.number=2]="number",e[e.date=3]="date",e[e.time=4]="time",e[e.select=5]="select",e[e.plural=6]="plural",e[e.pound=7]="pound",e[e.tag=8]="tag"})(on||(on={}));(function(e){e[e.number=0]="number",e[e.dateTime=1]="dateTime"})($s||($s={}));i(jb,"isLiteralElement");i(tN,"isArgumentElement");i(ng,"isNumberElement");i(rg,"isDateElement");i(ag,"isTimeElement");i(og,"isSelectElement");i(ig,"isPluralElement");i(nN,"\
isPoundElement");i(sg,"isTagElement");i(cg,"isNumberSkeleton");i(Sd,"isDateTimeSkeleton")});var qb,rN=g(()=>{d();qb=/[ \xA0\u1680\u2000-\u200A\u202F\u205F\u3000]/});function aN(e){var t={};return e.replace(BQ,function(n){var r=n.length;switch(n[0]){case"G":t.era=r===4?"long":r===5?"narrow":"short";break;case"y":t.year=r===2?"2-digit":"numeric";break;case"Y":case"u":case"U":case"r":throw new RangeError("`Y/u/U/r` (year) patterns are not supported, use `y` instead");case"q":case"Q":throw new RangeError("`q/Q` (quarter) patterns are not supported");case"M":case"L":t.month=["numeric","2-digit","short","long","narrow"][r-1];break;case"w":case"W":throw new RangeError("`w/W` (week) patterns are not supported");case"d":t.day=["numeric","2-digit"][r-1];break;case"D":case"F":case"g":throw new RangeError("`D/F/g` (day) patterns are not supported, use `d` instead");case"E":t.weekday=r===4?"short":r===5?"narrow":"short";break;case"e":if(r<4)throw new RangeError("`e..eee` (weekday) patterns are not supported");t.weekday=["short","long","narrow","short"][r-4];break;case"c":if(r<4)throw new RangeError("`c..ccc` (weekday) patterns are not supported");t.weekday=["s\
hort","long","narrow","short"][r-4];break;case"a":t.hour12=!0;break;case"b":case"B":throw new RangeError("`b/B` (period) patterns are not supported, use `a` instead");case"h":t.hourCycle="h12",t.hour=["numeric","2-digit"][r-1];break;case"H":t.hourCycle="h23",t.hour=["numeric","2-digit"][r-1];break;case"K":t.hourCycle="h11",t.hour=["numeric","2-digit"][r-1];break;case"k":t.hourCycle="h24",t.hour=["numeric","2-digit"][r-1];break;case"j":case"J":case"C":throw new RangeError("`j/J/C` (hour) patterns are not supported, use `h/H/K/k` instead");case"m":t.minute=["numeric","2-digit"][r-1];break;case"s":t.second=["numeric","2-digit"][r-1];break;case"S":case"A":throw new RangeError("`S/A` (second) patterns are not supported, use `s` instead");case"z":t.timeZoneName=r<4?"short":"long";break;case"Z":case"O":case"v":case"V":case"X":case"x":throw new RangeError("`Z/O/v/V/X/x` (timeZone) patterns are not supported, use `z` instead")}return""}),t}var BQ,oN=g(()=>{d();BQ=/(?:[Eec]{1,6}|G{1,5}|[Qq]{1,5}|(?:[yYur]+|U{1,5})|[ML]{1,5}|d{1,2}|D{1,3}|F{1}|[abB]{1,5}|[hkHK]{1,2}|w{1,2}|W{1}|m{1,2}|s{1,2}|[zZOvVxX]{1,4})(?=([^']*'[^']*')*[^']*$)/g;
i(aN,"parseDateTimeSkeleton")});var mn,iN=g(()=>{d();mn=i(function(){return mn=Object.assign||i(function(t){for(var n,r=1,a=arguments.length;r<a;r++){n=arguments[r];for(var o in n)Object.prototype.hasOwnProperty.call(n,o)&&(t[o]=n[o])}return t},"__assign"),mn.apply(this,arguments)},"__assign")});var sN,cN=g(()=>{d();sN=/[\t-\r \x85\u200E\u200F\u2028\u2029]/i});function mN(e){if(e.length===0)throw new Error("Number skeleton cannot be empty");for(var t=e.split(sN).filter(function(f){return f.length>0}),n=[],r=0,a=t;r<a.length;r++){var o=a[r],s=o.split("/");if(s.length===0)throw new Error("Invalid number skeleton");for(var c=s[0],u=s.slice(1),l=0,m=u;l<m.length;l++){var p=m[l];if(p.length===0)throw new Error("Invalid number skeleton")}n.push({stem:c,options:u})}return n}function UQ(e){return e.replace(/^(.*?)-/,"")}function lN(e){var t={};return e[e.length-1]==="r"?t.roundingPriority="morePrecision":e[e.length-1]==="s"&&(t.roundingPriority="lessPrecision"),e.replace(pN,function(n,r,a){return typeof a!="string"?(t.minimumSignificantDigits=r.length,t.maximumSignificantDigits=r.length):a==="+"?t.minimumSignificantDigits=r.length:r[0]==="#"?t.maximumSignificantDigits=r.length:(t.minimumSignificantDigits=r.length,t.maximumSignificantDigits=r.length+(typeof a=="string"?a.length:0)),""}),t}function hN(e){switch(e){case"sign-auto":return{signDisplay:"a\
uto"};case"sign-accounting":case"()":return{currencySign:"accounting"};case"sign-always":case"+!":return{signDisplay:"always"};case"sign-accounting-always":case"()!":return{signDisplay:"always",currencySign:"accounting"};case"sign-except-zero":case"+?":return{signDisplay:"exceptZero"};case"sign-accounting-except-zero":case"()?":return{signDisplay:"exceptZero",currencySign:"accounting"};case"sign-never":case"+_":return{signDisplay:"never"}}}function qQ(e){var t;if(e[0]==="E"&&e[1]==="E"?(t={notation:"engineering"},e=e.slice(2)):e[0]==="E"&&(t={notation:"scientific"},e=e.slice(1)),t){var n=e.slice(0,2);if(n==="+!"?(t.signDisplay="always",e=e.slice(2)):n==="+?"&&(t.signDisplay="exceptZero",e=e.slice(2)),!fN.test(e))throw new Error("Malformed concise eng/scientific notation");t.minimumIntegerDigits=e.length}return t}function dN(e){var t={},n=hN(e);return n||t}function gN(e){for(var t={},n=0,r=e;n<r.length;n++){var a=r[n];switch(a.stem){case"percent":case"%":t.style="percent";continue;case"\
%x100":t.style="percent",t.scale=100;continue;case"currency":t.style="currency",t.currency=a.options[0];continue;case"group-off":case",_":t.useGrouping=!1;continue;case"precision-integer":case".":t.maximumFractionDigits=0;continue;case"measure-unit":case"unit":t.style="unit",t.unit=UQ(a.options[0]);continue;case"compact-short":case"K":t.notation="compact",t.compactDisplay="short";continue;case"compact-long":case"KK":t.notation="compact",t.compactDisplay="long";continue;case"scientific":t=mn(mn(mn({},t),{notation:"scientific"}),a.options.reduce(function(u,l){return mn(mn({},u),dN(l))},{}));continue;case"engineering":t=mn(mn(mn({},t),{notation:"engineering"}),a.options.reduce(function(u,l){return mn(mn({},u),dN(l))},{}));continue;case"notation-simple":t.notation="standard";continue;case"unit-width-narrow":t.currencyDisplay="narrowSymbol",t.unitDisplay="narrow";continue;case"unit-width-short":t.currencyDisplay="code",t.unitDisplay="short";continue;case"unit-width-full-name":t.currencyDisplay=
"name",t.unitDisplay="long";continue;case"unit-width-iso-code":t.currencyDisplay="symbol";continue;case"scale":t.scale=parseFloat(a.options[0]);continue;case"integer-width":if(a.options.length>1)throw new RangeError("integer-width stems only accept a single optional option");a.options[0].replace(jQ,function(u,l,m,p,f,h){if(l)t.minimumIntegerDigits=m.length;else{if(p&&f)throw new Error("We currently do not support maximum integer digits");if(h)throw new Error("We currently do not support exact integer digits")}return""});continue}if(fN.test(a.stem)){t.minimumIntegerDigits=a.stem.length;continue}if(uN.test(a.stem)){if(a.options.length>1)throw new RangeError("Fraction-precision stems only accept a single optional option");a.stem.replace(uN,function(u,l,m,p,f,h){return m==="*"?t.minimumFractionDigits=l.length:p&&p[0]==="#"?t.maximumFractionDigits=p.length:f&&h?(t.minimumFractionDigits=f.length,t.maximumFractionDigits=f.length+h.length):(t.minimumFractionDigits=l.length,t.maximumFractionDigits=
l.length),""});var o=a.options[0];o==="w"?t=mn(mn({},t),{trailingZeroDisplay:"stripIfInteger"}):o&&(t=mn(mn({},t),lN(o)));continue}if(pN.test(a.stem)){t=mn(mn({},t),lN(a.stem));continue}var s=hN(a.stem);s&&(t=mn(mn({},t),s));var c=qQ(a.stem);c&&(t=mn(mn({},t),c))}return t}var uN,pN,jQ,fN,yN=g(()=>{d();iN();cN();i(mN,"parseNumberSkeletonFromString");i(UQ,"icuUnitToEcma");uN=/^\.(?:(0+)(\*)?|(#+)|(0+)(#+))$/g,pN=/^(@+)?(\+|#+)?[rs]?$/g,jQ=/(\*)(0+)|(#+)(0+)|(0+)/g,fN=/^(0+)$/;i(lN,"parseSignificantPrecision");i(hN,"parseSign");i(qQ,"parseConciseScientificAndEngineeringStem");i(dN,"parseNotationOptions");i(gN,"parseNumberSkeleton")});var vN=g(()=>{d();oN();yN()});var Cd,bN=g(()=>{d();Cd={"001":["H","h"],AC:["H","h","hb","hB"],AD:["H","hB"],AE:["h","hB","hb","H"],AF:["H","hb","hB","h"],AG:["h","hb","H","hB"],AI:["H","h","hb","hB"],AL:["h","H","hB"],AM:["H","hB"],AO:["H","hB"],AR:["H","h","hB","hb"],AS:["h","H"],AT:["H","hB"],AU:["h","hb","H","hB"],AW:["H","hB"],AX:["H"],AZ:["H","hB","h"],BA:["H","hB","h"],BB:["h","hb","H","hB"],BD:["h","hB","H"],BE:["H","hB"],BF:["H","hB"],BG:["H","hB","h"],BH:["h","hB","hb","H"],BJ:["H","hB"],BL:["H","hB"],BM:["h","hb","H","hB"],BN:["hb","hB","h","H"],BO:["H","hB","h","hb"],BQ:["H"],BR:["H","hB"],BS:["h","hb","H","hB"],BT:["h","H"],BW:["H","h","hb","hB"],BZ:["H","h","hb","hB"],CA:["h","hb","H","hB"],CC:["H","h","hb","hB"],CD:["hB","H"],CF:["H","h","hB"],CG:["H","hB"],CH:["H","hB","h"],CI:["H","hB"],CK:["H","h","hb","hB"],CL:["H","h","hB","hb"],CM:["H","h","hB"],CN:["H","hB","hb","h"],CO:["h","H","hB","hb"],CP:["H"],CR:["H","h","hB","hb"],CU:["H","h","hB","hb"],CV:["H","hB"],CX:["H","h","hb","hB"],CY:["h","H","h\
b","hB"],CZ:["H"],DE:["H","hB"],DG:["H","h","hb","hB"],DJ:["h","H"],DK:["H"],DM:["h","hb","H","hB"],DO:["h","H","hB","hb"],DZ:["h","hB","hb","H"],EA:["H","h","hB","hb"],EC:["H","hB","h","hb"],EE:["H","hB"],EG:["h","hB","hb","H"],EH:["h","hB","hb","H"],ER:["h","H"],ES:["H","hB","h","hb"],ET:["hB","hb","h","H"],FI:["H"],FJ:["h","hb","H","hB"],FK:["H","h","hb","hB"],FM:["h","hb","H","hB"],FR:["H","hB"],GA:["H","hB"],GB:["H","h","hb","hB"],GD:["h","hb","H","hB"],GE:["H","hB","h"],GF:["H","hB"],GG:["H","h","hb","hB"],GH:["h","H"],GI:["H","h","hb","hB"],GM:["h","hb","H","hB"],GN:["H","hB"],GP:["H","hB"],GQ:["H","hB","h","hb"],GR:["h","H","hb","hB"],GT:["H","h","hB","hb"],GU:["h","hb","H","hB"],GW:["H","hB"],GY:["h","hb","H","hB"],HK:["h","hB","hb","H"],HN:["H","h","hB","hb"],HR:["H","hB"],IC:["H","h","hB","hb"],ID:["H"],IE:["H","h","hb","hB"],IL:["H","hB"],IM:["H","h","hb","hB"],IN:["h","H"],IO:["H","h","hb","hB"],IQ:["h","hB","hb","H"],IR:["hB","H"],IS:["H"],IT:["H","hB"],JE:["H","h","hb","\
hB"],JM:["h","hb","H","hB"],JO:["h","hB","hb","H"],JP:["H","h","K"],KE:["hB","hb","H","h"],KG:["H","h","hB","hb"],KH:["hB","h","H","hb"],KI:["h","hb","H","hB"],KM:["H","h","hB","hb"],KN:["h","hb","H","hB"],KP:["h","H","hB","hb"],KR:["h","H","hB","hb"],KW:["h","hB","hb","H"],KY:["h","hb","H","hB"],KZ:["H","hB"],LA:["H","hb","hB","h"],LB:["h","hB","hb","H"],LC:["h","hb","H","hB"],LI:["H","hB","h"],LK:["H","h","hB","hb"],LR:["h","hb","H","hB"],LS:["h","H"],LT:["H","h","hb","hB"],LU:["H","h","hB"],LV:["H","hB","hb","h"],LY:["h","hB","hb","H"],MA:["H","h","hB","hb"],MC:["H","hB"],MD:["H","hB"],ME:["H","hB","h"],MF:["H","hB"],MH:["h","hb","H","hB"],MK:["H","h","hb","hB"],ML:["H"],MM:["hB","hb","H","h"],MN:["H","h","hb","hB"],MO:["h","hB","hb","H"],MP:["h","hb","H","hB"],MQ:["H","hB"],MR:["h","hB","hb","H"],MS:["H","h","hb","hB"],MW:["h","hb","H","hB"],MX:["H","h","hB","hb"],MY:["hb","hB","h","H"],MZ:["H","hB"],NA:["h","H","hB","hb"],NC:["H","hB"],NE:["H"],NF:["H","h","hb","hB"],NG:["H","h","\
hb","hB"],NI:["H","h","hB","hb"],NL:["H","hB"],NP:["H","h","hB"],NR:["H","h","hb","hB"],NU:["H","h","hb","hB"],NZ:["h","hb","H","hB"],OM:["h","hB","hb","H"],PA:["h","H","hB","hb"],PE:["H","hB","h","hb"],PF:["H","h","hB"],PG:["h","H"],PH:["h","hB","hb","H"],PK:["h","hB","H"],PM:["H","hB"],PN:["H","h","hb","hB"],PR:["h","H","hB","hb"],PS:["h","hB","hb","H"],PT:["H","hB"],PW:["h","H"],PY:["H","h","hB","hb"],QA:["h","hB","hb","H"],RE:["H","hB"],RO:["H","hB"],RS:["H","hB","h"],RU:["H"],SA:["h","hB","hb","H"],SB:["h","hb","H","hB"],SC:["H","h","hB"],SD:["h","hB","hb","H"],SE:["H"],SG:["h","hb","H","hB"],SH:["H","h","hb","hB"],SI:["H","hB"],SJ:["H"],SK:["H"],SL:["h","hb","H","hB"],SM:["H","h","hB"],SN:["H","h","hB"],SO:["h","H"],SR:["H","hB"],SS:["h","hb","H","hB"],ST:["H","hB"],SV:["H","h","hB","hb"],SX:["H","h","hb","hB"],SY:["h","hB","hb","H"],SZ:["h","hb","H","hB"],TA:["H","h","hb","hB"],TC:["h","hb","H","hB"],TD:["h","H","hB"],TF:["H","h","hB"],TG:["H","hB"],TL:["H","hB","hb","h"],TN:["h",
"hB","hb","H"],TO:["h","H"],TR:["H","hB"],TT:["h","hb","H","hB"],TW:["hB","hb","h","H"],TZ:["hB","hb","H","h"],UA:["H","hB","h"],UG:["hB","hb","H","h"],UM:["h","hb","H","hB"],US:["h","hb","H","hB"],UY:["H","h","hB","hb"],UZ:["H","hB","h"],VA:["H","h","hB"],VC:["h","hb","H","hB"],VE:["h","H","hB","hb"],VG:["h","hb","H","hB"],VI:["h","hb","H","hB"],VU:["h","H"],WF:["H","hB"],WS:["h","H"],XK:["H","hB","h"],YE:["h","hB","hb","H"],YT:["H","hB"],ZA:["H","h","hb","hB"],ZM:["h","hb","H","hB"],"af-ZA":["H","h","hB","hb"],"ar-001":["h","hB","hb","H"],"ca-ES":["H","h","hB"],"en-001":["h","hb","H","hB"],"es-BO":["H","h","hB","hb"],"es-BR":["H","h","hB","hb"],"es-EC":["H","h","hB","hb"],"es-ES":["H","h","hB","hb"],"es-GQ":["H","h","hB","hb"],"es-PE":["H","h","hB","hb"],"fr-CA":["H","h","hB"],"gl-ES":["H","h","hB"],"gu-IN":["hB","hb","h","H"],"hi-IN":["hB","h","H"],"it-CH":["H","h","hB"],"it-IT":["H","h","hB"],"kn-IN":["hB","h","H"],"ml-IN":["hB","h","H"],"mr-IN":["hB","hb","h","H"],"pa-IN":["hB","h\
b","h","H"],"ta-IN":["hB","h","hb","H"],"te-IN":["hB","h","H"],"zu-ZA":["H","hB","hb","h"]}});function wN(e,t){for(var n="",r=0;r<e.length;r++){var a=e.charAt(r);if(a==="j"){for(var o=0;r+1<e.length&&e.charAt(r+1)===a;)o++,r++;var s=1+(o&1),c=o<2?1:3+(o>>1),u="a",l=zQ(t);for((l=="H"||l=="k")&&(c=0);c-- >0;)n+=u;for(;s-- >0;)n=l+n}else a==="J"?n+="H":n+=a}return n}function zQ(e){var t=e.hourCycle;if(t===void 0&&e.hourCycles&&e.hourCycles.length&&(t=e.hourCycles[0]),t)switch(t){case"h24":return"k";case"h23":return"H";case"h12":return"h";case"h11":return"K";default:throw new Error("Invalid hourCycle")}var n=e.language,r;n!=="root"&&(r=e.maximize().region);var a=Cd[r||""]||Cd[n||""]||Cd["".concat(n,"-001")]||Cd["001"];return a[0]}var xN=g(()=>{d();bN();i(wN,"getBestPattern");i(zQ,"getDefaultHourSymbolFromLocale")});function Rt(e,t){return{start:e,end:t}}function CN(e,t){return new RegExp(e,t)}function $b(e){return e>=97&&e<=122||e>=65&&e<=90}function tee(e){return $b(e)||e===47}function nee(e){return e===45||e===46||e>=48&&e<=57||e===95||e>=97&&e<=122||e>=65&&e<=90||e==183||e>=192&&e<=214||e>=216&&e<=246||e>=248&&e<=893||e>=895&&e<=8191||e>=8204&&e<=8205||e>=8255&&e<=8256||e>=8304&&e<=8591||e>=11264&&e<=12271||e>=12289&&e<=55295||e>=63744&&e<=64975||e>=65008&&e<=65533||e>=65536&&e<=983039}function IN(e){return e>=9&&e<=13||e===32||e===133||e>=8206&&e<=8207||e===8232||e===8233}function ree(e){return e>=33&&e<=35||e===36||e>=37&&e<=39||e===40||e===41||e===42||e===43||e===44||e===45||e>=46&&e<=47||e>=58&&e<=59||e>=60&&e<=62||e>=63&&e<=64||e===91||e===92||e===93||e===94||e===96||e===123||e===124||e===125||e===126||e===161||e>=162&&e<=165||e===166||e===167||e===169||e===171||e===172||e===174||e===176||e===177||e===182||e===187||e===191||e===215||e===247||e>=8208&&e<=8213||e>=8214&&e<=8215||e===8216||e===
8217||e===8218||e>=8219&&e<=8220||e===8221||e===8222||e===8223||e>=8224&&e<=8231||e>=8240&&e<=8248||e===8249||e===8250||e>=8251&&e<=8254||e>=8257&&e<=8259||e===8260||e===8261||e===8262||e>=8263&&e<=8273||e===8274||e===8275||e>=8277&&e<=8286||e>=8592&&e<=8596||e>=8597&&e<=8601||e>=8602&&e<=8603||e>=8604&&e<=8607||e===8608||e>=8609&&e<=8610||e===8611||e>=8612&&e<=8613||e===8614||e>=8615&&e<=8621||e===8622||e>=8623&&e<=8653||e>=8654&&e<=8655||e>=8656&&e<=8657||e===8658||e===8659||e===8660||e>=8661&&e<=8691||e>=8692&&e<=8959||e>=8960&&e<=8967||e===8968||e===8969||e===8970||e===8971||e>=8972&&e<=8991||e>=8992&&e<=8993||e>=8994&&e<=9e3||e===9001||e===9002||e>=9003&&e<=9083||e===9084||e>=9085&&e<=9114||e>=9115&&e<=9139||e>=9140&&e<=9179||e>=9180&&e<=9185||e>=9186&&e<=9254||e>=9255&&e<=9279||e>=9280&&e<=9290||e>=9291&&e<=9311||e>=9472&&e<=9654||e===9655||e>=9656&&e<=9664||e===9665||e>=9666&&e<=9719||e>=9720&&e<=9727||e>=9728&&e<=9838||e===9839||e>=9840&&e<=10087||e===10088||e===10089||e===10090||
e===10091||e===10092||e===10093||e===10094||e===10095||e===10096||e===10097||e===10098||e===10099||e===10100||e===10101||e>=10132&&e<=10175||e>=10176&&e<=10180||e===10181||e===10182||e>=10183&&e<=10213||e===10214||e===10215||e===10216||e===10217||e===10218||e===10219||e===10220||e===10221||e===10222||e===10223||e>=10224&&e<=10239||e>=10240&&e<=10495||e>=10496&&e<=10626||e===10627||e===10628||e===10629||e===10630||e===10631||e===10632||e===10633||e===10634||e===10635||e===10636||e===10637||e===10638||e===10639||e===10640||e===10641||e===10642||e===10643||e===10644||e===10645||e===10646||e===10647||e===10648||e>=10649&&e<=10711||e===10712||e===10713||e===10714||e===10715||e>=10716&&e<=10747||e===10748||e===10749||e>=10750&&e<=11007||e>=11008&&e<=11055||e>=11056&&e<=11076||e>=11077&&e<=11078||e>=11079&&e<=11084||e>=11085&&e<=11123||e>=11124&&e<=11125||e>=11126&&e<=11157||e===11158||e>=11159&&e<=11263||e>=11776&&e<=11777||e===11778||e===11779||e===11780||e===11781||e>=11782&&e<=11784||e===
11785||e===11786||e===11787||e===11788||e===11789||e>=11790&&e<=11798||e===11799||e>=11800&&e<=11801||e===11802||e===11803||e===11804||e===11805||e>=11806&&e<=11807||e===11808||e===11809||e===11810||e===11811||e===11812||e===11813||e===11814||e===11815||e===11816||e===11817||e>=11818&&e<=11822||e===11823||e>=11824&&e<=11833||e>=11834&&e<=11835||e>=11836&&e<=11839||e===11840||e===11841||e===11842||e>=11843&&e<=11855||e>=11856&&e<=11857||e===11858||e>=11859&&e<=11903||e>=12289&&e<=12291||e===12296||e===12297||e===12298||e===12299||e===12300||e===12301||e===12302||e===12303||e===12304||e===12305||e>=12306&&e<=12307||e===12308||e===12309||e===12310||e===12311||e===12312||e===12313||e===12314||e===12315||e===12316||e===12317||e>=12318&&e<=12319||e===12320||e===12336||e===64830||e===64831||e>=65093&&e<=65094}var zb,HQ,WQ,GQ,VQ,$Q,YQ,KQ,JQ,XQ,ZQ,Wb,DN,EN,Gb,TN,SN,QQ,eee,Vb,Hb,kN,AN=g(()=>{d();Bb();Ub();ug();rN();vN();xN();HQ=new RegExp("^".concat(qb.source,"*")),WQ=new RegExp("".concat(qb.source,
"*$"));i(Rt,"createLocation");GQ=!!String.prototype.startsWith&&"_a".startsWith("a",1),VQ=!!String.fromCodePoint,$Q=!!Object.fromEntries,YQ=!!String.prototype.codePointAt,KQ=!!String.prototype.trimStart,JQ=!!String.prototype.trimEnd,XQ=!!Number.isSafeInteger,ZQ=XQ?Number.isSafeInteger:function(e){return typeof e=="number"&&isFinite(e)&&Math.floor(e)===e&&Math.abs(e)<=9007199254740991},Wb=!0;try{DN=CN("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),Wb=((zb=DN.exec("a"))===null||zb===void 0?void 0:zb[0])==="a"}catch{Wb=!1}EN=i(GQ?function(t,n,r){return t.startsWith(n,r)}:function(t,n,r){return t.slice(r,r+n.length)===n},"startsWith"),Gb=VQ?String.fromCodePoint:i(function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];for(var r="",a=t.length,o=0,s;a>o;){if(s=t[o++],s>1114111)throw RangeError(s+" is not a valid code point");r+=s<65536?String.fromCharCode(s):String.fromCharCode(((s-=65536)>>10)+55296,s%1024+56320)}return r},"fromCodePoint"),TN=$Q?Object.fromEntries:i(function(t){
for(var n={},r=0,a=t;r<a.length;r++){var o=a[r],s=o[0],c=o[1];n[s]=c}return n},"fromEntries"),SN=i(YQ?function(t,n){return t.codePointAt(n)}:function(t,n){var r=t.length;if(!(n<0||n>=r)){var a=t.charCodeAt(n),o;return a<55296||a>56319||n+1===r||(o=t.charCodeAt(n+1))<56320||o>57343?a:(a-55296<<10)+(o-56320)+65536}},"codePointAt"),QQ=i(KQ?function(t){return t.trimStart()}:function(t){return t.replace(HQ,"")},"trimStart"),eee=i(JQ?function(t){return t.trimEnd()}:function(t){return t.replace(WQ,"")},"trimEnd");i(CN,"RE");Wb?(Hb=CN("([^\\p{White_Space}\\p{Pattern_Syntax}]*)","yu"),Vb=i(function(t,n){var r;Hb.lastIndex=n;var a=Hb.exec(t);return(r=a[1])!==null&&r!==void 0?r:""},"matchIdentifierAtIndex")):Vb=i(function(t,n){for(var r=[];;){var a=SN(t,n);if(a===void 0||IN(a)||ree(a))break;r.push(a),n+=a>=65536?2:1}return Gb.apply(void 0,r)},"matchIdentifierAtIndex");kN=function(){function e(t,n){n===void 0&&(n={}),this.message=t,this.position={offset:0,line:1,column:1},this.ignoreTag=!!n.ignoreTag,
this.locale=n.locale,this.requiresOtherClause=!!n.requiresOtherClause,this.shouldParseSkeletons=!!n.shouldParseSkeletons}return i(e,"Parser"),e.prototype.parse=function(){if(this.offset()!==0)throw Error("parser can only be used once");return this.parseMessage(0,"",!1)},e.prototype.parseMessage=function(t,n,r){for(var a=[];!this.isEOF();){var o=this.char();if(o===123){var s=this.parseArgument(t,r);if(s.err)return s;a.push(s.val)}else{if(o===125&&t>0)break;if(o===35&&(n==="plural"||n==="selectordinal")){var c=this.clonePosition();this.bump(),a.push({type:on.pound,location:Rt(c,this.clonePosition())})}else if(o===60&&!this.ignoreTag&&this.peek()===47){if(r)break;return this.error(Tt.UNMATCHED_CLOSING_TAG,Rt(this.clonePosition(),this.clonePosition()))}else if(o===60&&!this.ignoreTag&&$b(this.peek()||0)){var s=this.parseTag(t,n);if(s.err)return s;a.push(s.val)}else{var s=this.parseLiteral(t,n);if(s.err)return s;a.push(s.val)}}}return{val:a,err:null}},e.prototype.parseTag=function(t,n){var r=this.
clonePosition();this.bump();var a=this.parseTagName();if(this.bumpSpace(),this.bumpIf("/>"))return{val:{type:on.literal,value:"<".concat(a,"/>"),location:Rt(r,this.clonePosition())},err:null};if(this.bumpIf(">")){var o=this.parseMessage(t+1,n,!0);if(o.err)return o;var s=o.val,c=this.clonePosition();if(this.bumpIf("</")){if(this.isEOF()||!$b(this.char()))return this.error(Tt.INVALID_TAG,Rt(c,this.clonePosition()));var u=this.clonePosition(),l=this.parseTagName();return a!==l?this.error(Tt.UNMATCHED_CLOSING_TAG,Rt(u,this.clonePosition())):(this.bumpSpace(),this.bumpIf(">")?{val:{type:on.tag,value:a,children:s,location:Rt(r,this.clonePosition())},err:null}:this.error(Tt.INVALID_TAG,Rt(c,this.clonePosition())))}else return this.error(Tt.UNCLOSED_TAG,Rt(r,this.clonePosition()))}else return this.error(Tt.INVALID_TAG,Rt(r,this.clonePosition()))},e.prototype.parseTagName=function(){var t=this.offset();for(this.bump();!this.isEOF()&&nee(this.char());)this.bump();return this.message.slice(t,this.
offset())},e.prototype.parseLiteral=function(t,n){for(var r=this.clonePosition(),a="";;){var o=this.tryParseQuote(n);if(o){a+=o;continue}var s=this.tryParseUnquoted(t,n);if(s){a+=s;continue}var c=this.tryParseLeftAngleBracket();if(c){a+=c;continue}break}var u=Rt(r,this.clonePosition());return{val:{type:on.literal,value:a,location:u},err:null}},e.prototype.tryParseLeftAngleBracket=function(){return!this.isEOF()&&this.char()===60&&(this.ignoreTag||!tee(this.peek()||0))?(this.bump(),"<"):null},e.prototype.tryParseQuote=function(t){if(this.isEOF()||this.char()!==39)return null;switch(this.peek()){case 39:return this.bump(),this.bump(),"'";case 123:case 60:case 62:case 125:break;case 35:if(t==="plural"||t==="selectordinal")break;return null;default:return null}this.bump();var n=[this.char()];for(this.bump();!this.isEOF();){var r=this.char();if(r===39)if(this.peek()===39)n.push(39),this.bump();else{this.bump();break}else n.push(r);this.bump()}return Gb.apply(void 0,n)},e.prototype.tryParseUnquoted=
function(t,n){if(this.isEOF())return null;var r=this.char();return r===60||r===123||r===35&&(n==="plural"||n==="selectordinal")||r===125&&t>0?null:(this.bump(),Gb(r))},e.prototype.parseArgument=function(t,n){var r=this.clonePosition();if(this.bump(),this.bumpSpace(),this.isEOF())return this.error(Tt.EXPECT_ARGUMENT_CLOSING_BRACE,Rt(r,this.clonePosition()));if(this.char()===125)return this.bump(),this.error(Tt.EMPTY_ARGUMENT,Rt(r,this.clonePosition()));var a=this.parseIdentifierIfPossible().value;if(!a)return this.error(Tt.MALFORMED_ARGUMENT,Rt(r,this.clonePosition()));if(this.bumpSpace(),this.isEOF())return this.error(Tt.EXPECT_ARGUMENT_CLOSING_BRACE,Rt(r,this.clonePosition()));switch(this.char()){case 125:return this.bump(),{val:{type:on.argument,value:a,location:Rt(r,this.clonePosition())},err:null};case 44:return this.bump(),this.bumpSpace(),this.isEOF()?this.error(Tt.EXPECT_ARGUMENT_CLOSING_BRACE,Rt(r,this.clonePosition())):this.parseArgumentOptions(t,n,a,r);default:return this.error(
Tt.MALFORMED_ARGUMENT,Rt(r,this.clonePosition()))}},e.prototype.parseIdentifierIfPossible=function(){var t=this.clonePosition(),n=this.offset(),r=Vb(this.message,n),a=n+r.length;this.bumpTo(a);var o=this.clonePosition(),s=Rt(t,o);return{value:r,location:s}},e.prototype.parseArgumentOptions=function(t,n,r,a){var o,s=this.clonePosition(),c=this.parseIdentifierIfPossible().value,u=this.clonePosition();switch(c){case"":return this.error(Tt.EXPECT_ARGUMENT_TYPE,Rt(s,u));case"number":case"date":case"time":{this.bumpSpace();var l=null;if(this.bumpIf(",")){this.bumpSpace();var m=this.clonePosition(),p=this.parseSimpleArgStyleIfPossible();if(p.err)return p;var f=eee(p.val);if(f.length===0)return this.error(Tt.EXPECT_ARGUMENT_STYLE,Rt(this.clonePosition(),this.clonePosition()));var h=Rt(m,this.clonePosition());l={style:f,styleLocation:h}}var y=this.tryParseArgumentClose(a);if(y.err)return y;var b=Rt(a,this.clonePosition());if(l&&EN(l?.style,"::",0)){var w=QQ(l.style.slice(2));if(c==="number"){var p=this.
parseNumberSkeletonFromString(w,l.styleLocation);return p.err?p:{val:{type:on.number,value:r,location:b,style:p.val},err:null}}else{if(w.length===0)return this.error(Tt.EXPECT_DATE_TIME_SKELETON,b);var D=w;this.locale&&(D=wN(w,this.locale));var f={type:$s.dateTime,pattern:D,location:l.styleLocation,parsedOptions:this.shouldParseSkeletons?aN(D):{}},T=c==="date"?on.date:on.time;return{val:{type:T,value:r,location:b,style:f},err:null}}}return{val:{type:c==="number"?on.number:c==="date"?on.date:on.time,value:r,location:b,style:(o=l?.style)!==null&&o!==void 0?o:null},err:null}}case"plural":case"selectordinal":case"select":{var S=this.clonePosition();if(this.bumpSpace(),!this.bumpIf(","))return this.error(Tt.EXPECT_SELECT_ARGUMENT_OPTIONS,Rt(S,fu({},S)));this.bumpSpace();var k=this.parseIdentifierIfPossible(),_=0;if(c!=="select"&&k.value==="offset"){if(!this.bumpIf(":"))return this.error(Tt.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,Rt(this.clonePosition(),this.clonePosition()));this.bumpSpace();var p=this.
tryParseDecimalInteger(Tt.EXPECT_PLURAL_ARGUMENT_OFFSET_VALUE,Tt.INVALID_PLURAL_ARGUMENT_OFFSET_VALUE);if(p.err)return p;this.bumpSpace(),k=this.parseIdentifierIfPossible(),_=p.val}var Y=this.tryParsePluralOrSelectOptions(t,c,n,k);if(Y.err)return Y;var y=this.tryParseArgumentClose(a);if(y.err)return y;var W=Rt(a,this.clonePosition());return c==="select"?{val:{type:on.select,value:r,options:TN(Y.val),location:W},err:null}:{val:{type:on.plural,value:r,options:TN(Y.val),offset:_,pluralType:c==="plural"?"cardinal":"ordinal",location:W},err:null}}default:return this.error(Tt.INVALID_ARGUMENT_TYPE,Rt(s,u))}},e.prototype.tryParseArgumentClose=function(t){return this.isEOF()||this.char()!==125?this.error(Tt.EXPECT_ARGUMENT_CLOSING_BRACE,Rt(t,this.clonePosition())):(this.bump(),{val:!0,err:null})},e.prototype.parseSimpleArgStyleIfPossible=function(){for(var t=0,n=this.clonePosition();!this.isEOF();){var r=this.char();switch(r){case 39:{this.bump();var a=this.clonePosition();if(!this.bumpUntil("\
'"))return this.error(Tt.UNCLOSED_QUOTE_IN_ARGUMENT_STYLE,Rt(a,this.clonePosition()));this.bump();break}case 123:{t+=1,this.bump();break}case 125:{if(t>0)t-=1;else return{val:this.message.slice(n.offset,this.offset()),err:null};break}default:this.bump();break}}return{val:this.message.slice(n.offset,this.offset()),err:null}},e.prototype.parseNumberSkeletonFromString=function(t,n){var r=[];try{r=mN(t)}catch{return this.error(Tt.INVALID_NUMBER_SKELETON,n)}return{val:{type:$s.number,tokens:r,location:n,parsedOptions:this.shouldParseSkeletons?gN(r):{}},err:null}},e.prototype.tryParsePluralOrSelectOptions=function(t,n,r,a){for(var o,s=!1,c=[],u=new Set,l=a.value,m=a.location;;){if(l.length===0){var p=this.clonePosition();if(n!=="select"&&this.bumpIf("=")){var f=this.tryParseDecimalInteger(Tt.EXPECT_PLURAL_ARGUMENT_SELECTOR,Tt.INVALID_PLURAL_ARGUMENT_SELECTOR);if(f.err)return f;m=Rt(p,this.clonePosition()),l=this.message.slice(p.offset,this.offset())}else break}if(u.has(l))return this.error(n===
"select"?Tt.DUPLICATE_SELECT_ARGUMENT_SELECTOR:Tt.DUPLICATE_PLURAL_ARGUMENT_SELECTOR,m);l==="other"&&(s=!0),this.bumpSpace();var h=this.clonePosition();if(!this.bumpIf("{"))return this.error(n==="select"?Tt.EXPECT_SELECT_ARGUMENT_SELECTOR_FRAGMENT:Tt.EXPECT_PLURAL_ARGUMENT_SELECTOR_FRAGMENT,Rt(this.clonePosition(),this.clonePosition()));var y=this.parseMessage(t+1,n,r);if(y.err)return y;var b=this.tryParseArgumentClose(h);if(b.err)return b;c.push([l,{value:y.val,location:Rt(h,this.clonePosition())}]),u.add(l),this.bumpSpace(),o=this.parseIdentifierIfPossible(),l=o.value,m=o.location}return c.length===0?this.error(n==="select"?Tt.EXPECT_SELECT_ARGUMENT_SELECTOR:Tt.EXPECT_PLURAL_ARGUMENT_SELECTOR,Rt(this.clonePosition(),this.clonePosition())):this.requiresOtherClause&&!s?this.error(Tt.MISSING_OTHER_CLAUSE,Rt(this.clonePosition(),this.clonePosition())):{val:c,err:null}},e.prototype.tryParseDecimalInteger=function(t,n){var r=1,a=this.clonePosition();this.bumpIf("+")||this.bumpIf("-")&&(r=-1);
for(var o=!1,s=0;!this.isEOF();){var c=this.char();if(c>=48&&c<=57)o=!0,s=s*10+(c-48),this.bump();else break}var u=Rt(a,this.clonePosition());return o?(s*=r,ZQ(s)?{val:s,err:null}:this.error(n,u)):this.error(t,u)},e.prototype.offset=function(){return this.position.offset},e.prototype.isEOF=function(){return this.offset()===this.message.length},e.prototype.clonePosition=function(){return{offset:this.position.offset,line:this.position.line,column:this.position.column}},e.prototype.char=function(){var t=this.position.offset;if(t>=this.message.length)throw Error("out of bound");var n=SN(this.message,t);if(n===void 0)throw Error("Offset ".concat(t," is at invalid UTF-16 code unit boundary"));return n},e.prototype.error=function(t,n){return{val:null,err:{kind:t,message:this.message,location:n}}},e.prototype.bump=function(){if(!this.isEOF()){var t=this.char();t===10?(this.position.line+=1,this.position.column=1,this.position.offset+=1):(this.position.column+=1,this.position.offset+=t<65536?1:
2)}},e.prototype.bumpIf=function(t){if(EN(this.message,t,this.offset())){for(var n=0;n<t.length;n++)this.bump();return!0}return!1},e.prototype.bumpUntil=function(t){var n=this.offset(),r=this.message.indexOf(t,n);return r>=0?(this.bumpTo(r),!0):(this.bumpTo(this.message.length),!1)},e.prototype.bumpTo=function(t){if(this.offset()>t)throw Error("targetOffset ".concat(t," must be greater than or equal to the current offset ").concat(this.offset()));for(t=Math.min(t,this.message.length);;){var n=this.offset();if(n===t)break;if(n>t)throw Error("targetOffset ".concat(t," is at invalid UTF-16 code unit boundary"));if(this.bump(),this.isEOF())break}},e.prototype.bumpSpace=function(){for(;!this.isEOF()&&IN(this.char());)this.bump()},e.prototype.peek=function(){if(this.isEOF())return null;var t=this.char(),n=this.offset(),r=this.message.charCodeAt(n+(t>=65536?2:1));return r??null},e}();i($b,"_isAlpha");i(tee,"_isAlphaOrSlash");i(nee,"_isPotentialElementNameChar");i(IN,"_isWhiteSpace");i(ree,"_i\
sPatternSyntax")});function Yb(e){e.forEach(function(t){if(delete t.location,og(t)||ig(t))for(var n in t.options)delete t.options[n].location,Yb(t.options[n].value);else ng(t)&&cg(t.style)||(rg(t)||ag(t))&&Sd(t.style)?delete t.style.location:sg(t)&&Yb(t.children)})}function FN(e,t){t===void 0&&(t={}),t=fu({shouldParseSkeletons:!0,requiresOtherClause:!0},t);var n=new kN(e,t).parse();if(n.err){var r=SyntaxError(Tt[n.err.kind]);throw r.location=n.err.location,r.originalMessage=n.err.message,r}return t?.captureLocation||Yb(n.val),n.val}var Kb=g(()=>{d();Bb();Ub();AN();ug();ug();i(Yb,"pruneLocation");i(FN,"parse")});function lg(e,t){var n=t&&t.cache?t.cache:uee,r=t&&t.serializer?t.serializer:cee,a=t&&t.strategy?t.strategy:oee;return a(e,{cache:n,serializer:r})}function aee(e){return e==null||typeof e=="number"||typeof e=="boolean"}function RN(e,t,n,r){var a=aee(r)?r:n(r),o=t.get(a);return typeof o>"u"&&(o=e.call(this,r),t.set(a,o)),o}function _N(e,t,n){var r=Array.prototype.slice.call(arguments,3),a=n(r),o=t.get(a);return typeof o>"u"&&(o=e.apply(this,r),t.set(a,o)),o}function Jb(e,t,n,r,a){return n.bind(t,e,r,a)}function oee(e,t){var n=e.length===1?RN:_N;return Jb(e,this,n,t.cache.create(),t.serializer)}function iee(e,t){return Jb(e,this,_N,t.cache.create(),t.serializer)}function see(e,t){return Jb(e,this,RN,t.cache.create(),t.serializer)}function Xb(){this.cache=Object.create(null)}var cee,uee,dg,MN=g(()=>{d();i(lg,"memoize");i(aee,"isPrimitive");i(RN,"monadic");i(_N,"variadic");i(Jb,"assemble");i(oee,"strategyDefault");i(iee,"strategyVariadic");i(see,"strategyMonadic");cee=i(function(){return JSON.
stringify(arguments)},"serializerDefault");i(Xb,"ObjectWithoutPrototypeCache");Xb.prototype.get=function(e){return this.cache[e]};Xb.prototype.set=function(e,t){this.cache[e]=t};uee={create:i(function(){return new Xb},"create")},dg={variadic:iee,monadic:see}});var Ys,kd,Zb,ON,NN,Qb=g(()=>{d();Lb();(function(e){e.MISSING_VALUE="MISSING_VALUE",e.INVALID_VALUE="INVALID_VALUE",e.MISSING_INTL_API="MISSING_INTL_API"})(Ys||(Ys={}));kd=function(e){Td(t,e);function t(n,r,a){var o=e.call(this,n)||this;return o.code=r,o.originalMessage=a,o}return i(t,"FormatError"),t.prototype.toString=function(){return"[formatjs Error: ".concat(this.code,"] ").concat(this.message)},t}(Error),Zb=function(e){Td(t,e);function t(n,r,a,o){return e.call(this,'Invalid values for "'.concat(n,'": "').concat(r,'". Options are "').concat(Object.keys(a).join('", "'),'"'),Ys.INVALID_VALUE,o)||this}return i(t,"InvalidValueError"),t}(kd),ON=function(e){Td(t,e);function t(n,r,a){return e.call(this,'Value for "'.concat(n,'" must be of type ').concat(r),Ys.INVALID_VALUE,a)||this}return i(t,"InvalidValueTypeError"),t}(kd),NN=function(e){Td(t,e);function t(n,r){return e.call(this,'The intl string context variable "'.concat(n,'" was not provided to the string "').concat(r,'"'),Ys.MISSING_VALUE,
r)||this}return i(t,"MissingValueError"),t}(kd)});function lee(e){return e.length<2?e:e.reduce(function(t,n){var r=t[t.length-1];return!r||r.type!==ar.literal||n.type!==ar.literal?t.push(n):r.value+=n.value,t},[])}function dee(e){return typeof e=="function"}function Id(e,t,n,r,a,o,s){if(e.length===1&&jb(e[0]))return[{type:ar.literal,value:e[0].value}];for(var c=[],u=0,l=e;u<l.length;u++){var m=l[u];if(jb(m)){c.push({type:ar.literal,value:m.value});continue}if(nN(m)){typeof o=="number"&&c.push({type:ar.literal,value:n.getNumberFormat(t).format(o)});continue}var p=m.value;if(!(a&&p in a))throw new NN(p,s);var f=a[p];if(tN(m)){(!f||typeof f=="string"||typeof f=="number")&&(f=typeof f=="string"||typeof f=="number"?String(f):""),c.push({type:typeof f=="string"?ar.literal:ar.object,value:f});continue}if(rg(m)){var h=typeof m.style=="string"?r.date[m.style]:Sd(m.style)?m.style.parsedOptions:void 0;c.push({type:ar.literal,value:n.getDateTimeFormat(t,h).format(f)});continue}if(ag(m)){var h=typeof m.style=="string"?r.time[m.style]:Sd(m.style)?m.
style.parsedOptions:r.time.medium;c.push({type:ar.literal,value:n.getDateTimeFormat(t,h).format(f)});continue}if(ng(m)){var h=typeof m.style=="string"?r.number[m.style]:cg(m.style)?m.style.parsedOptions:void 0;h&&h.scale&&(f=f*(h.scale||1)),c.push({type:ar.literal,value:n.getNumberFormat(t,h).format(f)});continue}if(sg(m)){var y=m.children,b=m.value,w=a[b];if(!dee(w))throw new ON(b,"function",s);var D=Id(y,t,n,r,a,o),T=w(D.map(function(_){return _.value}));Array.isArray(T)||(T=[T]),c.push.apply(c,T.map(function(_){return{type:typeof _=="string"?ar.literal:ar.object,value:_}}))}if(og(m)){var S=m.options[f]||m.options.other;if(!S)throw new Zb(m.value,f,Object.keys(m.options),s);c.push.apply(c,Id(S.value,t,n,r,a));continue}if(ig(m)){var S=m.options["=".concat(f)];if(!S){if(!Intl.PluralRules)throw new kd(`Intl.PluralRules is not available in this environment.
Try polyfilling it using "@formatjs/intl-pluralrules"
`,Ys.MISSING_INTL_API,s);var k=n.getPluralRules(t,{type:m.pluralType}).select(f-(m.offset||0));S=m.options[k]||m.options.other}if(!S)throw new Zb(m.value,f,Object.keys(m.options),s);c.push.apply(c,Id(S.value,t,n,r,a,f-(m.offset||0)));continue}}return lee(c)}var ar,e0=g(()=>{d();Kb();Qb();(function(e){e[e.literal=0]="literal",e[e.object=1]="object"})(ar||(ar={}));i(lee,"mergeLiteral");i(dee,"isFormatXMLElementFn");i(Id,"formatToParts")});function mee(e,t){return t?Sa(Sa(Sa({},e||{}),t||{}),Object.keys(e).reduce(function(n,r){return n[r]=Sa(Sa({},e[r]),t[r]||{}),n},{})):e}function pee(e,t){return t?Object.keys(e).reduce(function(n,r){return n[r]=mee(e[r],t[r]),n},Sa({},e)):e}function t0(e){return{create:function(){return{get:function(t){return e[t]},set:function(t,n){e[t]=n}}}}}function fee(e){return e===void 0&&(e={number:{},dateTime:{},pluralRules:{}}),{getNumberFormat:lg(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.NumberFormat).bind.apply(t,tg([void 0],n,!1)))},{cache:t0(e.number),strategy:dg.variadic}),getDateTimeFormat:lg(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.DateTimeFormat).bind.apply(t,tg([void 0],n,!1)))},{cache:t0(e.dateTime),strategy:dg.variadic}),getPluralRules:lg(function(){for(var t,n=[],r=0;r<arguments.length;r++)n[r]=arguments[r];return new((t=Intl.PluralRules).bind.apply(t,tg([void 0],n,!1)))},{cache:t0(e.pluralRules),
strategy:dg.variadic})}}var PN,n0=g(()=>{d();Lb();Kb();MN();e0();i(mee,"mergeConfig");i(pee,"mergeConfigs");i(t0,"createFastMemoizeCache");i(fee,"createDefaultFormatters");PN=function(){function e(t,n,r,a){n===void 0&&(n=e.defaultLocale);var o=this;if(this.formatterCache={number:{},dateTime:{},pluralRules:{}},this.format=function(l){var m=o.formatToParts(l);if(m.length===1)return m[0].value;var p=m.reduce(function(f,h){return!f.length||h.type!==ar.literal||typeof f[f.length-1]!="string"?f.push(h.value):f[f.length-1]+=h.value,f},[]);return p.length<=1?p[0]||"":p},this.formatToParts=function(l){return Id(o.ast,o.locales,o.formatters,o.formats,l,void 0,o.message)},this.resolvedOptions=function(){var l;return{locale:((l=o.resolvedLocale)===null||l===void 0?void 0:l.toString())||Intl.NumberFormat.supportedLocalesOf(o.locales)[0]}},this.getAst=function(){return o.ast},this.locales=n,this.resolvedLocale=e.resolveLocale(n),typeof t=="string"){if(this.message=t,!e.__parse)throw new TypeError("I\
ntlMessageFormat.__parse must be set to process `message` of type `string`");var s=a||{},c=s.formatters,u=eN(s,["formatters"]);this.ast=e.__parse(t,Sa(Sa({},u),{locale:this.resolvedLocale}))}else this.ast=t;if(!Array.isArray(this.ast))throw new TypeError("A message must be provided as a String or AST.");this.formats=pee(e.formats,r),this.formatters=a&&a.formatters||fee(this.formatterCache)}return i(e,"IntlMessageFormat"),Object.defineProperty(e,"defaultLocale",{get:function(){return e.memoizedDefaultLocale||(e.memoizedDefaultLocale=new Intl.NumberFormat().resolvedOptions().locale),e.memoizedDefaultLocale},enumerable:!1,configurable:!0}),e.memoizedDefaultLocale=null,e.resolveLocale=function(t){if(!(typeof Intl.Locale>"u")){var n=Intl.NumberFormat.supportedLocalesOf(t);return n.length>0?new Intl.Locale(n[0]):new Intl.Locale(typeof t=="string"?t:t[0])}},e.__parse=FN,e.formats={number:{integer:{maximumFractionDigits:0},currency:{style:"currency"},percent:{style:"percent"}},date:{short:{month:"\
numeric",day:"numeric",year:"2-digit"},medium:{month:"short",day:"numeric",year:"numeric"},long:{month:"long",day:"numeric",year:"numeric"},full:{weekday:"long",month:"long",day:"numeric",year:"numeric"}},time:{short:{hour:"numeric",minute:"numeric"},medium:{hour:"numeric",minute:"numeric",second:"numeric"},long:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"},full:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"}}},e}()});var r0,LN=g(()=>{d();n0();e0();n0();Qb();r0=PN});var Ks,hu=g(()=>{d();Ks=i(()=>({resolve(){throw new Error("createRequire.resolve is not supported in bundled Lighthouse")}}),"createRequire")});var hee,gee,Js,Ad=g(()=>{d();hee=globalThis.URL,gee=i(e=>e,"fileURLToPath"),Js={URL:hee,fileURLToPath:gee}});function BN(e){return Js.fileURLToPath(e.url)}var Xs=g(()=>{"use strict";d();hu();Ad();Fi();i(BN,"getModulePath")});function a0(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function UN(e){return typeof e=="object"&&e!==null}var jN=g(()=>{"use strict";d();i(a0,"isObjectOfUnknownValues");i(UN,"isObjectOrArrayOfUnknownValues")});var qN,zN=g(()=>{d();qN={}});function WN(e,t=new Map){for(let n of e)if(!(n.type===mg.literal||n.type===mg.pound)&&(t.set(n.value,n),n.type===mg.plural))for(let r of Object.values(n.options))WN(r.value,t);return t}function bee(e,t={},n){let r=WN(e.getAst()),a={};for(let[o,s]of r){if(!(o in t))throw new Error(`ICU Message "${n}" contains a value reference ("${o}") that wasn't provided`);let c=t[o];if(s.type!==mg.number){a[o]=c;continue}if(typeof c!="number")throw new Error(`ICU Message "${n}" contains a numeric reference ("${o}") but provided value was not a number`);s.style==="milliseconds"?a[o]=Math.round(c/10)*10:s.style==="seconds"&&o==="timeInMs"?a[o]=Math.round(c/100)/10:s.style==="bytes"?a[o]=c/1024:a[o]=c}for(let o of Object.keys(t))if(!(o in a)){if(o==="errorCode"){a.errorCode=t.errorCode;continue}throw new Error(`Provided value "${o}" does not match any placeholder in ICU message "${n}"`)}return a}function wee(e){return e.replace(/'/g,"''").replace(/\\{/g,"'{").replace(/\\}/g,"'}")}function i0(e,t,n){e=wee(
e);let r=n==="en-XA"||n==="en-XL"?"de-DE":n,a=r0.IntlMessageFormat||r0,o=new a(e,r,vee,{ignoreTag:!0}),s=bee(o,t,e),c=o.format(s);if(typeof c!="string")throw new Error("unexpected formatted result");return c}function xee(e,t){let r=VN(t)[e.i18nId];return r?i0(r.message,e.values,t):e.formattedDefault}function GN(e){let t=VN(e),n=Object.keys(t).filter(a=>a.startsWith("report/renderer/report-utils.js")),r={};for(let a of n){let{filename:o,key:s}=Eee(a);if(!o.endsWith("report-utils.js"))throw new Error(`Unexpected message: ${a}`);r[s]=t[a].message}return r}function yu(e){if(!a0(e))return!1;let{i18nId:t,values:n,formattedDefault:r}=e;if(typeof t!="string"||typeof r!="string")return!1;if(n!==void 0){if(!a0(n))return!1;for(let a of Object.values(n))if(typeof a!="string"&&typeof a!="number")return!1}return HN.test(t)}function Zs(e,t){if(yu(e))return xee(e,t);if(typeof e=="string")return e;throw new Error("Attempted to format invalid icuMessage type")}function Dee(e){let t="";for(let n of e)if(/^[a-z]+$/i.
test(n))t.length&&(t+="."),t+=n;else{if(/]|"|'|\s/.test(n))throw new Error(`Cannot handle "${n}" in i18n`);t+=`[${n}]`}return t}function s0(e,t){function n(a,o,s=[]){if(UN(a))for(let[c,u]of Object.entries(a)){let l=s.concat([c]);if(yu(u)){let m=Zs(u,t),p=o[u.i18nId]||[],f=Dee(l);p.push(u.values?{values:u.values,path:f}:f),a[c]=m,o[u.i18nId]=p}else n(u,o,l)}}i(n,"replaceInObject");let r={};return n(e,r),r}function VN(e){let t=o0[e];if(!t){if(e===gu)return{};throw new Error(`Unsupported locale '${e}'`)}return t}function $N(){return yee}function YN(){return[...new Set([...Object.keys(o0),gu])].sort()}function KN(e,t){o0[e]=t}function Eee(e){if(!HN.test(e))throw Error(`"${e}" does not appear to be a valid ICU message id`);let[t,n]=e.split(" | ");return{filename:t,key:n}}var mg,o0,gu,yee,HN,vee,Lo=g(()=>{"use strict";d();Ao();LN();Xs();jN();zN();mg={literal:0,argument:1,number:2,date:3,time:4,select:5,plural:6,pound:7,tag:8},o0=qN,gu="en-US",yee=["ar-XB.json","ar.json","bg.json","ca.json","\
cs.json","da.json","de.json","el.json","en-GB.json","en-US.json","en-XA.json","en-XL.json","es-419.json","es.json","fi.json","fil.json","fr.json","he.json","hi.json","hr.json","hu.json","id.json","it.json","ja.json","ko.json","lt.json","lv.json","nl.json","no.json","pl.json","pt-PT.json","pt.json","ro.json","ru.json","sk.json","sl.json","sr-Latn.json","sr.json","sv.json","ta.json","te.json","th.json","tr.json","uk.json","vi.json","zh-HK.json","zh-TW.json","zh.json"].filter(e=>e.endsWith(".json")&&!e.endsWith(".ctc.json")).map(e=>e.replace(".json","")).sort(),HN=/ | [^\s]+$/,vee={number:{bytes:{maximumFractionDigits:0},milliseconds:{maximumFractionDigits:0},seconds:{minimumFractionDigits:1,maximumFractionDigits:1},extendedPercent:{maximumFractionDigits:2,style:"percent"}}};i(WN,"collectAllCustomElementsFromICU");i(bee,"_preformatValues");i(wee,"escapeIcuMessage");i(i0,"formatMessage");i(xee,"_localizeIcuMessage");i(GN,"getRendererFormattedStrings");i(yu,"isIcuMessage");i(Zs,"getFormatte\
d");i(Dee,"_formatPathAsString");i(s0,"replaceIcuMessages");i(VN,"_getLocaleMessages");i($N,"getCanonicalLocales");i(YN,"getAvailableLocales");i(KN,"registerLocaleData");i(Eee,"getIcuMessageIdParts")});var XN=Ne((JFe,JN)=>{d();var Tee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><path fill="%230379c4" fill-rule="evenodd" d="m171.887 116.28-53.696 89.36h-9.728l9.617-58.227-30.2.047a4.852 4.852 0 0 1-4.855-4.855c0-1.152 1.07-3.102 1.07-3.102l53.52-89.254 9.9.043-9.86 58.317 30.413-.043a4.852 4.852 0 0 1 4.855 4.855c0 1.088-.427 2.044-1.033 2.854l.004.004zM128 0C57.306 0 0 57.3 0 128s57.306 128 128 128 128-57.306 128-128S198.7 0 128 0z"/></svg>',See={"modern-image-formats":"Consider displaying all [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) components in WebP formats while specifying an appropriate fallback for other browsers. [Learn more](https://amp.dev/documentation/components/amp-img/#example:-specifying-a-fallback-image).","offscreen-images":"Ensure that you are using [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) for images to automatically lazy-load. [Learn more](https://amp.de\
v/documentation/guides-and-tutorials/develop/media_iframes_3p/?format=websites#images).","render-blocking-resources":"Use tools such as [AMP Optimizer](https://github.com/ampproject/amp-toolbox/tree/master/packages/optimizer) to [server-side render AMP layouts](https://amp.dev/documentation/guides-and-tutorials/optimize-and-measure/server-side-rendering/).","unminified-css":"Refer to the [AMP documentation](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/style_pages/) to ensure all styles are supported.","efficient-animated-content":"For animated content, use [`amp-anim`](https://amp.dev/documentation/components/amp-anim/) to minimize CPU usage when the content is offscreen.","uses-responsive-images":"The [`amp-img`](https://amp.dev/documentation/components/amp-img/?format=websites) component supports the [`srcset`](https://web.dev/use-srcset-to-automatically-choose-the-right-image/) attribute to specify which image assets to use based on the screen size. [L\
earn more](https://amp.dev/documentation/guides-and-tutorials/develop/style_and_layout/art_direction/)."};JN.exports={id:"amp",title:"AMP",icon:Tee,UIStrings:See}});var QN=Ne((ZFe,ZN)=>{d();var Cee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 250 250"><path fill="%23dd0031" d="M125 30 31.9 63.2l14.2 123.1L125 230l78.9-43.7 14.2-123.1z"/><path fill="%23c3002f" d="M125 30v22.2-.1V230l78.9-43.7 14.2-123.1L125 30z"/><path fill="%23fff" d="M125 52.1 66.8 182.6h21.7l11.7-29.2h49.4l11.7 29.2H183L125 52.1zm17 83.3h-34l17-40.9 17 40.9z"/></svg>',kee={"total-byte-weight":"Apply [route-level code splitting](https://web.dev/route-level-code-splitting-in-angular/) to minimize the size of your JavaScript bundles. Also, consider precaching assets with the [Angular service worker](https://web.dev/precaching-with-the-angular-service-worker/).","unminified-warning":"If you are using Angular CLI, ensure that builds are generated in production mode. [Learn more](https://angular.io/guide/deployment#enable-runtime-production-mode).","unused-javascript":"If you are using Angular CLI, include source maps in your production build to inspect you\
r bundles. [Learn more](https://angular.io/guide/deployment#inspect-the-bundles).","uses-responsive-images":"Consider using the `BreakpointObserver` utility in the Component Dev Kit (CDK) to manage image breakpoints. [Learn more](https://material.angular.io/cdk/layout/overview).","uses-rel-preload":"Preload routes ahead of time to speed up navigation. [Learn more](https://web.dev/route-preloading-in-angular/).","dom-size":"Consider virtual scrolling with the Component Dev Kit (CDK) if very large lists are being rendered. [Learn more](https://web.dev/virtualize-lists-with-angular-cdk/)."};ZN.exports={id:"angular",title:"Angular",icon:Cee,UIStrings:kee}});var tP=Ne((eRe,eP)=>{d();var Iee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 186.525 243.713"><path fill="%23009cde" d="M131.64 51.91C114.491 34.769 98.13 18.429 93.26 0c-4.87 18.429-21.234 34.769-38.38 51.91C29.16 77.613 0 106.743 0 150.434a93.263 93.263 0 1 0 186.525 0c0-43.688-29.158-72.821-54.885-98.524m-92 120.256c-5.719-.194-26.824-36.571 12.329-75.303l25.909 28.3a2.215 2.215 0 0 1-.173 3.306c-6.183 6.34-32.534 32.765-35.81 41.902-.675 1.886-1.663 1.815-2.256 1.795m53.624 47.943a32.075 32.075 0 0 1-32.076-32.075 33.423 33.423 0 0 1 7.995-21.187c5.784-7.072 24.077-26.963 24.077-26.963s18.012 20.183 24.033 26.896a31.368 31.368 0 0 1 8.046 21.254 32.076 32.076 0 0 1-32.075 32.075m61.392-52.015c-.691 1.512-2.26 4.036-4.376 4.113-3.773.138-4.176-1.796-6.965-5.923-6.122-9.06-59.551-64.9-69.545-75.699-8.79-9.498-1.238-16.195 2.266-19.704 4.395-4.403 17.224-17.225 17.224-17.225s38.255 36.296 54.19 61.096 10.444 46.26 7.206 53.342"/></svg>',Aee={"unused-css-ru\
les":"Consider removing unused CSS rules and only attach the needed `Drupal` libraries to the relevant page or component in a page. See the [`Drupal` documentation](https://www.drupal.org/docs/develop/theming-drupal/adding-assets-css-js-to-a-drupal-theme-via-librariesyml#define) for details. To identify attached libraries that are adding extraneous CSS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the stylesheet when CSS aggregation is disabled in your `Drupal` site. Look out for themes/modules that have many stylesheets in the list which have a lot of red in code coverage. A theme/module should only attach a stylesheet library if it is actually used on the page.","modern-image-formats":"Consider configuring [WebP image formats with a Convert image style](https://www.drupal.org/docs/core-modules-and-themes/core-modules/image-module/working-with-images#styles) on your si\
te.","offscreen-images":"Consider configuring lazy load images in `Drupal`. The field formatters for images support `lazy` or `eager`.","total-byte-weight":"Consider using [Responsive Image Styles](https://www.drupal.org/documentation/modules/responsive_image) to reduce the size of images loaded on your page. If you are using `Views` to show multiple content items on a page, consider implementing pagination to limit the number of content items shown on a given page.","render-blocking-resources":"Consider using [a module](https://www.drupal.org/project/critical_css) to inline critical CSS and JavaScript, and use the defer attribute for non-critical CSS or JavaScript.","unminified-css":'Ensure you have enabled "Aggregate CSS files" in the "Administration » Configuration » Development" page.',"unminified-javascript":'Ensure you have enabled "Aggregate JavaScript files" in the "Administration » Configuration » Development" page.',"efficient-animated-content":"Consider uploading your `G\
IF` to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider removing unused JavaScript assets and only attach the needed `Drupal` libraries to the relevant page or component in a page. See the [Drupal documentation](https://www.drupal.org/docs/develop/theming-drupal/adding-assets-css-js-to-a-drupal-theme-via-librariesyml#define) for details. To identify attached libraries that are adding extraneous JavaScript, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage) in Chrome DevTools. You can identify the theme/module responsible from the URL of the script when JavaScript aggregation is disabled in your `Drupal` site. Look out for themes/modules that have many scripts in the list which have a lot of red in code coverage. A theme/module should only attach a script library if it is actually used on the page.","uses-long-cache-ttl":'Set the "Browser and proxy cache maximum age" in the "Administration » Configuration » D\
evelopment" page. Read about [`Drupal` cache and optimizing for performance](https://www.drupal.org/docs/8/api/cache-api/cache-api).',"uses-optimized-images":"Consider using [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=im_vid_3%3A123&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=image&solrsort=iss_project_release_usage+desc&op=Search) that automatically optimizes and reduces the size of images uploaded through the site while retaining quality. Also, ensure you are using the native [Responsive Image Styles](https://www.drupal.org/documentation/modules/responsive_image) provided from `Drupal` for all images rendered on the site.","uses-text-compression":"Text-based resources should be served with compression (gzip, deflate or brotli) to minimize total network bytes. Consider using a CDN that natively supports this, or configure the web server to perform this operation. [Learn more](https://developers.google.com/web/tools\
/lighthouse/audits/text-compression).","uses-responsive-images":"Ensure that you are using the native [Responsive Image Styles](https://www.drupal.org/documentation/modules/responsive_image) provided from `Drupal`. Use the Responsive Image Styles when rendering image fields through view modes, views, or images uploaded through the WYSIWYG editor.","prioritize-lcp-image":"If the LCP element is dynamically added to the page, you should optimize the image in order to improve LCP. [Learn more](https://www.smashingmagazine.com/2023/08/methods-improving-drupal-largest-contentful-paint-core-web-vital/).","server-response-time":"Offload traffic with one or more `Drupal` caching modules such as `Internal Page Cache`, `Internal Dynamic Page Cache`, and `BigPipe`. Couple these with a CDN to further improve response time. Your hosting servers should make use of PHP OPcache. Consider using memory-caching such as Redis or Memcached to reduce database query times. Lastly use performant themes, module\
s, and faster servers to lower server response time.",redirects:"Redirects introduce additional delays before the page can be loaded. If the [Redirect](https://www.drupal.org/project/redirect) module is installed, review if unnecessary redirects can be removed. [Learn more](https://developers.google.com/web/tools/lighthouse/audits/redirects).","uses-rel-preconnect":"`Preconnect` or `dns-prefetch` resource hints can be added by installing and configuring [a module](https://www.drupal.org/project/project_module?f%5B0%5D=&f%5B1%5D=&f%5B2%5D=&f%5B3%5D=&f%5B4%5D=sm_field_project_type%3Afull&f%5B5%5D=&f%5B6%5D=&text=Preconnect&solrsort=score+desc&op=Search) that provides facilities for user agent resource hints."};eP.exports={id:"drupal",title:"Drupal",icon:Iee,UIStrings:Aee}});var rP=Ne((nRe,nP)=>{d();var Fee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 82 82"><path fill="%235FA624" fill-rule="evenodd" d="M81.37 48.117C85.301 25.821 70.413 4.56 48.117.63 25.821-3.3 4.56 11.586.63 33.883-3.3 56.178 11.586 77.44 33.883 81.37 56.18 85.301 77.44 70.412 81.37 48.117Zm-8.935-14.17c2.77 12.357-1.942 25.721-12.96 33.436-14.57 10.203-34.656 6.662-44.859-7.909a32.434 32.434 0 0 1-2.869-4.98l28.7-20.097a6.53 6.53 0 1 0-3.744-5.347L9.564 48.054c-2.768-12.359 1.943-25.724 12.96-33.439 14.572-10.203 34.656-6.662 44.86 7.91a32.349 32.349 0 0 1 2.868 4.98L41.554 47.6a6.53 6.53 0 1 0 3.746 5.35l27.136-19.003Z"/></svg>',Ree={"unused-css-rules":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Remove Unused CSS` to help with this issue. It will identify the CSS classes that are actually used on each page of your site, and remove any others to keep the file size small.","modern-image-formats":"Use [Ezoic Leap](https://pubdash.ezoic.com/s\
peed) and enable `Next-Gen Formats` to convert images to WebP.","offscreen-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Lazy Load Images` to defer loading off-screen images until they are needed.","render-blocking-resources":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Critical CSS` and `Script Delay` to defer non-critical JS/CSS.","unminified-css":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify CSS` to automatically minify your CSS to reduce network payload sizes.","unminified-javascript":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Minify Javascript` to automatically minify your JS to reduce network payload sizes.","uses-long-cache-ttl":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Efficient Static Cache Policy` to set recommended values in the caching header for static assests.","uses-optimized-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Next-Gen Formats` t\
o convert images to WebP.","uses-responsive-images":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Resize Images` to resize images to a device appropriate size, reducing network payload sizes.","server-response-time":"Use [Ezoic Cloud Caching](https://pubdash.ezoic.com/speed/caching) to cache your content across our world wide network, improving time to first byte.","uses-rel-preconnect":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Pre-Connect Origins` to automatically add `preconnect` resource hints to establish early connections to important third-party origins.","uses-rel-preload":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Preload Fonts` and `Preload Background Images` to add `preload` links to prioritize fetching resources that are currently requested later in page load.","font-display":"Use [Ezoic Leap](https://pubdash.ezoic.com/speed) and enable `Optimize Fonts` to automatically leverage the `font-display` CSS feature to ensur\
e text is user-visible while webfonts are loading."};nP.exports={id:"ezoic",title:"Ezoic",icon:Fee,UIStrings:Ree}});var oP=Ne((aRe,aP)=>{d();var _ee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 28"><circle cx="14" cy="14" r="14" fill="%23639"/><path fill="%23fff" d="M6.2 21.8C4.1 19.7 3 16.9 3 14.2L13.9 25c-2.8-.1-5.6-1.1-7.7-3.2zm10.2 2.9L3.3 11.6C4.4 6.7 8.8 3 14 3c3.7 0 6.9 1.8 8.9 4.5l-1.5 1.3C19.7 6.5 17 5 14 5c-3.9 0-7.2 2.5-8.5 6L17 22.5c2.9-1 5.1-3.5 5.8-6.5H18v-2h7c0 5.2-3.7 9.6-8.6 10.7z"/></svg>',Mee={"unused-css-rules":"Use the `PurgeCSS` `Gatsby` plugin to remove unused rules from stylesheets. [Learn more](https://purgecss.com/plugins/gatsby.html).","modern-image-formats":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically optimize image format. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","offscreen-images":"Use the `gatsby-plugin-image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-p\
lugin-image).","render-blocking-resources":"Use the `Gatsby Script API` to defer loading of non-critical third-party scripts. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-script/).","unused-javascript":"Use `Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://www.gatsbyjs.com/plugins/gatsby-plugin-webpack-bundle-analyser-v2/)","uses-long-cache-ttl":"Configure caching for immutable assets. [Learn more](https://www.gatsbyjs.com/docs/how-to/previews-deploys-hosting/caching/).","uses-optimized-images":"Use the `gatsby-plugin-image` component instead of `<img>` to adjust image quality. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","uses-responsive-images":"Use the `gatsby-plugin-image` component to set appropriate `sizes`. [Learn more](https://www.gatsbyjs.com/docs/how-to/images-and-media/using-gatsby-plugin-image).","prioritize-lcp-image":"Use the `gatsby-plugin-image` component\
 and set the `loading` prop to `eager`. [Learn more](https://www.gatsbyjs.com/docs/reference/built-in-components/gatsby-plugin-image#shared-props)."};aP.exports={id:"gatsby",title:"Gatsby",icon:_ee,UIStrings:Mee}});var sP=Ne((iRe,iP)=>{"use strict";d();var Oee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid" viewBox="0 0 256 258"><path fill="%23F9AE41" d="M255.7 35.6a33.7 33.7 0 0 0-67-4.8l-.4-.2c-27.6-12.4-50.8 9.6-50.8 9.6l-61.4 61.7 24.3 23.4 49.4-48.6c23-23 35.6-7.4 35.6-7.4 17.4 14.6.6 32 .6 32l24.9 24c20.3-22 21.5-41.1 15.3-56.3a33.7 33.7 0 0 0 29.5-33.4"/><path fill="%23EE4035" d="m226.5 190.5.2-.3c12.4-27.6-9.6-50.8-9.6-50.8L155.4 78l-23.3 24.3 48.5 49.4c23 23 7.5 35.6 7.5 35.6-14.7 17.4-32 .6-32 .6l-24 24.9c21.9 20.3 41 21.5 56.2 15.3a33.7 33.7 0 1 0 38.2-37.6"/><path fill="%234F91CD" d="m156 133-49.5 48.6c-23 23-35.6 7.4-35.6 7.4-17.4-14.6-.6-32-.6-32l-24.9-24c-20.3 22-21.4 41.1-15.3 56.3a33.7 33.7 0 1 0 37.6 38.2l.3.2c27.6 12.4 50.8-9.6 50.8-9.6l61.4-61.7-24.3-23.4"/><path fill="%237AC043" d="M75.7 106.6c-23-23-7.4-35.6-7.4-35.6 14.6-17.4 32-.6 32-.6l24-24.9c-22-20.3-41-21.5-56.3-15.3a33.7 33.7 0 1 0-38.2 37.6l-.2.3C17.2 95.7 39.2 119 39.2 119l\
61.7 61.4 23.4-24.3-48.6-49.4"/></svg>',Nee={"unused-css-rules":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused CSS in your page. To identify extensions that are adding extraneous CSS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using a [plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=webp) or service that will automatically convert your uploaded images to the optimal formats.","offscreen-images":"Install a [lazy-load Joomla plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=lazy%20loading) that prov\
ides the ability to defer any offscreen images, or switch to a template that provides that functionality. Starting with Joomla 4.0, all new images will [automatically](https://github.com/joomla/joomla-cms/pull/30748) get the `loading` attribute from the core.","total-byte-weight":"Consider showing excerpts in your article categories (e.g. via the read more link), reducing the number of articles shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of Joomla plugins that can help you [inline critical assets](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) or [defer less important resources](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance). Beware that optimizations provided by these plugins may break features of your templates or plugins, so you will need to test these thoroughly.","unminified-css":"A number of [Joomla exte\
nsions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your css styles. There are also templates that provide this functionality.","unminified-javascript":"A number of [Joomla extensions](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) can speed up your site by concatenating, minifying, and compressing your scripts. There are also templates that provide this functionality.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [Joomla extensions](https://extensions.joomla.org/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. You can identify the \
extension responsible from the URL of the script. Look out for extensions that have many scripts in the list which have a lot of red in code coverage. An extension should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in Joomla](https://docs.joomla.org/Cache).","uses-optimized-images":"Consider using an [image optimization plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=performance) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression by enabling Gzip Page Compression in Joomla (System > Global configuration > Server).","uses-responsive-images":"Consider using a [responsive images plugin](https://extensions.joomla.org/instant-search/?jed_live%5Bquery%5D=responsive%20images) to use responsive images in your content.","server-response-time":"Templates, extensions, and server specifications all contribute to server response time. Consider findi\
ng a more optimized template, carefully selecting an optimization extension, and/or upgrading your server."};iP.exports={id:"joomla",title:"Joomla",icon:Oee,UIStrings:Nee}});var uP=Ne((cRe,cP)=>{d();var Pee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="%23f26322" viewBox="0 0 1000 1000"><path d="M916.9 267.4v465.3l-111.3 67.4V331.4l-1.5-.9-303.9-189-304.6 189.2-1.2.8V799L83.1 732.6V267.4l.7-.4L500.3 10l416 257 .6.4zM560.7 468.5v383.3L500.3 890l-61-38.2V306.7l-136 84.3v476.6l197 122.5 196.4-122.5V391l-136-84.3v161.8z"/></svg>',Lee={"modern-image-formats":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=webp) for a variety of third-party extensions to leverage newer image formats.","offscreen-images":"Consider modifying your product and catalog templates to make use of the web platform's [lazy loading](https://web.dev/native-lazy-loading) feature.","disable-bundling":"Disable Magento's built-in [JavaScript bundling and minification](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html), and consider using [baler](https://github.com/magento/baler/) instead.",
"unminified-css":`Enable the "Minify CSS Files" option in your store's Developer settings. [Learn more](https://devdocs.magento.com/guides/v2.3/performance-best-practices/configuration.html?itm_source=devdocs&itm_medium=search_page&itm_campaign=federated_search&itm_term=minify%20css%20files).`,"unminified-javascript":"Use [Terser](https://www.npmjs.com/package/terser) to minify all JavaScript assets from static content deployment, and disable the built-in minification feature.","unused-javascript":"Disable Magento's built-in [JavaScript bundling](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/themes/js-bundling.html).","uses-optimized-images":"Consider searching the [Magento Marketplace](https://marketplace.magento.com/catalogsearch/result/?q=optimize%20image) for a variety of third party extensions to optimize images.","server-response-time":"Use Magento's [Varnish integration](https://devdocs.magento.com/guides/v2.3/config-guide/varnish/config-varnish.html).","uses-rel-pr\
econnect":"Preconnect or dns-prefetch resource hints can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","uses-rel-preload":"`<link rel=preload>` tags can be added by [modifying a themes's layout](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/layouts/xml-manage.html).","critical-request-chains":"If you are not bundling your JavaScript assets, consider using [baler](https://github.com/magento/baler).","font-display":"Specify `@font-display` when [defining custom fonts](https://devdocs.magento.com/guides/v2.3/frontend-dev-guide/css-topics/using-fonts.html)."};cP.exports={id:"magento",title:"Magento",icon:Pee,UIStrings:Lee}});var dP=Ne((lRe,lP)=>{d();var Bee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 207 124"><path fill="%23000" d="M48.942 32.632h38.96v3.082h-35.39v23.193H85.79v3.082H52.513v25.464h35.794v3.081H48.942V32.632Zm42.45 0h4.139l18.343 25.464 18.749-25.464L158.124.287l-41.896 60.485 21.59 29.762h-4.302l-19.642-27.086L94.15 90.534h-4.22l21.751-29.762-20.29-28.14Zm47.967 3.082v-3.082h44.397v3.082h-20.453v54.82h-3.571v-54.82h-20.373ZM.203 32.632h4.464l61.557 91.671-25.439-33.769L3.936 37.011l-.162 53.523H.203zm183.194 53.891c.738 0 1.276-.563 1.276-1.29 0-.727-.538-1.29-1.276-1.29-.73 0-1.277.563-1.277 1.29 0 .727.547 1.29 1.277 1.29Zm3.509-3.393c0 2.146 1.555 3.549 3.822 3.549 2.414 0 3.874-1.446 3.874-3.956v-8.837h-1.946v8.828c0 1.394-.704 2.138-1.946 2.138-1.112 0-1.867-.692-1.893-1.722h-1.911Zm10.24-.113c.14 2.233 2.007 3.662 4.787 3.662 2.97 0 4.83-1.498 4.83-3.887 0-1.878-1.06-2.917-3.632-3.514l-1.38-.338c-1.634-.38-2.294-.891-2.294-1.783 0-1.125 1.025-1.86 2.563-1\
.86 1.459 0 2.466.718 2.649 1.869h1.893c-.113-2.103-1.971-3.583-4.516-3.583-2.737 0-4.56 1.48-4.56 3.704 0 1.835 1.033 2.926 3.3 3.454l1.616.39c1.659.389 2.388.96 2.388 1.912 0 1.108-1.146 1.913-2.71 1.913-1.676 0-2.84-.753-3.005-1.939h-1.928Z"/></svg>',Uee={"unused-css-rules":"Consider setting up `PurgeCSS` in `Next.js` configuration to remove unused rules from stylesheets. [Learn more](https://purgecss.com/guides/next.html).","modern-image-formats":"Use the `next/image` component instead of `<img>` to automatically optimize image format. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","offscreen-images":"Use the `next/image` component instead of `<img>` to automatically lazy-load images. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","render-blocking-resources":"Use the `next/script` component to defer loading of non-critical third-party scripts. [Learn more](https://nextjs.org/docs/basic-features/script).","unused-javascript":"Use\
 `Webpack Bundle Analyzer` to detect unused JavaScript code. [Learn more](https://github.com/vercel/next.js/tree/canary/packages/next-bundle-analyzer)","uses-long-cache-ttl":"Configure caching for immutable assets and `Server-side Rendered` (SSR) pages. [Learn more](https://nextjs.org/docs/going-to-production#caching).","uses-optimized-images":"Use the `next/image` component instead of `<img>` to adjust image quality. [Learn more](https://nextjs.org/docs/basic-features/image-optimization).","uses-text-compression":"Enable compression on your Next.js server. [Learn more](https://nextjs.org/docs/api-reference/next.config.js/compression).","uses-responsive-images":"Use the `next/image` component to set the appropriate `sizes`. [Learn more](https://nextjs.org/docs/api-reference/next/image#sizes).","user-timings":"Consider using `Next.js Analytics` to measure your app's real-world performance. [Learn more](https://nextjs.org/docs/advanced-features/measuring-performance).","prioritize-lcp-im\
age":'Use the `next/image` component and set "priority" to true to preload LCP image. [Learn more](https://nextjs.org/docs/api-reference/next/image#priority).',"unsized-images":"Use the `next/image` component to make sure images are always sized appropriately. [Learn more](https://nextjs.org/docs/api-reference/next/image#width)."};lP.exports={id:"next.js",title:"Next.js",icon:Bee,UIStrings:Uee}});var pP=Ne((mRe,mP)=>{d();var jee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="142" height="54"><g fill="none" fill-rule="evenodd"><g fill="%231B004E"><path d="M19.486 53.24h-3.891L4.682 39.247v13.936H0V32.946h5.444l9.475 12.398V32.946h4.567zM21.346 32.94h4.647v3.57h-4.647v-3.57Zm0 5.477h4.647V53.18h-4.647V38.417ZM40.569 53.183H36c-3.408 0-4.991-1.625-4.991-4.697v-6.22h-3.777V38.42h3.777v-5.474h4.598v5.474h4.958v3.846h-4.958v4.588c0 1.597.477 2.252 2.197 2.252h2.764v4.077ZM46.688 53.183h-4.57V38.42h4.57v2.308c.31-.686 1.351-2.336 4.425-2.336h3.13v4.56h-4.004c-2.593 0-3.55.967-3.55 3.019v7.212ZM70.612 45.802c0 4.56-3.409 7.75-8.01 7.75s-8.006-3.19-8.006-7.75c0-4.56 3.408-7.755 8.006-7.755 4.598 0 8.01 3.195 8.01 7.755Zm-4.599 0c0-2.14-1.35-3.733-3.408-3.733-2.057 0-3.44 1.594-3.44 3.733 0 2.139 1.41 3.733 3.44 3.733 2.03 0 3.408-1.598 3.408-3.733ZM72.47 32.946h11.7c4.543 0 7.192 2.28 7.192 6.526 0 4.247-2.649 6.577-7.191 6.577h-6.935v7.125h-4.765V32.946Zm4.766 4.218\
v4.676h6.485c1.832 0 2.736-.883 2.736-2.34 0-1.565-.904-2.336-2.736-2.336h-6.485ZM102.662 51.016c-.254.485-1.636 2.48-4.71 2.48-3.665 0-6.627-2.906-6.627-7.694 0-4.789 2.962-7.667 6.656-7.667 2.962 0 4.372 1.851 4.626 2.336v-2.05h4.567v14.762h-4.512v-2.167Zm-3.327-8.932c-2.03 0-3.384 1.594-3.384 3.733 0 2.14 1.354 3.733 3.384 3.733s3.327-1.597 3.327-3.733-1.298-3.733-3.327-3.733ZM119.184 43.578a2.98 2.98 0 0 0-2.749-1.494c-1.918 0-3.13 1.594-3.13 3.733 0 2.14 1.24 3.758 3.158 3.758 1.807 0 2.625-1.168 2.764-1.51h4.4c-.143 2.052-2.116 5.5-7.275 5.5-4.286 0-7.641-3.078-7.641-7.75 0-4.673 3.328-7.755 7.585-7.755 5.159 0 7.105 3.392 7.33 5.53l-4.442-.012ZM129.712 46.6v6.577h-4.567V32.194h4.567v11.998l5.838-5.784h5.751l-6.994 6.811 7.362 7.952h-5.921z"/></g><g fill="%2325F5CE"><path d="M49.159 4.65c12.832 0 23.235 10.41 23.235 23.251h4.648C77.042 12.491 64.558 0 49.159 0c-15.4 0-27.883 12.492-27.883 27.901h4.647c0-12.841 10.403-23.25 23.236-23.25Z"/><path d="M44.852 25.793a3.632 3.632 0 0 1\
 2.6-5.097L63.8 16.951 50.426 27.09a3.626 3.626 0 0 1-5.574-1.296Z"/></g></g></svg>',qee={"unused-css-rules":"Enable [`Reduce Unused CSS`](https://support.nitropack.io/hc/en-us/articles/360020418457-Reduce-Unused-CSS) to remove CSS rules that are not applicable to this page.","modern-image-formats":"Use [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/16547237162513) to automatically convert your images to WebP.","offscreen-images":"Defer offscreen images by enabling [`Automatic Image Lazy Loading`](https://support.nitropack.io/hc/en-us/articles/12457493524369-NitroPack-Lazy-Loading-Feature-for-Images).","render-blocking-resources":"Enable [`Remove render-blocking resources`](https://support.nitropack.io/hc/en-us/articles/13820893500049-How-to-Deal-with-Render-Blocking-Resources-in-NitroPack) in NitroPack for faster initial load times.","unminified-css":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in you\
r Caching settings to reduce the size of your CSS, HTML, and JavaScript files for faster load times.","unminified-javascript":"Enable [`Minify resources`](https://support.nitropack.io/hc/en-us/articles/360061059394-Minify-Resources) in your Caching settings to reduce the size of your JS, HTML, and CSS files for faster load times.","unused-javascript":"Configure [`Delayed Scripts`](https://support.nitropack.io/hc/en-us/articles/1500002600942-Delayed-Scripts) in NitroPack to delay loading of scripts until they are needed.","uses-long-cache-ttl":"Go to the [`Improve Server Response Time`](https://support.nitropack.io/hc/en-us/articles/1500002321821-Improve-Server-Response-Time) feature in the `Caching` menu and adjust your page cache expiration time to improve loading times and user experience.","uses-optimized-images":"Automatically compress, optimize, and convert your images into WebP by enabling the [`Image Optimization`](https://support.nitropack.io/hc/en-us/articles/14177271695121-Ho\
w-to-serve-images-in-next-gen-formats-using-NitroPack) setting.","uses-text-compression":"Use [`Gzip compression`](https://support.nitropack.io/hc/en-us/articles/13229297479313-Enabling-GZIP-compression) in NitroPack to reduce the size of the files that are sent to the browser.","uses-responsive-images":"Enable [`Adaptive Image Sizing`](https://support.nitropack.io/hc/en-us/articles/10123833029905-How-to-Enable-Adaptive-Image-Sizing-For-Your-Site) to preemptively optimize your images and make them match the dimensions of the containers they’re displayed in across all devices.","dom-size":"Contact your account manager to enable [`HTML Lazy Load`](https://support.nitropack.io/hc/en-us/articles/17144942904337). Configuring it will prioritize and optimize your page rendering performance.","font-display":"Use the [`Override Font Rendering Behavior`](https://support.nitropack.io/hc/en-us/articles/16547358865041) option in NitroPack to set a desired value for the CSS font-display rule."};mP.
exports={id:"nitropack",title:"NitroPack",icon:jee,UIStrings:qee}});var hP=Ne((fRe,fP)=>{d();var zee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 512 512"><path fill="%2300DC82" d="M281.44 397.667h156.88c5.006 0 9.798-1.759 14.133-4.244.336-2.481 8.805-5.596 11.307-9.894 2.502-4.297 4.242-9.173 4.24-14.134-.002-4.962-1.734-9.836-4.24-14.131l-106-182.321c-2.502-4.297-5.559-7.413-9.893-9.894-4.335-2.48-10.542-4.24-15.547-4.24-5.005 0-9.799 1.76-14.133 4.24-4.335 2.481-7.392 5.597-9.894 9.894l-26.853 46.64-53.707-90.457c-2.504-4.296-5.557-8.823-9.893-11.303-4.336-2.481-9.127-2.827-14.133-2.827-5.006 0-9.798.346-14.134 2.827-4.335 2.48-8.802 7.007-11.306 11.303L46.827 355.268c-2.506 4.295-2.8259.169-2.827 14.131-.002 4.961.325 9.836 2.827 14.134 2.502 4.297 6.97 7.413 11.306 9.894 4.336 2.481 9.127 4.24 14.134 4.24H171.2c39.201 0 67.734-17.585 87.627-50.88L306.88 263.4l25.44-43.813 77.733 132.853H306.88l-25.44 45.227ZM169.787 352.44h-69.254l103.174-178.08L256 263.4l-34.639 60.384c-13.21 21.603-28.272 28.656-51.574 28\
.656Z"/></svg>',Hee={"modern-image-formats":'Use the `nuxt/image` component and set `format="webp"`. [Learn more](https://image.nuxt.com/usage/nuxt-img#format).',"offscreen-images":'Use the `nuxt/image` component and set `loading="lazy"` for offscreen images. [Learn more](https://image.nuxt.com/usage/nuxt-img#loading).',"uses-optimized-images":"Use the `nuxt/image` component and set the appropriate `quality`. [Learn more](https://image.nuxt.com/usage/nuxt-img#quality).","uses-responsive-images":"Use the `nuxt/image` component and set the appropriate `sizes`. [Learn more](https://image.nuxt.com/usage/nuxt-img#sizes).","prioritize-lcp-image":"Use the `nuxt/image` component and specify `preload` for LCP image. [Learn more](https://image.nuxt.com/usage/nuxt-img#preload).","unsized-images":"Use the `nuxt/image` component and specify explicit `width` and `height`. [Learn more](https://image.nuxt.com/usage/nuxt-img#width-height)."};fP.exports={id:"nuxt",title:"Nuxt",icon:zee,UIStrings:Hee}});var yP=Ne((gRe,gP)=>{d();var Wee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 310 310"><path fill="none" d="M-1-1h802v602H-1z"/><path fill="%23de6c26" d="M135 6.9c-14.2 4.4-34.9 21.8-49.9 42C55.8 88.5 39.6 135.8 41.4 177c.8 20.2 4.9 35.5 14.4 54.5 13.6 27.4 40.8 55.1 65.5 66.9 14.1 6.7 13.4 6.9 14.1-2.8.3-4.4 1-32.4 1.6-62.1 2.7-137.3 4.4-176 8.2-191.3.6-2.3 1.4-4.2 1.9-4.2 1.2 0 3.6 9.1 4.9 18.3.5 4.3 1 17.7 1 29.8 0 12 .3 21.9.7 21.9.3 0 5.7-5 11.9-11 6.9-6.8 12-11 13.3-11 1.8 0 1.9.3 1 2.7-1.2 3.1-7.9 13.2-19.1 28.5L153 128l.1 31.2c.1 17.2.4 37.4.8 44.9l.6 13.7 11-12.6c14-16 35.1-37.1 39.5-39.6l3.3-1.9-.6 3.2c-2 9.8-9.5 20.7-37.4 54.3L154 240.8v31.1c0 18.3.4 31.1.9 31.1 2.8 0 19.3-6.4 26.8-10.5 13.8-7.3 23.8-15 38.3-29.5 15.7-15.7 24.4-27.4 33.4-45.2 20.5-40 21-80.3 1.6-119-17.8-35.6-54.6-72.1-87.8-86.9-11.7-5.3-24.6-7.3-32.2-5z"/></svg>',Gee={"unused-css-rules":"Consider reviewing the [plugins](https://octobercms.com/plugins) loading unused CSS on the we\
bsite. To identify plugins that add unnecessary CSS, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the stylesheet URL. Look for plugins with many stylesheets with lots of red in code coverage. A plugin should only add a stylesheet if it is actually used on the web page.","modern-image-formats":"Consider using a [plugin](https://octobercms.com/plugins?search=image) or service that will automatically convert the uploaded images to the optimal formats. [WebP lossless images](https://developers.google.com/speed/webp) are 26% smaller in size compared to PNGs and 25-34% smaller than comparable JPEG images at the equivalent SSIM quality index. Another next-gen image format to consider is [AVIF](https://jakearchibald.com/2020/avif-has-landed/).","offscreen-images":"Consider installing an [image lazy loading plugin](https://octobercms.com/plugins?search=lazy) that provides the\
 ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://octobercms.com/plugins?search=Accelerated+Mobile+Pages).","total-byte-weight":"Consider showing excerpts in the post lists (e.g. using a `show more` button), reducing the number of posts shown on a given web page, breaking long posts into multiple web pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are many plugins that help [inline critical assets](https://octobercms.com/plugins?search=css). These plugins may break other plugins, so you should test thoroughly.","unminified-css":"There are many [plugins](https://octobercms.com/plugins?search=css) that can speed up a website by concatenating, minifying and compressing the styles. Using a build process to do this minification up-front can speed up development.","unminified-javascript":"There are many [plugins](https://octobercms.com/plugins?search=javascript) that \
can speed up a website by concatenating, minifying and compressing the scripts. Using a build process to do this minification up-front can speed up development.","efficient-animated-content":"[Replace animated GIFs with video](https://web.dev/replace-gifs-with-videos/) for faster web page loads and consider using modern file formats such as [WebM](https://web.dev/replace-gifs-with-videos/#create-webm-videos) or [AV1](https://developers.google.com/web/updates/2018/09/chrome-70-media-updates#av1-decoder) to improve compression efficiency by greater than 30% over the current state-of-the-art video codec, VP9.","unused-javascript":"Consider reviewing the [plugins](https://octobercms.com/plugins?search=javascript) that load unused JavaScript in the web page. To identify plugins that add unnecessary JavaScript, run [code coverage](https://developers.google.com/web/updates/2017/04/devtools-release-notes#coverage) in Chrome DevTools. Identify the theme/plugin responsible from the URL of the sc\
ript. Look for plugins with many scripts with lots of red in code coverage. A plugin should only add a script if it is actually used on the web page.","uses-long-cache-ttl":"Read about [preventing unnecessary network requests with the HTTP Cache](https://web.dev/http-cache/#caching-checklist). There are many [plugins](https://octobercms.com/plugins?search=Caching) that can be used to speed up caching.","uses-optimized-images":"Consider using an [image optimization plugin](https://octobercms.com/plugins?search=image) to compresses images while retaining the quality.","uses-text-compression":"Enable text compression in the web server configuration.","uses-responsive-images":"Upload images directly in the media manager to ensure the required image sizes are available. Consider using the [resize filter](https://octobercms.com/docs/markup/filter-resize) or an [image resizing plugin](https://octobercms.com/plugins?search=image) to ensure the optimal image sizes are used.","server-response-ti\
me":"Themes, plugins and server specifications all contribute to the server response time. Consider finding a more optimized theme, carefully selecting an optimization plugin and/or upgrade the server. October CMS also allows developers to use [`Queues`](https://octobercms.com/docs/services/queues) to defer the processing of a time consuming task, such as sending an e-mail. This drastically speeds up web requests."};gP.exports={id:"octobercms",title:"October CMS",icon:Wee,UIStrings:Gee}});var bP=Ne((vRe,vP)=>{d();var Vee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 841.9 595.3"><g fill="%2361DAFB"><path d="M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3zm-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6\
-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9zm-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9zm32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1zM421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32zm-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24 4.7 8 9.5 15.8 14.4 23.4zM420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32zm-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9zm-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6 0-15.7 22.9-35.6 58.3-50.6 8.6-3.7 18-7 2\
7.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2zM310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7zm237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1zm38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6zM320.8 78.4z"/><circle cx="420.9" cy="296.5" r="45.7"/><path d="M520.5 78.1z"/></g></svg>',$ee={"unminified-css":"If your build system minifies CSS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unmin\
ified-javascript":"If your build system minifies JS files automatically, ensure that you are deploying the production build of your application. You can check this with the React Developer Tools extension. [Learn more](https://reactjs.org/docs/optimizing-performance.html#use-the-production-build).","unused-javascript":"If you are not server-side rendering, [split your JavaScript bundles](https://web.dev/code-splitting-suspense/) with `React.lazy()`. Otherwise, code-split using a third-party library such as [loadable-components](https://www.smooth-code.com/open-source/loadable-components/docs/getting-started/).","server-response-time":"If you are server-side rendering any React components, consider using `renderToPipeableStream()` or `renderToStaticNodeStream()` to allow the client to receive and hydrate different parts of the markup instead of all at once. [Learn more](https://reactjs.org/docs/react-dom-server.html#renderToPipeableStream).",redirects:"If you are using React Router, min\
imize usage of the `<Redirect>` component for [route navigations](https://reacttraining.com/react-router/web/api/Redirect).","user-timings":"Use the React DevTools Profiler, which makes use of the Profiler API, to measure the rendering performance of your components. [Learn more.](https://reactjs.org/blog/2018/09/10/introducing-the-react-profiler.html)","dom-size":'Consider using a "windowing" library like `react-window` to minimize the number of DOM nodes created if you are rendering many repeated elements on the page. [Learn more](https://web.dev/virtualize-long-lists-react-window/). Also, minimize unnecessary re-renders using [`shouldComponentUpdate`](https://reactjs.org/docs/optimizing-performance.html#shouldcomponentupdate-in-action), [`PureComponent`](https://reactjs.org/docs/react-api.html#reactpurecomponent), or [`React.memo`](https://reactjs.org/docs/react-api.html#reactmemo) and [skip effects](https://reactjs.org/docs/hooks-effect.html#tip-optimizing-performance-by-skipping-e\
ffects) only until certain dependencies have changed if you are using the `Effect` hook to improve runtime performance.'};vP.exports={id:"react",title:"React",icon:Vee,UIStrings:$ee}});var xP=Ne((wRe,wP)=>{d();var Yee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 71 28"><path fill-rule="evenodd" d="M0 .032s2.796-.356 4.66 1.31C5.81 2.37 6.145 4.008 6.145 4.008L9.952 18.96l3.165-12.239c.309-1.301.864-2.909 1.743-3.997 1.121-1.385 3.398-1.472 3.641-1.472.242 0 2.519.087 3.639 1.472.88 1.088 1.435 2.696 1.744 3.997l3.165 12.239 3.806-14.953s.336-1.638 1.486-2.666C34.205-.324 37 .032 37 .032l-7.289 27.945s-2.404.176-3.607-.446c-1.58-.816-2.332-1.447-3.289-5.249l-.099-.395c-.349-1.399-.883-3.59-1.424-5.813l-.162-.667-.162-.664c-.779-3.198-1.497-6.143-1.612-6.517-.108-.351-.236-1.187-.855-1.187-.607 0-.746.837-.857 1.187-.13.412-.99 3.955-1.856 7.514l-.162.667c-.512 2.107-1.01 4.151-1.341 5.48l-.1.395c-.956 3.802-1.708 4.433-3.288 5.249-1.204.622-3.608.446-3.608.446zM43.998 5v.995L44 5.994v16.628c-.014 3.413-.373 4.17-1.933 4.956-1.213.61-3.067.379-3.067.379V9.332c0-.935.315-1.548 1.477-2.098.693-.329 1.34-.58 2.012-.953C43.54 5.703 43.998 5 43.9\
98 5zM46 .125s3.877-.673 5.797 1.107c1.228 1.14 2.602 3.19 2.602 3.19l3.38 4.965c.164.258.378.54.72.54.343 0 .558-.282.722-.54l3.38-4.965s1.374-2.05 2.602-3.19C67.123-.548 71 .125 71 .125l-9.186 13.923 9.161 13.881-.032.004c-.38.045-4.036.423-5.855-1.266-1.229-1.138-2.487-2.992-2.487-2.992l-3.38-4.964c-.164-.26-.379-.54-.721-.54-.343 0-.557.28-.721.54l-3.38 4.964s-1.19 1.854-2.418 2.992c-1.92 1.783-5.957 1.262-5.957 1.262l9.161-13.88zM43.96 0H44c0 1.91-.186 3.042-1.387 3.923-.384.28-1.048.71-1.826.992C39.719 5.304 39 6 39 6c0-3.476.53-4.734 1.95-5.48.865-.452 2.272-.514 2.82-.52z"></path></svg>',Kee={"modern-image-formats":"Upload images using `Wix Media Manager` to ensure they are automatically served as WebP. Find [more ways to optimize](https://support.wix.com/en/article/site-performance-optimizing-your-media) your site's media.","render-blocking-resources":"When [adding third-party code](https://support.wix.com/en/article/site-performance-using-third-party-code-on-your-site) in the\
 `Custom Code` tab of your site's dashboard, make sure it's deferred or loaded at the end of the code body. Where possible, use Wix’s [integrations](https://support.wix.com/en/article/about-marketing-integrations) to embed marketing tools on your site. ","efficient-animated-content":"Place videos inside `VideoBoxes`, customize them using `Video Masks` or add `Transparent Videos`. [Learn more](https://support.wix.com/en/article/wix-video-about-wix-video).","unused-javascript":"Review any third-party code you've added to your site in the `Custom Code` tab of your site's dashboard and only keep the services that are necessary to your site. [Find out more](https://support.wix.com/en/article/site-performance-removing-unused-javascript).","server-response-time":"Wix utilizes CDNs and caching to serve responses as fast as possible for most visitors. Consider [manually enabling caching](https://support.wix.com/en/article/site-performance-caching-pages-to-optimize-loading-speed) for your site\
, especially if using `Velo`."};wP.exports={id:"wix",title:"Wix",icon:Yee,UIStrings:Kee}});var EP=Ne((DRe,DP)=>{d();var Jee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.5 122.5"><g fill="%232f3439"><path d="M8.7 61.3c0 20.8 12.1 38.7 29.6 47.3l-25-68.7c-3 6.5-4.6 13.7-4.6 21.4zm88-2.7c0-6.5-2.3-11-4.3-14.5-2.7-4.3-5.2-8-5.2-12.3 0-4.8 3.7-9.3 8.9-9.3h.7a52.4 52.4 0 0 0-79.4 9.9h3.3c5.5 0 14-.6 14-.6 2.9-.2 3.2 4 .4 4.3 0 0-2.9.4-6 .5l19.1 57L59.7 59l-8.2-22.5c-2.8-.1-5.5-.5-5.5-.5-2.8-.1-2.5-4.5.3-4.3 0 0 8.7.7 13.9.7 5.5 0 14-.7 14-.7 2.8-.2 3.2 4 .3 4.3 0 0-2.8.4-6 .5l19 56.5 5.2-17.5c2.3-7.3 4-12.5 4-17z"/><path d="m62.2 65.9-15.8 45.8a52.6 52.6 0 0 0 32.3-.9l-.4-.7zM107.4 36a49.6 49.6 0 0 1-3.6 24.2l-16.1 46.5A52.5 52.5 0 0 0 107.4 36z"/><path d="M61.3 0a61.3 61.3 0 1 0 .1 122.7A61.3 61.3 0 0 0 61.3 0zm0 119.7a58.5 58.5 0 1 1 .1-117 58.5 58.5 0 0 1-.1 117z"/></g></svg>',Xee={"unused-css-rules":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused CSS in your page. To identify plu\
gins that are adding extraneous CSS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the stylesheet. Look out for plugins that have many stylesheets in the list which have a lot of red in code coverage. A plugin should only enqueue a stylesheet if it is actually used on the page.","modern-image-formats":"Consider using the [Performance Lab](https://wordpress.org/plugins/performance-lab/) plugin to automatically convert your uploaded JPEG images into WebP, wherever supported.","offscreen-images":"Install a [lazy-load WordPress plugin](https://wordpress.org/plugins/search/lazy+load/) that provides the ability to defer any offscreen images, or switch to a theme that provides that functionality. Also consider using [the AMP plugin](https://wordpress.org/plugins/amp/).","total-byte-weight":"Consider showing excerpts in your post lists (e.g. via the more tag), reducing the numb\
er of posts shown on a given page, breaking your long posts into multiple pages, or using a plugin to lazy-load comments.","render-blocking-resources":"There are a number of WordPress plugins that can help you [inline critical assets](https://wordpress.org/plugins/search/critical+css/) or [defer less important resources](https://wordpress.org/plugins/search/defer+css+javascript/). Beware that optimizations provided by these plugins may break features of your theme or plugins, so you will likely need to make code changes.","unminified-css":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+css/) can speed up your site by concatenating, minifying, and compressing your styles. You may also want to use a build process to do this minification up-front if possible.","unminified-javascript":"A number of [WordPress plugins](https://wordpress.org/plugins/search/minify+javascript/) can speed up your site by concatenating, minifying, and compressing your scripts. You may\
 also want to use a build process to do this minification up front if possible.","efficient-animated-content":"Consider uploading your GIF to a service which will make it available to embed as an HTML5 video.","unused-javascript":"Consider reducing, or switching, the number of [WordPress plugins](https://wordpress.org/plugins/) loading unused JavaScript in your page. To identify plugins that are adding extraneous JS, try running [code coverage](https://developer.chrome.com/docs/devtools/coverage/) in Chrome DevTools. You can identify the theme/plugin responsible from the URL of the script. Look out for plugins that have many scripts in the list which have a lot of red in code coverage. A plugin should only enqueue a script if it is actually used on the page.","uses-long-cache-ttl":"Read about [Browser Caching in WordPress](https://wordpress.org/support/article/optimization/#browser-caching).","uses-optimized-images":"Consider using an [image optimization WordPress plugin](https://wordp\
ress.org/plugins/search/optimize+images/) that compresses your images while retaining quality.","uses-text-compression":"You can enable text compression in your web server configuration.","uses-responsive-images":"Upload images directly through the [media library](https://wordpress.org/support/article/media-library-screen/) to ensure that the required image sizes are available, and then insert them from the media library or use the image widget to ensure the optimal image sizes are used (including those for the responsive breakpoints). Avoid using `Full Size` images unless the dimensions are adequate for their usage. [Learn More](https://wordpress.org/support/article/inserting-images-into-posts-and-pages/).","server-response-time":"Choose a lightweight theme (ideally a block theme) and implement full-page caching or a static site solution. Disable unnecessary plugins to minimize server overhead. Consider upgrading your hosting to managed or dedicated service."};DP.exports={id:"wordpres\
s",title:"WordPress",icon:Jee,UIStrings:Xee}});var SP=Ne((TRe,TP)=>{d();var Zee='data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 294 524"><defs><linearGradient id="a" x1="36.742%" x2="37.116%" y1="100.518%" y2="-.001%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="b" x1="28.046%" x2="28.421%" y1="100.518%" y2="-.003%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient><linearGradient id="c" x1="38.215%" x2="38.589%" y1="100.518%" y2="0%"><stop offset="0%" stop-color="%23DD5F29"/><stop offset="26.042%" stop-color="%23F26B32"/><stop offset="100%" stop-color="%23FAC932"/></linearGradient></defs><g fill="none" fill-rule="evenodd"><path fill="url(%23a)" d="M218.617 270.615c-9.752 0-18.896-5.689-23.366-14.63l-7.72-17.27h-76.6l-7.722 17.27c-4.47 8.941-13.613 14.63-23.366 14.63H75.78l32.712 249.30\
6c1.625 4.671 4.673 4.671 6.502 0l32.51-79.648 28.242 79.442c1.625 4.676 4.673 4.676 6.501 0L220.04 270.82l-1.423-.204Z" transform="translate(-1.58 -.2)"/><path fill="url(%23b)" d="M184.47 231.784h-70.3l-10.77 24.179c-3.657 7.314-10.768 12.597-18.489 14.02L109.7 423.791c1.625 2.844 4.673 2.844 6.501 0l31.697-48.155 29.055 47.951c1.829 2.845 4.673 2.845 6.502 0l28.039-154.012c-6.908-2.032-13.004-6.908-16.255-13.613l-10.768-24.18Z" transform="translate(-1.58 -.2)"/><path fill="url(%23c)" d="m195.259 255.988-46.123-103.014-45.92 103.014c-1.625 3.048-3.656 5.69-6.095 7.925l19.1 102.2c1.015 1.423 3.657 1.83 5.485 0l25.601-33.931 25.602 33.728c1.625 2.032 4.47 1.626 5.485 0l21.131-103.42c-1.625-2.032-3.047-4.064-4.266-6.502Z" transform="translate(-1.58 -.2)"/><path fill="%23F56F46" d="M.439 12.559c-1.422-4.877 1.422-8.33 6.299-8.33H47.17c2.845 0 5.486 2.437 6.299 4.876l29.665 116.83h1.422l53.437-121.3c1.016-2.032 3.048-3.86 5.892-3.86h6.299c3.047 0 5.08 1.625 5.892 3.86l53.437 121.3h1.423L24\
0.6 9.105c.61-2.439 3.454-4.877 6.299-4.877h40.433c4.877 0 7.518 3.454 6.299 8.33l-65.221 231.63c-.61 2.845-3.454 4.876-6.298 4.876h-5.487c-2.438 0-4.876-1.625-5.892-3.86l-63.19-141.009h-1.015L83.744 245.203c-1.016 2.032-3.454 3.86-5.892 3.86h-5.486c-2.845 0-5.486-2.031-6.299-4.876L.44 12.559Z"/></g></svg>',Qee={"unused-css-rules":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket' to fix this issue. It reduces page size by removing all CSS and stylesheets that are not used while keeping only the used CSS for each page.","modern-image-formats":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' to convert your images to WebP.","unused-javascript":"Enable [Delay JavaScript execution](https://docs.wp-rocket.me/article/1349-delay-javascript-execution) in 'WP Rocket' to fix this problem. It will improve the loading of your page by delaying the execution of scripts until user interaction. If your site has iframes, you can use WP \
Rocket's [LazyLoad for iframes and videos](https://docs.wp-rocket.me/article/1674-lazyload-for-iframes-and-videos) and [Replace YouTube iframe with preview image](https://docs.wp-rocket.me/article/1488-replace-youtube-iframe-with-preview-image) as well.","render-blocking-resources":"Enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) and [Load JavaScript deferred](https://docs.wp-rocket.me/article/1265-load-javascript-deferred) in 'WP Rocket' to address this recommendation. These features will respectively optimize the CSS and JavaScript files so that they don't block the rendering of your page.","unminified-css":"Enable [Minify CSS files](https://docs.wp-rocket.me/article/1350-css-minify-combine) in 'WP Rocket' to fix this issue. Any spaces and comments in your site's CSS files will be removed to make the file size smaller and faster to download.","unminified-javascript":"Enable [Minify JavaScript files](https://docs.wp-rocket.me/article/1351-javascrip\
t-minify-combine) in 'WP Rocket' to fix this issue. Empty spaces and comments will be removed from JavaScript files to make their size smaller and faster to download.","uses-optimized-images":"Enable 'Imagify' from the Image Optimization tab in 'WP Rocket' and run Bulk Optimization to compress your images.","uses-rel-preconnect":`Use [Prefetch DNS Requests](https://docs.wp-rocket.me/article/1302-prefetch-dns-requests) in 'WP Rocket' to add "dns-prefetch" and speed up the connection with external domains. Also, 'WP Rocket' automatically adds "preconnect" to [Google Fonts domain](https://docs.wp-rocket.me/article/1312-optimize-google-fonts) and any CNAME(S) added via the [Enable CDN](https://docs.wp-rocket.me/article/42-using-wp-rocket-with-a-cdn) feature.`,"uses-rel-preload":"To fix this issue for fonts, enable [Remove Unused CSS](https://docs.wp-rocket.me/article/1529-remove-unused-css) in 'WP Rocket'. Your site's critical fonts will be preloaded with priority.","offscreen-images":"Ena\
ble [LazyLoad](https://docs.wp-rocket.me/article/1141-lazyload-for-images) in WP Rocket to fix this recommendation. This feature delays the loading of the images until the visitor scrolls down the page and actually needs to see them."};TP.exports={id:"wp-rocket",title:"WP Rocket",icon:Zee,UIStrings:Qee}});var kP=Ne((CRe,CP)=>{d();var ete=[XN(),QN(),tP(),rP(),oP(),sP(),uP(),dP(),pP(),hP(),yP(),bP(),xP(),EP(),SP()];CP.exports=ete});var AP=Ne((IRe,IP)=>{d();IP.exports=i(function(t,n){if(typeof t=="string"&&n[t])return t;for(var r=[].concat(t||[]),a=0,o=r.length;a<o;++a)for(var s=r[a].split("-");s.length;){var c=s.join("-");if(n[c])return c;s.pop()}},"lookupClosestLocale")});var pg,tte,FP,Fd=g(()=>{"use strict";d();Ao();Fi();Xs();pg=un.dirname(""),tte=JSON.parse(`{
  "name": "lighthouse",
  "type": "module",
  "version": "12.5.1",
  "description": "Automated auditing, performance metrics, and best practices for the web.",
  "main": "./core/index.js",
  "bin": {
    "lighthouse": "./cli/index.js",
    "chrome-debug": "./core/scripts/manual-chrome-launcher.js",
    "smokehouse": "./cli/test/smokehouse/frontends/smokehouse-bin.js"
  },
  "engines": {
    "node": ">=18.16"
  },
  "scripts": {
    "prepack": "yarn build-report --standalone --flow --esm && yarn build-types",
    "postpack": "yarn clean-types",
    "build-all": "npm-run-posix-or-windows build-all:task",
    "build-all:task": "yarn build-report && yarn build-cdt-strings && yarn build-devtools && concurrently 'yarn build-extension' 'yarn build-lr' 'yarn build-viewer' 'yarn build-treemap' 'yarn build-smokehouse-bundle' && yarn build-pack",
    "build-all:task:windows": "yarn build-report && yarn build-cdt-strings && yarn build-extension && yarn build-devtools && yarn build-lr && yarn build-viewer && yarn build-treemap && yarn build-smokehouse-bundle",
    "build-cdt-lib": "node ./build/build-cdt-lib.js",
    "build-cdt-strings": "node ./build/build-cdt-strings.js",
    "build-extension": "yarn build-extension-chrome && yarn build-extension-firefox",
    "build-extension-chrome": "node ./build/build-extension.js chrome",
    "build-extension-firefox": "node ./build/build-extension.js firefox",
    "build-devtools": "yarn reset-link && node ./build/build-bundle.js clients/devtools/devtools-entry.js dist/lighthouse-dt-bundle.js && node ./build/build-dt-report-resources.js",
    "build-smokehouse-bundle": "node ./build/build-smokehouse-bundle.js",
    "build-lr": "yarn reset-link && node --max-old-space-size=4096 ./build/build-lightrider-bundles.js",
    "build-pack": "bash build/build-pack.sh",
    "build-report": "node build/build-report-components.js && node build/build-report.js",
    "build-sample-reports": "yarn build-report && node build/build-sample-reports.js",
    "build-treemap": "node ./build/build-treemap.js",
    "build-viewer": "node ./build/build-viewer.js",
    "build-types": "yarn type-check && rsync -a .tmp/tsbuildinfo/ ./ --include='*.d.ts' --include='*.d.cts' --exclude='*.map' --exclude='*.tsbuildinfo'",
    "reset-link": "(yarn unlink || true) && yarn link && yarn link lighthouse",
    "c8": "bash core/scripts/c8.sh",
    "clean": "rm -r dist proto/scripts/*.json proto/scripts/*_pb2.* proto/scripts/*_pb.* proto/scripts/__pycache__ proto/scripts/*.pyc *.report.html *.report.dom.html *.report.json *.devtoolslog.json *.trace.json shared/localization/locales/*.ctc.json || true",
    "clean-types": "git clean -xfq '*.d.ts' '*.d.cts' -e 'node_modules/' -e 'dist/' -e '.tmp/' -e '**/types/'",
    "lint": "[ \\"$CI\\" = true ] && eslint --quiet -f codeframe . || eslint .",
    "smoke": "node -r source-map-support/register cli/test/smokehouse/frontends/smokehouse-bin.js",
    "debug": "node --inspect-brk ./cli/index.js",
    "start": "yarn build-report --standalone && node ./cli/index.js",
    "mocha": "node --loader=testdouble core/test/scripts/run-mocha-tests.js",
    "test": "yarn diff:sample-json && yarn lint --quiet && yarn unit && yarn type-check",
    "test-bundle": "yarn smoke --runner bundle",
    "test-clients": "yarn mocha --testMatch clients/**/*-test.js && yarn mocha --testMatch clients/**/*-test-pptr.js",
    "test-viewer": "yarn unit-viewer && yarn mocha --testMatch viewer/**/*-test-pptr.js --timeout 35000",
    "test-treemap": "yarn unit-treemap && yarn mocha --testMatch treemap/**/*-test-pptr.js --timeout 35000",
    "test-lantern": "bash core/scripts/test-lantern.sh",
    "test-legacy-javascript": "bash core/scripts/test-legacy-javascript.sh",
    "test-docs": "yarn --cwd docs/recipes/ test",
    "test-proto": "yarn compile-proto && yarn build-proto-roundtrip",
    "unit-core": "yarn mocha core",
    "unit-cli": "yarn mocha --testMatch cli/**/*-test.js",
    "unit-lantern-trace": "INTERNAL_LANTERN_USE_TRACE=1 yarn mocha core/test/computed/metrics core/test/audits",
    "unit-report": "yarn mocha --testMatch report/**/*-test.js",
    "unit-treemap": "yarn mocha --testMatch treemap/**/*-test.js",
    "unit-viewer": "yarn mocha --testMatch viewer/**/*-test.js",
    "unit-flow": "bash flow-report/test/run-flow-report-tests.sh",
    "unit": "yarn unit-flow && yarn mocha && yarn unit-lantern-trace",
    "unit:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit",
    "unit-lantern-trace:ci": "NODE_OPTIONS=--max-old-space-size=8192 npm run unit-lantern-trace",
    "core-unit": "yarn unit-core",
    "cli-unit": "yarn unit-cli",
    "viewer-unit": "yarn unit-viewer",
    "watch": "yarn unit-core --watch",
    "unit:cicoverage": "yarn c8 --all yarn unit:ci && yarn c8 --all yarn unit-lantern-trace:ci",
    "coverage": "yarn unit:cicoverage && c8 report --reporter html",
    "coverage:smoke": "yarn c8 yarn smoke -j=1 && c8 report --reporter html",
    "devtools": "bash core/scripts/roll-to-devtools.sh",
    "chrome": "node core/scripts/manual-chrome-launcher.js",
    "fast": "node ./cli/index.js --preset=desktop --throttlingMethod=provided",
    "deploy-treemap": "yarn build-treemap --deploy",
    "deploy-viewer": "yarn build-viewer --deploy",
    "vercel-build": "yarn build-sample-reports && yarn build-viewer && yarn build-treemap",
    "dogfood-lhci": "./core/scripts/dogfood-lhci.sh",
    "timing-trace": "node core/scripts/generate-timing-trace.js",
    "changelog": "conventional-changelog --config ./build/changelog-generator/index.cjs --infile changelog.md --same-file",
    "type-check": "tsc --build ./tsconfig-all.json",
    "i18n:checks": "./core/scripts/i18n/assert-strings-collected.sh",
    "i18n:collect-strings": "node core/scripts/i18n/collect-strings.js",
    "update:lantern-baseline": "node core/scripts/lantern/update-baseline-lantern-values.js",
    "update:sample-artifacts": "node core/scripts/update-report-fixtures.js",
    "update:sample-json": "yarn i18n:collect-strings && node ./cli -A=./core/test/results/artifacts --config-path=./core/test/results/sample-config.js --output=json --output-path=./core/test/results/sample_v2.json && node core/scripts/cleanup-LHR-for-diff.js ./core/test/results/sample_v2.json --only-remove-timing && node ./core/scripts/update-flow-fixtures.js",
    "update:flow-sample-json": "yarn i18n:collect-strings && node ./core/scripts/update-flow-fixtures.js",
    "test-devtools": "bash core/test/devtools-tests/test-locally.sh",
    "open-devtools": "bash core/scripts/open-devtools.sh",
    "run-devtools": "node core/scripts/pptr-run-devtools.js",
    "diff:sample-json": "yarn i18n:checks && bash core/scripts/assert-golden-lhr-unchanged.sh",
    "diff:flow-sample-json": "yarn i18n:collect-strings && bash core/scripts/assert-baseline-flow-result-unchanged.sh",
    "computeBenchmarkIndex": "./core/scripts/benchmark.js",
    "save-latest-run": "./core/scripts/save-latest-run.sh",
    "compile-proto": "protoc --python_out=./ ./proto/lighthouse-result.proto && mv ./proto/*_pb2.py ./proto/scripts || (echo \\"❌ Install protobuf = 3.20.x to compile the proto file.\\" && false)",
    "build-proto-roundtrip": "mkdir -p .tmp && python3 proto/scripts/json_roundtrip_via_proto.py",
    "static-server": "node cli/test/fixtures/static-server.js",
    "serve-dist": "cd dist && python3 -m http.server 7878",
    "serve-gh-pages": "cd dist/gh-pages && python3 -m http.server 7333",
    "serve-treemap": "yarn serve-gh-pages",
    "serve-viewer": "yarn serve-gh-pages",
    "flow-report": "yarn build-report --flow && node ./core/scripts/build-test-flow-report.js",
    "generate-insight-audits": "node core/scripts/generate-insight-audits.js"
  },
  "devDependencies": {
    "@build-tracker/cli": "^1.0.0-beta.15",
    "@esbuild-kit/esm-loader": "^2.1.1",
    "@esbuild-plugins/node-modules-polyfill": "^0.1.4",
    "@formatjs/icu-messageformat-parser": "^2.6.2",
    "@jest/fake-timers": "^28.1.0",
    "@testing-library/preact": "^3.1.1",
    "@testing-library/preact-hooks": "^1.1.0",
    "@types/archiver": "^2.1.2",
    "@types/chrome": "^0.0.154",
    "@types/configstore": "^4.0.0",
    "@types/cpy": "^5.1.0",
    "@types/debug": "^4.1.7",
    "@types/eslint": "^8.2.1",
    "@types/estree": "^0.0.50",
    "@types/gh-pages": "^2.0.0",
    "@types/google.analytics": "0.0.39",
    "@types/jpeg-js": "^0.3.7",
    "@types/jsdom": "^16.2.13",
    "@types/lodash-es": "^4.17.12",
    "@types/mocha": "^9.0.0",
    "@types/node": "*",
    "@types/pako": "^1.0.1",
    "@types/resize-observer-browser": "^0.1.1",
    "@types/resolve": "^1.20.2",
    "@types/semver": "^5.5.0",
    "@types/tabulator-tables": "^4.9.1",
    "@types/ws": "^7.0.0",
    "@types/yargs": "^17.0.8",
    "@types/yargs-parser": "^20.2.1",
    "@typescript-eslint/eslint-plugin": "^5.48.0",
    "@typescript-eslint/parser": "^5.48.0",
    "acorn": "^8.5.0",
    "angular": "^1.7.4",
    "archiver": "^3.0.0",
    "builtin-modules": "^3.3.0",
    "c8": "^7.11.3",
    "chalk": "^2.4.1",
    "chrome-devtools-frontend": "1.0.1418433",
    "colors": "^1.4.0",
    "concurrently": "^6.4.0",
    "conventional-changelog-cli": "^2.1.1",
    "core-js-compat": "^3.41.0",
    "cpy": "^8.1.2",
    "cross-env": "^7.0.2",
    "csv-validator": "^0.0.3",
    "es-main": "^1.2.0",
    "esbuild": "0.19.11",
    "eslint": "^8.4.1",
    "eslint-config-google": "^0.14.0",
    "eslint-formatter-codeframe": "^7.32.1",
    "eslint-plugin-import": "^2.25.3",
    "eslint-plugin-local-rules": "1.1.0",
    "event-target-shim": "^6.0.2",
    "expect": "^28.1.0",
    "firebase": "^9.0.2",
    "gh-pages": "^2.0.1",
    "glob": "^7.1.3",
    "idb-keyval": "2.2.0",
    "jest-mock": "^27.3.0",
    "jest-snapshot": "^28.1.0",
    "jsdom": "^12.2.0",
    "lighthouse-plugin-soft-navigation": "^1.0.1",
    "magic-string": "^0.25.7",
    "mime-types": "^2.1.30",
    "mocha": "^10.0.0",
    "node-fetch": "^2.6.1",
    "npm-run-posix-or-windows": "^2.0.2",
    "pako": "^2.0.3",
    "preact": "^10.7.2",
    "pretty-json-stringify": "^0.0.2",
    "puppeteer": "^24.4.0",
    "resolve": "^1.22.1",
    "rollup": "^2.52.7",
    "rollup-plugin-polyfill-node": "^0.12.0",
    "source-map-support": "^0.5.21",
    "tabulator-tables": "^4.9.3",
    "terser": "^5.18.2",
    "testdouble": "^3.18.0",
    "typed-query-selector": "^2.11.2",
    "typescript": "5.5.3",
    "wait-for-expect": "^3.0.2",
    "webtreemap-cdt": "^3.2.1"
  },
  "dependencies": {
    "@paulirish/trace_engine": "0.0.50",
    "@sentry/node": "^7.0.0",
    "axe-core": "^4.10.3",
    "chrome-launcher": "^1.1.2",
    "configstore": "^5.0.1",
    "csp_evaluator": "1.1.5",
    "devtools-protocol": "0.0.1436416",
    "enquirer": "^2.3.6",
    "http-link-header": "^1.1.1",
    "intl-messageformat": "^10.5.3",
    "jpeg-js": "^0.4.4",
    "js-library-detector": "^6.7.0",
    "lighthouse-logger": "^2.0.1",
    "lighthouse-stack-packs": "1.12.2",
    "lodash-es": "^4.17.21",
    "lookup-closest-locale": "6.2.0",
    "metaviewport-parser": "0.3.0",
    "open": "^8.4.0",
    "parse-cache-control": "1.0.1",
    "puppeteer-core": "^24.4.0",
    "robots-parser": "^3.0.1",
    "semver": "^5.3.0",
    "speedline-core": "^1.4.3",
    "third-party-web": "^0.26.5",
    "tldts-icann": "^6.1.16",
    "ws": "^7.0.0",
    "yargs": "^17.3.1",
    "yargs-parser": "^21.0.0"
  },
  "resolutions": {
    "puppeteer/**/devtools-protocol": "0.0.1436416",
    "puppeteer-core/**/devtools-protocol": "0.0.1436416"
  },
  "repository": "GoogleChrome/lighthouse",
  "keywords": [
    "google",
    "chrome",
    "devtools"
  ],
  "author": "Google LLC",
  "license": "Apache-2.0",
  "bugs": {
    "url": "https://github.com/GoogleChrome/lighthouse/issues"
  },
  "homepage": "https://github.com/GoogleChrome/lighthouse#readme"
}
`),FP=tte.version});function fg(e,t){if(typeof Intl!="object")throw new Error("Lighthouse must be run in Node with `Intl` support. See https://nodejs.org/api/intl.html for help");let n=Intl.getCanonicalLocales(e),r=Intl.NumberFormat.supportedLocalesOf(n),a=t||YN(),o=Object.fromEntries(a.map(c=>[c,{}])),s=(0,RP.default)(r,o);return s||(Intl.NumberFormat.supportedLocalesOf("es").length===0&&H.warn("i18n","Requested locale not available in this version of node. The `full-icu` npm module can provide additional locales. For help, see https://github.com/GoogleChrome/lighthouse/blob/main/readme.md#how-do-i-get-localized-lighthouse-results-via-the-cli"),H.warn("i18n",`locale(s) '${e}' not available. Falling back to default '${gu}'`)),s||gu}function x(e,t={}){e.startsWith("file://")&&(e=Js.fileURLToPath(e)),un.isAbsolute(e)&&(e=un.relative(pg,e));let n={...I,...t};return i((a,o)=>{let s=Object.keys(n).find(m=>n[m]===a);if(!s)throw new Error(`Could not locate: ${a}`);return{i18nId:`${(s in t?e:un.relative(pg,BN({url:"\
core/lib/i18n/i18n.js"}))).replace(/\\/g,"/")} | ${s}`,values:o,formattedDefault:i0(a,o,gu)}},"getIcuMessageFn")}function $a(e){return typeof e=="string"||yu(e)}var RP,I,N=g(()=>{"use strict";d();Fi();Ad();RP=Yn(AP(),1);ct();Lo();Fd();Lo();Xs();I={ms:"{timeInMs, number, milliseconds} ms",seconds:"{timeInMs, number, seconds} s",displayValueByteSavings:"Potential savings of {wastedBytes, number, bytes} KiB",displayValueMsSavings:"Potential savings of {wastedMs, number, milliseconds} ms",displayValueElementsFound:"{nodeCount, plural, =1 {1 element found} other {# elements found}}",columnURL:"URL",columnSize:"Size",columnResourceSize:"Resource Size",columnTransferSize:"Transfer Size",columnCacheTTL:"Cache TTL",columnWastedBytes:"Potential Savings",columnWastedMs:"Potential Savings",columnBlockingTime:"Main-Thread Blocking Time",columnTimeSpent:"Time Spent",columnLocation:"Location",columnResourceType:"Resource Type",columnRequests:"Requests",columnName:"Name",columnSource:"Source",columnElement:"\
Element",columnStartTime:"Start Time",columnDuration:"Duration",columnFailingElem:"Failing Elements",columnDescription:"Description",total:"Total",totalResourceType:"Total",documentResourceType:"Document",scriptResourceType:"Script",stylesheetResourceType:"Stylesheet",imageResourceType:"Image",mediaResourceType:"Media",fontResourceType:"Font",otherResourceType:"Other",thirdPartyResourceType:"Third-party",otherResourcesLabel:"Other resources",firstContentfulPaintMetric:"First Contentful Paint",interactiveMetric:"Time to Interactive",firstMeaningfulPaintMetric:"First Meaningful Paint",totalBlockingTimeMetric:"Total Blocking Time",maxPotentialFIDMetric:"Max Potential First Input Delay",speedIndexMetric:"Speed Index",largestContentfulPaintMetric:"Largest Contentful Paint",cumulativeLayoutShiftMetric:"Cumulative Layout Shift",interactionToNextPaint:"Interaction to Next Paint",itemSeverityLow:"Low",itemSeverityMedium:"Medium",itemSeverityHigh:"High"};i(fg,"lookupLocale");i(x,"createIcuMessag\
eFn");i($a,"isStringOrIcuMessage")});function MP(e){if(!e)return[];let t=[];for(let n of e){let r=u0.find(u=>u.requiredStacks.includes(`${n.detector}:${n.id}`));if(!r)continue;let a=_P.default.find(u=>u.id===r.packId);if(!a){H.warn("StackPacks",`'${r.packId}' stack pack was matched but is not found in stack-packs lib`);continue}let o=x(`node_modules/lighthouse-stack-packs/packs/${a.id}.js`,a.UIStrings),s={},c=a.UIStrings;for(let u in c)c[u]&&(s[u]=o(c[u]));t.push({id:a.id,title:a.title,iconDataURL:a.icon,descriptions:s})}return t.sort((n,r)=>{let a=u0.findIndex(s=>s.packId===n.id),o=u0.findIndex(s=>s.packId===r.id);return a-o})}var _P,u0,OP=g(()=>{"use strict";d();ct();_P=Yn(kP(),1);N();u0=[{packId:"gatsby",requiredStacks:["js:gatsby"]},{packId:"wordpress",requiredStacks:["js:wordpress"]},{packId:"wix",requiredStacks:["js:wix"]},{packId:"wp-rocket",requiredStacks:["js:wp-rocket"]},{packId:"ezoic",requiredStacks:["js:ezoic"]},{packId:"drupal",requiredStacks:["js:drupal"]},{packId:"nitropack",requiredStacks:["js:nitropack"]},
{packId:"amp",requiredStacks:["js:amp"]},{packId:"magento",requiredStacks:["js:magento"]},{packId:"octobercms",requiredStacks:["js:octobercms"]},{packId:"joomla",requiredStacks:["js:joomla"]},{packId:"next.js",requiredStacks:["js:next"]},{packId:"nuxt",requiredStacks:["js:nuxt"]},{packId:"angular",requiredStacks:["js:@angular/core"]},{packId:"react",requiredStacks:["js:react"]}];i(MP,"getStackPacks")});var l0,bn,NP=g(()=>{d();typeof Object.create=="function"?l0=i(function(t,n){t.super_=n,t.prototype=Object.create(n.prototype,{constructor:{value:t,enumerable:!1,writable:!0,configurable:!0}})},"inherits"):l0=i(function(t,n){t.super_=n;var r=i(function(){},"TempCtor");r.prototype=n.prototype,t.prototype=new r,t.prototype.constructor=t},"inherits");bn=l0});function ote(e){if(!b0(e)){for(var t=[],n=0;n<arguments.length;n++)t.push(Pi(arguments[n]));return t.join(" ")}for(var n=1,r=arguments,a=r.length,o=String(e).replace(ate,function(c){if(c==="%%")return"%";if(n>=a)return c;switch(c){case"%s":return String(r[n++]);case"%d":return Number(r[n++]);case"%j":try{return JSON.stringify(r[n++])}catch{return"[Circular]"}default:return c}}),s=r[n];n<a;s=r[++n])v0(s)||!Rd(s)?o+=" "+s:o+=" "+Pi(s);return o}function y0(e,t){if(Ni(globalThis.process))return function(){return y0(e,t).apply(this,arguments)};if(nr.noDeprecation===!0)return e;var n=!1;function r(){if(!n){if(nr.throwDeprecation)throw new Error(t);nr.traceDeprecation?console.trace(t):console.error(t),n=!0}return e.apply(this,arguments)}return i(r,"deprecated"),r}function LP(e){if(Ni(d0)&&(d0=nr.env.NODE_DEBUG||""),e=e.toUpperCase(),!hg[e])if(new RegExp("\\b"+e+"\\b","i").test(d0)){var t=0;hg[e]=function(){var n=ote.apply(null,arguments);console.error("%s %d: %s",e,t,n)}}else hg[e]=function(){};
return hg[e]}function Pi(e,t){var n={seen:[],stylize:ste};return arguments.length>=3&&(n.depth=arguments[2]),arguments.length>=4&&(n.colors=arguments[3]),BP(t)?n.showHidden=t:t&&fte(n,t),Ni(n.showHidden)&&(n.showHidden=!1),Ni(n.depth)&&(n.depth=2),Ni(n.colors)&&(n.colors=!1),Ni(n.customInspect)&&(n.customInspect=!0),n.colors&&(n.stylize=ite),gg(n,e,n.depth)}function ite(e,t){var n=Pi.styles[t];return n?"\x1B["+Pi.colors[n][0]+"m"+e+"\x1B["+Pi.colors[n][1]+"m":e}function ste(e,t){return e}function cte(e){var t={};return e.forEach(function(n,r){t[n]=!0}),t}function gg(e,t,n){if(e.customInspect&&t&&h0(t.inspect)&&t.inspect!==Pi&&!(t.constructor&&t.constructor.prototype===t)){var r=t.inspect(n,e);return b0(r)||(r=gg(e,r,n)),r}var a=ute(e,t);if(a)return a;var o=Object.keys(t),s=cte(o);if(e.showHidden&&(o=Object.getOwnPropertyNames(t)),f0(t)&&(o.indexOf("message")>=0||o.indexOf("description")>=0))return m0(t);if(o.length===0){if(h0(t)){var c=t.name?": "+t.name:"";return e.stylize("[Function"+
c+"]","special")}if(p0(t))return e.stylize(RegExp.prototype.toString.call(t),"regexp");if(PP(t))return e.stylize(Date.prototype.toString.call(t),"date");if(f0(t))return m0(t)}var u="",l=!1,m=["{","}"];if(mte(t)&&(l=!0,m=["[","]"]),h0(t)){var p=t.name?": "+t.name:"";u=" [Function"+p+"]"}if(p0(t)&&(u=" "+RegExp.prototype.toString.call(t)),PP(t)&&(u=" "+Date.prototype.toUTCString.call(t)),f0(t)&&(u=" "+m0(t)),o.length===0&&(!l||t.length==0))return m[0]+u+m[1];if(n<0)return p0(t)?e.stylize(RegExp.prototype.toString.call(t),"regexp"):e.stylize("[Object]","special");e.seen.push(t);var f;return l?f=lte(e,t,n,s,o):f=o.map(function(h){return g0(e,t,n,s,h,l)}),e.seen.pop(),dte(f,u,m)}function ute(e,t){if(Ni(t))return e.stylize("undefined","undefined");if(b0(t)){var n="'"+JSON.stringify(t).replace(/^"|"$/g,"").replace(/'/g,"\\'").replace(/\\"/g,'"')+"'";return e.stylize(n,"string")}if(pte(t))return e.stylize(""+t,"number");if(BP(t))return e.stylize(""+t,"boolean");if(v0(t))return e.stylize("null",
"null")}function m0(e){return"["+Error.prototype.toString.call(e)+"]"}function lte(e,t,n,r,a){for(var o=[],s=0,c=t.length;s<c;++s)UP(t,String(s))?o.push(g0(e,t,n,r,String(s),!0)):o.push("");return a.forEach(function(u){u.match(/^\d+$/)||o.push(g0(e,t,n,r,u,!0))}),o}function g0(e,t,n,r,a,o){var s,c,u;if(u=Object.getOwnPropertyDescriptor(t,a)||{value:t[a]},u.get?u.set?c=e.stylize("[Getter/Setter]","special"):c=e.stylize("[Getter]","special"):u.set&&(c=e.stylize("[Setter]","special")),UP(r,a)||(s="["+a+"]"),c||(e.seen.indexOf(u.value)<0?(v0(n)?c=gg(e,u.value,null):c=gg(e,u.value,n-1),c.indexOf(`
`)>-1&&(o?c=c.split(`
`).map(function(l){return"  "+l}).join(`
`).substr(2):c=`
`+c.split(`
`).map(function(l){return"   "+l}).join(`
`))):c=e.stylize("[Circular]","special")),Ni(s)){if(o&&a.match(/^\d+$/))return c;s=JSON.stringify(""+a),s.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)?(s=s.substr(1,s.length-2),s=e.stylize(s,"name")):(s=s.replace(/'/g,"\\'").replace(/\\"/g,'"').replace(/(^"|"$)/g,"'"),s=e.stylize(s,"string"))}return s+": "+c}function dte(e,t,n){var r=0,a=e.reduce(function(o,s){return r++,s.indexOf(`
`)>=0&&r++,o+s.replace(/\u001b\[\d\d?m/g,"").length+1},0);return a>60?n[0]+(t===""?"":t+`
 `)+" "+e.join(`,
  `)+" "+n[1]:n[0]+t+" "+e.join(", ")+" "+n[1]}function mte(e){return Array.isArray(e)}function BP(e){return typeof e=="boolean"}function v0(e){return e===null}function pte(e){return typeof e=="number"}function b0(e){return typeof e=="string"}function Ni(e){return e===void 0}function p0(e){return Rd(e)&&w0(e)==="[object RegExp]"}function Rd(e){return typeof e=="object"&&e!==null}function PP(e){return Rd(e)&&w0(e)==="[object Date]"}function f0(e){return Rd(e)&&(w0(e)==="[object Error]"||e instanceof Error)}function h0(e){return typeof e=="function"}function w0(e){return Object.prototype.toString.call(e)}function fte(e,t){if(!t||!Rd(t))return e;for(var n=Object.keys(t),r=n.length;r--;)e[n[r]]=t[n[r]];return e}function UP(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function hte(e){if(typeof e!="function")throw new TypeError('The "original" argument must be of type Function');if(Qs&&e[Qs]){var t=e[Qs];if(typeof t!="function")throw new TypeError('The "util.promisify.custom" argume\
nt must be of type Function');return Object.defineProperty(t,Qs,{value:t,enumerable:!1,writable:!1,configurable:!0}),t}function t(){for(var n,r,a=new Promise(function(c,u){n=c,r=u}),o=[],s=0;s<arguments.length;s++)o.push(arguments[s]);o.push(function(c,u){c?r(c):n(u)});try{e.apply(this,o)}catch(c){r(c)}return a}return i(t,"fn"),Object.setPrototypeOf(t,Object.getPrototypeOf(e)),Qs&&Object.defineProperty(t,Qs,{value:t,enumerable:!1,writable:!1,configurable:!0}),Object.defineProperties(t,rte(e))}var rte,ate,hg,d0,Qs,Li=g(()=>{d();Ci();NP();rte=Object.getOwnPropertyDescriptors||i(function(t){for(var n=Object.keys(t),r={},a=0;a<n.length;a++)r[n[a]]=Object.getOwnPropertyDescriptor(t,n[a]);return r},"getOwnPropertyDescriptors"),ate=/%[sdj%]/g;i(ote,"format");i(y0,"deprecate");hg={};i(LP,"debuglog");i(Pi,"inspect");Pi.colors={bold:[1,22],italic:[3,23],underline:[4,24],inverse:[7,27],white:[37,39],grey:[90,39],black:[30,39],blue:[34,39],cyan:[36,39],green:[32,39],magenta:[35,39],red:[31,39],yellow:[
33,39]};Pi.styles={special:"cyan",number:"yellow",boolean:"yellow",undefined:"grey",null:"bold",string:"green",date:"magenta",regexp:"red"};i(ite,"stylizeWithColor");i(ste,"stylizeNoColor");i(cte,"arrayToHash");i(gg,"formatValue");i(ute,"formatPrimitive");i(m0,"formatError");i(lte,"formatArray");i(g0,"formatProperty");i(dte,"reduceToSingleString");i(mte,"isArray");i(BP,"isBoolean");i(v0,"isNull");i(pte,"isNumber");i(b0,"isString");i(Ni,"isUndefined");i(p0,"isRegExp");i(Rd,"isObject");i(PP,"isDate");i(f0,"isError");i(h0,"isFunction");i(w0,"objectToString");i(fte,"_extend");i(UP,"hasOwnProperty");Qs=typeof Symbol<"u"?Symbol("util.promisify.custom"):void 0;i(hte,"promisify");hte.custom=Qs});function ec(){this.head=null,this.tail=null,this.length=0}var jP,qP=g(()=>{d();nu();jP=ec;i(ec,"BufferList");ec.prototype.push=function(e){var t={data:e,next:null};this.length>0?this.tail.next=t:this.head=t,this.tail=t,++this.length};ec.prototype.unshift=function(e){var t={data:e,next:this.head};this.length===0&&(this.tail=t),this.head=t,++this.length};ec.prototype.shift=function(){if(this.length!==0){var e=this.head.data;return this.length===1?this.head=this.tail=null:this.head=this.head.next,--this.length,e}};ec.prototype.clear=function(){this.head=this.tail=null,this.length=0};ec.prototype.join=function(e){if(this.length===0)return"";for(var t=this.head,n=""+t.data;t=t.next;)n+=e+t.data;return n};ec.prototype.concat=function(e){if(this.length===0)return re.alloc(0);if(this.length===1)return this.head.data;for(var t=re.allocUnsafe(e>>>0),n=this.head,r=0;n;)n.data.copy(t,r),r+=n.data.length,n=n.next;return t}});function yte(e){if(e&&!gte(e))throw new Error("Unknown encoding: "+e)}function vu(e){switch(this.encoding=(e||"utf8").toLowerCase().replace(/[-_]/,""),yte(e),this.encoding){case"utf8":this.surrogateSize=3;break;case"ucs2":case"utf16le":this.surrogateSize=2,this.detectIncompleteChar=bte;break;case"base64":this.surrogateSize=3,this.detectIncompleteChar=wte;break;default:this.write=vte;return}this.charBuffer=new re(6),this.charReceived=0,this.charLength=0}function vte(e){return e.toString(this.encoding)}function bte(e){this.charReceived=e.length%2,this.charLength=this.charReceived?2:0}function wte(e){this.charReceived=e.length%3,this.charLength=this.charReceived?3:0}var gte,zP=g(()=>{d();nu();gte=re.isEncoding||function(e){switch(e&&e.toLowerCase()){case"hex":case"utf8":case"utf-8":case"ascii":case"binary":case"base64":case"ucs2":case"ucs-2":case"utf16le":case"utf-16le":case"raw":return!0;default:return!1}};i(yte,"assertEncoding");i(vu,"StringDecoder");vu.prototype.write=function(e){for(var t="";this.
charLength;){var n=e.length>=this.charLength-this.charReceived?this.charLength-this.charReceived:e.length;if(e.copy(this.charBuffer,this.charReceived,0,n),this.charReceived+=n,this.charReceived<this.charLength)return"";e=e.slice(n,e.length),t=this.charBuffer.slice(0,this.charLength).toString(this.encoding);var a=t.charCodeAt(t.length-1);if(a>=55296&&a<=56319){this.charLength+=this.surrogateSize,t="";continue}if(this.charReceived=this.charLength=0,e.length===0)return t;break}this.detectIncompleteChar(e);var r=e.length;this.charLength&&(e.copy(this.charBuffer,0,e.length-this.charReceived,r),r-=this.charReceived),t+=e.toString(this.encoding,0,r);var r=t.length-1,a=t.charCodeAt(r);if(a>=55296&&a<=56319){var o=this.surrogateSize;return this.charLength+=o,this.charReceived+=o,this.charBuffer.copy(this.charBuffer,o,0,o),e.copy(this.charBuffer,0,0,o),t.substring(0,r)}return t};vu.prototype.detectIncompleteChar=function(e){for(var t=e.length>=3?3:e.length;t>0;t--){var n=e[e.length-t];if(t==1&&n>>
5==6){this.charLength=2;break}if(t<=2&&n>>4==14){this.charLength=3;break}if(t<=3&&n>>3==30){this.charLength=4;break}}this.charReceived=t};vu.prototype.end=function(e){var t="";if(e&&e.length&&(t=this.write(e)),this.charReceived){var n=this.charReceived,r=this.charBuffer,a=this.encoding;t+=r.slice(0,n).toString(a)}return t};i(vte,"passThroughWrite");i(bte,"utf16DetectIncompleteChar");i(wte,"base64DetectIncompleteChar")});function xte(e,t,n){if(typeof e.prependListener=="function")return e.prependListener(t,n);!e._events||!e._events[t]?e.on(t,n):Array.isArray(e._events[t])?e._events[t].unshift(n):e._events[t]=[n,e._events[t]]}function Dte(e,t){return e.listeners(t).length}function VP(e,t){e=e||{},this.objectMode=!!e.objectMode,t instanceof or&&(this.objectMode=this.objectMode||!!e.readableObjectMode);var n=e.highWaterMark,r=this.objectMode?16:16*1024;this.highWaterMark=n||n===0?n:r,this.highWaterMark=~~this.highWaterMark,this.buffer=new jP,this.length=0,this.pipes=null,this.pipesCount=0,this.flowing=null,this.ended=!1,this.endEmitted=!1,this.reading=!1,this.sync=!0,this.needReadable=!1,this.emittedReadable=!1,this.readableListening=!1,this.resumeScheduled=!1,this.defaultEncoding=e.defaultEncoding||"utf8",this.ranOut=!1,this.awaitDrain=0,this.readingMore=!1,this.decoder=null,this.encoding=null,e.encoding&&(this.decoder=new vu(e.encoding),this.encoding=e.encoding)}function ln(e){if(!(this instanceof ln))return new ln(
e);this._readableState=new VP(e,this),this.readable=!0,e&&typeof e.read=="function"&&(this._read=e.read),ea.call(this)}function $P(e,t,n,r,a){var o=Ste(t,n);if(o)e.emit("error",o);else if(n===null)t.reading=!1,Cte(e,t);else if(t.objectMode||n&&n.length>0)if(t.ended&&!a){var s=new Error("stream.push() after EOF");e.emit("error",s)}else if(t.endEmitted&&a){var c=new Error("stream.unshift() after end event");e.emit("error",c)}else{var u;t.decoder&&!a&&!r&&(n=t.decoder.write(n),u=!t.objectMode&&n.length===0),a||(t.reading=!1),u||(t.flowing&&t.length===0&&!t.sync?(e.emit("data",n),e.read(0)):(t.length+=t.objectMode?1:n.length,a?t.buffer.unshift(n):t.buffer.push(n),t.needReadable&&yg(e))),kte(e,t)}else a||(t.reading=!1);return Ete(t)}function Ete(e){return!e.ended&&(e.needReadable||e.length<e.highWaterMark||e.length===0)}function Tte(e){return e>=HP?e=HP:(e--,e|=e>>>1,e|=e>>>2,e|=e>>>4,e|=e>>>8,e|=e>>>16,e++),e}function WP(e,t){return e<=0||t.length===0&&t.ended?0:t.objectMode?1:e!==e?t.flowing&&
t.length?t.buffer.head.data.length:t.length:(e>t.highWaterMark&&(t.highWaterMark=Tte(e)),e<=t.length?e:t.ended?t.length:(t.needReadable=!0,0))}function Ste(e,t){var n=null;return!Buffer.isBuffer(t)&&typeof t!="string"&&t!==null&&t!==void 0&&!e.objectMode&&(n=new TypeError("Invalid non-string/buffer chunk")),n}function Cte(e,t){if(!t.ended){if(t.decoder){var n=t.decoder.end();n&&n.length&&(t.buffer.push(n),t.length+=t.objectMode?1:n.length)}t.ended=!0,yg(e)}}function yg(e){var t=e._readableState;t.needReadable=!1,t.emittedReadable||(Vt("emitReadable",t.flowing),t.emittedReadable=!0,t.sync?tr(GP,e):GP(e))}function GP(e){Vt("emit readable"),e.emit("readable"),D0(e)}function kte(e,t){t.readingMore||(t.readingMore=!0,tr(Ite,e,t))}function Ite(e,t){for(var n=t.length;!t.reading&&!t.flowing&&!t.ended&&t.length<t.highWaterMark&&(Vt("maybeReadMore read 0"),e.read(0),n!==t.length);)n=t.length;t.readingMore=!1}function Ate(e){return function(){var t=e._readableState;Vt("pipeOnDrain",t.awaitDrain),
t.awaitDrain&&t.awaitDrain--,t.awaitDrain===0&&e.listeners("data").length&&(t.flowing=!0,D0(e))}}function Fte(e){Vt("readable nexttick read 0"),e.read(0)}function Rte(e,t){t.resumeScheduled||(t.resumeScheduled=!0,tr(_te,e,t))}function _te(e,t){t.reading||(Vt("resume read 0"),e.read(0)),t.resumeScheduled=!1,t.awaitDrain=0,e.emit("resume"),D0(e),t.flowing&&!t.reading&&e.read(0)}function D0(e){var t=e._readableState;for(Vt("flow",t.flowing);t.flowing&&e.read()!==null;);}function YP(e,t){if(t.length===0)return null;var n;return t.objectMode?n=t.buffer.shift():!e||e>=t.length?(t.decoder?n=t.buffer.join(""):t.buffer.length===1?n=t.buffer.head.data:n=t.buffer.concat(t.length),t.buffer.clear()):n=Mte(e,t.buffer,t.decoder),n}function Mte(e,t,n){var r;return e<t.head.data.length?(r=t.head.data.slice(0,e),t.head.data=t.head.data.slice(e)):e===t.head.data.length?r=t.shift():r=n?Ote(e,t):Nte(e,t),r}function Ote(e,t){var n=t.head,r=1,a=n.data;for(e-=a.length;n=n.next;){var o=n.data,s=e>o.length?o.length:
e;if(s===o.length?a+=o:a+=o.slice(0,e),e-=s,e===0){s===o.length?(++r,n.next?t.head=n.next:t.head=t.tail=null):(t.head=n,n.data=o.slice(s));break}++r}return t.length-=r,a}function Nte(e,t){var n=Buffer.allocUnsafe(e),r=t.head,a=1;for(r.data.copy(n),e-=r.data.length;r=r.next;){var o=r.data,s=e>o.length?o.length:e;if(o.copy(n,n.length-e,0,s),e-=s,e===0){s===o.length?(++a,r.next?t.head=r.next:t.head=t.tail=null):(t.head=r,r.data=o.slice(s));break}++a}return t.length-=a,n}function x0(e){var t=e._readableState;if(t.length>0)throw new Error('"endReadable()" called on non-empty stream');t.endEmitted||(t.ended=!0,tr(Pte,t,e))}function Pte(e,t){!e.endEmitted&&e.length===0&&(e.endEmitted=!0,t.readable=!1,t.emit("end"))}function Lte(e,t){for(var n=0,r=e.length;n<r;n++)t(e[n],n)}function KP(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1}var Vt,HP,E0=g(()=>{"use strict";d();Co();Li();qP();zP();_d();Ci();ln.ReadableState=VP;Vt=LP("stream");bn(ln,ea);i(xte,"prependListener");i(Dte,"\
listenerCount");i(VP,"ReadableState");i(ln,"Readable");ln.prototype.push=function(e,t){var n=this._readableState;return!n.objectMode&&typeof e=="string"&&(t=t||n.defaultEncoding,t!==n.encoding&&(e=Buffer.from(e,t),t="")),$P(this,n,e,t,!1)};ln.prototype.unshift=function(e){var t=this._readableState;return $P(this,t,e,"",!0)};ln.prototype.isPaused=function(){return this._readableState.flowing===!1};i($P,"readableAddChunk");i(Ete,"needMoreData");ln.prototype.setEncoding=function(e){return this._readableState.decoder=new vu(e),this._readableState.encoding=e,this};HP=8388608;i(Tte,"computeNewHighWaterMark");i(WP,"howMuchToRead");ln.prototype.read=function(e){Vt("read",e),e=parseInt(e,10);var t=this._readableState,n=e;if(e!==0&&(t.emittedReadable=!1),e===0&&t.needReadable&&(t.length>=t.highWaterMark||t.ended))return Vt("read: emitReadable",t.length,t.ended),t.length===0&&t.ended?x0(this):yg(this),null;if(e=WP(e,t),e===0&&t.ended)return t.length===0&&x0(this),null;var r=t.needReadable;Vt("nee\
d readable",r),(t.length===0||t.length-e<t.highWaterMark)&&(r=!0,Vt("length less than watermark",r)),t.ended||t.reading?(r=!1,Vt("reading or ended",r)):r&&(Vt("do read"),t.reading=!0,t.sync=!0,t.length===0&&(t.needReadable=!0),this._read(t.highWaterMark),t.sync=!1,t.reading||(e=WP(n,t)));var a;return e>0?a=YP(e,t):a=null,a===null?(t.needReadable=!0,e=0):t.length-=e,t.length===0&&(t.ended||(t.needReadable=!0),n!==e&&t.ended&&x0(this)),a!==null&&this.emit("data",a),a};i(Ste,"chunkInvalid");i(Cte,"onEofChunk");i(yg,"emitReadable");i(GP,"emitReadable_");i(kte,"maybeReadMore");i(Ite,"maybeReadMore_");ln.prototype._read=function(e){this.emit("error",new Error("not implemented"))};ln.prototype.pipe=function(e,t){var n=this,r=this._readableState;switch(r.pipesCount){case 0:r.pipes=e;break;case 1:r.pipes=[r.pipes,e];break;default:r.pipes.push(e);break}r.pipesCount+=1,Vt("pipe count=%d opts=%j",r.pipesCount,t);var a=!t||t.end!==!1,o=a?c:m;r.endEmitted?tr(o):n.once("end",o),e.on("unpipe",s);function s(D){
Vt("onunpipe"),D===n&&m()}i(s,"onunpipe");function c(){Vt("onend"),e.end()}i(c,"onend");var u=Ate(n);e.on("drain",u);var l=!1;function m(){Vt("cleanup"),e.removeListener("close",y),e.removeListener("finish",b),e.removeListener("drain",u),e.removeListener("error",h),e.removeListener("unpipe",s),n.removeListener("end",c),n.removeListener("end",m),n.removeListener("data",f),l=!0,r.awaitDrain&&(!e._writableState||e._writableState.needDrain)&&u()}i(m,"cleanup");var p=!1;n.on("data",f);function f(D){Vt("ondata"),p=!1;var T=e.write(D);T===!1&&!p&&((r.pipesCount===1&&r.pipes===e||r.pipesCount>1&&KP(r.pipes,e)!==-1)&&!l&&(Vt("false write response, pause",n._readableState.awaitDrain),n._readableState.awaitDrain++,p=!0),n.pause())}i(f,"ondata");function h(D){Vt("onerror",D),w(),e.removeListener("error",h),Dte(e,"error")===0&&e.emit("error",D)}i(h,"onerror"),xte(e,"error",h);function y(){e.removeListener("finish",b),w()}i(y,"onclose"),e.once("close",y);function b(){Vt("onfinish"),e.removeListener(
"close",y),w()}i(b,"onfinish"),e.once("finish",b);function w(){Vt("unpipe"),n.unpipe(e)}return i(w,"unpipe"),e.emit("pipe",n),r.flowing||(Vt("pipe resume"),n.resume()),e};i(Ate,"pipeOnDrain");ln.prototype.unpipe=function(e){var t=this._readableState;if(t.pipesCount===0)return this;if(t.pipesCount===1)return e&&e!==t.pipes?this:(e||(e=t.pipes),t.pipes=null,t.pipesCount=0,t.flowing=!1,e&&e.emit("unpipe",this),this);if(!e){var n=t.pipes,r=t.pipesCount;t.pipes=null,t.pipesCount=0,t.flowing=!1;for(var a=0;a<r;a++)n[a].emit("unpipe",this);return this}var o=KP(t.pipes,e);return o===-1?this:(t.pipes.splice(o,1),t.pipesCount-=1,t.pipesCount===1&&(t.pipes=t.pipes[0]),e.emit("unpipe",this),this)};ln.prototype.on=function(e,t){var n=ea.prototype.on.call(this,e,t);if(e==="data")this._readableState.flowing!==!1&&this.resume();else if(e==="readable"){var r=this._readableState;!r.endEmitted&&!r.readableListening&&(r.readableListening=r.needReadable=!0,r.emittedReadable=!1,r.reading?r.length&&yg(this,r):
tr(Fte,this))}return n};ln.prototype.addListener=ln.prototype.on;i(Fte,"nReadingNextTick");ln.prototype.resume=function(){var e=this._readableState;return e.flowing||(Vt("resume"),e.flowing=!0,Rte(this,e)),this};i(Rte,"resume");i(_te,"resume_");ln.prototype.pause=function(){return Vt("call pause flowing=%j",this._readableState.flowing),this._readableState.flowing!==!1&&(Vt("pause"),this._readableState.flowing=!1,this.emit("pause")),this};i(D0,"flow");ln.prototype.wrap=function(e){var t=this._readableState,n=!1,r=this;e.on("end",function(){if(Vt("wrapped end"),t.decoder&&!t.ended){var s=t.decoder.end();s&&s.length&&r.push(s)}r.push(null)}),e.on("data",function(s){if(Vt("wrapped data"),t.decoder&&(s=t.decoder.write(s)),!(t.objectMode&&s==null)&&!(!t.objectMode&&(!s||!s.length))){var c=r.push(s);c||(n=!0,e.pause())}});for(var a in e)this[a]===void 0&&typeof e[a]=="function"&&(this[a]=function(s){return function(){return e[s].apply(e,arguments)}}(a));var o=["error","close","destroy","pause",
"resume"];return Lte(o,function(s){e.on(s,r.emit.bind(r,s))}),r._read=function(s){Vt("wrapped _read",s),n&&(n=!1,e.resume())},r};ln._fromList=YP;i(YP,"fromList");i(Mte,"fromListPartial");i(Ote,"copyFromBufferString");i(Nte,"copyFromBuffer");i(x0,"endReadable");i(Pte,"endReadableNT");i(Lte,"forEach");i(KP,"indexOf")});function Bte(){}function Ute(e,t,n){this.chunk=e,this.encoding=t,this.callback=n,this.next=null}function S0(e,t){Object.defineProperty(this,"buffer",{get:y0(function(){return this.getBuffer()},"_writableState.buffer is deprecated. Use _writableState.getBuffer instead.")}),e=e||{},this.objectMode=!!e.objectMode,t instanceof or&&(this.objectMode=this.objectMode||!!e.writableObjectMode);var n=e.highWaterMark,r=this.objectMode?16:16*1024;this.highWaterMark=n||n===0?n:r,this.highWaterMark=~~this.highWaterMark,this.needDrain=!1,this.ending=!1,this.ended=!1,this.finished=!1;var a=e.decodeStrings===!1;this.decodeStrings=!a,this.defaultEncoding=e.defaultEncoding||"utf8",this.length=0,this.writing=!1,this.corked=0,this.sync=!0,this.bufferProcessing=!1,this.onwrite=function(o){Vte(t,o)},this.writecb=null,this.writelen=0,this.bufferedRequest=null,this.lastBufferedRequest=null,this.pendingcb=0,this.prefinished=!1,this.errorEmitted=!1,this.bufferedRequestCount=0,this.corkedRequestsFree=new tL(this)}
function Un(e){if(!(this instanceof Un)&&!(this instanceof or))return new Un(e);this._writableState=new S0(e,this),this.writable=!0,e&&(typeof e.write=="function"&&(this._write=e.write),typeof e.writev=="function"&&(this._writev=e.writev)),Et.call(this)}function jte(e,t){var n=new Error("write after end");e.emit("error",n),tr(t,n)}function qte(e,t,n,r){var a=!0,o=!1;return n===null?o=new TypeError("May not write null values to stream"):!re.isBuffer(n)&&typeof n!="string"&&n!==void 0&&!t.objectMode&&(o=new TypeError("Invalid non-string/buffer chunk")),o&&(e.emit("error",o),tr(r,o),a=!1),a}function zte(e,t,n){return!e.objectMode&&e.decodeStrings!==!1&&typeof t=="string"&&(t=re.from(t,n)),t}function Hte(e,t,n,r,a){n=zte(t,n,r),re.isBuffer(n)&&(r="buffer");var o=t.objectMode?1:n.length;t.length+=o;var s=t.length<t.highWaterMark;if(s||(t.needDrain=!0),t.writing||t.corked){var c=t.lastBufferedRequest;t.lastBufferedRequest=new Ute(n,r,a),c?c.next=t.lastBufferedRequest:t.bufferedRequest=t.lastBufferedRequest,
t.bufferedRequestCount+=1}else T0(e,t,!1,o,n,r,a);return s}function T0(e,t,n,r,a,o,s){t.writelen=r,t.writecb=s,t.writing=!0,t.sync=!0,n?e._writev(a,t.onwrite):e._write(a,o,t.onwrite),t.sync=!1}function Wte(e,t,n,r,a){--t.pendingcb,n?tr(a,r):a(r),e._writableState.errorEmitted=!0,e.emit("error",r)}function Gte(e){e.writing=!1,e.writecb=null,e.length-=e.writelen,e.writelen=0}function Vte(e,t){var n=e._writableState,r=n.sync,a=n.writecb;if(Gte(n),t)Wte(e,n,r,t,a);else{var o=QP(n);!o&&!n.corked&&!n.bufferProcessing&&n.bufferedRequest&&ZP(e,n),r?tr(JP,e,n,o,a):JP(e,n,o,a)}}function JP(e,t,n,r){n||$te(e,t),t.pendingcb--,r(),eL(e,t)}function $te(e,t){t.length===0&&t.needDrain&&(t.needDrain=!1,e.emit("drain"))}function ZP(e,t){t.bufferProcessing=!0;var n=t.bufferedRequest;if(e._writev&&n&&n.next){var r=t.bufferedRequestCount,a=new Array(r),o=t.corkedRequestsFree;o.entry=n;for(var s=0;n;)a[s]=n,n=n.next,s+=1;T0(e,t,!0,t.length,a,"",o.finish),t.pendingcb++,t.lastBufferedRequest=null,o.next?(t.corkedRequestsFree=
o.next,o.next=null):t.corkedRequestsFree=new tL(t)}else{for(;n;){var c=n.chunk,u=n.encoding,l=n.callback,m=t.objectMode?1:c.length;if(T0(e,t,!1,m,c,u,l),n=n.next,t.writing)break}n===null&&(t.lastBufferedRequest=null)}t.bufferedRequestCount=0,t.bufferedRequest=n,t.bufferProcessing=!1}function QP(e){return e.ending&&e.length===0&&e.bufferedRequest===null&&!e.finished&&!e.writing}function XP(e,t){t.prefinished||(t.prefinished=!0,e.emit("prefinish"))}function eL(e,t){var n=QP(t);return n&&(t.pendingcb===0?(XP(e,t),t.finished=!0,e.emit("finish")):XP(e,t)),n}function Yte(e,t,n){t.ending=!0,eL(e,t),n&&(t.finished?tr(n):e.once("finish",n)),t.ended=!0,e.writable=!1}function tL(e){var t=this;this.next=null,this.entry=null,this.finish=function(n){var r=t.entry;for(t.entry=null;r;){var a=r.callback;e.pendingcb--,a(n),r=r.next}e.corkedRequestsFree?e.corkedRequestsFree.next=t:e.corkedRequestsFree=t}}var C0=g(()=>{d();Li();nu();Co();_d();Ci();Un.WritableState=S0;bn(Un,Et);i(Bte,"nop");i(Ute,"WriteReq");
i(S0,"WritableState");S0.prototype.getBuffer=i(function(){for(var t=this.bufferedRequest,n=[];t;)n.push(t),t=t.next;return n},"writableStateGetBuffer");i(Un,"Writable");Un.prototype.pipe=function(){this.emit("error",new Error("Cannot pipe, not readable"))};i(jte,"writeAfterEnd");i(qte,"validChunk");Un.prototype.write=function(e,t,n){var r=this._writableState,a=!1;return typeof t=="function"&&(n=t,t=null),re.isBuffer(e)?t="buffer":t||(t=r.defaultEncoding),typeof n!="function"&&(n=Bte),r.ended?jte(this,n):qte(this,r,e,n)&&(r.pendingcb++,a=Hte(this,r,e,t,n)),a};Un.prototype.cork=function(){var e=this._writableState;e.corked++};Un.prototype.uncork=function(){var e=this._writableState;e.corked&&(e.corked--,!e.writing&&!e.corked&&!e.finished&&!e.bufferProcessing&&e.bufferedRequest&&ZP(this,e))};Un.prototype.setDefaultEncoding=i(function(t){if(typeof t=="string"&&(t=t.toLowerCase()),!(["hex","utf8","utf-8","ascii","binary","base64","ucs2","ucs-2","utf16le","utf-16le","raw"].indexOf((t+"").toLowerCase())>
-1))throw new TypeError("Unknown encoding: "+t);return this._writableState.defaultEncoding=t,this},"setDefaultEncoding");i(zte,"decodeChunk");i(Hte,"writeOrBuffer");i(T0,"doWrite");i(Wte,"onwriteError");i(Gte,"onwriteStateUpdate");i(Vte,"onwrite");i(JP,"afterWrite");i($te,"onwriteDrain");i(ZP,"clearBuffer");Un.prototype._write=function(e,t,n){n(new Error("not implemented"))};Un.prototype._writev=null;Un.prototype.end=function(e,t,n){var r=this._writableState;typeof e=="function"?(n=e,e=null,t=null):typeof t=="function"&&(n=t,t=null),e!=null&&this.write(e,t),r.corked&&(r.corked=1,this.uncork()),!r.ending&&!r.finished&&Yte(this,r,n)};i(QP,"needFinish");i(XP,"prefinish");i(eL,"finishMaybe");i(Yte,"endWritable");i(tL,"CorkedRequest")});function or(e){if(!(this instanceof or))return new or(e);ln.call(this,e),Un.call(this,e),e&&e.readable===!1&&(this.readable=!1),e&&e.writable===!1&&(this.writable=!1),this.allowHalfOpen=!0,e&&e.allowHalfOpen===!1&&(this.allowHalfOpen=!1),this.once("end",Kte)}function Kte(){this.allowHalfOpen||this._writableState.ended||tr(Jte,this)}function Jte(e){e.end()}var nL,bg,vg,_d=g(()=>{d();Li();Ci();E0();C0();bn(or,ln);nL=Object.keys(Un.prototype);for(vg=0;vg<nL.length;vg++)bg=nL[vg],or.prototype[bg]||(or.prototype[bg]=Un.prototype[bg]);i(or,"Duplex");i(Kte,"onend");i(Jte,"onEndNT")});function Xte(e){this.afterTransform=function(t,n){return Zte(e,t,n)},this.needTransform=!1,this.transforming=!1,this.writecb=null,this.writechunk=null,this.writeencoding=null}function Zte(e,t,n){var r=e._transformState;r.transforming=!1;var a=r.writecb;if(!a)return e.emit("error",new Error("no writecb in Transform class"));r.writechunk=null,r.writecb=null,n!=null&&e.push(n),a(t);var o=e._readableState;o.reading=!1,(o.needReadable||o.length<o.highWaterMark)&&e._read(o.highWaterMark)}function fr(e){if(!(this instanceof fr))return new fr(e);or.call(this,e),this._transformState=new Xte(this);var t=this;this._readableState.needReadable=!0,this._readableState.sync=!1,e&&(typeof e.transform=="function"&&(this._transform=e.transform),typeof e.flush=="function"&&(this._flush=e.flush)),this.once("prefinish",function(){typeof this._flush=="function"?this._flush(function(n){rL(t,n)}):rL(t)})}function rL(e,t){if(t)return e.emit("error",t);var n=e._writableState,r=e._transformState;if(n.length)throw new Error(
"Calling transform done when ws.length != 0");if(r.transforming)throw new Error("Calling transform done when still transforming");return e.push(null)}var k0=g(()=>{d();_d();Li();bn(fr,or);i(Xte,"TransformState");i(Zte,"afterTransform");i(fr,"Transform");fr.prototype.push=function(e,t){return this._transformState.needTransform=!1,or.prototype.push.call(this,e,t)};fr.prototype._transform=function(e,t,n){throw new Error("Not implemented")};fr.prototype._write=function(e,t,n){var r=this._transformState;if(r.writecb=n,r.writechunk=e,r.writeencoding=t,!r.transforming){var a=this._readableState;(r.needTransform||a.needReadable||a.length<a.highWaterMark)&&this._read(a.highWaterMark)}};fr.prototype._read=function(e){var t=this._transformState;t.writechunk!==null&&t.writecb&&!t.transforming?(t.transforming=!0,this._transform(t.writechunk,t.writeencoding,t.afterTransform)):t.needTransform=!0};i(rL,"done")});function bu(e){if(!(this instanceof bu))return new bu(e);fr.call(this,e)}var aL=g(()=>{d();k0();Li();bn(bu,fr);i(bu,"PassThrough");bu.prototype._transform=function(e,t,n){n(null,e)}});function Ya(){ea.call(this)}var I0,A0=g(()=>{d();Co();Li();_d();E0();C0();k0();aL();bn(Ya,ea);Ya.Readable=ln;Ya.Writable=Un;Ya.Duplex=or;Ya.Transform=fr;Ya.PassThrough=bu;Ya.Stream=Ya;I0=Ya;i(Ya,"Stream");Ya.prototype.pipe=function(e,t){var n=this;function r(m){e.writable&&e.write(m)===!1&&n.pause&&n.pause()}i(r,"ondata"),n.on("data",r);function a(){n.readable&&n.resume&&n.resume()}i(a,"ondrain"),e.on("drain",a),!e._isStdio&&(!t||t.end!==!1)&&(n.on("end",s),n.on("close",c));var o=!1;function s(){o||(o=!0,e.end())}i(s,"onend");function c(){o||(o=!0,typeof e.destroy=="function"&&e.destroy())}i(c,"onclose");function u(m){if(l(),ea.listenerCount(this,"error")===0)throw m}i(u,"onerror"),n.on("error",u),e.on("error",u);function l(){n.removeListener("data",r),e.removeListener("drain",a),n.removeListener("end",s),n.removeListener("close",c),n.removeListener("error",u),e.removeListener("error",u),n.removeListener("end",l),n.removeListener("close",l),e.removeListener("close",l)}return i(l,"clean\
up"),n.on("end",l),n.on("close",l),e.on("close",l),e.emit("pipe",n),e}});var wg,F0=g(()=>{d();wg={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}});function Qte(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}var oL,iL=g(()=>{d();i(Qte,"ZStream");oL=Qte});function wu(e,t,n,r,a){if(t.subarray&&e.subarray){e.set(t.subarray(n,n+r),a);return}for(var o=0;o<r;o++)e[a+o]=t[n+o]}var R0,Bo,_0=g(()=>{"use strict";d();i(wu,"arraySet");R0=Uint8Array,Bo=Uint16Array});function Du(e){for(var t=e.length;--t>=0;)e[t]=0}function O0(e,t,n,r,a){this.static_tree=e,this.extra_bits=t,this.extra_base=n,this.elems=r,this.max_length=a,this.has_stree=e&&e.length}function N0(e,t){this.dyn_tree=e,this.max_code=0,this.stat_desc=t}function EL(e){return e<256?Nd[e]:Nd[256+(e>>>7)]}function Ld(e,t){e.pending_buf[e.pending++]=t&255,e.pending_buf[e.pending++]=t>>>8&255}function Fr(e,t,n){e.bi_valid>M0-n?(e.bi_buf|=t<<e.bi_valid&65535,Ld(e,e.bi_buf),e.bi_buf=t>>M0-e.bi_valid,e.bi_valid+=n-M0):(e.bi_buf|=t<<e.bi_valid&65535,e.bi_valid+=n)}function Ka(e,t,n){Fr(e,n[t*2],n[t*2+1])}function TL(e,t){var n=0;do n|=e&1,e>>>=1,n<<=1;while(--t>0);return n>>>1}function une(e){e.bi_valid===16?(Ld(e,e.bi_buf),e.bi_buf=0,e.bi_valid=0):e.bi_valid>=8&&(e.pending_buf[e.pending++]=e.bi_buf&255,e.bi_buf>>=8,e.bi_valid-=8)}function lne(e,t){var n=t.dyn_tree,r=t.max_code,a=t.stat_desc.static_tree,o=t.stat_desc.has_stree,s=t.stat_desc.extra_bits,c=t.stat_desc.extra_base,u=t.stat_desc.max_length,
l,m,p,f,h,y,b=0;for(f=0;f<=tc;f++)e.bl_count[f]=0;for(n[e.heap[e.heap_max]*2+1]=0,l=e.heap_max+1;l<hL;l++)m=e.heap[l],f=n[n[m*2+1]*2+1]+1,f>u&&(f=u,b++),n[m*2+1]=f,!(m>r)&&(e.bl_count[f]++,h=0,m>=c&&(h=s[m-c]),y=n[m*2],e.opt_len+=y*(f+h),o&&(e.static_len+=y*(a[m*2+1]+h)));if(b!==0){do{for(f=u-1;e.bl_count[f]===0;)f--;e.bl_count[f]--,e.bl_count[f+1]+=2,e.bl_count[u]--,b-=2}while(b>0);for(f=u;f!==0;f--)for(m=e.bl_count[f];m!==0;)p=e.heap[--l],!(p>r)&&(n[p*2+1]!==f&&(e.opt_len+=(f-n[p*2+1])*n[p*2],n[p*2+1]=f),m--)}}function SL(e,t,n){var r=new Array(tc+1),a=0,o,s;for(o=1;o<=tc;o++)r[o]=a=a+n[o-1]<<1;for(s=0;s<=t;s++){var c=e[s*2+1];c!==0&&(e[s*2]=TL(r[c]++,c))}}function dne(){var e,t,n,r,a,o=new Array(tc+1);for(n=0,r=0;r<U0-1;r++)for(z0[r]=n,e=0;e<1<<L0[r];e++)Pd[n++]=r;for(Pd[n-1]=r,a=0,r=0;r<16;r++)for(Dg[r]=a,e=0;e<1<<xg[r];e++)Nd[a++]=r;for(a>>=7;r<xu;r++)for(Dg[r]=a<<7,e=0;e<1<<xg[r]-7;e++)Nd[256+a++]=r;for(t=0;t<=tc;t++)o[t]=0;for(e=0;e<=143;)Uo[e*2+1]=8,e++,o[8]++;for(;e<=255;)Uo[e*
2+1]=9,e++,o[9]++;for(;e<=279;)Uo[e*2+1]=7,e++,o[7]++;for(;e<=287;)Uo[e*2+1]=8,e++,o[8]++;for(SL(Uo,Od+1,o),e=0;e<xu;e++)Md[e*2+1]=5,Md[e*2]=TL(e,5);wL=new O0(Uo,L0,Bd+1,Od,tc),xL=new O0(Md,xg,0,xu,tc),DL=new O0(new Array(0),sne,0,j0,ine)}function CL(e){var t;for(t=0;t<Od;t++)e.dyn_ltree[t*2]=0;for(t=0;t<xu;t++)e.dyn_dtree[t*2]=0;for(t=0;t<j0;t++)e.bl_tree[t*2]=0;e.dyn_ltree[q0*2]=1,e.opt_len=e.static_len=0,e.last_lit=e.matches=0}function kL(e){e.bi_valid>8?Ld(e,e.bi_buf):e.bi_valid>0&&(e.pending_buf[e.pending++]=e.bi_buf),e.bi_buf=0,e.bi_valid=0}function mne(e,t,n,r){kL(e),r&&(Ld(e,n),Ld(e,~n)),wu(e.pending_buf,e.window,t,n,e.pending),e.pending+=n}function uL(e,t,n,r){var a=t*2,o=n*2;return e[a]<e[o]||e[a]===e[o]&&r[t]<=r[n]}function P0(e,t,n){for(var r=e.heap[n],a=n<<1;a<=e.heap_len&&(a<e.heap_len&&uL(t,e.heap[a+1],e.heap[a],e.depth)&&a++,!uL(t,r,e.heap[a],e.depth));)e.heap[n]=e.heap[a],n=a,a<<=1;e.heap[n]=r}function lL(e,t,n){var r,a,o=0,s,c;if(e.last_lit!==0)do r=e.pending_buf[e.d_buf+
o*2]<<8|e.pending_buf[e.d_buf+o*2+1],a=e.pending_buf[e.l_buf+o],o++,r===0?Ka(e,a,t):(s=Pd[a],Ka(e,s+Bd+1,t),c=L0[s],c!==0&&(a-=z0[s],Fr(e,a,c)),r--,s=EL(r),Ka(e,s,n),c=xg[s],c!==0&&(r-=Dg[s],Fr(e,r,c)));while(o<e.last_lit);Ka(e,q0,t)}function B0(e,t){var n=t.dyn_tree,r=t.stat_desc.static_tree,a=t.stat_desc.has_stree,o=t.stat_desc.elems,s,c,u=-1,l;for(e.heap_len=0,e.heap_max=hL,s=0;s<o;s++)n[s*2]!==0?(e.heap[++e.heap_len]=u=s,e.depth[s]=0):n[s*2+1]=0;for(;e.heap_len<2;)l=e.heap[++e.heap_len]=u<2?++u:0,n[l*2]=1,e.depth[l]=0,e.opt_len--,a&&(e.static_len-=r[l*2+1]);for(t.max_code=u,s=e.heap_len>>1;s>=1;s--)P0(e,n,s);l=o;do s=e.heap[1],e.heap[1]=e.heap[e.heap_len--],P0(e,n,1),c=e.heap[1],e.heap[--e.heap_max]=s,e.heap[--e.heap_max]=c,n[l*2]=n[s*2]+n[c*2],e.depth[l]=(e.depth[s]>=e.depth[c]?e.depth[s]:e.depth[c])+1,n[s*2+1]=n[c*2+1]=l,e.heap[1]=l++,P0(e,n,1);while(e.heap_len>=2);e.heap[--e.heap_max]=e.heap[1],lne(e,t),SL(n,u,e.bl_count)}function dL(e,t,n){var r,a=-1,o,s=t[0*2+1],c=0,u=7,l=4;for(s===
0&&(u=138,l=3),t[(n+1)*2+1]=65535,r=0;r<=n;r++)o=s,s=t[(r+1)*2+1],!(++c<u&&o===s)&&(c<l?e.bl_tree[o*2]+=c:o!==0?(o!==a&&e.bl_tree[o*2]++,e.bl_tree[gL*2]++):c<=10?e.bl_tree[yL*2]++:e.bl_tree[vL*2]++,c=0,a=o,s===0?(u=138,l=3):o===s?(u=6,l=3):(u=7,l=4))}function mL(e,t,n){var r,a=-1,o,s=t[0*2+1],c=0,u=7,l=4;for(s===0&&(u=138,l=3),r=0;r<=n;r++)if(o=s,s=t[(r+1)*2+1],!(++c<u&&o===s)){if(c<l)do Ka(e,o,e.bl_tree);while(--c!==0);else o!==0?(o!==a&&(Ka(e,o,e.bl_tree),c--),Ka(e,gL,e.bl_tree),Fr(e,c-3,2)):c<=10?(Ka(e,yL,e.bl_tree),Fr(e,c-3,3)):(Ka(e,vL,e.bl_tree),Fr(e,c-11,7));c=0,a=o,s===0?(u=138,l=3):o===s?(u=6,l=3):(u=7,l=4)}}function pne(e){var t;for(dL(e,e.dyn_ltree,e.l_desc.max_code),dL(e,e.dyn_dtree,e.d_desc.max_code),B0(e,e.bl_desc),t=j0-1;t>=3&&e.bl_tree[bL[t]*2+1]===0;t--);return e.opt_len+=3*(t+1)+5+5+4,t}function fne(e,t,n,r){var a;for(Fr(e,t-257,5),Fr(e,n-1,5),Fr(e,r-4,4),a=0;a<r;a++)Fr(e,e.bl_tree[bL[a]*2+1],3);mL(e,e.dyn_ltree,t-1),mL(e,e.dyn_dtree,n-1)}function hne(e){var t=4093624447,
n;for(n=0;n<=31;n++,t>>>=1)if(t&1&&e.dyn_ltree[n*2]!==0)return sL;if(e.dyn_ltree[9*2]!==0||e.dyn_ltree[10*2]!==0||e.dyn_ltree[13*2]!==0)return cL;for(n=32;n<Bd;n++)if(e.dyn_ltree[n*2]!==0)return cL;return sL}function IL(e){pL||(dne(),pL=!0),e.l_desc=new N0(e.dyn_ltree,wL),e.d_desc=new N0(e.dyn_dtree,xL),e.bl_desc=new N0(e.bl_tree,DL),e.bi_buf=0,e.bi_valid=0,CL(e)}function H0(e,t,n,r){Fr(e,(nne<<1)+(r?1:0),3),mne(e,t,n,!0)}function AL(e){Fr(e,fL<<1,3),Ka(e,q0,Uo),une(e)}function FL(e,t,n,r){var a,o,s=0;e.level>0?(e.strm.data_type===tne&&(e.strm.data_type=hne(e)),B0(e,e.l_desc),B0(e,e.d_desc),s=pne(e),a=e.opt_len+3+7>>>3,o=e.static_len+3+7>>>3,o<=a&&(a=o)):a=o=n+5,n+4<=a&&t!==-1?H0(e,t,n,r):e.strategy===ene||o===a?(Fr(e,(fL<<1)+(r?1:0),3),lL(e,Uo,Md)):(Fr(e,(rne<<1)+(r?1:0),3),fne(e,e.l_desc.max_code+1,e.d_desc.max_code+1,s+1),lL(e,e.dyn_ltree,e.dyn_dtree)),CL(e),r&&kL(e)}function jo(e,t,n){return e.pending_buf[e.d_buf+e.last_lit*2]=t>>>8&255,e.pending_buf[e.d_buf+e.last_lit*2+1]=t&255,e.
pending_buf[e.l_buf+e.last_lit]=n&255,e.last_lit++,t===0?e.dyn_ltree[n*2]++:(e.matches++,t--,e.dyn_ltree[(Pd[n]+Bd+1)*2]++,e.dyn_dtree[EL(t)*2]++),e.last_lit===e.lit_bufsize-1}var ene,sL,cL,tne,nne,fL,rne,ane,one,U0,Bd,Od,xu,j0,hL,tc,M0,ine,q0,gL,yL,vL,L0,xg,sne,bL,cne,Uo,Md,Nd,Pd,z0,Dg,wL,xL,DL,pL,RL=g(()=>{"use strict";d();_0();ene=4,sL=0,cL=1,tne=2;i(Du,"zero");nne=0,fL=1,rne=2,ane=3,one=258,U0=29,Bd=256,Od=Bd+1+U0,xu=30,j0=19,hL=2*Od+1,tc=15,M0=16,ine=7,q0=256,gL=16,yL=17,vL=18,L0=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],xg=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],sne=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],bL=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],cne=512,Uo=new Array((Od+2)*2);Du(Uo);Md=new Array(xu*2);Du(Md);Nd=new Array(cne);Du(Nd);Pd=new Array(one-ane+1);Du(Pd);z0=new Array(U0);Du(z0);Dg=new Array(xu);Du(Dg);i(O0,"StaticTreeDesc");i(N0,"TreeDesc");i(EL,"d_code");i(Ld,"put_short");i(Fr,"send_bits");i(Ka,"send_code");i(TL,
"bi_reverse");i(une,"bi_flush");i(lne,"gen_bitlen");i(SL,"gen_codes");i(dne,"tr_static_init");i(CL,"init_block");i(kL,"bi_windup");i(mne,"copy_block");i(uL,"smaller");i(P0,"pqdownheap");i(lL,"compress_block");i(B0,"build_tree");i(dL,"scan_tree");i(mL,"send_tree");i(pne,"build_bl_tree");i(fne,"send_all_trees");i(hne,"detect_data_type");pL=!1;i(IL,"_tr_init");i(H0,"_tr_stored_block");i(AL,"_tr_align");i(FL,"_tr_flush_block");i(jo,"_tr_tally")});function gne(e,t,n,r){for(var a=e&65535|0,o=e>>>16&65535|0,s=0;n!==0;){s=n>2e3?2e3:n,n-=s;do a=a+t[r++]|0,o=o+a|0;while(--s);a%=65521,o%=65521}return a|o<<16|0}var _L,ML=g(()=>{d();i(gne,"adler32");_L=gne});function yne(){for(var e,t=[],n=0;n<256;n++){e=n;for(var r=0;r<8;r++)e=e&1?3988292384^e>>>1:e>>>1;t[n]=e}return t}function bne(e,t,n,r){var a=vne,o=r+n;e^=-1;for(var s=r;s<o;s++)e=e>>>8^a[(e^t[s])&255];return e^-1}var vne,qo,OL=g(()=>{d();i(yne,"makeTable");vne=yne();i(bne,"crc32");qo=bne});function qi(e,t){return e.msg=wg[t],t}function LL(e){return(e<<1)-(e>4?9:0)}function nc(e){for(var t=e.length;--t>=0;)e[t]=0}function Bi(e){var t=e.state,n=t.pending;n>e.avail_out&&(n=e.avail_out),n!==0&&(wu(e.output,t.pending_buf,t.pending_out,n,e.next_out),e.next_out+=n,t.pending_out+=n,e.total_out+=n,e.avail_out-=n,t.pending-=n,t.pending===0&&(t.pending_out=0))}function Jn(e,t){FL(e,e.block_start>=0?e.block_start:-1,e.strstart-e.block_start,t),e.block_start=e.strstart,Bi(e.strm)}function Pt(e,t){e.pending_buf[e.pending++]=t}function Ud(e,t){e.pending_buf[e.pending++]=t>>>8&255,e.pending_buf[e.pending++]=t&255}function Lne(e,t,n,r){var a=e.avail_in;return a>r&&(a=r),a===0?0:(e.avail_in-=a,wu(t,e.input,e.next_in,a,n),e.state.wrap===1?e.adler=_L(e.adler,t,a,n):e.state.wrap===2&&(e.adler=qo(e.adler,t,a,n)),e.next_in+=a,e.total_in+=a,a)}function BL(e,t){var n=e.max_chain_length,r=e.strstart,a,o,s=e.prev_length,c=e.nice_match,u=e.strstart>e.w_size-Ca?e.strstart-(e.w_size-Ca):0,l=e.window,
m=e.w_mask,p=e.prev,f=e.strstart+ji,h=l[r+s-1],y=l[r+s];e.prev_length>=e.good_match&&(n>>=2),c>e.lookahead&&(c=e.lookahead);do if(a=t,!(l[a+s]!==y||l[a+s-1]!==h||l[a]!==l[r]||l[++a]!==l[r+1])){r+=2,a++;do;while(l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&l[++r]===l[++a]&&r<f);if(o=ji-(f-r),r=f-ji,o>s){if(e.match_start=t,s=o,o>=c)break;h=l[r+s-1],y=l[r+s]}}while((t=p[t&m])>u&&--n!==0);return s<=e.lookahead?s:e.lookahead}function zd(e){var t=e.w_size,n,r,a,o,s;do{if(o=e.window_size-e.lookahead-e.strstart,e.strstart>=t+(t-Ca)){wu(e.window,e.window,t,t,0),e.match_start-=t,e.strstart-=t,e.block_start-=t,r=e.hash_size,n=r;do a=e.head[--n],e.head[n]=a>=t?a-t:0;while(--r);r=t,n=r;do a=e.prev[--n],e.prev[n]=a>=t?a-t:0;while(--r);o+=t}if(e.strm.avail_in===0)break;if(r=Lne(e.strm,e.window,e.strstart+e.lookahead,o),e.lookahead+=r,e.lookahead+e.insert>=Gt)for(s=e.strstart-e.insert,e.ins_h=e.window[s],e.ins_h=(e.ins_h<<e.hash_shift^
e.window[s+1])&e.hash_mask;e.insert&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[s+Gt-1])&e.hash_mask,e.prev[s&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=s,s++,e.insert--,!(e.lookahead+e.insert<Gt)););}while(e.lookahead<Ca&&e.strm.avail_in!==0)}function Bne(e,t){var n=65535;for(n>e.pending_buf_size-5&&(n=e.pending_buf_size-5);;){if(e.lookahead<=1){if(zd(e),e.lookahead===0&&t===oc)return Rn;if(e.lookahead===0)break}e.strstart+=e.lookahead,e.lookahead=0;var r=e.block_start+n;if((e.strstart===0||e.strstart>=r)&&(e.lookahead=e.strstart-r,e.strstart=r,Jn(e,!1),e.strm.avail_out===0)||e.strstart-e.block_start>=e.w_size-Ca&&(Jn(e,!1),e.strm.avail_out===0))return Rn}return e.insert=0,t===zi?(Jn(e,!0),e.strm.avail_out===0?ac:Su):(e.strstart>e.block_start&&(Jn(e,!1),e.strm.avail_out===0),Rn)}function G0(e,t){for(var n,r;;){if(e.lookahead<Ca){if(zd(e),e.lookahead<Ca&&t===oc)return Rn;if(e.lookahead===0)break}if(n=0,e.lookahead>=Gt&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+Gt-1])&e.hash_mask,
n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),n!==0&&e.strstart-n<=e.w_size-Ca&&(e.match_length=BL(e,n)),e.match_length>=Gt)if(r=jo(e,e.strstart-e.match_start,e.match_length-Gt),e.lookahead-=e.match_length,e.match_length<=e.max_lazy_match&&e.lookahead>=Gt){e.match_length--;do e.strstart++,e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+Gt-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart;while(--e.match_length!==0);e.strstart++}else e.strstart+=e.match_length,e.match_length=0,e.ins_h=e.window[e.strstart],e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+1])&e.hash_mask;else r=jo(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++;if(r&&(Jn(e,!1),e.strm.avail_out===0))return Rn}return e.insert=e.strstart<Gt-1?e.strstart:Gt-1,t===zi?(Jn(e,!0),e.strm.avail_out===0?ac:Su):e.last_lit&&(Jn(e,!1),e.strm.avail_out===0)?Rn:qd}function Eu(e,t){for(var n,r,a;;){if(e.lookahead<Ca){if(zd(e),e.lookahead<Ca&&t===oc)return Rn;if(e.
lookahead===0)break}if(n=0,e.lookahead>=Gt&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+Gt-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart),e.prev_length=e.match_length,e.prev_match=e.match_start,e.match_length=Gt-1,n!==0&&e.prev_length<e.max_lazy_match&&e.strstart-n<=e.w_size-Ca&&(e.match_length=BL(e,n),e.match_length<=5&&(e.strategy===Tne||e.match_length===Gt&&e.strstart-e.match_start>4096)&&(e.match_length=Gt-1)),e.prev_length>=Gt&&e.match_length<=e.prev_length){a=e.strstart+e.lookahead-Gt,r=jo(e,e.strstart-1-e.prev_match,e.prev_length-Gt),e.lookahead-=e.prev_length-1,e.prev_length-=2;do++e.strstart<=a&&(e.ins_h=(e.ins_h<<e.hash_shift^e.window[e.strstart+Gt-1])&e.hash_mask,n=e.prev[e.strstart&e.w_mask]=e.head[e.ins_h],e.head[e.ins_h]=e.strstart);while(--e.prev_length!==0);if(e.match_available=0,e.match_length=Gt-1,e.strstart++,r&&(Jn(e,!1),e.strm.avail_out===0))return Rn}else if(e.match_available){if(r=jo(e,0,e.window[e.strstart-1]),r&&
Jn(e,!1),e.strstart++,e.lookahead--,e.strm.avail_out===0)return Rn}else e.match_available=1,e.strstart++,e.lookahead--}return e.match_available&&(r=jo(e,0,e.window[e.strstart-1]),e.match_available=0),e.insert=e.strstart<Gt-1?e.strstart:Gt-1,t===zi?(Jn(e,!0),e.strm.avail_out===0?ac:Su):e.last_lit&&(Jn(e,!1),e.strm.avail_out===0)?Rn:qd}function Une(e,t){for(var n,r,a,o,s=e.window;;){if(e.lookahead<=ji){if(zd(e),e.lookahead<=ji&&t===oc)return Rn;if(e.lookahead===0)break}if(e.match_length=0,e.lookahead>=Gt&&e.strstart>0&&(a=e.strstart-1,r=s[a],r===s[++a]&&r===s[++a]&&r===s[++a])){o=e.strstart+ji;do;while(r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&r===s[++a]&&a<o);e.match_length=ji-(o-a),e.match_length>e.lookahead&&(e.match_length=e.lookahead)}if(e.match_length>=Gt?(n=jo(e,1,e.match_length-Gt),e.lookahead-=e.match_length,e.strstart+=e.match_length,e.match_length=0):(n=jo(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++),n&&(Jn(e,!1),e.strm.avail_out===
0))return Rn}return e.insert=0,t===zi?(Jn(e,!0),e.strm.avail_out===0?ac:Su):e.last_lit&&(Jn(e,!1),e.strm.avail_out===0)?Rn:qd}function jne(e,t){for(var n;;){if(e.lookahead===0&&(zd(e),e.lookahead===0)){if(t===oc)return Rn;break}if(e.match_length=0,n=jo(e,0,e.window[e.strstart]),e.lookahead--,e.strstart++,n&&(Jn(e,!1),e.strm.avail_out===0))return Rn}return e.insert=0,t===zi?(Jn(e,!0),e.strm.avail_out===0?ac:Su):e.last_lit&&(Jn(e,!1),e.strm.avail_out===0)?Rn:qd}function Ja(e,t,n,r,a){this.good_length=e,this.max_lazy=t,this.nice_length=n,this.max_chain=r,this.func=a}function qne(e){e.window_size=2*e.w_size,nc(e.head),e.max_lazy_match=Tu[e.level].max_lazy,e.good_match=Tu[e.level].good_length,e.nice_match=Tu[e.level].nice_length,e.max_chain_length=Tu[e.level].max_chain,e.strstart=0,e.block_start=0,e.lookahead=0,e.insert=0,e.match_length=e.prev_length=Gt-1,e.match_available=0,e.ins_h=0}function zne(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=
0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=Y0,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new Bo(Mne*2),this.dyn_dtree=new Bo((2*Rne+1)*2),this.bl_tree=new Bo((2*_ne+1)*2),nc(this.dyn_ltree),nc(this.dyn_dtree),nc(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new Bo(One+1),this.heap=new Bo(2*V0+1),nc(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new Bo(2*V0+1),nc(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,
this.insert=0,this.bi_buf=0,this.bi_valid=0}function Hne(e){var t;return!e||!e.state?qi(e,Hi):(e.total_in=e.total_out=0,e.data_type=kne,t=e.state,t.pending=0,t.pending_out=0,t.wrap<0&&(t.wrap=-t.wrap),t.status=t.wrap?K0:rc,e.adler=t.wrap===2?0:1,t.last_flush=oc,IL(t),Ui)}function J0(e){var t=Hne(e);return t===Ui&&qne(e.state),t}function UL(e,t,n,r,a,o){if(!e)return Hi;var s=1;if(t===Ene&&(t=6),r<0?(s=0,r=-r):r>15&&(s=2,r-=16),a<1||a>Ine||n!==Y0||r<8||r>15||t<0||t>9||o<0||o>Cne)return qi(e,Hi);r===8&&(r=9);var c=new zne;return e.state=c,c.strm=e,c.wrap=s,c.gzhead=null,c.w_bits=r,c.w_size=1<<c.w_bits,c.w_mask=c.w_size-1,c.hash_bits=a+7,c.hash_size=1<<c.hash_bits,c.hash_mask=c.hash_size-1,c.hash_shift=~~((c.hash_bits+Gt-1)/Gt),c.window=new R0(c.w_size*2),c.head=new Bo(c.hash_size),c.prev=new Bo(c.w_size),c.lit_bufsize=1<<a+6,c.pending_buf_size=c.lit_bufsize*4,c.pending_buf=new R0(c.pending_buf_size),c.d_buf=1*c.lit_bufsize,c.l_buf=3*c.lit_bufsize,c.level=t,c.strategy=o,c.method=n,J0(e)}function jL(e,t){
var n,r,a,o;if(!e||!e.state||t>NL||t<0)return e?qi(e,Hi):Hi;if(r=e.state,!e.output||!e.input&&e.avail_in!==0||r.status===jd&&t!==zi)return qi(e,e.avail_out===0?W0:Hi);if(r.strm=e,n=r.last_flush,r.last_flush=t,r.status===K0)if(r.wrap===2)e.adler=0,Pt(r,31),Pt(r,139),Pt(r,8),r.gzhead?(Pt(r,(r.gzhead.text?1:0)+(r.gzhead.hcrc?2:0)+(r.gzhead.extra?4:0)+(r.gzhead.name?8:0)+(r.gzhead.comment?16:0)),Pt(r,r.gzhead.time&255),Pt(r,r.gzhead.time>>8&255),Pt(r,r.gzhead.time>>16&255),Pt(r,r.gzhead.time>>24&255),Pt(r,r.level===9?2:r.strategy>=Eg||r.level<2?4:0),Pt(r,r.gzhead.os&255),r.gzhead.extra&&r.gzhead.extra.length&&(Pt(r,r.gzhead.extra.length&255),Pt(r,r.gzhead.extra.length>>8&255)),r.gzhead.hcrc&&(e.adler=qo(e.adler,r.pending_buf,r.pending,0)),r.gzindex=0,r.status=$0):(Pt(r,0),Pt(r,0),Pt(r,0),Pt(r,0),Pt(r,0),Pt(r,r.level===9?2:r.strategy>=Eg||r.level<2?4:0),Pt(r,Pne),r.status=rc);else{var s=Y0+(r.w_bits-8<<4)<<8,c=-1;r.strategy>=Eg||r.level<2?c=0:r.level<6?c=1:r.level===6?c=2:c=3,s|=c<<6,r.strstart!==
0&&(s|=Nne),s+=31-s%31,r.status=rc,Ud(r,s),r.strstart!==0&&(Ud(r,e.adler>>>16),Ud(r,e.adler&65535)),e.adler=1}if(r.status===$0)if(r.gzhead.extra){for(a=r.pending;r.gzindex<(r.gzhead.extra.length&65535)&&!(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>a&&(e.adler=qo(e.adler,r.pending_buf,r.pending-a,a)),Bi(e),a=r.pending,r.pending===r.pending_buf_size));)Pt(r,r.gzhead.extra[r.gzindex]&255),r.gzindex++;r.gzhead.hcrc&&r.pending>a&&(e.adler=qo(e.adler,r.pending_buf,r.pending-a,a)),r.gzindex===r.gzhead.extra.length&&(r.gzindex=0,r.status=Tg)}else r.status=Tg;if(r.status===Tg)if(r.gzhead.name){a=r.pending;do{if(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>a&&(e.adler=qo(e.adler,r.pending_buf,r.pending-a,a)),Bi(e),a=r.pending,r.pending===r.pending_buf_size)){o=1;break}r.gzindex<r.gzhead.name.length?o=r.gzhead.name.charCodeAt(r.gzindex++)&255:o=0,Pt(r,o)}while(o!==0);r.gzhead.hcrc&&r.pending>a&&(e.adler=qo(e.adler,r.pending_buf,r.pending-a,a)),o===0&&(r.gzindex=0,r.status=
Sg)}else r.status=Sg;if(r.status===Sg)if(r.gzhead.comment){a=r.pending;do{if(r.pending===r.pending_buf_size&&(r.gzhead.hcrc&&r.pending>a&&(e.adler=qo(e.adler,r.pending_buf,r.pending-a,a)),Bi(e),a=r.pending,r.pending===r.pending_buf_size)){o=1;break}r.gzindex<r.gzhead.comment.length?o=r.gzhead.comment.charCodeAt(r.gzindex++)&255:o=0,Pt(r,o)}while(o!==0);r.gzhead.hcrc&&r.pending>a&&(e.adler=qo(e.adler,r.pending_buf,r.pending-a,a)),o===0&&(r.status=Cg)}else r.status=Cg;if(r.status===Cg&&(r.gzhead.hcrc?(r.pending+2>r.pending_buf_size&&Bi(e),r.pending+2<=r.pending_buf_size&&(Pt(r,e.adler&255),Pt(r,e.adler>>8&255),e.adler=0,r.status=rc)):r.status=rc),r.pending!==0){if(Bi(e),e.avail_out===0)return r.last_flush=-1,Ui}else if(e.avail_in===0&&LL(t)<=LL(n)&&t!==zi)return qi(e,W0);if(r.status===jd&&e.avail_in!==0)return qi(e,W0);if(e.avail_in!==0||r.lookahead!==0||t!==oc&&r.status!==jd){var u=r.strategy===Eg?jne(r,t):r.strategy===Sne?Une(r,t):Tu[r.level].func(r,t);if((u===ac||u===Su)&&(r.status=jd),
u===Rn||u===ac)return e.avail_out===0&&(r.last_flush=-1),Ui;if(u===qd&&(t===wne?AL(r):t!==NL&&(H0(r,0,0,!1),t===xne&&(nc(r.head),r.lookahead===0&&(r.strstart=0,r.block_start=0,r.insert=0))),Bi(e),e.avail_out===0))return r.last_flush=-1,Ui}return t!==zi?Ui:r.wrap<=0?PL:(r.wrap===2?(Pt(r,e.adler&255),Pt(r,e.adler>>8&255),Pt(r,e.adler>>16&255),Pt(r,e.adler>>24&255),Pt(r,e.total_in&255),Pt(r,e.total_in>>8&255),Pt(r,e.total_in>>16&255),Pt(r,e.total_in>>24&255)):(Ud(r,e.adler>>>16),Ud(r,e.adler&65535)),Bi(e),r.wrap>0&&(r.wrap=-r.wrap),r.pending!==0?Ui:PL)}function qL(e){var t;return!e||!e.state?Hi:(t=e.state.status,t!==K0&&t!==$0&&t!==Tg&&t!==Sg&&t!==Cg&&t!==rc&&t!==jd?qi(e,Hi):(e.state=null,t===rc?qi(e,Dne):Ui))}var oc,wne,xne,zi,NL,Ui,PL,Hi,Dne,W0,Ene,Tne,Eg,Sne,Cne,kne,Y0,Ine,Ane,Fne,V0,Rne,_ne,Mne,One,Gt,ji,Ca,Nne,K0,$0,Tg,Sg,Cg,rc,jd,Rn,qd,ac,Su,Pne,Tu,zL=g(()=>{d();_0();RL();ML();OL();F0();oc=0,wne=1,xne=3,zi=4,NL=5,Ui=0,PL=1,Hi=-2,Dne=-3,W0=-5,Ene=-1,Tne=1,Eg=2,Sne=3,Cne=4,kne=2,Y0=8,
Ine=9,Ane=29,Fne=256,V0=Fne+1+Ane,Rne=30,_ne=19,Mne=2*V0+1,One=15,Gt=3,ji=258,Ca=ji+Gt+1,Nne=32,K0=42,$0=69,Tg=73,Sg=91,Cg=103,rc=113,jd=666,Rn=1,qd=2,ac=3,Su=4,Pne=3;i(qi,"err");i(LL,"rank");i(nc,"zero");i(Bi,"flush_pending");i(Jn,"flush_block_only");i(Pt,"put_byte");i(Ud,"putShortMSB");i(Lne,"read_buf");i(BL,"longest_match");i(zd,"fill_window");i(Bne,"deflate_stored");i(G0,"deflate_fast");i(Eu,"deflate_slow");i(Une,"deflate_rle");i(jne,"deflate_huff");i(Ja,"Config");Tu=[new Ja(0,0,0,0,Bne),new Ja(4,4,8,4,G0),new Ja(4,5,16,8,G0),new Ja(4,6,32,32,G0),new Ja(4,4,16,16,Eu),new Ja(8,16,32,32,Eu),new Ja(8,16,128,128,Eu),new Ja(8,32,128,256,Eu),new Ja(32,128,258,1024,Eu),new Ja(32,258,258,4096,Eu)];i(qne,"lm_init");i(zne,"DeflateState");i(Hne,"deflateResetKeep");i(J0,"deflateReset");i(UL,"deflateInit2");i(jL,"deflate");i(qL,"deflateEnd")});var HL=g(()=>{d()});var Rg={};E(Rg,{DEFLATE:()=>ku,DEFLATERAW:()=>Cu,GUNZIP:()=>Ig,GZIP:()=>Hd,INFLATE:()=>Ag,INFLATERAW:()=>Wd,NONE:()=>X0,UNZIP:()=>Gd,Z_BEST_COMPRESSION:()=>Zne,Z_BEST_SPEED:()=>Xne,Z_BINARY:()=>ore,Z_BLOCK:()=>KL,Z_BUF_ERROR:()=>Kne,Z_DATA_ERROR:()=>Yne,Z_DEFAULT_COMPRESSION:()=>Qne,Z_DEFAULT_STRATEGY:()=>are,Z_DEFLATED:()=>XL,Z_ERRNO:()=>Vne,Z_FILTERED:()=>ere,Z_FINISH:()=>YL,Z_FIXED:()=>rre,Z_FULL_FLUSH:()=>$L,Z_HUFFMAN_ONLY:()=>tre,Z_NEED_DICT:()=>Gne,Z_NO_COMPRESSION:()=>Jne,Z_NO_FLUSH:()=>WL,Z_OK:()=>Fg,Z_PARTIAL_FLUSH:()=>GL,Z_RLE:()=>nre,Z_STREAM_END:()=>JL,Z_STREAM_ERROR:()=>$ne,Z_SYNC_FLUSH:()=>VL,Z_TEXT:()=>ire,Z_TREES:()=>Wne,Z_UNKNOWN:()=>sre,Zlib:()=>Xa});function Xa(e){if(e<ku||e>Gd)throw new TypeError("Bad argument");this.mode=e,this.init_done=!1,this.write_in_progress=!1,this.pending_close=!1,this.windowBits=0,this.level=0,this.memLevel=0,this.strategy=0,this.dictionary=null}function cre(e,t){for(var n=0;n<e.length;n++)this[t+n]=e[n]}var X0,ku,Ag,Hd,Ig,Cu,Wd,Gd,WL,GL,VL,
$L,YL,KL,Wne,Fg,JL,Gne,Vne,$ne,Yne,Kne,Jne,Xne,Zne,Qne,ere,tre,nre,rre,are,ore,ire,sre,XL,kg,ZL=g(()=>{d();F0();iL();zL();HL();X0=0,ku=1,Ag=2,Hd=3,Ig=4,Cu=5,Wd=6,Gd=7,WL=0,GL=1,VL=2,$L=3,YL=4,KL=5,Wne=6,Fg=0,JL=1,Gne=2,Vne=-1,$ne=-2,Yne=-3,Kne=-5,Jne=0,Xne=1,Zne=9,Qne=-1,ere=1,tre=2,nre=3,rre=4,are=0,ore=0,ire=1,sre=2,XL=8;i(Xa,"Zlib");Xa.prototype.init=function(e,t,n,r,a){this.windowBits=e,this.level=t,this.memLevel=n,this.strategy=r,(this.mode===Hd||this.mode===Ig)&&(this.windowBits+=16),this.mode===Gd&&(this.windowBits+=32),(this.mode===Cu||this.mode===Wd)&&(this.windowBits=-this.windowBits),this.strm=new oL;var o;switch(this.mode){case ku:case Hd:case Cu:o=UL(this.strm,this.level,XL,this.windowBits,this.memLevel,this.strategy);break;case Ag:case Ig:case Wd:case Gd:o=(this.strm,this.windowBits,void 0);break;default:throw new Error("Unknown mode "+this.mode)}if(o!==Fg){this._error(o);return}this.write_in_progress=!1,this.init_done=!0};Xa.prototype.params=function(){throw new Error("d\
eflateParams Not supported")};Xa.prototype._writeCheck=function(){if(!this.init_done)throw new Error("write before init");if(this.mode===X0)throw new Error("already finalized");if(this.write_in_progress)throw new Error("write already in progress");if(this.pending_close)throw new Error("close is pending")};Xa.prototype.write=function(e,t,n,r,a,o,s){this._writeCheck(),this.write_in_progress=!0;var c=this;return process.nextTick(function(){c.write_in_progress=!1;var u=c._write(e,t,n,r,a,o,s);c.callback(u[0],u[1]),c.pending_close&&c.close()}),this};i(cre,"bufferSet");Xa.prototype.writeSync=function(e,t,n,r,a,o,s){return this._writeCheck(),this._write(e,t,n,r,a,o,s)};Xa.prototype._write=function(e,t,n,r,a,o,s){if(this.write_in_progress=!0,e!==WL&&e!==GL&&e!==VL&&e!==$L&&e!==YL&&e!==KL)throw new Error("Invalid flush value");t==null&&(t=new Buffer(0),r=0,n=0),a._set?a.set=a._set:a.set=cre;var c=this.strm;c.avail_in=r,c.input=t,c.next_in=n,c.avail_out=s,c.output=a,c.next_out=o;var u;switch(this.
mode){case ku:case Hd:case Cu:u=jL(c,e);break;case Gd:case Ag:case Ig:case Wd:u=void 0;break;default:throw new Error("Unknown mode "+this.mode)}return u!==JL&&u!==Fg&&this._error(u),this.write_in_progress=!1,[c.avail_in,c.avail_out]};Xa.prototype.close=function(){if(this.write_in_progress){this.pending_close=!0;return}this.pending_close=!1,this.mode===ku||this.mode===Hd||this.mode===Cu?qL(this.strm):(this.strm,void 0),this.mode=X0};Xa.prototype.reset=function(){switch(this.mode){case ku:case Cu:kg=J0(this.strm);break;case Ag:case Wd:kg=(this.strm,void 0);break}kg!==Fg&&this._error(kg)};Xa.prototype._error=function(e){this.onerror(wg[e]+": "+this.strm.msg,e),this.write_in_progress=!1,this.pending_close&&this.close()}});function ure(e,t){if(!e)throw new Error(t)}function QL(e){return new Vd(e)}function e5(e,t,n){return typeof t=="function"&&(n=t,t={}),lre(new Vd(t),e,n)}function t5(e,t){return dre(new _g(t),e)}function lre(e,t,n){var r=[],a=0;e.on("error",s),e.on("end",c),e.end(t),o();function o(){for(var u;(u=e.read())!==null;)r.push(u),a+=u.length;e.once("readable",o)}i(o,"flow");function s(u){e.removeListener("end",c),e.removeListener("readable",o),n(u)}i(s,"onError");function c(){var u=Buffer.concat(r,a);r=[],n(null,u),e.close()}i(c,"onEnd")}function dre(e,t){if(typeof t=="string"&&(t=new Buffer(t)),!Buffer.isBuffer(t))throw new TypeError("Not a string or buffer");var n=xe.Z_FINISH;return e._processChunk(t,n)}function Q0(e){if(!(this instanceof Q0))return new Q0(e);wn.call(this,e,xe.DEFLATE)}function ew(e){if(!(this instanceof ew))return new ew(e);wn.call(this,e,xe.INFLATE)}function Vd(e){if(!(this instanceof Vd))return new Vd(e);wn.call(this,e,xe.GZIP)}function _g(e){if(!(this instanceof _g))return new _g(
e);wn.call(this,e,xe.GUNZIP)}function tw(e){if(!(this instanceof tw))return new tw(e);wn.call(this,e,xe.DEFLATERAW)}function nw(e){if(!(this instanceof nw))return new nw(e);wn.call(this,e,xe.INFLATERAW)}function rw(e){if(!(this instanceof rw))return new rw(e);wn.call(this,e,xe.UNZIP)}function wn(e,t){if(this._opts=e=e||{},this._chunkSize=e.chunkSize||xe.Z_DEFAULT_CHUNK,fr.call(this,e),e.flush&&e.flush!==xe.Z_NO_FLUSH&&e.flush!==xe.Z_PARTIAL_FLUSH&&e.flush!==xe.Z_SYNC_FLUSH&&e.flush!==xe.Z_FULL_FLUSH&&e.flush!==xe.Z_FINISH&&e.flush!==xe.Z_BLOCK)throw new Error("Invalid flush flag: "+e.flush);if(this._flushFlag=e.flush||xe.Z_NO_FLUSH,e.chunkSize&&(e.chunkSize<xe.Z_MIN_CHUNK||e.chunkSize>xe.Z_MAX_CHUNK))throw new Error("Invalid chunk size: "+e.chunkSize);if(e.windowBits&&(e.windowBits<xe.Z_MIN_WINDOWBITS||e.windowBits>xe.Z_MAX_WINDOWBITS))throw new Error("Invalid windowBits: "+e.windowBits);if(e.level&&(e.level<xe.Z_MIN_LEVEL||e.level>xe.Z_MAX_LEVEL))throw new Error("Invalid compression l\
evel: "+e.level);if(e.memLevel&&(e.memLevel<xe.Z_MIN_MEMLEVEL||e.memLevel>xe.Z_MAX_MEMLEVEL))throw new Error("Invalid memLevel: "+e.memLevel);if(e.strategy&&e.strategy!=xe.Z_FILTERED&&e.strategy!=xe.Z_HUFFMAN_ONLY&&e.strategy!=xe.Z_RLE&&e.strategy!=xe.Z_FIXED&&e.strategy!=xe.Z_DEFAULT_STRATEGY)throw new Error("Invalid strategy: "+e.strategy);if(e.dictionary&&!Buffer.isBuffer(e.dictionary))throw new Error("Invalid dictionary: it should be a Buffer instance");this._binding=new xe.Zlib(t);var n=this;this._hadError=!1,this._binding.onerror=function(o,s){n._binding=null,n._hadError=!0;var c=new Error(o);c.errno=s,c.code=xe.codes[s],n.emit("error",c)};var r=xe.Z_DEFAULT_COMPRESSION;typeof e.level=="number"&&(r=e.level);var a=xe.Z_DEFAULT_STRATEGY;typeof e.strategy=="number"&&(a=e.strategy),this._binding.init(e.windowBits||xe.Z_DEFAULT_WINDOWBITS,r,e.memLevel||xe.Z_DEFAULT_MEMLEVEL,a,e.dictionary),this._buffer=new Buffer(this._chunkSize),this._offset=0,this._closed=!1,this._level=r,this._strategy=
a,this.once("end",this.close)}var xe,Z0,aw=g(()=>{d();A0();ZL();Li();i(ure,"assert");xe={};Object.keys(Rg).forEach(function(e){xe[e]=Rg[e]});xe.Z_MIN_WINDOWBITS=8;xe.Z_MAX_WINDOWBITS=15;xe.Z_DEFAULT_WINDOWBITS=15;xe.Z_MIN_CHUNK=64;xe.Z_MAX_CHUNK=1/0;xe.Z_DEFAULT_CHUNK=16*1024;xe.Z_MIN_MEMLEVEL=1;xe.Z_MAX_MEMLEVEL=9;xe.Z_DEFAULT_MEMLEVEL=8;xe.Z_MIN_LEVEL=-1;xe.Z_MAX_LEVEL=9;xe.Z_DEFAULT_LEVEL=xe.Z_DEFAULT_COMPRESSION;Z0={Z_OK:xe.Z_OK,Z_STREAM_END:xe.Z_STREAM_END,Z_NEED_DICT:xe.Z_NEED_DICT,Z_ERRNO:xe.Z_ERRNO,Z_STREAM_ERROR:xe.Z_STREAM_ERROR,Z_DATA_ERROR:xe.Z_DATA_ERROR,Z_MEM_ERROR:xe.Z_MEM_ERROR,Z_BUF_ERROR:xe.Z_BUF_ERROR,Z_VERSION_ERROR:xe.Z_VERSION_ERROR};Object.keys(Z0).forEach(function(e){Z0[Z0[e]]=e});i(QL,"createGzip");i(e5,"gzip");i(t5,"gunzipSync");i(lre,"zlibBuffer");i(dre,"zlibBufferSync");i(Q0,"Deflate");i(ew,"Inflate");i(Vd,"Gzip");i(_g,"Gunzip");i(tw,"DeflateRaw");i(nw,"InflateRaw");i(rw,"Unzip");i(wn,"Zlib");bn(wn,fr);wn.prototype.params=function(e,t,n){if(e<xe.Z_MIN_LEVEL||
e>xe.Z_MAX_LEVEL)throw new RangeError("Invalid compression level: "+e);if(t!=xe.Z_FILTERED&&t!=xe.Z_HUFFMAN_ONLY&&t!=xe.Z_RLE&&t!=xe.Z_FIXED&&t!=xe.Z_DEFAULT_STRATEGY)throw new TypeError("Invalid strategy: "+t);if(this._level!==e||this._strategy!==t){var r=this;this.flush(xe.Z_SYNC_FLUSH,function(){r._binding.params(e,t),r._hadError||(r._level=e,r._strategy=t,n&&n())})}else process.nextTick(n)};wn.prototype.reset=function(){return this._binding.reset()};wn.prototype._flush=function(e){this._transform(new Buffer(0),"",e)};wn.prototype.flush=function(e,t){var n=this._writableState;if((typeof e=="function"||e===void 0&&!t)&&(t=e,e=xe.Z_FULL_FLUSH),n.ended)t&&process.nextTick(t);else if(n.ending)t&&this.once("end",t);else if(n.needDrain){var r=this;this.once("drain",function(){r.flush(t)})}else this._flushFlag=e,this.write(new Buffer(0),"",t)};wn.prototype.close=function(e){if(e&&process.nextTick(e),!this._closed){this._closed=!0,this._binding.close();var t=this;process.nextTick(function(){
t.emit("close")})}};wn.prototype._transform=function(e,t,n){var r,a=this._writableState,o=a.ending||a.ended,s=o&&(!e||a.length===e.length);if(!e===null&&!Buffer.isBuffer(e))return n(new Error("invalid input"));s?r=xe.Z_FINISH:(r=this._flushFlag,e.length>=a.length&&(this._flushFlag=this._opts.flush||xe.Z_NO_FLUSH)),this._processChunk(e,r,n)};wn.prototype._processChunk=function(e,t,n){var r=e&&e.length,a=this._chunkSize-this._offset,o=0,s=this,c=typeof n=="function";if(!c){var u=[],l=0,m;this.on("error",function(b){m=b});do var p=this._binding.writeSync(t,e,o,r,this._buffer,this._offset,a);while(!this._hadError&&y(p[0],p[1]));if(this._hadError)throw m;var f=Buffer.concat(u,l);return this.close(),f}var h=this._binding.write(t,e,o,r,this._buffer,this._offset,a);h.buffer=e,h.callback=y;function y(b,w){if(!s._hadError){var D=a-w;if(ure(D>=0,"have should not go down"),D>0){var T=s._buffer.slice(s._offset,s._offset+D);s._offset+=D,c?s.push(T):(u.push(T),l+=T.length)}if((w===0||s._offset>=s._chunkSize)&&
(a=s._chunkSize,s._offset=0,s._buffer=new Buffer(s._chunkSize)),w===0){if(o+=r-b,r=b,!c)return!0;var S=s._binding.write(t,e,o,r,s._buffer,s._offset,s._chunkSize);S.callback=y,S.buffer=e;return}if(!c)return!1;n()}}i(y,"callback")};bn(Q0,wn);bn(ew,wn);bn(Vd,wn);bn(_g,wn);bn(tw,wn);bn(nw,wn);bn(rw,wn)});var ge,ow=g(()=>{d();ge=class extends Error{static{i(this,"LanternError")}}});var Mg,n5,mre,pre,zo,r5=g(()=>{d();ow();Mg=class{static{i(this,"UrlUtils")}static rewriteChromeInternalUrl(t){return t?.startsWith("chrome://")?(t.endsWith("/")&&(t=t.replace(/\/$/,"")),t.replace(/^chrome:\/\/chrome\//,"chrome://")):t}static equalWithExcludedFragments(t,n){[t,n]=[t,n].map(this.rewriteChromeInternalUrl);try{let r=new URL(t);r.hash="";let a=new URL(n);return a.hash="",r.href===a.href}catch{return!1}}},n5=14*1024,mre=.4,pre={Document:.9,XHR:.9,Fetch:.9},zo=class e{static{i(this,"NetworkAnalyzer")}static get summary(){return"__SUMMARY__"}static groupByOrigin(t){let n=new Map;return t.forEach(r=>{let a=r.parsedURL.securityOrigin,o=n.get(a)||[];o.push(r),n.set(a,o)}),n}static getSummary(t){t.sort((r,a)=>r-a);let n;if(t.length===0)n=t[0];else if(t.length%2===0){let r=t[Math.floor((t.length-1)/2)],a=t[Math.floor((t.length-1)/2)+1];n=(r+a)/2}else n=t[Math.floor((t.length-1)/2)];return{min:t[0],max:t[t.length-1],avg:t.reduce((r,a)=>r+a,0)/t.length,median:n}}static summarize(t){let n=new Map,
r=[];for(let[a,o]of t)n.set(a,e.getSummary(o)),r.push(...o);return n.set(e.summary,e.getSummary(r)),n}static estimateValueByOrigin(t,n){let r=e.estimateIfConnectionWasReused(t),a=e.groupByOrigin(t),o=new Map;for(let[s,c]of a.entries()){let u=[];for(let l of c){let m=l.timing;if(!m)continue;let p=n({request:l,timing:m,connectionReused:r.get(l.requestId)});typeof p<"u"&&(u=u.concat(p))}u.length&&o.set(s,u)}return o}static estimateRTTViaConnectionTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(r)return;let{connectStart:o,sslStart:s,sslEnd:c,connectEnd:u}=n;if(u>=0&&o>=0&&a.protocol.startsWith("h3"))return u-o;if(s>=0&&c>=0&&s!==o)return[u-s,s-o];if(o>=0&&u>=0)return u-o}static estimateRTTViaDownloadTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(r||a.transferSize<=n5||!Number.isFinite(n.receiveHeadersEnd)||n.receiveHeadersEnd<0)return;let s=a.networkEndTime-a.networkRequestTime-n.receiveHeadersEnd,c=Math.log2(a.transferSize/n5);if(!(c>5))return s/c}static estimateRTTViaSendStartTiming(t){
let{timing:n,connectionReused:r,request:a}=t;if(r||!Number.isFinite(n.sendStart)||n.sendStart<0)return;let o=1;return a.protocol.startsWith("h3")||(o+=1),a.parsedURL.scheme==="https"&&(o+=1),n.sendStart/o}static estimateRTTViaHeadersEndTiming(t){let{timing:n,connectionReused:r,request:a}=t;if(!Number.isFinite(n.receiveHeadersEnd)||n.receiveHeadersEnd<0||!a.resourceType)return;let o=pre[a.resourceType]||mre,s=n.receiveHeadersEnd*o,c=1;return r||(c+=1,a.protocol.startsWith("h3")||(c+=1),a.parsedURL.scheme==="https"&&(c+=1)),Math.max((n.receiveHeadersEnd-s)/c,3)}static estimateResponseTimeByOrigin(t,n){return e.estimateValueByOrigin(t,({request:r,timing:a})=>{if(r.serverResponseTime!==void 0)return r.serverResponseTime;if(!Number.isFinite(a.receiveHeadersEnd)||a.receiveHeadersEnd<0||!Number.isFinite(a.sendEnd)||a.sendEnd<0)return;let o=a.receiveHeadersEnd-a.sendEnd,s=r.parsedURL.securityOrigin,c=n.get(s)||n.get(e.summary)||0;return Math.max(o-c,0)})}static canTrustConnectionInformation(t){
let n=new Map;for(let r of t){let a=n.get(r.connectionId)||!r.connectionReused;n.set(r.connectionId,a)}return n.size<=1?!1:Array.from(n.values()).every(r=>r)}static estimateIfConnectionWasReused(t,n){let{forceCoarseEstimates:r=!1}=n||{};if(!r&&e.canTrustConnectionInformation(t))return new Map(t.map(s=>[s.requestId,!!s.connectionReused]));let a=new Map,o=e.groupByOrigin(t);for(let s of o.values()){let c=s.map(l=>l.networkEndTime).reduce((l,m)=>Math.min(l,m),1/0);for(let l of s)a.set(l.requestId,l.networkRequestTime>=c||l.protocol==="h2");let u=s.reduce((l,m)=>l.networkRequestTime>m.networkRequestTime?m:l);a.set(u.requestId,!1)}return a}static estimateRTTByOrigin(t,n){let{forceCoarseEstimates:r=!1,coarseEstimateMultiplier:a=.3,useDownloadEstimates:o=!0,useSendStartEstimates:s=!0,useHeadersEndEstimates:c=!0}=n||{},u=e.estimateIfConnectionWasReused(t),l=e.groupByOrigin(t),m=new Map;for(let[p,f]of l.entries()){let y=function(b,w=1){for(let D of f){let T=D.timing;if(!T||!D.transferSize)continue;
let S=b({request:D,timing:T,connectionReused:u.get(D.requestId)});S!==void 0&&(Array.isArray(S)?h.push(...S.map(k=>k*w)):h.push(S*w))}};i(y,"collectEstimates");let h=[];r||y(this.estimateRTTViaConnectionTiming),h.length||(o&&y(this.estimateRTTViaDownloadTiming,a),s&&y(this.estimateRTTViaSendStartTiming,a),c&&y(this.estimateRTTViaHeadersEndTiming,a)),h.length&&m.set(p,h)}if(!m.size)throw new ge("No timing information available");return e.summarize(m)}static estimateServerResponseTimeByOrigin(t,n){let r=n?.rttByOrigin;if(!r){r=new Map;let o=e.estimateRTTByOrigin(t,n);for(let[s,c]of o.entries())r.set(s,c.min)}let a=e.estimateResponseTimeByOrigin(t,r);return e.summarize(a)}static estimateThroughput(t){let n=0,r=t.reduce((c,u)=>(u.parsedURL?.scheme==="data"||u.failed||!u.finished||u.statusCode>300||!u.transferSize||(n+=u.transferSize,c.push({time:u.responseHeadersEndTime/1e3,isStart:!0}),c.push({time:u.networkEndTime/1e3,isStart:!1})),c),[]).sort((c,u)=>c.time-u.time);if(!r.length)return null;
let a=0,o=0,s=0;return r.forEach(c=>{c.isStart?(a===0&&(o=c.time),a++):(a--,a===0&&(s+=c.time-o))}),n*8/s}static computeRTTAndServerResponseTime(t){let n=new Map;for(let[c,u]of e.estimateRTTByOrigin(t).entries())n.set(c,u.min);let r=Math.min(...Array.from(n.values())),a=e.estimateServerResponseTimeByOrigin(t,{rttByOrigin:n}),o=new Map,s=new Map;for(let[c,u]of a.entries()){let l=n.get(c)||r;o.set(c,l-r),s.set(c,u.median)}return{rtt:r,additionalRttByOrigin:o,serverResponseTimeByOrigin:s}}static analyze(t){let n=e.estimateThroughput(t);return n===null?null:{throughput:n,...e.computeRTTAndServerResponseTime(t)}}static findResourceForUrl(t,n){return t.find(r=>n.startsWith(r.url)&&Mg.equalWithExcludedFragments(r.url,n))}static findLastDocumentForUrl(t,n){let r=t.filter(a=>a.resourceType==="Document"&&!a.failed&&n.startsWith(a.url)&&Mg.equalWithExcludedFragments(a.url,n));return r[r.length-1]}static resolveRedirects(t){for(;t.redirectDestination;)t=t.redirectDestination;return t}}});var Lt={};E(Lt,{LanternError:()=>ge,NetworkAnalyzer:()=>zo});var $r=g(()=>{d();ow();r5()});var It,Og=g(()=>{d();$r();It=class e{static{i(this,"BaseNode")}static types={NETWORK:"network",CPU:"cpu"};_id;_isMainDocument;dependents;dependencies;constructor(t){this._id=t,this._isMainDocument=!1,this.dependents=[],this.dependencies=[]}get id(){return this._id}get type(){throw new ge("Unimplemented")}get startTime(){throw new ge("Unimplemented")}get endTime(){throw new ge("Unimplemented")}setIsMainDocument(t){this._isMainDocument=t}isMainDocument(){return this._isMainDocument}getDependents(){return this.dependents.slice()}getNumberOfDependents(){return this.dependents.length}getDependencies(){return this.dependencies.slice()}getNumberOfDependencies(){return this.dependencies.length}getRootNode(){let t=this;for(;t.dependencies.length;)t=t.dependencies[0];return t}addDependent(t){t.addDependency(this)}addDependency(t){if(t===this)throw new ge("Cannot add dependency on itself");this.dependencies.includes(t)||(t.dependents.push(this),this.dependencies.push(t))}removeDependent(t){t.removeDependency(
this)}removeDependency(t){if(!this.dependencies.includes(t))return;let n=t.dependents.indexOf(this);t.dependents.splice(n,1),this.dependencies.splice(this.dependencies.indexOf(t),1)}removeAllDependencies(){for(let t of this.dependencies.slice())this.removeDependency(t)}isDependentOn(t){let n=!1;return this.traverse(r=>{n||(n=r===t)},r=>n?[]:r.getDependencies()),n}cloneWithoutRelationships(){let t=new e(this.id);return t.setIsMainDocument(this._isMainDocument),t}cloneWithRelationships(t){let n=this.getRootNode(),r=new Map;n.traverse(o=>{if(!r.has(o.id)){if(t===void 0){r.set(o.id,o.cloneWithoutRelationships());return}t(o)&&o.traverse(s=>r.set(s.id,s.cloneWithoutRelationships()),s=>s.dependencies.filter(c=>!r.has(c.id)))}}),n.traverse(o=>{let s=r.get(o.id);if(s)for(let c of o.dependencies){let u=r.get(c.id);if(!u)throw new ge("Dependency somehow not cloned");s.addDependency(u)}});let a=r.get(this.id);if(!a)throw new ge("Cloned graph missing node");return a}traverse(t,n){for(let{node:r,traversalPath:a}of this.
traverseGenerator(n))t(r,a)}*traverseGenerator(t){t||(t=i(a=>a.getDependents(),"getNextNodes"));let n=[[this]],r=new Set([this.id]);for(;n.length;){let a=n.shift(),o=a[0];yield{node:o,traversalPath:a};for(let s of t(o))r.has(s.id)||(r.add(s.id),n.push([s,...a]))}}static hasCycle(t,n="both"){if(n==="both")return e.hasCycle(t,"dependents")||e.hasCycle(t,"dependencies");let r=new Set,a=[],o=[t],s=new Map([[t,0]]);for(;o.length;){let c=o.pop();if(a.includes(c))return!0;if(r.has(c))continue;for(;a.length>s.get(c);)a.pop();r.add(c),a.push(c);let u=n==="dependents"?c.dependents:c.dependencies;for(let l of u)o.includes(l)||(o.push(l),s.set(l,a.length))}return!1}canDependOn(t){return t.startTime<=this.startTime}}});var $d,iw=g(()=>{d();Og();$d=class e extends It{static{i(this,"CPUNode")}_event;_childEvents;correctedEndTs;constructor(t,n=[],r){let a=`${t.tid}.${t.ts}`;super(a),this._event=t,this._childEvents=n,this.correctedEndTs=r}get type(){return It.types.CPU}get startTime(){return this._event.ts}get endTime(){return this.correctedEndTs?this.correctedEndTs:this._event.ts+this._event.dur}get duration(){return this.endTime-this.startTime}get event(){return this._event}get childEvents(){return this._childEvents}didPerformLayout(){return this._childEvents.some(t=>t.name==="Layout")}getEvaluateScriptURLs(){let t=new Set;for(let n of this._childEvents)n.name==="EvaluateScript"&&n.args.data?.url&&t.add(n.args.data.url);return t}cloneWithoutRelationships(){return new e(this._event,this._childEvents,this.correctedEndTs)}}});function a5(e){let t=e.includes(":")?e.slice(0,e.indexOf(":")):e;return fre.includes(t)}var fre,Iu,sw=g(()=>{d();Og();fre=["blob","data","intent","file","filesystem","chrome-extension"];i(a5,"isNonNetworkProtocol");Iu=class e extends It{static{i(this,"NetworkNode")}_request;constructor(t){super(t.requestId),this._request=t}get type(){return It.types.NETWORK}get startTime(){return this._request.rendererStartTime*1e3}get endTime(){return this._request.networkEndTime*1e3}get rawRequest(){return this._request.rawRequest}get request(){return this._request}get initiatorType(){return this._request.initiator.type}get fromDiskCache(){return!!this._request.fromDiskCache}get isNonNetworkProtocol(){return a5(this.request.protocol)||a5(this.request.parsedURL.scheme)}get isConnectionless(){return this.fromDiskCache||this.isNonNetworkProtocol}hasRenderBlockingPriority(){let t=this._request.priority,n=this._request.resourceType==="Script",r=this._request.resourceType==="Document";return t==="VeryHigh"||
t==="High"&&n||t==="High"&&r}cloneWithoutRelationships(){let t=new e(this._request);return t.setIsMainDocument(this._isMainDocument),t}}});var hre,gre,yre,vre,bre,wre,cw,o5=g(()=>{d();$r();iw();sw();hre="RunTask",gre="ThreadControllerImpl::RunTask",yre="ThreadControllerImpl::DoWork",vre="TaskQueueManager::ProcessTaskFromWorkQueue",bre=10,wre=/^video/,cw=class e{static{i(this,"PageDependencyGraph")}static getNetworkInitiators(t){if(!t.initiator)return[];if(t.initiator.url)return[t.initiator.url];if(t.initiator.type==="script"){let n=new Set,r=t.initiator.stack;for(;r;){let a=r.callFrames||[];for(let o of a)o.url&&n.add(o.url);r=r.parent}return Array.from(n)}return[]}static getNetworkNodeOutput(t){let n=[],r=new Map,a=new Map,o=new Map;return t.forEach(s=>{if(wre.test(s.mimeType)||s.fromWorker)return;for(;r.has(s.requestId);)s.requestId+=":duplicate";let c=new Iu(s);n.push(c);let u=a.get(s.url)||[];if(u.push(c),r.set(s.requestId,c),a.set(s.url,u),s.frameId&&s.resourceType==="Document"&&s.documentURL===s.url){let l=o.has(s.frameId)?null:c;o.set(s.frameId,l)}}),{nodes:n,idToNodeMap:r,urlToNodeMap:a,frameIdToNodeMap:o}}static isScheduleableTask(t){
return t.name===hre||t.name===gre||t.name===yre||t.name===vre}static assertHasToplevelEvents(t){if(!t.some(this.isScheduleableTask))throw new ge("Could not find any top level events")}static getCPUNodes(t){let n=[],r=0;for(e.assertHasToplevelEvents(t);r<t.length;){let a=t[r];if(r++,!e.isScheduleableTask(a)||!a.dur)continue;let o,s=[];for(let c=a.ts+a.dur;r<t.length&&t[r].ts<c;r++){let u=t[r];if(e.isScheduleableTask(u)&&u.dur){o=u.ts-1;break}s.push(u)}n.push(new $d(a,s,o))}return n}static linkNetworkNodes(t,n){n.nodes.forEach(r=>{let a=r.request.initiatorRequest||t.request,o=n.idToNodeMap.get(a.requestId)||t,s=!o.isDependentOn(r)&&r.canDependOn(o),c=e.getNetworkInitiators(r.request);if(c.length?c.forEach(l=>{let m=n.urlToNodeMap.get(l)||[];m.length===1&&m[0].startTime<=r.startTime&&!m[0].isDependentOn(r)?r.addDependency(m[0]):s&&o.addDependent(r)}):s&&o.addDependent(r),r!==t&&r.getDependencies().length===0&&r.canDependOn(t)&&r.addDependency(t),!r.request.redirects)return;let u=[...r.request.
redirects,r.request];for(let l=1;l<u.length;l++){let m=n.idToNodeMap.get(u[l-1].requestId),p=n.idToNodeMap.get(u[l].requestId);p&&m&&p.addDependency(m)}})}static linkCPUNodes(t,n,r){let a=new Set(["XHR","Fetch","Script"]);function o(h,y){let b=n.idToNodeMap.get(y);if(!b||b.startTime<=h.startTime)return;let{request:w}=b,D=w.resourceType||w.redirectDestination?.resourceType;a.has(D)&&h.addDependent(b)}i(o,"addDependentNetworkRequest");function s(h,y){if(!y)return;let b=n.frameIdToNodeMap.get(y);b&&(b.startTime>=h.startTime||h.addDependency(b))}i(s,"addDependencyOnFrame");function c(h,y){if(!y)return;let b=-100*1e3,w=n.urlToNodeMap.get(y)||[],D=null,T=1/0;for(let S of w){if(h.startTime<=S.startTime)return;let k=h.startTime-S.endTime;k>=b&&k<T&&(D=S,T=k)}D&&h.addDependency(D)}i(c,"addDependencyOnUrl");let u=new Map;for(let h of r){for(let y of h.childEvents){if(!y.args.data)continue;let b=y.args.data.url,w=(y.args.data.stackTrace||[]).map(D=>D.url).filter(Boolean);switch(y.name){case"Timer\
Install":u.set(y.args.data.timerId,h),w.forEach(D=>c(h,D));break;case"TimerFire":{let D=u.get(y.args.data.timerId);if(!D||D.endTime>h.startTime)break;D.addDependent(h);break}case"InvalidateLayout":case"ScheduleStyleRecalculation":s(h,y.args.data.frame),w.forEach(D=>c(h,D));break;case"EvaluateScript":s(h,y.args.data.frame),c(h,b),w.forEach(D=>c(h,D));break;case"XHRReadyStateChange":if(y.args.data.readyState!==4)break;c(h,b),w.forEach(D=>c(h,D));break;case"FunctionCall":case"v8.compile":s(h,y.args.data.frame),c(h,b);break;case"ParseAuthorStyleSheet":s(h,y.args.data.frame),c(h,y.args.data.styleSheetUrl);break;case"ResourceSendRequest":s(h,y.args.data.frame),o(h,y.args.data.requestId),w.forEach(D=>c(h,D));break}}h.getNumberOfDependencies()===0&&h.canDependOn(t)&&h.addDependency(t)}let l=bre*1e3,m=!1,p=!1,f=!1;for(let h of r){let y=!1;!m&&h.childEvents.some(b=>b.name==="Layout")&&(y=m=!0),!p&&h.childEvents.some(b=>b.name==="Paint")&&(y=p=!0),!f&&h.childEvents.some(b=>b.name==="ParseHTML")&&
(y=f=!0),!(y||h.duration>=l)&&(h.getNumberOfDependencies()===1||h.getNumberOfDependents()<=1)&&e.pruneNode(h)}}static pruneNode(t){let n=t.getDependencies(),r=t.getDependents();for(let a of n){t.removeDependency(a);for(let o of r)a.addDependent(o)}for(let a of r)t.removeDependent(a)}static debugNormalizeRequests(t){for(let a of t)a.rendererStartTime=Math.round(a.rendererStartTime*1e3)/1e3,a.networkRequestTime=Math.round(a.networkRequestTime*1e3)/1e3,a.responseHeadersEndTime=Math.round(a.responseHeadersEndTime*1e3)/1e3,a.networkEndTime=Math.round(a.networkEndTime*1e3)/1e3;for(let a of t)delete a.rawRequest,a.initiatorRequest&&(a.initiatorRequest={id:a.initiatorRequest.requestId}),a.redirectDestination&&(a.redirectDestination={id:a.redirectDestination.requestId}),a.redirectSource&&(a.redirectSource={id:a.redirectSource.requestId}),a.redirects&&(a.redirects=a.redirects.map(o=>o.requestId));let r=t.map(a=>({requestId:a.requestId,connectionId:a.connectionId,connectionReused:a.connectionReused,
url:a.url,protocol:a.protocol,parsedURL:a.parsedURL,documentURL:a.documentURL,rendererStartTime:a.rendererStartTime,networkRequestTime:a.networkRequestTime,responseHeadersEndTime:a.responseHeadersEndTime,networkEndTime:a.networkEndTime,transferSize:a.transferSize,resourceSize:a.resourceSize,fromDiskCache:a.fromDiskCache,fromMemoryCache:a.fromMemoryCache,finished:a.finished,statusCode:a.statusCode,redirectSource:a.redirectSource,redirectDestination:a.redirectDestination,redirects:a.redirects,failed:a.failed,initiator:a.initiator,timing:a.timing?{requestTime:a.timing.requestTime,proxyStart:a.timing.proxyStart,proxyEnd:a.timing.proxyEnd,dnsStart:a.timing.dnsStart,dnsEnd:a.timing.dnsEnd,connectStart:a.timing.connectStart,connectEnd:a.timing.connectEnd,sslStart:a.timing.sslStart,sslEnd:a.timing.sslEnd,workerStart:a.timing.workerStart,workerReady:a.timing.workerReady,workerFetchStart:a.timing.workerFetchStart,workerRespondWithSettled:a.timing.workerRespondWithSettled,sendStart:a.timing.sendStart,
sendEnd:a.timing.sendEnd,pushStart:a.timing.pushStart,pushEnd:a.timing.pushEnd,receiveHeadersStart:a.timing.receiveHeadersStart,receiveHeadersEnd:a.timing.receiveHeadersEnd}:a.timing,resourceType:a.resourceType,mimeType:a.mimeType,priority:a.priority,initiatorRequest:a.initiatorRequest,frameId:a.frameId,fromWorker:a.fromWorker,isLinkPreload:a.isLinkPreload,serverResponseTime:a.serverResponseTime})).filter(a=>!a.fromWorker);console.log(r)}static createGraph(t,n,r){let a=e.getNetworkNodeOutput(n),o=e.getCPUNodes(t),{requestedUrl:s,mainDocumentUrl:c}=r;if(!s)throw new ge("requestedUrl is required to get the root request");if(!c)throw new ge("mainDocumentUrl is required to get the main resource");let u=zo.findResourceForUrl(n,s);if(!u)throw new ge("rootRequest not found");let l=a.idToNodeMap.get(u.requestId);if(!l)throw new ge("rootNode not found");let m=zo.findLastDocumentForUrl(n,c);if(!m)throw new ge("mainDocumentRequest not found");let p=a.idToNodeMap.get(m.requestId);if(!p)throw new ge(
"mainDocumentNode not found");if(e.linkNetworkNodes(l,a),e.linkCPUNodes(l,a,o),p.setIsMainDocument(!0),Iu.hasCycle(l))throw new ge("Invalid dependency graph created, cycle detected");return l}static printGraph(t,n=100){function r(l,m,p=" "){return l+p.repeat(Math.max(m-l.length,0))}i(r,"padRight");let a=[];t.traverse(l=>a.push(l)),a.sort((l,m)=>l.startTime-m.startTime);let o=a[0].startTime,u=(a.reduce((l,m)=>Math.max(l,m.endTime),0)-o)/n;a.forEach(l=>{let m=Math.round((l.startTime-o)/u),p=Math.ceil((l.endTime-l.startTime)/u),f=r("",m)+r("",p,"="),h=l.request?l.request.url:l.type;console.log(r(f,n),`| ${h.slice(0,30)}`)})}}});var Cn={};E(Cn,{BaseNode:()=>It,CPUNode:()=>$d,NetworkNode:()=>Iu,PageDependencyGraph:()=>cw});var Za=g(()=>{d();Og();iw();sw();o5()});var ir,Wi=g(()=>{d();$r();Za();ir=class{static{i(this,"Metric")}static getScriptUrls(t,n){let r=new Set;return t.traverse(a=>{a.type===It.types.NETWORK&&a.request.resourceType==="Script"&&n?.(a)&&r.add(a.request.url)}),r}static get coefficients(){throw new ge("coefficients unimplemented!")}static getScaledCoefficients(t){return this.coefficients}static getOptimisticGraph(t,n){throw new ge("Optimistic graph unimplemented!")}static getPessimisticGraph(t,n){throw new ge("Pessmistic graph unimplemented!")}static getEstimateFromSimulation(t,n){return t}static compute(t,n){let{simulator:r,graph:a,processedNavigation:o}=t,s=this.name.replace("Lantern",""),c=this.getOptimisticGraph(a,o),u=this.getPessimisticGraph(a,o),l={label:`optimistic${s}`},m=r.simulate(c,l);l={label:`pessimistic${s}`};let p=r.simulate(u,l),f=this.getEstimateFromSimulation(m,{...n,optimistic:!0}),h=this.getEstimateFromSimulation(p,{...n,optimistic:!1}),y=this.getScaledCoefficients(r.rtt),b=y.intercept>0?Math.min(1,f.timeInMs/
1e3):1;return{timing:y.intercept*b+y.optimistic*f.timeInMs+y.pessimistic*h.timeInMs,optimisticEstimate:f,pessimisticEstimate:h,optimisticGraph:c,pessimisticGraph:u}}}});var Au,uw=g(()=>{d();Za();Wi();Au=class extends ir{static{i(this,"FirstContentfulPaint")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getRenderBlockingNodeData(t,{cutoffTimestamp:n,treatNodeAsRenderBlocking:r,additionalCpuNodesToTreatAsRenderBlocking:a}){let o=new Map,s=[];t.traverse(h=>{if(h.type===It.types.CPU){h.startTime<=n&&s.push(h);let y=h.getEvaluateScriptURLs();for(let b of y){let w=o.get(b)||h;o.set(b,h.startTime<w.startTime?h:w)}}}),s.sort((h,y)=>h.startTime-y.startTime);let c=ir.getScriptUrls(t,h=>h.endTime<=n&&r(h)),u=new Set,l=new Set;for(let h of c){let y=o.get(h);if(y){if(s.includes(y)){l.add(y.id);continue}u.add(h)}}let m=s.find(h=>h.didPerformLayout());m&&l.add(m.id);let p=s.find(h=>h.childEvents.some(y=>y.name==="Paint"));p&&l.add(p.id);let f=s.find(h=>h.childEvents.some(y=>y.name==="ParseHTML"));return f&&l.add(f.id),a&&s.filter(a).forEach(h=>l.add(h.id)),{definitelyNotRenderBlockingScriptUrls:u,renderBlockingCpuNodeIds:l}}static getFirstPaintBasedGraph(t,{
cutoffTimestamp:n,treatNodeAsRenderBlocking:r,additionalCpuNodesToTreatAsRenderBlocking:a}){let o=this.getRenderBlockingNodeData(t,{cutoffTimestamp:n,treatNodeAsRenderBlocking:r,additionalCpuNodesToTreatAsRenderBlocking:a}),{definitelyNotRenderBlockingScriptUrls:s,renderBlockingCpuNodeIds:c}=o;return t.cloneWithRelationships(u=>{if(u.type===It.types.NETWORK){if((u.endTime>n||u.startTime>n)&&!u.isMainDocument())return!1;let m=u.request.url;return s.has(m)?!1:r(u)}return c.has(u.id)})}static getOptimisticGraph(t,n){return this.getFirstPaintBasedGraph(t,{cutoffTimestamp:n.timestamps.firstContentfulPaint,treatNodeAsRenderBlocking:r=>r.hasRenderBlockingPriority()&&r.initiatorType!=="script"})}static getPessimisticGraph(t,n){return this.getFirstPaintBasedGraph(t,{cutoffTimestamp:n.timestamps.firstContentfulPaint,treatNodeAsRenderBlocking:r=>r.hasRenderBlockingPriority()})}}});var xre,lw,i5=g(()=>{d();$r();Za();Wi();xre=20,lw=class e extends ir{static{i(this,"Interactive")}static get coefficients(){return{intercept:0,optimistic:.45,pessimistic:.55}}static getOptimisticGraph(t){let n=xre*1e3;return t.cloneWithRelationships(r=>{if(r.type===It.types.CPU)return r.duration>n;let a=r.request.resourceType==="Image",o=r.request.resourceType==="Script";return!a&&(o||r.request.priority==="High"||r.request.priority==="VeryHigh")})}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.lcpResult)throw new ge("missing lcpResult");let r=e.getLastLongTaskEndTime(t.nodeTimings),a=n.optimistic?n.lcpResult.optimisticEstimate.timeInMs:n.lcpResult.pessimisticEstimate.timeInMs;return{timeInMs:Math.max(a,r),nodeTimings:t.nodeTimings}}static compute(t,n){let r=n?.lcpResult;if(!r)throw new ge("LCP is required to calculate the Interactive metric");let a=super.compute(t,n);return a.timing=Math.max(a.timing,r.timing),a}static getLastLongTaskEndTime(t,n=50){
return Array.from(t.entries()).filter(([r,a])=>r.type!==It.types.CPU?!1:a.duration>n).map(([r,a])=>a.endTime).reduce((r,a)=>Math.max(r||0,a||0),0)}}});var dw,s5=g(()=>{d();$r();uw();Wi();dw=class e extends ir{static{i(this,"LargestContentfulPaint")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static isNotLowPriorityImageNode(t){if(t.type!=="network")return!0;let n=t.request.resourceType==="Image",r=t.request.priority==="Low"||t.request.priority==="VeryLow";return!n||!r}static getOptimisticGraph(t,n){let r=n.timestamps.largestContentfulPaint;if(!r)throw new ge("NO_LCP");return Au.getFirstPaintBasedGraph(t,{cutoffTimestamp:r,treatNodeAsRenderBlocking:e.isNotLowPriorityImageNode})}static getPessimisticGraph(t,n){let r=n.timestamps.largestContentfulPaint;if(!r)throw new ge("NO_LCP");return Au.getFirstPaintBasedGraph(t,{cutoffTimestamp:r,treatNodeAsRenderBlocking:a=>!0,additionalCpuNodesToTreatAsRenderBlocking:a=>a.didPerformLayout()})}static getEstimateFromSimulation(t){let n=Array.from(t.nodeTimings.entries()).filter(r=>e.isNotLowPriorityImageNode(r[0])).map(r=>r[1].endTime);return{timeInMs:Math.max(...n),nodeTimings:t.
nodeTimings}}static compute(t,n){let r=n?.fcpResult;if(!r)throw new ge("FCP is required to calculate the LCP metric");let a=super.compute(t,n);return a.timing=Math.max(a.timing,r.timing),a}}});var mw,c5=g(()=>{d();$r();Za();Wi();mw=class e extends ir{static{i(this,"MaxPotentialFID")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.fcpResult)throw new ge("missing fcpResult");let r=n.optimistic?n.fcpResult.pessimisticEstimate.timeInMs:n.fcpResult.optimisticEstimate.timeInMs,a=e.getTimingsAfterFCP(t.nodeTimings,r);return{timeInMs:Math.max(...a.map(o=>o.duration),16),nodeTimings:t.nodeTimings}}static compute(t,n){if(!n?.fcpResult)throw new ge("FCP is required to calculate the Max Potential FID metric");return super.compute(t,n)}static getTimingsAfterFCP(t,n){return Array.from(t.entries()).filter(([r,a])=>r.type===It.types.CPU&&a.endTime>n).map(([r,a])=>a)}}});var Dre,pw,u5=g(()=>{d();$r();Za();Wi();Dre=150,pw=class e extends ir{static{i(this,"SpeedIndex")}static get coefficients(){return{intercept:0,optimistic:1.4,pessimistic:.4}}static getScaledCoefficients(t){let n=this.coefficients,r=Dre-30,a=Math.max((t-30)/r,0);return{intercept:n.intercept*a,optimistic:.5+(n.optimistic-.5)*a,pessimistic:.5+(n.pessimistic-.5)*a}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.fcpResult)throw new ge("missing fcpResult");if(n.observedSpeedIndex===void 0)throw new ge("missing observedSpeedIndex");let r=n.fcpResult.pessimisticEstimate.timeInMs;return{timeInMs:n.optimistic?n.observedSpeedIndex:e.computeLayoutBasedSpeedIndex(t.nodeTimings,r),nodeTimings:t.nodeTimings}}static compute(t,n){let r=n?.fcpResult;if(!r)throw new ge("FCP is required to calculate the SpeedIndex metric");let a=super.compute(t,n);return a.timing=Math.max(a.timing,r.timing),a}static computeLayoutBasedSpeedIndex(t,n){
let r=[];for(let[s,c]of t.entries())if(s.type===It.types.CPU&&s.childEvents.some(u=>u.name==="Layout")){let u=Math.max(Math.log2(c.endTime-c.startTime),0);r.push({time:c.endTime,weight:u})}let a=r.map(s=>s.weight*Math.max(s.time,n)).reduce((s,c)=>s+c,0),o=r.map(s=>s.weight).reduce((s,c)=>s+c,0);return o?a/o:n}}});var gw={};E(gw,{BLOCKING_TIME_THRESHOLD:()=>fw,calculateSumOfBlockingTime:()=>hw,calculateTbtImpactForEvent:()=>l5});function l5(e,t,n,r){let a=50;if(r&&(a*=e.duration/r.duration),e.duration<a||e.end<t||e.start>n)return 0;let o=Math.max(e.start,t),c=Math.min(e.end,n)-o;return c<a?0:c-a}function hw(e,t,n){if(n<=t)return 0;let r=0;for(let a of e)r+=l5(a,t,n);return r}var fw,yw=g(()=>{d();fw=50;i(l5,"calculateTbtImpactForEvent");i(hw,"calculateSumOfBlockingTime")});var vw,d5=g(()=>{d();$r();Za();Wi();yw();vw=class e extends ir{static{i(this,"TotalBlockingTime")}static get coefficients(){return{intercept:0,optimistic:.5,pessimistic:.5}}static getOptimisticGraph(t){return t}static getPessimisticGraph(t){return t}static getEstimateFromSimulation(t,n){if(!n.fcpResult)throw new ge("missing fcpResult");if(!n.interactiveResult)throw new ge("missing interactiveResult");let r=n.optimistic?n.fcpResult.pessimisticEstimate.timeInMs:n.fcpResult.optimisticEstimate.timeInMs,a=n.optimistic?n.interactiveResult.optimisticEstimate.timeInMs:n.interactiveResult.pessimisticEstimate.timeInMs,o=50,s=e.getTopLevelEvents(t.nodeTimings,o);return{timeInMs:hw(s,r,a),nodeTimings:t.nodeTimings}}static compute(t,n){if(!n?.fcpResult)throw new ge("FCP is required to calculate the TBT metric");if(!n?.fcpResult)throw new ge("Interactive is required to calculate the TBT metric");return super.compute(t,n)}static getTopLevelEvents(t,n){let r=[];for(let[a,o]of t.entries())a.type===It.types.
CPU&&(o.duration<n||r.push({start:o.startTime,end:o.endTime,duration:o.duration}));return r}}});var pn={};E(pn,{FirstContentfulPaint:()=>Au,Interactive:()=>lw,LargestContentfulPaint:()=>dw,MaxPotentialFID:()=>mw,Metric:()=>ir,SpeedIndex:()=>pw,TBTUtils:()=>gw,TotalBlockingTime:()=>vw});var m5=g(()=>{d();uw();i5();s5();c5();Wi();u5();d5();yw()});var ic,Ng=g(()=>{d();ic=class e{static{i(this,"TCPConnection")}warmed;ssl;h2;rtt;throughput;serverLatency;_congestionWindow;h2OverflowBytesDownloaded;constructor(t,n,r=0,a=!0,o=!1){this.warmed=!1,this.ssl=a,this.h2=o,this.rtt=t,this.throughput=n,this.serverLatency=r,this._congestionWindow=10,this.h2OverflowBytesDownloaded=0}static maximumSaturatedConnections(t,n){let s=1e3/t*1460*8;return Math.floor(n/s)}computeMaximumCongestionWindowInSegments(){let t=this.throughput/8,n=this.rtt/1e3,r=t*n;return Math.floor(r/1460)}setThroughput(t){this.throughput=t}setCongestionWindow(t){this._congestionWindow=t}setWarmed(t){this.warmed=t}isH2(){return this.h2}get congestionWindow(){return this._congestionWindow}setH2OverflowBytesDownloaded(t){this.h2&&(this.h2OverflowBytesDownloaded=t)}clone(){return Object.assign(new e(this.rtt,this.throughput),this)}simulateDownloadUntil(t,n){let{timeAlreadyElapsed:r=0,maximumTimeToElapse:a=1/0,dnsResolutionTime:o=0}=n||{};this.warmed&&this.h2&&(t-=this.h2OverflowBytesDownloaded);
let s=this.rtt,c=s/2,u=this.computeMaximumCongestionWindowInSegments(),l=c;this.warmed||(l=o+c+c+c+(this.ssl?s:0));let m=Math.ceil(l/s),p=l+this.serverLatency+c;this.warmed&&this.h2&&(p=0);let f=Math.max(p-r,0),h=a-f,y=Math.min(this._congestionWindow,u),b=0;f>0?b=y*1460:m=0;let w=0,D=t-b;for(;D>0&&w<=h;){m++,w+=s,y=Math.max(Math.min(u,y*2),1);let Y=y*1460;b+=Y,D-=Y}let T=f+w,S=this.h2?Math.max(b-t,0):0,k=Math.max(Math.min(b,t),0),_;return this.warmed?this.h2?_={timeToFirstByte:p}:_={connectionTime:l,timeToFirstByte:p}:_={dnsResolutionTime:o,connectionTime:l-o,sslTime:this.ssl?s:void 0,timeToFirstByte:p},{roundTrips:m,timeElapsed:T,bytesDownloaded:k,extraBytesDownloaded:S,congestionWindow:y,connectionTiming:_}}}});var Ere,Tre,Sre,Yd,bw=g(()=>{d();$r();Ng();Ere=30,Tre=["https","wss"],Sre=6,Yd=class{static{i(this,"ConnectionPool")}options;records;connectionsByOrigin;connectionsByRequest;_connectionsInUse;connectionReusedByRequestId;constructor(t,n){this.options=n,this.records=t,this.connectionsByOrigin=new Map,this.connectionsByRequest=new Map,this._connectionsInUse=new Set,this.connectionReusedByRequestId=zo.estimateIfConnectionWasReused(t,{forceCoarseEstimates:!0}),this.initializeConnections()}connectionsInUse(){return Array.from(this._connectionsInUse)}initializeConnections(){let t=this.connectionReusedByRequestId,n=this.options.additionalRttByOrigin,r=this.options.serverResponseTimeByOrigin,a=zo.groupByOrigin(this.records);for(let[o,s]of a.entries()){let c=[],u=n.get(o)||0,l=r.get(o)||Ere;for(let p of s){if(t.get(p.requestId))continue;let f=Tre.includes(p.parsedURL.scheme),h=p.protocol==="h2",y=new ic(this.options.rtt+u,this.options.throughput,l,f,h);c.push(y)}if(!c.length)throw new ge(`Could \
not find a connection for origin: ${o}`);let m=c[0].isH2()?1:Sre;for(;c.length<m;)c.push(c[0].clone());this.connectionsByOrigin.set(o,c)}}findAvailableConnectionWithLargestCongestionWindow(t){let n=null;for(let r=0;r<t.length;r++){let a=t[r];if(this._connectionsInUse.has(a))continue;let o=n?.congestionWindow||-1/0;a.congestionWindow>o&&(n=a)}return n}acquire(t){if(this.connectionsByRequest.has(t))throw new ge("Record already has a connection");let n=t.parsedURL.securityOrigin,r=this.connectionsByOrigin.get(n)||[],a=this.findAvailableConnectionWithLargestCongestionWindow(r);return a?(this._connectionsInUse.add(a),this.connectionsByRequest.set(t,a),a):null}acquireActiveConnectionFromRequest(t){let n=this.connectionsByRequest.get(t);if(!n)throw new ge("Could not find an active connection for request");return n}release(t){let n=this.connectionsByRequest.get(t);this.connectionsByRequest.delete(t),n&&this._connectionsInUse.delete(n)}}});var Cre,Kd,ww=g(()=>{d();Cre={DEVTOOLS_RTT_ADJUSTMENT_FACTOR:3.75,DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR:.9,mobileSlow4G:{rttMs:150,throughputKbps:1638.4,requestLatencyMs:562.5,downloadThroughputKbps:1474.5600000000002,uploadThroughputKbps:675,cpuSlowdownMultiplier:4},mobileRegular3G:{rttMs:300,throughputKbps:700,requestLatencyMs:1125,downloadThroughputKbps:630,uploadThroughputKbps:630,cpuSlowdownMultiplier:4},desktopDense4G:{rttMs:40,throughputKbps:10240,cpuSlowdownMultiplier:1,requestLatencyMs:0,downloadThroughputKbps:0,uploadThroughputKbps:0}},Kd={throttling:Cre}});var Fu,xw=g(()=>{d();Fu=class e{static{i(this,"DNSCache")}static rttMultiplier=2;rtt;resolvedDomainNames;constructor({rtt:t}){this.rtt=t,this.resolvedDomainNames=new Map}getTimeUntilResolution(t,n){let{requestedAt:r=0,shouldUpdateCache:a=!1}=n||{},o=t.parsedURL.host,s=this.resolvedDomainNames.get(o),c=this.rtt*e.rttMultiplier;if(s){let l=Math.max(s.resolvedAt-r,0);c=Math.min(l,c)}let u=r+c;return a&&this.updateCacheResolvedAtIfNeeded(t,u),c}updateCacheResolvedAtIfNeeded(t,n){let r=t.parsedURL.host,a=this.resolvedDomainNames.get(r)||{resolvedAt:n};a.resolvedAt=Math.min(a.resolvedAt,n),this.resolvedDomainNames.set(r,a)}setResolvedAt(t,n){this.resolvedDomainNames.set(t,{resolvedAt:n})}}});var Ru,Dw=g(()=>{d();$r();Za();Ru=class{static{i(this,"SimulatorTimingMap")}nodeTimings;constructor(){this.nodeTimings=new Map}getNodes(){return Array.from(this.nodeTimings.keys())}setReadyToStart(t,n){this.nodeTimings.set(t,n)}setInProgress(t,n){let r={...this.getQueued(t),startTime:n.startTime,timeElapsed:0};this.nodeTimings.set(t,t.type===It.types.NETWORK?{...r,timeElapsedOvershoot:0,bytesDownloaded:0}:r)}setCompleted(t,n){let r={...this.getInProgress(t),endTime:n.endTime,connectionTiming:n.connectionTiming};this.nodeTimings.set(t,r)}setCpu(t,n){let r={...this.getCpuStarted(t),timeElapsed:n.timeElapsed};this.nodeTimings.set(t,r)}setCpuEstimated(t,n){let r={...this.getCpuStarted(t),estimatedTimeElapsed:n.estimatedTimeElapsed};this.nodeTimings.set(t,r)}setNetwork(t,n){let r={...this.getNetworkStarted(t),timeElapsed:n.timeElapsed,timeElapsedOvershoot:n.timeElapsedOvershoot,bytesDownloaded:n.bytesDownloaded};this.nodeTimings.set(t,r)}setNetworkEstimated(t,n){let r={...this.getNetworkStarted(
t),estimatedTimeElapsed:n.estimatedTimeElapsed};this.nodeTimings.set(t,r)}getQueued(t){let n=this.nodeTimings.get(t);if(!n)throw new ge(`Node ${t.id} not yet queued`);return n}getCpuStarted(t){let n=this.nodeTimings.get(t);if(!n)throw new ge(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new ge(`Node ${t.id} not yet started`);if("bytesDownloaded"in n)throw new ge(`Node ${t.id} timing not valid`);return n}getNetworkStarted(t){let n=this.nodeTimings.get(t);if(!n)throw new ge(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new ge(`Node ${t.id} not yet started`);if(!("bytesDownloaded"in n))throw new ge(`Node ${t.id} timing not valid`);return n}getInProgress(t){let n=this.nodeTimings.get(t);if(!n)throw new ge(`Node ${t.id} not yet queued`);if(!("startTime"in n))throw new ge(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in n))throw new ge(`Node ${t.id} not yet in progress`);return n}getCompleted(t){let n=this.nodeTimings.get(t);if(!n)throw new ge(`Node ${t.
id} not yet queued`);if(!("startTime"in n))throw new ge(`Node ${t.id} not yet started`);if(!("estimatedTimeElapsed"in n))throw new ge(`Node ${t.id} not yet in progress`);if(!("endTime"in n))throw new ge(`Node ${t.id} not yet completed`);return n}}});var Ew,kre,Ire,Are,ra,Fre,p5,Tw,f5=g(()=>{d();$r();Za();bw();ww();xw();Dw();Ng();Ew=Kd.throttling.mobileSlow4G,kre=10,Ire=.5,Are=1e4,ra={NotReadyToStart:0,ReadyToStart:1,InProgress:2,Complete:3},Fre={VeryHigh:0,High:.25,Medium:.5,Low:1,VeryLow:2},p5=new Map,Tw=class e{static{i(this,"Simulator")}static createSimulator(t){let{throttlingMethod:n,throttling:r,precomputedLanternData:a,networkAnalysis:o}=t,s={additionalRttByOrigin:o.additionalRttByOrigin,serverResponseTimeByOrigin:o.serverResponseTimeByOrigin,observedThroughput:o.throughput};switch(a&&(s.additionalRttByOrigin=new Map(Object.entries(a.additionalRttByOrigin)),s.serverResponseTimeByOrigin=new Map(Object.entries(a.serverResponseTimeByOrigin))),n){case"provided":s.rtt=o.rtt,s.throughput=o.throughput,s.cpuSlowdownMultiplier=1,s.layoutTaskMultiplier=1;break;case"devtools":r&&(s.rtt=r.requestLatencyMs/Kd.throttling.DEVTOOLS_RTT_ADJUSTMENT_FACTOR,s.throughput=r.downloadThroughputKbps*1024/Kd.throttling.DEVTOOLS_THROUGHPUT_ADJUSTMENT_FACTOR),
s.cpuSlowdownMultiplier=1,s.layoutTaskMultiplier=1;break;case"simulate":r&&(s.rtt=r.rttMs,s.throughput=r.throughputKbps*1024,s.cpuSlowdownMultiplier=r.cpuSlowdownMultiplier);break;default:break}return new e(s)}options;_rtt;throughput;maximumConcurrentRequests;cpuSlowdownMultiplier;layoutTaskMultiplier;cachedNodeListByStartPosition;nodeTimings;numberInProgressByType;nodes;dns;connectionPool;constructor(t){if(this.options=Object.assign({rtt:Ew.rttMs,throughput:Ew.throughputKbps*1024,maximumConcurrentRequests:kre,cpuSlowdownMultiplier:Ew.cpuSlowdownMultiplier,layoutTaskMultiplier:Ire,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map},t),this._rtt=this.options.rtt,this.throughput=this.options.throughput,this.maximumConcurrentRequests=Math.max(Math.min(ic.maximumSaturatedConnections(this._rtt,this.throughput),this.options.maximumConcurrentRequests),1),this.cpuSlowdownMultiplier=this.options.cpuSlowdownMultiplier,this.layoutTaskMultiplier=this.cpuSlowdownMultiplier*this.options.
layoutTaskMultiplier,this.cachedNodeListByStartPosition=[],this.nodeTimings=new Ru,this.numberInProgressByType=new Map,this.nodes={},this.dns=new Fu({rtt:this._rtt}),this.connectionPool=null,!Number.isFinite(this._rtt))throw new ge(`Invalid rtt ${this._rtt}`);if(!Number.isFinite(this.throughput))throw new ge(`Invalid throughput ${this.throughput}`)}get rtt(){return this._rtt}initializeConnectionPool(t){let n=[];t.getRootNode().traverse(r=>{r.type===It.types.NETWORK&&n.push(r.request)}),this.connectionPool=new Yd(n,this.options)}initializeAuxiliaryData(){this.nodeTimings=new Ru,this.numberInProgressByType=new Map,this.nodes={},this.cachedNodeListByStartPosition=[];for(let t of Object.values(ra))this.nodes[t]=new Set}numberInProgress(t){return this.numberInProgressByType.get(t)||0}markNodeAsReadyToStart(t,n){let r=e.computeNodeStartPosition(t),a=this.cachedNodeListByStartPosition.findIndex(s=>e.computeNodeStartPosition(s)>r),o=a===-1?this.cachedNodeListByStartPosition.length:a;this.cachedNodeListByStartPosition.
splice(o,0,t),this.nodes[ra.ReadyToStart].add(t),this.nodes[ra.NotReadyToStart].delete(t),this.nodeTimings.setReadyToStart(t,{queuedTime:n})}markNodeAsInProgress(t,n){let r=this.cachedNodeListByStartPosition.indexOf(t);this.cachedNodeListByStartPosition.splice(r,1),this.nodes[ra.InProgress].add(t),this.nodes[ra.ReadyToStart].delete(t),this.numberInProgressByType.set(t.type,this.numberInProgress(t.type)+1),this.nodeTimings.setInProgress(t,{startTime:n})}markNodeAsComplete(t,n,r){this.nodes[ra.Complete].add(t),this.nodes[ra.InProgress].delete(t),this.numberInProgressByType.set(t.type,this.numberInProgress(t.type)-1),this.nodeTimings.setCompleted(t,{endTime:n,connectionTiming:r});for(let a of t.getDependents())a.getDependencies().some(s=>!this.nodes[ra.Complete].has(s))||this.markNodeAsReadyToStart(a,n)}acquireConnection(t){return this.connectionPool.acquire(t)}getNodesSortedByStartPosition(){return Array.from(this.cachedNodeListByStartPosition)}startNodeIfPossible(t,n){if(t.type===It.types.
CPU){this.numberInProgress(t.type)===0&&this.markNodeAsInProgress(t,n);return}if(t.type!==It.types.NETWORK)throw new ge("Unsupported");!t.isConnectionless&&(this.numberInProgress(t.type)>=this.maximumConcurrentRequests||!this.acquireConnection(t.request))||this.markNodeAsInProgress(t,n)}updateNetworkCapacity(){let t=this.numberInProgress(It.types.NETWORK);if(t!==0)for(let n of this.connectionPool.connectionsInUse())n.setThroughput(this.throughput/t)}estimateTimeRemaining(t){if(t.type===It.types.CPU)return this.estimateCPUTimeRemaining(t);if(t.type===It.types.NETWORK)return this.estimateNetworkTimeRemaining(t);throw new ge("Unsupported")}estimateCPUTimeRemaining(t){let n=this.nodeTimings.getCpuStarted(t),r=t.didPerformLayout()?this.layoutTaskMultiplier:this.cpuSlowdownMultiplier,o=Math.min(Math.round(t.duration/1e3*r),Are)-n.timeElapsed;return this.nodeTimings.setCpuEstimated(t,{estimatedTimeElapsed:o}),o}estimateNetworkTimeRemaining(t){let n=t.request,r=this.nodeTimings.getNetworkStarted(
t),a=0;if(t.fromDiskCache)a=8+20*((n.resourceSize||0)/1024/1024)-r.timeElapsed;else if(t.isNonNetworkProtocol)a=2+10*((n.resourceSize||0)/1024/1024)-r.timeElapsed;else{let s=this.connectionPool.acquireActiveConnectionFromRequest(n),c=this.dns.getTimeUntilResolution(n,{requestedAt:r.startTime,shouldUpdateCache:!0}),u=r.timeElapsed;a=s.simulateDownloadUntil(n.transferSize-r.bytesDownloaded,{timeAlreadyElapsed:u,dnsResolutionTime:c,maximumTimeToElapse:1/0}).timeElapsed}let o=a+r.timeElapsedOvershoot;return this.nodeTimings.setNetworkEstimated(t,{estimatedTimeElapsed:o}),o}findNextNodeCompletionTime(){let t=1/0;for(let n of this.nodes[ra.InProgress])t=Math.min(t,this.estimateTimeRemaining(n));return t}updateProgressMadeInTimePeriod(t,n,r){let a=this.nodeTimings.getInProgress(t),o=a.estimatedTimeElapsed===n;if(t.type===It.types.CPU||t.isConnectionless){o?this.markNodeAsComplete(t,r):a.timeElapsed+=n;return}if(t.type!==It.types.NETWORK)throw new ge("Unsupported");if(!("bytesDownloaded"in a))
throw new ge("Invalid timing data");let s=t.request,c=this.connectionPool.acquireActiveConnectionFromRequest(s),u=this.dns.getTimeUntilResolution(s,{requestedAt:a.startTime,shouldUpdateCache:!0}),l=c.simulateDownloadUntil(s.transferSize-a.bytesDownloaded,{dnsResolutionTime:u,timeAlreadyElapsed:a.timeElapsed,maximumTimeToElapse:n-a.timeElapsedOvershoot});c.setCongestionWindow(l.congestionWindow),c.setH2OverflowBytesDownloaded(l.extraBytesDownloaded),o?(c.setWarmed(!0),this.connectionPool.release(s),this.markNodeAsComplete(t,r,l.connectionTiming)):(a.timeElapsed+=l.timeElapsed,a.timeElapsedOvershoot+=l.timeElapsed-n,a.bytesDownloaded+=l.bytesDownloaded)}computeFinalNodeTimings(){let t=this.nodeTimings.getNodes().map(r=>[r,this.nodeTimings.getCompleted(r)]);t.sort((r,a)=>r[1].startTime-a[1].startTime);let n=t.map(([r,a])=>[r,{startTime:a.startTime,endTime:a.endTime,duration:a.endTime-a.startTime}]);return{nodeTimings:new Map(n),completeNodeTimings:new Map(t)}}getOptions(){return this.options}simulate(t,n){
if(It.hasCycle(t))throw new ge("Cannot simulate graph with cycle");n=Object.assign({label:void 0},n),this.dns=new Fu({rtt:this._rtt}),this.initializeConnectionPool(t),this.initializeAuxiliaryData();let r=this.nodes[ra.NotReadyToStart],a=this.nodes[ra.ReadyToStart],o=this.nodes[ra.InProgress],s=t.getRootNode();s.traverse(p=>r.add(p));let c=0,u=0;for(this.markNodeAsReadyToStart(s,c);a.size||o.size;){for(let f of this.getNodesSortedByStartPosition())this.startNodeIfPossible(f,c);if(!o.size)throw new ge("Failed to start a node");this.updateNetworkCapacity();let p=this.findNextNodeCompletionTime();if(c+=p,!Number.isFinite(p)||u>1e5)throw new ge("Simulation failed, depth exceeded");u++;for(let f of o)this.updateProgressMadeInTimePeriod(f,p,c)}let{nodeTimings:l,completeNodeTimings:m}=this.computeFinalNodeTimings();return p5.set(n.label||"unlabeled",m),{timeInMs:c,nodeTimings:l}}computeWastedMsFromWastedBytes(t){let{throughput:n,observedThroughput:r}=this.options,a=n===0?r:n;if(a===0)return 0;
let s=t*8/a*1e3;return Math.round(s/10)*10}static get allNodeTimings(){return p5}static computeNodeStartPosition(t){return t.type==="cpu"?t.startTime:t.startTime+(Fre[t.request.priority]*1e3*1e3||0)}}});var Ho={};E(Ho,{ConnectionPool:()=>Yd,Constants:()=>Kd,DNSCache:()=>Fu,Simulator:()=>Tw,SimulatorTimingMap:()=>Ru,TCPConnection:()=>ic});var h5=g(()=>{d();bw();ww();xw();Dw();f5();Ng()});var Rre,g5=g(()=>{d();Rre={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch"}});var Jd={};E(Jd,{NetworkRequestTypes:()=>Rre});var y5=g(()=>{d();g5()});var Xd=g(()=>{d();$r();Za();m5();h5();y5()});var E5=Ne((HOe,D5)=>{d();var v5=/:\/\/(\S*?)(:\d+)?(\/|$)/,b5=/([a-z0-9.-]+\.[a-z0-9]+|localhost)/i,_re=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,Mre=/[^.]+\.([^.]+|(gov|com|co|ne)\.\w{2})$/i;function w5(e){return typeof e!="string"||e.length>1e4||e.startsWith("data:")?null:v5.test(e)?e.match(v5)[1]:b5.test(e)?e.match(b5)[0]:null}i(w5,"getDomainFromOriginOrURL");function Cw(e){let t=w5(e);if(!t)return null;if(_re.test(t))return t;let n=t.match(Mre);return n&&n[0]||t}i(Cw,"getRootDomain");function Ore(e,t){return e.length<=t.length?e:e.split(".").slice(1).join(".")}i(Ore,"sliceSubdomainFromDomain");function x5(e,t,n,r){let a=w5(r),o=Cw(a);if(!(!a||!o)){if(e.has(a))return e.get(a);for(let s=a;s.length>o.length;s=Ore(s,o))if(t.has(s))return t.get(s);if(n.has(o))return n.get(o)}}i(x5,"getEntityInDataset");function Nre(e,t,n,r){let a=x5(e,t,n,r),o=a&&a.products;if(o&&typeof r=="string"){for(let s of o)for(let c of s.urlPatterns)if(c instanceof RegExp&&c.test(r)||typeof c=="string"&&r.includes(
c))return s}}i(Nre,"getProductInDataset");function Pre(e){return e.map(t=>{let n={company:t.name,categories:[t.category],...t},r=(t.products||[]).map(a=>({company:n.company,category:n.category,categories:[n.category],facades:[],...a,urlPatterns:(a.urlPatterns||[]).map(o=>o.startsWith("REGEXP:")?new RegExp(o.slice(7)):o)}));return n.products=r,n})}i(Pre,"cloneEntities");function Lre(e){let t=Pre(e),n=new Map,r=new Map,a=new Map;for(let c of t){c.totalExecutionTime=Number(c.totalExecutionTime)||0,c.totalOccurrences=Number(c.totalOccurrences)||0,c.averageExecutionTime=c.totalExecutionTime/c.totalOccurrences;for(let u of c.domains){if(n.has(u)){let m=n.get(u);throw new Error(`Duplicate domain ${u} (${c.name} and ${m.name})`)}n.set(u,c);let l=Cw(u);if(u.startsWith("*.")){let m=u.slice(2);m===l?r.set(l,c):a.set(m,c)}}}for(let[c,u]of r.entries())u||r.delete(c);let o=x5.bind(null,n,a,r),s=Nre.bind(null,n,a,r);return{getEntity:o,getProduct:s,getRootDomain:Cw,entities:t}}i(Lre,"createAPIFromData\
set");D5.exports={createAPIFromDataset:Lre}});var T5=Ne((VOe,Bre)=>{Bre.exports=[{name:"Google/Doubleclick Ads",company:"Google",homepage:"https://marketingplatform.google.com/about/enterprise/",category:"ad",domains:["adservice.google.com","adservice.google.com.au","adservice.google.com.sg","adservice.google.com.br","adservice.google.com.ua","adservice.google.co.uk","adservice.google.co.jp","adservice.google.co.in","adservice.google.co.kr","adservice.google.co.id","adservice.google.co.nz","adservice.google.ie","adservice.google.se","adservice.google.de","adservice.google.ca","adservice.google.be","adservice.google.es","adservice.google.ch","adservice.google.fr","adservice.google.nl","*.googleadservices.com","*.googlesyndication.com","*.googletagservices.com","*.2mdn.net","*.doubleclick.net"],examples:["pagead2.googlesyndication.com","tpc.googlesyndication.com","ade.googlesyndication.com","googleads.g.doubleclick.net","googleads4.g.doubleclick.net","securepubads.g.doubleclick.net","pubads.g.doubleclick.net","static.doubleclick.net",
"cm.g.doubleclick.net","bid.g.doubleclick.net","s0.2mdn.net","stats.g.doubleclick.net","survey.g.doubleclick.net","fls.doubleclick.net","ad.doubleclick.net","www.googleadservices.com","https://www.googletagservices.com/tag/js/gpt.js"],totalExecutionTime:3224311743,totalOccurrences:1232210},{name:"Facebook",homepage:"https://www.facebook.com",category:"social",domains:["*.facebook.com","*.atlassbx.com","*.fbsbx.com","fbcdn-photos-e-a.akamaihd.net","*.facebook.net","*.fbcdn.net"],examples:["www.facebook.com","connect.facebook.net","staticxx.facebook.com","static.xx.fbcdn.net","m.facebook.com","an.facebook.com","platform-lookaside.fbsbx.com"],products:[{name:"Facebook Messenger Customer Chat",urlPatterns:["REGEXP:connect\\.facebook\\.net\\/.*\\/sdk\\/xfbml\\.customerchat\\.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}],totalExecutionTime:1097107210,totalOccurrences:3157799},{name:"Instagram",homepage:"https://www.instagram.com",
category:"social",domains:["*.cdninstagram.com","*.instagram.com"],examples:["scontent.cdninstagram.com"],totalExecutionTime:31988464,totalOccurrences:20376},{name:"Google CDN",company:"Google",homepage:"https://developers.google.com/speed/libraries/",category:"cdn",domains:["ajax.googleapis.com","commondatastorage.googleapis.com","www.gstatic.com","ssl.gstatic.com"],totalExecutionTime:4805631169,totalOccurrences:3192326},{name:"Google Maps",company:"Google",homepage:"https://www.google.com/maps",category:"utility",domains:["maps.google.com","maps-api-ssl.google.com","maps.googleapis.com","mts.googleapis.com","mt.googleapis.com","mt0.googleapis.com","mt1.googleapis.com","mt2.googleapis.com","mt3.googleapis.com","khm0.googleapis.com","khm1.googleapis.com","khms.googleapis.com","khms1.googleapis.com","khms2.googleapis.com","maps.gstatic.com"],totalExecutionTime:904392768,totalOccurrences:1195850},{name:"Other Google APIs/SDKs",company:"Google",homepage:"https://developers.google.com/apis\
-explorer/#p/",category:"utility",domains:["accounts.google.com","apis.google.com","calendar.google.com","clients2.google.com","cse.google.com","news.google.com","pay.google.com","payments.google.com","play.google.com","smartlock.google.com","www.google.com","www.google.de","www.google.co.jp","www.google.com.au","www.google.co.uk","www.google.ie","www.google.com.sg","www.google.co.in","www.google.com.br","www.google.ca","www.google.co.kr","www.google.co.nz","www.google.co.id","www.google.fr","www.google.be","www.google.com.ua","www.google.nl","www.google.ru","www.google.se","www.googleapis.com","imasdk.googleapis.com","storage.googleapis.com","translate.googleapis.com","translate.google.com","translate-pa.googleapis.com","lh3.googleusercontent.com","jnn-pa.googleapis.com","csi.gstatic.com"],totalExecutionTime:1158368443,totalOccurrences:2638940},{name:"Firebase",homepage:"https://developers.google.com/apis-explorer/#p/",category:"utility",domains:["firebasestorage.googleapis.com","fire\
store.googleapis.com","firebaseinstallations.googleapis.com","firebase.googleapis.com","firebaseremoteconfig.googleapis.com"],totalExecutionTime:201194,totalOccurrences:493},{name:"Google Analytics",company:"Google",homepage:"https://marketingplatform.google.com/about/analytics/",category:"analytics",domains:["*.google-analytics.com","*.urchin.com","analytics.google.com"],examples:["www.google-analytics.com","ssl.google-analytics.com","analytics.google.com/g/collect"],totalExecutionTime:495649535,totalOccurrences:4231882},{name:"Google Optimize",company:"Google",homepage:"https://marketingplatform.google.com/about/optimize/",category:"analytics",domains:["www.googleoptimize.com"],examples:["https://www.googleoptimize.com/optimize.js?id="],totalExecutionTime:9330261,totalOccurrences:38797},{name:"Google AMP",company:"Google",homepage:"https://github.com/google/amp-client-id-library",category:"analytics",domains:["ampcid.google.com"]},{name:"Google Tag Manager",company:"Google",homepage:"\
https://marketingplatform.google.com/about/tag-manager/",category:"tag-manager",domains:["*.googletagmanager.com"],examples:["www.googletagmanager.com"],totalExecutionTime:6770912735,totalOccurrences:8124119},{name:"Google Fonts",company:"Google",homepage:"https://fonts.google.com/",category:"cdn",domains:["fonts.googleapis.com","fonts.gstatic.com"],totalExecutionTime:53081,totalOccurrences:220864},{name:"Adobe TypeKit",company:"Adobe",homepage:"https://fonts.adobe.com/",category:"cdn",domains:["*.typekit.com","*.typekit.net"],examples:["use.typekit.net","p.typekit.net"],totalExecutionTime:78981507,totalOccurrences:119621},{name:"YouTube",homepage:"https://youtube.com",category:"video",domains:["*.youtube.com","*.ggpht.com","*.youtube-nocookie.com","*.ytimg.com"],examples:["www.youtube.com","s.ytimg.com","yt3.ggpht.com","img.youtube.com","fcmatch.youtube.com"],products:[{name:"YouTube Embedded Player",urlPatterns:["youtube.com/embed/"],facades:[{name:"Lite YouTube",repo:"https://github\
.com/paulirish/lite-youtube-embed"},{name:"Ngx Lite Video",repo:"https://github.com/karim-mamdouh/ngx-lite-video"}]}],totalExecutionTime:6277579675,totalOccurrences:977311},{name:"Twitter",homepage:"https://twitter.com",category:"social",domains:["*.vine.co","*.twimg.com","*.twitpic.com","platform.twitter.com","syndication.twitter.com"],examples:["cdn.syndication.twimg.com","abs.twimg.com","pbs.twimg.com"],totalExecutionTime:804233203,totalOccurrences:319957},{name:"AddThis",homepage:"https://www.addthis.com/",category:"social",domains:["*.addthis.com","*.addthiscdn.com","*.addthisedge.com"],examples:["s7.addthis.com","r.dlx.addthis.com","su.addthis.com","x.dlx.addthis.com"],totalExecutionTime:23,totalOccurrences:42},{name:"AddToAny",homepage:"https://www.addtoany.com/",category:"social",domains:["*.addtoany.com"],examples:["static.addtoany.com"],totalExecutionTime:10606113,totalOccurrences:66065},{name:"Akamai",homepage:"https://www.akamai.com/",category:"cdn",domains:["23.62.3.183","\
*.akamaitechnologies.com","*.akamaitechnologies.fr","*.akamai.net","*.akamaiedge.net","*.akamaihd.net","*.akamaized.net","*.edgefcs.net","*.edgekey.net","edgesuite.net","*.srip.net"],totalExecutionTime:4795669,totalOccurrences:9820},{name:"Blogger",homepage:"https://www.blogger.com/",category:"hosting",domains:["*.blogblog.com","*.blogger.com","*.blogspot.com","images-blogger-opensocial.googleusercontent.com"],examples:["1.bp.blogspot.com","www.blogger.com"],totalExecutionTime:58390438,totalOccurrences:213326},{name:"Gravatar",homepage:"https://en.gravatar.com/",category:"social",domains:["*.gravatar.com"],examples:["secure.gravatar.com","www.gravatar.com"],totalExecutionTime:9235,totalOccurrences:43},{name:"Yandex Metrica",company:"Yandex",homepage:"https://metrica.yandex.com/about?",category:"analytics",domains:["mc.yandex.ru","mc.yandex.com","d31j93rd8oukbv.cloudfront.net"],totalExecutionTime:1438544698,totalOccurrences:602136},{name:"Hotjar",homepage:"https://www.hotjar.com/",category:"\
analytics",domains:["*.hotjar.com","*.hotjar.io"],examples:["script.hotjar.com","static.hotjar.com","in.hotjar.com","vc.hotjar.io","vars.hotjar.com"],totalExecutionTime:241418055,totalOccurrences:333356},{name:"Baidu Analytics",homepage:"https://tongji.baidu.com/web/welcome/login",category:"analytics",domains:["hm.baidu.com","hmcdn.baidu.com"],examples:["hm.baidu.com","hmcdn.baidu.com"],totalExecutionTime:7739347,totalOccurrences:32612},{name:"Insider",homepage:"",category:"analytics",domains:["*.useinsider.com"],examples:["hit.api.useinsider.com"],totalExecutionTime:2214966,totalOccurrences:1861},{name:"Adobe Experience Cloud",company:"Adobe",homepage:"",category:"analytics",domains:["*.2o7.net","du8783wkf05yr.cloudfront.net","*.hitbox.com","*.imageg.net","*.nedstat.com","*.omtrdc.net"],examples:["audiag.112.2o7.net","du8783wkf05yr.cloudfront.net/NS_mbox.js"],totalExecutionTime:2369,totalOccurrences:38},{name:"Adobe Tag Manager",company:"Adobe",homepage:"https://www.adobe.com/experien\
ce-platform/",category:"tag-manager",domains:["*.adobedtm.com","*.demdex.net","*.everesttech.net","sstats.adobe.com","hbrt.adobe.com"],examples:["assets.adobedtm.com","sync-tm.everesttech.net","cm.everesttech.net"],totalExecutionTime:34937564,totalOccurrences:200160},{name:"jQuery CDN",homepage:"https://code.jquery.com/",category:"cdn",domains:["*.jquery.com"],examples:["code.jquery.com"],totalExecutionTime:302334055,totalOccurrences:724477},{name:"Cloudflare CDN",homepage:"https://cdnjs.com/",category:"cdn",domains:["cdnjs.cloudflare.com","amp.cloudflare.com"],totalExecutionTime:337711119,totalOccurrences:666628},{name:"Cloudflare",homepage:"https://www.cloudflare.com/website-optimization/",category:"utility",domains:["ajax.cloudflare.com","*.nel.cloudflare.com","static.cloudflareinsights.com"],totalExecutionTime:58723052,totalOccurrences:467719},{name:"WordPress",company:"Automattic",homepage:"https://wp.com/",category:"hosting",domains:["*.wordpress.com","s0.wp.com","s2.wp.com","*.w\
.org","c0.wp.com","s1.wp.com","i0.wp.com","i1.wp.com","i2.wp.com","widgets.wp.com"],examples:["s.w.org"],totalExecutionTime:220910650,totalOccurrences:308694},{name:"WordPress Site Stats",company:"Automattic",homepage:"https://wp.com/",category:"analytics",domains:["pixel.wp.com","stats.wp.com"],totalExecutionTime:8573549,totalOccurrences:128931},{name:"Hatena Blog",homepage:"https://hatenablog.com/",category:"hosting",domains:["*.st-hatena.com","*.hatena.ne.jp"],examples:["cdn.blog.st-hatena.com","cdn.pool.st-hatena.com","cdn7.www.st-hatena.com","s.hatena.ne.jp","b.st-hatena.com"],totalExecutionTime:106337940,totalOccurrences:43183},{name:"Shopify",homepage:"https://www.shopify.com/",category:"hosting",domains:["*.shopify.com","*.shopifyapps.com","*.shopifycdn.com","*.shopifysvc.com"],examples:["cdn.shopify.com","productreviews.shopifycdn.com","monorail-edge.shopifysvc.com"],totalExecutionTime:287428893,totalOccurrences:338668},{name:"Dealer",homepage:"https://www.dealer.com/",category:"\
hosting",domains:["*.dealer.com"],examples:["static.dealer.com"],totalExecutionTime:871324,totalOccurrences:2620},{name:"PIXNET",homepage:"https://www.pixnet.net/",category:"social",domains:["*.pixfs.net","*.pixnet.net"],examples:["front.pixfs.net","falcon-asset.pixfs.net","pixgame-asset.pixfs.net"],totalExecutionTime:18541448,totalOccurrences:13718},{name:"Moat",homepage:"https://moat.com/",category:"ad",domains:["*.moatads.com","*.moatpixel.com"],examples:["z.moatads.com","px.moatads.com","geo.moatads.com","sejs.moatads.com","mb.moatads.com","v4.moatads.com"]},{name:"33 Across",homepage:"https://33across.com/",category:"ad",domains:["*.33across.com"],examples:["sic.33across.com","cdn-sic.33across.com"],totalExecutionTime:10002146,totalOccurrences:192648},{name:"OpenX",homepage:"https://www.openx.com/",category:"ad",domains:["*.deliverimp.com","*.openxadexchange.com","*.servedbyopenx.com","*.jump-time.net","*.openx.net","*.openxcdn.net"],examples:["uk-ads.openx.net","us-ads.openx.net",
"33across-d.openx.net","rtb.openx.net","us-u.openx.net","eu-u.openx.net","u.openx.net"],totalExecutionTime:6274934,totalOccurrences:76561},{name:"Amazon Ads",homepage:"https://ad.amazon.com/",category:"ad",domains:["*.amazon-adsystem.com"],examples:["s.amazon-adsystem.com","c.amazon-adsystem.com","aax.amazon-adsystem.com","z-na.amazon-adsystem.com","fls-na.amazon-adsystem.com","aax-us-east.amazon-adsystem.com","ir-na.amazon-adsystem.com"],totalExecutionTime:98703856,totalOccurrences:240331},{name:"Rubicon Project",homepage:"https://rubiconproject.com/",category:"ad",domains:["*.rubiconproject.com","*.chango.com","*.fimserve.com"],examples:["pixel.rubiconproject.com","fastlane.rubiconproject.com","secure-assets.rubiconproject.com","eus.rubiconproject.com","pixel-us-east.rubiconproject.com","token.rubiconproject.com","ads.rubiconproject.com"],totalExecutionTime:287111007,totalOccurrences:270271},{name:"The Trade Desk",homepage:"https://www.thetradedesk.com/",category:"ad",domains:["*.ads\
rvr.org","d1eoo1tco6rr5e.cloudfront.net"],examples:["js.adsrvr.org","match.adsrvr.org","insight.adsrvr.org","usw-lax.adsrvr.org","data.adsrvr.org","snap.adsrvr.org"],totalExecutionTime:2197325,totalOccurrences:25346},{name:"Bidswitch",homepage:"https://www.bidswitch.com/",category:"ad",domains:["*.bidswitch.net"],examples:["x.bidswitch.net"],totalExecutionTime:25660,totalOccurrences:68217},{name:"LiveRamp IdentityLink",homepage:"https://liveramp.com/discover-identitylink/",category:"analytics",domains:["*.circulate.com","*.rlcdn.com"],examples:["idsync.rlcdn.com","id.rlcdn.com","api.rlcdn.com","cdn.rlcdn.com"],totalExecutionTime:141414,totalOccurrences:1461},{name:"Drawbridge",homepage:"https://www.drawbridge.com/",category:"ad",domains:["*.adsymptotic.com"]},{name:"AOL / Oath / Verizon Media",homepage:"https://www.oath.com/",category:"ad",domains:["*.advertising.com","*.aol.com","*.aolcdn.com","*.blogsmithmedia.com","*.oath.com","*.aol.net","*.tacoda.net","*.aol.co.uk"],examples:["pix\
el.advertising.com","dtm.advertising.com","tag.sp.advertising.com","service.sp.advertising.com","adtech.advertising.com","adaptv.advertising.com","mighty.aol.net","consent.cmp.oath.com"],totalExecutionTime:165968,totalOccurrences:278},{name:"Xaxis",homepage:"https://www.xaxis.com/",category:"ad",domains:["*.247realmedia.com","*.mookie1.com","*.gmads.net"],examples:["t.mookie1.com","odr.mookie1.com"],totalExecutionTime:28343,totalOccurrences:209},{name:"Freshdesk",company:"Freshworks",homepage:"https://freshdesk.com/",category:"customer-success",domains:["d36mpcpuzc4ztk.cloudfront.net"],totalExecutionTime:64296,totalOccurrences:225},{name:"Help Scout",homepage:"https://www.helpscout.net/",category:"customer-success",domains:["djtflbt20bdde.cloudfront.net","*.helpscout.net"],examples:["beacon-v2.helpscout.net"],products:[{name:"Help Scout Beacon",urlPatterns:["beacon-v2.helpscout.net"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}],
totalExecutionTime:2186050,totalOccurrences:4906},{name:"Alexa",homepage:"https://www.alexa.com/",category:"analytics",domains:["*.alexametrics.com","d31qbv1cthcecs.cloudfront.net"],examples:["certify.alexametrics.com"]},{name:"OneSignal",homepage:"https://onesignal.com/",category:"utility",domains:["*.onesignal.com"],examples:["cdn.onesignal.com","https://onesignal.com/api/v1/sync/"],totalExecutionTime:17761218,totalOccurrences:68282},{name:"Lucky Orange",homepage:"https://www.luckyorange.com/",category:"analytics",domains:["*.luckyorange.com","d10lpsik1i8c69.cloudfront.net","*.luckyorange.net"],totalExecutionTime:12779009,totalOccurrences:16442},{name:"Crazy Egg",homepage:"https://www.crazyegg.com/",category:"analytics",domains:["*.cetrk.com","*.crazyegg.com","dnn506yrbagrg.cloudfront.net"],totalExecutionTime:27593244,totalOccurrences:43822},{name:"Hello Bar",homepage:"https://www.hellobar.com/",category:"marketing",domains:["*.hellobar.com"],totalExecutionTime:1533955,totalOccurrences:4502},
{name:"Yandex Ads",company:"Yandex",homepage:"https://yandex.com/adv/",category:"ad",domains:["an.yandex.ru"],totalExecutionTime:5171537,totalOccurrences:8488},{name:"Salesforce",homepage:"https://www.salesforce.com/products/marketing-cloud/",category:"analytics",domains:["*.krxd.net"],examples:["cdn.krxd.net","beacon.krxd.net","consumer.krxd.net","usermatch.krxd.net"]},{name:"Salesforce Commerce Cloud",homepage:"https://www.salesforce.com/products/commerce-cloud/overview/",category:"hosting",domains:["*.cquotient.com","*.demandware.net","demandware.edgesuite.net"],totalExecutionTime:2045309,totalOccurrences:4127},{name:"Optimizely",homepage:"https://www.optimizely.com/",category:"analytics",domains:["*.optimizely.com"],examples:["cdn.optimizely.com","cdn-pci.optimizely.com","logx.optimizely.com","cdn3.optimizely.com"],totalExecutionTime:12599739,totalOccurrences:15998},{name:"LiveChat",homepage:"https://www.livechat.com/",category:"customer-success",domains:["*.livechatinc.com","*.liv\
echat.com","*.livechat-static.com"],examples:["cdn.livechatinc.com","secure.livechatinc.com"],totalExecutionTime:49171416,totalOccurrences:39034},{name:"VK",homepage:"https://vk.com/",category:"social",domains:["*.vk.com"],totalExecutionTime:91334176,totalOccurrences:22377},{name:"Tumblr",homepage:"https://tumblr.com/",category:"social",domains:["*.tumblr.com"],examples:["assets.tumblr.com","static.tumblr.com"],totalExecutionTime:45570825,totalOccurrences:18114},{name:"Wistia",homepage:"https://wistia.com/",category:"video",domains:["*.wistia.com","embedwistia-a.akamaihd.net","*.wistia.net"],examples:["fast.wistia.com","fast.wistia.net","distillery.wistia.com","pipedream.wistia.com"],totalExecutionTime:115722112,totalOccurrences:27059},{name:"Brightcove",homepage:"https://www.brightcove.com/en/",category:"video",domains:["*.brightcove.com","*.brightcove.net","*.zencdn.net"],examples:["vjs.zencdn.net","players.brightcove.net"],totalExecutionTime:15099708,totalOccurrences:13745},{name:"J\
SDelivr CDN",homepage:"https://www.jsdelivr.com/",category:"cdn",domains:["*.jsdelivr.net"],examples:["cdn.jsdelivr.net"],totalExecutionTime:260364458,totalOccurrences:399959},{name:"Sumo",homepage:"https://sumo.com/",category:"marketing",domains:["*.sumo.com","*.sumome.com","sumo.b-cdn.net"],examples:["sumo.b-cdn.net","load.sumo.com","load.sumome.com"],totalExecutionTime:16489977,totalOccurrences:10901},{name:"Vimeo",homepage:"https://vimeo.com/",category:"video",domains:["*.vimeo.com","*.vimeocdn.com"],examples:["f.vimeocdn.com","player.vimeo.com","i.vimeocdn.com"],products:[{name:"Vimeo Embedded Player",urlPatterns:["player.vimeo.com/video/"],facades:[{name:"Lite Vimeo",repo:"https://github.com/slightlyoff/lite-vimeo"},{name:"Lite Vimeo Embed",repo:"https://github.com/luwes/lite-vimeo-embed"},{name:"Ngx Lite Video",repo:"https://github.com/karim-mamdouh/ngx-lite-video"}]}],totalExecutionTime:263943622,totalOccurrences:120397},{name:"Disqus",homepage:"https://disqus.com/",category:"s\
ocial",domains:["*.disqus.com","*.disquscdn.com"],examples:["c.disquscdn.com"],totalExecutionTime:3697272,totalOccurrences:1775},{name:"Yandex APIs",company:"Yandex",homepage:"https://yandex.ru/",category:"utility",domains:["api-maps.yandex.ru","money.yandex.ru"],totalExecutionTime:40765111,totalOccurrences:51601},{name:"Yandex CDN",company:"Yandex",homepage:"https://yandex.ru/",category:"cdn",domains:["*.yandex.st","*.yastatic.net"],examples:["https://yastatic.net/share2/share.js","https://yastatic.net/jquery/2.1.4/jquery.min.js"]},{name:"Integral Ad Science",homepage:"https://integralads.com/uk/",category:"ad",domains:["*.adsafeprotected.com","*.iasds01.com"],examples:["pixel.adsafeprotected.com","static.adsafeprotected.com","fw.adsafeprotected.com","cdn.adsafeprotected.com","dt.adsafeprotected.com"],totalExecutionTime:88554254,totalOccurrences:21660},{name:"Tealium",homepage:"https://tealium.com/",category:"tag-manager",domains:["*.aniview.com","*.delvenetworks.com","*.limelight.com",
"*.tiqcdn.com","*.llnwd.net","*.tealiumiq.com"],examples:["tags.tiqcdn.com","tealium.hs.llnwd.net","link.videoplatform.limelight.com","datacloud.tealiumiq.com"],totalExecutionTime:20176561,totalOccurrences:75434},{name:"Pubmatic",homepage:"https://pubmatic.com/",category:"ad",domains:["*.pubmatic.com"],examples:["image6.pubmatic.com","ads.pubmatic.com","image2.pubmatic.com","simage2.pubmatic.com","image4.pubmatic.com","simage4.pubmatic.com","image5.pubmatic.com","hbopenbid.pubmatic.com"],totalExecutionTime:417694368,totalOccurrences:279418},{name:"Olark",homepage:"https://www.olark.com/",category:"customer-success",domains:["*.olark.com"],examples:["static.olark.com"],totalExecutionTime:9840846,totalOccurrences:6534},{name:"Tawk.to",homepage:"https://www.tawk.to/",category:"customer-success",domains:["*.tawk.to"],examples:["embed.tawk.to"],totalExecutionTime:43074965,totalOccurrences:111088},{name:"OptinMonster",homepage:"https://optinmonster.com/",category:"marketing",domains:["*.opmn\
str.com","*.optmnstr.com","*.optmstr.com"],examples:["a.optmstr.com","api.opmnstr.com","a.optmnstr.com"],totalExecutionTime:1035991,totalOccurrences:2346},{name:"ZenDesk",homepage:"https://zendesk.com/",category:"customer-success",domains:["*.zdassets.com","*.zendesk.com","*.zopim.com"],examples:["assets.zendesk.com","static.zdassets.com","v2.zopim.com"],totalExecutionTime:106701440,totalOccurrences:72537},{name:"Pusher",homepage:"https://pusher.com/",category:"utility",domains:["*.pusher.com","*.pusherapp.com"],examples:["stats.pusher.com"],totalExecutionTime:152727,totalOccurrences:1698},{name:"Drift",homepage:"https://www.drift.com/",category:"marketing",domains:["*.drift.com","*.driftt.com"],examples:["js.driftt.com","api.drift.com"],products:[{name:"Drift Live Chat",urlPatterns:["REGEXP:js\\.driftt\\.com\\/include\\/.*\\/.*\\.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"}]}],totalExecutionTime:30179596,totalOccurrences:5515},
{name:"Sentry",homepage:"https://sentry.io/",category:"utility",domains:["*.getsentry.com","*.ravenjs.com","*.sentry-cdn.com","*.sentry.io"],examples:["cdn.ravenjs.com","browser.sentry-cdn.com"],totalExecutionTime:47937360,totalOccurrences:85598},{name:"Amazon Web Services",homepage:"https://aws.amazon.com/s3/",category:"other",domains:["*.amazon.com","*.amazonaws.com","*.amazonwebapps.com","*.amazonwebservices.com","*.elasticbeanstalk.com","*.images-amazon.com","*.amazon.co.uk"],examples:["s3.amazonaws.com","us-east-1.amazonaws.com","api-cdn.amazon.com","ecx.images-amazon.com","ws.amazon.co.uk"],totalExecutionTime:51892201,totalOccurrences:119152},{name:"Amazon Pay",homepage:"https://pay.amazon.com",category:"utility",domains:["payments.amazon.com","*.payments-amazon.com"],totalExecutionTime:1234650,totalOccurrences:6833},{name:"Media.net",homepage:"https://www.media.net/",category:"ad",domains:["*.media.net","*.mnet-ad.net"],examples:["contextual.media.net","cdnwest-xch.media.net","h\
bx.media.net","cs.media.net","hblg.media.net"],totalExecutionTime:24973689,totalOccurrences:97679},{name:"Yahoo!",homepage:"https://www.yahoo.com/",category:"ad",domains:["*.bluelithium.com","*.hostingprod.com","*.lexity.com","*.yahoo.com","*.yahooapis.com","*.yimg.com","*.zenfs.com","*.yahoo.net"],examples:["ads.yahoo.com","analytics.yahoo.com","geo.yahoo.com","udc.yahoo.com","ganon.yahoo.com","ads.yap.yahoo.com"],totalExecutionTime:2617276,totalOccurrences:24800},{name:"Adroll",homepage:"https://www.adroll.com/",category:"ad",domains:["*.adroll.com"],examples:["d.adroll.com","s.adroll.com"],totalExecutionTime:11884188,totalOccurrences:30782},{name:"Twitch",homepage:"https://twitch.tv/",category:"video",domains:["*.twitch.tv"],examples:["player.twitch.tv"],totalExecutionTime:18452667,totalOccurrences:1255},{name:"Taboola",homepage:"https://www.taboola.com/",category:"ad",domains:["*.taboola.com","*.taboolasyndication.com"],examples:["cdn.taboola.com","trc.taboola.com","vidstat.taboola\
.com","images.taboola.com"],totalExecutionTime:32631891,totalOccurrences:49191},{name:"Sizmek",homepage:"https://www.sizmek.com/",category:"ad",domains:["*.serving-sys.com","*.peer39.net"],examples:["secure-ds.serving-sys.com","ds.serving-sys.com","bs.serving-sys.com"],totalExecutionTime:6679849,totalOccurrences:4307},{name:"Scorecard Research",homepage:"https://www.scorecardresearch.com/",category:"ad",domains:["*.scorecardresearch.com"],examples:["sb.scorecardresearch.com","sa.scorecardresearch.com","b.scorecardresearch.com"],totalExecutionTime:4399371,totalOccurrences:54577},{name:"Criteo",homepage:"https://www.criteo.com/",category:"ad",domains:["*.criteo.com","*.emailretargeting.com","*.criteo.net"],examples:["static.criteo.net","bidder.criteo.com","dis.criteo.com","gum.criteo.com","sslwidget.criteo.com","dis.us.criteo.com"],totalExecutionTime:25625451,totalOccurrences:213880},{name:"Segment",homepage:"https://segment.com/",category:"analytics",domains:["*.segment.com","*.segment.\
io"],examples:["cdn.segment.com","api.segment.io"],totalExecutionTime:11055141,totalOccurrences:27036},{name:"ShareThis",homepage:"https://www.sharethis.com/",category:"social",domains:["*.sharethis.com"],examples:["w.sharethis.com","ws.sharethis.com","t.sharethis.com"],totalExecutionTime:30807804,totalOccurrences:88829},{name:"Distil Networks",homepage:"https://www.distilnetworks.com/",category:"utility",domains:["*.areyouahuman.com"],examples:["n-cdn.areyouahuman.com"]},{name:"Connexity",homepage:"https://connexity.com/",category:"analytics",domains:["*.connexity.net"]},{name:"Popads",homepage:"https://www.popads.net/",category:"ad",domains:["*.popads.net"],examples:["serve.popads.net","c1.popads.net"],totalExecutionTime:756593,totalOccurrences:427},{name:"CreateJS CDN",homepage:"https://code.createjs.com/",category:"cdn",domains:["*.createjs.com"],examples:["code.createjs.com"],totalExecutionTime:13654049,totalOccurrences:3880},{name:"Squarespace",homepage:"https://www.squarespace.c\
om/",category:"hosting",domains:["*.squarespace.com"],examples:["static.squarespace.com","static1.squarespace.com"],totalExecutionTime:1106480464,totalOccurrences:243154},{name:"Media Math",homepage:"https://www.mediamath.com/",category:"ad",domains:["*.mathads.com","*.mathtag.com"],examples:["mathid.mathtag.com","sync.mathtag.com","pixel.mathtag.com"],totalExecutionTime:20783,totalOccurrences:305},{name:"Mixpanel",homepage:"https://mixpanel.com/",category:"analytics",domains:["*.mixpanel.com","*.mxpnl.com"],examples:["cdn.mxpnl.com"],totalExecutionTime:3250547,totalOccurrences:18817},{name:"FontAwesome CDN",homepage:"https://fontawesome.com/",category:"cdn",domains:["*.fontawesome.com"],examples:["use.fontawesome.com"],totalExecutionTime:73007333,totalOccurrences:291586},{name:"Hubspot",homepage:"https://hubspot.com/",category:"marketing",domains:["*.hs-scripts.com","*.hubspot.com","*.leadin.com","*.hs-analytics.net","*.hscollectedforms.net","*.hscta.net","*.hsforms.net","*.hsleadflow\
s.net","*.hsstatic.net","*.hubspot.net","*.hsforms.com","*.hs-banner.com","*.hs-embed-reporting.com","*.hs-growth-metrics.com","*.hs-data.com","*.hsadspixel.net","*.hubapi.com"],examples:["forms.hubspot.com","js.hsforms.net","js.hs-analytics.net","js.leadin.com"],totalExecutionTime:92224372,totalOccurrences:154415},{name:"Mailchimp",homepage:"https://mailchimp.com/",category:"marketing",domains:["*.chimpstatic.com","*.list-manage.com","*.mailchimp.com"],examples:["downloads.mailchimp.com"],totalExecutionTime:21592375,totalOccurrences:45506},{name:"MGID",homepage:"https://www.mgid.com/",category:"ad",domains:["*.mgid.com","*.dt07.net"],examples:["servicer.mgid.com"],totalExecutionTime:22074076,totalOccurrences:10437},{name:"Stripe",homepage:"https://stripe.com",category:"utility",domains:["*.stripe.com","*.stripecdn.com","*.stripe.network"],examples:["m.stripe.network","js.stripe.com"],totalExecutionTime:166354648,totalOccurrences:136440},{name:"PayPal",homepage:"https://paypal.com",category:"\
utility",domains:["*.paypal.com","*.paypalobjects.com"],examples:["www.paypalobjects.com"],totalExecutionTime:64408205,totalOccurrences:62800},{name:"Market GID",homepage:"https://www.marketgid.com/",category:"ad",domains:["*.marketgid.com"],examples:["jsc.marketgid.com"]},{name:"Pinterest",homepage:"https://pinterest.com/",category:"social",domains:["*.pinimg.com","*.pinterest.com"],examples:["assets.pinterest.com","ct.pinterest.com","log.pinterest.com"],totalExecutionTime:17602311,totalOccurrences:131448},{name:"New Relic",homepage:"https://newrelic.com/",category:"utility",domains:["*.newrelic.com","*.nr-data.net"],examples:["js-agent.newrelic.com","bam.nr-data.net"],totalExecutionTime:64592740,totalOccurrences:227672},{name:"AppDynamics",homepage:"https://www.appdynamics.com/",category:"utility",domains:["*.appdynamics.com","*.eum-appdynamics.com","d3tjaysgumg9lf.cloudfront.net"],examples:["cdn.appdynamics.com"],totalExecutionTime:2509158,totalOccurrences:2920},{name:"Parking Crew",
homepage:"https://parkingcrew.net/",category:"other",domains:["d1lxhc4jvstzrp.cloudfront.net","*.parkingcrew.net"],totalExecutionTime:9,totalOccurrences:1},{name:"WordAds",company:"Automattic",homepage:"https://wordads.co/",category:"ad",domains:["*.pubmine.com"],examples:["s.pubmine.com"],totalExecutionTime:74286347,totalOccurrences:100449},{name:"AppNexus",homepage:"https://www.appnexus.com/",category:"ad",domains:["*.adnxs.com","*.ctasnet.com","*.adrdgt.com"],examples:["acdn.adnxs.com","secure.adnxs.com","ib.adnxs.com","sharethrough.adnxs.com","cdn.adnxs.com","vcdn.adnxs.com"],totalExecutionTime:5948505,totalOccurrences:234133},{name:"Histats",homepage:"https://www.histats.com/",category:"analytics",domains:["*.histats.com"],examples:["s10.histats.com"],totalExecutionTime:5601,totalOccurrences:92},{name:"DoubleVerify",homepage:"https://www.doubleverify.com/",category:"ad",domains:["*.doubleverify.com","*.dvtps.com","*.iqfp1.com"],examples:["cdn.doubleverify.com","cdn3.doubleverify.c\
om","tps.doubleverify.com","tps712.doubleverify.com","tps714.doubleverify.com","tps706.doubleverify.com","tps700.doubleverify.com","tps707.doubleverify.com","rtb2.doubleverify.com","rtb0.doubleverify.com","rtbcdn.doubleverify.com","tps11020.doubleverify.com","tm.iqfp1.com"],totalExecutionTime:46891028,totalOccurrences:19453},{name:"Mediavine",homepage:"https://www.mediavine.com/",category:"ad",domains:["*.mediavine.com"],examples:["scripts.mediavine.com","video.mediavine.com"],totalExecutionTime:59009373,totalOccurrences:12963},{name:"Wix",homepage:"https://www.wix.com/",category:"hosting",domains:["*.parastorage.com","*.wix.com","*.wixstatic.com","*.wixapps.net"],examples:["static.parastorage.com","static.wixstatic.com","www.wix.com","instagram.codev.wixapps.net"],totalExecutionTime:2112268981,totalOccurrences:458273},{name:"Webflow",homepage:"https://webflow.com/",category:"hosting",domains:["*.uploads-ssl.webflow.com","*.assets-global.website-files.com","*.assets.website-files.com"],
examples:["uploads-ssl.webflow.com","assets-global.website-files.com","assets.website-files.com"]},{name:"Weebly",homepage:"https://www.weebly.com/",category:"hosting",domains:["*.editmysite.com"],totalExecutionTime:413019e3,totalOccurrences:67864},{name:"LinkedIn",homepage:"https://www.linkedin.com/",category:"social",domains:["*.bizographics.com","platform.linkedin.com","*.slideshare.com","*.slidesharecdn.com","*.oribi.io"],totalExecutionTime:5776577,totalOccurrences:16507},{name:"LinkedIn Ads",category:"ad",domains:["*.licdn.com","*.ads.linkedin.com","ads.linkedin.com","www.linkedin.com"],examples:["snap.licdn.com"],totalExecutionTime:22805542,totalOccurrences:199088},{name:"Vox Media",homepage:"https://www.voxmedia.com/",category:"content",domains:["*.vox-cdn.com","*.voxmedia.com"],examples:["cdn.vox-cdn.com"],totalExecutionTime:910366,totalOccurrences:320},{name:"Hotmart",homepage:"https://www.hotmart.com/",category:"content",domains:["*.hotmart.com"],examples:["launchermodule.hot\
mart.com"],totalExecutionTime:15363016,totalOccurrences:4554},{name:"SoundCloud",homepage:"https://www.soundcloud.com/",category:"content",domains:["*.sndcdn.com","*.soundcloud.com","*.stratus.sc"],examples:["widget.sndcdn.com"],totalExecutionTime:15888610,totalOccurrences:5859},{name:"Spotify",homepage:"https://www.spotify.com/",category:"content",domains:["*.scdn.co","*.spotify.com"],examples:["open.spotify.com","open.scdn.co","i.scdn.co"],totalExecutionTime:99924,totalOccurrences:10992},{name:"AMP",homepage:"https://amp.dev/",category:"content",domains:["*.ampproject.org"],examples:["cdn.ampproject.org"],totalExecutionTime:79590738,totalOccurrences:66265},{name:"Beeketing",homepage:"https://beeketing.com/",category:"marketing",domains:["*.beeketing.com"],examples:["sdk-cdn.beeketing.com","sdk.beeketing.com"],totalExecutionTime:2163106,totalOccurrences:1971},{name:"Albacross",homepage:"https://albacross.com/",category:"marketing",domains:["*.albacross.com"],examples:["serve.albacross\
.com"],totalExecutionTime:100459,totalOccurrences:1503},{name:"TrafficJunky",homepage:"https://www.trafficjunky.com/",category:"ad",domains:["*.contentabc.com","*.trafficjunky.net"],examples:["ads2.contentabc.com","hw-cdn.contentabc.com","media.trafficjunky.net","ads.trafficjunky.net","hw-cdn.trafficjunky.net"],totalExecutionTime:2936,totalOccurrences:62},{name:"Bootstrap CDN",homepage:"https://www.bootstrapcdn.com/",category:"cdn",domains:["*.bootstrapcdn.com"],examples:["maxcdn.bootstrapcdn.com","stackpath.bootstrapcdn.com"],totalExecutionTime:2075388,totalOccurrences:38731},{name:"Shareaholic",homepage:"https://www.shareaholic.com/",category:"social",domains:["*.shareaholic.com","dsms0mj1bbhn4.cloudfront.net"],totalExecutionTime:122180,totalOccurrences:1429},{name:"Snowplow",homepage:"https://snowplowanalytics.com/",category:"analytics",domains:["d32hwlnfiv2gyn.cloudfront.net"],totalExecutionTime:7099041,totalOccurrences:58566},{name:"RD Station",homepage:"https://www.rdstation.com/\
en/",category:"marketing",domains:["d335luupugsy2.cloudfront.net"],totalExecutionTime:7693701,totalOccurrences:21846},{name:"Jivochat",homepage:"https://www.jivochat.com/",category:"customer-success",domains:["*.jivosite.com"],examples:["cdn-ca.jivosite.com","code.jivosite.com"],totalExecutionTime:36663932,totalOccurrences:57540},{name:"Listrak",homepage:"https://www.listrak.com/",category:"marketing",domains:["*.listrak.com","*.listrakbi.com"],examples:["cdn.listrakbi.com","s1.listrakbi.com"],totalExecutionTime:458776,totalOccurrences:1045},{name:"Ontame",homepage:"https://www.ontame.io",category:"analytics",domains:["*.ontame.io"],examples:["cdn.ontame.io","collector.ontame.io"],totalExecutionTime:23620,totalOccurrences:101},{name:"Ipify",homepage:"https://www.ipify.org",category:"utility",domains:["*.ipify.org"],examples:["api.ipify.org","geo.ipify.org"],totalExecutionTime:365905,totalOccurrences:2753},{name:"Ensighten",homepage:"https://www.ensighten.com/",category:"tag-manager",domains:[
"*.ensighten.com"],examples:["nexus.ensighten.com"],totalExecutionTime:1774287,totalOccurrences:3199},{name:"EpiServer",homepage:"https://www.episerver.com",category:"content",domains:["*.episerver.net"],examples:["dl.episerver.net"],totalExecutionTime:9010,totalOccurrences:80},{name:"mPulse",homepage:"https://developer.akamai.com/akamai-mpulse",category:"analytics",domains:["*.akstat.io","*.go-mpulse.net","*.mpulse.net","*.mpstat.us"],examples:["c.go-mpulse.net","0211c83c.akstat.io"],totalExecutionTime:3089821,totalOccurrences:30624},{name:"Pingdom RUM",homepage:"https://www.pingdom.com/product/performance-monitoring/",category:"analytics",domains:["*.pingdom.net"],examples:["rum-static.pingdom.net","rum-collector-2.pingdom.net"],totalExecutionTime:106679,totalOccurrences:1825},{name:"SpeedCurve RUM",company:"SpeedCurve",homepage:"https://www.speedcurve.com/features/performance-monitoring/",category:"analytics",domains:["*.speedcurve.com"],examples:["cdn.speedcurve.com","lux.speedcurv\
e.com"],totalExecutionTime:323903,totalOccurrences:5358},{name:"Radar",company:"Cedexis",homepage:"https://www.cedexis.com/radar/",category:"analytics",domains:["*.cedexis-test.com","*.cedexis.com","*.cmdolb.com","cedexis.leasewebcdn.com","*.cedexis-radar.net","*.cedexis.net","cedexis-test01.insnw.net","cedexisakamaitest.azureedge.net","cedexispub.cdnetworks.net","cs600.wac.alphacdn.net","cs600.wpc.edgecastdns.net","global2.cmdolb.com","img-cedexis.mncdn.com","a-cedexis.msedge.net","zn3vgszfh.fastestcdn.net"],examples:["radar.cedexis.com","rpt.cedexis.com","2-01-49cd-0002.cdx.cedexis.net","bench.cedexis-test.com"],totalExecutionTime:290925,totalOccurrences:1133},{name:"Byside",homepage:"https://byside.com",category:"analytics",domains:["*.byside.com"],examples:["byce2.byside.com","wce2.byside.com"],totalExecutionTime:45270,totalOccurrences:87},{name:"VWO",homepage:"https://vwo.com",category:"analytics",domains:["*.vwo.com","*.visualwebsiteoptimizer.com","d5phz18u4wuww.cloudfront.net","\
*.wingify.com"],examples:["dev.visualwebsiteoptimizer.com"],totalExecutionTime:6485310,totalOccurrences:7903},{name:"Bing Ads",homepage:"https://bingads.microsoft.com",category:"ad",domains:["*.bing.com","*.microsoft.com","*.msn.com","*.s-msft.com","*.s-msn.com","*.msads.net","*.msecnd.net"],examples:["bat.bing.com","c.bing.com","bat.r.msn.com","ajax.microsoft.com"],totalExecutionTime:14227177,totalOccurrences:117720},{name:"GoSquared",homepage:"https://www.gosquared.com",category:"analytics",domains:["*.gosquared.com","d1l6p2sc9645hc.cloudfront.net"],examples:["data.gosquared.com","data2.gosquared.com"],totalExecutionTime:56152,totalOccurrences:613},{name:"Usabilla",homepage:"https://usabilla.com",category:"analytics",domains:["*.usabilla.com","d6tizftlrpuof.cloudfront.net"],examples:["w.usabilla.com"],totalExecutionTime:240166,totalOccurrences:1354},{name:"Fastly Insights",homepage:"https://insights.fastlylabs.com",category:"analytics",domains:["*.fastly-insights.com"],examples:["www\
.fastly-insights.com"],totalExecutionTime:541189,totalOccurrences:4449},{name:"Visual IQ",homepage:"https://www.visualiq.com",category:"analytics",domains:["*.myvisualiq.net"],examples:["t.myvisualiq.net"]},{name:"Snapchat",homepage:"https://www.snapchat.com",category:"analytics",domains:["*.snapchat.com","*.sc-static.net"],examples:["tr.snapchat.com"],totalExecutionTime:177890,totalOccurrences:1978},{name:"Atlas Solutions",homepage:"https://atlassolutions.com",category:"analytics",domains:["*.atdmt.com"],examples:["ad.atdmt.com","cx.atdmt.com"]},{name:"Quantcast",homepage:"https://www.quantcast.com",category:"analytics",domains:["*.brtstats.com","*.quantcount.com","*.quantserve.com","*.semantictec.com","*.ntv.io"],examples:["pixel.quantserve.com","secure.quantserve.com","cms.quantserve.com","rules.quantcount.com"],totalExecutionTime:12419392,totalOccurrences:77646},{name:"Spiceworks",homepage:"https://www.spiceworks.com",category:"analytics",domains:["*.spiceworks.com"],examples:["px.\
spiceworks.com"]},{name:"Marketo",homepage:"https://www.marketo.com",category:"analytics",domains:["*.marketo.com","*.mktoresp.com","*.marketo.net"],examples:["munchkin.marketo.net"],totalExecutionTime:724464,totalOccurrences:1798},{name:"Intercom",homepage:"https://www.intercom.com",category:"customer-success",domains:["*.intercomcdn.com","*.intercom.io"],examples:["js.intercomcdn.com","api-iam.intercom.io","widget.intercom.io","nexus-websocket-a.intercom.io"],products:[{name:"Intercom Widget",urlPatterns:["widget.intercom.io","js.intercomcdn.com/shim.latest.js"],facades:[{name:"React Live Chat Loader",repo:"https://github.com/calibreapp/react-live-chat-loader"},{name:"Intercom Facade",repo:"https://github.com/danielbachhuber/intercom-facade/"}]}],totalExecutionTime:44601345,totalOccurrences:35197},{name:"Unpkg",homepage:"https://unpkg.com",category:"cdn",domains:["*.unpkg.com","*.npmcdn.com"],totalExecutionTime:74666,totalOccurrences:227},{name:"ReadSpeaker",homepage:"https://www.rea\
dspeaker.com",category:"other",domains:["*.readspeaker.com"],examples:["sf1-eu.readspeaker.com"],totalExecutionTime:727525,totalOccurrences:6265},{name:"Browsealoud",homepage:"https://www.texthelp.com/en-gb/products/browsealoud/",category:"other",domains:["*.browsealoud.com","*.texthelp.com"],examples:["www.browsealoud.com"],totalExecutionTime:665425,totalOccurrences:1951},{name:"15gifts",category:"customer-success",domains:["*.15gifts.com","*.primefuse.com"],examples:["www.primefuse.com"]},{name:"1xRUN",category:"utility",domains:["*.1xrun.com"]},{name:"2AdPro Media Solutions",category:"ad",domains:["*.2adpro.com"]},{name:"301 Digital Media",category:"content",domains:["*.301ads.com","*.301network.com"]},{name:"360 picnic platform",company:"MediaV",category:"ad",domains:["*.mediav.com"],totalExecutionTime:4893,totalOccurrences:78},{name:"365 Media Group",category:"content",domains:["*.365dm.com"]},{name:"365 Tech Services",category:"hosting",domains:["*.365webservices.co.uk"]},{name:"\
3D Issue",category:"utility",domains:["*.3dissue.com","*.pressjack.com"],totalExecutionTime:53823,totalOccurrences:30},{name:"47Line Technologies",category:"other",domains:["*.pejs.net"]},{name:"4finance",category:"utility",domains:["*.4finance.com"]},{name:"5miles",category:"content",domains:["*.5milesapp.com"]},{name:"77Tool",company:"77Agency",category:"analytics",domains:["*.77tracking.com"]},{name:"9xb",category:"ad",domains:["*.9xb.com"]},{name:"@UK",category:"hosting",domains:["*.uk-plc.net"]},{name:"A Perfect Pocket",category:"hosting",domains:["*.aperfectpocketdata.com"]},{name:"A-FIS PTE",category:"analytics",domains:["*.websta.me"]},{name:"AB Tasty",homepage:"https://www.abtasty.com/",category:"analytics",domains:["*.abtasty.com","d1447tq2m68ekg.cloudfront.net"],examples:["try.abtasty.com"],totalExecutionTime:1720461,totalOccurrences:3363},{name:"ABA RESEARCH",category:"analytics",domains:["*.abaresearch.uk","qmodal.azurewebsites.net"]},{name:"ADMIZED",category:"ad",domains:[
"*.admized.com"]},{name:"ADNOLOGIES",category:"ad",domains:["*.heias.com"]},{name:"ADventori",category:"ad",domains:["*.adventori.com"],totalExecutionTime:5790,totalOccurrences:21},{name:"AI Media Group",category:"ad",domains:["*.aimediagroup.com"]},{name:"AIR.TV",category:"ad",domains:["*.air.tv"]},{name:"AKQA",category:"ad",domains:["*.srtk.net"]},{name:"AOL ad",company:"AOL",category:"ad",domains:["*.atwola.com"]},{name:"AOL On",company:"AOL",category:"content",domains:["*.5min.com"]},{name:"AOL Sponsored Listiings",company:"AOL",category:"ad",domains:["*.adsonar.com"]},{name:"APSIS Lead",company:"APSIS International AB",category:"ad",domains:["*.prospecteye.com"]},{name:"APSIS Profile Cloud",company:"APSIS",category:"analytics",domains:["*.innomdc.com"]},{name:"APSIS Forms",company:"APSIS",category:"other",domains:["*.apsisforms.com"],examples:["forms.apsisforms.com"]},{name:"ARENA",company:"Altitude",category:"ad",domains:["*.altitude-arena.com"],totalExecutionTime:1,totalOccurrences:1},
{name:"ARM",category:"analytics",domains:["*.tag4arm.com"],totalExecutionTime:5847,totalOccurrences:83},{name:"ASAPP",category:"other",domains:["*.asapp.com"],totalExecutionTime:37052,totalOccurrences:31},{name:"ASP",category:"hosting",domains:["*.goshowoff.com"]},{name:"AT Internet",category:"analytics",domains:["*.ati-host.net"]},{name:"ATTRAQT",category:"utility",domains:["*.attraqt.com","*.locayta.com"]},{name:"AVANSER",category:"analytics",domains:["*.avanser.com.au"]},{name:"AVG",company:"AVG Technologies",category:"utility",domains:["*.avg.com"],examples:["omni.avg.com"]},{name:"AWeber",category:"ad",domains:["*.aweber.com"],totalExecutionTime:40945,totalOccurrences:280},{name:"AXS",category:"content",domains:["*.axs.com"],totalExecutionTime:49218,totalOccurrences:8},{name:"Accentuate",company:"Accentuate Digital",category:"utility",homepage:"https://www.accentuate.io/",domains:["*.accentuate.io"],examples:["cdn.accentuate.io","original.accentuate.io"],totalExecutionTime:1772,totalOccurrences:17},
{name:"Accenture",category:"analytics",domains:["*.tmvtp.com"]},{name:"Accord Holdings",category:"ad",domains:["*.agcdn.com"]},{name:"Accordant Media",category:"ad",domains:["*.a3cloud.net"],examples:["segment.a3cloud.net"]},{name:"Account Kit",category:"other",domains:["*.accountkit.com"]},{name:"Accuen Media (Omnicom Media Group)",category:"content",domains:["*.p-td.com"]},{name:"Accuweather",category:"content",domains:["*.accuweather.com"],totalExecutionTime:291762,totalOccurrences:1477},{name:"Acquisio",category:"ad",domains:["*.acq.io"],totalExecutionTime:1692,totalOccurrences:32},{name:"Act-On Software",category:"marketing",domains:["*.actonsoftware.com"],totalExecutionTime:98,totalOccurrences:2},{name:"ActBlue",category:"other",domains:["*.actblue.com"],totalExecutionTime:62800,totalOccurrences:73},{name:"Active Agent",category:"ad",domains:["*.active-agent.com"]},{name:"ActiveCampaign",category:"ad",domains:["*.trackcmp.net","app-us1.com","*.app-us1.com"],examples:["trackcmp.ne\
t","prism.app-us1.com","diffuser-cdn.app-us1.com"],totalExecutionTime:1605217,totalOccurrences:19100},{name:"AcuityAds",category:"ad",domains:["*.acuityplatform.com"],totalExecutionTime:2492,totalOccurrences:693},{name:"Acxiom",category:"ad",domains:["*.acxiom-online.com","*.acxiomapac.com","*.delivery.net"]},{name:"Ad4Screen",category:"ad",domains:["*.a4.tl"]},{name:"Ad6Media",category:"ad",domains:["*.ad6media.fr"],totalExecutionTime:821770,totalOccurrences:654},{name:"AdCurve",category:"ad",domains:["*.shop2market.com"]},{name:"AdEasy",category:"ad",domains:["*.adeasy.ru"]},{name:"AdExtent",category:"ad",domains:["*.adextent.com"]},{name:"AdForge Edge",company:"AdForge",category:"ad",domains:["*.adforgeinc.com"]},{name:"AdGear",company:"Samsung Electronics",category:"ad",domains:["*.adgear.com","*.adgrx.com"],totalExecutionTime:19948,totalOccurrences:42920},{name:"AdInMedia",category:"ad",domains:["*.fastapi.net"]},{name:"AdJug",category:"ad",domains:["*.adjug.com"],examples:["track\
ing.adjug.com","uk.view.adjug.com"]},{name:"AdMatic",category:"ad",domains:["*.admatic.com.tr"],totalExecutionTime:1274496,totalOccurrences:467},{name:"AdMedia",category:"ad",domains:["*.admedia.com"],examples:["pixel.admedia.com"],totalExecutionTime:2027,totalOccurrences:7},{name:"AdRecover",category:"ad",domains:["*.adrecover.com"],totalExecutionTime:5117,totalOccurrences:46},{name:"AdRiver",category:"ad",domains:["*.adriver.ru"],totalExecutionTime:1374767,totalOccurrences:4740},{name:"AdSniper",category:"ad",domains:["*.adsniper.ru","*.sniperlog.ru"],totalExecutionTime:2366,totalOccurrences:22},{name:"AdSpeed",category:"ad",domains:["*.adspeed.net"],totalExecutionTime:4642,totalOccurrences:16},{name:"AdSpruce",category:"ad",domains:["*.adspruce.com"]},{name:"AdSupply",category:"ad",domains:["*.doublepimp.com"],totalExecutionTime:1436,totalOccurrences:13},{name:"AdTheorent",category:"ad",domains:["*.adentifi.com"],totalExecutionTime:108,totalOccurrences:1},{name:"AdThink AudienceInsi\
ghts",company:"AdThink Media",category:"analytics",domains:["*.audienceinsights.net"]},{name:"AdTrue",company:"FPT AdTrue",category:"ad",domains:["*.adtrue.com"]},{name:"AdYapper",category:"ad",domains:["*.adyapper.com"]},{name:"Adacado",category:"ad",domains:["*.adacado.com"],totalExecutionTime:1777,totalOccurrences:18},{name:"Adap.tv",category:"ad",domains:["*.adap.tv"]},{name:"Adapt Services",category:"hosting",domains:["*.adcmps.com"]},{name:"Adaptive Web",category:"hosting",domains:["*.adaptive.co.uk"]},{name:"Adara Media",category:"ad",domains:["*.yieldoptimizer.com"],totalExecutionTime:1324,totalOccurrences:23},{name:"Adblade",category:"ad",domains:["*.adblade.com"],totalExecutionTime:704,totalOccurrences:7},{name:"Adbrain",category:"ad",domains:["*.adbrn.com"]},{name:"AddEvent",category:"utility",domains:["*.addevent.com"],examples:["www.addevent.com"],totalExecutionTime:73230,totalOccurrences:203},{name:"AddShoppers",category:"social",domains:["*.addshoppers.com","d3rr3d0n31t4\
8m.cloudfront.net","*.shop.pe"],totalExecutionTime:31574,totalOccurrences:451},{name:"AddThisEvent",category:"hosting",domains:["*.addthisevent.com"]},{name:"Addoox MetaNetwork",company:"Addoox",category:"ad",domains:["*.metanetwork.net"]},{name:"Addvantage Media",category:"ad",domains:["*.addvantagemedia.com","*.simplytechnology.net"]},{name:"AD EBis",category:"analytics",homepage:"https://www.ebis.ne.jp/",domains:["*.ebis.ne.jp"],examples:["taj1.ebis.ne.jp"],totalExecutionTime:55086,totalOccurrences:608},{name:"Adecs",category:"customer-success",domains:["*.adecs.co.uk"],examples:["www.adecs.co.uk"]},{name:"Adelphic",category:"ad",domains:["*.ipredictive.com"],totalExecutionTime:8196,totalOccurrences:112},{name:"Adestra",category:"ad",domains:["*.adestra.com","*.msgfocus.com"]},{name:"Adform",category:"ad",domains:["*.adform.net","*.adformdsp.net"],totalExecutionTime:1798751,totalOccurrences:140125},{name:"Adkontekst",category:"ad",domains:["*.adkontekst.pl"]},{name:"Adlead",category:"\
ad",domains:["*.webelapp.com"]},{name:"Adledge",category:"utility",domains:["*.adledge.com"]},{name:"Adloox",category:"ad",domains:["*.adlooxtracking.com"],totalExecutionTime:103507,totalOccurrences:112},{name:"Adlux",category:"ad",domains:["*.adlux.com"]},{name:"Admedo",category:"ad",domains:["*.a8723.com","*.adizio.com","*.admedo.com"],examples:["pool.a8723.com"],totalExecutionTime:9586,totalOccurrences:695},{name:"Admeta",company:"Wideorbit",category:"ad",domains:["*.atemda.com"]},{name:"Admetrics",company:"Next Tuesday",category:"analytics",domains:["*.nt.vc"],examples:["metrics.nt.vc"]},{name:"Admiral",category:"ad",domains:["*.unknowntray.com"]},{name:"Admitad",category:"ad",domains:["*.lenmit.com"],totalExecutionTime:2335,totalOccurrences:31},{name:"Admixer for Publishers",company:"Admixer",category:"ad",domains:["*.admixer.net"],totalExecutionTime:1542643,totalOccurrences:878},{name:"Adnium",category:"ad",domains:["*.adnium.com"]},{name:"Adnostic",company:"Dennis Publishing",category:"\
ad",domains:["*.adnostic.co.uk"]},{name:"Adobe Marketing Cloud",company:"Adobe Systems",category:"ad",domains:["*.adobetag.com"]},{name:"Adobe Scene7",company:"Adobe Systems",category:"content",domains:["wwwimages.adobe.com","*.scene7.com","*.everestads.net","*.everestjs.net"],totalExecutionTime:808424,totalOccurrences:702},{name:"Adobe Systems",category:"content",domains:["adobe.com","www.adobe.com"],totalExecutionTime:38836,totalOccurrences:179},{name:"Adobe Business Catalyst",homepage:"https://www.businesscatalyst.com/",category:"hosting",domains:["*.businesscatalyst.com"]},{name:"Adocean",company:"Gemius",category:"ad",domains:["*.adocean.pl"],totalExecutionTime:1658274,totalOccurrences:2151},{name:"Adometry",company:"Google",category:"ad",domains:["*.dmtry.com"]},{name:"Adomik",category:"analytics",domains:["*.adomik.com"]},{name:"Adotmob",category:"ad",domains:["*.adotmob.com"]},{name:"Adrian Quevedo",category:"hosting",domains:["*.adrianquevedo.com"]},{name:"Adroit Digital Solut\
ions",category:"ad",domains:["*.imiclk.com","*.abmr.net"]},{name:"AdsNative",category:"ad",domains:["*.adsnative.com"]},{name:"AdsWizz",category:"ad",domains:["*.adswizz.com"],totalExecutionTime:479514,totalOccurrences:1901},{name:"Adscale",category:"ad",domains:["*.adscale.de"],totalExecutionTime:106237,totalOccurrences:960},{name:"Adschoom",company:"JSWeb Production",category:"ad",domains:["*.adschoom.com"],totalExecutionTime:491,totalOccurrences:2},{name:"Adscience",category:"ad",domains:["*.adscience.nl"]},{name:"Adsiduous",category:"ad",domains:["*.adsiduous.com"]},{name:"Adsty",category:"ad",domains:["*.adx1.com"],totalExecutionTime:698,totalOccurrences:5},{name:"Adtech (AOL)",category:"ad",domains:["*.adtechus.com"],totalExecutionTime:176,totalOccurrences:2},{name:"Adtegrity",category:"ad",domains:["*.adtpix.com"],totalExecutionTime:1735,totalOccurrences:20},{name:"Adthink",company:"Adthink Media",category:"ad",domains:["*.adxcore.com","*.dcoengine.com"],examples:["d.adxcore.com"]},
{name:"AdultWebmasterEmpire.Com",category:"ad",domains:["*.awempire.com"],totalExecutionTime:65091,totalOccurrences:38},{name:"Adunity",category:"ad",domains:["*.adunity.com"]},{name:"Advance Magazine Group",category:"content",domains:["*.condenastdigital.com","*.condenet.com","*.condenast.co.uk"],totalExecutionTime:2531,totalOccurrences:8},{name:"Adverline Board",company:"Adverline",category:"ad",domains:["*.adverline.com","*.adnext.fr"]},{name:"AdvertServe",category:"ad",domains:["*.advertserve.com"],totalExecutionTime:112685,totalOccurrences:437},{name:"Advolution",category:"utility",domains:["*.advolution.de"]},{name:"Adwise",category:"ad",domains:["*.adwise.bg"],totalExecutionTime:144,totalOccurrences:2},{name:"Adyen",category:"utility",domains:["*.adyen.com"],totalExecutionTime:6335144,totalOccurrences:2363},{name:"Adyoulike",category:"ad",domains:["*.adyoulike.com","*.omnitagjs.com","*.adyoulike.net"],totalExecutionTime:147862,totalOccurrences:53190},{name:"Adzerk",category:"ad",
domains:["*.adzerk.net"],totalExecutionTime:35184,totalOccurrences:117},{name:"Adzip",company:"Adbox Digital",category:"ad",domains:["*.adzip.co"]},{name:"AerServ",category:"ad",domains:["*.aerserv.com"]},{name:"Affectv",category:"ad",domains:["*.affectv.com","*.affec.tv"],totalExecutionTime:1187,totalOccurrences:12},{name:"Affiliate Window",company:"Digital Window",category:"ad",domains:["*.dwin1.com"],totalExecutionTime:561168,totalOccurrences:5414},{name:"Affiliatly",category:"ad",domains:["*.affiliatly.com"],examples:["www.affiliatly.com"],totalExecutionTime:32020,totalOccurrences:132},{name:"Affino",category:"ad",domains:["affino.com"]},{name:"Affirm",category:"utility",domains:["*.affirm.com"],totalExecutionTime:3997184,totalOccurrences:6665},{name:"Afterpay",company:"Block",category:"utility",homepage:"https://www.afterpay.com/",domains:["*.afterpay.com"],examples:["static-us.afterpay.com"],totalExecutionTime:1270109,totalOccurrences:8269},{name:"Agenda Media",category:"ad",domains:[
"*.agendamedia.co.uk"]},{name:"Aggregate Knowledge",company:"Neustar",category:"ad",domains:["*.agkn.com"],totalExecutionTime:14828,totalOccurrences:344},{name:"AgilOne",category:"marketing",domains:["*.agilone.com"],totalExecutionTime:4190,totalOccurrences:53},{name:"Agility",category:"hosting",domains:["*.agilitycms.com"],totalExecutionTime:3079,totalOccurrences:4},{name:"Ahalogy",category:"social",domains:["*.ahalogy.com"]},{name:"Aheadworks",category:"utility",domains:["*.aheadworks.com"]},{name:"AirPR",category:"analytics",domains:["*.airpr.com"],totalExecutionTime:416,totalOccurrences:5},{name:"Aira",category:"ad",domains:["*.aira.net"],examples:["www.aira.net"]},{name:"Airport Parking and Hotels",category:"content",domains:["*.aph.com"],totalExecutionTime:277,totalOccurrences:3},{name:"Akanoo",category:"analytics",domains:["*.akanoo.com"]},{name:"Alchemy",company:"AndBeyond.Media",category:"ad",domains:["*.andbeyond.media"],totalExecutionTime:456340,totalOccurrences:164},{name:"\
AlephD",company:"AOL",category:"ad",domains:["*.alephd.com"]},{name:"AliveChat",company:"AYU Technology Solutions",category:"customer-success",domains:["*.websitealive.com","*.websitealive7.com"]},{name:"All Access",category:"other",domains:["*.allaccess.com.ph"]},{name:"Alliance for Audited Media",category:"ad",domains:["*.aamsitecertifier.com"]},{name:"Allyde",category:"marketing",domains:["*.mautic.com"]},{name:"AlphaSSL",category:"utility",domains:["*.alphassl.com"],totalExecutionTime:1146,totalOccurrences:10},{name:"Altitude",category:"ad",domains:["*.altitudeplatform.com"]},{name:"Altocloud",category:"analytics",domains:["*.altocloud.com"]},{name:"Amadeus",category:"content",domains:["*.e-travel.com"]},{name:"Amazon CloudFront",company:"Amazon",category:"utility",domains:["cloudfront.net"]},{name:"Ambassador",category:"ad",domains:["*.getambassador.com"],totalExecutionTime:21042,totalOccurrences:89},{name:"Ambient",company:"Ericcson",category:"other",domains:["*.adnetwork.vn","*.\
ambientplatform.vn"]},{name:"Amelia Communication",category:"hosting",domains:["*.sara.media"]},{name:"Amobee",category:"marketing",domains:["*.amgdgt.com","*.kontera.com"]},{name:"Amplience",category:"marketing",domains:["*.10cms.com","*.amplience.com","*.amplience.net","*.bigcontent.io","*.adis.ws"],totalExecutionTime:4093,totalOccurrences:17},{name:"Amplitude Mobile Analytics",company:"Amplitude",category:"analytics",domains:["*.amplitude.com","d24n15hnbwhuhn.cloudfront.net"],totalExecutionTime:8703641,totalOccurrences:46524},{name:"Anametrix",company:"Ensighten",category:"analytics",domains:["*.anametrix.com"]},{name:"Ancora Platform",company:"Ancora Media Solutions",category:"ad",domains:["*.ancoraplatform.com"]},{name:"Anedot",category:"other",domains:["*.anedot.com"],totalExecutionTime:84655,totalOccurrences:21},{name:"AnimateJS",category:"utility",domains:["*.animatedjs.com"]},{name:"AnswerDash",category:"customer-success",domains:["*.answerdash.com"],examples:["p1.answerdash.c\
om"]},{name:"Answers",category:"analytics",domains:["*.answcdn.com","*.answers.com","*.dsply.com"]},{name:"Apester",category:"analytics",domains:["*.apester.com","*.qmerce.com"],totalExecutionTime:25294,totalOccurrences:166},{name:"Apligraf SmartWeb",company:"Apligraf",category:"utility",domains:["*.apligraf.com.br"]},{name:"Appier",category:"ad",domains:["*.appier.net"],totalExecutionTime:124524,totalOccurrences:826},{name:"Appsolute",category:"utility",homepage:"https://appsolute.us/",domains:["dropahint.love"],examples:["dropahint.love"],totalExecutionTime:16362,totalOccurrences:144},{name:"Apptus eSales",company:"Apptus",category:"analytics",domains:["*.apptus.com"]},{name:"Arbor",company:"LiveRamp",category:"other",domains:["*.pippio.com"]},{name:"Ardent Creative",category:"hosting",domains:["*.ardentcreative.co.uk"]},{name:"Arnold Clark Automobiles",category:"content",domains:["*.arnoldclark.com"]},{name:"Atom Content Marketing",category:"content",domains:["*.atomvault.net"],examples:[
"danu.atomvault.net"]},{name:"Atom Data",category:"other",domains:["*.atomdata.io"]},{name:"Attribution",category:"ad",domains:["*.attributionapp.com"],totalExecutionTime:44124,totalOccurrences:124},{name:"Audience 360",company:"Datapoint Media",category:"ad",domains:["*.dpmsrv.com"],totalExecutionTime:578723,totalOccurrences:371},{name:"Audience Science",category:"ad",domains:["*.revsci.net"]},{name:"AudienceSearch",company:"Intimate Merger",category:"ad",domains:["*.im-apps.net"],totalExecutionTime:9114981,totalOccurrences:46726},{name:"Auditorius",category:"ad",domains:["*.audtd.com"]},{name:"Augur",category:"analytics",domains:["*.augur.io"]},{name:"Auto Link Maker",company:"Apple",category:"ad",domains:["*.apple.com"],examples:["autolinkmaker.itunes.apple.com"],totalExecutionTime:657122,totalOccurrences:2479},{name:"Autopilot",category:"ad",domains:["*.autopilothq.com"],totalExecutionTime:15490,totalOccurrences:74},{name:"Avail",company:"RichRelevance",category:"ad",domains:["*.av\
ail.net"]},{name:"AvantLink",category:"ad",domains:["*.avmws.com"],totalExecutionTime:417,totalOccurrences:8},{name:"Avco Systems",category:"utility",domains:["*.avcosystems.com"]},{name:"Avid Media",category:"customer-success",domains:["*.adspdbl.com","*.metadsp.co.uk"],totalExecutionTime:58,totalOccurrences:1},{name:"Avocet Systems",category:"ad",domains:["*.avocet.io","ads.avct.cloud"]},{name:"Avora",category:"analytics",domains:["*.truedash.com"],examples:["truetag.truedash.com"]},{name:"Azure Traffic Manager",company:"Microsoft",category:"other",domains:["*.gateway.net","*.trafficmanager.net"],examples:["analytics.gateway.net"],totalExecutionTime:51660,totalOccurrences:148},{name:"Azure Web Services",company:"Microsoft",category:"cdn",domains:["*.azurewebsites.net","*.azureedge.net","*.msedge.net","*.windows.net"],totalExecutionTime:35665078,totalOccurrences:51378},{name:"BAM",category:"analytics",domains:["*.bam-x.com"]},{name:"Baifendian Technology",category:"marketing",domains:[
"*.baifendian.com"]},{name:"Bankrate",category:"utility",domains:["*.bankrate.com"]},{name:"BannerFlow",company:"Nordic Factory Solutions",category:"ad",domains:["*.bannerflow.com"],totalExecutionTime:50455,totalOccurrences:42},{name:"Barclaycard SmartPay",company:"Barclaycard",category:"utility",domains:["*.barclaycardsmartpay.com"]},{name:"Barilliance",category:"analytics",domains:["*.barilliance.net","dn3y71tq7jf07.cloudfront.net"],totalExecutionTime:7250,totalOccurrences:26},{name:"Barnebys",category:"other",domains:["*.barnebys.com"],totalExecutionTime:59682,totalOccurrences:57},{name:"Basis",company:"Basis Technologies",category:"ad",homepage:"https://basis.net/",domains:["*.basis.net"],examples:["cdn01.basis.net"],totalExecutionTime:215661,totalOccurrences:2623},{name:"Batch Media",category:"ad",domains:["*.t4ft.de"]},{name:"Bauer Consumer Media",category:"content",domains:["*.bauercdn.com","*.greatmagazines.co.uk"],examples:["www.greatmagazines.co.uk"]},{name:"Baynote",category:"\
analytics",domains:["*.baynote.net"]},{name:"Bazaarvoice",category:"analytics",domains:["*.bazaarvoice.com","*.feedmagnet.com"],totalExecutionTime:1664795,totalOccurrences:3375},{name:"Beachfront Media",category:"ad",domains:["*.bfmio.com"],totalExecutionTime:7782,totalOccurrences:771},{name:"BeamPulse",category:"analytics",domains:["*.beampulse.com"]},{name:"Beeswax",category:"ad",domains:["*.bidr.io"],totalExecutionTime:5298,totalOccurrences:12735},{name:"Beetailer",category:"social",domains:["*.beetailer.com"],examples:["www.beetailer.com"]},{name:"Best Of Media S.A.",category:"content",domains:["*.servebom.com"],totalExecutionTime:29,totalOccurrences:67},{name:"Bet365",category:"ad",domains:["*.bet365affiliates.com"]},{name:"Betfair",category:"other",domains:["*.cdnbf.net"]},{name:"Betgenius",company:"Genius Sports",category:"content",domains:["*.connextra.com"],totalExecutionTime:84739,totalOccurrences:287},{name:"Better Banners",category:"ad",domains:["*.betterbannerscloud.com"]},
{name:"Better Business Bureau",category:"analytics",domains:["*.bbb.org"],totalExecutionTime:10819,totalOccurrences:78},{name:"Between Digital",category:"ad",domains:["*.betweendigital.com"],totalExecutionTime:88306,totalOccurrences:787},{name:"BidTheatre",category:"ad",domains:["*.bidtheatre.com"],totalExecutionTime:23106,totalOccurrences:252},{name:"Bidtellect",category:"ad",domains:["*.bttrack.com"],totalExecutionTime:2834,totalOccurrences:19},{name:"Bigcommerce",category:"marketing",domains:["*.bigcommerce.com"],totalExecutionTime:45747978,totalOccurrences:19595},{name:"BitGravity",company:"Tata Communications",category:"content",domains:["*.bitgravity.com"]},{name:"Bitly",category:"utility",domains:["*.bitly.com","*.lemde.fr","*.bit.ly"],totalExecutionTime:2977,totalOccurrences:8},{name:"Bizible",category:"ad",domains:["*.bizible.com","*.bizibly.com"],totalExecutionTime:435247,totalOccurrences:1186},{name:"Bizrate",category:"analytics",domains:["*.bizrate.com"],totalExecutionTime:11197,
totalOccurrences:57},{name:"BlastCasta",category:"social",domains:["*.poweringnews.com"],examples:["www.poweringnews.com"]},{name:"Blindado",category:"utility",domains:["*.siteblindado.com"],totalExecutionTime:41,totalOccurrences:1},{name:"Blis",category:"ad",domains:["*.blismedia.com"]},{name:"Blogg.se",category:"hosting",domains:["*.cdnme.se","*.publishme.se"]},{name:"BloomReach",category:"ad",domains:["*.brcdn.com","*.brsrvr.com","*.brsvr.com"],totalExecutionTime:2695,totalOccurrences:47},{name:"Bloomberg",category:"content",domains:["*.gotraffic.net"]},{name:"Shop Logic",company:"BloomReach",category:"marketing",domains:["*.goshoplogic.com"]},{name:"Blue State Digital",category:"ad",domains:["*.bsd.net"]},{name:"Blue Triangle Technologies",category:"analytics",domains:["*.btttag.com"],totalExecutionTime:102966,totalOccurrences:182},{name:"BlueCava",category:"ad",domains:["*.bluecava.com"],totalExecutionTime:466075,totalOccurrences:5165},{name:"BlueKai",company:"Oracle",category:"ad",
domains:["*.bkrtx.com","*.bluekai.com"],totalExecutionTime:4,totalOccurrences:6},{name:"Bluecore",category:"analytics",domains:["*.bluecore.com"],examples:["www.bluecore.com"],totalExecutionTime:83612,totalOccurrences:225},{name:"Bluegg",category:"hosting",domains:["d1va5oqn59yrvt.cloudfront.net"]},{name:"Bold Commerce",category:"utility",domains:["*.shappify-cdn.com","*.shappify.com","*.boldapps.net"],totalExecutionTime:5072681,totalOccurrences:9886},{name:"BoldChat",company:"LogMeIn",category:"customer-success",domains:["*.boldchat.com"]},{name:"Bombora",category:"ad",domains:["*.mlno6.com"]},{name:"Bonnier",category:"content",domains:["*.bonniercorp.com"]},{name:"Bookatable",category:"content",domains:["*.bookatable.com","*.livebookings.com"]},{name:"Booking.com",category:"content",domains:["*.bstatic.com"],totalExecutionTime:1652677,totalOccurrences:2448},{name:"Boomtrain",category:"ad",domains:["*.boomtrain.com","*.boomtrain.net"],totalExecutionTime:360072,totalOccurrences:2169},{
name:"BoostSuite",category:"ad",domains:["*.poweredbyeden.com"]},{name:"Boostable",category:"ad",domains:["*.boostable.com"]},{name:"Bootstrap Chinese network",category:"cdn",domains:["*.bootcss.com"],totalExecutionTime:427117,totalOccurrences:881},{name:"Booxscale",category:"ad",domains:["*.booxscale.com"]},{name:"Borderfree",company:"pitney bowes",category:"utility",domains:["*.borderfree.com","*.fiftyone.com"]},{name:"BowNow",category:"analytics",homepage:"https://bow-now.jp/",domains:["*.bownow.jp"],examples:["contents.bownow.jp"],totalExecutionTime:1298132,totalOccurrences:2410},{name:"Box",category:"hosting",domains:["*.box.com"],totalExecutionTime:15191,totalOccurrences:223},{name:"Boxever",category:"analytics",domains:["*.boxever.com"]},{name:"Braintree Payments",company:"Paypal",category:"utility",domains:["*.braintreegateway.com"],totalExecutionTime:171291,totalOccurrences:1141},{name:"Branch Metrics",category:"ad",domains:["*.branch.io","*.app.link"],totalExecutionTime:441792,
totalOccurrences:8288},{name:"Brand Finance",category:"other",domains:["*.brandirectory.com"]},{name:"Brand View",category:"analytics",domains:["*.brandview.com"]},{name:"Brandscreen",category:"ad",domains:["*.rtbidder.net"],examples:["match.rtbidder.net"]},{name:"BridgeTrack",company:"Sapient",category:"ad",domains:["*.bridgetrack.com"]},{name:"BrightRoll",company:"Yahoo!",category:"ad",domains:["*.btrll.com"]},{name:"BrightTag / Signal",company:"Signal",homepage:"https://www.signal.co",category:"tag-manager",domains:["*.btstatic.com","*.thebrighttag.com"]},{name:"Brightcove ZenCoder",company:"Brightcove",category:"other",domains:["*.zencoder.net"]},{name:"Bronto Software",category:"marketing",domains:["*.bm23.com","*.bronto.com","*.brontops.com"]},{name:"Browser-Update.org",category:"other",domains:["*.browser-update.org"]},{name:"Buffer",category:"social",domains:["*.bufferapp.com"],totalExecutionTime:535,totalOccurrences:7},{name:"Bugsnag",category:"utility",domains:["*.bugsnag.com",
"d2wy8f7a9ursnm.cloudfront.net"],examples:["notify.bugsnag.com"],totalExecutionTime:6197502,totalOccurrences:15069},{name:"Burst Media",category:"ad",domains:["*.burstnet.com","*.1rx.io"],examples:["usermatch.burstnet.com"],totalExecutionTime:1618,totalOccurrences:52},{name:"Burt",category:"analytics",domains:["*.richmetrics.com","*.burt.io"]},{name:"Business Message",category:"ad",domains:["*.message-business.com"],totalExecutionTime:7310,totalOccurrences:21},{name:"Business Week",company:"Bloomberg",category:"social",domains:["*.bwbx.io"],totalExecutionTime:67737,totalOccurrences:9},{name:"Buto",company:"Big Button",category:"ad",domains:["*.buto.tv"]},{name:"Button",category:"ad",domains:["*.btncdn.com"]},{name:"BuySellAds",category:"ad",domains:["*.buysellads.com","*.buysellads.net"],totalExecutionTime:179225,totalOccurrences:170},{name:"BuySight (AOL)",category:"ad",domains:["*.pulsemgr.com"]},{name:"Buyapowa",category:"ad",domains:["*.co-buying.com"],totalExecutionTime:3038,totalOccurrences:37},
{name:"BuzzFeed",category:"social",domains:["*.buzzfed.com","*.buzzfeed.com"],totalExecutionTime:14608,totalOccurrences:2},{name:"C1X",category:"ad",domains:["*.c1exchange.com"]},{name:"C3 Metrics",category:"analytics",domains:["*.c3tag.com"],totalExecutionTime:18122,totalOccurrences:153},{name:"CANDDi",company:"Campaign and Digital Intelligence",category:"ad",domains:["*.canddi.com"],totalExecutionTime:84756,totalOccurrences:150},{name:"CCM benchmark Group",category:"social",domains:["*.ccm2.net"]},{name:"CD Networks",category:"utility",domains:["*.gccdn.net"]},{name:"CDN Planet",category:"analytics",domains:["*.cdnplanet.com"]},{name:"InAuth",category:"utility",homepage:"https://www.inauth.com/",domains:["*.cdn-net.com"],examples:["uk.cdn-net.com"],totalExecutionTime:306346,totalOccurrences:298},{name:"CJ Affiliate",company:"Conversant",category:"ad",domains:["*.cj.com","*.dpbolvw.net"],totalExecutionTime:7725,totalOccurrences:17},{name:"CJ Affiliate by Conversant",company:"Conversan\
t",category:"ad",domains:["*.ftjcfx.com"],totalExecutionTime:8,totalOccurrences:4},{name:"CNBC",category:"content",domains:["*.cnbc.com"],totalExecutionTime:11468,totalOccurrences:12},{name:"CNET Content Solutions",company:"CBS Interactive",category:"content",domains:["*.cnetcontent.com"],examples:["cdn.cnetcontent.com","ws.cnetcontent.com"]},{name:"CPEx",category:"content",domains:["*.cpex.cz"],totalExecutionTime:763356,totalOccurrences:1104},{name:"CPXi",category:"ad",domains:["*.cpxinteractive.com"]},{name:"CUBED Attribution",company:"CUBED",category:"ad",domains:["*.withcubed.com"],examples:["data.withcubed.com"]},{name:"Cachefly",category:"utility",domains:["*.cachefly.net"],totalExecutionTime:128046,totalOccurrences:258},{name:"Calendly",category:"other",domains:["*.calendly.com"],totalExecutionTime:8622733,totalOccurrences:4604},{name:"CallRail",category:"analytics",domains:["*.callrail.com"],totalExecutionTime:8080185,totalOccurrences:29537},{name:"CallTrackingMetrics",category:"\
analytics",domains:["*.tctm.co"],totalExecutionTime:1981698,totalOccurrences:7503},{name:"Canned Banners",category:"ad",domains:["*.cannedbanners.com"]},{name:"Canopy Labs",category:"analytics",domains:["*.canopylabs.com"]},{name:"Capita",category:"utility",domains:["*.crcom.co.uk"],examples:["emmsrep.crcom.co.uk"]},{name:"Captify Media",category:"ad",domains:["*.cpx.to"],totalExecutionTime:1519,totalOccurrences:31},{name:"Captiify",category:"ad",domains:["*.captifymedia.com"]},{name:"Captivate Ai",category:"ad",domains:["*.captivate.ai"]},{name:"Captora",category:"marketing",domains:["*.captora.com"]},{name:"Carcloud",category:"other",domains:["*.carcloud.co.uk"]},{name:"Cardlytics",category:"ad",domains:["*.cardlytics.com"]},{name:"Cardosa Enterprises",category:"analytics",domains:["*.y-track.com"],totalExecutionTime:778,totalOccurrences:17},{name:"Caspian Media",category:"ad",domains:["*.caspianmedia.com"]},{name:"Cast",category:"utility",domains:["*.cast.rocks"]},{name:"Catch",category:"\
other",domains:["*.getcatch.com"],examples:["app.getcatch.com","assets.getcatch.com","js.getcatch.com"],totalExecutionTime:18282,totalOccurrences:40},{name:"Cavisson",category:"analytics",domains:["*.cavisson.com"]},{name:"Cedato",category:"ad",domains:["*.algovid.com","*.vdoserv.com"]},{name:"Celebrus Technologies",category:"analytics",domains:["*.celebrus.com"]},{name:"Celtra",category:"ad",domains:["*.celtra.com"],totalExecutionTime:369517,totalOccurrences:427},{name:"Centro",category:"ad",domains:["*.brand-server.com"]},{name:"Ceros",category:"other",domains:["ceros.com","view.ceros.com"],totalExecutionTime:64139,totalOccurrences:149},{name:"Ceros Analytics",company:"Ceros",category:"analytics",domains:["api.ceros.com"]},{name:"Certona",category:"analytics",domains:["*.certona.net"],totalExecutionTime:376,totalOccurrences:4},{name:"Certum",category:"utility",domains:["*.ocsp-certum.com","*.certum.pl"],totalExecutionTime:8544,totalOccurrences:3},{name:"Cgrdirect",category:"other",domains:[
"*.cgrdirect.co.uk"]},{name:"Channel 5 Media",category:"ad",domains:["*.five.tv"]},{name:"Channel.me",category:"customer-success",domains:["*.channel.me"]},{name:"ChannelAdvisor",category:"ad",domains:["*.channeladvisor.com","*.searchmarketing.com"],totalExecutionTime:3385,totalOccurrences:25},{name:"ChannelApe",company:"ChannelApe",category:"other",homepage:"https://www.channelape.com/",domains:["*.channelape.com"],examples:["callbacks.channelape.com"]},{name:"Chargeads Oscar",company:"Chargeads",category:"ad",domains:["*.chargeads.com"]},{name:"Charities Aid Foundation",category:"utility",domains:["*.cafonline.org"],totalExecutionTime:4368,totalOccurrences:7},{name:"Chartbeat",category:"analytics",domains:["*.chartbeat.com","*.chartbeat.net"],totalExecutionTime:1270560,totalOccurrences:6246},{name:"Cheapflights Media",company:"Momondo",category:"content",domains:["*.momondo.net"]},{name:"CheckM8",category:"ad",domains:["*.checkm8.com"]},{name:"CheckRate",company:"FreeStart",category:"\
utility",domains:["*.checkrate.co.uk"]},{name:"Checkfront",category:"other",domains:["*.checkfront.com","dcg3jth5savst.cloudfront.net"],totalExecutionTime:279282,totalOccurrences:152},{name:"CheetahMail",company:"Experian",category:"ad",domains:["*.chtah.com"]},{name:"Chitika",category:"ad",domains:["*.chitika.net"]},{name:"ChoiceStream",category:"ad",domains:["*.choicestream.com"]},{name:"Cint",category:"social",domains:["*.cint.com"],totalExecutionTime:111659,totalOccurrences:33},{name:"Civic",category:"hosting",domains:["*.civiccomputing.com"],totalExecutionTime:2815742,totalOccurrences:7253},{name:"ClearRise",category:"customer-success",domains:["*.clearrise.com"]},{name:"Clearstream",category:"ad",domains:["*.clrstm.com"]},{name:"Clerk.io ApS",category:"analytics",domains:["*.clerk.io"],totalExecutionTime:1196778,totalOccurrences:1915},{name:"CleverDATA",category:"ad",domains:["*.1dmp.io"]},{name:"CleverTap",category:"analytics",domains:["d2r1yp2w7bby2u.cloudfront.net"],totalExecutionTime:163519,
totalOccurrences:1321},{name:"Click Density",category:"analytics",domains:["*.clickdensity.com"]},{name:"Click4Assistance",category:"customer-success",domains:["*.click4assistance.co.uk"],totalExecutionTime:22710,totalOccurrences:178},{name:"ClickDesk",category:"customer-success",domains:["*.clickdesk.com","d1gwclp1pmzk26.cloudfront.net"],totalExecutionTime:74975,totalOccurrences:595},{name:"ClickDimensions",category:"ad",domains:["*.clickdimensions.com"],totalExecutionTime:125295,totalOccurrences:262},{name:"Clickadu (Winner Solutions)",category:"ad",domains:["*.clickadu.com"],totalExecutionTime:10740,totalOccurrences:4},{name:"Clickagy Audience Lab",company:"Clickagy",category:"ad",domains:["*.clickagy.com"],examples:["aorta.clickagy.com"],totalExecutionTime:44558,totalOccurrences:667},{name:"Clickio",category:"ad",domains:[]},{name:"Clicktale",category:"analytics",domains:["*.cdngc.net","*.clicktale.net"],examples:["clicktalecdn.sslcs.cdngc.net"],totalExecutionTime:288716,totalOccurrences:256},
{name:"Clicktripz",category:"content",domains:["*.clicktripz.com"],examples:["static.clicktripz.com","www.clicktripz.com"],totalExecutionTime:502041,totalOccurrences:354},{name:"Clik.com Websites",category:"content",domains:["*.clikpic.com"]},{name:"Cloud Technologies",category:"ad",domains:["*.behavioralengine.com","*.behavioralmailing.com"]},{name:"Cloud-A",category:"other",domains:["*.bulkstorage.ca"]},{name:"Cloud.typography",company:"Hoefler &amp; Co",category:"cdn",domains:["*.typography.com"],totalExecutionTime:3308,totalOccurrences:364},{name:"CloudSponge",category:"ad",domains:["*.cloudsponge.com"]},{name:"CloudVPS",category:"other",domains:["*.adoftheyear.com","*.objectstore.eu"]},{name:"Cloudinary",category:"content",domains:["*.cloudinary.com"],totalExecutionTime:1188126,totalOccurrences:2129},{name:"Cloudqp",company:"Cloudwp",category:"other",domains:["*.cloudwp.io"]},{name:"Cludo",category:"utility",domains:["*.cludo.com"],totalExecutionTime:25376,totalOccurrences:249},{name:"\
Cognesia",category:"marketing",domains:["*.intelli-direct.com"]},{name:"CogoCast",company:"Cogo Labs",category:"ad",domains:["*.cogocast.net"]},{name:"Colbenson",category:"utility",domains:["*.colbenson.com"]},{name:"Collective",category:"ad",domains:["*.collective-media.net"]},{name:"Com Laude",category:"other",domains:["*.gdimg.net"]},{name:"Comm100",category:"customer-success",domains:["*.comm100.com"],totalExecutionTime:469389,totalOccurrences:1045},{name:"CommerceHub",category:"marketing",domains:["*.mercent.com"]},{name:"Commission Factory",category:"ad",domains:["*.cfjump.com"],totalExecutionTime:961,totalOccurrences:12},{name:"Communicator",category:"ad",domains:["*.communicatorcorp.com","*.communicatoremail.com"]},{name:"Comodo",category:"utility",domains:["*.comodo.com","*.trust-provider.com","*.trustlogo.com","*.usertrust.com","*.comodo.net"],examples:["ocsp.trust-provider.com"],totalExecutionTime:41752,totalOccurrences:34},{name:"Comodo Certificate Authority",company:"Comod\
o",category:"utility",domains:["crt.comodoca.com","*.comodoca4.com","ocsp.comodoca.com","ocsp.usertrust.com","crt.usertrust.com"],examples:["ocsp.comodoca4.com"]},{name:"Compete",company:"Millwood Brown Digital",category:"analytics",domains:["*.c-col.com","*.compete.com"]},{name:"Compuware",category:"analytics",domains:["*.axf8.net"]},{name:"Conductrics",category:"analytics",domains:["*.conductrics.com"],examples:["cdn-v3.conductrics.com"],totalExecutionTime:12705,totalOccurrences:61},{name:"Confirmit",category:"analytics",domains:["*.confirmit.com"],totalExecutionTime:32100,totalOccurrences:195},{name:"Connatix",category:"ad",domains:["*.connatix.com"],totalExecutionTime:6751327,totalOccurrences:1195},{name:"Connect Events",category:"hosting",domains:["*.connectevents.com.au"]},{name:"Constant Contact",category:"ad",domains:["*.ctctcdn.com"],totalExecutionTime:604932,totalOccurrences:17528},{name:"Constructor.io",category:"utility",domains:["*.cnstrc.com"]},{name:"Contabo",category:"h\
osting",domains:["185.2.100.179"]},{name:"Content Media Corporation",category:"content",domains:["*.contentmedia.eu"]},{name:"ContentSquare",category:"analytics",domains:["d1m6l9dfulcyw7.cloudfront.net","*.content-square.net","*.contentsquare.net"],totalExecutionTime:3626830,totalOccurrences:2948},{name:"ContextWeb",category:"ad",domains:["*.contextweb.com"],totalExecutionTime:32437,totalOccurrences:1909},{name:"Continental Exchange Solutions",category:"utility",domains:["*.hifx.com"]},{name:"Converge-Digital",category:"ad",domains:["*.converge-digital.com"],examples:["ads.converge-digital.com"]},{name:"Conversant",category:"analytics",domains:["*.dotomi.com","*.dtmpub.com","*.emjcd.com","mediaplex.com","*.tqlkg.com","*.fastclick.net"],examples:["www.tqlkg.com"],totalExecutionTime:6531550,totalOccurrences:54802},{name:"Conversant Ad Server",company:"Conversant",category:"ad",domains:["adfarm.mediaplex.com","*.mediaplex.com"]},{name:"Conversant Tag Manager",company:"Conversant",category:"\
tag-manager",domains:["*.mplxtms.com"],totalExecutionTime:14146,totalOccurrences:58},{name:"Conversio",category:"ad",domains:["*.conversio.com"]},{name:"Conversion Labs",category:"ad",domains:["*.net.pl"],examples:["conversionlabs.net.pl"],totalExecutionTime:3243395,totalOccurrences:1898},{name:"Conversion Logic",category:"ad",domains:["*.conversionlogic.net"]},{name:"Convert Insights",category:"analytics",domains:["*.convertexperiments.com"],totalExecutionTime:2575826,totalOccurrences:4385},{name:"ConvertMedia",category:"ad",domains:["*.admailtiser.com","*.basebanner.com","*.cmbestsrv.com","*.vidfuture.com","*.zorosrv.com"],examples:["www.cmbestsrv.com"]},{name:"Convertro",category:"ad",domains:["*.convertro.com"]},{name:"Conviva",category:"content",domains:["*.conviva.com"],totalExecutionTime:2955,totalOccurrences:2},{name:"Cookie Reports",category:"utility",domains:["*.cookiereports.com"],totalExecutionTime:280810,totalOccurrences:671},{name:"Cookie-Script.com",category:"utility",domains:[
"*.cookie-script.com"],totalExecutionTime:15051619,totalOccurrences:58095},{name:"CookieQ",company:"Baycloud Systems",category:"utility",domains:["*.cookieq.com"]},{name:"CoolaData",category:"analytics",domains:["*.cooladata.com"],totalExecutionTime:1165,totalOccurrences:15},{name:"CopperEgg",category:"analytics",domains:["*.copperegg.com","d2vig74li2resi.cloudfront.net"]},{name:"Council ad Network",category:"ad",domains:["*.counciladvertising.net"],totalExecutionTime:18621,totalOccurrences:94},{name:"Covert Pics",category:"content",domains:["*.covet.pics"],totalExecutionTime:4496,totalOccurrences:55},{name:"Cox Digital Solutions",category:"ad",domains:["*.afy11.net"]},{name:"Creafi Online Media",category:"ad",domains:["*.creafi-online-media.com"]},{name:"Creators",category:"content",domains:["*.creators.co"]},{name:"Crimson Hexagon Analytics",company:"Crimson Hexagon",category:"analytics",domains:["*.hexagon-analytics.com"]},{name:"Crimtan",category:"ad",domains:["*.ctnsnet.com"],totalExecutionTime:59150,
totalOccurrences:74818},{name:"Cross Pixel Media",category:"ad",domains:["*.crsspxl.com"],totalExecutionTime:493,totalOccurrences:8},{name:"Crosswise",category:"ad",domains:["*.univide.com"],examples:["p.univide.com"]},{name:"Crowd Control",company:"Lotame",category:"ad",domains:["*.crwdcntrl.net"],totalExecutionTime:16298725,totalOccurrences:101196},{name:"Crowd Ignite",category:"ad",domains:["*.crowdignite.com"]},{name:"CrowdTwist",category:"ad",domains:["*.crowdtwist.com"]},{name:"Crowdskout",category:"ad",domains:["*.crowdskout.com"]},{name:"Crowdynews",category:"social",domains:["*.breakingburner.com"]},{name:"Curalate",category:"marketing",domains:["*.curalate.com","d116tqlcqfmz3v.cloudfront.net"],totalExecutionTime:628884,totalOccurrences:683},{name:"Customer Acquisition Cloud",company:"[24]7",category:"ad",domains:["*.campanja.com"]},{name:"Customer.io",category:"ad",domains:["*.customer.io"],totalExecutionTime:210609,totalOccurrences:1268},{name:"Custora",category:"analytics",
domains:["*.custora.com"]},{name:"Cxense",category:"ad",domains:["*.cxense.com","*.cxpublic.com","*.emediate.dk","*.emediate.eu"],totalExecutionTime:2218364,totalOccurrences:3708},{name:"CyberKnight",company:"Namogoo",category:"utility",domains:["*.namogoo.com"]},{name:"CyberSource (Visa)",category:"utility",domains:["*.authorize.net"],totalExecutionTime:339030,totalOccurrences:2682},{name:"Cybernet Quest",category:"analytics",domains:["*.cqcounter.com"]},{name:"D.A. Consortium",category:"ad",domains:["*.eff1.net"]},{name:"D4t4 Solutions",category:"analytics",domains:["*.u5e.com"]},{name:"DCSL Software",category:"hosting",domains:["*.dcslsoftware.com"]},{name:"DMG Media",category:"content",domains:["*.mol.im","*.and.co.uk","*.anm.co.uk","*.dailymail.co.uk"],totalExecutionTime:37855,totalOccurrences:15},{name:"DTSCOUT",category:"ad",domains:["*.dtscout.com"],totalExecutionTime:645362,totalOccurrences:8311},{name:"Dailykarma",category:"utility",homepage:"https://www.dailykarma.com/",domains:[
"*.dailykarma.io"],examples:["assets.dailykarma.io"],totalExecutionTime:122378,totalOccurrences:477},{name:"Dailymotion",category:"content",domains:["*.dailymotion.com","*.dmxleo.com","*.dm.gg","*.pxlad.io","*.dmcdn.net","*.sublimevideo.net"],examples:["ad.pxlad.io","www.dailymotion.com"],totalExecutionTime:56076026,totalOccurrences:5142},{name:"Dash Hudson",company:"Dash Hudson",category:"content",domains:["*.dashhudson.com"],examples:["cdn.dashhudson.com"],totalExecutionTime:154963,totalOccurrences:91},{name:"Datacamp",category:"utility",domains:["*.cdn77.org"],totalExecutionTime:3303608,totalOccurrences:1181},{name:"Datalicious",category:"tag-manager",domains:["*.supert.ag","*.optimahub.com"]},{name:"Datalogix",category:"ad",domains:["*.nexac.com"]},{name:"Datawrapper",category:"utility",domains:["*.datawrapper.de","*.dwcdn.net"],examples:["www.datawrapper.de"],totalExecutionTime:951486,totalOccurrences:249},{name:"Dataxu",category:"marketing",domains:["*.w55c.net"],totalExecutionTime:10,
totalOccurrences:5},{name:"DatoCMS",homepage:"https://www.datocms.com/",category:"content",domains:["*.datocms-assets.com"],examples:["www.datocms-assets.com"]},{name:"Datonics",category:"ad",domains:["*.pro-market.net"],examples:["pbid.pro-market.net"],totalExecutionTime:16955,totalOccurrences:254},{name:"Dealtime",category:"content",domains:["*.dealtime.com"]},{name:"Debenhams Geo Location",company:"Debenhams",category:"utility",domains:["176.74.183.134"]},{name:"Decibel Insight",category:"analytics",domains:["*.decibelinsight.net"],totalExecutionTime:995190,totalOccurrences:691},{name:"Deep Forest Media",company:"Rakuten",category:"ad",domains:["*.dpclk.com"]},{name:"DeepIntent",category:"ad",domains:["*.deepintent.com"],totalExecutionTime:3875,totalOccurrences:206},{name:"Delicious Media",category:"social",domains:["*.delicious.com"]},{name:"Delineo",category:"ad",domains:["*.delineo.com"],examples:["www.delineo.com"]},{name:"Delta Projects AB",category:"ad",domains:["*.de17a.com"],
totalExecutionTime:90548,totalOccurrences:382},{name:"Demand Media",category:"content",domains:["*.dmtracker.com"]},{name:"DemandBase",category:"marketing",domains:["*.demandbase.com"],totalExecutionTime:393206,totalOccurrences:2552},{name:"DemandJump",category:"analytics",domains:["*.demandjump.com"]},{name:"Dennis Publishing",category:"content",domains:["*.alphr.com"]},{name:"Devatics",category:"analytics",domains:["*.devatics.com","*.devatics.io"]},{name:"Developer Media",category:"ad",domains:["*.developermedia.com"],totalExecutionTime:4416,totalOccurrences:17},{name:"DialogTech",category:"ad",domains:["*.dialogtech.com"]},{name:"DialogTech SourceTrak",company:"DialogTech",category:"ad",domains:["d31y97ze264gaa.cloudfront.net"]},{name:"DigiCert",category:"utility",domains:["*.digicert.com"],examples:["ocsp.digicert.com"],totalExecutionTime:26560,totalOccurrences:83},{name:"Digioh",category:"ad",domains:["*.lightboxcdn.com"],totalExecutionTime:1347082,totalOccurrences:1303},{name:"D\
igital Look",category:"content",domains:["*.digitallook.com"]},{name:"Digital Media Exchange",company:"NDN",category:"content",domains:["*.newsinc.com"]},{name:"Digital Millennium Copyright Act Services",category:"utility",domains:["*.dmca.com"],totalExecutionTime:8820,totalOccurrences:70},{name:"Digital Ocean",category:"other",domains:["95.85.62.56"]},{name:"Digital Remedy",category:"ad",domains:["*.consumedmedia.com"]},{name:"Digital Window",category:"ad",domains:["*.awin1.com","*.zenaps.com"],totalExecutionTime:195,totalOccurrences:4},{name:"DigitalScirocco",category:"analytics",domains:["*.digitalscirocco.net"]},{name:"Digitial Point",category:"utility",domains:["*.dpstatic.com"]},{name:"Diligent (Adnetik)",category:"ad",domains:["*.wtp101.com"]},{name:"Directed Edge",category:"social",domains:["*.directededge.com"],examples:["shopify.directededge.com"],totalExecutionTime:8371,totalOccurrences:81},{name:"Distribute Travel",category:"ad",domains:["*.dtrck.net"]},{name:"District M",category:"\
ad",domains:["*.districtm.io"]},{name:"DistroScale",category:"ad",domains:["*.jsrdn.com"],totalExecutionTime:186009,totalOccurrences:198},{name:"Divido",category:"utility",domains:["*.divido.com"]},{name:"Dow Jones",category:"content",domains:["*.dowjones.com","*.dowjoneson.com"]},{name:"Drifty Co",category:"utility",domains:["*.onicframework.com"]},{name:"Drip",company:"The Numa Group",category:"ad",domains:["*.getdrip.com"],totalExecutionTime:120918,totalOccurrences:1350},{name:"Dropbox",category:"utility",domains:["*.dropboxusercontent.com"],totalExecutionTime:142552,totalOccurrences:145},{name:"Dyn Real User Monitoring",company:"Dyn",category:"analytics",domains:["*.jisusaiche.biz","*.dynapis.com","*.jisusaiche.com","*.dynapis.info"],examples:["beacon.rum.dynapis.com"]},{name:"DynAdmic",category:"ad",domains:["*.dyntrk.com"]},{name:"Dynamic Converter",category:"utility",domains:["*.dynamicconverter.com"],totalExecutionTime:58723,totalOccurrences:96},{name:"Dynamic Dummy Image Gener\
ator",company:"Open Source",category:"utility",domains:["*.dummyimage.com"]},{name:"Dynamic Logic",category:"ad",domains:["*.dl-rms.com","*.questionmarket.com"]},{name:"Dynamic Yield",category:"customer-success",domains:["*.dynamicyield.com"],totalExecutionTime:3580074,totalOccurrences:1843},{name:"Dynatrace",category:"analytics",domains:["*.ruxit.com","js-cdn.dynatrace.com"],totalExecutionTime:4106731,totalOccurrences:3221},{name:"ec-concier",homepage:"https://ec-concier.com/",category:"marketing",domains:["*.ec-concier.com"],examples:["s.ec-concier.com","gsync.ec-concier.com"]},{name:"ECT News Network",category:"content",domains:["*.ectnews.com"]},{name:"ELITechGroup",category:"analytics",domains:["*.elitechnology.com"]},{name:"EMAP",category:"content",domains:["*.emap.com"]},{name:"EMedia Solutions",category:"ad",domains:["*.e-shots.eu"],examples:["www.e-shots.eu"]},{name:"EQ works",category:"ad",domains:["*.eqads.com"]},{name:"ESV Digital",category:"analytics",domains:["*.esearchvi\
sion.com"]},{name:"Ebiquity",category:"analytics",domains:["*.ebiquitymedia.com"]},{name:"Eco Rebates",category:"ad",domains:["*.ecorebates.com"]},{name:"Ecwid",category:"hosting",domains:["*.ecwid.com","*.shopsettings.com","d3fi9i0jj23cau.cloudfront.net","d3j0zfs7paavns.cloudfront.net"],totalExecutionTime:3757012,totalOccurrences:4362},{name:"Edge Web Fonts",company:"Adobe Systems",category:"cdn",domains:["*.edgefonts.net"],examples:["use.edgefonts.net"]},{name:"Edition Digital",category:"ad",domains:["*.editiondigital.com"]},{name:"Edot Web Technologies",category:"hosting",domains:["*.edot.co.za"]},{name:"Effective Measure",category:"ad",domains:["*.effectivemeasure.net"],totalExecutionTime:17,totalOccurrences:1},{name:"Effiliation sa",category:"ad",domains:["*.effiliation.com"],totalExecutionTime:108,totalOccurrences:3},{name:"Ekm Systems",category:"analytics",domains:["*.ekmsecure.com","*.ekmpinpoint.co.uk"],examples:["globalstats.ekmsecure.com"],totalExecutionTime:67875,totalOccurrences:789},
{name:"Elastera",category:"hosting",domains:["*.elastera.net"]},{name:"Elastic Ad",category:"ad",domains:["*.elasticad.net"],totalExecutionTime:30225,totalOccurrences:137},{name:"Elastic Load Balancing",company:"Amazon Web Services",category:"hosting",domains:["*.105app.com"],examples:["rhpury.105app.com","rhxtd.105app.com"]},{name:"Elecard StreamEye",company:"Elecard",category:"other",domains:["*.streameye.net"]},{name:"Elevate",company:"Elevate Technology Solutions",category:"utility",domains:["*.elevaate.technology"]},{name:"Elicit",category:"utility",domains:["*.elicitapp.com"]},{name:"Elogia",category:"ad",domains:["*.elogia.net"]},{name:"Email Attitude",company:"1000mercis",category:"ad",domains:["*.email-attitude.com"]},{name:"EmailCenter",category:"ad",domains:["*.emailcenteruk.com"]},{name:"Embedly",category:"content",domains:["*.embedly.com","*.embed.ly"],totalExecutionTime:5014487,totalOccurrences:10836},{name:"EmpathyBroker Site Search",company:"EmpathyBroker",category:"uti\
lity",domains:["*.empathybroker.com"]},{name:"Enfusen",category:"analytics",domains:["*.enfusen.com"]},{name:"Engadget",company:"Engadget (AOL)",category:"content",domains:["*.gdgt.com"],examples:["media.gdgt.com"]},{name:"Engagio",category:"marketing",domains:["*.engagio.com"]},{name:"Ensighten Manage",company:"Ensighten",category:"tag-manager",domains:["*.levexis.com"]},{name:"EntityLink",category:"other",domains:["*.entitytag.co.uk"]},{name:"Entrust Datacard",category:"utility",domains:["*.entrust.com","*.entrust.net"],examples:["ocsp.entrust.com","ocsp.entrust.net"],totalExecutionTime:14041,totalOccurrences:3},{name:"Equiniti",category:"utility",domains:["*.equiniti.com"]},{name:"Errorception",category:"utility",domains:["*.errorception.com"]},{name:"Esri ArcGIS",company:"Esri",category:"utility",domains:["*.arcgis.com","*.arcgisonline.com"],totalExecutionTime:21967746,totalOccurrences:3432},{name:"Ethnio",category:"analytics",domains:["*.ethn.io"]},{name:"Eulerian Technologies",category:"\
ad",domains:["*.eolcdn.com"]},{name:"Euroland",category:"utility",domains:["*.euroland.com"],totalExecutionTime:1,totalOccurrences:3},{name:"European Interactive Digital ad Alli",category:"utility",domains:["*.edaa.eu"]},{name:"Eventbrite",category:"hosting",domains:["*.evbuc.com","*.eventbrite.co.uk"],totalExecutionTime:4667,totalOccurrences:33},{name:"Everflow",category:"analytics",domains:["*.tp88trk.com"],examples:["www.tp88trk.com"],totalExecutionTime:110842,totalOccurrences:185},{name:"Evergage",category:"analytics",domains:["*.evergage.com","*.evgnet.com"],examples:["cdn.evgnet.com"],totalExecutionTime:1095634,totalOccurrences:2491},{name:"Everquote",category:"content",domains:["*.evq1.com"]},{name:"Everyday Health",category:"ad",domains:["*.agoramedia.com"]},{name:"Evidon",category:"analytics",domains:["*.evidon.com"],totalExecutionTime:1260409,totalOccurrences:2482},{name:"Evolve Media",category:"content",domains:["*.evolvemediallc.com"]},{name:"Exactag",category:"ad",domains:[
"*.exactag.com"],totalExecutionTime:662,totalOccurrences:6},{name:"ExoClick",category:"ad",domains:["*.exoclick.com"],totalExecutionTime:69348,totalOccurrences:568},{name:"Expedia",category:"content",domains:["*.travel-assets.com","*.trvl-media.com","*.trvl-px.com","*.uciservice.com"],examples:["www.trvl-px.com","www.uciservice.com"],totalExecutionTime:15443,totalOccurrences:15},{name:"Expedia Australia",company:"Expedia",category:"content",domains:["*.expedia.com.au"],examples:["www.expedia.com.au"]},{name:"Expedia Canada",company:"Expedia",category:"content",domains:["*.expedia.ca"],examples:["www.expedia.ca"]},{name:"Expedia France",company:"Expedia",category:"content",domains:["*.expedia.fr"],examples:["www.expedia.fr"]},{name:"Expedia Germany",company:"Expedia",category:"content",domains:["*.expedia.de"],examples:["www.expedia.de"]},{name:"Expedia Italy",company:"Expedia",category:"content",domains:["*.expedia.it"],examples:["www.expedia.it"]},{name:"Expedia Japan",company:"Expedi\
a",category:"content",domains:["*.expedia.co.jp"],examples:["www.expedia.co.jp"]},{name:"Expedia USA",company:"Expedia",category:"content",domains:["*.expedia.com"],examples:["www.expedia.com"],totalExecutionTime:40062,totalOccurrences:19},{name:"Expedia United Kingdom",company:"Expedia",category:"content",domains:["*.expedia.co.uk"],examples:["www.expedia.co.uk"]},{name:"Experian",category:"utility",domains:["*.audienceiq.com","*.experian.com","*.experianmarketingservices.digital"]},{name:"Experian Cross-Channel Marketing Platform",company:"Experian",category:"marketing",domains:["*.eccmp.com","*.ccmp.eu"],totalExecutionTime:1268,totalOccurrences:24},{name:"Exponea",category:"analytics",domains:["*.exponea.com"],totalExecutionTime:154832,totalOccurrences:1303},{name:"Exponential Interactive",category:"ad",domains:["*.exponential.com"],totalExecutionTime:5179,totalOccurrences:120},{name:"Extensis WebInk",category:"cdn",domains:["*.webink.com"]},{name:"Extole",category:"ad",domains:["*.\
extole.com","*.extole.io"],examples:["origin.extole.io"],totalExecutionTime:21067,totalOccurrences:44},{name:"Ey-Seren",category:"analytics",domains:["*.webabacus.com"]},{name:"EyeView",category:"ad",domains:["*.eyeviewads.com"]},{name:"Eyeota",category:"ad",domains:["*.eyeota.net"],totalExecutionTime:152570,totalOccurrences:1827},{name:"Ezakus Pretargeting",company:"Ezakus",category:"ad",domains:["*.ezakus.net"]},{name:"Ezoic",category:"analytics",domains:["*.ezoic.net"],totalExecutionTime:93024,totalOccurrences:173},{name:"FLXone",company:"Teradata",category:"ad",domains:["*.pangolin.blue","*.flx1.com","d2hlpp31teaww3.cloudfront.net","*.flxpxl.com"],totalExecutionTime:25037,totalOccurrences:67},{name:"Fairfax Media",category:"content",domains:["ads.fairfax.com.au","resources.fairfax.com.au"]},{name:"Fairfax Media Analtics",company:"Fairfax Media",category:"analytics",domains:["analytics.fairfax.com.au"]},{name:"Falk Technologies",category:"ad",domains:["*.angsrvr.com"]},{name:"Fanpla\
yr",category:"analytics",domains:["*.fanplayr.com","d38nbbai6u794i.cloudfront.net"],totalExecutionTime:69669,totalOccurrences:154},{name:"Fast Thinking",company:"NE Marketing",category:"marketing",domains:["*.fast-thinking.co.uk"]},{name:"Fastest Forward",category:"analytics",domains:["*.gaug.es"],totalExecutionTime:13583,totalOccurrences:261},{name:"Fastly",category:"utility",domains:["*.fastly.net"],totalExecutionTime:21362072,totalOccurrences:9582},{name:"Feedbackify",company:"InsideMetrics",category:"analytics",domains:["*.feedbackify.com"],totalExecutionTime:42808,totalOccurrences:173},{name:"Feefo.com",company:"Feefo",category:"analytics",domains:["*.feefo.com"],totalExecutionTime:1362284,totalOccurrences:2025},{name:"Fidelity Media",category:"ad",domains:["*.fidelity-media.com"],examples:["x.fidelity-media.com"]},{name:"Filestack",category:"content",domains:["*.filepicker.io"],examples:["api.filepicker.io","dialog.filepicker.io","www.filepicker.io"],totalExecutionTime:27297,totalOccurrences:200},
{name:"Finsbury Media",category:"ad",domains:["*.finsburymedia.com"],totalExecutionTime:3470,totalOccurrences:12},{name:"Firepush",category:"utility",domains:["*.firepush.io"]},{name:"FirstImpression",category:"ad",domains:["*.firstimpression.io"],totalExecutionTime:141056,totalOccurrences:107},{name:"Fit Analytics",category:"other",domains:["*.fitanalytics.com"],examples:["integrations.fitanalytics.com","widget.fitanalytics.com","metrics.fitanalytics.com"]},{name:"Fits Me",category:"analytics",domains:["*.fits.me"]},{name:"Fivetran",category:"analytics",domains:["*.fivetran.com"],totalExecutionTime:2922,totalOccurrences:3},{name:"FlexShopper",category:"utility",domains:["*.flexshopper.com"]},{name:"Flickr",category:"content",domains:["*.flickr.com","*.staticflickr.com"],totalExecutionTime:262262,totalOccurrences:524},{name:"Flipboard",category:"social",domains:["*.flipboard.com"],totalExecutionTime:50049,totalOccurrences:41},{name:"Flipdesk",category:"customer-success",homepage:"https\
://flipdesk.jp/",domains:["*.flipdesk.jp"],examples:["api.flipdesk.jp"],totalExecutionTime:322297,totalOccurrences:411},{name:"Flipp",category:"analytics",domains:["*.wishabi.com","d2e0sxz09bo7k2.cloudfront.net","*.wishabi.net"]},{name:"Flite",category:"ad",domains:["*.flite.com"]},{name:"Flixmedia",category:"analytics",domains:["*.flix360.com","*.flixcar.com","*.flixfacts.com","*.flixsyndication.net","*.flixfacts.co.uk"],totalExecutionTime:32827,totalOccurrences:19},{name:"Flockler",category:"ad",domains:["*.flockler.com"],totalExecutionTime:504051,totalOccurrences:1297},{name:"Flowplayer",category:"content",domains:["*.flowplayer.org"],totalExecutionTime:218859,totalOccurrences:862},{name:"Flowzymes Ky",category:"cdn",domains:["*.jquerytools.org"]},{name:"Fomo",category:"ad",domains:["*.notifyapp.io"]},{name:"Fonecall",category:"analytics",domains:["*.web-call-analytics.com"]},{name:"Fontdeck",category:"cdn",domains:["*.fontdeck.com"]},{name:"Foodity Technologies",category:"ad",domains:[
"*.foodity.com"]},{name:"Force24",category:"ad",domains:["*.force24.co.uk"],totalExecutionTime:10225,totalOccurrences:112},{name:"ForeSee",company:"Answers",category:"analytics",domains:["*.4seeresults.com","*.answerscloud.com","*.foresee.com","*.foreseeresults.com"],totalExecutionTime:179704,totalOccurrences:266},{name:"Forensiq",category:"utility",domains:["*.fqtag.com"],totalExecutionTime:21937,totalOccurrences:171},{name:"Fort Awesome",category:"cdn",domains:["*.fortawesome.com"],totalExecutionTime:652365,totalOccurrences:3635},{name:"Forter",category:"utility",domains:["*.forter.com"],totalExecutionTime:6578955,totalOccurrences:6930},{name:"Forward Internet Group",category:"hosting",domains:["*.f3d.io"]},{name:"Forward3D",category:"ad",domains:["*.forward3d.com"]},{name:"Fospha",category:"analytics",domains:["*.fospha.com"],examples:["router.fospha.com"]},{name:"Foursixty",category:"customer-success",domains:["*.foursixty.com"]},{name:"FoxyCart",category:"utility",domains:["*.foxy\
cart.com"],totalExecutionTime:361777,totalOccurrences:669},{name:"Fraudlogix",category:"utility",domains:["*.yabidos.com"],totalExecutionTime:47637,totalOccurrences:357},{name:"FreakOut",category:"ad",domains:["*.fout.jp"],totalExecutionTime:114328,totalOccurrences:2036},{name:"Freespee",category:"customer-success",domains:["*.freespee.com"],examples:["analytics.freespee.com"],totalExecutionTime:67626,totalOccurrences:484},{name:"Freetobook",category:"content",domains:["*.freetobook.com"],examples:["www.freetobook.com"],totalExecutionTime:297146,totalOccurrences:649},{name:"Fresh 8 Gaming",category:"ad",domains:["*.fresh8.co"],totalExecutionTime:319849,totalOccurrences:76},{name:"Fresh Relevance",category:"analytics",domains:["*.freshrelevance.com","*.cloudfront.ne","d1y9qtn9cuc3xw.cloudfront.net","d81mfvml8p5ml.cloudfront.net","dkpklk99llpj0.cloudfront.net"],examples:["d1y9qtn9cuc3xw.cloudfront.ne"],totalExecutionTime:91181,totalOccurrences:300},{name:"Friendbuy",category:"ad",domains:[
"*.friendbuy.com","djnf6e5yyirys.cloudfront.net"],totalExecutionTime:17783,totalOccurrences:150},{name:"Frienefit",category:"ad",domains:["*.frienefit.com"]},{name:"FuelX",category:"ad",domains:["*.fuelx.com"]},{name:"Full Circle Studies",category:"analytics",domains:["*.securestudies.com"]},{name:"FullStory",category:"analytics",domains:["*.fullstory.com"],examples:["rs.fullstory.com"],totalExecutionTime:11575233,totalOccurrences:14687},{name:"Fyber",category:"ad",domains:["*.fyber.com"]},{name:"G-Forces Web Management",category:"hosting",domains:["*.gforcesinternal.co.uk"]},{name:"G4 Native",company:"Gravity4",category:"ad",domains:["*.triggit.com"]},{name:"GET ME IN!  (TicketMaster)",category:"content",domains:["*.getmein.com"]},{name:"GIPHY",category:"content",domains:["*.giphy.com"],totalExecutionTime:4831,totalOccurrences:6},{name:"GainCloud",company:"GainCloud Systems",category:"other",domains:["*.egaincloud.net"]},{name:"Gath Adams",category:"content",domains:["*.iwantthatfligh\
t.com.au"]},{name:"Gecko Tribe",category:"social",domains:["*.geckotribe.com"]},{name:"Gemius",category:"ad",domains:["*.gemius.pl"],totalExecutionTime:2964756,totalOccurrences:15596},{name:"Genesis Media",category:"ad",domains:["*.bzgint.com","*.genesismedia.com","*.genesismediaus.com"]},{name:"Genie Ventures",category:"ad",domains:["*.genieventures.co.uk"]},{name:"Geniee",category:"ad",domains:["*.href.asia","*.genieessp.jp","*.genieesspv.jp","*.gssprt.jp"],examples:["cs.gssprt.jp"],totalExecutionTime:16956055,totalOccurrences:16354},{name:"Geniuslink",category:"analytics",domains:["*.geni.us"],totalExecutionTime:897,totalOccurrences:3},{name:"GeoRiot",category:"other",domains:["*.georiot.com"]},{name:"GeoTrust",category:"utility",domains:["*.geotrust.com"],totalExecutionTime:3300,totalOccurrences:2},{name:"Geoplugin",category:"utility",domains:["*.geoplugin.com","*.geoplugin.net"],totalExecutionTime:119,totalOccurrences:3},{name:"Georeferencer",company:"Klokan Technologies",category:"\
utility",domains:["*.georeferencer.com"]},{name:"GetIntent RTBSuite",company:"GetIntent",category:"ad",domains:["*.adhigh.net"],totalExecutionTime:2768,totalOccurrences:356},{name:"GetResponse",category:"ad",domains:["*.getresponse.com"],totalExecutionTime:209076,totalOccurrences:1019},{name:"GetSiteControl",company:"GetWebCraft",category:"utility",domains:["*.getsitecontrol.com"],totalExecutionTime:1739288,totalOccurrences:3146},{name:"GetSocial",category:"social",domains:["*.getsocial.io"],totalExecutionTime:1204,totalOccurrences:11},{name:"Getty Images",category:"content",domains:["*.gettyimages.com","*.gettyimages.co.uk"],examples:["www.gettyimages.com"],totalExecutionTime:17939,totalOccurrences:65},{name:"Gfycat",company:"Gycat",category:"utility",domains:["*.gfycat.com"]},{name:"Ghostery Enterprise",company:"Ghostery",category:"marketing",domains:["*.betrad.com"],totalExecutionTime:1129,totalOccurrences:26},{name:"Giant Media",category:"ad",domains:["*.videostat.com"]},{name:"Gig\
ya",category:"analytics",domains:["*.gigya.com"],totalExecutionTime:2692493,totalOccurrences:1995},{name:"GitHub",category:"utility",domains:["*.github.com","*.githubusercontent.com","*.github.io","*.rawgit.com"],examples:["raw.githubusercontent.com","cdn.rawgit.com"],totalExecutionTime:7126491,totalOccurrences:14675},{name:"Gladly",company:"Gladly",homepage:"https://www.gladly.com/",category:"customer-success",domains:["*.gladly.com"],examples:["cdn.gladly.com"],totalExecutionTime:240417,totalOccurrences:381},{name:"Glassdoor",category:"content",domains:["*.glassdoor.com"],totalExecutionTime:68877,totalOccurrences:19},{name:"Gleam",category:"marketing",domains:["*.gleam.io"],totalExecutionTime:43249,totalOccurrences:221},{name:"Global Digital Markets",category:"ad",domains:["*.gdmdigital.com"]},{name:"Global-e",category:"hosting",domains:["*.global-e.com"],totalExecutionTime:706185,totalOccurrences:1314},{name:"GlobalSign",category:"utility",domains:["*.globalsign.com","*.globalsign.n\
et"],totalExecutionTime:11228,totalOccurrences:48},{name:"GlobalWebIndex",category:"analytics",domains:["*.globalwebindex.net"]},{name:"Globase International",category:"ad",domains:["*.globase.com"]},{name:"GoDataFeed",category:"other",domains:["*.godatafeed.com"]},{name:"Google APIs",company:"Google",category:"utility",domains:["googleapis.com"]},{name:"Google Ad Block Detection",company:"Google",category:"ad",domains:["*.0emn.com","*.0fmm.com"]},{name:"Google Analytics Experiments",company:"Google",category:"analytics",domains:["*.gexperiments1.com"]},{name:"Google DoubleClick Ad Exchange",company:"Google",category:"ad",domains:["*.admeld.com"]},{name:"Google IPV6 Metrics",company:"Google",category:"analytics",domains:["*.ipv6test.net"]},{name:"Google Plus",company:"Google",category:"social",domains:["plus.google.com"],totalExecutionTime:49945,totalOccurrences:442},{name:"Google Trusted Stores",company:"Google",category:"utility",domains:["*.googlecommerce.com"],totalExecutionTime:218,
totalOccurrences:5},{name:"Google Video",company:"Google",category:"content",domains:["*.googlevideo.com"],totalExecutionTime:4,totalOccurrences:3},{name:"Google reCAPTCHA",company:"Google",category:"utility",domains:["*.recaptcha.net"],examples:["api.recaptcha.net"],totalExecutionTime:8694396,totalOccurrences:25662},{name:"GovMetric",company:"ROL Solutions",category:"analytics",domains:["*.govmetric.com"],totalExecutionTime:233,totalOccurrences:6},{name:"Granify",category:"analytics",domains:["*.granify.com"],totalExecutionTime:19211,totalOccurrences:24},{name:"Grapeshot",category:"ad",domains:["*.gscontxt.net","*.grapeshot.co.uk"],totalExecutionTime:4945,totalOccurrences:4},{name:"Gravity (AOL)",category:"analytics",domains:["*.grvcdn.com"]},{name:"Groovy Gecko",category:"content",domains:["*.ggwebcast.com","*.groovygecko.net"]},{name:"GroupM",category:"ad",domains:["*.qservz.com"]},{name:"Guardian Media",category:"ad",domains:["*.theguardian.com","*.guardian.co.uk"],examples:["oas.t\
heguardian.com"]},{name:"GumGum",category:"ad",domains:["*.gumgum.com"],totalExecutionTime:3440651,totalOccurrences:167535},{name:"Gumtree",category:"content",domains:["*.gumtree.com"]},{name:"H264 Codec",company:"Cisco",category:"other",domains:["*.openh264.org"]},{name:"HERE",category:"analytics",domains:["*.medio.com"]},{name:"HP Optimost",company:"Hewlett-Packard Development Company",category:"marketing",domains:["*.hp.com","d2uncb19xzxhzx.cloudfront.net"],examples:["by.marketinghub.hp.com","marketinghub.hp.com"],totalExecutionTime:420577,totalOccurrences:100},{name:"Has Offers",company:"TUNE",category:"ad",domains:["*.go2cloud.org"],totalExecutionTime:0,totalOccurrences:3},{name:"Hawk Search",category:"utility",domains:["*.hawksearch.com"],totalExecutionTime:15097,totalOccurrences:132},{name:"Haymarket Media Group",category:"content",domains:["*.brandrepublic.com","*.hbpl.co.uk"]},{name:"Heap",category:"analytics",domains:["*.heapanalytics.com"],totalExecutionTime:5187800,totalOccurrences:12078},
{name:"Hearst Communications",category:"content",domains:["*.h-cdn.co","*.hearstdigital.com","*.hearstlabs.com","*.hearst.io","*.cdnds.net"]},{name:"Heatmap",category:"analytics",domains:["*.heatmap.it"],totalExecutionTime:7337,totalOccurrences:141},{name:"Heroku",category:"other",domains:["*.herokuapp.com"],totalExecutionTime:12602535,totalOccurrences:14119},{name:"Hexton",category:"utility",domains:["*.hextom.com"],totalExecutionTime:10806589,totalOccurrences:24738},{name:"Hibernia Networks",category:"utility",domains:["*.hiberniacdn.com"]},{name:"High Impact Media",category:"ad",domains:["*.reactx.com"]},{name:"Highcharts",category:"utility",domains:["*.highcharts.com"],totalExecutionTime:746540,totalOccurrences:3181},{name:"Highwinds",category:"utility",domains:["*.hwcdn.net"]},{name:"HitsLink",category:"analytics",domains:["*.hitslink.com"],totalExecutionTime:1452,totalOccurrences:29},{name:"Hola Networks",category:"other",domains:["*.h-cdn.com"],totalExecutionTime:83024,totalOccurrences:42},
{name:"Hootsuite",category:"analytics",domains:["*.hootsuite.com"]},{name:"HotUKDeals",category:"analytics",domains:["*.hotukdeals.com"]},{name:"HotWords",company:"Media Response Group",category:"ad",domains:["*.hotwords.com.br"]},{name:"HotelsCombined",category:"content",domains:["*.datahc.com"],totalExecutionTime:81,totalOccurrences:2},{name:"Hoverr",category:"ad",domains:["*.hoverr.media"]},{name:"Hull.js",category:"utility",domains:["*.hull.io","*.hullapp.io"]},{name:"Hupso Website Analyzer",company:"Hupso",category:"analytics",domains:["*.hupso.com"],totalExecutionTime:20892,totalOccurrences:248},{name:"I-Behavior",company:"WPP",category:"ad",domains:["*.ib-ibi.com"],totalExecutionTime:23,totalOccurrences:35},{name:"i-mobile",company:"i-mobile",category:"ad",domains:["*.i-mobile.co.jp"],examples:["ssp-sync.i-mobile.co.jp"],totalExecutionTime:3701005,totalOccurrences:16595},{name:"IBM Digital Analytics",company:"IBM",category:"analytics",domains:["*.cmcore.com","coremetrics.com","d\
ata.coremetrics.com","data.de.coremetrics.com","libs.de.coremetrics.com","tmscdn.de.coremetrics.com","iocdn.coremetrics.com","libs.coremetrics.com","tmscdn.coremetrics.com","*.s81c.com","*.unica.com","*.coremetrics.eu"],examples:["data.coremetrics.eu"],totalExecutionTime:126790,totalOccurrences:169},{name:"IBM Digital Data Exchange",company:"IBM",category:"tag-manager",domains:["tagmanager.coremetrics.com"]},{name:"IBM Tealeaf",company:"IBM",category:"analytics",domains:["*.ibmcloud.com"],examples:["uscollector.tealeaf.ibmcloud.com"]},{name:"IBM Acoustic Campaign",company:"IBM",category:"analytics",domains:["www.sc.pages01.net","www.sc.pages02.net","www.sc.pages03.net","www.sc.pages04.net","www.sc.pages05.net","www.sc.pages06.net","www.sc.pages07.net","www.sc.pages08.net","www.sc.pages09.net","www.sc.pagesA.net"],examples:["https://www.sc.pages01.net/lp/static/js/iMAWebCookie.js"],totalExecutionTime:51361,totalOccurrences:417},{name:"ICF Technology",category:"content",domains:["*.camad\
s.net"]},{name:"IFDNRG",category:"hosting",domains:["*.ifdnrg.com"]},{name:"IMRG",category:"analytics",domains:["*.peermap.com","*.imrg.org"],examples:["benchmarking.imrg.org"]},{name:"IPONWEB",category:"ad",domains:["*.company-target.com","*.liadm.com","*.iponweb.net","*.p161.net"],examples:["pool.udsp.iponweb.net"],totalExecutionTime:8924906,totalOccurrences:39154},{name:"IQ Mobile",category:"utility",domains:["*.iqm.cc"]},{name:"IS Group",category:"hosting",domains:["*.creative-serving.com"],totalExecutionTime:2127,totalOccurrences:29},{name:"IT Dienstleistungen Tim Prinzkosky",category:"utility",domains:["*.flaticons.net"]},{name:"IXI Digital",company:"Equifax",category:"ad",domains:["*.ixiaa.com"]},{name:"IcoMoon",category:"cdn",domains:["d19ayerf5ehaab.cloudfront.net","d1azc1qln24ryf.cloudfront.net"],totalExecutionTime:54286,totalOccurrences:180},{name:"IdenTrust",category:"utility",domains:["*.identrust.com"],totalExecutionTime:2334,totalOccurrences:1},{name:"Ido",category:"cust\
omer-success",domains:["*.idio.co"],totalExecutionTime:2222,totalOccurrences:12},{name:"Ignition One",category:"marketing",domains:["*.searchignite.com"]},{name:"ImageShack",category:"content",domains:["*.yfrog.com"]},{name:"Imagen Studio",category:"utility",domains:["*.telephonesky.com"]},{name:"Imagini Holdings",category:"ad",domains:["*.vdna-assets.com"]},{name:"Img Safe",category:"content",domains:["*.imgsafe.org"]},{name:"Imgur",category:"utility",domains:["*.imgur.com"],totalExecutionTime:3538,totalOccurrences:30},{name:"Impact Radius",category:"ad",domains:["*.impactradius-event.com","*.impactradius-go.com","*.7eer.net","d3cxv97fi8q177.cloudfront.net","*.evyy.net","*.ojrq.net","utt.impactcdn.com","*.sjv.io"],examples:["a.impactradius-go.com","microsoft-uk.evyy.net"],totalExecutionTime:612310,totalOccurrences:4274},{name:"Improve Digital",category:"ad",domains:["*.360yield.com"],totalExecutionTime:28784,totalOccurrences:732},{name:"Improvely",category:"analytics",domains:["*.iljm\
p.com"],totalExecutionTime:129,totalOccurrences:3},{name:"InMobi",category:"ad",domains:["*.inmobi.com"],totalExecutionTime:24607375,totalOccurrences:126087},{name:"InSkin Media",category:"ad",domains:["*.inskinad.com","*.inskinmedia.com"]},{name:"Inbenta",category:"customer-success",domains:["*.inbenta.com"],totalExecutionTime:3923,totalOccurrences:7},{name:"Incisive Media",category:"content",domains:["*.incisivemedia.com"]},{name:"Indeed",category:"content",domains:["*.indeed.com"],totalExecutionTime:81347,totalOccurrences:55},{name:"Index Exchange",company:"WPP",category:"ad",domains:["*.casalemedia.com","*.indexww.com"],totalExecutionTime:892351,totalOccurrences:32324},{name:"Indoona",category:"other",domains:["*.indoona.com"]},{name:"Infectious Media",category:"ad",domains:["*.impdesk.com","*.impressiondesk.com","*.inmz.net"]},{name:"Inference Mobile",category:"ad",domains:["*.inferencemobile.com"]},{name:"Infinity Tracking",category:"analytics",domains:["*.infinity-tracking.net"],
totalExecutionTime:24308,totalOccurrences:250},{name:"Infoline",category:"analytics",domains:["*.ioam.de"],totalExecutionTime:8983,totalOccurrences:95},{name:"Infolinks",category:"ad",domains:["*.infolinks.com"],totalExecutionTime:7995389,totalOccurrences:5950},{name:"Infopark",category:"hosting",domains:["*.scrvt.com"]},{name:"Infusionsoft",category:"ad",domains:["*.infusionsoft.com"],totalExecutionTime:345182,totalOccurrences:723},{name:"Ink",category:"ad",domains:["*.inktad.com"]},{name:"Inktel Contact Center Solutions",company:"Inktel",category:"customer-success",domains:["*.inktel.com"]},{name:"Inneractive",category:"ad",domains:["*.inner-active.mobi"]},{name:"Innovid",category:"ad",homepage:"https://www.innovid.com/",domains:["*.innovid.com"],examples:["ag.innovid.com","rtr.innovid.com"],totalExecutionTime:115267,totalOccurrences:1363},{name:"Insight Express",category:"analytics",domains:["*.insightexpressai.com"],totalExecutionTime:1,totalOccurrences:2},{name:"Insipio",category:"\
other",domains:["*.insipio.com"]},{name:"Inspectlet",category:"analytics",domains:["*.inspectlet.com"],totalExecutionTime:7622183,totalOccurrences:5346},{name:"Instansive",category:"utility",domains:["*.instansive.com"]},{name:"Instart",homepage:"https://www.instart.com/",category:"utility",domains:["*.insnw.net"]},{name:"Instembedder",category:"content",domains:["*.instaembedder.com"]},{name:"Instinctive",category:"ad",domains:["*.instinctiveads.com"]},{name:"Intelligent Reach",category:"ad",domains:["*.ist-track.com"]},{name:"Intent HQ",category:"analytics",domains:["*.intenthq.com"]},{name:"Intent IQ",category:"ad",domains:["*.intentiq.com"],totalExecutionTime:48447,totalOccurrences:1146},{name:"Intercept Interactive",category:"ad",domains:["*.undertone.com"],totalExecutionTime:2293921,totalOccurrences:21012},{name:"Interest Graph",company:"AOL",category:"ad",domains:["*.gravity.com"]},{name:"Internet Brands",category:"content",domains:["*.ibpxl.com"]},{name:"Interpublic Group",category:"\
ad",domains:["*.mbww.com"]},{name:"Interstate",category:"analytics",domains:["*.interstateanalytics.com"]},{name:"Interview",category:"analytics",domains:["*.efm.me"]},{name:"Intilery",category:"customer-success",domains:["*.intilery-analytics.com"]},{name:"Investis",category:"utility",domains:["*.investis.com"],totalExecutionTime:244162,totalOccurrences:282},{name:"Investis Flife",category:"hosting",domains:["*.quartalflife.com"]},{name:"Invodo",category:"ad",domains:["*.invodo.com"],examples:["e.invodo.com"]},{name:"iSite",category:"analytics",domains:["*.isitetv.com"],examples:["static.isitetv.com","events.isitetv.com"]},{name:"Issue",category:"content",domains:["*.issue.by"]},{name:"J.D. Williams & Co",category:"content",domains:["*.drct2u.com"]},{name:"Janrain",category:"analytics",domains:["*.janrain.com","*.janrainbackplane.com","*.rpxnow.com","d3hmp0045zy3cs.cloudfront.net"],totalExecutionTime:4006,totalOccurrences:21},{name:"Jellyfish",category:"ad",domains:["*.jellyfish.net"]},
{name:"JetStream",category:"content",domains:["*.xlcdn.com"]},{name:"JingDong",category:"content",domains:["*.3.com","*.jd.com"],totalExecutionTime:119043,totalOccurrences:84},{name:"Jivox",category:"ad",domains:["*.jivox.com"],totalExecutionTime:31166,totalOccurrences:65},{name:"Jobvite",category:"content",domains:["*.jobvite.com"],totalExecutionTime:6667,totalOccurrences:4},{name:"Johnston Press",category:"content",domains:["*.johnstonpress.co.uk","*.jpress.co.uk"]},{name:"Join the Dots (Research)",category:"social",domains:["*.jtdiscuss.com"]},{name:"JotForm",category:"utility",domains:["*.jotformpro.com"]},{name:"JuicyAds",category:"ad",domains:["*.juicyads.com"],totalExecutionTime:543292,totalOccurrences:2092},{name:"JustPremium",category:"ad",domains:["*.net.net"],examples:["d2nvliyzbo36lk.cloudfrontd2nvliyzbo36lk.cloudfront.net.net"]},{name:"JustPremium Ads",company:"JustPremium",category:"ad",domains:["*.justpremium.com"],totalExecutionTime:1061,totalOccurrences:35},{name:"Just\
Uno",category:"ad",domains:["*.justuno.com","d2j3qa5nc37287.cloudfront.net"],totalExecutionTime:773949,totalOccurrences:1448},{name:"KINX (Korea Internet Neutral eXchange)",category:"other",domains:["*.kinxcdn.com"],totalExecutionTime:1433,totalOccurrences:4},{name:"KISSmetrics",category:"analytics",domains:["*.kissmetrics.com","doug1izaerwt3.cloudfront.net","dsyszv14g9ymi.cloudfront.net"],totalExecutionTime:3896,totalOccurrences:46},{name:"Kaizen Platform",category:"analytics",domains:["*.kaizenplatform.net"],examples:["cdn.kaizenplatform.net","log-v4.kaizenplatform.net"],totalExecutionTime:85284,totalOccurrences:183},{name:"Kakao",category:"social",domains:["*.daum.net","*.daumcdn.net"],totalExecutionTime:38351047,totalOccurrences:62730},{name:"Kaltura Video Platform",company:"Kaltura",category:"content",domains:["*.kaltura.com"],examples:["cdnsecakmi.kaltura.com"],totalExecutionTime:2164237,totalOccurrences:1017},{name:"Kameleoon",homepage:"https://www.kameleoon.com/",category:"anal\
ytics",domains:["*.kameleoon.com","*.kameleoon.eu","*.kameleoon.io"],examples:["data.kameleoon.io","kdm3fpv6il.kameleoon.eu"],totalExecutionTime:2217218,totalOccurrences:2337},{name:"Kampyle",category:"analytics",domains:["*.kampyle.com"],totalExecutionTime:413304,totalOccurrences:702},{name:"Kantar",category:"analytics",domains:["*.sesamestats.com"]},{name:"Kargo",category:"marketing",domains:["*.kargo.com"],totalExecutionTime:48285,totalOccurrences:1135},{name:"KARTE",company:"Plaid",homepage:"https://karte.io/",category:"marketing",domains:["*.karte.io"],examples:["static.karte.io","t.karte.io"],totalExecutionTime:1712123,totalOccurrences:1729},{name:"Kauli",category:"ad",domains:["*.kau.li"]},{name:"Keen",company:"Keen",homepage:"https://keen.io/",category:"analytics",domains:["*.keen.io","d26b395fwzu5fz.cloudfront.net"],totalExecutionTime:24210,totalOccurrences:416},{name:"Kelkoo",category:"hosting",domains:["*.kelkoo.com"]},{name:"Kenshoo",category:"marketing",domains:["*.xg4ken.\
com"],totalExecutionTime:710,totalOccurrences:18},{name:"Key CDN",category:"utility",domains:["*.kxcdn.com"],totalExecutionTime:4814875,totalOccurrences:10025},{name:"Keynote",company:"Dynatrace",category:"analytics",domains:["*.keynote.com"]},{name:"Keywee",category:"ad",domains:["*.keywee.co"],totalExecutionTime:44984,totalOccurrences:259},{name:"Kiosked",category:"ad",domains:["*.kiosked.com"],totalExecutionTime:343355,totalOccurrences:173},{name:"Klarna",category:"utility",domains:["*.klarna.com"],totalExecutionTime:1374032,totalOccurrences:10759},{name:"Klaviyo",category:"ad",domains:["*.klaviyo.com"],totalExecutionTime:113130218,totalOccurrences:161289},{name:"Klevu Search",company:"Klevu",category:"utility",domains:["*.klevu.com"],totalExecutionTime:1124647,totalOccurrences:1463},{name:"Klick2Contact",category:"customer-success",domains:["*.klick2contact.com"]},{name:"Knight Lab",company:"Northwestern University",category:"utility",domains:["*.knightlab.com"],totalExecutionTime:350550,
totalOccurrences:448},{name:"Kodajo",category:"other",domains:["*.kodajo.com"]},{name:"Komoona",category:"ad",domains:["*.komoona.com"]},{name:"Korrelate",company:"JD Power",category:"analytics",domains:["*.korrelate.net"]},{name:"LKQD",category:"ad",domains:["*.lkqd.net"]},{name:"Layer0",category:"cdn",domains:["*.layer0.co"],examples:["rum.layer0.co"]},{name:"Layershift",category:"hosting",domains:["109.109.138.174"]},{name:"Lead Forensics",category:"ad",domains:["*.200summit.com","*.baw5tracker.com","*.business-path-55.com","*.bux1le001.com","*.central-core-7.com","*.direct-azr-78.com","*.explore-123.com","*.forensics1000.com","*.gldsta-02-or.com","*.green-bloc9.com","*.lansrv040.com","*.lead-123.com","*.leadforensics.com","*.mavic852.com","*.mon-com-net.com","*.peak-ip-54.com","*.snta0034.com","*.svr-prc-01.com","*.syntace-094.com","*.tghbn12.com","*.trail-web.com","*.web-01-gbl.com","*.web-cntr-07.com","*.trackdiscovery.net"],examples:["www.baw5tracker.com","www.lansrv040.com","ww\
w.mon-com-net.com","www.peak-ip-54.com","www.tghbn12.com","www.web-01-gbl.com"],totalExecutionTime:45938,totalOccurrences:307},{name:"Lead Intelligence",company:"Magnetise Solutions",category:"ad",domains:["*.leadintelligence.co.uk"]},{name:"LeadLander",category:"analytics",domains:["*.formalyzer.com","*.trackalyzer.com"]},{name:"Leaflet",category:"utility",domains:["*.leafletjs.com"],totalExecutionTime:3668,totalOccurrences:69},{name:"LeasdBoxer",company:"LeadBoxer",category:"ad",domains:["*.leadboxer.com"],totalExecutionTime:15328,totalOccurrences:118},{name:"LeaseWeb",homepage:"https://www.leaseweb.com/",category:"cdn",domains:["*.lswcdn.net","*.leasewebcdn.com"]},{name:"Leboncoin",category:"content",domains:["*.leboncoin.fr"]},{name:"Lengow",category:"hosting",domains:["*.lengow.com"]},{name:"Lessbuttons",category:"social",domains:["*.lessbuttons.com"]},{name:"Letter Press",category:"ad",domains:["*.getletterpress.com"]},{name:"Level 3 Communications",category:"utility",domains:["f\
ootprint.net"]},{name:"Level3",category:"other",domains:["secure.footprint.net"]},{name:"Lifestreet Media",category:"social",domains:["*.lfstmedia.com"]},{name:"LiftSuggest",category:"analytics",domains:["d2blwevgjs7yom.cloudfront.net"]},{name:"Ligatus",category:"ad",domains:["*.ligadx.com"]},{name:"LightStep",category:"analytics",domains:["*.lightstep.com"]},{name:"LightWidget",category:"utility",domains:["*.lightwidget.com"],totalExecutionTime:1825559,totalOccurrences:9383},{name:"Likelihood",company:"LIkeihood",category:"hosting",domains:["*.likelihood.com"],examples:["client.likelihood.com"]},{name:"LikeShop",company:"Dash Hudson",category:"content",domains:["likeshop.me"],examples:["likeshop.me"]},{name:"LINE Corporation",category:"ad",domains:["*.line-scdn.net","*.line.me"],examples:["d.line-scdn.net","tr.line.me"],totalExecutionTime:3858282,totalOccurrences:26881},{name:"Linkcious",category:"analytics",domains:["*.linkcious.com"]},{name:"Linking Mobile",category:"ad",domains:["*\
.linkingmobile.com"]},{name:"LittleData",category:"analytics",homepage:"https://www.littledata.io/",domains:["*.littledata.io"],examples:["transactions.littledata.io"],totalExecutionTime:832,totalOccurrences:1},{name:"LiveBurst",category:"ad",domains:["*.liveburst.com"]},{name:"LiveClicker",category:"ad",domains:["*.liveclicker.net"]},{name:"LiveHelpNow",category:"customer-success",domains:["*.livehelpnow.net"],totalExecutionTime:284671,totalOccurrences:819},{name:"LiveInternet",category:"analytics",domains:["*.yadro.ru"]},{name:"LiveJournal",category:"social",domains:["*.livejournal.com","*.livejournal.net"],totalExecutionTime:63532309,totalOccurrences:9109},{name:"LivePerson",category:"customer-success",homepage:"https://www.liveperson.com/",domains:["*.liveperson.com","*.look.io","*.liveperson.net","*.lpsnmedia.net"],totalExecutionTime:1930619,totalOccurrences:2544},{name:"LiveRail",company:"Facebook",category:"ad",domains:["*.liverail.com","*.lrcdn.net"],examples:["scontent.lrcdn.n\
et"]},{name:"LiveTex",category:"customer-success",domains:["*.livetex.ru"],totalExecutionTime:476954,totalOccurrences:1911},{name:"Livefyre",category:"content",domains:["*.fyre.co","*.livefyre.com"]},{name:"Living Map Company",category:"utility",domains:["*.livingmap.com"]},{name:"Local World",category:"content",domains:["*.thelocalpeople.co.uk"]},{name:"LockerDome",category:"analytics",domains:["*.lockerdome.com"],totalExecutionTime:244,totalOccurrences:3},{name:"Logentries",company:"Rapid",category:"utility",domains:["*.logentries.com"],examples:["js.logentries.com"]},{name:"Logicalis",category:"analytics",domains:["*.trovus.co.uk"]},{name:"LoginRadius",company:"LoginRadius",homepage:"https://www.loginradius.com/",category:"ad",domains:["*.loginradius.com","*.lrcontent.com"],examples:["config.lrcontent.com"],totalExecutionTime:15746,totalOccurrences:131},{name:"LongTail Ad Solutions",category:"ad",domains:["*.jwpcdn.com","*.jwplatform.com","*.jwplayer.com","*.jwpltx.com","*.jwpsrv.co\
m","*.longtailvideo.com"],totalExecutionTime:4531393,totalOccurrences:5572},{name:"Loop Commerce",category:"other",domains:["*.loopassets.net"]},{name:"Loop11",category:"analytics",domains:["*.loop11.com"],totalExecutionTime:22278,totalOccurrences:28},{name:"LoopMe",category:"ad",domains:["*.loopme.biz","*.loopme.com","*.vntsm.com","*.loopme.me"],totalExecutionTime:2112781,totalOccurrences:11752},{name:"Looper",category:"content",domains:["*.looper.com"]},{name:"Loyalty Point",category:"ad",domains:["*.loyaltypoint.pl"]},{name:"LoyaltyLion",category:"ad",domains:["*.loyaltylion.com","*.loyaltylion.net","dg1f2pfrgjxdq.cloudfront.net"],totalExecutionTime:2971522,totalOccurrences:4114},{name:"Luma Tag",category:"analytics",domains:["*.lumatag.co.uk"]},{name:"Lumesse",category:"content",domains:["*.recruitmentplatform.com"]},{name:"Luminate",category:"ad",domains:["*.luminate.com"]},{name:"Lynchpin Analytics",category:"analytics",domains:["*.lypn.net"]},{name:"Lyris",category:"ad",domains:[
"*.clicktracks.com"]},{name:"Lytics",category:"ad",domains:["*.lytics.io"],totalExecutionTime:272463,totalOccurrences:857},{name:"MEC WebTrack",company:"MEC",category:"ad",domains:["*.e-webtrack.net"]},{name:"MECLABS Institute",category:"analytics",domains:["*.meclabs.com","*.meclabsdata.com"]},{name:"MLveda",category:"utility",domains:["*.mlveda.com"],examples:["www.mlveda.com"],totalExecutionTime:109345,totalOccurrences:229},{name:"Macromill",company:"Macromill",category:"analytics",homepage:"https://group.macromill.com/",domains:["*.macromill.com"],examples:["img.macromill.com/js/us000131vfg/4000000570-56/lognos.js"],totalExecutionTime:5731,totalOccurrences:9},{name:"Macropod BugHerd",company:"Macropod",category:"utility",domains:["*.bugherd.com"],examples:["www.bugherd.com"],totalExecutionTime:512091,totalOccurrences:3523},{name:"Madison Logic",category:"marketing",domains:["*.ml314.com"],totalExecutionTime:101,totalOccurrences:3},{name:"Madmetrics",company:"Keyade",category:"analy\
tics",domains:["*.keyade.com"]},{name:"Magnetic",category:"ad",domains:["*.domdex.com","d3ezl4ajpp2zy8.cloudfront.net"]},{name:"Magnetic Platform",company:"Magnetic",category:"ad",domains:["*.magnetic.is"]},{name:"MailMunch",category:"ad",domains:["*.mailmunch.co"],totalExecutionTime:1414543,totalOccurrences:19969},{name:"MailPlus",category:"ad",domains:["*.mailplus.nl"],totalExecutionTime:83524,totalOccurrences:304},{name:"Mapbox",category:"utility",domains:["*.mapbox.com"],totalExecutionTime:13815633,totalOccurrences:19555},{name:"Maptive",category:"utility",domains:["*.maptive.com"]},{name:"Marcaria.com",category:"other",domains:["*.gooo.al"]},{name:"Marchex",category:"analytics",domains:["*.voicestar.com","*.marchex.io"],totalExecutionTime:1378181,totalOccurrences:7390},{name:"Mark and Mini",category:"ad",domains:["*.markandmini.com"],examples:["www.markandmini.com"]},{name:"Marker",category:"utility",domains:["*.marker.io"],examples:["edge.marker.io"],totalExecutionTime:2331726,totalOccurrences:1722},
{name:"Marketing Dashboards",company:"GroupM",category:"analytics",domains:["*.m-decision.com"]},{name:"Marketizator",category:"analytics",domains:["*.marketizator.com"]},{name:"Marketplace Web Service",company:"Amazon",category:"other",domains:["*.ssl-images-amazon.com"],totalExecutionTime:234709,totalOccurrences:451},{name:"Mashable",category:"social",domains:["*.mshcdn.com"]},{name:"MatchWork",category:"utility",domains:["*.matchwork.com"]},{name:"MathJax",category:"utility",domains:["*.mathjax.org"],totalExecutionTime:84751,totalOccurrences:743},{name:"Mather Economics",category:"analytics",domains:["*.matheranalytics.com"],totalExecutionTime:262501,totalOccurrences:507},{name:"MaxCDN Enterprise",company:"MaxCDN",category:"utility",domains:["*.netdna-cdn.com","*.netdna-ssl.com"]},{name:"MaxMind",category:"utility",domains:["*.maxmind.com"],totalExecutionTime:855332,totalOccurrences:831},{name:"MaxPoint Interactive",category:"ad",domains:["*.mxptint.net"],totalExecutionTime:20140,totalOccurrences:23834},
{name:"Maxsi",category:"analytics",domains:["*.evisitanalyst.com"]},{name:"Maxymiser",category:"analytics",domains:["*.maxymiser.net, maxymiser.hs.llnwd.net"]},{name:"McAffee",category:"utility",domains:["*.mcafeesecure.com","*.scanalert.com"]},{name:"Measured",category:"analytics",domains:["*.measured.com"],examples:["tag.measured.com"],homepage:"https://www.measured.com/"},{name:"Media IQ",category:"analytics",domains:["*.mediaiqdigital.com"]},{name:"Media Management Technologies",category:"ad",domains:["*.speedshiftmedia.com"],totalExecutionTime:27147,totalOccurrences:161},{name:"Media Temple",category:"hosting",domains:["*.goodlayers2.com"]},{name:"Mediabong",category:"ad",domains:["*.mediabong.net"]},{name:"Mediahawk",category:"analytics",domains:["*.mediahawk.co.uk"],totalExecutionTime:51393,totalOccurrences:239},{name:"Mediahub",category:"ad",domains:["*.hubverifyandoptimize.com","*.projectwatchtower.com"]},{name:"Mediasyndicator",category:"ad",domains:["*.creativesyndicator.com"]},
{name:"Medium",category:"content",domains:["*.medium.com"],totalExecutionTime:216923262,totalOccurrences:17027},{name:"Meetrics",category:"ad",domains:["*.de.com","*.meetrics.net","*.mxcdn.net"],examples:["research.de.com"],totalExecutionTime:102809,totalOccurrences:63},{name:"Mega",company:"Mega Information Technology",category:"other",domains:["*.mgcdn.com"]},{name:"Melt",category:"ad",domains:["*.meltdsp.com","*.mesp.com"]},{name:"Meltwater Group",category:"customer-success",domains:["*.meltwaternews.com"]},{name:"Meme",category:"ad",domains:["*.viewwonder.com"]},{name:"MentAd",category:"ad",domains:["*.mentad.com"]},{name:"Mention Me",category:"ad",domains:["*.mention-me.com"],examples:["tag.mention-me.com"],totalExecutionTime:15233,totalOccurrences:44},{name:"Merchant Equipment Store",category:"utility",domains:["*.merchantequip.com"],totalExecutionTime:268,totalOccurrences:1},{name:"Merchenta",category:"customer-success",domains:["*.merchenta.com"]},{name:"Merkle Digital Data Exc\
hange",company:"Merkle",category:"ad",domains:["*.brilig.com"]},{name:"Merkle Paid Search",company:"Merkle",category:"ad",domains:["*.rkdms.com"],totalExecutionTime:69291,totalOccurrences:407},{name:"Met Office",category:"content",domains:["*.metoffice.gov.uk"],totalExecutionTime:15029,totalOccurrences:19},{name:"Meta Broadcast",category:"social",domains:["*.metabroadcast.com"],examples:["voila.metabroadcast.com"]},{name:"Michael Associates",category:"ad",domains:["*.checktestsite.com"],examples:["www.checktestsite.com"]},{name:"Michelin",category:"content",domains:["*.viamichelin.com"],totalExecutionTime:8087,totalOccurrences:7},{name:"Microad",category:"ad",domains:["*.microad.jp"],totalExecutionTime:14626755,totalOccurrences:23909},{name:"Microsoft Certificate Services",company:"Microsoft",category:"utility",domains:["*.msocsp.com"]},{name:"Microsoft Hosted Libs",company:"Microsoft",category:"cdn",domains:["*.aspnetcdn.com"],examples:["ajax.aspnetcdn.com"],totalExecutionTime:4562478,
totalOccurrences:20042},{name:"Microsoft XBox Live",company:"Microsoft",category:"marketing",domains:["*.xboxlive.com"]},{name:"Mightypop",category:"ad",domains:["*.mightypop.ca"]},{name:"Mika Tuupola",category:"utility",domains:["*.appelsiini.net"]},{name:"Millennial Media",category:"ad",domains:["*.jumptap.com"]},{name:"Mirror Image Internet",category:"utility",domains:["*.miisolutions.net"]},{name:"Mobify",category:"utility",domains:["*.mobify.com","*.mobify.net"]},{name:"Mobile Nations",category:"social",domains:["*.mobilenations.com"]},{name:"Mobivate",category:"ad",domains:["*.mobivatebulksms.com"]},{name:"Momondo",category:"content",domains:["*.momondo.dk"]},{name:"Momondo Group",category:"content",domains:["*.momondogrouo.com","*.momondogroup.com"]},{name:"Monarch Ads",category:"ad",domains:["*.monarchads.com"]},{name:"Monetate",category:"analytics",domains:["*.monetate.net"],totalExecutionTime:260345,totalOccurrences:599},{name:"MonetizeMore",category:"ad",domains:["*.m2.ai"],
totalExecutionTime:8896,totalOccurrences:47},{name:"Monitor",company:"Econda",category:"analytics",domains:["*.econda-monitor.de"],examples:["www.econda-monitor.de"]},{name:"Monkey Frog Media",category:"content",domains:["*.monkeyfrogmedia.com"]},{name:"Monotype",category:"cdn",domains:["*.fonts.com","*.fonts.net"],totalExecutionTime:729465,totalOccurrences:3185},{name:"Moore-Wilson",category:"ad",domains:["*.mwdev.co.uk"]},{name:"Moovweb",category:"utility",domains:["*.moovweb.net"]},{name:"Mopinion",category:"analytics",domains:["*.mopinion.com"],totalExecutionTime:171681,totalOccurrences:177},{name:"MotionPoint",category:"other",domains:["*.convertlanguage.com"],totalExecutionTime:1843,totalOccurrences:35},{name:"Mouse3K",category:"analytics",domains:["*.mouse3k.com"]},{name:"MouseStats",category:"analytics",domains:["*.mousestats.com"]},{name:"Mouseflow",homepage:"https://mouseflow.com/",category:"analytics",domains:["*.mouseflow.com"],totalExecutionTime:331345,totalOccurrences:6786},
{name:"Movable Ink",category:"analytics",domains:["*.micpn.com"],totalExecutionTime:439979,totalOccurrences:4949},{name:"MovingIMAGE24",category:"content",domains:["*.edge-cdn.net"]},{name:"Moxielinks",category:"ad",domains:["*.moxielinks.com"]},{name:"Moz Recommended Companies",company:"Moz",category:"analytics",domains:["d2eeipcrcdle6.cloudfront.net"]},{name:"Mozilla",category:"utility",domains:["*.mozilla.org"],examples:["aus5.mozilla.org"],totalExecutionTime:21085,totalOccurrences:32},{name:"Multiview",category:"content",domains:["*.multiview.com","*.track-mv.com"],totalExecutionTime:8831,totalOccurrences:58},{name:"Mux",category:"analytics",domains:["*.litix.io"],totalExecutionTime:91580,totalOccurrences:249},{name:"MyAds",company:"MyBuys",category:"analytics",domains:["*.veruta.com"]},{name:"MyBuys",category:"analytics",domains:["*.mybuys.com"]},{name:"MyFonts",category:"cdn",domains:["*.myfonts.net"],totalExecutionTime:78,totalOccurrences:4},{name:"MyRegistry",category:"other",domains:[
"*.myregistry.com"],totalExecutionTime:164086,totalOccurrences:621},{name:"MySpace",company:"Specific Media",category:"social",domains:["*.myspace.com"]},{name:"Mynewsdesk",category:"utility",domains:["*.mynewsdesk.com"],totalExecutionTime:564,totalOccurrences:31},{name:"NAVIS",category:"content",domains:["*.navistechnologies.info"]},{name:"NCC Group Real User Monitoring",company:"NCC Group",category:"analytics",domains:["*.nccgroup-webperf.com"],examples:["beacon-rumlive.rum.nccgroup-webperf.com","config-rumlive.rum.nccgroup-webperf.com","script-rumlive.rum.nccgroup-webperf.com"]},{name:"NEORY Marketing Cloud",company:"NEORY",category:"marketing",domains:["*.ad-srv.net"],totalExecutionTime:10976,totalOccurrences:240},{name:"Nanigans",category:"ad",domains:["*.nanigans.com"]},{name:"Nano Interactive",category:"ad",domains:["*.audiencemanager.de"],totalExecutionTime:780,totalOccurrences:10},{name:"Nanorep",company:"Nanorep Technologies",category:"customer-success",domains:["*.nanorep.co\
m"]},{name:"Narrative",category:"ad",domains:["*.narrative.io"],totalExecutionTime:1228,totalOccurrences:2},{name:"Native Ads",category:"ad",domains:["*.nativeads.com"]},{name:"Nativo",category:"ad",domains:["*.postrelease.com"],totalExecutionTime:28260,totalOccurrences:35852},{name:"Navegg",category:"ad",domains:["*.navdmp.com"],totalExecutionTime:51915,totalOccurrences:805},{name:"NaviStone",category:"ad",domains:["*.murdoog.com"]},{name:"Naytev",category:"analytics",domains:["*.naytev.com"]},{name:"Needle",category:"analytics",domains:["*.needle.com"]},{name:"Neiman Marcus",category:"content",domains:["*.ctscdn.com"]},{name:"Nend",category:"ad",domains:["*.nend.net"]},{name:"Neodata",category:"ad",domains:["*.neodatagroup.com"],totalExecutionTime:12827,totalOccurrences:86},{name:"Net Applications",category:"analytics",domains:["*.hitsprocessor.com"]},{name:"Net Reviews",category:"analytics",domains:["*.avis-verifies.com"],examples:["www.avis-verifies.com"],totalExecutionTime:1143140,
totalOccurrences:2442},{name:"NetAffiliation",company:"Kwanco",category:"ad",domains:["*.metaffiliation.com"],totalExecutionTime:18519,totalOccurrences:127},{name:"NetDirector",company:"G-Forces Web Management",category:"other",domains:["*.netdirector.co.uk"],totalExecutionTime:3931,totalOccurrences:1},{name:"NetFlix",category:"content",domains:["*.nflxext.com","*.nflximg.net"],totalExecutionTime:4364,totalOccurrences:5},{name:"Nielsen NetRatings SiteCensus",company:"The Nielsen Company",homepage:"http://www.nielsen-online.com/intlpage.html",category:"analytics",domains:["*.imrworldwide.com"],totalExecutionTime:6840006,totalOccurrences:19525},{name:"NetSeer",category:"ad",domains:["*.netseer.com","*.ns-cdn.com"]},{name:"NetShelter",company:"Ziff Davis Tech",category:"ad",domains:["*.netshelter.net"]},{name:"Netmining",company:"Ignition One",category:"ad",domains:["*.netmng.com"],totalExecutionTime:7746,totalOccurrences:92},{name:"Netop",category:"customer-success",domains:["*.netop.com"]},
{name:"Network Solutions",category:"utility",domains:["*.netsolssl.com","*.networksolutions.com"],examples:["ocsp.netsolssl.com"],totalExecutionTime:2415,totalOccurrences:2},{name:"Neustar AdAdvisor",company:"Neustar",category:"ad",domains:["*.adadvisor.net"]},{name:"New Approach Media",category:"ad",domains:["*.newapproachmedia.co.uk"]},{name:"NewShareCounts",category:"social",domains:["*.newsharecounts.com"]},{name:"News",category:"social",domains:["*.news.com.au","*.newsanalytics.com.au","*.newsapi.com.au","*.newscdn.com.au","*.newsdata.com.au","*.newsdiscover.com.au","*.news-static.com"],totalExecutionTime:69261,totalOccurrences:46},{name:"Newsquest",category:"content",domains:["*.newsquestdigital.co.uk"]},{name:"Newzulu",category:"content",domains:["*.filemobile.com","*.projects.fm"]},{name:"Nexcess.Net",category:"hosting",domains:["*.nexcesscdn.net"]},{name:"Nexstar Media Group",category:"ad",domains:["*.yashi.com"]},{name:"NextPerf",company:"Rakuten Marketing",category:"ad",domains:[
"*.nxtck.com"]},{name:"Nine.com.au",company:"Nine Digital",category:"content",domains:["*.9msn.com.au"]},{name:"NitroSell",category:"hosting",domains:["*.nitrosell.com"]},{name:"Nochex",category:"utility",domains:["*.nochex.com"]},{name:"Northern &amp; Shell Media Group",category:"content",domains:["*.northernandshell.co.uk"]},{name:"Nosto",category:"analytics",domains:["*.nosto.com"],totalExecutionTime:703736,totalOccurrences:1189},{name:"Now Interact",category:"analytics",domains:["*.nowinteract.com"]},{name:"Numberly",company:"1000mercis",category:"ad",domains:["*.mmtro.com","*.nzaza.com"],totalExecutionTime:1827,totalOccurrences:19},{name:"NyaConcepts",category:"analytics",domains:["*.xclusive.ly"]},{name:"O2",category:"other",domains:["*.o2.co.uk"],examples:["servedby.o2.co.uk"]},{name:"GoDaddy",homepage:"https://www.godaddy.com/",category:"utility",domains:["*.godaddy.com","*.wsimg.com"],examples:["ocsp.godaddy.com","seal.godaddy.com"],totalExecutionTime:94698135,totalOccurrences:110342},
{name:"ObjectPlanet",category:"analytics",domains:["*.easypolls.net"],totalExecutionTime:28470,totalOccurrences:70},{name:"OhMyAd",category:"ad",domains:["*.ohmyad.co"],examples:["pr.ohmyad.co"]},{name:"Okas Concepts",category:"utility",domains:["*.okasconcepts.com"],totalExecutionTime:1483515,totalOccurrences:661},{name:"Okta",category:"analytics",domains:["*.okta.com"],totalExecutionTime:1464920,totalOccurrences:3542},{name:"Olapic",category:"content",domains:["*.photorank.me"],totalExecutionTime:115,totalOccurrences:2},{name:"Ometria",category:"analytics",domains:["*.ometria.com"],totalExecutionTime:16630,totalOccurrences:204},{name:"Omniconvert",category:"analytics",domains:["*.omniconvert.com","d2tgfbvjf3q6hn.cloudfront.net","d3vbj265bmdenw.cloudfront.net"],totalExecutionTime:85855,totalOccurrences:381},{name:"Omniroot",company:"Verizon",category:"utility",domains:["*.omniroot.com"],examples:["ocsp.omniroot.com","vassg142.ocsp.omniroot.com"]},{name:"OnAudience",company:"Cloud Tech\
nologies",category:"ad",domains:["*.onaudience.com"]},{name:"OnScroll",category:"ad",domains:["*.onscroll.com"]},{name:"OnState",category:"ad",domains:["*.onstate.co.uk"]},{name:"OnYourMap",category:"utility",domains:["*.onyourmap.com"]},{name:"One by AOL",company:"AOL",category:"ad",domains:["*.adtechjp.com","*.adtech.de"],totalExecutionTime:1140,totalOccurrences:17},{name:"One by AOL:Mobile",company:"AOL",category:"ad",domains:["*.nexage.com"],examples:["ads.nexage.com","hb.nexage.com"]},{name:"OneAll",category:"analytics",domains:["*.oneall.com"],totalExecutionTime:104501,totalOccurrences:623},{name:"OneSoon",category:"analytics",domains:["*.adalyser.com"],totalExecutionTime:33037,totalOccurrences:437},{name:"OneTag",category:"ad",domains:["*.onetag-sys.com"]},{name:"Onet",category:"ad",domains:["*.onet.pl"],totalExecutionTime:531334,totalOccurrences:760},{name:"Online Rewards",company:"Mastercard",category:"ad",domains:["*.loyaltygateway.com"]},{name:"Online republic",category:"con\
tent",domains:["*.imallcdn.net"],totalExecutionTime:67122,totalOccurrences:58},{name:"Ooyala",category:"ad",domains:["*.ooyala.com"]},{name:"OpenTable",company:"Priceline Group",category:"content",domains:["*.opentable.com","*.opentable.co.uk","*.toptable.co.uk"],examples:["www.toptable.co.uk"],totalExecutionTime:412090,totalOccurrences:4314},{name:"OpenX Ad Exchange",company:"OpenX Technologies",category:"ad",domains:["*.liftdna.com"]},{name:"Opinion Stage",category:"analytics",domains:["*.opinionstage.com"],examples:["www.opinionstage.com"],totalExecutionTime:113206,totalOccurrences:145},{name:"OpinionBar",category:"analytics",domains:["*.opinionbar.com"]},{name:"Opta",company:"Perform Group",category:"content",domains:["*.opta.net"],totalExecutionTime:302785,totalOccurrences:272},{name:"OptiMonk",category:"ad",domains:["*.optimonk.com"],totalExecutionTime:10318415,totalOccurrences:10615},{name:"Optilead",category:"analytics",domains:["*.dyn-img.com","*.leadcall.co.uk","*.optilead.co\
.uk"]},{name:"Optimatic",category:"ad",domains:["*.optimatic.com"],examples:["synch.optimatic.com"]},{name:"Optimise Media Group",category:"utility",domains:["*.omguk.com"],totalExecutionTime:6691,totalOccurrences:41},{name:"Optimost",company:"OpenText",category:"ad",domains:["*.optimost.com"]},{name:"Optimove",company:"Mobius Solutions",category:"analytics",domains:["*.optimove.net"],totalExecutionTime:22679,totalOccurrences:293},{name:"Optorb",category:"ad",domains:["*.optorb.com"]},{name:"Oracle",category:"marketing",domains:["*.custhelp.com","*.eloqua.com","*.en25.com","*.estara.com","*.instantservice.com"],totalExecutionTime:684920,totalOccurrences:569},{name:"Oracle Recommendations On Demand",company:"Oracle",category:"analytics",domains:["*.atgsvcs.com"],totalExecutionTime:8696,totalOccurrences:96},{name:"Oracle Responsys",company:"Oracle",category:"marketing",domains:["*.adrsp.net","*.responsys.net"]},{name:"Order Security-VOID",company:"Order Security",category:"analytics",domains:[
"*.order-security.com"]},{name:"Oriel",category:"ad",domains:["*.oriel.io"]},{name:"Outbrain",homepage:"https://www.outbrain.com/",category:"ad",domains:["*.outbrain.com","*.outbrainimg.com","*.visualrevenue.com"],totalExecutionTime:3373858,totalOccurrences:13287},{name:"OverStream",company:"Coull",category:"ad",domains:["*.coull.com"],examples:["ex1.coull.com"]},{name:"Overdrive",category:"content",domains:["*.contentreserve.com"]},{name:"Overstock",category:"utility",domains:["*.ostkcdn.com"]},{name:"OwnerIQ",category:"ad",domains:["*.owneriq.net"],totalExecutionTime:305561,totalOccurrences:2173},{name:"OzCart",category:"utility",domains:["*.ozcart.com.au"]},{name:"Ozone Media",category:"ad",domains:["*.adadyn.com"]},{name:"Loqate",company:"Loqate",category:"other",domains:["*.pcapredict.com","*.postcodeanywhere.co.uk"],totalExecutionTime:136866,totalOccurrences:777},{name:"PEER 1 Hosting",category:"hosting",domains:["*.peer1.com"]},{name:"PERFORM",category:"content",domains:["*.perf\
ormgroup.com"]},{name:"PICnet",category:"hosting",domains:["*.nonprofitsoapbox.com"]},{name:"Pacnet",company:"Telstra",category:"other",domains:["*.cdndelivery.net"],examples:["682968324.r.cdndelivery.net"]},{name:"Pagefair",category:"ad",domains:["*.pagefair.com","*.pagefair.net"]},{name:"Pagely",category:"other",domains:["*.optnmstr.com"],totalExecutionTime:99314,totalOccurrences:487},{name:"Pagesuite",category:"ad",domains:["*.pagesuite-professional.co.uk"],totalExecutionTime:12,totalOccurrences:1},{name:"Pardot",category:"marketing",domains:["*.pardot.com"],totalExecutionTime:73880,totalOccurrences:550},{name:"Parse.ly",category:"analytics",domains:["*.parsely.com","d1z2jf7jlzjs58.cloudfront.net"],totalExecutionTime:1122662,totalOccurrences:5204},{name:"Pay per Click",company:"Eysys",category:"ad",domains:["*.eysys.com"],examples:["pla27.eysys.com"]},{name:"PayPal Ads",category:"ad",domains:["*.where.com"]},{name:"Peaks & Pies",category:"analytics",domains:["*.bunchbox.co"]},{name:"\
PebblePost",category:"ad",domains:["*.pbbl.co"],totalExecutionTime:147945,totalOccurrences:725},{name:"Peerius",category:"analytics",domains:["*.peerius.com"]},{name:"Peermap",company:"IMRG",category:"analytics",domains:["peermapcontent.affino.com"]},{name:"Penske Media",category:"content",domains:["*.pmc.com"]},{name:"Penton",category:"utility",domains:["*.pisces-penton.com"]},{name:"Pepper",category:"ad",domains:["*.peppercorp.com"]},{name:"Perfect Audience",company:"Marin Software",category:"ad",domains:["*.prfct.co","*.marinsm.com","*.perfectaudience.com"],totalExecutionTime:405,totalOccurrences:7},{name:"Perfect Market",category:"ad",domains:["*.perfectmarket.com"]},{name:"Perfect Privacy",category:"other",domains:["*.suitesmart.com"]},{name:"Perform Group",category:"content",domains:["*.performfeeds.com","*.premiumtv.co.uk"]},{name:"Performio",category:"ad",domains:["*.performax.cz"],examples:["ut.performax.cz"],totalExecutionTime:117591,totalOccurrences:337},{name:"PerimeterX Bo\
t Defender",company:"PerimeterX",category:"utility",domains:["*.perimeterx.net","*.pxi.pub"],totalExecutionTime:172605,totalOccurrences:68},{name:"Periscope",category:"content",domains:["*.periscope.tv"]},{name:"Permutive",category:"ad",domains:["*.permutive.com","d3alqb8vzo7fun.cloudfront.net"],totalExecutionTime:1406714,totalOccurrences:1124},{name:"Petametrics",category:"analytics",domains:["*.petametrics.com"]},{name:"PhotoBucket",category:"content",domains:["*.photobucket.com"],totalExecutionTime:2383529,totalOccurrences:338},{name:"Picreel",category:"analytics",domains:["*.pcrl.co","*.picreel.com"],totalExecutionTime:45437,totalOccurrences:300},{name:"Pictela (AOL)",category:"analytics",domains:["*.pictela.net"]},{name:"PistonHeads",category:"social",domains:["*.pistonheads.com"]},{name:"Piwik",category:"analytics",domains:["*.drtvtracker.com","*.piwikpro.com","*.raac33.net"],totalExecutionTime:2813,totalOccurrences:32},{name:"Pixalate",category:"utility",domains:["*.adrta.com"],
totalExecutionTime:4187,totalOccurrences:13},{name:"Pixlee",category:"social",domains:["*.pixlee.com"],totalExecutionTime:137281,totalOccurrences:341},{name:"Placed",category:"analytics",domains:["*.placed.com"],totalExecutionTime:691,totalOccurrences:1},{name:"Planning-inc",category:"analytics",domains:["*.planning-inc.co.uk"]},{name:"PlayAd Media Group",category:"ad",domains:["*.youplay.se"]},{name:"Playbuzz",category:"hosting",domains:["*.playbuzz.com"],totalExecutionTime:58184,totalOccurrences:89},{name:"Pleenq",category:"ad",domains:["*.pleenq.com"]},{name:"Plentific",category:"content",domains:["*.plentific.com"]},{name:"PluginDetect",category:"other",domains:["dtlilztwypawv.cloudfront.net"]},{name:"Po.st",company:"RadiumOne",category:"utility",domains:["*.po.st"],totalExecutionTime:178,totalOccurrences:3},{name:"Pointpin",category:"utility",domains:["*.pointp.in"]},{name:"Pointroll (Garnett)",category:"ad",domains:["*.pointroll.com"]},{name:"Polar",homepage:"https://polar.me/",category:"\
ad",domains:["*.polarmobile.ca","*.mediaeverywhere.com","*.mediavoice.com","*.plrsrvcs.com","*.polarcdn-engine.com","*.polarcdn-meraxes.com","*.polarcdn-pentos.com","*.polarcdn-static.com","*.polarcdn-terrax.com","*.polarcdn.com","*.polarmobile.com","*.poweredbypolar.com","*.mediaconductor.me","*.polaracademy.me"],totalExecutionTime:66280,totalOccurrences:223},{name:"PollDaddy (Automattic)",category:"ad",domains:["static.polldaddy.com","*.poll.fm"],totalExecutionTime:4752,totalOccurrences:37},{name:"Polldaddy",company:"Automattic",category:"analytics",domains:["polldaddy.com","*.polldaddy.com"],totalExecutionTime:294207,totalOccurrences:2715},{name:"Polyfill service",company:"Polyfill.io",category:"other",domains:["*.polyfill.io"]},{name:"MegaPopAds",category:"ad",domains:["*.megapopads.com"]},{name:"Populis",category:"ad",domains:["*.populisengage.com"]},{name:"Postimage.org",category:"content",domains:["*.postimg.org"]},{name:"PowerFront",category:"hosting",domains:["*.inside-graph.c\
om"],totalExecutionTime:220331,totalOccurrences:370},{name:"PowerReviews",category:"analytics",domains:["*.powerreviews.com"],totalExecutionTime:1208993,totalOccurrences:1324},{name:"Powerlinks.com",category:"ad",domains:["*.powerlinks.com"]},{name:"Press+",category:"ad",domains:["*.pipol.com","*.ppjol.com","*.ppjol.net"]},{name:"PressArea",category:"utility",domains:["*.pressarea.com"],examples:["www.pressarea.com"]},{name:"Pretio Interactive",category:"ad",domains:["*.pretio.in"]},{name:"Prezi",category:"utility",domains:["*.prezi.com"],totalExecutionTime:72394,totalOccurrences:79},{name:"PriceGrabber",category:"content",domains:["*.pgcdn.com","*.pricegrabber.com"]},{name:"PriceRunner",category:"content",domains:["*.pricerunner.com"],totalExecutionTime:200,totalOccurrences:6},{name:"PrintFriendly",category:"utility",domains:["*.printfriendly.com"],totalExecutionTime:39464,totalOccurrences:381},{name:"Privy",category:"ad",domains:["*.privy.com","*.privymktg.com"],totalExecutionTime:14992809,
totalOccurrences:18961},{name:"Proclivity Media",category:"analytics",domains:["*.pswec.com"]},{name:"Profitshare",category:"ad",domains:["*.profitshare.ro"],totalExecutionTime:60087,totalOccurrences:194},{name:"Programattik",category:"ad",domains:["*.programattik.com"],totalExecutionTime:95,totalOccurrences:9},{name:"Proper Media",category:"content",domains:["*.proper.io"],totalExecutionTime:253672,totalOccurrences:109},{name:"Property Week",category:"content",domains:["*.propertyweek.com"],examples:["www.propertyweek.com"]},{name:"Provide Support",category:"customer-success",domains:["*.providesupport.com"],totalExecutionTime:79281,totalOccurrences:989},{name:"Proweb Uk",category:"hosting",domains:["*.proweb.net"]},{name:"Proximic (ComScore)",category:"ad",domains:["*.proximic.com"]},{name:"Psyma",category:"ad",domains:["*.psyma.com"],totalExecutionTime:2496,totalOccurrences:5},{name:"PubFactory",company:"Safari Books Online",category:"content",domains:["*.pubfactory.com"]},{name:"Pu\
bNation",category:"ad",domains:["*.pubnation.com"],totalExecutionTime:625439,totalOccurrences:132},{name:"Publicidad.net",category:"ad",domains:["*.publicidad.tv"]},{name:"PublishThis",company:"Ultra Unlimited",category:"ad",domains:["*.publishthis.com"]},{name:"Pulse Insights",category:"analytics",domains:["*.pulseinsights.com"],totalExecutionTime:5757,totalOccurrences:53},{name:"Pulsepoint",category:"marketing",domains:["*.displaymarketplace.com"]},{name:"Purch",category:"ad",domains:["*.bestofmedia.com","*.purch.com"],examples:["ramp.purch.com"]},{name:"Pure Chat",category:"customer-success",domains:["*.purechat.com"],totalExecutionTime:1129392,totalOccurrences:3105},{name:"PushCrew",category:"ad",domains:["*.pushcrew.com"],totalExecutionTime:170011,totalOccurrences:823},{name:"Q1Media",category:"ad",domains:["*.q1media.com","*.q1mediahydraplatform.com"]},{name:"Qbase Software Development",category:"hosting",domains:["*.smartwebportal.co.uk"]},{name:"Qeryz",category:"analytics",domains:[
"*.qeryz.com"]},{name:"Qode Interactive",category:"hosting",domains:["*.qodeinteractive.com"],totalExecutionTime:2503828,totalOccurrences:147},{name:"Qrius",category:"social",domains:["*.qrius.me"]},{name:"Qualaroo",category:"analytics",domains:["*.qualaroo.com"],totalExecutionTime:54960,totalOccurrences:347},{name:"Qualtrics",category:"analytics",domains:["*.qualtrics.com"],totalExecutionTime:4907219,totalOccurrences:7134},{name:"Qubit",company:"Qubit",category:"analytics",domains:["*.qubit.com","*.qutics.com","d3c3cq33003psk.cloudfront.net","*.goqubit.com","*.qubitproducts.com"],totalExecutionTime:50060,totalOccurrences:43},{name:"Qubit Deliver",company:"Qubit",category:"analytics",domains:["d1m54pdnjzjnhe.cloudfront.net","d22rutvoghj3db.cloudfront.net","dd6zx4ibq538k.cloudfront.net"]},{name:"QuestionPro",category:"analytics",domains:["*.questionpro.com"],totalExecutionTime:60868,totalOccurrences:152},{name:"Queue-it",category:"other",domains:["*.queue-it.net"],totalExecutionTime:60031,
totalOccurrences:143},{name:"QuinStreet",category:"ad",domains:["*.Quinstreet.com","*.b2btechleadform.com","*.qnsr.com","*.qsstats.com"],examples:["www.qsstats.com"]},{name:"QuoVadis",category:"utility",domains:["*.quovadisglobal.com"]},{name:"Qzzr",category:"analytics",domains:["*.movementventures.com","*.qzzr.com"],examples:["www.qzzr.com"]},{name:"RapidAPI",category:"utility",domains:["*.rapidapi.com"],examples:["telize-v1.p.rapidapi.com"],totalExecutionTime:4218,totalOccurrences:2},{name:"RCS Media Group",category:"ad",domains:["*.rcsadv.it"]},{name:"REVIVVE",category:"ad",domains:["*.revivve.com"]},{name:"RSSinclude",category:"social",domains:["*.rssinclude.com"]},{name:"RTB House AdPilot",company:"RTB House",category:"ad",domains:["*.erne.co","*.creativecdn.com"],totalExecutionTime:1677125,totalOccurrences:13287},{name:"RTB Media",category:"ad",domains:["*.rtb-media.me"]},{name:"RUN",category:"ad",domains:["*.runadtag.com","*.rundsp.com"]},{name:"Rackspace",category:"hosting",domains:[
"*.rackcdn.com","*.rackspacecloud.com","*.raxcdn.com","*.websitetestlink.com"],totalExecutionTime:3573460,totalOccurrences:2624},{name:"RadiumOne",category:"ad",domains:["*.gwallet.com","*.r1-cdn.net"]},{name:"Rakuten DC Storm",company:"Rakuten",category:"analytics",domains:["*.dc-storm.com","*.h4k5.com","*.stormiq.com"]},{name:"Rakuten LinkShare",company:"Rakuten",category:"ad",domains:["*.linksynergy.com"],totalExecutionTime:23285,totalOccurrences:151},{name:"Rakuten Marketing",company:"Rakuten",category:"ad",domains:["*.rakuten-static.com","*.rmtag.com","tag.rmp.rakuten.com"],totalExecutionTime:462276,totalOccurrences:3399},{name:"Rakuten MediaForge",company:"Rakuten",category:"ad",domains:["*.mediaforge.com"],totalExecutionTime:1650,totalOccurrences:20},{name:"Rambler",company:"Rambler & Co",category:"utility",domains:["*.rambler.ru"],totalExecutionTime:54521084,totalOccurrences:15831},{name:"Ranker",category:"content",domains:["*.ranker.com","*.rnkr-static.com"]},{name:"Ravelin",category:"\
utility",domains:["*.ravelin.com"]},{name:"Raygun",category:"utility",domains:["*.raygun.io","*.rapidzebra.io"],totalExecutionTime:245714,totalOccurrences:2539},{name:"ReCollect",category:"utility",domains:["*.recollect.net"],totalExecutionTime:229879,totalOccurrences:135},{name:"ReSRC",category:"utility",domains:["*.resrc.it"]},{name:"ReTargeter",category:"ad",domains:["*.retargeter.com"]},{name:"Reach Group",category:"ad",domains:["*.redintelligence.net"],totalExecutionTime:1449,totalOccurrences:199},{name:"ReachDynamics",category:"ad",domains:["*.rdcdn.com"]},{name:"ReachForce",category:"ad",domains:["*.reachforce.com"]},{name:"ReachLocal",category:"ad",domains:["*.rtrk.co.nz"],examples:["rtsys.rtrk.co.nz"]},{name:"ReachMee",category:"content",domains:["*.reachmee.com"],totalExecutionTime:133135,totalOccurrences:40},{name:"Reactful",category:"analytics",domains:["*.reactful.com"],totalExecutionTime:12497,totalOccurrences:42},{name:"Realtime",company:"internet business technologies",
category:"utility",domains:["*.realtime.co"]},{name:"Realtime Media (Brian Communications)",category:"ad",domains:["*.rtm.com"]},{name:"Realtime Targeting",category:"ad",domains:["*.idtargeting.com"]},{name:"Realytics",category:"analytics",domains:["dcniko1cv0rz.cloudfront.net","*.realytics.net"],totalExecutionTime:38343,totalOccurrences:276},{name:"RebelMouse",category:"ad",domains:["*.rebelmouse.com","*.rbl.ms"],examples:["www.rebelmouse.com"],totalExecutionTime:3876,totalOccurrences:22},{name:"Receiptful",category:"utility",domains:["*.receiptful.com"],totalExecutionTime:58254,totalOccurrences:361},{name:"Recite Me",category:"other",domains:["*.reciteme.com"],totalExecutionTime:22320,totalOccurrences:142},{name:"RecoBell",category:"analytics",domains:["*.recobell.io"]},{name:"Recommend",category:"analytics",domains:["*.recommend.pro"]},{name:"Red Eye International",category:"ad",domains:["*.pajmc.com"]},{name:"Redfish Group",category:"ad",domains:["*.wmps.com"]},{name:"Reevoo",category:"\
analytics",domains:["*.reevoo.com"],totalExecutionTime:87323,totalOccurrences:133},{name:"Refersion",category:"ad",domains:["*.refersion.com"],totalExecutionTime:564360,totalOccurrences:2170},{name:"Refined Ads",category:"ad",domains:["*.refinedads.com"]},{name:"Reflektion",category:"analytics",domains:["*.reflektion.com","d26opx5dl8t69i.cloudfront.net"]},{name:"Reflow",company:"Scenestealer",category:"ad",domains:["*.reflow.tv"]},{name:"Reklama",category:"ad",domains:["*.o2.pl","*.wp.pl"],examples:["dot.wp.pl","px.o2.pl","px.wp.pl"],totalExecutionTime:846563,totalOccurrences:1054},{name:"Relevad ReleStar",company:"Relevad",category:"ad",domains:["*.relestar.com"]},{name:"Remarketing Pixel",company:"Adsterra Network",category:"ad",domains:["*.datadbs.com","*.remarketingpixel.com"]},{name:"Remintrex",company:"SmartUp Venture",category:"ad",domains:["*.remintrex.com"]},{name:"Republer",category:"ad",domains:["*.republer.com"],examples:["sync.republer.com"]},{name:"Research Now",category:"\
analytics",domains:["*.researchgnow.com","*.researchnow.com"],examples:["tag.researchgnow.com"]},{name:"Research Online",company:"Skills Development Scotland",category:"content",domains:["*.researchonline.org.uk"],examples:["www.researchonline.org.uk"]},{name:"Resonance Insights",category:"analytics",domains:["*.res-x.com"],totalExecutionTime:2277,totalOccurrences:20},{name:"Resonate Networks",category:"analytics",domains:["*.reson8.com"],totalExecutionTime:1739,totalOccurrences:1},{name:"Response Team",category:"ad",domains:["*.i-transactads.com"]},{name:"ResponseTap",category:"analytics",domains:["*.adinsight.com","*.responsetap.com"],totalExecutionTime:84074,totalOccurrences:274},{name:"ResponsiveVoice",category:"other",domains:["*.responsivevoice.org"],totalExecutionTime:851397,totalOccurrences:6863},{name:"Retention Science",category:"ad",domains:["*.retentionscience.com","d1stxfv94hrhia.cloudfront.net"],totalExecutionTime:17276,totalOccurrences:209},{name:"Revcontent",category:"c\
ontent",domains:["*.revcontent.com"],totalExecutionTime:1153469,totalOccurrences:1251},{name:"Revee",category:"ad",domains:["*.revee.com"]},{name:"Revenue Conduit",category:"utility",domains:["*.revenueconduit.com"]},{name:"RevenueMantra",category:"ad",domains:["*.revenuemantra.com"]},{name:"Reviews.co.uk",category:"analytics",domains:["*.reviews.co.uk"],totalExecutionTime:425151,totalOccurrences:1883},{name:"Reviews.io",category:"analytics",domains:["*.reviews.io"],totalExecutionTime:1713955,totalOccurrences:4516},{name:"Revolver Maps",category:"analytics",domains:["*.revolvermaps.com"],totalExecutionTime:2132297,totalOccurrences:2305},{name:"Revv",category:"utility",domains:["*.revv.co"],totalExecutionTime:26667,totalOccurrences:11},{name:"RichRelevance",category:"analytics",domains:["*.richrelevance.com"],totalExecutionTime:3496,totalOccurrences:19},{name:"RightNow Service Cloud",company:"Oracle",category:"customer-success",domains:["*.rightnowtech.com","*.rnengage.com"],totalExecutionTime:8970,
totalOccurrences:122},{name:"Rightster",category:"ad",domains:["*.ads-creativesyndicator.com"]},{name:"Riskified",category:"utility",domains:["*.riskified.com"],totalExecutionTime:373865,totalOccurrences:1643},{name:"Rockerbox",category:"analytics",homepage:"https://www.rockerbox.com/",domains:["getrockerbox.com"],examples:["getrockerbox.com"],totalExecutionTime:19742,totalOccurrences:162},{name:"Rocket Fuel",category:"ad",domains:["*.rfihub.com","*.ru4.com","*.rfihub.net","*.ad1x.com"],totalExecutionTime:356189,totalOccurrences:3247},{name:"Rollbar",category:"utility",domains:["*.rollbar.com","d37gvrvc0wt4s1.cloudfront.net"],examples:["api.rollbar.com"],totalExecutionTime:190180,totalOccurrences:2349},{name:"RomanCart",category:"utility",domains:["*.romancart.com"],totalExecutionTime:510,totalOccurrences:5},{name:"Rondavu",category:"ad",domains:["*.rondavu.com"]},{name:"Roomkey",category:"content",domains:["*.roomkey.com"],examples:["www.roomkey.com"]},{name:"Roost",category:"utility",
domains:["*.goroost.com"]},{name:"Roxot",category:"ad",domains:["*.rxthdr.com"]},{name:"Roxr Software",category:"analytics",domains:["*.getclicky.com"],totalExecutionTime:851573,totalOccurrences:12877},{name:"Rtoaster",company:"Brainpad",homepage:"https://www.brainpad.co.jp/rtoaster/",category:"marketing",domains:["*.rtoaster.jp"],examples:["rt.rtoaster.jp"],totalExecutionTime:15065,totalOccurrences:91},{name:"Rubikloud.com",category:"analytics",domains:["*.rubikloud.com"]},{name:"Ruler Analytics",company:"Ruler",category:"analytics",domains:["*.nyltx.com","*.ruleranalytics.com"],examples:["www.ruleranalytics.com"],totalExecutionTime:41074,totalOccurrences:436},{name:"Runner",company:"Rambler & Co",category:"content",domains:["*.begun.ru"],totalExecutionTime:26,totalOccurrences:1},{name:"S4M",category:"ad",domains:["*.sam4m.com"]},{name:"SAP Hybris Marketing Convert",company:"SAP",category:"ad",domains:["*.seewhy.com"]},{name:"SAS Institute",category:"ad",domains:["*.aimatch.com","*.sa\
s.com"],totalExecutionTime:59419,totalOccurrences:29},{name:"SATORI",homepage:"https://satori.marketing/",category:"marketing",domains:["satori.segs.jp"],examples:["satori.segs.jp/s.js"],totalExecutionTime:62202,totalOccurrences:816},{name:"SC ShopMania Net SRL",category:"content",domains:["*.shopmania.com"]},{name:"SDL Media Manager",company:"SDL",category:"other",domains:["*.sdlmedia.com"]},{name:"SFR",category:"other",domains:["*.sfr.fr"],examples:["elr.sfr.fr"],totalExecutionTime:22751,totalOccurrences:22},{name:"SLI Systems",category:"utility",domains:["*.resultslist.com","*.resultspage.com","*.sli-spark.com"],totalExecutionTime:2909,totalOccurrences:33},{name:"SMARTASSISTANT",company:"Smart Information Systems",category:"customer-success",domains:["*.smartassistant.com"]},{name:"SMARTSTREAM.TV",category:"ad",domains:["*.smartstream.tv"]},{name:"SPX",company:"Smaato",category:"ad",domains:["*.smaato.net"],totalExecutionTime:519,totalOccurrences:13},{name:"Sabio",category:"customer\
-success",domains:["*.sabio.co.uk"],examples:["www.sabio.co.uk"]},{name:"Sailthru",category:"analytics",domains:["*.sail-horizon.com","*.sail-personalize.com","*.sail-track.com"],totalExecutionTime:59245,totalOccurrences:678},{name:"Sailthru Sightlines",company:"Sailthru",category:"marketing",domains:["*.sailthru.com"],totalExecutionTime:6772,totalOccurrences:18},{name:"Sajari Pty",category:"utility",domains:["*.sajari.com"],totalExecutionTime:70019,totalOccurrences:197},{name:"SaleCycle",category:"ad",domains:["*.salecycle.com","d16fk4ms6rqz1v.cloudfront.net","d22j4fzzszoii2.cloudfront.net","d30ke5tqu2tkyx.cloudfront.net","dn1i8v75r669j.cloudfront.net"],totalExecutionTime:146399,totalOccurrences:641},{name:"Salesforce Live Agent",company:"Salesforce.com",category:"customer-success",domains:["*.salesforceliveagent.com"],totalExecutionTime:100033,totalOccurrences:675},{name:"Salesforce.com",category:"ad",domains:["*.force.com","*.salesforce.com"],examples:["secure.force.com"],totalExecutionTime:1614051,
totalOccurrences:4970},{name:"Samba TV",company:"Samba",category:"content",domains:["*.samba.tv"],totalExecutionTime:1690,totalOccurrences:7},{name:"Samplicio.us",category:"analytics",domains:["*.samplicio.us"],totalExecutionTime:1727,totalOccurrences:5},{name:"Say Media",category:"ad",domains:["*.saymedia.com"]},{name:"Scenario",category:"analytics",domains:["*.getscenario.com"]},{name:"Schuh (image shard)",company:"Schuh",category:"other",domains:["d2ob0iztsaxy5v.cloudfront.net"]},{name:"Science Rockstars",category:"analytics",domains:["*.persuasionapi.com"]},{name:"ScientiaMobile",category:"analytics",domains:["*.wurflcloud.com","*.wurfl.io"],totalExecutionTime:627,totalOccurrences:3},{name:"Scoota",category:"ad",domains:["*.rockabox.co","*.scoota.co","d31i2625d5nv27.cloudfront.net","dyjnzf8evxrp2.cloudfront.net"]},{name:"ScribbleLive",category:"ad",domains:["*.scribblelive.com"]},{name:"SearchForce",category:"ad",domains:["*.searchforce.net"],totalExecutionTime:118,totalOccurrences:3},
{name:"SearchSpring",category:"utility",domains:["*.searchspring.net"],totalExecutionTime:1175588,totalOccurrences:309},{name:"Searchanise",category:"analytics",domains:["*.searchanise.com"],examples:["www.searchanise.com"],totalExecutionTime:63519,totalOccurrences:420},{name:"Sears Holdings",category:"content",domains:["*.shld.net"]},{name:"Secomapp",category:"utility",domains:["*.secomapp.com"],totalExecutionTime:2151952,totalOccurrences:2137},{name:"SecuredVisit",company:"4Cite Marketing",category:"ad",domains:["*.securedvisit.com"],totalExecutionTime:41054,totalOccurrences:369},{name:"SecurityMetrics",category:"utility",domains:["*.securitymetrics.com"],totalExecutionTime:8413,totalOccurrences:2},{name:"Segmento",category:"ad",domains:["*.rutarget.ru"],totalExecutionTime:17111,totalOccurrences:226},{name:"Segmint",category:"analytics",domains:["*.segmint.net"],totalExecutionTime:14122,totalOccurrences:109},{name:"Sekindo",category:"content",domains:["*.sekindo.com"],totalExecutionTime:376,
totalOccurrences:4},{name:"Seldon",category:"analytics",domains:["*.rummblelabs.com"]},{name:"SelectMedia International",category:"content",domains:["*.selectmedia.asia"],totalExecutionTime:186574,totalOccurrences:68},{name:"Selligent",category:"ad",domains:["*.emsecure.net","*.slgnt.eu","targetemsecure.blob.core.windows.net"],totalExecutionTime:163886,totalOccurrences:506},{name:"Sellpoints",category:"analytics",domains:["*.sellpoints.com"]},{name:"Semantics3",category:"analytics",domains:["*.hits.io"]},{name:"Semasio",category:"analytics",domains:["*.semasio.net"]},{name:"Semcasting Site Visitor Attribution",company:"Semcasting",category:"ad",domains:["*.smartzonessva.com"]},{name:"Sentifi",category:"social",domains:["*.sentifi.com"]},{name:"ServMetric",category:"analytics",domains:["*.servmetric.com"]},{name:"ServiceSource International",category:"marketing",domains:["*.scoutanalytics.net"],examples:["scout.scoutanalytics.net"]},{name:"ServiceTick",category:"analytics",domains:["*.s\
ervicetick.com"]},{name:"Servo",company:"Xervo",category:"hosting",domains:["*.onmodulus.net"]},{name:"SessionCam",company:"ServiceTick",category:"analytics",domains:["*.sessioncam.com","d2oh4tlt9mrke9.cloudfront.net"]},{name:"Seznam",category:"utility",domains:["*.imedia.cz"],totalExecutionTime:1323711,totalOccurrences:6863},{name:"Sharethrough",category:"ad",domains:["*.sharethrough.com"],totalExecutionTime:46730,totalOccurrences:833},{name:"SharpSpring",category:"marketing",domains:["*.sharpspring.com","*.marketingautomation.services"],totalExecutionTime:632191,totalOccurrences:2080},{name:"ShopRunner",category:"content",domains:["*.shoprunner.com","*.s-9.us"],totalExecutionTime:35573,totalOccurrences:32},{name:"ShopStorm",category:"utility",domains:["*.shopstorm.com"]},{name:"Shopatron",category:"hosting",domains:["*.shopatron.com"]},{name:"Shopgate",category:"utility",domains:["*.shopgate.com"],totalExecutionTime:15293,totalOccurrences:25},{name:"ShopiMind",company:"ShopIMind",category:"\
ad",domains:["*.shopimind.com"]},{name:"Shopkeeper Tools",category:"utility",domains:["*.shopkeepertools.com"],totalExecutionTime:500,totalOccurrences:6},{name:"Sidecar",category:"other",domains:["*.getsidecar.com","d3v27wwd40f0xu.cloudfront.net"]},{name:"Sidereel",category:"analytics",domains:["*.sidereel.com"]},{name:"Sift Science",category:"utility",domains:["*.siftscience.com"],totalExecutionTime:90167,totalOccurrences:355},{name:"Signal",category:"tag-manager",domains:["*.sitetagger.co.uk"]},{name:"Signyfyd",category:"utility",domains:["*.signifyd.com"],totalExecutionTime:4752892,totalOccurrences:2608},{name:"Silktide",category:"hosting",domains:["*.silktide.com"],totalExecutionTime:132707,totalOccurrences:390},{name:"Silverpop",company:"IBM",category:"ad",domains:["*.mkt912.com","*.mkt922.com","*.mkt932.com","*.mkt941.com","*.mkt51.net","*.mkt61.net","*.pages01.net","*.pages02.net","*.pages03.net","*.pages04.net","*.pages05.net"],totalExecutionTime:4144,totalOccurrences:58},{name:"\
Simplaex",category:"marketing",domains:["*.simplaex.net"]},{name:"SimpleReach",category:"analytics",domains:["*.simplereach.com","d8rk54i4mohrb.cloudfront.net"]},{name:"Simplestream",category:"content",domains:["*.simplestream.com"],examples:["player.simplestream.com"]},{name:"Simpli.fi",category:"ad",domains:["*.simpli.fi"],totalExecutionTime:974218,totalOccurrences:16378},{name:"Simplicity Marketing",category:"ad",domains:["*.flashtalking.com"],totalExecutionTime:579126,totalOccurrences:2927},{name:"SinnerSchrader Deutschland",category:"ad",domains:["*.s2Betrieb.de"]},{name:"Sirv",category:"other",domains:["*.sirv.com"],totalExecutionTime:604262,totalOccurrences:1034},{name:"Site Meter",category:"analytics",domains:["*.sitemeter.com"]},{name:"Site24x7 Real User Monitoring",company:"Site24x7",category:"analytics",domains:["*.site24x7rum.com"],totalExecutionTime:124283,totalOccurrences:1007},{name:"SiteGainer",category:"analytics",domains:["*.sitegainer.com","d191y0yd6d0jy4.cloudfront.\
net"]},{name:"SiteScout",company:"Centro",category:"ad",domains:["*.pixel.ad","*.sitescout.com"],totalExecutionTime:256082,totalOccurrences:3401},{name:"Siteimprove",category:"utility",domains:["*.siteimprove.com","*.siteimproveanalytics.com"],totalExecutionTime:28494,totalOccurrences:361},{name:"Six Degrees Group",category:"hosting",domains:["*.fstech.co.uk"]},{name:"Skimbit",category:"ad",domains:["*.redirectingat.com","*.skimresources.com","*.skimresources.net"],totalExecutionTime:32940093,totalOccurrences:86270},{name:"Skimlinks",category:"ad",domains:["*.skimlinks.com"]},{name:"SkyGlue Technology",category:"analytics",domains:["*.skyglue.com"],totalExecutionTime:2567,totalOccurrences:24},{name:"SkyScanner",category:"content",domains:["*.skyscanner.net"],examples:["api.skyscanner.net"],totalExecutionTime:98147,totalOccurrences:370},{name:"Skybet",company:"Bonne Terre t/a Sky Vegas (Sky)",category:"other",domains:["*.skybet.com"]},{name:"Skype",category:"other",domains:["*.skype.com"],
totalExecutionTime:121901,totalOccurrences:625},{name:"Slate Group",category:"content",domains:["*.cdnslate.com"]},{name:"SlimCut Media Outstream",company:"SlimCut Media",category:"ad",domains:["*.freeskreen.com"]},{name:"Smart Insight Tracking",company:"Emarsys",category:"analytics",domains:["*.scarabresearch.com"],totalExecutionTime:361811,totalOccurrences:1779},{name:"Smart AdServer",category:"ad",domains:["*.01net.com","*.sascdn.com","*.sasqos.com","*.smartadserver.com"],examples:["securite.01net.com"],totalExecutionTime:22356737,totalOccurrences:107812},{name:"SmartFocus",category:"analytics",domains:["*.emv2.com","*.emv3.com","*.predictiveintent.com","*.smartfocus.com","*.themessagecloud.com"]},{name:"Smarter Click",category:"ad",domains:["*.smct.co","*.smarterclick.co.uk"],totalExecutionTime:761,totalOccurrences:11},{name:"SmarterHQ",category:"analytics",domains:["*.smarterhq.io","d1n00d49gkbray.cloudfront.net","*.smarterremarketer.net"],totalExecutionTime:2636,totalOccurrences:28},
{name:"Smarttools",category:"customer-success",domains:["*.smartertrack.com"]},{name:"Smartzer",category:"ad",domains:["*.smartzer.com"]},{name:"Snack Media",category:"content",domains:["*.snack-media.com"],totalExecutionTime:575613,totalOccurrences:423},{name:"Snacktools",category:"ad",domains:["*.bannersnack.com"],totalExecutionTime:162327,totalOccurrences:303},{name:"SnapEngage",category:"customer-success",domains:["*.snapengage.com"],totalExecutionTime:147012,totalOccurrences:1038},{name:"SnapWidget",category:"content",domains:["*.snapwidget.com"]},{name:"Soasta",category:"analytics",domains:["*.lognormal.net"]},{name:"SociableLabs",category:"ad",domains:["*.sociablelabs.net","*.sociablelabs.com"]},{name:"Social Annex",category:"customer-success",domains:["*.socialannex.com"]},{name:"SocialShopWave",category:"social",domains:["*.socialshopwave.com"],totalExecutionTime:4962079,totalOccurrences:3720},{name:"Socialphotos",category:"social",domains:["*.slpht.com"],totalExecutionTime:12590,
totalOccurrences:120},{name:"Sociomantic Labs",company:"DunnHumby",category:"ad",domains:["*.sociomantic.com"]},{name:"SodaHead",category:"analytics",domains:["*.sodahead.com"],examples:["pollware-cdn.sodahead.com"]},{name:"Softwebzone",category:"hosting",domains:["*.softwebzone.com"],examples:["www.softwebzone.com"]},{name:"Sojern",category:"marketing",domains:["*.sojern.com"],totalExecutionTime:2086952,totalOccurrences:4422},{name:"Sokrati",category:"marketing",domains:["*.sokrati.com"]},{name:"Sonobi",category:"ad",domains:["*.sonobi.com"],totalExecutionTime:4682222,totalOccurrences:81682},{name:"Sooqr Search",company:"Sooqr",category:"utility",domains:["*.sooqr.com"],totalExecutionTime:176199,totalOccurrences:396},{name:"Sophus3",category:"analytics",domains:["*.s3ae.com","*.sophus3.com"],totalExecutionTime:5605,totalOccurrences:11},{name:"Sorenson Media",category:"content",domains:["*.sorensonmedia.com"]},{name:"Sortable",category:"ad",domains:["*.deployads.com"]},{name:"Sotic",category:"\
hosting",domains:["*.sotic.net","*.soticservers.net"]},{name:"Soundest",category:"ad",domains:["*.soundestlink.com","*.soundest.net"],totalExecutionTime:835,totalOccurrences:102},{name:"Sourcepoint",category:"ad",domains:["*.decenthat.com","*.fallingfalcon.com","*.summerhamster.com","d2lv4zbk7v5f93.cloudfront.net","d3qxwzhswv93jk.cloudfront.net"],examples:["www.decenthat.com","www.fallingfalcon.com","www.summerhamster.com"]},{name:"SourceKnowledge",homepage:"https://www.sourceknowledge.com",category:"ad",domains:["*.provenpixel.com"],totalExecutionTime:505,totalOccurrences:8},{name:"SpaceNet",category:"hosting",domains:["*.nmm.de"]},{name:"Sparkflow",company:"Intercept Interactive",category:"ad",domains:["*.sparkflow.net"]},{name:"Specific Media",category:"ad",domains:["*.specificmedia.com","*.adviva.net","*.specificclick.net"]},{name:"Spicy",company:"Data-Centric Alliance",category:"ad",domains:["*.sspicy.ru"]},{name:"Spoke",category:"customer-success",domains:["*.121d8.com"]},{name:"\
Spongecell",category:"ad",domains:["*.spongecell.com"]},{name:"Spot.IM",category:"social",domains:["*.spot.im","*.spotim.market"],totalExecutionTime:192547,totalOccurrences:342},{name:"SpotXchange",category:"ad",domains:["*.spotxcdn.com","*.spotxchange.com","*.spotx.tv"]},{name:"SpringServer",category:"ad",domains:["*.springserve.com"],totalExecutionTime:1192823,totalOccurrences:1432},{name:"Spylight",category:"other",domains:["*.spylight.com"]},{name:"SreamAMG",company:"StreamAMG",category:"other",domains:["*.streamamg.com"],totalExecutionTime:85506,totalOccurrences:62},{name:"StackAdapt",category:"ad",domains:["*.stackadapt.com"],totalExecutionTime:1338506,totalOccurrences:14912},{name:"StackExchange",category:"social",domains:["*.sstatic.net"],totalExecutionTime:187262,totalOccurrences:217},{name:"Stackla PTY",category:"social",domains:["*.stackla.com"],totalExecutionTime:271026,totalOccurrences:175},{name:"Stailamedia",category:"ad",domains:["*.stailamedia.com"]},{name:"Stamped.io",
category:"analytics",domains:["*.stamped.io"],totalExecutionTime:1665115,totalOccurrences:12460},{name:"Starfield Services Root Certificate Authority",company:"Starfield Technologies",category:"utility",domains:["*.starfieldtech.com","ss2.us","*.ss2.us"],examples:["ocsp.starfieldtech.com"],totalExecutionTime:18156,totalOccurrences:39},{name:"Starfield Technologies",category:"utility",domains:["*.websiteprotection.com"],examples:["seals.websiteprotection.com"]},{name:"StatCounter",category:"analytics",domains:["*.statcounter.com"],totalExecutionTime:5427381,totalOccurrences:50769},{name:"Statful",category:"analytics",domains:["*.statful.com"]},{name:"Steelhouse",category:"ad",domains:["*.steelhousemedia.com"],totalExecutionTime:66172,totalOccurrences:452},{name:"Steepto",category:"ad",domains:["*.steepto.com"],totalExecutionTime:170,totalOccurrences:1},{name:"StellaService",category:"analytics",domains:["*.stellaservice.com"]},{name:"StickyADS.tv",category:"ad",domains:["*.stickyadstv.c\
om"],totalExecutionTime:2198555,totalOccurrences:1462},{name:"STINGRAY",company:"FlexOne",category:"ad",domains:["*.impact-ad.jp"],examples:["y.one.impact-ad.jp"],totalExecutionTime:1261721,totalOccurrences:9742},{name:"Storify",company:"Adobe Systems",category:"social",domains:["*.storify.com"]},{name:"Storm Tag Manager",company:"Rakuten",category:"tag-manager",domains:["*.stormcontainertag.com"]},{name:"Storygize",category:"ad",domains:["*.storygize.net"],examples:["www.storygize.net"],totalExecutionTime:60468,totalOccurrences:154},{name:"Strands",category:"utility",domains:["*.strands.com"]},{name:"StreamRail",category:"ad",domains:["*.streamrail.com","*.streamrail.net"]},{name:"StrikeAd",category:"ad",domains:["*.strikead.com"]},{name:"Struq",company:"Quantcast",category:"ad",domains:["*.struq.com"]},{name:"StrÃ¶er Digital Media",category:"ad",domains:["*.stroeerdigitalmedia.de"]},{name:"StumbleUpon",category:"content",domains:["*.stumble-upon.com","*.stumbleupon.com"],totalExecutionTime:18653,
totalOccurrences:17},{name:"Sub2 Technologies",category:"analytics",domains:["*.sub2tech.com"],totalExecutionTime:6667,totalOccurrences:31},{name:"SublimeSkinz",category:"ad",domains:["*.ayads.co"],totalExecutionTime:339456,totalOccurrences:772},{name:"Sumo Logic",category:"utility",domains:["*.sumologic.com"],totalExecutionTime:19322,totalOccurrences:9},{name:"Sunday Times Driving",category:"content",domains:["*.driving.co.uk"]},{name:"SundaySky",category:"ad",domains:["*.sundaysky.com","dds6m601du5ji.cloudfront.net"],totalExecutionTime:7435,totalOccurrences:10},{name:"Sunrise Integration",category:"utility",domains:["*.sunriseintegration.com"]},{name:"Supertool Network Technology",category:"analytics",domains:["*.miaozhen.com"],totalExecutionTime:6166,totalOccurrences:49},{name:"Survata",category:"analytics",domains:["*.survata.com"]},{name:"SurveyGizmo",category:"analytics",domains:["*.surveygizmo.eu"],examples:["www.surveygizmo.eu"]},{name:"SurveyMonkey",category:"analytics",domains:[
"*.surveymonkey.com"],totalExecutionTime:28632,totalOccurrences:250},{name:"Survicate",category:"analytics",domains:["*.survicate.com"],totalExecutionTime:933283,totalOccurrences:3008},{name:"Sweet Tooth",category:"ad",domains:["*.sweettooth.io"],totalExecutionTime:2673,totalOccurrences:41},{name:"Swiftype",category:"utility",domains:["*.swiftype.com","*.swiftypecdn.com"],totalExecutionTime:383638,totalOccurrences:982},{name:"Switch Concepts",category:"ad",domains:["*.switchadhub.com"]},{name:"SwitchAds",company:"Switch Concepts",category:"ad",domains:["*.switchads.com"]},{name:"Swogo",category:"analytics",domains:["*.xsellapp.com"]},{name:"Swoop",category:"ad",domains:["*.swoop.com"],totalExecutionTime:13511,totalOccurrences:75},{name:"Symantec",category:"utility",domains:["*.norton.com","*.symantec.com","*.symcb.com","*.symcd.com"],examples:["extended-validation-ssl.websecurity.symantec.com"],totalExecutionTime:184600,totalOccurrences:363},{name:"Syncapse",category:"social",domains:[
"*.clickable.net"]},{name:"Synergetic",category:"ad",domains:["*.synergetic.ag"]},{name:"Synthetix",category:"customer-success",domains:["*.syn-finity.com","*.synthetix-ec1.com","*.synthetix.com"],examples:["www.synthetix-ec1.com"],totalExecutionTime:6284,totalOccurrences:27},{name:"Syte",category:"other",domains:["*.syteapi.com"],examples:["cdn.syteapi.com"],totalExecutionTime:109749,totalOccurrences:106},{name:"TINT",category:"content",domains:["*.71n7.com","d33w9bm0n1egwm.cloudfront.net","d36hc0p18k1aoc.cloudfront.net","d3l7tj34e9fc43.cloudfront.net"],examples:["www.71n7.com"]},{name:"TNS (Kantar Group)",category:"analytics",domains:["*.tns-counter.ru"]},{name:"TRUSTe",category:"utility",domains:["*.truste.com"],totalExecutionTime:123425,totalOccurrences:613},{name:"TV Genius",company:"Ericcson Media Services",category:"content",domains:["*.tvgenius.net"]},{name:"TVSquared",category:"ad",domains:["*.tvsquared.com"],totalExecutionTime:548667,totalOccurrences:4082},{name:"TVTY",category:"\
ad",domains:["*.distribeo.com","*.ogigl.com"]},{name:"Tactics bvba",category:"hosting",domains:["*.influid.co"]},{name:"Tag Inspector",company:"InfoTrust",category:"analytics",domains:["d22xmn10vbouk4.cloudfront.net"],totalExecutionTime:51386,totalOccurrences:171},{name:"TagCommander",category:"tag-manager",domains:["*.commander1.com","*.tagcommander.com"],totalExecutionTime:448164,totalOccurrences:1509},{name:"Tagboard",category:"social",domains:["*.tagboard.com"],totalExecutionTime:106499,totalOccurrences:49},{name:"Taggstar",company:"Taggstar UK",category:"ad",domains:["*.taggstar.com"],totalExecutionTime:16168,totalOccurrences:68},{name:"Tail Target",company:"Tail",category:"ad",domains:["*.tailtarget.com"],totalExecutionTime:176612,totalOccurrences:873},{name:"Tailored",category:"other",domains:["d24qm7bu56swjs.cloudfront.net","dw3vahmen1rfy.cloudfront.net","*.tailored.to"]},{name:"Taleo Enterprise Cloud Service",company:"Oracle",category:"content",domains:["*.taleo.net"],totalExecutionTime:4178,
totalOccurrences:68},{name:"Talkable",category:"ad",domains:["*.talkable.com","d2jjzw81hqbuqv.cloudfront.net"],examples:["www.talkable.com"],totalExecutionTime:154019,totalOccurrences:601},{name:"TapSense",category:"ad",domains:["*.tapsense.com"]},{name:"Tapad",category:"ad",domains:["*.tapad.com"],totalExecutionTime:976,totalOccurrences:54},{name:"Teads",category:"ad",domains:["*.teads.tv"],totalExecutionTime:2295585,totalOccurrences:7565},{name:"Team Internet Tonic",company:"Team Internet",category:"ad",domains:["*.dntrax.com"]},{name:"TechTarget",category:"content",domains:["*.techtarget.com","*.ttgtmedia.com"],totalExecutionTime:11857,totalOccurrences:24},{name:"Technorati",company:"Synacor",category:"ad",domains:["*.technoratimedia.com"],totalExecutionTime:5382653,totalOccurrences:27186},{name:"Teedhaze",category:"content",domains:["*.fuel451.com"]},{name:"Tell Apart",category:"analytics",domains:["*.tellapart.com","*.tellaparts.com"]},{name:"Tencent",category:"content",domains:["\
*.qq.com","*.ywxi.net"],totalExecutionTime:2265040,totalOccurrences:8726},{name:"Thanx Media",category:"utility",domains:["*.hawksearch.info"]},{name:"Thawte",category:"utility",domains:["*.thawte.com"],examples:["ocsp.thawte.com","seal.thawte.com"],totalExecutionTime:307,totalOccurrences:1},{name:"Thesis",category:"analytics",homepage:"https://www.thesistesting.com/",domains:["*.ttsep.com"],examples:["thix.ttsep.com"]},{name:"The AA",category:"ad",domains:["*.adstheaa.com"]},{name:"The ADEX",category:"ad",domains:["*.theadex.com"],totalExecutionTime:13554,totalOccurrences:129},{name:"The Best Day",category:"social",domains:["*.thebestday.com"]},{name:"The Filter",company:"Exabre",category:"analytics",domains:["*.thefilter.com"]},{name:"The Guardian",category:"analytics",domains:["*.ophan.co.uk"]},{name:"The Hut Group",category:"content",domains:["*.thcdn.com"],totalExecutionTime:497181,totalOccurrences:281},{name:"The Numa Group",category:"other",domains:["*.hittail.com"]},{name:"The \
Publisher Desk",category:"ad",domains:["*.206ads.com","*.publisherdesk.com"]},{name:"The Sydney Morning Herald",company:"Fairfax Media",category:"content",domains:["*.smh.com.au"]},{name:"The Wall Street Jounal",category:"content",domains:["*.wsj.net"],totalExecutionTime:3036,totalOccurrences:5},{name:"The Wall Street Journal",category:"content",domains:["*.marketwatch.com"]},{name:"TheFind",category:"content",domains:["*.thefind.com"]},{name:"Thinglink",category:"utility",domains:["*.thinglink.com"],totalExecutionTime:2987,totalOccurrences:53},{name:"Thirdpresence",category:"ad",domains:["*.thirdpresence.com"]},{name:"ThreatMetrix",category:"utility",domains:["*.online-metrix.net"],totalExecutionTime:1901757,totalOccurrences:3530},{name:"Throtle",homepage:"https://throtle.io/",category:"analytics",domains:["*.thrtle.com","*.v12group.com"]},{name:"TicketMaster",category:"content",domains:["*.t-x.io","*.tmcs.net"]},{name:"TikTok",company:"ByteDance Ltd",homepage:"https://www.tiktok.com/\
en/",category:"social",domains:["*.tiktok.com","*.ipstatp.com"],examples:["analytics.tiktok.com","https://s0.ipstatp.com/ad/business/track-log.js"],totalExecutionTime:111182189,totalOccurrences:256224},{name:"Tidio Live Chat",company:"Tidio",homepage:"https://www.tidiochat.com/en/",category:"customer-success",domains:["*.tidiochat.com"],totalExecutionTime:26584634,totalOccurrences:24598},{name:"Tiledesk Live Chat",company:"Tiledesk SRL",homepage:"https://www.tiledesk.com/",category:"customer-success",domains:["*.tiledesk.com"],examples:["widget.tiledesk.com"],totalExecutionTime:253744,totalOccurrences:103},{name:"Time",category:"content",domains:["*.timeinc.net"]},{name:"Time2Perf",category:"ad",domains:["*.time2perf.com"]},{name:"TinyURL",category:"utility",domains:["*.tinyurl.com"]},{name:"Tivo",category:"analytics",domains:["*.rovicorp.com"]},{name:"Tom&Co",category:"hosting",domains:["*.tomandco.uk"]},{name:"Toms Native Ads",company:"Purch",category:"ad",domains:["*.natoms.com"]},{
name:"ToneMedia",category:"ad",domains:["*.clickfuse.com"]},{name:"Tonic",company:"Team Internet",category:"ad",domains:["*.dntx.com"]},{name:"Touch Commerce",category:"customer-success",domains:["*.inq.com","*.touchcommerce.com"],totalExecutionTime:12673,totalOccurrences:74},{name:"ToutApp",category:"ad",domains:["*.toutapp.com"]},{name:"TraceView",company:"Solarwinds",category:"analytics",domains:["*.tracelytics.com","d2gfdmu30u15x7.cloudfront.net"]},{name:"TrackJS",category:"analytics",domains:["*.trackjs.com","d2zah9y47r7bi2.cloudfront.net"],examples:["usage.trackjs.com"],totalExecutionTime:2112335,totalOccurrences:2268},{name:"Tradedoubler",category:"ad",domains:["*.pvnsolutions.com","*.tradedoubler.com"],totalExecutionTime:31870,totalOccurrences:165},{name:"Tradelab",category:"ad",domains:["*.tradelab.fr"],totalExecutionTime:5013,totalOccurrences:44},{name:"TrafficFactory",category:"ad",domains:["*.trafficfactory.biz"]},{name:"TrafficHunt",category:"ad",domains:["*.traffichunt.co\
m"]},{name:"TrafficStars",category:"ad",domains:["*.trafficstars.com","*.tsyndicate.com"],totalExecutionTime:3435101,totalOccurrences:7430},{name:"Transifex",category:"utility",domains:["*.transifex.com"],totalExecutionTime:193259,totalOccurrences:546},{name:"Travelex",category:"utility",domains:["*.travelex.net","*.travelex.co.uk"],examples:["api.travelex.net","travelmoney.travelex.co.uk"]},{name:"Travelocity Canada",company:"Travelocity",category:"content",domains:["*.travelocity.ca"],examples:["www.travelocity.ca"]},{name:"Travelocity USA",company:"Travelocity",category:"content",domains:["*.travelocity.com"],examples:["www.travelocity.com"]},{name:"Travelzoo",category:"content",domains:["*.travelzoo.com"]},{name:"Treasure Data",category:"analytics",domains:["*.treasuredata.com"],totalExecutionTime:1404314,totalOccurrences:14403},{name:"Tremor Video",category:"ad",domains:["*.tremorhub.com","*.videohub.tv"]},{name:"Trialfire",category:"analytics",domains:["*.trialfire.com"],totalExecutionTime:44579,
totalOccurrences:198},{name:"Tribal Fusion",company:"Exponential Interactive",category:"ad",domains:["*.tribalfusion.com"],totalExecutionTime:96569,totalOccurrences:158016},{name:"Triblio",category:"marketing",domains:["*.tribl.io"]},{name:"Triggered Messaging",company:"Fresh Relevance",category:"ad",domains:["*.triggeredmessaging.com"]},{name:"Trinity Mirror",category:"content",domains:["*.mirror.co.uk"],totalExecutionTime:13841,totalOccurrences:41},{name:"Trinity Mirror Digital Media",category:"social",domains:["*.tm-aws.com","*.icnetwork.co.uk"]},{name:"TripAdvisor",category:"content",domains:["*.jscache.com","*.tacdn.com","*.tamgrt.com","*.tripadvisor.com","*.viator.com","*.tripadvisor.co.uk"],examples:["www.jscache.com","www.tamgrt.com"],totalExecutionTime:749303,totalOccurrences:2354},{name:"TripleLift",category:"ad",domains:["*.3lift.com"],totalExecutionTime:8396,totalOccurrences:4812},{name:"Tru Optik",category:"ad",domains:["*.truoptik.com"]},{name:"TruConversion",category:"an\
alytics",domains:["*.truconversion.com"],totalExecutionTime:487670,totalOccurrences:1008},{name:"Trueffect",category:"marketing",domains:["*.adlegend.com"]},{name:"Truefit",category:"analytics",domains:["*.truefitcorp.com"],examples:["cdn.truefitcorp.com","fitrec.truefitcorp.com","sch-cdn.truefitcorp.com"],totalExecutionTime:4647,totalOccurrences:20},{name:"Trust Guard",category:"utility",domains:["*.trust-guard.com"],totalExecutionTime:3346,totalOccurrences:35},{name:"Trust Pilot",category:"analytics",domains:["*.trustpilot.com"],totalExecutionTime:14795265,totalOccurrences:54942},{name:"Amazon Trust Services",company:"Amazon",category:"utility",domains:["*.amazontrust.com","o.ss2.us"],examples:["ocsp.rootca1.amazontrust.com"],totalExecutionTime:107,totalOccurrences:1},{name:"Google Trust Services",company:"Google",category:"utility",domains:["*.pki.goog"],examples:["ocsp.pki.goog"],totalExecutionTime:18,totalOccurrences:1},{name:"Let's Encrypt",homepage:"https://letsencrypt.org/",category:"\
utility",domains:["*.letsencrypt.org"],examples:["ocsp.int-x3.letsencrypt.org"],totalExecutionTime:76,totalOccurrences:3},{name:"TrustX",category:"ad",domains:["*.trustx.org"]},{name:"Trusted Shops",category:"utility",domains:["*.trustedshops.com"],totalExecutionTime:7373870,totalOccurrences:17267},{name:"Trustev",company:"TransUnion",category:"utility",domains:["*.trustev.com"],totalExecutionTime:3272,totalOccurrences:22},{name:"Trustwave",category:"utility",domains:["*.trustwave.com"],totalExecutionTime:4600,totalOccurrences:7},{name:"Tryzens TradeState",company:"Tryzens",category:"analytics",domains:["*.tryzens-analytics.com"],totalExecutionTime:969,totalOccurrences:9},{name:"TubeMogul",category:"ad",domains:["*.tubemogul.com"],totalExecutionTime:24151,totalOccurrences:51},{name:"Turn",category:"ad",domains:["*.turn.com"],totalExecutionTime:4802,totalOccurrences:72},{name:"Tutorialize",category:"customer-success",domains:["*.tutorialize.me"]},{name:"Twenga",category:"content",domains:[
"*.twenga.fr","*.c4tw.net","*.twenga.co.uk"],examples:["tracker.twenga.co.uk"]},{name:"Twitframe",company:"Superblock",category:"utility",domains:["*.twitframe.com"]},{name:"Twitter Online Conversion Tracking",company:"Twitter",category:"ad",domains:["*.ads-twitter.com","analytics.twitter.com"],examples:["static.ads-twitter.com"],totalExecutionTime:6170585,totalOccurrences:73452},{name:"Twitter Short URL",company:"Twitter",category:"social",domains:["*.t.co"]},{name:"Twyn Group",category:"ad",domains:["*.twyn.com"]},{name:"Tynt",company:"33 Across",category:"ad",domains:["*.tynt.com"],totalExecutionTime:41643525,totalOccurrences:212415},{name:"Typepad",category:"hosting",domains:["*.typepad.com"],totalExecutionTime:834082,totalOccurrences:813},{name:"TyrbooBytes",category:"utility",domains:["*.turbobytes.net"]},{name:"UPS i-parcel",company:"UPS",category:"other",domains:["*.i-parcel.com"]},{name:"US Media Consulting",category:"ad",domains:["*.mediade.sk"]},{name:"Ubertags",category:"ta\
g-manager",domains:["*.ubertags.com"]},{name:"Umbel",category:"analytics",domains:["*.umbel.com"]},{name:"Unanimis",company:"Switch",category:"ad",domains:["*.unanimis.co.uk"]},{name:"Unbounce",category:"ad",domains:["*.ubembed.com","*.unbounce.com","d2xxq4ijfwetlm.cloudfront.net","d9hhrg4mnvzow.cloudfront.net"],totalExecutionTime:2902422,totalOccurrences:8808},{name:"Underdog Media",category:"ad",domains:["*.underdog.media","*.udmserve.net"],totalExecutionTime:524141,totalOccurrences:289},{name:"Understand Digital",category:"ad",domains:["*.redirecting2.net"]},{name:"Undertone",company:"Perion",category:"ad",domains:["*.legolas-media.com"],examples:["rt.legolas-media.com"]},{name:"Unidays",category:"ad",domains:["*.myunidays.com","*.unidays.world"]},{name:"Uniqodo",category:"ad",domains:["*.uniqodo.com"]},{name:"Unite",category:"ad",domains:["*.uadx.com"]},{name:"United Card Services",category:"utility",domains:["*.ucs.su"]},{name:"United Internet",category:"hosting",domains:["*.uicdn\
.com"],totalExecutionTime:14225,totalOccurrences:75},{name:"United Internet Media",category:"ad",domains:["*.ui-portal.de"],totalExecutionTime:20307,totalOccurrences:59},{name:"United Internet Media AG",category:"hosting",domains:["*.tifbs.net","*.uicdn.net","*.uimserv.net"],totalExecutionTime:1737,totalOccurrences:48},{name:"Unknown",category:"other",domains:[]},{name:"Unruly Media",category:"ad",domains:["*.unrulymedia.com"],totalExecutionTime:679,totalOccurrences:1789},{name:"UpBuild",category:"ad",domains:["*.upbuild.io"],examples:["www.upbuild.io"]},{name:"UpSellit",category:"analytics",domains:["*.upsellit.com"],examples:["www.upsellit.com"],totalExecutionTime:289920,totalOccurrences:1013},{name:"Upland Software",category:"hosting",domains:["*.clickability.com"]},{name:"Airship",category:"marketing",domains:["*.urbanairship.com","*.aswpsdkus.com"],totalExecutionTime:4666,totalOccurrences:37},{name:"UsabilityTools",category:"analytics",domains:["*.usabilitytools.com"]},{name:"Usab\
lenet.net",category:"utility",domains:["*.usablenet.net"]},{name:"Use It Better",category:"analytics",domains:["*.useitbetter.com"]},{name:"User Replay",category:"analytics",domains:["*.userreplay.net"]},{name:"UserReport",category:"analytics",domains:["*.userreport.com"],totalExecutionTime:133479,totalOccurrences:476},{name:"Userneeds",category:"analytics",domains:["*.userneeds.dk"]},{name:"Userzoom",category:"analytics",domains:["*.userzoom.com"],totalExecutionTime:5093,totalOccurrences:4},{name:"V12 Retail Finance",category:"utility",domains:["*.v12finance.com"]},{name:"Vacaciones eDreams",category:"content",domains:["*.odistatic.net"]},{name:"Varick Media Management",category:"ad",domains:["*.vmmpxl.com"]},{name:"Vdopia Chocolate",company:"Vdopia",category:"ad",domains:["*.vdopia.com"]},{name:"Ve",company:"Ve",homepage:"https://www.ve.com/",category:"marketing",domains:["*.veinteractive.com","*.ve.com"]},{name:"Ve Interactive",company:"Ve",category:"ad",domains:["*.vepxl1.net","*.a\
dgenie.co.uk"]},{name:"Vee24",category:"customer-success",domains:["*.vee24.com"],totalExecutionTime:20941,totalOccurrences:38},{name:"Veeseo",category:"content",domains:["*.veeseo.com"]},{name:"Venatus Media",category:"marketing",domains:["*.alcvid.com","*.venatusmedia.com"]},{name:"Veoxa",category:"ad",domains:["*.veoxa.com"]},{name:"Vergic AB",category:"customer-success",domains:["*.psplugin.com"],totalExecutionTime:48232,totalOccurrences:71},{name:"Vergic Engage Platform",company:"Vergic",category:"customer-success",domains:["*.vergic.com"],totalExecutionTime:41524,totalOccurrences:57},{name:"Verisign (Symantec)",category:"utility",domains:["*.verisign.com"]},{name:"Verizon",category:"utility",domains:["*.public-trust.com"],examples:["www.public-trust.com"]},{name:"Verizon Digital Media CDN",homepage:"https://www.verizondigitalmedia.com/",category:"cdn",domains:["*.edgecastcdn.net","*.edgecastdns.net"],totalExecutionTime:98698,totalOccurrences:108},{name:"Verizon Uplynk",company:"V\
erizon",category:"content",domains:["*.uplynk.com"],totalExecutionTime:572,totalOccurrences:4},{name:"Vero",company:"Semblance",category:"ad",domains:["*.getvero.com","d3qxef4rp70elm.cloudfront.net"],totalExecutionTime:613,totalOccurrences:10},{name:"VertaMedia",category:"ad",domains:["*.vertamedia.com"]},{name:"Vertical Mass",category:"ad",domains:["*.vmweb.net"]},{name:"Vestorly",category:"ad",domains:["*.oodalab.com"]},{name:"Vextras",category:"other",domains:["*.vextras.com"],totalExecutionTime:4484,totalOccurrences:42},{name:"Viacom",category:"content",domains:["*.mtvnservices.com"],totalExecutionTime:15501,totalOccurrences:44},{name:"Vibrant Media",category:"ad",domains:["*.intellitxt.com","*.picadmedia.com"]},{name:"VidPulse",category:"analytics",domains:["*.vidpulse.com"]},{name:"Video Media Groep",category:"ad",domains:["*.vmg.host","*.inpagevideo.nl"]},{name:"VideoHub",company:"Tremor Video",category:"ad",domains:["*.scanscout.com"],examples:["dt.scanscout.com"]},{name:"Video\
logy",category:"ad",domains:["*.tidaltv.com"]},{name:"Vidible",category:"ad",domains:["*.vidible.tv"]},{name:"VigLink",category:"ad",domains:["*.viglink.com"],totalExecutionTime:3670311,totalOccurrences:6219},{name:"Vindico",company:"Viant",category:"ad",domains:["*.vindicosuite.com"]},{name:"Viocorp International",category:"content",domains:["*.vioapi.com"]},{name:"ViralNinjas",category:"ad",domains:["*.viralninjas.com"]},{name:"Virool",category:"ad",domains:["*.virool.com"]},{name:"Virtual Earth",company:"Microsoft",category:"utility",domains:["*.virtualearth.net"],totalExecutionTime:54315,totalOccurrences:312},{name:"Visely",company:"Visely",category:"other",homepage:"https://visely.io/",domains:["*.visely.io"]},{name:"VisScore",category:"analytics",domains:["*.visscore.com","d2hkbi3gan6yg6.cloudfront.net"]},{name:"Visible Measures",category:"ad",domains:["*.visiblemeasures.com"],totalExecutionTime:11,totalOccurrences:13},{name:"Visual Studio",company:"Microsoft",category:"utility",
domains:["*.visualstudio.com"],totalExecutionTime:3464,totalOccurrences:3},{name:"VisualDNA",category:"ad",domains:["*.visualdna.com"]},{name:"VisualVisitor",category:"ad",domains:["*.id-visitors.com"],examples:["frontend.id-visitors.com"],totalExecutionTime:871,totalOccurrences:14},{name:"Vivocha S.p.A",category:"customer-success",domains:["*.vivocha.com"],totalExecutionTime:65471,totalOccurrences:38},{name:"Vizu (Nielsen)",category:"analytics",domains:["*.vizu.com"]},{name:"Vizury",category:"ad",domains:["*.vizury.com"],totalExecutionTime:1296,totalOccurrences:20},{name:"VoiceFive",category:"analytics",domains:["*.voicefive.com"]},{name:"Volvelle",company:"Optomaton",category:"ad",domains:["*.volvelle.tech"]},{name:"VouchedFor",category:"analytics",domains:["*.vouchedfor.co.uk"],totalExecutionTime:30557,totalOccurrences:18},{name:"WARPCACHE",category:"utility",domains:["*.warpcache.net"]},{name:"WISHLIST",company:"Shopapps",category:"social",domains:["*.shopapps.in"]},{name:"WP Engin\
e",category:"hosting",domains:["*.wpengine.com"],totalExecutionTime:651034,totalOccurrences:341},{name:"WalkMe",category:"customer-success",domains:["*.walkme.com"],totalExecutionTime:636459,totalOccurrences:495},{name:"Watching That",category:"other",domains:["*.watchingthat.com"]},{name:"Wayfair",category:"analytics",domains:["*.wayfair.com"],examples:["t.wayfair.com"]},{name:"Web CEO",category:"other",domains:["*.websiteceo.com"],examples:["www.websiteceo.com"]},{name:"Web Dissector",company:"Beijing Gridsum Technologies",category:"analytics",domains:["*.gridsumdissector.com","*.webdissector.com"],examples:["www.webdissector.com"]},{name:"Web Forensics",category:"analytics",domains:["*.webforensics.co.uk"]},{name:"Web Security and Performance",company:"NCC Group",category:"utility",domains:["*.nccgroup.trust"]},{name:"WebEngage",category:"customer-success",domains:["*.webengage.co","*.webengage.com","d23nd6ymopvz52.cloudfront.net","d3701cc9l7v9a6.cloudfront.net"],totalExecutionTime:789975,
totalOccurrences:2283},{name:"WebInsight",company:"dotMailer",category:"analytics",domains:["*.trackedlink.net","*.trackedweb.net"],totalExecutionTime:21241,totalOccurrences:277},{name:"WebPageOne Solutions",category:"other",domains:["*.webpageone.com"]},{name:"WebSpectator",category:"ad",domains:["*.webspectator.com"]},{name:"WebTuna",company:"Application Performance",category:"analytics",domains:["*.webtuna.com"]},{name:"WebVideoCore",company:"StreamingVideoProvider",category:"content",domains:["*.webvideocore.net"],totalExecutionTime:74152,totalOccurrences:38},{name:"WebWombat",category:"utility",domains:["*.ic.com.au"]},{name:"Webcollage",category:"customer-success",domains:["*.webcollage.net"]},{name:"Webcore",category:"ad",domains:["*.onefeed.co.uk"]},{name:"Webkul",company:"Webkul Software",category:"utility",domains:["*.webkul.com"],totalExecutionTime:172788,totalOccurrences:490},{name:"Webmarked",category:"utility",domains:["*.webmarked.net"],totalExecutionTime:72467,totalOccurrences:1077},
{name:"Weborama",category:"ad",domains:["*.weborama.com","*.weborama.fr"],totalExecutionTime:45883,totalOccurrences:372},{name:"WebpageFX",category:"ad",domains:["*.leadmanagerfx.com"],totalExecutionTime:241118,totalOccurrences:946},{name:"Webphone",company:"IP WEB SERVICES",category:"customer-success",domains:["*.webphone.net"],totalExecutionTime:4605,totalOccurrences:20},{name:"Webselect selectcommerce",company:"Webselect Internet",category:"hosting",domains:["*.webselect.net"]},{name:"Webthinking",category:"hosting",domains:["*.webthinking.co.uk"]},{name:"Webtrekk",category:"analytics",domains:["*.wbtrk.net","*.webtrekk-asia.net","*.webtrekk.net","*.wt-eu02.net","*.wt-safetag.com"],totalExecutionTime:85572,totalOccurrences:428},{name:"Webtrends",category:"analytics",domains:["*.webtrends.com","*.webtrendslive.com","d1q62gfb8siqnm.cloudfront.net"],totalExecutionTime:1437,totalOccurrences:6},{name:"Webtype",category:"cdn",domains:["*.webtype.com"],totalExecutionTime:0,totalOccurrences:1},
{name:"White Ops",category:"utility",domains:["*.acexedge.com","*.tagsrvcs.com"]},{name:"Whitespace",category:"ad",domains:["*.whitespacers.com"]},{name:"WhosOn Live Chat Software",category:"customer-success",domains:["*.whoson.com"],totalExecutionTime:20753,totalOccurrences:112},{name:"Wibbitz",category:"other",domains:["*.wibbitz.com"]},{name:"Wide Area Communications",category:"hosting",domains:["*.widearea.co.uk"]},{name:"WideOrbit",category:"marketing",domains:["*.admaym.com"]},{name:"William Reed",category:"content",domains:["*.wrbm.com"],totalExecutionTime:50,totalOccurrences:1},{name:"WillyFogg.com",category:"content",domains:["*.willyfogg.com"]},{name:"Windows",company:"Microsoft",category:"utility",domains:["*.windowsupdate.com"],examples:["ctldl.windowsupdate.com"]},{name:"WisePops",category:"utility",domains:["*.wisepops.com"],totalExecutionTime:2631328,totalOccurrences:1950},{name:"Wishlist King",company:"Appmate",category:"other",homepage:"https://appmate.io/",domains:["*\
.appmate.io"],examples:["api.appmate.io"],totalExecutionTime:130543,totalOccurrences:235},{name:"Wishpond Technologies",category:"marketing",domains:["*.wishpond.com","*.wishpond.net"],totalExecutionTime:771888,totalOccurrences:1691},{name:"WizRocket Technologies",category:"analytics",domains:["*.wzrkt.com"],totalExecutionTime:138,totalOccurrences:2},{name:"Woopra",category:"analytics",domains:["*.woopra.com"],totalExecutionTime:120767,totalOccurrences:1366},{name:"Woosmap",category:"utility",domains:["*.woosmap.com"],totalExecutionTime:58710,totalOccurrences:139},{name:"WorkCast",category:"hosting",domains:["*.workcast.net"]},{name:"World News Media",category:"content",domains:["*.wnmedia.co.uk"]},{name:"Worldpay",category:"utility",domains:["*.worldpay.com"],totalExecutionTime:25852,totalOccurrences:18},{name:"Wow Analytics",category:"analytics",domains:["*.wowanalytics.co.uk"],totalExecutionTime:11162,totalOccurrences:73},{name:"Wowcher",category:"ad",domains:["*.wowcher.co.uk"]},{name:"\
Wufoo",category:"utility",domains:["*.wufoo.com"],totalExecutionTime:381206,totalOccurrences:1507},{name:"Wunderkind",category:"marketing",homepage:"https://www.wunderkind.co/",domains:["*.bounceexchange.com","*.bouncex.net","*.wknd.ai","*.cdnbasket.net","*.cdnwidget.com"],examples:["events.bouncex.net","tag.wknd.ai","data.cdnbasket.net","pix.cdnwidget.com"],totalExecutionTime:2016506,totalOccurrences:1278},{name:"Wyng",category:"ad",domains:["*.offerpop.com"]},{name:"XMLSHOP",category:"hosting",domains:["*.xmlshop.biz"]},{name:"XiTi",company:"AT Internet",category:"analytics",domains:["*.xiti.com","*.aticdn.net"],homepage:"https://www.atinternet.com/en/",examples:["tag.aticdn.net/123456789/smarttag.js"],totalExecutionTime:918257,totalOccurrences:8483},{name:"YUDU",category:"content",domains:["*.yudu.com"]},{name:"Yahoo! Ad Exchange",company:"Yahoo!",category:"ad",domains:["*.yieldmanager.com","*.browsiprod.com"],examples:["yield-manager.browsiprod.com"],totalExecutionTime:12720569,totalOccurrences:4994},
{name:"Yahoo! JAPAN Ads",company:"Yahoo! JAPAN",category:"ad",homepage:"https://marketing.yahoo.co.jp/service/yahooads/",domains:["yads.c.yimg.jp","s.yimg.jp","b92.yahoo.co.jp"],examples:["yads.c.yimg.jp/js/yads-async.js","s.yimg.jp/images/listing/tool/yads/ydn/creative/video/ytop_video_timeline_sp.min.js","b92.yahoo.co.jp/js/s_retargeting.js"],totalExecutionTime:6236624,totalOccurrences:37464},{name:"Yahoo! Tag Manager",company:"Yahoo! JAPAN",category:"tag-manager",homepage:"https://marketing.yahoo.co.jp/service/tagmanager/",domains:["*.yjtag.jp"],examples:["s.yjtag.jp/tag.js"]},{name:"Yahoo! Small Business",company:"Yahoo!",category:"hosting",domains:["*.aabacosmallbusiness.com"]},{name:"Yellow Robot",category:"ad",domains:["*.backinstock.org"],totalExecutionTime:15268,totalOccurrences:508},{name:"YieldPartners",category:"ad",domains:["*.yieldpartners.com"]},{name:"Yieldbot",category:"ad",domains:["*.yldbt.com"]},{name:"Yieldify",category:"ad",domains:["*.yieldify.com","*.yieldifylab\
s.com","d33wq5gej88ld6.cloudfront.net","dwmvwp56lzq5t.cloudfront.net"],examples:["geo.yieldifylabs.com"],totalExecutionTime:513761,totalOccurrences:168},{name:"Yieldlab",category:"ad",domains:["*.yieldlab.net"],totalExecutionTime:54,totalOccurrences:8},{name:"Yieldmo",category:"ad",domains:["*.yieldmo.com"],totalExecutionTime:51128,totalOccurrences:2375},{name:"Yieldr",category:"ad",domains:["*.254a.com"]},{name:"Yo",category:"utility",domains:["*.yopify.com"]},{name:"YoYo",category:"utility",domains:["*.goadservices.com"]},{name:"Yotpo",homepage:"https://www.yotpo.com/",category:"marketing",domains:["*.yotpo.com","*.swellrewards.com"],totalExecutionTime:16919447,totalOccurrences:26094},{name:"Yottaa",category:"hosting",domains:["*.yottaa.com","*.yottaa.net"],totalExecutionTime:798791,totalOccurrences:753},{name:"YourAmigo",category:"utility",domains:["*.youramigo.com"]},{name:"YuMe",category:"ad",domains:["*.yume.com","*.yumenetworks.com"],examples:["cks.yumenetworks.com"]},{name:"Yum\
mley",category:"other",domains:["*.yummly.com"],totalExecutionTime:14163,totalOccurrences:6},{name:"ZEDO",category:"ad",domains:["*.zedo.com"]},{name:"Zafu",category:"analytics",domains:["*.zafu.com"]},{name:"Zaius",category:"ad",domains:["*.zaius.com"]},{name:"Zamplus ad",category:"ad",domains:["*.zampda.net"]},{name:"Zanox",category:"ad",domains:["*.zanox.com","*.zanox.ws"]},{name:"Zapper",category:"utility",domains:["*.zapper.com"]},{name:"Zarget",category:"analytics",domains:["*.zarget.com"]},{name:"Zemanta",category:"ad",domains:["*.zemanta.com"],totalExecutionTime:2735,totalOccurrences:28},{name:"Zen Internet",category:"other",domains:["*.zyen.com"]},{name:"Zenovia Digital Exchange",category:"ad",domains:["*.rhythmxchange.com","*.zenoviaexchange.com"]},{name:"ZergNet",category:"content",domains:["*.zergnet.com"],totalExecutionTime:186,totalOccurrences:4},{name:"Zerogrey",category:"hosting",domains:["*.zerogrey.com"]},{name:"Ziff Davis Tech",category:"ad",domains:["*.adziff.com","\
*.zdbb.net"],totalExecutionTime:30706,totalOccurrences:93},{name:"Zmags",category:"marketing",domains:["*.zmags.com"],totalExecutionTime:262514,totalOccurrences:119},{name:"Zolando",category:"content",domains:["*.ztat.net"],totalExecutionTime:229623,totalOccurrences:48},{name:"Zoover",category:"analytics",domains:["*.zoover.nl","*.zoover.co.uk"],totalExecutionTime:9173,totalOccurrences:2},{name:"Zopim",category:"customer-success",domains:["*.zopim.io"]},{name:"[24]7",category:"customer-success",domains:["*.247-inc.net","*.247inc.net","d1af033869koo7.cloudfront.net"],totalExecutionTime:24965,totalOccurrences:20},{name:"adKernel",category:"ad",domains:["*.adkernel.com"],totalExecutionTime:19140,totalOccurrences:9621},{name:"adMarketplace",company:"AMPexchange",category:"ad",domains:["*.ampxchange.com","*.admarketplace.net"]},{name:"addtocalendar",category:"utility",domains:["*.addtocalendar.com"]},{name:"adnanny",category:"ad",domains:["*.adserver01.de"],totalExecutionTime:2,totalOccurrences:6},
{name:"affilinet",category:"ad",domains:["*.reussissonsensemble.fr","*.successfultogether.co.uk"]},{name:"audioBoom",category:"social",domains:["*.audioboom.com","*.audioboo.fm"],totalExecutionTime:136729,totalOccurrences:57},{name:"bPay by Barclaycard",company:"Barclays Bank",category:"utility",domains:["*.bpay.co.uk"]},{name:"bRealTime",category:"ad",domains:["*.brealtime.com"],totalExecutionTime:4479,totalOccurrences:76},{name:"bd4travel",category:"analytics",domains:["*.bd4travel.com"]},{name:"bizinformation-VOID",company:"bizinformation",category:"analytics",domains:["*.bizinformation.org"]},{name:"carrot",category:"social",domains:["*.sharebutton.co"]},{name:"cloudIQ",category:"analytics",domains:["*.cloud-iq.com"]},{name:"comScore",category:"analytics",domains:["*.adxpose.com","*.comscore.com","*.sitestat.com","*.zqtk.net"],totalExecutionTime:4938,totalOccurrences:3},{name:"content.ad",category:"ad",domains:["*.content.ad"]},{name:"d3 Media",company:"d3 Technologies",category:"o\
ther",domains:["*.d3sv.net"]},{name:"dexiMEDIA",category:"ad",domains:["*.deximedia.com"]},{name:"dianomi",category:"ad",domains:["*.dianomi.com","*.dianomioffers.co.uk"],totalExecutionTime:52461,totalOccurrences:86},{name:"donReach",category:"social",domains:["*.donreach.com"]},{name:"dotMailer",category:"ad",domains:["*.dmtrk.com","*.dotmailer.com","*.emlfiles.com"]},{name:"dotMailer Surveys",company:"dotMailer",category:"analytics",domains:["*.dotmailer-surveys.com"]},{name:"dstillery",category:"ad",domains:["*.dstillery.com","*.media6degrees.com"],totalExecutionTime:1160,totalOccurrences:12},{name:"eBay",category:"ad",domains:["*.ebay.com","*.ebayimg.com","*.fetchback.com"],totalExecutionTime:600826,totalOccurrences:1026},{name:"eBay Enterprise",category:"hosting",domains:["*.csdata1.com","*.gsipartners.com"]},{name:"eBuzzing",company:"Teads Managed Services",category:"ad",domains:["*.ebz.io"]},{name:"eDigital Research",category:"customer-success",domains:["*.edigitalresearch.com",
"*.edigitalsurvey.com","*.edrcdn.com","*.ecustomeropinions.com"]},{name:"eGain",category:"analytics",domains:["*.analytics-egain.com","*.egain.com"],totalExecutionTime:8418,totalOccurrences:74},{name:"eHost",category:"hosting",domains:["*.ehosts.net"]},{name:"eKomi",category:"analytics",domains:["*.ekomi.com","*.ekomi.de"],totalExecutionTime:51192,totalOccurrences:17},{name:"eWAY",company:"Web Active Pty",category:"utility",domains:["*.eway.com.au"],examples:["www.eway.com.au"],totalExecutionTime:11094,totalOccurrences:1},{name:"eXTReMe digital",category:"analytics",domains:["*.extreme-dm.com"],totalExecutionTime:3491,totalOccurrences:78},{name:"eXelate",category:"ad",domains:["*.exelator.com"],totalExecutionTime:17905,totalOccurrences:246},{name:"ecommercefeed.net",category:"marketing",domains:["*.ecommercefeed.net"]},{name:"engage:BDR",category:"ad",domains:["*.bnmla.com","*.ebdr3.com"]},{name:"epago",category:"ad",domains:["*.adaos-ads.net"]},{name:"epoq internet services",category:"\
analytics",domains:["*.epoq.de"],totalExecutionTime:84260,totalOccurrences:122},{name:"etouches",category:"hosting",domains:["*.etouches.com"],examples:["www.etouches.com"]},{name:"etracker",category:"analytics",domains:["*.etracker.com","*.etracker.de"],examples:["www.etracker.com"],totalExecutionTime:2076262,totalOccurrences:5626},{name:"everestads.com",category:"content",domains:["*.verestads.net"]},{name:"exebid.DCA",company:"Data-Centric Alliance",category:"ad",domains:["*.exe.bid"]},{name:"eyeReturn Marketing",category:"marketing",domains:["*.eyereturn.com"]},{name:"feedoptimise",category:"hosting",domains:["*.feedoptimise.com","d1w78njrm56n7g.cloudfront.net"],totalExecutionTime:126,totalOccurrences:2},{name:"fifty-five",category:"ad",domains:["*.55labs.com"]},{name:"fluct",category:"ad",domains:["*.adingo.jp"],totalExecutionTime:5114249,totalOccurrences:12890},{name:"freegeoip.net",company:"(community-funded)",category:"utility",domains:["*.freegeoip.net"]},{name:"freewheel.tv",
category:"content",domains:["*.fwmrm.net"],totalExecutionTime:3847,totalOccurrences:42},{name:"gnatta",category:"customer-success",domains:["*.gnatta.com"]},{name:"home.pl",category:"hosting",domains:["*.nscontext.eu"]},{name:"hyfn",category:"ad",domains:["*.hyfn.com"]},{name:"iAdvize SAS",category:"customer-success",domains:["*.iadvize.com"],totalExecutionTime:286995,totalOccurrences:844},{name:"iBillboard",category:"ad",domains:["*.ibillboard.com"],totalExecutionTime:303,totalOccurrences:2},{name:"iCrossing",category:"ad",domains:["*.ic-live.com"]},{name:"iFactory",company:"RDW Group",category:"hosting",domains:["*.ifactory.com"]},{name:"iGoDigital",category:"analytics",domains:["*.igodigital.com"],totalExecutionTime:1800,totalOccurrences:21},{name:"iJento",company:"Fopsha",category:"ad",domains:["*.ijento.com"]},{name:"iPage",category:"hosting",domains:["*.ipage.com"],examples:["www.ipage.com"],totalExecutionTime:490,totalOccurrences:6},{name:"iPerceptions",category:"customer-succes\
s",domains:["*.iperceptions.com"],totalExecutionTime:626044,totalOccurrences:4662},{name:"iTunes",company:"Apple",category:"content",domains:["*.mzstatic.com"]},{name:"imgix",company:"Zebrafish Labs",category:"utility",domains:["*.imgix.net"],totalExecutionTime:40073,totalOccurrences:98},{name:"infogr.am",category:"utility",domains:["*.infogr.am","*.jifo.co"],totalExecutionTime:2008949,totalOccurrences:233},{name:"iotec",category:"analytics",domains:["*.dsp.io"]},{name:"iovation",category:"utility",domains:["*.iesnare.com"],totalExecutionTime:270232,totalOccurrences:2159},{name:"ipinfo.io",category:"utility",domains:["*.ipinfo.io"]},{name:"issuu",category:"content",domains:["*.issuu.com","*.isu.pub"],totalExecutionTime:5607951,totalOccurrences:2714},{name:"iubenda",category:"utility",domains:["*.iubenda.com"],examples:["www.iubenda.com"],totalExecutionTime:69911073,totalOccurrences:97074},{name:"j2 Cloud Services",category:"ad",domains:["*.campaigner.com"],totalExecutionTime:12708,totalOccurrences:28},
{name:"jsonip.com",category:"analytics",domains:["*.jsonip.com"]},{name:"linkpulse",category:"analytics",domains:["*.lp4.io"]},{name:"loGo_net",category:"analytics",domains:["*.logo-net.co.uk"]},{name:"mainADV",category:"ad",domains:["*.httptrack.com","*.solocpm.com"]},{name:"mbr targeting",category:"ad",domains:["*.m6r.eu"],totalExecutionTime:17,totalOccurrences:1},{name:"media.ventive",category:"ad",domains:["*.contentspread.net"]},{name:"metrigo",category:"ad",domains:["*.metrigo.com"]},{name:"minicabit.com",category:"content",domains:["*.minicabit.com"]},{name:"mobiManage",category:"hosting",domains:["*.mobimanage.com"]},{name:"moving-pictures",category:"other",domains:["*.moving-pictures.biz","*.v6-moving-pictures.com","*.vtstat.com","*.moving-pictures.de"]},{name:"my6sense",category:"ad",domains:["*.mynativeplatform.com"]},{name:"myThings",category:"ad",domains:["*.mythings.com","*.mythingsmedia.net"]},{name:"mymovies",category:"content",domains:["*.mymovies.net"]},{name:"nRelate\
-VOID",company:"nRelate",category:"content",domains:["*.nrelate.com"]},{name:"nToklo",category:"analytics",domains:["*.ntoklo.com"]},{name:"neXeps",category:"ad",domains:["*.nexeps.com"]},{name:"ninemsn Pty.",category:"utility",domains:["*.ninemsn.com.au"]},{name:"nugg.ad",category:"ad",domains:["*.nuggad.net"]},{name:"numero interactive",company:"numero",category:"ad",domains:["*.numerointeractive.com"]},{name:"optMD",company:"Optimax Media Delivery",category:"ad",domains:["*.optmd.com"]},{name:"otracking.com",category:"analytics",domains:["*.otracking.com"]},{name:"paysafecard",company:"Paysafe Group",category:"utility",domains:["*.paysafecard.com"]},{name:"piano",category:"ad",domains:["*.npttech.com","*.tinypass.com"],examples:["www.npttech.com"],totalExecutionTime:1016108,totalOccurrences:1146},{name:"piclike",category:"ad",domains:["*.piclike.us"]},{name:"placehold.it",category:"utility",domains:["*.placehold.it"]},{name:"plista",category:"ad",domains:["*.plista.com"]},{name:"pre\
bid.org",category:"utility",domains:["*.prebid.org"],totalExecutionTime:462,totalOccurrences:1},{name:"reEmbed",category:"other",domains:["*.reembed.com"]},{name:"reddit",category:"social",domains:["*.reddit.com","*.redditstatic.com"],examples:["www.redditstatic.com"],totalExecutionTime:4113522,totalOccurrences:18483},{name:"rewardStyle.com",category:"ad",domains:["*.rewardstyle.com"],totalExecutionTime:280999,totalOccurrences:1491},{name:"rss2json",category:"utility",domains:["*.rss2json.com"],totalExecutionTime:1380,totalOccurrences:18},{name:"sage Pay",company:"Sage Pay Europe",category:"utility",domains:["*.sagepay.com"],totalExecutionTime:4481,totalOccurrences:40},{name:"section.io",category:"utility",domains:["*.squixa.net"],examples:["beacon.squixa.net","s.squixa.net"]},{name:"smartclip",category:"ad",domains:["*.smartclip.net"],totalExecutionTime:41051,totalOccurrences:21},{name:"sovrn",category:"ad",domains:["*.lijit.com"],totalExecutionTime:2389059,totalOccurrences:27306},{name:"\
stackpile.io",company:"StackPile",category:"tag-manager",domains:["*.stackpile.io"]},{name:"template-help.com",category:"hosting",domains:["*.template-help.com"],totalExecutionTime:16016,totalOccurrences:13},{name:"test",company:"test only",category:"other",domains:["*.testtesttest.com"]},{name:"trueAnthem",category:"social",domains:["*.tru.am"]},{name:"tweetmeme-VOID",company:"tweetmeme",category:"analytics",domains:["*.tweetmeme.com"]},{name:"uLogin",category:"other",domains:["*.ulogin.ru"]},{name:"uLogix",category:"ad",domains:["*.ulogix.ru"]},{name:"ucfunnel ucX",company:"ucfunnel",category:"ad",domains:["*.aralego.com"],totalExecutionTime:1469345,totalOccurrences:7945},{name:"up-value",category:"ad",domains:["*.up-value.de"]},{name:"wywy",category:"ad",domains:["*.wywy.com","*.wywyuserservice.com"]},{name:"CDK Dealer Management",company:"CDK Global",homepage:"https://www.cdkglobal.com/us",category:"hosting",domains:["*.assets-cdk.com"],examples:["media-cf.assets-cdk.com"],totalExecutionTime:1052,
totalOccurrences:4},{name:"fam",company:"Fing Co Ltd.",homepage:"http://admin.fam-ad.com/report/",category:"ad",domains:["*.fam-ad.com"],examples:["img.fam-ad.com"],totalExecutionTime:1816,totalOccurrences:10},{name:"zypmedia",category:"ad",domains:["*.extend.tv"]},{name:"codigo",homepage:"https://www.codigo.se",category:"analytics",domains:["*.codigo.se"],examples:["analytics.codigo.se"],totalExecutionTime:469,totalOccurrences:10},{name:"Playground",homepage:"https://playground.xyz",category:"ad",domains:["*.playground.xyz"],examples:["ads.playground.xyz"],totalExecutionTime:2767,totalOccurrences:26},{name:"RAM",homepage:"https://www2.rampanel.com/",category:"analytics",domains:["*.rampanel.com"],examples:["inviso.rampanel.com"],totalExecutionTime:15413,totalOccurrences:1},{name:"Adition",homepage:"https://www.adition.com",category:"ad",domains:["*.adition.com"],examples:["dsp.adfarm1.adition.com"],totalExecutionTime:74399,totalOccurrences:491},{name:"Widespace",homepage:"https://www.\
widespace.com",category:"ad",domains:["*.widespace.com"],examples:["sync.widespace.com"]},{name:"Colpirio",homepage:"https://www.widespace.com",category:"analytics",domains:["*.colpirio.com"],examples:["proxy-tracker.colpirio.com"]},{name:"Brandmetrics",homepage:"https://www.brandmetrics.com",category:"analytics",domains:["*.brandmetrics.com"],examples:["collector.brandmetrics.com","cdn.brandmetrics.com"],totalExecutionTime:3689914,totalOccurrences:30850},{name:"EasyAd",homepage:"https://web.easy-ads.com/",category:"ad",domains:["*.easy-ads.com"],examples:["ads.easy-ads.com"]},{name:"Glimr",homepage:"https://glimr.io/",category:"analytics",domains:["*.glimr.io"],examples:["pixel.glimr.io"]},{name:"Webtreck",homepage:"https://www.webtrekk.com/en/home/",category:"analytics",domains:["*.wcfbc.net"],examples:["fbc.wcfbc.net"]},{name:"DigiTrust",homepage:"http://www.digitru.st/",category:"analytics",domains:["*.digitru.st"],examples:["cdn.digitru.st"]},{name:"Kantar Sifo",homepage:"https://\
www.kantarsifo.se",category:"analytics",domains:["*.research-int.se"],examples:["trafficgateway.research-int.se"],totalExecutionTime:375,totalOccurrences:1},{name:"Concert",homepage:"https://concert.io/",category:"ad",domains:["*.concert.io"],examples:["cdn.concert.io"],totalExecutionTime:317481,totalOccurrences:336},{name:"Emerse",homepage:"https://www.emerse.com/",category:"ad",domains:["*.emerse.com"],examples:["tracking.emerse.com"],totalExecutionTime:2872,totalOccurrences:13},{name:"Iterate",homepage:"https://iteratehq.com/",category:"analytics",domains:["*.iteratehq.com"],totalExecutionTime:8751,totalOccurrences:72},{name:"Cookiebot",homepage:"https://www.cookiebot.com/",category:"utility",domains:["*.cookiebot.com"],examples:["consent.cookiebot.com"],totalExecutionTime:64865019,totalOccurrences:187732},{name:"Netlify",homepage:"https://www.netlify.com/",category:"utility",domains:["*.netlify.com","*.netlifyusercontent.com"],examples:["cloud.netlifyusercontent.com"],totalExecutionTime:299527,
totalOccurrences:1323},{name:"Scroll",homepage:"https://scroll.com/",category:"utility",domains:["*.scroll.com"],examples:["static.scroll.com","connect.scroll.com"]},{name:"Consumable",homepage:"https://consumable.com/",category:"ad",domains:["*.serverbid.com"],totalExecutionTime:15203,totalOccurrences:266},{name:"DMD Marketing",homepage:"https://www.dmdconnects.com/",category:"ad",domains:["*.medtargetsystem.com"],totalExecutionTime:257224,totalOccurrences:846},{name:"Catchpoint",homepage:"https://www.catchpoint.com/",category:"analytics",domains:["*.3gl.net","*.3genlabs.net"],totalExecutionTime:14822,totalOccurrences:160},{name:"Terminus",homepage:"https://terminus.com/",category:"ad",domains:["*.terminus.services"],totalExecutionTime:28077,totalOccurrences:207},{name:"Acceptable Ads",homepage:"https://acceptableads.com/",category:"ad",domains:["*.aaxads.com","*.aaxdetect.com"],totalExecutionTime:2200,totalOccurrences:34},{name:"ClearBrain",homepage:"https://www.clearbrain.com/",category:"\
analytics",domains:["*.clearbrain.com"],examples:["api.clearbrain.com"]},{name:"Optanon",homepage:"https://www.cookielaw.org/",category:"consent-provider",domains:["*.onetrust.com","*.cookielaw.org"],examples:["cdn.cookielaw.org","geolocation.onetrust.com"],totalExecutionTime:55293468,totalOccurrences:113700},{name:"TrustArc",homepage:"https://www.trustarc.com/",category:"utility",domains:["*.trustarc.com"],examples:["choices.trustarc.com","consent.trustarc.com"],totalExecutionTime:2429376,totalOccurrences:5941},{name:"iSpot.tv",homepage:"https://www.ispot.tv/",category:"ad",domains:["*.ispot.tv"],examples:["pt.ispot.tv"],totalExecutionTime:2947,totalOccurrences:10},{name:"RevJet",homepage:"https://www.revjet.com/",category:"ad",domains:["*.revjet.com"],examples:["pix.revjet.com","ads.revjet.com"],totalExecutionTime:54608,totalOccurrences:36},{name:"atlasRTX",homepage:"https://www.atlasrtx.com/",category:"customer-success",domains:["*.atlasrtx.com"],examples:["app.atlasrtx.com","cdn.at\
lasrtx.com","dev.atlasrtx.com"],totalExecutionTime:52386,totalOccurrences:46},{name:"ContactAtOnce",homepage:"https://www.contactatonce.com/",category:"customer-success",domains:["*.contactatonce.com"],examples:["tag.contactatonce.com","agentpresence.contactatonce.com"]},{name:"Algolia",homepage:"https://www.algolia.com/",category:"utility",domains:["*.algolianet.com","*.algolia.net","*.algolia.io"],totalExecutionTime:5603,totalOccurrences:20},{name:"EMX Digital",homepage:"https://emxdigital.com",category:"ad",domains:["*.emxdgt.com"],totalExecutionTime:9160,totalOccurrences:166},{name:"Moxie",homepage:"https://www.gomoxie.com/",category:"utility",domains:["*.gomoxie.solutions"],totalExecutionTime:24183,totalOccurrences:28},{name:"Scripps Network Digital",homepage:"https://www.scrippsnetworksdigital.com/",category:"ad",domains:["*.snidigital.com"]},{name:"TurnTo",homepage:"https://www.turntonetworks.com/",category:"utility",domains:["*.turnto.com"],totalExecutionTime:4666,totalOccurrences:32},
{name:"Quantum Metric",homepage:"https://www.quantummetric.com/",category:"analytics",domains:["*.quantummetric.com"],totalExecutionTime:1699724,totalOccurrences:1140},{name:"Carbon Ads",homepage:"https://www.carbonads.net/",category:"ad",domains:["*.carbonads.net","*.carbonads.com"],totalExecutionTime:12059,totalOccurrences:224},{name:"Ably",homepage:"https://www.ably.io/",category:"utility",domains:["*.ably.io"],totalExecutionTime:17031,totalOccurrences:125},{name:"Sectigo",homepage:"https://sectigo.com/",category:"utility",domains:["*.sectigo.com"],totalExecutionTime:4576,totalOccurrences:3},{name:"Specless",homepage:"https://gospecless.com/",category:"ad",domains:["*.specless.tech"]},{name:"Loggly",homepage:"https://www.loggly.com/",category:"analytics",domains:["*.loggly.com","d9jmv9u00p0mv.cloudfront.net"],examples:["logs-01.loggly.com"],totalExecutionTime:943,totalOccurrences:5},{name:"Intent Media",homepage:"https://intent.com/",category:"ad",domains:["*.intentmedia.net"]},{name:"\
Supership",homepage:"https://supership.jp/",category:"ad",domains:["*.socdm.com"],totalExecutionTime:10809246,totalOccurrences:17934},{name:"F@N Communications",homepage:"https://www.fancs.com/",category:"ad",domains:["*.ladsp.com"],examples:["px.ladsp.com"],totalExecutionTime:258835,totalOccurrences:1768},{name:"Vidyard",homepage:"https://www.vidyard.com/",category:"utility",domains:["*.vidyard.com"],totalExecutionTime:1165600,totalOccurrences:1097},{name:"RapidSSL",homepage:"https://www.rapidssl.com/",category:"utility",domains:["*.rapidssl.com"],totalExecutionTime:845,totalOccurrences:2},{name:"Coherent Path",homepage:"https://coherentpath.com/",category:"utility",domains:["*.coherentpath.com"]},{name:"Attentive",homepage:"https://attentivemobile.com/",category:"ad",domains:["*.attn.tv","*.attentivemobile.com"],totalExecutionTime:5554871,totalOccurrences:9099},{name:"emetriq",homepage:"https://www.emetriq.com/",category:"ad",domains:["*.emetriq.de","*.xplosion.de"],totalExecutionTime:1917,
totalOccurrences:24},{name:"Bonzai",homepage:"https://www.bonzai.co/",category:"ad",domains:["*.bonzai.co"]},{name:"Freshchat",homepage:"https://www.freshworks.com/live-chat-software/",category:"customer-success",domains:["*.freshchat.com","*.freshworksapi.com"],products:[{name:"Freshdesk Messaging",urlPatterns:["wchat.freshchat.com"],facades:[{name:"Freshdesk Messaging (formerly Freshchat) Facade",repo:"https://github.com/coliff/freshdesk-messaging-facade/"}]}],totalExecutionTime:23350324,totalOccurrences:7081},{name:"Contentful",homepage:"https://www.contentful.com/",category:"utility",domains:["*.contentful.com"],examples:["cdn.contentful.com"],totalExecutionTime:4826,totalOccurrences:2},{name:"PureCars",homepage:"https://www.purecars.com/",category:"marketing",domains:["*.purecars.com"],examples:["cdn.purecars.com"],totalExecutionTime:969442,totalOccurrences:1292},{name:"Tray Commerce",homepage:"https://www.tray.com.br/",category:"marketing",domains:["*.tcdn.com.br"],examples:["ima\
ges.tcdn.com.br"],totalExecutionTime:68362173,totalOccurrences:14071},{name:"AdScore",homepage:"https://www.adscore.com/",category:"ad",domains:["*.adsco.re"],examples:["c.adsco.re"],totalExecutionTime:2812771,totalOccurrences:4394},{name:"WebsiteBuilder.com",homepage:"https://www.websitebuilder.com",category:"hosting",domains:["*.mywebsitebuilder.com"],totalExecutionTime:19568135,totalOccurrences:4688},{name:"mParticle",homepage:"https://www.mparticle.com/",category:"utility",domains:["*.mparticle.com"],examples:["jssdks.mparticle.com","identity.mparticle.com"],totalExecutionTime:403503,totalOccurrences:1029},{name:"Ada",homepage:"https://www.ada.support/",category:"customer-success",domains:["*.ada.support"],examples:["static.ada.support"],totalExecutionTime:695777,totalOccurrences:985},{name:"Quora Ads",homepage:"https://www.quora.com/business/",category:"ad",domains:["*.quora.com"],examples:["q.quora.com"],totalExecutionTime:1338719,totalOccurrences:10614},{name:"Auth0",homepage:"h\
ttps://auth0.com/",category:"utility",domains:["*.auth0.com"],examples:["cdn.auth0.com"],totalExecutionTime:245638,totalOccurrences:816},{name:"Bridgewell DSP",homepage:"https://www.bridgewell.com/",category:"ad",domains:["*.scupio.com"],examples:["img.scupio.com"],totalExecutionTime:63728,totalOccurrences:354},{name:"Wicked Reports",homepage:"https://www.wickedreports.com/",category:"marketing",domains:["*.wickedreports.com"],examples:["widget.wickedreports.com"],totalExecutionTime:148754,totalOccurrences:483},{name:"Jaywing",homepage:"https://jaywing.com/",category:"marketing",domains:["*.jaywing.com"],examples:["amazon.almanac.jaywing.com"]},{name:"Holimetrix",homepage:"https://u360.d-bi.fr/",category:"marketing",domains:["*.d-bi.fr"],examples:["u360.d-bi.fr"]},{name:"iZooto",homepage:"https://www.izooto.com",category:"marketing",domains:["*.izooto.com"],examples:["cdn.izooto.com"],totalExecutionTime:1111125,totalOccurrences:2022},{name:"Ordergroove",homepage:"https://www.ordergroov\
e.com/",category:"marketing",domains:["*.ordergroove.com"],examples:["static.ordergroove.com"],totalExecutionTime:99990,totalOccurrences:274},{name:"PageSense",homepage:"https://www.zoho.com/pagesense/",category:"analytics",domains:["*.pagesense.io"],examples:["cdn.pagesense.io"],totalExecutionTime:1996537,totalOccurrences:6219},{name:"Vizzit",homepage:"https://www.vizzit.se",category:"analytics",domains:["*.vizzit.se"],examples:["www.vizzit.se","tag.vizzit.se"],totalExecutionTime:739,totalOccurrences:7},{name:"Click Guardian",homepage:"https://www.clickguardian.co.uk/",category:"ad",domains:["*.clickguardian.app","*.clickguardian.co.uk"],examples:["v2.clickguardian.app","protection.clickguardian.co.uk"],totalExecutionTime:202620,totalOccurrences:1101},{name:"Smartsupp",company:"Smartsupp.com",homepage:"https://www.smartsupp.com",category:"customer-success",domains:["*.smartsuppchat.com","*.smartsupp.com","smartsupp-widget-161959.c.cdn77.org","*.smartsuppcdn.com"],examples:["widget-v1.\
smartsuppcdn.com"],totalExecutionTime:9998165,totalOccurrences:21505},{name:"Smartlook",company:"Smartsupp.com",homepage:"https://www.smartlook.com/",category:"analytics",domains:["*.smartlook.com"],totalExecutionTime:1386251,totalOccurrences:16221},{name:"Luigis Box",company:"Luigis Box",homepage:"https://www.luigisbox.com/",category:"utility",domains:["*.luigisbox.com"],totalExecutionTime:2975273,totalOccurrences:2356},{name:"Targito",company:"VIVmail.cz",homepage:"https://www.targito.com",category:"marketing",domains:["*.targito.com"],totalExecutionTime:3145,totalOccurrences:29},{name:"Foxentry",company:"AVANTRO",homepage:"https://foxentry.cz/",category:"utility",domains:["*.foxentry.cz"],totalExecutionTime:758854,totalOccurrences:2313},{name:"Pendo",homepage:"https://www.pendo.io",category:"analytics",domains:["*.pendo.io"],examples:["app.pendo.io"],totalExecutionTime:4935190,totalOccurrences:12203},{name:"Braze",homepage:"https://www.braze.com",category:"analytics",domains:["*.app\
boycdn.com"],examples:["js.appboycdn.com"],totalExecutionTime:399216,totalOccurrences:2014},{name:"Usersnap",homepage:"https://usersnap.com",category:"customer-success",domains:["*.usersnap.com"],examples:["api.usersnap.com","cdn.usersnap.com"],totalExecutionTime:334324,totalOccurrences:437},{name:"Rewardful",homepage:"https://www.getrewardful.com",category:"analytics",domains:["*.wdfl.co"],examples:["r.wdfl.co"],totalExecutionTime:9094,totalOccurrences:161},{name:"Launch Darkly",homepage:"https://launchdarkly.com",category:"utility",domains:["*.launchdarkly.com"],examples:["app.launchdarkly.com","events.launchdarkly.com"],totalExecutionTime:10547,totalOccurrences:6},{name:"Statuspage",company:"Atlassian",homepage:"https://www.statuspage.io",category:"utility",domains:["*.statuspage.io"],examples:["1k6wzpspjf99.statuspage.io"],totalExecutionTime:43124,totalOccurrences:1212},{name:"HyperInzerce",homepage:"https://hyperinzerce.cz",category:"ad",domains:["*.hyperinzerce.cz"],examples:["mo\
torky.hyperinzerce.cz"],totalExecutionTime:1035,totalOccurrences:39},{name:"POWr",homepage:"https://www.powr.io",category:"utility",domains:["*.powr.io"],examples:["www.powr.io"],totalExecutionTime:191534674,totalOccurrences:39716},{name:"Coral",company:"Coral",homepage:"https://coralproject.net",category:"content",domains:["*.coral.coralproject.net"],examples:["company.coral.coralproject.net"],totalExecutionTime:61135,totalOccurrences:250},{name:"Bolt",homepage:"https://www.bolt.com/",category:"utility",domains:["*.bolt.com"],examples:["connect.bolt.com"],totalExecutionTime:513689,totalOccurrences:217},{name:"Judge.me",homepage:"https://judge.me/",category:"marketing",domains:["*.judge.me"],examples:["cdn.judge.me"],totalExecutionTime:31886982,totalOccurrences:27483},{name:"Tilda",homepage:"https://tilda.cc/",category:"hosting",domains:["*.tildacdn.com"],examples:["stat.tildacdn.com","static.tildacdn.com","upwidget.tildacdn.com"],totalExecutionTime:94734169,totalOccurrences:70321},{name:"\
SalesLoft",homepage:"https://salesloft.com/",category:"marketing",domains:["*.salesloft.com"],examples:["scout-cdn.salesloft.com"],totalExecutionTime:42987,totalOccurrences:705},{name:"Accessibe Accessibility Overlay",company:"Accessibe",homepage:"https://accessibe.com/",category:"utility",domains:["*.accessibe.com","*.acsbapp.com","*.acsbap.com"],examples:["accessibe.com","acsbapp.com"],totalExecutionTime:285765,totalOccurrences:808},{name:"Builder",homepage:"https://www.builder.io/",category:"hosting",domains:["*.builder.io"],examples:["cdn.builder.io"],totalExecutionTime:412358,totalOccurrences:261},{name:"Pepperjam",homepage:"https://www.pepperjam.com/",category:"marketing",domains:["*.pepperjam.com","*.affiliatetechnology.com"],examples:["container.pepperjam.com"],totalExecutionTime:2308,totalOccurrences:35},{name:"Reach",homepage:"https://withreach.com/",category:"utility",domains:["*.gointerpay.net"],examples:["checkout.gointerpay.net"]},{name:"Chameleon",homepage:"https://www.t\
rychameleon.com/",category:"marketing",domains:["*.trychameleon.com"],examples:["fast.trychameleon.com"],totalExecutionTime:24218,totalOccurrences:8},{name:"Matomo",company:"InnoCraft",homepage:"https://matomo.org/",category:"analytics",domains:["*.matomo.cloud"],totalExecutionTime:3115176,totalOccurrences:14345},{name:"Segmanta",homepage:"https://segmanta.com/",category:"marketing",domains:["*.segmanta.com"],examples:["clientName.segmanta.com"]},{name:"Podsights",homepage:"https://podsights.com/",category:"marketing",domains:["*.pdst.fm","us-central1-adaptive-growth.cloudfunctions.net"],examples:["cdn.pdst.fm","sink.pdst.fm"],totalExecutionTime:71990,totalOccurrences:1140},{name:"Chatwoot",homepage:"https://www.chatwoot.com/",category:"customer-success",domains:["*.chatwoot.com"],examples:["cdn.chatwoot.com","app.chatwoot.com"],totalExecutionTime:31973,totalOccurrences:444},{name:"Crisp",homepage:"https://crisp.chat/",category:"customer-success",domains:["*.crisp.chat"],examples:["cli\
ent.crisp.chat","client.relay.crisp.chat"],totalExecutionTime:33757,totalOccurrences:1052},{name:"Admiral CMP",homepage:"https://www.getadmiral.com",category:"consent-provider",domains:["admiral.mgr.consensu.org","*.admiral.mgr.consensu.org"]},{name:"Adnuntius CMP",homepage:"https://adnuntius.com",category:"consent-provider",domains:["adnuntiusconsent.mgr.consensu.org","*.adnuntiusconsent.mgr.consensu.org"]},{name:"Clickio CMP",homepage:"https://clickio.com",category:"consent-provider",domains:["clickio.mgr.consensu.org","*.clickio.mgr.consensu.org"]},{name:"AppConsent CMP",homepage:"https://appconsent.io/en",category:"consent-provider",domains:["appconsent.mgr.consensu.org","*.appconsent.mgr.consensu.org"]},{name:"DMG Media CMP",homepage:"https://www.dmgmedia.co.uk",category:"consent-provider",domains:["dmgmedia.mgr.consensu.org","*.dmgmedia.mgr.consensu.org"]},{name:"Axel Springer CMP",homepage:"https://www.axelspringer.com",category:"consent-provider",domains:["axelspringer.mgr.cons\
ensu.org","*.axelspringer.mgr.consensu.org"]},{name:"Bedrock CMP",homepage:"https://www.bedrockstreaming.com",category:"consent-provider",domains:["bedrock.mgr.consensu.org","*.bedrock.mgr.consensu.org"]},{name:"BMIND CMP",homepage:"https://www.bmind.es",category:"consent-provider",domains:["bmind.mgr.consensu.org","*.bmind.mgr.consensu.org"]},{name:"Borlabs CMP",homepage:"https://borlabs.io",category:"consent-provider",domains:["borlabs.mgr.consensu.org","*.borlabs.mgr.consensu.org"]},{name:"Civic CMP",homepage:"https://www.civicuk.com",category:"consent-provider",domains:["cookiecontrol.mgr.consensu.org","*.cookiecontrol.mgr.consensu.org"]},{name:"Commanders Act CMP",homepage:"https://www.commandersact.com",category:"consent-provider",domains:["commandersact.mgr.consensu.org","*.commandersact.mgr.consensu.org"]},{name:"Complianz CMP",homepage:"https://complianz.io/",category:"consent-provider",domains:["complianz.mgr.consensu.org","*.complianz.mgr.consensu.org"]},{name:"Consent Desk \
CMP",homepage:"https://www.consentdesk.com/",category:"consent-provider",domains:["consentdesk.mgr.consensu.org","*.consentdesk.mgr.consensu.org"]},{name:"Consent Manager CMP",homepage:"https://consentmanager.net",category:"consent-provider",domains:["consentmanager.mgr.consensu.org","*.consentmanager.mgr.consensu.org"]},{name:"Conversant CMP",homepage:"https://www.conversantmedia.eu/",category:"consent-provider",domains:["conversant.mgr.consensu.org","*.conversant.mgr.consensu.org"]},{name:"Cookie Information CMP",homepage:"https://www.cookieinformation.com/",category:"consent-provider",domains:["cookieinformation.mgr.consensu.org","*.cookieinformation.mgr.consensu.org"]},{name:"Cookiebot CMP",homepage:"https://www.cookiebot.com",category:"consent-provider",domains:["cookiebot.mgr.consensu.org","*.cookiebot.mgr.consensu.org"]},{name:"Truendo CMP",homepage:"https://truendo.com/",category:"consent-provider",domains:["truendo.mgr.consensu.org","*.truendo.mgr.consensu.org"]},{name:"Dentsu\
 CMP",homepage:"https://www.dentsuaegisnetwork.de/",category:"consent-provider",domains:["dan.mgr.consensu.org","*.dan.mgr.consensu.org"]},{name:"Didomi CMP",homepage:"https://www.didomi.io/en/",category:"consent-provider",domains:["didomi.mgr.consensu.org","*.didomi.mgr.consensu.org"]},{name:"Ensighten CMP",homepage:"https://www.ensighten.com/",category:"consent-provider",domains:["ensighten.mgr.consensu.org","*.ensighten.mgr.consensu.org"]},{name:"Evidon CMP",homepage:"https://evidon.com",category:"consent-provider",domains:["evidon.mgr.consensu.org","*.evidon.mgr.consensu.org"]},{name:"Ezoic CMP",homepage:"https://www.ezoic.com/",category:"consent-provider",domains:["ezoic.mgr.consensu.org","*.ezoic.mgr.consensu.org"]},{name:"Gemius CMP",homepage:"https://www.gemius.com",category:"consent-provider",domains:["gemius.mgr.consensu.org","*.gemius.mgr.consensu.org"]},{name:"NitroPay CMP",homepage:"https://nitropay.com/",category:"consent-provider",domains:["nitropay.mgr.consensu.org","*.\
nitropay.mgr.consensu.org"]},{name:"Google FundingChoices",homepage:"https://fundingchoices.google.com/start/",category:"consent-provider",domains:["fundingchoices.mgr.consensu.org","*.fundingchoices.mgr.consensu.org","fundingchoicesmessages.google.com","*.fundingchoicesmessages.google.com"],totalExecutionTime:257806056,totalOccurrences:400016},{name:"Gravito CMP",homepage:"https://www.gravito.net/",category:"consent-provider",domains:["gravito.mgr.consensu.org","*.gravito.mgr.consensu.org"]},{name:"ID Ward CMP",homepage:"https://id-ward.com/enterprise",category:"consent-provider",domains:["idward.mgr.consensu.org","*.idward.mgr.consensu.org"]},{name:"iubenda CMP",homepage:"https://www.iubenda.com",category:"consent-provider",domains:["iubenda.mgr.consensu.org","*.iubenda.mgr.consensu.org"]},{name:"Jump CMP",homepage:"https://jumpgroup.it/",category:"consent-provider",domains:["avacy.mgr.consensu.org","*.avacy.mgr.consensu.org"]},{name:"LiveRamp CMP",homepage:"https://liveramp.com/",category:"\
consent-provider",domains:["faktor.mgr.consensu.org","*.faktor.mgr.consensu.org"]},{name:"Madvertise CMP",homepage:"https://madvertise.com/en/",category:"consent-provider",domains:["madvertise.mgr.consensu.org","*.madvertise.mgr.consensu.org"]},{name:"Mairdumont Netletic CMP",homepage:"https://www.mairdumont-netletix.com/",category:"consent-provider",domains:["mdnxmp.mgr.consensu.org","*.mdnxmp.mgr.consensu.org"]},{name:"Marfeel CMP",homepage:"https://www.marfeel.com/",category:"consent-provider",domains:["marfeel.mgr.consensu.org","*.marfeel.mgr.consensu.org"]},{name:"Mediavine CMP",homepage:"https://www.mediavine.com/",category:"consent-provider",domains:["mediavine.mgr.consensu.org","*.mediavine.mgr.consensu.org"]},{name:"ConsentServe CMP",homepage:"https://www.consentserve.com/",category:"consent-provider",domains:["consentserve.mgr.consensu.org","*.consentserve.mgr.consensu.org"]},{name:"Next14 CMP",homepage:"https://www.next14.com/",category:"consent-provider",domains:["next14.mg\
r.consensu.org","*.next14.mgr.consensu.org"]},{name:"AdRoll CMP",homepage:"https://www.adroll.com/",category:"consent-provider",domains:["adroll.mgr.consensu.org","*.adroll.mgr.consensu.org"]},{name:"Ogury CMP",homepage:"https://www.ogury.com/",category:"consent-provider",domains:["ogury.mgr.consensu.org","*.ogury.mgr.consensu.org"]},{name:"OneTag CMP",homepage:"https://onetag.net",category:"consent-provider",domains:["onetag.mgr.consensu.org","*.onetag.mgr.consensu.org"]},{name:"OneTrust CMP",homepage:"https://onetrust.com",category:"consent-provider",domains:["onetrust.mgr.consensu.org","*.onetrust.mgr.consensu.org"]},{name:"optAd360 CMP",homepage:"https://www.optad360.com/",category:"consent-provider",domains:["optad360.mgr.consensu.org","*.optad360.mgr.consensu.org"]},{name:"Osano CMP",homepage:"https://www.osano.com",category:"consent-provider",domains:["osano.mgr.consensu.org","*.osano.mgr.consensu.org"]},{name:"Playwire CMP",homepage:"https://www.playwire.com",category:"consent-\
provider",domains:["playwire.mgr.consensu.org","*.playwire.mgr.consensu.org"]},{name:"Pulselive CMP",homepage:"https://www.pulselive.com",category:"consent-provider",domains:["pulselive.mgr.consensu.org","*.pulselive.mgr.consensu.org"]},{name:"Quantcast Choice",homepage:"https://quantcast.com",category:"consent-provider",domains:["quantcast.mgr.consensu.org","*.quantcast.mgr.consensu.org"]},{name:"RCS Pubblicita CMP",homepage:"http://www.rcspubblicita.it/site/home.html",category:"consent-provider",domains:["rcsmediagroup.mgr.consensu.org","*.rcsmediagroup.mgr.consensu.org"]},{name:"Rich Audience CMP",homepage:"https://richaudience.com",category:"consent-provider",domains:["richaudience.mgr.consensu.org","*.richaudience.mgr.consensu.org"]},{name:"Ringier Axel Springer CMP",homepage:"https://www.ringieraxelspringer.pl/en/home/",category:"consent-provider",domains:["rasp.mgr.consensu.org","*.rasp.mgr.consensu.org"]},{name:"Secure Privacy CMP",homepage:"https://secureprivacy.ai/",category:"\
consent-provider",domains:["secureprivacy.mgr.consensu.org","*.secureprivacy.mgr.consensu.org"]},{name:"Securiti CMP",homepage:"https://securiti.ai/",category:"consent-provider",domains:["securiti.mgr.consensu.org","*.securiti.mgr.consensu.org"]},{name:"Seznam.cz CMP",homepage:"https://www.seznam.cz/",category:"consent-provider",domains:["seznam.mgr.consensu.org","*.seznam.mgr.consensu.org"]},{name:"ShareThis CMP",homepage:"https://sharethis.com",category:"consent-provider",domains:["sharethis.mgr.consensu.org","*.sharethis.mgr.consensu.org"]},{name:"ShinyStat CMP",homepage:"https://www.shinystat.com",category:"consent-provider",domains:["shinystat.mgr.consensu.org","*.shinystat.mgr.consensu.org"]},{name:"Sibbo CMP",homepage:"https://sibboventures.com/en/",category:"consent-provider",domains:["sibboventures.mgr.consensu.org","*.sibboventures.mgr.consensu.org"]},{name:"Singlespot CMP",homepage:"https://www.singlespot.com/en",category:"consent-provider",domains:["singlespot.mgr.consensu.\
org","*.singlespot.mgr.consensu.org"]},{name:"Sirdata CMP",homepage:"https://www.sirdata.com",category:"consent-provider",domains:["sddan.mgr.consensu.org","*.sddan.mgr.consensu.org"]},{name:"Snigel CMP",homepage:"https://snigel.com",category:"consent-provider",domains:["snigelweb.mgr.consensu.org","*.snigelweb.mgr.consensu.org"]},{name:"Sourcepoint CMP",homepage:"https://sourcepoint.com",category:"consent-provider",domains:["sourcepoint.mgr.consensu.org","*.sourcepoint.mgr.consensu.org"]},{name:"Pubtech CMP",homepage:"https://www.pubtech.ai/",category:"consent-provider",domains:["pubtech.mgr.consensu.org","*.pubtech.mgr.consensu.org"]},{name:"AdMetrics Pro CMP",homepage:"https://admetricspro.com",category:"consent-provider",domains:["cmp.mgr.consensu.org","*.cmp.mgr.consensu.org"]},{name:"Traffective CMP",homepage:"https://traffective.com",category:"consent-provider",domains:["traffective.mgr.consensu.org","*.traffective.mgr.consensu.org"]},{name:"UniConsent CMP",homepage:"https://www\
.uniconsent.com",category:"consent-provider",domains:["uniconsent.mgr.consensu.org","*.uniconsent.mgr.consensu.org","cmp.uniconsent.com","*.uniconsent.com"],totalExecutionTime:829870,totalOccurrences:1336},{name:"TrustArc CMP",homepage:"https://trustarc.com/",category:"consent-provider",domains:["trustarc.mgr.consensu.org","*.trustarc.mgr.consensu.org"]},{name:"Usercentrics CMP",homepage:"https://usercentrics.com",category:"consent-provider",domains:["usercentrics.mgr.consensu.org","*.usercentrics.mgr.consensu.org","*.usercentrics.eu","*.services.usercentrics.eu"],totalExecutionTime:53008518,totalOccurrences:49602},{name:"WebAds CMP",homepage:"https://www.webads.nl/",category:"consent-provider",domains:["webads.mgr.consensu.org","*.webads.mgr.consensu.org"]},{name:"Trustcommander",company:"Commandersact",homepage:"https://www.commandersact.com",category:"consent-provider",domains:["*.trustcommander.net"],examples:["cdn.trustcommander.net","privacy.trustcommander.net"],totalExecutionTime:324770,
totalOccurrences:1713},{name:"Hubvisor",homepage:"https://www.hubvisor.io",category:"ad",domains:["*.hubvisor.io"],examples:["cdn.hubvisor.io","stream.hubvisor.io"],totalExecutionTime:404737,totalOccurrences:492},{name:"Castle",homepage:"https://castle.io",category:"utility",domains:["*.castle.io","d2t77mnxyo7adj.cloudfront.net"],examples:["t.castle.io"]},{name:"Wigzo",homepage:"https://www.wigzo.com/",category:"marketing",domains:["*.wigzo.com","*.wigzopush.com"],examples:["app.wigzo.com","tracker.wigzopush.com"],totalExecutionTime:215280,totalOccurrences:762},{name:"Convertful",homepage:"https://convertful.com/",category:"marketing",domains:["*.convertful.com"],examples:["app.convertful.com"],totalExecutionTime:215317,totalOccurrences:1534},{name:"OpenLink",company:"MediaWallah",homepage:"https://www.mediawallah.com/",category:"ad",domains:["*.mediawallahscript.com"],examples:["partner.mediawallahscript.com"]},{name:"TPMN",company:"TPMN",homepage:"http://tpmn.io/",category:"ad",domains:[
"*.tpmn.co.kr"],examples:["ad.tpmn.co.kr"],totalExecutionTime:354,totalOccurrences:10},{name:"HERO",company:"Klarna",homepage:"https://www.usehero.com/",category:"customer-success",domains:["*.usehero.com"],examples:["api.usehero.com","cdn.usehero.com"],totalExecutionTime:32092,totalOccurrences:42},{name:"Zync",company:"Zeta Global",homepage:"https://zetaglobal.com/",category:"marketing",domains:["*.rezync.com"],examples:["live.rezync.com"],totalExecutionTime:25978,totalOccurrences:246},{name:"AdFuel Video",company:"AdFuel",homepage:"https://goadfuel.com/",category:"ad",domains:["*.videoplayerhub.com"],examples:["customer.videoplayerhub.com"],totalExecutionTime:82951,totalOccurrences:1407},{name:"Prefix Box AI Search",company:"Prefix Box",homepage:"https://www.prefixbox.com/",category:"utility",domains:["*.prefixbox.com"],examples:["cdn.prefixbox.com"],totalExecutionTime:51608,totalOccurrences:58},{name:"SpeedSize Service Worker",company:"SpeedSize",homepage:"https://speedsize.com/",category:"\
utility",domains:["di6367dava8ow.cloudfront.net","d2d22nphq0yz8t.cloudfront.net"],examples:["di6367dava8ow.cloudfront.net"]},{name:"Vonage Video API",company:"Vonage",homepage:"https://www.vonage.com/communications-apis/video/",category:"video",domains:["*.opentok.com"],examples:["static.opentok.com"],totalExecutionTime:220760,totalOccurrences:304},{name:"Checkout.com",company:"Checkout.com",homepage:"https://www.checkout.com",category:"utility",domains:["*.checkout.com"],examples:["cdn.checkout.com"],totalExecutionTime:184372,totalOccurrences:1367},{name:"Noibu",company:"Noibu",homepage:"https://www.noibu.com",category:"utility",domains:["*.noibu.com"],examples:["input.noibu.com"],totalExecutionTime:1453903,totalOccurrences:613},{name:"Clarity",company:"Microsoft",homepage:"https://clarity.microsoft.com/",category:"utility",domains:["*.clarity.ms"],examples:["c.clarity.ms"],totalExecutionTime:208824616,totalOccurrences:456309},{name:"goinstore",company:"Emplifi",homepage:"https://goin\
store.com/",category:"customer-success",domains:["*.goinstore.com"],examples:["gis.goinstore.com"]},{name:"SegmentStream",company:"SegmentStream",homepage:"https://segmentstream.com/",category:"marketing",domains:["*.segmentstream.com"],examples:["track.segmentstream.com"],totalExecutionTime:8628,totalOccurrences:13},{name:"Amazon Associates",company:"Amazon",homepage:"https://affiliate-program.amazon.co.uk/",category:"marketing",domains:["*.associates-amazon.com"],examples:["assoc-na.associates-amazon.com"],totalExecutionTime:50,totalOccurrences:1},{name:"DotMetrics",company:"Ipsos",homepage:"https://www.dotmetrics.net/",category:"analytics",domains:["*.dotmetrics.net"],examples:["uk-script.dotmetrics.net"],totalExecutionTime:159255,totalOccurrences:817},{name:"Truffle Bid",company:"Truffle",homepage:"https://truffle.bid/",category:"ad",domains:["*.truffle.bid"],examples:["matching.truffle.bid"],totalExecutionTime:24026,totalOccurrences:39},{name:"Hybrid",company:"Hybrid",homepage:"ht\
tps://hybrid.ai/",category:"ad",domains:["*.hybrid.ai"],examples:["dm-eu.hybrid.ai"],totalExecutionTime:219740,totalOccurrences:2326},{name:"AdMan Media",company:"AdMan",homepage:"https://admanmedia.com/",category:"video",domains:["*.admanmedia.com"],examples:["cs.admanmedia.com"],totalExecutionTime:1924,totalOccurrences:202},{name:"ID5 Identity Cloud",company:"ID5",homepage:"https://id5.io/",category:"ad",domains:["id5-sync.com","*.id5-sync.com"],examples:["id5-sync.com"],totalExecutionTime:26134069,totalOccurrences:119336},{name:"Audience Rate",company:"Audience Rate Limited",homepage:"https://www.audiencerate.com/",category:"ad",domains:["*.audrte.com"],examples:["a.audrte.com"]},{name:"Seedtag",company:"Seedtag Advertising",homepage:"https://www.seedtag.com/",category:"ad",domains:["*.seedtag.com"],examples:["s.seedtag.com"],totalExecutionTime:3342567,totalOccurrences:1503},{name:"IVI",company:"IVI Technologies",homepage:"http://ivitechnologies.com/",category:"ad",domains:["*.ivitr\
ack.com"],examples:["matching.ivitrack.com"],totalExecutionTime:3746,totalOccurrences:34},{name:"Sportradar",company:"Sportradar",homepage:"https://www.sportradar.com/",category:"ad",domains:["*.sportradarserving.com"],examples:["a.sportradarserving.com"],totalExecutionTime:520,totalOccurrences:11},{name:"ZEOTAP",company:"ZEOTAP",homepage:"https://zeotap.com/",category:"ad",domains:["*.zeotap.com"],examples:["spl.zeotap.com"],totalExecutionTime:14368,totalOccurrences:96},{name:"Web Content Assessor",company:"TMT Digital",homepage:"https://mediatrust.com/",category:"ad",domains:["*.webcontentassessor.com"],examples:["scripts.webcontentassessor.com"],totalExecutionTime:314249,totalOccurrences:633},{name:"Genie",company:"Media Force",homepage:"https://hellogenie.com/",category:"ad",domains:["*.mfadsrvr.com"],examples:["rtb.mfadsrvr.com"],totalExecutionTime:37,totalOccurrences:2},{name:"mediarithmics",company:"mediarithmics",homepage:"https://www.mediarithmics.com/",category:"ad",domains:[
"*.mediarithmics.com"],examples:["cookie-matching.mediarithmics.com"],totalExecutionTime:25799,totalOccurrences:144},{name:"Ozone Project",company:"The Ozone Project",homepage:"https://www.ozoneproject.com/",category:"ad",domains:["*.the-ozone-project.com"],examples:["elb.the-ozone-project.com"],totalExecutionTime:152768,totalOccurrences:910},{name:"FiftyAurora",company:"Fifty",homepage:"https://fifty.io/",category:"ad",domains:["*.fiftyt.com"],examples:["visitor.fiftyt.com"]},{name:"smadex",company:"entravision",homepage:"https://smadex.com/",category:"ad",domains:["*.smadex.com"],examples:["cm.smadex.com"],totalExecutionTime:5,totalOccurrences:1},{name:"AWX",company:"Trinity Mirror",category:"ad",domains:["*.tm-awx.com"],examples:["felix.data.tm-awx.com"],totalExecutionTime:68744,totalOccurrences:54},{name:"XPO",company:"Knorex",category:"ad",homepage:"https://www.knorex.com/",domains:["*.brand-display.com"],examples:["dmp.brand-display.com"],totalExecutionTime:388629,totalOccurrences:477},
{name:"Viafoura",company:"Viafoura",category:"ad",homepage:"https://viafoura.com/",domains:["*.viafoura.co","*.viafoura.net"],examples:["api.viafoura.co","cdn.viafoura.net"],totalExecutionTime:307404,totalOccurrences:446},{name:"Adnami",company:"Adnami",category:"ad",homepage:"https://www.adnami.io/",domains:["*.adnami.io"],examples:["macro.adnami.io"],totalExecutionTime:272668,totalOccurrences:1639},{name:"LiveRamp Privacy Manager",company:"LiveRamp",category:"ad",homepage:"https://liveramp.com/privacy-legal-compliance/",domains:["*.privacymanager.io"],examples:["geo.privacymanager.io"],totalExecutionTime:6546055,totalOccurrences:22295},{name:"Onfocus",company:"Onfocus SAS",category:"ad",domains:["*.4dex.io"],examples:["script.4dex.io"],totalExecutionTime:4240761,totalOccurrences:8836},{name:"viewTag",company:"Advanced Store",category:"ad",domains:["*.ad4m.at"],examples:["ad4m.at","as.ad4m.at"],totalExecutionTime:458,totalOccurrences:21},{name:"MRP Prelytics",company:"Market Resource \
Partners",category:"ad",homepage:"https://www.mrpfd.com/",domains:["*.mrpdata.net"],examples:["j.mrpdata.net"]},{name:"iPROM",company:"iPROM",category:"ad",homepage:"https://iprom.eu/",domains:["*.iprom.net"],examples:["core.iprom.net"],totalExecutionTime:114801,totalOccurrences:72099},{name:"Plausible",company:"Plausible",homepage:"https://plausible.io/",category:"analytics",domains:["*.plausible.io"]},{name:"Micro Analytics",company:"Micro Analytics",homepage:"https://microanalytics.io/",category:"analytics",domains:["padmin.microanalytics.io","www.microanalytics.io","dev.microanalytics.io","status.microanalytics.io"]},{name:"Scale8",company:"Scale8",homepage:"https://scale8.com/",category:"analytics",domains:["www.scale8.com","api-dev.scale8.com","cdn.scale8.com","ui.scale8.com"]},{name:"Cabin",company:"Cabin",homepage:"https://withcabin.com/",category:"analytics",domains:["*.withcabin.com"],totalExecutionTime:3843,totalOccurrences:100},{name:"Appcues",company:"Appcues",homepage:"ht\
tps://www.appcues.com/",category:"analytics",domains:["*.appcues.com"],totalExecutionTime:2154145,totalOccurrences:2831},{name:"Fathom Analytics",company:"Fathom",homepage:"https://usefathom.com/",category:"analytics",domains:["*.usefathom.com"],totalExecutionTime:145389,totalOccurrences:1141},{name:"Clearbit",company:"Clearbit",homepage:"https://clearbit.com/",category:"analytics",domains:["*.clearbitjs.com","*.clearbitscripts.com","*.clearbit.com"],totalExecutionTime:967253,totalOccurrences:4171},{name:"G2",company:"G2",homepage:"https://www.g2.com/",category:"utility",domains:["*.g2.com","*.g2crowd.com"],totalExecutionTime:195752,totalOccurrences:406},{name:"Navu",company:"Navu",homepage:"https://navu.co/",category:"ad",domains:["*.navu.co"]},{name:"InZynk",company:"InZynk",homepage:"https://inzynk.com/",category:"ad",domains:["*.inzynk.com","*.inzynk.io"],totalExecutionTime:541,totalOccurrences:8},{name:"Integrate",company:"Integrate",homepage:"https://www.integrate.com/",category:"\
ad",domains:["*.integrate.com","*.listenloop.com"],totalExecutionTime:14260,totalOccurrences:39},{name:"Ad Lightning",company:"Boltive",homepage:"https://www.adlightning.com/",category:"ad",domains:["*.adlightning.com"],totalExecutionTime:6879067,totalOccurrences:3795},{name:"GeoEdge",company:"GeoEdge",homepage:"https://www.geoedge.com/",category:"ad",domains:["*.geoedge.com","*.geoedge.be"],totalExecutionTime:1039615,totalOccurrences:1796},{name:"Doofinder",company:"Doofinder",homepage:"https://www.doofinder.com/",category:"utility",domains:["cdn.doofinder.com"],totalExecutionTime:1750777,totalOccurrences:12550},{name:"Revlifter",company:"Revlifter",homepage:"https://www.revlifter.com/",category:"utility",domains:["assets.revlifter.com"]},{name:"Didomi",company:"Didomi",homepage:"https://www.didomi.io/",category:"consent-provider",domains:["sdk.privacy-center.org","api.privacy-center.org"],totalExecutionTime:85132161,totalOccurrences:84206},{name:"Pubperf Analytics",company:"Pubperf",
homepage:"https://www.pubperf.com/",category:"analytics",domains:["*.pubperf.com"],totalExecutionTime:51392,totalOccurrences:400}]});var C5=Ne(($Oe,S5)=>{d();var{createAPIFromDataset:Ure}=E5(),jre=T5();S5.exports=Ure(jre)});var Gi,Pg=g(()=>{d();Gi=Yn(C5(),1)});var Qa={};E(Qa,{configToCacheKey:()=>zre,defaults:()=>qre});function zre(e){return JSON.stringify(e)}var qre,k5=g(()=>{d();qre=i(()=>({includeRuntimeCallStats:!1,showAllEvents:!1,debugMode:!1,maxInvalidationEventsPerEvent:20}),"defaults");i(zre,"configToCacheKey")});var ka={};E(ka,{extensionPalette:()=>Hre,isExtensionPayloadMarker:()=>I5,isExtensionPayloadTrackEntry:()=>A5,isSyntheticExtensionEntry:()=>Gre,isValidExtensionPayload:()=>Wre});function I5(e){return e.dataType==="marker"}function A5(e){let t="track"in e&&!!e.track;return(e.dataType==="track-entry"||e.dataType===void 0)&&t}function Wre(e){return I5(e)||A5(e)}function Gre(e){return e.cat==="devtools.extension"}var Hre,F5=g(()=>{d();Hre=["primary","primary-light","primary-dark","secondary","secondary-light","secondary-dark","tertiary","tertiary-light","tertiary-dark","error","warning"];i(I5,"isExtensionPayloadMarker");i(A5,"isExtensionPayloadTrackEntry");i(Wre,"isValidExtensionPayload");i(Gre,"isSyntheticExtensionEntry")});var R5=g(()=>{d()});var O={};E(O,{Micro:()=>$re,Milli:()=>Yre,Seconds:()=>Kre});function $re(e){return e}function Yre(e){return e}function Kre(e){return e}var _5=g(()=>{d();i($re,"Micro");i(Yre,"Milli");i(Kre,"Seconds")});var C={};E(C,{CallFrameID:()=>qae,Categories:()=>hie,MarkerName:()=>aae,NO_NAVIGATION:()=>Aw,ProcessID:()=>Hae,ProfileID:()=>jae,SampleIndex:()=>zae,SelectorTimingsKey:()=>Tn,ThreadID:()=>Wae,WorkerId:()=>Gae,eventIsPageLoadEvent:()=>sae,isAbortPostTaskCallback:()=>mie,isActivateLayerTree:()=>Aae,isAnimation:()=>ioe,isAnimationFrameAsyncEnd:()=>hae,isAnimationFrameAsyncStart:()=>fae,isAnimationFramePresentation:()=>gae,isAuctionWorkletDoneWithProcess:()=>eae,isAuctionWorkletRunningInProcess:()=>Qre,isBegin:()=>Vae,isBeginCommitCompositorFrame:()=>uae,isBeginFrame:()=>xae,isBeginMainThreadFrame:()=>Tae,isBeginRemoteFontLoad:()=>_oe,isCommit:()=>Cae,isCommitLoad:()=>ooe,isComplete:()=>B5,isCompositeLayers:()=>Iae,isConsoleRunTask:()=>Q5,isConsoleTime:()=>Poe,isConsoleTimeStamp:()=>Loe,isDOMStats:()=>eoe,isDebuggerAsyncTaskRun:()=>Uae,isDebuggerAsyncTaskScheduled:()=>Bae,isDecodeImage:()=>Mae,isDecodeLazyPixelRef:()=>_ae,isDidCommitSameDocumentNavigation:()=>koe,isDispatch:()=>Yae,isDisplayListItemListSnapshot:()=>Yoe,
isDomLoading:()=>Roe,isDrawFrame:()=>wae,isDrawLazyPixelRef:()=>Rae,isDroppedFrame:()=>Dae,isEnd:()=>$ae,isEventTiming:()=>Fw,isEventTimingEnd:()=>doe,isEventTimingStart:()=>moe,isFireAnimationFrame:()=>Joe,isFireIdleCallback:()=>Jae,isFirstContentfulPaint:()=>q5,isFirstPaint:()=>W5,isFlowPhase:()=>Jre,isFlowPhaseEvent:()=>fie,isFrameCommittedInBrowser:()=>aoe,isFunctionCall:()=>cie,isGPUTask:()=>poe,isHandlePostMessage:()=>Zae,isInstant:()=>U5,isInteractiveTime:()=>V5,isInvalidateLayout:()=>Lae,isInvalidationTracking:()=>Fae,isJSInvocationEvent:()=>pie,isLargestContentfulPaintCandidate:()=>z5,isLargestImagePaintCandidate:()=>uoe,isLargestTextPaintCandidate:()=>loe,isLayerTreeHostImplSnapshot:()=>Koe,isLayout:()=>Pae,isLayoutImageUnsized:()=>pae,isLayoutInvalidationTracking:()=>j5,isLayoutShift:()=>coe,isLegacyScreenshot:()=>tae,isLegacySyntheticScreenshot:()=>nae,isLegacyTimelineFrame:()=>gie,isMainFrameViewport:()=>Ioe,isMarkDOMContent:()=>G5,isMarkLoad:()=>H5,isMarkerEvent:()=>oae,isNavigationStart:()=>Y5,
isNeedsBeginFrameChanged:()=>Sae,isNestableAsyncPhase:()=>M5,isNetworkTrackEntry:()=>Soe,isPaint:()=>Hoe,isPaintImage:()=>Woe,isParseHTML:()=>Uoe,isParseMetaViewport:()=>lae,isPerformanceMark:()=>Noe,isPerformanceMeasure:()=>K5,isPerformanceMeasureBegin:()=>Ooe,isPhaseAsync:()=>Iw,isPipelineReporter:()=>yae,isPrePaint:()=>Coe,isProcessName:()=>noe,isProfile:()=>foe,isProfileCall:()=>zoe,isProfileChunk:()=>goe,isRasterTask:()=>kae,isReceivedDataEvent:()=>Toe,isRemoteFontLoaded:()=>Moe,isRenderFrameImplCreateChildFrame:()=>mae,isRendererEvent:()=>Kae,isRequestAnimationFrame:()=>Xoe,isRequestIdleCallback:()=>eie,isRequestMainThreadFrame:()=>Eae,isResourceChangePriority:()=>yoe,isResourceFinish:()=>xoe,isResourceMarkAsCached:()=>woe,isResourceReceiveResponse:()=>boe,isResourceReceivedData:()=>Eoe,isResourceSendRequest:()=>voe,isResourceWillSendRequest:()=>Doe,isRunPostTaskCallback:()=>die,isRunTask:()=>Zre,isSchedulePostMessage:()=>Xae,isSchedulePostTaskCallback:()=>lie,isScheduleStyleInvalidationTracking:()=>N5,
isScheduleStyleRecalculation:()=>dae,isScreenshot:()=>rae,isScrollLayer:()=>Goe,isSelectorStats:()=>Oae,isSetLayerId:()=>Voe,isStyleInvalidatorInvalidationTracking:()=>L5,isStyleRecalcInvalidationTracking:()=>P5,isSyntheticAnimation:()=>soe,isSyntheticBased:()=>vae,isSyntheticConsoleTiming:()=>Foe,isSyntheticCpuProfile:()=>hoe,isSyntheticInteraction:()=>bae,isSyntheticLayoutShift:()=>joe,isSyntheticLayoutShiftCluster:()=>qoe,isSyntheticNetworkRequest:()=>$5,isSyntheticServerTiming:()=>uie,isSyntheticUserTiming:()=>Aoe,isSyntheticWebSocketConnection:()=>Rw,isTargetRundownEvent:()=>yie,isThreadName:()=>toe,isTimerFire:()=>Qoe,isTimerInstall:()=>Zoe,isTracingSessionIdForWorker:()=>cae,isTracingStartedInBrowser:()=>roe,isUpdateCounters:()=>Qae,isUpdateLayer:()=>$oe,isUpdateLayoutTree:()=>Nae,isUserTiming:()=>_w,isUserTimingMeasure:()=>Boe,isV8Compile:()=>sie,isV8SourceRundownEvent:()=>vie,isV8SourceRundownSourcesLargeScriptCatchupEvent:()=>wie,isV8SourceRundownSourcesScriptCatchupEvent:()=>bie,
isWebSocketCreate:()=>J5,isWebSocketDestroy:()=>oie,isWebSocketEvent:()=>iie,isWebSocketInfo:()=>X5,isWebSocketReceive:()=>nie,isWebSocketReceiveHandshakeResponse:()=>aie,isWebSocketSend:()=>tie,isWebSocketSendHandshakeRequest:()=>rie,isWebSocketTraceEvent:()=>Mw,isWebSocketTransfer:()=>Z5,objectIsCallFrame:()=>Xre});function M5(e){return e==="b"||e==="e"||e==="n"}function Iw(e){return M5(e)||e==="S"||e==="T"||e==="F"||e==="p"}function Jre(e){return e==="s"||e==="t"||e==="f"}function Xre(e){return"functionName"in e&&typeof e.functionName=="string"&&"scriptId"in e&&(typeof e.scriptId=="string"||typeof e.scriptId=="number")&&"columnNumber"in e&&typeof e.columnNumber=="number"&&"lineNumber"in e&&typeof e.lineNumber=="number"&&"url"in e&&typeof e.url=="string"}function Zre(e){return e.name==="RunTask"}function Qre(e){return e.name==="AuctionWorkletRunningInProcess"}function eae(e){return e.name==="AuctionWorkletDoneWithProcess"}function tae(e){return e.name==="Screenshot"&&"id"in e}function nae(e){
return e.name==="Screenshot"&&"dataUri"in(e.args??{})}function rae(e){return e.name==="Screenshot"&&"source_id"in(e.args??{})}function oae(e){return e.ph==="I"||e.ph==="R"?O5.some(t=>t(e)):!1}function sae(e){return e.ph==="I"||e.ph==="R"?iae.some(t=>t(e)):!1}function cae(e){return e.name==="TracingSessionIdForWorker"}function N5(e){return e.name==="ScheduleStyleInvalidationTracking"}function P5(e){return e.name==="StyleRecalcInvalidationTracking"}function L5(e){return e.name==="StyleInvalidatorInvalidationTracking"}function uae(e){return e.name==="BeginCommitCompositorFrame"}function lae(e){return e.name==="ParseMetaViewport"}function dae(e){return e.name==="ScheduleStyleRecalculation"}function mae(e){return e.name==="RenderFrameImpl::createChildFrame"}function pae(e){return e.name==="LayoutImageUnsized"}function fae(e){return e.name==="AnimationFrame"&&e.ph==="b"}function hae(e){return e.name==="AnimationFrame"&&e.ph==="e"}function gae(e){return e.name==="AnimationFrame::Presentation"}
function yae(e){return e.name==="PipelineReporter"}function vae(e){return"rawSourceEvent"in e}function bae(e){return!!("interactionId"in e&&e.args?.data&&"beginEvent"in e.args.data&&"endEvent"in e.args.data)}function wae(e){return e.name==="DrawFrame"&&e.ph==="I"}function xae(e){return!!(e.name==="BeginFrame"&&e.args&&"frameSeqId"in e.args)}function Dae(e){return!!(e.name==="DroppedFrame"&&e.args&&"frameSeqId"in e.args)}function Eae(e){return e.name==="RequestMainThreadFrame"}function Tae(e){return e.name==="BeginMainThreadFrame"}function Sae(e){return e.name==="NeedsBeginFrameChanged"}function Cae(e){return!!(e.name==="Commit"&&e.args&&"frameSeqId"in e.args)}function kae(e){return e.name==="RasterTask"}function Iae(e){return e.name==="CompositeLayers"}function Aae(e){return e.name==="ActivateLayerTree"}function Fae(e){return N5(e)||P5(e)||L5(e)||j5(e)}function Rae(e){return e.name==="Draw LazyPixelRef"}function _ae(e){return e.name==="Decode LazyPixelRef"}function Mae(e){return e.name===
"Decode Image"}function Oae(e){return e.name==="SelectorStats"}function Nae(e){return e.name==="UpdateLayoutTree"}function Pae(e){return e.name==="Layout"}function Lae(e){return e.name==="InvalidateLayout"}function Bae(e){return e.name==="v8::Debugger::AsyncTaskScheduled"}function Uae(e){return e.name==="v8::Debugger::AsyncTaskRun"}function jae(e){return e}function qae(e){return e}function zae(e){return e}function Hae(e){return e}function Wae(e){return e}function Gae(e){return e}function B5(e){return e.ph==="X"}function Vae(e){return e.ph==="B"}function $ae(e){return e.ph==="E"}function Yae(e){return e.name==="EventDispatch"}function U5(e){return e.ph==="I"}function Kae(e){return U5(e)||B5(e)}function Jae(e){return e.name==="FireIdleCallback"}function Xae(e){return e.name==="SchedulePostMessage"}function Zae(e){return e.name==="HandlePostMessage"}function Qae(e){return e.name==="UpdateCounters"}function eoe(e){return e.name==="DOMStats"}function toe(e){return e.name==="thread_name"}function noe(e){
return e.name==="process_name"}function roe(e){return e.name==="TracingStartedInBrowser"}function aoe(e){return e.name==="FrameCommittedInBrowser"}function ooe(e){return e.name==="CommitLoad"}function ioe(e){return e.name==="Animation"&&e.cat.includes("devtools.timeline")}function soe(e){if(e.name!=="Animation"||!e.cat.includes("devtools.timeline"))return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function coe(e){return e.name==="LayoutShift"}function j5(e){return e.name==="LayoutInvalidationTracking"}function q5(e){return e.name==="firstContentfulPaint"}function z5(e){return e.name==="largestContentfulPaint::Candidate"}function uoe(e){return e.name==="LargestImagePaint::Candidate"}function loe(e){return e.name==="LargestTextPaint::Candidate"}function H5(e){return e.name==="MarkLoad"}function W5(e){return e.name==="firstPaint"}function G5(e){return e.name==="MarkDOMContent"}function V5(e){return e.name==="InteractiveTime"}function Fw(e){return e.name==="EventTimi\
ng"}function doe(e){return Fw(e)&&e.ph==="e"}function moe(e){return Fw(e)&&e.ph==="b"}function poe(e){return e.name==="GPUTask"}function foe(e){return e.name==="Profile"}function hoe(e){return e.name==="CpuProfile"}function goe(e){return e.name==="ProfileChunk"}function yoe(e){return e.name==="ResourceChangePriority"}function voe(e){return e.name==="ResourceSendRequest"}function boe(e){return e.name==="ResourceReceiveResponse"}function woe(e){return e.name==="ResourceMarkAsCached"}function xoe(e){return e.name==="ResourceFinish"}function Doe(e){return e.name==="ResourceWillSendRequest"}function Eoe(e){return e.name==="ResourceReceivedData"}function Toe(e){return e.name==="ResourceReceivedData"||e.name==="ResourceFinish"||e.name==="ResourceReceiveResponse"}function $5(e){return e.name==="SyntheticNetworkRequest"}function Rw(e){return e.name==="SyntheticWebSocketConnection"}function Soe(e){return $5(e)||Rw(e)||Mw(e)}function Coe(e){return e.name==="PrePaint"}function Y5(e){return e.name===
"navigationStart"&&e.args?.data?.documentLoaderURL!==""}function koe(e){return e.name==="RenderFrameHostImpl::DidCommitSameDocumentNavigation"}function Ioe(e){return e.name==="PaintTimingVisualizer::Viewport"}function Aoe(e){if(e.cat!=="blink.user_timing")return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function Foe(e){if(e.cat!=="blink.console")return!1;let t=e.args?.data;return t?"beginEvent"in t&&"endEvent"in t:!1}function _w(e){return e.cat==="blink.user_timing"}function Roe(e){return e.name==="domLoading"}function _oe(e){return e.name==="BeginRemoteFontLoad"}function Moe(e){return e.name==="RemoteFontLoaded"}function K5(e){return _w(e)&&Iw(e.ph)}function Ooe(e){return K5(e)&&e.ph==="b"}function Noe(e){return _w(e)&&(e.ph==="R"||e.ph==="I")}function Poe(e){return e.cat==="blink.console"&&Iw(e.ph)}function Loe(e){return e.ph==="I"&&e.name==="TimeStamp"}function Boe(e){return e.name==="UserTiming::Measure"}function Uoe(e){return e.name==="ParseHTML"}function joe(e){
return e.name==="SyntheticLayoutShift"}function qoe(e){return e.name==="SyntheticLayoutShiftCluster"}function zoe(e){return"callFrame"in e}function Hoe(e){return e.name==="Paint"}function Woe(e){return e.name==="PaintImage"}function Goe(e){return e.name==="ScrollLayer"}function Voe(e){return e.name==="SetLayerTreeId"}function $oe(e){return e.name==="UpdateLayer"}function Yoe(e){return e.name==="cc::DisplayItemList"}function Koe(e){return e.name==="cc::LayerTreeHostImpl"}function Joe(e){return e.name==="FireAnimationFrame"}function Xoe(e){return e.name==="RequestAnimationFrame"}function Zoe(e){return e.name==="TimerInstall"}function Qoe(e){return e.name==="TimerFire"}function eie(e){return e.name==="RequestIdleCallback"}function J5(e){return e.name==="WebSocketCreate"}function X5(e){return e.name==="WebSocketSendHandshakeRequest"||e.name==="WebSocketReceiveHandshakeResponse"||e.name==="WebSocketDestroy"}function Z5(e){return e.name==="WebSocketSend"||e.name==="WebSocketReceive"}function tie(e){
return e.name==="WebSocketSend"}function nie(e){return e.name==="WebSocketReceive"}function rie(e){return e.name==="WebSocketSendHandshakeRequest"}function aie(e){return e.name==="WebSocketReceiveHandshakeResponse"}function oie(e){return e.name==="WebSocketDestroy"}function Mw(e){return J5(e)||X5(e)||Z5(e)}function iie(e){return Mw(e)||Rw(e)}function sie(e){return e.name==="v8.compile"}function cie(e){return e.name==="FunctionCall"}function uie(e){return e.cat==="devtools.server-timing"}function lie(e){return e.name==="SchedulePostTaskCallback"}function die(e){return e.name==="RunPostTaskCallback"}function mie(e){return e.name==="AbortPostTaskCallback"}function pie(e){switch(e.name){case"RunMicrotasks":case"FunctionCall":case"EvaluateScript":case"v8.evaluateModule":case"EventDispatch":case"V8.Execute":case"V8Console::runTask":return!0}return!!(e.name.startsWith("v8")||e.name.startsWith("V8")||Q5(e))}function Q5(e){return e.name==="V8Console::runTask"}function fie(e){return e.ph==="s"||
e.ph==="t"||e.ph==="f"}function gie(e){return"idle"in e&&typeof e.idle=="boolean"}function yie(e){return e.cat==="disabled-by-default-devtools.target-rundown"&&e.name==="ScriptCompiled"}function vie(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown"&&e.name==="ScriptCatchup"}function bie(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown-sources"&&e.name==="ScriptCatchup"}function wie(e){return e.cat==="disabled-by-default-devtools.v8-source-rundown-sources"&&e.name==="LargeScriptCatchup"}var O5,aae,iae,Aw,Tn,hie,Lg=g(()=>{d();i(M5,"isNestableAsyncPhase");i(Iw,"isPhaseAsync");i(Jre,"isFlowPhase");i(Xre,"objectIsCallFrame");i(Zre,"isRunTask");i(Qre,"isAuctionWorkletRunningInProcess");i(eae,"isAuctionWorkletDoneWithProcess");i(tae,"isLegacyScreenshot");i(nae,"isLegacySyntheticScreenshot");i(rae,"isScreenshot");O5=[G5,H5,W5,q5,z5,Y5],aae=["MarkDOMContent","MarkLoad","firstPaint","firstContentfulPaint","largestContentfulPaint::Candidate"];i(oae,"isMarkerEvent");
iae=[...O5,V5];i(sae,"eventIsPageLoadEvent");i(cae,"isTracingSessionIdForWorker");Aw="NO_NAVIGATION";i(N5,"isScheduleStyleInvalidationTracking");i(P5,"isStyleRecalcInvalidationTracking");i(L5,"isStyleInvalidatorInvalidationTracking");i(uae,"isBeginCommitCompositorFrame");i(lae,"isParseMetaViewport");i(dae,"isScheduleStyleRecalculation");i(mae,"isRenderFrameImplCreateChildFrame");i(pae,"isLayoutImageUnsized");i(fae,"isAnimationFrameAsyncStart");i(hae,"isAnimationFrameAsyncEnd");i(gae,"isAnimationFramePresentation");i(yae,"isPipelineReporter");i(vae,"isSyntheticBased");i(bae,"isSyntheticInteraction");i(wae,"isDrawFrame");i(xae,"isBeginFrame");i(Dae,"isDroppedFrame");i(Eae,"isRequestMainThreadFrame");i(Tae,"isBeginMainThreadFrame");i(Sae,"isNeedsBeginFrameChanged");i(Cae,"isCommit");i(kae,"isRasterTask");i(Iae,"isCompositeLayers");i(Aae,"isActivateLayerTree");i(Fae,"isInvalidationTracking");i(Rae,"isDrawLazyPixelRef");i(_ae,"isDecodeLazyPixelRef");i(Mae,"isDecodeImage");(function(e){e.Elapsed=
"elapsed (us)",e.RejectPercentage="reject_percentage",e.FastRejectCount="fast_reject_count",e.MatchAttempts="match_attempts",e.MatchCount="match_count",e.Selector="selector",e.StyleSheetId="style_sheet_id"})(Tn||(Tn={}));i(Oae,"isSelectorStats");i(Nae,"isUpdateLayoutTree");i(Pae,"isLayout");i(Lae,"isInvalidateLayout");i(Bae,"isDebuggerAsyncTaskScheduled");i(Uae,"isDebuggerAsyncTaskRun");i(jae,"ProfileID");i(qae,"CallFrameID");i(zae,"SampleIndex");i(Hae,"ProcessID");i(Wae,"ThreadID");i(Gae,"WorkerId");i(B5,"isComplete");i(Vae,"isBegin");i($ae,"isEnd");i(Yae,"isDispatch");i(U5,"isInstant");i(Kae,"isRendererEvent");i(Jae,"isFireIdleCallback");i(Xae,"isSchedulePostMessage");i(Zae,"isHandlePostMessage");i(Qae,"isUpdateCounters");i(eoe,"isDOMStats");i(toe,"isThreadName");i(noe,"isProcessName");i(roe,"isTracingStartedInBrowser");i(aoe,"isFrameCommittedInBrowser");i(ooe,"isCommitLoad");i(ioe,"isAnimation");i(soe,"isSyntheticAnimation");i(coe,"isLayoutShift");i(j5,"isLayoutInvalidationTracking");
i(q5,"isFirstContentfulPaint");i(z5,"isLargestContentfulPaintCandidate");i(uoe,"isLargestImagePaintCandidate");i(loe,"isLargestTextPaintCandidate");i(H5,"isMarkLoad");i(W5,"isFirstPaint");i(G5,"isMarkDOMContent");i(V5,"isInteractiveTime");i(Fw,"isEventTiming");i(doe,"isEventTimingEnd");i(moe,"isEventTimingStart");i(poe,"isGPUTask");i(foe,"isProfile");i(hoe,"isSyntheticCpuProfile");i(goe,"isProfileChunk");i(yoe,"isResourceChangePriority");i(voe,"isResourceSendRequest");i(boe,"isResourceReceiveResponse");i(woe,"isResourceMarkAsCached");i(xoe,"isResourceFinish");i(Doe,"isResourceWillSendRequest");i(Eoe,"isResourceReceivedData");i(Toe,"isReceivedDataEvent");i($5,"isSyntheticNetworkRequest");i(Rw,"isSyntheticWebSocketConnection");i(Soe,"isNetworkTrackEntry");i(Coe,"isPrePaint");i(Y5,"isNavigationStart");i(koe,"isDidCommitSameDocumentNavigation");i(Ioe,"isMainFrameViewport");i(Aoe,"isSyntheticUserTiming");i(Foe,"isSyntheticConsoleTiming");i(_w,"isUserTiming");i(Roe,"isDomLoading");i(_oe,"isB\
eginRemoteFontLoad");i(Moe,"isRemoteFontLoaded");i(K5,"isPerformanceMeasure");i(Ooe,"isPerformanceMeasureBegin");i(Noe,"isPerformanceMark");i(Poe,"isConsoleTime");i(Loe,"isConsoleTimeStamp");i(Boe,"isUserTimingMeasure");i(Uoe,"isParseHTML");i(joe,"isSyntheticLayoutShift");i(qoe,"isSyntheticLayoutShiftCluster");i(zoe,"isProfileCall");i(Hoe,"isPaint");i(Woe,"isPaintImage");i(Goe,"isScrollLayer");i(Voe,"isSetLayerId");i($oe,"isUpdateLayer");i(Yoe,"isDisplayListItemListSnapshot");i(Koe,"isLayerTreeHostImplSnapshot");i(Joe,"isFireAnimationFrame");i(Xoe,"isRequestAnimationFrame");i(Zoe,"isTimerInstall");i(Qoe,"isTimerFire");i(eie,"isRequestIdleCallback");i(J5,"isWebSocketCreate");i(X5,"isWebSocketInfo");i(Z5,"isWebSocketTransfer");i(tie,"isWebSocketSend");i(nie,"isWebSocketReceive");i(rie,"isWebSocketSendHandshakeRequest");i(aie,"isWebSocketReceiveHandshakeResponse");i(oie,"isWebSocketDestroy");i(Mw,"isWebSocketTraceEvent");i(iie,"isWebSocketEvent");i(sie,"isV8Compile");i(cie,"isFunctionCall");
i(uie,"isSyntheticServerTiming");i(lie,"isSchedulePostTaskCallback");i(die,"isRunPostTaskCallback");i(mie,"isAbortPostTaskCallback");i(pie,"isJSInvocationEvent");i(Q5,"isConsoleRunTask");i(fie,"isFlowPhaseEvent");hie={Console:"blink.console",UserTiming:"blink.user_timing",Loading:"loading"};i(gie,"isLegacyTimelineFrame");i(yie,"isTargetRundownEvent");i(vie,"isV8SourceRundownEvent");i(bie,"isV8SourceRundownSourcesScriptCatchupEvent");i(wie,"isV8SourceRundownSourcesLargeScriptCatchupEvent")});var Pe=g(()=>{d();k5();F5();R5();_5();Lg()});var eo={};E(eo,{addEventToEntityMapping:()=>Nw,addNetworkRequestToEntityMapping:()=>Pw,getEntityForEvent:()=>Ow,getEntityForUrl:()=>e8,getNonResolvedURL:()=>Bg,makeUpEntity:()=>t8});function Ow(e,t){let n=Bg(e);if(n)return e8(n,t)}function e8(e,t){return Gi.default.getEntity(e)??t8(t,e)}function Bg(e,t){if(C.isProfileCall(e))return e.callFrame.url;if(C.isSyntheticNetworkRequest(e))return e.args.data.url;if(e.args?.data?.stackTrace&&e.args.data.stackTrace.length>0)return e.args.data.stackTrace[0].url;if(C.isParseHTML(e))return e.args.beginData.url;if(t){if(C.isDecodeImage(e)){let n=t.ImagePainting.paintImageForEvent.get(e);return n?Bg(n,t):null}if(C.isDrawLazyPixelRef(e)&&e.args?.LazyPixelRef){let n=t.ImagePainting.paintImageByDrawLazyPixelRef.get(e.args.LazyPixelRef);return n?Bg(n,t):null}}return e.args?.data?.url?e.args.data.url:null}function t8(e,t){if(t.startsWith("chrome-extension:"))return Die(e,t);if(!t.startsWith("http"))return;let n=Gi.default.getRootDomain(t);if(!n)return;if(e.
has(n))return e.get(n);let r={name:n,company:n,category:"",categories:[],domains:[n],averageExecutionTime:0,totalExecutionTime:0,totalOccurrences:0,isUnrecognized:!0};return e.set(n,r),r}function xie(e){return e.protocol+"//"+e.host}function Die(e,t,n){let r=new URL(t),a=xie(r),o=new URL(a).host,s=n||o,c=e.get(a);if(c)return c;let u={name:s,company:s,category:"Chrome Extension",homepage:"https://chromewebstore.google.com/detail/"+o,categories:[],domains:[a],averageExecutionTime:0,totalExecutionTime:0,totalOccurrences:0};return e.set(a,u),u}function Nw(e,t){let n=Ow(e,t.createdEntityCache);if(!n||t.entityByEvent.has(e))return;let r=t.eventsByEntity.get(n);r?r.push(e):t.eventsByEntity.set(n,[e]),t.entityByEvent.set(e,n)}function Pw(e,t,n){let r=Ow(e,t.createdEntityCache);if(!r)return;let a=[e,...Object.values(n).flat()],o=t.eventsByEntity.get(r);o?o.push(...a):t.eventsByEntity.set(r,a);for(let s of a)t.entityByEvent.set(s,r)}var Ug=g(()=>{d();Pg();Pe();i(Ow,"getEntityForEvent");i(e8,"get\
EntityForUrl");i(Bg,"getNonResolvedURL");i(t8,"makeUpEntity");i(xie,"getChromeExtensionOrigin");i(Die,"makeUpChromeExtensionEntity");i(Nw,"addEventToEntityMapping");i(Pw,"addNetworkRequestToEntityMapping")});var _n={};E(_n,{DEFAULT_COMPARATOR:()=>Aie,arrayDoesNotContainNullOrUndefined:()=>Mie,binaryIndexOf:()=>Cie,intersectOrdered:()=>kie,lowerBound:()=>r8,mergeOrdered:()=>Iie,nearestIndexFromBeginning:()=>Rie,nearestIndexFromEnd:()=>_ie,removeElement:()=>Eie,sortRange:()=>Sie,upperBound:()=>Fie});function Lw(e,t,n){let r=e[t];e[t]=e[n],e[n]=r}function Tie(e,t,n,r,a){let o=e[a];Lw(e,r,a);let s=n;for(let c=n;c<r;++c)t(e[c],o)<0&&(Lw(e,s,c),++s);return Lw(e,r,s),s}function Bw(e,t,n,r,a,o){if(r<=n)return;let s=Math.floor(Math.random()*(r-n))+n,c=Tie(e,t,n,r,s);a<c&&Bw(e,t,n,c-1,a,o),c<o&&Bw(e,t,c+1,r,a,o)}function Sie(e,t,n,r,a,o){return n===0&&r===e.length-1&&a===0&&o>=r?e.sort(t):Bw(e,t,n,r,a,o),e}function n8(e,t,n,r){let a=[],o=0,s=0;for(;o<e.length&&s<t.length;){let c=n(e[o],t[s]);(r||!c)&&a.push(c<=0?e[o]:t[s]),c<=0&&o++,c>=0&&s++}if(r){for(;o<e.length;)a.push(e[o++]);for(;s<t.length;)a.push(t[s++])}return a}function r8(e,t,n,r,a){let o=r||0,s=a!==void 0?a:e.length;for(;o<s;){let c=o+s>>
1;n(t,e[c])>0?o=c+1:s=c}return s}function Fie(e,t,n,r,a){let o=r||0,s=a!==void 0?a:e.length;for(;o<s;){let c=o+s>>1;n(t,e[c])>=0?o=c+1:s=c}return s}function a8(e,t,n){let r=n==="END";if(e.length===0)return null;let a=0,o=e.length-1,s=0,c=!1,u=!1,l=0;do l=a+(o-a)/2,s=r?Math.ceil(l):Math.floor(l),c=t(e[s]),u=c===r,u?a=Math.min(o,s+(a===s?1:0)):o=Math.max(a,s+(o===s?-1:0));while(o!==a);return t(e[a])?a:null}function Rie(e,t){return a8(e,t,"BEGINNING")}function _ie(e,t){return a8(e,t,"END")}function Mie(e){return!e.includes(null)&&!e.includes(void 0)}var Eie,Cie,kie,Iie,Aie,o8=g(()=>{d();Eie=i((e,t,n)=>{let r=e.indexOf(t);if(r===-1)return!1;if(n)return e.splice(r,1),!0;for(let a=r+1,o=e.length;a<o;++a)e[a]!==t&&(e[r++]=e[a]);return e.length=r,!0},"removeElement");i(Lw,"swap");i(Tie,"partition");i(Bw,"quickSortRange");i(Sie,"sortRange");Cie=i((e,t,n)=>{let r=r8(e,t,n);return r<e.length&&n(t,e[r])===0?r:-1},"binaryIndexOf");i(n8,"mergeOrIntersect");kie=i((e,t,n)=>n8(e,t,n,!1),"intersectOrder\
ed"),Iie=i((e,t,n)=>n8(e,t,n,!0),"mergeOrdered"),Aie=i((e,t)=>e<t?-1:e>t?1:0,"DEFAULT_COMPARATOR");i(r8,"lowerBound");i(Fie,"upperBound");i(a8,"nearestIndex");i(Rie,"nearestIndexFromBeginning");i(_ie,"nearestIndexFromEnd");i(Mie,"arrayDoesNotContainNullOrUndefined")});var i8=g(()=>{d()});var s8=g(()=>{d()});var c8=g(()=>{d()});var u8=g(()=>{d()});var l8=g(()=>{d()});var d8=g(()=>{d()});var Me={};E(Me,{Multimap:()=>jg,getWithDefault:()=>Uie,inverse:()=>Bie});function Uie(e,t,n){let r=e.get(t);return r==null&&(r=n(t),e.set(t,r)),r}var Bie,jg,m8=g(()=>{d();Bie=i(function(e){let t=new jg;for(let[n,r]of e.entries())t.set(r,n);return t},"inverse"),jg=class{static{i(this,"Multimap")}map=new Map;set(t,n){let r=this.map.get(t);r||(r=new Set,this.map.set(t,r)),r.add(n)}get(t){return this.map.get(t)||new Set}has(t){return this.map.has(t)}hasValue(t,n){let r=this.map.get(t);return r?r.has(n):!1}get size(){return this.map.size}delete(t,n){let r=this.get(t);if(!r)return!1;let a=r.delete(n);return r.size||this.map.delete(t),a}deleteAll(t){this.map.delete(t)}keysArray(){return[...this.map.keys()]}keys(){return this.map.keys()}valuesArray(){let t=[];for(let n of this.map.values())t.push(...n.values());return t}clear(){this.map.clear()}};i(Uie,"getWithDefault")});var p8=g(()=>{d()});var _u={};E(_u,{aspectRatio:()=>Vie,clamp:()=>qie,floor:()=>Wie,greatestCommonDivisor:()=>f8,mod:()=>zie,toFixedIfFloating:()=>Hie,withThousandsSeparator:()=>$ie});var qie,zie,Hie,Wie,f8,Gie,Vie,$ie,h8=g(()=>{d();qie=i((e,t,n)=>{let r=e;return e<t?r=t:e>n&&(r=n),r},"clamp"),zie=i((e,t)=>(e%t+t)%t,"mod"),Hie=i(e=>{if(!e||Number.isNaN(Number(e)))return e;let t=Number(e);return t%1?t.toFixed(3):String(t)},"toFixedIfFloating"),Wie=i((e,t=0)=>{if(t>0&&t<1)return t=1/t,Math.floor(e/t)*t;let n=Math.pow(10,t);return Math.floor(e*n)/n},"floor"),f8=i((e,t)=>{for(e=Math.round(e),t=Math.round(t);t!==0;){let n=t;t=e%t,e=n}return e},"greatestCommonDivisor"),Gie=new Map([["8∶5","16∶10"]]),Vie=i((e,t)=>{let n=f8(e,t);n!==0&&(e/=n,t/=n);let r=`${e}∶${t}`;return Gie.get(r)||r},"aspectRatio"),$ie=i(function(e){let t=String(e),n=/(\d+)(\d{3})/;for(;t.match(n);)t=t.replace(n,"$1 $2");return t},"withThousandsSeparator")});var g8,Uw=g(()=>{d();g8=i((e,t)=>e>t?1:e<t?-1:0,"compare")});var qg={};E(qg,{ServerTiming:()=>jw});var y8,jw,v8=g(()=>{d();Uw();y8={deprecratedSyntax(){return"Deprecated syntax found. Please use: <name>;dur=<duration>;desc=<description>"},duplicateParameter(e){return`Duplicate parameter "${e}" ignored.`},noValueFoundForParameter(e){return`No value found for parameter "${e}".`},unrecognizedParameter(e){return`Unrecognized parameter "${e}".`},extraneousTrailingCharacters(){return"Extraneous trailing characters."},unableToParseValue(e,t){return`Unable to parse "${e}" value "${t}".`}},jw=class e{static{i(this,"ServerTiming")}metric;value;description;start;constructor(t,n,r,a){this.metric=t,this.value=n,this.description=r,this.start=a}static parseHeaders(t,n=y8){let r=t.filter(o=>o.name.toLowerCase()==="server-timing");if(!r.length)return null;let a=r.reduce((o,s)=>{let c=this.createFromHeaderValue(s.value,n);return o.push(...c.map(function(u){return new e(u.name,u.hasOwnProperty("dur")?u.dur:null,u.hasOwnProperty("desc")?u.desc:"",u.hasOwnProperty("\
start")?u.start:null)})),o},[]);return a.sort((o,s)=>g8(o.metric.toLowerCase(),s.metric.toLowerCase())),a}static createFromHeaderValue(t,n=y8){function r(){t=t.replace(/^\s*/,"")}i(r,"trimLeadingWhiteSpace");function a(p){return console.assert(p.length===1),r(),t.charAt(0)!==p?!1:(t=t.substring(1),!0)}i(a,"consumeDelimiter");function o(){let p=/^(?:\s*)([\w!#$%&'*+\-.^`|~]+)(?:\s*)(.*)/.exec(t);return p?(t=p[2],p[1]):null}i(o,"consumeToken");function s(){return r(),t.charAt(0)==='"'?c():o()}i(s,"consumeTokenOrQuotedString");function c(){console.assert(t.charAt(0)==='"'),t=t.substring(1);let p="";for(;t.length;){let f=/^([^"\\]*)(.*)/.exec(t);if(!f)return null;if(p+=f[1],f[2].charAt(0)==='"')return t=f[2].substring(1),p;console.assert(f[2].charAt(0)==="\\"),p+=f[2].charAt(1),t=f[2].substring(2)}return null}i(c,"consumeQuotedString");function u(){let p=/([,;].*)/.exec(t);p&&(t=p[1])}i(u,"consumeExtraneous");let l=[],m;for(;(m=o())!==null;){let p={name:m};for(t.charAt(0)==="="&&this.showWarning(
n.deprecratedSyntax());a(";");){let f;if((f=o())===null)continue;f=f.toLowerCase();let h=this.getParserForParameter(f,n),y=null;if(a("=")&&(y=s(),u()),h){if(p.hasOwnProperty(f)){this.showWarning(n.duplicateParameter(f));continue}y===null&&this.showWarning(n.noValueFoundForParameter(f)),h.call(this,p,y)}else this.showWarning(n.unrecognizedParameter(f))}if(l.push(p),!a(","))break}return t.length&&this.showWarning(n.extraneousTrailingCharacters()),l}static getParserForParameter(t,n){switch(t){case"dur":{let r=function(a,o){if(a.dur=0,o!==null){let s=parseFloat(o);if(isNaN(s)){e.showWarning(n.unableToParseValue(t,o));return}a.dur=s}};return i(r,"durParser"),r}case"start":{let r=function(a,o){if(a.start=null,o!==null){let s=parseFloat(o);if(isNaN(s)){e.showWarning(n.unableToParseValue(t,o));return}a.start=s}};return i(r,"startParser"),r}case"desc":{let r=function(a,o){a.desc=o||""};return i(r,"descParser"),r}default:return null}}static showWarning(t){console.warn(`ServerTiming: ${t}`)}}});var b8=g(()=>{d()});var w8=g(()=>{d()});function Zd(e,t){throw new Error(t)}var qw=g(()=>{d();i(Zd,"assertNever")});var x8=g(()=>{d()});var D8=g(()=>{d()});var dn=g(()=>{d();o8();i8();s8();c8();u8();l8();d8();m8();p8();h8();v8();Uw();b8();w8();qw();x8();D8();qw()});var xn={};E(xn,{SyntheticEventsManager:()=>Qd});var zg,Qd,zw=g(()=>{d();zg=null,Qd=class e{static{i(this,"SyntheticEventsManager")}#e=[];#t=[];static activate(t){zg=t}static createAndActivate(t){let n=new e(t);return e.activate(n),n}static getActiveManager(){if(!zg)throw new Error("Attempted to get a SyntheticEventsManager without initializing");return zg}static reset(){zg=null}static registerSyntheticEvent(t){try{return e.getActiveManager().registerSyntheticEvent(t)}catch{return t}}static registerServerTiming(t){return t}constructor(t){this.#t=t}registerSyntheticEvent(t){let n=this.#t.indexOf(t.rawSourceEvent);if(n<0)throw new Error("Attempted to register a synthetic event paired to an unknown raw event.");let r=t;return this.#e[n]=r,r}syntheticEventForRawEventIndex(t){let n=this.#e.at(t);if(!n)throw new Error(`Attempted to get a synthetic event from an unknown raw event index: ${t}`);return n}getSyntheticTraces(){return this.#e}getRawTraceEvents(){return this.#t}}});var ue={};E(ue,{boundsIncludeTimeRange:()=>lse,eventIsInBounds:()=>Hw,eventTimingsMicroSeconds:()=>em,eventTimingsMilliSeconds:()=>ase,expandWindowByPercentOrToOneMillisecond:()=>rse,microToMilli:()=>sc,microToSeconds:()=>tse,milliToMicro:()=>Vi,secondsToMicro:()=>ese,secondsToMilli:()=>E8,timeStampForEventAdjustedByClosestNavigation:()=>nse,timestampIsInBounds:()=>dse,traceWindowFromEvent:()=>use,traceWindowFromMicroSeconds:()=>cse,traceWindowFromMilliSeconds:()=>sse,traceWindowMicroSecondsToMilliSeconds:()=>ise,traceWindowMilliSeconds:()=>ose,windowFitsInsideBounds:()=>mse,windowsEqual:()=>pse});function nse(e,t,n,r){let a=e.ts-t.min;if(e.args?.data?.navigationId){let o=n.get(e.args.data.navigationId);o&&(a=e.ts-o.ts)}else if(e.args?.data?.frame){let o=Ww(e,e.args.data.frame,r);o&&(a=e.ts-o.ts)}return O.Micro(a)}function rse(e,t,n){let r=e.min-e.range*(n/100)/2,a=e.max+e.range*(n/100)/2;if(a-r<1e3){let s=(e.min+e.max)/2;r=s-500,a=s+500}return r=Math.max(r,t.min),a=Math.min(a,t.max),{
min:O.Micro(r),max:O.Micro(a),range:O.Micro(a-r)}}function em(e){return{startTime:e.ts,endTime:e.ts+(e.dur??0),duration:e.dur||0}}function ase(e){return{startTime:e.ts/1e3,endTime:(e.ts+(e.dur??0))/1e3,duration:(e.dur||0)/1e3}}function ose(e){return{min:sc(e.min),max:sc(e.max),range:sc(e.range)}}function ise(e){return{min:sc(e.min),max:sc(e.max),range:sc(e.range)}}function sse(e,t){return{min:Vi(e),max:Vi(t),range:O.Micro(Vi(t)-Vi(e))}}function cse(e,t){return{min:e,max:t,range:O.Micro(t-e)}}function use(e){return{min:e.ts,max:O.Micro(e.ts+(e.dur??0)),range:e.dur??O.Micro(0)}}function lse(e){let{min:t,max:n}=e.bounds,{min:r,max:a}=e.timeRange;return t<=a&&n>=r}function Hw(e,t){let n=e.ts;return n<=t.max&&t.min<=n+(e.dur??0)}function dse(e,t){return t>=e.min&&t<=e.max}function mse(e){return e.window.min>=e.bounds.min&&e.window.max<=e.bounds.max}function pse(e,t){return e.min===t.min&&e.max===t.max}var Vi,E8,ese,sc,tse,tm=g(()=>{d();Pe();nm();Vi=i(e=>O.Micro(e*1e3),"milliToMicro"),E8=i(e=>O.
Milli(e*1e3),"secondsToMilli"),ese=i(e=>Vi(E8(e)),"secondsToMicro"),sc=i(e=>O.Milli(e/1e3),"microToMilli"),tse=i(e=>O.Seconds(e/1e3/1e3),"microToSeconds");i(nse,"timeStampForEventAdjustedByClosestNavigation");i(rse,"expandWindowByPercentOrToOneMillisecond");i(em,"eventTimingsMicroSeconds");i(ase,"eventTimingsMilliSeconds");i(ose,"traceWindowMilliSeconds");i(ise,"traceWindowMicroSecondsToMilliSeconds");i(sse,"traceWindowFromMilliSeconds");i(cse,"traceWindowFromMicroSeconds");i(use,"traceWindowFromEvent");i(lse,"boundsIncludeTimeRange");i(Hw,"eventIsInBounds");i(dse,"timestampIsInBounds");i(mse,"windowFitsInsideBounds");i(pse,"windowsEqual")});var We={};E(We,{activeURLForFrameAtTime:()=>gse,addEventToProcessThread:()=>hse,createMatchedSortedSyntheticEvents:()=>yse,createSortedSyntheticEvents:()=>k8,eventContainsTimestamp:()=>Fse,eventHasCategory:()=>Ise,eventTimeComparator:()=>$w,extractId:()=>S8,extractOriginFromTrace:()=>fse,extractSampleTraceId:()=>Wg,findNextEventAfterTimestamp:()=>Tse,findPreviousEventBeforeTimestamp:()=>Sse,findUpdateLayoutTreeEvents:()=>Ese,forEachEvent:()=>Cse,frameIDForEvent:()=>xse,getNavigationForTraceEvent:()=>Ww,getZeroIndexedLineAndColumnForEvent:()=>vse,getZeroIndexedStackTraceForEvent:()=>bse,isMatchingCallFrame:()=>Ase,isTopLevelEvent:()=>I8,makeProfileCall:()=>Hg,makeZeroBasedCallFrame:()=>Vw,matchEvents:()=>C8,mergeEventsInOrder:()=>Kw,sortTraceEventsInPlace:()=>Yw,stackTraceInEvent:()=>T8});function T8(e){if(e.args?.data?.stackTrace)return e.args.data.stackTrace;if(e.args?.stackTrace)return e.args.stackTrace;if(C.isUpdateLayoutTree(e))return e.args.beginData?.stackTrace||null;if(C.isLayout(
e))return e.args.beginData.stackTrace??null;if(C.isFunctionCall(e)){let t=e.args.data;if(!t)return null;let{columnNumber:n,lineNumber:r,url:a,scriptId:o,functionName:s}=t;return r===void 0||s===void 0||n===void 0||o===void 0||a===void 0?null:[{columnNumber:n,lineNumber:r,url:a,scriptId:o,functionName:s}]}if(C.isProfileCall(e)){let t=e.callFrame;if(!t)return null;let{columnNumber:n,lineNumber:r,url:a,scriptId:o,functionName:s}=t;return r===void 0||s===void 0||n===void 0||o===void 0||a===void 0?null:[{columnNumber:n,lineNumber:r,url:a,scriptId:o,functionName:s}]}return null}function fse(e){let t=new URL(e);return t?t.host.startsWith("www.")?t.host.slice(4):t.host:null}function hse(e,t){let{tid:n,pid:r}=e,a=t.get(r);a||(a=new Map);let o=a.get(n);o||(o=[]),o.push(e),a.set(e.tid,o),t.set(e.pid,a)}function $w(e,t){let n=e.ts,r=t.ts;if(n<r)return-1;if(n>r)return 1;let a=e.dur??0,o=t.dur??0,s=n+a,c=r+o;return s>c?-1:s<c?1:C.isProfileCall(e)&&!C.isProfileCall(t)?-1:C.isProfileCall(t)&&!C.isProfileCall(
e)?1:0}function Yw(e){e.sort($w)}function Kw(e,t){let n=[],r=0,a=0;for(;r<e.length&&a<t.length;){let o=e[r],s=t[a],c=$w(o,s);c<=0&&(n.push(o),r++),c===1&&(n.push(s),a++)}for(;r<e.length;)n.push(e[r++]);for(;a<t.length;)n.push(t[a++]);return n}function Ww(e,t,n){let r=n.get(t);if(!r||t==="")return null;let a=_n.nearestIndexFromEnd(r,o=>o.ts<=e.ts);return a===null?null:r[a]}function S8(e){return e.id??e.id2?.global??e.id2?.local}function gse(e,t,n){let r=n.get(e);if(!r)return null;for(let a of r.values())for(let o of a)if(!(o.window.min>t||o.window.max<t))return o.frame.url;return null}function Hg(e,t,n,r,a,o){return{cat:"",name:"ProfileCall",nodeId:e.id,args:{},ph:"X",pid:a,tid:o,ts:r,dur:O.Micro(0),callFrame:e.callFrame,sampleIndex:n,profileId:t}}function C8(e){let t=new Map;for(let n of e){let r=Gw(n);if(r===void 0)continue;let a=Me.getWithDefault(t,r,()=>({begin:null,end:null,instant:[]})),o=n.ph==="b",s=n.ph==="e",c=n.ph==="n";o?a.begin=n:s?a.end=n:c&&(a.instant||(a.instant=[]),a.instant.
push(n))}return t}function Gw(e){let t=S8(e);return t&&`${e.cat}:${t}:${e.name}`}function k8(e,t){let n=[];for(let[r,a]of e.entries()){let l=function(f){let h=f.instantEvents?f.instantEvents.some(b=>r===Gw(b)):!1,y=f.endEvent?r===Gw(f.endEvent):!1;return!!r&&(h||y)};i(l,"eventsArePairable");let o=a.begin,s=a.end,c=a.instant;if(!o||!(s||c))continue;let u={beginEvent:o,endEvent:s,instantEvents:c};if(!l(u))continue;let m=s||o,p=Qd.registerSyntheticEvent({rawSourceEvent:u.beginEvent,cat:m.cat,ph:m.ph,pid:m.pid,tid:m.tid,id:r,name:o.name,dur:O.Micro(m.ts-o.ts),ts:o.ts,args:{data:u}});p.dur<0||(t?.(p),n.push(p))}return n.sort((r,a)=>r.ts-a.ts)}function yse(e,t){let n=C8(e);return k8(n,t)}function vse(e){let t=wse(e),{lineNumber:n,columnNumber:r}=t;switch(e.name){case"FunctionCall":case"EvaluateScript":case"v8.compile":case"v8.produceCache":return{lineNumber:typeof n=="number"?n-1:void 0,columnNumber:typeof r=="number"?r-1:void 0};case"ProfileCall":{let a=e.callFrame;return{lineNumber:typeof n==
"number"?a.lineNumber-1:void 0,columnNumber:typeof r=="number"?a.columnNumber-1:void 0}}default:return t}}function bse(e){let t=T8(e);return t?t.map(n=>{switch(e.name){case"ScheduleStyleRecalculation":case"InvalidateLayout":case"FunctionCall":case"Layout":case"UpdateLayoutTree":return Vw(n);default:if(C.isUserTiming(e)||ka.isSyntheticExtensionEntry(e))return Vw(n)}return n}):null}function Vw(e){let t={...e};return t.lineNumber=e.lineNumber&&e.lineNumber-1,t.columnNumber=e.columnNumber&&e.columnNumber-1,t}function wse(e){if(!e.args?.data)return{lineNumber:void 0,columnNumber:void 0};let t,n;return"lineNumber"in e.args.data&&typeof e.args.data.lineNumber=="number"&&(t=e.args.data.lineNumber),"columnNumber"in e.args.data&&typeof e.args.data.columnNumber=="number"&&(n=e.args.data.columnNumber),{lineNumber:t,columnNumber:n}}function xse(e){return e.args&&"beginData"in e.args&&typeof e.args.beginData=="object"&&e.args.beginData!==null&&"frame"in e.args.beginData&&typeof e.args.beginData.frame==
"string"?e.args.beginData.frame:e.args?.data?.frame?e.args.data.frame:null}function I8(e){return e.name==="JSRoot"&&e.cat==="toplevel"?!0:e.cat.includes(Dse)&&e.name==="RunTask"}function A8(e,t){let n=_n.upperBound(e,t,(r,a)=>r-a.ts)-1;for(;n>0&&!I8(e[n]);)n--;return Math.max(n,0)}function Ese(e,t,n){let r=[],a=A8(e,t);for(let o=a;o<e.length;o++){let s=e[o];C.isUpdateLayoutTree(s)&&(s.ts>=(n||1/0)||r.push(s))}return r}function Tse(e,t){let n=_n.nearestIndexFromBeginning(e,r=>t<r.ts);return n===null?null:e[n]}function Sse(e,t){let n=_n.nearestIndexFromEnd(e,r=>r.ts<t);return n===null?null:e[n]}function Cse(e,t){let n=t.startTime??O.Micro(0),r=t.endTime||O.Micro(1/0),a=t.ignoreAsyncEvents!==!1,o=[],s=A8(e,n);for(let c=s;c<e.length;c++){let u=e[c],l=em(u);if(l.endTime<n)continue;if(l.startTime>r)break;if(a&&C.isPhaseAsync(u.ph)||C.isFlowPhase(u.ph))continue;let p=o.at(-1),f=p?em(p).endTime:null;for(;p&&f&&f<=l.startTime;)o.pop(),t.onEndEvent(p),p=o.at(-1),f=p?em(p).endTime:null;t.eventFilter&&
!t.eventFilter(u)||(l.duration?(t.onStartEvent(u),o.push(u)):t.onInstantEvent&&t.onInstantEvent(u))}for(;o.length;){let c=o.pop();c&&t.onEndEvent(c)}}function Ise(e,t){let n=kse.get(e.cat);return n||(n=new Set(e.cat.split(",")||[])),n.has(t)}function Ase(e,t){return e.columnNumber===t.columnNumber&&e.lineNumber===t.lineNumber&&String(e.scriptId)===t.scriptId&&e.url===t.url&&e.functionName===t.functionName}function Fse(e,t){return e.ts<=t&&e.ts+(e.dur||0)>=t}function Wg(e){return e.args?"beginData"in e.args?e.args.beginData.sampleTraceId??null:e.args?.sampleTraceId??e.args?.data?.sampleTraceId??null:null}var Dse,kse,nm=g(()=>{d();dn();Pe();zw();tm();i(T8,"stackTraceInEvent");i(fse,"extractOriginFromTrace");i(hse,"addEventToProcessThread");i($w,"eventTimeComparator");i(Yw,"sortTraceEventsInPlace");i(Kw,"mergeEventsInOrder");i(Ww,"getNavigationForTraceEvent");i(S8,"extractId");i(gse,"activeURLForFrameAtTime");i(Hg,"makeProfileCall");i(C8,"matchEvents");i(Gw,"getSyntheticId");i(k8,"createS\
ortedSyntheticEvents");i(yse,"createMatchedSortedSyntheticEvents");i(vse,"getZeroIndexedLineAndColumnForEvent");i(bse,"getZeroIndexedStackTraceForEvent");i(Vw,"makeZeroBasedCallFrame");i(wse,"getRawLineAndColumnNumbersForEvent");i(xse,"frameIDForEvent");Dse="disabled-by-default-devtools.timeline";i(I8,"isTopLevelEvent");i(A8,"topLevelEventIndexEndingAfter");i(Ese,"findUpdateLayoutTreeEvents");i(Tse,"findNextEventAfterTimestamp");i(Sse,"findPreviousEventBeforeTimestamp");i(Cse,"forEachEvent");kse=new Map;i(Ise,"eventHasCategory");i(Ase,"isMatchingCallFrame");i(Fse,"eventContainsTimestamp");i(Wg,"extractSampleTraceId")});var $i={};E($i,{canBuildTreesFromEvents:()=>Qw,makeEmptyTraceEntryNode:()=>_8,makeEmptyTraceEntryTree:()=>R8,makeTraceEntryNodeId:()=>F8,treify:()=>Xw,walkEntireTree:()=>_se,walkTreeFromEntry:()=>Rse});function Xw(e,t){let n=new Map,r=[];Jw=-1;let a=R8();for(let o=0;o<e.length;o++){let s=e[o];if(t&&!t.filter.has(s.name))continue;let c=s.dur||0,u=F8(),l=_8(s,u);if(r.length===0){a.roots.add(l),l.selfTime=O.Micro(c),r.push(l),a.maxDepth=Math.max(a.maxDepth,r.length),n.set(s,l);continue}let m=r.at(-1);if(m===void 0)throw new Error("Impossible: no parent node found in the stack");let p=m.entry,f=s.ts,h=p.ts,y=p.dur||0,b=f+c,w=h+y;if(f<h)throw new Error("Impossible: current event starts before the parent event");if(f>=w){r.pop(),o--,Jw--;continue}b>w||(l.depth=r.length,l.parent=m,m.children.push(l),l.selfTime=O.Micro(c),m.selfTime!==void 0&&(m.selfTime=O.Micro(m.selfTime-(s.dur||0))),r.push(l),a.maxDepth=Math.max(a.maxDepth,r.length),n.set(s,l))}return{tree:a,entryToNode:n}}function Rse(e,t,n,r){
let a=e.get(t);a&&Zw(e,a,n,r)}function _se(e,t,n,r,a,o){for(let s of t.roots)Zw(e,s,n,r,a,o)}function Zw(e,t,n,r,a,o){if(!(a&&!Mse(t,a))&&!(typeof o<"u"&&O.Micro(t.entry.ts+O.Micro(t.entry.dur??0))<o)){n(t.entry);for(let s of t.children)Zw(e,s,n,r,a,o);r(t.entry)}}function Mse(e,t){return Hw(e.entry,t)}function Qw(e){let t=[];for(let n of e){let r=n.ts,a=n.ts+(n.dur??0),o=t.at(-1);if(o===void 0){t.push(n);continue}let s=o.ts+(o.dur??0);for(;t.length&&r>=s&&(t.pop(),o=t.at(-1),o!==void 0);)s=o.ts+(o.dur??0);if(t.length&&a>s)return!1;t.push(n)}return!0}var Jw,F8,R8,_8,ex=g(()=>{d();Pe();tm();Jw=0,F8=i(()=>++Jw,"makeTraceEntryNodeId"),R8=i(()=>({roots:new Set,maxDepth:0}),"makeEmptyTraceEntryTree"),_8=i((e,t)=>({entry:e,id:t,parent:null,children:[],depth:0}),"makeEmptyTraceEntryNode");i(Xw,"treify");i(Rse,"walkTreeFromEntry");i(_se,"walkEntireTree");i(Zw,"walkTreeByNode");i(Mse,"treeNodeIsInWindow");i(Qw,"canBuildTreesFromEvents")});var Gg={};E(Gg,{buildTrackDataFromExtensionEntries:()=>Ose});function Ose(e,t,n){let r=new Map;for(let a of e){let o=a.args.trackGroup||`track-name-${a.args.track}`,s=Me.getWithDefault(r,o,()=>({name:a.args.trackGroup||a.args.track,isTrackGroup:!!a.args.trackGroup,entriesByTrack:{[a.args.track]:[]}}));s.entriesByTrack[a.args.track]||(s.entriesByTrack[a.args.track]=[]),s.entriesByTrack[a.args.track].push(a)}for(let a of r.values()){for(let o of Object.values(a.entriesByTrack))if(Yw(o),Qw(o))for(let[s,c]of Xw(o).entryToNode)n.set(s,c);t.push(a)}return{extensionTrackData:t,entryToNode:n}}var M8=g(()=>{d();dn();nm();ex();i(Ose,"buildTrackDataFromExtensionEntries")});var Rr={};E(Rr,{CACHEABLE_STATUS_CODES:()=>Use,NON_NETWORK_SCHEMES:()=>qse,STATIC_RESOURCE_TYPES:()=>jse,isSyntheticNetworkRequestEventRenderBlocking:()=>Pse,isSyntheticNetworkRequestHighPriority:()=>Bse,parseCacheControl:()=>zse});function Pse(e){return!Nse.has(e.args.data.renderBlocking)}function Bse(e){return Lse.has(e.args.data.priority)}function zse(e){if(!e)return null;let t=e.split(",").map(r=>r.trim()),n={};for(let r of t){let[a,o]=r.split("=").map(s=>s.trim());switch(a){case"max-age":{let s=parseInt(o,10);isNaN(s)||(n["max-age"]=s);break}case"no-cache":n["no-cache"]=!0;break;case"no-store":n["no-store"]=!0;break;case"must-revalidate":n["must-revalidate"]=!0;break;case"private":n.private=!0;break;default:break}}return n}var Nse,Lse,Use,jse,qse,O8=g(()=>{d();Nse=new Set(["non_blocking","dynamically_injected_non_blocking","potentially_blocking"]);i(Pse,"isSyntheticNetworkRequestEventRenderBlocking");Lse=new Set(["VeryHigh","High","Medium"]);i(Bse,"isSyntheticNetworkRequestHighPri\
ority");Use=new Set([200,203,206]),jse=new Set(["Font","Image","Media","Script","Stylesheet"]),qse=["blob","data","intent","file","filesystem","chrome-extension"];i(zse,"parseCacheControl")});var Vg={};E(Vg,{SamplesIntegrator:()=>tx});var tx,N8=g(()=>{d();Pe();tm();nm();tx=class e{static{i(this,"SamplesIntegrator")}#e=[];#t=[];#o;#r;#a=[];#u={};#i=!1;#n;#c=new Map;#s;#l;jsSampleEvents=[];constructor(t,n,r,a,o){this.#n=t,this.#r=a,this.#o=r,this.#s=o||Qa.defaults(),this.#l=n}buildProfileCalls(t){let n=Kw(t,this.callsFromProfileSamples()),r=[];for(let a=0;a<n.length;a++){let o=n[a];if(o.ph==="I"&&!Wg(o))continue;if(r.length===0){if(C.isProfileCall(o)){this.#m(o);continue}r.push(o),this.#g(o);continue}let s=r.at(-1);if(s===void 0)continue;let c=o.ts,u=s.ts,l=s.dur||0,m=u+l;if(c>=m){this.#p(s),r.pop(),a--;continue}if(C.isProfileCall(o)){this.#m(o,s);continue}this.#g(o),r.push(o)}for(;r.length;){let a=r.pop();a&&this.#p(a)}return this.#e}#g(t){(t.name==="RunMicrotasks"||t.name==="RunTask")&&(this.#a=[],this.#h(0,t.ts),this.#i=!1),this.#i&&(this.#h(this.#a.pop()||0,t.ts),this.#i=!1),this.#f(t),this.#a.push(this.#t.length)}#m(t,n){if(n&&C.isJSInvocationEvent(n)||this.#i)this.#f(t);else if(C.
isProfileCall(t)&&this.#t.length===0){this.#i=!0;let r=this.#t.length;this.#f(t),this.#a.push(r)}}#p(t){let n=O.Micro(t.ts+(t.dur??0));this.#h(this.#a.pop()||0,n)}callsFromProfileSamples(){let t=this.#n.samples,n=this.#n.timestamps,r=this.#s.debugMode;if(!t)return[];let a=[],o;for(let s=0;s<t.length;s++){let c=this.#n.nodeByIndex(s),u=Vi(O.Milli(n[s]));if(!c)continue;let l=this.#n.traceIds?.[s],m=Hg(c,this.#l,s,u,this.#o,this.#r);if(l===void 0?a.push(m):this.#u[l]=m,r){let p=this.#n.traceIds?.[s];this.jsSampleEvents.push(this.#v(m,u,p))}if(c.id===this.#n.gcNode?.id&&o){this.#c.set(m,o);continue}o=c}return a}#d(t,n){let r=this.#n.nodeById(t.nodeId),a=r?.id===this.#n.gcNode?.id;if(a&&(r=this.#c.get(t)||null),!r)return[];let o=new Array(r.depth+1+Number(a)),s=o.length-1;for(a&&(o[s--]=t);r;)o[s--]=Hg(r,t.profileId,t.sampleIndex,n??t.ts,this.#o,this.#r),r=r.parent;return o}#f(t){let n=this.#t;C.isProfileCall(t)&&(n=this.#d(t));let r=Wg(t);if(r!==null){let c=this.#u[r];c&&(n=this.#d(c,t.ts))}
e.filterStackFrames(n,this.#s);let a=t.ts+(t.dur||0),o=Math.min(n.length,this.#t.length),s;for(s=this.#a.at(-1)||0;s<o;++s){let c=n[s].callFrame,u=this.#t[s].callFrame;if(!e.framesAreEqual(c,u))break;this.#t[s].dur=O.Micro(Math.max(this.#t[s].dur||0,a-this.#t[s].ts))}for(this.#h(s,t.ts);s<n.length;++s){let c=n[s];c.nodeId===this.#n.programNode?.id||c.nodeId===this.#n.root?.id||c.nodeId===this.#n.idleNode?.id||c.nodeId===this.#n.gcNode?.id||(this.#t.push(c),this.#e.push(c))}}#h(t,n){if(this.#a.length){let r=this.#a.at(-1);r&&t<r&&(console.error(`Child stack is shallower (${t}) than the parent stack (${r}) at ${n}`),t=r)}this.#t.length<t&&(console.error(`Trying to truncate higher than the current stack size at ${n}`),t=this.#t.length);for(let r=0;r<this.#t.length;++r)this.#t[r].dur=O.Micro(Math.max(n-this.#t[r].ts,0));this.#t.length=t}#v(t,n,r){return{name:"JSSample",cat:"devtools.timeline",args:{data:{traceId:r,stackTrace:this.#d(t).map(o=>o.callFrame)}},ph:"I",ts:n,dur:O.Micro(0),pid:this.#o,
tid:this.#r}}static framesAreEqual(t,n){return t.scriptId===n.scriptId&&t.functionName===n.functionName&&t.lineNumber===n.lineNumber}static showNativeName(t,n){return n&&!!e.nativeGroup(t)}static nativeGroup(t){return t.startsWith("Parse")?"Parse":t.startsWith("Compile")||t.startsWith("Recompile")?"Compile":null}static isNativeRuntimeFrame(t){return t.url==="native V8Runtime"}static filterStackFrames(t,n){if(n.showAllEvents)return;let a=null,o=0;for(let s=0;s<t.length;++s){let c=t[s].callFrame,u=e.isNativeRuntimeFrame(c);if(u&&!e.showNativeName(c.functionName,n.includeRuntimeCallStats))continue;let l=u?e.nativeGroup(c.functionName):null;a&&a===l||(a=l,t[o++]=t[s])}t.length=o}static createFakeTraceFromCpuProfile(t,n){let r=[],a=`Thread ${n}`;if(o("TracingStartedInPage",{data:{sessionId:"1"}},0,0,"M"),o("thread_name",{name:a},0,0,"M","__metadata"),!t)return{traceEvents:r,metadata:{}};return o("JSRoot",{},t.startTime,t.endTime-t.startTime,"X","toplevel"),o("CpuProfile",{data:{cpuProfile:t}},
t.endTime,0,"X"),{traceEvents:r,metadata:{dataOrigin:"CPUProfile"}};function o(s,c,u,l,m,p){let f={cat:p||"disabled-by-default-devtools.timeline",name:s,ph:m||"X",pid:C.ProcessID(1),tid:n,ts:O.Micro(u),args:c};return l&&(f.dur=O.Micro(l)),r.push(f),f}i(o,"appendEvent")}}});var ut=g(()=>{d();M8();O8();N8();zw();tm();nm();ex()});var ox={};E(ox,{data:()=>Vse,deps:()=>$se,finalize:()=>Gse,handleEvent:()=>Wse,reset:()=>Hse});function P8(e){return`${e.pid}-${e.tid}`}function Hse(){$g.clear(),Yg.clear(),rx.length=0,ax.clear(),nx.clear()}function Wse(e){if(C.isAnimationFrameAsyncStart(e)){let t=P8(e),n=$g.get(t)??[];n.push(e),$g.set(t,n)}else if(C.isAnimationFrameAsyncEnd(e)){let t=P8(e),n=Yg.get(t)??[];n.push(e),Yg.set(t,n)}else C.isAnimationFramePresentation(e)&&e.args?.id&&nx.set(e.args.id,e)}async function Gse(){for(let[e,t]of $g.entries()){let n=Yg.get(e);if(n){We.sortTraceEventsInPlace(t),We.sortTraceEventsInPlace(n);for(let r=0;r<t.length;r++){let a=n.at(r);if(!a)break;let o=t[r],s=xn.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:o,...o,dur:O.Micro(a.ts-o.ts),args:{data:{beginEvent:o,endEvent:a}}});rx.push(s);let c=o.args?.id;if(c){let u=nx.get(c);u&&ax.set(s,u)}}}}}function Vse(){return{animationFrames:rx,presentationForFrame:ax}}function $se(){return["Meta"]}var $g,Yg,nx,rx,ax,L8=g(()=>{d();
ut();Pe();i(P8,"threadKey");$g=new Map,Yg=new Map,nx=new Map,rx=[],ax=new Map;i(Hse,"reset");i(Wse,"handleEvent");i(Gse,"finalize");i(Vse,"data");i($se,"deps")});var cx={};E(cx,{data:()=>Xse,finalize:()=>Jse,handleEvent:()=>Kse,reset:()=>Yse});function Yse(){ix.length=0,sx.length=0}function Kse(e){if(C.isAnimation(e)){ix.push(e);return}}async function Jse(){let e=We.createMatchedSortedSyntheticEvents(ix);sx.push(...e)}function Xse(){return{animations:sx}}var ix,sx,B8=g(()=>{d();ut();Pe();ix=[],sx=[];i(Yse,"reset");i(Kse,"handleEvent");i(Jse,"finalize");i(Xse,"data")});var hx={};E(hx,{data:()=>am,finalize:()=>rce,handleEvent:()=>Qse,reset:()=>Zse});function Zse(){fx=[],mx.length=0,px.length=0,rm.clear(),lx.clear(),dx.clear()}function Qse(e){if(C.isFlowPhaseEvent(e)){mx.push(e);return}px.push(e)}function ece(e){let t=lx.get(e.ts)?.get(e.pid)?.get(e.tid)?.get(e.cat);if(!t)return;let{flows:n,bindingParsed:r}=t;if(!r){for(let a of n)Me.getWithDefault(dx,a,()=>new Map).set(e.ts,e);t.bindingParsed=!0}}function tce(e){let t=nce(e);switch(e.ph){case"s":{let n={flowId:e.id,times:new Map([[e.ts,void 0]])};rm.set(t,e.id),ux(e,n.flowId);return}case"t":{let n=rm.get(t);if(n===void 0)return;ux(e,n);return}case"f":{let n=rm.get(t);if(n===void 0)return;ux(e,n),rm.delete(t)}}}function ux(e,t){let n=Me.getWithDefault(lx,e.ts,()=>new Map),r=Me.getWithDefault(n,e.pid,()=>new Map),a=Me.getWithDefault(r,e.tid,()=>new Map);Me.getWithDefault(a,e.cat,()=>({flows:new Set,bindingParsed:!1})).flows.add(t)}function nce(e){return`${e.cat}${U8}${e.name}${U8}${e.id}`}async function rce(){
mx.forEach(tce),px.forEach(ece),fx=[...dx.values()].map(e=>[...e.values()]).map(e=>e.filter(t=>t!==void 0)).filter(e=>e.length>1)}function am(){return{flows:fx}}var rm,lx,dx,mx,px,fx,U8,Kg=g(()=>{d();dn();Pe();rm=new Map,lx=new Map,dx=new Map,mx=[],px=[],fx=[],U8="-$-";i(Zse,"reset");i(Qse,"handleEvent");i(ece,"processNonFlowEvent");i(tce,"processFlowEvent");i(ux,"addFlowIdToEventBinding");i(nce,"flowGroupTokenForFlowPhaseEvent");i(rce,"finalize");i(am,"data")});var xx={};E(xx,{data:()=>om,finalize:()=>sce,handleEvent:()=>oce,reset:()=>ace});function ace(){gx.clear(),yx.clear(),vx.clear(),bx.clear(),wx.clear()}function oce(e){if(C.isAuctionWorkletRunningInProcess(e)){gx.set(e.args.data.pid,e);return}if(C.isAuctionWorkletDoneWithProcess(e)){yx.set(e.args.data.pid,e);return}if(C.isThreadName(e)){if(e.args.name==="auction_worklet.CrUtilityMain"){bx.set(e.pid,e);return}e.args.name==="AuctionV8HelperThread"&&wx.set(e.pid,e)}}function ice(e){switch(e){case"seller":return"seller";case"bidder":return"bidder";default:return"unknown"}}function j8(e){return xn.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:e,name:"SyntheticAuctionWorklet",s:"t",cat:e.cat,tid:e.tid,ts:e.ts,ph:"I",pid:e.args.data.pid,host:e.args.data.host,target:e.args.data.target,type:ice(e.args.data.type)})}async function sce(){for(let[e,t]of bx){let n=wx.get(e);if(!n)continue;let r=gx.get(e),a=yx.get(e),o=null;r?(o={...j8(r),args:{data:{runningInProcessEvent:r,utilityThread:t,
v8HelperThread:n}}},a&&(o.args.data.doneWithProcessEvent=a)):a&&(o={...j8(a),args:{data:{doneWithProcessEvent:a,utilityThread:t,v8HelperThread:n}}},r&&(o.args.data.runningInProcessEvent=r)),o!==null&&vx.set(e,o)}}function om(){return{worklets:new Map(vx)}}var gx,yx,vx,bx,wx,Jg=g(()=>{d();ut();Pe();gx=new Map,yx=new Map,vx=new Map,bx=new Map,wx=new Map;i(ace,"reset");i(oce,"handleEvent");i(ice,"workletType");i(j8,"makeSyntheticEventBase");i(sce,"finalize");i(om,"data")});var Ax={};E(Ax,{data:()=>Kt,finalize:()=>mce,handleEvent:()=>dce,reset:()=>lce});function lce(){Ou.clear(),Mu.clear(),cm.clear(),kx.clear(),lm.length=0,Tx=C.ProcessID(-1),Sx=C.ThreadID(-1),Cx=C.ProcessID(-1),Xg=C.ThreadID(-1),Zg=null,Qg.clear(),Ix.clear(),um.clear(),Ex.clear(),hr.min=O.Micro(Number.POSITIVE_INFINITY),hr.max=O.Micro(Number.NEGATIVE_INFINITY),hr.range=O.Micro(Number.POSITIVE_INFINITY),e1=O.Micro(-1),t1=!0}function Dx(e,t){Me.getWithDefault(Ex,t.processId,()=>new Map).set(t.frame,t);let r=Me.getWithDefault(um,t.frame,()=>new Map),a=Me.getWithDefault(r,t.processId,()=>[]),o=a.at(-1);o&&o.frame.url===t.url||a.push({frame:t,window:{min:e.ts,max:O.Micro(0),range:O.Micro(0)}})}function dce(e){if(t1&&uce.has(e.name)&&(t1=!1),C.isProcessName(e)&&kx.set(e.pid,e),e.ts!==0&&!e.name.endsWith("::UMA")&&cce.has(e.ph)){hr.min=O.Micro(Math.min(e.ts,hr.min));let t=e.dur??O.Micro(0);hr.max=O.Micro(Math.max(e.ts+t,hr.max))}if(C.isProcessName(e)&&(e.args.name==="Browser"||e.args.name==="Hea\
dlessBrowser")){Tx=e.pid;return}if(C.isProcessName(e)&&(e.args.name==="Gpu"||e.args.name==="GPU Process")){Cx=e.pid;return}if(C.isThreadName(e)&&e.args.name==="CrGpuMain"){Xg=e.tid;return}if(C.isThreadName(e)&&e.args.name==="CrBrowserMain"&&(Sx=e.tid),C.isMainFrameViewport(e)&&Zg===null){let t=e.args.data.viewport_rect,n=t[0],r=t[1],a=t[2],o=t[5];Zg=new DOMRect(n,r,a,o),q8=e.args.data.dpr}if(C.isTracingStartedInBrowser(e)){if(e1=e.ts,!e.args.data)throw new Error("No frames found in trace data");for(let t of e.args.data.frames??[]){Dx(e,t),t.parent||Qg.add(t.processId);let n="isInPrimaryMainFrame"in t,r="isOutermostMainFrame"in t;n&&r?t.isInPrimaryMainFrame&&t.isOutermostMainFrame&&(im=t.frame,sm=t.url):r?t.isOutermostMainFrame&&(im=t.frame,sm=t.url):!t.parent&&t.url&&(im=t.frame,sm=t.url)}return}if(C.isFrameCommittedInBrowser(e)){let t=e.args.data;if(!t||(Dx(e,t),t.parent))return;Qg.add(t.processId);return}if(C.isCommitLoad(e)){let t=e.args.data;if(!t)return;let{frame:n,name:r,url:a}=t;
Dx(e,{processId:e.pid,frame:n,name:r,url:a});return}if(C.isThreadName(e)){Me.getWithDefault(Ix,e.pid,()=>new Map).set(e.tid,e);return}if(C.isNavigationStart(e)&&e.args.data){let t=e.args.data.navigationId;if(Mu.has(t))return;Mu.set(t,e),cm.set(t,e.args.data.documentLoaderURL);let n=e.args.frame,r=Ou.get(n)||[];r.push(e),Ou.set(n,r),n===im&&lm.push(e);return}if(C.isResourceSendRequest(e)){if(e.args.data.resourceType!=="Document")return;let t=e.args.data.requestId;if(!Mu.get(t))return;cm.set(t,e.args.data.url);return}if(C.isDidCommitSameDocumentNavigation(e)){if(e.args.render_frame_host.frame_type!=="PRIMARY_MAIN_FRAME")return;let n=lm.at(-1)?.args.data?.navigationId??"";cm.set(n,e.args.url);return}}async function mce(){e1>=0&&(hr.min=e1),hr.range=O.Micro(hr.max-hr.min);for(let[,n]of um){let r=[...n.values()].flat().sort((a,o)=>a.window.min-o.window.min);for(let a=0;a<r.length;a++){let o=r[a],s=r[a+1];s?(o.window.max=O.Micro(s.window.min-1),o.window.range=O.Micro(o.window.max-o.window.min)):
(o.window.max=O.Micro(hr.max),o.window.range=O.Micro(hr.max-o.window.min))}}for(let[n,r]of Ou)if(!um.has(n)){Ou.delete(n);for(let a of r)a.args.data&&Mu.delete(a.args.data.navigationId)}let e=lm.at(0),t=ue.secondsToMicro(O.Seconds(.5));if(e){let n=e.ts-hr.min<t;e.args.data?.isOutermostMainFrame&&e.args.data?.documentLoaderURL&&n&&(sm=e.args.data.documentLoaderURL)}}function Kt(){return{traceBounds:{...hr},browserProcessId:Tx,browserThreadId:Sx,processNames:kx,gpuProcessId:Cx,gpuThreadId:Xg===C.ThreadID(-1)?void 0:Xg,viewportRect:Zg||void 0,devicePixelRatio:q8??void 0,mainFrameId:im,mainFrameURL:sm,navigationsByFrameId:Ou,navigationsByNavigationId:Mu,finalDisplayUrlByNavigationId:cm,threadsInProcess:Ix,rendererProcessesByFrame:um,topLevelRendererIds:Qg,frameByProcessId:Ex,mainFrameNavigations:lm,traceIsGeneric:t1}}var um,im,sm,Ex,Tx,Sx,Cx,Xg,Zg,q8,kx,Qg,hr,Ou,Mu,cm,lm,Ix,e1,cce,t1,uce,aa=g(()=>{d();dn();ut();Pe();um=new Map,im="",sm="",Ex=new Map,Tx=C.ProcessID(-1),Sx=C.ThreadID(-1),Cx=
C.ProcessID(-1),Xg=C.ThreadID(-1),Zg=null,q8=null,kx=new Map,Qg=new Set,hr={min:O.Micro(Number.POSITIVE_INFINITY),max:O.Micro(Number.NEGATIVE_INFINITY),range:O.Micro(Number.POSITIVE_INFINITY)},Ou=new Map,Mu=new Map,cm=new Map,lm=[],Ix=new Map,e1=O.Micro(-1),cce=new Set(["B","E","X","I"]),t1=!0,uce=new Set(["TracingStartedInPage","TracingSessionIdForWorker","TracingStartedInBrowser"]);i(lce,"reset");i(Dx,"updateRendererProcessByFrame");i(dce,"handleEvent");i(mce,"finalize");i(Kt,"data")});var Mx={};E(Mx,{data:()=>Wo,deps:()=>yce,finalize:()=>gce,handleEvent:()=>hce,reset:()=>fce});function cc(e,t,n){dm.has(e)||dm.set(e,{});let r=dm.get(e);if(!r)throw new Error(`Unable to locate trace events for request ID ${e}`);if(Array.isArray(r[t])){let a=r[t],o=n;a.push(...o)}else r[t]=n}function pce(e){for(let t of e)if(t>0)return t;return 0}function fce(){Fx.clear(),Rx.clear(),dm.clear(),a1.length=0,r1.clear(),_x.clear(),uc.clear(),lc.eventsByEntity.clear(),lc.entityByEvent.clear(),lc.createdEntityCache.clear()}function hce(e){if(C.isResourceChangePriority(e)){cc(e.args.data.requestId,"changePriority",e);return}if(C.isResourceWillSendRequest(e)){cc(e.args.data.requestId,"willSendRequests",[e]);return}if(C.isResourceSendRequest(e)){cc(e.args.data.requestId,"sendRequests",[e]);return}if(C.isResourceReceiveResponse(e)){cc(e.args.data.requestId,"receiveResponse",e);return}if(C.isResourceReceivedData(e)){cc(e.args.data.requestId,"receivedData",[e]);return}if(C.isResourceFinish(e)){cc(e.
args.data.requestId,"resourceFinish",e);return}if(C.isResourceMarkAsCached(e)){cc(e.args.data.requestId,"resourceMarkAsCached",e);return}if(C.isWebSocketCreate(e)||C.isWebSocketInfo(e)||C.isWebSocketTransfer(e)){let t=e.args.data.identifier;uc.has(t)||(e.args.data.frame?uc.set(t,{frame:e.args.data.frame,webSocketIdentifier:t,events:[],syntheticConnection:null}):e.args.data.workerId&&uc.set(t,{workerId:e.args.data.workerId,webSocketIdentifier:t,events:[],syntheticConnection:null})),uc.get(t)?.events.push(e)}}async function gce(){let{rendererProcessesByFrame:e}=Kt();for(let[t,n]of dm.entries()){if(!n.sendRequests||!n.receiveResponse)continue;let r=[];for(let at=0;at<n.sendRequests.length-1;at++){let Ge=n.sendRequests[at],Be=n.sendRequests[at+1],Ue=Ge.ts,be=O.Micro(Be.ts-Ge.ts);if(n.willSendRequests?.[at]&&n.willSendRequests[at+1]){let de=n.willSendRequests[at],Mt=n.willSendRequests[at+1];Ue=de.ts,be=O.Micro(Mt.ts-de.ts)}r.push({url:Ge.args.data.url,priority:Ge.args.data.priority,requestMethod:Ge.
args.data.requestMethod,ts:Ue,dur:be})}let a=n.resourceFinish?.args.data.encodedDataLength!==0,o=n.receiveResponse.args.data.fromCache&&!n.receiveResponse.args.data.fromServiceWorker&&!a,s=n.resourceMarkAsCached!==void 0,c=s?void 0:n.receiveResponse.args.data.timing;if(!c&&!s)continue;let u=n.sendRequests[0],l=n.sendRequests[n.sendRequests.length-1],m=l.args.data.priority,p=m;n.changePriority&&(p=n.changePriority.args.data.priority);let f=n.willSendRequests?.length?O.Micro(n.willSendRequests[0].ts):O.Micro(u.ts),h=n.willSendRequests?.length?O.Micro(n.willSendRequests[n.willSendRequests.length-1].ts):O.Micro(l.ts),y=n.resourceFinish?n.resourceFinish.ts:h,b=n.resourceFinish?.args.data.finishTime?O.Micro(n.resourceFinish.args.data.finishTime*n1):O.Micro(y),w=O.Micro(c?(b||h)-h:0),D=O.Micro(y-(b||y)),T=O.Micro(h-f),S=c?c.requestTime*n1-h:0,k=O.Micro(_u.clamp(S,0,Number.MAX_VALUE)),_=c?O.Micro(pce([c.dnsStart*Ia,c.connectStart*Ia,c.sendStart*Ia,n.receiveResponse.ts-h])):O.Micro(n.receiveResponse.
ts-f),Y=c?O.Micro(c.requestTime*n1+c.sendStart*Ia):f,W=c?O.Micro((c.receiveHeadersEnd-c.sendEnd)*Ia):O.Micro(0),oe=c?O.Micro(c.requestTime*n1+c.receiveHeadersEnd*Ia):f,me=c?O.Micro((b||oe)-oe):O.Micro(y-n.receiveResponse.ts),De=O.Micro(w+D),Oe=c?O.Micro((c.dnsEnd-c.dnsStart)*Ia):O.Micro(0),we=c?O.Micro((c.sslEnd-c.sslStart)*Ia):O.Micro(0),ve=c?O.Micro((c.proxyEnd-c.proxyStart)*Ia):O.Micro(0),Dt=c?O.Micro((c.sendEnd-c.sendStart)*Ia):O.Micro(0),Fe=c?O.Micro((c.connectEnd-c.connectStart)*Ia):O.Micro(0),{frame:ze,url:_t,renderBlocking:yt}=l.args.data,{encodedDataLength:tt,decodedBodyLength:$t}=n.resourceFinish?n.resourceFinish.args.data:{encodedDataLength:0,decodedBodyLength:0},pt=new URL(_t),ft=pt.protocol==="https:",Xe=We.activeURLForFrameAtTime(ze,l.ts,e)||"",J=xn.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:l,args:{data:{syntheticData:{dnsLookup:Oe,download:me,downloadStart:oe,finishTime:b,initialConnection:Fe,isDiskCached:o,isHttps:ft,isMemoryCached:s,isPushedResource:a,
networkDuration:w,processingDuration:D,proxyNegotiation:ve,queueing:k,redirectionDuration:T,requestSent:Dt,sendStartTime:Y,ssl:we,stalled:_,totalTime:De,waiting:W},decodedBodyLength:$t,encodedDataLength:tt,frame:ze,fromServiceWorker:n.receiveResponse.args.data.fromServiceWorker,isLinkPreload:l.args.data.isLinkPreload||!1,mimeType:n.receiveResponse.args.data.mimeType,priority:p,initialPriority:m,protocol:n.receiveResponse.args.data.protocol??"unknown",redirects:r,renderBlocking:yt??"non_blocking",requestId:t,requestingFrameUrl:Xe,requestMethod:l.args.data.requestMethod,resourceType:l.args.data.resourceType??"Other",statusCode:n.receiveResponse.args.data.statusCode,responseHeaders:n.receiveResponse.args.data.headers||[],fetchPriorityHint:l.args.data.fetchPriorityHint??"auto",initiator:l.args.data.initiator,stackTrace:l.args.data.stackTrace,timing:c,url:_t,failed:n.resourceFinish?.args.data.didFail??!1,finished:!!n.resourceFinish,connectionId:n.receiveResponse.args.data.connectionId,connectionReused:n.
receiveResponse.args.data.connectionReused}},cat:"loading",name:"SyntheticNetworkRequest",ph:"X",dur:O.Micro(y-f),tdur:O.Micro(y-f),ts:O.Micro(f),tts:O.Micro(f),pid:l.pid,tid:l.tid}),Ie=Me.getWithDefault(Rx,pt.host,()=>({renderBlocking:[],nonRenderBlocking:[],all:[]}));Rr.isSyntheticNetworkRequestEventRenderBlocking(J)?Ie.renderBlocking.push(J):Ie.nonRenderBlocking.push(J),Ie.all.push(J),a1.push(J),Fx.set(J.args.data.requestId,J),Pw(J,lc,n);let Ft=J.args.data.initiator?.url||We.getZeroIndexedStackTraceForEvent(J)?.at(0)?.url;if(Ft){let at=r1.get(Ft)??[];at.push(J),r1.set(Ft,at)}}for(let t of a1){let n=r1.get(t.args.data.url);if(n)for(let r of n)_x.set(r,t)}vce()}function Wo(){return{byId:Fx,byOrigin:Rx,byTime:a1,eventToInitiator:_x,webSocket:[...uc.values()],entityMappings:{entityByEvent:new Map(lc.entityByEvent),eventsByEntity:new Map(lc.eventsByEntity),createdEntityCache:new Map(lc.createdEntityCache)}}}function yce(){return["Meta"]}function vce(){uc.forEach(e=>{let t=null,n=null;for(let r of e.
events)C.isWebSocketCreate(r)&&(t=r),C.isWebSocketDestroy(r)&&(n=r);e.syntheticConnection=bce(t,n,e.events[0])})}function bce(e,t,n){let{traceBounds:r}=Kt(),a=e?e.ts:r.min,s=(t?t.ts:r.max)-a,c=e||t||n;return{name:"SyntheticWebSocketConnection",cat:c.cat,ph:"X",ts:a,dur:s,pid:c.pid,tid:c.tid,s:c.s,rawSourceEvent:c,_tag:"SyntheticEntryTag",args:{data:{identifier:c.args.data.identifier,priority:"Low",url:c.args.data.url||""}}}}var Ia,n1,uc,dm,Fx,Rx,a1,r1,_x,lc,Nu=g(()=>{d();dn();ut();Pe();Ug();aa();Ia=1e3,n1=1e6,uc=new Map,dm=new Map,Fx=new Map,Rx=new Map,a1=[],r1=new Map,_x=new Map,lc={eventsByEntity:new Map,entityByEvent:new Map,createdEntityCache:new Map};i(cc,"storeTraceEventWithRequestId");i(pce,"firstPositiveValueInList");i(fce,"reset");i(hce,"handleEvent");i(gce,"finalize");i(Wo,"data");i(yce,"deps");i(vce,"finalizeWebSocketData");i(bce,"createSyntheticWebSocketConnection")});var o1,i1,Ox=g(()=>{d();o1=class{static{i(this,"ProfileNode")}callFrame;callUID;self;total;id;parent;children;functionName;depth;deoptReason;constructor(t){this.callFrame=t,this.callUID=`${t.functionName}@${t.scriptId}:${t.lineNumber}:${t.columnNumber}`,this.self=0,this.total=0,this.id=0,this.functionName=t.functionName,this.parent=null,this.children=[]}get scriptId(){return String(this.callFrame.scriptId)}get url(){return this.callFrame.url}get lineNumber(){return this.callFrame.lineNumber}get columnNumber(){return this.callFrame.columnNumber}setFunctionName(t){t!==null&&(this.functionName=t)}},i1=class{static{i(this,"ProfileTreeModel")}root;total;maxDepth;constructor(){}initialize(t){this.root=t,this.assignDepthsAndParents(),this.total=this.calculateTotals(this.root)}assignDepthsAndParents(){let t=this.root;t.depth=-1,t.parent=null,this.maxDepth=0;let n=[t];for(;n.length;){let r=n.pop(),a=r.depth+1;a>this.maxDepth&&(this.maxDepth=a);let o=r.children;for(let s of o)s.depth=a,s.parent=
r,n.push(s)}}calculateTotals(t){let n=[t],r=[];for(;n.length;){let a=n.pop();a.total=a.self,r.push(a),n.push(...a.children)}for(;r.length>1;){let a=r.pop();a.parent&&(a.parent.total+=a.total)}return t.total}}});var s1={};E(s1,{CPUProfileDataModel:()=>Nx,CPUProfileNode:()=>mm});var mm,Nx,z8=g(()=>{d();dn();Ox();mm=class extends o1{static{i(this,"CPUProfileNode")}id;self;positionTicks;deoptReason;constructor(t,n){let r=t.callFrame||{functionName:t.functionName,scriptId:t.scriptId,url:t.url,lineNumber:t.lineNumber-1,columnNumber:t.columnNumber-1};super(r),this.id=t.id,this.self=(t.hitCount||0)*n,this.positionTicks=t.positionTicks,this.deoptReason=t.deoptReason&&t.deoptReason!=="no reason"?t.deoptReason:null}},Nx=class extends i1{static{i(this,"CPUProfileDataModel")}profileStartTime;profileEndTime;timestamps;samples;traceIds;lines;totalHitCount;profileHead;#e;gcNode;programNode;idleNode;#t;#o;constructor(t){super(),!!t.head?(this.profileStartTime=t.startTime*1e3,this.profileEndTime=t.endTime*1e3,this.timestamps=t.timestamps,this.compatibilityConversionHeadToNodes(t)):(this.profileStartTime=t.startTime/1e3,this.profileEndTime=t.endTime/1e3,this.timestamps=this.convertTimeDeltas(t)),this.traceIds=t.
traceIds,this.samples=t.samples,this.lines=t.lines,this.totalHitCount=0,this.profileHead=this.translateProfileTree(t.nodes),this.initialize(this.profileHead),this.extractMetaNodes(),this.samples?.length&&(this.sortSamples(),this.normalizeTimestamps(),this.fixMissingSamples())}compatibilityConversionHeadToNodes(t){if(!t.head||t.nodes)return;let n=[];r(t.head),t.nodes=n,delete t.head;function r(a){return n.push(a),a.children=a.children.map(r),a.id}i(r,"convertNodesTree")}convertTimeDeltas(t){if(!t.timeDeltas)return[];let n=t.startTime,r=new Array(t.timeDeltas.length);for(let a=0;a<t.timeDeltas.length;++a)n+=t.timeDeltas[a],r[a]=n;return r}translateProfileTree(t){function n(p){if(!p[0].children){p[0].children=[];for(let f=1;f<p.length;++f){let h=p[f],y=a.get(h.parent);y&&(y.children?y.children.push(h.id):y.children=[h.id])}}}i(n,"buildChildrenFromParents");function r(p,f){if(typeof p[0].hitCount!="number"){if(!f)throw new Error("Error: Neither hitCount nor samples are present in profile.");
for(let h=0;h<p.length;++h)p[h].hitCount=0;for(let h=0;h<f.length;++h){let y=a.get(f[h]);y?.hitCount!==void 0&&y.hitCount++}}}i(r,"buildHitCountFromSamples");let a=new Map;for(let p=0;p<t.length;++p){let f=t[p];a.set(f.id,f)}r(t,this.samples),n(t),this.totalHitCount=t.reduce((p,f)=>p+(f.hitCount||0),0);let o=(this.profileEndTime-this.profileStartTime)/this.totalHitCount,s=t[0],c=new Map([[s.id,s.id]]);this.#e=new Map;let u=new mm(s,o);if(this.#e.set(s.id,u),!s.children)throw new Error("Missing children for root");let l=s.children.map(()=>u),m=s.children.map(p=>a.get(p));for(;m.length;){let p=l.pop(),f=m.pop();if(!f||!p)continue;f.children||(f.children=[]);let h=new mm(f,o);p.children.push(h),p=h,c.set(f.id,p.id),l.push.apply(l,f.children.map(()=>p)),m.push.apply(m,f.children.map(y=>a.get(y))),this.#e.set(f.id,h)}return this.samples&&(this.samples=this.samples.map(p=>c.get(p))),u}sortSamples(){if(!this.timestamps||!this.samples)return;let t=this.timestamps,n=this.samples,r=t.map((a,o)=>o);
r.sort((a,o)=>t[a]-t[o]),this.timestamps=[],this.samples=[];for(let a=0;a<r.length;a++){let o=r[a];this.timestamps.push(t[o]),this.samples.push(n[o])}}normalizeTimestamps(){if(!this.samples)return;let t=this.timestamps;if(!t){let n=this.profileStartTime,r=(this.profileEndTime-n)/this.samples.length;t=new Array(this.samples.length+1);for(let a=0;a<t.length;++a)t[a]=n+a*r;this.timestamps=t;return}for(let n=0;n<t.length;++n)t[n]/=1e3;if(this.samples.length===t.length){let n=t.at(-1)||0,r=(n-t[0])/(t.length-1);this.timestamps.push(n+r)}this.profileStartTime=t.at(0)||this.profileStartTime,this.profileEndTime=t.at(-1)||this.profileEndTime}extractMetaNodes(){let t=this.profileHead.children;for(let n=0;n<t.length&&!(this.gcNode&&this.programNode&&this.idleNode);n++){let r=t[n];r.functionName==="(garbage collector)"?this.gcNode=r:r.functionName==="(program)"?this.programNode=r:r.functionName==="(idle)"&&(this.idleNode=r)}}fixMissingSamples(){let t=this.samples;if(!t)return;let n=t.length;if(!this.
programNode||n<3)return;let r=this.#e,a=this.programNode.id,o=this.gcNode?this.gcNode.id:-1,s=this.idleNode?this.idleNode.id:-1,c=t[0],u=t[1];for(let p=1;p<n-1;p++){let f=t[p+1],h=r.get(c),y=r.get(f);if(c===void 0||f===void 0||!h||!y){console.error(`Unexpectedly found undefined nodes: ${c} ${f}`);continue}u===a&&!m(c)&&!m(f)&&l(h)===l(y)&&(t[p]=c),c=u,u=f}function l(p){for(;p.parent?.parent;)p=p.parent;return p}i(l,"bottomNode");function m(p){return p===a||p===o||p===s}i(m,"isSystemNode")}forEachFrame(t,n,r,a){if(!this.profileHead||!this.samples)return;r=r||0,a=a||1/0;let o=this.samples,s=this.timestamps,c=this.#e,u=this.gcNode,l=o.length,m=_n.lowerBound(s,r,_n.DEFAULT_COMPARATOR),p=0,f=[],h=this.profileHead.id,y,b=null,w=this.maxDepth+3;this.#t||(this.#t=new Array(w));let D=this.#t;this.#o||(this.#o=new Array(w));let T=this.#o,S,k;for(k=m;k<l&&(y=s[k],!(y>=a));k++){let _=o[k];if(_===h)continue;S=c.get(_);let Y=c.get(h)||null;if(Y){if(u&&S===u){b=Y,t(b.depth+1,u,k,y),D[++p]=y,T[p]=0,h=
_;continue}if(u&&Y===u&&b){let W=D[p],oe=y-W;T[p-1]+=oe,n(b.depth+1,u,k,W,oe,oe-T[p]),--p,Y=b,h=Y.id,b=null}for(;S&&S.depth>Y.depth;)f.push(S),S=S.parent;for(;Y&&Y!==S;){let W=D[p],oe=y-W;T[p-1]+=oe,n(Y.depth,Y,k,W,oe,oe-T[p]),--p,S&&S.depth===Y.depth&&(f.push(S),S=S.parent),Y=Y.parent}for(;f.length;){let W=f.pop();if(!W)break;S=W,t(W.depth,W,k,y),D[++p]=y,T[p]=0}h=_}}if(y=s[k]||this.profileEndTime,S&&b&&c.get(h)===u){let _=D[p],Y=y-_;T[p-1]+=Y,n(b.depth+1,S,k,_,Y,Y-T[p]),--p,h=b.id}for(let _=c.get(h);_?.parent;_=_.parent){let Y=D[p],W=y-Y;T[p-1]+=W,n(_.depth,_,k,Y,W,W-T[p]),--p}}nodeByIndex(t){return this.samples&&this.#e.get(this.samples[t])||null}nodeById(t){return this.#e.get(t)||null}nodes(){return this.#e?[...this.#e.values()]:null}}});var H8=g(()=>{d();z8();Ox()});var jx={};E(jx,{data:()=>Ux,finalize:()=>Cce,getProfileCallFunctionName:()=>kce,handleEvent:()=>Sce,reset:()=>Tce});function Ece(e){for(let[t,n]of Bx)for(let[r,a]of n){let p=function(){c.forEachFrame(f,h);function f(y,b,w,D){if(o===void 0)return;let T=ue.milliToMicro(O.Milli(D)),S=b.id,k=We.makeProfileCall(b,r,w,T,t,o);l.profileCalls.push(k),s.push(l.profileCalls.length-1);let _=$i.makeEmptyTraceEntryNode(k,S);pm.set(k,_),_.depth=y,s.length===1&&l.profileTree?.roots.add(_)}i(f,"openFrameCallback");function h(y,b,w,D,T,S){let k=s.pop(),_=k!==void 0&&l.profileCalls[k];if(!_)return;let{callFrame:Y,ts:W,pid:oe,tid:me}=_,De=pm.get(_);if(Y===void 0||W===void 0||oe===void 0||r===void 0||me===void 0||De===void 0)return;let Oe=ue.milliToMicro(O.Milli(T)),we=ue.milliToMicro(O.Milli(S));_.dur=Oe,De.selfTime=we;let ve=s.at(-1),Dt=ve!==void 0&&l.profileCalls.at(ve),Fe=Dt&&pm.get(Dt);Fe&&(De.parent=Fe,Fe.children.push(De))}i(h,"closeFrameCallback")};i(p,"buildProfileCallsForCPUProfile");let o=a.threadId;
if(!a.rawProfile.nodes.length||o===void 0)continue;let s=[],c=new s1.CPUProfileDataModel(a.rawProfile),u=$i.makeEmptyTraceEntryTree();u.maxDepth=c.maxDepth;let l={rawProfile:a.rawProfile,parsedProfile:c,profileCalls:[],profileTree:u,profileId:r};Me.getWithDefault(Lx,t,()=>new Map).set(o,l),e.isCPUProfile&&p()}}function Tce(){Dce.clear(),Bx.clear(),Lx.clear(),pm.clear()}function Sce(e){if(C.isSyntheticCpuProfile(e)){let t=e.pid,n=e.tid,a=Px(t,"0x1");a.rawProfile=e.args.data.cpuProfile,a.threadId=n;return}if(C.isProfile(e)){let t=Px(e.pid,e.id);t.rawProfile.startTime=e.ts,t.threadId=e.tid;return}if(C.isProfileChunk(e)){let n=Px(e.pid,e.id).rawProfile,r=e.args?.data?.cpuProfile||{samples:[]},a=r?.samples||[],o=e.args?.data?.cpuProfile?.trace_ids||{},s=[];for(let l of r?.nodes||[]){let m=typeof l.callFrame.lineNumber>"u"?-1:l.callFrame.lineNumber,p=typeof l.callFrame.columnNumber>"u"?-1:l.callFrame.columnNumber,f=String(l.callFrame.scriptId),h=l.callFrame.url||"",y={...l,callFrame:{...l.callFrame,
url:h,lineNumber:m,columnNumber:p,scriptId:f}};s.push(y)}let c=e.args.data?.timeDeltas||[],u=e.args.data?.lines||Array(a.length).fill(0);if(n.nodes.push(...s),n.samples?.push(...a),n.timeDeltas?.push(...c),n.lines?.push(...u),n.traceIds={...n.traceIds||{},...o},n.samples&&n.timeDeltas&&n.samples.length!==n.timeDeltas.length){console.error("Failed to parse CPU profile.");return}if(!n.endTime&&n.timeDeltas){let l=n.timeDeltas;n.endTime=l.reduce((m,p)=>m+p,n.startTime)}return}}async function Cce(e={}){Ece(e)}function Ux(){return{profilesInProcess:Lx,entryToNode:pm}}function Px(e,t){let n=Me.getWithDefault(Bx,e,()=>new Map);return Me.getWithDefault(n,t,()=>({rawProfile:{startTime:0,endTime:0,nodes:[],samples:[],timeDeltas:[],lines:[]},profileId:t}))}function kce(e,t){let r=e.profilesInProcess.get(t.pid)?.get(t.tid)?.parsedProfile.nodeById(t.nodeId);return r?.functionName?r.functionName:t.callFrame.functionName}var Dce,Lx,pm,Bx,qx=g(()=>{d();dn();H8();ut();Pe();Dce=new Map,Lx=new Map,pm=new Map,
Bx=new Map;i(Ece,"parseCPUProfileData");i(Tce,"reset");i(Sce,"handleEvent");i(Cce,"finalize");i(Ux,"data");i(Px,"getOrCreatePreProcessedData");i(kce,"getProfileCallFunctionName")});var Gx={};E(Gx,{assignIsMainFrame:()=>$8,assignMeta:()=>G8,assignOrigin:()=>V8,assignThreadName:()=>Y8,buildHierarchy:()=>X8,data:()=>hm,deps:()=>Nce,finalize:()=>Mce,handleEvent:()=>_ce,handleUserConfig:()=>Fce,makeCompleteEvent:()=>Z8,reset:()=>Rce,sanitizeProcesses:()=>K8,sanitizeThreads:()=>J8});function Fce(e){W8=e}function Rce(){to.clear(),Wx.clear(),Yi.eventsByEntity.clear(),Yi.entityByEvent.clear(),Yi.createdEntityCache.clear(),Go.length=0,zx.length=0,Hx.length=0}function _ce(e){if(C.isThreadName(e)&&e.args.name?.startsWith("CompositorTileWorker")&&Hx.push({pid:e.pid,tid:e.tid}),C.isBegin(e)||C.isEnd(e)){let t=Pu(to,e.pid),n=fm(t,e.tid),r=Z8(e);if(!r)return;n.entries.push(r),Go.push(r);return}if(C.isInstant(e)||C.isComplete(e)){let t=Pu(to,e.pid);fm(t,e.tid).entries.push(e),Go.push(e)}if(C.isLayout(e)){let t=Pu(to,e.pid);fm(t,e.tid).layoutEvents.push(e)}if(C.isUpdateLayoutTree(e)){let t=Pu(to,e.pid);fm(t,e.tid).updateLayoutTreeEvents.push(e)}}async function Mce(){let{mainFrameId:e,
rendererProcessesByFrame:t,threadsInProcess:n}=Kt();Yi=Wo().entityMappings,G8(to,e,t,n),K8(to),X8(to),J8(to),We.sortTraceEventsInPlace(Go)}function hm(){return{processes:new Map(to),compositorTileWorkers:new Map(Oce()),entryToNode:new Map(Wx),allTraceEntries:[...Go],entityMappings:{entityByEvent:new Map(Yi.entityByEvent),eventsByEntity:new Map(Yi.eventsByEntity),createdEntityCache:new Map(Yi.createdEntityCache)}}}function Oce(){let e=new Map;for(let t of Hx){let n=e.get(t.pid)||[];n.push(t.tid),e.set(t.pid,n)}return e}function G8(e,t,n,r){V8(e,n),$8(e,t,n),Y8(e,n,r)}function V8(e,t){for(let n of t.values())for(let[r,a]of n)for(let o of a.flat()){let s=Pu(e,r);if(s.url===null||s.url==="about:blank")try{new URL(o.frame.url),s.url=o.frame.url}catch{s.url=null}}}function $8(e,t,n){for(let[r,a]of n)for(let[o]of a){let s=Pu(e,o);r===t&&(s.isOnMainFrame=!0)}}function Y8(e,t,n){for(let[r,a]of e)for(let[o,s]of n.get(r)??[]){let c=fm(a,o);c.name=s?.args.name??`${o}`}}function K8(e){let t=om().worklets;
if(!Kt().traceIsGeneric){for(let[r,a]of e)if(a.url===null){let o=t.get(r);o?a.url=o.host:e.delete(r);continue}}}function J8(e){for(let[,t]of e)for(let[n,r]of t.threads)r.tree?.roots.size||t.threads.delete(n)}function X8(e,t){let n=Ux();for(let[r,a]of e)for(let[o,s]of a.threads){if(!s.entries.length){s.tree=$i.makeEmptyTraceEntryTree();continue}We.sortTraceEventsInPlace(s.entries);let c=n.profilesInProcess.get(r)?.get(o);if(c){let l=c.parsedProfile,m=l&&new Vg.SamplesIntegrator(l,c.profileId,r,o,W8),p=m?.buildProfileCalls(s.entries);if(m&&p){Go=[...Go,...p],s.entries=We.mergeEventsInOrder(s.entries,p),s.profileCalls=p;let f=m.jsSampleEvents;f&&(Go=[...Go,...f],s.entries=We.mergeEventsInOrder(s.entries,f))}}let u=$i.treify(s.entries,t);s.tree=u.tree;for(let[l,m]of u.entryToNode)Wx.set(l,m),Nw(l,Yi)}}function Z8(e){if(C.isEnd(e)){let n=zx.pop();return n?n.name!==e.name||n.cat!==e.cat?(console.error("Begin/End events mismatch at "+n.ts+" ("+n.name+") vs. "+e.ts+" ("+e.name+")"),null):(n.dur=
O.Micro(e.ts-n.ts),null):null}let t={...e,ph:"X",dur:O.Micro(0)};return zx.push(t),t}function Nce(){return["Meta","Samples","AuctionWorklets","NetworkRequests"]}var to,Yi,Hx,Wx,Go,zx,W8,Ice,Ace,Pu,fm,c1=g(()=>{d();dn();ut();Pe();Jg();Ug();aa();Nu();qx();to=new Map,Yi={eventsByEntity:new Map,entityByEvent:new Map,createdEntityCache:new Map},Hx=Array(),Wx=new Map,Go=[],zx=[],W8=Qa.defaults(),Ice=i(()=>({url:null,isOnMainFrame:!1,threads:new Map}),"makeRendererProcess"),Ace=i(()=>({name:null,entries:[],profileCalls:[],layoutEvents:[],updateLayoutTreeEvents:[]}),"makeRendererThread"),Pu=i((e,t)=>Me.getWithDefault(e,t,Ice),"getOrCreateRendererProcess"),fm=i((e,t)=>Me.getWithDefault(e.threads,t,Ace),"getOrCreateRendererThread");i(Fce,"handleUserConfig");i(Rce,"reset");i(_ce,"handleEvent");i(Mce,"finalize");i(hm,"data");i(Oce,"gatherCompositorThreads");i(G8,"assignMeta");i(V8,"assignOrigin");i($8,"assignIsMainFrame");i(Y8,"assignThreadName");i(K8,"sanitizeProcesses");i(J8,"sanitizeThreads");i(
X8,"buildHierarchy");i(Z8,"makeCompleteEvent");i(Nce,"deps")});var Kx={};E(Kx,{data:()=>Yx,deps:()=>zce,finalize:()=>Bce,handleEvent:()=>Lce,reset:()=>Pce});function Pce(){Vx.clear(),$x.clear()}function Lce(e){}async function Bce(){let{flows:e}=am(),{entryToNode:t}=hm();for(let n of e){let r=n.at(0);if(!r||!C.isDebuggerAsyncTaskScheduled(r))continue;let a=r.args.taskName,o=n.at(1);if(!o||!C.isDebuggerAsyncTaskRun(o))continue;let s=Uce(r,t);if(!s)continue;let c=jce(o,t);if(!c)continue;Me.getWithDefault(Vx,s,()=>[]).push(c);let l=qce(o,t);for(let m of l)$x.set(m,{taskName:a,scheduler:s})}}function Uce(e,t){let n=t.get(e)?.parent;for(;n;){if(C.isProfileCall(n.entry)||Q8(n.entry))return n.entry;n=n.parent}return null}function Q8(e){let t=C.isConsoleRunTask(e),n=e.name.startsWith("v8")||e.name.startsWith("V8");return C.isJSInvocationEvent(e)&&(t||!n)}function jce(e,t){return e4(e,t,Q8,C.isDebuggerAsyncTaskRun).at(0)}function qce(e,t){return e4(e,t,C.isProfileCall,C.isDebuggerAsyncTaskRun)}function e4(e,t,n,r){let a=t.get(e);if(!a)return[];let o=[[...a.
children]],s=[];for(let c=0;c<o.length;c++){let u=o[c];for(let l=0;l<u.length;l++){let m=u[l];n(m.entry)?s.push(m.entry):r(m.entry)||o.push([...m.children])}}return s}function Yx(){return{schedulerToRunEntryPoints:Vx,asyncCallToScheduler:$x}}function zce(){return["Renderer","Flows"]}var Vx,$x,Jx=g(()=>{d();dn();Pe();Kg();c1();Vx=new Map,$x=new Map;i(Pce,"reset");i(Lce,"handleEvent");i(Bce,"finalize");i(Uce,"findNearestJSAncestor");i(Q8,"acceptJSInvocationsPredicate");i(jce,"findFirstJsInvocationForAsyncTaskRun");i(qce,"findFirstJSCallsForAsyncTaskRun");i(e4,"findFirstDescendantsOfType");i(Yx,"data");i(zce,"deps")});var Zx={};E(Zx,{data:()=>Vce,finalize:()=>Gce,handleEvent:()=>Wce,reset:()=>Hce});function Hce(){Xx.clear()}function Wce(e){if(!C.isDOMStats(e))return;Me.getWithDefault(Xx,e.args.data.frame,()=>[]).push(e)}async function Gce(){}function Vce(){return{domStatsByFrameId:Xx}}var Xx,t4=g(()=>{d();dn();Pe();Xx=new Map;i(Hce,"reset");i(Wce,"handleEvent");i(Gce,"finalize");i(Vce,"data")});var aD={};E(aD,{data:()=>gm,finalize:()=>Qce,handleEvent:()=>Zce,reset:()=>$ce});function $ce(){dc.length=0,eD.length=0,tD.length=0,nD.length=0,rD.length=0,Qx.clear()}function Xce(e,t,n){let r=e.ts,a=t.ts;if(r<a)return-1;if(r>a)return 1;let o=e.dur??0,s=t.dur??0,c=r+o,u=a+s;return c>u?-1:c<u?1:n.indexOf(t)-n.indexOf(e)}function Zce(e){if(!Jce.includes(e.name)){if(C.isUserTimingMeasure(e)&&Qx.set(e.args.traceId,e),C.isPerformanceMeasure(e)){eD.push(e);return}C.isPerformanceMark(e)&&tD.push(e),C.isConsoleTime(e)&&nD.push(e),C.isConsoleTimeStamp(e)&&rD.push(e)}}async function Qce(){let e=[...eD,...nD];dc=We.createMatchedSortedSyntheticEvents(e),dc=dc.sort((t,n)=>Xce(t,n,[...dc]))}function gm(){return{performanceMeasures:dc.filter(e=>e.cat==="blink.user_timing"),consoleTimings:dc.filter(e=>e.cat==="blink.console"),performanceMarks:[...tD],timestampEvents:[...rD],measureTraceByTraceId:new Map(Qx)}}var dc,Qx,eD,tD,nD,rD,Yce,Kce,Jce,oD=g(()=>{d();ut();Pe();dc=[],Qx=new Map,eD=[],tD=[],nD=[],rD=
[];i($ce,"reset");Yce=["workerStart","redirectStart","redirectEnd","fetchStart","domainLookupStart","domainLookupEnd","connectStart","connectEnd","secureConnectionStart","requestStart","responseStart","responseEnd"],Kce=["navigationStart","unloadEventStart","unloadEventEnd","redirectStart","redirectEnd","fetchStart","commitNavigationEnd","domainLookupStart","domainLookupEnd","connectStart","connectEnd","secureConnectionStart","requestStart","responseStart","responseEnd","domLoading","domInteractive","domContentLoadedEventStart","domContentLoadedEventEnd","domComplete","loadEventStart","loadEventEnd"],Jce=[...Yce,...Kce];i(Xce,"userTimingComparator");i(Zce,"handleEvent");i(Qce,"finalize");i(gm,"data")});var lD={};E(lD,{data:()=>aue,deps:()=>oue,extensionDataInConsoleTimeStamp:()=>o4,extensionDataInPerformanceTiming:()=>a4,extractConsoleAPIExtensionEntries:()=>n4,extractPerformanceAPIExtensionEntries:()=>r4,finalize:()=>nue,handleEvent:()=>eue,reset:()=>tue});function eue(e){}function tue(){ym.length=0,uD.length=0,iD.length=0,sD.length=0,cD.clear(),u1.clear()}async function nue(){rue()}function rue(){let e=gm().performanceMeasures,t=gm().performanceMarks,n=We.mergeEventsInOrder(e,t);r4(n),n4(),We.sortTraceEventsInPlace(ym),Gg.buildTrackDataFromExtensionEntries(ym,iD,cD)}function n4(){let e=gm().timestampEvents;for(let t of e){if(!t.args.data)continue;let n=String(t.args.data.name??t.args.data.message);u1.set(n,t);let r=o4(t),a=t.args.data.start,o=t.args.data.end;if(!r&&!a&&!o)continue;let s=typeof a=="number"?O.Micro(a):u1.get(String(a))?.ts,c=typeof o=="number"?O.Micro(o):u1.get(String(o))?.ts;if(c!==void 0&&s===void 0)continue;let u=s??t.ts,l=c??t.ts;if(r){let f={...t,name:n,cat:"dev\
tools.extension",args:r,rawSourceEvent:t,dur:O.Micro(l-u),ts:u,ph:"X"},h=xn.SyntheticEventsManager.getActiveManager().registerSyntheticEvent(f);ym.push(h);continue}let m={...t,name:n,cat:"disabled-by-default-v8.inspector",ph:"X",ts:u,dur:O.Micro(l-u),rawSourceEvent:t},p=xn.SyntheticEventsManager.getActiveManager().registerSyntheticEvent(m);uD.push(p)}}function r4(e){for(let t of e){let n=a4(t);if(!n)continue;let r={name:t.name,ph:ka.isExtensionPayloadMarker(n)?"I":"X",pid:t.pid,tid:t.tid,ts:t.ts,dur:t.dur,cat:"devtools.extension",args:n,rawSourceEvent:C.isSyntheticUserTiming(t)?t.rawSourceEvent:t};if(ka.isExtensionPayloadMarker(n)){let a=xn.SyntheticEventsManager.getActiveManager().registerSyntheticEvent(r);sD.push(a);continue}if(ka.isExtensionPayloadTrackEntry(r.args)){let a=xn.SyntheticEventsManager.getActiveManager().registerSyntheticEvent(r);ym.push(a);continue}}}function a4(e){let t=C.isPerformanceMark(e)?e.args.data?.detail:e.args.data.beginEvent.args.detail;if(!t)return null;try{
let n=JSON.parse(t);return!("devtools"in n)||!ka.isValidExtensionPayload(n.devtools)?null:n.devtools}catch{return null}}function o4(e){if(!e.args.data)return null;let t=e.args.data.track;return t===""||t===void 0?null:{color:String(e.args.data.color),track:String(t),dataType:"track-entry",trackGroup:e.args.data.trackGroup!==void 0?String(e.args.data.trackGroup):void 0}}function aue(){return{entryToNode:cD,extensionTrackData:iD,extensionMarkers:sD,syntheticConsoleEntriesForTimingsTrack:uD}}function oue(){return["UserTimings"]}var ym,iD,sD,cD,u1,uD,i4=g(()=>{d();ut();Pe();oD();ym=[],iD=[],sD=[],cD=new Map,u1=new Map,uD=[];i(eue,"handleEvent");i(tue,"reset");i(nue,"finalize");i(rue,"createExtensionFlameChartEntries");i(n4,"extractConsoleAPIExtensionEntries");i(r4,"extractPerformanceAPIExtensionEntries");i(a4,"extensionDataInPerformanceTiming");i(o4,"extensionDataInConsoleTimeStamp");i(aue,"data");i(oue,"deps")});var yD={};E(yD,{data:()=>gD,deps:()=>uue,finalize:()=>cue,handleEvent:()=>sue,reset:()=>iue});function iue(){pD.length=0,fD.length=0,hD.clear(),dD={},mD=null,l1.length=0,d1.length=0}function sue(e){(C.isPaint(e)||C.isDisplayListItemListSnapshot(e)||C.isUpdateLayer(e)||C.isSetLayerId(e))&&d1.push(e)}async function cue(){let e=Kt();We.sortTraceEventsInPlace(d1);for(let t of d1)if(C.isSetLayerId(t)){if(e.mainFrameId!==t.args.data.frame)continue;mD=t.args.data.layerTreeId}else if(C.isUpdateLayer(t))l1.push(t);else if(C.isPaint(t)){if(!t.args.data.layerId)continue;pD.push(t),dD[t.args.data.layerId]=t;continue}else if(C.isDisplayListItemListSnapshot(t)){let n=null;for(let a=l1.length-1;a>-1;a--){let o=l1[a];if(o.pid===t.pid&&o.tid===t.tid){n=o;break}}if(!n||n.args.layerTreeId!==mD)continue;let r=dD[n.args.layerId];if(!r)continue;fD.push(t),hD.set(r,t)}}function gD(){return{paints:pD,snapshots:fD,paintsToSnapshots:hD}}function uue(){return["Meta"]}var pD,fD,hD,dD,mD,l1,d1,vD=g(()=>{d();ut();Pe();
aa();pD=[],fD=[],hD=new Map,dD={},mD=null,l1=[],d1=[];i(iue,"reset");i(sue,"handleEvent");i(cue,"finalize");i(gD,"data");i(uue,"deps")});var Lu={};E(Lu,{threadsInRenderer:()=>m1,threadsInTrace:()=>due});function lue(e,t,n){let r="OTHER";return t.name==="CrRendererMain"?r="MAIN_THREAD":t.name==="DedicatedWorker thread"?r="WORKER":t.name?.startsWith("CompositorTileWorker")?r="RASTERIZER":n.worklets.has(e)?r="AUCTION_WORKLET":t.name?.startsWith("ThreadPool")&&(r="THREAD_POOL"),r}function m1(e,t){let n=[];if(e.processes.size)for(let[r,a]of e.processes)for(let[o,s]of a.threads){if(!s.tree)continue;let c=lue(r,s,t);n.push({name:s.name,pid:r,tid:o,processIsOnMainFrame:a.isOnMainFrame,entries:s.entries,tree:s.tree,type:c,entryToNode:e.entryToNode})}return n}function due(e){let t=bD.get(e);if(t)return t;let n=m1(e.Renderer,e.AuctionWorklets);if(n.length)return bD.set(e,n),n;let r=[];if(e.Samples.profilesInProcess.size)for(let[a,o]of e.Samples.profilesInProcess)for(let[s,c]of o)c.profileTree&&r.push({pid:a,tid:s,name:null,entries:c.profileCalls,processIsOnMainFrame:!1,tree:c.profileTree,type:"CPU_PROFILE",entryToNode:e.Samples.entryToNode});
return bD.set(e,r),r}var bD,wD=g(()=>{d();i(lue,"getThreadTypeForRendererThread");i(m1,"threadsInRenderer");bD=new WeakMap;i(due,"threadsInTrace")});var ED={};E(ED,{LayerPaintEvent:()=>h1,PendingFrame:()=>g1,TimelineFrameBeginFrameQueue:()=>y1,TimelineFrameModel:()=>f1,data:()=>hue,deps:()=>gue,finalize:()=>fue,framesWithinWindow:()=>wue,handleEvent:()=>pue,reset:()=>mue});function mue(){p1.length=0}function pue(e){p1.push(e)}async function fue(){We.sortTraceEventsInPlace(p1),vm=new f1(p1,hm(),om(),Kt(),gD())}function hue(){return{frames:vm?Array.from(vm.frames()):[],framesById:vm?{...vm.framesById()}:{}}}function gue(){return["Meta","Renderer","AuctionWorklets","LayerTree"]}function yue(e){return C.isSetLayerId(e)||C.isBeginFrame(e)||C.isDroppedFrame(e)||C.isRequestMainThreadFrame(e)||C.isBeginMainThreadFrame(e)||C.isNeedsBeginFrameChanged(e)||C.isCommit(e)||C.isCompositeLayers(e)||C.isActivateLayerTree(e)||C.isDrawFrame(e)}function vue(e){return e.name==="RunTask"&&e.cat.includes("disabled-by-default-devtools.timeline")}function wue(e,t,n){let r=_n.lowerBound(e,t||0,(o,s)=>o-s.endTime),a=_n.lowerBound(e,n||1/0,(o,s)=>o-s.startTime);
return e.slice(r,a)}var p1,vm,f1,bue,xD,h1,g1,DD,y1,s4=g(()=>{d();dn();ut();Pe();Jg();vD();aa();c1();wD();p1=[],vm=null;i(mue,"reset");i(pue,"handleEvent");i(fue,"finalize");i(hue,"data");i(gue,"deps");i(yue,"isFrameEvent");i(vue,"entryIsTopLevel");f1=class{static{i(this,"TimelineFrameModel")}#e=[];#t={};#o=new y1;#r=null;#a=!1;#u=!1;#i=null;#n=null;#c=null;#s=null;#l=null;#g=null;#m=null;#p=null;#d=null;#f;constructor(t,n,r,a,o){let c=m1(n,r).filter(u=>u.type==="MAIN_THREAD"&&u.processIsOnMainFrame).map(u=>({tid:u.tid,pid:u.pid,startTime:u.entries[0].ts}));this.#f=o,this.#k(t,c,a.mainFrameId)}framesById(){return this.#t}frames(){return this.#e}#h(t,n){this.#r||this.#y(t,n),this.#s=t,this.#o.addFrameIfNotExists(n,t,!1,!1)}#v(t,n,r){this.#r||this.#y(t,n),this.#o.addFrameIfNotExists(n,t,!0,r),this.#o.setDropped(n,!0),this.#o.setPartial(n,r)}#w(t,n){if(!this.#r){this.#y(t,n);return}if(this.#a||!this.#u){this.#l&&((this.#n?this.#n.triggerTime:this.#s||this.#l)>this.#r.startTime&&(this.#r.idle=
!0,this.#s=null),this.#l=null);let r=this.#o.processPendingBeginFramesOnDrawFrame(n);for(let a of r){let o=this.#r.idle;this.#y(a.startTime,n),o&&this.#n&&this.#b(),a.isDropped&&(this.#r.dropped=!0),a.isPartial&&(this.#r.isPartial=!0)}}this.#a=!1}#x(){this.#r&&this.#n&&!this.#l&&this.#b()}#D(){this.#r&&(this.#u=!0)}#E(){this.#c&&(this.#n=this.#c,this.#c=null,this.#u=!1,this.#a=!0)}#T(t){this.#i=t}#S(t,n){n&&(this.#l=t)}#y(t,n){this.#r&&this.#C(this.#r,t),this.#r=new xD(n,t,O.Micro(t-Kt().traceBounds.min))}#C(t,n){t.setLayerTree(this.#i),t.setEndTime(n),this.#i&&(this.#i.paints=t.paints);let r=this.#e[this.#e.length-1];this.#e.length&&r&&(t.startTime!==r.endTime||t.startTime>t.endTime)&&console.assert(!1,`Inconsistent frame time for frame ${this.#e.length} (${t.startTime} - ${t.endTime})`);let a=this.#e.push(t);t.setIndex(a-1),typeof t.mainFrameId=="number"&&(this.#t[t.mainFrameId]=t)}#b(){!this.#n||!this.#r||(this.#r.paints=this.#n.paints,this.#r.mainFrameId=this.#n.mainFrameId,this.#n=
null)}#k(t,n,r){let a=0;this.#d=n.length&&n[0].tid||null,this.#p=n.length&&n[0].pid||null;for(let o=0;o<t.length;++o){for(;a+1<n.length&&n[a+1].startTime<=t[o].ts;)this.#d=n[++a].tid,this.#p=n[a].pid;this.#I(t[o],r)}this.#d=null,this.#p=null}#I(t,n){C.isSetLayerId(t)&&t.args.data.frame===n?this.#m=t.args.data.layerTreeId:C.isLayerTreeHostImplSnapshot(t)&&Number(t.id)===this.#m?this.#T({entry:t,paints:[]}):(yue(t)&&this.#A(t),t.tid===this.#d&&t.pid===this.#p&&this.#F(t))}#A(t){t.args.layerTreeId===this.#m&&(C.isBeginFrame(t)?this.#h(t.ts,t.args.frameSeqId):C.isDrawFrame(t)?this.#w(t.ts,t.args.frameSeqId):C.isActivateLayerTree(t)?this.#x():C.isRequestMainThreadFrame(t)?this.#D():C.isNeedsBeginFrameChanged(t)?this.#S(t.ts,t.args.data&&!!t.args.data.needsBeginFrame):C.isDroppedFrame(t)&&this.#v(t.ts,t.args.frameSeqId,!!t.args.hasPartialUpdate))}#F(t){if(vue(t)&&(this.#g=t.ts),!this.#c&&bue.has(t.name)&&(this.#c=new g1(this.#g||t.ts)),!!this.#c){if(C.isBeginMainThreadFrame(t)&&t.args.data.frameId&&
(this.#c.mainFrameId=t.args.data.frameId),C.isPaint(t)){let n=this.#f.paintsToSnapshots.get(t);n&&this.#c.paints.push(new h1(t,n))}(C.isCompositeLayers(t)||C.isCommit(t))&&t.args.layerTreeId===this.#m&&this.#E()}}},bue=new Set(["ScheduleStyleRecalculation","InvalidateLayout","BeginMainThreadFrame","ScrollLayer"]),xD=class{static{i(this,"TimelineFrame")}cat="devtools.legacy_frame";name="frame";ph="X";ts;pid=C.ProcessID(-1);tid=C.ThreadID(-1);index=-1;startTime;startTimeOffset;endTime;duration;idle;dropped;isPartial;layerTree;paints;mainFrameId;seqId;constructor(t,n,r){this.seqId=t,this.startTime=n,this.ts=n,this.startTimeOffset=r,this.endTime=this.startTime,this.duration=O.Micro(0),this.idle=!1,this.dropped=!1,this.isPartial=!1,this.layerTree=null,this.paints=[],this.mainFrameId=void 0}setIndex(t){this.index=t}setEndTime(t){this.endTime=t,this.duration=O.Micro(this.endTime-this.startTime)}setLayerTree(t){this.layerTree=t}get dur(){return this.duration}},h1=class{static{i(this,"LayerPain\
tEvent")}#e;#t;constructor(t,n){this.#e=t,this.#t=n}layerId(){return this.#e.args.data.layerId}event(){return this.#e}picture(){let t=this.#t.args.snapshot.params?.layer_rect,n=this.#t.args.snapshot.skp64;return t&&n?{rect:t,serializedPicture:n}:null}},g1=class{static{i(this,"PendingFrame")}paints;mainFrameId;triggerTime;constructor(t){this.paints=[],this.mainFrameId=void 0,this.triggerTime=t}},DD=class{static{i(this,"BeginFrameInfo")}seqId;startTime;isDropped;isPartial;constructor(t,n,r,a){this.seqId=t,this.startTime=n,this.isDropped=r,this.isPartial=a}},y1=class{static{i(this,"TimelineFrameBeginFrameQueue")}queueFrames=[];mapFrames={};addFrameIfNotExists(t,n,r,a){t in this.mapFrames||(this.mapFrames[t]=new DD(t,n,r,a),this.queueFrames.push(t))}setDropped(t,n){t in this.mapFrames&&(this.mapFrames[t].isDropped=n)}setPartial(t,n){t in this.mapFrames&&(this.mapFrames[t].isPartial=n)}processPendingBeginFramesOnDrawFrame(t){let n=[];if(t in this.mapFrames){for(;this.queueFrames[0]!==t;){let r=this.
queueFrames[0];this.mapFrames[r].isDropped&&n.push(this.mapFrames[r]),delete this.mapFrames[r],this.queueFrames.shift()}n.push(this.mapFrames[t]),delete this.mapFrames[t],this.queueFrames.shift()}return n}};i(wue,"framesWithinWindow")});var CD={};E(CD,{data:()=>Tue,deps:()=>Sue,finalize:()=>Eue,handleEvent:()=>Due,reset:()=>xue});function xue(){TD.clear(),SD=[]}function Due(e){C.isGPUTask(e)&&We.addEventToProcessThread(e,TD)}async function Eue(){let{gpuProcessId:e,gpuThreadId:t}=Kt(),n=TD.get(e);n&&t&&(SD=n.get(t)||[])}function Tue(){return{mainGPUThreadTasks:SD}}function Sue(){return["Meta"]}var TD,SD,c4=g(()=>{d();ut();Pe();aa();TD=new Map,SD=[];i(xue,"reset");i(Due,"handleEvent");i(Eue,"finalize");i(Tue,"data");i(Sue,"deps")});var ID={};E(ID,{data:()=>Aue,finalize:()=>Iue,handleEvent:()=>kue,reset:()=>Cue});function Cue(){bm.clear(),v1.clear(),b1.clear(),w1.clear(),kD.clear()}function kue(e){if(C.isPaintImage(e)){let t=bm.get(e.pid)||new Map,n=t.get(e.tid)||[];n.push(e),t.set(e.tid,n),bm.set(e.pid,t),e.args.data.url&&Me.getWithDefault(kD,e.args.data.url,()=>[]).push(e);return}if(C.isDecodeLazyPixelRef(e)&&typeof e.args?.LazyPixelRef<"u"){let t=v1.get(e.pid)||new Map,n=t.get(e.tid)||[];n.push(e),t.set(e.tid,n),v1.set(e.pid,t)}if(C.isDrawLazyPixelRef(e)&&typeof e.args?.LazyPixelRef<"u"){let t=bm.get(e.pid)?.get(e.tid)?.at(-1);if(!t)return;b1.set(e.args.LazyPixelRef,t);return}if(C.isDecodeImage(e)){let t=bm.get(e.pid)?.get(e.tid)?.at(-1);if(t){w1.set(e,t);return}let n=v1.get(e.pid)?.get(e.tid)?.at(-1);if(typeof n?.args?.LazyPixelRef>"u")return;let r=b1.get(n.args.LazyPixelRef);if(!r)return;w1.set(e,r)}}async function Iue(){}function Aue(){return{paintImageByDrawLazyPixelRef:b1,paintImageForEvent:w1,paintImageEventForUrl:kD}}
var bm,v1,b1,w1,kD,u4=g(()=>{d();dn();Pe();bm=new Map,v1=new Map,b1=new Map,w1=new Map,kD=new Map;i(Cue,"reset");i(kue,"handleEvent");i(Iue,"finalize");i(Aue,"data")});var MD={};E(MD,{data:()=>Nue,deps:()=>Pue,finalize:()=>Oue,handleEvent:()=>Rue,reset:()=>Fue});function Fue(){AD.clear(),wm.clear(),FD.clear(),D1.clear(),x1.clear(),RD.clear(),_D.clear()}function Bu(e){D1.set(e.event,e.initiator);let t=x1.get(e.initiator)||[];t.push(e.event),x1.set(e.initiator,t)}function Rue(e){if(C.isScheduleStyleRecalculation(e))AD.set(e.args.data.frame,e);else if(C.isUpdateLayoutTree(e)){if(e.args.beginData){FD.set(e.args.beginData.frame,e);let t=AD.get(e.args.beginData.frame);t&&Bu({event:e,initiator:t})}}else if(C.isInvalidateLayout(e)){let t=e;if(!wm.has(e.args.data.frame)){let n=FD.get(e.args.data.frame);if(n){let{endTime:r}=ue.eventTimingsMicroSeconds(n),a=D1.get(n);a&&r&&r>e.ts&&(t=a)}}wm.set(e.args.data.frame,t)}else if(C.isLayout(e)){let t=wm.get(e.args.beginData.frame);t&&Bu({event:e,initiator:t}),wm.delete(e.args.beginData.frame)}else if(C.isWebSocketCreate(e))RD.set(e.args.data.identifier,e);else if(C.isWebSocketInfo(e)||C.isWebSocketTransfer(e)){let t=RD.
get(e.args.data.identifier);t&&Bu({event:e,initiator:t})}else if(C.isSchedulePostTaskCallback(e))_D.set(e.args.data.taskId,e);else if(C.isRunPostTaskCallback(e)||C.isAbortPostTaskCallback(e)){let t=_D.get(e.args.data.taskId);t&&Bu({event:e,initiator:t})}}function _ue(){let e=am().flows;for(let t=0;t<e.length;t++){let n=e[t];for(let r=0;r<n.length-1;r++)Bu({event:n[r+1],initiator:n[r]})}}function Mue(){let e=Yx().schedulerToRunEntryPoints.entries();for(let[t,n]of e)for(let r of n)Bu({event:r,initiator:t})}async function Oue(){_ue(),Mue()}function Nue(){return{eventToInitiator:D1,initiatorToEvents:x1}}function Pue(){return["Flows","AsyncJSCalls"]}var AD,wm,FD,D1,x1,RD,_D,l4=g(()=>{d();ut();Pe();Jx();Kg();AD=new Map,wm=new Map,FD=new Map,D1=new Map,x1=new Map,RD=new Map,_D=new Map;i(Fue,"reset");i(Bu,"storeInitiator");i(Rue,"handleEvent");i(_ue,"createRelationshipsFromFlows");i(Mue,"createRelationshipsFromAsyncJSCalls");i(Oue,"finalize");i(Nue,"data");i(Pue,"deps")});var PD={};E(PD,{data:()=>que,finalize:()=>jue,handleEvent:()=>Uue,handleUserConfig:()=>Bue,reset:()=>Lue});function Lue(){T1.clear(),no=null,xm.length=0,E1=!1,Dm=null}function Bue(e){Dm=e.maxInvalidationEventsPerEvent}function OD(e,t){let n=T1.get(e)||[];n.push(t),Dm!==null&&n.length>Dm&&n.shift(),T1.set(e,n);let r=ND.get(e)??0;ND.set(e,r+1)}function Uue(e){if(Dm!==0){if(C.isUpdateLayoutTree(e)){no=e;for(let t of xm){if(C.isLayoutInvalidationTracking(t))continue;let n=no.args.beginData?.frame;n&&t.args.data.frame===n&&OD(e,t)}return}if(C.isInvalidationTracking(e)){if(E1&&(xm.length=0,no=null,E1=!1),no&&(C.isScheduleStyleInvalidationTracking(e)||C.isStyleRecalcInvalidationTracking(e)||C.isStyleInvalidatorInvalidationTracking(e))){let t=no.ts+(no.dur||0);e.ts>=no.ts&&e.ts<=t&&no.args.beginData?.frame===e.args.data.frame&&OD(no,e)}xm.push(e);return}if(C.isPaint(e)){E1=!0;return}if(C.isLayout(e)){let t=e.args.beginData.frame;for(let n of xm)C.isLayoutInvalidationTracking(n)&&n.args.data.frame===
t&&OD(e,n)}}}async function jue(){}function que(){return{invalidationsForEvent:T1,invalidationCountForEvent:ND}}var T1,ND,no,E1,xm,Dm,d4=g(()=>{d();Pe();T1=new Map,ND=new Map,no=null,E1=!1,xm=[];i(Lue,"reset");Dm=null;i(Bue,"handleUserConfig");i(OD,"addInvalidationToEvent");i(Uue,"handleEvent");i(jue,"finalize");i(que,"data")});var UD={};E(UD,{data:()=>BD,deps:()=>Yue,finalize:()=>$ue,getFrameIdForPageLoadEvent:()=>C1,handleEvent:()=>Hue,metricIsLCP:()=>Kue,reset:()=>zue,scoreClassificationForDOMContentLoaded:()=>h4,scoreClassificationForFirstContentfulPaint:()=>m4,scoreClassificationForLargestContentfulPaint:()=>f4,scoreClassificationForTimeToInteractive:()=>p4,scoreClassificationForTotalBlockingTime:()=>g4});function zue(){Tm.clear(),Em=[],LD=[],S1.clear()}function Hue(e){C.eventIsPageLoadEvent(e)&&Em.push(e)}function Wue(e,t){let n=e.args.data?.navigationId;if(!n)throw new Error("Navigation event unexpectedly had no navigation ID.");let r=C1(t),{rendererProcessesByFrame:a}=Kt(),o=a.get(r);if(!(!o||!o.get(t.pid))&&!C.isNavigationStart(t)){if(C.isFirstContentfulPaint(t)){let c=O.Micro(t.ts-e.ts),u=m4(c);Ki(r,n,{event:t,metricName:"FCP",classification:u,navigation:e,timing:c});return}if(C.isFirstPaint(t)){let c=O.Micro(t.ts-e.ts);Ki(r,n,{event:t,metricName:"FP",classification:"unclassified",navigation:e,timing:c});
return}if(C.isMarkDOMContent(t)){let c=O.Micro(t.ts-e.ts),u={event:t,metricName:"DCL",classification:h4(c),navigation:e,timing:c};Ki(r,n,u);return}if(C.isInteractiveTime(t)){let c=O.Micro(t.ts-e.ts),u={event:t,metricName:"TTI",classification:p4(c),navigation:e,timing:c};Ki(r,n,u);let l=ue.milliToMicro(O.Milli(t.args.args.total_blocking_time_ms)),m={event:t,metricName:"TBT",classification:g4(l),navigation:e,timing:l};Ki(r,n,m);return}if(C.isMarkLoad(t)){let c=O.Micro(t.ts-e.ts);Ki(r,n,{event:t,metricName:"L",classification:"unclassified",navigation:e,timing:c});return}if(C.isLargestContentfulPaintCandidate(t)){let c=t.args.data?.candidateIndex;if(!c)throw new Error("Largest Contentful Paint unexpectedly had no candidateIndex.");let u=O.Micro(t.ts-e.ts),l={event:t,metricName:"LCP",classification:f4(u),navigation:e,timing:u},m=Me.getWithDefault(Tm,r,()=>new Map),f=Me.getWithDefault(m,n,()=>new Map).get("LCP");if(f===void 0){S1.add(l.event),Ki(r,n,l);return}let h=f.event;if(!C.isLargestContentfulPaintCandidate(
h))return;let y=h.args.data?.candidateIndex;if(!y)return;y<c&&(S1.delete(h),S1.add(l.event),Ki(r,n,l));return}if(!C.isLayoutShift(t))return Zd(t,`Unexpected event type: ${t}`)}}function Ki(e,t,n){let r=Me.getWithDefault(Tm,e,()=>new Map),a=Me.getWithDefault(r,t,()=>new Map);a.delete(n.metricName),a.set(n.metricName,n)}function C1(e){if(C.isFirstContentfulPaint(e)||C.isInteractiveTime(e)||C.isLargestContentfulPaintCandidate(e)||C.isNavigationStart(e)||C.isLayoutShift(e)||C.isFirstPaint(e))return e.args.frame;if(C.isMarkDOMContent(e)||C.isMarkLoad(e)){let t=e.args.data?.frame;if(!t)throw new Error("MarkDOMContent unexpectedly had no frame ID.");return t}Zd(e,`Unexpected event type: ${e}`)}function Gue(e){if(C.isFirstContentfulPaint(e)||C.isLargestContentfulPaintCandidate(e)||C.isFirstPaint(e)){let t=e.args.data?.navigationId;if(!t)throw new Error("Trace event unexpectedly had no navigation ID.");let{navigationsByNavigationId:n}=Kt(),r=n.get(t);return r||null}if(C.isMarkDOMContent(e)||C.isInteractiveTime(
e)||C.isLayoutShift(e)||C.isMarkLoad(e)){let t=C1(e),{navigationsByFrameId:n}=Kt();return We.getNavigationForTraceEvent(e,t,n)}return C.isNavigationStart(e)?null:Zd(e,`Unexpected event type: ${e}`)}function m4(e){let t=ue.secondsToMicro(O.Seconds(1.8)),n=ue.secondsToMicro(O.Seconds(3)),r="bad";return e<=n&&(r="ok"),e<=t&&(r="good"),r}function p4(e){let t=ue.secondsToMicro(O.Seconds(3.8)),n=ue.secondsToMicro(O.Seconds(7.3)),r="bad";return e<=n&&(r="ok"),e<=t&&(r="good"),r}function f4(e){let t=ue.secondsToMicro(O.Seconds(2.5)),n=ue.secondsToMicro(O.Seconds(4)),r="bad";return e<=n&&(r="ok"),e<=t&&(r="good"),r}function h4(e){return"unclassified"}function g4(e){let t=ue.milliToMicro(O.Milli(200)),n=ue.milliToMicro(O.Milli(600)),r="bad";return e<=n&&(r="ok"),e<=t&&(r="good"),r}function Vue(){let e=[],n=[...Tm.values()].flatMap(r=>[...r.values()]);for(let r=0;r<n.length;r++){let o=n[r].get("LCP");o?.event&&e.push(o.event)}return e}async function $ue(){Em.sort((a,o)=>a.ts-o.ts);for(let a of Em){
let o=Gue(a);o&&Wue(o,a)}let e=Vue(),t=Kt().mainFrameId,n=Em.filter(a=>!C.isLargestContentfulPaintCandidate(a));LD=[...e,...n].filter(C.isMarkerEvent).filter(a=>C1(a)===t).sort((a,o)=>a.ts-o.ts)}function BD(){return{metricScoresByFrameId:Tm,allMarkerEvents:LD}}function Yue(){return["Meta"]}function Kue(e){return e.metricName==="LCP"}var Tm,LD,Em,S1,jD=g(()=>{d();dn();ut();Pe();aa();Tm=new Map,LD=[];i(zue,"reset");Em=[],S1=new Set;i(Hue,"handleEvent");i(Wue,"storePageLoadMetricAgainstNavigationId");i(Ki,"storeMetricScore");i(C1,"getFrameIdForPageLoadEvent");i(Gue,"getNavigationForPageLoadEvent");i(m4,"scoreClassificationForFirstContentfulPaint");i(p4,"scoreClassificationForTimeToInteractive");i(f4,"scoreClassificationForLargestContentfulPaint");i(h4,"scoreClassificationForDOMContentLoaded");i(g4,"scoreClassificationForTotalBlockingTime");i(Vue,"gatherFinalLCPEvents");i($ue,"finalize");i(BD,"data");i(Yue,"deps");i(Kue,"metricIsLCP")});var zD={};E(zD,{data:()=>Que,deps:()=>ele,finalize:()=>Zue,handleEvent:()=>Xue,reset:()=>Jue});function Jue(){qD.clear()}function Xue(e){if(!C.isLargestImagePaintCandidate(e)||!e.args.data)return;Me.getWithDefault(qD,e.pid,()=>new Map).set(e.args.data.DOMNodeId,e)}async function Zue(){let e=Wo().byTime,{traceBounds:t,navigationsByNavigationId:n}=Kt(),r=BD().metricScoresByFrameId;for(let[a,o]of n){let c=r.get(o.args.frame)?.get(a)?.get("LCP")?.event;if(!c||!C.isLargestContentfulPaintCandidate(c))continue;let u=c.args.data?.nodeId;if(!u)continue;let l=qD.get(c.pid)?.get(u),m=l?.args.data?.imageUrl;if(!m)continue;let p=o?.ts??t.min,f=l.ts,h;for(let y of e)if(!(y.ts<p)){if(y.ts>=f)break;if(y.args.data.url===m||y.args.data.redirects.some(b=>b.url===m)){h=y;break}}h&&y4.set(a,h)}}function Que(){return{lcpRequestByNavigationId:y4}}function ele(){return["Meta","NetworkRequests","PageLoadMetrics"]}var qD,y4,v4=g(()=>{d();dn();Pe();aa();Nu();jD();qD=new Map,y4=new Map;i(Jue,"reset");i(Xue,"handl\
eEvent");i(Zue,"finalize");i(Que,"data");i(ele,"deps")});var WD={};E(WD,{data:()=>ale,finalize:()=>rle,handleEvent:()=>nle,reset:()=>tle});function tle(){HD.clear()}function nle(e){C.isLargestTextPaintCandidate(e)&&e.args.data&&HD.set(e.args.data.DOMNodeId,e)}async function rle(){}function ale(){return HD}var HD,b4=g(()=>{d();Pe();HD=new Map;i(tle,"reset");i(nle,"handleEvent");i(rle,"finalize");i(ale,"data")});var YD={};E(YD,{data:()=>$D,deps:()=>ule,finalize:()=>sle,handleEvent:()=>ile,reset:()=>ole,screenshotImageDataUri:()=>cle});function ole(){GD.length=0,VD.length=0,I1.length=0,k1.length=0,w4={}}function ile(e){C.isLegacyScreenshot(e)?VD.push(e):C.isScreenshot(e)?k1.push(e):C.isPipelineReporter(e)&&GD.push(e)}async function sle(){let e=We.createMatchedSortedSyntheticEvents(GD);w4=Object.fromEntries(e.map(t=>{let n=t.args.data.beginEvent.args.chrome_frame_reporter.frame_sequence,r=O.Micro(t.ts+t.dur);return[n,r]}));for(let t of VD){let{cat:n,name:r,ph:a,pid:o,tid:s}=t,c=xn.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:t,cat:n,name:r,ph:a,pid:o,tid:s,ts:t.ts,args:{dataUri:`data:image/jpg;base64,${t.args.snapshot}`}});I1.push(c)}}function cle(e){return C.isLegacySyntheticScreenshot(e)?e.args.dataUri:`data:image/jpg;base64,${e.args.snapshot}`}function $D(){return{legacySyntheticScreenshots:I1.length?I1:null,screenshots:k1.length?k1:null}}function ule(){return["Meta"]}var GD,
VD,k1,I1,w4,KD=g(()=>{d();ut();Pe();GD=[],VD=[],k1=[],I1=[],w4={};i(ole,"reset");i(ile,"handleEvent");i(sle,"finalize");i(cle,"screenshotImageDataUri");i($D,"data");i(ule,"deps")});var ZD={};E(ZD,{MAX_CLUSTER_DURATION:()=>F1,MAX_SHIFT_TIME_DELTA:()=>Sm,data:()=>yle,deps:()=>vle,finalize:()=>hle,handleEvent:()=>dle,reset:()=>lle,scoreClassificationForLayoutShift:()=>ble});function lle(){Ji.length=0,km.length=0,_1.length=0,x4.length=0,P1.length=0,L1.length=0,M1.length=0,N1.length=0,O1.length=0,Cm.length=0,Uu.clear(),_r.length=0,R1=0,ju.length=0,JD=-1,XD.clear()}function dle(e){if(C.isLayoutShift(e)&&!e.args.data?.had_recent_input){Ji.push(e);return}if(C.isLayoutInvalidationTracking(e)){km.push(e);return}if(C.isScheduleStyleInvalidationTracking(e)&&_1.push(e),C.isStyleRecalcInvalidationTracking(e)&&x4.push(e),C.isPrePaint(e)){P1.push(e);return}if(C.isRenderFrameImplCreateChildFrame(e)&&M1.push(e),C.isDomLoading(e)&&O1.push(e),C.isLayoutImageUnsized(e)&&N1.push(e),C.isBeginRemoteFontLoad(e)&&Cm.push({display:e.args.display,url:e.args.url,beginRemoteFontLoadEvent:e}),C.isRemoteFontLoaded(e))for(let t of Cm)t.url===e.args.url&&(t.name=e.args.name);C.isPaintImage(e)&&L1.
push(e)}function A1(e){return{min:e,max:e,range:O.Micro(0)}}function oa(e,t){e.max=t,e.range=O.Micro(e.max-e.min)}function mle(e){let t=$D();if(t.screenshots){let n=We.findPreviousEventBeforeTimestamp(t.screenshots,e),r=n?t.screenshots[t.screenshots.indexOf(n)+1]:null;return{before:n,after:r}}if(t.legacySyntheticScreenshots){let n=We.findPreviousEventBeforeTimestamp(t.legacySyntheticScreenshots,e),r=n?t.legacySyntheticScreenshots[t.legacySyntheticScreenshots.indexOf(n)+1]:null;return{before:n,after:r}}return{before:null,after:null}}function ple(){let{traceBounds:e}=Kt();ju.push({ts:e.min,score:0});for(let t of _r){let n=0;t.events[0].args.data&&ju.push({ts:t.clusterWindow.min,score:t.events[0].args.data.weighted_score_delta});for(let r=0;r<t.events.length;r++){let a=t.events[r];a.args.data&&(n+=a.args.data.weighted_score_delta,ju.push({ts:a.ts,score:n}))}ju.push({ts:t.clusterWindow.max,score:0})}}function fle(){Uu.clear();for(let e of Ji)if(e.args.data?.impacted_nodes)for(let t of e.args.
data.impacted_nodes)Uu.add(t.node_id);for(let e of km)e.args.data?.nodeId&&Uu.add(e.args.data.nodeId);for(let e of _1)e.args.data?.nodeId&&Uu.add(e.args.data.nodeId)}async function hle(){Ji.sort((e,t)=>e.ts-t.ts),P1.sort((e,t)=>e.ts-t.ts),km.sort((e,t)=>e.ts-t.ts),M1.sort((e,t)=>e.ts-t.ts),O1.sort((e,t)=>e.ts-t.ts),N1.sort((e,t)=>e.ts-t.ts),Cm.sort((e,t)=>e.beginRemoteFontLoadEvent.ts-t.beginRemoteFontLoadEvent.ts),L1.sort((e,t)=>e.ts-t.ts),await gle(),ple(),fle()}async function gle(){let{navigationsByFrameId:e,mainFrameId:t,traceBounds:n}=Kt(),r=e.get(t)||[];if(Ji.length===0)return;let a=Ji[0].ts,o=Ji[0].ts,s=null;for(let c of Ji){let u=c.ts-a>F1,l=c.ts-o>Sm,m=_n.nearestIndexFromEnd(r,b=>b.ts<c.ts),p=s!==m&&m!==null;if(u||l||p||!_r.length){let b=c.ts,w=u?a+F1:1/0,D=l?o+Sm:1/0,T=p?r[m].ts:1/0,S=Math.min(w,D,T);if(_r.length>0){let _=_r[_r.length-1];oa(_.clusterWindow,O.Micro(S))}let k=m===null?C.NO_NAVIGATION:r[m].args.data?.navigationId;_r.push({name:"SyntheticLayoutShiftCluster",events:[],
clusterWindow:A1(b),clusterCumulativeScore:0,scoreWindows:{good:A1(b)},navigationId:k,ts:c.ts,pid:c.pid,tid:c.tid,ph:"X",cat:"",dur:O.Micro(-1)}),a=b}let f=_r[_r.length-1],h=m!==null?O.Micro(c.ts-r[m].ts):void 0;if(f.clusterCumulativeScore+=c.args.data?c.args.data.weighted_score_delta:0,!c.args.data)continue;let y=xn.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:c,...c,name:"SyntheticLayoutShift",args:{frame:c.args.frame,data:{...c.args.data,rawEvent:c,navigationId:f.navigationId??void 0}},parsedData:{timeFromNavigation:h,screenshots:mle(c.ts),cumulativeWeightedScoreInWindow:f.clusterCumulativeScore,sessionWindowData:{cumulativeWindowScore:0,id:_r.length}}});f.events.push(y),oa(f.clusterWindow,c.ts),o=c.ts,s=m}for(let c of _r){let u=0,l=-1;if(c===_r[_r.length-1]){let h=F1+c.clusterWindow.min,y=c.clusterWindow.max+Sm,b=_n.nearestIndexFromBeginning(r,T=>T.ts>c.clusterWindow.max),w=b?r[b].ts:1/0,D=Math.min(h,y,n.max,w);oa(c.clusterWindow,O.Micro(D))}let m=0,p=null;for(let h of c.
events){u+=h.args.data?h.args.data.weighted_score_delta:0,l=h.parsedData.sessionWindowData.id;let y=h.ts;h.parsedData.sessionWindowData.cumulativeWindowScore=c.clusterCumulativeScore,u<.1?oa(c.scoreWindows.good,y):u>=.1&&u<.25?(c.scoreWindows.needsImprovement||(oa(c.scoreWindows.good,O.Micro(y-1)),c.scoreWindows.needsImprovement=A1(y)),oa(c.scoreWindows.needsImprovement,y)):u>=.25&&(c.scoreWindows.bad||(c.scoreWindows.needsImprovement?oa(c.scoreWindows.needsImprovement,O.Micro(y-1)):oa(c.scoreWindows.good,O.Micro(y-1)),c.scoreWindows.bad=A1(h.ts)),oa(c.scoreWindows.bad,y)),c.scoreWindows.bad?oa(c.scoreWindows.bad,c.clusterWindow.max):c.scoreWindows.needsImprovement?oa(c.scoreWindows.needsImprovement,c.clusterWindow.max):oa(c.scoreWindows.good,c.clusterWindow.max);let b=h.args.data?.weighted_score_delta;b!==void 0&&b>m&&(m=b,p=h)}p&&(c.worstShiftEvent=p),c.ts=c.events[0].ts;let f=ue.eventTimingsMicroSeconds(c.events[c.events.length-1]);c.dur=O.Micro(f.endTime-c.events[0].ts+Sm),u>R1&&(JD=
l,R1=u),c.navigationId&&Me.getWithDefault(XD,c.navigationId,()=>[]).push(c)}}function yle(){return{clusters:_r,sessionMaxScore:R1,clsWindowID:JD,prePaintEvents:P1,layoutInvalidationEvents:km,scheduleStyleInvalidationEvents:_1,styleRecalcInvalidationEvents:[],renderFrameImplCreateChildFrameEvents:M1,domLoadingEvents:O1,layoutImageUnsizedEvents:N1,remoteFonts:Cm,scoreRecords:ju,backendNodeIds:[...Uu],clustersByNavigationId:new Map(XD),paintImageEvents:L1}}function vle(){return["Screenshots","Meta"]}function ble(e){let t="good";return e>=.1&&(t="ok"),e>=.25&&(t="bad"),t}var F1,Sm,Ji,km,_1,x4,M1,O1,N1,Cm,Uu,P1,L1,R1,JD,_r,XD,ju,D4=g(()=>{d();dn();ut();Pe();aa();KD();F1=ue.milliToMicro(O.Milli(5e3)),Sm=ue.milliToMicro(O.Milli(1e3)),Ji=[],km=[],_1=[],x4=[],M1=[],O1=[],N1=[],Cm=[],Uu=new Set,P1=[],L1=[],R1=0,JD=-1,_r=[],XD=new Map,ju=[];i(lle,"reset");i(dle,"handleEvent");i(A1,"traceWindowFromTime");i(oa,"updateTraceWindowMax");i(mle,"findScreenshots");i(ple,"buildScoreRecords");i(fle,"collec\
tNodes");i(hle,"finalize");i(gle,"buildLayoutShiftsClusters");i(yle,"data");i(vle,"deps");i(ble,"scoreClassificationForLayoutShift")});var QD={};E(QD,{data:()=>Ele,finalize:()=>Dle,handleEvent:()=>xle,reset:()=>wle});function wle(){B1.clear()}function xle(e){if(C.isUpdateCounters(e)){let t=Me.getWithDefault(B1,e.pid,()=>[]);t.push(e),B1.set(e.pid,t)}}async function Dle(){}function Ele(){return{updateCountersByProcess:B1}}var B1,E4=g(()=>{d();dn();Pe();B1=new Map;i(wle,"reset");i(xle,"handleEvent");i(Dle,"finalize");i(Ele,"data")});var eE={};E(eE,{data:()=>kle,finalize:()=>Cle,handleEvent:()=>Sle,reset:()=>Tle});function Tle(){Im.clear()}function Sle(e){if(C.isTracingStartedInBrowser(e)){for(let t of e.args.data?.frames??[])Im.set(t.frame,t);return}if(C.isCommitLoad(e)){let t=e.args.data;if(!t)return;let n=Im.get(t.frame);if(!n)return;Im.set(t.frame,{...n,url:t.url||n.url,name:t.name||t.name})}}async function Cle(){}function kle(){return{frames:Im}}var Im,T4=g(()=>{d();Pe();Im=new Map;i(Tle,"reset");i(Sle,"handleEvent");i(Cle,"finalize");i(kle,"data")});var tE={};E(tE,{data:()=>Ole,deps:()=>Ile,finalize:()=>Mle,handleEvent:()=>Fle,reset:()=>Ale});function S4(e,t){if(t.startsWith("data:")||t.startsWith("blob:")||t.startsWith("javascript:")||t.startsWith("mailto:"))return t;try{return new URL(t,e).href}catch{}return null}function Ile(){return["Meta","NetworkRequests"]}function Ale(){Am.clear()}function Fle(e){let t=i((n,r)=>{let a=String(r),o=`${n}.${a}`;return Me.getWithDefault(Am,o,()=>({isolate:n,scriptId:a,frame:"",ts:0}))},"getOrMakeScript");if(C.isTargetRundownEvent(e)&&e.args.data){let{isolate:n,scriptId:r,frame:a}=e.args.data,o=t(n,r);o.frame=a,o.ts=e.ts;return}if(C.isV8SourceRundownEvent(e)){let{isolate:n,scriptId:r,url:a,sourceUrl:o,sourceMapUrl:s}=e.args.data,c=t(n,r);c.url=a,o&&(c.sourceUrl=o),s&&(c.sourceMapUrl=s);return}if(C.isV8SourceRundownSourcesScriptCatchupEvent(e)){let{isolate:n,scriptId:r,sourceText:a}=e.args.data,o=t(n,r);o.content=a;return}if(C.isV8SourceRundownSourcesLargeScriptCatchupEvent(e)){let{isolate:n,scriptId:r,
sourceText:a}=e.args.data,o=t(n,r);o.content=(o.content??"")+a;return}}function Rle(e,t){for(let n of e.frameByProcessId?.values()){let r=n.get(t);if(r)return r}return null}function _le(e,t){return e.find(n=>n.args.data.url===t.url)??null}async function Mle(e){let t=[...Wo().byId.values()];for(let a of Am.values())a.request=_le(t,a)??void 0;if(!e.resolveSourceMap)return;let n=Kt(),r=[];for(let a of Am.values()){if(!a.frame||!a.url||!a.sourceMapUrl)continue;let o=Rle(n,a.frame)?.url;if(!o)continue;let s=a.url;a.sourceUrl&&(s=S4(o,a.sourceUrl)??a.sourceUrl);let c=S4(s,a.sourceMapUrl);if(!c)continue;a.sourceMapUrl=c;let u={scriptId:a.scriptId,scriptUrl:s,sourceMapUrl:c,frame:a.frame},l=e.resolveSourceMap(u).then(m=>{m&&(a.sourceMap=m)});r.push(l)}await Promise.all(r)}function Ole(){return{scripts:[...Am.values()]}}var Am,C4=g(()=>{d();dn();Pe();aa();Nu();i(S4,"completeURL");Am=new Map;i(Ile,"deps");i(Ale,"reset");i(Fle,"handleEvent");i(Rle,"findFrame");i(_le,"findNetworkRequest");i(Mle,"f\
inalize");i(Ole,"data")});var rE={};E(rE,{data:()=>Ble,finalize:()=>Lle,handleEvent:()=>Ple,reset:()=>Nle});function Nle(){U1=null,nE.clear()}function Ple(e){if(C.isSelectorStats(e)&&U1&&e.args.selector_stats){nE.set(U1,{timings:e.args.selector_stats.selector_timings});return}if(C.isUpdateLayoutTree(e)){U1=e;return}}async function Lle(){}function Ble(){return{dataForUpdateLayoutEvent:nE}}var U1,nE,k4=g(()=>{d();Pe();U1=null,nE=new Map;i(Nle,"reset");i(Ple,"handleEvent");i(Lle,"finalize");i(Ble,"data")});var aE={};E(aE,{data:()=>Wle,deps:()=>Gle,finalize:()=>qle,handleEvent:()=>jle,reset:()=>Ule});function Ule(){j1.length=0}function jle(e){}async function qle(){zle(),We.sortTraceEventsInPlace(j1)}function zle(){for(let e of Wo().byTime){let t=null;for(let s of e.args.data.responseHeaders){let c=s.name.toLocaleLowerCase();if(c==="server-timing"||c==="server-timing-test"){s.name="server-timing",t=qg.ServerTiming.parseHeaders([s]);continue}}let n=t?.find(s=>s.metric===I4)?.start,r=t?.find(s=>s.metric===A4)?.start;if(!n||!r||!t)continue;let a=n*1e3,o=r*1e3;j1.push(...Hle(e,a,o,t))}}function Hle(e,t,n,r){let a=e.args.data.syntheticData.sendStartTime,o=e.args.data.syntheticData.sendStartTime+e.args.data.syntheticData.waiting,s=O.Micro((t-a+n-o)/2),c=[];for(let u of r){if(u.metric===I4||u.metric===A4||u.start===null)continue;let l=ue.milliToMicro(O.Milli(u.start))-s,p=new URL(e.args.data.url).origin,f=xn.SyntheticEventsManager.registerServerTiming({rawSourceEvent:e.rawSourceEvent,name:u.metric,
ph:"X",pid:C.ProcessID(0),tid:C.ThreadID(0),ts:O.Micro(l),dur:ue.milliToMicro(O.Milli(u.value)),cat:"devtools.server-timing",args:{data:{desc:u.description||void 0,origin:p}}});e.args.data.syntheticServerTimings||(e.args.data.syntheticServerTimings=[]),e.args.data.syntheticServerTimings.push(f),c.push(f)}return c}function Wle(){return{serverTimings:j1}}function Gle(){return["NetworkRequests"]}var j1,I4,A4,F4=g(()=>{d();dn();ut();Pe();Nu();j1=[];i(Ule,"reset");i(jle,"handleEvent");i(qle,"finalize");I4="response-start",A4="response-end";i(zle,"extractServerTimings");i(Hle,"createSyntheticServerTiming");i(Wle,"data");i(Gle,"deps")});var pE={};E(pE,{LONG_INTERACTION_THRESHOLD:()=>uE,categoryOfInteraction:()=>R4,data:()=>mE,deps:()=>Qle,finalize:()=>Zle,handleEvent:()=>Kle,removeNestedInteractions:()=>_4,reset:()=>Yle,scoreClassificationForInteractionToNextPaint:()=>ede});function Yle(){iE.length=0,sE.length=0,cE.length=0,Rm.length=0,dE.length=0,lE.clear(),q1.length=0,Fm=null}function Kle(e){if(C.isBeginCommitCompositorFrame(e)){sE.push(e);return}if(C.isParseMetaViewport(e)){cE.push(e);return}if(!C.isEventTiming(e)||(C.isEventTimingEnd(e)&&lE.set(e.id,e),iE.push(e),!e.args.data||!C.isEventTimingStart(e)))return;let{duration:t,interactionId:n}=e.args.data;t<1||n===void 0||n===0||dE.push(e)}function R4(e){return Jle.has(e.type)?"POINTER":Xle.has(e.type)?"KEYBOARD":"OTHER"}function _4(e){let t={POINTER:new Map,KEYBOARD:new Map,OTHER:new Map};function n(a){let o=R4(a),s=t[o],c=O.Micro(a.ts+a.dur),u=s.get(c);if(!u){s.set(c,a);return}if(a.ts<u.ts)s.set(c,a);else if(a.ts===u.ts&&a.interactionId===u.interactionId){let l=u.processingEnd-
u.processingStart;a.processingEnd-a.processingStart>l&&s.set(c,a)}a.processingStart<u.processingStart&&(u.processingStart=a.processingStart,oE(u)),a.processingEnd>u.processingEnd&&(u.processingEnd=a.processingEnd,oE(u))}i(n,"storeEventIfEarliestForCategoryAndEndTime");for(let a of e)n(a);let r=Object.values(t).flatMap(a=>Array.from(a.values()));return r.sort((a,o)=>a.ts-o.ts),r}function oE(e){let t=e.args.data.beginEvent,n=e.args.data.endEvent;e.inputDelay=O.Micro(e.processingStart-t.ts),e.mainThreadHandling=O.Micro(e.processingEnd-e.processingStart),e.presentationDelay=O.Micro(n.ts-e.processingEnd)}async function Zle(){let{navigationsByFrameId:e}=Kt();for(let t of dE){let n=lE.get(t.id);if(!n)continue;let{type:r,interactionId:a,timeStamp:o,processingStart:s,processingEnd:c}=t.args.data;if(!r||!a||!o||!s||!c)continue;let u=O.Micro(ue.milliToMicro(s)-ue.milliToMicro(o)+t.ts),l=O.Micro(ue.milliToMicro(c)-ue.milliToMicro(o)+t.ts),m=t.args.frame??t.args.data.frame??"",f=We.getNavigationForTraceEvent(
t,m,e)?.args.data?.navigationId,h=xn.SyntheticEventsManager.registerSyntheticEvent({rawSourceEvent:t,cat:t.cat,name:t.name,pid:t.pid,tid:t.tid,ph:t.ph,processingStart:u,processingEnd:l,inputDelay:O.Micro(-1),mainThreadHandling:O.Micro(-1),presentationDelay:O.Micro(-1),args:{data:{beginEvent:t,endEvent:n,frame:m,navigationId:f}},ts:t.ts,dur:O.Micro(n.ts-t.ts),type:t.args.data.type,interactionId:t.args.data.interactionId});oE(h),Rm.push(h)}q1.push(..._4(Rm));for(let t of q1)(!Fm||Fm.dur<t.dur)&&(Fm=t)}function mE(){return{allEvents:iE,beginCommitCompositorFrameEvents:sE,parseMetaViewportEvents:cE,interactionEvents:Rm,interactionEventsWithNoNesting:q1,longestInteractionEvent:Fm,interactionsOverThreshold:new Set(Rm.filter(e=>e.dur>uE))}}function Qle(){return["Meta"]}function ede(e){return e<=Vle?"good":e<=$le?"ok":"bad"}var iE,sE,cE,uE,Vle,$le,Fm,Rm,q1,lE,dE,Jle,Xle,fE=g(()=>{d();ut();Pe();aa();iE=[],sE=[],cE=[],uE=ue.milliToMicro(O.Milli(200)),Vle=uE,$le=ue.milliToMicro(O.Milli(500)),Fm=null,
Rm=[],q1=[],lE=new Map,dE=[];i(Yle,"reset");i(Kle,"handleEvent");Jle=new Set(["pointerdown","touchstart","pointerup","touchend","mousedown","mouseup","click"]),Xle=new Set(["keydown","keypress","keyup"]);i(R4,"categoryOfInteraction");i(_4,"removeNestedInteractions");i(oE,"writeSyntheticTimespans");i(Zle,"finalize");i(mE,"data");i(Qle,"deps");i(ede,"scoreClassificationForInteractionToNextPaint")});var yE={};E(yE,{FORCED_REFLOW_THRESHOLD:()=>O4,LONG_MAIN_THREAD_TASK_THRESHOLD:()=>N4,data:()=>ide,deps:()=>ade,finalize:()=>ode,handleEvent:()=>nde,reset:()=>tde});function tde(){z1.clear(),H1.clear(),hE.length=0,gE.length=0,_m.length=0}function W1(e,t){let n=Me.getWithDefault(z1,e,()=>[]);n.push(t),z1.set(e,n);let r=Me.getWithDefault(H1,t,()=>[]);r.push(e),H1.set(t,r)}function nde(e){if(rde(e),e.name==="RunTask"){let{duration:t}=ue.eventTimingsMicroSeconds(e);t>N4&&W1(e,"LONG_TASK");return}if(C.isFireIdleCallback(e)){let{duration:t}=ue.eventTimingsMilliSeconds(e);t>e.args.data.allottedMilliseconds&&W1(e,"IDLE_CALLBACK_OVER_TIME");return}}function rde(e){if(M4(e,hE),M4(e,gE,C.isJSInvocationEvent(e)),gE.length&&(e.name==="Layout"||e.name==="UpdateLayoutTree")){_m.push(e);return}hE.length===1&&(_m.reduce((n,r)=>n+(r.dur||0),0)>=O4&&_m.forEach(n=>W1(n,"FORCED_REFLOW")),_m.length=0)}function M4(e,t,n=!0){let r=t.at(-1);for(;r&&e.ts>r.ts+(r.dur||0);)t.pop(),r=t.at(-1);n&&t.push(e)}function ade(){
return["UserInteractions"]}async function ode(){let e=mE().interactionsOverThreshold;for(let t of e)W1(t,"LONG_INTERACTION")}function ide(){return{perEvent:z1,perWarning:H1}}var z1,H1,hE,gE,_m,O4,N4,P4=g(()=>{d();dn();ut();Pe();fE();z1=new Map,H1=new Map,hE=[],gE=[],_m=[],O4=ue.milliToMicro(O.Milli(30)),N4=ue.milliToMicro(O.Milli(50));i(tde,"reset");i(W1,"storeWarning");i(nde,"handleEvent");i(rde,"processForcedReflowWarning");i(M4,"accomodateEventInStack");i(ade,"deps");i(ode,"finalize");i(ide,"data")});var wE={};E(wE,{data:()=>lde,finalize:()=>ude,handleEvent:()=>cde,reset:()=>sde});function sde(){G1.length=0,vE.clear(),bE.clear()}function cde(e){C.isTracingSessionIdForWorker(e)&&G1.push(e)}async function ude(){for(let e of G1)e.args.data&&(vE.set(e.args.data.workerThreadId,e.args.data.workerId),bE.set(e.args.data.workerId,e.args.data.url))}function lde(){return{workerSessionIdEvents:G1,workerIdByThread:vE,workerURLById:bE}}var G1,vE,bE,L4=g(()=>{d();Pe();G1=[],vE=new Map,bE=new Map;i(sde,"reset");i(cde,"handleEvent");i(ude,"finalize");i(lde,"data")});var ro={};E(ro,{AnimationFrames:()=>ox,Animations:()=>cx,AsyncJSCalls:()=>Kx,AuctionWorklets:()=>xx,DOMStats:()=>Zx,ExtensionTraceData:()=>lD,Flows:()=>hx,Frames:()=>ED,GPU:()=>CD,ImagePainting:()=>ID,Initiators:()=>MD,Invalidations:()=>PD,LargestImagePaint:()=>zD,LargestTextPaint:()=>WD,LayerTree:()=>yD,LayoutShifts:()=>ZD,Memory:()=>QD,Meta:()=>Ax,NetworkRequests:()=>Mx,PageFrames:()=>eE,PageLoadMetrics:()=>UD,Renderer:()=>Gx,Samples:()=>jx,Screenshots:()=>YD,Scripts:()=>tE,SelectorStats:()=>rE,ServerTimings:()=>aE,UserInteractions:()=>pE,UserTimings:()=>aD,Warnings:()=>yE,Workers:()=>wE});var B4=g(()=>{d();L8();B8();Jx();Jg();t4();i4();Kg();s4();c4();u4();l4();d4();v4();b4();vD();D4();E4();aa();Nu();T4();jD();c1();qx();KD();C4();k4();F4();fE();oD();P4();L4()});var U4={};var j4=g(()=>{d()});var ao={};E(ao,{Helpers:()=>eo,ModelHandlers:()=>ro,Threads:()=>Lu,Types:()=>U4});var ia=g(()=>{d();Ug();B4();wD();j4()});var V1={};E(V1,{getSummariesAndEntitiesWithMapping:()=>hde,summarizeThirdParties:()=>pde});function q4(e,t,n){let r=Gi.default.getEntity(n)??eo.makeUpEntity(e.madeUpEntityCache,n);if(!r)return null;let a=e.urlsByEntity.get(r)??new Set;a.add(n),e.urlsByEntity.set(r,a);let o=e.eventsByEntity.get(r)??[];o.push(t),e.eventsByEntity.set(r,o);let s=e.byEntity.get(r);return s||(s={transferSize:0,mainThreadTime:O.Micro(0)},e.byEntity.set(r,s),s)}function z4(e,t){let n=e.byUrl.get(t);return n||(n={transferSize:0,mainThreadTime:O.Micro(0)},e.byUrl.set(t,n),n)}function dde(e,t,n){for(let r of t.Renderer.processes.values())if(r.isOnMainFrame){for(let a of r.threads.values())if(a.name==="CrRendererMain"){if(!a.tree)break;for(let o of a.entries){if(!ue.eventIsInBounds(o,n))continue;let s=t.Renderer.entryToNode.get(o);if(!s||!s.selfTime)continue;let c=eo.getNonResolvedURL(o,t);if(!c)continue;let u=q4(e,o,c);u&&(u.mainThreadTime=u.mainThreadTime+s.selfTime),u=z4(e,c),u&&(u.mainThreadTime=u.mainThreadTime+
s.selfTime)}}}}function mde(e,t){for(let n of t){let r=n.args.data.url,a=q4(e,n,r);a&&(a.transferSize+=n.args.data.encodedDataLength),a=z4(e,r),a&&(a.transferSize+=n.args.data.encodedDataLength)}}function pde(e,t,n){let r={byEntity:new Map,byUrl:new Map,urlsByEntity:new Map,eventsByEntity:new Map,madeUpEntityCache:new Map};return dde(r,e,t),mde(r,n),r}function fde(e,t,n){let r=new Map,a=new Map,o={transferSize:0,mainThreadTime:O.Micro(0)};for(let s of e){let c=r.get(s)||{...o};C.isSyntheticNetworkRequest(s)&&(c.transferSize+=s.args.data.encodedDataLength),r.set(s,c)}for(let[s,c]of r.entries()){let u=t.get(s);if(!u){r.delete(s);continue}let l=a.get(u)||{...o};l.transferSize+=c.transferSize,a.set(u,l)}return{byEntity:a,eventsByEntity:n,madeUpEntityCache:new Map,byUrl:new Map,urlsByEntity:new Map}}function hde(e,t,n){let r=new Map(n.entityByEvent),a=new Map(n.eventsByEntity),s=Array.from(r.entries()).filter(([h])=>ue.eventIsInBounds(h,t)),c=new Map(s),l=Array.from(a.entries()).filter(([,h])=>(h.
map(y=>ue.eventIsInBounds(y,t)),h.length>0)),m=new Map(l),p=Array.from(r.keys());return{summaries:fde(p,c,m),entityByEvent:c}}var H4=g(()=>{d();Pg();ia();ut();Pe();i(q4,"getOrMakeSummaryByEntity");i(z4,"getOrMakeSummaryByURL");i(dde,"collectMainThreadActivity");i(mde,"collectNetworkActivity");i(pde,"summarizeThirdParties");i(fde,"getSummaryMapWithMapping");i(hde,"getSummariesAndEntitiesWithMapping")});var $1={};E($1,{computeGeneratedFileSizes:()=>W4,computeScriptDuplication:()=>vde,normalizeDuplication:()=>V4,normalizeSource:()=>G4});function W4(e){if(!e.sourceMap)throw new Error("expected source map");let t=e.sourceMap,n=e.content??"",r=n.length,a=n.split(`
`),o={},s=r,c=s,u=yde(e.sourceMap);for(let l of t.mappings()){let m=l.sourceURL,p=l.lineNumber,f=l.columnNumber,h=u.get(l);if(!m)continue;let y=a[p];if(y==null)return{errorMessage:`${t.url()} mapping for line out of bounds: ${p+1}`};if(f>y.length)return{errorMessage:`${t.url()} mapping for column out of bounds: ${p+1}:${f}`};let b=0;if(h!==void 0){if(h>y.length)return{errorMessage:`${t.url()} mapping for last column out of bounds: ${p+1}:${h}`};b=h-f}else b=y.length-f+1;o[m]=(o[m]||0)+b,c-=b}return{files:o,unmappedBytes:c,totalBytes:s}}function G4(e){e=e.replace(/\?$/,"");let t=e.lastIndexOf("node_modules");return t!==-1&&(e=e.substring(t)),e}function gde(e){return!!(e.includes("webpack/bootstrap")||e.includes("(webpack)/buildin")||e.includes("external "))}function V4(e){for(let[t,n]of e){if(n.duplicates.sort((r,a)=>a.attributedSize-r.attributedSize),n.duplicates.length>1){let r=n.duplicates[0].attributedSize;n.duplicates=n.duplicates.filter(a=>a.attributedSize/r>=.1)}if(n.duplicates=n.
duplicates.filter(r=>r.attributedSize>=512),n.duplicates.length<=1){e.delete(t);continue}n.estimatedDuplicateBytes=n.duplicates.slice(1).reduce((r,a)=>r+a.attributedSize,0)}}function yde(e){let t=new Map,n=e.mappings();for(let r=0;r<n.length-1;r++){let a=n[r],o=n[r+1];a.lineNumber===o.lineNumber&&t.set(a,o.columnNumber)}return t}function vde(e){let t=new Map;for(let a of e.scripts)a.content&&a.sourceMap&&t.set(a,W4(a));let n=new Map;for(let[a,o]of t){if(!a.sourceMap)continue;if("errorMessage"in o){console.error(o.errorMessage);continue}let s=[];n.set(a,s);let c=a.sourceMap.sourceURLs();for(let u=0;u<c.length;u++){if(gde(c[u]))continue;let l=o.files[c[u]];s.push({source:G4(c[u]),resourceSize:l})}}let r=new Map;for(let[a,o]of n)for(let s of o){let c=r.get(s.source);c||(c={estimatedDuplicateBytes:0,duplicates:[]},r.set(s.source,c)),c.duplicates.push({script:a,attributedSize:s.resourceSize})}return V4(r),new Map([...r].sort((a,o)=>o[1].estimatedDuplicateBytes-a[1].estimatedDuplicateBytes))}
var $4=g(()=>{d();i(W4,"computeGeneratedFileSizes");i(G4,"normalizeSource");i(gde,"shouldIgnoreSource");i(V4,"normalizeDuplication");i(yde,"computeLastGeneratedColumnMap");i(vde,"computeScriptDuplication")});var Y1={};E(Y1,{clearCacheForTrace:()=>bde,get:()=>xE,stackTraceForEventInTrace:()=>qu});function bde(e){qu.delete(e)}function xE(e,t){let n=qu.get(t);n||(n=new Map,qu.set(t,n));let r=n.get(e);if(r)return r;let a=null;if(C.isProfileCall(e))a=wde(e,t);else if(ka.isSyntheticExtensionEntry(e))a=xde(e,t);else if(C.isUserTiming(e))a=K4(e,t);else if(C.isLayout(e)||C.isUpdateLayoutTree(e)){let s=t.Renderer.entryToNode.get(e)?.parent?.entry;s&&(a=xE(s,t))}return a&&n.set(e,a),a}function wde(e,t){let n=t.Renderer.entryToNode.size>0?t.Renderer.entryToNode:t.Samples.entryToNode,r={callFrames:[]},a=r,o=e,s=n.get(e),c=qu.get(t)||new Map;for(qu.set(t,c);s;){if(!C.isProfileCall(s.entry)){s=s.parent;continue}o=s.entry;let u=c.get(s.entry);if(u){a.callFrames.push(...u.callFrames.filter(p=>!Y4(p))),a.parent=u.parent,a.description=a.description||u.description;break}Y4(o.callFrame)||a.callFrames.push(o.callFrame);let l=t.AsyncJSCalls.asyncCallToScheduler.get(o),m=l&&n.get(l.scheduler);if(m){a.parent={callFrames:[]},
a=a.parent,a.description=l.taskName,s=m;continue}s=s.parent}return r}function xde(e,t){return K4(e.rawSourceEvent,t)}function K4(e,t){let n=e;if(C.isPerformanceMeasureBegin(e)){if(e.args.traceId===void 0)return null;n=t.UserTimings.measureTraceByTraceId.get(e.args.traceId)}if(!n)return null;let r=t.Renderer.entryToNode.get(n);for(;r&&!C.isProfileCall(r.entry);)r=r.parent;return r&&C.isProfileCall(r.entry)?xE(r.entry,t):null}function Y4({columnNumber:e,lineNumber:t,url:n,scriptId:r}){return t===-1&&e===-1&&n===""&&r==="0"}var qu,J4=g(()=>{d();Pe();qu=new Map;i(bde,"clearCacheForTrace");i(xE,"get");i(wde,"getForProfileCall");i(xde,"getForExtensionEntry");i(K4,"getForUserTiming");i(Y4,"isNativeJSFunction")});var Mm=g(()=>{d();H4();$4();J4();(()=>{var e=Object.getOwnPropertyNames,t=i((ae,F)=>i(function(){return F||(0,ae[e(ae)[0]])((F={exports:{}}).exports,F),F.exports},"__require"),"__commonJS"),n=t({"node_modules/object-keys/isArguments.js"(ae,F){"use strict";var A=Object.prototype.toString;F.exports=i(function(M){var z=A.call(M),L=z==="[object Arguments]";return L||(L=z!=="[object Array]"&&M!==null&&typeof M=="object"&&typeof M.length=="number"&&M.length>=0&&A.call(M.callee)==="[object Function]"),L},"isArguments")}}),r=t({"node_modules/object-keys/implementation.js"(ae,F){"use strict";var A;Object.keys||(R=Object.prototype.hasOwnProperty,M=Object.prototype.toString,z=n(),L=Object.prototype.propertyIsEnumerable,G=!L.call({toString:null},"toString"),j=L.call(function(){},"prototype"),U=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],V=i(function(Z){var pe=Z.constructor;return pe&&pe.prototype===Z},"equalsConstructorPrototype"),B=
{$applicationCache:!0,$console:!0,$external:!0,$frame:!0,$frameElement:!0,$frames:!0,$innerHeight:!0,$innerWidth:!0,$onmozfullscreenchange:!0,$onmozfullscreenerror:!0,$outerHeight:!0,$outerWidth:!0,$pageXOffset:!0,$pageYOffset:!0,$parent:!0,$scrollLeft:!0,$scrollTop:!0,$scrollX:!0,$scrollY:!0,$self:!0,$webkitIndexedDB:!0,$webkitStorageInfo:!0,$window:!0},q=function(){if(typeof window>"u")return!1;for(var Z in window)try{if(!B["$"+Z]&&R.call(window,Z)&&window[Z]!==null&&typeof window[Z]=="object")try{V(window[Z])}catch{return!0}}catch{return!0}return!1}(),X=i(function(Z){if(typeof window>"u"||!q)return V(Z);try{return V(Z)}catch{return!1}},"equalsConstructorPrototypeIfNotBuggy"),A=i(function(pe){var Te=pe!==null&&typeof pe=="object",it=M.call(pe)==="[object Function]",Yt=z(pe),bt=Te&&M.call(pe)==="[object String]",Ct=[];if(!Te&&!it&&!Yt)throw new TypeError("Object.keys called on a non-object");var Ze=j&&it;if(bt&&pe.length>0&&!R.call(pe,0))for(var Zt=0;Zt<pe.length;++Zt)Ct.push(String(Zt));
if(Yt&&pe.length>0)for(var Vn=0;Vn<pe.length;++Vn)Ct.push(String(Vn));else for(var Nn in pe)!(Ze&&Nn==="prototype")&&R.call(pe,Nn)&&Ct.push(String(Nn));if(G)for(var Qt=X(pe),sn=0;sn<U.length;++sn)!(Qt&&U[sn]==="constructor")&&R.call(pe,U[sn])&&Ct.push(U[sn]);return Ct},"keys"));var R,M,z,L,G,j,U,V,B,q,X;F.exports=A}}),a=t({"node_modules/object-keys/index.js"(ae,F){"use strict";var A=Array.prototype.slice,R=n(),M=Object.keys,z=M?i(function(j){return M(j)},"keys"):r(),L=Object.keys;z.shim=i(function(){if(Object.keys){var j=function(){var U=Object.keys(arguments);return U&&U.length===arguments.length}(1,2);j||(Object.keys=i(function(V){return R(V)?L(A.call(V)):L(V)},"keys"))}else Object.keys=z;return Object.keys||z},"shimObjectKeys"),F.exports=z}}),o=t({"node_modules/es-define-property/index.js"(ae,F){"use strict";var A=Object.defineProperty||!1;if(A)try{A({},"a",{value:1})}catch{A=!1}F.exports=A}}),s=t({"node_modules/es-errors/syntax.js"(ae,F){"use strict";F.exports=SyntaxError}}),c=t({"\
node_modules/es-errors/type.js"(ae,F){"use strict";F.exports=TypeError}}),u=t({"node_modules/gopd/gOPD.js"(ae,F){"use strict";F.exports=Object.getOwnPropertyDescriptor}}),l=t({"node_modules/gopd/index.js"(ae,F){"use strict";var A=u();if(A)try{A([],"length")}catch{A=null}F.exports=A}}),m=t({"node_modules/define-data-property/index.js"(ae,F){"use strict";var A=o(),R=s(),M=c(),z=l();F.exports=i(function(G,j,U){if(!G||typeof G!="object"&&typeof G!="function")throw new M("`obj` must be an object or a function`");if(typeof j!="string"&&typeof j!="symbol")throw new M("`property` must be a string or a symbol`");if(arguments.length>3&&typeof arguments[3]!="boolean"&&arguments[3]!==null)throw new M("`nonEnumerable`, if provided, must be a boolean or null");if(arguments.length>4&&typeof arguments[4]!="boolean"&&arguments[4]!==null)throw new M("`nonWritable`, if provided, must be a boolean or null");if(arguments.length>5&&typeof arguments[5]!="boolean"&&arguments[5]!==null)throw new M("`nonConfigu\
rable`, if provided, must be a boolean or null");if(arguments.length>6&&typeof arguments[6]!="boolean")throw new M("`loose`, if provided, must be a boolean");var V=arguments.length>3?arguments[3]:null,B=arguments.length>4?arguments[4]:null,q=arguments.length>5?arguments[5]:null,X=arguments.length>6?arguments[6]:!1,Z=!!z&&z(G,j);if(A)A(G,j,{configurable:q===null&&Z?Z.configurable:!q,enumerable:V===null&&Z?Z.enumerable:!V,value:U,writable:B===null&&Z?Z.writable:!B});else if(X||!V&&!B&&!q)G[j]=U;else throw new R("This environment does not support defining a property as non-configurable, non-writable, or non-enumerable.")},"defineDataProperty")}}),p=t({"node_modules/has-property-descriptors/index.js"(ae,F){"use strict";var A=o(),R=i(function(){return!!A},"hasPropertyDescriptors2");R.hasArrayLengthDefineBug=i(function(){if(!A)return null;try{return A([],"length",{value:1}).length!==1}catch{return!0}},"hasArrayLengthDefineBug"),F.exports=R}}),f=t({"node_modules/define-properties/index.js"(ae,F){
"use strict";var A=a(),R=typeof Symbol=="function"&&typeof Symbol("foo")=="symbol",M=Object.prototype.toString,z=Array.prototype.concat,L=m(),G=i(function(B){return typeof B=="function"&&M.call(B)==="[object Function]"},"isFunction"),j=p()(),U=i(function(B,q,X,Z){if(q in B){if(Z===!0){if(B[q]===X)return}else if(!G(Z)||!Z())return}j?L(B,q,X,!0):L(B,q,X)},"defineProperty"),V=i(function(B,q){var X=arguments.length>2?arguments[2]:{},Z=A(q);R&&(Z=z.call(Z,Object.getOwnPropertySymbols(q)));for(var pe=0;pe<Z.length;pe+=1)U(B,Z[pe],q[Z[pe]],X[Z[pe]])},"defineProperties");V.supportsDescriptors=!!j,F.exports=V}}),h=t({"node_modules/es-object-atoms/index.js"(ae,F){"use strict";F.exports=Object}}),y=t({"node_modules/es-errors/index.js"(ae,F){"use strict";F.exports=Error}}),b=t({"node_modules/es-errors/eval.js"(ae,F){"use strict";F.exports=EvalError}}),w=t({"node_modules/es-errors/range.js"(ae,F){"use strict";F.exports=RangeError}}),D=t({"node_modules/es-errors/ref.js"(ae,F){"use strict";F.exports=
ReferenceError}}),T=t({"node_modules/es-errors/uri.js"(ae,F){"use strict";F.exports=URIError}}),S=t({"node_modules/math-intrinsics/abs.js"(ae,F){"use strict";F.exports=Math.abs}}),k=t({"node_modules/math-intrinsics/floor.js"(ae,F){"use strict";F.exports=Math.floor}}),_=t({"node_modules/math-intrinsics/max.js"(ae,F){"use strict";F.exports=Math.max}}),Y=t({"node_modules/math-intrinsics/min.js"(ae,F){"use strict";F.exports=Math.min}}),W=t({"node_modules/math-intrinsics/pow.js"(ae,F){"use strict";F.exports=Math.pow}}),oe=t({"node_modules/math-intrinsics/round.js"(ae,F){"use strict";F.exports=Math.round}}),me=t({"node_modules/math-intrinsics/isNaN.js"(ae,F){"use strict";F.exports=Number.isNaN||i(function(R){return R!==R},"isNaN2")}}),De=t({"node_modules/math-intrinsics/sign.js"(ae,F){"use strict";var A=me();F.exports=i(function(M){return A(M)||M===0?M:M<0?-1:1},"sign")}}),Oe=t({"node_modules/has-symbols/shams.js"(ae,F){"use strict";F.exports=i(function(){if(typeof Symbol!="function"||typeof Object.
getOwnPropertySymbols!="function")return!1;if(typeof Symbol.iterator=="symbol")return!0;var R={},M=Symbol("test"),z=Object(M);if(typeof M=="string"||Object.prototype.toString.call(M)!=="[object Symbol]"||Object.prototype.toString.call(z)!=="[object Symbol]")return!1;var L=42;R[M]=L;for(var G in R)return!1;if(typeof Object.keys=="function"&&Object.keys(R).length!==0||typeof Object.getOwnPropertyNames=="function"&&Object.getOwnPropertyNames(R).length!==0)return!1;var j=Object.getOwnPropertySymbols(R);if(j.length!==1||j[0]!==M||!Object.prototype.propertyIsEnumerable.call(R,M))return!1;if(typeof Object.getOwnPropertyDescriptor=="function"){var U=Object.getOwnPropertyDescriptor(R,M);if(U.value!==L||U.enumerable!==!0)return!1}return!0},"hasSymbols")}}),we=t({"node_modules/has-symbols/index.js"(ae,F){"use strict";var A=typeof Symbol<"u"&&Symbol,R=Oe();F.exports=i(function(){return typeof A!="function"||typeof Symbol!="function"||typeof A("foo")!="symbol"||typeof Symbol("bar")!="symbol"?!1:R()},
"hasNativeSymbols")}}),ve=t({"node_modules/get-proto/Reflect.getPrototypeOf.js"(ae,F){"use strict";F.exports=typeof Reflect<"u"&&Reflect.getPrototypeOf||null}}),Dt=t({"node_modules/get-proto/Object.getPrototypeOf.js"(ae,F){"use strict";var A=h();F.exports=A.getPrototypeOf||null}}),Fe=t({"node_modules/call-bind-apply-helpers/node_modules/function-bind/implementation.js"(ae,F){"use strict";var A="Function.prototype.bind called on incompatible ",R=Object.prototype.toString,M=Math.max,z="[object Function]",L=i(function(V,B){for(var q=[],X=0;X<V.length;X+=1)q[X]=V[X];for(var Z=0;Z<B.length;Z+=1)q[Z+V.length]=B[Z];return q},"concatty2"),G=i(function(V,B){for(var q=[],X=B||0,Z=0;X<V.length;X+=1,Z+=1)q[Z]=V[X];return q},"slicy2"),j=i(function(U,V){for(var B="",q=0;q<U.length;q+=1)B+=U[q],q+1<U.length&&(B+=V);return B},"joiny");F.exports=i(function(V){var B=this;if(typeof B!="function"||R.apply(B)!==z)throw new TypeError(A+B);for(var q=G(arguments,1),X,Z=i(function(){if(this instanceof X){var bt=B.
apply(this,L(q,arguments));return Object(bt)===bt?bt:this}return B.apply(V,L(q,arguments))},"binder"),pe=M(0,B.length-q.length),Te=[],it=0;it<pe;it++)Te[it]="$"+it;if(X=Function("binder","return function ("+j(Te,",")+"){ return binder.apply(this,arguments); }")(Z),B.prototype){var Yt=i(function(){},"Empty2");Yt.prototype=B.prototype,X.prototype=new Yt,Yt.prototype=null}return X},"bind")}}),ze=t({"node_modules/call-bind-apply-helpers/node_modules/function-bind/index.js"(ae,F){"use strict";var A=Fe();F.exports=Function.prototype.bind||A}}),_t=t({"node_modules/call-bind-apply-helpers/functionCall.js"(ae,F){"use strict";F.exports=Function.prototype.call}}),yt=t({"node_modules/call-bind-apply-helpers/functionApply.js"(ae,F){"use strict";F.exports=Function.prototype.apply}}),tt=t({"node_modules/call-bind-apply-helpers/reflectApply.js"(ae,F){"use strict";F.exports=typeof Reflect<"u"&&Reflect&&Reflect.apply}}),$t=t({"node_modules/call-bind-apply-helpers/actualApply.js"(ae,F){"use strict";var A=ze(),
R=yt(),M=_t(),z=tt();F.exports=z||A.call(M,R)}}),pt=t({"node_modules/call-bind-apply-helpers/index.js"(ae,F){"use strict";var A=ze(),R=c(),M=_t(),z=$t();F.exports=i(function(G){if(G.length<1||typeof G[0]!="function")throw new R("a function is required");return z(A,M,G)},"callBindBasic")}}),ft=t({"node_modules/dunder-proto/get.js"(ae,F){"use strict";var A=pt(),R=l(),M;try{M=[].__proto__===Array.prototype}catch(j){if(!j||typeof j!="object"||!("code"in j)||j.code!=="ERR_PROTO_ACCESS")throw j}var z=!!M&&R&&R(Object.prototype,"__proto__"),L=Object,G=L.getPrototypeOf;F.exports=z&&typeof z.get=="function"?A([z.get]):typeof G=="function"?i(function(U){return G(U==null?U:L(U))},"getDunder"):!1}}),Xe=t({"node_modules/get-proto/index.js"(ae,F){"use strict";var A=ve(),R=Dt(),M=ft();F.exports=A?i(function(L){return A(L)},"getProto"):R?i(function(L){if(!L||typeof L!="object"&&typeof L!="function")throw new TypeError("getProto: not an object");return R(L)},"getProto"):M?i(function(L){return M(L)},"ge\
tProto"):null}}),J=t({"node_modules/get-intrinsic/node_modules/function-bind/implementation.js"(ae,F){"use strict";var A="Function.prototype.bind called on incompatible ",R=Object.prototype.toString,M=Math.max,z="[object Function]",L=i(function(V,B){for(var q=[],X=0;X<V.length;X+=1)q[X]=V[X];for(var Z=0;Z<B.length;Z+=1)q[Z+V.length]=B[Z];return q},"concatty2"),G=i(function(V,B){for(var q=[],X=B||0,Z=0;X<V.length;X+=1,Z+=1)q[Z]=V[X];return q},"slicy2"),j=i(function(U,V){for(var B="",q=0;q<U.length;q+=1)B+=U[q],q+1<U.length&&(B+=V);return B},"joiny");F.exports=i(function(V){var B=this;if(typeof B!="function"||R.apply(B)!==z)throw new TypeError(A+B);for(var q=G(arguments,1),X,Z=i(function(){if(this instanceof X){var bt=B.apply(this,L(q,arguments));return Object(bt)===bt?bt:this}return B.apply(V,L(q,arguments))},"binder"),pe=M(0,B.length-q.length),Te=[],it=0;it<pe;it++)Te[it]="$"+it;if(X=Function("binder","return function ("+j(Te,",")+"){ return binder.apply(this,arguments); }")(Z),B.prototype){
var Yt=i(function(){},"Empty2");Yt.prototype=B.prototype,X.prototype=new Yt,Yt.prototype=null}return X},"bind")}}),Ie=t({"node_modules/get-intrinsic/node_modules/function-bind/index.js"(ae,F){"use strict";var A=J();F.exports=Function.prototype.bind||A}}),Ft=t({"node_modules/hasown/node_modules/function-bind/implementation.js"(ae,F){"use strict";var A="Function.prototype.bind called on incompatible ",R=Object.prototype.toString,M=Math.max,z="[object Function]",L=i(function(V,B){for(var q=[],X=0;X<V.length;X+=1)q[X]=V[X];for(var Z=0;Z<B.length;Z+=1)q[Z+V.length]=B[Z];return q},"concatty2"),G=i(function(V,B){for(var q=[],X=B||0,Z=0;X<V.length;X+=1,Z+=1)q[Z]=V[X];return q},"slicy2"),j=i(function(U,V){for(var B="",q=0;q<U.length;q+=1)B+=U[q],q+1<U.length&&(B+=V);return B},"joiny");F.exports=i(function(V){var B=this;if(typeof B!="function"||R.apply(B)!==z)throw new TypeError(A+B);for(var q=G(arguments,1),X,Z=i(function(){if(this instanceof X){var bt=B.apply(this,L(q,arguments));return Object(
bt)===bt?bt:this}return B.apply(V,L(q,arguments))},"binder"),pe=M(0,B.length-q.length),Te=[],it=0;it<pe;it++)Te[it]="$"+it;if(X=Function("binder","return function ("+j(Te,",")+"){ return binder.apply(this,arguments); }")(Z),B.prototype){var Yt=i(function(){},"Empty2");Yt.prototype=B.prototype,X.prototype=new Yt,Yt.prototype=null}return X},"bind")}}),at=t({"node_modules/hasown/node_modules/function-bind/index.js"(ae,F){"use strict";var A=Ft();F.exports=Function.prototype.bind||A}}),Ge=t({"node_modules/hasown/index.js"(ae,F){"use strict";var A=Function.prototype.call,R=Object.prototype.hasOwnProperty,M=at();F.exports=M.call(A,R)}}),Be=t({"node_modules/get-intrinsic/index.js"(ae,F){"use strict";var A,R=h(),M=y(),z=b(),L=w(),G=D(),j=s(),U=c(),V=T(),B=S(),q=k(),X=_(),Z=Y(),pe=W(),Te=oe(),it=De(),Yt=Function,bt=i(function(Hr){try{return Yt('"use strict"; return ('+Hr+").constructor;")()}catch{}},"getEvalledConstructor"),Ct=l(),Ze=o(),Zt=i(function(){throw new U},"throwTypeError"),Vn=Ct?function(){
try{return arguments.callee,Zt}catch{try{return Ct(arguments,"callee").get}catch{return Zt}}}():Zt,Nn=we()(),Qt=Xe(),sn=Dt(),ad=ve(),gi=yt(),zr=_t(),za={},od=typeof Uint8Array>"u"||!Qt?A:Qt(Uint8Array),kr={__proto__:null,"%AggregateError%":typeof AggregateError>"u"?A:AggregateError,"%Array%":Array,"%ArrayBuffer%":typeof ArrayBuffer>"u"?A:ArrayBuffer,"%ArrayIteratorPrototype%":Nn&&Qt?Qt([][Symbol.iterator]()):A,"%AsyncFromSyncIteratorPrototype%":A,"%AsyncFunction%":za,"%AsyncGenerator%":za,"%AsyncGeneratorFunction%":za,"%AsyncIteratorPrototype%":za,"%Atomics%":typeof Atomics>"u"?A:Atomics,"%BigInt%":typeof BigInt>"u"?A:BigInt,"%BigInt64Array%":typeof BigInt64Array>"u"?A:BigInt64Array,"%BigUint64Array%":typeof BigUint64Array>"u"?A:BigUint64Array,"%Boolean%":Boolean,"%DataView%":typeof DataView>"u"?A:DataView,"%Date%":Date,"%decodeURI%":decodeURI,"%decodeURIComponent%":decodeURIComponent,"%encodeURI%":encodeURI,"%encodeURIComponent%":encodeURIComponent,"%Error%":M,"%eval%":eval,"%EvalErro\
r%":z,"%Float16Array%":typeof Float16Array>"u"?A:Float16Array,"%Float32Array%":typeof Float32Array>"u"?A:Float32Array,"%Float64Array%":typeof Float64Array>"u"?A:Float64Array,"%FinalizationRegistry%":typeof FinalizationRegistry>"u"?A:FinalizationRegistry,"%Function%":Yt,"%GeneratorFunction%":za,"%Int8Array%":typeof Int8Array>"u"?A:Int8Array,"%Int16Array%":typeof Int16Array>"u"?A:Int16Array,"%Int32Array%":typeof Int32Array>"u"?A:Int32Array,"%isFinite%":isFinite,"%isNaN%":isNaN,"%IteratorPrototype%":Nn&&Qt?Qt(Qt([][Symbol.iterator]())):A,"%JSON%":typeof JSON=="object"?JSON:A,"%Map%":typeof Map>"u"?A:Map,"%MapIteratorPrototype%":typeof Map>"u"||!Nn||!Qt?A:Qt(new Map()[Symbol.iterator]()),"%Math%":Math,"%Number%":Number,"%Object%":R,"%Object.getOwnPropertyDescriptor%":Ct,"%parseFloat%":parseFloat,"%parseInt%":parseInt,"%Promise%":typeof Promise>"u"?A:Promise,"%Proxy%":typeof Proxy>"u"?A:Proxy,"%RangeError%":L,"%ReferenceError%":G,"%Reflect%":typeof Reflect>"u"?A:Reflect,"%RegExp%":RegExp,"%\
Set%":typeof Set>"u"?A:Set,"%SetIteratorPrototype%":typeof Set>"u"||!Nn||!Qt?A:Qt(new Set()[Symbol.iterator]()),"%SharedArrayBuffer%":typeof SharedArrayBuffer>"u"?A:SharedArrayBuffer,"%String%":String,"%StringIteratorPrototype%":Nn&&Qt?Qt(""[Symbol.iterator]()):A,"%Symbol%":Nn?Symbol:A,"%SyntaxError%":j,"%ThrowTypeError%":Vn,"%TypedArray%":od,"%TypeError%":U,"%Uint8Array%":typeof Uint8Array>"u"?A:Uint8Array,"%Uint8ClampedArray%":typeof Uint8ClampedArray>"u"?A:Uint8ClampedArray,"%Uint16Array%":typeof Uint16Array>"u"?A:Uint16Array,"%Uint32Array%":typeof Uint32Array>"u"?A:Uint32Array,"%URIError%":V,"%WeakMap%":typeof WeakMap>"u"?A:WeakMap,"%WeakRef%":typeof WeakRef>"u"?A:WeakRef,"%WeakSet%":typeof WeakSet>"u"?A:WeakSet,"%Function.prototype.call%":zr,"%Function.prototype.apply%":gi,"%Object.defineProperty%":Ze,"%Object.getPrototypeOf%":sn,"%Math.abs%":B,"%Math.floor%":q,"%Math.max%":X,"%Math.min%":Z,"%Math.pow%":pe,"%Math.round%":Te,"%Math.sign%":it,"%Reflect.getPrototypeOf%":ad};if(Qt)try{
null.error}catch(Hr){yi=Qt(Qt(Hr)),kr["%Error.prototype%"]=yi}var yi,mh=i(function Hr(cn){var Pn;if(cn==="%AsyncFunction%")Pn=bt("async function () {}");else if(cn==="%GeneratorFunction%")Pn=bt("function* () {}");else if(cn==="%AsyncGeneratorFunction%")Pn=bt("async function* () {}");else if(cn==="%AsyncGenerator%"){var vn=Hr("%AsyncGeneratorFunction%");vn&&(Pn=vn.prototype)}else if(cn==="%AsyncIteratorPrototype%"){var $n=Hr("%AsyncGenerator%");$n&&Qt&&(Pn=Qt($n.prototype))}return kr[cn]=Pn,Pn},"doEval2"),id={__proto__:null,"%ArrayBufferPrototype%":["ArrayBuffer","prototype"],"%ArrayPrototype%":["Array","prototype"],"%ArrayProto_entries%":["Array","prototype","entries"],"%ArrayProto_forEach%":["Array","prototype","forEach"],"%ArrayProto_keys%":["Array","prototype","keys"],"%ArrayProto_values%":["Array","prototype","values"],"%AsyncFunctionPrototype%":["AsyncFunction","prototype"],"%AsyncGenerator%":["AsyncGeneratorFunction","prototype"],"%AsyncGeneratorPrototype%":["AsyncGeneratorFuncti\
on","prototype","prototype"],"%BooleanPrototype%":["Boolean","prototype"],"%DataViewPrototype%":["DataView","prototype"],"%DatePrototype%":["Date","prototype"],"%ErrorPrototype%":["Error","prototype"],"%EvalErrorPrototype%":["EvalError","prototype"],"%Float32ArrayPrototype%":["Float32Array","prototype"],"%Float64ArrayPrototype%":["Float64Array","prototype"],"%FunctionPrototype%":["Function","prototype"],"%Generator%":["GeneratorFunction","prototype"],"%GeneratorPrototype%":["GeneratorFunction","prototype","prototype"],"%Int8ArrayPrototype%":["Int8Array","prototype"],"%Int16ArrayPrototype%":["Int16Array","prototype"],"%Int32ArrayPrototype%":["Int32Array","prototype"],"%JSONParse%":["JSON","parse"],"%JSONStringify%":["JSON","stringify"],"%MapPrototype%":["Map","prototype"],"%NumberPrototype%":["Number","prototype"],"%ObjectPrototype%":["Object","prototype"],"%ObjProto_toString%":["Object","prototype","toString"],"%ObjProto_valueOf%":["Object","prototype","valueOf"],"%PromisePrototype%":[
"Promise","prototype"],"%PromiseProto_then%":["Promise","prototype","then"],"%Promise_all%":["Promise","all"],"%Promise_reject%":["Promise","reject"],"%Promise_resolve%":["Promise","resolve"],"%RangeErrorPrototype%":["RangeError","prototype"],"%ReferenceErrorPrototype%":["ReferenceError","prototype"],"%RegExpPrototype%":["RegExp","prototype"],"%SetPrototype%":["Set","prototype"],"%SharedArrayBufferPrototype%":["SharedArrayBuffer","prototype"],"%StringPrototype%":["String","prototype"],"%SymbolPrototype%":["Symbol","prototype"],"%SyntaxErrorPrototype%":["SyntaxError","prototype"],"%TypedArrayPrototype%":["TypedArray","prototype"],"%TypeErrorPrototype%":["TypeError","prototype"],"%Uint8ArrayPrototype%":["Uint8Array","prototype"],"%Uint8ClampedArrayPrototype%":["Uint8ClampedArray","prototype"],"%Uint16ArrayPrototype%":["Uint16Array","prototype"],"%Uint32ArrayPrototype%":["Uint32Array","prototype"],"%URIErrorPrototype%":["URIError","prototype"],"%WeakMapPrototype%":["WeakMap","prototype"],
"%WeakSetPrototype%":["WeakSet","prototype"]},vi=Ie(),bi=Ge(),ph=vi.call(zr,Array.prototype.concat),fh=vi.call(gi,Array.prototype.splice),sd=vi.call(zr,String.prototype.replace),$c=vi.call(zr,String.prototype.slice),hh=vi.call(zr,RegExp.prototype.exec),Yv=/[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g,Eo=/\\(\\)?/g,cd=i(function(cn){var Pn=$c(cn,0,1),vn=$c(cn,-1);if(Pn==="%"&&vn!=="%")throw new j("invalid intrinsic syntax, expected closing `%`");if(vn==="%"&&Pn!=="%")throw new j("invalid intrinsic syntax, expected opening `%`");var $n=[];return sd(cn,Yv,function(Wr,wi,er,Ir){$n[$n.length]=er?sd(Ir,Eo,"$1"):wi||Wr}),$n},"stringToPath2"),Kv=i(function(cn,Pn){var vn=cn,$n;if(bi(id,vn)&&($n=id[vn],vn="%"+$n[0]+"%"),bi(kr,vn)){var Wr=kr[vn];if(Wr===za&&(Wr=mh(vn)),typeof Wr>"u"&&!Pn)throw new U("intrinsic "+cn+" exists, but is not available. Please file an issue!");return{alias:$n,name:vn,value:Wr}}throw new j("intrinsic "+cn+" does not \
exist!")},"getBaseIntrinsic2");F.exports=i(function(cn,Pn){if(typeof cn!="string"||cn.length===0)throw new U("intrinsic name must be a non-empty string");if(arguments.length>1&&typeof Pn!="boolean")throw new U('"allowMissing" argument must be a boolean');if(hh(/^%?[^%]*%?$/,cn)===null)throw new j("`%` may not be present anywhere but at the beginning and end of the intrinsic name");var vn=cd(cn),$n=vn.length>0?vn[0]:"",Wr=Kv("%"+$n+"%",Pn),wi=Wr.name,er=Wr.value,Ir=!1,Zr=Wr.alias;Zr&&($n=Zr[0],fh(vn,ph([0,1],Zr)));for(var Yc=1,xi=!0;Yc<vn.length;Yc+=1){var Ea=vn[Yc],Kc=$c(Ea,0,1),Jc=$c(Ea,-1);if((Kc==='"'||Kc==="'"||Kc==="`"||Jc==='"'||Jc==="'"||Jc==="`")&&Kc!==Jc)throw new j("property names with quotes must have matching quotes");if((Ea==="constructor"||!xi)&&(Ir=!0),$n+="."+Ea,wi="%"+$n+"%",bi(kr,wi))er=kr[wi];else if(er!=null){if(!(Ea in er)){if(!Pn)throw new U("base intrinsic for "+cn+" exists, but the property is not available.");return}if(Ct&&Yc+1>=vn.length){var Xc=Ct(er,Ea);xi=!!Xc,
xi&&"get"in Xc&&!("originalValue"in Xc.get)?er=Xc.get:er=er[Ea]}else xi=bi(er,Ea),er=er[Ea];xi&&!Ir&&(kr[wi]=er)}}return er},"GetIntrinsic")}}),Ue=t({"node_modules/call-bound/index.js"(ae,F){"use strict";var A=Be(),R=pt(),M=R([A("%String.prototype.indexOf%")]);F.exports=i(function(L,G){var j=A(L,!!G);return typeof j=="function"&&M(L,".prototype.")>-1?R([j]):j},"callBoundIntrinsic")}}),be=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/helpers/IsArray.js"(ae,F){"use strict";var A=Be(),R=A("%Array%"),M=!R.isArray&&Ue()("Object.prototype.toString");F.exports=R.isArray||i(function(L){return M(L)==="[object Array]"},"IsArray")}}),de=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/IsArray.js"(ae,F){"use strict";F.exports=be()}}),Mt=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/Call.js"(ae,F){"use strict";var A=Be(),R=Ue(),M=c(),z=de(),L=A("%Reflect.apply%",!0)||R("Function.prototype.apply");F.exports=i(function(j,U){var V=arguments.length>
2?arguments[2]:[];if(!z(V))throw new M("Assertion failed: optional `argumentsList`, if provided, must be a List");return L(j,U,V)},"Call")}}),Ve=t({"(disabled):node_modules/object-inspect/util.inspect"(){}}),$e=t({"node_modules/object-inspect/index.js"(ae,F){var A=typeof Map=="function"&&Map.prototype,R=Object.getOwnPropertyDescriptor&&A?Object.getOwnPropertyDescriptor(Map.prototype,"size"):null,M=A&&R&&typeof R.get=="function"?R.get:null,z=A&&Map.prototype.forEach,L=typeof Set=="function"&&Set.prototype,G=Object.getOwnPropertyDescriptor&&L?Object.getOwnPropertyDescriptor(Set.prototype,"size"):null,j=L&&G&&typeof G.get=="function"?G.get:null,U=L&&Set.prototype.forEach,V=typeof WeakMap=="function"&&WeakMap.prototype,B=V?WeakMap.prototype.has:null,q=typeof WeakSet=="function"&&WeakSet.prototype,X=q?WeakSet.prototype.has:null,Z=typeof WeakRef=="function"&&WeakRef.prototype,pe=Z?WeakRef.prototype.deref:null,Te=Boolean.prototype.valueOf,it=Object.prototype.toString,Yt=Function.prototype.toString,
bt=String.prototype.match,Ct=String.prototype.slice,Ze=String.prototype.replace,Zt=String.prototype.toUpperCase,Vn=String.prototype.toLowerCase,Nn=RegExp.prototype.test,Qt=Array.prototype.concat,sn=Array.prototype.join,ad=Array.prototype.slice,gi=Math.floor,zr=typeof BigInt=="function"?BigInt.prototype.valueOf:null,za=Object.getOwnPropertySymbols,od=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?Symbol.prototype.toString:null,kr=typeof Symbol=="function"&&typeof Symbol.iterator=="object",yi=typeof Symbol=="function"&&Symbol.toStringTag&&(typeof Symbol.toStringTag===kr||!0)?Symbol.toStringTag:null,mh=Object.prototype.propertyIsEnumerable,id=(typeof Reflect=="function"?Reflect.getPrototypeOf:Object.getPrototypeOf)||([].__proto__===Array.prototype?function($){return $.__proto__}:null);function vi($,K){if($===1/0||$===-1/0||$!==$||$&&$>-1e3&&$<1e3||Nn.call(/e/,K))return K;var qt=/[0-9](?=(?:[0-9]{3})+(?![0-9]))/g;if(typeof $=="number"){var en=$<0?-gi(-$):gi($);if(en!==$){var rn=String(
en),gt=Ct.call(K,rn.length+1);return Ze.call(rn,qt,"$&_")+"."+Ze.call(Ze.call(gt,/([0-9]{3})/g,"$&_"),/_$/,"")}}return Ze.call(K,qt,"$&_")}i(vi,"addNumericSeparator");var bi=Ve(),ph=bi.custom,fh=Wr(ph)?ph:null,sd={__proto__:null,double:'"',single:"'"},$c={__proto__:null,double:/(["\\])/g,single:/(['\\])/g};F.exports=i(function $(K,qt,en,rn){var gt=qt||{};if(Ir(gt,"quoteStyle")&&!Ir(sd,gt.quoteStyle))throw new TypeError('option "quoteStyle" must be "single" or "double"');if(Ir(gt,"maxStringLength")&&(typeof gt.maxStringLength=="number"?gt.maxStringLength<0&&gt.maxStringLength!==1/0:gt.maxStringLength!==null))throw new TypeError('option "maxStringLength", if provided, must be a positive integer, Infinity, or `null`');var Di=Ir(gt,"customInspect")?gt.customInspect:!0;if(typeof Di!="boolean"&&Di!=="symbol")throw new TypeError("option \"customInspect\", if provided, must be `true`, `false`, or `'symbol'`");if(Ir(gt,"indent")&&gt.indent!==null&&gt.indent!=="	"&&!(parseInt(gt.indent,10)===gt.
indent&&gt.indent>0))throw new TypeError('option "indent" must be "\\t", an integer > 0, or `null`');if(Ir(gt,"numericSeparator")&&typeof gt.numericSeparator!="boolean")throw new TypeError('option "numericSeparator", if provided, must be `true` or `false`');var Us=gt.numericSeparator;if(typeof K>"u")return"undefined";if(K===null)return"null";if(typeof K=="boolean")return K?"true":"false";if(typeof K=="string")return v_(K,gt);if(typeof K=="number"){if(K===0)return 1/0/K>0?"0":"-0";var Gr=String(K);return Us?vi(K,Gr):Gr}if(typeof K=="bigint"){var Ei=String(K)+"n";return Us?vi(K,Ei):Ei}var Zv=typeof gt.depth>"u"?5:gt.depth;if(typeof en>"u"&&(en=0),en>=Zv&&Zv>0&&typeof K=="object")return cd(K)?"[Array]":"[Object]";var Zc=fY(gt,en);if(typeof rn>"u")rn=[];else if(xi(rn,K)>=0)return"[Circular]";function Ta(Qc,vh,gY){if(vh&&(rn=ad.call(rn),rn.push(vh)),gY){var k_={depth:gt.depth};return Ir(gt,"quoteStyle")&&(k_.quoteStyle=gt.quoteStyle),$(Qc,k_,en+1,rn)}return $(Qc,gt,en+1,rn)}if(i(Ta,"inspect"),
typeof K=="function"&&!Hr(K)){var w_=Yc(K),x_=gh(K,Ta);return"[Function"+(w_?": "+w_:" (anonymous)")+"]"+(x_.length>0?" { "+sn.call(x_,", ")+" }":"")}if(Wr(K)){var D_=kr?Ze.call(String(K),/^(Symbol\(.*\))_[^)]*$/,"$1"):od.call(K);return typeof K=="object"&&!kr?ud(D_):D_}if(dY(K)){for(var ld="<"+Vn.call(String(K.nodeName)),Qv=K.attributes||[],yh=0;yh<Qv.length;yh++)ld+=" "+Qv[yh].name+"="+hh(Yv(Qv[yh].value),"double",gt);return ld+=">",K.childNodes&&K.childNodes.length&&(ld+="..."),ld+="</"+Vn.call(String(K.nodeName))+">",ld}if(cd(K)){if(K.length===0)return"[]";var eb=gh(K,Ta);return Zc&&!pY(eb)?"["+Xv(eb,Zc)+"]":"[ "+sn.call(eb,", ")+" ]"}if(cn(K)){var tb=gh(K,Ta);return!("cause"in Error.prototype)&&"cause"in K&&!mh.call(K,"cause")?"{ ["+String(K)+"] "+sn.call(Qt.call("[cause]: "+Ta(K.cause),tb),", ")+" }":tb.length===0?"["+String(K)+"]":"{ ["+String(K)+"] "+sn.call(tb,", ")+" }"}if(typeof K=="object"&&Di){if(fh&&typeof K[fh]=="function"&&bi)return bi(K,{depth:Zv-en});if(Di!=="symbol"&&
typeof K.inspect=="function")return K.inspect()}if(Ea(K)){var E_=[];return z&&z.call(K,function(Qc,vh){E_.push(Ta(vh,K,!0)+" => "+Ta(Qc,K))}),b_("Map",M.call(K),E_,Zc)}if(Xc(K)){var T_=[];return U&&U.call(K,function(Qc){T_.push(Ta(Qc,K))}),b_("Set",j.call(K),T_,Zc)}if(Kc(K))return Jv("WeakMap");if(lY(K))return Jv("WeakSet");if(Jc(K))return Jv("WeakRef");if(vn(K))return ud(Ta(Number(K)));if(wi(K))return ud(Ta(zr.call(K)));if($n(K))return ud(Te.call(K));if(Pn(K))return ud(Ta(String(K)));if(typeof window<"u"&&K===window)return"{ [object Window] }";if(typeof globalThis<"u"&&K===globalThis||typeof globalThis<"u"&&K===globalThis)return"{ [object globalThis] }";if(!Kv(K)&&!Hr(K)){var nb=gh(K,Ta),S_=id?id(K)===Object.prototype:K instanceof Object||K.constructor===Object,rb=K instanceof Object?"":"null prototype",C_=!S_&&yi&&Object(K)===K&&yi in K?Ct.call(Zr(K),8,-1):rb?"Object":"",hY=S_||typeof K.constructor!="function"?"":K.constructor.name?K.constructor.name+" ":"",ab=hY+(C_||rb?"["+sn.call(
Qt.call([],C_||[],rb||[]),": ")+"] ":"");return nb.length===0?ab+"{}":Zc?ab+"{"+Xv(nb,Zc)+"}":ab+"{ "+sn.call(nb,", ")+" }"}return String(K)},"inspect_");function hh($,K,qt){var en=qt.quoteStyle||K,rn=sd[en];return rn+$+rn}i(hh,"wrapQuotes");function Yv($){return Ze.call(String($),/"/g,"&quot;")}i(Yv,"quote");function Eo($){return!yi||!(typeof $=="object"&&(yi in $||typeof $[yi]<"u"))}i(Eo,"canTrustToString");function cd($){return Zr($)==="[object Array]"&&Eo($)}i(cd,"isArray");function Kv($){return Zr($)==="[object Date]"&&Eo($)}i(Kv,"isDate");function Hr($){return Zr($)==="[object RegExp]"&&Eo($)}i(Hr,"isRegExp");function cn($){return Zr($)==="[object Error]"&&Eo($)}i(cn,"isError");function Pn($){return Zr($)==="[object String]"&&Eo($)}i(Pn,"isString");function vn($){return Zr($)==="[object Number]"&&Eo($)}i(vn,"isNumber");function $n($){return Zr($)==="[object Boolean]"&&Eo($)}i($n,"isBoolean");function Wr($){if(kr)return $&&typeof $=="object"&&$ instanceof Symbol;if(typeof $=="symb\
ol")return!0;if(!$||typeof $!="object"||!od)return!1;try{return od.call($),!0}catch{}return!1}i(Wr,"isSymbol");function wi($){if(!$||typeof $!="object"||!zr)return!1;try{return zr.call($),!0}catch{}return!1}i(wi,"isBigInt");var er=Object.prototype.hasOwnProperty||function($){return $ in this};function Ir($,K){return er.call($,K)}i(Ir,"has");function Zr($){return it.call($)}i(Zr,"toStr");function Yc($){if($.name)return $.name;var K=bt.call(Yt.call($),/^function\s*([\w$]+)/);return K?K[1]:null}i(Yc,"nameOf");function xi($,K){if($.indexOf)return $.indexOf(K);for(var qt=0,en=$.length;qt<en;qt++)if($[qt]===K)return qt;return-1}i(xi,"indexOf");function Ea($){if(!M||!$||typeof $!="object")return!1;try{M.call($);try{j.call($)}catch{return!0}return $ instanceof Map}catch{}return!1}i(Ea,"isMap");function Kc($){if(!B||!$||typeof $!="object")return!1;try{B.call($,B);try{X.call($,X)}catch{return!0}return $ instanceof WeakMap}catch{}return!1}i(Kc,"isWeakMap");function Jc($){if(!pe||!$||typeof $!="ob\
ject")return!1;try{return pe.call($),!0}catch{}return!1}i(Jc,"isWeakRef");function Xc($){if(!j||!$||typeof $!="object")return!1;try{j.call($);try{M.call($)}catch{return!0}return $ instanceof Set}catch{}return!1}i(Xc,"isSet");function lY($){if(!X||!$||typeof $!="object")return!1;try{X.call($,X);try{B.call($,B)}catch{return!0}return $ instanceof WeakSet}catch{}return!1}i(lY,"isWeakSet");function dY($){return!$||typeof $!="object"?!1:typeof HTMLElement<"u"&&$ instanceof HTMLElement?!0:typeof $.nodeName=="string"&&typeof $.getAttribute=="function"}i(dY,"isElement");function v_($,K){if($.length>K.maxStringLength){var qt=$.length-K.maxStringLength,en="... "+qt+" more character"+(qt>1?"s":"");return v_(Ct.call($,0,K.maxStringLength),K)+en}var rn=$c[K.quoteStyle||"single"];rn.lastIndex=0;var gt=Ze.call(Ze.call($,rn,"\\$1"),/[\x00-\x1f]/g,mY);return hh(gt,"single",K)}i(v_,"inspectString");function mY($){var K=$.charCodeAt(0),qt={8:"b",9:"t",10:"n",12:"f",13:"r"}[K];return qt?"\\"+qt:"\\x"+(K<16?
"0":"")+Zt.call(K.toString(16))}i(mY,"lowbyte");function ud($){return"Object("+$+")"}i(ud,"markBoxed");function Jv($){return $+" { ? }"}i(Jv,"weakCollectionOf");function b_($,K,qt,en){var rn=en?Xv(qt,en):sn.call(qt,", ");return $+" ("+K+") {"+rn+"}"}i(b_,"collectionOf");function pY($){for(var K=0;K<$.length;K++)if(xi($[K],`
`)>=0)return!1;return!0}i(pY,"singleLineValues");function fY($,K){var qt;if($.indent==="	")qt="	";else if(typeof $.indent=="number"&&$.indent>0)qt=sn.call(Array($.indent+1)," ");else return null;return{base:qt,prev:sn.call(Array(K+1),qt)}}i(fY,"getIndent");function Xv($,K){if($.length===0)return"";var qt=`
`+K.prev+K.base;return qt+sn.call($,","+qt)+`
`+K.prev}i(Xv,"indentedJoin");function gh($,K){var qt=cd($),en=[];if(qt){en.length=$.length;for(var rn=0;rn<$.length;rn++)en[rn]=Ir($,rn)?K($[rn],$):""}var gt=typeof za=="function"?za($):[],Di;if(kr){Di={};for(var Us=0;Us<gt.length;Us++)Di["$"+gt[Us]]=gt[Us]}for(var Gr in $)Ir($,Gr)&&(qt&&String(Number(Gr))===Gr&&Gr<$.length||kr&&Di["$"+Gr]instanceof Symbol||(Nn.call(/[^\w$]/,Gr)?en.push(K(Gr,$)+": "+K($[Gr],$)):en.push(Gr+": "+K($[Gr],$))));if(typeof za=="function")for(var Ei=0;Ei<gt.length;Ei++)mh.call($,gt[Ei])&&en.push("["+K(gt[Ei])+"]: "+K($[gt[Ei]],$));return en}i(gh,"arrObjKeys")}}),Tr=t({"node_modules/side-channel-list/index.js"(ae,F){"use strict";var A=$e(),R=c(),M=i(function(U,V,B){for(var q=U,X;(X=q.next)!=null;q=X)if(X.key===V)return q.next=X.next,B||(X.next=U.next,U.next=X),X},"listGetNode"),z=i(function(U,V){if(U){var B=M(U,V);return B&&B.value}},"listGet"),L=i(function(U,V,B){var q=M(U,V);q?q.value=B:U.next={key:V,next:U.next,value:B}},"listSet"),G=i(function(U,V){return U?
!!M(U,V):!1},"listHas"),j=i(function(U,V){if(U)return M(U,V,!0)},"listDelete");F.exports=i(function(){var V,B={assert:function(q){if(!B.has(q))throw new R("Side channel does not contain "+A(q))},delete:function(q){var X=V&&V.next,Z=j(V,q);return Z&&X&&X===Z&&(V=void 0),!!Z},get:function(q){return z(V,q)},has:function(q){return G(V,q)},set:function(q,X){V||(V={next:void 0}),L(V,q,X)}};return B},"getSideChannelList")}}),Sr=t({"node_modules/side-channel-map/index.js"(ae,F){"use strict";var A=Be(),R=Ue(),M=$e(),z=c(),L=A("%Map%",!0),G=R("Map.prototype.get",!0),j=R("Map.prototype.set",!0),U=R("Map.prototype.has",!0),V=R("Map.prototype.delete",!0),B=R("Map.prototype.size",!0);F.exports=!!L&&i(function(){var X,Z={assert:function(pe){if(!Z.has(pe))throw new z("Side channel does not contain "+M(pe))},delete:function(pe){if(X){var Te=V(X,pe);return B(X)===0&&(X=void 0),Te}return!1},get:function(pe){if(X)return G(X,pe)},has:function(pe){return X?U(X,pe):!1},set:function(pe,Te){X||(X=new L),j(X,pe,
Te)}};return Z},"getSideChannelMap")}}),ne=t({"node_modules/side-channel-weakmap/index.js"(ae,F){"use strict";var A=Be(),R=Ue(),M=$e(),z=Sr(),L=c(),G=A("%WeakMap%",!0),j=R("WeakMap.prototype.get",!0),U=R("WeakMap.prototype.set",!0),V=R("WeakMap.prototype.has",!0),B=R("WeakMap.prototype.delete",!0);F.exports=G?i(function(){var X,Z,pe={assert:function(Te){if(!pe.has(Te))throw new L("Side channel does not contain "+M(Te))},delete:function(Te){if(G&&Te&&(typeof Te=="object"||typeof Te=="function")){if(X)return B(X,Te)}else if(z&&Z)return Z.delete(Te);return!1},get:function(Te){return G&&Te&&(typeof Te=="object"||typeof Te=="function")&&X?j(X,Te):Z&&Z.get(Te)},has:function(Te){return G&&Te&&(typeof Te=="object"||typeof Te=="function")&&X?V(X,Te):!!Z&&Z.has(Te)},set:function(Te,it){G&&Te&&(typeof Te=="object"||typeof Te=="function")?(X||(X=new G),U(X,Te,it)):z&&(Z||(Z=z()),Z.set(Te,it))}};return pe},"getSideChannelWeakMap"):z}}),_e=t({"node_modules/side-channel/index.js"(ae,F){"use strict";var A=c(),
R=$e(),M=Tr(),z=Sr(),L=ne(),G=L||z||M;F.exports=i(function(){var U,V={assert:function(B){if(!V.has(B))throw new A("Side channel does not contain "+R(B))},delete:function(B){return!!U&&U.delete(B)},get:function(B){return U&&U.get(B)},has:function(B){return!!U&&U.has(B)},set:function(B,q){U||(U=G()),U.set(B,q)}};return V},"getSideChannel")}}),Re=t({"node_modules/internal-slot/index.js"(ae,F){"use strict";var A=Ge(),R=_e()(),M=c(),z={assert:function(L,G){if(!L||typeof L!="object"&&typeof L!="function")throw new M("`O` is not an object");if(typeof G!="string")throw new M("`slot` must be a string");if(R.assert(L),!z.has(L,G))throw new M("`"+G+"` is not present on `O`")},get:function(L,G){if(!L||typeof L!="object"&&typeof L!="function")throw new M("`O` is not an object");if(typeof G!="string")throw new M("`slot` must be a string");var j=R.get(L);return j&&j["$"+G]},has:function(L,G){if(!L||typeof L!="object"&&typeof L!="function")throw new M("`O` is not an object");if(typeof G!="string")throw new M(
"`slot` must be a string");var j=R.get(L);return!!j&&A(j,"$"+G)},set:function(L,G,j){if(!L||typeof L!="object"&&typeof L!="function")throw new M("`O` is not an object");if(typeof G!="string")throw new M("`slot` must be a string");var U=R.get(L);U||(U={},R.set(L,U)),U["$"+G]=j}};Object.freeze&&Object.freeze(z),F.exports=z}}),Ae=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/CompletionRecord.js"(ae,F){"use strict";var A=s(),R=Re(),M=i(function z(L,G){if(!(this instanceof z))return new z(L,G);if(L!=="normal"&&L!=="break"&&L!=="continue"&&L!=="return"&&L!=="throw")throw new A('Assertion failed: `type` must be one of "normal", "break", "continue", "return", or "throw"');R.set(this,"[[Type]]",L),R.set(this,"[[Value]]",G)},"CompletionRecord2");M.prototype.type=i(function(){return R.get(this,"[[Type]]")},"Type"),M.prototype.value=i(function(){return R.get(this,"[[Value]]")},"Value"),M.prototype["?"]=i(function(){var L=R.get(this,"[[Type]]"),G=R.get(this,"[[Value]]");if(L===
"throw")throw G;return G},"ReturnIfAbrupt"),M.prototype["!"]=i(function(){var L=R.get(this,"[[Type]]");if(L!=="normal")throw new A('Assertion failed: Completion Record is not of type "normal"');return R.get(this,"[[Value]]")},"assert"),F.exports=M}}),Ye=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/CreateIterResultObject.js"(ae,F){"use strict";var A=c();F.exports=i(function(M,z){if(typeof z!="boolean")throw new A("Assertion failed: Type(done) is not Boolean");return{value:M,done:z}},"CreateIterResultObject")}}),ot=t({"node_modules/is-callable/index.js"(ae,F){"use strict";var A=Function.prototype.toString,R=typeof Reflect=="object"&&Reflect!==null&&Reflect.apply,M,z;if(typeof R=="function"&&typeof Object.defineProperty=="function")try{M=Object.defineProperty({},"length",{get:function(){throw z}}),z={},R(function(){throw 42},null,M)}catch(Ct){Ct!==z&&(R=null)}else R=null;var L=/^\s*class\b/,G=i(function(Ze){try{var Zt=A.call(Ze);return L.test(Zt)}catch{return!1}},"is\
ES6ClassFunction"),j=i(function(Ze){try{return G(Ze)?!1:(A.call(Ze),!0)}catch{return!1}},"tryFunctionToStr"),U=Object.prototype.toString,V="[object Object]",B="[object Function]",q="[object GeneratorFunction]",X="[object HTMLAllCollection]",Z="[object HTML document.all class]",pe="[object HTMLCollection]",Te=typeof Symbol=="function"&&!!Symbol.toStringTag,it=!(0 in[,]),Yt=i(function(){return!1},"isDocumentDotAll");typeof document=="object"&&(bt=document.all,U.call(bt)===U.call(document.all)&&(Yt=i(function(Ze){if((it||!Ze)&&(typeof Ze>"u"||typeof Ze=="object"))try{var Zt=U.call(Ze);return(Zt===X||Zt===Z||Zt===pe||Zt===V)&&Ze("")==null}catch{}return!1},"isDocumentDotAll")));var bt;F.exports=i(R?function(Ze){if(Yt(Ze))return!0;if(!Ze||typeof Ze!="function"&&typeof Ze!="object")return!1;try{R(Ze,null,M)}catch(Zt){if(Zt!==z)return!1}return!G(Ze)&&j(Ze)}:function(Ze){if(Yt(Ze))return!0;if(!Ze||typeof Ze!="function"&&typeof Ze!="object")return!1;if(Te)return j(Ze);if(G(Ze))return!1;var Zt=U.
call(Ze);return Zt!==B&&Zt!==q&&!/^\[object HTML/.test(Zt)?!1:j(Ze)},"isCallable")}}),ht=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/IsCallable.js"(ae,F){"use strict";F.exports=ot()}}),lt=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/helpers/isObject.js"(ae,F){"use strict";F.exports=i(function(R){return!!R&&(typeof R=="function"||typeof R=="object")},"isObject")}}),nn=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/5/Type.js"(ae,F){"use strict";var A=lt();F.exports=i(function(M){if(M===null)return"Null";if(typeof M>"u")return"Undefined";if(A(M))return"Object";if(typeof M=="number")return"Number";if(typeof M=="boolean")return"Boolean";if(typeof M=="string")return"String"},"Type")}}),jt=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/Type.js"(ae,F){"use strict";var A=nn();F.exports=i(function(M){return typeof M=="symbol"?"Symbol":typeof M=="bigint"?"BigInt":A(M)},"Type")}}),ce=t({"node_modules/es-iterator-helpers/aos\
/GeneratorStart.js"(ae,F){"use strict";var A=c(),R=Ye(),M=ht(),z=jt(),L=Re();F.exports=i(function(j,U){if(L.assert(j,"[[GeneratorState]]"),L.assert(j,"[[GeneratorContext]]"),L.assert(j,"[[GeneratorBrand]]"),L.assert(j,"[[Sentinel]]"),L.assert(j,"[[CloseIfAbrupt]]"),!M(U)||U.length!==0)throw new A("`closure` must be a function that takes no arguments");var V=L.get(U,"[[Sentinel]]");if(z(V)!=="Object")throw new A("`closure.[[Sentinel]]` must be an object");L.set(j,"[[GeneratorContext]]",function(){try{var B=U();return B===V?(L.set(j,"[[GeneratorState]]","completed"),L.set(j,"[[GeneratorContext]]",null),R(void 0,!0)):(L.set(j,"[[GeneratorState]]","suspendedYield"),R(B,!1))}catch(q){throw L.set(j,"[[GeneratorState]]","completed"),L.set(j,"[[GeneratorContext]]",null),q}}),L.set(j,"[[GeneratorState]]","suspendedStart")},"GeneratorStart")}}),Ce=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/helpers/forEach.js"(ae,F){"use strict";F.exports=i(function(R,M){for(var z=0;z<R.length;z+=
1)M(R[z],z,R)},"forEach")}}),Ke=t({"node_modules/has-proto/index.js"(ae,F){"use strict";var A={__proto__:null,foo:{}},R={__proto__:A}.foo===A.foo&&!(A instanceof Object);F.exports=i(function(){return R},"hasProto")}}),Xt=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/OrdinaryObjectCreate.js"(ae,F){"use strict";var A=Be(),R=A("%Object.create%",!0),M=c(),z=s(),L=de(),G=Ce(),j=lt(),U=Re(),V=Ke()();F.exports=i(function(q){if(q!==null&&!j(q))throw new M("Assertion failed: `proto` must be null or an object");var X=arguments.length<2?[]:arguments[1];if(!L(X))throw new M("Assertion failed: `additionalInternalSlotsList` must be an Array");var Z;if(R)Z=R(q);else if(V)Z={__proto__:q};else{if(q===null)throw new z("native Object.create support is required to create null objects");var pe=i(function(){},"T2");pe.prototype=q,Z=new pe}return X.length>0&&G(X,function(Te){U.set(Z,Te,void 0)}),Z},"OrdinaryObjectCreate")}}),nt=t({"node_modules/es-iterator-helpers/node_modules/es-abstrac\
t/helpers/every.js"(ae,F){"use strict";F.exports=i(function(R,M){for(var z=0;z<R.length;z+=1)if(!M(R[z],z,R))return!1;return!0},"every")}}),vt=t({"node_modules/set-function-length/index.js"(ae,F){"use strict";var A=Be(),R=m(),M=p()(),z=l(),L=c(),G=A("%Math.floor%");F.exports=i(function(U,V){if(typeof U!="function")throw new L("`fn` is not a function");if(typeof V!="number"||V<0||V>4294967295||G(V)!==V)throw new L("`length` must be a positive 32-bit integer");var B=arguments.length>2&&!!arguments[2],q=!0,X=!0;if("length"in U&&z){var Z=z(U,"length");Z&&!Z.configurable&&(q=!1),Z&&!Z.writable&&(X=!1)}return(q||X||!B)&&(M?R(U,"length",V,!0,!0):R(U,"length",V)),U},"setFunctionLength")}}),Wt=t({"node_modules/call-bind-apply-helpers/applyBind.js"(ae,F){"use strict";var A=ze(),R=yt(),M=$t();F.exports=i(function(){return M(A,R,arguments)},"applyBind")}}),He=t({"node_modules/call-bind/index.js"(ae,F){"use strict";var A=vt(),R=o(),M=pt(),z=Wt();F.exports=i(function(G){var j=M(arguments),U=G.length-
(arguments.length-1);return A(j,1+(U>0?U:0),!0)},"callBind"),R?R(F.exports,"apply",{value:z}):F.exports.apply=z}}),Ot=t({"node_modules/isarray/index.js"(ae,F){var A={}.toString;F.exports=Array.isArray||function(R){return A.call(R)=="[object Array]"}}}),Fn=t({"node_modules/safe-array-concat/index.js"(ae,F){"use strict";var A=Be(),R=A("%Array.prototype.concat%"),M=He(),z=Ue(),L=z("Array.prototype.slice"),G=Oe()(),j=G&&Symbol.isConcatSpreadable,U=[],V=j?M.apply(R,U):null,B=j?Ot():null;F.exports=j?i(function(X){for(var Z=0;Z<arguments.length;Z+=1){var pe=arguments[Z];if(pe&&typeof pe=="object"&&typeof pe[j]=="boolean"){U[j]||(U[j]=!0);var Te=B(pe)?L(pe):[pe];Te[j]=!0,arguments[Z]=Te}}return V(arguments)},"safeArrayConcat"):M(R,U)}}),Jt=t({"node_modules/es-iterator-helpers/aos/CreateIteratorFromClosure.js"(ae,F){"use strict";var A=c(),R=ce(),M=de(),z=ht(),L=Xt(),G=nt(),j=Re(),U=Fn(),V=i(function(q){return typeof q=="string"},"isString2");F.exports=i(function(q,X,Z){if(!z(q))throw new A("`cl\
osure` must be a function");if(typeof X!="string")throw new A("`generatorBrand` must be a string");var pe=arguments.length>3?arguments[3]:[];if(arguments.length>3&&(!M(pe)||!G(pe,V)))throw new A("`extraSlots` must be a List of String internal slot names");var Te=U(pe,["[[GeneratorContext]]","[[GeneratorBrand]]","[[GeneratorState]]"]),it=L(Z,Te);return j.set(it,"[[GeneratorBrand]]",X),j.assert(q,"[[Sentinel]]"),j.set(it,"[[Sentinel]]",j.get(q,"[[Sentinel]]")),j.assert(q,"[[CloseIfAbrupt]]"),j.set(it,"[[CloseIfAbrupt]]",j.get(q,"[[CloseIfAbrupt]]")),R(it,q),it},"CreateIteratorFromClosure")}}),Qn=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/helpers/isPropertyKey.js"(ae,F){"use strict";F.exports=i(function(R){return typeof R=="string"||typeof R=="symbol"},"isPropertyKey")}}),Cr=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/Get.js"(ae,F){"use strict";var A=c(),R=$e(),M=lt(),z=Qn();F.exports=i(function(G,j){if(!M(G))throw new A("Assertion failed: Type(O)\
 is not Object");if(!z(j))throw new A("Assertion failed: P is not a Property Key, got "+R(j));return G[j]},"Get")}}),qa=t({"node_modules/es-iterator-helpers/aos/GetIteratorDirect.js"(ae,F){"use strict";var A=c(),R=Cr(),M=jt();F.exports=i(function(L){if(M(L)!=="Object")throw new A("Assertion failed: `obj` must be an Object");var G=R(L,"next"),j={"[[Iterator]]":L,"[[NextMethod]]":G,"[[Done]]":!1};return j},"GetIteratorDirect")}}),xo=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/helpers/isLeadingSurrogate.js"(ae,F){"use strict";F.exports=i(function(R){return typeof R=="number"&&R>=55296&&R<=56319},"isLeadingSurrogate")}}),Do=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/helpers/isTrailingSurrogate.js"(ae,F){"use strict";F.exports=i(function(R){return typeof R=="number"&&R>=56320&&R<=57343},"isTrailingSurrogate")}}),Fs=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/UTF16SurrogatePairToCodePoint.js"(ae,F){"use strict";var A=Be(),R=c(),M=A(
"%String.fromCharCode%"),z=xo(),L=Do();F.exports=i(function(j,U){if(!z(j)||!L(U))throw new R("Assertion failed: `lead` must be a leading surrogate char code, and `trail` must be a trailing surrogate char code");return M(j)+M(U)},"UTF16SurrogatePairToCodePoint")}}),Rs=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/CodePointAt.js"(ae,F){"use strict";var A=c(),R=Ue(),M=xo(),z=Do(),L=Fs(),G=R("String.prototype.charAt"),j=R("String.prototype.charCodeAt");F.exports=i(function(V,B){if(typeof V!="string")throw new A("Assertion failed: `string` must be a String");var q=V.length;if(B<0||B>=q)throw new A("Assertion failed: `position` must be >= 0, and < the length of `string`");var X=j(V,B),Z=G(V,B),pe=M(X),Te=z(X);if(!pe&&!Te)return{"[[CodePoint]]":Z,"[[CodeUnitCount]]":1,"[[IsUnpairedSurrogate]]":!1};if(Te||B+1===q)return{"[[CodePoint]]":Z,"[[CodeUnitCount]]":1,"[[IsUnpairedSurrogate]]":!0};var it=j(V,B+1);return z(it)?{"[[CodePoint]]":L(X,it),"[[CodeUnitCount]]":2,"[[IsUnpa\
iredSurrogate]]":!1}:{"[[CodePoint]]":Z,"[[CodeUnitCount]]":1,"[[IsUnpairedSurrogate]]":!0}},"CodePointAt")}}),Hc=t({"node_modules/math-intrinsics/isFinite.js"(ae,F){"use strict";var A=me();F.exports=i(function(M){return(typeof M=="number"||typeof M=="bigint")&&!A(M)&&M!==1/0&&M!==-1/0},"isFinite2")}}),_s=t({"node_modules/math-intrinsics/isInteger.js"(ae,F){"use strict";var A=S(),R=k(),M=me(),z=Hc();F.exports=i(function(G){if(typeof G!="number"||M(G)||!z(G))return!1;var j=A(G);return R(j)===j},"isInteger")}}),Ms=t({"node_modules/math-intrinsics/constants/maxSafeInteger.js"(ae,F){"use strict";F.exports=Number.MAX_SAFE_INTEGER||9007199254740991}}),Os=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/AdvanceStringIndex.js"(ae,F){"use strict";var A=Rs(),R=c(),M=_s(),z=Ms();F.exports=i(function(G,j,U){if(typeof G!="string")throw new R("Assertion failed: `S` must be a String");if(!M(j)||j<0||j>z)throw new R("Assertion failed: `length` must be an integer >= 0 and <= 2**53");if(typeof U!=
"boolean")throw new R("Assertion failed: `unicode` must be a Boolean");if(!U)return j+1;var V=G.length;if(j+1>=V)return j+1;var B=A(G,j);return j+B["[[CodeUnitCount]]"]},"AdvanceStringIndex")}}),Ns=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/GetV.js"(ae,F){"use strict";var A=c(),R=$e(),M=Qn();F.exports=i(function(L,G){if(!M(G))throw new A("Assertion failed: P is not a Property Key, got "+R(G));return L[G]},"GetV")}}),Ql=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/GetMethod.js"(ae,F){"use strict";var A=c(),R=Ns(),M=ht(),z=Qn(),L=$e();F.exports=i(function(j,U){if(!z(U))throw new A("Assertion failed: P is not a Property Key");var V=R(j,U);if(V!=null){if(!M(V))throw new A(L(U)+" is not a function: "+L(V));return V}},"GetMethod")}}),Wc=t({"node_modules/has-tostringtag/shams.js"(ae,F){"use strict";var A=Oe();F.exports=i(function(){return A()&&!!Symbol.toStringTag},"hasToStringTagShams")}}),ah=t({"node_modules/es-iterator-helpers/node_modules/is-s\
tring/index.js"(ae,F){"use strict";var A=Ue(),R=A("String.prototype.valueOf"),M=i(function(U){try{return R(U),!0}catch{return!1}},"tryStringObject2"),z=A("Object.prototype.toString"),L="[object String]",G=Wc()();F.exports=i(function(U){return typeof U=="string"?!0:!U||typeof U!="object"?!1:G?M(U):z(U)===L},"isString")}}),oh=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/helpers/getIteratorMethod.js"(ae,F){"use strict";var A=we()(),R=Be(),M=Ue(),z=ah(),L=R("%Symbol.iterator%",!0),G=M("String.prototype.slice"),j=R("%String%");F.exports=i(function(V,B){var q;return A?q=V.GetMethod(B,L):V.IsArray(B)?q=i(function(){var X=-1,Z=this;return{next:function(){return X+=1,{done:X>=Z.length,value:Z[X]}}}},"usingIterator"):z(B)&&(q=i(function(){var X=0;return{next:function(){var Z=V.AdvanceStringIndex(j(B),X,!0),pe=G(B,X,Z);return X=Z,{done:Z>B.length,value:pe}}}},"usingIterator")),q},"getIteratorMethod")}}),ih=t({"node_modules/es-iterator-helpers/aos/GetIteratorFlattenable.js"(ae,F){
"use strict";var A=c(),R=Os(),M=Mt(),z=qa(),L=Ql(),G=de(),j=jt(),U=oh();F.exports=i(function(B,q){if(q!=="REJECT-STRINGS"&&q!=="ITERATE-STRINGS")throw new A('Assertion failed: `stringHandling` must be "REJECT-STRINGS" or "ITERATE-STRINGS"');if(j(B)!=="Object"&&(q==="REJECT-STRINGS"||typeof B!="string"))throw new A("obj must be an Object");var X=void 0;X=U({AdvanceStringIndex:R,GetMethod:L,IsArray:G},B);var Z;if(typeof X>"u"?Z=B:Z=M(X,B),j(Z)!=="Object")throw new A("iterator must be an Object");return z(Z)},"GetIteratorFlattenable")}}),Ps=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/helpers/records/iterator-record.js"(ae,F){"use strict";var A=Ge();F.exports=i(function(M){return!!M&&typeof M=="object"&&A(M,"[[Iterator]]")&&A(M,"[[NextMethod]]")&&A(M,"[[Done]]")&&typeof M["[[Done]]"]=="boolean"},"isIteratorRecord")}}),ed=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/IteratorClose.js"(ae,F){"use strict";var A=c(),R=Mt(),M=Ae(),z=Ql(),L=ht(),G=lt(),j=Ps();
F.exports=i(function(V,B){if(!j(V))throw new A("Assertion failed: `iteratorRecord` must be an Iterator Record");if(!G(V["[[Iterator]]"]))throw new A("Assertion failed: iteratorRecord.[[Iterator]] must be an Object");if(!L(B)&&!(B instanceof M))throw new A("Assertion failed: completion is not a thunk representing a Completion Record, nor a Completion Record instance");var q=B instanceof M?function(){return B["?"]()}:B,X=V["[[Iterator]]"],Z;try{Z=z(X,"return")}catch(it){throw q(),q=null,it}if(typeof Z>"u")return q();var pe;try{pe=R(Z,X,[])}catch(it){throw q(),q=null,it}var Te=q();if(q=null,!G(pe))throw new A("iterator .return must return an object");return Te},"IteratorClose")}}),$v=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/ToBoolean.js"(ae,F){"use strict";F.exports=i(function(R){return!!R},"ToBoolean")}}),Ls=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/IteratorComplete.js"(ae,F){"use strict";var A=c(),R=Cr(),M=$v(),z=lt();F.exports=i(function(G){
if(!z(G))throw new A("Assertion failed: Type(iterResult) is not Object");return M(R(G,"done"))},"IteratorComplete")}}),td=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/IteratorNext.js"(ae,F){"use strict";var A=c(),R=Mt(),M=lt(),z=Ps();F.exports=i(function(G){if(!z(G))throw new A("Assertion failed: `iteratorRecord` must be an Iterator Record");var j;if(arguments.length<2?j=R(G["[[NextMethod]]"],G["[[Iterator]]"]):j=R(G["[[NextMethod]]"],G["[[Iterator]]"],[arguments[1]]),!M(j))throw new A("iterator next must return an object");return j},"IteratorNext")}}),Gc=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/IteratorStepValue.js"(ae,F){"use strict";var A=c(),R=Cr(),M=Ls(),z=td(),L=Ps();F.exports=i(function(j){if(!L(j))throw new A("Assertion failed: `iteratorRecord` must be an Iterator Record");var U;try{U=z(j)}catch(q){throw j["[[Done]]"]=!0,q}var V;try{V=M(U)}catch(q){throw j["[[Done]]"]=!0,q}if(V)return j["[[Done]]"]=!0,"DONE";var B;try{B=R(U,"value")}catch(q){
throw j["[[Done]]"]=!0,q}return B},"IteratorStepValue")}}),Bs=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/ThrowCompletion.js"(ae,F){"use strict";var A=Ae();F.exports=i(function(M){return new A("throw",M)},"ThrowCompletion")}}),sh=t({"node_modules/es-set-tostringtag/index.js"(ae,F){"use strict";var A=Be(),R=A("%Object.defineProperty%",!0),M=Wc()(),z=Ge(),L=c(),G=M?Symbol.toStringTag:null;F.exports=i(function(U,V){var B=arguments.length>2&&!!arguments[2]&&arguments[2].force,q=arguments.length>2&&!!arguments[2]&&arguments[2].nonConfigurable;if(typeof B<"u"&&typeof B!="boolean"||typeof q<"u"&&typeof q!="boolean")throw new L("if provided, the `overrideIfSet` and `nonConfigurable` options must be booleans");G&&(B||!z(U,G))&&(R?R(U,G,{configurable:!q,enumerable:!1,value:V,writable:!1}):U[G]=V)},"setToStringTag")}}),ch=t({"node_modules/functions-have-names/index.js"(ae,F){"use strict";var A=i(function(){return typeof i(function(){},"f").name=="string"},"functionsHaveName\
s2"),R=Object.getOwnPropertyDescriptor;if(R)try{R([],"length")}catch{R=null}A.functionsHaveConfigurableNames=i(function(){if(!A()||!R)return!1;var L=R(function(){},"name");return!!L&&!!L.configurable},"functionsHaveConfigurableNames");var M=Function.prototype.bind;A.boundFunctionsHaveNames=i(function(){return A()&&typeof M=="function"&&i(function(){},"f").bind().name!==""},"boundFunctionsHaveNames"),F.exports=A}}),uh=t({"node_modules/set-function-name/index.js"(ae,F){"use strict";var A=m(),R=p()(),M=ch().functionsHaveConfigurableNames(),z=c();F.exports=i(function(G,j){if(typeof G!="function")throw new z("`fn` is not a function");var U=arguments.length>2&&!!arguments[2];return(!U||M)&&(R?A(G,"name",j,!0,!0):A(G,"name",j)),G},"setFunctionName")}}),lh=t({"node_modules/iterator.prototype/index.js"(ae,F){"use strict";var A=Be(),R=Xe(),M=we(),z=uh(),L=m(),G=h(),j=A("%ArrayIteratorPrototype%",!0),U=j&&R(j),V=U!==G.prototype&&U||{};M()&&(Symbol.iterator in V||(B=z(i(function(){return this},"Sy\
mbolIterator"),"[Symbol.iterator]",!0),L(V,Symbol.iterator,B,!0)));var B;F.exports=V}}),nd=t({"node_modules/es-iterator-helpers/Iterator.prototype/implementation.js"(ae,F){"use strict";F.exports=lh()}}),rd=t({"node_modules/es-iterator-helpers/aos/GeneratorValidate.js"(ae,F){"use strict";var A=c(),R=Re();F.exports=i(function(z,L){R.assert(z,"[[GeneratorState]]"),R.assert(z,"[[GeneratorBrand]]");var G=R.get(z,"[[GeneratorBrand]]");if(G!==L)throw new A("Assertion failed: generator brand is unexpected: "+G);R.assert(z,"[[GeneratorContext]]");var j=R.get(z,"[[GeneratorState]]");if(j==="executing")throw new A("generator is executing");return j},"GeneratorValidate")}}),dh=t({"node_modules/es-iterator-helpers/aos/GeneratorResume.js"(ae,F){"use strict";var A=c(),R=Ye(),M=rd(),z=Re();F.exports=i(function(G,j,U){var V=M(G,U);if(V==="completed")return R(void 0,!0);if(V!=="suspendedStart"&&V!=="suspendedYield")throw new A("Assertion failed: generator state is unexpected: "+V);var B=z.get(G,"[[Gener\
atorContext]]");z.set(G,"[[GeneratorState]]","executing");var q=B(j);return q},"GeneratorResume")}}),Vc=t({"node_modules/es-iterator-helpers/node_modules/es-abstract/2024/NormalCompletion.js"(ae,F){"use strict";var A=Ae();F.exports=i(function(M){return new A("normal",M)},"NormalCompletion")}}),rY=t({"node_modules/es-iterator-helpers/aos/GeneratorResumeAbrupt.js"(ae,F){"use strict";var A=c(),R=Ae(),M=Ye(),z=rd(),L=Vc(),G=Re();F.exports=i(function(U,V,B){if(!(V instanceof R))throw new A("Assertion failed: abruptCompletion must be a Completion Record");var q=z(U,B);q==="suspendedStart"&&(G.set(U,"[[GeneratorState]]","completed"),G.set(U,"[[GeneratorContext]]",null),q="completed");var X=V.value();if(q==="completed")return M(X,!0);if(q!=="suspendedYield")throw new A("Assertion failed: generator state is unexpected: "+q);if(V.type()==="return")return M(G.get(U,"[[CloseIfAbrupt]]")(L(V.value())),!0);var Z=G.get(U,"[[GeneratorContext]]");G.set(U,"[[GeneratorState]]","executing");var pe=Z(X);return pe},
"GeneratorResumeAbrupt")}}),aY=t({"node_modules/es-iterator-helpers/aos/IteratorCloseAll.js"(ae,F){"use strict";var A=c(),R=Ae(),M=ed(),z=Bs(),L=be(),G=nt(),j=Ps();F.exports=i(function(V,B){if(!L(V)||!G(V,j))throw new A("Assertion failed: `iters` must be a List of IteratorRecords");if(!(B instanceof R))throw new A("Assertion failed: `completion` must be a Completion Record");for(var q=V.length-1;q>=0;q-=1)try{M(V[q],B)}catch(X){B=z(X)}return B["?"]()},"IteratorCloseAll")}}),oY=t({"node_modules/es-iterator-helpers/aos/ReturnCompletion.js"(ae,F){"use strict";var A=Ae();F.exports=i(function(M){return new A("return",M)},"ReturnCompletion")}}),iY=t({"node_modules/es-iterator-helpers/IteratorHelperPrototype/index.js"(ae,F){"use strict";var A=sh(),R=Ke()(),M=nd(),z=Re(),L=Ye(),G=dh(),j=rY(),U=aY(),V=oY(),B,q={return:function(){var Z=this;if(z.assert(Z,"[[UnderlyingIterators]]"),z.assert(Z,"[[GeneratorState]]"),z.get(Z,"[[GeneratorState]]")==="suspendedStart")return z.set(Z,"[[GeneratorState]]",
"completed"),U(z.get(Z,"[[UnderlyingIterators]]"),V(void 0)),L(void 0,!0);var pe=V(void 0);return j(Z,pe,"Iterator Helper")}};R?(B={__proto__:M,next:i(function(){return G(this,void 0,"Iterator Helper")},"next"),return:q.return},A(B,"Iterator Helper")):(X=i(function(){},"IteratorHelper2"),X.prototype=M,B=new X,delete B.constructor,B.next=i(function(){return G(this,void 0,"Iterator Helper")},"next"),B.return=q.return);var X;F.exports=B}}),sY=t({"node_modules/es-iterator-helpers/Iterator.prototype.flatMap/implementation.js"(ae,F){"use strict";var A=c(),R=Mt(),M=Ae(),z=Jt(),L=qa(),G=ih(),j=ht(),U=ed(),V=Gc(),B=Bs(),q=jt(),X=iY(),Z=Re();F.exports=i(function pe(Te){if(this instanceof pe)throw new A("`flatMap` is not a constructor");var it=this;if(q(it)!=="Object")throw new A("`this` value must be an Object");if(!j(Te))throw new A("`mapper` must be a function");var Yt=L(it),bt={sentinel:!0},Ct=bt,Ze=i(function(sn){if(!(sn instanceof M))throw new A("`abruptCompletion` must be a Completion Reco\
rd");try{Ct!==bt&&U(Ct,sn)}finally{Ct=bt,U(Yt,sn)}},"closeIfAbrupt"),Zt=0,Vn=!1,Nn=i(function(){if(Ct===bt){var sn=V(Yt);if(Yt["[[Done]]"])return Vn=!1,Ct=bt,bt}if(Ct===bt){Vn=!0;try{var ad=R(Te,void 0,[sn,Zt]);Ct=G(ad,"REJECT-STRINGS")}catch(zr){Vn=!1,Ct=bt,Ze(B(zr))}finally{Zt+=1}}if(Vn){var gi;try{gi=V(Ct)}catch(zr){Vn=!1,Ct=bt,Ze(B(zr))}return Ct["[[Done]]"]?(Vn=!1,Ct=bt,Nn()):gi}return bt},"closure");Z.set(Nn,"[[Sentinel]]",bt),Z.set(Nn,"[[CloseIfAbrupt]]",Ze);var Qt=z(Nn,"Iterator Helper",X,["[[UnderlyingIterators]]"]);return Z.set(Qt,"[[UnderlyingIterators]]",[Yt]),Qt},"flatMap")}}),cY=t({"node_modules/es-iterator-helpers/Iterator.prototype.flatMap/polyfill.js"(ae,F){"use strict";var A=sY();F.exports=i(function(){if(typeof Iterator=="function"&&typeof Iterator.prototype.flatMap=="function")try{Iterator.prototype.flatMap.call({next:null},function(){}).next()}catch{return Iterator.prototype.flatMap}return A},"getPolyfill")}}),uY=t({"node_modules/es-iterator-helpers/Iterator.protot\
ype.flatMap/shim.js"(ae,F){"use strict";var A=f(),R=cY(),M=nd();F.exports=i(function(){var L=R();return A(M,{flatMap:L},{flatMap:function(){return M.flatMap!==L}}),L},"shimIteratorPrototypeFlatMap")}});uY()()})()});var EE={};E(EE,{getLogNormalScore:()=>Om,linearInterpolation:()=>DE});function Sde(e){let t=Math.sign(e);e=Math.abs(e);let n=.254829592,r=-.284496736,a=1.421413741,o=-1.453152027,s=1.061405429,u=1/(1+.3275911*e),l=u*(n+u*(r+u*(a+u*(o+u*s))));return t*(1-l*Math.exp(-e*e))}function Om({median:e,p10:t},n){if(e<=0)throw new Error("median must be greater than zero");if(t<=0)throw new Error("p10 must be greater than zero");if(t>=e)throw new Error("p10 must be less than the median");if(n<=0)return 1;let r=.9061938024368232,a=Math.max(Number.MIN_VALUE,n/e),o=Math.log(a),s=Math.max(Number.MIN_VALUE,t/e),c=-Math.log(s),u=o*r/c,l=(1-Sde(u))/2,m;return n<=t?m=Math.max(.9,Math.min(1,l)):n<=e?m=Math.max(Ede,Math.min(Dde,l)):m=Math.max(0,Math.min(Tde,l)),m}function DE(e,t,n,r,a){let o=(r-t)/(n-e);return t+(a-e)*o}var Dde,Ede,Tde,J1=g(()=>{d();Dde=.8999999999999999,Ede=.5,Tde=.49999999999999994;i(Sde,"erf");i(Om,"getLogNormalScore");i(DE,"linearInterpolation")});var Mr={};E(Mr,{calculateMetricWeightsForSorting:()=>Fde,evaluateCLSMetricScore:()=>t6,evaluateINPMetricScore:()=>e6,evaluateLCPMetricScore:()=>Q4,getCLS:()=>Ide,getFieldMetricsForInsightSet:()=>r6,getINP:()=>kde,getInsight:()=>X1,getLCP:()=>Cde,metricSavingsForWastedBytes:()=>Nm});function X1(e,t,n){if(!t||!n)return null;let r=t.get(n);if(!r)return null;let a=r.model[e];return a instanceof Error?null:a}function Cde(e,t){let n=X1("LCPPhases",e,t);return!n||!n.lcpMs||!n.lcpEvent?null:{value:ue.milliToMicro(n.lcpMs),event:n.lcpEvent}}function kde(e,t){let n=X1("InteractionToNextPaint",e,t);return n?.longestInteractionEvent?.dur?{value:n.longestInteractionEvent.dur,event:n.longestInteractionEvent}:null}function Ide(e,t){let n=X1("CLSCulprits",e,t);if(!n)return{value:0,worstClusterEvent:null};let r=0,a;for(let o of n.clusters)o.clusterCumulativeScore>r&&(r=o.clusterCumulativeScore,a=o);return{value:r,worstClusterEvent:a??null}}function Q4(e){return Om({p10:2500,median:4e3},e)}function e6(e){
return Om({p10:200,median:500},e)}function t6(e){return Om({p10:.1,median:.25},e)}function Ade(e,t,n,r=null){return e.find(a=>{let o=r?a[`${r.pageScope}-${r.deviceScope}`]?.record.key:(a["url-ALL"]||a["origin-ALL"])?.record.key;return o?.url&&o.url===t||o?.origin&&o.origin===n})}function n6(e,t,n=null){let r=[];n?r.push(n):(r.push({pageScope:"url",deviceScope:"ALL"}),r.push({pageScope:"origin",deviceScope:"ALL"}));for(let a of r){let o=`${a.pageScope}-${a.deviceScope}`,s=e[o]?.record.metrics[t]?.percentiles?.p75;if(typeof s=="string"&&(s=Number(s)),typeof s=="number"&&Number.isFinite(s))return{value:s,pageScope:a.pageScope}}return null}function mc(e,t,n=null){let r=n6(e,t,n);if(r){let a=r.value;return{value:ue.milliToMicro(a),pageScope:r.pageScope}}return null}function r6(e,t,n=null){let r=t?.cruxFieldData;if(!r)return null;let a=Ade(r,e.url.href,e.url.origin,n);return a?{fcp:mc(a,"first_contentful_paint",n),lcp:mc(a,"largest_contentful_paint",n),inp:mc(a,"interaction_to_next_paint",n),
cls:n6(a,"cumulative_layout_shift",n),lcpPhases:{ttfb:mc(a,"largest_contentful_paint_image_time_to_first_byte",n),loadDelay:mc(a,"largest_contentful_paint_image_resource_load_delay",n),loadDuration:mc(a,"largest_contentful_paint_image_resource_load_duration",n),renderDelay:mc(a,"largest_contentful_paint_image_element_render_delay",n)}}:null}function Fde(e,t){let n={lcp:.3333333333333333,inp:.3333333333333333,cls:.3333333333333333};if(!t?.cruxFieldData)return n;let a=r6(e,t);if(!a)return n;let o=a.lcp?.value??null,s=a.inp?.value??null,c=a.cls?.value??null,u=o!==null?Q4(o):0,l=s!==null?e6(s):0,m=c!==null?t6(c):0,p=1-u,f=1-l,h=1-m,y=p+f+h;return y&&(n.lcp=p/y,n.inp=f/y,n.cls=h/y),n}function Z4(e,t,n){let r=t.simulate(n),a=new Map;n.traverse(c=>{if(c.type!=="network")return;let u=e.get(c.request.requestId);if(!u)return;let l=c.request.transferSize;a.set(c.request.requestId,l),c.request.transferSize=Math.max(l-u,0)});let o=t.simulate(n);n.traverse(c=>{if(c.type!=="network")return;let u=a.get(
c.request.requestId);u!==void 0&&(c.request.transferSize=u)});let s=r.timeInMs-o.timeInMs;return s=Math.round(s/X4)*X4,O.Milli(s)}function Nm(e,t){if(!t.navigation||!t.lantern)return;if(!e.size)return{FCP:O.Milli(0),LCP:O.Milli(0)};let n=t.lantern.simulator,r=t.lantern.metrics.firstContentfulPaint.optimisticGraph,a=t.lantern.metrics.largestContentfulPaint.optimisticGraph;return{FCP:Z4(e,n,r),LCP:Z4(e,n,a)}}var X4,Z1=g(()=>{d();ut();Pe();J1();X4=50;i(X1,"getInsight");i(Cde,"getLCP");i(kde,"getINP");i(Ide,"getCLS");i(Q4,"evaluateLCPMetricScore");i(e6,"evaluateINPMetricScore");i(t6,"evaluateCLSMetricScore");i(Ade,"getPageResult");i(n6,"getMetricResult");i(mc,"getMetricTimingResult");i(r6,"getFieldMetricsForInsightSet");i(Fde,"calculateMetricWeightsForSorting");i(Z4,"estimateSavingsWithGraphs");i(Nm,"metricSavingsForWastedBytes")});var TE={};E(TE,{InsightCategory:()=>At,InsightWarning:()=>gr});var gr,At,jn=g(()=>{d();(function(e){e.NO_FP="NO_FP",e.NO_LCP="NO_LCP",e.NO_DOCUMENT_REQUEST="NO_DOCUMENT_REQUEST",e.NO_LAYOUT="NO_LAYOUT"})(gr||(gr={}));(function(e){e.ALL="All",e.INP="INP",e.LCP="LCP",e.CLS="CLS"})(At||(At={}))});var SE={};E(SE,{UIStrings:()=>sr,generateInsight:()=>jde,getNonCompositedFailure:()=>o6,i18nString:()=>pc});function a6(e,t){let n=e.dur?e.ts+e.dur:e.ts;return n<t.ts&&n>=t.ts-_de}function o6(e){let t=[],n=e.args.data.beginEvent,r=e.args.data.instantEvents||[];for(let a of r){let o=a.args.data.compositeFailed,s=a.args.data.unsupportedProperties;if(!o)continue;let c=Rde.filter(l=>o&l.flag).map(l=>l.failure),u={name:n.args.data.displayName,failureReasons:c,unsupportedProperties:s,animation:e};t.push(u)}return t}function Mde(e,t,n,r){let a=[];for(let o of e){let s=o6(o);if(!s)continue;a.push(...s);let c=Q1(t,o);if(!c||!a6(o,c))continue;let u=n.get(c);if(u)for(let l of u){let m=r.get(l);if(!m)throw new Error("Unaccounted shift");m.nonCompositedAnimations.push(...s)}}return a}function Ode(e,t){let n=new Map;for(let r of t){let a=_n.nearestIndexFromBeginning(e,o=>o.ts>=r.ts);if(a!==null)for(let o=a;o<e.length;o++){let s=e[o];if(s.ts>=r.ts&&s.ts<=r.ts+r.dur&&Me.getWithDefault(n,r,()=>[]).push(
s),s.ts>r.ts+r.dur)break}}return n}function Q1(e,t){let n=_n.nearestIndexFromBeginning(e,r=>r.ts>t.ts+(t.dur||0));if(n!==null)return e[n]}function Nde(e,t,n,r,a){for(let o of e){let s=Q1(t,o);if(!s)continue;let c=n.get(s);if(c)for(let u of c){let l=r.get(u);if(!l)throw new Error("Unaccounted shift");let m=a.find(p=>{let f=O.Micro(o.ts+(o.dur??0));return p.ts>=o.ts&&p.ts<=f});m?.args.frame&&l.iframeIds.push(m.args.frame)}}return r}function Pde(e,t,n,r){return n.forEach((a,o)=>{let s=Q1(t,o),c=e.find(u=>u.args.data.nodeId===s?.args.data.nodeId);if(c)for(let u of a){let l=r.get(u);if(!l)throw new Error("Unaccounted shift");l.unsizedImages.push(c.args.data.nodeId)}}),r}function Lde(e,t,n,r){let a=e.filter(o=>o.args.data.resourceType==="Font"&&o.args.data.mimeType.startsWith("font"));for(let o of a){let s=Q1(t,o);if(!s||!a6(o,s))continue;let c=n.get(s);if(c)for(let u of c){let l=r.get(u);if(!l)throw new Error("Unaccounted shift");l.fontRequests.push(o)}}return r}function Bde(e,t){let r=[],a=e.
events;for(let o of a){let s=t.get(o);if(!s)continue;let c=s.fontRequests,u=s.iframeIds,l=s.nonCompositedAnimations,m=s.unsizedImages;for(let p=0;p<c.length&&r.length<3;p++)r.push(pc(sr.fontRequest));for(let p=0;p<u.length&&r.length<3;p++)r.push(pc(sr.injectedIframe));for(let p=0;p<l.length&&r.length<3;p++)r.push(pc(sr.animation));for(let p=0;p<m.length&&r.length<3;p++)r.push(pc(sr.unsizedImages));if(r.length>=3)break}return r.slice(0,3)}function Ude(e){let t="pass";return e.worstCluster&&(ro.LayoutShifts.scoreClassificationForLayoutShift(e.worstCluster.clusterCumulativeScore)==="good"?t="informative":t="fail"),{insightKey:"CLSCulprits",strings:sr,title:pc(sr.title),description:pc(sr.description),category:At.CLS,state:t,...e}}function jde(e,t){let n=i(k=>ue.eventIsInBounds(k,t.bounds),"isWithinContext"),r=e.Animations.animations.filter(n),a=e.LayoutShifts.renderFrameImplCreateChildFrameEvents.filter(n),o=e.NetworkRequests.byTime.filter(n),s=e.LayoutShifts.domLoadingEvents.filter(n),c=e.
LayoutShifts.layoutImageUnsizedEvents.filter(n),u=t.navigation?t.navigationId:C.NO_NAVIGATION,l=e.LayoutShifts.clustersByNavigationId.get(u)??[],p=[...l].sort((k,_)=>_.clusterCumulativeScore-k.clusterCumulativeScore).at(0),f=l.flatMap(k=>k.events),h=e.LayoutShifts.prePaintEvents.filter(n),y=e.LayoutShifts.paintImageEvents.filter(n),b=new Map,w=Ode(f,h);for(let k of f)b.set(k,{iframeIds:[],fontRequests:[],nonCompositedAnimations:[],unsizedImages:[]});Nde(a,h,w,b,s),Lde(o,h,w,b),Pde(c,y,w,b);let D=Mde(r,h,w,b),T=[...f];p&&T.push(p);let S=new Map;for(let k of l)S.set(k,Bde(k,b));return Ude({relatedEvents:T,animationFailures:D,shifts:b,clusters:l,worstCluster:p,topCulpritsByCluster:S})}var sr,pc,Rde,_de,CE=g(()=>{d();dn();ia();ut();Pe();jn();sr={title:"Layout shift culprits",description:"Layout shifts occur when elements move absent any user interaction. [Investigate the causes of layout shifts](https://web.dev/articles/optimize-cls), such as elements being added, removed, or their fonts c\
hanging as the page loads.",worstLayoutShiftCluster:"Worst layout shift cluster",worstCluster:"Worst cluster",layoutShiftCluster:"Layout shift cluster @ {PH1}",topCulprits:"Top layout shift culprits",injectedIframe:"Injected iframe",fontRequest:"Font request",animation:"Animation",unsizedImages:"Unsized Images",noLayoutShifts:"No layout shifts",noCulprits:"Could not detect any layout shift culprits"},pc=i((e,t)=>({i18nId:e,values:t}),"i18nString"),Rde=[{flag:1,failure:"ACCELERATED_ANIMATIONS_DISABLED"},{flag:2,failure:"EFFECT_SUPPRESSED_BY_DEVTOOLS"},{flag:4,failure:"INVALID_ANIMATION_OR_EFFECT"},{flag:8,failure:"EFFECT_HAS_UNSUPPORTED_TIMING_PARAMS"},{flag:16,failure:"EFFECT_HAS_NON_REPLACE_COMPOSITE_MODE"},{flag:32,failure:"TARGET_HAS_INVALID_COMPOSITING_STATE"},{flag:64,failure:"TARGET_HAS_INCOMPATIBLE_ANIMATIONS"},{flag:128,failure:"TARGET_HAS_CSS_OFFSET"},{flag:512,failure:"ANIMATION_AFFECTS_NON_CSS_PROPERTIES"},{flag:1024,failure:"TRANSFORM_RELATED_PROPERTY_CANNOT_BE_ACCELERATED_\
ON_TARGET"},{flag:2048,failure:"TRANSFROM_BOX_SIZE_DEPENDENT"},{flag:4096,failure:"FILTER_RELATED_PROPERTY_MAY_MOVE_PIXELS"},{flag:8192,failure:"UNSUPPORTED_CSS_PROPERTY"},{flag:32768,failure:"MIXED_KEYFRAME_VALUE_TYPES"},{flag:65536,failure:"TIMELINE_SOURCE_HAS_INVALID_COMPOSITING_STATE"},{flag:1<<17,failure:"ANIMATION_HAS_NO_VISIBLE_CHANGE"},{flag:1<<18,failure:"AFFECTS_IMPORTANT_PROPERTY"},{flag:1<<19,failure:"SVG_TARGET_HAS_INDEPENDENT_TRANSFORM_PROPERTY"}],_de=ue.secondsToMicro(O.Seconds(.5));i(a6,"isInRootCauseWindow");i(o6,"getNonCompositedFailure");i(Mde,"getNonCompositedFailureRootCauses");i(Ode,"getShiftsByPrePaintEvents");i(Q1,"getNextEvent");i(Nde,"getIframeRootCauses");i(Pde,"getUnsizedImageRootCauses");i(Lde,"getFontRootCauses");i(Bde,"getTopCulprits");i(Ude,"finalize");i(jde,"generateInsight")});var IE={};E(IE,{UIStrings:()=>yr,generateInsight:()=>Vde,i18nString:()=>Vo,isDocumentLatency:()=>Hde});function Hde(e){return e.insightKey==="DocumentLatency"}function Wde(e){if(!e.args.data.timing)return null;let n=ue.microToMilli(e.args.data.syntheticData.waiting);return Math.round(n)}function Gde(e){let t=[/^content-encoding$/i,/^x-content-encoding-over-network$/i],n=["gzip","br","deflate","zstd"];if(e.args.data.responseHeaders.some(s=>t.some(c=>s.name.match(c))&&n.includes(s.value)))return 0;let a=e.args.data.decodedBodyLength,o=0;switch(e.args.data.mimeType){case"text/css":o=Math.round(a*.8);break;case"text/html":case"text/javascript":o=Math.round(a*.67);break;case"text/plain":case"text/xml":case"text/x-component":case"application/javascript":case"application/json":case"application/manifest+json":case"application/vnd.api+json":case"application/xml":case"application/xhtml+xml":case"application/rss+xml":case"application/atom+xml":case"application/vnd.ms-fontobject":case"application/\
x-font-ttf":case"application/x-font-opentype":case"application/x-font-truetype":case"image/svg+xml":case"image/x-icon":case"image/vnd.microsoft.icon":case"font/ttf":case"font/eot":case"font/otf":case"font/opentype":o=Math.round(a*.5);break;default:}return o<zde?0:o}function kE(e){let t=!1;return e.data&&(t=!e.data.checklist.usesCompression.value||!e.data.checklist.serverResponseIsFast.value||!e.data.checklist.noRedirects.value),{insightKey:"DocumentLatency",strings:yr,title:Vo(yr.title),description:Vo(yr.description),category:At.ALL,state:t?"fail":"pass",...e}}function Vde(e,t){if(!t.navigation)return kE({});let n=e.NetworkRequests.byTime.find(f=>f.args.data.requestId===t.navigationId);if(!n)return kE({warnings:[gr.NO_DOCUMENT_REQUEST]});let r=Wde(n);if(r===null)throw new Error("missing document request timing");let a=r>i6,o=0;r>i6&&(o=Math.max(r-qde,0));let s=Math.round(n.args.data.syntheticData.redirectionDuration/1e3);o+=s;let c={FCP:o,LCP:o},u=Gde(n),l=s===0,m=!a,p=u===0;return kE(
{relatedEvents:[n],data:{serverResponseTime:r,redirectDuration:O.Milli(s),uncompressedResponseBytes:u,documentRequest:n,checklist:{noRedirects:{label:Vo(l?yr.passingRedirects:yr.failedRedirects),value:l},serverResponseIsFast:{label:Vo(m?yr.passingServerResponseTime:yr.failedServerResponseTime),value:m},usesCompression:{label:Vo(p?yr.passingTextCompression:yr.failedTextCompression),value:p}}},metricSavings:c})}var yr,Vo,i6,qde,zde,AE=g(()=>{d();ut();Pe();jn();yr={title:"Document request latency",description:"Your first network request is the most important.  Reduce its latency by avoiding redirects, ensuring a fast server response, and enabling text compression.",passingRedirects:"Avoids redirects",failedRedirects:"Had redirects",passingServerResponseTime:"Server responds quickly",failedServerResponseTime:"Server responded slowly",passingTextCompression:"Applies text compression",failedTextCompression:"No compression applied",redirectsLabel:"Redirects",serverResponseTimeLabel:"Server re\
sponse time",uncompressedDownload:"Uncompressed download"},Vo=i((e,t)=>({i18nId:e,values:t}),"i18nString"),i6=600,qde=100,zde=1400;i(Hde,"isDocumentLatency");i(Wde,"getServerResponseTime");i(Gde,"getCompressionSavings");i(kE,"finalize");i(Vde,"generateInsight")});var RE={};E(RE,{UIStrings:()=>vr,generateInsight:()=>Jde,i18nString:()=>FE});function Kde(e){let t=[...e.largeLayoutUpdates,...e.largeStyleRecalcs];return{insightKey:"DOMSize",strings:vr,title:FE(vr.title),description:FE(vr.description),category:At.INP,state:t.length>0?"fail":"pass",...e,relatedEvents:t}}function Jde(e,t){let n=i(l=>ue.eventIsInBounds(l,t.bounds),"isWithinContext"),r=t.navigation?.tid,a=[],o=[],s=Lu.threadsInRenderer(e.Renderer,e.AuctionWorklets);for(let l of s){if(l.type!=="MAIN_THREAD")continue;if(r===void 0){if(!l.processIsOnMainFrame)continue}else if(l.tid!==r)continue;let m=e.Renderer.processes.get(l.pid)?.threads.get(l.tid);if(!m)continue;let{entries:p,layoutEvents:f,updateLayoutTreeEvents:h}=m;if(!p.length)continue;let y=p[0],b=p[p.length-1],w=ue.traceWindowFromMicroSeconds(y.ts,O.Micro(b.ts+(b.dur??0)));if(ue.boundsIncludeTimeRange({timeRange:w,bounds:t.bounds})){for(let D of f){if(D.dur<s6||!n(D))continue;let{dirtyObjects:T}=D.args.beginData;T>$de&&a.push(D)}for(let D of h){
if(D.dur<s6||!n(D))continue;let{elementCount:T}=D.args;T>Yde&&o.push(D)}}}let c=e.DOMStats.domStatsByFrameId.get(t.frameId)?.filter(n)??[],u;for(let l of c){let m=t.navigation?.pid;m&&l.pid!==m||(!u||l.args.data.totalElements>u.args.data.totalElements)&&(u=l)}return Kde({largeLayoutUpdates:a,largeStyleRecalcs:o,maxDOMStats:u})}var vr,FE,s6,$de,Yde,_E=g(()=>{d();ia();ut();Pe();jn();vr={title:"Optimize DOM size",description:"A large DOM can increase the duration of style calculations and layout reflows, impacting page responsiveness. A large DOM will also increase memory usage. [Learn how to avoid an excessive DOM size](https://developer.chrome.com/docs/lighthouse/performance/dom-size/).",statistic:"Statistic",value:"Value",element:"Element",totalElements:"Total elements",maxDOMDepth:"DOM depth",maxChildren:"Most children"},FE=i((e,t)=>({i18nId:e,values:t}),"i18nString"),s6=ue.milliToMicro(O.Milli(40)),$de=100,Yde=300;i(Kde,"finalize");i(Jde,"generateInsight")});var OE={};E(OE,{UIStrings:()=>$o,generateInsight:()=>Zde,i18nString:()=>ME});function Xde(e){let t=e.scriptsWithDuplication.map(n=>n.request).filter(n=>!!n);return{insightKey:"DuplicatedJavaScript",strings:$o,title:ME($o.title),description:ME($o.description),category:At.LCP,state:e.duplication.values().next().value?"fail":"pass",relatedEvents:[...new Set(t)],...e}}function Zde(e,t){let n=e.Scripts.scripts.filter(o=>!t.navigation||o.frame!==t.frameId?!1:ue.timestampIsInBounds(t.bounds,o.ts)),r=$1.computeScriptDuplication({scripts:n}),a=[...r.values().flatMap(o=>o.duplicates.map(s=>s.script))];return Xde({duplication:r,scriptsWithDuplication:[...new Set(a)]})}var $o,ME,NE=g(()=>{d();Mm();ut();jn();$o={title:"Duplicated JavaScript",description:"Remove large, duplicate JavaScript modules from bundles to reduce unnecessary bytes consumed by network activity.",columnSource:"Source",columnResourceSize:"Resource size"},ME=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Xde,"finalize");i(Zde,"ge\
nerateInsight")});var LE={};E(LE,{UIStrings:()=>Yo,generateInsight:()=>eme,i18nString:()=>PE});function Qde(e){return{insightKey:"FontDisplay",strings:Yo,title:PE(Yo.title),description:PE(Yo.description),category:At.INP,state:e.fonts.find(t=>t.wastedTime>0)?"fail":"pass",...e}}function eme(e,t){let n=[];for(let a of e.LayoutShifts.remoteFonts){let o=a.beginRemoteFontLoadEvent;if(!ue.eventIsInBounds(o,t.bounds))continue;let s=`${o.pid}.${o.args.id}`,c=e.NetworkRequests.byId.get(s);if(!c||!/^(block|fallback|auto)$/.test(a.display))continue;let u=O.Micro(c.args.data.syntheticData.finishTime-c.args.data.syntheticData.sendStartTime),l=_u.floor(ue.microToMilli(u),1/5);l!==0&&(l=Math.min(l,3e3),n.push({name:a.name,request:c,display:a.display,wastedTime:l}))}n.sort((a,o)=>o.wastedTime-a.wastedTime);let r=Math.max(...n.map(a=>a.wastedTime));return Qde({relatedEvents:n.map(a=>a.request),fonts:n,metricSavings:{FCP:r}})}var Yo,PE,BE=g(()=>{d();dn();ut();Pe();jn();Yo={title:"Font display",description:"Consider setti\
ng [`font-display`](https://developer.chrome.com/blog/font-display) to `swap` or `optional` to ensure text is consistently visible. `swap` can be further optimized to mitigate layout shifts with [font metric overrides](https://developer.chrome.com/blog/font-fallbacks).",fontColumn:"Font",wastedTimeColumn:"Wasted time"},PE=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Qde,"finalize");i(eme,"generateInsight")});var jE={};E(jE,{UIStrings:()=>Yr,generateInsight:()=>ame,i18nString:()=>UE});function c6(e){return e.scriptId+":"+e.lineNumber+":"+e.columnNumber}function tme(e,t){let n=t.Renderer.entryToNode,r=new Map;if(e.length===0)return;for(let o of e){let s=n.get(o);if(!s)continue;let c=s.parent,u,l;for(;c;){let f=c.entry;if(C.isProfileCall(f))u=f.callFrame,l=f;else{C.isFunctionCall(f)&&f.args.data&&C.objectIsCallFrame(f.args.data)&&(u=f.args.data,l=f);break}c=c.parent}if(!u||!l)continue;let m=c6(u),p=Me.getWithDefault(r,m,()=>({topLevelFunctionCall:u,totalReflowTime:0,topLevelFunctionCallEvents:[]}));p.totalReflowTime+=o.dur??0,p.topLevelFunctionCallEvents.push(l)}let a;return r.forEach(o=>{(!a||o.totalReflowTime>a.totalReflowTime)&&(a=o)}),a}function nme(e){return{insightKey:"ForcedReflow",strings:Yr,title:UE(Yr.title),description:UE(Yr.description),category:At.ALL,state:e.aggregatedBottomUpData.length!==0?"fail":"pass",...e}}function rme(e,t){let n=Y1.get(e,t),r=We.getZeroIndexedStackTraceForEvent(
e);return n?.callFrames[0]??r?.[0]??null}function ame(e,t){let n=i(s=>We.frameIDForEvent(s)!==t.frameId?!1:ue.eventIsInBounds(s,t.bounds),"isWithinContext"),r=new Map,a=e.Warnings.perWarning.get("FORCED_REFLOW")?.filter(n)??[];for(let s of a){let c=rme(s,e),u=c?c6(c):"UNATTRIBUTED",l=Me.getWithDefault(r,u,()=>({bottomUpData:c,totalTime:0,relatedEvents:[]}));l.totalTime+=s.dur??0,l.relatedEvents.push(s)}let o=tme(a,e);return nme({relatedEvents:a,topLevelFunctionCallData:o,aggregatedBottomUpData:[...r.values()]})}var Yr,UE,qE=g(()=>{d();dn();Mm();ut();Pe();jn();Yr={title:"Forced reflow",description:"Many APIs, typically reading layout geometry, force the rendering engine to pause script execution in order to calculate the style and layout. Learn more about [forced reflow](https://developers.google.com/web/fundamentals/performance/rendering/avoid-large-complex-layouts-and-layout-thrashing#avoid-forced-synchronous-layouts) and its mitigations.",relatedStackTrace:"Stack trace",topTimeConsumingFunctionCall:"\
Top function call",totalReflowTime:"Total reflow time",unattributed:"Unattributed"},UE=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(c6,"getCallFrameId");i(tme,"getLargestTopLevelFunctionData");i(nme,"finalize");i(rme,"getBottomCallFrameForEvent");i(ame,"generateInsight")});var ty={};E(ty,{ImageOptimizationType:()=>Aa,UIStrings:()=>Or,generateInsight:()=>lme,getOptimizationMessage:()=>ey,getOptimizationMessageWithBytes:()=>l6,i18nString:()=>Xi});function ey(e){switch(e.type){case Aa.ADJUST_COMPRESSION:return Xi(Or.useCompression);case Aa.MODERN_FORMAT_OR_COMPRESSION:return Xi(Or.useModernFormat);case Aa.VIDEO_FORMAT:return Xi(Or.useVideoFormat);case Aa.RESPONSIVE_SIZE:return Xi(Or.useResponsiveSize,{PH1:`${e.fileDimensions.width}x${e.fileDimensions.height}`,PH2:`${e.displayDimensions.width}x${e.displayDimensions.height}`})}}function l6(e){let t=(r=>({__i18nBytes:r}))(e.byteSavings),n=ey(e);return Xi(Or.estimatedSavings,{PH1:n,PH2:t})}function cme(e){return{insightKey:"ImageDelivery",strings:Or,title:Xi(Or.title),description:Xi(Or.description),category:At.LCP,state:e.optimizableImages.length>0?"fail":"pass",...e,relatedEvents:new Map(e.optimizableImages.map(t=>[t.request,t.optimizations.map(l6)]))}}function ume(e){return Math.round(29.1*Math.log10(e.args.data.
decodedBodyLength)-100.7)/100}function zE(e){return{filePixels:e.args.data.srcWidth*e.args.data.srcHeight,displayedPixels:e.args.data.width*e.args.data.height}}function lme(e,t){let n=i(s=>ue.eventIsInBounds(s,t.bounds),"isWithinContext"),r=e.NetworkRequests.byTime.filter(n),a=[];for(let s of r){if(s.args.data.resourceType!=="Image"||s.args.data.mimeType==="image/svg+xml")continue;let c=s.args.data.redirects[0]?.url??s.args.data.url,u=e.ImagePainting.paintImageEventForUrl.get(c)?.filter(n);if(!u?.length)continue;let l=u.reduce((T,S)=>{let k=zE(T).displayedPixels,_=zE(S).displayedPixels;return k>_?T:S}),{filePixels:m,displayedPixels:p}=zE(l),f=Math.min(s.args.data.decodedBodyLength,s.args.data.encodedDataLength),h=f/m,y=[];if(s.args.data.mimeType==="image/gif"){if(f>ome){let T=ume(s),S=Math.round(f*T);y.push({type:Aa.VIDEO_FORMAT,byteSavings:S})}}else if(h>u6){let T=Math.round(u6*m),S=f-T;s.args.data.mimeType!=="image/webp"&&s.args.data.mimeType!=="image/avif"?y.push({type:Aa.MODERN_FORMAT_OR_COMPRESSION,
byteSavings:S}):y.push({type:Aa.ADJUST_COMPRESSION,byteSavings:S})}let b=Math.max(0,...y.map(T=>T.byteSavings)),w=b,D=1-p/m;if(D>0&&!l.args.data.isCSS){let T=Math.round(D*f);(!(l.args.data.isPicture||l.args.data.srcsetAttribute)||T>sme)&&(w+=Math.round(D*(f-b)),y.push({type:Aa.RESPONSIVE_SIZE,byteSavings:T,fileDimensions:{width:Math.round(l.args.data.srcWidth),height:Math.round(l.args.data.srcHeight)},displayDimensions:{width:Math.round(l.args.data.width),height:Math.round(l.args.data.height)}}))}y=y.filter(T=>T.byteSavings>ime),y.length>0&&a.push({request:s,largestImagePaint:l,optimizations:y,byteSavings:w})}let o=new Map;for(let s of a)o.set(s.request.args.data.requestId,s.byteSavings);return a.sort((s,c)=>c.byteSavings!==s.byteSavings?c.byteSavings-s.byteSavings:c.request.args.data.decodedBodyLength-s.request.args.data.decodedBodyLength),cme({optimizableImages:a,totalByteSavings:a.reduce((s,c)=>s+c.byteSavings,0),metricSavings:Nm(o,t)})}var Or,Xi,u6,ome,ime,sme,Aa,ny=g(()=>{d();ut();
Z1();jn();Or={title:"Improve image delivery",description:"Reducing the download time of images can improve the perceived load time of the page and LCP. [Learn more about optimizing image size](https://developer.chrome.com/docs/lighthouse/performance/uses-optimized-images/)",useCompression:"Increasing the image compression factor could improve this image's download size.",useModernFormat:"Using a modern image format (WebP, AVIF) or increasing the image compression could improve this image's download size.",useVideoFormat:"Using video formats instead of GIFs can improve the download size of animated content.",useResponsiveSize:"This image file is larger than it needs to be ({PH1}) for its displayed dimensions ({PH2}). Use responsive images to reduce the image download size.",optimizeFile:"Optimize file size",others:"{PH1} others",noOptimizableImages:"No optimizable images",estimatedSavings:"{PH1} (Est {PH2})"},Xi=i((e,t)=>({i18nId:e,values:t}),"i18nString"),u6=2*1/12,ome=100*1024,ime=4096,
sme=12288;(function(e){e.ADJUST_COMPRESSION="ADJUST_COMPRESSION",e.MODERN_FORMAT_OR_COMPRESSION="MODERN_FORMAT_OR_COMPRESSION",e.VIDEO_FORMAT="VIDEO_FORMAT",e.RESPONSIVE_SIZE="RESPONSIVE_SIZE"})(Aa||(Aa={}));i(ey,"getOptimizationMessage");i(l6,"getOptimizationMessageWithBytes");i(cme,"finalize");i(ume,"estimateGIFPercentSavings");i(zE,"getPixelCounts");i(lme,"generateInsight")});var WE={};E(WE,{UIStrings:()=>Kr,generateInsight:()=>dme,i18nString:()=>HE});function d6(e){return{insightKey:"InteractionToNextPaint",strings:Kr,title:HE(Kr.title),description:HE(Kr.description),category:At.INP,state:e.longestInteractionEvent?"informative":"pass",...e}}function dme(e,t){let n=e.UserInteractions.interactionEventsWithNoNesting.filter(s=>ue.eventIsInBounds(s,t.bounds));if(!n.length)return d6({});let r=new Map;for(let s of n){let c=s.interactionId,u=r.get(c);(!u||s.dur>u.dur)&&r.set(c,s)}let a=[...r.values()];a.sort((s,c)=>c.dur-s.dur);let o=Math.min(9,Math.floor(a.length/50));return d6({relatedEvents:[a[0]],longestInteractionEvent:a[0],highPercentileInteractionEvent:a[o]})}var Kr,HE,GE=g(()=>{d();ut();jn();Kr={description:"Start investigating with the longest phase. [Delays can be minimized](https://web.dev/articles/optimize-inp#optimize_interactions). To reduce processing duration, [optimize the main-thread costs](https://web.dev/articles/optimize-long-tasks), often JS.",
title:"INP by phase",phase:"Phase",duration:"Duration",inputDelay:"Input delay",processingDuration:"Processing duration",presentationDelay:"Presentation delay",noInteractions:"No interactions detected"},HE=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(d6,"finalize");i(dme,"generateInsight")});var VE={};E(VE,{UIStrings:()=>Jr,generateInsight:()=>pme,i18nString:()=>fc,isLCPDiscovery:()=>mme});function mme(e){return e.insightKey==="LCPDiscovery"}function Pm(e){let t=e.lcpEvent&&e.lcpRequest?[e.lcpEvent,e.lcpRequest]:[];return{insightKey:"LCPDiscovery",strings:Jr,title:fc(Jr.title),description:fc(Jr.description),category:At.LCP,state:e.lcpRequest&&e.checklist&&(!e.checklist.eagerlyLoaded.value||!e.checklist.requestDiscoverable.value||!e.checklist.priorityHinted.value)?"fail":"pass",...e,relatedEvents:t}}function pme(e,t){if(!t.navigation)return Pm({});let n=e.NetworkRequests,r=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId);if(!r)throw new Error("no frame metrics");let a=r.get(t.navigationId);if(!a)throw new Error("no navigation metrics");let s=a.get("LCP")?.event;if(!s||!C.isLargestContentfulPaintCandidate(s))return Pm({warnings:[gr.NO_LCP]});let c=n.byTime.find(w=>w.args.data.requestId===t.navigationId);if(!c)return Pm({warnings:[gr.NO_DOCUMENT_REQUEST]});let u=e.LargestImagePaint.
lcpRequestByNavigationId.get(t.navigationId);if(!u)return Pm({lcpEvent:s});let l=u.args.data.initiator?.url,m=u?.args.data.initiator?.type==="parser"&&c.args.data.url===l,p=u?.args.data.isLinkPreload||m,f=s.args.data?.loadingAttr,h=u?.args.data.fetchPriorityHint,y=c?.args.data.timing?ue.secondsToMicro(c.args.data.timing.requestTime)+ue.milliToMicro(c.args.data.timing.receiveHeadersStart):void 0,b=h==="high";return Pm({lcpEvent:s,lcpRequest:u,earliestDiscoveryTimeTs:y?O.Micro(y):void 0,checklist:{priorityHinted:{label:fc(b?Jr.fetchPriorityApplied:Jr.fetchPriorityShouldBeApplied),value:b},requestDiscoverable:{label:fc(Jr.requestDiscoverable),value:p},eagerlyLoaded:{label:fc(Jr.lazyLoadNotApplied),value:f!=="lazy"}}})}var Jr,fc,$E=g(()=>{d();ia();ut();Pe();jn();Jr={title:"LCP request discovery",description:"Optimize LCP by making the LCP image [discoverable](https://web.dev/articles/optimize-lcp#1_eliminate_resource_load_delay) from the HTML immediately, and [avoiding lazy-loading](https:\
//web.dev/articles/lcp-lazy-loading)",lcpLoadDelay:"LCP image loaded {PH1} after earliest start point.",fetchPriorityApplied:"fetchpriority=high applied",fetchPriorityShouldBeApplied:"fetchpriority=high should be applied",requestDiscoverable:"Request is discoverable in initial document",lazyLoadNotApplied:"lazy load not applied",noLcp:"No LCP detected",noLcpResource:"No LCP resource detected because the LCP is not an image"},fc=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(mme,"isLCPDiscovery");i(Pm,"finalize");i(pme,"generateInsight")});var KE={};E(KE,{UIStrings:()=>Nr,generateInsight:()=>hme,i18nString:()=>YE,isLCPPhases:()=>fme});function fme(e){return e.insightKey==="LCPPhases"}function m6(...e){return e.some(t=>Number.isNaN(t))}function p6(e,t,n,r){let a=t.args.data.timing;if(!a)throw new Error("no timing for document request");let o=ue.secondsToMicro(a.requestTime)+ue.milliToMicro(a.receiveHeadersStart),s=O.Micro(o-e.ts),c=ue.microToMilli(s),u=O.Milli(n-c);if(!r)return m6(c,u)?null:{ttfb:c,renderDelay:u};let l=O.Micro(r.ts-e.ts),m=ue.microToMilli(l),p=O.Micro(r.args.data.syntheticData.finishTime-e.ts),f=ue.microToMilli(p),h=O.Milli(m-c),y=O.Milli(f-m);return u=O.Milli(n-f),m6(c,h,y,u)?null:{ttfb:c,loadDelay:h,loadTime:y,renderDelay:u}}function Lm(e){let t=[];return e.lcpEvent&&t.push(e.lcpEvent),e.lcpRequest&&t.push(e.lcpRequest),{insightKey:"LCPPhases",strings:Nr,title:YE(Nr.title),description:YE(Nr.description),category:At.LCP,state:e.lcpEvent||e.lcpRequest?"informative":"pass",...e,relatedEvents:t}}function hme(e,t){
if(!t.navigation)return Lm({});let n=e.NetworkRequests,r=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId);if(!r)throw new Error("no frame metrics");let a=r.get(t.navigationId);if(!a)throw new Error("no navigation metrics");let o=a.get("LCP"),s=o?.event;if(!s||!C.isLargestContentfulPaintCandidate(s))return Lm({warnings:[gr.NO_LCP]});let c=ue.microToMilli(o.timing),u=o.event?.ts?ue.microToMilli(o.event?.ts):void 0,l=e.LargestImagePaint.lcpRequestByNavigationId.get(t.navigationId),m=n.byTime.find(p=>p.args.data.requestId===t.navigationId);return Lm(m?l?{lcpMs:c,lcpTs:u,lcpEvent:s,lcpRequest:l,phases:p6(t.navigation,m,c,l)??void 0}:{lcpMs:c,lcpTs:u,lcpEvent:s,lcpRequest:l,phases:p6(t.navigation,m,c,l)??void 0}:{lcpMs:c,lcpTs:u,lcpEvent:s,lcpRequest:l,warnings:[gr.NO_DOCUMENT_REQUEST]})}var Nr,YE,JE=g(()=>{d();ia();ut();Pe();jn();Nr={title:"LCP by phase",description:"Each [phase has specific improvement strategies](https://web.dev/articles/optimize-lcp#lcp-breakdown). Ideally, most of\
 the LCP time should be spent on loading the resources, not within delays.",timeToFirstByte:"Time to first byte",resourceLoadDelay:"Resource load delay",resourceLoadDuration:"Resource load duration",elementRenderDelay:"Element render delay",phase:"Phase",duration:"Duration",fieldDuration:"Field 75th percentile",noLcp:"No LCP detected"},YE=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(fme,"isLCPPhases");i(m6,"anyValuesNaN");i(p6,"breakdownPhases");i(Lm,"finalize");i(hme,"generateInsight")});var XE={};E(XE,{UIStrings:()=>oo,generateInsight:()=>yme,i18nString:()=>ry});function f6(e){return{insightKey:"NetworkDependencyTree",strings:oo,title:ry(oo.title),description:ry(oo.description),category:At.LCP,state:e.fail?"fail":"pass",...e}}function h6(e,t){if(e.args.data.requestId===t.navigationId)return!0;if(e.args.data.isLinkPreload)return!1;let n=e.args.data.resourceType==="Document"&&e.args.data.frame!==t.frameId;if(gme.has(e.args.data.resourceType)||n||e.args.data.mimeType.startsWith("image/")||!(e.args.data.initiator?.url||We.getZeroIndexedStackTraceForEvent(e)?.at(0)?.url))return!1;let a=Rr.isSyntheticNetworkRequestEventRenderBlocking(e);return Rr.isSyntheticNetworkRequestHighPriority(e)||a}function yme(e,t){if(!t.navigation)return f6({rootNodes:[],maxTime:O.Micro(0),fail:!1});let n=[],r=new Map,a=O.Micro(0),o=!1,s=[];function c(m){if(m.length===0)return;m.length>=2&&(o=!0);let p=m[0],f=m[m.length-1],h=O.Micro(f.ts+f.dur-p.ts);h>a&&(a=h,s=m);let y=n;for(let b=0;b<m.length;++b){
let w=m[b],D=y.find(T=>T.request===w);if(!D){let T=O.Micro(w.ts+w.dur-p.ts);D={request:w,timeFromInitialRequest:T,children:[],relatedRequests:new Set},y.push(D)}m.forEach(T=>D?.relatedRequests.add(T)),r.set(w,b<2?[]:[ry(oo.warningDescription)]),y=D.children}}i(c,"addChain");let u=new Set;function l(m){return m.getDependents().filter(p=>p.getDependencies().every(f=>u.has(f)))}if(i(l,"getNextNodes"),t.lantern?.graph.traverse((m,p)=>{if(u.add(m),m.type!=="network"||!h6(m.rawRequest,t))return;let h=p.filter(y=>y.type==="network").reverse().map(y=>y.rawRequest);h.some(y=>!h6(y,t))||m.isNonNetworkProtocol||c(h)},l),s.length>0){let m=n;for(let p of s){let f=m.find(h=>h.request===p);f?(f.isLongest=!0,m=f.children):console.error("Some request in the longest chain is not found")}}return f6({rootNodes:n,maxTime:a,fail:o,relatedEvents:r})}var oo,ry,gme,ZE=g(()=>{d();ut();Pe();jn();oo={title:"Network dependency tree",description:"[Avoid chaining critical requests](https://developer.chrome.com/docs/\
lighthouse/performance/critical-request-chains) by reducing the length of chains, reducing the download size of resources, or deferring the download of unnecessary resources to improve page load.",warningDescription:"Avoid chaining critical requests by reducing the length of chains, reducing the download size of resources, or deferring the download of unnecessary resources to improve page load.",noNetworkDependencyTree:"No rendering tasks impacted by network dependencies",maxCriticalPathLatency:"Max critical path latency:"},ry=i((e,t)=>({i18nId:e,values:t}),"i18nString"),gme=new Set(["Image","XHR","Fetch","EventSource"]);i(f6,"finalize");i(h6,"isCritical");i(yme,"generateInsight")});var tT={};E(tT,{UIStrings:()=>Ko,generateInsight:()=>Tme,i18nString:()=>eT,isRenderBlocking:()=>vme});function vme(e){return e.insightKey==="RenderBlocking"}function wme(e){let t=new Map;for(let[n,r]of e)n.type==="network"&&t.set(n.request.requestId,{node:n,nodeTiming:r});return t}function xme(e,t){let n=t.simulator,r=t.metrics.firstContentfulPaint.optimisticGraph,{nodeTimings:a}=t.simulator.simulate(r),o=new Map(a),s=0,c=r.cloneWithRelationships(f=>!e.has(f.id));if(c.type!=="network")throw new Error("minimalFCPGraph not a NetworkNode");let u=Math.max(...Array.from(Array.from(o).map(f=>f[1].endTime))),l=c.request.transferSize,m=l||0;c.request.transferSize=m+s;let p=n.simulate(c).timeInMs;return c.request.transferSize=l,Math.round(Math.max(u-p,0))}function Dme(e,t){return e.LargestImagePaint.lcpRequestByNavigationId.has(t.navigationId)}function Eme(e,t,n){if(!t.lantern)return;let r=wme(t.lantern.metrics.firstContentfulPaint.optimisticEstimate.nodeTimings),a={FCP:0,LCP:0},o=new Map,s=new Set;
for(let c of n){let u=r.get(c.args.data.requestId);if(!u)continue;let{node:l,nodeTiming:m}=u;l.traverse(f=>s.add(f.id));let p=Math.round(m.duration);p<bme||o.set(l.id,p)}return o.size&&(a.FCP=xme(s,t.lantern),Dme(e,t)||(a.LCP=a.FCP)),{metricSavings:a,requestIdToWastedMs:o}}function QE(e){return{insightKey:"RenderBlocking",strings:Ko,title:eT(Ko.title),description:eT(Ko.description),category:At.LCP,state:e.renderBlockingRequests.length>0?"fail":"pass",...e}}function Tme(e,t){if(!t.navigation)return QE({renderBlockingRequests:[]});let n=e.PageLoadMetrics.metricScoresByFrameId.get(t.frameId)?.get(t.navigationId)?.get("FP")?.event?.ts;if(!n)return QE({renderBlockingRequests:[],warnings:[gr.NO_FP]});let r=[];for(let o of e.NetworkRequests.byTime){if(o.args.data.frame!==t.frameId||!Rr.isSyntheticNetworkRequestEventRenderBlocking(o)||o.args.data.syntheticData.finishTime>n)continue;if(o.args.data.renderBlocking==="in_body_parser_blocking"){let c=o.args.data.priority,l=o.args.data.resourceType===
"Script"&&c==="High";if(c!=="VeryHigh"&&!l)continue}We.getNavigationForTraceEvent(o,t.frameId,e.Meta.navigationsByFrameId)===t.navigation&&r.push(o)}let a=Eme(e,t,r);return r=r.sort((o,s)=>s.dur-o.dur),QE({relatedEvents:r,renderBlockingRequests:r,...a})}var Ko,eT,bme,nT=g(()=>{d();ia();ut();jn();Ko={title:"Render blocking requests",description:"Requests are blocking the page's initial render, which may delay LCP. [Deferring or inlining](https://web.dev/learn/performance/understanding-the-critical-path#render-blocking_resources/) can move these network requests out of the critical path.",renderBlockingRequest:"Request",duration:"Duration",noRenderBlocking:"No render blocking requests for this navigation"},eT=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(vme,"isRenderBlocking");bme=50;i(wme,"getNodesAndTimingByRequestId");i(xme,"estimateSavingsWithGraphs");i(Dme,"hasImageLCP");i(Eme,"computeSavings");i(QE,"finalize");i(Tme,"generateInsight")});var aT={};E(aT,{UIStrings:()=>Jo,generateInsight:()=>kme,i18nString:()=>rT});function Sme(e,t){let n=new Map;for(let[r,a]of e)if(r.args.beginData?.frame===t.frameId&&ue.eventIsInBounds(r,t.bounds))for(let o of a.timings){let s=o[Tn.Selector]+"_"+o[Tn.StyleSheetId],c=n.get(s);c!==void 0?(c[Tn.Elapsed]+=o[Tn.Elapsed],c[Tn.FastRejectCount]+=o[Tn.FastRejectCount],c[Tn.MatchAttempts]+=o[Tn.MatchAttempts],c[Tn.MatchCount]+=o[Tn.MatchCount]):n.set(s,{...o})}return[...n.values()]}function Cme(e){return{insightKey:"SlowCSSSelector",strings:Jo,title:rT(Jo.title),description:rT(Jo.description),category:At.ALL,state:e.topElapsedMs.length!==0&&e.topMatchAttempts.length!==0?"informative":"pass",...e}}function kme(e,t){let n=e.SelectorStats;if(!n)throw new Error("no selector stats data");let r=Sme(n.dataForUpdateLayoutEvent,t),a=0,o=0,s=0;r.map(l=>{a+=l[Tn.Elapsed],o+=l[Tn.MatchAttempts],s+=l[Tn.MatchCount]});let c=[...r].sort((l,m)=>m[Tn.Elapsed]-l[Tn.Elapsed]),u=[...r].sort((l,m)=>m[Tn.MatchAttempts]-
l[Tn.MatchAttempts]);return Cme({relatedEvents:[],totalElapsedMs:O.Milli(a/1e3),totalMatchAttempts:o,totalMatchCount:s,topElapsedMs:c.slice(0,3),topMatchAttempts:u.slice(0,3)})}var Jo,rT,oT=g(()=>{d();ut();Lg();Pe();jn();Jo={title:"CSS Selector costs",description:"If Recalculate Style costs remain high, selector optimization can reduce them. [Optimize the selectors](https://developer.chrome.com/docs/devtools/performance/selector-stats) with both high elapsed time and high slow-path %. Simpler selectors, fewer selectors, a smaller DOM, and a shallower DOM will all reduce matching costs.",matchAttempts:"Match attempts",matchCount:"Match count",elapsed:"Elapsed time",topSelectors:"Top selectors",total:"Total",enableSelectorData:"No CSS selector data was found. CSS selector stats need to be enabled in the performance panel settings."},rT=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Sme,"aggregateSelectorStats");i(Cme,"finalize");i(kme,"generateInsight")});var sT={};E(sT,{UIStrings:()=>sa,generateInsight:()=>Fme,i18nString:()=>iT});function Ime(e,t){let n=[];for(let[r,a]of e.eventsByEntity.entries())r!==t&&n.push(...a);return n}function Ame(e){return{insightKey:"ThirdParties",strings:sa,title:iT(sa.title),description:iT(sa.description),category:At.ALL,state:[...e.summaryByEntity.entries()].find(t=>t[0]!==e.firstPartyEntity)?"informative":"pass",...e}}function Fme(e,t){let n=e.NetworkRequests.byTime.filter(s=>!t.navigation||s.args.data.frame!==t.frameId?!1:ue.eventIsInBounds(s,t.bounds)),r=V1.summarizeThirdParties(e,t.bounds,n),a=t.navigation?.args.data?.documentLoaderURL??e.Meta.mainFrameURL,o=Gi.default.getEntity(a)||eo.makeUpEntity(r.madeUpEntityCache,a);return Ame({relatedEvents:Ime(r,o),eventsByEntity:r.eventsByEntity,summaryByEntity:r.byEntity,summaryByUrl:r.byUrl,urlsByEntity:r.urlsByEntity,firstPartyEntity:o})}var sa,iT,cT=g(()=>{d();Pg();Mm();ia();ut();jn();sa={title:"3rd parties",description:"3rd party code can significantly imp\
act load performance. [Reduce and defer loading of 3rd party code](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/loading-third-party-javascript/) to prioritize your page's content.",columnThirdParty:"3rd party",columnTransferSize:"Transfer size",columnMainThreadTime:"Main thread time",noThirdParties:"No third parties found"},iT=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(Ime,"getRelatedEvents");i(Ame,"finalize");i(Fme,"generateInsight")});var lT={};E(lT,{UIStrings:()=>Fa,cachingDisabled:()=>b6,computeCacheLifetimeInSeconds:()=>y6,generateInsight:()=>Ome,getCombinedHeaders:()=>v6,i18nString:()=>uT,isCacheable:()=>g6});function _me(e){return{insightKey:"UseCache",strings:Fa,title:uT(Fa.title),description:uT(Fa.description),category:At.ALL,state:e.requests.length>0?"fail":"pass",...e}}function g6(e){return Rr.NON_NETWORK_SCHEMES.includes(e.args.data.protocol)?!1:!!(Rr.CACHEABLE_STATUS_CODES.has(e.args.data.statusCode)&&Rr.STATIC_RESOURCE_TYPES.has(e.args.data.resourceType||"Other"))}function y6(e,t){if(t?.["max-age"]!==void 0)return t["max-age"];let n=e.find(r=>r.name==="expires")?.value??null;if(n){let r=new Date(n).getTime();return r?Math.ceil((r-Date.now())/1e3):0}return null}function Mme(e){let t=[0,.2,1,3,8,12,24,48,72,168,8760,1/0],n=e/3600,r=t.findIndex(u=>u>=n);if(r===t.length-1)return 1;if(r===0)return 0;let a=t[r],o=t[r-1],s=r/10,c=(r-1)/10;return DE(o,c,a,s,n)}function v6(e){let t=new Map;for(let n of e){let r=n.
name.toLowerCase();t.get(r)?t.set(r,`${t.get(r)}, ${n.value}`):t.set(r,n.value)}return t}function b6(e,t){let n=e?.get("cache-control")??null,r=e?.get("pragma")??null;return!!(!n&&r?.includes("no-cache")||t&&(t["must-revalidate"]||t["no-cache"]||t["no-store"]||t.private))}function Ome(e,t){let n=[],r=e.NetworkRequests.byTime,a=0,o=new Map;for(let s of r){if(!g6(s))continue;let c=v6(s.args.data.responseHeaders),u=c.get("cache-control")??null,l=Rr.parseCacheControl(u);if(b6(c,l))continue;let m=y6(s.args.data.responseHeaders,l);if(m!==null&&(!Number.isFinite(m)||m<=0))continue;m=m||0;let p=Mme(m);if(p>Rme)continue;let f=s.args.data.encodedDataLength||0,h=(1-p)*f;o.set(s.args.data.requestId,h),a+=h,n.push({request:s,ttl:m,wastedBytes:h})}return n.sort((s,c)=>c.request.args.data.decodedBodyLength-s.request.args.data.decodedBodyLength||s.ttl-c.ttl),_me({relatedEvents:n.map(s=>s.request),requests:n,metricSavings:Nm(o,t),totalWastedBytes:a})}var Fa,uT,Rme,dT=g(()=>{d();ut();Z1();J1();jn();Fa={
title:"Use efficient cache lifetimes",description:"A long cache lifetime can speed up repeat visits to your page. [Learn more](https://web.dev/uses-long-cache-ttl/).",requestColumn:"Request",cacheTTL:"Cache TTL",noRequestsToCache:"No requests with inefficient cache policies",others:"{PH1} others"},uT=i((e,t)=>({i18nId:e,values:t}),"i18nString"),Rme=.925;i(_me,"finalize");i(g6,"isCacheable");i(y6,"computeCacheLifetimeInSeconds");i(Mme,"getCacheHitProbability");i(v6,"getCombinedHeaders");i(b6,"cachingDisabled");i(Ome,"generateInsight")});var fT={};E(fT,{UIStrings:()=>Xo,generateInsight:()=>Nme,i18nString:()=>pT});function mT(e){return{insightKey:"Viewport",strings:Xo,title:pT(Xo.title),description:pT(Xo.description),category:At.INP,state:e.mobileOptimized===!1?"fail":"pass",...e}}function Nme(e,t){let n=e.UserInteractions.parseMetaViewportEvents.find(a=>a.args.data.frame!==t.frameId?!1:ue.eventIsInBounds(a,t.bounds)),r=e.UserInteractions.beginCommitCompositorFrameEvents.filter(a=>a.args.frame!==t.frameId||n&&a.ts<n.ts?!1:ue.eventIsInBounds(a,t.bounds));if(!r.length)return mT({mobileOptimized:null,warnings:[gr.NO_LAYOUT]});for(let a of r)if(!a.args.is_mobile_optimized)return mT({mobileOptimized:!1,viewportEvent:n,metricSavings:{INP:300}});return mT({mobileOptimized:!0,viewportEvent:n})}var Xo,pT,hT=g(()=>{d();ut();jn();Xo={title:"Optimize viewport for mobile",description:"Tap interactions may be [delayed by up to 300 ms](https://developer.chrome.com/blog/300ms-tap-delay-gone-away/) if the viewport is not optimized for m\
obile."},pT=i((e,t)=>({i18nId:e,values:t}),"i18nString");i(mT,"finalize");i(Nme,"generateInsight")});var Bm={};E(Bm,{CLSCulprits:()=>SE,DOMSize:()=>RE,DocumentLatency:()=>IE,DuplicatedJavaScript:()=>OE,FontDisplay:()=>LE,ForcedReflow:()=>jE,ImageDelivery:()=>ty,InteractionToNextPaint:()=>WE,LCPDiscovery:()=>VE,LCPPhases:()=>KE,NetworkDependencyTree:()=>XE,RenderBlocking:()=>tT,SlowCSSSelector:()=>aT,ThirdParties:()=>sT,UseCache:()=>lT,Viewport:()=>fT});var w6=g(()=>{d();CE();AE();_E();NE();BE();qE();ny();GE();$E();JE();ZE();nT();oT();cT();dT();hT()});var Um={};E(Um,{Common:()=>Mr,Models:()=>Bm,Statistics:()=>EE,Types:()=>TE});var gT=g(()=>{d();Z1();w6();J1();jn()});var Zo={};E(Zo,{createGraph:()=>bT,createNetworkRequests:()=>vT,createProcessedNavigation:()=>yT});function yT(e,t,n){let r=e.PageLoadMetrics.metricScoresByFrameId.get(t);if(!r)throw new Lt.LanternError("missing metric scores for frame");let a=r.get(n);if(!a)throw new Lt.LanternError("missing metric scores for specified navigation");let o=i(c=>{let u=a.get(c);if(u?.event)return u.event.ts},"getTimestampOrUndefined");return{timestamps:{firstContentfulPaint:i(c=>{let u=a.get(c);if(!u?.event)throw new Lt.LanternError(`missing metric: ${c}`);return u.event.ts},"getTimestamp")("FCP"),largestContentfulPaint:o("LCP")}}}function x6(e){return typeof e=="string"&&(e=new URL(e)),{scheme:e.protocol.split(":")[0],host:e.hostname,securityOrigin:e.origin}}function Pme(e){let t=new Map,n=["ServiceWorker thread","DedicatedWorker thread"];for(let r of e.traceEvents){if(r.name!=="thread_name"||!r.args.name||!n.includes(r.args.name))continue;let a=t.get(r.pid);a?a.push(r.tid):t.set(r.pid,[r.tid])}return t}
function Lme(e,t,n){if(n.args.data.connectionId===void 0||n.args.data.connectionReused===void 0)throw new Lt.LanternError("Trace is too old");let r;try{r=new URL(n.args.data.url)}catch{return}let a=n.args.data.timing?{workerFetchStart:-1,workerRespondWithSettled:-1,...n.args.data.timing}:void 0,o=a?a.requestTime*1e3:n.args.data.syntheticData.downloadStart/1e3,s=!1;t.get(n.pid)?.includes(n.tid)&&(s=!0),e.Workers.workerIdByThread.has(n.tid)&&(s=!0);let u=n.args.data.initiator??{type:"other"};if(n.args.data.stackTrace){let p=n.args.data.stackTrace.map(f=>({scriptId:String(f.scriptId),url:f.url,lineNumber:f.lineNumber-1,columnNumber:f.columnNumber-1,functionName:f.functionName}));u.stack={callFrames:p}}let l=n.args.data.resourceType;n.args.data.initiator?.fetchType==="xmlhttprequest"?l="XHR":n.args.data.initiator?.fetchType==="fetch"&&(l="Fetch");let m=n.args.data.decodedBodyLength??0;if(r.protocol==="data:"&&m===0){let p=r.pathname.indexOf(",");r.pathname.substring(0,p).includes(";base64")?
m=atob(r.pathname.substring(p+1)).length:m=r.pathname.length-p-1}return{rawRequest:n,requestId:n.args.data.requestId,connectionId:n.args.data.connectionId,connectionReused:n.args.data.connectionReused,url:n.args.data.url,protocol:n.args.data.protocol,parsedURL:x6(r),documentURL:n.args.data.requestingFrameUrl,rendererStartTime:n.ts/1e3,networkRequestTime:o,responseHeadersEndTime:n.args.data.syntheticData.downloadStart/1e3,networkEndTime:n.args.data.syntheticData.finishTime/1e3,transferSize:n.args.data.encodedDataLength,resourceSize:m,fromDiskCache:n.args.data.syntheticData.isDiskCached,fromMemoryCache:n.args.data.syntheticData.isMemoryCached,isLinkPreload:n.args.data.isLinkPreload,finished:n.args.data.finished,failed:n.args.data.failed,statusCode:n.args.data.statusCode,initiator:u,timing:a,resourceType:l,mimeType:n.args.data.mimeType,priority:n.args.data.priority,frameId:n.args.data.frame,fromWorker:s,redirects:void 0,redirectSource:void 0,redirectDestination:void 0,initiatorRequest:void 0}}
function Bme(e,t){if(e.redirectSource)return e.redirectSource;let n=Cn.PageDependencyGraph.getNetworkInitiators(e)[0],r=t.get(n)||[];if(r=r.filter(a=>a.responseHeadersEndTime<=e.rendererStartTime&&a.finished&&!a.failed),r.length>1){let a=r.filter(o=>o.resourceType!==Jd.NetworkRequestTypes.Other);a.length&&(r=a)}if(r.length>1){let a=r.filter(o=>o.frameId===e.frameId);a.length&&(r=a)}if(r.length>1&&e.initiator.type==="parser"){let a=r.filter(o=>o.resourceType===Jd.NetworkRequestTypes.Document);a.length&&(r=a)}if(r.length>1){let a=r.filter(o=>o.isLinkPreload);if(a.length){let o=r.filter(c=>!c.isLinkPreload),s=o.every(c=>c.fromDiskCache||c.fromMemoryCache);o.length&&s&&(r=a)}}return r.length===1?r[0]:null}function Ume(e){let t=new Map;for(let n of e){let r=t.get(n.url)||[];r.push(n),t.set(n.url,r)}for(let n of e){let r=Bme(n,t);r&&(n.initiatorRequest=r)}}function vT(e,t,n=0,r=Number.POSITIVE_INFINITY){let a=Pme(e),o=[];for(let s of t.NetworkRequests.byTime)if(s.ts>=n&&s.ts<r){let c=Lme(t,a,
s);c&&o.push(c)}for(let s of[...o]){if(!s.rawRequest)continue;let c=s.rawRequest.args.data.redirects;if(!c.length)continue;let u=[];for(let l of c){let m=structuredClone(s);m.networkRequestTime=l.ts/1e3,m.rendererStartTime=m.networkRequestTime,m.networkEndTime=(l.ts+l.dur)/1e3,m.responseHeadersEndTime=m.networkEndTime,m.timing={requestTime:m.networkRequestTime/1e3,receiveHeadersStart:m.responseHeadersEndTime,receiveHeadersEnd:m.responseHeadersEndTime,proxyStart:-1,proxyEnd:-1,dnsStart:-1,dnsEnd:-1,connectStart:-1,connectEnd:-1,sslStart:-1,sslEnd:-1,sendStart:-1,sendEnd:-1,workerStart:-1,workerReady:-1,workerFetchStart:-1,workerRespondWithSettled:-1,pushStart:-1,pushEnd:-1},m.url=l.url,m.parsedURL=x6(l.url),m.statusCode=302,m.resourceType=void 0,m.transferSize=400,u.push(m),o.push(m)}u.push(s);for(let l=0;l<u.length;l++){let m=u[l];l>0&&(m.redirectSource=u[l-1],m.redirects=u.slice(0,l)),l!==u.length-1&&(m.redirectDestination=u[l+1])}for(let l=1;l<u.length;l++)u[l].requestId=`${u[l-1].requestId}\
:redirect`}return Ume(o),o.sort((s,c)=>s.rendererStartTime-c.rendererStartTime)}function jme(e,t){let n=t.Meta,r=n.mainFrameNavigations.length?new Set(n.mainFrameNavigations.map(o=>o.pid)):n.topLevelRendererIds,a=new Map;for(let o of r){let s=n.threadsInProcess.get(o)??[],c=!1;for(let[u,l]of s)if(l.args.name==="CrRendererMain"){a.set(o,u),c=!0;break}if(!c){for(let[u,l]of s)if(l.args.name==="CrBrowserMain"){a.set(o,u),c=!0;break}}}return e.traceEvents.filter(o=>a.get(o.pid)===o.tid)}function bT(e,t,n,r){let a=jme(t,n);if(!r){r={requestedUrl:e[0].url,mainDocumentUrl:""};let o=e[0];for(;o.redirectDestination;)o=o.redirectDestination;r.mainDocumentUrl=o.url}return Cn.PageDependencyGraph.createGraph(a,e,r)}var wT=g(()=>{d();ia();Xd();i(yT,"createProcessedNavigation");i(x6,"createParsedUrl");i(Pme,"findWorkerThreads");i(Lme,"createLanternRequest");i(Bme,"chooseInitiatorRequest");i(Ume,"linkInitiators");i(vT,"createNetworkRequests");i(jme,"collectMainThreadEvents");i(bT,"createGraph")});var oy={};E(oy,{TraceParseProgressEvent:()=>hc,TraceProcessor:()=>ay,sortHandlers:()=>E6});function D6(e,t){return t===.8?e*(.8-.2)+.2:e*t}function E6(e){let t=new Map,n=new Set,r=i(a=>{if(t.has(a))return;if(n.has(a)){let c="";for(let u of n)(c||u===a)&&(c+=`${u}->`);throw c+=a,new Error(`Found dependency cycle in trace event handlers: ${c}`)}n.add(a);let o=e[a];if(!o)return;let s=o.deps?.();s&&s.forEach(r),t.set(a,o)},"visitHandler");for(let a of Object.keys(e))r(a);return t}var hc,ay,xT=g(()=>{d();ia();ut();gT();Xd();wT();Pe();hc=class e extends Event{static{i(this,"TraceParseProgressEvent")}data;static eventName="traceparseprogress";constructor(t,n={bubbles:!0}){super(e.eventName,n),this.data=t}};i(D6,"calculateProgress");ay=class e extends EventTarget{static{i(this,"TraceProcessor")}#e;#t="IDLE";#o=Qa.defaults();#r=null;#a=null;static createWithAllHandlers(){return new e(ro,Qa.defaults())}static getInsightRunners(){return{...Bm}}constructor(t,n){super(),this.#i(t),this.#e={Meta:ro.
Meta,...t},n&&(this.#o=n),this.#u()}#u(){for(let t of Object.values(this.#e))"handleUserConfig"in t&&t.handleUserConfig&&t.handleUserConfig(this.#o)}#i(t){if(Object.keys(t).length===Object.keys(ro).length)return;let n=new Set;for(let[a,o]of Object.entries(t)){n.add(a);let s="deps"in o?o.deps():[];for(let c of s)n.add(c)}let r=new Set(Object.keys(t));n.delete("Meta");for(let a of n)if(!r.has(a))throw new Error(`Required handler ${a} not provided.`)}reset(){if(this.#t==="PARSING")throw new Error("Trace processor can't reset while parsing.");let t=Object.values(this.#e);for(let n of t)n.reset();this.#r=null,this.#a=null,this.#t="IDLE"}async parse(t,n){if(this.#t!=="IDLE")throw new Error(`Trace processor can't start parsing when not idle. Current state: ${this.#t}`);n.logger?.start("total");try{this.#t="PARSING",n.logger?.start("parse"),await this.#n(t,n),n.logger?.end("parse"),this.#r&&!n.isCPUProfile&&(n.logger?.start("insights"),this.#l(this.#r,t,n),n.logger?.end("insights")),this.#t="F\
INISHED_PARSING"}catch(r){throw this.#t="ERRORED_WHILE_PARSING",r}finally{n.logger?.end("total")}}async#n(t,n){let a=[...E6(this.#e).entries()];for(let[,c]of a)c.reset();n.logger?.start("parse:handleEvent");for(let c=0;c<t.length;++c){if(c%5e4===0&&c){let l=D6(c/t.length,.2);this.dispatchEvent(new hc({percent:l})),await new Promise(m=>setTimeout(m,0))}let u=t[c];for(let l=0;l<a.length;++l){let[,m]=a[l];m.handleEvent(u)}}n.logger?.end("parse:handleEvent");for(let c=0;c<a.length;c++){let[u,l]=a[c];l.finalize&&(n.logger?.start(`parse:${u}:finalize`),await new Promise(p=>setTimeout(p,0)),await l.finalize(n),n.logger?.end(`parse:${u}:finalize`));let m=D6(c/a.length,.8);this.dispatchEvent(new hc({percent:m}))}let o=i((c,u=!0)=>{if(c instanceof Map)return new Map(c);if(c instanceof Set)return new Set(c);if(Array.isArray(c))return[...c];if(typeof c=="object"&&c&&u){let l={};for(let[m,p]of Object.entries(c))l[m]=o(p,!1);return l}return c},"shallowClone");n.logger?.start("parse:clone");let s={};
for(let[c,u]of Object.entries(this.#e)){let l=o(u.data());Object.assign(s,{[c]:l})}n.logger?.end("parse:clone"),this.dispatchEvent(new hc({percent:1})),this.#r=s}get parsedTrace(){return this.#t!=="FINISHED_PARSING"?null:this.#r}get insights(){return this.#t!=="FINISHED_PARSING"?null:this.#a}#c(t,n,r,a,o){if(!t.NetworkRequests||!t.Workers||!t.PageLoadMetrics)return;if(!t.NetworkRequests.byTime.length)throw new Lt.LanternError("No network requests found in trace");let s=t.Meta.navigationsByFrameId.get(r),c=s?.findIndex(oe=>oe.args.data?.navigationId===a);if(!s||c===void 0||c===-1)throw new Lt.LanternError("Could not find navigation start");let u=s[c].ts,l=c+1<s.length?s[c+1].ts:Number.POSITIVE_INFINITY,p={traceEvents:n.filter(oe=>oe.ts>=u&&oe.ts<l)},f=vT(p,t,u,l),h=bT(f,p,t),y=yT(t,r,a),b=Lt.NetworkAnalyzer.analyze(f);if(!b)return;let w={networkAnalysis:b,throttlingMethod:"provided",...o.lanternSettings},D=Ho.Simulator.createSimulator(w),T={graph:h,simulator:D,processedNavigation:y},S=pn.
FirstContentfulPaint.compute(T),k=pn.LargestContentfulPaint.compute(T,{fcpResult:S}),_=pn.Interactive.compute(T,{lcpResult:k}),Y=pn.TotalBlockingTime.compute(T,{fcpResult:S,interactiveResult:_});return{graph:h,simulator:D,metrics:{firstContentfulPaint:S,interactive:_,largestContentfulPaint:k,totalBlockingTime:Y}}}sortInsightSet(t,n,r){let a={InteractionToNextPaint:null,LCPPhases:null,LCPDiscovery:null,CLSCulprits:null,RenderBlocking:null,NetworkDependencyTree:null,ImageDelivery:null,DocumentLatency:null,FontDisplay:null,Viewport:null,DOMSize:null,ThirdParties:null,DuplicatedJavaScript:null,SlowCSSSelector:null,ForcedReflow:null,UseCache:null},o=Mr.calculateMetricWeightsForSorting(n,r),s=Mr.getLCP(t,n.id)?.value,c=Mr.getCLS(t,n.id).value,u=Mr.getINP(t,n.id)?.value??200,l=s!==void 0?Mr.evaluateLCPMetricScore(s):void 0,m=Mr.evaluateINPMetricScore(u),p=Mr.evaluateCLSMetricScore(c),f=new Map;for(let[w,D]of Object.entries(n.model)){let T=D.metricSavings?.LCP??0,S=D.metricSavings?.INP??0,k=D.
metricSavings?.CLS??0,_=s!==void 0?Math.max(0,s-T):void 0,Y=Math.max(0,u-S),W=Math.max(0,c-k),oe=0;o.lcp&&T&&l!==void 0&&_!==void 0&&(oe+=o.lcp*(Mr.evaluateLCPMetricScore(_)-l)),o.inp&&S&&m!==void 0&&(oe+=o.inp*(Mr.evaluateINPMetricScore(Y)-m)),o.cls&&k&&p!==void 0&&(oe+=o.cls*(Mr.evaluateCLSMetricScore(W)-p)),f.set(w,oe)}let h=Object.keys(a),y=Object.keys(n.model);y.sort((w,D)=>{let T=h.indexOf(w),S=h.indexOf(D);return T>=0&&S>=0?T-S:T>=0?-1:S>=0?1:0}),y.sort((w,D)=>(f.get(D)??0)-(f.get(w)??0));let b={};for(let w of y){let D=n.model[w];b[w]=D}n.model=b}#s(t,n,r,a){let o,s,c;r.navigation?(o=r.navigationId,s=n.Meta.finalDisplayUrlByNavigationId.get(r.navigationId)??n.Meta.mainFrameURL,c=r.navigation):(o=C.NO_NAVIGATION,s=n.Meta.finalDisplayUrlByNavigationId.get("")??n.Meta.mainFrameURL);let u={};for(let[p,f]of Object.entries(e.getInsightRunners())){let h;try{a.logger?.start(`insights:${p}`),h=f.generateInsight(n,r),h.frameId=r.frameId;let y=r.navigation?.args.data?.navigationId;y&&(h.navigationId=
y)}catch(y){h=y}finally{a.logger?.end(`insights:${p}`)}Object.assign(u,{[p]:h})}let l;try{l=new URL(s)}catch{return}let m={id:o,url:l,navigation:c,frameId:r.frameId,bounds:r.bounds,model:u};t.set(m.id,m),this.sortInsightSet(t,m,a.metadata??null)}#l(t,n,r){this.#a=new Map;let a=t.Meta.mainFrameNavigations.filter(o=>o.args.frame&&o.args.data?.navigationId);if(a.length){let o=ue.traceWindowFromMicroSeconds(t.Meta.traceBounds.min,a[0].ts),s=ue.milliToMicro(50);if(o.range>s){let c={bounds:o,frameId:t.Meta.mainFrameId};this.#s(this.#a,t,c,r)}}else{let o={bounds:t.Meta.traceBounds,frameId:t.Meta.mainFrameId};this.#s(this.#a,t,o,r)}for(let[o,s]of a.entries()){let c=s.args.frame,u=s.args.data?.navigationId,l;try{r.logger?.start("insights:createLanternContext"),l=this.#c(t,n,c,u,r)}catch(y){let b=["mainDocumentRequest not found","missing metric scores for main frame","missing metric: FCP","missing metric: LCP","No network requests found in trace","Trace is too old"];y instanceof Lt.LanternError&&
b.some(w=>y.message===w)||console.error(y)}finally{r.logger?.end("insights:createLanternContext")}let m=s.ts,p=o+1<a.length?a[o+1].ts:t.Meta.traceBounds.max,h={bounds:ue.traceWindowFromMicroSeconds(m,p),frameId:c,navigation:s,navigationId:u,lantern:l};this.#s(this.#a,t,h,r)}}};i(E6,"sortHandlers")});var T6=g(()=>{d();dn();ia();ut();xT();Pe()});var S6=g(()=>{d()});var DT=g(()=>{d();Mm();ia();ut();gT();Xd();wT();T6();xT();S6();Pe()});var hn=g(()=>{"use strict";d();Xd();DT();});var C6=g(()=>{"use strict";d();});var k6=g(()=>{"use strict";d();ct();ko();});var iy,I6=g(()=>{"use strict";d();Ed();iy=class e{static{i(this,"ArbitraryEqualityMap")}constructor(){this._equalsFn=e.deepEquals,this._entries=[]}setEqualityFn(t){this._equalsFn=t}has(t){return this._findIndexOf(t)!==-1}get(t){return this._entries[this._findIndexOf(t)]?.value}set(t,n){let r=this._findIndexOf(t);r===-1&&(r=this._entries.length),this._entries[r]={key:t,value:n}}_findIndexOf(t){for(let n=0;n<this._entries.length;n++)if(this._equalsFn(t,this._entries[n].key))return n;return-1}static deepEquals(t,n){return Va(t,n)}}});function le(e,t){return Object.assign(e,{request:i((r,a)=>{let o=e.name;for(let f of t||[])if(r&&typeof r=="object"&&r[f]===void 0){let h=new Error(`missing required key "${String(f)}" for computed artifact ${e.name}`);if(Qh)throw h;H.error(`lh:computed:${o}`,h)}let s=t?Object.fromEntries(t.map(f=>[f,r[f]])):r,c=a.computedCache,u=c.get(o)||new iy;c.set(o,u);let l=u.get(s);if(l)return l;let m={msg:`Computing artifact: ${o}`,id:`lh:computed:${o}`};H.time(m,"verbose");let p=e.compute_(s,a);return u.set(s,p),p.then(()=>H.timeEnd(m)).catch(()=>H.timeEnd(m)),p},"request")})}var Qe=g(()=>{"use strict";d();ct();I6();Ob();i(le,"makeComputedArtifact")});function Hme(e,t){return e.endsWith(t)?e.length===t.length||e[e.length-t.length-1]===".":!1}function Wme(e,t){let n=e.length-t.length-2,r=e.lastIndexOf(".",n);return r===-1?e:e.slice(r+1)}function ET(e,t,n){if(n.validHosts!==null){let a=n.validHosts;for(let o of a)if(Hme(t,o))return o}let r=0;if(t.startsWith("."))for(;r<t.length&&t[r]===".";)r+=1;return e.length===t.length-r?null:Wme(t,e)}var A6=g(()=>{d();i(Hme,"shareSameDomainSuffix");i(Wme,"extractDomainWithSuffix");i(ET,"getDomain")});function TT(e,t){return e.slice(0,-t.length-1)}var F6=g(()=>{d();i(TT,"getDomainWithoutSuffix")});function sy(e,t){let n=0,r=e.length,a=!1;if(!t){if(e.startsWith("data:"))return null;for(;n<e.length&&e.charCodeAt(n)<=32;)n+=1;for(;r>n+1&&e.charCodeAt(r-1)<=32;)r-=1;if(e.charCodeAt(n)===47&&e.charCodeAt(n+1)===47)n+=2;else{let l=e.indexOf(":/",n);if(l!==-1){let m=l-n,p=e.charCodeAt(n),f=e.charCodeAt(n+1),h=e.charCodeAt(n+2),y=e.charCodeAt(n+3),b=e.charCodeAt(n+4);if(!(m===5&&p===104&&f===116&&h===116&&y===112&&b===115)){if(!(m===4&&p===104&&f===116&&h===116&&y===112)){if(!(m===3&&p===119&&f===115&&h===115)){if(!(m===2&&p===119&&f===115))for(let w=n;w<l;w+=1){let D=e.charCodeAt(w)|32;if(!(D>=97&&D<=122||D>=48&&D<=57||D===46||D===45||D===43))return null}}}}for(n=l+2;e.charCodeAt(n)===47;)n+=1}}let s=-1,c=-1,u=-1;for(let l=n;l<r;l+=1){let m=e.charCodeAt(l);if(m===35||m===47||m===63){r=l;break}else m===64?s=l:m===93?c=l:m===58?u=l:m>=65&&m<=90&&(a=!0)}if(s!==-1&&s>n&&s<r&&(n=s+1),e.charCodeAt(n)===91)return c!==-1?e.slice(n+1,c).toLowerCase():null;u!==-1&&u>n&&u<r&&(r=u)}for(;r>n+1&&e.charCodeAt(
r-1)===46;)r-=1;let o=n!==0||r!==e.length?e.slice(n,r):e;return a?o.toLowerCase():o}var R6=g(()=>{d();i(sy,"extractHostname")});function Gme(e){if(e.length<7||e.length>15)return!1;let t=0;for(let n=0;n<e.length;n+=1){let r=e.charCodeAt(n);if(r===46)t+=1;else if(r<48||r>57)return!1}return t===3&&e.charCodeAt(0)!==46&&e.charCodeAt(e.length-1)!==46}function Vme(e){if(e.length<3)return!1;let t=e.startsWith("[")?1:0,n=e.length;if(e[n-1]==="]"&&(n-=1),n-t>39)return!1;let r=!1;for(;t<n;t+=1){let a=e.charCodeAt(t);if(a===58)r=!0;else if(!(a>=48&&a<=57||a>=97&&a<=102||a>=65&&a<=90))return!1}return r}function ST(e){return Vme(e)||Gme(e)}var _6=g(()=>{d();i(Gme,"isProbablyIpv4");i(Vme,"isProbablyIpv6");i(ST,"isIp")});function M6(e){return e>=97&&e<=122||e>=48&&e<=57||e>127}function cy(e){if(e.length>255||e.length===0||!M6(e.charCodeAt(0))&&e.charCodeAt(0)!==46&&e.charCodeAt(0)!==95)return!1;let t=-1,n=-1,r=e.length;for(let a=0;a<r;a+=1){let o=e.charCodeAt(a);if(o===46){if(a-t>64||n===46||n===45||n===95)return!1;t=a}else if(!(M6(o)||o===45||o===95))return!1;n=o}return r-t-1<=63&&n!==45}var O6=g(()=>{d();i(M6,"isValidAscii");i(cy,"default")});function N6({allowIcannDomains:e=!0,allowPrivateDomains:t=!1,detectIp:n=!0,extractHostname:r=!0,mixedInputs:a=!0,validHosts:o=null,validateHostname:s=!0}){return{allowIcannDomains:e,allowPrivateDomains:t,detectIp:n,extractHostname:r,mixedInputs:a,validHosts:o,validateHostname:s}}function CT(e){return e===void 0?$me:N6(e)}var $me,kT=g(()=>{d();i(N6,"setDefaultsImpl");$me=N6({});i(CT,"setDefaults")});function IT(e,t){return t.length===e.length?"":e.slice(0,-t.length-1)}var P6=g(()=>{d();i(IT,"getSubdomain")});function AT(){return{domain:null,domainWithoutSuffix:null,hostname:null,isIcann:null,isIp:null,isPrivate:null,publicSuffix:null,subdomain:null}}function FT(e){e.domain=null,e.domainWithoutSuffix=null,e.hostname=null,e.isIcann=null,e.isIp=null,e.isPrivate=null,e.publicSuffix=null,e.subdomain=null}function RT(e,t,n,r,a){let o=CT(r);return typeof e!="string"||(o.extractHostname?o.mixedInputs?a.hostname=sy(e,cy(e)):a.hostname=sy(e,!1):a.hostname=e,t===0||a.hostname===null)||o.detectIp&&(a.isIp=ST(a.hostname),a.isIp)?a:o.validateHostname&&o.extractHostname&&!cy(a.hostname)?(a.hostname=null,a):(n(a.hostname,o,a),t===2||a.publicSuffix===null||(a.domain=ET(a.publicSuffix,a.hostname,o),t===3||a.domain===null)||(a.subdomain=IT(a.hostname,a.domain),t===4)||(a.domainWithoutSuffix=TT(a.domain,a.publicSuffix)),a)}var L6=g(()=>{d();A6();F6();R6();_6();O6();kT();P6();i(AT,"getEmptyResult");i(FT,"resetResult");i(RT,"parseImpl")});function uy(e,t,n){if(!t.allowPrivateDomains&&e.length>3){let r=e.length-1,a=e.charCodeAt(r),o=e.charCodeAt(r-1),s=e.charCodeAt(r-2),c=e.charCodeAt(r-3);if(a===109&&o===111&&s===99&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="com",!0;if(a===103&&o===114&&s===111&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="org",!0;if(a===117&&o===100&&s===101&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="edu",!0;if(a===118&&o===111&&s===103&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="gov",!0;if(a===116&&o===101&&s===110&&c===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="net",!0;if(a===101&&o===100&&s===46)return n.isIcann=!0,n.isPrivate=!1,n.publicSuffix="de",!0}return!1}var B6=g(()=>{d();i(uy,"default")});var _T=g(()=>{d();L6();B6();kT()});var U6,j6,q6=g(()=>{d();U6=function(){let e=[1,{}],t=[0,{city:e}];return[0,{ck:[0,{www:e}],jp:[0,{kawasaki:t,kitakyushu:t,kobe:t,nagoya:t,sapporo:t,sendai:t,yokohama:t}]}]}(),j6=function(){let e=[1,{}],t=[1,{com:e,edu:e,gov:e,net:e,mil:e,org:e}],n=[1,{gov:e,com:e,org:e,net:e,edu:e}],r=[1,{gov:e}],a=[1,{com:e}],o=[0,{"*":e}],s=[1,{com:e,edu:e,net:e,org:e}],c=[1,{co:e,net:e,org:e}],u=[1,{co:e,com:e,edu:e,gov:e,net:e,org:e}],l=[1,{com:e,org:e,net:e,edu:e,sch:e,gov:e,mil:e,name:e}],m=[1,{edu:e,biz:e,net:e,org:e,gov:e,info:e,com:e}],p=[1,{gs:e}],f=[0,{nes:e}],h=[1,{k12:e,cc:e,lib:e}],y=[1,{cc:e}],b=[1,{cc:e,lib:e}];return[0,{ac:t,ad:[1,{nom:e}],ae:[1,{co:e,net:e,org:e,sch:e,ac:e,gov:e,mil:e}],aero:[1,{"accident-investigation":e,"accident-prevention":e,aerobatic:e,aeroclub:e,aerodrome:e,agents:e,aircraft:e,airline:e,airport:e,"air-surveillance":e,airtraffic:e,"air-traffic-control":e,ambulance:e,amusement:e,association:e,author:e,ballooning:e,broker:e,caa:e,cargo:e,catering:e,certification:e,
championship:e,charter:e,civilaviation:e,club:e,conference:e,consultant:e,consulting:e,control:e,council:e,crew:e,design:e,dgca:e,educator:e,emergency:e,engine:e,engineer:e,entertainment:e,equipment:e,exchange:e,express:e,federation:e,flight:e,fuel:e,gliding:e,government:e,groundhandling:e,group:e,hanggliding:e,homebuilt:e,insurance:e,journal:e,journalist:e,leasing:e,logistics:e,magazine:e,maintenance:e,media:e,microlight:e,modelling:e,navigation:e,parachuting:e,paragliding:e,"passenger-association":e,pilot:e,press:e,production:e,recreation:e,repbody:e,res:e,research:e,rotorcraft:e,safety:e,scientist:e,services:e,show:e,skydiving:e,software:e,student:e,trader:e,trading:e,trainer:e,union:e,workinggroup:e,works:e}],af:n,ag:[1,{com:e,org:e,net:e,co:e,nom:e}],ai:[1,{off:e,com:e,net:e,org:e}],al:t,am:[1,{co:e,com:e,commune:e,net:e,org:e}],ao:[1,{ed:e,gv:e,og:e,co:e,pb:e,it:e}],aq:e,ar:[1,{bet:e,com:e,coop:e,edu:e,gob:e,gov:e,int:e,mil:e,musica:e,mutual:e,net:e,org:e,senasa:e,tur:e}],arpa:[1,
{e164:e,"in-addr":e,ip6:e,iris:e,uri:e,urn:e}],as:r,asia:e,at:[1,{ac:[1,{sth:e}],co:e,gv:e,or:e}],au:[1,{com:e,net:e,org:e,edu:[1,{act:e,catholic:e,nsw:[1,{schools:e}],nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],gov:[1,{qld:e,sa:e,tas:e,vic:e,wa:e}],asn:e,id:e,info:e,conf:e,oz:e,act:e,nsw:e,nt:e,qld:e,sa:e,tas:e,vic:e,wa:e}],aw:a,ax:e,az:[1,{com:e,net:e,int:e,gov:e,org:e,edu:e,info:e,pp:e,mil:e,name:e,pro:e,biz:e}],ba:t,bb:[1,{biz:e,co:e,com:e,edu:e,gov:e,info:e,net:e,org:e,store:e,tv:e}],bd:o,be:[1,{ac:e}],bf:r,bg:[1,{0:e,1:e,2:e,3:e,4:e,5:e,6:e,7:e,8:e,9:e,a:e,b:e,c:e,d:e,e,f:e,g:e,h:e,i:e,j:e,k:e,l:e,m:e,n:e,o:e,p:e,q:e,r:e,s:e,t:e,u:e,v:e,w:e,x:e,y:e,z:e}],bh:n,bi:[1,{co:e,com:e,edu:e,or:e,org:e}],biz:e,bj:[1,{africa:e,agro:e,architectes:e,assur:e,avocats:e,co:e,com:e,eco:e,econo:e,edu:e,info:e,loisirs:e,money:e,net:e,org:e,ote:e,resto:e,restaurant:e,tourism:e,univ:e}],bm:n,bn:n,bo:[1,{com:e,edu:e,gob:e,int:e,org:e,net:e,mil:e,tv:e,web:e,academia:e,agro:e,arte:e,blog:e,bolivia:e,ciencia:e,cooperativa:e,
democracia:e,deporte:e,ecologia:e,economia:e,empresa:e,indigena:e,industria:e,info:e,medicina:e,movimiento:e,musica:e,natural:e,nombre:e,noticias:e,patria:e,politica:e,profesional:e,plurinacional:e,pueblo:e,revista:e,salud:e,tecnologia:e,tksat:e,transporte:e,wiki:e}],br:[1,{"9guacu":e,abc:e,adm:e,adv:e,agr:e,aju:e,am:e,anani:e,aparecida:e,app:e,arq:e,art:e,ato:e,b:e,barueri:e,belem:e,bhz:e,bib:e,bio:e,blog:e,bmd:e,boavista:e,bsb:e,campinagrande:e,campinas:e,caxias:e,cim:e,cng:e,cnt:e,com:e,contagem:e,coop:e,coz:e,cri:e,cuiaba:e,curitiba:e,def:e,des:e,det:e,dev:e,ecn:e,eco:e,edu:e,emp:e,enf:e,eng:e,esp:e,etc:e,eti:e,far:e,feira:e,flog:e,floripa:e,fm:e,fnd:e,fortal:e,fot:e,foz:e,fst:e,g12:e,geo:e,ggf:e,goiania:e,gov:[1,{ac:e,al:e,am:e,ap:e,ba:e,ce:e,df:e,es:e,go:e,ma:e,mg:e,ms:e,mt:e,pa:e,pb:e,pe:e,pi:e,pr:e,rj:e,rn:e,ro:e,rr:e,rs:e,sc:e,se:e,sp:e,to:e}],gru:e,imb:e,ind:e,inf:e,jab:e,jampa:e,jdf:e,joinville:e,jor:e,jus:e,leg:e,lel:e,log:e,londrina:e,macapa:e,maceio:e,manaus:e,maringa:e,mat:e,
med:e,mil:e,morena:e,mp:e,mus:e,natal:e,net:e,niteroi:e,nom:o,not:e,ntr:e,odo:e,ong:e,org:e,osasco:e,palmas:e,poa:e,ppg:e,pro:e,psc:e,psi:e,pvh:e,qsl:e,radio:e,rec:e,recife:e,rep:e,ribeirao:e,rio:e,riobranco:e,riopreto:e,salvador:e,sampa:e,santamaria:e,santoandre:e,saobernardo:e,saogonca:e,seg:e,sjc:e,slg:e,slz:e,sorocaba:e,srv:e,taxi:e,tc:e,tec:e,teo:e,the:e,tmp:e,trd:e,tur:e,tv:e,udi:e,vet:e,vix:e,vlog:e,wiki:e,zlg:e}],bs:n,bt:n,bv:e,bw:[1,{co:e,org:e}],by:[1,{gov:e,mil:e,com:e,of:e}],bz:n,ca:[1,{ab:e,bc:e,mb:e,nb:e,nf:e,nl:e,ns:e,nt:e,nu:e,on:e,pe:e,qc:e,sk:e,yk:e,gc:e}],cat:e,cc:e,cd:r,cf:e,cg:e,ch:e,ci:[1,{org:e,or:e,com:e,co:e,edu:e,ed:e,ac:e,net:e,go:e,asso:e,"xn--aroport-bya":e,aéroport:e,int:e,presse:e,md:e,gouv:e}],ck:o,cl:[1,{co:e,gob:e,gov:e,mil:e}],cm:[1,{co:e,com:e,gov:e,net:e}],cn:[1,{ac:e,com:e,edu:e,gov:e,net:e,org:e,mil:e,"xn--55qx5d":e,公司:e,"xn--io0a7i":e,网络:e,"xn--od0alg":e,網絡:e,ah:e,bj:e,cq:e,fj:e,gd:e,gs:e,gz:e,gx:e,ha:e,hb:e,he:e,hi:e,hl:e,hn:e,jl:e,
js:e,jx:e,ln:e,nm:e,nx:e,qh:e,sc:e,sd:e,sh:e,sn:e,sx:e,tj:e,xj:e,xz:e,yn:e,zj:e,hk:e,mo:e,tw:e}],co:[1,{arts:e,com:e,edu:e,firm:e,gov:e,info:e,int:e,mil:e,net:e,nom:e,org:e,rec:e,web:e}],com:e,coop:e,cr:[1,{ac:e,co:e,ed:e,fi:e,go:e,or:e,sa:e}],cu:[1,{com:e,edu:e,org:e,net:e,gov:e,inf:e}],cv:[1,{com:e,edu:e,int:e,nome:e,org:e}],cw:s,cx:r,cy:[1,{ac:e,biz:e,com:e,ekloges:e,gov:e,ltd:e,mil:e,net:e,org:e,press:e,pro:e,tm:e}],cz:e,de:e,dj:e,dk:e,dm:n,do:[1,{art:e,com:e,edu:e,gob:e,gov:e,mil:e,net:e,org:e,sld:e,web:e}],dz:[1,{art:e,asso:e,com:e,edu:e,gov:e,org:e,net:e,pol:e,soc:e,tm:e}],ec:[1,{com:e,info:e,net:e,fin:e,k12:e,med:e,pro:e,org:e,edu:e,gov:e,gob:e,mil:e}],edu:e,ee:[1,{edu:e,gov:e,riik:e,lib:e,med:e,com:e,pri:e,aip:e,org:e,fie:e}],eg:[1,{com:e,edu:e,eun:e,gov:e,mil:e,name:e,net:e,org:e,sci:e}],er:o,es:[1,{com:e,nom:e,org:e,gob:e,edu:e}],et:[1,{com:e,gov:e,org:e,edu:e,biz:e,name:e,info:e,net:e}],eu:e,fi:[1,{aland:e}],fj:[1,{ac:e,biz:e,com:e,gov:e,info:e,mil:e,name:e,net:e,org:e,pro:e}],
fk:o,fm:s,fo:e,fr:[1,{asso:e,com:e,gouv:e,nom:e,prd:e,tm:e,avoues:e,cci:e,greta:e,"huissier-justice":e}],ga:e,gb:e,gd:[1,{edu:e,gov:e}],ge:[1,{com:e,edu:e,gov:e,org:e,mil:e,net:e,pvt:e}],gf:e,gg:c,gh:[1,{com:e,edu:e,gov:e,org:e,mil:e}],gi:[1,{com:e,ltd:e,gov:e,mod:e,edu:e,org:e}],gl:[1,{co:e,com:e,edu:e,net:e,org:e}],gm:e,gn:[1,{ac:e,com:e,edu:e,gov:e,org:e,net:e}],gov:e,gp:[1,{com:e,net:e,mobi:e,edu:e,org:e,asso:e}],gq:e,gr:n,gs:e,gt:[1,{com:e,edu:e,gob:e,ind:e,mil:e,net:e,org:e}],gu:[1,{com:e,edu:e,gov:e,guam:e,info:e,net:e,org:e,web:e}],gw:e,gy:u,hk:[1,{com:e,edu:e,gov:e,idv:e,net:e,org:e,"xn--55qx5d":e,公司:e,"xn--wcvs22d":e,教育:e,"xn--lcvr32d":e,敎育:e,"xn--mxtq1m":e,政府:e,"xn--gmqw5a":e,個人:e,"xn--ciqpn":e,个人:e,"xn--gmq050i":e,箇人:e,"xn--zf0avx":e,網络:e,"xn--io0a7i":e,网络:e,"xn--mk0axi":e,组織:e,"xn--od0alg":e,網絡:e,"xn--od0aq3b":e,网絡:e,"xn--tn0ag":e,组织:e,"xn--uc0atv":e,組織:e,"xn--uc0ay4a":e,組织:e}],hm:e,hn:[1,{com:e,edu:e,org:e,net:e,
mil:e,gob:e}],hr:[1,{iz:e,from:e,name:e,com:e}],ht:[1,{com:e,shop:e,firm:e,info:e,adult:e,net:e,pro:e,org:e,med:e,art:e,coop:e,pol:e,asso:e,edu:e,rel:e,gouv:e,perso:e}],hu:[1,{2e3:e,co:e,info:e,org:e,priv:e,sport:e,tm:e,agrar:e,bolt:e,casino:e,city:e,erotica:e,erotika:e,film:e,forum:e,games:e,hotel:e,ingatlan:e,jogasz:e,konyvelo:e,lakas:e,media:e,news:e,reklam:e,sex:e,shop:e,suli:e,szex:e,tozsde:e,utazas:e,video:e}],id:[1,{ac:e,biz:e,co:e,desa:e,go:e,mil:e,my:e,net:e,or:e,ponpes:e,sch:e,web:e}],ie:r,il:[1,{ac:e,co:e,gov:e,idf:e,k12:e,muni:e,net:e,org:e}],"xn--4dbrk0ce":[1,{"xn--4dbgdty6c":e,"xn--5dbhl8d":e,"xn--8dbq2a":e,"xn--hebda8b":e}],ישראל:[1,{אקדמיה:e,ישוב:e,צהל:e,ממשל:e}],im:[1,{ac:e,co:[1,{ltd:e,plc:e}],com:e,net:e,org:e,tt:e,tv:e}],in:[1,{"5g":e,"6g":e,ac:e,ai:e,am:e,bihar:e,biz:e,business:e,ca:e,cn:e,co:e,com:e,coop:e,cs:e,delhi:e,dr:e,edu:e,er:e,firm:e,gen:e,gov:e,gujarat:e,ind:e,info:e,int:e,internet:e,io:e,me:e,mil:e,net:e,nic:e,org:e,pg:e,post:e,pro:e,
res:e,travel:e,tv:e,uk:e,up:e,us:e}],info:e,int:[1,{eu:e}],io:a,iq:t,ir:[1,{ac:e,co:e,gov:e,id:e,net:e,org:e,sch:e,"xn--mgba3a4f16a":e,ایران:e,"xn--mgba3a4fra":e,ايران:e}],is:[1,{net:e,com:e,edu:e,gov:e,org:e,int:e}],it:[1,{gov:e,edu:e,abr:e,abruzzo:e,"aosta-valley":e,aostavalley:e,bas:e,basilicata:e,cal:e,calabria:e,cam:e,campania:e,"emilia-romagna":e,emiliaromagna:e,emr:e,"friuli-v-giulia":e,"friuli-ve-giulia":e,"friuli-vegiulia":e,"friuli-venezia-giulia":e,"friuli-veneziagiulia":e,"friuli-vgiulia":e,"friuliv-giulia":e,"friulive-giulia":e,friulivegiulia:e,"friulivenezia-giulia":e,friuliveneziagiulia:e,friulivgiulia:e,fvg:e,laz:e,lazio:e,lig:e,liguria:e,lom:e,lombardia:e,lombardy:e,lucania:e,mar:e,marche:e,mol:e,molise:e,piedmont:e,piemonte:e,pmn:e,pug:e,puglia:e,sar:e,sardegna:e,sardinia:e,sic:e,sicilia:e,sicily:e,taa:e,tos:e,toscana:e,"trentin-sud-tirol":e,"xn--trentin-sd-tirol-rzb":e,"trentin-süd-tirol":e,"trentin-sudtirol":e,"xn--trentin-sdtirol-7vb":e,"trentin-südtirol":e,
"trentin-sued-tirol":e,"trentin-suedtirol":e,"trentino-a-adige":e,"trentino-aadige":e,"trentino-alto-adige":e,"trentino-altoadige":e,"trentino-s-tirol":e,"trentino-stirol":e,"trentino-sud-tirol":e,"xn--trentino-sd-tirol-c3b":e,"trentino-süd-tirol":e,"trentino-sudtirol":e,"xn--trentino-sdtirol-szb":e,"trentino-südtirol":e,"trentino-sued-tirol":e,"trentino-suedtirol":e,trentino:e,"trentinoa-adige":e,trentinoaadige:e,"trentinoalto-adige":e,trentinoaltoadige:e,"trentinos-tirol":e,trentinostirol:e,"trentinosud-tirol":e,"xn--trentinosd-tirol-rzb":e,"trentinosüd-tirol":e,trentinosudtirol:e,"xn--trentinosdtirol-7vb":e,trentinosüdtirol:e,"trentinosued-tirol":e,trentinosuedtirol:e,"trentinsud-tirol":e,"xn--trentinsd-tirol-6vb":e,"trentinsüd-tirol":e,trentinsudtirol:e,"xn--trentinsdtirol-nsb":e,trentinsüdtirol:e,"trentinsued-tirol":e,trentinsuedtirol:e,tuscany:e,umb:e,umbria:e,"val-d-aosta":e,"val-daosta":e,"vald-aosta":e,valdaosta:e,"valle-aosta":e,"valle-d-aosta":e,"valle-daosta":e,valleaosta:e,
"valled-aosta":e,valledaosta:e,"vallee-aoste":e,"xn--valle-aoste-ebb":e,"vallée-aoste":e,"vallee-d-aoste":e,"xn--valle-d-aoste-ehb":e,"vallée-d-aoste":e,valleeaoste:e,"xn--valleaoste-e7a":e,valléeaoste:e,valleedaoste:e,"xn--valledaoste-ebb":e,valléedaoste:e,vao:e,vda:e,ven:e,veneto:e,ag:e,agrigento:e,al:e,alessandria:e,"alto-adige":e,altoadige:e,an:e,ancona:e,"andria-barletta-trani":e,"andria-trani-barletta":e,andriabarlettatrani:e,andriatranibarletta:e,ao:e,aosta:e,aoste:e,ap:e,aq:e,aquila:e,ar:e,arezzo:e,"ascoli-piceno":e,ascolipiceno:e,asti:e,at:e,av:e,avellino:e,ba:e,"balsan-sudtirol":e,"xn--balsan-sdtirol-nsb":e,"balsan-südtirol":e,"balsan-suedtirol":e,balsan:e,bari:e,"barletta-trani-andria":e,barlettatraniandria:e,belluno:e,benevento:e,bergamo:e,bg:e,bi:e,biella:e,bl:e,bn:e,bo:e,bologna:e,"bolzano-altoadige":e,bolzano:e,"bozen-sudtirol":e,"xn--bozen-sdtirol-2ob":e,"bozen-südtirol":e,"bozen-suedtirol":e,bozen:e,br:e,brescia:e,brindisi:e,bs:e,bt:e,"bulsan-sudtirol":e,"xn--bul\
san-sdtirol-nsb":e,"bulsan-südtirol":e,"bulsan-suedtirol":e,bulsan:e,bz:e,ca:e,cagliari:e,caltanissetta:e,"campidano-medio":e,campidanomedio:e,campobasso:e,"carbonia-iglesias":e,carboniaiglesias:e,"carrara-massa":e,carraramassa:e,caserta:e,catania:e,catanzaro:e,cb:e,ce:e,"cesena-forli":e,"xn--cesena-forl-mcb":e,"cesena-forlì":e,cesenaforli:e,"xn--cesenaforl-i8a":e,cesenaforlì:e,ch:e,chieti:e,ci:e,cl:e,cn:e,co:e,como:e,cosenza:e,cr:e,cremona:e,crotone:e,cs:e,ct:e,cuneo:e,cz:e,"dell-ogliastra":e,dellogliastra:e,en:e,enna:e,fc:e,fe:e,fermo:e,ferrara:e,fg:e,fi:e,firenze:e,florence:e,fm:e,foggia:e,"forli-cesena":e,"xn--forl-cesena-fcb":e,"forlì-cesena":e,forlicesena:e,"xn--forlcesena-c8a":e,forlìcesena:e,fr:e,frosinone:e,ge:e,genoa:e,genova:e,go:e,gorizia:e,gr:e,grosseto:e,"iglesias-carbonia":e,iglesiascarbonia:e,im:e,imperia:e,is:e,isernia:e,kr:e,"la-spezia":e,laquila:e,laspezia:e,latina:e,lc:e,le:e,lecce:e,lecco:e,li:e,livorno:e,lo:e,lodi:e,lt:e,lu:e,lucca:e,macerata:e,mantova:e,"mas\
sa-carrara":e,massacarrara:e,matera:e,mb:e,mc:e,me:e,"medio-campidano":e,mediocampidano:e,messina:e,mi:e,milan:e,milano:e,mn:e,mo:e,modena:e,"monza-brianza":e,"monza-e-della-brianza":e,monza:e,monzabrianza:e,monzaebrianza:e,monzaedellabrianza:e,ms:e,mt:e,na:e,naples:e,napoli:e,no:e,novara:e,nu:e,nuoro:e,og:e,ogliastra:e,"olbia-tempio":e,olbiatempio:e,or:e,oristano:e,ot:e,pa:e,padova:e,padua:e,palermo:e,parma:e,pavia:e,pc:e,pd:e,pe:e,perugia:e,"pesaro-urbino":e,pesarourbino:e,pescara:e,pg:e,pi:e,piacenza:e,pisa:e,pistoia:e,pn:e,po:e,pordenone:e,potenza:e,pr:e,prato:e,pt:e,pu:e,pv:e,pz:e,ra:e,ragusa:e,ravenna:e,rc:e,re:e,"reggio-calabria":e,"reggio-emilia":e,reggiocalabria:e,reggioemilia:e,rg:e,ri:e,rieti:e,rimini:e,rm:e,rn:e,ro:e,roma:e,rome:e,rovigo:e,sa:e,salerno:e,sassari:e,savona:e,si:e,siena:e,siracusa:e,so:e,sondrio:e,sp:e,sr:e,ss:e,suedtirol:e,"xn--sdtirol-n2a":e,südtirol:e,sv:e,ta:e,taranto:e,te:e,"tempio-olbia":e,tempioolbia:e,teramo:e,terni:e,tn:e,to:e,torino:e,tp:e,tr:e,"tra\
ni-andria-barletta":e,"trani-barletta-andria":e,traniandriabarletta:e,tranibarlettaandria:e,trapani:e,trento:e,treviso:e,trieste:e,ts:e,turin:e,tv:e,ud:e,udine:e,"urbino-pesaro":e,urbinopesaro:e,va:e,varese:e,vb:e,vc:e,ve:e,venezia:e,venice:e,verbania:e,vercelli:e,verona:e,vi:e,"vibo-valentia":e,vibovalentia:e,vicenza:e,viterbo:e,vr:e,vs:e,vt:e,vv:e}],je:c,jm:o,jo:l,jobs:e,jp:[1,{ac:e,ad:e,co:e,ed:e,go:e,gr:e,lg:e,ne:e,or:e,aichi:[1,{aisai:e,ama:e,anjo:e,asuke:e,chiryu:e,chita:e,fuso:e,gamagori:e,handa:e,hazu:e,hekinan:e,higashiura:e,ichinomiya:e,inazawa:e,inuyama:e,isshiki:e,iwakura:e,kanie:e,kariya:e,kasugai:e,kira:e,kiyosu:e,komaki:e,konan:e,kota:e,mihama:e,miyoshi:e,nishio:e,nisshin:e,obu:e,oguchi:e,oharu:e,okazaki:e,owariasahi:e,seto:e,shikatsu:e,shinshiro:e,shitara:e,tahara:e,takahama:e,tobishima:e,toei:e,togo:e,tokai:e,tokoname:e,toyoake:e,toyohashi:e,toyokawa:e,toyone:e,toyota:e,tsushima:e,yatomi:e}],akita:[1,{akita:e,daisen:e,fujisato:e,gojome:e,hachirogata:e,happou:e,higashinaruse:e,
honjo:e,honjyo:e,ikawa:e,kamikoani:e,kamioka:e,katagami:e,kazuno:e,kitaakita:e,kosaka:e,kyowa:e,misato:e,mitane:e,moriyoshi:e,nikaho:e,noshiro:e,odate:e,oga:e,ogata:e,semboku:e,yokote:e,yurihonjo:e}],aomori:[1,{aomori:e,gonohe:e,hachinohe:e,hashikami:e,hiranai:e,hirosaki:e,itayanagi:e,kuroishi:e,misawa:e,mutsu:e,nakadomari:e,noheji:e,oirase:e,owani:e,rokunohe:e,sannohe:e,shichinohe:e,shingo:e,takko:e,towada:e,tsugaru:e,tsuruta:e}],chiba:[1,{abiko:e,asahi:e,chonan:e,chosei:e,choshi:e,chuo:e,funabashi:e,futtsu:e,hanamigawa:e,ichihara:e,ichikawa:e,ichinomiya:e,inzai:e,isumi:e,kamagaya:e,kamogawa:e,kashiwa:e,katori:e,katsuura:e,kimitsu:e,kisarazu:e,kozaki:e,kujukuri:e,kyonan:e,matsudo:e,midori:e,mihama:e,minamiboso:e,mobara:e,mutsuzawa:e,nagara:e,nagareyama:e,narashino:e,narita:e,noda:e,oamishirasato:e,omigawa:e,onjuku:e,otaki:e,sakae:e,sakura:e,shimofusa:e,shirako:e,shiroi:e,shisui:e,sodegaura:e,sosa:e,tako:e,tateyama:e,togane:e,tohnosho:e,tomisato:e,urayasu:e,yachimata:e,yachiyo:e,yokaichiba:e,
yokoshibahikari:e,yotsukaido:e}],ehime:[1,{ainan:e,honai:e,ikata:e,imabari:e,iyo:e,kamijima:e,kihoku:e,kumakogen:e,masaki:e,matsuno:e,matsuyama:e,namikata:e,niihama:e,ozu:e,saijo:e,seiyo:e,shikokuchuo:e,tobe:e,toon:e,uchiko:e,uwajima:e,yawatahama:e}],fukui:[1,{echizen:e,eiheiji:e,fukui:e,ikeda:e,katsuyama:e,mihama:e,minamiechizen:e,obama:e,ohi:e,ono:e,sabae:e,sakai:e,takahama:e,tsuruga:e,wakasa:e}],fukuoka:[1,{ashiya:e,buzen:e,chikugo:e,chikuho:e,chikujo:e,chikushino:e,chikuzen:e,chuo:e,dazaifu:e,fukuchi:e,hakata:e,higashi:e,hirokawa:e,hisayama:e,iizuka:e,inatsuki:e,kaho:e,kasuga:e,kasuya:e,kawara:e,keisen:e,koga:e,kurate:e,kurogi:e,kurume:e,minami:e,miyako:e,miyama:e,miyawaka:e,mizumaki:e,munakata:e,nakagawa:e,nakama:e,nishi:e,nogata:e,ogori:e,okagaki:e,okawa:e,oki:e,omuta:e,onga:e,onojo:e,oto:e,saigawa:e,sasaguri:e,shingu:e,shinyoshitomi:e,shonai:e,soeda:e,sue:e,tachiarai:e,tagawa:e,takata:e,toho:e,toyotsu:e,tsuiki:e,ukiha:e,umi:e,usui:e,yamada:e,yame:e,yanagawa:e,yukuhashi:e}],fukushima:[
1,{aizubange:e,aizumisato:e,aizuwakamatsu:e,asakawa:e,bandai:e,date:e,fukushima:e,furudono:e,futaba:e,hanawa:e,higashi:e,hirata:e,hirono:e,iitate:e,inawashiro:e,ishikawa:e,iwaki:e,izumizaki:e,kagamiishi:e,kaneyama:e,kawamata:e,kitakata:e,kitashiobara:e,koori:e,koriyama:e,kunimi:e,miharu:e,mishima:e,namie:e,nango:e,nishiaizu:e,nishigo:e,okuma:e,omotego:e,ono:e,otama:e,samegawa:e,shimogo:e,shirakawa:e,showa:e,soma:e,sukagawa:e,taishin:e,tamakawa:e,tanagura:e,tenei:e,yabuki:e,yamato:e,yamatsuri:e,yanaizu:e,yugawa:e}],gifu:[1,{anpachi:e,ena:e,gifu:e,ginan:e,godo:e,gujo:e,hashima:e,hichiso:e,hida:e,higashishirakawa:e,ibigawa:e,ikeda:e,kakamigahara:e,kani:e,kasahara:e,kasamatsu:e,kawaue:e,kitagata:e,mino:e,minokamo:e,mitake:e,mizunami:e,motosu:e,nakatsugawa:e,ogaki:e,sakahogi:e,seki:e,sekigahara:e,shirakawa:e,tajimi:e,takayama:e,tarui:e,toki:e,tomika:e,wanouchi:e,yamagata:e,yaotsu:e,yoro:e}],gunma:[1,{annaka:e,chiyoda:e,fujioka:e,higashiagatsuma:e,isesaki:e,itakura:e,kanna:e,kanra:e,katashina:e,
kawaba:e,kiryu:e,kusatsu:e,maebashi:e,meiwa:e,midori:e,minakami:e,naganohara:e,nakanojo:e,nanmoku:e,numata:e,oizumi:e,ora:e,ota:e,shibukawa:e,shimonita:e,shinto:e,showa:e,takasaki:e,takayama:e,tamamura:e,tatebayashi:e,tomioka:e,tsukiyono:e,tsumagoi:e,ueno:e,yoshioka:e}],hiroshima:[1,{asaminami:e,daiwa:e,etajima:e,fuchu:e,fukuyama:e,hatsukaichi:e,higashihiroshima:e,hongo:e,jinsekikogen:e,kaita:e,kui:e,kumano:e,kure:e,mihara:e,miyoshi:e,naka:e,onomichi:e,osakikamijima:e,otake:e,saka:e,sera:e,seranishi:e,shinichi:e,shobara:e,takehara:e}],hokkaido:[1,{abashiri:e,abira:e,aibetsu:e,akabira:e,akkeshi:e,asahikawa:e,ashibetsu:e,ashoro:e,assabu:e,atsuma:e,bibai:e,biei:e,bifuka:e,bihoro:e,biratori:e,chippubetsu:e,chitose:e,date:e,ebetsu:e,embetsu:e,eniwa:e,erimo:e,esan:e,esashi:e,fukagawa:e,fukushima:e,furano:e,furubira:e,haboro:e,hakodate:e,hamatonbetsu:e,hidaka:e,higashikagura:e,higashikawa:e,hiroo:e,hokuryu:e,hokuto:e,honbetsu:e,horokanai:e,horonobe:e,ikeda:e,imakane:e,ishikari:e,iwamizawa:e,iwanai:e,
kamifurano:e,kamikawa:e,kamishihoro:e,kamisunagawa:e,kamoenai:e,kayabe:e,kembuchi:e,kikonai:e,kimobetsu:e,kitahiroshima:e,kitami:e,kiyosato:e,koshimizu:e,kunneppu:e,kuriyama:e,kuromatsunai:e,kushiro:e,kutchan:e,kyowa:e,mashike:e,matsumae:e,mikasa:e,minamifurano:e,mombetsu:e,moseushi:e,mukawa:e,muroran:e,naie:e,nakagawa:e,nakasatsunai:e,nakatombetsu:e,nanae:e,nanporo:e,nayoro:e,nemuro:e,niikappu:e,niki:e,nishiokoppe:e,noboribetsu:e,numata:e,obihiro:e,obira:e,oketo:e,okoppe:e,otaru:e,otobe:e,otofuke:e,otoineppu:e,oumu:e,ozora:e,pippu:e,rankoshi:e,rebun:e,rikubetsu:e,rishiri:e,rishirifuji:e,saroma:e,sarufutsu:e,shakotan:e,shari:e,shibecha:e,shibetsu:e,shikabe:e,shikaoi:e,shimamaki:e,shimizu:e,shimokawa:e,shinshinotsu:e,shintoku:e,shiranuka:e,shiraoi:e,shiriuchi:e,sobetsu:e,sunagawa:e,taiki:e,takasu:e,takikawa:e,takinoue:e,teshikaga:e,tobetsu:e,tohma:e,tomakomai:e,tomari:e,toya:e,toyako:e,toyotomi:e,toyoura:e,tsubetsu:e,tsukigata:e,urakawa:e,urausu:e,uryu:e,utashinai:e,wakkanai:e,wassamu:e,
yakumo:e,yoichi:e}],hyogo:[1,{aioi:e,akashi:e,ako:e,amagasaki:e,aogaki:e,asago:e,ashiya:e,awaji:e,fukusaki:e,goshiki:e,harima:e,himeji:e,ichikawa:e,inagawa:e,itami:e,kakogawa:e,kamigori:e,kamikawa:e,kasai:e,kasuga:e,kawanishi:e,miki:e,minamiawaji:e,nishinomiya:e,nishiwaki:e,ono:e,sanda:e,sannan:e,sasayama:e,sayo:e,shingu:e,shinonsen:e,shiso:e,sumoto:e,taishi:e,taka:e,takarazuka:e,takasago:e,takino:e,tamba:e,tatsuno:e,toyooka:e,yabu:e,yashiro:e,yoka:e,yokawa:e}],ibaraki:[1,{ami:e,asahi:e,bando:e,chikusei:e,daigo:e,fujishiro:e,hitachi:e,hitachinaka:e,hitachiomiya:e,hitachiota:e,ibaraki:e,ina:e,inashiki:e,itako:e,iwama:e,joso:e,kamisu:e,kasama:e,kashima:e,kasumigaura:e,koga:e,miho:e,mito:e,moriya:e,naka:e,namegata:e,oarai:e,ogawa:e,omitama:e,ryugasaki:e,sakai:e,sakuragawa:e,shimodate:e,shimotsuma:e,shirosato:e,sowa:e,suifu:e,takahagi:e,tamatsukuri:e,tokai:e,tomobe:e,tone:e,toride:e,tsuchiura:e,tsukuba:e,uchihara:e,ushiku:e,yachiyo:e,yamagata:e,yawara:e,yuki:e}],ishikawa:[1,{anamizu:e,hakui:e,
hakusan:e,kaga:e,kahoku:e,kanazawa:e,kawakita:e,komatsu:e,nakanoto:e,nanao:e,nomi:e,nonoichi:e,noto:e,shika:e,suzu:e,tsubata:e,tsurugi:e,uchinada:e,wajima:e}],iwate:[1,{fudai:e,fujisawa:e,hanamaki:e,hiraizumi:e,hirono:e,ichinohe:e,ichinoseki:e,iwaizumi:e,iwate:e,joboji:e,kamaishi:e,kanegasaki:e,karumai:e,kawai:e,kitakami:e,kuji:e,kunohe:e,kuzumaki:e,miyako:e,mizusawa:e,morioka:e,ninohe:e,noda:e,ofunato:e,oshu:e,otsuchi:e,rikuzentakata:e,shiwa:e,shizukuishi:e,sumita:e,tanohata:e,tono:e,yahaba:e,yamada:e}],kagawa:[1,{ayagawa:e,higashikagawa:e,kanonji:e,kotohira:e,manno:e,marugame:e,mitoyo:e,naoshima:e,sanuki:e,tadotsu:e,takamatsu:e,tonosho:e,uchinomi:e,utazu:e,zentsuji:e}],kagoshima:[1,{akune:e,amami:e,hioki:e,isa:e,isen:e,izumi:e,kagoshima:e,kanoya:e,kawanabe:e,kinko:e,kouyama:e,makurazaki:e,matsumoto:e,minamitane:e,nakatane:e,nishinoomote:e,satsumasendai:e,soo:e,tarumizu:e,yusui:e}],kanagawa:[1,{aikawa:e,atsugi:e,ayase:e,chigasaki:e,ebina:e,fujisawa:e,hadano:e,hakone:e,hiratsuka:e,isehara:e,
kaisei:e,kamakura:e,kiyokawa:e,matsuda:e,minamiashigara:e,miura:e,nakai:e,ninomiya:e,odawara:e,oi:e,oiso:e,sagamihara:e,samukawa:e,tsukui:e,yamakita:e,yamato:e,yokosuka:e,yugawara:e,zama:e,zushi:e}],kochi:[1,{aki:e,geisei:e,hidaka:e,higashitsuno:e,ino:e,kagami:e,kami:e,kitagawa:e,kochi:e,mihara:e,motoyama:e,muroto:e,nahari:e,nakamura:e,nankoku:e,nishitosa:e,niyodogawa:e,ochi:e,okawa:e,otoyo:e,otsuki:e,sakawa:e,sukumo:e,susaki:e,tosa:e,tosashimizu:e,toyo:e,tsuno:e,umaji:e,yasuda:e,yusuhara:e}],kumamoto:[1,{amakusa:e,arao:e,aso:e,choyo:e,gyokuto:e,kamiamakusa:e,kikuchi:e,kumamoto:e,mashiki:e,mifune:e,minamata:e,minamioguni:e,nagasu:e,nishihara:e,oguni:e,ozu:e,sumoto:e,takamori:e,uki:e,uto:e,yamaga:e,yamato:e,yatsushiro:e}],kyoto:[1,{ayabe:e,fukuchiyama:e,higashiyama:e,ide:e,ine:e,joyo:e,kameoka:e,kamo:e,kita:e,kizu:e,kumiyama:e,kyotamba:e,kyotanabe:e,kyotango:e,maizuru:e,minami:e,minamiyamashiro:e,miyazu:e,muko:e,nagaokakyo:e,nakagyo:e,nantan:e,oyamazaki:e,sakyo:e,seika:e,tanabe:e,uji:e,
ujitawara:e,wazuka:e,yamashina:e,yawata:e}],mie:[1,{asahi:e,inabe:e,ise:e,kameyama:e,kawagoe:e,kiho:e,kisosaki:e,kiwa:e,komono:e,kumano:e,kuwana:e,matsusaka:e,meiwa:e,mihama:e,minamiise:e,misugi:e,miyama:e,nabari:e,shima:e,suzuka:e,tado:e,taiki:e,taki:e,tamaki:e,toba:e,tsu:e,udono:e,ureshino:e,watarai:e,yokkaichi:e}],miyagi:[1,{furukawa:e,higashimatsushima:e,ishinomaki:e,iwanuma:e,kakuda:e,kami:e,kawasaki:e,marumori:e,matsushima:e,minamisanriku:e,misato:e,murata:e,natori:e,ogawara:e,ohira:e,onagawa:e,osaki:e,rifu:e,semine:e,shibata:e,shichikashuku:e,shikama:e,shiogama:e,shiroishi:e,tagajo:e,taiwa:e,tome:e,tomiya:e,wakuya:e,watari:e,yamamoto:e,zao:e}],miyazaki:[1,{aya:e,ebino:e,gokase:e,hyuga:e,kadogawa:e,kawaminami:e,kijo:e,kitagawa:e,kitakata:e,kitaura:e,kobayashi:e,kunitomi:e,kushima:e,mimata:e,miyakonojo:e,miyazaki:e,morotsuka:e,nichinan:e,nishimera:e,nobeoka:e,saito:e,shiiba:e,shintomi:e,takaharu:e,takanabe:e,takazaki:e,tsuno:e}],nagano:[1,{achi:e,agematsu:e,anan:e,aoki:e,asahi:e,azumino:e,
chikuhoku:e,chikuma:e,chino:e,fujimi:e,hakuba:e,hara:e,hiraya:e,iida:e,iijima:e,iiyama:e,iizuna:e,ikeda:e,ikusaka:e,ina:e,karuizawa:e,kawakami:e,kiso:e,kisofukushima:e,kitaaiki:e,komagane:e,komoro:e,matsukawa:e,matsumoto:e,miasa:e,minamiaiki:e,minamimaki:e,minamiminowa:e,minowa:e,miyada:e,miyota:e,mochizuki:e,nagano:e,nagawa:e,nagiso:e,nakagawa:e,nakano:e,nozawaonsen:e,obuse:e,ogawa:e,okaya:e,omachi:e,omi:e,ookuwa:e,ooshika:e,otaki:e,otari:e,sakae:e,sakaki:e,saku:e,sakuho:e,shimosuwa:e,shinanomachi:e,shiojiri:e,suwa:e,suzaka:e,takagi:e,takamori:e,takayama:e,tateshina:e,tatsuno:e,togakushi:e,togura:e,tomi:e,ueda:e,wada:e,yamagata:e,yamanouchi:e,yasaka:e,yasuoka:e}],nagasaki:[1,{chijiwa:e,futsu:e,goto:e,hasami:e,hirado:e,iki:e,isahaya:e,kawatana:e,kuchinotsu:e,matsuura:e,nagasaki:e,obama:e,omura:e,oseto:e,saikai:e,sasebo:e,seihi:e,shimabara:e,shinkamigoto:e,togitsu:e,tsushima:e,unzen:e}],nara:[1,{ando:e,gose:e,heguri:e,higashiyoshino:e,ikaruga:e,ikoma:e,kamikitayama:e,kanmaki:e,kashiba:e,
kashihara:e,katsuragi:e,kawai:e,kawakami:e,kawanishi:e,koryo:e,kurotaki:e,mitsue:e,miyake:e,nara:e,nosegawa:e,oji:e,ouda:e,oyodo:e,sakurai:e,sango:e,shimoichi:e,shimokitayama:e,shinjo:e,soni:e,takatori:e,tawaramoto:e,tenkawa:e,tenri:e,uda:e,yamatokoriyama:e,yamatotakada:e,yamazoe:e,yoshino:e}],niigata:[1,{aga:e,agano:e,gosen:e,itoigawa:e,izumozaki:e,joetsu:e,kamo:e,kariwa:e,kashiwazaki:e,minamiuonuma:e,mitsuke:e,muika:e,murakami:e,myoko:e,nagaoka:e,niigata:e,ojiya:e,omi:e,sado:e,sanjo:e,seiro:e,seirou:e,sekikawa:e,shibata:e,tagami:e,tainai:e,tochio:e,tokamachi:e,tsubame:e,tsunan:e,uonuma:e,yahiko:e,yoita:e,yuzawa:e}],oita:[1,{beppu:e,bungoono:e,bungotakada:e,hasama:e,hiji:e,himeshima:e,hita:e,kamitsue:e,kokonoe:e,kuju:e,kunisaki:e,kusu:e,oita:e,saiki:e,taketa:e,tsukumi:e,usa:e,usuki:e,yufu:e}],okayama:[1,{akaiwa:e,asakuchi:e,bizen:e,hayashima:e,ibara:e,kagamino:e,kasaoka:e,kibichuo:e,kumenan:e,kurashiki:e,maniwa:e,misaki:e,nagi:e,niimi:e,nishiawakura:e,okayama:e,satosho:e,setouchi:e,shinjo:e,
shoo:e,soja:e,takahashi:e,tamano:e,tsuyama:e,wake:e,yakage:e}],okinawa:[1,{aguni:e,ginowan:e,ginoza:e,gushikami:e,haebaru:e,higashi:e,hirara:e,iheya:e,ishigaki:e,ishikawa:e,itoman:e,izena:e,kadena:e,kin:e,kitadaito:e,kitanakagusuku:e,kumejima:e,kunigami:e,minamidaito:e,motobu:e,nago:e,naha:e,nakagusuku:e,nakijin:e,nanjo:e,nishihara:e,ogimi:e,okinawa:e,onna:e,shimoji:e,taketomi:e,tarama:e,tokashiki:e,tomigusuku:e,tonaki:e,urasoe:e,uruma:e,yaese:e,yomitan:e,yonabaru:e,yonaguni:e,zamami:e}],osaka:[1,{abeno:e,chihayaakasaka:e,chuo:e,daito:e,fujiidera:e,habikino:e,hannan:e,higashiosaka:e,higashisumiyoshi:e,higashiyodogawa:e,hirakata:e,ibaraki:e,ikeda:e,izumi:e,izumiotsu:e,izumisano:e,kadoma:e,kaizuka:e,kanan:e,kashiwara:e,katano:e,kawachinagano:e,kishiwada:e,kita:e,kumatori:e,matsubara:e,minato:e,minoh:e,misaki:e,moriguchi:e,neyagawa:e,nishi:e,nose:e,osakasayama:e,sakai:e,sayama:e,sennan:e,settsu:e,shijonawate:e,shimamoto:e,suita:e,tadaoka:e,taishi:e,tajiri:e,takaishi:e,takatsuki:e,tondabayashi:e,
toyonaka:e,toyono:e,yao:e}],saga:[1,{ariake:e,arita:e,fukudomi:e,genkai:e,hamatama:e,hizen:e,imari:e,kamimine:e,kanzaki:e,karatsu:e,kashima:e,kitagata:e,kitahata:e,kiyama:e,kouhoku:e,kyuragi:e,nishiarita:e,ogi:e,omachi:e,ouchi:e,saga:e,shiroishi:e,taku:e,tara:e,tosu:e,yoshinogari:e}],saitama:[1,{arakawa:e,asaka:e,chichibu:e,fujimi:e,fujimino:e,fukaya:e,hanno:e,hanyu:e,hasuda:e,hatogaya:e,hatoyama:e,hidaka:e,higashichichibu:e,higashimatsuyama:e,honjo:e,ina:e,iruma:e,iwatsuki:e,kamiizumi:e,kamikawa:e,kamisato:e,kasukabe:e,kawagoe:e,kawaguchi:e,kawajima:e,kazo:e,kitamoto:e,koshigaya:e,kounosu:e,kuki:e,kumagaya:e,matsubushi:e,minano:e,misato:e,miyashiro:e,miyoshi:e,moroyama:e,nagatoro:e,namegawa:e,niiza:e,ogano:e,ogawa:e,ogose:e,okegawa:e,omiya:e,otaki:e,ranzan:e,ryokami:e,saitama:e,sakado:e,satte:e,sayama:e,shiki:e,shiraoka:e,soka:e,sugito:e,toda:e,tokigawa:e,tokorozawa:e,tsurugashima:e,urawa:e,warabi:e,yashio:e,yokoze:e,yono:e,yorii:e,yoshida:e,yoshikawa:e,yoshimi:e}],shiga:[1,{aisho:e,gamo:e,
higashiomi:e,hikone:e,koka:e,konan:e,kosei:e,koto:e,kusatsu:e,maibara:e,moriyama:e,nagahama:e,nishiazai:e,notogawa:e,omihachiman:e,otsu:e,ritto:e,ryuoh:e,takashima:e,takatsuki:e,torahime:e,toyosato:e,yasu:e}],shimane:[1,{akagi:e,ama:e,gotsu:e,hamada:e,higashiizumo:e,hikawa:e,hikimi:e,izumo:e,kakinoki:e,masuda:e,matsue:e,misato:e,nishinoshima:e,ohda:e,okinoshima:e,okuizumo:e,shimane:e,tamayu:e,tsuwano:e,unnan:e,yakumo:e,yasugi:e,yatsuka:e}],shizuoka:[1,{arai:e,atami:e,fuji:e,fujieda:e,fujikawa:e,fujinomiya:e,fukuroi:e,gotemba:e,haibara:e,hamamatsu:e,higashiizu:e,ito:e,iwata:e,izu:e,izunokuni:e,kakegawa:e,kannami:e,kawanehon:e,kawazu:e,kikugawa:e,kosai:e,makinohara:e,matsuzaki:e,minamiizu:e,mishima:e,morimachi:e,nishiizu:e,numazu:e,omaezaki:e,shimada:e,shimizu:e,shimoda:e,shizuoka:e,susono:e,yaizu:e,yoshida:e}],tochigi:[1,{ashikaga:e,bato:e,haga:e,ichikai:e,iwafune:e,kaminokawa:e,kanuma:e,karasuyama:e,kuroiso:e,mashiko:e,mibu:e,moka:e,motegi:e,nasu:e,nasushiobara:e,nikko:e,nishikata:e,nogi:e,
ohira:e,ohtawara:e,oyama:e,sakura:e,sano:e,shimotsuke:e,shioya:e,takanezawa:e,tochigi:e,tsuga:e,ujiie:e,utsunomiya:e,yaita:e}],tokushima:[1,{aizumi:e,anan:e,ichiba:e,itano:e,kainan:e,komatsushima:e,matsushige:e,mima:e,minami:e,miyoshi:e,mugi:e,nakagawa:e,naruto:e,sanagochi:e,shishikui:e,tokushima:e,wajiki:e}],tokyo:[1,{adachi:e,akiruno:e,akishima:e,aogashima:e,arakawa:e,bunkyo:e,chiyoda:e,chofu:e,chuo:e,edogawa:e,fuchu:e,fussa:e,hachijo:e,hachioji:e,hamura:e,higashikurume:e,higashimurayama:e,higashiyamato:e,hino:e,hinode:e,hinohara:e,inagi:e,itabashi:e,katsushika:e,kita:e,kiyose:e,kodaira:e,koganei:e,kokubunji:e,komae:e,koto:e,kouzushima:e,kunitachi:e,machida:e,meguro:e,minato:e,mitaka:e,mizuho:e,musashimurayama:e,musashino:e,nakano:e,nerima:e,ogasawara:e,okutama:e,ome:e,oshima:e,ota:e,setagaya:e,shibuya:e,shinagawa:e,shinjuku:e,suginami:e,sumida:e,tachikawa:e,taito:e,tama:e,toshima:e}],tottori:[1,{chizu:e,hino:e,kawahara:e,koge:e,kotoura:e,misasa:e,nanbu:e,nichinan:e,sakaiminato:e,tottori:e,
wakasa:e,yazu:e,yonago:e}],toyama:[1,{asahi:e,fuchu:e,fukumitsu:e,funahashi:e,himi:e,imizu:e,inami:e,johana:e,kamiichi:e,kurobe:e,nakaniikawa:e,namerikawa:e,nanto:e,nyuzen:e,oyabe:e,taira:e,takaoka:e,tateyama:e,toga:e,tonami:e,toyama:e,unazuki:e,uozu:e,yamada:e}],wakayama:[1,{arida:e,aridagawa:e,gobo:e,hashimoto:e,hidaka:e,hirogawa:e,inami:e,iwade:e,kainan:e,kamitonda:e,katsuragi:e,kimino:e,kinokawa:e,kitayama:e,koya:e,koza:e,kozagawa:e,kudoyama:e,kushimoto:e,mihama:e,misato:e,nachikatsuura:e,shingu:e,shirahama:e,taiji:e,tanabe:e,wakayama:e,yuasa:e,yura:e}],yamagata:[1,{asahi:e,funagata:e,higashine:e,iide:e,kahoku:e,kaminoyama:e,kaneyama:e,kawanishi:e,mamurogawa:e,mikawa:e,murayama:e,nagai:e,nakayama:e,nanyo:e,nishikawa:e,obanazawa:e,oe:e,oguni:e,ohkura:e,oishida:e,sagae:e,sakata:e,sakegawa:e,shinjo:e,shirataka:e,shonai:e,takahata:e,tendo:e,tozawa:e,tsuruoka:e,yamagata:e,yamanobe:e,yonezawa:e,yuza:e}],yamaguchi:[1,{abu:e,hagi:e,hikari:e,hofu:e,iwakuni:e,kudamatsu:e,mitou:e,nagato:e,oshima:e,
shimonoseki:e,shunan:e,tabuse:e,tokuyama:e,toyota:e,ube:e,yuu:e}],yamanashi:[1,{chuo:e,doshi:e,fuefuki:e,fujikawa:e,fujikawaguchiko:e,fujiyoshida:e,hayakawa:e,hokuto:e,ichikawamisato:e,kai:e,kofu:e,koshu:e,kosuge:e,"minami-alps":e,minobu:e,nakamichi:e,nanbu:e,narusawa:e,nirasaki:e,nishikatsura:e,oshino:e,otsuki:e,showa:e,tabayama:e,tsuru:e,uenohara:e,yamanakako:e,yamanashi:e}],"xn--4pvxs":e,栃木:e,"xn--vgu402c":e,愛知:e,"xn--c3s14m":e,愛媛:e,"xn--f6qx53a":e,兵庫:e,"xn--8pvr4u":e,熊本:e,"xn--uist22h":e,茨城:e,"xn--djrs72d6uy":e,北海道:e,"xn--mkru45i":e,千葉:e,"xn--0trq7p7nn":e,和歌山:e,"xn--8ltr62k":e,長崎:e,"xn--2m4a15e":e,長野:e,"xn--efvn9s":e,新潟:e,"xn--32vp30h":e,青森:e,"xn--4it797k":e,静岡:e,"xn--1lqs71d":e,東京:e,"xn--5rtp49c":e,石川:e,"xn--5js045d":e,埼玉:e,"xn--ehqz56n":e,三重:e,"xn--1lqs03n":e,京都:e,"xn--qqqt11m":e,佐賀:e,"xn--kbrq7o":e,大分:e,"xn--pssu33l":e,大阪:e,"xn--ntsq17g":e,奈良:e,"xn--uisz3g":e,宮城:e,"xn--6btw5a":e,宮崎:e,
"xn--1ctwo":e,富山:e,"xn--6orx2r":e,山口:e,"xn--rht61e":e,山形:e,"xn--rht27z":e,山梨:e,"xn--djty4k":e,岩手:e,"xn--nit225k":e,岐阜:e,"xn--rht3d":e,岡山:e,"xn--klty5x":e,島根:e,"xn--kltx9a":e,広島:e,"xn--kltp7d":e,徳島:e,"xn--uuwu58a":e,沖縄:e,"xn--zbx025d":e,滋賀:e,"xn--ntso0iqx3a":e,神奈川:e,"xn--elqq16h":e,福井:e,"xn--4it168d":e,福岡:e,"xn--klt787d":e,福島:e,"xn--rny31h":e,秋田:e,"xn--7t0a264c":e,群馬:e,"xn--5rtq34k":e,香川:e,"xn--k7yn95e":e,高知:e,"xn--tor131o":e,鳥取:e,"xn--d5qv7z876c":e,鹿児島:e,kawasaki:o,kitakyushu:o,kobe:o,nagoya:o,sapporo:o,sendai:o,yokohama:o}],ke:[1,{ac:e,co:e,go:e,info:e,me:e,mobi:e,ne:e,or:e,sc:e}],kg:t,kh:o,ki:m,km:[1,{org:e,nom:e,gov:e,prd:e,tm:e,edu:e,mil:e,ass:e,com:e,coop:e,asso:e,presse:e,medecin:e,notaires:e,pharmaciens:e,veterinaire:e,gouv:e}],kn:[1,{net:e,org:e,edu:e,gov:e}],kp:[1,{com:e,edu:e,gov:e,org:e,rep:e,tra:e}],kr:[1,{ac:e,co:e,es:e,go:e,hs:e,kg:e,mil:e,ms:e,ne:e,or:e,pe:e,re:e,sc:e,busan:e,chungbuk:e,
chungnam:e,daegu:e,daejeon:e,gangwon:e,gwangju:e,gyeongbuk:e,gyeonggi:e,gyeongnam:e,incheon:e,jeju:e,jeonbuk:e,jeonnam:e,seoul:e,ulsan:e}],kw:[1,{com:e,edu:e,emb:e,gov:e,ind:e,net:e,org:e}],ky:s,kz:t,la:[1,{int:e,net:e,info:e,edu:e,gov:e,per:e,com:e,org:e}],lb:n,lc:u,li:e,lk:[1,{gov:e,sch:e,net:e,int:e,com:e,org:e,edu:e,ngo:e,soc:e,web:e,ltd:e,assn:e,grp:e,hotel:e,ac:e}],lr:n,ls:[1,{ac:e,biz:e,co:e,edu:e,gov:e,info:e,net:e,org:e,sc:e}],lt:r,lu:e,lv:[1,{com:e,edu:e,gov:e,org:e,mil:e,id:e,net:e,asn:e,conf:e}],ly:[1,{com:e,net:e,gov:e,plc:e,edu:e,sch:e,med:e,org:e,id:e}],ma:[1,{co:e,net:e,gov:e,org:e,ac:e,press:e}],mc:[1,{tm:e,asso:e}],md:e,me:[1,{co:e,net:e,org:e,edu:e,ac:e,gov:e,its:e,priv:e}],mg:[1,{org:e,nom:e,gov:e,prd:e,tm:e,edu:e,mil:e,com:e,co:e}],mh:e,mil:e,mk:[1,{com:e,org:e,net:e,edu:e,gov:e,inf:e,name:e}],ml:[1,{com:e,edu:e,gouv:e,gov:e,net:e,org:e,presse:e}],mm:o,mn:[1,{gov:e,edu:e,org:e}],mo:n,mobi:e,mp:e,mq:e,mr:r,ms:n,mt:s,mu:[1,{com:e,net:e,org:e,gov:e,ac:e,co:e,or:e}],museum:e,
mv:[1,{aero:e,biz:e,com:e,coop:e,edu:e,gov:e,info:e,int:e,mil:e,museum:e,name:e,net:e,org:e,pro:e}],mw:[1,{ac:e,biz:e,co:e,com:e,coop:e,edu:e,gov:e,int:e,museum:e,net:e,org:e}],mx:[1,{com:e,org:e,gob:e,edu:e,net:e}],my:[1,{biz:e,com:e,edu:e,gov:e,mil:e,name:e,net:e,org:e}],mz:[1,{ac:e,adv:e,co:e,edu:e,gov:e,mil:e,net:e,org:e}],na:[1,{info:e,pro:e,name:e,school:e,or:e,dr:e,us:e,mx:e,ca:e,in:e,cc:e,tv:e,ws:e,mobi:e,co:e,com:e,org:e}],name:e,nc:[1,{asso:e,nom:e}],ne:e,net:e,nf:[1,{com:e,net:e,per:e,rec:e,web:e,arts:e,firm:e,info:e,other:e,store:e}],ng:[1,{com:e,edu:e,gov:e,i:e,mil:e,mobi:e,name:e,net:e,org:e,sch:e}],ni:[1,{ac:e,biz:e,co:e,com:e,edu:e,gob:e,in:e,info:e,int:e,mil:e,net:e,nom:e,org:e,web:e}],nl:e,no:[1,{fhs:e,vgs:e,fylkesbibl:e,folkebibl:e,museum:e,idrett:e,priv:e,mil:e,stat:e,dep:e,kommune:e,herad:e,aa:p,ah:p,bu:p,fm:p,hl:p,hm:p,"jan-mayen":p,mr:p,nl:p,nt:p,of:p,ol:p,oslo:p,rl:p,sf:p,st:p,svalbard:p,tm:p,tr:p,va:p,vf:p,akrehamn:e,"xn--krehamn-dxa":e,åkrehamn:e,algard:e,"xn\
--lgrd-poac":e,ålgård:e,arna:e,brumunddal:e,bryne:e,bronnoysund:e,"xn--brnnysund-m8ac":e,brønnøysund:e,drobak:e,"xn--drbak-wua":e,drøbak:e,egersund:e,fetsund:e,floro:e,"xn--flor-jra":e,florø:e,fredrikstad:e,hokksund:e,honefoss:e,"xn--hnefoss-q1a":e,hønefoss:e,jessheim:e,jorpeland:e,"xn--jrpeland-54a":e,jørpeland:e,kirkenes:e,kopervik:e,krokstadelva:e,langevag:e,"xn--langevg-jxa":e,langevåg:e,leirvik:e,mjondalen:e,"xn--mjndalen-64a":e,mjøndalen:e,"mo-i-rana":e,mosjoen:e,"xn--mosjen-eya":e,mosjøen:e,nesoddtangen:e,orkanger:e,osoyro:e,"xn--osyro-wua":e,osøyro:e,raholt:e,"xn--rholt-mra":e,råholt:e,sandnessjoen:e,"xn--sandnessjen-ogb":e,sandnessjøen:e,skedsmokorset:e,slattum:e,spjelkavik:e,stathelle:e,stavern:e,stjordalshalsen:e,"xn--stjrdalshalsen-sqb":e,stjørdalshalsen:e,tananger:e,tranby:e,vossevangen:e,afjord:e,"xn--fjord-lra":e,åfjord:e,agdenes:e,al:e,"xn--l-1fa":e,ål:e,alesund:e,"xn--lesund-hua":e,ålesund:e,alstahaug:e,alta:e,"xn--lt-liac":e,áltá:e,alaheadju:e,"xn-\
-laheadju-7ya":e,álaheadju:e,alvdal:e,amli:e,"xn--mli-tla":e,åmli:e,amot:e,"xn--mot-tla":e,åmot:e,andebu:e,andoy:e,"xn--andy-ira":e,andøy:e,andasuolo:e,ardal:e,"xn--rdal-poa":e,årdal:e,aremark:e,arendal:e,"xn--s-1fa":e,ås:e,aseral:e,"xn--seral-lra":e,åseral:e,asker:e,askim:e,askvoll:e,askoy:e,"xn--asky-ira":e,askøy:e,asnes:e,"xn--snes-poa":e,åsnes:e,audnedaln:e,aukra:e,aure:e,aurland:e,"aurskog-holand":e,"xn--aurskog-hland-jnb":e,"aurskog-høland":e,austevoll:e,austrheim:e,averoy:e,"xn--avery-yua":e,averøy:e,balestrand:e,ballangen:e,balat:e,"xn--blt-elab":e,bálát:e,balsfjord:e,bahccavuotna:e,"xn--bhccavuotna-k7a":e,báhccavuotna:e,bamble:e,bardu:e,beardu:e,beiarn:e,bajddar:e,"xn--bjddar-pta":e,bájddar:e,baidar:e,"xn--bidr-5nac":e,báidár:e,berg:e,bergen:e,berlevag:e,"xn--berlevg-jxa":e,berlevåg:e,bearalvahki:e,"xn--bearalvhki-y4a":e,bearalváhki:e,bindal:e,birkenes:e,bjarkoy:e,"xn--bjarky-fya":e,bjarkøy:e,bjerkreim:e,bjugn:e,bodo:e,"xn--bod-2na":e,bodø:e,badaddja:e,"xn\
--bdddj-mrabd":e,bådåddjå:e,budejju:e,bokn:e,bremanger:e,bronnoy:e,"xn--brnny-wuac":e,brønnøy:e,bygland:e,bykle:e,barum:e,"xn--brum-voa":e,bærum:e,telemark:[0,{bo:e,"xn--b-5ga":e,bø:e}],nordland:[0,{bo:e,"xn--b-5ga":e,bø:e,heroy:e,"xn--hery-ira":e,herøy:e}],bievat:e,"xn--bievt-0qa":e,bievát:e,bomlo:e,"xn--bmlo-gra":e,bømlo:e,batsfjord:e,"xn--btsfjord-9za":e,båtsfjord:e,bahcavuotna:e,"xn--bhcavuotna-s4a":e,báhcavuotna:e,dovre:e,drammen:e,drangedal:e,dyroy:e,"xn--dyry-ira":e,dyrøy:e,donna:e,"xn--dnna-gra":e,dønna:e,eid:e,eidfjord:e,eidsberg:e,eidskog:e,eidsvoll:e,eigersund:e,elverum:e,enebakk:e,engerdal:e,etne:e,etnedal:e,evenes:e,evenassi:e,"xn--eveni-0qa01ga":e,evenášši:e,"evje-og-hornnes":e,farsund:e,fauske:e,fuossko:e,fuoisku:e,fedje:e,fet:e,finnoy:e,"xn--finny-yua":e,finnøy:e,fitjar:e,fjaler:e,fjell:e,flakstad:e,flatanger:e,flekkefjord:e,flesberg:e,flora:e,fla:e,"xn--fl-zia":e,flå:e,folldal:e,forsand:e,fosnes:e,frei:e,frogn:e,froland:e,frosta:e,frana:e,"xn--frna-\
woa":e,fræna:e,froya:e,"xn--frya-hra":e,frøya:e,fusa:e,fyresdal:e,forde:e,"xn--frde-gra":e,førde:e,gamvik:e,gangaviika:e,"xn--ggaviika-8ya47h":e,gáŋgaviika:e,gaular:e,gausdal:e,gildeskal:e,"xn--gildeskl-g0a":e,gildeskål:e,giske:e,gjemnes:e,gjerdrum:e,gjerstad:e,gjesdal:e,gjovik:e,"xn--gjvik-wua":e,gjøvik:e,gloppen:e,gol:e,gran:e,grane:e,granvin:e,gratangen:e,grimstad:e,grong:e,kraanghke:e,"xn--kranghke-b0a":e,kråanghke:e,grue:e,gulen:e,hadsel:e,halden:e,halsa:e,hamar:e,hamaroy:e,habmer:e,"xn--hbmer-xqa":e,hábmer:e,hapmir:e,"xn--hpmir-xqa":e,hápmir:e,hammerfest:e,hammarfeasta:e,"xn--hmmrfeasta-s4ac":e,hámmárfeasta:e,haram:e,hareid:e,harstad:e,hasvik:e,aknoluokta:e,"xn--koluokta-7ya57h":e,ákŋoluokta:e,hattfjelldal:e,aarborte:e,haugesund:e,hemne:e,hemnes:e,hemsedal:e,"more-og-romsdal":[0,{heroy:e,sande:e}],"xn--mre-og-romsdal-qqb":[0,{"xn--hery-ira":e,sande:e}],"møre-og-romsdal":[0,{herøy:e,sande:e}],hitra:e,hjartdal:e,hjelmeland:e,hobol:e,"xn--hobl-ira":e,hobøl:e,hof:e,hol:e,
hole:e,holmestrand:e,holtalen:e,"xn--holtlen-hxa":e,holtålen:e,hornindal:e,horten:e,hurdal:e,hurum:e,hvaler:e,hyllestad:e,hagebostad:e,"xn--hgebostad-g3a":e,hægebostad:e,hoyanger:e,"xn--hyanger-q1a":e,høyanger:e,hoylandet:e,"xn--hylandet-54a":e,høylandet:e,ha:e,"xn--h-2fa":e,hå:e,ibestad:e,inderoy:e,"xn--indery-fya":e,inderøy:e,iveland:e,jevnaker:e,jondal:e,jolster:e,"xn--jlster-bya":e,jølster:e,karasjok:e,karasjohka:e,"xn--krjohka-hwab49j":e,kárášjohka:e,karlsoy:e,galsa:e,"xn--gls-elac":e,gálsá:e,karmoy:e,"xn--karmy-yua":e,karmøy:e,kautokeino:e,guovdageaidnu:e,klepp:e,klabu:e,"xn--klbu-woa":e,klæbu:e,kongsberg:e,kongsvinger:e,kragero:e,"xn--krager-gya":e,kragerø:e,kristiansand:e,kristiansund:e,krodsherad:e,"xn--krdsherad-m8a":e,krødsherad:e,kvalsund:e,rahkkeravju:e,"xn--rhkkervju-01af":e,ráhkkerávju:e,kvam:e,kvinesdal:e,kvinnherad:e,kviteseid:e,kvitsoy:e,"xn--kvitsy-fya":e,kvitsøy:e,kvafjord:e,"xn--kvfjord-nxa":e,kvæfjord:e,giehtavuoatna:e,kvanangen:e,"xn--kvnangen\
-k0a":e,kvænangen:e,navuotna:e,"xn--nvuotna-hwa":e,návuotna:e,kafjord:e,"xn--kfjord-iua":e,kåfjord:e,gaivuotna:e,"xn--givuotna-8ya":e,gáivuotna:e,larvik:e,lavangen:e,lavagis:e,loabat:e,"xn--loabt-0qa":e,loabát:e,lebesby:e,davvesiida:e,leikanger:e,leirfjord:e,leka:e,leksvik:e,lenvik:e,leangaviika:e,"xn--leagaviika-52b":e,leaŋgaviika:e,lesja:e,levanger:e,lier:e,lierne:e,lillehammer:e,lillesand:e,lindesnes:e,lindas:e,"xn--linds-pra":e,lindås:e,lom:e,loppa:e,lahppi:e,"xn--lhppi-xqa":e,láhppi:e,lund:e,lunner:e,luroy:e,"xn--lury-ira":e,lurøy:e,luster:e,lyngdal:e,lyngen:e,ivgu:e,lardal:e,lerdal:e,"xn--lrdal-sra":e,lærdal:e,lodingen:e,"xn--ldingen-q1a":e,lødingen:e,lorenskog:e,"xn--lrenskog-54a":e,lørenskog:e,loten:e,"xn--lten-gra":e,løten:e,malvik:e,masoy:e,"xn--msy-ula0h":e,måsøy:e,muosat:e,"xn--muost-0qa":e,muosát:e,mandal:e,marker:e,marnardal:e,masfjorden:e,meland:e,meldal:e,melhus:e,meloy:e,"xn--mely-ira":e,meløy:e,meraker:e,"xn--merker-kua":e,meråker:e,moareke:e,"xn--mo\
reke-jua":e,moåreke:e,midsund:e,"midtre-gauldal":e,modalen:e,modum:e,molde:e,moskenes:e,moss:e,mosvik:e,malselv:e,"xn--mlselv-iua":e,målselv:e,malatvuopmi:e,"xn--mlatvuopmi-s4a":e,málatvuopmi:e,namdalseid:e,aejrie:e,namsos:e,namsskogan:e,naamesjevuemie:e,"xn--nmesjevuemie-tcba":e,nååmesjevuemie:e,laakesvuemie:e,nannestad:e,narvik:e,narviika:e,naustdal:e,"nedre-eiker":e,akershus:f,buskerud:f,nesna:e,nesodden:e,nesseby:e,unjarga:e,"xn--unjrga-rta":e,unjárga:e,nesset:e,nissedal:e,nittedal:e,"nord-aurdal":e,"nord-fron":e,"nord-odal":e,norddal:e,nordkapp:e,davvenjarga:e,"xn--davvenjrga-y4a":e,davvenjárga:e,"nordre-land":e,nordreisa:e,raisa:e,"xn--risa-5na":e,ráisa:e,"nore-og-uvdal":e,notodden:e,naroy:e,"xn--nry-yla5g":e,nærøy:e,notteroy:e,"xn--nttery-byae":e,nøtterøy:e,odda:e,oksnes:e,"xn--ksnes-uua":e,øksnes:e,oppdal:e,oppegard:e,"xn--oppegrd-ixa":e,oppegård:e,orkdal:e,orland:e,"xn--rland-uua":e,ørland:e,orskog:e,"xn--rskog-uua":e,ørskog:e,orsta:e,"xn--rsta-fra":e,ørsta:e,
hedmark:[0,{os:e,valer:e,"xn--vler-qoa":e,våler:e}],hordaland:[0,{os:e}],osen:e,osteroy:e,"xn--ostery-fya":e,osterøy:e,"ostre-toten":e,"xn--stre-toten-zcb":e,"østre-toten":e,overhalla:e,"ovre-eiker":e,"xn--vre-eiker-k8a":e,"øvre-eiker":e,oyer:e,"xn--yer-zna":e,øyer:e,oygarden:e,"xn--ygarden-p1a":e,øygarden:e,"oystre-slidre":e,"xn--ystre-slidre-ujb":e,"øystre-slidre":e,porsanger:e,porsangu:e,"xn--porsgu-sta26f":e,porsáŋgu:e,porsgrunn:e,radoy:e,"xn--rady-ira":e,radøy:e,rakkestad:e,rana:e,ruovat:e,randaberg:e,rauma:e,rendalen:e,rennebu:e,rennesoy:e,"xn--rennesy-v1a":e,rennesøy:e,rindal:e,ringebu:e,ringerike:e,ringsaker:e,rissa:e,risor:e,"xn--risr-ira":e,risør:e,roan:e,rollag:e,rygge:e,ralingen:e,"xn--rlingen-mxa":e,rælingen:e,rodoy:e,"xn--rdy-0nab":e,rødøy:e,romskog:e,"xn--rmskog-bya":e,rømskog:e,roros:e,"xn--rros-gra":e,røros:e,rost:e,"xn--rst-0na":e,røst:e,royken:e,"xn--ryken-vua":e,røyken:e,royrvik:e,"xn--ryrvik-bya":e,røyrvik:e,rade:e,"xn--rde-ula":e,råde:e,salangen:e,
siellak:e,saltdal:e,salat:e,"xn--slt-elab":e,sálát:e,"xn--slat-5na":e,sálat:e,samnanger:e,vestfold:[0,{sande:e}],sandefjord:e,sandnes:e,sandoy:e,"xn--sandy-yua":e,sandøy:e,sarpsborg:e,sauda:e,sauherad:e,sel:e,selbu:e,selje:e,seljord:e,sigdal:e,siljan:e,sirdal:e,skaun:e,skedsmo:e,ski:e,skien:e,skiptvet:e,skjervoy:e,"xn--skjervy-v1a":e,skjervøy:e,skierva:e,"xn--skierv-uta":e,skiervá:e,skjak:e,"xn--skjk-soa":e,skjåk:e,skodje:e,skanland:e,"xn--sknland-fxa":e,skånland:e,skanit:e,"xn--sknit-yqa":e,skánit:e,smola:e,"xn--smla-hra":e,smøla:e,snillfjord:e,snasa:e,"xn--snsa-roa":e,snåsa:e,snoasa:e,snaase:e,"xn--snase-nra":e,snåase:e,sogndal:e,sokndal:e,sola:e,solund:e,songdalen:e,sortland:e,spydeberg:e,stange:e,stavanger:e,steigen:e,steinkjer:e,stjordal:e,"xn--stjrdal-s1a":e,stjørdal:e,stokke:e,"stor-elvdal":e,stord:e,stordal:e,storfjord:e,omasvuotna:e,strand:e,stranda:e,stryn:e,sula:e,suldal:e,sund:e,sunndal:e,surnadal:e,sveio:e,svelvik:e,sykkylven:e,sogne:e,"xn--sgne-gra":e,søgne:e,
somna:e,"xn--smna-gra":e,sømna:e,"sondre-land":e,"xn--sndre-land-0cb":e,"søndre-land":e,"sor-aurdal":e,"xn--sr-aurdal-l8a":e,"sør-aurdal":e,"sor-fron":e,"xn--sr-fron-q1a":e,"sør-fron":e,"sor-odal":e,"xn--sr-odal-q1a":e,"sør-odal":e,"sor-varanger":e,"xn--sr-varanger-ggb":e,"sør-varanger":e,"matta-varjjat":e,"xn--mtta-vrjjat-k7af":e,"mátta-várjjat":e,sorfold:e,"xn--srfold-bya":e,sørfold:e,sorreisa:e,"xn--srreisa-q1a":e,sørreisa:e,sorum:e,"xn--srum-gra":e,sørum:e,tana:e,deatnu:e,time:e,tingvoll:e,tinn:e,tjeldsund:e,dielddanuorri:e,tjome:e,"xn--tjme-hra":e,tjøme:e,tokke:e,tolga:e,torsken:e,tranoy:e,"xn--trany-yua":e,tranøy:e,tromso:e,"xn--troms-zua":e,tromsø:e,tromsa:e,romsa:e,trondheim:e,troandin:e,trysil:e,trana:e,"xn--trna-woa":e,træna:e,trogstad:e,"xn--trgstad-r1a":e,trøgstad:e,tvedestrand:e,tydal:e,tynset:e,tysfjord:e,divtasvuodna:e,divttasvuotna:e,tysnes:e,tysvar:e,"xn--tysvr-vra":e,tysvær:e,tonsberg:e,"xn--tnsberg-q1a":e,tønsberg:e,ullensaker:e,ullensvang:e,ulvik:e,
utsira:e,vadso:e,"xn--vads-jra":e,vadsø:e,cahcesuolo:e,"xn--hcesuolo-7ya35b":e,čáhcesuolo:e,vaksdal:e,valle:e,vang:e,vanylven:e,vardo:e,"xn--vard-jra":e,vardø:e,varggat:e,"xn--vrggt-xqad":e,várggát:e,vefsn:e,vaapste:e,vega:e,vegarshei:e,"xn--vegrshei-c0a":e,vegårshei:e,vennesla:e,verdal:e,verran:e,vestby:e,vestnes:e,"vestre-slidre":e,"vestre-toten":e,vestvagoy:e,"xn--vestvgy-ixa6o":e,vestvågøy:e,vevelstad:e,vik:e,vikna:e,vindafjord:e,volda:e,voss:e,varoy:e,"xn--vry-yla5g":e,værøy:e,vagan:e,"xn--vgan-qoa":e,vågan:e,voagat:e,vagsoy:e,"xn--vgsy-qoa0j":e,vågsøy:e,vaga:e,"xn--vg-yiab":e,vågå:e,ostfold:[0,{valer:e}],"xn--stfold-9xa":[0,{"xn--vler-qoa":e}],østfold:[0,{våler:e}]}],np:o,nr:m,nu:e,nz:[1,{ac:e,co:e,cri:e,geek:e,gen:e,govt:e,health:e,iwi:e,kiwi:e,maori:e,mil:e,"xn--mori-qsa":e,māori:e,net:e,org:e,parliament:e,school:e}],om:[1,{co:e,com:e,edu:e,gov:e,med:e,museum:e,net:e,org:e,pro:e}],onion:e,org:e,pa:[1,{ac:e,gob:e,com:e,org:e,sld:e,edu:e,net:e,ing:e,abo:e,med:e,
nom:e}],pe:[1,{edu:e,gob:e,nom:e,mil:e,org:e,com:e,net:e}],pf:[1,{com:e,org:e,edu:e}],pg:o,ph:[1,{com:e,net:e,org:e,gov:e,edu:e,ngo:e,mil:e,i:e}],pk:[1,{com:e,net:e,edu:e,org:e,fam:e,biz:e,web:e,gov:e,gob:e,gok:e,gon:e,gop:e,gos:e,info:e}],pl:[1,{com:e,net:e,org:e,aid:e,agro:e,atm:e,auto:e,biz:e,edu:e,gmina:e,gsm:e,info:e,mail:e,miasta:e,media:e,mil:e,nieruchomosci:e,nom:e,pc:e,powiat:e,priv:e,realestate:e,rel:e,sex:e,shop:e,sklep:e,sos:e,szkola:e,targi:e,tm:e,tourism:e,travel:e,turystyka:e,gov:[1,{ap:e,griw:e,ic:e,is:e,kmpsp:e,konsulat:e,kppsp:e,kwp:e,kwpsp:e,mup:e,mw:e,oia:e,oirm:e,oke:e,oow:e,oschr:e,oum:e,pa:e,pinb:e,piw:e,po:e,pr:e,psp:e,psse:e,pup:e,rzgw:e,sa:e,sdn:e,sko:e,so:e,sr:e,starostwo:e,ug:e,ugim:e,um:e,umig:e,upow:e,uppo:e,us:e,uw:e,uzs:e,wif:e,wiih:e,winb:e,wios:e,witd:e,wiw:e,wkz:e,wsa:e,wskr:e,wsse:e,wuoz:e,wzmiuw:e,zp:e,zpisdn:e}],augustow:e,"babia-gora":e,bedzin:e,beskidy:e,bialowieza:e,bialystok:e,bielawa:e,bieszczady:e,boleslawiec:e,bydgoszcz:e,bytom:e,cieszyn:e,czeladz:e,
czest:e,dlugoleka:e,elblag:e,elk:e,glogow:e,gniezno:e,gorlice:e,grajewo:e,ilawa:e,jaworzno:e,"jelenia-gora":e,jgora:e,kalisz:e,"kazimierz-dolny":e,karpacz:e,kartuzy:e,kaszuby:e,katowice:e,kepno:e,ketrzyn:e,klodzko:e,kobierzyce:e,kolobrzeg:e,konin:e,konskowola:e,kutno:e,lapy:e,lebork:e,legnica:e,lezajsk:e,limanowa:e,lomza:e,lowicz:e,lubin:e,lukow:e,malbork:e,malopolska:e,mazowsze:e,mazury:e,mielec:e,mielno:e,mragowo:e,naklo:e,nowaruda:e,nysa:e,olawa:e,olecko:e,olkusz:e,olsztyn:e,opoczno:e,opole:e,ostroda:e,ostroleka:e,ostrowiec:e,ostrowwlkp:e,pila:e,pisz:e,podhale:e,podlasie:e,polkowice:e,pomorze:e,pomorskie:e,prochowice:e,pruszkow:e,przeworsk:e,pulawy:e,radom:e,"rawa-maz":e,rybnik:e,rzeszow:e,sanok:e,sejny:e,slask:e,slupsk:e,sosnowiec:e,"stalowa-wola":e,skoczow:e,starachowice:e,stargard:e,suwalki:e,swidnica:e,swiebodzin:e,swinoujscie:e,szczecin:e,szczytno:e,tarnobrzeg:e,tgory:e,turek:e,tychy:e,ustka:e,walbrzych:e,warmia:e,warszawa:e,waw:e,wegrow:e,wielun:e,wlocl:e,wloclawek:e,wodzislaw:e,
wolomin:e,wroclaw:e,zachpomor:e,zagan:e,zarow:e,zgora:e,zgorzelec:e}],pm:e,pn:[1,{gov:e,co:e,org:e,edu:e,net:e}],post:e,pr:[1,{com:e,net:e,org:e,gov:e,edu:e,isla:e,pro:e,biz:e,info:e,name:e,est:e,prof:e,ac:e}],pro:[1,{aaa:e,aca:e,acct:e,avocat:e,bar:e,cpa:e,eng:e,jur:e,law:e,med:e,recht:e}],ps:[1,{edu:e,gov:e,sec:e,plo:e,com:e,org:e,net:e}],pt:[1,{net:e,gov:e,org:e,edu:e,int:e,publ:e,com:e,nome:e}],pw:[1,{co:e,ne:e,or:e,ed:e,go:e,belau:e}],py:[1,{com:e,coop:e,edu:e,gov:e,mil:e,net:e,org:e}],qa:l,re:[1,{asso:e,com:e,nom:e}],ro:[1,{arts:e,com:e,firm:e,info:e,nom:e,nt:e,org:e,rec:e,store:e,tm:e,www:e}],rs:[1,{ac:e,co:e,edu:e,gov:e,in:e,org:e}],ru:e,rw:[1,{ac:e,co:e,coop:e,gov:e,mil:e,net:e,org:e}],sa:[1,{com:e,net:e,org:e,gov:e,med:e,pub:e,edu:e,sch:e}],sb:n,sc:n,sd:[1,{com:e,net:e,org:e,edu:e,med:e,tv:e,gov:e,info:e}],se:[1,{a:e,ac:e,b:e,bd:e,brand:e,c:e,d:e,e,f:e,fh:e,fhsk:e,fhv:e,g:e,h:e,i:e,k:e,komforb:e,kommunalforbund:e,komvux:e,l:e,lanbib:e,m:e,n:e,naturbruksgymn:e,o:e,org:e,p:e,parti:e,
pp:e,press:e,r:e,s:e,t:e,tm:e,u:e,w:e,x:e,y:e,z:e}],sg:[1,{com:e,net:e,org:e,gov:e,edu:e,per:e}],sh:[1,{com:e,net:e,gov:e,org:e,mil:e}],si:e,sj:e,sk:e,sl:n,sm:e,sn:[1,{art:e,com:e,edu:e,gouv:e,org:e,perso:e,univ:e}],so:[1,{com:e,edu:e,gov:e,me:e,net:e,org:e}],sr:e,ss:[1,{biz:e,com:e,edu:e,gov:e,me:e,net:e,org:e,sch:e}],st:[1,{co:e,com:e,consulado:e,edu:e,embaixada:e,mil:e,net:e,org:e,principe:e,saotome:e,store:e}],su:e,sv:[1,{com:e,edu:e,gob:e,org:e,red:e}],sx:r,sy:t,sz:[1,{co:e,ac:e,org:e}],tc:e,td:e,tel:e,tf:e,tg:e,th:[1,{ac:e,co:e,go:e,in:e,mi:e,net:e,or:e}],tj:[1,{ac:e,biz:e,co:e,com:e,edu:e,go:e,gov:e,int:e,mil:e,name:e,net:e,nic:e,org:e,test:e,web:e}],tk:e,tl:r,tm:[1,{com:e,co:e,org:e,net:e,nom:e,gov:e,mil:e,edu:e}],tn:[1,{com:e,ens:e,fin:e,gov:e,ind:e,info:e,intl:e,mincom:e,nat:e,net:e,org:e,perso:e,tourism:e}],to:t,tr:[1,{av:e,bbs:e,bel:e,biz:e,com:e,dr:e,edu:e,gen:e,gov:e,info:e,mil:e,k12:e,kep:e,name:e,net:e,org:e,pol:e,tel:e,tsk:e,tv:e,web:e,nc:r}],tt:[1,{co:e,com:e,org:e,net:e,
biz:e,info:e,pro:e,int:e,coop:e,jobs:e,mobi:e,travel:e,museum:e,aero:e,name:e,gov:e,edu:e}],tv:e,tw:[1,{edu:e,gov:e,mil:e,com:e,net:e,org:e,idv:e,game:e,ebiz:e,club:e,"xn--zf0ao64a":e,網路:e,"xn--uc0atv":e,組織:e,"xn--czrw28b":e,商業:e}],tz:[1,{ac:e,co:e,go:e,hotel:e,info:e,me:e,mil:e,mobi:e,ne:e,or:e,sc:e,tv:e}],ua:[1,{com:e,edu:e,gov:e,in:e,net:e,org:e,cherkassy:e,cherkasy:e,chernigov:e,chernihiv:e,chernivtsi:e,chernovtsy:e,ck:e,cn:e,cr:e,crimea:e,cv:e,dn:e,dnepropetrovsk:e,dnipropetrovsk:e,donetsk:e,dp:e,if:e,"ivano-frankivsk":e,kh:e,kharkiv:e,kharkov:e,kherson:e,khmelnitskiy:e,khmelnytskyi:e,kiev:e,kirovograd:e,km:e,kr:e,kropyvnytskyi:e,krym:e,ks:e,kv:e,kyiv:e,lg:e,lt:e,lugansk:e,luhansk:e,lutsk:e,lv:e,lviv:e,mk:e,mykolaiv:e,nikolaev:e,od:e,odesa:e,odessa:e,pl:e,poltava:e,rivne:e,rovno:e,rv:e,sb:e,sebastopol:e,sevastopol:e,sm:e,sumy:e,te:e,ternopil:e,uz:e,uzhgorod:e,uzhhorod:e,vinnica:e,vinnytsia:e,vn:e,volyn:e,yalta:e,zakarpattia:e,zaporizhzhe:e,zaporizhzhia:e,zhitomir:e,zhytomyr:e,
zp:e,zt:e}],ug:[1,{co:e,or:e,ac:e,sc:e,go:e,ne:e,com:e,org:e}],uk:[1,{ac:e,co:e,gov:e,ltd:e,me:e,net:e,nhs:e,org:e,plc:e,police:e,sch:o}],us:[1,{dni:e,fed:e,isa:e,kids:e,nsn:e,ak:h,al:h,ar:h,as:h,az:h,ca:h,co:h,ct:h,dc:h,de:y,fl:h,ga:h,gu:h,hi:b,ia:h,id:h,il:h,in:h,ks:h,ky:h,la:h,ma:[1,{k12:[1,{pvt:e,chtr:e,paroch:e}],cc:e,lib:e}],md:h,me:h,mi:[1,{k12:e,cc:e,lib:e,"ann-arbor":e,cog:e,dst:e,eaton:e,gen:e,mus:e,tec:e,washtenaw:e}],mn:h,mo:h,ms:h,mt:h,nc:h,nd:b,ne:h,nh:h,nj:h,nm:h,nv:h,ny:h,oh:h,ok:h,or:h,pa:h,pr:h,ri:b,sc:h,sd:b,tn:h,tx:h,ut:h,vi:h,vt:h,va:h,wa:h,wi:h,wv:y,wy:h}],uy:[1,{com:e,edu:e,gub:e,mil:e,net:e,org:e}],uz:[1,{co:e,com:e,net:e,org:e}],va:e,vc:t,ve:[1,{arts:e,bib:e,co:e,com:e,e12:e,edu:e,firm:e,gob:e,gov:e,info:e,int:e,mil:e,net:e,nom:e,org:e,rar:e,rec:e,store:e,tec:e,web:e}],vg:e,vi:[1,{co:e,com:e,k12:e,net:e,org:e}],vn:[1,{ac:e,ai:e,biz:e,com:e,edu:e,gov:e,health:e,id:e,info:e,int:e,io:e,name:e,net:e,org:e,pro:e,angiang:e,bacgiang:e,backan:e,baclieu:e,bacninh:e,"bar\
ia-vungtau":e,bentre:e,binhdinh:e,binhduong:e,binhphuoc:e,binhthuan:e,camau:e,cantho:e,caobang:e,daklak:e,daknong:e,danang:e,dienbien:e,dongnai:e,dongthap:e,gialai:e,hagiang:e,haiduong:e,haiphong:e,hanam:e,hanoi:e,hatinh:e,haugiang:e,hoabinh:e,hungyen:e,khanhhoa:e,kiengiang:e,kontum:e,laichau:e,lamdong:e,langson:e,laocai:e,longan:e,namdinh:e,nghean:e,ninhbinh:e,ninhthuan:e,phutho:e,phuyen:e,quangbinh:e,quangnam:e,quangngai:e,quangninh:e,quangtri:e,soctrang:e,sonla:e,tayninh:e,thaibinh:e,thainguyen:e,thanhhoa:e,thanhphohochiminh:e,thuathienhue:e,tiengiang:e,travinh:e,tuyenquang:e,vinhlong:e,vinhphuc:e,yenbai:e}],vu:s,wf:e,ws:n,yt:e,"xn--mgbaam7a8h":e,امارات:e,"xn--y9a3aq":e,հայ:e,"xn--54b7fta0cc":e,বাংলা:e,"xn--90ae":e,бг:e,"xn--mgbcpq6gpa1a":e,البحرين:e,"xn--90ais":e,бел:e,"xn--fiqs8s":e,中国:e,"xn--fiqz9s":e,中國:e,"xn--lgbbat1ad8j":e,الجزائر:e,"xn--wgbh1c":e,مصر:e,"xn--e1a4c":e,ею:e,"xn--qxa6a":e,ευ:e,"xn--mgbah1a3hjkrd":e,موريتانيا:e,
"xn--node":e,გე:e,"xn--qxam":e,ελ:e,"xn--j6w193g":[1,{"xn--55qx5d":e,"xn--wcvs22d":e,"xn--mxtq1m":e,"xn--gmqw5a":e,"xn--od0alg":e,"xn--uc0atv":e}],香港:[1,{公司:e,教育:e,政府:e,個人:e,網絡:e,組織:e}],"xn--2scrj9c":e,ಭಾರತ:e,"xn--3hcrj9c":e,ଭାରତ:e,"xn--45br5cyl":e,ভাৰত:e,"xn--h2breg3eve":e,भारतम्:e,"xn--h2brj9c8c":e,भारोत:e,"xn--mgbgu82a":e,ڀارت:e,"xn--rvc1e0am3e":e,ഭാരതം:e,"xn--h2brj9c":e,भारत:e,"xn--mgbbh1a":e,بارت:e,"xn--mgbbh1a71e":e,بھارت:e,"xn--fpcrj9c3d":e,భారత్:e,"xn--gecrj9c":e,ભારત:e,"xn--s9brj9c":e,ਭਾਰਤ:e,"xn--45brj9c":e,ভারত:e,"xn--xkc2dl3a5ee0h":e,இந்தியா:e,"xn--mgba3a4f16a":e,ایران:e,"xn--mgba3a4fra":e,ايران:e,"xn--mgbtx2b":e,عراق:e,"xn--mgbayh7gpa":e,الاردن:e,"xn--3e0b707e":e,한국:e,"xn--80ao21a":e,қаз:e,"xn--q7ce6a":e,ລາວ:e,"xn--fzc2c9e2c":e,ලංකා:e,"xn--xkc2al3hye2a":e,இலங்கை:e,"\
xn--mgbc0a9azcg":e,المغرب:e,"xn--d1alf":e,мкд:e,"xn--l1acc":e,мон:e,"xn--mix891f":e,澳門:e,"xn--mix082f":e,澳门:e,"xn--mgbx4cd0ab":e,مليسيا:e,"xn--mgb9awbf":e,عمان:e,"xn--mgbai9azgqp6j":e,پاکستان:e,"xn--mgbai9a5eva00b":e,پاكستان:e,"xn--ygbi2ammx":e,فلسطين:e,"xn--90a3ac":[1,{"xn--o1ac":e,"xn--c1avg":e,"xn--90azh":e,"xn--d1at":e,"xn--o1ach":e,"xn--80au":e}],срб:[1,{пр:e,орг:e,обр:e,од:e,упр:e,ак:e}],"xn--p1ai":e,рф:e,"xn--wgbl6a":e,قطر:e,"xn--mgberp4a5d4ar":e,السعودية:e,"xn--mgberp4a5d4a87g":e,السعودیة:e,"xn--mgbqly7c0a67fbc":e,السعودیۃ:e,"xn--mgbqly7cvafr":e,السعوديه:e,"xn--mgbpl2fh":e,سودان:e,"xn--yfro4i67o":e,新加坡:e,"xn--clchc0ea0b2g2a9gcd":e,சிங்கப்பூர்:e,"xn--ogbpf8fl":e,سورية:e,"xn--mgbtf8fl":e,سوريا:e,"xn--o3cw4h":[1,{"xn--12c1fe0br":e,"xn--12co0c3b4eva":e,"xn--h3cuzk1di":e,"xn--o3cyx2a":e,"xn--m3ch0j3a":e,"xn--12cfi8ixb8l":e}],ไทย:[1,
{ศึกษา:e,ธุรกิจ:e,รัฐบาล:e,ทหาร:e,เน็ต:e,องค์กร:e}],"xn--pgbs0dh":e,تونس:e,"xn--kpry57d":e,台灣:e,"xn--kprw13d":e,台湾:e,"xn--nnx388a":e,臺灣:e,"xn--j1amh":e,укр:e,"xn--mgb2ddes":e,اليمن:e,xxx:e,ye:t,za:[0,{ac:e,agric:e,alt:e,co:e,edu:e,gov:e,grondar:e,law:e,mil:e,net:e,ngo:e,nic:e,nis:e,nom:e,org:e,school:e,tm:e,web:e}],zm:[1,{ac:e,biz:e,co:e,com:e,edu:e,gov:e,info:e,mil:e,net:e,org:e,sch:e}],zw:[1,{ac:e,co:e,gov:e,mil:e,org:e}],aaa:e,aarp:e,abb:e,abbott:e,abbvie:e,abc:e,able:e,abogado:e,abudhabi:e,academy:e,accenture:e,accountant:e,accountants:e,aco:e,actor:e,ads:e,adult:e,aeg:e,aetna:e,afl:e,africa:e,agakhan:e,agency:e,aig:e,airbus:e,airforce:e,airtel:e,akdn:e,alibaba:e,alipay:e,allfinanz:e,allstate:e,ally:e,alsace:e,alstom:e,amazon:e,americanexpress:e,americanfamily:e,amex:e,amfam:e,amica:e,amsterdam:e,analytics:e,android:e,anquan:e,anz:e,aol:e,apartments:e,app:e,apple:e,aquarelle:e,arab:e,aramco:e,archi:e,
army:e,art:e,arte:e,asda:e,associates:e,athleta:e,attorney:e,auction:e,audi:e,audible:e,audio:e,auspost:e,author:e,auto:e,autos:e,aws:e,axa:e,azure:e,baby:e,baidu:e,banamex:e,band:e,bank:e,bar:e,barcelona:e,barclaycard:e,barclays:e,barefoot:e,bargains:e,baseball:e,basketball:e,bauhaus:e,bayern:e,bbc:e,bbt:e,bbva:e,bcg:e,bcn:e,beats:e,beauty:e,beer:e,bentley:e,berlin:e,best:e,bestbuy:e,bet:e,bharti:e,bible:e,bid:e,bike:e,bing:e,bingo:e,bio:e,black:e,blackfriday:e,blockbuster:e,blog:e,bloomberg:e,blue:e,bms:e,bmw:e,bnpparibas:e,boats:e,boehringer:e,bofa:e,bom:e,bond:e,boo:e,book:e,booking:e,bosch:e,bostik:e,boston:e,bot:e,boutique:e,box:e,bradesco:e,bridgestone:e,broadway:e,broker:e,brother:e,brussels:e,build:e,builders:e,business:e,buy:e,buzz:e,bzh:e,cab:e,cafe:e,cal:e,call:e,calvinklein:e,cam:e,camera:e,camp:e,canon:e,capetown:e,capital:e,capitalone:e,car:e,caravan:e,cards:e,care:e,career:e,careers:e,cars:e,casa:e,case:e,cash:e,casino:e,catering:e,catholic:e,cba:e,cbn:e,cbre:e,center:e,
ceo:e,cern:e,cfa:e,cfd:e,chanel:e,channel:e,charity:e,chase:e,chat:e,cheap:e,chintai:e,christmas:e,chrome:e,church:e,cipriani:e,circle:e,cisco:e,citadel:e,citi:e,citic:e,city:e,claims:e,cleaning:e,click:e,clinic:e,clinique:e,clothing:e,cloud:e,club:e,clubmed:e,coach:e,codes:e,coffee:e,college:e,cologne:e,commbank:e,community:e,company:e,compare:e,computer:e,comsec:e,condos:e,construction:e,consulting:e,contact:e,contractors:e,cooking:e,cool:e,corsica:e,country:e,coupon:e,coupons:e,courses:e,cpa:e,credit:e,creditcard:e,creditunion:e,cricket:e,crown:e,crs:e,cruise:e,cruises:e,cuisinella:e,cymru:e,cyou:e,dabur:e,dad:e,dance:e,data:e,date:e,dating:e,datsun:e,day:e,dclk:e,dds:e,deal:e,dealer:e,deals:e,degree:e,delivery:e,dell:e,deloitte:e,delta:e,democrat:e,dental:e,dentist:e,desi:e,design:e,dev:e,dhl:e,diamonds:e,diet:e,digital:e,direct:e,directory:e,discount:e,discover:e,dish:e,diy:e,dnp:e,docs:e,doctor:e,dog:e,domains:e,dot:e,download:e,drive:e,dtv:e,dubai:e,dunlop:e,dupont:e,durban:e,dvag:e,
dvr:e,earth:e,eat:e,eco:e,edeka:e,education:e,email:e,emerck:e,energy:e,engineer:e,engineering:e,enterprises:e,epson:e,equipment:e,ericsson:e,erni:e,esq:e,estate:e,eurovision:e,eus:e,events:e,exchange:e,expert:e,exposed:e,express:e,extraspace:e,fage:e,fail:e,fairwinds:e,faith:e,family:e,fan:e,fans:e,farm:e,farmers:e,fashion:e,fast:e,fedex:e,feedback:e,ferrari:e,ferrero:e,fidelity:e,fido:e,film:e,final:e,finance:e,financial:e,fire:e,firestone:e,firmdale:e,fish:e,fishing:e,fit:e,fitness:e,flickr:e,flights:e,flir:e,florist:e,flowers:e,fly:e,foo:e,food:e,football:e,ford:e,forex:e,forsale:e,forum:e,foundation:e,fox:e,free:e,fresenius:e,frl:e,frogans:e,frontier:e,ftr:e,fujitsu:e,fun:e,fund:e,furniture:e,futbol:e,fyi:e,gal:e,gallery:e,gallo:e,gallup:e,game:e,games:e,gap:e,garden:e,gay:e,gbiz:e,gdn:e,gea:e,gent:e,genting:e,george:e,ggee:e,gift:e,gifts:e,gives:e,giving:e,glass:e,gle:e,global:e,globo:e,gmail:e,gmbh:e,gmo:e,gmx:e,godaddy:e,gold:e,goldpoint:e,golf:e,goo:e,goodyear:e,goog:e,google:e,
gop:e,got:e,grainger:e,graphics:e,gratis:e,green:e,gripe:e,grocery:e,group:e,gucci:e,guge:e,guide:e,guitars:e,guru:e,hair:e,hamburg:e,hangout:e,haus:e,hbo:e,hdfc:e,hdfcbank:e,health:e,healthcare:e,help:e,helsinki:e,here:e,hermes:e,hiphop:e,hisamitsu:e,hitachi:e,hiv:e,hkt:e,hockey:e,holdings:e,holiday:e,homedepot:e,homegoods:e,homes:e,homesense:e,honda:e,horse:e,hospital:e,host:e,hosting:e,hot:e,hotels:e,hotmail:e,house:e,how:e,hsbc:e,hughes:e,hyatt:e,hyundai:e,ibm:e,icbc:e,ice:e,icu:e,ieee:e,ifm:e,ikano:e,imamat:e,imdb:e,immo:e,immobilien:e,inc:e,industries:e,infiniti:e,ing:e,ink:e,institute:e,insurance:e,insure:e,international:e,intuit:e,investments:e,ipiranga:e,irish:e,ismaili:e,ist:e,istanbul:e,itau:e,itv:e,jaguar:e,java:e,jcb:e,jeep:e,jetzt:e,jewelry:e,jio:e,jll:e,jmp:e,jnj:e,joburg:e,jot:e,joy:e,jpmorgan:e,jprs:e,juegos:e,juniper:e,kaufen:e,kddi:e,kerryhotels:e,kerrylogistics:e,kerryproperties:e,kfh:e,kia:e,kids:e,kim:e,kindle:e,kitchen:e,kiwi:e,koeln:e,komatsu:e,kosher:e,kpmg:e,kpn:e,
krd:e,kred:e,kuokgroup:e,kyoto:e,lacaixa:e,lamborghini:e,lamer:e,lancaster:e,land:e,landrover:e,lanxess:e,lasalle:e,lat:e,latino:e,latrobe:e,law:e,lawyer:e,lds:e,lease:e,leclerc:e,lefrak:e,legal:e,lego:e,lexus:e,lgbt:e,lidl:e,life:e,lifeinsurance:e,lifestyle:e,lighting:e,like:e,lilly:e,limited:e,limo:e,lincoln:e,link:e,lipsy:e,live:e,living:e,llc:e,llp:e,loan:e,loans:e,locker:e,locus:e,lol:e,london:e,lotte:e,lotto:e,love:e,lpl:e,lplfinancial:e,ltd:e,ltda:e,lundbeck:e,luxe:e,luxury:e,madrid:e,maif:e,maison:e,makeup:e,man:e,management:e,mango:e,map:e,market:e,marketing:e,markets:e,marriott:e,marshalls:e,mattel:e,mba:e,mckinsey:e,med:e,media:e,meet:e,melbourne:e,meme:e,memorial:e,men:e,menu:e,merckmsd:e,miami:e,microsoft:e,mini:e,mint:e,mit:e,mitsubishi:e,mlb:e,mls:e,mma:e,mobile:e,moda:e,moe:e,moi:e,mom:e,monash:e,money:e,monster:e,mormon:e,mortgage:e,moscow:e,moto:e,motorcycles:e,mov:e,movie:e,msd:e,mtn:e,mtr:e,music:e,nab:e,nagoya:e,natura:e,navy:e,nba:e,nec:e,netbank:e,netflix:e,network:e,
neustar:e,new:e,news:e,next:e,nextdirect:e,nexus:e,nfl:e,ngo:e,nhk:e,nico:e,nike:e,nikon:e,ninja:e,nissan:e,nissay:e,nokia:e,norton:e,now:e,nowruz:e,nowtv:e,nra:e,nrw:e,ntt:e,nyc:e,obi:e,observer:e,office:e,okinawa:e,olayan:e,olayangroup:e,ollo:e,omega:e,one:e,ong:e,onl:e,online:e,ooo:e,open:e,oracle:e,orange:e,organic:e,origins:e,osaka:e,otsuka:e,ott:e,ovh:e,page:e,panasonic:e,paris:e,pars:e,partners:e,parts:e,party:e,pay:e,pccw:e,pet:e,pfizer:e,pharmacy:e,phd:e,philips:e,phone:e,photo:e,photography:e,photos:e,physio:e,pics:e,pictet:e,pictures:e,pid:e,pin:e,ping:e,pink:e,pioneer:e,pizza:e,place:e,play:e,playstation:e,plumbing:e,plus:e,pnc:e,pohl:e,poker:e,politie:e,porn:e,pramerica:e,praxi:e,press:e,prime:e,prod:e,productions:e,prof:e,progressive:e,promo:e,properties:e,property:e,protection:e,pru:e,prudential:e,pub:e,pwc:e,qpon:e,quebec:e,quest:e,racing:e,radio:e,read:e,realestate:e,realtor:e,realty:e,recipes:e,red:e,redstone:e,redumbrella:e,rehab:e,reise:e,reisen:e,reit:e,reliance:e,
ren:e,rent:e,rentals:e,repair:e,report:e,republican:e,rest:e,restaurant:e,review:e,reviews:e,rexroth:e,rich:e,richardli:e,ricoh:e,ril:e,rio:e,rip:e,rocks:e,rodeo:e,rogers:e,room:e,rsvp:e,rugby:e,ruhr:e,run:e,rwe:e,ryukyu:e,saarland:e,safe:e,safety:e,sakura:e,sale:e,salon:e,samsclub:e,samsung:e,sandvik:e,sandvikcoromant:e,sanofi:e,sap:e,sarl:e,sas:e,save:e,saxo:e,sbi:e,sbs:e,scb:e,schaeffler:e,schmidt:e,scholarships:e,school:e,schule:e,schwarz:e,science:e,scot:e,search:e,seat:e,secure:e,security:e,seek:e,select:e,sener:e,services:e,seven:e,sew:e,sex:e,sexy:e,sfr:e,shangrila:e,sharp:e,shaw:e,shell:e,shia:e,shiksha:e,shoes:e,shop:e,shopping:e,shouji:e,show:e,silk:e,sina:e,singles:e,site:e,ski:e,skin:e,sky:e,skype:e,sling:e,smart:e,smile:e,sncf:e,soccer:e,social:e,softbank:e,software:e,sohu:e,solar:e,solutions:e,song:e,sony:e,soy:e,spa:e,space:e,sport:e,spot:e,srl:e,stada:e,staples:e,star:e,statebank:e,statefarm:e,stc:e,stcgroup:e,stockholm:e,storage:e,store:e,stream:e,studio:e,study:e,style:e,
sucks:e,supplies:e,supply:e,support:e,surf:e,surgery:e,suzuki:e,swatch:e,swiss:e,sydney:e,systems:e,tab:e,taipei:e,talk:e,taobao:e,target:e,tatamotors:e,tatar:e,tattoo:e,tax:e,taxi:e,tci:e,tdk:e,team:e,tech:e,technology:e,temasek:e,tennis:e,teva:e,thd:e,theater:e,theatre:e,tiaa:e,tickets:e,tienda:e,tips:e,tires:e,tirol:e,tjmaxx:e,tjx:e,tkmaxx:e,tmall:e,today:e,tokyo:e,tools:e,top:e,toray:e,toshiba:e,total:e,tours:e,town:e,toyota:e,toys:e,trade:e,trading:e,training:e,travel:e,travelers:e,travelersinsurance:e,trust:e,trv:e,tube:e,tui:e,tunes:e,tushu:e,tvs:e,ubank:e,ubs:e,unicom:e,university:e,uno:e,uol:e,ups:e,vacations:e,vana:e,vanguard:e,vegas:e,ventures:e,verisign:e,versicherung:e,vet:e,viajes:e,video:e,vig:e,viking:e,villas:e,vin:e,vip:e,virgin:e,visa:e,vision:e,viva:e,vivo:e,vlaanderen:e,vodka:e,volvo:e,vote:e,voting:e,voto:e,voyage:e,wales:e,walmart:e,walter:e,wang:e,wanggou:e,watch:e,watches:e,weather:e,weatherchannel:e,webcam:e,weber:e,website:e,wed:e,wedding:e,weibo:e,weir:e,whoswho:e,
wien:e,wiki:e,williamhill:e,win:e,windows:e,wine:e,winners:e,wme:e,wolterskluwer:e,woodside:e,work:e,works:e,world:e,wow:e,wtc:e,wtf:e,xbox:e,xerox:e,xihuan:e,xin:e,"xn--11b4c3d":e,कॉम:e,"xn--1ck2e1b":e,セール:e,"xn--1qqw23a":e,佛山:e,"xn--30rr7y":e,慈善:e,"xn--3bst00m":e,集团:e,"xn--3ds443g":e,在线:e,"xn--3pxu8k":e,点看:e,"xn--42c2d9a":e,คอม:e,"xn--45q11c":e,八卦:e,"xn--4gbrim":e,موقع:e,"xn--55qw42g":e,公益:e,"xn--55qx5d":e,公司:e,"xn--5su34j936bgsg":e,香格里拉:e,"xn--5tzm5g":e,网站:e,"xn--6frz82g":e,移动:e,"xn--6qq986b3xl":e,我爱你:e,"xn--80adxhks":e,москва:e,"xn--80aqecdr1a":e,католик:e,"xn--80asehdb":e,онлайн:e,"xn--80aswg":e,сайт:e,"xn--8y0a063a":e,联通:e,"xn--9dbq2a":e,קום:e,"xn--9et52u":e,时尚:e,"xn--9krt00a":e,微博:e,"xn--b4w605ferd":e,淡马锡:e,"xn--bck1b9a5dre4c":e,ファッション:e,"xn--c1avg":e,орг:e,"xn--c2br7g":e,नेट:e,"xn--cck2b3b":e,ストア:e,"xn--cckwcxetd":e,アマゾン:e,"x\
n--cg4bki":e,삼성:e,"xn--czr694b":e,商标:e,"xn--czrs0t":e,商店:e,"xn--czru2d":e,商城:e,"xn--d1acj3b":e,дети:e,"xn--eckvdtc9d":e,ポイント:e,"xn--efvy88h":e,新闻:e,"xn--fct429k":e,家電:e,"xn--fhbei":e,كوم:e,"xn--fiq228c5hs":e,中文网:e,"xn--fiq64b":e,中信:e,"xn--fjq720a":e,娱乐:e,"xn--flw351e":e,谷歌:e,"xn--fzys8d69uvgm":e,電訊盈科:e,"xn--g2xx48c":e,购物:e,"xn--gckr3f0f":e,クラウド:e,"xn--gk3at1e":e,通販:e,"xn--hxt814e":e,网店:e,"xn--i1b6b1a6a2e":e,संगठन:e,"xn--imr513n":e,餐厅:e,"xn--io0a7i":e,网络:e,"xn--j1aef":e,ком:e,"xn--jlq480n2rg":e,亚马逊:e,"xn--jvr189m":e,食品:e,"xn--kcrx77d1x4a":e,飞利浦:e,"xn--kput3i":e,手机:e,"xn--mgba3a3ejt":e,ارامكو:e,"xn--mgba7c0bbn0a":e,العليان:e,"xn--mgbab2bd":e,بازار:e,"xn--mgbca7dzdo":e,ابوظبي:e,"xn--mgbi4ecexp":e,كاثوليك:e,"xn--mgbt3dhd":e,همراه:e,"xn--mk1bu44c":e,닷컴:e,"xn--mxtq1m":e,政府:e,"xn--ngbc5azd":e,شبكة:e,"xn--ngbe9e0a":e,بيتك:e,
"xn--ngbrx":e,عرب:e,"xn--nqv7f":e,机构:e,"xn--nqv7fs00ema":e,组织机构:e,"xn--nyqy26a":e,健康:e,"xn--otu796d":e,招聘:e,"xn--p1acf":e,рус:e,"xn--pssy2u":e,大拿:e,"xn--q9jyb4c":e,みんな:e,"xn--qcka1pmc":e,グーグル:e,"xn--rhqv96g":e,世界:e,"xn--rovu88b":e,書籍:e,"xn--ses554g":e,网址:e,"xn--t60b56a":e,닷넷:e,"xn--tckwe":e,コム:e,"xn--tiq49xqyj":e,天主教:e,"xn--unup4y":e,游戏:e,"xn--vermgensberater-ctb":e,vermögensberater:e,"xn--vermgensberatung-pwb":e,vermögensberatung:e,"xn--vhquv":e,企业:e,"xn--vuq861b":e,信息:e,"xn--w4r85el8fhu5dnra":e,嘉里大酒店:e,"xn--w4rs40l":e,嘉里:e,"xn--xhq521b":e,广东:e,"xn--zfr164b":e,政务:e,xyz:e,yachts:e,yahoo:e,yamaxun:e,yandex:e,yodobashi:e,yoga:e,yokohama:e,you:e,youtube:e,yun:e,zappos:e,zara:e,zero:e,zip:e,zone:e,zuerich:e}]}()});function z6(e,t,n){let r=null,a=t;for(;a!==void 0&&(a[0]===1&&(r={index:n+1}),n!==-1);){let o=a[1];a=Object.prototype.hasOwnProperty.call(o,e[n])?o[e[n]]:o["*"],n-=1}return r}function MT(e,t,n){var r;if(uy(e,t,n))return;let a=e.split("."),o=z6(a,U6,a.length-1);if(o!==null){n.publicSuffix=a.slice(o.index+1).join(".");return}let s=z6(a,j6,a.length-1);if(s!==null){n.publicSuffix=a.slice(s.index).join(".");return}n.publicSuffix=(r=a[a.length-1])!==null&&r!==void 0?r:null}var H6=g(()=>{d();_T();q6();i(z6,"lookupInTrie");i(MT,"suffixLookup")});function G6(e,t={}){return FT(W6),RT(e,3,MT,t,W6).domain}var W6,V6=g(()=>{d();_T();H6();W6=AT();i(G6,"getDomain")});var Nt,Yme,$6,Y6,se,Kme,kn=g(()=>{"use strict";d();N();Nt={didntCollectScreenshots:"Chrome didn't collect any screenshots during the page load. Please make sure there is content visible on the page, and then try re-running Lighthouse. ({errorCode})",badTraceRecording:"Something went wrong with recording the trace over your page load. Please run Lighthouse again. ({errorCode})",noFcp:"The page did not paint any content. Please ensure you keep the browser window in the foreground during the load and try again. ({errorCode})",noLcp:"The page did not display content that qualifies as a Largest Contentful Paint (LCP). Ensure the page has a valid LCP element and then try again. ({errorCode})",pageLoadTookTooLong:"Your page took too long to load. Please follow the opportunities in the report to reduce your page load time, and then try re-running Lighthouse. ({errorCode})",pageLoadFailed:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL a\
nd that the server is properly responding to all requests.",pageLoadFailedWithStatusCode:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Status code: {statusCode})",pageLoadFailedWithDetails:"Lighthouse was unable to reliably load the page you requested. Make sure you are testing the correct URL and that the server is properly responding to all requests. (Details: {errorDetails})",pageLoadFailedInsecure:"The URL you have provided does not have a valid security certificate. {securityMessages}",pageLoadFailedInterstitial:"Chrome prevented page load with an interstitial. Make sure you are testing the correct URL and that the server is properly responding to all requests.",internalChromeError:"An internal Chrome error occurred. Please restart Chrome and try re-running Lighthouse.",requestContentTimeout:"Fetching resource content has exceeded the allotted time",notHtml:"The\
 page provided is not HTML (served as MIME type {mimeType}).",urlInvalid:"The URL you have provided appears to be invalid.",protocolTimeout:"Waiting for DevTools protocol response has exceeded the allotted time. (Method: {protocolMethod})",dnsFailure:"DNS servers could not resolve the provided domain.",pageLoadFailedHung:"Lighthouse was unable to reliably load the URL you requested because the page stopped responding.",criTimeout:"Timeout waiting for initial Debugger Protocol connection.",missingRequiredArtifact:"Required {artifactName} gatherer did not run.",erroredRequiredArtifact:"Required {artifactName} gatherer encountered an error: {errorMessage}",oldChromeDoesNotSupportFeature:"This version of Chrome is too old to support '{featureName}'. Use a newer version to see full results.",targetCrashed:"Browser tab has unexpectedly crashed."},Yme=x("core/lib/lh-error.js",Nt),$6="__LighthouseErrorSentinel",Y6="__ErrorSentinel",se=class e extends Error{static{i(this,"LighthouseError")}constructor(t,n,r){
super(t.code,r),this.name="LighthouseError",this.code=t.code,this.friendlyMessage=Yme(t.message,{errorCode:this.code,...n}),this.lhrRuntimeError=!!t.lhrRuntimeError,n&&Object.assign(this,n),Error.captureStackTrace(this,e)}static fromProtocolMessage(t,n){let r=Object.values(e.errors).filter(s=>s.pattern).find(s=>s.pattern&&s.pattern.test(n.message));if(r)return new e(r);let a=`(${t}): ${n.message}`;n.data&&(a+=` (${n.data})`);let o=new Error(`Protocol error ${a}`);return Object.assign(o,{protocolMethod:t,protocolError:n.message})}static stringifyReplacer(t){if(t instanceof e){let{name:n,code:r,message:a,friendlyMessage:o,lhrRuntimeError:s,stack:c,cause:u,...l}=t;return{sentinel:$6,code:r,stack:c,cause:u,properties:l}}if(t instanceof Error){let{message:n,stack:r,cause:a}=t,o=t.code;return{sentinel:Y6,message:n,code:o,stack:r,cause:a}}throw new Error("Invalid value for LighthouseError stringification")}static parseReviver(t,n){if(typeof n=="object"&&n!==null){if(n.sentinel===$6){let{code:r,
stack:a,cause:o,properties:s}=n,c=e.errors[r],u=new e(c,s,{cause:o});return u.stack=a,u}if(n.sentinel===Y6){let{message:r,code:a,stack:o,cause:s}=n,c=s?{cause:s}:void 0,u=new Error(r,c);return Object.assign(u,{code:a,stack:o}),u}}return n}},Kme={NO_SPEEDLINE_FRAMES:{code:"NO_SPEEDLINE_FRAMES",message:Nt.didntCollectScreenshots,lhrRuntimeError:!0},SPEEDINDEX_OF_ZERO:{code:"SPEEDINDEX_OF_ZERO",message:Nt.didntCollectScreenshots,lhrRuntimeError:!0},NO_SCREENSHOTS:{code:"NO_SCREENSHOTS",message:Nt.didntCollectScreenshots,lhrRuntimeError:!0},INVALID_SPEEDLINE:{code:"INVALID_SPEEDLINE",message:Nt.didntCollectScreenshots,lhrRuntimeError:!0},NO_TRACING_STARTED:{code:"NO_TRACING_STARTED",message:Nt.badTraceRecording,lhrRuntimeError:!0},NO_RESOURCE_REQUEST:{code:"NO_RESOURCE_REQUEST",message:Nt.badTraceRecording,lhrRuntimeError:!0},NO_NAVSTART:{code:"NO_NAVSTART",message:Nt.badTraceRecording,lhrRuntimeError:!0},NO_FCP:{code:"NO_FCP",message:Nt.noFcp,lhrRuntimeError:!0},NO_DCL:{code:"NO_DCL",message:Nt.
badTraceRecording,lhrRuntimeError:!0},NO_FMP:{code:"NO_FMP",message:Nt.badTraceRecording},NO_LCP:{code:"NO_LCP",message:Nt.noLcp},NO_LCP_ALL_FRAMES:{code:"NO_LCP_ALL_FRAMES",message:Nt.noLcp},UNSUPPORTED_OLD_CHROME:{code:"UNSUPPORTED_OLD_CHROME",message:Nt.oldChromeDoesNotSupportFeature},NO_TTI_CPU_IDLE_PERIOD:{code:"NO_TTI_CPU_IDLE_PERIOD",message:Nt.pageLoadTookTooLong},NO_TTI_NETWORK_IDLE_PERIOD:{code:"NO_TTI_NETWORK_IDLE_PERIOD",message:Nt.pageLoadTookTooLong},NO_DOCUMENT_REQUEST:{code:"NO_DOCUMENT_REQUEST",message:Nt.pageLoadFailed,lhrRuntimeError:!0},FAILED_DOCUMENT_REQUEST:{code:"FAILED_DOCUMENT_REQUEST",message:Nt.pageLoadFailedWithDetails,lhrRuntimeError:!0},ERRORED_DOCUMENT_REQUEST:{code:"ERRORED_DOCUMENT_REQUEST",message:Nt.pageLoadFailedWithStatusCode,lhrRuntimeError:!0},INSECURE_DOCUMENT_REQUEST:{code:"INSECURE_DOCUMENT_REQUEST",message:Nt.pageLoadFailedInsecure,lhrRuntimeError:!0},CHROME_INTERSTITIAL_ERROR:{code:"CHROME_INTERSTITIAL_ERROR",message:Nt.pageLoadFailedInterstitial,
lhrRuntimeError:!0},PAGE_HUNG:{code:"PAGE_HUNG",message:Nt.pageLoadFailedHung,lhrRuntimeError:!0},NOT_HTML:{code:"NOT_HTML",message:Nt.notHtml,lhrRuntimeError:!0},TRACING_ALREADY_STARTED:{code:"TRACING_ALREADY_STARTED",message:Nt.internalChromeError,pattern:/Tracing.*started/,lhrRuntimeError:!0},PARSING_PROBLEM:{code:"PARSING_PROBLEM",message:Nt.internalChromeError,pattern:/Parsing problem/,lhrRuntimeError:!0},READ_FAILED:{code:"READ_FAILED",message:Nt.internalChromeError,pattern:/Read failed/,lhrRuntimeError:!0},INVALID_URL:{code:"INVALID_URL",message:Nt.urlInvalid},PROTOCOL_TIMEOUT:{code:"PROTOCOL_TIMEOUT",message:Nt.protocolTimeout,lhrRuntimeError:!0},DNS_FAILURE:{code:"DNS_FAILURE",message:Nt.dnsFailure,lhrRuntimeError:!0},CRI_TIMEOUT:{code:"CRI_TIMEOUT",message:Nt.criTimeout,lhrRuntimeError:!0},MISSING_REQUIRED_ARTIFACT:{code:"MISSING_REQUIRED_ARTIFACT",message:Nt.missingRequiredArtifact},ERRORED_REQUIRED_ARTIFACT:{code:"ERRORED_REQUIRED_ARTIFACT",message:Nt.erroredRequiredArtifact},
TARGET_CRASHED:{code:"TARGET_CRASHED",message:Nt.targetCrashed,lhrRuntimeError:!0}};se.errors=Kme;se.NO_ERROR="NO_ERROR";se.UNKNOWN_ERROR="UNKNOWN_ERROR"});function epe(e){return!e||!e.startsWith("chrome://")?e:(e.endsWith("/")&&(e=e.replace(/\/$/,"")),e.replace(/^chrome:\/\/chrome\//,"chrome://"))}var Jme,Xme,Zme,Qme,ly,he,Ht=g(()=>{"use strict";d();V6();Po();kn();Jme=["https:","http:","chrome:","chrome-extension:"],Xme=["data","https","wss","blob","chrome","chrome-extension","about","filesystem"],Zme=["localhost","127.0.0.1"],Qme=["blob","data","intent","file","filesystem","chrome-extension"];i(epe,"rewriteChromeInternalUrl");ly=class e{static{i(this,"UrlUtils")}static isValid(t){try{return new URL(t),!0}catch{return!1}}static hostsMatch(t,n){try{return new URL(t).host===new URL(n).host}catch{return!1}}static originsMatch(t,n){try{return new URL(t).origin===new URL(n).origin}catch{return!1}}static getOrigin(t){try{let n=new URL(t);return n.protocol==="chrome-extension:"?zt.getChromeExtensionOrigin(t):n.host&&n.origin||null}catch{return null}}static getRootDomain(t){let n=zt.createOrReturnURL(t);return G6(n.href)||n.hostname}static rootDomainsMatch(t,n){
let r,a;try{r=zt.createOrReturnURL(t),a=zt.createOrReturnURL(n)}catch{return!1}if(!r.hostname||!a.hostname)return!1;let o=e.getRootDomain(r),s=e.getRootDomain(a);return o===s}static getURLDisplayName(t,n){return zt.getURLDisplayName(new URL(t),n)}static elideDataURI(t){try{return new URL(t).protocol==="data:"?zt.truncate(t,100):t}catch{return t}}static equalWithExcludedFragments(t,n){[t,n]=[t,n].map(epe);try{let r=new URL(t);r.hash="";let a=new URL(n);return a.hash="",r.href===a.href}catch{return!1}}static isProtocolAllowed(t){try{let n=new URL(t);return Jme.includes(n.protocol)}catch{return!1}}static isLikeLocalhost(t){return Zme.includes(t)||t.endsWith(".localhost")}static isSecureScheme(t){return Xme.includes(t)}static isNonNetworkProtocol(t){let n=t.includes(":")?t.slice(0,t.indexOf(":")):t;return Qme.includes(n)}static guessMimeType(t){let n;try{n=new URL(t)}catch{return}if(n.protocol==="data:"){let o=n.pathname.match(/^(image\/(png|jpeg|svg\+xml|webp|gif|avif))[;,]/);return o?o[1]:
void 0}let r=n.pathname.toLowerCase().match(/\.(png|jpeg|jpg|svg|webp|gif|avif)$/);if(!r)return;let a=r[1];return a==="svg"?"image/svg+xml":a==="jpg"?"image/jpeg":`image/${a}`}static normalizeUrl(t){if(t&&this.isValid(t)&&this.isProtocolAllowed(t))return new URL(t).href;throw new se(se.errors.INVALID_URL)}};ly.INVALID_URL_DEBUG_STRING="Lighthouse was unable to determine the URL of some script executions. It's possible a Chrome extension or other eval'd code is the source.";he=ly});var K6,J6,X6,Z6,Q6,e7,t7,dy,fe,Dn=g(()=>{"use strict";d();rr();hn();Ht();K6="X-TCPMs",J6="X-SSLMs",X6="X-RequestMs",Z6="X-ResponseMs",Q6="X-TotalMs",e7="X-TotalFetchedSize",t7="X-ProtocolIsH2",dy={XHR:"XHR",Fetch:"Fetch",EventSource:"EventSource",Script:"Script",Stylesheet:"Stylesheet",Image:"Image",Media:"Media",Font:"Font",Document:"Document",TextTrack:"TextTrack",WebSocket:"WebSocket",Other:"Other",Manifest:"Manifest",SignedExchange:"SignedExchange",Ping:"Ping",Preflight:"Preflight",CSPViolationReport:"CSPViolationReport",Prefetch:"Prefetch"},fe=class e{static{i(this,"NetworkRequest")}constructor(){this.requestId="",this.connectionId=0,this.connectionReused=!1,this.url="",this.protocol="",this.isSecure=!1,this.isValid=!1,this.parsedURL={scheme:""},this.documentURL="",this.rendererStartTime=-1,this.networkRequestTime=-1,this.responseHeadersEndTime=-1,this.networkEndTime=-1,this.transferSize=0,this.responseHeadersTransferSize=0,this.resourceSize=0,this.fromDiskCache=!1,this.fromMemoryCache=
!1,this.fromPrefetchCache=!1,this.lrStatistics=void 0,this.finished=!1,this.requestMethod="",this.statusCode=-1,this.redirectSource=void 0,this.redirectDestination=void 0,this.redirects=void 0,this.failed=!1,this.localizedFailDescription="",this.initiator={type:"other"},this.timing=void 0,this.resourceType=void 0,this.mimeType="",this.priority="Low",this.initiatorRequest=void 0,this.responseHeaders=[],this.responseHeadersText="",this.fetchedViaServiceWorker=!1,this.frameId="",this.sessionId=void 0,this.sessionTargetType=void 0,this.fromWorker=!1,this.isLinkPreload=!1}hasErrorStatusCode(){return this.statusCode>=400}setInitiatorRequest(t){this.initiatorRequest=t}onRequestWillBeSent(t){this.requestId=t.requestId;let n;try{n=new URL(t.request.url)}catch{return}this.url=t.request.url,this.documentURL=t.documentURL,this.parsedURL={scheme:n.protocol.split(":")[0],host:n.hostname,securityOrigin:n.origin},this.isSecure=he.isSecureScheme(this.parsedURL.scheme),this.rendererStartTime=t.timestamp*
1e3,this.networkRequestTime=this.rendererStartTime,this.responseHeadersEndTime=this.rendererStartTime,this.requestMethod=t.request.method,this.initiator=t.initiator,this.resourceType=t.type&&dy[t.type],this.priority=t.request.initialPriority,this.frameId=t.frameId,this.isLinkPreload=t.initiator.type==="preload"||!!t.request.isLinkPreload,this.isValid=!0}onRequestServedFromCache(){this.fromMemoryCache=!0}onResponseReceived(t){this._onResponse(t.response,t.timestamp,t.type),this._updateProtocolForLightrider(),this.frameId=t.frameId}onResponseReceivedExtraInfo(t){this.responseHeadersText=t.headersText||""}onDataReceived(t){this.resourceSize+=t.dataLength,t.encodedDataLength!==-1&&(this.transferSize+=t.encodedDataLength)}onLoadingFinished(t){this.finished||(this.finished=!0,this.networkEndTime=t.timestamp*1e3,t.encodedDataLength>=0&&(this.transferSize=t.encodedDataLength),this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),
this._updateTimingsForLightrider())}onLoadingFailed(t){this.finished||(this.finished=!0,this.networkEndTime=t.timestamp*1e3,this.failed=!0,this.resourceType=t.type&&dy[t.type],this.localizedFailDescription=t.errorText,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming(),this._updateTransferSizeForLightrider(),this._updateTimingsForLightrider())}onResourceChangedPriority(t){this.priority=t.newPriority}onRedirectResponse(t){if(!t.redirectResponse)throw new Error("Missing redirectResponse data");this._onResponse(t.redirectResponse,t.timestamp,t.type),this.resourceType=void 0,this.finished=!0,this.networkEndTime=t.timestamp*1e3,this._updateResponseHeadersEndTimeIfNecessary(),this._backfillReceiveHeaderStartTiming()}setSession(t){this.sessionId=t}get isOutOfProcessIframe(){return this.sessionTargetType==="iframe"}_onResponse(t,n,r){this.url=t.url,this.connectionId=t.connectionId,this.connectionReused=t.connectionReused,t.protocol&&(this.protocol=t.protocol),
this.responseTimestamp=n*1e3,this.transferSize=t.encodedDataLength,this.responseHeadersTransferSize=t.encodedDataLength,typeof t.fromDiskCache=="boolean"&&(this.fromDiskCache=t.fromDiskCache),typeof t.fromPrefetchCache=="boolean"&&(this.fromPrefetchCache=t.fromPrefetchCache),this.statusCode=t.status,this.timing=t.timing,r&&(this.resourceType=dy[r]),this.mimeType=t.mimeType,this.responseHeaders=e._headersDictToHeadersArray(t.headers),this.fetchedViaServiceWorker=!!t.fromServiceWorker,this.fromMemoryCache&&(this.timing=void 0),this.timing&&this._recomputeTimesWithResourceTiming(this.timing)}_recomputeTimesWithResourceTiming(t){if(t.requestTime===-1||t.receiveHeadersEnd===-1)return;this.networkRequestTime=t.requestTime*1e3;let n=this.networkRequestTime+t.receiveHeadersEnd;this.responseHeadersEndTime=n,this.responseTimestamp!==void 0&&(this.responseHeadersEndTime=Math.min(this.responseHeadersEndTime,this.responseTimestamp)),this.responseHeadersEndTime=Math.max(this.responseHeadersEndTime,this.
networkRequestTime),this.networkEndTime=Math.max(this.networkEndTime,this.responseHeadersEndTime)}_updateResponseHeadersEndTimeIfNecessary(){this.responseHeadersEndTime=Math.min(this.networkEndTime,this.responseHeadersEndTime)}_updateTransferSizeForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(r=>r.name===e7);if(!t)return;let n=parseFloat(t.value);isNaN(n)||(this.transferSize=n)}_updateProtocolForLightrider(){globalThis.isLightrider&&this.responseHeaders.some(t=>t.name===t7)&&(this.protocol="h2")}_backfillReceiveHeaderStartTiming(){!this.timing||this.timing.receiveHeadersStart!==void 0||(this.timing.receiveHeadersStart=this.timing.receiveHeadersEnd)}_updateTimingsForLightrider(){if(!globalThis.isLightrider)return;let t=this.responseHeaders.find(p=>p.name===Q6);if(!t)return;let n=parseInt(t.value),r=this.responseHeaders.find(p=>p.name===K6),a=this.responseHeaders.find(p=>p.name===J6),o=this.responseHeaders.find(p=>p.name===X6),s=this.responseHeaders.find(
p=>p.name===Z6),c=r?Math.max(0,parseInt(r.value)):0,u=a?Math.max(0,parseInt(a.value)):0,l=o?Math.max(0,parseInt(o.value)):0,m=s?Math.max(0,parseInt(s.value)):0;if(!Number.isNaN(c+l+m+n)){if(c+l+m!==n){if(Math.abs(c+l+m-n)>=25)return;n=c+l+m}u>c||(this.lrStatistics={endTimeDeltaMs:this.networkEndTime-(this.networkRequestTime+n),TCPMs:c,requestMs:l,responseMs:m},this.serverResponseTime=m)}}static getRequestIdForBackend(t){return t.replace(/(:redirect)+$/,"")}static _headersDictToHeadersArray(t){let n=[];for(let r of Object.keys(t)){let a=t[r].split(`
`);for(let o=0;o<a.length;++o)n.push({name:r,value:a[o]})}return n}static get TYPES(){return dy}static asLanternNetworkRequest(t){let n=t.timing,r;return globalThis.isLightrider&&t.lrStatistics&&(t.protocol.startsWith("h3")?n={connectStart:0,connectEnd:t.lrStatistics.TCPMs}:(n={connectStart:0,sslStart:t.lrStatistics.TCPMs/2,connectEnd:t.lrStatistics.TCPMs,sslEnd:t.lrStatistics.TCPMs},r=t.lrStatistics.requestMs)),t.fromWorker=t.sessionTargetType==="worker",{rawRequest:t,...t,timing:n,serverResponseTime:r}}static isNonNetworkRequest(t){return he.isNonNetworkProtocol(t.protocol)||he.isNonNetworkProtocol(t.parsedURL.scheme)}static isSecureRequest(t){return he.isSecureScheme(t.parsedURL.scheme)||he.isSecureScheme(t.protocol)||he.isLikeLocalhost(t.parsedURL.host)||e.isHstsRequest(t)}static isHstsRequest(t){let n=t.redirectDestination;return n?t.responseHeaders.find(o=>o.name==="Non-Authoritative-Reason")?.value==="HSTS"&&e.isSecureRequest(n):!1}static isContentEncoded(t){let n=globalThis.isLightrider?
[/^x-original-content-encoding$/i]:[/^content-encoding$/i,/^x-content-encoding-over-network$/i],r=["gzip","br","deflate","zstd"];return t.responseHeaders.some(a=>n.some(o=>a.name.match(o))&&r.includes(a.value))}static getResourceSizeOnNetwork(t){return Math.min(t.resourceSize||0,t.transferSize||1/0)}};fe.HEADER_TCP=K6;fe.HEADER_SSL=J6;fe.HEADER_REQ=X6;fe.HEADER_RES=Z6;fe.HEADER_TOTAL=Q6;fe.HEADER_FETCHED_SIZE=e7;fe.HEADER_PROTOCOL_IS_H2=t7});var tpe,zu,OT=g(()=>{"use strict";d();Co();ct();rr();hn();Dn();tpe=Et,zu=class e extends tpe{static{i(this,"NetworkRecorder")}constructor(){super(),this._records=[],this._recordsById=new Map}getRawRecords(){return Array.from(this._records)}onRequestStarted(t){this._records.push(t),this._recordsById.set(t.requestId,t),this.emit("requeststarted",t)}onRequestFinished(t){this.emit("requestfinished",t)}onRequestWillBeSent(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);if(!r){let s=new fe;s.onRequestWillBeSent(n),s.sessionId=t.sessionId,s.sessionTargetType=t.targetType,this.onRequestStarted(s),H.verbose("network",`request will be sent to ${s.url}`);return}if(!n.redirectResponse)return;let a={...n,initiator:r.initiator,requestId:`${r.requestId}:redirect`},o=new fe;o.onRequestWillBeSent(a),r.onRedirectResponse(n),H.verbose("network",`${r.url} redirected to ${o.url}`),r.redirectDestination=o,o.redirectSource=r,this.onRequestStarted(o),this.onRequestFinished(
r)}onRequestServedFromCache(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(H.verbose("network",`${r.url} served from cache`),r.onRequestServedFromCache())}onResponseReceived(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(H.verbose("network",`${r.url} response received`),r.onResponseReceived(n))}onResponseReceivedExtraInfo(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(H.verbose("network",`${r.url} response received extra info`),r.onResponseReceivedExtraInfo(n))}onDataReceived(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(H.verbose("network",`${r.url} data received`),r.onDataReceived(n))}onLoadingFinished(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(H.verbose("network",`${r.url} loading finished`),r.onLoadingFinished(n),this.onRequestFinished(
r))}onLoadingFailed(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&(H.verbose("network",`${r.url} loading failed`),r.onLoadingFailed(n),this.onRequestFinished(r))}onResourceChangedPriority(t){let n=t.params,r=this._findRealRequestAndSetSession(n.requestId,t.targetType,t.sessionId);r&&r.onResourceChangedPriority(n)}dispatch(t){switch(t.method){case"Network.requestWillBeSent":return this.onRequestWillBeSent(t);case"Network.requestServedFromCache":return this.onRequestServedFromCache(t);case"Network.responseReceived":return this.onResponseReceived(t);case"Network.responseReceivedExtraInfo":return this.onResponseReceivedExtraInfo(t);case"Network.dataReceived":return this.onDataReceived(t);case"Network.loadingFinished":return this.onLoadingFinished(t);case"Network.loadingFailed":return this.onLoadingFailed(t);case"Network.resourceChangedPriority":return this.onResourceChangedPriority(t);default:return}}_findRealRequestAndSetSession(t,n,r){let a=this.
_recordsById.get(t);if(!(!a||!a.isValid)){for(;a.redirectDestination;)a=a.redirectDestination;return a.setSession(r),a.sessionTargetType=n,a}}static _chooseInitiatorRequest(t,n){if(t.redirectSource)return t.redirectSource;let r=Cn.PageDependencyGraph.getNetworkInitiators(t)[0],a=n.get(r)||[];if(a=a.filter(o=>o.responseHeadersEndTime<=t.rendererStartTime&&o.finished&&!o.failed),a.length>1){let o=a.filter(s=>s.resourceType!==fe.TYPES.Other);o.length&&(a=o)}if(a.length>1){let o=a.filter(s=>s.frameId===t.frameId);o.length&&(a=o)}if(a.length>1&&t.initiator.type==="parser"){let o=a.filter(s=>s.resourceType===fe.TYPES.Document);o.length&&(a=o)}if(a.length>1){let o=a.filter(s=>s.isLinkPreload);if(o.length){let s=a.filter(u=>!u.isLinkPreload),c=s.every(u=>u.fromDiskCache||u.fromMemoryCache);s.length&&c&&(a=o)}}return a.length===1?a[0]:null}static recordsFromLogs(t){let n=new e;t.forEach(o=>n.dispatch(o));let r=n.getRawRecords().filter(o=>o.isValid),a=new Map;for(let o of r){let s=a.get(o.url)||
[];s.push(o),a.set(o.url,s)}for(let o of r){let s=e._chooseInitiatorRequest(o,a);s&&o.setInitiatorRequest(s);let c=o;for(;c.redirectDestination;)c=c.redirectDestination;if(c===o||c.redirects)continue;let u=[];for(let l=c.redirectSource;l;l=l.redirectSource)u.unshift(l);c.redirects=u}return r}}});var NT,ke,Bt=g(()=>{"use strict";d();rr();Qe();OT();NT=class{static{i(this,"NetworkRecords")}static async compute_(t){return zu.recordsFromLogs(t)}},ke=le(NT,null)});var PT,Ra,gc=g(()=>{"use strict";d();ct();hn();Qe();Bt();PT=class{static{i(this,"NetworkAnalysis")}static async compute_(t,n){let r=await ke.request(t,n),a=Lt.NetworkAnalyzer.analyze(r);return a||(H.error("NetworkAnalysis","Network analysis failed due to lack of transfer data"),{throughput:0,rtt:Number.POSITIVE_INFINITY,additionalRttByOrigin:new Map,serverResponseTimeByOrigin:new Map})}},Ra=le(PT,null)});var LT,zn,io=g(()=>{"use strict";d();Qe();hn();gc();LT=class{static{i(this,"LoadSimulator")}static async compute_(t,n){let r=await Ra.request(t.devtoolsLog,n);return Ho.Simulator.createSimulator({...t.settings,networkAnalysis:r})}static convertAnalysisToSaveableLanternData(t){let n={additionalRttByOrigin:{},serverResponseTimeByOrigin:{}};for(let[r,a]of t.additionalRttByOrigin.entries())r.startsWith("http")&&(n.additionalRttByOrigin[r]=a);for(let[r,a]of t.serverResponseTimeByOrigin.entries())r.startsWith("http")&&(n.serverResponseTimeByOrigin[r]=a);return n}},zn=le(LT,["devtoolsLog","settings"])});async function UT(e,t,n){let r=ta.createWriteStream(n?t+".gz":t);n?await I0.promises.pipeline(e,QL(),r):await I0.promises.pipeline(e,r)}function BT(e,t){if(ta.existsSync(e+".gz")&&(e=e+".gz"),!e.endsWith(".json.gz"))return JSON.parse(ta.readFileSync(e,"utf8"),t);let n=t5(ta.readFileSync(e));return JSON.parse(n.toString("utf8"),t)}function n7(e,t){return e.endsWith(t)||e.endsWith(t+".gz")}function o7(e){if(H.log("Reading artifacts from disk:",e),!ta.existsSync(e))throw new Error("No saved artifacts found at "+e);let t=BT(un.join(e,my),se.parseReviver),n=ta.readdirSync(e);return n.filter(r=>n7(r,vc)).forEach(r=>{t.devtoolsLogs||(t.devtoolsLogs={});let a=r.replace(vc+".gz","").replace(vc,""),o=BT(un.join(e,r));t.devtoolsLogs[a]=o,a===py&&(t.DevtoolsLog=o),a===fy&&(t.DevtoolsLogError=o)}),n.filter(r=>n7(r,yc)).forEach(r=>{t.traces||(t.traces={});let a=BT(un.join(e,r)),o=r.replace(yc+".gz","").replace(yc,"");t.traces[o]=Array.isArray(a)?{traceEvents:a}:a,o===py&&(t.Trace=t.traces[o]),o===fy&&
(t.TraceError=t.traces[o])}),Array.isArray(t.Timing)&&t.Timing.forEach(r=>r.gather=!0),t}function npe(e,t){return t instanceof Error?se.stringifyReplacer(t):t}async function i7(e,t,n={}){let r={msg:"Saving artifacts",id:"lh:assetSaver:saveArtifacts"};H.time(r),ta.mkdirSync(t,{recursive:!0});let a=ta.readdirSync(t);for(let h of a)(h.endsWith(yc)||h.endsWith(vc)||h.endsWith(yc+".gz")||h.endsWith(vc+".gz")||h===my||h===my+".gz")&&ta.unlinkSync(`${t}/${h}`);let{traces:o,devtoolsLogs:s,DevtoolsLog:c,Trace:u,DevtoolsLogError:l,TraceError:m,...p}=e;u&&await r7(u,`${t}/${py}${yc}`,n),m&&await r7(m,`${t}/${fy}${yc}`,n),c&&await a7(c,`${t}/${py}${vc}`,n),l&&await a7(l,`${t}/${fy}${vc}`,n);let f=JSON.stringify(p,npe,2);await UT(function*(){yield f,yield`
`},`${t}/${my}`,!!n.gzip),H.log("Artifacts saved to disk in folder:",t),H.timeEnd(r)}function s7(e,t){ta.writeFileSync(`${t}/lhr.report.json`,JSON.stringify(e,null,2))}function*c7(e){if(yield`[
`,e.length>0){let n=e[Symbol.iterator](),r=n.next().value;yield`  ${JSON.stringify(r)}`;let a=500,o="";for(let s of n)o+=`,
  ${JSON.stringify(s)}`,a--,a===0&&(yield o,a=500,o="");yield o}yield`
]`}function*rpe(e){let{traceEvents:t,...n}=e;yield`{
`,yield'"traceEvents": ',yield*c7(t);for(let[r,a]of Object.entries(n))yield`,
"${r}": ${JSON.stringify(a,null,2)}`;yield`}
`}function r7(e,t,n={}){let r=rpe(e);return UT(r,t,!!n.gzip)}function a7(e,t,n={}){return UT(function*(){yield*c7(e),yield`
`},t,!!n.gzip)}var my,yc,vc,py,fy,u7=g(()=>{"use strict";d();Ao();Fi();A0();Ad();aw();ct();hn();C6();k6();gc();io();kn();Fd();my="artifacts.json",yc=".trace.json",vc=".devtoolslog.json",py="defaultPass",fy="pageLoadError-defaultPass";i(UT,"writeJson");i(BT,"readJson");i(n7,"endsWithSuffix");i(o7,"loadArtifacts");i(npe,"stringifyReplacer");i(i7,"saveArtifacts");i(s7,"saveLhr");i(c7,"arrayOfObjectsJsonGenerator");i(rpe,"traceJsonGenerator");i(r7,"saveTrace");i(a7,"saveDevtoolsLog")});var Qi={};E(Qi,{defaultSettings:()=>ca,nonSimulatedSettingsOverrides:()=>Wu,screenEmulationMetrics:()=>hy,throttling:()=>Hu,userAgents:()=>Zi});var Hu,ope,ipe,hy,spe,cpe,Zi,ca,Wu,Qo=g(()=>{"use strict";d();hn();Hu=Ho.Constants.throttling,ope={mobile:!0,width:412,height:823,deviceScaleFactor:1.75,disabled:!1},ipe={mobile:!1,width:1350,height:940,deviceScaleFactor:1,disabled:!1},hy={mobile:ope,desktop:ipe},spe="Mozilla/5.0 (Linux; Android 11; moto g power (2022)) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Mobile Safari/537.36",cpe="Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36",Zi={mobile:spe,desktop:cpe},ca={output:"json",maxWaitForFcp:30*1e3,maxWaitForLoad:45*1e3,pauseAfterFcpMs:1e3,pauseAfterLoadMs:1e3,networkQuietThresholdMs:1e3,cpuQuietThresholdMs:1e3,formFactor:"mobile",throttling:Hu.mobileSlow4G,throttlingMethod:"simulate",screenEmulation:hy.mobile,emulatedUserAgent:Zi.mobile,auditMode:!1,gatherMode:!1,
clearStorageTypes:["file_systems","shader_cache","service_workers","cache_storage"],disableStorageReset:!1,debugNavigation:!1,channel:"node",usePassiveGathering:!1,disableFullPageScreenshot:!1,skipAboutBlank:!1,blankPage:"about:blank",ignoreStatusCode:!1,locale:"en-US",blockedUrlPatterns:null,additionalTraceCategories:null,extraHeaders:null,precomputedLanternData:null,onlyAudits:null,onlyCategories:null,skipAudits:null},Wu={pauseAfterFcpMs:5250,pauseAfterLoadMs:5250,networkQuietThresholdMs:5250,cpuQuietThresholdMs:5250}});var mt,wt,l7,gy,jT=g(()=>{"use strict";d();rr();Qo();N();mt={performanceCategoryTitle:"Performance",metricGroupTitle:"Metrics",insightGroupTitle:"Insights",firstPaintImprovementsGroupTitle:"First Paint Improvements",firstPaintImprovementsGroupDescription:"The most critical aspect of performance is how quickly pixels are rendered onscreen. Key metrics: First Contentful Paint, First Meaningful Paint",overallImprovementsGroupTitle:"Overall Improvements",overallImprovementsGroupDescription:"Enhance the overall loading experience, so the page is responsive and ready to use as soon as possible. Key metrics: Time to Interactive, Speed Index",diagnosticsGroupTitle:"Diagnostics",diagnosticsGroupDescription:"More information about the performance of your application. These numbers don't [directly affect](https://developer.chrome.com/docs/lighthouse/performance/performance-scoring/) the Performance score.",a11yCategoryTitle:"Accessibility",a11yCategoryDescription:"These checks highlight opportuni\
ties to [improve the accessibility of your web app](https://developer.chrome.com/docs/lighthouse/accessibility/). Automatic detection can only detect a subset of issues and does not guarantee the accessibility of your web app, so [manual testing](https://web.dev/articles/how-to-review) is also encouraged.",a11yCategoryManualDescription:"These items address areas which an automated testing tool cannot cover. Learn more in our guide on [conducting an accessibility review](https://web.dev/articles/how-to-review).",a11yBestPracticesGroupTitle:"Best practices",a11yBestPracticesGroupDescription:"These items highlight common accessibility best practices.",a11yColorContrastGroupTitle:"Contrast",a11yColorContrastGroupDescription:"These are opportunities to improve the legibility of your content.",a11yNamesLabelsGroupTitle:"Names and labels",a11yNamesLabelsGroupDescription:"These are opportunities to improve the semantics of the controls in your application. This may enhance the experience for u\
sers of assistive technology, like a screen reader.",a11yNavigationGroupTitle:"Navigation",a11yNavigationGroupDescription:"These are opportunities to improve keyboard navigation in your application.",a11yAriaGroupTitle:"ARIA",a11yAriaGroupDescription:"These are opportunities to improve the usage of ARIA in your application which may enhance the experience for users of assistive technology, like a screen reader.",a11yLanguageGroupTitle:"Internationalization and localization",a11yLanguageGroupDescription:"These are opportunities to improve the interpretation of your content by users in different locales.",a11yAudioVideoGroupTitle:"Audio and video",a11yAudioVideoGroupDescription:"These are opportunities to provide alternative content for audio and video. This may improve the experience for users with hearing or vision impairments.",a11yTablesListsVideoGroupTitle:"Tables and lists",a11yTablesListsVideoGroupDescription:"These are opportunities to improve the experience of reading tabular or\
 list data using assistive technology, like a screen reader.",seoCategoryTitle:"SEO",seoCategoryDescription:"These checks ensure that your page is following basic search engine optimization advice. There are many additional factors Lighthouse does not score here that may affect your search ranking, including performance on [Core Web Vitals](https://web.dev/explore/vitals). [Learn more about Google Search Essentials](https://support.google.com/webmasters/answer/35769).",seoCategoryManualDescription:"Run these additional validators on your site to check additional SEO best practices.",seoMobileGroupTitle:"Mobile Friendly",seoMobileGroupDescription:"Make sure your pages are mobile friendly so users don’t have to pinch or zoom in order to read the content pages. [Learn how to make pages mobile-friendly](https://developers.google.com/search/mobile-sites/).",seoContentGroupTitle:"Content Best Practices",seoContentGroupDescription:"Format your HTML in a way that enables crawlers to better u\
nderstand your app’s content.",seoCrawlingGroupTitle:"Crawling and Indexing",seoCrawlingGroupDescription:"To appear in search results, crawlers need access to your app.",bestPracticesCategoryTitle:"Best Practices",bestPracticesTrustSafetyGroupTitle:"Trust and Safety",bestPracticesUXGroupTitle:"User Experience",bestPracticesBrowserCompatGroupTitle:"Browser Compatibility",bestPracticesGeneralGroupTitle:"General"},wt=x("core/config/default-config.js",mt),l7={settings:ca,artifacts:[{id:"DevtoolsLog",gatherer:"devtools-log"},{id:"Trace",gatherer:"trace"},{id:"Accessibility",gatherer:"accessibility"},{id:"AnchorElements",gatherer:"anchor-elements"},{id:"CacheContents",gatherer:"cache-contents"},{id:"ConsoleMessages",gatherer:"console-messages"},{id:"CSSUsage",gatherer:"css-usage"},{id:"Doctype",gatherer:"dobetterweb/doctype"},{id:"DOMStats",gatherer:"dobetterweb/domstats"},{id:"FontSize",gatherer:"seo/font-size"},{id:"Inputs",gatherer:"inputs"},{id:"IFrameElements",gatherer:"iframe-element\
s"},{id:"ImageElements",gatherer:"image-elements"},{id:"InspectorIssues",gatherer:"inspector-issues"},{id:"JsUsage",gatherer:"js-usage"},{id:"LinkElements",gatherer:"link-elements"},{id:"MainDocumentContent",gatherer:"main-document-content"},{id:"MetaElements",gatherer:"meta-elements"},{id:"NetworkUserAgent",gatherer:"network-user-agent"},{id:"OptimizedImages",gatherer:"dobetterweb/optimized-images"},{id:"ResponseCompression",gatherer:"dobetterweb/response-compression"},{id:"RobotsTxt",gatherer:"seo/robots-txt"},{id:"Scripts",gatherer:"scripts"},{id:"SourceMaps",gatherer:"source-maps"},{id:"Stacks",gatherer:"stacks"},{id:"Stylesheets",gatherer:"stylesheets"},{id:"TraceElements",gatherer:"trace-elements"},{id:"ViewportDimensions",gatherer:"viewport-dimensions"},{id:"devtoolsLogs",gatherer:"devtools-log-compat"},{id:"traces",gatherer:"trace-compat"},{id:"FullPageScreenshot",gatherer:"full-page-screenshot"},{id:"BFCacheFailures",gatherer:"bf-cache-failures"}],audits:["is-on-https","redire\
cts-http","viewport","metrics/first-contentful-paint","metrics/largest-contentful-paint","metrics/first-meaningful-paint","metrics/speed-index","screenshot-thumbnails","final-screenshot","metrics/total-blocking-time","metrics/max-potential-fid","metrics/cumulative-layout-shift","metrics/interaction-to-next-paint","errors-in-console","server-response-time","metrics/interactive","user-timings","critical-request-chains","redirects","image-aspect-ratio","image-size-responsive","deprecations","third-party-cookies","mainthread-work-breakdown","bootup-time","uses-rel-preconnect","font-display","diagnostics","network-requests","network-rtt","network-server-latency","main-thread-tasks","metrics","resource-summary","third-party-summary","third-party-facades","largest-contentful-paint-element","lcp-lazy-loaded","layout-shifts","long-tasks","non-composited-animations","unsized-images","valid-source-maps","prioritize-lcp-image","csp-xss","has-hsts","origin-isolation","clickjacking-mitigation","scri\
pt-treemap-data","accessibility/accesskeys","accessibility/aria-allowed-attr","accessibility/aria-allowed-role","accessibility/aria-command-name","accessibility/aria-conditional-attr","accessibility/aria-deprecated-role","accessibility/aria-dialog-name","accessibility/aria-hidden-body","accessibility/aria-hidden-focus","accessibility/aria-input-field-name","accessibility/aria-meter-name","accessibility/aria-progressbar-name","accessibility/aria-prohibited-attr","accessibility/aria-required-attr","accessibility/aria-required-children","accessibility/aria-required-parent","accessibility/aria-roles","accessibility/aria-text","accessibility/aria-toggle-field-name","accessibility/aria-tooltip-name","accessibility/aria-treeitem-name","accessibility/aria-valid-attr-value","accessibility/aria-valid-attr","accessibility/button-name","accessibility/bypass","accessibility/color-contrast","accessibility/definition-list","accessibility/dlitem","accessibility/document-title","accessibility/duplicate\
-id-aria","accessibility/empty-heading","accessibility/form-field-multiple-labels","accessibility/frame-title","accessibility/heading-order","accessibility/html-has-lang","accessibility/html-lang-valid","accessibility/html-xml-lang-mismatch","accessibility/identical-links-same-purpose","accessibility/image-alt","accessibility/image-redundant-alt","accessibility/input-button-name","accessibility/input-image-alt","accessibility/label-content-name-mismatch","accessibility/label","accessibility/landmark-one-main","accessibility/link-name","accessibility/link-in-text-block","accessibility/list","accessibility/listitem","accessibility/meta-refresh","accessibility/meta-viewport","accessibility/object-alt","accessibility/select-name","accessibility/skip-link","accessibility/tabindex","accessibility/table-duplicate-name","accessibility/table-fake-caption","accessibility/target-size","accessibility/td-has-header","accessibility/td-headers-attr","accessibility/th-has-data-cells","accessibility/va\
lid-lang","accessibility/video-caption","accessibility/manual/custom-controls-labels","accessibility/manual/custom-controls-roles","accessibility/manual/focus-traps","accessibility/manual/focusable-controls","accessibility/manual/interactive-element-affordance","accessibility/manual/logical-tab-order","accessibility/manual/managed-focus","accessibility/manual/offscreen-content-hidden","accessibility/manual/use-landmarks","accessibility/manual/visual-order-follows-dom","byte-efficiency/uses-long-cache-ttl","byte-efficiency/total-byte-weight","byte-efficiency/offscreen-images","byte-efficiency/render-blocking-resources","byte-efficiency/unminified-css","byte-efficiency/unminified-javascript","byte-efficiency/unused-css-rules","byte-efficiency/unused-javascript","byte-efficiency/modern-image-formats","byte-efficiency/uses-optimized-images","byte-efficiency/uses-text-compression","byte-efficiency/uses-responsive-images","byte-efficiency/efficient-animated-content","byte-efficiency/duplicat\
ed-javascript","byte-efficiency/legacy-javascript","byte-efficiency/uses-responsive-images-snapshot","dobetterweb/doctype","dobetterweb/charset","dobetterweb/dom-size","dobetterweb/geolocation-on-start","dobetterweb/inspector-issues","dobetterweb/no-document-write","dobetterweb/js-libraries","dobetterweb/notification-on-start","dobetterweb/paste-preventing-inputs","dobetterweb/uses-http2","dobetterweb/uses-passive-event-listeners","seo/meta-description","seo/http-status-code","seo/font-size","seo/link-text","seo/crawlable-anchors","seo/is-crawlable","seo/robots-txt","seo/hreflang","seo/canonical","seo/manual/structured-data","work-during-interaction","bf-cache","insights/cls-culprits-insight","insights/document-latency-insight","insights/dom-size-insight","insights/duplicated-javascript-insight","insights/font-display-insight","insights/forced-reflow-insight","insights/image-delivery-insight","insights/interaction-to-next-paint-insight","insights/lcp-discovery-insight","insights/lcp-ph\
ases-insight","insights/network-dependency-tree-insight","insights/render-blocking-insight","insights/slow-css-selector-insight","insights/third-parties-insight","insights/use-cache-insight","insights/viewport-insight"],groups:{metrics:{title:wt(mt.metricGroupTitle)},insights:{title:wt(mt.insightGroupTitle)},diagnostics:{title:wt(mt.diagnosticsGroupTitle),description:wt(mt.diagnosticsGroupDescription)},"a11y-best-practices":{title:wt(mt.a11yBestPracticesGroupTitle),description:wt(mt.a11yBestPracticesGroupDescription)},"a11y-color-contrast":{title:wt(mt.a11yColorContrastGroupTitle),description:wt(mt.a11yColorContrastGroupDescription)},"a11y-names-labels":{title:wt(mt.a11yNamesLabelsGroupTitle),description:wt(mt.a11yNamesLabelsGroupDescription)},"a11y-navigation":{title:wt(mt.a11yNavigationGroupTitle),description:wt(mt.a11yNavigationGroupDescription)},"a11y-aria":{title:wt(mt.a11yAriaGroupTitle),description:wt(mt.a11yAriaGroupDescription)},"a11y-language":{title:wt(mt.a11yLanguageGroupTitle),
description:wt(mt.a11yLanguageGroupDescription)},"a11y-audio-video":{title:wt(mt.a11yAudioVideoGroupTitle),description:wt(mt.a11yAudioVideoGroupDescription)},"a11y-tables-lists":{title:wt(mt.a11yTablesListsVideoGroupTitle),description:wt(mt.a11yTablesListsVideoGroupDescription)},"seo-mobile":{title:wt(mt.seoMobileGroupTitle),description:wt(mt.seoMobileGroupDescription)},"seo-content":{title:wt(mt.seoContentGroupTitle),description:wt(mt.seoContentGroupDescription)},"seo-crawl":{title:wt(mt.seoCrawlingGroupTitle),description:wt(mt.seoCrawlingGroupDescription)},"best-practices-trust-safety":{title:wt(mt.bestPracticesTrustSafetyGroupTitle)},"best-practices-ux":{title:wt(mt.bestPracticesUXGroupTitle)},"best-practices-browser-compat":{title:wt(mt.bestPracticesBrowserCompatGroupTitle)},"best-practices-general":{title:wt(mt.bestPracticesGeneralGroupTitle)},hidden:{title:""}},categories:{performance:{title:wt(mt.performanceCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[
{id:"first-contentful-paint",weight:10,group:"metrics",acronym:"FCP"},{id:"largest-contentful-paint",weight:25,group:"metrics",acronym:"LCP"},{id:"total-blocking-time",weight:30,group:"metrics",acronym:"TBT"},{id:"cumulative-layout-shift",weight:25,group:"metrics",acronym:"CLS"},{id:"speed-index",weight:10,group:"metrics",acronym:"SI"},{id:"interaction-to-next-paint",weight:0,group:"metrics",acronym:"INP"},{id:"cls-culprits-insight",weight:0,group:"hidden"},{id:"document-latency-insight",weight:0,group:"hidden"},{id:"dom-size-insight",weight:0,group:"hidden"},{id:"duplicated-javascript-insight",weight:0,group:"hidden"},{id:"font-display-insight",weight:0,group:"hidden"},{id:"forced-reflow-insight",weight:0,group:"hidden"},{id:"image-delivery-insight",weight:0,group:"hidden"},{id:"interaction-to-next-paint-insight",weight:0,group:"hidden"},{id:"lcp-discovery-insight",weight:0,group:"hidden"},{id:"lcp-phases-insight",weight:0,group:"hidden"},{id:"network-dependency-tree-insight",weight:0,
group:"hidden"},{id:"render-blocking-insight",weight:0,group:"hidden"},{id:"slow-css-selector-insight",weight:0,group:"hidden"},{id:"third-parties-insight",weight:0,group:"hidden"},{id:"use-cache-insight",weight:0,group:"hidden"},{id:"viewport-insight",weight:0,group:"hidden"},{id:"interactive",weight:0,group:"hidden",acronym:"TTI"},{id:"max-potential-fid",weight:0,group:"hidden"},{id:"first-meaningful-paint",weight:0,acronym:"FMP",group:"hidden"},{id:"render-blocking-resources",weight:0,group:"diagnostics"},{id:"uses-responsive-images",weight:0,group:"diagnostics"},{id:"offscreen-images",weight:0,group:"diagnostics"},{id:"unminified-css",weight:0,group:"diagnostics"},{id:"unminified-javascript",weight:0,group:"diagnostics"},{id:"unused-css-rules",weight:0,group:"diagnostics"},{id:"unused-javascript",weight:0,group:"diagnostics"},{id:"uses-optimized-images",weight:0,group:"diagnostics"},{id:"modern-image-formats",weight:0,group:"diagnostics"},{id:"uses-text-compression",weight:0,group:"\
diagnostics"},{id:"uses-rel-preconnect",weight:0,group:"diagnostics"},{id:"server-response-time",weight:0,group:"diagnostics"},{id:"redirects",weight:0,group:"diagnostics"},{id:"uses-http2",weight:0,group:"diagnostics"},{id:"efficient-animated-content",weight:0,group:"diagnostics"},{id:"duplicated-javascript",weight:0,group:"diagnostics"},{id:"legacy-javascript",weight:0,group:"diagnostics"},{id:"prioritize-lcp-image",weight:0,group:"diagnostics"},{id:"total-byte-weight",weight:0,group:"diagnostics"},{id:"uses-long-cache-ttl",weight:0,group:"diagnostics"},{id:"dom-size",weight:0,group:"diagnostics"},{id:"critical-request-chains",weight:0,group:"diagnostics"},{id:"user-timings",weight:0,group:"diagnostics"},{id:"bootup-time",weight:0,group:"diagnostics"},{id:"mainthread-work-breakdown",weight:0,group:"diagnostics"},{id:"font-display",weight:0,group:"diagnostics"},{id:"third-party-summary",weight:0,group:"diagnostics"},{id:"third-party-facades",weight:0,group:"diagnostics"},{id:"largest-\
contentful-paint-element",weight:0,group:"diagnostics"},{id:"lcp-lazy-loaded",weight:0,group:"diagnostics"},{id:"layout-shifts",weight:0,group:"diagnostics"},{id:"uses-passive-event-listeners",weight:0,group:"diagnostics"},{id:"no-document-write",weight:0,group:"diagnostics"},{id:"long-tasks",weight:0,group:"diagnostics"},{id:"non-composited-animations",weight:0,group:"diagnostics"},{id:"unsized-images",weight:0,group:"diagnostics"},{id:"viewport",weight:0,group:"diagnostics"},{id:"uses-responsive-images-snapshot",weight:0,group:"diagnostics"},{id:"work-during-interaction",weight:0,group:"diagnostics"},{id:"bf-cache",weight:0,group:"diagnostics"},{id:"network-requests",weight:0,group:"hidden"},{id:"network-rtt",weight:0,group:"hidden"},{id:"network-server-latency",weight:0,group:"hidden"},{id:"main-thread-tasks",weight:0,group:"hidden"},{id:"diagnostics",weight:0,group:"hidden"},{id:"metrics",weight:0,group:"hidden"},{id:"screenshot-thumbnails",weight:0,group:"hidden"},{id:"final-scree\
nshot",weight:0,group:"hidden"},{id:"script-treemap-data",weight:0,group:"hidden"},{id:"resource-summary",weight:0,group:"hidden"}]},accessibility:{title:wt(mt.a11yCategoryTitle),description:wt(mt.a11yCategoryDescription),manualDescription:wt(mt.a11yCategoryManualDescription),supportedModes:["navigation","snapshot"],auditRefs:[{id:"accesskeys",weight:7,group:"a11y-navigation"},{id:"aria-allowed-attr",weight:10,group:"a11y-aria"},{id:"aria-allowed-role",weight:1,group:"a11y-aria"},{id:"aria-command-name",weight:7,group:"a11y-aria"},{id:"aria-conditional-attr",weight:7,group:"a11y-aria"},{id:"aria-deprecated-role",weight:1,group:"a11y-aria"},{id:"aria-dialog-name",weight:7,group:"a11y-aria"},{id:"aria-hidden-body",weight:10,group:"a11y-aria"},{id:"aria-hidden-focus",weight:7,group:"a11y-aria"},{id:"aria-input-field-name",weight:7,group:"a11y-aria"},{id:"aria-meter-name",weight:7,group:"a11y-aria"},{id:"aria-progressbar-name",weight:7,group:"a11y-aria"},{id:"aria-prohibited-attr",weight:7,
group:"a11y-aria"},{id:"aria-required-attr",weight:10,group:"a11y-aria"},{id:"aria-required-children",weight:10,group:"a11y-aria"},{id:"aria-required-parent",weight:10,group:"a11y-aria"},{id:"aria-roles",weight:7,group:"a11y-aria"},{id:"aria-text",weight:7,group:"a11y-aria"},{id:"aria-toggle-field-name",weight:7,group:"a11y-aria"},{id:"aria-tooltip-name",weight:7,group:"a11y-aria"},{id:"aria-treeitem-name",weight:7,group:"a11y-aria"},{id:"aria-valid-attr-value",weight:10,group:"a11y-aria"},{id:"aria-valid-attr",weight:10,group:"a11y-aria"},{id:"button-name",weight:10,group:"a11y-names-labels"},{id:"bypass",weight:7,group:"a11y-navigation"},{id:"color-contrast",weight:7,group:"a11y-color-contrast"},{id:"definition-list",weight:7,group:"a11y-tables-lists"},{id:"dlitem",weight:7,group:"a11y-tables-lists"},{id:"document-title",weight:7,group:"a11y-names-labels"},{id:"duplicate-id-aria",weight:10,group:"a11y-aria"},{id:"form-field-multiple-labels",weight:3,group:"a11y-names-labels"},{id:"fr\
ame-title",weight:7,group:"a11y-names-labels"},{id:"heading-order",weight:3,group:"a11y-navigation"},{id:"html-has-lang",weight:7,group:"a11y-language"},{id:"html-lang-valid",weight:7,group:"a11y-language"},{id:"html-xml-lang-mismatch",weight:3,group:"a11y-language"},{id:"image-alt",weight:10,group:"a11y-names-labels"},{id:"image-redundant-alt",weight:1,group:"a11y-names-labels"},{id:"input-button-name",weight:10,group:"a11y-names-labels"},{id:"input-image-alt",weight:10,group:"a11y-names-labels"},{id:"label",weight:7,group:"a11y-names-labels"},{id:"link-in-text-block",weight:7,group:"a11y-color-contrast"},{id:"link-name",weight:7,group:"a11y-names-labels"},{id:"list",weight:7,group:"a11y-tables-lists"},{id:"listitem",weight:7,group:"a11y-tables-lists"},{id:"meta-refresh",weight:10,group:"a11y-best-practices"},{id:"meta-viewport",weight:10,group:"a11y-best-practices"},{id:"object-alt",weight:7,group:"a11y-names-labels"},{id:"select-name",weight:7,group:"a11y-names-labels"},{id:"skip-li\
nk",weight:3,group:"a11y-names-labels"},{id:"tabindex",weight:7,group:"a11y-navigation"},{id:"table-duplicate-name",weight:1,group:"a11y-tables-lists"},{id:"target-size",weight:7,group:"a11y-best-practices"},{id:"td-headers-attr",weight:7,group:"a11y-tables-lists"},{id:"th-has-data-cells",weight:7,group:"a11y-tables-lists"},{id:"valid-lang",weight:7,group:"a11y-language"},{id:"video-caption",weight:10,group:"a11y-audio-video"},{id:"focusable-controls",weight:0},{id:"interactive-element-affordance",weight:0},{id:"logical-tab-order",weight:0},{id:"visual-order-follows-dom",weight:0},{id:"focus-traps",weight:0},{id:"managed-focus",weight:0},{id:"use-landmarks",weight:0},{id:"offscreen-content-hidden",weight:0},{id:"custom-controls-labels",weight:0},{id:"custom-controls-roles",weight:0},{id:"empty-heading",weight:0,group:"hidden"},{id:"identical-links-same-purpose",weight:0,group:"hidden"},{id:"landmark-one-main",weight:0,group:"hidden"},{id:"label-content-name-mismatch",weight:0,group:"hi\
dden"},{id:"table-fake-caption",weight:0,group:"hidden"},{id:"td-has-header",weight:0,group:"hidden"}]},"best-practices":{title:wt(mt.bestPracticesCategoryTitle),supportedModes:["navigation","timespan","snapshot"],auditRefs:[{id:"is-on-https",weight:5,group:"best-practices-trust-safety"},{id:"redirects-http",weight:1,group:"best-practices-trust-safety"},{id:"geolocation-on-start",weight:1,group:"best-practices-trust-safety"},{id:"notification-on-start",weight:1,group:"best-practices-trust-safety"},{id:"csp-xss",weight:0,group:"best-practices-trust-safety"},{id:"has-hsts",weight:0,group:"best-practices-trust-safety"},{id:"origin-isolation",weight:0,group:"best-practices-trust-safety"},{id:"clickjacking-mitigation",weight:0,group:"best-practices-trust-safety"},{id:"paste-preventing-inputs",weight:3,group:"best-practices-ux"},{id:"image-aspect-ratio",weight:1,group:"best-practices-ux"},{id:"image-size-responsive",weight:1,group:"best-practices-ux"},{id:"viewport",weight:1,group:"best-prac\
tices-ux"},{id:"font-size",weight:1,group:"best-practices-ux"},{id:"doctype",weight:1,group:"best-practices-browser-compat"},{id:"charset",weight:1,group:"best-practices-browser-compat"},{id:"js-libraries",weight:0,group:"best-practices-general"},{id:"deprecations",weight:5,group:"best-practices-general"},{id:"third-party-cookies",weight:5,group:"best-practices-general"},{id:"errors-in-console",weight:1,group:"best-practices-general"},{id:"valid-source-maps",weight:0,group:"best-practices-general"},{id:"inspector-issues",weight:1,group:"best-practices-general"}]},seo:{title:wt(mt.seoCategoryTitle),description:wt(mt.seoCategoryDescription),manualDescription:wt(mt.seoCategoryManualDescription),supportedModes:["navigation","snapshot"],auditRefs:[{id:"is-crawlable",weight:93/23,group:"seo-crawl"},{id:"document-title",weight:1,group:"seo-content"},{id:"meta-description",weight:1,group:"seo-content"},{id:"http-status-code",weight:1,group:"seo-crawl"},{id:"link-text",weight:1,group:"seo-conte\
nt"},{id:"crawlable-anchors",weight:1,group:"seo-crawl"},{id:"robots-txt",weight:1,group:"seo-crawl"},{id:"image-alt",weight:1,group:"seo-content"},{id:"hreflang",weight:1,group:"seo-content"},{id:"canonical",weight:1,group:"seo-content"},{id:"structured-data",weight:0}]}}};Object.defineProperty(l7,"UIStrings",{enumerable:!1,get:()=>mt});gy=l7});function d7(e,t){let n={timespan:0,snapshot:1,navigation:2},r=Math.min(...e.instance.meta.supportedModes.map(o=>n[o])),a=Math.min(...t.instance.meta.supportedModes.map(o=>n[o]));return r===n.timespan?a===n.timespan:r===n.snapshot?a===n.snapshot:!0}function m7(e,t){if(!t.startsWith("lighthouse-plugin-"))throw new Error(`plugin name '${t}' does not start with 'lighthouse-plugin-'`);if(e.categories?.[t])throw new Error(`plugin name '${t}' not allowed because it is the id of a category already found in config`)}function upe(e){let t=e.gatherer.instance;if(typeof t.meta!="object")throw new Error(`Gatherer for ${e.id} did not provide a meta object.`);if(t.meta.supportedModes.length===0)throw new Error(`Gatherer for ${e.id} did not support any gather modes.`);if(typeof t.getArtifact!="function"||t.getArtifact===Ee.prototype.getArtifact)throw new Error(`Gatherer for ${e.id} did not define a "getArtifact" method.`)}function qT(e){let{implementation:t,path:n}=e,r=n||t?.meta?.id||"Unknown audit";
if(typeof t.audit!="function"||t.audit===v.audit)throw new Error(`${r} has no audit() method.`);if(typeof t.meta.id!="string")throw new Error(`${r} has no meta.id property, or the property is not a string.`);if(!$a(t.meta.title))throw new Error(`${r} has no meta.title property, or the property is not a string.`);let a=t.meta.scoreDisplayMode||v.SCORING_MODES.BINARY;if(!$a(t.meta.failureTitle)&&a===v.SCORING_MODES.BINARY)throw new Error(`${r} has no meta.failureTitle and should.`);if($a(t.meta.description)){if(t.meta.description==="")throw new Error(`${r} has an empty meta.description string. Please add a description for the UI.`)}else throw new Error(`${r} has no meta.description property, or the property is not a string.`);if(!Array.isArray(t.meta.requiredArtifacts))throw new Error(`${r} has no meta.requiredArtifacts property, or the property is not an array.`)}function lpe(e,t,n){if(!e)return;let r=new Map((t||[]).map(a=>[a.implementation.meta.id,a]));Object.keys(e).forEach(a=>{e[a].
auditRefs.forEach((o,s)=>{if(!o.id)throw new Error(`missing an audit id at ${a}[${s}]`);let c=r.get(o.id);if(!c)throw new Error(`could not find ${o.id} audit for category ${a}`);let l=c.implementation.meta.scoreDisplayMode==="manual";if(a==="accessibility"&&!o.group&&!l)throw new Error(`${o.id} accessibility audit does not have a group`);if(o.weight>0&&l)throw new Error(`${o.id} is manual but has a positive weight`);if(o.group&&(!n||!n[o.group]))throw new Error(`${o.id} references unknown group ${o.group}`)})})}function zT(e){if(!e.formFactor)throw new Error("`settings.formFactor` must be defined as 'mobile' or 'desktop'. See https://github.com/GoogleChrome/lighthouse/blob/main/docs/emulation.md");if(!e.screenEmulation.disabled&&e.screenEmulation.mobile!==(e.formFactor==="mobile"))throw new Error(`Screen emulation mobile setting (${e.screenEmulation.mobile}) does not match formFactor setting (${e.formFactor}). See https://github.com/GoogleChrome/lighthouse/blob/main/docs/emulation.md`);
let t=e.skipAudits?.find(n=>e.onlyAudits?.includes(n));if(t)throw new Error(`${t} appears in both skipAudits and onlyAudits`)}function dpe(e){let t=new Set;for(let n of e){if(upe(n),t.has(n.id))throw new Error(`Config defined multiple artifacts with id '${n.id}'`);if(t.add(n.id),!!n.dependencies)for(let[r,{id:a}]of Object.entries(n.dependencies))t.has(a)||HT(n.id,r)}}function p7(e){dpe(e.artifacts||[]);for(let t of e.audits||[])qT(t);lpe(e.categories,e.audits,e.groups),zT(e.settings)}function HT(e,t){throw new Error([`Failed to find dependency "${t}" for "${e}" artifact`,"Check that...",`  1. A gatherer exposes a matching Symbol that satisfies "${t}".`,`  2. "${t}" is configured to run before "${e}"`].join(`
`))}function f7(e,t){throw new Error([`Dependency "${t}" for "${e}" artifact is invalid.`,"The dependency must be collected before the dependent."].join(`
`))}var WT=g(()=>{"use strict";d();ie();kt();N();i(d7,"isValidArtifactDependency");i(m7,"assertValidPluginName");i(upe,"assertValidArtifact");i(qT,"assertValidAudit");i(lpe,"assertValidCategories");i(zT,"assertValidSettings");i(dpe,"assertValidArtifacts");i(p7,"assertValidConfig");i(HT,"throwInvalidDependencyOrder");i(f7,"throwInvalidArtifactDependency")});function h7(e,t){if(!e)return new Set;t=t||Object.keys(e);let r=t.map(a=>e[a]).flatMap(a=>a?.auditRefs||[]);return new Set(r.map(a=>a.id))}function ype(e,t){if(!e)return null;if(!t)return e;let n=new Map(e.map(o=>[o.id,o])),r=new Set([...gpe,...t.flatMap(o=>o.implementation.meta.requiredArtifacts)]),a=0;for(;a!==r.size;){a=r.size;for(let o of r){let s=n.get(o);if(s&&s.dependencies)for(let c of Object.values(s.dependencies))r.add(c.id)}}return e.filter(o=>r.has(o.id))}function vpe(e,t){return e?e.filter(n=>n.gatherer.instance.meta.supportedModes.includes(t)):null}function bpe(e,t){if(!e)return null;let n=new Set(t.map(r=>r.id).concat(fpe));return e.filter(r=>r.implementation.meta.requiredArtifacts.every(o=>n.has(o)))}function wpe(e,t){return e?e.filter(n=>{let r=n.implementation.meta;return!r.supportedModes||r.supportedModes.includes(t)}):null}function xpe(e,t){if(!e)return null;let n=Object.entries(e).filter(([r,a])=>!a.supportedModes||a.supportedModes.includes(t));return Object.fromEntries(
n)}function Dpe(e,t){if(!e||!t)return e;let n=Object.entries(e).filter(([r])=>t.includes(r));return Object.fromEntries(n)}function Epe(e,t){if(t)for(let n of t)e?.[n]||H.warn("config",`unrecognized category in 'onlyCategories': ${n}`)}function g7(e,t){if(!e)return e;let n=new Map(t.map(a=>[a.implementation.meta.id,a.implementation.meta])),r=Object.entries(e).map(([a,o])=>{let s={...o,auditRefs:o.auditRefs.filter(l=>n.has(l.id))},c=s.auditRefs.length<o.auditRefs.length,u=s.auditRefs.every(l=>{let m=n.get(l.id);return m?m.scoreDisplayMode===v.SCORING_MODES.MANUAL:!1});return c&&u&&(s.auditRefs=[]),[a,s]}).filter(a=>typeof a[1]=="object"&&a[1].auditRefs.length);return Object.fromEntries(r)}function y7(e,t){let n=vpe(e.artifacts,t),r=wpe(e.audits,t),a=bpe(r,n||[]),o=xpe(e.categories,t),s=g7(o,a||[]);return{...e,artifacts:n,audits:a,categories:s}}function v7(e,t){let{onlyAudits:n,onlyCategories:r,skipAudits:a}=t;Epe(e.categories,r);let o=h7(e.categories,void 0);r?o=h7(e.categories,r):n?o=new Set:
(!e.categories||!Object.keys(e.categories).length)&&(o=new Set(e.audits?.map(p=>p.implementation.meta.id)));let s=new Set([...o,...n||[],...hpe].filter(p=>!a||!a.includes(p))),c=s.size&&e.audits?e.audits.filter(p=>s.has(p.implementation.meta.id)):e.audits,u=g7(e.categories,c||[]),l=Dpe(u,r),m=ype(e.artifacts,c);return m&&e.settings.disableFullPageScreenshot&&(m=m.filter(({id:p})=>p!=="FullPageScreenshot")),{...e,artifacts:m,audits:c,categories:l}}var ppe,fpe,hpe,gpe,b7=g(()=>{"use strict";d();ct();ie();ppe={fetchTime:"",LighthouseRunWarnings:"",BenchmarkIndex:"",settings:"",Timing:"",URL:"",PageLoadError:"",HostFormFactor:"",HostUserAgent:"",HostProduct:"",GatherContext:""},fpe=Object.keys(ppe),hpe=[],gpe=["Stacks","NetworkUserAgent","FullPageScreenshot"];i(h7,"getAuditIdsInCategories");i(ype,"filterArtifactsByAvailableAudits");i(vpe,"filterArtifactsByGatherMode");i(bpe,"filterAuditsByAvailableArtifacts");i(wpe,"filterAuditsByGatherMode");i(xpe,"filterCategoriesByGatherMode");i(Dpe,"fi\
lterCategoriesByExplicitFilters");i(Epe,"warnOnUnknownOnlyCategories");i(g7,"filterCategoriesByAvailableAudits");i(y7,"filterConfigByGatherMode");i(v7,"filterConfigByExplicitFilters")});function w7(e){return Array.isArray(e)&&e.every(qm)}function qm(e){return typeof e=="object"&&e!==null&&!Array.isArray(e)}function Tpe(e){return typeof e!="string"?!1:e==="navigation"||e==="timespan"||e==="snapshot"}function Spe(e){return Array.isArray(e)?e.every(Tpe):!1}function jm(e,t,n=""){n&&(n+=" ");let r=Object.keys(e);if(r.length>0){let a=r.join(", ");throw new Error(`${t} has unrecognized ${n}properties: [${a}]`)}}var GT,x7,D7=g(()=>{"use strict";d();N();i(w7,"isArrayOfUnknownObjects");i(qm,"isObjectOfUnknownProperties");i(Tpe,"objectIsGatherMode");i(Spe,"isArrayOfGatherModes");i(jm,"assertNoExcessProperties");GT=class e{static{i(this,"ConfigPlugin")}static _parseAuditsList(t,n){if(t!==void 0){if(!w7(t))throw new Error(`${n} has an invalid audits array.`);return t.map(r=>{let{path:a,...o}=r;if(jm(o,n,"audit"),typeof a!="string")throw new Error(`${n} has a missing audit path.`);return{path:a}})}}static _parseAuditRefsList(t,n){if(!w7(t))throw new Error(`${n} has no valid auditsR\
efs.`);return t.map(r=>{let{id:a,weight:o,group:s,...c}=r;if(jm(c,n,"auditRef"),typeof a!="string")throw new Error(`${n} has an invalid auditRef id.`);if(typeof o!="number")throw new Error(`${n} has an invalid auditRef weight.`);if(typeof s!="string"&&typeof s<"u")throw new Error(`${n} has an invalid auditRef group.`);let u=s&&`${n}-${s}`;return{id:a,weight:o,group:u}})}static _parseCategory(t,n){if(!qm(t))throw new Error(`${n} has no valid category.`);let{title:r,description:a,manualDescription:o,auditRefs:s,supportedModes:c,...u}=t;if(jm(u,n,"category"),!$a(r))throw new Error(`${n} has an invalid category tile.`);if(!$a(a)&&a!==void 0)throw new Error(`${n} has an invalid category description.`);if(!$a(o)&&o!==void 0)throw new Error(`${n} has an invalid category manualDescription.`);if(!Spe(c)&&c!==void 0)throw new Error(`${n} supportedModes must be an array, valid array values are "navigation", "timespan", and "snapshot".`);let l=e._parseAuditRefsList(s,n);return{title:r,auditRefs:l,
description:a,manualDescription:o,supportedModes:c}}static _parseGroups(t,n){if(t===void 0)return;if(!qm(t))throw new Error(`${n} groups json is not defined as an object.`);let r=Object.entries(t),a={};return r.forEach(([o,s])=>{if(!qm(s))throw new Error(`${n} has a group not defined as an object.`);let{title:c,description:u,...l}=s;if(jm(l,n,"group"),!$a(c))throw new Error(`${n} has an invalid group title.`);if(!$a(u)&&u!==void 0)throw new Error(`${n} has an invalid group description.`);a[`${n}-${o}`]={title:c,description:u}}),a}static parsePlugin(t,n){if(t=JSON.parse(JSON.stringify(t)),!qm(t))throw new Error(`${n} is not defined as an object.`);let{audits:r,category:a,groups:o,...s}=t;return jm(s,n),{audits:e._parseAuditsList(r,n),categories:{[n]:e._parseCategory(a,n)},groups:e._parseGroups(o,n)}}},x7=GT});var E7,T7=g(()=>{"use strict";d();Ao();hu();E7=`/*! axe v4.10.3
 * Copyright (c) 2015 - 2025 Deque Systems, Inc.
 *
 * Your use of this Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This entire copyright notice must appear in every copy of this file you
 * distribute or in any file that contains substantial portions of this source
 * code.
 */
!function e(t){var n=t,r=t.document;function a(e){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var o=o||{};function u(e){this.name="SupportError",this.cause=e.cause,this.message="\`".concat(e.cause,"\` - feature unsupported in your environment."),e.ruleId&&(this.ruleId=e.ruleId,this.message+=" Skipping ".concat(this.ruleId," rule.")),this.stack=(new Error).stack}o.version="4.10.3","function"==typeof define&&define.amd&&define("axe-core",[],(function(){return o})),"object"===("undefined"==typeof module?"undefined":a(module))&&module.exports&&"function"==typeof e.toString&&(o.source="("+e.toString()+')(typeof window === "object" ? window : this);',module.exports=o),"function"==typeof t.getComputedStyle&&(t.axe=o),(u.prototype=Object.create(Error.prototype)).constructor=u;var i=["node"],l=["relatedNodes"],s=["node"],c=["var\
iant"],d=["matches"],p=["chromium"],f=["noImplicit"],D=["noPresentational"],m=["precision","format","inGamut"],h=["space"],g=["algorithm"],b=["method"],v=["maxDeltaE","deltaEMethod","steps","maxSteps"],y=["node"],F=["environmentData"],w=["environmentData"],E=["environmentData"],C=["environmentData"],x=["environmentData"];function A(e,t,n){t=N(t);var r=e;if((t=k()?Reflect.construct(t,n||[],N(e).constructor):t.apply(e,n))&&("object"==a(t)||"function"==typeof t))return t;if(void 0!==t)throw new TypeError("Derived constructors may only return object or undefined");if(void 0!==(t=r))return t;throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}function k(){try{var e=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){})))}catch(e){}return(k=function(){return!!e})()}function N(e){return(N=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(e){return e.__proto__||Object.getPrototypeOf(e)})(e)}function B(e,t){if("function"!=typeof t\
&&null!==t)throw new TypeError("Super expression must either be null or a function");e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,writable:!0,configurable:!0}}),Object.defineProperty(e,"prototype",{writable:!1}),t&&T(e,t)}function T(e,t){return(T=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(e,t){return e.__proto__=t,e})(e,t)}function R(e,t,n){O(e,t),t.set(e,n)}function S(e,t){O(e,t),t.add(e)}function O(e,t){if(t.has(e))throw new TypeError("Cannot initialize the same private elements twice on an object")}function _(e,t){return e.get(P(e,t))}function M(e,t,n){e.set(P(e,t),n)}function P(e,t,n){if("function"==typeof e?e===t:e.has(t))return arguments.length<3?t:n;throw new TypeError("Private element is not present on this object")}function I(e,t){if(null==e)return{};var n,r=((e,t)=>{if(null==e)return{};var n,r={};for(n in e)!{}.hasOwnProperty.call(e,n)||t.includes(n)||(r[n]=e[n]);return r})(e,t);if(Object.getOwnPropertySymbols)for(var a=Object.getOwnProperty\
Symbols(e),o=0;o<a.length;o++)n=a[o],t.includes(n)||{}.propertyIsEnumerable.call(e,n)&&(r[n]=e[n]);return r}function j(e){return(e=>{if(Array.isArray(e))return X(e)})(e)||L(e)||K(e)||(()=>{throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")})()}function L(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}function q(){return(q=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var n,r=arguments[t];for(n in r)!{}.hasOwnProperty.call(r,n)||(e[n]=r[n])}return e}).apply(null,arguments)}function z(e,t){return $(e)||((e,t)=>{var n=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=n){var r,a,o,u,i=[],l=!0,s=!1;try{if(o=(n=n.call(e)).next,0===t){if(Object(n)!==n)return;l=!1}else for(;!(l=(r=o.call(n)).done)&&(i.push(r.value),i.length!==t);l=!0);}catch(e){s=!0,a=e}finally{tr\
y{if(!l&&null!=n.return&&(u=n.return(),Object(u)!==u))return}finally{if(s)throw a}}return i}})(e,t)||K(e,t)||V()}function V(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function $(e){if(Array.isArray(e))return e}function H(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function U(e,t){for(var n=0;n<t.length;n++){var r=t[n];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,W(r.key),r)}}function G(e,t,n){return t&&U(e.prototype,t),n&&U(e,n),Object.defineProperty(e,"prototype",{writable:!1}),e}function W(e){return e=((e,t)=>{if("object"!=a(e)||!e)return e;var n=e[Symbol.toPrimitive];if(void 0===n)return String(e);if(n=n.call(e,"string"),"object"==a(n))throw new TypeError("@@toPrimitive must return a primitive value.");return n})(e),"symbol"==a(e)?e:e+""}function Y(e,t){var n,r,a,o,u="und\
efined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(u)return a=!(r=!0),{s:function(){u=u.call(e)},n:function(){var e=u.next();return r=e.done,e},e:function(e){a=!0,n=e},f:function(){try{r||null==u.return||u.return()}finally{if(a)throw n}}};if(Array.isArray(e)||(u=K(e))||t&&e&&"number"==typeof e.length)return u&&(e=u),o=0,{s:t=function(){},n:function(){return o>=e.length?{done:!0}:{done:!1,value:e[o++]}},e:function(e){throw e},f:t};throw new TypeError("Invalid attempt to iterate non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function K(e,t){var n;if(e)return"string"==typeof e?X(e,t):"Map"===(n="Object"===(n={}.toString.call(e).slice(8,-1))&&e.constructor?e.constructor.name:n)||"Set"===n?Array.from(e):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?X(e,t):void 0}function X(e,t){(null==t||t>e.length)&&(t=e.length);for(var n=0,r=Array(t);n<t;n++)r[n]=e[n];return r}function a(e){return(a="function"=\
=typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}var Z,J,Q,ee,te,ne,re,ae,oe,ue,ie=void 0;function le(e,t){return function(){return t||e((t={exports:{}}).exports,t),t.exports}}function se(e,t){for(var n in t)fe(e,n,{get:t[n],enumerable:!0})}function ce(e){return function(e,t,n){if(t&&"object"===a(t)||"function"==typeof t){var r,o=Y(he(t));try{for(o.s();!(r=o.n()).done;)(()=>{var a=r.value;me.call(e,a)||"default"===a||fe(e,a,{get:function(){return t[a]},enumerable:!(n=ge(t,a))||n.enumerable})})()}catch(e){o.e(e)}finally{o.f()}}return e}((t=fe(null!=e?pe(De(e)):{},"default",e&&e.__esModule&&"default"in e?{get:function(){return e.default},enumerable:!0}:{value:e,enumerable:!0}),fe(t,"__esModule",{value:!0})),e);var t}function de(e,t,n){(t="symbol"!==a(t)?t+"":t)in e?fe(e,t,{enumerable:!0,configurable:!0,writable:!0,value:n}):e[t]=n}var pe=Object\
.create,fe=Object.defineProperty,De=Object.getPrototypeOf,me=Object.prototype.hasOwnProperty,he=Object.getOwnPropertyNames,ge=Object.getOwnPropertyDescriptor,be=le((function(e,t){t.exports=function(){}})),ve=le((function(e,t){var n=be()();t.exports=function(e){return e!==n&&null!==e}})),ye=le((function(e,t){var n=ve(),r=Array.prototype.forEach,a=Object.create;t.exports=function(e){var t=a(null);return r.call(arguments,(function(e){if(n(e)){var r,a=Object(e),o=t;for(r in a)o[r]=a[r]}})),t}})),Fe=le((function(e,t){t.exports=function(){var e=Math.sign;return"function"==typeof e&&1===e(10)&&-1===e(-20)}})),we=le((function(e,t){t.exports=function(e){return e=Number(e),isNaN(e)||0===e?e:0<e?1:-1}})),Ee=le((function(e,t){t.exports=Fe()()?Math.sign:we()})),Ce=le((function(e,t){var n=Ee(),r=Math.abs,a=Math.floor;t.exports=function(e){return isNaN(e)?0:0!==(e=Number(e))&&isFinite(e)?n(e)*a(r(e)):e}})),xe=le((function(e,t){var n=Ce(),r=Math.max;t.exports=function(e){return r(0,n(e))}})),Ae=le((fu\
nction(e,t){var n=xe();t.exports=function(e,t,r){return isNaN(e)?0<=t?r&&t?t-1:t:1:!1!==e&&n(e)}})),ke=le((function(e,t){t.exports=function(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e}})),Ne=le((function(e,t){var n=ve();t.exports=function(e){if(n(e))return e;throw new TypeError("Cannot use null or undefined")}})),Be=le((function(e,t){var n=ke(),r=Ne(),a=Function.prototype.bind,o=Function.prototype.call,u=Object.keys,i=Object.prototype.propertyIsEnumerable;t.exports=function(e,t){return function(l,s){var c,d=arguments[2],p=arguments[3];return l=Object(r(l)),n(s),c=u(l),p&&c.sort("function"==typeof p?a.call(p,l):void 0),"function"!=typeof e&&(e=c[e]),o.call(e,c,(function(e,n){return i.call(l,e)?o.call(s,d,l[e],e,l,n):t}))}}})),Te=le((function(e,t){t.exports=Be()("forEach")})),Re=le((function(){})),Se=le((function(e,t){t.exports=function(){var e=Object.assign;return"function"==typeof e&&(e(e={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),e.foo+e.bar+e.trzy==="r\
azdwatrzy")}})),Oe=le((function(e,t){t.exports=function(){try{return Object.keys("primitive"),!0}catch(e){return!1}}})),_e=le((function(e,t){var n=ve(),r=Object.keys;t.exports=function(e){return r(n(e)?Object(e):e)}})),Me=le((function(e,t){t.exports=Oe()()?Object.keys:_e()})),Pe=le((function(e,t){var n=Me(),r=Ne(),a=Math.max;t.exports=function(e,t){var o,u,i,l=a(arguments.length,2);for(e=Object(r(e)),i=function(n){try{e[n]=t[n]}catch(n){o=o||n}},u=1;u<l;++u)n(t=arguments[u]).forEach(i);if(void 0!==o)throw o;return e}})),Ie=le((function(e,t){t.exports=Se()()?Object.assign:Pe()})),je=le((function(e,t){var n=ve(),r={function:!0,object:!0};t.exports=function(e){return n(e)&&r[a(e)]||!1}})),Le=le((function(e,t){var n=Ie(),r=je(),a=ve(),o=Error.captureStackTrace;t.exports=function(e){e=new Error(e);var u=arguments[1],i=arguments[2];return a(i)||r(u)&&(i=u,u=null),a(i)&&n(e,i),a(u)&&(e.code=u),o&&o(e,t.exports),e}})),qe=le((function(e,t){var n=Ne(),r=Object.defineProperty,a=Object.getOwnPrope\
rtyDescriptor,o=Object.getOwnPropertyNames,u=Object.getOwnPropertySymbols;t.exports=function(e,t){var i,l=Object(n(t));if(e=Object(n(e)),o(l).forEach((function(n){try{r(e,n,a(t,n))}catch(n){i=n}})),"function"==typeof u&&u(l).forEach((function(n){try{r(e,n,a(t,n))}catch(n){i=n}})),void 0!==i)throw i;return e}})),ze=le((function(e,t){function n(e,t){return t}var r,a,o,u,i,l=xe();try{Object.defineProperty(n,"length",{configurable:!0,writable:!1,enumerable:!1,value:1})}catch(e){}1===n.length?(r={configurable:!0,writable:!1,enumerable:!1},a=Object.defineProperty,t.exports=function(e,t){return t=l(t),e.length===t?e:(r.value=t,a(e,"length",r))}):(u=qe(),i=[],o=function(e){var t,n=0;if(i[e])return i[e];for(t=[];e--;)t.push("a"+(++n).toString(36));return new Function("fn","return function ("+t.join(", ")+") { return fn.apply(this, arguments); };")},t.exports=function(e,t){if(t=l(t),e.length===t)return e;t=o(t)(e);try{u(t,e)}catch(e){}return t})})),Ve=le((function(e,t){t.exports=function(e){retu\
rn null!=e}})),$e=le((function(e,t){var n=Ve(),r={object:!0,function:!0,undefined:!0};t.exports=function(e){return!!n(e)&&hasOwnProperty.call(r,a(e))}})),He=le((function(e,t){var n=$e();t.exports=function(e){if(!n(e))return!1;try{return!!e.constructor&&e.constructor.prototype===e}catch(e){return!1}}})),Ue=le((function(e,t){var n=He();t.exports=function(e){if("function"!=typeof e)return!1;if(!hasOwnProperty.call(e,"length"))return!1;try{if("number"!=typeof e.length)return!1;if("function"!=typeof e.call)return!1;if("function"!=typeof e.apply)return!1}catch(e){return!1}return!n(e)}})),Ge=le((function(e,t){var n=Ue(),r=/^\\s*class[\\s{/}]/,a=Function.prototype.toString;t.exports=function(e){return!!n(e)&&!r.test(a.call(e))}})),We=le((function(e,t){var n="razdwatrzy";t.exports=function(){return"function"==typeof n.contains&&!0===n.contains("dwa")&&!1===n.contains("foo")}})),Ye=le((function(e,t){var n=String.prototype.indexOf;t.exports=function(e){return-1<n.call(this,e,arguments[1])}})),Ke=le\
((function(e,t){t.exports=We()()?String.prototype.contains:Ye()})),Xe=le((function(e,t){var n=Ve(),r=Ge(),a=Ie(),o=ye(),u=Ke();(t.exports=function(e,t){var r,i,l,s;return arguments.length<2||"string"!=typeof e?(s=t,t=e,e=null):s=arguments[2],n(e)?(r=u.call(e,"c"),i=u.call(e,"e"),l=u.call(e,"w")):i=!(r=l=!0),e={value:t,configurable:r,enumerable:i,writable:l},s?a(o(s),e):e}).gs=function(e,t,i){var l,s;return"string"!=typeof e?(s=i,i=t,t=e,e=null):s=arguments[3],n(t)?r(t)?n(i)?r(i)||(s=i,i=void 0):i=void 0:(s=t,t=i=void 0):t=void 0,e=n(e)?(l=u.call(e,"c"),u.call(e,"e")):!(l=!0),t={get:t,set:i,configurable:l,enumerable:e},s?a(o(s),t):t}})),Ze=le((function(e,t){var n=Xe(),r=ke(),o=Function.prototype.apply,u=Function.prototype.call,i=Object.create,l=Object.defineProperty,s=Object.defineProperties,c=Object.prototype.hasOwnProperty,d={configurable:!0,enumerable:!1,writable:!0},p=function(e,t){var n;return r(t),c.call(this,"__ee__")?n=this.__ee__:(n=d.value=i(null),l(this,"__ee__",d),d.value=nu\
ll),n[e]?"object"===a(n[e])?n[e].push(t):n[e]=[n[e],t]:n[e]=t,this},f=function(e,t){var n,a;return r(t),a=this,p.call(this,e,n=function(){D.call(a,e,n),o.call(t,this,arguments)}),n.__eeOnceListener__=t,this},D=function(e,t){var n,o,u,i;if(r(t),c.call(this,"__ee__")&&(n=this.__ee__)[e])if("object"===a(o=n[e]))for(i=0;u=o[i];++i)u!==t&&u.__eeOnceListener__!==t||(2===o.length?n[e]=o[i?0:1]:o.splice(i,1));else o!==t&&o.__eeOnceListener__!==t||delete n[e];return this},m=function(e){var t,n,r,i,l;if(c.call(this,"__ee__")&&(i=this.__ee__[e]))if("object"===a(i)){for(n=arguments.length,l=new Array(n-1),t=1;t<n;++t)l[t-1]=arguments[t];for(i=i.slice(),t=0;r=i[t];++t)o.call(r,this,l)}else switch(arguments.length){case 1:u.call(i,this);break;case 2:u.call(i,this,arguments[1]);break;case 3:u.call(i,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,l=new Array(n-1),t=1;t<n;++t)l[t-1]=arguments[t];o.call(i,this,l)}},h={on:p,once:f,off:D,emit:m},g={on:n(p),once:n(f),off:n(D),emit:n(m\
)},b=s({},g);t.exports=e=function(e){return null==e?i(b):s(Object(e),g)},e.methods=h})),Je=le((function(e,t){t.exports=function(){var e,t=Array.from;return"function"==typeof t&&(e=t(t=["raz","dwa"]),Boolean(e&&e!==t&&"dwa"===e[1]))}})),Qe=le((function(e,t){t.exports=function(){return"object"===("undefined"==typeof globalThis?"undefined":a(globalThis))&&!!globalThis&&globalThis.Array===Array}})),et=le((function(e,n){function r(){if("object"===("undefined"==typeof self?"undefined":a(self))&&self)return self;if("object"===(void 0===t?"undefined":a(t))&&t)return t;throw new Error("Unable to resolve global \`this\`")}n.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(e){return r()}try{return __global__||r()}finally{delete Object.prototype.__global__}}()})),tt=le((function(e,t){t.exports=Qe()()?globalThis:et()})),nt=le((function(e,t){var n=tt(),r={object:!0,symbol:!0};t.exports=function(){var e,t\
=n.Symbol;if("function"!=typeof t)return!1;e=t("test symbol");try{String(e)}catch(e){return!1}return!!r[a(t.iterator)]&&!!r[a(t.toPrimitive)]&&!!r[a(t.toStringTag)]}})),rt=le((function(e,t){t.exports=function(e){return!!e&&("symbol"===a(e)||!!e.constructor&&"Symbol"===e.constructor.name&&"Symbol"===e[e.constructor.toStringTag])}})),at=le((function(e,t){var n=rt();t.exports=function(e){if(n(e))return e;throw new TypeError(e+" is not a symbol")}})),ot=le((function(e,t){var n=Xe(),r=Object.create,a=Object.defineProperty,o=Object.prototype,u=r(null);t.exports=function(e){for(var t,r,i=0;u[e+(i||"")];)++i;return u[e+=i||""]=!0,a(o,t="@@"+e,n.gs(null,(function(e){r||(r=!0,a(this,t,n(e)),r=!1)}))),t}})),ut=le((function(e,t){var n=Xe(),r=tt().Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:n("",r&&r.hasInstance||e("hasInstance")),isConcatSpreadable:n("",r&&r.isConcatSpreadable||e("isConcatSpreadable")),iterator:n("",r&&r.iterator||e("iterator")),match:n("",r&&r.match\
||e("match")),replace:n("",r&&r.replace||e("replace")),search:n("",r&&r.search||e("search")),species:n("",r&&r.species||e("species")),split:n("",r&&r.split||e("split")),toPrimitive:n("",r&&r.toPrimitive||e("toPrimitive")),toStringTag:n("",r&&r.toStringTag||e("toStringTag")),unscopables:n("",r&&r.unscopables||e("unscopables"))})}})),it=le((function(e,t){var n=Xe(),r=at(),a=Object.create(null);t.exports=function(e){return Object.defineProperties(e,{for:n((function(t){return a[t]||(a[t]=e(String(t)))})),keyFor:n((function(e){for(var t in r(e),a)if(a[t]===e)return t}))})}})),lt=le((function(e,t){var n,r,o,u=Xe(),i=at(),l=tt().Symbol,s=ot(),c=ut(),d=it(),p=Object.create,f=Object.defineProperties,D=Object.defineProperty;if("function"==typeof l)try{String(l()),o=!0}catch(e){}else l=null;r=function(e){if(this instanceof r)throw new TypeError("Symbol is not a constructor");return n(e)},t.exports=n=function e(t){var n;if(this instanceof e)throw new TypeError("Symbol is not a constructor");return\
 o?l(t):(n=p(r.prototype),t=void 0===t?"":String(t),f(n,{__description__:u("",t),__name__:u("",s(t))}))},c(n),d(n),f(r.prototype,{constructor:u(n),toString:u("",(function(){return this.__name__}))}),f(n.prototype,{toString:u((function(){return"Symbol ("+i(this).__description__+")"})),valueOf:u((function(){return i(this)}))}),D(n.prototype,n.toPrimitive,u("",(function(){var e=i(this);return"symbol"===a(e)?e:e.toString()}))),D(n.prototype,n.toStringTag,u("c","Symbol")),D(r.prototype,n.toStringTag,u("c",n.prototype[n.toStringTag])),D(r.prototype,n.toPrimitive,u("c",n.prototype[n.toPrimitive]))})),st=le((function(e,t){t.exports=nt()()?tt().Symbol:lt()})),ct=le((function(e,t){var n=Object.prototype.toString,r=n.call(function(){return arguments}());t.exports=function(e){return n.call(e)===r}})),dt=le((function(e,t){var n=Object.prototype.toString,r=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);t.exports=function(e){return"function"==typeof e&&r(n.call(e))}})),pt=le((function(\
e,t){var n=Object.prototype.toString,r=n.call("");t.exports=function(e){return"string"==typeof e||e&&"object"===a(e)&&(e instanceof String||n.call(e)===r)||!1}})),ft=le((function(e,t){var n=st().iterator,r=ct(),a=dt(),o=xe(),u=ke(),i=Ne(),l=ve(),s=pt(),c=Array.isArray,d=Function.prototype.call,p={configurable:!0,enumerable:!0,writable:!0,value:null},f=Object.defineProperty;t.exports=function(e){var t,D,m,h,g,b,v,y,F,w,E=arguments[1],C=arguments[2];if(e=Object(i(e)),l(E)&&u(E),this&&this!==Array&&a(this))t=this;else{if(!E){if(r(e))return 1!==(g=e.length)?Array.apply(null,e):((h=new Array(1))[0]=e[0],h);if(c(e)){for(h=new Array(g=e.length),D=0;D<g;++D)h[D]=e[D];return h}}h=[]}if(!c(e))if(void 0!==(F=e[n])){for(v=u(F).call(e),t&&(h=new t),y=v.next(),D=0;!y.done;)w=E?d.call(E,C,y.value,D):y.value,t?(p.value=w,f(h,D,p)):h[D]=w,y=v.next(),++D;g=D}else if(s(e)){for(g=e.length,t&&(h=new t),m=D=0;D<g;++D)w=e[D],D+1<g&&55296<=(b=w.charCodeAt(0))&&b<=56319&&(w+=e[++D]),w=E?d.call(E,C,w,m):w,t?(p.\
value=w,f(h,m,p)):h[m]=w,++m;g=m}if(void 0===g)for(g=o(e.length),t&&(h=new t(g)),D=0;D<g;++D)w=E?d.call(E,C,e[D],D):e[D],t?(p.value=w,f(h,D,p)):h[D]=w;return t&&(p.value=null,h.length=g),h}})),Dt=le((function(e,t){t.exports=Je()()?Array.from:ft()})),mt=le((function(e,t){var n=Dt(),r=Array.isArray;t.exports=function(e){return r(e)?e:n(e)}})),ht=le((function(e,t){var n=mt(),r=ve(),a=ke(),o=Array.prototype.slice,u=function(e){return this.map((function(t,n){return t?t(e[n]):e[n]})).concat(o.call(e,this.length))};t.exports=function(e){return(e=n(e)).forEach((function(e){r(e)&&a(e)})),u.bind(e)}})),gt=le((function(e,t){var n=ke();t.exports=function(e){var t;return"function"==typeof e?{set:e,get:e}:(t={get:n(e.get)},void 0!==e.set?(t.set=n(e.set),e.delete&&(t.delete=n(e.delete)),e.clear&&(t.clear=n(e.clear))):t.set=t.get,t)}})),bt=le((function(e,t){var n=Le(),r=ze(),a=Xe(),o=Ze().methods,u=ht(),i=gt(),l=Function.prototype.apply,s=Function.prototype.call,c=Object.create,d=Object.defineProperti\
es,p=o.on,f=o.emit;t.exports=function(e,t,o){var D,m,h,g,b,v,y,F,w,E,C,x=c(null),A=!1!==t?t:isNaN(e.length)?1:e.length;return o.normalizer&&(E=i(o.normalizer),m=E.get,h=E.set,g=E.delete,b=E.clear),null!=o.resolvers&&(C=u(o.resolvers)),E=m?r((function(t){var r,a,o=arguments;if(C&&(o=C(o)),null!==(r=m(o))&&hasOwnProperty.call(x,r))return y&&D.emit("get",r,o,this),x[r];if(a=1===o.length?s.call(e,this,o[0]):l.call(e,this,o),null===r){if(null!==(r=m(o)))throw n("Circular invocation","CIRCULAR_INVOCATION");r=h(o)}else if(hasOwnProperty.call(x,r))throw n("Circular invocation","CIRCULAR_INVOCATION");return x[r]=a,F&&D.emit("set",r,null,a),a}),A):0===t?function(){var t;if(hasOwnProperty.call(x,"data"))return y&&D.emit("get","data",arguments,this),x.data;if(t=arguments.length?l.call(e,this,arguments):s.call(e,this),hasOwnProperty.call(x,"data"))throw n("Circular invocation","CIRCULAR_INVOCATION");return x.data=t,F&&D.emit("set","data",null,t),t}:function(t){var r,a=arguments;if(C&&(a=C(arguments\
)),r=String(a[0]),hasOwnProperty.call(x,r))return y&&D.emit("get",r,a,this),x[r];if(a=1===a.length?s.call(e,this,a[0]):l.call(e,this,a),hasOwnProperty.call(x,r))throw n("Circular invocation","CIRCULAR_INVOCATION");return x[r]=a,F&&D.emit("set",r,null,a),a},D={original:e,memoized:E,profileName:o.profileName,get:function(e){return C&&(e=C(e)),m?m(e):String(e[0])},has:function(e){return hasOwnProperty.call(x,e)},delete:function(e){var t;hasOwnProperty.call(x,e)&&(g&&g(e),t=x[e],delete x[e],w)&&D.emit("delete",e,t)},clear:function(){var e=x;b&&b(),x=c(null),D.emit("clear",e)},on:function(e,t){return"get"===e?y=!0:"set"===e?F=!0:"delete"===e&&(w=!0),p.call(this,e,t)},emit:f,updateEnv:function(){e=D.original}},o=m?r((function(e){var t=arguments;C&&(t=C(t)),null!==(t=m(t))&&D.delete(t)}),A):0===t?function(){return D.delete("data")}:function(e){return C&&(e=C(arguments)[0]),D.delete(e)},A=r((function(){var e=arguments;return 0===t?x.data:(C&&(e=C(e)),e=m?m(e):String(e[0]),x[e])})),v=r((functio\
n(){var e=arguments;return 0===t?D.has("data"):(C&&(e=C(e)),null!==(e=m?m(e):String(e[0]))&&D.has(e))})),d(E,{__memoized__:a(!0),delete:a(o),clear:a(D.clear),_get:a(A),_has:a(v)}),D}})),vt=le((function(e,t){var n=ke(),r=Te(),a=Re(),o=bt(),u=Ae();t.exports=function e(t){var i,l,s;if(n(t),(i=Object(arguments[1])).async&&i.promise)throw new Error("Options 'async' and 'promise' cannot be used together");return hasOwnProperty.call(t,"__memoized__")&&!i.force?t:(l=u(i.length,t.length,i.async&&a.async),s=o(t,l,i),r(a,(function(e,t){i[t]&&e(i[t],s,i)})),e.__profiler__&&e.__profiler__(s),s.updateEnv(),s.memoized)}})),yt=le((function(e,t){t.exports=function(e){var t,n,r=e.length;if(!r)return"";for(t=String(e[n=0]);--r;)t+=""+e[++n];return t}})),Ft=le((function(e,t){t.exports=function(e){return e?function(t){for(var n=String(t[0]),r=0,a=e;--a;)n+=""+t[++r];return n}:function(){return""}}})),wt=le((function(e,t){t.exports=function(){var e=Number.isNaN;return"function"==typeof e&&!e({})&&e(NaN)&\
&!e(34)}})),Et=le((function(e,t){t.exports=function(e){return e!=e}})),Ct=le((function(e,t){t.exports=wt()()?Number.isNaN:Et()})),xt=le((function(e,t){var n=Ct(),r=xe(),a=Ne(),o=Array.prototype.indexOf,u=Object.prototype.hasOwnProperty,i=Math.abs,l=Math.floor;t.exports=function(e){var t,s,c;if(!n(e))return o.apply(this,arguments);for(s=r(a(this).length),e=arguments[1],t=e=isNaN(e)?0:0<=e?l(e):r(this.length)-l(i(e));t<s;++t)if(u.call(this,t)&&(c=this[t],n(c)))return t;return-1}})),At=le((function(e,t){var n=xt(),r=Object.create;t.exports=function(){var e=0,t=[],a=r(null);return{get:function(e){var r,a=0,o=t,u=e.length;if(0===u)return o[u]||null;if(o=o[u]){for(;a<u-1;){if(-1===(r=n.call(o[0],e[a])))return null;o=o[1][r],++a}return-1===(r=n.call(o[0],e[a]))?null:o[1][r]||null}return null},set:function(r){var o,u=0,i=t,l=r.length;if(0===l)i[l]=++e;else{for(i[l]||(i[l]=[[],[]]),i=i[l];u<l-1;)-1===(o=n.call(i[0],r[u]))&&(o=i[0].push(r[u])-1,i[1].push([[],[]])),i=i[1][o],++u;-1===(o=n.call(i[\
0],r[u]))&&(o=i[0].push(r[u])-1),i[1][o]=++e}return a[e]=r,e},delete:function(e){var r,o=0,u=t,i=a[e],l=i.length,s=[];if(0===l)delete u[l];else if(u=u[l]){for(;o<l-1;){if(-1===(r=n.call(u[0],i[o])))return;s.push(u,r),u=u[1][r],++o}if(-1===(r=n.call(u[0],i[o])))return;for(e=u[1][r],u[0].splice(r,1),u[1].splice(r,1);!u[0].length&&s.length;)r=s.pop(),(u=s.pop())[0].splice(r,1),u[1].splice(r,1)}delete a[e]},clear:function(){t=[],a=r(null)}}}})),kt=le((function(e,t){var n=xt();t.exports=function(){var e=0,t=[],r=[];return{get:function(e){return-1===(e=n.call(t,e[0]))?null:r[e]},set:function(n){return t.push(n[0]),r.push(++e),e},delete:function(e){-1!==(e=n.call(r,e))&&(t.splice(e,1),r.splice(e,1))},clear:function(){t=[],r=[]}}}})),Nt=le((function(e,t){var n=xt(),r=Object.create;t.exports=function(e){var t=0,a=[[],[]],o=r(null);return{get:function(t){for(var r,o=0,u=a;o<e-1;){if(-1===(r=n.call(u[0],t[o])))return null;u=u[1][r],++o}return-1!==(r=n.call(u[0],t[o]))&&u[1][r]||null},set:function\
(r){for(var u,i=0,l=a;i<e-1;)-1===(u=n.call(l[0],r[i]))&&(u=l[0].push(r[i])-1,l[1].push([[],[]])),l=l[1][u],++i;return-1===(u=n.call(l[0],r[i]))&&(u=l[0].push(r[i])-1),l[1][u]=++t,o[t]=r,t},delete:function(t){for(var r,u=0,i=a,l=[],s=o[t];u<e-1;){if(-1===(r=n.call(i[0],s[u])))return;l.push(i,r),i=i[1][r],++u}if(-1!==(r=n.call(i[0],s[u]))){for(t=i[1][r],i[0].splice(r,1),i[1].splice(r,1);!i[0].length&&l.length;)r=l.pop(),(i=l.pop())[0].splice(r,1),i[1].splice(r,1);delete o[t]}},clear:function(){a=[[],[]],o=r(null)}}}})),Bt=le((function(e,t){var n=ke(),r=Te(),a=Function.prototype.call;t.exports=function(e,t){var o={},u=arguments[2];return n(t),r(e,(function(e,n,r,i){o[n]=a.call(t,u,e,n,r,i)})),o}})),Tt=le((function(e,t){function n(e){if("function"!=typeof e)throw new TypeError(e+" is not a function");return e}function o(e){var t,a,o=r.createTextNode(""),u=0;return new e((function(){var e;if(t)a&&(t=a.concat(t));else{if(!a)return;t=a}if(a=t,t=null,"function"==typeof a)e=a,a=null,e();else f\
or(o.data=u=++u%2;a;)e=a.shift(),a.length||(a=null),e()})).observe(o,{characterData:!0}),function(e){n(e),t?"function"==typeof t?t=[t,e]:t.push(e):(t=e,o.data=u=++u%2)}}t.exports=(()=>{if("object"===("undefined"==typeof process?"undefined":a(process))&&process&&"function"==typeof process.nextTick)return process.nextTick;if("function"==typeof queueMicrotask)return function(e){queueMicrotask(n(e))};if("object"===(void 0===r?"undefined":a(r))&&r){if("function"==typeof MutationObserver)return o(MutationObserver);if("function"==typeof WebKitMutationObserver)return o(WebKitMutationObserver)}return"function"==typeof setImmediate?function(e){setImmediate(n(e))}:"function"==typeof setTimeout||"object"===("undefined"==typeof setTimeout?"undefined":a(setTimeout))?function(e){setTimeout(n(e),0)}:null})()})),Rt=le((function(){var e=Dt(),t=Bt(),n=qe(),r=ze(),a=Tt(),o=Array.prototype.slice,u=Function.prototype.apply,i=Object.create;Re().async=function(l,s){var c,d,p,f=i(null),D=i(null),m=s.memoized,h\
=s.original;s.memoized=r((function(e){var t=arguments,n=t[t.length-1];return"function"==typeof n&&(c=n,t=o.call(t,0,-1)),m.apply(d=this,p=t)}),m);try{n(s.memoized,m)}catch(l){}s.on("get",(function(e){var t,n,r;c&&(f[e]?("function"==typeof f[e]?f[e]=[f[e],c]:f[e].push(c),c=null):(t=c,n=d,r=p,c=d=p=null,a((function(){var a;hasOwnProperty.call(D,e)?(a=D[e],s.emit("getasync",e,r,n),u.call(t,a.context,a.args)):(c=t,d=n,p=r,m.apply(n,r))}))))})),s.original=function(){var t,n,r,o;return c?(t=e(arguments),r=c,c=d=p=null,t.push(n=function t(n){var r,i,l=t.id;if(null==l)a(u.bind(t,this,arguments));else if(delete t.id,r=f[l],delete f[l],r)return i=e(arguments),s.has(l)&&(n?s.delete(l):(D[l]={context:this,args:i},s.emit("setasync",l,"function"==typeof r?1:r.length))),"function"==typeof r?o=u.call(r,this,i):r.forEach((function(e){o=u.call(e,this,i)}),this),o}),o=u.call(h,this,t),n.cb=r,c=n,o):u.call(h,this,arguments)},s.on("set",(function(e){c?(f[e]?"function"==typeof f[e]?f[e]=[f[e],c.cb]:f[e].pus\
h(c.cb):f[e]=c.cb,delete c.cb,c.id=e,c=null):s.delete(e)})),s.on("delete",(function(e){var t;hasOwnProperty.call(f,e)||D[e]&&(t=D[e],delete D[e],s.emit("deleteasync",e,o.call(t.args,1)))})),s.on("clear",(function(){var e=D;D=i(null),s.emit("clearasync",t(e,(function(e){return o.call(e.args,1)})))}))}})),St=le((function(e,t){var n=Array.prototype.forEach,r=Object.create;t.exports=function(e){var t=r(null);return n.call(arguments,(function(e){t[e]=!0})),t}})),Ot=le((function(e,t){t.exports=function(e){return"function"==typeof e}})),_t=le((function(e,t){var n=Ot();t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){throw new TypeError("Passed argument cannot be stringifed")}}})),Mt=le((function(e,t){var n=Ne(),r=_t();t.exports=function(e){return r(n(e))}})),Pt=le((function(e,t){var n=Ot();t.exports=function(e){try{return e&&n(e.toString)?e.toString():String(e)}catch(e){return"<Non-coercible to string value>"}}})),It=le((function(e,t){var n=Pt(),r=/[\\n\\r\\u2028\
\\u2029]/g;t.exports=function(e){return(e=100<(e=n(e)).length?e.slice(0,99)+"…":e).replace(r,(function(e){return JSON.stringify(e).slice(1,-1)}))}})),jt=le((function(e,t){function n(e){return!!e&&("object"===a(e)||"function"==typeof e)&&"function"==typeof e.then}t.exports=n,t.exports.default=n})),Lt=le((function(){var e=Bt(),t=St(),n=Mt(),r=It(),a=jt(),o=Tt(),u=Object.create,i=t("then","then:finally","done","done:finally");Re().promise=function(t,l){var s=u(null),c=u(null),d=u(null);if(!0===t)t=null;else if(t=n(t),!i[t])throw new TypeError("'"+r(t)+"' is not valid promise mode");l.on("set",(function(e,n,r){var u=!1;if(a(r)){s[e]=1,d[e]=r;var i=function(t){var n=s[e];if(u)throw new Error("Memoizee error: Detected unordered then|done & finally resolution, which in turn makes proper detection of success/failure impossible (when in 'done:finally' mode)\\nConsider to rely on 'then' or 'done' mode instead.");n&&(delete s[e],c[e]=t,l.emit("setasync",e,n))},p=function(){u=!0,s[e]&&(delete s[e],d\
elete d[e],l.delete(e))},f=t;if("then"===(f=f||"then")){var D=function(){o(p)};"function"==typeof(r=r.then((function(e){o(i.bind(this,e))}),D)).finally&&r.finally(D)}else if("done"===f){if("function"!=typeof r.done)throw new Error("Memoizee error: Retrieved promise does not implement 'done' in 'done' mode");r.done(i,p)}else if("done:finally"===f){if("function"!=typeof r.done)throw new Error("Memoizee error: Retrieved promise does not implement 'done' in 'done:finally' mode");if("function"!=typeof r.finally)throw new Error("Memoizee error: Retrieved promise does not implement 'finally' in 'done:finally' mode");r.done(i),r.finally(p)}}else c[e]=r,l.emit("setasync",e,1)})),l.on("get",(function(e,t,n){var r,u;s[e]?++s[e]:(r=d[e],u=function(){l.emit("getasync",e,t,n)},a(r)?"function"==typeof r.done?r.done(u):r.then((function(){o(u)})):u())})),l.on("delete",(function(e){var t;delete d[e],s[e]?delete s[e]:hasOwnProperty.call(c,e)&&(t=c[e],delete c[e],l.emit("deleteasync",e,[t]))})),l.on("clea\
r",(function(){var t=c;c=u(null),s=u(null),d=u(null),l.emit("clearasync",e(t,(function(e){return[e]})))}))}})),qt=le((function(){var e=ke(),t=Te(),n=Re(),r=Function.prototype.apply;n.dispose=function(a,o,u){var i;e(a),u.async&&n.async||u.promise&&n.promise?(o.on("deleteasync",i=function(e,t){r.call(a,null,t)}),o.on("clearasync",(function(e){t(e,(function(e,t){i(t,e)}))}))):(o.on("delete",i=function(e,t){a(t)}),o.on("clear",(function(e){t(e,(function(e,t){i(t,e)}))})))}})),zt=le((function(e,t){t.exports=2147483647})),Vt=le((function(e,t){var n=xe(),r=zt();t.exports=function(e){if(e=n(e),r<e)throw new TypeError(e+" exceeds maximum possible timeout");return e}})),$t=le((function(){var e=Dt(),t=Te(),n=Tt(),r=jt(),a=Vt(),o=Re(),u=Function.prototype,i=Math.max,l=Math.min,s=Object.create;o.maxAge=function(c,d,p){var f,D,m,h;(c=a(c))&&(f=s(null),D=p.async&&o.async||p.promise&&o.promise?"async":"",d.on("set"+D,(function(e){f[e]=setTimeout((function(){d.delete(e)}),c),"function"==typeof f[e].unr\
ef&&f[e].unref(),h&&(h[e]&&"nextTick"!==h[e]&&clearTimeout(h[e]),h[e]=setTimeout((function(){delete h[e]}),m),"function"==typeof h[e].unref)&&h[e].unref()})),d.on("delete"+D,(function(e){clearTimeout(f[e]),delete f[e],h&&("nextTick"!==h[e]&&clearTimeout(h[e]),delete h[e])})),p.preFetch&&(m=!0===p.preFetch||isNaN(p.preFetch)?.333:i(l(Number(p.preFetch),1),0))&&(h={},m=(1-m)*c,d.on("get"+D,(function(t,a,o){h[t]||(h[t]="nextTick",n((function(){var n;"nextTick"===h[t]&&(delete h[t],d.delete(t),p.async&&(a=e(a)).push(u),n=d.memoized.apply(o,a),p.promise)&&r(n)&&("function"==typeof n.done?n.done(u,u):n.then(u,u))})))}))),d.on("clear"+D,(function(){t(f,(function(e){clearTimeout(e)})),f={},h&&(t(h,(function(e){"nextTick"!==e&&clearTimeout(e)})),h={})})))}})),Ht=le((function(e,t){var n=xe(),r=Object.create,a=Object.prototype.hasOwnProperty;t.exports=function(e){var t,o=0,u=1,i=r(null),l=r(null),s=0;return e=n(e),{hit:function(n){var r=l[n],c=++s;if(i[c]=n,l[n]=c,!r)return++o<=e?void 0:(n=i[u],t\
(n),n);if(delete i[r],u===r)for(;!a.call(i,++u););},delete:t=function(e){var t=l[e];if(t&&(delete i[t],delete l[e],--o,u===t))if(o)for(;!a.call(i,++u););else s=0,u=1},clear:function(){o=0,u=1,i=r(null),l=r(null),s=0}}}})),Ut=le((function(){var e=xe(),t=Ht(),n=Re();n.max=function(r,a,o){var u;(r=e(r))&&(u=t(r),r=o.async&&n.async||o.promise&&n.promise?"async":"",a.on("set"+r,o=function(e){void 0!==(e=u.hit(e))&&a.delete(e)}),a.on("get"+r,o),a.on("delete"+r,u.delete),a.on("clear"+r,u.clear))}})),Gt=le((function(){var e=Xe(),t=Re(),n=Object.create,r=Object.defineProperties;t.refCounter=function(a,o,u){var i=n(null);u=u.async&&t.async||u.promise&&t.promise?"async":"";o.on("set"+u,(function(e,t){i[e]=t||1})),o.on("get"+u,(function(e){++i[e]})),o.on("delete"+u,(function(e){delete i[e]})),o.on("clear"+u,(function(){i={}})),r(o.memoized,{deleteRef:e((function(){var e=o.get(arguments);return null!==e&&i[e]?!--i[e]&&(o.delete(e),!0):null})),getRefCount:e((function(){var e=o.get(arguments);return \
null!==e&&i[e]||0}))})}})),Wt=le((function(e,t){var n=ye(),r=Ae(),a=vt();t.exports=function(e){var t,o=n(arguments[1]);return o.normalizer||0!==(t=o.length=r(o.length,e.length,o.async))&&(o.primitive?!1===t?o.normalizer=yt():1<t&&(o.normalizer=Ft()(t)):o.normalizer=!1===t?At()():1===t?kt()():Nt()(t)),o.async&&Rt(),o.promise&&Lt(),o.dispose&&qt(),o.maxAge&&$t(),o.max&&Ut(),o.refCounter&&Gt(),a(e,o)}})),Yt=le((function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.isIdentStart=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"-"===e||"_"===e},e.isIdent=function(e){return"a"<=e&&e<="z"||"A"<=e&&e<="Z"||"0"<=e&&e<="9"||"-"===e||"_"===e},e.isHex=function(e){return"a"<=e&&e<="f"||"A"<=e&&e<="F"||"0"<=e&&e<="9"},e.escapeIdentifier=function(t){for(var n=t.length,r="",a=0;a<n;){var o=t.charAt(a);if(e.identSpecialChars[o])r+="\\\\"+o;else if("_"===o||"-"===o||"A"<=o&&o<="Z"||"a"<=o&&o<="z"||0!==a&&"0"<=o&&o<="9")r+=o;else{if(55296==(63488&(o=o.charCodeAt(0)))){var u=t.charCodeAt(a++);if(5\
5296!=(64512&o)||56320!=(64512&u))throw Error("UCS-2(decode): illegal sequence");o=((1023&o)<<10)+(1023&u)+65536}r+="\\\\"+o.toString(16)+" "}a++}return r},e.escapeStr=function(t){for(var n,r=t.length,a="",o=0;o<r;){var u=t.charAt(o);'"'===u?u='\\\\"':"\\\\"===u?u="\\\\\\\\":void 0!==(n=e.strReplacementsRev[u])&&(u=n),a+=u,o++}return'"'+a+'"'},e.identSpecialChars={"!":!0,'"':!0,"#":!0,$:!0,"%":!0,"&":!0,"'":!0,"(":!0