import"../../ui/components/switch/switch.js";import"../../ui/components/cards/cards.js";import*as e from"../../ui/components/chrome_link/chrome_link.js";import*as t from"../../core/common/common.js";import*as i from"../../core/host/host.js";import*as s from"../../core/i18n/i18n.js";import*as r from"../../core/root/root.js";import*as n from"../../core/sdk/sdk.js";import"../../ui/components/buttons/buttons.js";import*as o from"../../ui/components/input/input.js";import*as a from"../../ui/legacy/legacy.js";import*as c from"../../ui/lit/lit.js";import{render as l,html as d}from"../../ui/lit/lit.js";import*as u from"../../ui/visual_logging/visual_logging.js";import"../../ui/legacy/components/data_grid/data_grid.js";import*as h from"../../core/platform/platform.js";import*as g from"../../models/issues_manager/issues_manager.js";import*as p from"../network/forward/forward.js";import*as m from"../../ui/components/icon_button/icon_button.js";var y={cssText:`.overflow-auto{height:100%}.controls{display:flex;flex-direction:column;padding:var(--sys-size-5) var(--sys-size-3) var(--sys-size-5) var(--sys-size-5);min-width:var(--sys-size-33)}.header{display:flex;flex-direction:column;gap:var(--sys-size-2);padding-left:var(--sys-size-5)}h1{margin:0;font:var(--sys-typescale-headline4)}.card-container{max-width:100%}.card{display:flex;flex-direction:column;padding:var(--sys-size-6) var(--sys-size-8);gap:var(--sys-size-6);&.enterprise-disabled{color:var(--sys-color-token-subtle)}}.card-header{display:flex;align-items:center}.card-header > .lhs{width:100%;display:flex;justify-content:space-between;align-items:center;padding-right:var(--sys-size-9);& > devtools-icon{height:var(--sys-size-11);width:var(--sys-size-11)}}.text{display:flex;flex-direction:column;gap:var(--sys-size-2)}h2{font:var(--sys-typescale-headline5);margin:0}.body{font:var(--sys-typescale-body4-regular)}.checkbox-label{gap:var(--sys-size-8);display:flex;align-items:center}.card-row{padding-top:var(--sys-size-4);padding-bottom:var(--sys-size-4);padding-left:var(--sys-size-8)}h3{font:var(--sys-typescale-body4-medium);margin:0}.x-link{color:var(--sys-color-primary);text-decoration-line:underline;cursor:pointer}.enterprise{display:flex;flex-direction:row;justify-content:space-between;gap:var(--sys-size-9);padding:var(--sys-size-6) var(--sys-size-8) var(--sys-size-6) var(--sys-size-11);align-items:center;> .anchor{display:flex;flex-direction:row;gap:var(--sys-size-9)}}input[type="checkbox"]{flex-shrink:0}.main-text{color:var(--sys-color-on-surface)}.subtext{color:var(--sys-color-on-surface-subtle)}\n/*# sourceURL=${import.meta.resolve("./cookieControlsView.css")} */\n`};const{render:v,html:w}=c,S={viewTitle:"Controls",viewExplanation:"Test how this site will perform if third-party cookies are limited in Chrome",cardTitle:"Temporarily limit third-party cookies",cardDisclaimer:"Only when DevTools is open",siteReloadMessage:"To apply your updated controls, reload the page",exceptions:"Exceptions",exceptionsExplanation:"Scenarios that grant access to third-party cookies",gracePeriodTitle:"Third-party cookie grace period",gracePeriodExplanation:"If this site or a site embedded on it is enrolled in the {PH1}, then the site can access third-party cookies",enrollGracePeriod:"To use this, enroll this site or sites embedded on it in the {PH1}",gracePeriod:"grace period",heuristicTitle:"Heuristics based exception",heuristicExplanation:"In {PH1} like pop-ups or redirects, a site embedded on this site can access third-party cookies",scenarios:"predefined scenarios",enterpriseDisclaimer:"Your organization manages third-party cookie access for this site",enterpriseTooltip:"This setting is managed by your organization",viewDetails:"View details",enableFlag:"To use this, set {PH1} to Default",tpcdMetadataGrants:"#tpcd-metadata-grants",tpcdHeuristicsGrants:"#tpcd-heuristics-grants"},b=s.i18n.registerUIStrings("panels/security/CookieControlsView.ts",S),k=s.i18n.getLocalizedString.bind(void 0,b),f=s.i18n.getFormatLocalizedString.bind(void 0,b);function x(){a.InspectorView.InspectorView.instance().displayDebuggedTabReloadRequiredWarning(k(S.siteReloadMessage))}class C extends a.Widget.VBox{#e;#t;#i;constructor(e,i=(e,i,s)=>{const r=t.Settings.Settings.instance().createSetting("enterprise-enabled",!(!this.#i||!this.#i.managedBlockThirdPartyCookies||"boolean"!=typeof this.#i.managedBlockThirdPartyCookies)&&this.#i.managedBlockThirdPartyCookies,"Global"),n=t.Settings.Settings.instance().createSetting("cookie-control-override-enabled",!(!this.#i||!this.#i.thirdPartyCookieRestrictionEnabled)&&this.#i.thirdPartyCookieRestrictionEnabled,"Global"),o=t.Settings.Settings.instance().createSetting("grace-period-mitigation-disabled",!this.#i||!this.#i.thirdPartyCookieMetadataEnabled||this.#i.thirdPartyCookieMetadataEnabled,"Global"),l=t.Settings.Settings.instance().createSetting("heuristic-mitigation-disabled",!this.#i||!this.#i.thirdPartyCookieHeuristicsEnabled||this.#i.thirdPartyCookieHeuristicsEnabled,"Global"),d=w`
      <div class="card-header">
        <div class="lhs">
          <div class="text">
            <h2 class="main-text">${k(S.cardTitle)}</h2>
            <div class="body subtext">${k(S.cardDisclaimer)}</div>
          </div>
          ${Boolean(r.get())?w`
            <devtools-icon
              tabindex="0"
              .name=${"domain"}
              ${c.Directives.ref((e=>{a.Tooltip.Tooltip.install(e,k(S.enterpriseTooltip)),e.role="img"}))}>
            </devtools-icon>`:c.nothing}
        </div>
        <div>
          <devtools-switch
            .checked=${Boolean(n.get())}
            .disabled=${Boolean(r.get())}
            @switchchange=${()=>{e.inputChanged(!n.get(),n)}}
            aria-label="Temporarily limit third-party cookies, only when DevTools is open"
            jslog=${u.toggle(n.name).track({click:!0})}
          >
          </devtools-switch>
        </div>
      </div>
    `,h=!!this.#i&&!this.#i.thirdPartyCookieMetadataEnabled||r.get()||!n.get()||!this.#t,g=w`
      <div class="card-row">
        <label class='checkbox-label'>
          <input type='checkbox'
            .disabled=${h}
            .checked=${!h&&!Boolean(o.get())}
            @change=${()=>{e.inputChanged(!o.get(),o)}}
            jslog=${u.toggle(o.name).track({click:!0})}
          >
          <div class="text">
            <div class="body main-text">${k(S.gracePeriodTitle)}</div>
            <div class="body subtext">
              ${Boolean(r.get())?f(S.gracePeriodExplanation,{PH1:k(S.gracePeriod)}):this.#i&&!this.#i?.thirdPartyCookieMetadataEnabled?f(S.enableFlag,{PH1:this.getChromeFlagsLink(S.tpcdMetadataGrants)}):f(this.#t?S.gracePeriodExplanation:S.enrollGracePeriod,{PH1:a.Fragment.html`<x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/grace-period" jslog=${u.link("grace-period-link").track({click:!0})}>${k(S.gracePeriod)}</x-link>`})}
            </div>
          </div>
        </label>
      </div>
    `,p=!!this.#i&&!this.#i.thirdPartyCookieHeuristicsEnabled||r.get()||!n.get(),m=w`
      <div class="card-row">
        <label class='checkbox-label'>
          <input type='checkbox'
            .disabled=${p}
            .checked=${!p&&!Boolean(l.get())}
            @change=${()=>{e.inputChanged(!l.get(),l)}}
            jslog=${u.toggle(l.name).track({click:!0})}
          >
          <div class='text'>
            <div class="body main-text">${k(S.heuristicTitle)}</div>
            <div class="body subtext">
              ${Boolean(r.get())?f(S.heuristicExplanation,{PH1:k(S.scenarios)}):this.#i&&!this.#i.thirdPartyCookieHeuristicsEnabled?f(S.enableFlag,{PH1:this.getChromeFlagsLink(S.tpcdHeuristicsGrants)}):f(S.heuristicExplanation,{PH1:a.Fragment.html`<x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/heuristics-based-exceptions" jslog=${u.link("heuristic-link").track({click:!0})}>${k(S.scenarios)}</x-link>`})}
            </div>
          </div>
        </label>
      </div>
    `,y=w`
      <div class="enterprise">
        <div class="text body">${k(S.enterpriseDisclaimer)}</div>
          <div class="anchor">
            <devtools-icon
            .name=${"domain"}
            ></devtools-icon>
            <devtools-button
            @click=${e.openChromeCookieSettings}
            aria-label="View details of third-party cookie access in Settings"
            .variant=${"outlined"}
            jslog=${u.action("view-details").track({click:!0})}>
            ${k(S.viewDetails)}
          </devtools-button>
        </div>
      </div>
    `;v(w`
      <div class="overflow-auto">
        <div class="controls">
          <div class="header">
            <h1>${k(S.viewTitle)}</h1>
            <div class="body">${k(S.viewExplanation)}</div>
          </div>
          <devtools-card class="card-container">
            <div class=${Boolean(r.get())?"card enterprise-disabled":"card"}>
              ${d}
              <div>
                <div class="card-row text">
                  <h3 class="main-text">${k(S.exceptions)}</h3>
                  <div class="body subtext">${k(S.exceptionsExplanation)}</div>
                </div>
                ${g}
                ${m}
              </div>
            </div>
          </devtools-card>
          ${Boolean(r.get())?y:c.nothing}
        </div>
      </div>
    `,s,{host:this})}){super(!0,void 0,e),this.#e=i,this.#t=!1,this.#i=r.Runtime.hostConfig.thirdPartyCookieControls,this.registerRequiredCSS(o.checkboxStylesRaw,y),n.TargetManager.TargetManager.instance().addModelListener(n.ResourceTreeModel.ResourceTreeModel,n.ResourceTreeModel.Events.PrimaryPageChanged,this.#s,this),n.TargetManager.TargetManager.instance().addModelListener(n.ResourceTreeModel.ResourceTreeModel,n.ResourceTreeModel.Events.ResourceAdded,this.checkGracePeriodActive,this),this.checkGracePeriodActive().catch((e=>{console.error(e)})),this.requestUpdate()}performUpdate(){this.#e(this,this,this.contentElement)}inputChanged(e,t){t.set(e),x(),this.requestUpdate()}openChromeCookieSettings(){const e=n.TargetManager.TargetManager.instance().rootTarget();if(null===e)return;const t="chrome://settings/cookies";e.targetAgent().invoke_createTarget({url:t}).then((e=>{e.getError()&&i.InspectorFrontendHost.InspectorFrontendHostInstance.openInNewTab(t)}))}#s(){this.#t=!1,this.checkGracePeriodActive().catch((e=>{console.error(e)}))}async checkGracePeriodActive(e){if(!this.#i||!this.#i.thirdPartyCookieMetadataEnabled)return;if(this.#t)return;const t=n.TargetManager.TargetManager.instance().primaryPageTarget();if(!t)return;const i=[];if(e)i.push(e.data.url);else for(const e of n.TargetManager.TargetManager.instance().models(n.ResourceTreeModel.ResourceTreeModel))e.forAllResources((e=>(i.push(e.url),!0)));const s=await t.storageAgent().invoke_getAffectedUrlsForThirdPartyCookieMetadata({firstPartyUrl:t.inspectedURL(),thirdPartyUrls:i});s.matchedUrls&&s.matchedUrls.length>0&&(this.#t=!0,this.requestUpdate())}getChromeFlagsLink(t){const i=new e.ChromeLink.ChromeLink;return i.textContent=t,i.href="chrome://flags/"+t,i.setAttribute("tabindex","0"),i}}var T=Object.freeze({__proto__:null,CookieControlsView:C,i18nFormatString:f,i18nString:k,showInfobar:x}),E={cssText:`.report{display:flex;flex-direction:column;width:100%;height:100%;max-height:100%;gap:var(--sys-size-6);padding-top:var(--sys-size-5)}.header{display:flex;flex-direction:column;flex-shrink:0;gap:var(--sys-size-2);padding-left:var(--sys-size-6);padding-right:var(--sys-size-6);min-width:var(--sys-size-31);h1{font:var(--sys-typescale-headline4);margin:0}}.body{font:var(--sys-typescale-body4-regular)}.x-link{color:var(--sys-color-primary);text-decoration-line:underline;cursor:pointer}.filter{padding-right:var(--sys-size-6);flex-shrink:0}.filters-container{display:flex;padding-left:var(--sys-size-5)}devtools-data-grid{flex:auto;margin-left:-1px}.empty-report{display:flex;flex-direction:column;align-items:center;gap:var(--sys-size-2);padding:var(--sys-size-11) var(--sys-size-6) 0 var(--sys-size-6);flex-shrink:0;min-width:var(--sys-size-31)}.empty-report-title{font:var(--sys-typescale-headline5)}.cookie-off{width:var(--sys-size-11);height:var(--sys-size-11)}\n/*# sourceURL=${import.meta.resolve("./cookieReportView.css")} */\n`};const{render:I,html:R,Directives:{ref:P}}=c,A={title:"Third-party cookies",body:"This site might not work if third-party cookies and other cookies are limited in Chrome.",learnMoreLink:"Learn more about how third-party cookies are used",name:"Name",domain:"Domain",type:"Type",platform:"Platform",recommendation:"Recommendation",status:"Status",allowed:"Allowed",allowedByException:"Allowed by exception",blocked:"Blocked",unknown:"Unknown",report:"Third-Party Cookie Report",emptyReport:"Not a crumb left",emptyReportExplanation:"No issues with third-party cookies found",gitHubResource:"Review {PH1} from third-party site",guidance:"guidance",gracePeriod:"Review {PH1}. Grace period exception is active.",reportedIssues:"reported issues",heuristics:"Action needed later. Heuristics based exception is active.",other:"Contact third-party site for more info",gitHubResourceInsightTypeString:"Github",gracePeriodInsightTypeString:"Grace Period",heuristicsInisightTypeString:"Heuristics",otherInsightTypeString:"Other",adCookieTypeString:"Advertising",analyticsCookieTypeString:"Analytics",socialCookieTypeString:"Social",videoCookieTypeString:"Video",utilityCookieTypeString:"Utility",hostingCookieTypeString:"Hosting",marketingCookieTypeString:"Marketing",customerSuccessCookieTypeString:"Customer Success",contentCookieTypeString:"Content",cdnCookieTypeString:"CDN",tagManagerCookieTypeString:"Tag Manager",consentProviderCookieTypeString:"Consent Provider",otherCookieTypeString:"Other",showRequestsWithThisCookie:"Show requests with this cookie"},L=s.i18n.registerUIStrings("panels/security/CookieReportView.ts",A),M=s.i18n.getLocalizedString.bind(void 0,L);class H extends a.Widget.VBox{#r;namedBitSetFilterUI;#n=new Map;#e;filterItems=[];searchText;constructor(e,i=(e,t,i)=>{I(R`
        <div class="report overflow-auto">
            <div class="header">
              <h1>${M(A.title)}</h1>
              <div class="body">${M(A.body)} <x-link class="devtools-link" href="https://developers.google.com/privacy-sandbox/cookies/prepare/audit-cookies" jslog=${u.link("learn-more").track({click:!0})}>${M(A.learnMoreLink)}</x-link></div>
            </div>
            ${e.cookieRows.length>0?R`
                <div class="filters-container">
                  <devtools-toolbar>
                    <devtools-toolbar-input
                      type="filter"
                      style="flex-grow: 0.4;"
                      @change=${e.onSearchFilterChanged}
                      value=${e.searchText}
                    ></devtools-toolbar-input>
                  </devtools-toolbar>
                  <devtools-named-bit-set-filter
                    class="filter"
                    aria-label="Third-party cookie status filters"
                    @filterChanged=${e.onFilterChanged}
                    .options=${{items:e.filterItems}}
                    ${P((e=>{e instanceof a.FilterBar.NamedBitSetFilterUIElement&&(t.namedBitSetFilterUI=e.getOrCreateNamedBitSetFilterUI())}))}
                  ></devtools-named-bit-set-filter>
                </div>
                <!-- @ts-ignore -->
                <devtools-data-grid
                  name=${M(A.report)}
                  striped
                  .filters=${e.filters}
                  @sort=${e.onSortingChanged}
                  @contextmenu=${e.populateContextMenu.bind(e)}
                >
                  <table>
                    <tr>
                      <th id="name" sortable>${M(A.name)}</th>
                      <th id="domain" sortable>${M(A.domain)}</th>
                      <th id="type" sortable>${M(A.type)}</th>
                      <th id="platform" sortable>${M(A.platform)}</th>
                      <th id="status" sortable>${M(A.status)}</th>
                      <th id="recommendation" sortable>${M(A.recommendation)}</th>
                    </tr>
                    ${[...e.cookieRows.values()].map((e=>R`
                      <tr data-name=${e.name} data-domain=${e.domain}>
                        <td>${e.name}</td>
                        <td>${e.domain}</td>
                        <td>${H.getCookieTypeString(e.type)}</td>
                        <td>${e.platform??M(A.unknown)}</td>
                        <td>${H.getStatusString(e.status)}</td>
                        <td>${H.getRecommendation(e.domain,e.insight)}</td>
                      </tr>
                    `))}
                  </table>
                </devtools-data-grid>
              `:R`
                <div class="empty-report">
                  <devtools-icon
                    class="cookie-off"
                    .name=${"cookie_off"}
                  ></devtools-icon>
                  <div class="empty-report-title">
                    ${M(A.emptyReport)}
                  </div>
                  <div class="body">
                    ${M(A.emptyReportExplanation)}
                  </div>
                </div>
              `}

        </div>
    `,i,{host:this})}){super(!0,void 0,e),this.#e=i,this.registerRequiredCSS(E),this.searchText=t.Settings.Settings.instance().createSetting("cookie-report-search-query","").get(),n.TargetManager.TargetManager.instance().addModelListener(n.ResourceTreeModel.ResourceTreeModel,n.ResourceTreeModel.Events.PrimaryPageChanged,this.#s,this),this.#r=g.IssuesManager.IssuesManager.instance(),this.#r.addEventListener("IssueAdded",this.#o,this);for(const e of this.#r.issues())e instanceof g.CookieIssue.CookieIssue&&this.#a(e);this.requestUpdate()}performUpdate(){this.filterItems=this.#c();const e={cookieRows:[...this.#n.values()].filter((e=>!this.namedBitSetFilterUI||this.namedBitSetFilterUI.accept(H.getStatusString(e.status)))),filters:[{key:"name,domain",regex:RegExp(h.StringUtilities.escapeForRegExp(this.searchText),"i"),negative:!1}],searchText:this.searchText,filterItems:this.filterItems,onSearchFilterChanged:e=>this.onSearchFilterChanged(e),onFilterChanged:()=>this.requestUpdate(),onSortingChanged:()=>this.requestUpdate(),populateContextMenu:this.populateContextMenu.bind(this)};this.#e(e,this,this.contentElement)}#s(){this.#n.clear(),this.namedBitSetFilterUI=void 0,this.requestUpdate()}#o(e){if(e.data.issue instanceof g.CookieIssue.CookieIssue){if(this.#n.has(e.data.issue.cookieId()))return;this.#a(e.data.issue),this.requestUpdate()}}#a(e){const t=e.makeCookieReportEntry();t&&this.#n.set(e.cookieId(),t)}onSearchFilterChanged(e){this.searchText=e.detail?e.detail:"",t.Settings.Settings.instance().createSetting("cookie-report-search-query","").set(this.searchText),this.requestUpdate()}#c(){const e=[];return this.#n.values().some((e=>0===e.status))&&e.push({name:A.blocked,label:()=>M(A.blocked),title:A.blocked,jslogContext:"blocked"}),this.#n.values().some((e=>1===e.status))&&e.push({name:A.allowed,label:()=>M(A.allowed),title:A.allowed,jslogContext:"allowed"}),this.#n.values().some((e=>2===e.status||3===e.status))&&e.push({name:A.allowedByException,label:()=>M(A.allowedByException),title:A.allowedByException,jslogContext:"allowed-by-exception"}),e}populateContextMenu(e){const{menu:i,element:s}=e.detail,{domain:r,name:n}=s?.dataset;r&&n&&i.revealSection().appendItem(M(A.showRequestsWithThisCookie),(()=>{const e=p.UIFilter.UIRequestFilter.filters([{filterType:p.UIFilter.FilterType.CookieDomain,filterValue:r},{filterType:p.UIFilter.FilterType.CookieName,filterValue:n}]);t.Revealer.reveal(e)}),{jslogContext:"show-requests-with-this-cookie"})}static getStatusString(e){switch(e){case 0:return M(A.blocked);case 2:case 3:return M(A.allowedByException);case 1:return M(A.allowed)}}static getInsightTypeString(e){if(!e)return M(A.otherInsightTypeString);switch(e.type){case"GitHubResource":return M(A.gitHubResourceInsightTypeString);case"GracePeriod":return M(A.gracePeriodInsightTypeString);case"Heuristics":return M(A.heuristicsInisightTypeString);default:return M(A.otherInsightTypeString)}}static getRecommendation(e,t){const i=document.createElement("div");return I(H.getRecommendationText(e,t),i,{host:this}),i}static getRecommendationText(e,i){if(!i)return R`${M(A.other)}`;switch(i.type){case"GitHubResource":{const e=a.XLink.XLink.create(i.tableEntryUrl?i.tableEntryUrl:"https://github.com/privacysandbox/privacy-sandbox-dev-support/blob/main/3pc-migration-readiness.md",M(A.guidance),void 0,void 0,"readiness-list-link");return R`${s.i18n.getFormatLocalizedString(L,A.gitHubResource,{PH1:e})}`}case"GracePeriod":{const i=n.TargetManager.TargetManager.instance().primaryPageTarget()?.inspectedURL(),r=a.XLink.XLink.create("https://developers.google.com/privacy-sandbox/cookies/dashboard?url="+(i?t.ParsedURL.ParsedURL.fromString(i)?.host+"+":"")+("."===e.charAt(0)?e.substring(1):e),M(A.reportedIssues),void 0,void 0,"compatibility-lookup-link");return R`${s.i18n.getFormatLocalizedString(L,A.gracePeriod,{PH1:r})}`}case"Heuristics":return R`${M(A.heuristics)}`;default:return R`${M(A.other)}`}}static getCookieTypeString(e){if(!e)return M(A.otherCookieTypeString);switch(e){case"ad":return M(A.adCookieTypeString);case"analytics":return M(A.analyticsCookieTypeString);case"social":return M(A.socialCookieTypeString);case"video":return M(A.videoCookieTypeString);case"utility":return M(A.utilityCookieTypeString);case"hosting":return M(A.hostingCookieTypeString);case"marketing":return M(A.marketingCookieTypeString);case"customer-success":return M(A.customerSuccessCookieTypeString);case"content":return M(A.contentCookieTypeString);case"cdn":return M(A.cdnCookieTypeString);case"tag-manager":return M(A.tagManagerCookieTypeString);case"consent-provider":return M(A.consentProviderCookieTypeString);default:return M(A.otherCookieTypeString)}}}var D=Object.freeze({__proto__:null,CookieReportView:H,i18nString:M});const U={theSecurityOfThisPageIsUnknown:"The security of this page is unknown.",thisPageIsNotSecure:"This page is not secure.",thisPageIsSecureValidHttps:"This page is secure (valid HTTPS).",thisPageIsNotSecureBrokenHttps:"This page is not secure (broken HTTPS).",cipherWithMAC:"{PH1} with {PH2}",keyExchangeWithGroup:"{PH1} with {PH2}"},F=s.i18n.registerUIStrings("panels/security/SecurityModel.ts",U),$=s.i18n.getLocalizedString.bind(void 0,F),V=s.i18n.getLazilyComputedLocalizedString.bind(void 0,F);class O extends n.SDKModel.SDKModel{dispatcher;securityAgent;constructor(e){super(e),this.dispatcher=new _(this),this.securityAgent=e.securityAgent(),e.registerSecurityDispatcher(this.dispatcher),this.securityAgent.invoke_enable()}resourceTreeModel(){return this.target().model(n.ResourceTreeModel.ResourceTreeModel)}networkManager(){return this.target().model(n.NetworkManager.NetworkManager)}}function N(e,t){const i=["info","insecure-broken","insecure","neutral","secure","unknown"];return i.indexOf(e)-i.indexOf(t)}var B;n.SDKModel.SDKModel.register(O,{capabilities:512,autostart:!1}),function(e){e.VisibleSecurityStateChanged="VisibleSecurityStateChanged"}(B||(B={}));const z={unknown:V(U.theSecurityOfThisPageIsUnknown),insecure:V(U.thisPageIsNotSecure),neutral:V(U.thisPageIsNotSecure),secure:V(U.thisPageIsSecureValidHttps),"insecure-broken":V(U.thisPageIsNotSecureBrokenHttps)};class G{securityState;certificateSecurityState;safetyTipInfo;securityStateIssueIds;constructor(e,t,i,s){this.securityState=e,this.certificateSecurityState=t?new q(t):null,this.safetyTipInfo=i?new j(i):null,this.securityStateIssueIds=s}}class q{protocol;keyExchange;keyExchangeGroup;cipher;mac;certificate;subjectName;issuer;validFrom;validTo;certificateNetworkError;certificateHasWeakSignature;certificateHasSha1Signature;modernSSL;obsoleteSslProtocol;obsoleteSslKeyExchange;obsoleteSslCipher;obsoleteSslSignature;constructor(e){this.protocol=e.protocol,this.keyExchange=e.keyExchange,this.keyExchangeGroup=e.keyExchangeGroup||null,this.cipher=e.cipher,this.mac=e.mac||null,this.certificate=e.certificate,this.subjectName=e.subjectName,this.issuer=e.issuer,this.validFrom=e.validFrom,this.validTo=e.validTo,this.certificateNetworkError=e.certificateNetworkError||null,this.certificateHasWeakSignature=e.certificateHasWeakSignature,this.certificateHasSha1Signature=e.certificateHasSha1Signature,this.modernSSL=e.modernSSL,this.obsoleteSslProtocol=e.obsoleteSslProtocol,this.obsoleteSslKeyExchange=e.obsoleteSslKeyExchange,this.obsoleteSslCipher=e.obsoleteSslCipher,this.obsoleteSslSignature=e.obsoleteSslSignature}isCertificateExpiringSoon(){const e=new Date(1e3*this.validTo).getTime();return e<new Date(Date.now()).setHours(48)&&e>Date.now()}getKeyExchangeName(){return this.keyExchangeGroup?this.keyExchange?$(U.keyExchangeWithGroup,{PH1:this.keyExchange,PH2:this.keyExchangeGroup}):this.keyExchangeGroup:this.keyExchange}getCipherFullName(){return this.mac?$(U.cipherWithMAC,{PH1:this.cipher,PH2:this.mac}):this.cipher}}class j{safetyTipStatus;safeUrl;constructor(e){this.safetyTipStatus=e.safetyTipStatus,this.safeUrl=e.safeUrl||null}}class W{securityState;title;summary;description;certificate;mixedContentType;recommendations;constructor(e,t,i,s,r=[],n="none",o=[]){this.securityState=e,this.title=t,this.summary=i,this.description=s,this.certificate=r,this.mixedContentType=n,this.recommendations=o}}class _{model;constructor(e){this.model=e}securityStateChanged(e){}visibleSecurityStateChanged({visibleSecurityState:e}){const t=new G(e.securityState,e.certificateSecurityState||null,e.safetyTipInfo||null,e.securityStateIssueIds);this.model.dispatchEventToListeners(B.VisibleSecurityStateChanged,t)}certificateError(e){}}var K=Object.freeze({__proto__:null,CertificateSecurityState:q,get Events(){return B},PageVisibleSecurityState:G,SecurityModel:O,SecurityStyleExplanation:W,SummaryMessages:z,securityStateCompare:N}),X={cssText:`.lock-icon,\n.security-property{height:var(--sys-size-9);width:var(--sys-size-9)}.lock-icon-secure{color:var(--sys-color-green)}.lock-icon-insecure{color:var(--sys-color-error)}.lock-icon-insecure-broken{color:var(--sys-color-error)}.security-property-secure{color:var(--sys-color-green)}.security-property-neutral{color:var(--sys-color-error)}.security-property-insecure{color:var(--sys-color-error)}.security-property-insecure-broken{color:var(--sys-color-error)}.security-property-info{color:var(--sys-color-on-surface-subtle)}.security-property-unknown{color:var(--sys-color-on-surface-subtle)}.url-scheme-secure{color:var(--sys-color-green)}.url-scheme-neutral,\n.url-scheme-insecure,\n.url-scheme-insecure-broken{color:var(--sys-color-error)}\n/*# sourceURL=${import.meta.resolve("./lockIcon.css")} */\n`},Y={cssText:`.devtools-link{display:inline-block}.security-main-view{overflow:hidden auto;background-color:var(--sys-color-cdt-base-container)}.security-main-view > div{flex-shrink:0}.security-summary-section-title{font-size:15px;margin:12px 16px;user-select:text}.lock-spectrum{margin:8px 16px;display:flex;align-items:flex-start}.security-summary .lock-icon{flex:none;width:16px;height:16px;margin:0}.security-summary .lock-icon-neutral{margin:0 16px}.security-summary:not(.security-summary-secure) .lock-icon-secure,\n.security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n.security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n.security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken{color:var(--sys-color-state-disabled)}@media (forced-colors: active){.security-summary-neutral .lock-icon-neutral{color:Highlight}.security-summary:not(.security-summary-secure) .lock-icon-secure,\n  .security-summary:not(.security-summary-neutral) .lock-icon-neutral,\n  .security-summary:not(.security-summary-insecure) .lock-icon-insecure,\n  .security-summary:not(.security-summary-insecure-broken) .lock-icon-insecure-broken{color:canvastext}}.triangle-pointer-container{margin:8px 24px 0;padding:0}.triangle-pointer-wrapper{transform:translateX(0);transition:transform 0.3s}.triangle-pointer{width:12px;height:12px;margin-bottom:-6px;margin-left:-6px;transform:rotate(-45deg);border-style:solid;border-width:1px 1px 0 0;background:var(--sys-color-cdt-base-container);border-color:var(--sys-color-neutral-outline)}.security-summary-secure .triangle-pointer-wrapper{transform:translateX(0)}.security-summary-neutral .triangle-pointer-wrapper{transform:translateX(32px)}.security-summary-insecure .triangle-pointer-wrapper{transform:translateX(64px)}.security-summary-insecure-broken .triangle-pointer-wrapper{transform:translateX(64px)}.security-summary-text{padding:16px 24px;border-style:solid;border-width:1px 0;font-size:15px;background:var(--sys-color-cdt-base-container);border-color:var(--sys-color-neutral-outline);user-select:text}.security-summary-secure .triangle-pointer,\n.security-summary-secure .security-summary-text,\n.security-explanation-title-secure{color:var(--sys-color-green)}.security-summary-insecure-broken .triangle-pointer,\n.security-summary-insecure-broken .security-summary-text,\n.security-explanation-title-neutral,\n.security-explanation-title-insecure,\n.security-explanation-title-insecure-broken{color:var(--sys-color-error)}.security-explanation-list{padding-bottom:16px}.security-explanation-list:empty{border-bottom:none;padding:0}.security-explanations-main{margin-top:-5px;background-color:var(--sys-color-cdt-base-container);border-bottom:1px solid var(--sys-color-divider)}.security-explanations-extra{background-color:transparent}.security-explanation{padding:11px;display:flex;white-space:nowrap;border:none;color:var(--sys-color-token-subtle)}.security-explanation-text{flex:auto;white-space:normal;max-width:400px}.origin-button{margin-top:var(--sys-size-4)}.security-explanation .security-property{flex:none;width:16px;height:16px;margin-right:16px}.security-explanation-title{color:var(--sys-color-token-subtle);margin-top:1px;margin-bottom:8px}.security-mixed-content{margin-top:8px}.security-explanation-recommendations{padding-inline-start:16px}.security-explanation-recommendations > li{margin-bottom:4px}\n/*# sourceURL=${import.meta.resolve("./mainView.css")} */\n`};class J extends a.TreeOutline.TreeElement{constructor(e="",t=!1,i){super(e,t,i),a.ARIAUtils.setLabel(this.listItemElement,e)}get elemId(){return"overview"}showElement(){throw new Error("Unimplemented Method")}onselect(e){if(e){const e=this.elemId;this.listItemElement.dispatchEvent(new CustomEvent("update-sidebar-selection",{bubbles:!0,composed:!0,detail:{id:e}})),this.showElement()}return!1}}class Q extends Event{static eventName="showorigin";origin;constructor(e){super(Q.eventName,{bubbles:!0,composed:!0}),this.origin=e}}class Z extends J{#l;#d;#u=null;constructor(e,t,i=null){super(),this.#d=t,this.#u=i,this.listItemElement.classList.add(e),this.#l=null,this.setSecurityState("unknown")}setSecurityState(e){this.#l=e,this.#d(this)}securityState(){return this.#l}origin(){return this.#u}showElement(){this.listItemElement.dispatchEvent(new Q(this.#u))}}var ee={cssText:`.title-section{padding:16px 0 24px;border-bottom:1px solid var(--sys-color-divider)}.title-section-header{padding-left:16px;padding-bottom:10px;font-size:14px}.security-origin-view{overflow:hidden scroll;display:block;user-select:text}.security-origin-view .origin-view-section{border-bottom:1px solid var(--sys-color-divider);padding:12px 6px 12px 24px;font-size:12px}.origin-view-notes{margin-top:2px;color:var(--sys-color-token-subtle)}.origin-view-section-notes{margin-top:6px;color:var(--sys-color-token-subtle)}.security-origin-view .origin-display{font-size:12px;padding-left:var(--sys-size-8);display:flex;align-items:center}.title-section > .view-network-button{padding:6px 0 0 16px}.security-origin-view .origin-display devtools-icon{width:var(--sys-size-8);height:var(--sys-size-8);margin-right:var(--sys-size-6)}.security-origin-view .origin-view-section-title{margin-top:4px;margin-bottom:4px;font-weight:bold}.security-origin-view .details-table{border-spacing:0}.security-origin-view .details-table-row{white-space:nowrap;overflow:hidden;line-height:22px;vertical-align:top}.security-origin-view .details-table-row > td{padding:0}.security-origin-view .details-table-row > td:first-child{color:var(--sys-color-token-subtle);width:calc(120px + 1em);text-align:right;padding-right:1em}.security-origin-view .details-table-row > td:nth-child(2){white-space:normal}.security-origin-view .sct-details .details-table .details-table-row:last-child td:last-child{border-bottom:1px solid var(--sys-color-divider);padding-bottom:10px}.security-origin-view .sct-details .details-table:last-child .details-table-row:last-child td:last-child{border-bottom:none;padding-bottom:0}.security-origin-view .details-toggle{margin-left:126px}.security-origin-view .sct-toggle{margin-left:145px;padding-top:5px}.security-origin-view .details-table .empty-san{color:var(--sys-color-state-disabled)}.security-origin-view .details-table .san-entry{display:block}.security-origin-view .truncated-san .truncated-entry{display:none}.origin-view-section:last-child{border-bottom:none}.devtools-link{display:inline-flex}\n/*# sourceURL=${import.meta.resolve("./originView.css")} */\n`};class te extends J{constructor(e,t){super(e,!1,t),this.setLeadingIcons([m.Icon.create("gear","cookie-icon")])}get elemId(){return"controls"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showFlagControls",{bubbles:!0,composed:!0}))}}class ie extends J{constructor(e,t){super(e,!1,t),this.setLeadingIcons([m.Icon.create("cookie","cookie-icon")])}get elemId(){return"report"}showElement(){this.listItemElement.dispatchEvent(new CustomEvent("showCookieReport",{bubbles:!0,composed:!0}))}}var se={cssText:`.tree-outline-disclosure{width:100%}.tree-outline li.security-group-list-item{& + ol{padding-left:0}&::before{display:none}&:not(:first-child){margin-top:var(--sys-size-6)}}.security-main-view-reload-message{color:var(--sys-color-token-subtle)}.tree-outline li.security-sidebar-origins + .children > li{&.selected{.url-scheme-secure{color:var(--sys-color-green)}.url-scheme-neutral,\n    .url-scheme-insecure,\n    .url-scheme-insecure-broken{color:var(--sys-color-error)}}}.security-main-view-reload-message,\n.tree-outline li.security-sidebar-origins,\n.tree-outline li.security-group-list-item,\n.tree-outline span{font:var(--sys-typescale-body4-medium);&:hover:not(:has(dt-checkbox)) .selection{background:transparent}}.tree-outline li{& .leading-icons{flex:none}& .tree-element-title,\n  .highlighted-url,\n  .title{overflow:hidden;text-overflow:ellipsis}}\n/*# sourceURL=${import.meta.resolve("./sidebar.css")} */\n`};const re={security:"Security",privacy:"Privacy",cookieReport:"Third-party cookies",flagControls:"Controls",mainOrigin:"Main origin",nonsecureOrigins:"Non-secure origins",secureOrigins:"Secure origins",unknownCanceled:"Unknown / canceled",overview:"Overview",reloadToViewDetails:"Reload to view details"},ne=s.i18n.registerUIStrings("panels/security/SecurityPanelSidebar.ts",re),oe=s.i18n.getLocalizedString.bind(void 0,ne);class ae extends a.Widget.VBox{#h;sidebarTree;#g;#p;securityOverviewElement;#m;cookieReportTreeElement;#y;#v;#w;constructor(e){if(super(void 0,void 0,e),this.#h=t.Settings.Settings.instance().createSetting("security-last-selected-element-path",""),this.#w=null,this.sidebarTree=new a.TreeOutline.TreeOutlineInShadow("NavigationTree"),this.sidebarTree.registerRequiredCSS(X,se),this.sidebarTree.element.classList.add("security-sidebar"),this.contentElement.appendChild(this.sidebarTree.element),r.Runtime.hostConfig.devToolsPrivacyUI?.enabled){const e=this.#S(oe(re.privacy),"privacy");this.#m=new te(oe(re.flagControls),"cookie-flag-controls"),e.appendChild(this.#m),this.cookieReportTreeElement=new ie(oe(re.cookieReport),"cookie-report"),e.appendChild(this.cookieReportTreeElement),""===this.#h.get()&&this.#h.set(this.#m.elemId)}const i=oe(re.security),s=this.#S(i,"security");this.securityOverviewElement=new Z("security-main-view-sidebar-tree-item",this.#d),this.securityOverviewElement.tooltip=oe(re.overview),s.appendChild(this.securityOverviewElement),this.#g=new Map([[ke.MainOrigin,{title:oe(re.mainOrigin)}],[ke.NonSecure,{title:oe(re.nonsecureOrigins),icon:ve("insecure","lock-icon lock-icon-insecure")}],[ke.Secure,{title:oe(re.secureOrigins),icon:ve("secure","lock-icon lock-icon-secure")}],[ke.Unknown,{title:oe(re.unknownCanceled),icon:ve("unknown","lock-icon lock-icon-unknown")}]]),this.#p=new Map;for(const e of Object.values(ke)){const t=this.#b(this.#g.get(e)?.title,this.#g.get(e)?.icon);this.#p.set(e,t),s.appendChild(t)}this.#v=new a.TreeOutline.TreeElement(oe(re.reloadToViewDetails)),this.#v.selectable=!1,this.#v.listItemElement.classList.add("security-main-view-reload-message");this.#p.get(ke.MainOrigin).appendChild(this.#v),this.#k(),this.#y=new Map,this.element.addEventListener("update-sidebar-selection",(e=>{const t=e.detail.id;this.#h.set(t)})),this.showLastSelectedElement()}showLastSelectedElement(){this.#m&&this.#h.get()===this.#m.elemId?(this.#m.select(),this.#m.showElement()):this.cookieReportTreeElement&&this.#h.get()===this.cookieReportTreeElement.elemId?(this.cookieReportTreeElement.select(),this.cookieReportTreeElement.showElement()):(this.securityOverviewElement.select(),this.securityOverviewElement.showElement())}#S(e,t){const i=new a.TreeOutline.TreeElement(e,!0,t);return i.listItemElement.classList.add("security-group-list-item"),i.setCollapsible(!1),i.selectable=!1,this.sidebarTree.appendChild(i),a.ARIAUtils.markAsHeading(i.listItemElement,3),a.ARIAUtils.setLabel(i.childrenListElement,e),i}#f(e){return this.#g.get(e)?.title}#x(e){return this.#p.get(e)}#b(e,t){const i=new a.TreeOutline.TreeElement(e,!0);return i.selectable=!1,i.expand(),i.listItemElement.classList.add("security-sidebar-origins"),t&&i.setLeadingIcons([t]),a.ARIAUtils.setLabel(i.childrenListElement,e),i}toggleOriginsList(e){for(const t of this.#p.values())t.hidden=e}addOrigin(e,t){this.#v.hidden=!0;const i=new Z("security-sidebar-tree-item",this.#d,e);i.tooltip=e,this.#y.set(e,i),this.updateOrigin(e,t)}setMainOrigin(e){this.#w=e}get mainOrigin(){return this.#w}get originGroups(){return this.#p}updateOrigin(e,t){const i=this.#y.get(e);let s;if(i.setSecurityState(t),e===this.#w)s=this.#p.get(ke.MainOrigin),s.title=oe(re.mainOrigin),s.setLeadingIcons([we(t,`lock-icon lock-icon-${t}`)]),a.ARIAUtils.setLabel(s.childrenListElement,s.title);else switch(t){case"secure":s=this.#x(ke.Secure);break;case"unknown":s=this.#x(ke.Unknown);break;default:s=this.#x(ke.NonSecure)}const r=i.parent;r!==s&&(r&&(r.removeChild(i),0===r.childCount()&&(r.hidden=!0)),s.appendChild(i),s.hidden=!1)}#k(){for(const[e,t]of this.#p)if(e===ke.MainOrigin){for(let e=t.childCount()-1;e>0;e--)t.removeChildAtIndex(e);t.title=this.#f(ke.MainOrigin),t.hidden=!1,this.#v.hidden=!1}else t.removeChildren(),t.hidden=!0}clearOrigins(){this.#k(),this.#y.clear()}focus(){this.sidebarTree.focus()}#d(e){if(e instanceof Z){const t=e.securityState()??"unknown",i=e.listItemElement.classList.contains("security-main-view-sidebar-tree-item"),s=i?we(t,`lock-icon lock-icon-${t}`):ve(t,`security-property security-property-${t}`),r=i?(()=>{const e=document.createElement("span");return e.classList.add("title"),e.textContent=oe(re.overview),e})():Se(e.origin()??h.DevToolsPath.EmptyUrlString,t);e.setLeadingIcons([s]),e.listItemElement.lastChild&&e.listItemElement.removeChild(e.listItemElement.lastChild),e.listItemElement.appendChild(r)}}}const{widgetConfig:ce}=a.Widget,le={securityOverview:"Security overview",secure:"Secure",info:"Info",notSecure:"Not secure",viewCertificate:"View certificate",notSecureBroken:"Not secure (broken)",thisPageIsDangerousFlaggedBy:"This page is dangerous (flagged by Google Safe Browsing).",flaggedByGoogleSafeBrowsing:"Flagged by Google Safe Browsing",toCheckThisPagesStatusVisit:"To check this page's status, visit g.co/safebrowsingstatus.",thisIsAnErrorPage:"This is an error page.",thisPageIsInsecureUnencrypted:"This page is insecure (unencrypted HTTP).",thisPageHasANonhttpsSecureOrigin:"This page has a non-HTTPS secure origin.",thisPageIsSuspicious:"This page is suspicious",chromeHasDeterminedThatThisSiteS:"Chrome has determined that this site could be fake or fraudulent.",ifYouBelieveThisIsShownIn:"If you believe this is shown in error please visit https://g.co/chrome/lookalike-warnings.",possibleSpoofingUrl:"Possible spoofing URL",thisSitesHostnameLooksSimilarToP:"This site's hostname looks similar to {PH1}. Attackers sometimes mimic sites by making small, hard-to-see changes to the domain name.",ifYouBelieveThisIsShownInErrorSafety:"If you believe this is shown in error please visit https://g.co/chrome/lookalike-warnings.",thisPageIsSuspiciousFlaggedBy:"This page is suspicious (flagged by Chrome).",certificate:"Certificate",insecureSha:"insecure (SHA-1)",theCertificateChainForThisSite:"The certificate chain for this site contains a certificate signed using SHA-1.",subjectAlternativeNameMissing:"`Subject Alternative Name` missing",theCertificateForThisSiteDoesNot:"The certificate for this site does not contain a `Subject Alternative Name` extension containing a domain name or IP address.",missing:"missing",thisSiteIsMissingAValidTrusted:"This site is missing a valid, trusted certificate ({PH1}).",validAndTrusted:"valid and trusted",theConnectionToThisSiteIsUsingA:"The connection to this site is using a valid, trusted server certificate issued by {PH1}.",publickeypinningBypassed:"Public-Key-Pinning bypassed",publickeypinningWasBypassedByA:"Public-Key-Pinning was bypassed by a local root certificate.",certificateExpiresSoon:"Certificate expires soon",theCertificateForThisSiteExpires:"The certificate for this site expires in less than 48 hours and needs to be renewed.",connection:"Connection",secureConnectionSettings:"secure connection settings",theConnectionToThisSiteIs:"The connection to this site is encrypted and authenticated using {PH1}, {PH2}, and {PH3}.",sIsObsoleteEnableTlsOrLater:"{PH1} is obsolete. Enable TLS 1.2 or later.",rsaKeyExchangeIsObsoleteEnableAn:"RSA key exchange is obsolete. Enable an ECDHE-based cipher suite.",sIsObsoleteEnableAnAesgcmbased:"{PH1} is obsolete. Enable an AES-GCM-based cipher suite.",theServerSignatureUsesShaWhichIs:"The server signature uses SHA-1, which is obsolete. Enable a SHA-2 signature algorithm instead. (Note this is different from the signature in the certificate.)",obsoleteConnectionSettings:"obsolete connection settings",resources:"Resources",activeMixedContent:"active mixed content",youHaveRecentlyAllowedNonsecure:"You have recently allowed non-secure content (such as scripts or iframes) to run on this site.",mixedContent:"mixed content",thisPageIncludesHttpResources:"This page includes HTTP resources.",nonsecureForm:"non-secure form",thisPageIncludesAFormWithA:'This page includes a form with a non-secure "action" attribute.',activeContentWithCertificate:"active content with certificate errors",youHaveRecentlyAllowedContent:"You have recently allowed content loaded with certificate errors (such as scripts or iframes) to run on this site.",contentWithCertificateErrors:"content with certificate errors",thisPageIncludesResourcesThat:"This page includes resources that were loaded with certificate errors.",allServedSecurely:"all served securely",allResourcesOnThisPageAreServed:"All resources on this page are served securely.",blockedMixedContent:"Blocked mixed content",yourPageRequestedNonsecure:"Your page requested non-secure resources that were blocked.",reloadThePageToRecordRequestsFor:"Reload the page to record requests for HTTP resources.",viewDRequestsInNetworkPanel:"{n, plural, =1 {View # request in Network Panel} other {View # requests in Network Panel}}",origin:"Origin",viewRequestsInNetworkPanel:"View requests in Network Panel",protocol:"Protocol",keyExchange:"Key exchange",cipher:"Cipher",serverSignature:"Server signature",encryptedClientHello:"Encrypted ClientHello",certificateTransparency:"Certificate Transparency",subject:"Subject",validFrom:"Valid from",validUntil:"Valid until",issuer:"Issuer",openFullCertificateDetails:"Open full certificate details",sct:"SCT",logName:"Log name",logId:"Log ID",validationStatus:"Validation status",source:"Source",issuedAt:"Issued at",hashAlgorithm:"Hash algorithm",signatureAlgorithm:"Signature algorithm",signatureData:"Signature data",showFullDetails:"Show full details",hideFullDetails:"Hide full details",thisRequestCompliesWithChromes:"This request complies with `Chrome`'s Certificate Transparency policy.",thisRequestDoesNotComplyWith:"This request does not comply with `Chrome`'s Certificate Transparency policy.",thisResponseWasLoadedFromCache:"This response was loaded from cache. Some security details might be missing.",theSecurityDetailsAboveAreFrom:"The security details above are from the first inspected response.",thisOriginIsANonhttpsSecure:"This origin is a non-HTTPS secure origin.",yourConnectionToThisOriginIsNot:"Your connection to this origin is not secure.",noSecurityInformation:"No security information",noSecurityDetailsAreAvailableFor:"No security details are available for this origin.",na:"(n/a)",showLess:"Show less",showMoreSTotal:"Show more ({PH1} total)",unknownField:"unknown",enabled:"enabled"},de=s.i18n.registerUIStrings("panels/security/SecurityPanel.ts",le),ue=s.i18n.getLocalizedString.bind(void 0,de);let he;const ge=new Map([[513,"RSA with SHA-1"],[1025,"RSA with SHA-256"],[1281,"RSA with SHA-384"],[1537,"RSA with SHA-512"],[1027,"ECDSA with SHA-256"],[1283,"ECDSA with SHA-384"],[2052,"RSA-PSS with SHA-256"],[2053,"RSA-PSS with SHA-384"],[2054,"RSA-PSS with SHA-512"]]),pe="lock",me="warning",ye="indeterminate-question-box";function ve(e,t){let i;switch(e){case"neutral":case"insecure":case"insecure-broken":i=me;break;case"secure":i=pe;break;case"info":case"unknown":i=ye}return m.Icon.create(i,t)}function we(e,t){let i;switch(e){case"unknown":case"neutral":i=ye;break;case"insecure":case"insecure-broken":i=me;break;case"secure":i=pe;break;case"info":throw new Error(`Unexpected security state ${e}`)}return m.Icon.create(i,t)}function Se(e,t){const i="://",s=e.indexOf(i);if(-1===s){const t=document.createElement("span");return t.textContent=e,t}const r=document.createElement("span");r.classList.add("highlighted-url");const n=e.substr(0,s),o=e.substr(s+3);return r.createChild("span","url-scheme-"+t).textContent=n,r.createChild("span","url-scheme-separator").textContent=i,r.createChild("span").textContent=o,r}class be extends a.Panel.Panel{view;mainView;sidebar;lastResponseReceivedForLoaderId;origins;filterRequestCounts;visibleView;eventListeners;securityModel;splitWidget;constructor(e=(e,t,i)=>{l(d`
    <devtools-split-view direction="column" name="security"
      ${a.Widget.widgetRef(a.SplitWidget.SplitWidget,(e=>{t.splitWidget=e}))}>
        <devtools-widget
          slot="sidebar"
          .widgetConfig=${ce(ae)}
          @showCookieReport=${()=>t.setVisibleView(new H)}
          @showFlagControls=${()=>t.setVisibleView(new C)}
          ${a.Widget.widgetRef(ae,(e=>{t.sidebar=e}))}>
        </devtools-widget>
    </devtools-split-view>`,i,{host:this})}){super("security"),this.view=e,this.update(),this.sidebar.setMinimumSize(100,25),this.sidebar.element.classList.add("panel-sidebar"),this.sidebar.element.setAttribute("jslog",`${u.pane("sidebar").track({resize:!0})}`),this.mainView=new fe,this.mainView.panel=this,this.element.addEventListener(Q.eventName,(e=>{e.origin?this.showOrigin(e.origin):this.setVisibleView(this.mainView)})),this.lastResponseReceivedForLoaderId=new Map,this.origins=new Map,this.filterRequestCounts=new Map,this.visibleView=null,this.eventListeners=[],this.securityModel=null,n.TargetManager.TargetManager.instance().observeModels(O,this,{scoped:!0}),n.TargetManager.TargetManager.instance().addModelListener(n.ResourceTreeModel.ResourceTreeModel,n.ResourceTreeModel.Events.PrimaryPageChanged,this.onPrimaryPageChanged,this),this.sidebar.showLastSelectedElement()}static instance(e={forceNew:null}){const{forceNew:t}=e;return he&&!t||(he=new be),he}static createCertificateViewerButtonForOrigin(e,t){const s=a.UIUtils.createTextButton(e,(async e=>{e.consume();const s=await n.NetworkManager.MultitargetNetworkManager.instance().getCertificate(t);s.length>0&&i.InspectorFrontendHost.InspectorFrontendHostInstance.showCertificateViewer(s)}),{className:"origin-button",jslogContext:"security.view-certificate-for-origin",title:e});return a.ARIAUtils.markAsButton(s),s}static createCertificateViewerButtonForCert(e,t){const s=a.UIUtils.createTextButton(e,(e=>{e.consume(),i.InspectorFrontendHost.InspectorFrontendHostInstance.showCertificateViewer(t)}),{className:"origin-button",jslogContext:"security.view-certificate"});return a.ARIAUtils.markAsButton(s),s}update(){this.view({panel:this},this,this.contentElement)}updateVisibleSecurityState(e){this.sidebar.securityOverviewElement.setSecurityState(e.securityState),this.mainView.updateVisibleSecurityState(e)}onVisibleSecurityStateChanged({data:e}){this.updateVisibleSecurityState(e)}showOrigin(e){const t=this.origins.get(e);t&&(t.originView||(t.originView=new xe(this,e,t)),this.setVisibleView(t.originView))}wasShown(){super.wasShown(),this.visibleView||this.sidebar.showLastSelectedElement()}focus(){this.sidebar.focus()}setVisibleView(e){this.visibleView!==e&&(this.visibleView&&this.visibleView.detach(),this.visibleView=e,e&&this.splitWidget.setMainWidget(e))}onResponseReceived(e){const i=e.data.request;i.resourceType()===t.ResourceType.resourceTypes.Document&&i.loaderId&&this.lastResponseReceivedForLoaderId.set(i.loaderId,i)}processRequest(e){const i=t.ParsedURL.ParsedURL.extractOrigin(e.url());if(!i)return;let s=e.securityState();"blockable"!==e.mixedContentType&&"optionally-blockable"!==e.mixedContentType||(s="insecure");const r=this.origins.get(i);if(r){if(N(s,r.securityState)<0){r.securityState=s;const t=e.securityDetails();t&&(r.securityDetails=t),this.sidebar.updateOrigin(i,s),r.originView&&r.originView.setSecurityState(s)}}else{const t={securityState:s,securityDetails:e.securityDetails(),loadedFromCache:e.cached(),originView:void 0};this.origins.set(i,t),this.sidebar.addOrigin(i,s)}}onRequestFinished(e){const t=e.data;this.updateFilterRequestCounts(t),this.processRequest(t)}updateFilterRequestCounts(e){if("none"===e.mixedContentType)return;let t="all";e.wasBlocked()?t="blocked":"blockable"===e.mixedContentType?t="block-overridden":"optionally-blockable"===e.mixedContentType&&(t="displayed");const i=this.filterRequestCounts.get(t);i?this.filterRequestCounts.set(t,i+1):this.filterRequestCounts.set(t,1),this.mainView.refreshExplanations()}filterRequestCount(e){return this.filterRequestCounts.get(e)||0}modelAdded(e){if(e.target()!==e.target().outermostTarget())return;this.securityModel=e;const i=e.resourceTreeModel(),s=e.networkManager();this.eventListeners.length&&t.EventTarget.removeEventListeners(this.eventListeners),this.eventListeners=[e.addEventListener(B.VisibleSecurityStateChanged,this.onVisibleSecurityStateChanged,this),i.addEventListener(n.ResourceTreeModel.Events.InterstitialShown,this.onInterstitialShown,this),i.addEventListener(n.ResourceTreeModel.Events.InterstitialHidden,this.onInterstitialHidden,this),s.addEventListener(n.NetworkManager.Events.ResponseReceived,this.onResponseReceived,this),s.addEventListener(n.NetworkManager.Events.RequestFinished,this.onRequestFinished,this)],i.isInterstitialShowing&&this.onInterstitialShown()}modelRemoved(e){this.securityModel===e&&(this.securityModel=null,t.EventTarget.removeEventListeners(this.eventListeners))}onPrimaryPageChanged(e){const{frame:i}=e.data,s=this.lastResponseReceivedForLoaderId.get(i.loaderId);this.sidebar.showLastSelectedElement(),this.sidebar.clearOrigins(),this.origins.clear(),this.lastResponseReceivedForLoaderId.clear(),this.filterRequestCounts.clear(),this.mainView.refreshExplanations();const r=t.ParsedURL.ParsedURL.extractOrigin(s?s.url():i.url);this.sidebar.setMainOrigin(r),s&&this.processRequest(s)}onInterstitialShown(){this.sidebar.showLastSelectedElement(),this.sidebar.toggleOriginsList(!0)}onInterstitialHidden(){this.sidebar.toggleOriginsList(!1)}}var ke;!function(e){e.MainOrigin="MainOrigin",e.NonSecure="NonSecure",e.Secure="Secure",e.Unknown="Unknown"}(ke||(ke={}));class fe extends a.Widget.VBox{panel;summarySection;securityExplanationsMain;securityExplanationsExtra;lockSpectrum;summaryText;explanations;securityState;constructor(e){super(void 0,void 0,e),this.registerRequiredCSS(X,Y),this.element.setAttribute("jslog",`${u.pane("security.main-view")}`),this.setMinimumSize(200,100),this.contentElement.classList.add("security-main-view"),this.summarySection=this.contentElement.createChild("div","security-summary"),this.securityExplanationsMain=this.contentElement.createChild("div","security-explanation-list security-explanations-main"),this.securityExplanationsExtra=this.contentElement.createChild("div","security-explanation-list security-explanations-extra");const t=this.summarySection.createChild("div","security-summary-section-title");t.textContent=ue(le.securityOverview),a.ARIAUtils.markAsHeading(t,1);const i=this.summarySection.createChild("div","lock-spectrum");this.lockSpectrum=new Map([["secure",i.appendChild(we("secure","lock-icon lock-icon-secure"))],["neutral",i.appendChild(we("neutral","lock-icon lock-icon-neutral"))],["insecure",i.appendChild(we("insecure","lock-icon lock-icon-insecure"))]]),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("secure"),ue(le.secure)),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("neutral"),ue(le.info)),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),ue(le.notSecure)),this.summarySection.createChild("div","triangle-pointer-container").createChild("div","triangle-pointer-wrapper").createChild("div","triangle-pointer"),this.summaryText=this.summarySection.createChild("div","security-summary-text"),a.ARIAUtils.markAsHeading(this.summaryText,2),this.explanations=null,this.securityState=null}getLockSpectrumDiv(e){const t=this.lockSpectrum.get(e);if(!t)throw new Error(`Invalid argument: ${e}`);return t}addExplanation(e,t){const i=e.createChild("div","security-explanation");i.classList.add("security-explanation-"+t.securityState);const s=ve(t.securityState,"security-property security-property-"+t.securityState);i.appendChild(s);const r=i.createChild("div","security-explanation-text"),n=r.createChild("div","security-explanation-title");if(t.title?(n.createChild("span").textContent=t.title+" - ",n.createChild("span","security-explanation-title-"+t.securityState).textContent=t.summary):n.textContent=t.summary,r.createChild("div").textContent=t.description,t.certificate.length&&r.appendChild(be.createCertificateViewerButtonForCert(ue(le.viewCertificate),t.certificate)),t.recommendations?.length){const e=r.createChild("ul","security-explanation-recommendations");for(const i of t.recommendations)e.createChild("li").textContent=i}return r}updateVisibleSecurityState(e){this.summarySection.classList.remove("security-summary-"+this.securityState),this.securityState=e.securityState,this.summarySection.classList.add("security-summary-"+this.securityState),"insecure"===this.securityState?(this.getLockSpectrumDiv("insecure").classList.add("lock-icon-insecure"),this.getLockSpectrumDiv("insecure").classList.remove("lock-icon-insecure-broken"),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),ue(le.notSecure))):"insecure-broken"===this.securityState&&(this.getLockSpectrumDiv("insecure").classList.add("lock-icon-insecure-broken"),this.getLockSpectrumDiv("insecure").classList.remove("lock-icon-insecure"),a.Tooltip.Tooltip.install(this.getLockSpectrumDiv("insecure"),ue(le.notSecureBroken)));const{summary:t,explanations:i}=this.getSecuritySummaryAndExplanations(e);this.summaryText.textContent=t||z[this.securityState](),this.explanations=this.orderExplanations(i),this.refreshExplanations()}getSecuritySummaryAndExplanations(e){const{securityState:t,securityStateIssueIds:i}=e;let s;const r=[];if(s=this.explainSafetyTipSecurity(e,s,r),i.includes("malicious-content"))s=ue(le.thisPageIsDangerousFlaggedBy),r.unshift(new W("insecure",void 0,ue(le.flaggedByGoogleSafeBrowsing),ue(le.toCheckThisPagesStatusVisit)));else{if(i.includes("is-error-page")&&null===e.certificateSecurityState?.certificateNetworkError)return s=ue(le.thisIsAnErrorPage),{summary:s,explanations:r};"insecure-broken"===t&&i.includes("scheme-is-not-cryptographic")&&(s=s||ue(le.thisPageIsInsecureUnencrypted))}return i.includes("scheme-is-not-cryptographic")?("neutral"!==t||i.includes("insecure-origin")||(s=ue(le.thisPageHasANonhttpsSecureOrigin)),{summary:s,explanations:r}):(this.explainCertificateSecurity(e,r),this.explainConnectionSecurity(e,r),this.explainContentSecurity(e,r),{summary:s,explanations:r})}explainSafetyTipSecurity(e,t,i){const{securityStateIssueIds:s,safetyTipInfo:r}=e,n=[];if(s.includes("bad_reputation")){const e=`${ue(le.chromeHasDeterminedThatThisSiteS)}\n\n${ue(le.ifYouBelieveThisIsShownIn)}`;n.push({summary:ue(le.thisPageIsSuspicious),description:e})}else if(s.includes("lookalike")&&r?.safeUrl){const e=new URL(r.safeUrl).hostname,t=`${ue(le.thisSitesHostnameLooksSimilarToP,{PH1:e})}\n\n${ue(le.ifYouBelieveThisIsShownInErrorSafety)}`;n.push({summary:ue(le.possibleSpoofingUrl),description:t})}return n.length>0&&(t=t||ue(le.thisPageIsSuspiciousFlaggedBy),i.push(new W("insecure",void 0,n[0].summary,n[0].description))),t}explainCertificateSecurity(e,t){const{certificateSecurityState:i,securityStateIssueIds:s}=e,r=ue(le.certificate);if(i?.certificateHasSha1Signature){const e=ue(le.insecureSha),s=ue(le.theCertificateChainForThisSite);i.certificateHasWeakSignature?t.push(new W("insecure",r,e,s,i.certificate,"none")):t.push(new W("neutral",r,e,s,i.certificate,"none"))}i&&s.includes("cert-missing-subject-alt-name")&&t.push(new W("insecure",r,ue(le.subjectAlternativeNameMissing),ue(le.theCertificateForThisSiteDoesNot),i.certificate,"none")),i&&null!==i.certificateNetworkError?t.push(new W("insecure",r,ue(le.missing),ue(le.thisSiteIsMissingAValidTrusted,{PH1:i.certificateNetworkError}),i.certificate,"none")):i&&!i.certificateHasSha1Signature&&t.push(new W("secure",r,ue(le.validAndTrusted),ue(le.theConnectionToThisSiteIsUsingA,{PH1:i.issuer}),i.certificate,"none")),s.includes("pkp-bypassed")&&t.push(new W("info",r,ue(le.publickeypinningBypassed),ue(le.publickeypinningWasBypassedByA))),i?.isCertificateExpiringSoon()&&t.push(new W("info",void 0,ue(le.certificateExpiresSoon),ue(le.theCertificateForThisSiteExpires)))}explainConnectionSecurity(e,t){const i=e.certificateSecurityState;if(!i)return;const s=ue(le.connection);if(i.modernSSL)return void t.push(new W("secure",s,ue(le.secureConnectionSettings),ue(le.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()})));const r=[];i.obsoleteSslProtocol&&r.push(ue(le.sIsObsoleteEnableTlsOrLater,{PH1:i.protocol})),i.obsoleteSslKeyExchange&&r.push(ue(le.rsaKeyExchangeIsObsoleteEnableAn)),i.obsoleteSslCipher&&r.push(ue(le.sIsObsoleteEnableAnAesgcmbased,{PH1:i.cipher})),i.obsoleteSslSignature&&r.push(ue(le.theServerSignatureUsesShaWhichIs)),t.push(new W("info",s,ue(le.obsoleteConnectionSettings),ue(le.theConnectionToThisSiteIs,{PH1:i.protocol,PH2:i.getKeyExchangeName(),PH3:i.getCipherFullName()}),void 0,void 0,r))}explainContentSecurity(e,t){let i=!0;const s=ue(le.resources),r=e.securityStateIssueIds;r.includes("ran-mixed-content")&&(i=!1,t.push(new W("insecure",s,ue(le.activeMixedContent),ue(le.youHaveRecentlyAllowedNonsecure),[],"blockable"))),r.includes("displayed-mixed-content")&&(i=!1,t.push(new W("neutral",s,ue(le.mixedContent),ue(le.thisPageIncludesHttpResources),[],"optionally-blockable"))),r.includes("contained-mixed-form")&&(i=!1,t.push(new W("neutral",s,ue(le.nonsecureForm),ue(le.thisPageIncludesAFormWithA)))),null===e.certificateSecurityState?.certificateNetworkError&&(r.includes("ran-content-with-cert-error")&&(i=!1,t.push(new W("insecure",s,ue(le.activeContentWithCertificate),ue(le.youHaveRecentlyAllowedContent)))),r.includes("displayed-content-with-cert-errors")&&(i=!1,t.push(new W("neutral",s,ue(le.contentWithCertificateErrors),ue(le.thisPageIncludesResourcesThat))))),i&&(r.includes("scheme-is-not-cryptographic")||t.push(new W("secure",s,ue(le.allServedSecurely),ue(le.allResourcesOnThisPageAreServed))))}orderExplanations(e){if(0===e.length)return e;const t=["insecure","neutral","secure","info"],i=[];for(const s of t)i.push(...e.filter((e=>e.securityState===s)));return i}refreshExplanations(){if(this.securityExplanationsMain.removeChildren(),this.securityExplanationsExtra.removeChildren(),this.explanations){for(const e of this.explanations)if("info"===e.securityState)this.addExplanation(this.securityExplanationsExtra,e);else switch(e.mixedContentType){case"blockable":this.addMixedContentExplanation(this.securityExplanationsMain,e,"block-overridden");break;case"optionally-blockable":this.addMixedContentExplanation(this.securityExplanationsMain,e,"displayed");break;default:this.addExplanation(this.securityExplanationsMain,e)}if(this.panel.filterRequestCount("blocked")>0){const e={securityState:"info",summary:ue(le.blockedMixedContent),description:ue(le.yourPageRequestedNonsecure),mixedContentType:"blockable",certificate:[],title:""};this.addMixedContentExplanation(this.securityExplanationsMain,e,"blocked")}}}addMixedContentExplanation(e,t,i){const s=this.addExplanation(e,t),r=this.panel.filterRequestCount(i);if(!r){return void(s.createChild("div","security-mixed-content").textContent=ue(le.reloadThePageToRecordRequestsFor))}const n=s.createChild("button","security-mixed-content devtools-link text-button link-style");a.ARIAUtils.markAsLink(n),n.tabIndex=0,n.textContent=ue(le.viewDRequestsInNetworkPanel,{n:r}),n.addEventListener("click",this.showNetworkFilter.bind(this,i))}showNetworkFilter(e,i){i.consume(),t.Revealer.reveal(p.UIFilter.UIRequestFilter.filters([{filterType:p.UIFilter.FilterType.MixedContent,filterValue:e}]))}}class xe extends a.Widget.VBox{panel;originLockIcon;constructor(e,i,r){super(),this.registerRequiredCSS(ee,X),this.element.setAttribute("jslog",`${u.pane("security.origin-view")}`),this.panel=e,this.setMinimumSize(200,100),this.element.classList.add("security-origin-view");const n=this.element.createChild("div","title-section"),o=n.createChild("div","title-section-header");o.textContent=ue(le.origin),a.ARIAUtils.markAsHeading(o,1);const c=n.createChild("div","origin-display");this.originLockIcon=c.createChild("span");const l=ve(r.securityState,`security-property security-property-${r.securityState}`);this.originLockIcon.appendChild(l),c.appendChild(Se(i,r.securityState));const d=n.createChild("div","view-network-button"),h=a.UIUtils.createTextButton(ue(le.viewRequestsInNetworkPanel),(e=>{e.consume();const s=new t.ParsedURL.ParsedURL(i);t.Revealer.reveal(p.UIFilter.UIRequestFilter.filters([{filterType:p.UIFilter.FilterType.Domain,filterValue:s.host},{filterType:p.UIFilter.FilterType.Scheme,filterValue:s.scheme}]))}),{jslogContext:"reveal-in-network"});if(d.appendChild(h),a.ARIAUtils.markAsLink(h),r.securityDetails){const g=this.element.createChild("div","origin-view-section"),m=g.createChild("div","origin-view-section-title");m.textContent=ue(le.connection),a.ARIAUtils.markAsHeading(m,2);let y=new Ce;if(g.appendChild(y.element()),y.addRow(ue(le.protocol),r.securityDetails.protocol),r.securityDetails.keyExchange&&r.securityDetails.keyExchangeGroup?y.addRow(ue(le.keyExchange),r.securityDetails.keyExchange+" with "+r.securityDetails.keyExchangeGroup):r.securityDetails.keyExchange?y.addRow(ue(le.keyExchange),r.securityDetails.keyExchange):r.securityDetails.keyExchangeGroup&&y.addRow(ue(le.keyExchange),r.securityDetails.keyExchangeGroup),r.securityDetails.serverSignatureAlgorithm){let R=ge.get(r.securityDetails.serverSignatureAlgorithm);R??=ue(le.unknownField)+" ("+r.securityDetails.serverSignatureAlgorithm+")",y.addRow(ue(le.serverSignature),R)}y.addRow(ue(le.cipher),r.securityDetails.cipher+(r.securityDetails.mac?" with "+r.securityDetails.mac:"")),r.securityDetails.encryptedClientHello&&y.addRow(ue(le.encryptedClientHello),ue(le.enabled));const v=this.element.createChild("div","origin-view-section"),w=v.createChild("div","origin-view-section-title");w.textContent=ue(le.certificate),a.ARIAUtils.markAsHeading(w,2);const S=r.securityDetails.signedCertificateTimestampList.length,b=r.securityDetails.certificateTransparencyCompliance;let k;if(S||"unknown"!==b){k=this.element.createChild("div","origin-view-section");const P=k.createChild("div","origin-view-section-title");P.textContent=ue(le.certificateTransparency),a.ARIAUtils.markAsHeading(P,2)}const f=this.createSanDiv(r.securityDetails.sanList),x=new Date(1e3*r.securityDetails.validFrom).toUTCString(),C=new Date(1e3*r.securityDetails.validTo).toUTCString();if(y=new Ce,v.appendChild(y.element()),y.addRow(ue(le.subject),r.securityDetails.subjectName),y.addRow(s.i18n.lockedString("SAN"),f),y.addRow(ue(le.validFrom),x),y.addRow(ue(le.validUntil),C),y.addRow(ue(le.issuer),r.securityDetails.issuer),y.addRow("",be.createCertificateViewerButtonForOrigin(ue(le.openFullCertificateDetails),i)),!k)return;const T=new Ce;T.element().classList.add("sct-summary"),k.appendChild(T.element());for(let A=0;A<S;A++){const L=r.securityDetails.signedCertificateTimestampList[A];T.addRow(ue(le.sct),L.logDescription+" ("+L.origin+", "+L.status+")")}const E=k.createChild("div","sct-details");E.classList.add("hidden");for(let M=0;M<S;M++){const H=new Ce;E.appendChild(H.element());const D=r.securityDetails.signedCertificateTimestampList[M];H.addRow(ue(le.logName),D.logDescription),H.addRow(ue(le.logId),D.logId.replace(/(.{2})/g,"$1 ")),H.addRow(ue(le.validationStatus),D.status),H.addRow(ue(le.source),D.origin),H.addRow(ue(le.issuedAt),new Date(D.timestamp).toUTCString()),H.addRow(ue(le.hashAlgorithm),D.hashAlgorithm),H.addRow(ue(le.signatureAlgorithm),D.signatureAlgorithm),H.addRow(ue(le.signatureData),D.signatureData.replace(/(.{2})/g,"$1 "))}if(S){function U(){let e;const t=!E.classList.contains("hidden");e=ue(t?le.showFullDetails:le.hideFullDetails),F.textContent=e,a.ARIAUtils.setLabel(F,e),a.ARIAUtils.setExpanded(F,!t),T.element().classList.toggle("hidden"),E.classList.toggle("hidden")}const F=a.UIUtils.createTextButton(ue(le.showFullDetails),U,{className:"details-toggle",jslogContext:"security.toggle-scts-details"});k.appendChild(F)}switch(b){case"compliant":k.createChild("div","origin-view-section-notes").textContent=ue(le.thisRequestCompliesWithChromes);break;case"not-compliant":k.createChild("div","origin-view-section-notes").textContent=ue(le.thisRequestDoesNotComplyWith)}const I=this.element.createChild("div","origin-view-section origin-view-notes");r.loadedFromCache&&(I.createChild("div").textContent=ue(le.thisResponseWasLoadedFromCache)),I.createChild("div").textContent=ue(le.theSecurityDetailsAboveAreFrom)}else if("secure"===r.securityState){const $=this.element.createChild("div","origin-view-section"),V=$.createChild("div","origin-view-section-title");V.textContent=ue(le.secure),a.ARIAUtils.markAsHeading(V,2),$.createChild("div").textContent=ue(le.thisOriginIsANonhttpsSecure)}else if("unknown"!==r.securityState){const O=this.element.createChild("div","origin-view-section"),N=O.createChild("div","origin-view-section-title");N.textContent=ue(le.notSecure),a.ARIAUtils.markAsHeading(N,2),O.createChild("div").textContent=ue(le.yourConnectionToThisOriginIsNot)}else{const B=this.element.createChild("div","origin-view-section"),z=B.createChild("div","origin-view-section-title");z.textContent=ue(le.noSecurityInformation),a.ARIAUtils.markAsHeading(z,2),B.createChild("div").textContent=ue(le.noSecurityDetailsAreAvailableFor)}}createSanDiv(e){const t=document.createElement("div");if(0===e.length)t.textContent=ue(le.na),t.classList.add("empty-san");else{const i=2,s=e.length>i+1;for(let r=0;r<e.length;r++){const n=t.createChild("span","san-entry");n.textContent=e[r],s&&r>=i&&n.classList.add("truncated-entry")}if(s){function o(){const i=t.classList.contains("truncated-san");let s;i?(t.classList.remove("truncated-san"),s=ue(le.showLess)):(t.classList.add("truncated-san"),s=ue(le.showMoreSTotal,{PH1:e.length})),c.textContent=s,a.ARIAUtils.setLabel(c,s),a.ARIAUtils.setExpanded(c,i)}const c=a.UIUtils.createTextButton(ue(le.showMoreSTotal,{PH1:e.length}),o,{jslogContext:"security.toggle-san-truncation"});t.appendChild(c),o()}}return t}setSecurityState(e){this.originLockIcon.removeChildren();const t=ve(e,`security-property security-property-${e}`);this.originLockIcon.appendChild(t)}}class Ce{elementInternal;constructor(){this.elementInternal=document.createElement("table"),this.elementInternal.classList.add("details-table")}element(){return this.elementInternal}addRow(e,t){const i=this.elementInternal.createChild("tr","details-table-row");i.createChild("td").textContent=e;const s=i.createChild("td");"string"==typeof t?s.textContent=t:s.appendChild(t)}}var Te=Object.freeze({__proto__:null,get OriginGroup(){return ke},SecurityDetailsTable:Ce,SecurityMainView:fe,SecurityOriginView:xe,SecurityPanel:be,SecurityRevealer:class{async reveal(){await a.ViewManager.ViewManager.instance().showView("security");const e=a.ViewManager.ViewManager.instance().view("security");if(e){const t=await e.widget();if(!(t instanceof be&&t.sidebar.cookieReportTreeElement))throw new Error("Expected securityPanel to be an instance of SecurityPanel with a cookieReportTreeElement in the sidebar");t.sidebar.cookieReportTreeElement.select(!1,!0)}}},createHighlightedUrl:Se,getSecurityStateIconForDetailedView:ve,getSecurityStateIconForOverview:we});export{T as CookieControlsView,D as CookieReportView,K as SecurityModel,Te as SecurityPanel};
