"use strict";

import { resolveValue, ToastPosition } from './types';
import { genId } from './utils';
import { announceForAccessibility } from '../utils';
import { ActionType, dispatch } from './store';
const createToast = (message, type = 'blank', opts) => ({
  createdAt: Date.now(),
  visible: true,
  type,
  message,
  pauseDuration: 0,
  position: ToastPosition.TOP,
  providerKey: 'DEFAULT',
  isSwipeable: true,
  animationType: opts?.animationType,
  animationConfig: opts?.animationConfig,
  ...opts,
  id: opts?.id || genId()
});
const createHandler = type => (message, options) => {
  const toast = createToast(message, type, options);
  dispatch({
    type: ActionType.UPSERT_TOAST,
    toast
  });
  if (toast.accessabilityMessage) {
    announceForAccessibility(toast.accessabilityMessage);
  }
  return toast.id;
};
const toast = (message, opts) => createHandler('blank')(message, opts);
toast.error = createHandler('error');
toast.success = createHandler('success');
toast.loading = createHandler('loading');
toast.dismiss = toastId => {
  dispatch({
    type: ActionType.DISMISS_TOAST,
    toastId
  });
};
toast.remove = toastId => dispatch({
  type: ActionType.REMOVE_TOAST,
  toastId
});
toast.promise = (promise, msgs, opts) => {
  const id = toast.loading(msgs.loading, {
    ...opts,
    ...opts?.loading
  });
  promise.then(p => {
    toast.success(resolveValue(msgs.success, p), {
      id,
      ...opts,
      ...opts?.success
    });
    return p;
  }).catch(e => {
    toast.error(resolveValue(msgs.error, e), {
      id,
      ...opts,
      ...opts?.error
    });
  });
  return promise;
};
export { toast };
//# sourceMappingURL=toast.js.map