"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toast = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactNative = require("react-native");
var _reactNativeReanimated = _interopRequireWildcard(require("react-native-reanimated"));
var _reactNativeSafeAreaContext = require("react-native-safe-area-context");
var _reactNativeGestureHandler = require("react-native-gesture-handler");
var _types = require("../core/types");
var _utils = require("../utils");
var _headless = require("../headless");
var _jsxRuntime = require("react/jsx-runtime");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnimatedPressable = _reactNativeReanimated.default.createAnimatedComponent(_reactNative.Pressable);
const DEFAULT_TOAST_HEIGHT = 50;
const Toast = ({
  toast,
  updateHeight,
  offset,
  startPause,
  endPause,
  overrideDarkMode,
  onToastHide,
  onToastPress,
  onToastShow,
  extraInsets,
  defaultStyle,
  keyboardVisible,
  keyboardHeight
}) => {
  const insets = (0, _reactNativeSafeAreaContext.useSafeAreaInsets)();
  const {
    width,
    height
  } = (0, _reactNative.useWindowDimensions)();
  (0, _utils.useVisibilityChange)(() => {
    onToastShow?.(toast);
  }, () => {
    onToastHide?.(toast);
  }, toast.visible);
  const isSystemDarkMode = (0, _reactNative.useColorScheme)() === 'dark';
  const isDarkMode = overrideDarkMode !== undefined ? overrideDarkMode : isSystemDarkMode;
  const [toastHeight, setToastHeight] = (0, _react.useState)(toast?.height ? toast.height : DEFAULT_TOAST_HEIGHT);
  const [toastWidth, setToastWidth] = (0, _react.useState)(toast?.width ? toast.width : width - 32 > 360 ? 360 : width - 32);
  const startingY = (0, _react.useMemo)(() => toast.position === _types.ToastPosition.TOP ? -(toast.height || DEFAULT_TOAST_HEIGHT) - insets.top - 50 : height - insets.bottom - _reactNative.Platform.select({
    ios: 0,
    default: 32
  }), [height, toast.position, insets.bottom, insets.top, toast.height]);
  const opacity = (0, _reactNativeReanimated.useSharedValue)(0);
  const position = (0, _reactNativeReanimated.useSharedValue)(startingY);
  const offsetY = (0, _reactNativeReanimated.useSharedValue)(startingY);
  const onPress = () => onToastPress?.(toast);
  const dismiss = (0, _react.useCallback)(id => {
    _headless.toast.dismiss(id);
  }, []);
  const setPosition = (0, _react.useCallback)(() => {
    let timingConfig = {
      duration: 300
    };
    let springConfig = {
      stiffness: 80
    };
    if (toast.animationConfig) {
      const {
        duration = 300,
        easing = _reactNativeReanimated.Easing.inOut(_reactNativeReanimated.Easing.quad),
        reduceMotion = _reactNativeReanimated.ReduceMotion.System,
        ...spring
      } = toast.animationConfig;
      timingConfig = {
        duration,
        easing,
        reduceMotion
      };
      springConfig = spring;
    }
    const useSpringAnimation = toast.animationType === 'spring';
    const animation = useSpringAnimation ? _reactNativeReanimated.withSpring : _reactNativeReanimated.withTiming;
    if (toast.position === _types.ToastPosition.TOP) {
      offsetY.value = animation(toast.visible ? offset : startingY, useSpringAnimation ? springConfig : timingConfig);
      position.value = animation(toast.visible ? offset : startingY, useSpringAnimation ? springConfig : timingConfig);
    } else {
      let kbHeight = keyboardVisible ? keyboardHeight : 0;
      const val = toast.visible ? startingY - toastHeight - offset - kbHeight - insets.bottom - (extraInsets?.bottom ?? 0) - 24 : startingY;
      offsetY.value = animation(val, useSpringAnimation ? springConfig : timingConfig);
      position.value = animation(val, useSpringAnimation ? springConfig : timingConfig);
    }
  }, [offset, toast.visible, keyboardVisible, keyboardHeight, toastHeight, insets.bottom, position, startingY, toast.position, offsetY, extraInsets, toast.animationConfig, toast.animationType]);
  const composedGesture = (0, _react.useMemo)(() => {
    const panGesture = _reactNativeGestureHandler.Gesture.Pan().onUpdate(e => {
      offsetY.value = e.translationY / 4 + position.value;
    }).onEnd(() => {
      (0, _reactNativeReanimated.runOnJS)(setPosition)();
    });
    const flingGesture = _reactNativeGestureHandler.Gesture.Fling().direction(toast.position === _types.ToastPosition.TOP ? _reactNativeGestureHandler.Directions.UP : _reactNativeGestureHandler.Directions.DOWN).onEnd(() => {
      offsetY.value = (0, _reactNativeReanimated.withTiming)(startingY, {
        duration: toast?.animationConfig?.flingPositionReturnDuration ?? 40
      });
      (0, _reactNativeReanimated.runOnJS)(dismiss)(toast.id);
    });
    return toast.isSwipeable ? _reactNativeGestureHandler.Gesture.Simultaneous(flingGesture, panGesture) : panGesture;
  }, [offsetY, startingY, position, setPosition, toast.position, toast.id, dismiss, toast.isSwipeable, toast.animationConfig]);
  (0, _react.useEffect)(() => {
    setToastHeight(toast?.height ? toast.height : DEFAULT_TOAST_HEIGHT);
  }, [toast.height]);
  (0, _react.useEffect)(() => {
    setToastWidth(toast?.width ? toast.width : width - 32 > 360 ? 360 : width - 32);
  }, [toast.width, width]);
  (0, _react.useEffect)(() => {
    opacity.value = (0, _reactNativeReanimated.withTiming)(toast.visible ? 1 : 0, {
      duration: toast?.animationConfig?.duration ?? 300
    });
  }, [toast.visible, opacity, toast.animationConfig]);
  (0, _react.useEffect)(() => {
    setPosition();
  }, [offset, toast.visible, keyboardVisible, keyboardHeight, toastHeight, setPosition]);
  const style = (0, _reactNativeReanimated.useAnimatedStyle)(() => {
    //Control opacity and translation of toast
    return {
      opacity: opacity.value,
      transform: [{
        translateY: offsetY.value
      }]
    };
  });
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNativeGestureHandler.GestureDetector, {
    gesture: composedGesture,
    children: /*#__PURE__*/(0, _jsxRuntime.jsx)(AnimatedPressable, {
      testID: "toast-pressable",
      onPressIn: startPause,
      onPressOut: () => {
        endPause();
      },
      onPress: onPress,
      style: [{
        backgroundColor: !toast.customToast ? isDarkMode ? _utils.colors.backgroundDark : _utils.colors.backgroundLight : undefined,
        borderRadius: 8,
        position: 'absolute',
        left: (width - toastWidth) / 2,
        zIndex: toast.visible ? 9999 : undefined,
        alignItems: 'center',
        justifyContent: 'center'
      }, style, !toast.disableShadow && (0, _utils.ConstructShadow)('#181821', 0.15, false), defaultStyle?.pressable, toast.styles?.pressable],
      children: toast.customToast ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
        testID: "toast-view",
        onLayout: event => updateHeight(toast.id, event.nativeEvent.layout.height),
        children: toast.customToast({
          ...toast,
          height: toastHeight,
          width: toastWidth
        })
      }, toast.id) : /*#__PURE__*/(0, _jsxRuntime.jsxs)(_reactNative.View, {
        testID: "toast-view",
        onLayout: event => updateHeight(toast.id, event.nativeEvent.layout.height),
        style: [{
          minHeight: toastHeight,
          width: toastWidth,
          flexDirection: 'row',
          alignItems: 'center',
          paddingVertical: 12,
          paddingHorizontal: 16
        }, defaultStyle?.view, toast.styles?.view],
        children: [(toast.type === 'error' || toast.type === 'success') && /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.View, {
          style: [{
            backgroundColor: toast.type === 'error' ? _utils.colors.error : toast.type === 'success' ? _utils.colors.success : isDarkMode ? _utils.colors.backgroundDark : _utils.colors.backgroundLight,
            width: 3,
            height: '100%',
            borderRadius: 12,
            marginRight: 12
          }, defaultStyle?.indicator, toast?.styles?.indicator]
        }), typeof toast.icon === 'string' ? /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Text, {
          children: toast.icon
        }) : toast.icon, /*#__PURE__*/(0, _jsxRuntime.jsx)(_reactNative.Text, {
          style: [{
            color: isDarkMode ? _utils.colors.textLight : _utils.colors.textDark,
            padding: 4,
            flex: 1
          }, defaultStyle?.text, toast?.styles?.text],
          children: (0, _types.resolveValue)(toast.message, toast)
        })]
      }, toast.id)
    })
  }, toast.id);
};
exports.Toast = Toast;
//# sourceMappingURL=Toast.js.map