'use strict';

const name = "uniwind";

var Platform = /* @__PURE__ */ ((Platform2) => {
  Platform2["Android"] = "android";
  Platform2["iOS"] = "ios";
  Platform2["Web"] = "web";
  Platform2["Native"] = "native";
  return Platform2;
})(Platform || {});

const isDefined = (value) => value !== null && value !== void 0;
const toCamelCase = (str) => str.replace(/-([a-z])/g, (_, letter) => letter.toUpperCase());
const pipe = (data) => ((...fns) => fns.reduce((acc, fn) => fn(acc), data));
const isNumber = (data) => {
  if (typeof data === "number") {
    return true;
  }
  if (typeof data === "string" && data !== "") {
    return !isNaN(Number(data));
  }
  return false;
};
const smartSplit = (str, separator = " ") => {
  const escaper = "&&&";
  return pipe(str)(
    (x) => x.replace(/\s\?\?\s/g, `${escaper}??${escaper}`),
    (x) => x.replace(/\s([+\-*/])\s/g, `${escaper}$1${escaper}`),
    (x) => x.split(separator),
    (x) => x.map((token) => token.replace(new RegExp(escaper, "g"), " "))
  );
};
const addMissingSpaces = (str) => pipe(str)(
  (x) => x.trim(),
  (x) => x.replace(/]this/g, "] this"),
  (x) => x.replace(/\](?=\d)/g, "] "),
  (x) => x.replace(/\)(?=\S)/g, ") "),
  (x) => x.replace(/(?<!^)(?<!\s)"(?=\d)/g, '" ')
);
const uniq = (arr) => Array.from(new Set(arr));
const isValidJSValue = (jsValueString) => {
  try {
    new Function(`const test = ${jsValueString}`);
    return true;
  } catch {
    return false;
  }
};
const shouldBeSerialized = (value) => {
  if (value.includes("-")) {
    return value.split("-").some(shouldBeSerialized);
  }
  return [
    isNumber(value),
    value.startsWith("this["),
    value.startsWith("rt."),
    /[*/+-]/.test(value),
    value.includes('"'),
    value.includes(" ")
  ].some(Boolean);
};
const roundToPrecision = (value, precision) => parseFloat(value.toFixed(precision));

exports.Platform = Platform;
exports.addMissingSpaces = addMissingSpaces;
exports.isDefined = isDefined;
exports.isNumber = isNumber;
exports.isValidJSValue = isValidJSValue;
exports.name = name;
exports.pipe = pipe;
exports.roundToPrecision = roundToPrecision;
exports.shouldBeSerialized = shouldBeSerialized;
exports.smartSplit = smartSplit;
exports.toCamelCase = toCamelCase;
exports.uniq = uniq;
