import { jsx } from "react/jsx-runtime";
import { Image as RNImage } from "react-native";
import { useUniwindAccent } from "../../hooks/index.js";
import { copyComponentProperties } from "../utils.js";
import { toRNWClassName } from "./rnw.js";
export const Image = copyComponentProperties(RNImage, (props) => {
  const tintColor = useUniwindAccent(props.tintColorClassName);
  return /* @__PURE__ */ jsx(
    RNImage,
    {
      ...props,
      style: [toRNWClassName(props.className), props.style],
      tintColor: props.tintColor ?? tintColor
    }
  );
});
export default Image;
