import { jsx } from "react/jsx-runtime";
import { Switch as RNSwitch } from "react-native";
import { useUniwindAccent } from "../../hooks/useUniwindAccent.native.js";
import { copyComponentProperties } from "../utils.js";
import { useStyle } from "./useStyle.js";
export const Switch = copyComponentProperties(RNSwitch, (props) => {
  const state = {
    isDisabled: Boolean(props.disabled)
  };
  const style = useStyle(props.className, state);
  const trackColorOn = useUniwindAccent(props.trackColorOnClassName, state);
  const trackColorOff = useUniwindAccent(props.trackColorOffClassName, state);
  const thumbColor = useUniwindAccent(props.thumbColorClassName, state);
  const ios_backgroundColor = useUniwindAccent(props.ios_backgroundColorClassName, state);
  return /* @__PURE__ */ jsx(
    RNSwitch,
    {
      ...props,
      style: [style, props.style],
      thumbColor: props.thumbColor ?? thumbColor,
      trackColor: { true: props.trackColor?.true ?? trackColorOn, false: props.trackColor?.false ?? trackColorOff },
      ios_backgroundColor: props.ios_backgroundColor ?? ios_backgroundColor
    }
  );
});
export default Switch;
