import { jsx } from "react/jsx-runtime";
import { FlatList as RNFlatList } from "react-native";
import { useUniwindAccent } from "../../hooks/index.js";
import { copyComponentProperties } from "../utils.js";
import { useStyle } from "./useStyle.js";
export const FlatList = copyComponentProperties(RNFlatList, (props) => {
  const style = useStyle(props.className);
  const styleColumnWrapper = useStyle(props.columnWrapperClassName);
  const styleContentContainer = useStyle(props.contentContainerClassName);
  const styleListFooterComponent = useStyle(props.ListFooterComponentClassName);
  const styleListHeaderComponent = useStyle(props.ListHeaderComponentClassName);
  const endFillColor = useUniwindAccent(props.endFillColorClassName);
  const hasSingleColumn = !("numColumns" in props) || props.numColumns === 1;
  return /* @__PURE__ */ jsx(
    RNFlatList,
    {
      ...props,
      style: [style, props.style],
      columnWrapperStyle: hasSingleColumn ? void 0 : [styleColumnWrapper, props.columnWrapperStyle],
      contentContainerStyle: [styleContentContainer, props.contentContainerStyle],
      ListFooterComponentStyle: [styleListFooterComponent, props.ListFooterComponentStyle],
      ListHeaderComponentStyle: [styleListHeaderComponent, props.ListHeaderComponentStyle],
      endFillColor: props.endFillColor ?? endFillColor
    }
  );
});
export default FlatList;
