"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUniwind = void 0;
var _react = require("react");
var _core = require("../core");
var _web = require("../core/web");
const useUniwind = () => {
  const [theme, setTheme] = (0, _react.useState)(_core.Uniwind.currentTheme);
  const [hasAdaptiveThemes, setHasAdaptiveThemes] = (0, _react.useState)(_core.Uniwind.hasAdaptiveThemes);
  (0, _react.useEffect)(() => {
    const dispose = _web.CSSListener.addThemeListener(() => {
      setTheme(_core.Uniwind.currentTheme);
      setHasAdaptiveThemes(_core.Uniwind.hasAdaptiveThemes);
    });
    return () => {
      dispose();
    };
  }, []);
  return {
    theme,
    hasAdaptiveThemes
  };
};
exports.useUniwind = useUniwind;