"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Uniwind = void 0;
var _reactNative = require("react-native");
var _types = require("../../types");
var _themeChange = require("./themeChange");
const SYSTEM_THEME = "system";
class UniwindConfigBuilder {
  #hasAdaptiveThemes = true;
  #currentTheme = this.colorScheme;
  constructor() {
    if (_reactNative.Platform.OS === "web") {
      this.emitThemeChange();
    }
    _reactNative.Appearance.addChangeListener(event => {
      const colorScheme = event.colorScheme ?? _types.ColorScheme.Light;
      const prevTheme = this.#currentTheme;
      if (this.#hasAdaptiveThemes && prevTheme !== colorScheme) {
        this.#currentTheme = colorScheme;
        this.emitThemeChange();
      }
    });
  }
  get hasAdaptiveThemes() {
    return this.#hasAdaptiveThemes;
  }
  get currentTheme() {
    return this.#currentTheme;
  }
  get themes() {
    return globalThis.__uniwindThemes__ ?? ["light", "dark"];
  }
  get colorScheme() {
    return _reactNative.Appearance.getColorScheme() ?? _types.ColorScheme.Light;
  }
  // eslint-disable-next-line @typescript-eslint/no-redundant-type-constituents
  setTheme(theme) {
    const prevTheme = this.#currentTheme;
    const prevHasAdaptiveThemes = this.#hasAdaptiveThemes;
    const isAdaptiveTheme = ["light", "dark"].includes(theme);
    if (theme === SYSTEM_THEME) {
      this.#hasAdaptiveThemes = true;
      this.#currentTheme = this.colorScheme;
      if (prevTheme !== this.#currentTheme || prevHasAdaptiveThemes !== this.#hasAdaptiveThemes) {
        this.emitThemeChange();
      }
      if (_reactNative.Platform.OS !== "web") {
        _reactNative.Appearance.setColorScheme(void 0);
      }
      return;
    }
    if (!this.themes.includes(theme)) {
      throw new Error(`Uniwind: You're trying to setTheme to '${theme}', but it was not registered.`);
    }
    this.#hasAdaptiveThemes = false;
    this.#currentTheme = theme;
    if (prevTheme !== this.#currentTheme || prevHasAdaptiveThemes !== this.#hasAdaptiveThemes) {
      this.emitThemeChange();
    }
    if (_reactNative.Platform.OS !== "web") {
      _reactNative.Appearance.setColorScheme(isAdaptiveTheme ? this.#currentTheme : void 0);
    }
  }
  emitThemeChange() {
    (0, _themeChange.themeChange)(this.#currentTheme, this.themes);
  }
}
const Uniwind = exports.Uniwind = new UniwindConfigBuilder();