"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
module.exports = exports.Text = void 0;
var _jsxRuntime = require("react/jsx-runtime");
var _react = require("react");
var _reactNative = require("react-native");
var _useUniwindAccent = require("../../hooks/useUniwindAccent.native");
var _utils = require("../utils");
var _useStyle = require("./useStyle");
const Text = exports.Text = (0, _utils.copyComponentProperties)(_reactNative.Text, props => {
  const [isPressed, setIsPressed] = (0, _react.useState)(false);
  const state = {
    isPressed,
    isDisabled: Boolean(props.disabled)
  };
  const style = (0, _useStyle.useStyle)(props.className, state);
  const selectionColor = (0, _useUniwindAccent.useUniwindAccent)(props.selectionColorClassName, state);
  return /* @__PURE__ */(0, _jsxRuntime.jsx)(_reactNative.Text, {
    ...props,
    style: [style, props.style],
    selectionColor: props.selectionColor ?? selectionColor,
    numberOfLines: style.WebkitLineClamp ?? props.numberOfLines,
    onPressIn: event => {
      setIsPressed(true);
      props.onPressIn?.(event);
    },
    onPressOut: event => {
      setIsPressed(false);
      props.onPressOut?.(event);
    }
  });
});
module.exports = Text;