"use strict";
// src/utils/FetchWrapper.ts
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FetchWrapper = void 0;
class FetchWrapper {
    constructor(baseUrl, apiKey, clientKey) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.clientKey = clientKey;
    }
    request(endpoint, params) {
        return __awaiter(this, void 0, void 0, function* () {
            const url = new URL(`${this.baseUrl}/${endpoint}`);
            url.search = new URLSearchParams(Object.assign(Object.assign({ key: this.apiKey }, params), (this.clientKey ? { client_key: this.clientKey } : {}))).toString();
            const response = yield fetch(url.toString());
            if (!response.ok) {
                throw new Error(`Error: ${response.status} ${response.statusText}`);
            }
            return response.json();
        });
    }
    get(endpoint, params = {}) {
        return this.request(endpoint, params);
    }
}
exports.FetchWrapper = FetchWrapper;
