import { FetchWrapper } from '../utils/FetchWrapper';
export interface SuggestionsParams {
    q: string;
    country?: string;
    locale?: string;
    limit?: number;
}
export interface SuggestionsResponse {
    results: string[];
}
export declare class SuggestionsService {
    private fetchWrapper;
    constructor(fetchWrapper: FetchWrapper);
    /**
     * Fetches a list of alternative search terms (suggestions) for a given search term.
     *
     * @param params - An object containing the search parameters.
     * @returns A promise that resolves to a SuggestionsResponse containing the suggested search terms.
     */
    getSuggestions(params: SuggestionsParams): Promise<SuggestionsResponse>;
}
