import { FetchWrapper } from '../utils/FetchWrapper';
import { ResponseObject } from './interfaces/ResponseObject';
export interface SearchParams {
    q: string;
    searchfilter?: string;
    country?: string;
    locale?: string;
    contentfilter?: 'off' | 'low' | 'medium' | 'high';
    media_filter?: string;
    ar_range?: 'all' | 'wide' | 'standard';
    random?: boolean;
    limit?: number;
    pos?: string;
}
export interface SearchResponse {
    next: string;
    results: ResponseObject[];
}
export declare class SearchService {
    private fetchWrapper;
    constructor(fetchWrapper: FetchWrapper);
    /**
     * Searches for GIFs, stickers, or other media types based on the provided parameters.
     *
     * @param params - An object containing the search parameters.
     * @returns A promise that resolves to a SearchResponse containing the search results and the next page token.
     */
    query(params: SearchParams | {
        pos: string;
    }): Promise<SearchResponse>;
    /**
     * Fetches the next page of results based on the provided next token.
     *
     * @param next - The next page token from a previous search response.
     * @returns A promise that resolves to a SearchResponse containing the next set of results.
     */
    fetchNext(next: string): Promise<SearchResponse>;
}
