import { FetchWrapper } from '../utils/FetchWrapper';
import { CategoryObject } from './interfaces/CategoryObject';
export interface CategoriesParams {
    country?: string;
    locale?: string;
    type?: 'featured' | 'trending';
    contentfilter?: 'off' | 'low' | 'medium' | 'high';
}
export interface CategoriesResponse {
    tags: CategoryObject[];
}
export declare class CategoryService {
    private fetchWrapper;
    constructor(fetchWrapper: FetchWrapper);
    /**
     * Fetches a list of GIF categories associated with the provided type.
     *
     * @param params - An object containing the parameters for the request.
     * @returns A promise that resolves to a CategoriesResponse containing the list of categories.
     */
    getCategories(params?: CategoriesParams): Promise<CategoriesResponse>;
}
