"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startProfiling = startProfiling;
exports.stopProfiling = stopProfiling;
const NOT_STARTED_PROFILER = {
  stop: () => {
    console.warn('The profiler has not been started');
    return Promise.resolve({
      frames: [],
      resources: [],
      samples: [],
      stacks: []
    });
  }
};
let profiler = NOT_STARTED_PROFILER;
const SAMPLING_INTERVAL = 10;
const MAX_BUFFER_SIZE = 10000;
const MICRO_SECONDS_IN_MILLISECONDS = 1000;
function startProfiling() {
  if (typeof window.Profiler !== 'function') {
    console.warn('Profiler is not available in this browser. Ignoring this profiler run...');
    return false;
  }
  profiler = new Profiler({
    sampleInterval: SAMPLING_INTERVAL,
    maxBufferSize: MAX_BUFFER_SIZE
  });
  return true;
}
async function stopProfiling(saveToDownloads = false, fileName = `trace-${new Date().toISOString()}.cpuprofile.txt`) {
  const trace = await profiler.stop();
  profiler = NOT_STARTED_PROFILER;
  const hermesProfiler = convertToHermesProfilerFormat(trace);
  downloadJsonFile(hermesProfiler, fileName);
  if (!saveToDownloads) {
    console.warn('Specifying `saveToDownloads=false` is not supported on web, as downloading is the only one possible way to store the trace file');
  }
  return fileName;
}
function downloadJsonFile(exportObj, exportName) {
  const dataStr = 'data:text/json;charset=utf-8,' + encodeURIComponent(JSON.stringify(exportObj));
  const downloadAnchorNode = document.createElement('a');
  downloadAnchorNode.setAttribute('href', dataStr);
  downloadAnchorNode.setAttribute('download', exportName);
  document.body.appendChild(downloadAnchorNode); // required for Firefox
  downloadAnchorNode.click();
  downloadAnchorNode.remove();
}
function convertToHermesProfilerFormat(profilingTrace) {
  const {
    frames,
    resources,
    samples,
    stacks
  } = profilingTrace;
  return {
    traceEvents: [],
    samples: samples.map(sample => ({
      cpu: '-1',
      name: '',
      ts: sample.timestamp * MICRO_SECONDS_IN_MILLISECONDS,
      pid: 1,
      tid: '1',
      weight: '1',
      sf: sample.stackId ?? 1
    })),
    stackFrames: stacks.map(stack => {
      var _frames$stack$frameId, _frames$stack$frameId2;
      const resourceId = (_frames$stack$frameId = frames[stack.frameId]) === null || _frames$stack$frameId === void 0 ? void 0 : _frames$stack$frameId.resourceId;
      return {
        parent: stack.parentId,
        category: 'JavaScript',
        ...frames[stack.frameId],
        name: `${(_frames$stack$frameId2 = frames[stack.frameId]) === null || _frames$stack$frameId2 === void 0 ? void 0 : _frames$stack$frameId2.name}(${resourceId ? resources[resourceId] : null})`
      };
    })
  };
}
//# sourceMappingURL=index.web.js.map