"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _child_process = require("child_process");
function getConfig() {
  return new Promise((resolve, reject) => {
    // Get path to react-native binary:
    const reactNativePath = require.resolve('react-native/cli.js');
    (0, _child_process.exec)(`${reactNativePath} config`, (error, stdout, stderr) => {
      if (error) {
        console.error(`exec error: ${error}`);
        reject(error);
        return;
      }
      try {
        const config = JSON.parse(stdout);
        resolve(config);
      } catch (e) {
        console.error(`Failed to parse the output of "npx react-native config" to JSON. Are you sure the output returns a JSON-only string?\nError: ${e}`);
        reject(e);
        return;
      }

      // If we get here it means that the config object could be parsed as JSON, so we can assume
      // that loading the config went fine. We still want to inform about any warnings or errors
      // that might have occured along the way:
      if (stderr) {
        console.warn("The following problem occured during retrieving the app's config:");
        console.warn(stderr);
      }
    });
  });
}
var _default = exports.default = getConfig;
//# sourceMappingURL=getConfig.js.map