"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyboardController = void 0;
var _bindings = require("./bindings");
let isClosed = true;
let lastState = {
  height: 0,
  duration: 0,
  timestamp: new Date().getTime(),
  target: -1,
  type: "default",
  appearance: "light"
};
_bindings.KeyboardEvents.addListener("keyboardDidHide", e => {
  isClosed = true;
  lastState = e;
});
_bindings.KeyboardEvents.addListener("keyboardDidShow", e => {
  isClosed = false;
  lastState = e;
});
const dismiss = async options => {
  const keepFocus = (options === null || options === void 0 ? void 0 : options.keepFocus) ?? false;
  return new Promise(resolve => {
    if (isClosed) {
      resolve();
      return;
    }
    const subscription = _bindings.KeyboardEvents.addListener("keyboardDidHide", () => {
      resolve(undefined);
      subscription.remove();
    });
    _bindings.KeyboardControllerNative.dismiss(keepFocus);
  });
};
const isVisible = () => !isClosed;
const state = () => lastState;

/**
 * KeyboardController module. Helps to perform imperative actions/checks with keyboard.
 */
const KeyboardController = exports.KeyboardController = {
  setDefaultMode: _bindings.KeyboardControllerNative.setDefaultMode,
  setInputMode: _bindings.KeyboardControllerNative.setInputMode,
  setFocusTo: _bindings.KeyboardControllerNative.setFocusTo,
  preload: _bindings.KeyboardControllerNative.preload,
  dismiss,
  isVisible,
  state
};
//# sourceMappingURL=module.js.map