"use strict";

import React from 'react';
import OLElement from "../elements/OLElement.js";
import { useRendererProps } from "../context/RenderersPropsProvider.js";
function getFallbackListStyleTypeFromNestLevel(nestLevel) {
  switch (nestLevel % 3) {
    case 0:
      return 'decimal';

    /* istanbul ignore next */
    case 1:
      return 'upper-alpha';

    /* istanbul ignore next */
    default:
      return 'lower-alpha';
  }
}
export function useOLElementProps(props) {
  const config = useRendererProps('ol');
  return {
    ...props,
    getFallbackListStyleTypeFromNestLevel,
    ...config
  };
}
const OLRenderer = props => {
  return /*#__PURE__*/React.createElement(OLElement, useOLElementProps(props));
};
export default OLRenderer;
//# sourceMappingURL=OLRenderer.js.map