"use strict";

import React from 'react';
import useNormalizedUrl from "../hooks/useNormalizedUrl.js";
import { useDocumentMetadata } from "../context/DocumentMetadataProvider.js";
import { useRendererProps } from "../context/RenderersPropsProvider.js";
function useAnchorOnLinkPress(tnode, onPress) {
  const href = tnode.attributes.href ?? '';
  const normalizedHref = useNormalizedUrl(href);
  const {
    baseTarget
  } = useDocumentMetadata();
  const shouldHandleLinkPress = tnode.tagName === 'a' && typeof normalizedHref === 'string' && href.length > 0 && typeof onPress === 'function';
  return shouldHandleLinkPress ? e => onPress(e, normalizedHref, tnode.attributes, tnode.attributes.target || baseTarget) : undefined;
}
export function useAElementProps(props) {
  const {
    tnode
  } = props;
  const {
    onPress
  } = useRendererProps('a');
  const syntheticAnchorOnLinkPress = useAnchorOnLinkPress(tnode, onPress);
  if (typeof syntheticAnchorOnLinkPress !== 'function') {
    return props;
  }
  return {
    ...props,
    onPress: syntheticAnchorOnLinkPress
  };
}
const ARenderer = props => {
  return /*#__PURE__*/React.createElement(props.TDefaultRenderer, useAElementProps(props));
};
export default ARenderer;
//# sourceMappingURL=ARenderer.js.map