"use strict";

import React from 'react';
import TNodeRenderer from "./TNodeRenderer.js";
import collapseTopMarginForChild from "./helpers/collapseTopMarginForChild.js";
import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
const mapCollapsibleChildren = (propsForChildren, renderChild, disableMarginCollapsing, childTnode, n, tchildren) => {
  const collapsedMarginTop = disableMarginCollapsing ? null : collapseTopMarginForChild(n, tchildren);
  const propsFromParent = {
    ...propsForChildren,
    collapsedMarginTop
  };
  const key = childTnode.nodeIndex;
  const childElement = /*#__PURE__*/React.createElement(TNodeRenderer, {
    propsFromParent,
    tnode: childTnode,
    key,
    renderIndex: n,
    renderLength: tchildren.length
  });
  return typeof renderChild === 'function' ? renderChild({
    key,
    childElement,
    index: n,
    childTnode,
    propsFromParent
  }) : childElement;
};
export default function renderChildren({
  tchildren,
  propsForChildren = {},
  disableMarginCollapsing,
  renderChild
}) {
  const elements = tchildren.map(mapCollapsibleChildren.bind(null, propsForChildren, renderChild, disableMarginCollapsing));
  return /*#__PURE__*/_jsx(_Fragment, {
    children: elements
  });
}
//# sourceMappingURL=renderChildren.js.map