"use strict";

import IMGElement from "../elements/IMGElement.js";
import OLElement from "../elements/OLElement.js";
import ULElement from "../elements/ULElement.js";
import { useAElementProps } from "../renderers/ARenderer.js";
import { useIMGElementProps } from "../renderers/IMGRenderer.js";
import { useOLElementProps } from "../renderers/OLRenderer.js";
import { useULElementProps } from "../renderers/ULRenderer.js";
const specialRenderersConfig = {
  img: {
    hook: useIMGElementProps,
    Element: IMGElement
  },
  ol: {
    hook: useOLElementProps,
    Element: OLElement
  },
  ul: {
    hook: useULElementProps,
    Element: ULElement
  },
  a: {
    hook: useAElementProps,
    Element: undefined
  }
};
function hasSpecialInternalRenderer(tagName) {
  return tagName in specialRenderersConfig;
}
/**
 * Resuse internal renderers logic for infinite customization!
 *
 * @remarks `tagName` must be invariant, i.e. it cannot change. You would
 * otherwise break the rules of hooks.
 *
 * @param tagName - **Invariant** The tag name to extend.
 * @param props - The props passed to the custom renderer.
 * @typeParam T - The name of the tag to target.
 * @returns An object with two fields: `Renderer` (the internal react
 * component) and `rendererProps`, the internal component props.
 *
 * @public
 */
export default function useInternalRenderer(tagName, props) {
  const {
    TDefaultRenderer,
    ...rendererProps
  } = props;
  if (hasSpecialInternalRenderer(tagName)) {
    return {
      Renderer: specialRenderersConfig[tagName].Element || TDefaultRenderer,
      rendererProps: specialRenderersConfig[tagName].hook(props)
    };
  }
  return {
    Renderer: TDefaultRenderer,
    rendererProps
  };
}
//# sourceMappingURL=useInternalRenderer.js.map