"use strict";

import { useMemo, useRef } from 'react';
import { useSharedProps } from "../context/SharedPropsProvider.js";
export default function useIMGNormalizedSource({
  source,
  specifiedDimensions
}) {
  const cachedDimensions = useRef(specifiedDimensions);
  const {
    provideEmbeddedHeaders
  } = useSharedProps();
  return useMemo(() => {
    if (source.uri && typeof provideEmbeddedHeaders === 'function') {
      const headers = provideEmbeddedHeaders(source.uri, 'img', {
        printWidth: cachedDimensions.current?.width || undefined,
        printHeight: cachedDimensions.current?.height || undefined
      });
      if (headers) {
        return {
          headers,
          ...source
        };
      }
    }
    return source;
  }, [provideEmbeddedHeaders, source]);
}
//# sourceMappingURL=useIMGNormalizedSource.js.map