"use strict";

import React from 'react';
import { View } from 'react-native';
import useSymbolicMarkerRendererProps from "./useSymbolicMarkerRendererStyles.js";
export default function DisclosureOpenSymbolRenderer(props) {
  const {
    prefixStyle: {
      top
    },
    prefixSize
  } = useSymbolicMarkerRendererProps(props, 1);
  return /*#__PURE__*/React.createElement(View, {
    style: {
      top,
      width: 0,
      height: 0,
      borderStyle: 'solid',
      borderTopWidth: prefixSize,
      borderTopColor: props.color,
      borderLeftWidth: prefixSize / 2,
      borderLeftColor: 'transparent',
      borderRightWidth: prefixSize / 2,
      borderRightColor: 'transparent'
    }
  });
}
//# sourceMappingURL=DisclosureOpenSymbolRenderer.js.map