"use strict";

import { Linking } from 'react-native';
export async function defaultAOnPress(_e, href) {
  try {
    await Linking.openURL(href);
  } catch (e) {
    console.warn(`Could not open URL "${href}".`, e);
  }
  return null;
}
const defaultRendererProps = {
  img: {
    initialDimensions: {
      height: 50,
      width: 50
    },
    enableExperimentalPercentWidth: false
  },
  a: {
    onPress: defaultAOnPress
  },
  ol: {},
  ul: {}
};
export default defaultRendererProps;
//# sourceMappingURL=defaultRendererProps.js.map