"use strict";

import { memo, useEffect, useMemo } from 'react';
import DocumentMetadataProvider from "./context/DocumentMetadataProvider.js";
import TNodeRenderer from "./TNodeRenderer.js";
import { jsx as _jsx } from "react/jsx-runtime";
const TDocumentRenderer = /*#__PURE__*/memo(({
  tdoc,
  baseUrl,
  onDocumentMetadataLoaded
}) => {
  const metadata = useMemo(() => {
    const {
      baseHref,
      baseTarget,
      lang,
      links,
      meta,
      title,
      dir
    } = tdoc.context;
    return {
      baseTarget,
      baseUrl: baseUrl ?? baseHref,
      lang,
      dir,
      links,
      meta,
      title
    };
  }, [tdoc.context, baseUrl]);
  useEffect(() => {
    onDocumentMetadataLoaded?.call(null, metadata);
  }, [onDocumentMetadataLoaded, metadata]);
  return /*#__PURE__*/_jsx(DocumentMetadataProvider, {
    value: metadata,
    children: /*#__PURE__*/_jsx(TNodeRenderer, {
      renderIndex: 0,
      renderLength: 1,
      tnode: tdoc
    })
  });
});
export default TDocumentRenderer;
//# sourceMappingURL=TDocumentRenderer.js.map