"use strict";

import { useMemo } from 'react';
import RenderersPropsProvider from "./context/RenderersPropsProvider.js";
import SharedPropsProvider from "./context/SharedPropsProvider.js";
import TChildrenRenderersContext from "./context/TChildrenRendererContext.js";
import TNodeChildrenRenderer from "./TNodeChildrenRenderer.js";
import TChildrenRenderer from "./TChildrenRenderer.js";
import sourceLoaderContext, { defaultRenderError, defaultRenderLoading } from "./context/sourceLoaderContext.js";
import RenderRegistryProvider from "./context/RenderRegistryProvider.js";
import { useAmbientTRenderEngine } from "./TRenderEngineProvider.js";
import useProfiler from "./hooks/useProfiler.js";
import ListStyleSpecsProvider from "./context/ListStyleSpecsProvider.js";
import { jsx as _jsx } from "react/jsx-runtime";
const childrenRendererContext = {
  TChildrenRenderer,
  TNodeChildrenRenderer
};

/**
 * A component to provide configuration for {@link RenderHTMLSource}
 * descendants, to be used in conjunction with {@link TRenderEngineProvider}.
 */
export default function RenderHTMLConfigProvider(props) {
  const {
    remoteErrorView,
    remoteLoadingView,
    renderersProps,
    children,
    renderers,
    ...sharedProps
  } = props;
  const engine = useAmbientTRenderEngine();
  const profile = useProfiler({
    prop: 'remoteErrorView or remoteLoadingView'
  });
  const sourceLoaderConfig = useMemo(() => {
    typeof __DEV__ === 'boolean' && __DEV__ && profile();
    return {
      remoteErrorView: remoteErrorView || defaultRenderError,
      remoteLoadingView: remoteLoadingView || defaultRenderLoading
    };
  }, [remoteErrorView, remoteLoadingView, profile]);
  return /*#__PURE__*/_jsx(RenderRegistryProvider, {
    renderers: renderers,
    elementModels: engine.getHTMLElementsModels(),
    children: /*#__PURE__*/_jsx(SharedPropsProvider, {
      ...sharedProps,
      children: /*#__PURE__*/_jsx(ListStyleSpecsProvider, {
        children: /*#__PURE__*/_jsx(RenderersPropsProvider, {
          renderersProps: renderersProps,
          children: /*#__PURE__*/_jsx(TChildrenRenderersContext.Provider, {
            value: childrenRendererContext,
            children: /*#__PURE__*/_jsx(sourceLoaderContext.Provider, {
              value: sourceLoaderConfig,
              children: children
            })
          })
        })
      })
    })
  });
}
//# sourceMappingURL=RenderHTMLConfigProvider.js.map