/**
 * @name html-crush
 * @fileoverview Minifies HTML/CSS: valid or broken, pure or mixed with other languages
 * @version 4.2.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/html-crush/}
 */

!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).htmlCrush={})}(this,(function(e){"use strict";
/**
 * @name ranges-sort
 * @fileoverview Sort string index ranges
 * @version 4.1.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/ranges-sort/}
 */const t={strictlyTwoElementsInRangeArrays:!1,progressFn:null};function r(e,r){if(!Array.isArray(e)||!e.length)return e;const n={...t,...r};let i,s;if(n.strictlyTwoElementsInRangeArrays&&!e.filter((e=>e)).every(((e,t)=>2===e.length||(i=t,s=e.length,!1))))throw new TypeError(`ranges-sort: [THROW_ID_03] The first argument should be an array and must consist of arrays which are natural number indexes representing TWO string index ranges. However, ${i}th range (${JSON.stringify(e[i],null,4)}) has not two but ${s} elements!`);if(!e.filter((e=>e)).every(((e,t)=>!(!Number.isInteger(e[0])||e[0]<0||!Number.isInteger(e[1])||e[1]<0)||(i=t,!1))))throw new TypeError(`ranges-sort: [THROW_ID_04] The first argument should be an array and must consist of arrays which are natural number indexes representing string index ranges. However, ${i}th range (${JSON.stringify(e[i],null,4)}) does not consist of only natural numbers!`);const o=e.filter((e=>e)).length**2;let a=0;return Array.from(e).filter((e=>e)).sort(((e,t)=>(n.progressFn&&(a+=1,n.progressFn(Math.floor(100*a/o))),e[0]===t[0]?e[1]<t[1]?-1:e[1]>t[1]?1:0:e[0]<t[0]?-1:1)))}
/**
 * @name ranges-merge
 * @fileoverview Merge and sort string index ranges
 * @version 7.1.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/ranges-merge/}
 */const n={mergeType:1,progressFn:null,joinRangesThatTouchEdges:!0};function i(e,t){function i(e){return e&&"object"==typeof e&&!Array.isArray(e)}if(!Array.isArray(e)||!e.length)return null;let s;if(t){if(!i(t))throw new Error(`emlint: [THROW_ID_03] the second input argument must be a plain object. It was given as:\n${JSON.stringify(t,null,4)} (type ${typeof t})`);if(s={...n,...t},s.progressFn&&i(s.progressFn)&&!Object.keys(s.progressFn).length)s.progressFn=null;else if(s.progressFn&&"function"!=typeof s.progressFn)throw new Error(`ranges-merge: [THROW_ID_01] opts.progressFn must be a function! It was given of a type: "${typeof s.progressFn}", equal to ${JSON.stringify(s.progressFn,null,4)}`);if(s.mergeType&&1!=+s.mergeType&&2!=+s.mergeType)throw new Error(`ranges-merge: [THROW_ID_02] opts.mergeType was customised to a wrong thing! It was given of a type: "${typeof s.mergeType}", equal to ${JSON.stringify(s.mergeType,null,4)}`);if("boolean"!=typeof s.joinRangesThatTouchEdges)throw new Error(`ranges-merge: [THROW_ID_04] opts.joinRangesThatTouchEdges was customised to a wrong thing! It was given of a type: "${typeof s.joinRangesThatTouchEdges}", equal to ${JSON.stringify(s.joinRangesThatTouchEdges,null,4)}`)}else s={...n};const o=e.filter((e=>e)).map((e=>[...e])).filter((e=>void 0!==e[2]||e[0]!==e[1]));let a,l,u;if(a=s.progressFn?r(o,{progressFn:e=>{u=Math.floor(e/5),u!==l&&(l=u,s.progressFn(u))}}):r(o),!a)return null;const h=a.length-1;for(let e=h;e>0;e--)s.progressFn&&(u=Math.floor(78*(1-e/h))+21,u!==l&&u>l&&(l=u,s.progressFn(u))),(a[e][0]<=a[e-1][0]||!s.joinRangesThatTouchEdges&&a[e][0]<a[e-1][1]||s.joinRangesThatTouchEdges&&a[e][0]<=a[e-1][1])&&(a[e-1][0]=Math.min(a[e][0],a[e-1][0]),a[e-1][1]=Math.max(a[e][1],a[e-1][1]),void 0!==a[e][2]&&(a[e-1][0]>=a[e][0]||a[e-1][1]<=a[e][1])&&null!==a[e-1][2]&&(null===a[e][2]&&null!==a[e-1][2]?a[e-1][2]=null:null!=a[e-1][2]?2==+s.mergeType&&a[e-1][0]===a[e][0]?a[e-1][2]=a[e][2]:a[e-1][2]+=a[e][2]:a[e-1][2]=a[e][2]),a.splice(e,1),e=a.length);return a.length?a:null}
/**
 * @name ranges-apply
 * @fileoverview Take an array of string index ranges, delete/replace the string according to them
 * @version 5.1.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/ranges-apply/}
 */
/**
 * @name string-collapse-leading-whitespace
 * @fileoverview Collapse the leading and trailing whitespace of a string
 * @version 5.1.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/string-collapse-leading-whitespace/}
 */
function s(e,t=1){function r(e){return Array.from(e).reverse().join("")}function n(e,t,r){const n=r?"\n":"\r",i=r?"\r":"\n";if(!e)return e;let s=0,o="";for(let r=0,a=e.length;r<a;r++)(e[r]===n||e[r]===i&&e[r-1]!==n)&&s++,"\r\n".includes(e[r])||" "===e[r]?" "===e[r]?o+=e[r]:e[r]===n?s<=t&&(o+=e[r],e[r+1]===i&&(o+=e[r+1],r++)):e[r]===i&&(!e[r-1]||e[r-1]!==n)&&s<=t&&(o+=e[r]):e[r+1]||s||(o+=" ");return o}if("string"==typeof e&&e.length){let i=1;"number"==typeof+t&&Number.isInteger(+t)&&+t>=0&&(i=+t);let s="",o="";if(e.trim()){if(!e[0].trim())for(let t=0,r=e.length;t<r;t++)if(e[t].trim()){s=e.slice(0,t);break}}else s=e;if(e.trim()&&(""===e.slice(-1).trim()||" "===e.slice(-1)))for(let t=e.length;t--;)if(e[t].trim()){o=e.slice(t+1);break}return`${n(s,i,!1)}${e.trim()}${r(n(r(o),i,!0))}`}return e}
/**
 * @name ranges-push
 * @fileoverview Gather string index ranges
 * @version 5.1.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/ranges-push/}
 */function o(e){return null!=e}function a(e){return Number.isInteger(e)&&e>=0}function l(e){return"string"==typeof e}const u={limitToBeAddedWhitespace:!1,limitLinebreaksCount:1,mergeType:1};
/**
 * @name string-match-left-right
 * @fileoverview Match substrings on the left or right of a given index, ignoring whitespace
 * @version 7.1.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/string-match-left-right/}
 */
function h(e){return e&&"object"==typeof e&&!Array.isArray(e)}function f(e){return"string"==typeof e}const c={cb:void 0,i:!1,trimBeforeMatching:!1,trimCharsBeforeMatching:[],maxMismatches:0,firstMustMatch:!1,lastMustMatch:!1,hungry:!1},g=e=>e+1;function p(e,t,r,n,i=!1,s=g){const o="function"==typeof r?r():r;if(+t<0&&i&&"EOL"===o)return o;const a={...c,...n};if(t>=e.length&&!i)return!1;let l=i?1:r.length,u=0,h=!1,f=!1,p=!1,d=a.maxMismatches,m=t,y=!1,T=!1,b=!1;function w(){return 1===u&&d<a.maxMismatches-1}for(;e[m];){const t=s(m);if(a.trimBeforeMatching&&""===e[m].trim()){if(!e[t]&&i&&"EOL"===r)return!0;m=s(m);continue}if(a&&!a.i&&a.trimCharsBeforeMatching&&a.trimCharsBeforeMatching.includes(e[m])||a&&a.i&&a.trimCharsBeforeMatching&&a.trimCharsBeforeMatching.map((e=>e.toLowerCase())).includes(e[m].toLowerCase())){if(i&&"EOL"===r&&!e[t])return!0;m=s(m);continue}const n=t>m?r[r.length-l]:r[l-1];if(!a.i&&e[m]===n||a.i&&e[m].toLowerCase()===n.toLowerCase()){if(y||(y=!0),p||(p=!0),l===r.length){if(T=!0,d!==a.maxMismatches)return!1}else 1===l&&(b=!0);if(l-=1,u++,w())return!1;if(!l)return(u!==r.length||d===a.maxMismatches||!h)&&m}else{if(h||u||(h=!0),!(a.maxMismatches&&d&&m))return!(0!==m||1!==l||a.lastMustMatch||!p)&&0;d-=1;for(let n=0;n<=d;n++){const i=t>m?r[r.length-l+1+n]:r[l-2-n],o=e[s(m)];if(i&&(!a.i&&e[m]===i||a.i&&e[m].toLowerCase()===i.toLowerCase())&&(!a.firstMustMatch||l!==r.length)){if(u++,w())return!1;l-=2,y=!0;break}if(o&&i&&(!a.i&&o===i||a.i&&o.toLowerCase()===i.toLowerCase())&&(!a.firstMustMatch||l!==r.length)){if(!u&&!a.hungry)return!1;l-=1,y=!0;break}if(void 0===i&&d>=0&&y&&(!a.firstMustMatch||T)&&(!a.lastMustMatch||b))return m}y||(f=m)}if(!1!==f&&f!==m&&(f=!1),l<1)return m;m=s(m)}return l>0?!(!i||"EOL"!==o)||!!(a&&a.maxMismatches>=l&&p)&&(f||0):void 0}function d(e,t,r,n,i){if(h(i)&&Object.prototype.hasOwnProperty.call(i,"trimBeforeMatching")&&"boolean"!=typeof i.trimBeforeMatching)throw new Error(`string-match-left-right/${e}(): [THROW_ID_09] opts.trimBeforeMatching should be boolean!${Array.isArray(i.trimBeforeMatching)?" Did you mean to use opts.trimCharsBeforeMatching?":""}`);const s={...c,...i};
/**
 * @name arrayiffy-if-string
 * @fileoverview Put non-empty strings into arrays, turn empty-ones into empty arrays. Bypass everything else.
 * @version 3.14.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/arrayiffy-if-string/}
 */
var o;if("string"==typeof s.trimCharsBeforeMatching&&(s.trimCharsBeforeMatching="string"==typeof(o=s.trimCharsBeforeMatching)?o.length?[o]:[]:o),s.trimCharsBeforeMatching=s.trimCharsBeforeMatching.map((e=>f(e)?e:String(e))),!f(t))return!1;if(!t.length)return!1;if(!Number.isInteger(r)||r<0)throw new Error(`string-match-left-right/${e}(): [THROW_ID_03] the second argument should be a natural number. Currently it's of a type: ${typeof r}, equal to:\n${JSON.stringify(r,null,4)}`);let a,l;if(f(n))a=[n];else if(Array.isArray(n))a=n;else if(n){if("function"!=typeof n)throw new Error(`string-match-left-right/${e}(): [THROW_ID_05] the third argument, whatToMatch, is neither string nor array of strings! It's ${typeof n}, equal to:\n${JSON.stringify(n,null,4)}`);a=[],a.push(n)}else a=n;if(i&&!h(i))throw new Error(`string-match-left-right/${e}(): [THROW_ID_06] the fourth argument, options object, should be a plain object. Currently it's of a type "${typeof i}", and equal to:\n${JSON.stringify(i,null,4)}`);let u=0,g="";if(s&&s.trimCharsBeforeMatching&&s.trimCharsBeforeMatching.some(((e,t)=>e.length>1&&(u=t,g=e,!0))))throw new Error(`string-match-left-right/${e}(): [THROW_ID_07] the fourth argument, options object contains trimCharsBeforeMatching. It was meant to list the single characters but one of the entries at index ${u} is longer than 1 character, ${g.length} (equals to ${g}). Please split it into separate characters and put into array as separate elements.`);if(!a||!Array.isArray(a)||Array.isArray(a)&&!a.length||Array.isArray(a)&&1===a.length&&f(a[0])&&!a[0].trim()){if("function"==typeof s.cb){let n,i=r;if("matchLeftIncl"!==e&&"matchRight"!==e||(i+=1),"L"===e[5])for(let e=i;e--;){const r=t[e];if((!s.trimBeforeMatching||s.trimBeforeMatching&&void 0!==r&&r.trim())&&(!s.trimCharsBeforeMatching||!s.trimCharsBeforeMatching.length||void 0!==r&&!s.trimCharsBeforeMatching.includes(r))){n=e;break}}else if(e.startsWith("matchRight"))for(let e=i;e<t.length;e++){const r=t[e];if((!s.trimBeforeMatching||s.trimBeforeMatching&&r.trim())&&(!s.trimCharsBeforeMatching||!s.trimCharsBeforeMatching.length||!s.trimCharsBeforeMatching.includes(r))){n=e;break}}if(void 0===n)return!1;const o=t[n],a=n+1;let l="";return a&&a>0&&(l=t.slice(0,a)),"L"===e[5]?s.cb(o,l,n):(n&&n>0&&(l=t.slice(n)),s.cb(o,l,n))}let n="";throw i||(n=" More so, the whole options object, the fourth input argument, is missing!"),new Error(`string-match-left-right/${e}(): [THROW_ID_08] the third argument, "whatToMatch", was given as an empty string. This means, you intend to match purely by a callback. The callback was not set though, the opts key "cb" is not set!${n}`)}for(let n=0,i=a.length;n<i;n++){l="function"==typeof a[n];const i=a[n];let o,u,h="",f=r;"matchRight"===e?f+=1:"matchLeft"===e&&(f-=1);const c=p(t,f,i,s,l,(t=>"L"===e[5]?t-1:t+1));if(c&&l&&"function"==typeof i&&"EOL"===i())return!(!i()||s.cb&&!s.cb(o,h,u))&&i();if(Number.isInteger(c)&&(u=e.startsWith("matchLeft")?c-1:c+1,h="L"===e[5]?t.slice(0,c):t.slice(u)),u<0&&(u=void 0),t[u]&&(o=t[u]),Number.isInteger(c)&&(!s.cb||s.cb(o,h,u)))return i}return!1}function m(e,t,r,n){return d("matchLeft",e,t,r,n)}function y(e,t,r,n){return d("matchRightIncl",e,t,r,n)}function T(e,t,r,n){return d("matchRight",e,t,r,n)}
/**
 * @name string-range-expander
 * @fileoverview Expands string index ranges within whitespace boundaries until letters are met
 * @version 2.1.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/string-range-expander/}
 */const b={str:"",from:0,to:0,ifLeftSideIncludesThisThenCropTightly:"",ifLeftSideIncludesThisCropItToo:"",ifRightSideIncludesThisThenCropTightly:"",ifRightSideIncludesThisCropItToo:"",extendToOneSide:!1,wipeAllWhitespaceOnLeft:!1,wipeAllWhitespaceOnRight:!1,addSingleSpaceToPreventAccidentalConcatenation:!1};function w(e){const t=/^[0-9a-zA-Z]+$/;function r(e){return!(!e||"string"!=typeof e)&&!e.trim()}function n(e){return"string"==typeof e}if(!e||"object"!=typeof e||Array.isArray(e)){let t;throw t=void 0===e?"but it is missing completely.":null===e?"but it was given as null.":`but it was given as ${typeof e}, equal to:\n${JSON.stringify(e,null,4)}.`,new Error(`string-range-expander: [THROW_ID_01] Input must be a plain object ${t}`)}if("object"==typeof e&&null!==e&&!Array.isArray(e)&&!Object.keys(e).length)throw new Error("string-range-expander: [THROW_ID_02] Input must be a plain object but it was given as a plain object without any keys.");if("number"!=typeof e.from)throw new Error(`string-range-expander: [THROW_ID_03] The input's "from" value opts.from, is not a number! Currently it's given as ${typeof e.from}, equal to ${JSON.stringify(e.from,null,0)}`);if("number"!=typeof e.to)throw new Error(`string-range-expander: [THROW_ID_04] The input's "to" value opts.to, is not a number! Currently it's given as ${typeof e.to}, equal to ${JSON.stringify(e.to,null,0)}`);if(e&&e.str&&!e.str[e.from]&&e.from!==e.to)throw new Error(`string-range-expander: [THROW_ID_05] The given input string opts.str ("${e.str}") must contain the character at index "from" ("${e.from}")`);if(e&&e.str&&!e.str[e.to-1])throw new Error(`string-range-expander: [THROW_ID_06] The given input string, opts.str ("${e.str}") must contain the character at index before "to" ("${e.to-1}")`);if(e.from>e.to)throw new Error(`string-range-expander: [THROW_ID_07] The given "from" index, "${e.from}" is greater than "to" index, "${e.to}". That's wrong!`);if(n(e.extendToOneSide)&&"left"!==e.extendToOneSide&&"right"!==e.extendToOneSide||!n(e.extendToOneSide)&&void 0!==e.extendToOneSide&&!1!==e.extendToOneSide)throw new Error(`string-range-expander: [THROW_ID_08] The opts.extendToOneSide value is not recogniseable! It's set to: "${e.extendToOneSide}" (${typeof e.extendToOneSide}). It has to be either Boolean "false" or strings "left" or "right"`);const i={...b,...e};if(Array.isArray(i.ifLeftSideIncludesThisThenCropTightly)){let e,t;if(!i.ifLeftSideIncludesThisThenCropTightly.every(((r,i)=>!!n(r)||(e=i,t=r,!1))))throw new Error(`string-range-expander: [THROW_ID_09] The opts.ifLeftSideIncludesThisThenCropTightly was set to an array:\n${JSON.stringify(i.ifLeftSideIncludesThisThenCropTightly,null,4)}. Now, that array contains not only string elements. For example, an element at index ${e} is of a type ${typeof t} (equal to ${JSON.stringify(t,null,0)}).`);i.ifLeftSideIncludesThisThenCropTightly=i.ifLeftSideIncludesThisThenCropTightly.join("")}const s=i.str;let o=i.from,a=i.to;if("right"!==i.extendToOneSide&&(r(s[o-1])&&(r(s[o-2])||i.ifLeftSideIncludesThisCropItToo.includes(s[o-2]))||s[o-1]&&i.ifLeftSideIncludesThisCropItToo.includes(s[o-1])||i.wipeAllWhitespaceOnLeft&&r(s[o-1])))for(let e=o;e--;)if(!i.ifLeftSideIncludesThisCropItToo.includes(s[e])){if(s[e].trim()){o=i.wipeAllWhitespaceOnLeft||i.ifLeftSideIncludesThisCropItToo.includes(s[e+1])?e+1:e+2;break}if(0===e){o=i.wipeAllWhitespaceOnLeft?0:1;break}}if("left"!==i.extendToOneSide&&(r(s[a])&&(i.wipeAllWhitespaceOnRight||r(s[a+1]))||i.ifRightSideIncludesThisCropItToo.includes(s[a])))for(let e=a,t=s.length;e<t;e++)if(!i.ifRightSideIncludesThisCropItToo.includes(s[e])&&(s[e]&&s[e].trim()||void 0===s[e])){a=i.wipeAllWhitespaceOnRight||i.ifRightSideIncludesThisCropItToo.includes(s[e-1])?e:e-1;break}return("right"!==i.extendToOneSide&&n(i.ifLeftSideIncludesThisThenCropTightly)&&i.ifLeftSideIncludesThisThenCropTightly&&(s[o-2]&&i.ifLeftSideIncludesThisThenCropTightly.includes(s[o-2])||s[o-1]&&i.ifLeftSideIncludesThisThenCropTightly.includes(s[o-1]))||"left"!==i.extendToOneSide&&n(i.ifRightSideIncludesThisThenCropTightly)&&i.ifRightSideIncludesThisThenCropTightly&&(s[a+1]&&i.ifRightSideIncludesThisThenCropTightly.includes(s[a+1])||s[a]&&i.ifRightSideIncludesThisThenCropTightly.includes(s[a])))&&("right"!==i.extendToOneSide&&r(s[o-1])&&!i.wipeAllWhitespaceOnLeft&&(o-=1),"left"!==i.extendToOneSide&&r(s[a])&&!i.wipeAllWhitespaceOnRight&&(a+=1)),i.addSingleSpaceToPreventAccidentalConcatenation&&s[o-1]&&s[o-1].trim()&&s[a]&&s[a].trim()&&(!i.ifLeftSideIncludesThisThenCropTightly&&!i.ifRightSideIncludesThisThenCropTightly||i.ifLeftSideIncludesThisThenCropTightly&&!i.ifLeftSideIncludesThisThenCropTightly.includes(s[o-1])||!(!i.ifRightSideIncludesThisThenCropTightly||s[a]&&i.ifRightSideIncludesThisThenCropTightly.includes(s[a])))&&(t.test(s[o-1])||t.test(s[a]))?[o,a," "]:[o,a]}var _="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};Function.prototype.toString.call(Object);var v={exports:{}};!function(e,t){var r="__lodash_hash_undefined__",n=9007199254740991,i="[object Arguments]",s="[object Boolean]",o="[object Date]",a="[object Function]",l="[object GeneratorFunction]",u="[object Map]",h="[object Number]",f="[object Object]",c="[object Promise]",g="[object RegExp]",p="[object Set]",d="[object String]",m="[object Symbol]",y="[object WeakMap]",T="[object ArrayBuffer]",b="[object DataView]",w="[object Float32Array]",v="[object Float64Array]",O="[object Int8Array]",I="[object Int16Array]",L="[object Int32Array]",S="[object Uint8Array]",A="[object Uint8ClampedArray]",C="[object Uint16Array]",$="[object Uint32Array]",M=/\w*$/,R=/^\[object .+?Constructor\]$/,x=/^(?:0|[1-9]\d*)$/,j={};j[i]=j["[object Array]"]=j[T]=j[b]=j[s]=j[o]=j[w]=j[v]=j[O]=j[I]=j[L]=j[u]=j[h]=j[f]=j[g]=j[p]=j[d]=j[m]=j[S]=j[A]=j[C]=j[$]=!0,j["[object Error]"]=j[a]=j[y]=!1;var W="object"==typeof self&&self&&self.Object===Object&&self,E="object"==typeof _&&_&&_.Object===Object&&_||W||Function("return this")(),N=t&&!t.nodeType&&t,k=N&&e&&!e.nodeType&&e,B=k&&k.exports===N;function F(e,t){return e.set(t[0],t[1]),e}function H(e,t){return e.add(t),e}function D(e,t,r,n){var i=-1,s=e?e.length:0;for(n&&s&&(r=e[++i]);++i<s;)r=t(r,e[i],i,e);return r}function J(e){var t=!1;if(null!=e&&"function"!=typeof e.toString)try{t=!!(e+"")}catch(e){}return t}function P(e){var t=-1,r=Array(e.size);return e.forEach((function(e,n){r[++t]=[n,e]})),r}function q(e,t){return function(r){return e(t(r))}}function U(e){var t=-1,r=Array(e.size);return e.forEach((function(e){r[++t]=e})),r}var z,V=Array.prototype,G=Function.prototype,Y=Object.prototype,Z=E["__core-js_shared__"],K=(z=/[^.]+$/.exec(Z&&Z.keys&&Z.keys.IE_PROTO||""))?"Symbol(src)_1."+z:"",Q=G.toString,X=Y.hasOwnProperty,ee=Y.toString,te=RegExp("^"+Q.call(X).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),re=B?E.Buffer:void 0,ne=E.Symbol,ie=E.Uint8Array,se=q(Object.getPrototypeOf,Object),oe=Object.create,ae=Y.propertyIsEnumerable,le=V.splice,ue=Object.getOwnPropertySymbols,he=re?re.isBuffer:void 0,fe=q(Object.keys,Object),ce=ke(E,"DataView"),ge=ke(E,"Map"),pe=ke(E,"Promise"),de=ke(E,"Set"),me=ke(E,"WeakMap"),ye=ke(Object,"create"),Te=Je(ce),be=Je(ge),we=Je(pe),_e=Je(de),ve=Je(me),Oe=ne?ne.prototype:void 0,Ie=Oe?Oe.valueOf:void 0;function Le(e){var t=-1,r=e?e.length:0;for(this.clear();++t<r;){var n=e[t];this.set(n[0],n[1])}}function Se(e){var t=-1,r=e?e.length:0;for(this.clear();++t<r;){var n=e[t];this.set(n[0],n[1])}}function Ae(e){var t=-1,r=e?e.length:0;for(this.clear();++t<r;){var n=e[t];this.set(n[0],n[1])}}function Ce(e){this.__data__=new Se(e)}function $e(e,t){var r=qe(e)||function(e){return function(e){return function(e){return!!e&&"object"==typeof e}(e)&&Ue(e)}(e)&&X.call(e,"callee")&&(!ae.call(e,"callee")||ee.call(e)==i)}(e)?function(e,t){for(var r=-1,n=Array(e);++r<e;)n[r]=t(r);return n}(e.length,String):[],n=r.length,s=!!n;for(var o in e)!t&&!X.call(e,o)||s&&("length"==o||He(o,n))||r.push(o);return r}function Me(e,t,r){var n=e[t];X.call(e,t)&&Pe(n,r)&&(void 0!==r||t in e)||(e[t]=r)}function Re(e,t){for(var r=e.length;r--;)if(Pe(e[r][0],t))return r;return-1}function xe(e,t,r,n,c,y,_){var R;if(n&&(R=y?n(e,c,y,_):n(e)),void 0!==R)return R;if(!Ge(e))return e;var x=qe(e);if(x){if(R=function(e){var t=e.length,r=e.constructor(t);t&&"string"==typeof e[0]&&X.call(e,"index")&&(r.index=e.index,r.input=e.input);return r}(e),!t)return function(e,t){var r=-1,n=e.length;t||(t=Array(n));for(;++r<n;)t[r]=e[r];return t}(e,R)}else{var W=Fe(e),E=W==a||W==l;if(ze(e))return function(e,t){if(t)return e.slice();var r=new e.constructor(e.length);return e.copy(r),r}(e,t);if(W==f||W==i||E&&!y){if(J(e))return y?e:{};if(R=function(e){return"function"!=typeof e.constructor||De(e)?{}:(t=se(e),Ge(t)?oe(t):{});var t}(E?{}:e),!t)return function(e,t){return Ee(e,Be(e),t)}(e,function(e,t){return e&&Ee(t,Ye(t),e)}(R,e))}else{if(!j[W])return y?e:{};R=function(e,t,r,n){var i=e.constructor;switch(t){case T:return We(e);case s:case o:return new i(+e);case b:return function(e,t){var r=t?We(e.buffer):e.buffer;return new e.constructor(r,e.byteOffset,e.byteLength)}(e,n);case w:case v:case O:case I:case L:case S:case A:case C:case $:return function(e,t){var r=t?We(e.buffer):e.buffer;return new e.constructor(r,e.byteOffset,e.length)}(e,n);case u:return function(e,t,r){return D(t?r(P(e),!0):P(e),F,new e.constructor)}(e,n,r);case h:case d:return new i(e);case g:return function(e){var t=new e.constructor(e.source,M.exec(e));return t.lastIndex=e.lastIndex,t}(e);case p:return function(e,t,r){return D(t?r(U(e),!0):U(e),H,new e.constructor)}(e,n,r);case m:return a=e,Ie?Object(Ie.call(a)):{}}var a}(e,W,xe,t)}}_||(_=new Ce);var N=_.get(e);if(N)return N;if(_.set(e,R),!x)var k=r?function(e){return function(e,t,r){var n=t(e);return qe(e)?n:function(e,t){for(var r=-1,n=t.length,i=e.length;++r<n;)e[i+r]=t[r];return e}(n,r(e))}(e,Ye,Be)}(e):Ye(e);return function(e,t){for(var r=-1,n=e?e.length:0;++r<n&&!1!==t(e[r],r,e););}(k||e,(function(i,s){k&&(i=e[s=i]),Me(R,s,xe(i,t,r,n,s,e,_))})),R}function je(e){return!(!Ge(e)||(t=e,K&&K in t))&&(Ve(e)||J(e)?te:R).test(Je(e));var t}function We(e){var t=new e.constructor(e.byteLength);return new ie(t).set(new ie(e)),t}function Ee(e,t,r,n){r||(r={});for(var i=-1,s=t.length;++i<s;){var o=t[i],a=n?n(r[o],e[o],o,r,e):void 0;Me(r,o,void 0===a?e[o]:a)}return r}function Ne(e,t){var r,n,i=e.__data__;return("string"==(n=typeof(r=t))||"number"==n||"symbol"==n||"boolean"==n?"__proto__"!==r:null===r)?i["string"==typeof t?"string":"hash"]:i.map}function ke(e,t){var r=function(e,t){return null==e?void 0:e[t]}(e,t);return je(r)?r:void 0}Le.prototype.clear=function(){this.__data__=ye?ye(null):{}},Le.prototype.delete=function(e){return this.has(e)&&delete this.__data__[e]},Le.prototype.get=function(e){var t=this.__data__;if(ye){var n=t[e];return n===r?void 0:n}return X.call(t,e)?t[e]:void 0},Le.prototype.has=function(e){var t=this.__data__;return ye?void 0!==t[e]:X.call(t,e)},Le.prototype.set=function(e,t){return this.__data__[e]=ye&&void 0===t?r:t,this},Se.prototype.clear=function(){this.__data__=[]},Se.prototype.delete=function(e){var t=this.__data__,r=Re(t,e);return!(r<0)&&(r==t.length-1?t.pop():le.call(t,r,1),!0)},Se.prototype.get=function(e){var t=this.__data__,r=Re(t,e);return r<0?void 0:t[r][1]},Se.prototype.has=function(e){return Re(this.__data__,e)>-1},Se.prototype.set=function(e,t){var r=this.__data__,n=Re(r,e);return n<0?r.push([e,t]):r[n][1]=t,this},Ae.prototype.clear=function(){this.__data__={hash:new Le,map:new(ge||Se),string:new Le}},Ae.prototype.delete=function(e){return Ne(this,e).delete(e)},Ae.prototype.get=function(e){return Ne(this,e).get(e)},Ae.prototype.has=function(e){return Ne(this,e).has(e)},Ae.prototype.set=function(e,t){return Ne(this,e).set(e,t),this},Ce.prototype.clear=function(){this.__data__=new Se},Ce.prototype.delete=function(e){return this.__data__.delete(e)},Ce.prototype.get=function(e){return this.__data__.get(e)},Ce.prototype.has=function(e){return this.__data__.has(e)},Ce.prototype.set=function(e,t){var r=this.__data__;if(r instanceof Se){var n=r.__data__;if(!ge||n.length<199)return n.push([e,t]),this;r=this.__data__=new Ae(n)}return r.set(e,t),this};var Be=ue?q(ue,Object):function(){return[]},Fe=function(e){return ee.call(e)};function He(e,t){return!!(t=null==t?n:t)&&("number"==typeof e||x.test(e))&&e>-1&&e%1==0&&e<t}function De(e){var t=e&&e.constructor;return e===("function"==typeof t&&t.prototype||Y)}function Je(e){if(null!=e){try{return Q.call(e)}catch(e){}try{return e+""}catch(e){}}return""}function Pe(e,t){return e===t||e!=e&&t!=t}(ce&&Fe(new ce(new ArrayBuffer(1)))!=b||ge&&Fe(new ge)!=u||pe&&Fe(pe.resolve())!=c||de&&Fe(new de)!=p||me&&Fe(new me)!=y)&&(Fe=function(e){var t=ee.call(e),r=t==f?e.constructor:void 0,n=r?Je(r):void 0;if(n)switch(n){case Te:return b;case be:return u;case we:return c;case _e:return p;case ve:return y}return t});var qe=Array.isArray;function Ue(e){return null!=e&&function(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=n}(e.length)&&!Ve(e)}var ze=he||function(){return!1};function Ve(e){var t=Ge(e)?ee.call(e):"";return t==a||t==l}function Ge(e){var t=typeof e;return!!e&&("object"==t||"function"==t)}function Ye(e){return Ue(e)?$e(e):function(e){if(!De(e))return fe(e);var t=[];for(var r in Object(e))X.call(e,r)&&"constructor"!=r&&t.push(r);return t}(e)}e.exports=function(e){return xe(e,!0,!0)}}(v,v.exports);
/**
 * @name string-left-right
 * @fileoverview Looks up the first non-whitespace character to the left/right of a given index
 * @version 4.1.0
 * @author Roy Revelt, Codsen Ltd
 * @license MIT
 * {@link https://codsen.com/os/string-left-right/}
 */
const O=" ";function I(e,t=0){return function({str:e,idx:t=0,stopAtNewlines:r=!1,stopAtRawNbsp:n=!1}){if("string"!=typeof e||!e.length)return null;if(t&&"number"==typeof t||(t=0),!e[t+1])return null;if(e[t+1]&&(e[t+1].trim()||r&&"\n\r".includes(e[t+1])||n&&e[t+1]===O))return t+1;if(e[t+2]&&(e[t+2].trim()||r&&"\n\r".includes(e[t+2])||n&&e[t+2]===O))return t+2;for(let i=t+1,s=e.length;i<s;i++)if(e[i].trim()||r&&"\n\r".includes(e[i])||n&&e[i]===O)return i;return null}({str:e,idx:t,stopAtNewlines:!1,stopAtRawNbsp:!1})}function L(e,t=0){return function({str:e,idx:t,stopAtNewlines:r,stopAtRawNbsp:n}){if("string"!=typeof e||!e.length)return null;if(t&&"number"==typeof t||(t=0),t<1)return null;if(e[~-t]&&(e[~-t].trim()||r&&"\n\r".includes(e[~-t])||n&&e[~-t]===O))return~-t;if(e[t-2]&&(e[t-2].trim()||r&&"\n\r".includes(e[t-2])||n&&e[t-2]===O))return t-2;for(let i=t;i--;)if(e[i]&&(e[i].trim()||r&&"\n\r".includes(e[i])||n&&e[i]===O))return i;return null}({str:e,idx:t,stopAtNewlines:!1,stopAtRawNbsp:!1})}const S=new class{constructor(e){const t={...u,...e};if(t.mergeType&&1!==t.mergeType&&2!==t.mergeType)if(l(t.mergeType)&&"1"===t.mergeType.trim())t.mergeType=1;else{if(!l(t.mergeType)||"2"!==t.mergeType.trim())throw new Error(`ranges-push: [THROW_ID_02] opts.mergeType was customised to a wrong thing! It was given of a type: "${typeof t.mergeType}", equal to ${JSON.stringify(t.mergeType,null,4)}`);t.mergeType=2}this.opts=t,this.ranges=[]}add(e,t,r){if(null==e&&null==t)return;if(o(e)&&!o(t)){if(Array.isArray(e)){if(e.length){if(e.some((e=>Array.isArray(e))))return void e.forEach((e=>{Array.isArray(e)&&this.add(...e)}));e.length&&a(+e[0])&&a(+e[1])&&this.add(...e)}return}throw new TypeError(`ranges-push/Ranges/add(): [THROW_ID_12] the first input argument, "from" is set (${JSON.stringify(e,null,0)}) but second-one, "to" is not (${JSON.stringify(t,null,0)})`)}if(!o(e)&&o(t))throw new TypeError(`ranges-push/Ranges/add(): [THROW_ID_13] the second input argument, "to" is set (${JSON.stringify(t,null,0)}) but first-one, "from" is not (${JSON.stringify(e,null,0)})`);const n=+e,i=+t;if(a(r)&&(r=String(r)),!a(n)||!a(i))throw a(n)&&n>=0?new TypeError(`ranges-push/Ranges/add(): [THROW_ID_10] "to" value, the second input argument, must be a natural number or zero! Currently it's of a type "${typeof i}" equal to: ${JSON.stringify(i,null,4)}`):new TypeError(`ranges-push/Ranges/add(): [THROW_ID_09] "from" value, the first input argument, must be a natural number or zero! Currently it's of a type "${typeof n}" equal to: ${JSON.stringify(n,null,4)}`);if(o(r)&&!l(r)&&!a(r))throw new TypeError(`ranges-push/Ranges/add(): [THROW_ID_08] The third argument, the value to add, was given not as string but ${typeof r}, equal to:\n${JSON.stringify(r,null,4)}`);if(o(this.ranges)&&Array.isArray(this.last())&&n===this.last()[1]){if(this.last()[1]=i,this.last(),null!==this.last()[2]&&o(r)){let e=!(this.last()[2]&&this.last()[2].length>0)||this.opts&&this.opts.mergeType&&1!==this.opts.mergeType?r:this.last()[2]+r;this.opts.limitToBeAddedWhitespace&&(e=s(e,this.opts.limitLinebreaksCount)),l(e)&&!e.length||(this.last()[2]=e)}}else{this.ranges||(this.ranges=[]);const e=void 0===r||l(r)&&!r.length?[n,i]:[n,i,r&&this.opts.limitToBeAddedWhitespace?s(r,this.opts.limitLinebreaksCount):r];this.ranges.push(e)}}push(e,t,r){this.add(e,t,r)}current(){return Array.isArray(this.ranges)&&this.ranges.length?(this.ranges=i(this.ranges,{mergeType:this.opts.mergeType}),this.ranges&&this.opts.limitToBeAddedWhitespace?this.ranges.map((e=>o(e[2])?[e[0],e[1],s(e[2],this.opts.limitLinebreaksCount)]:e)):this.ranges):null}wipe(){this.ranges=[]}replace(e){if(Array.isArray(e)&&e.length){if(!Array.isArray(e[0])||!a(e[0][0]))throw new Error(`ranges-push/Ranges/replace(): [THROW_ID_11] Single range was given but we expected array of arrays! The first element, ${JSON.stringify(e[0],null,4)} should be an array and its first element should be an integer, a string index.`);this.ranges=Array.from(e)}else this.ranges=[]}last(){return Array.isArray(this.ranges)&&this.ranges.length?this.ranges[this.ranges.length-1]:null}}({limitToBeAddedWhitespace:!0}),A={lineLengthLimit:500,removeIndentations:!0,removeLineBreaks:!1,removeHTMLComments:!1,removeCSSComments:!0,reportProgressFunc:null,reportProgressFuncFrom:0,reportProgressFuncTo:100,breakToTheLeftOf:["</td","<html","</html","<head","</head","<meta","<link","<table","<script","</script","<!DOCTYPE","<style","</style","<title","<body","@media","</body","\x3c!--[if","\x3c!--<![endif","<![endif]"],mindTheInlineTags:["a","abbr","acronym","audio","b","bdi","bdo","big","br","button","canvas","cite","code","data","datalist","del","dfn","em","embed","i","iframe","img","input","ins","kbd","label","map","mark","meter","noscript","object","output","picture","progress","q","ruby","s","samp","script","select","slot","small","span","strong","sub","sup","svg","template","textarea","time","u","tt","var","video","wbr"]},C={removeHTMLComments:!1,removeCSSComments:!1};function $(e){return"string"==typeof e}function M(e){return"string"==typeof e&&e.toUpperCase()!==e.toLowerCase()}e.crush=function(e,t){const r=Date.now();if(!$(e))throw void 0===e?new Error("html-crush: [THROW_ID_01] the first input argument is completely missing! It should be given as string."):new Error(`html-crush: [THROW_ID_02] the first input argument must be string! It was given as "${typeof e}", equal to:\n${JSON.stringify(e,null,4)}`);if(t&&"object"!=typeof t)throw new Error(`html-crush: [THROW_ID_03] the second input argument, options object, should be a plain object but it was given as type ${typeof t}, equal to ${JSON.stringify(t,null,4)}`);if(t&&Array.isArray(t.breakToTheLeftOf)&&t.breakToTheLeftOf.length)for(let e=0,r=t.breakToTheLeftOf.length;e<r;e++)if(!$(t.breakToTheLeftOf[e]))throw new TypeError(`html-crush: [THROW_ID_05] the opts.breakToTheLeftOf array contains non-string elements! For example, element at index ${e} is of a type "${typeof t.breakToTheLeftOf[e]}" and is equal to:\n${JSON.stringify(t.breakToTheLeftOf[e],null,4)}`);const n={...A,...t};"boolean"==typeof n.removeHTMLComments&&(n.removeHTMLComments=n.removeHTMLComments?1:0);let s="";Array.isArray(n.breakToTheLeftOf)&&n.breakToTheLeftOf.length&&(s=[...new Set(n.breakToTheLeftOf.map((e=>e[0])))].join(""));let o,a=null,l=null,u=!1,h=0,f=0,c=!1,g=!1,p=null,d=null,b=null,_=null,v=null,O=null,R=null,x=null,j=null,W=null;const E=">};",N="<",k="!",B=">",F="<",H="{},:;<>~+",D=H,J=H;let P=!0;const q=e.length,U=Math.floor(q/2);let z,V;n.reportProgressFunc&&(z=Math.floor(n.reportProgressFuncTo-.01*(n.reportProgressFuncTo-n.reportProgressFuncFrom)-n.reportProgressFuncFrom));let G=0,Y="\n";if(e.includes("\r\n")?Y="\r\n":e.includes("\r")&&(Y="\r"),q){for(let t=0;t<q;t++)if(n.reportProgressFunc&&(q>1e3&&q<2e3?t===U&&n.reportProgressFunc(Math.floor((n.reportProgressFuncTo-n.reportProgressFuncFrom)/2)):q>=2e3&&(V=n.reportProgressFuncFrom+Math.floor(t/q*(z||1)),V!==G&&(G=V,n.reportProgressFunc(V)))),f++,o&&"number"==typeof o&&t>=o&&(o=void 0),null===_||!e.startsWith("</script",t)||M(e[t+8])){if(!o&&!c&&e.startsWith("<script",t)&&!M(e[t+7])){_=t,o=!0;let e="";(n.removeLineBreaks||n.removeIndentations)&&null!==l&&(l>0&&(e=Y),S.push(l,t,e)),l=null,a=null}if(null!==j&&null===x&&!/\w/.test(e[t])){x=e.slice(j,t);const r=I(e,~-t);"number"==typeof r&&">"===e[r]&&!e[t].trim()&&I(e,t)?S.push(t,I(e,t)):r&&"/"===e[r]&&">"===e[I(e,r)]&&(!e[t].trim()&&I(e,t)&&S.push(t,I(e,t)),">"!==e[r+1]&&I(e,r+1)&&S.push(r+1,I(e,r+1)))}if(o||c||p||"<"!==e[~-t]||null!==j||(/\w/.test(e[t])?j=t:"/"===e[I(e,~-t)]&&/\w/.test(e[I(e,I(e,~-t))]||"")&&(j=I(e,I(e,~-t)))),o||!c&&!p||null===d||"*"!==e[t]||"/"!==e[t+1]||([v,O]=w({str:e,from:d,to:t+2,ifLeftSideIncludesThisThenCropTightly:D,ifRightSideIncludesThisThenCropTightly:J}),d=null,null!=v?S.push(v,O):(h+=1,t+=1),o=t+2),o||!c&&!p||null!==d||"/"!==e[t]||"*"!==e[t+1]||(C.removeCSSComments||(C.removeCSSComments=!0),n.removeCSSComments&&(d=t)),g&&e.startsWith("![endif",t+1)&&(g=!1),!o&&!c&&!p&&null!==b){let r;e.startsWith("--\x3e",t)?r=3:">"===e[t]&&"]"===e[t-1]&&(r=1),r&&([v,O]=w({str:e,from:b,to:t+r}),b=null,null!=v?n.lineLengthLimit&&f-(O-v)>=n.lineLengthLimit?(S.push(v,O,Y),f=-r):(S.push(v,O),f-=O-v):(h+=r-1,t+=r-1),o=t+r)}if(o||c||p||!e.startsWith("\x3c!--",t)||null!==b||(e.startsWith("[if",t+4)?(g||(g=!0),2===n.removeHTMLComments&&(b=t)):!n.removeHTMLComments||g&&2!==n.removeHTMLComments||(b=t),C.removeHTMLComments||(C.removeHTMLComments=!0)),!o&&c&&null===d&&e.startsWith("</style",t)&&!M(e[t+7])?c=!1:o||c||null!==d||!e.startsWith("<style",t)||M(e[t+6])||(c=!0,(n.removeLineBreaks||n.removeIndentations)&&n.breakToTheLeftOf.includes("<style")&&e.startsWith(' type="text/css">',t+6)&&e[t+24]&&S.push(t+23,t+23,Y)),!o&&!p&&"\"'".includes(e[t])&&e.endsWith("style=",t)&&(p=t),o||e[t].trim()){if(!o&&(!c&&!p||null===d)){if(null!==l){if(n.removeLineBreaks&&(h+=1),P)P=!1,(n.removeIndentations||n.removeLineBreaks)&&S.push(0,t);else if(n.removeIndentations&&!n.removeLineBreaks&&(!u&&null!==a&&t>a?S.push(a+1,t):l+1<t&&(e.endsWith("]>",l)||e.endsWith("--\x3e",l)||e.startsWith("<![",t)||e.startsWith("\x3c!--<![",t)?S.push(l,t):" "===e[l]?S.push(l+1,t):" "===e[~-t]?S.push(l,~-t):S.push(l,t," "))),n.removeLineBreaks||p){if(s.includes(e[t])&&y(e,t,n.breakToTheLeftOf)){"\r\n".includes(e[~-t])&&l===~-t||"\n"===e[~-t]&&"\r"===e[t-2]&&l===t-2||S.push(l,t,Y),v=null,O=null,R=null,l=null,h=1;continue}let r=" ";"<"===e[t]&&T(e,t,n.mindTheInlineTags,{cb:e=>!e||!/\w/.test(e)})||(e[~-l]&&B.includes(e[~-l])&&F.includes(e[t])||(c||p)&&null===d&&(D.includes(e[~-l])||J.includes(e[t]))||e.startsWith("!important",t)&&!g||p&&("'"===e[~-l]||'"'===e[~-l])||"}"===e[~-l]&&e.startsWith("</style",t)||">"===e[t]&&("'\"".includes(e[L(e,t)])||"<"===e[I(e,t)])||"/"===e[t]&&">"===e[I(e,t)])&&(r="","/"===e[t]&&">"===e[t+1]&&I(e,t)&&I(e,t)>t+1&&(S.push(t+1,I(e,t)),h-=I(e,t)-t+1)),r&&r.length&&(h+=1),n.lineLengthLimit?h>=n.lineLengthLimit||!e[t+1]||">"===e[t]||"/"===e[t]&&">"===e[t+1]?((h>n.lineLengthLimit||h===n.lineLengthLimit&&e[t+1]&&e[t+1].trim()&&!E.includes(e[t])&&!N.includes(e[t+1]))&&(r=Y,h=1),(h>n.lineLengthLimit||" "!==r||t!==l+1)&&(S.push(l,t,r),a=null),v=null,O=null,R=null):(null===v||l<v)&&(v=l,O=t,R=r):t===l+1&&" "===r||S.push(l,t,r)}l=null,u||(u=!0)}else P&&(P=!1),n.removeLineBreaks&&(h+=1);u||(u=!0)}}else null===l&&(l=t);if(!o&&!P&&0!==t&&n.removeLineBreaks&&(n.lineLengthLimit||s)&&!e.startsWith("</a",t)){if(s&&y(e,t,n.breakToTheLeftOf)&&e.slice(0,t).trim()&&(!e.startsWith("<![endif]",t)||!m(e,t,"\x3c!--"))){S.push(t,t,Y),v=null,O=null,R=null,h=1;continue}if(n.lineLengthLimit&&h<=n.lineLengthLimit){if(!e[t+1]||N.includes(e[t])&&!k.includes(e[t])||E.includes(e[t])||!e[t].trim()){if(null!==v&&null!==O&&(v!==O||R&&R.length)){let r=R;e[t].trim()&&e[t+1]&&e[t+1].trim()&&h+(R?R.length:0)>n.lineLengthLimit&&(r=Y),h+(r?r.length:0)>n.lineLengthLimit||" "!==r||O!==v+1||" "!==e[v]?"}"===e[~-v]&&"{"===e[O]||(S.push(v,O,r),a=null):h-=a||0}!(e[t].trim()&&(N.includes(e[t])||e[~-t]&&E.includes(e[~-t]))&&$(W))||x&&n.mindTheInlineTags.includes(x)||"<"===e[t]&&T(e,t,n.mindTheInlineTags,{cb:e=>!e||!/\w/.test(e)})||"<"===e[t]&&T(e,t,n.mindTheInlineTags,{trimCharsBeforeMatching:"/",cb:e=>!e||!/\w/.test(e)})?null!==d||null===v||!(p||!n.mindTheInlineTags||!Array.isArray(n.mindTheInlineTags)||Array.isArray(n.mindTheInlineTags.length)&&!n.mindTheInlineTags.length||!$(x)||Array.isArray(n.mindTheInlineTags)&&n.mindTheInlineTags.length&&$(x)&&!n.mindTheInlineTags.includes(x))||"<"===e[t]&&T(e,t,n.mindTheInlineTags,{trimCharsBeforeMatching:"/",cb:e=>!e||!/\w/.test(e)})||(v=null,O=null,R=null):(v=t,O=t,R=null)}}else if(n.lineLengthLimit)if(!N.includes(e[t])||"<"===e[t]&&T(e,t,n.mindTheInlineTags,{trimCharsBeforeMatching:"/",cb:e=>!e||!/\w/.test(e)}))e[t+1]&&E.includes(e[t])&&$(x)&&Array.isArray(n.mindTheInlineTags)&&n.mindTheInlineTags.length&&!n.mindTheInlineTags.includes(x)?null!==v&&null!==O&&(v!==O||R&&R.length)||(S.push(t+1,t+1,Y),h=0):e[t].trim()&&(e[t+1]||null!==v&&null!==O&&(v!==O||R&&R.length)&&S.push(v,O,Y));else if(null!==v&&null!==O&&(v!==O||R&&R.length)){const e=R&&R.length?R.length:0;h-(O-v-e)-1>n.lineLengthLimit||(S.push(v,O,R),h-(O-v-e)-1===n.lineLengthLimit&&(S.push(t,t,Y),h=0),v=null,O=null,R=null)}else S.push(t,t,Y),h=0}if(!o&&!P&&n.removeLineBreaks&&n.lineLengthLimit&&h>=n.lineLengthLimit&&null!==v&&null!==O&&!E.includes(e[t])&&!N.includes(e[t])&&!"/".includes(e[t])&&(h!==n.lineLengthLimit||!e[t+1]||e[t+1].trim())){let r=Y;e[t+1]&&!e[t+1].trim()&&h===n.lineLengthLimit&&(r=R),r===Y&&!e[~-v].trim()&&L(e,v)&&(v=L(e,v)+1),S.push(v,O,r),h=t-O,e[t].length&&(h+=1),v=null,O=null,R=null}if((!o&&"\n"===e[t]||"\r"===e[t]&&(!e[t+1]||e[t+1]&&"\n"!==e[t+1]))&&(a=t,u&&(u=!1),!n.removeLineBreaks&&null!==l&&l<t&&e[t+1]&&"\r"!==e[t+1]&&"\n"!==e[t+1]&&S.push(l,t)),e[t+1]||(c&&null!==d?S.push(...w({str:e,from:d,to:t,ifLeftSideIncludesThisThenCropTightly:D,ifRightSideIncludesThisThenCropTightly:J})):l&&"\n"!==e[t]&&"\r"!==e[t]?S.push(l,t+1):l&&("\r"===e[t]&&"\n"===e[t+1]||"\n"===e[t]&&"\r"!==e[t-1])&&S.push(l,t)),!o&&p&&p<t&&e[p]===e[t]&&(p=null),!o&&!c&&e.startsWith("<pre",t)&&!M(e[t+4])){const r=e.indexOf("</pre",t+5);r>0&&(o=r)}if(!o&&!c&&e.startsWith("<code",t)&&!M(e[t+5])){const r=e.indexOf("</code",t+5);r>0&&(o=r)}if(!o&&e.startsWith("<![CDATA[",t)){const r=e.indexOf("]]>",t+9);r>0&&(o=r)}o||c||p||null===j||">"!==e[t]||("<"===e[I(e,t)]&&(W=x),j=null,x=null),"<"===e[t]&&null!==W&&(W=null)}else{if((n.removeIndentations||n.removeLineBreaks)&&t>0&&e[~-t]&&!e[~-t].trim())for(let r=t;r--;)if("\n"===e[r]||"\r"===e[r]||e[r].trim()){r+1<t&&S.push(r+1,t);break}_=null,o=!1,t+=8}if(S.current()){const t=S.current();S.wipe();const s=n.reportProgressFuncTo-.01*(n.reportProgressFuncTo-n.reportProgressFuncFrom),o=function(e,t,r){let n,s=0,o=0;if(0===arguments.length)throw new Error("ranges-apply: [THROW_ID_01] inputs missing!");if("string"!=typeof e)throw new TypeError(`ranges-apply: [THROW_ID_02] first input argument must be a string! Currently it's: ${typeof e}, equal to: ${JSON.stringify(e,null,4)}`);if(t&&!Array.isArray(t))throw new TypeError(`ranges-apply: [THROW_ID_03] second input argument must be an array (or null)! Currently it's: ${typeof t}, equal to: ${JSON.stringify(t,null,4)}`);if(r&&"function"!=typeof r)throw new TypeError(`ranges-apply: [THROW_ID_04] the third input argument must be a function (or falsey)! Currently it's: ${typeof r}, equal to: ${JSON.stringify(r,null,4)}`);if(!t||!t.filter((e=>e)).length)return e;n=Array.isArray(t)&&Number.isInteger(t[0])&&Number.isInteger(t[1])?[Array.from(t)]:Array.from(t);const a=n.length;let l=0;n.filter((e=>e)).forEach(((e,t)=>{if(r&&(s=Math.floor(l/a*10),s!==o&&(o=s,r(s))),!Array.isArray(e))throw new TypeError(`ranges-apply: [THROW_ID_05] ranges array, second input arg., has ${t}th element not an array: ${JSON.stringify(e,null,4)}, which is ${typeof e}`);if(!Number.isInteger(e[0])){if(!Number.isInteger(+e[0])||+e[0]<0)throw new TypeError(`ranges-apply: [THROW_ID_06] ranges array, second input arg. has ${t}th element, array ${JSON.stringify(e,null,0)}. Its first element is not an integer, string index, but ${typeof e[0]}, equal to: ${JSON.stringify(e[0],null,4)}.`);n[t][0]=+n[t][0]}if(!Number.isInteger(e[1])){if(!Number.isInteger(+e[1])||+e[1]<0)throw new TypeError(`ranges-apply: [THROW_ID_07] ranges array, second input arg. has ${t}th element, array ${JSON.stringify(e,null,0)}. Its second element is not an integer, string index, but ${typeof e[1]}, equal to: ${JSON.stringify(e[1],null,4)}.`);n[t][1]=+n[t][1]}l+=1}));const u=i(n,{progressFn:e=>{r&&(s=10+Math.floor(e/10),s!==o&&(o=s,r(s)))}}),h=Array.isArray(u)?u.length:0;if(h>0){const t=e.slice(u[h-1][1]);e=u.reduce(((t,n,i,a)=>(r&&(s=20+Math.floor(i/h*80),s!==o&&(o=s,r(s))),t+e.slice(0===i?0:a[i-1][1],a[i][0])+(a[i][2]||""))),""),e+=t}return e}(e,t,(e=>{n.reportProgressFunc&&q>=2e3&&(V=Math.floor(s+e/100*(n.reportProgressFuncTo-s)),V!==G&&(G=V,n.reportProgressFunc(V)))})),a=o.length;return{log:{timeTakenInMilliseconds:Date.now()-r,originalLength:q,cleanedLength:a,bytesSaved:Math.max(q-a,0),percentageReducedOfOriginal:q?Math.round(100*Math.max(q-a,0)/q):0},ranges:t,applicableOpts:C,result:o}}}return{log:{timeTakenInMilliseconds:Date.now()-r,originalLength:q,cleanedLength:q,bytesSaved:0,percentageReducedOfOriginal:0},applicableOpts:C,ranges:null,result:e}},e.defaults=A,e.version="4.2.0",Object.defineProperty(e,"__esModule",{value:!0})}));
