import { MutableRefObject } from "react";
import { FieldInstance } from "./types";
import { FieldArrayInstance } from "../field-array";
export type InternalValue<T> = {
    __value: T;
    __isResetting: boolean;
};
export declare const isInternal: <T>(value: any) => value is InternalValue<T>;
interface UseListenToListenToArrayProps<T> {
    listenTo: string[] | undefined;
    runFieldValidation: (l: "onChangeValidate" | "onBlurValidate" | "onMountValidate", v: T) => void;
    valueRef: MutableRefObject<T>;
}
export declare function useListenToListenToArray<T>({ listenTo, runFieldValidation, valueRef, }: UseListenToListenToArrayProps<T>): void;
type GetInstanceInferedType<T, TT> = TT extends FieldInstance ? T : T[];
export interface UseFieldLikeProps<T, F, TT extends FieldInstance<T, F> | FieldArrayInstance<T, F>> {
    props: TT["props"] & {
        initialValue?: GetInstanceInferedType<T, TT>;
    };
    initialValue: GetInstanceInferedType<T, TT>;
}
/**
 * A "field-like" is anything that contains a value,
 * errors, and needs to be set to the closest form
 */
export declare const useFieldLike: <T, F, TT extends FieldInstance<T, F> | FieldArrayInstance<T, F>>({ initialValue, props, }: UseFieldLikeProps<T, F, TT>) => {
    value: GetInstanceInferedType<T, TT>;
    setErrors: import("react").Dispatch<import("react").SetStateAction<string[]>>;
    errors: string[];
    hints: string[];
    setHints: import("react").Dispatch<import("react").SetStateAction<string[]>>;
    setIsDirty: import("react").Dispatch<import("react").SetStateAction<boolean>>;
    setIsTouched: import("react").Dispatch<import("react").SetStateAction<boolean>>;
    setValue: <J extends GetInstanceInferedType<T, TT> = GetInstanceInferedType<T, TT>>(val: J | ((prevState: J) => J)) => void;
    isTouched: boolean;
    isDirty: boolean;
    isValid: boolean;
    isValidating: boolean;
    isSubmitted: boolean;
    runFieldValidation: (validationFnName: "onChangeValidate" | "onBlurValidate" | "onMountValidate", val: GetInstanceInferedType<T, TT>) => void;
    runFieldHintCheck: (validationFnName: "onChangeHint" | "onBlurHint" | "onMountHint", val: GetInstanceInferedType<T, TT>) => void;
    valueRef: MutableRefObject<GetInstanceInferedType<T, TT>>;
    validate: (validationFnName: "onChangeValidate" | "onBlurValidate" | "onMountValidate") => void;
    checkHint: (validationFnName: "onBlurHint" | "onMountHint" | "onChangeHint") => void;
    _normalizedDotName: string;
    _setIsValidating: import("react").Dispatch<import("react").SetStateAction<boolean>>;
};
export {};
