/* eslint-disable */
function createReactiveSystem({
  update,
  notify,
  unwatched
}) {
  let currentVersion = 0;
  return {
    link,
    unlink,
    propagate,
    checkDirty,
    endTracking,
    startTracking,
    shallowPropagate
  };
  function link(dep, sub) {
    const prevDep = sub._depsTail;
    if (prevDep !== undefined && prevDep.dep === dep) {
      return;
    }
    const nextDep = prevDep !== undefined ? prevDep.nextDep : sub._deps;
    if (nextDep !== undefined && nextDep.dep === dep) {
      nextDep.version = currentVersion;
      sub._depsTail = nextDep;
      return;
    }
    const prevSub = dep._subsTail;
    if (prevSub !== undefined && prevSub.version === currentVersion && prevSub.sub === sub) {
      return;
    }
    const newLink = sub._depsTail = dep._subsTail = {
      version: currentVersion,
      dep,
      sub,
      prevDep,
      nextDep,
      prevSub,
      nextSub: undefined
    };
    if (nextDep !== undefined) {
      nextDep.prevDep = newLink;
    }
    if (prevDep !== undefined) {
      prevDep.nextDep = newLink;
    } else {
      sub._deps = newLink;
    }
    if (prevSub !== undefined) {
      prevSub.nextSub = newLink;
    } else {
      dep._subs = newLink;
    }
  }
  function unlink(link, sub = link.sub) {
    const dep = link.dep;
    const prevDep = link.prevDep;
    const nextDep = link.nextDep;
    const nextSub = link.nextSub;
    const prevSub = link.prevSub;
    if (nextDep !== undefined) {
      nextDep.prevDep = prevDep;
    } else {
      sub._depsTail = prevDep;
    }
    if (prevDep !== undefined) {
      prevDep.nextDep = nextDep;
    } else {
      sub._deps = nextDep;
    }
    if (nextSub !== undefined) {
      nextSub.prevSub = prevSub;
    } else {
      dep._subsTail = prevSub;
    }
    if (prevSub !== undefined) {
      prevSub.nextSub = nextSub;
    } else if ((dep._subs = nextSub) === undefined) {
      unwatched(dep);
    }
    return nextDep;
  }
  function propagate(link) {
    let next = link.nextSub;
    let stack;
    top: do {
      const sub = link.sub;
      let flags = sub._flags;
      if (!(flags & 60)) {
        sub._flags = flags | 32;
      } else if (!(flags & 12)) {
        flags = 0;
      } else if (!(flags & 4)) {
        sub._flags = flags & ~8 | 32;
      } else if (!(flags & 48) && isValidLink(link, sub)) {
        sub._flags = flags | 40;
        flags &= 1;
      } else {
        flags = 0;
      }
      if (flags & 2) {
        notify(sub);
      }
      if (flags & 1) {
        const subSubs = sub._subs;
        if (subSubs !== undefined) {
          const nextSub = (link = subSubs).nextSub;
          if (nextSub !== undefined) {
            stack = {
              value: next,
              prev: stack
            };
            next = nextSub;
          }
          continue;
        }
      }
      if ((link = next) !== undefined) {
        next = link.nextSub;
        continue;
      }
      while (stack !== undefined) {
        link = stack.value;
        stack = stack.prev;
        if (link !== undefined) {
          next = link.nextSub;
          continue top;
        }
      }
      break;
    } while (true);
  }
  function startTracking(sub) {
    ++currentVersion;
    sub._depsTail = undefined;
    sub._flags = sub._flags & ~56 | 4;
  }
  function endTracking(sub) {
    const depsTail = sub._depsTail;
    let toRemove = depsTail !== undefined ? depsTail.nextDep : sub._deps;
    while (toRemove !== undefined) {
      toRemove = unlink(toRemove, sub);
    }
    sub._flags &= ~4;
  }
  function checkDirty(link, sub) {
    let stack;
    let checkDepth = 0;
    top: do {
      const dep = link.dep;
      const flags = dep._flags;
      let dirty = false;
      if (sub._flags & 16) {
        dirty = true;
      } else if ((flags & 17) === 17) {
        if (update(dep)) {
          const subs = dep._subs;
          if (subs.nextSub !== undefined) {
            shallowPropagate(subs);
          }
          dirty = true;
        }
      } else if ((flags & 33) === 33) {
        if (link.nextSub !== undefined || link.prevSub !== undefined) {
          stack = {
            value: link,
            prev: stack
          };
        }
        link = dep._deps;
        sub = dep;
        ++checkDepth;
        continue;
      }
      if (!dirty) {
        const nextDep = link.nextDep;
        if (nextDep !== undefined) {
          link = nextDep;
          continue;
        }
      }
      while (checkDepth--) {
        const firstSub = sub._subs;
        const hasMultipleSubs = firstSub.nextSub !== undefined;
        if (hasMultipleSubs) {
          link = stack.value;
          stack = stack.prev;
        } else {
          link = firstSub;
        }
        if (dirty) {
          if (update(sub)) {
            if (hasMultipleSubs) {
              shallowPropagate(firstSub);
            }
            sub = link.sub;
            continue;
          }
        } else {
          sub._flags &= ~32;
        }
        sub = link.sub;
        const nextDep = link.nextDep;
        if (nextDep !== undefined) {
          link = nextDep;
          continue top;
        }
        dirty = false;
      }
      return dirty;
    } while (true);
  }
  function shallowPropagate(link) {
    do {
      const sub = link.sub;
      const flags = sub._flags;
      if ((flags & 48) === 32) {
        sub._flags = flags | 16;
        if (flags & 2) {
          notify(sub);
        }
      }
    } while ((link = link.nextSub) !== undefined);
  }
  function isValidLink(checkLink, sub) {
    let link = sub._depsTail;
    while (link !== undefined) {
      if (link === checkLink) {
        return true;
      }
      link = link.prevDep;
    }
    return false;
  }
}

function toObserver(nextHandler, errorHandler, completionHandler) {
  const isObserver = typeof nextHandler === 'object';
  const self = isObserver ? nextHandler : undefined;
  return {
    next: (isObserver ? nextHandler.next : nextHandler)?.bind(self),
    error: (isObserver ? nextHandler.error : errorHandler)?.bind(self),
    complete: (isObserver ? nextHandler.complete : completionHandler)?.bind(self)
  };
}

const queuedEffects = [];
const {
  link,
  unlink,
  propagate,
  checkDirty,
  endTracking,
  startTracking,
  shallowPropagate
} = createReactiveSystem({
  update(atom) {
    return atom._update();
  },
  notify(effect) {
    queuedEffects[queuedEffectsLength++] = effect;
  },
  unwatched(atom) {
    let toRemove = atom._deps;
    if (toRemove !== undefined) {
      atom._flags = 17;
      do {
        toRemove = unlink(toRemove, atom);
      } while (toRemove !== undefined);
    }
  }
});
let notifyIndex = 0;
let queuedEffectsLength = 0;
let activeSub;
function flush() {
  while (notifyIndex < queuedEffectsLength) {
    const effect = queuedEffects[notifyIndex];
    queuedEffects[notifyIndex++] = undefined;
    effect.notify();
  }
  notifyIndex = 0;
  queuedEffectsLength = 0;
}
function createAsyncAtom(getValue, options) {
  const atom = createAtom(() => {
    getValue().then(data => {
      if (atom._update({
        status: 'done',
        data
      })) {
        const subs = atom._subs;
        if (subs !== undefined) {
          propagate(subs);
          shallowPropagate(subs);
          flush();
        }
      }
    }, error => {
      if (atom._update({
        status: 'error',
        error
      })) {
        const subs = atom._subs;
        if (subs !== undefined) {
          propagate(subs);
          shallowPropagate(subs);
          flush();
        }
      }
    });
    return {
      status: 'pending'
    };
  }, options);
  return atom;
}
function createAtom(valueOrFn, options) {
  const isComputed = typeof valueOrFn === 'function';
  const getter = valueOrFn;

  // Create plain object atom
  const atom = {
    _snapshot: isComputed ? undefined : valueOrFn,
    _subs: undefined,
    _subsTail: undefined,
    _flags: 0,
    get() {
      if (activeSub !== undefined) {
        link(atom, activeSub);
      }
      return atom._snapshot;
    },
    subscribe(observerOrFn) {
      const obs = toObserver(observerOrFn);
      const observed = {
        current: false
      };
      const e = effect(() => {
        atom.get();
        if (!observed.current) {
          observed.current = true;
        } else {
          obs.next?.(atom._snapshot);
        }
      });
      return {
        unsubscribe: () => {
          e.stop();
        }
      };
    },
    _update(getValue) {
      const prevSub = activeSub;
      const compare = options?.compare ?? Object.is;
      activeSub = atom;
      startTracking(atom);
      try {
        const oldValue = atom._snapshot;
        const read = atom => atom.get();
        const newValue = typeof getValue === 'function' ? getValue(oldValue) : getValue === undefined && isComputed ? getter(read, oldValue) : getValue;
        if (oldValue === undefined || !compare(oldValue, newValue)) {
          atom._snapshot = newValue;
          return true;
        }
        return false;
      } finally {
        activeSub = prevSub;
        endTracking(atom);
      }
    }
  };
  if (isComputed) {
    Object.assign(atom, {
      _deps: undefined,
      _depsTail: undefined,
      _flags: 17,
      get() {
        const flags = this._flags;
        if (flags & 16 || flags & 32 && checkDirty(atom._deps, atom)) {
          if (atom._update()) {
            const subs = atom._subs;
            if (subs !== undefined) {
              shallowPropagate(subs);
            }
          }
        } else if (flags & 32) {
          atom._flags = flags & ~32;
        }
        if (activeSub !== undefined) {
          link(atom, activeSub);
        }
        return atom._snapshot;
      }
    });
  } else {
    Object.assign(atom, {
      set(valueOrFn) {
        if (atom._update(valueOrFn)) {
          const subs = atom._subs;
          if (subs !== undefined) {
            propagate(subs);
            shallowPropagate(subs);
            flush();
          }
        }
      }
    });
  }
  return atom;
}
function effect(fn) {
  const run = () => {
    const prevSub = activeSub;
    activeSub = effectObj;
    startTracking(effectObj);
    try {
      return fn();
    } finally {
      activeSub = prevSub;
      endTracking(effectObj);
    }
  };
  const effectObj = {
    _deps: undefined,
    _depsTail: undefined,
    _flags: 2,
    notify() {
      const flags = this._flags;
      if (flags & 16 || flags & 32 && checkDirty(this._deps, this)) {
        run();
      } else if (flags & 32) {
        this._flags = flags & ~32;
      }
    },
    stop() {
      startTracking(this);
      endTracking(this);
    }
  };
  run();
  return effectObj;
}

const symbolObservable = (() => typeof Symbol === 'function' && Symbol.observable || '@@observable')();
const inspectionObservers = new WeakMap();
function createStoreCore(logic, emits) {
  let listeners;
  const initialSnapshot = logic.getInitialSnapshot();
  let currentSnapshot = initialSnapshot;
  const atom = createAtom(currentSnapshot);
  const emit = ev => {
    if (!listeners) {
      return;
    }
    const type = ev.type;
    const typeListeners = listeners.get(type);
    if (typeListeners) {
      typeListeners.forEach(listener => listener(ev));
    }
  };
  const transition = logic.transition;
  function receive(event) {
    const [nextSnapshot, effects] = transition(currentSnapshot, event);
    currentSnapshot = nextSnapshot;
    inspectionObservers.get(store)?.forEach(observer => {
      observer.next?.({
        type: '@xstate.snapshot',
        event,
        snapshot: nextSnapshot,
        actorRef: store,
        rootId: store.sessionId
      });
    });
    atom.set(nextSnapshot);
    for (const effect of effects) {
      if (typeof effect === 'function') {
        effect();
      } else {
        // handle the inherent effect first
        emits?.[effect.type]?.(effect);
        emit(effect);
      }
    }
  }
  const store = {
    get _snapshot() {
      return atom._snapshot;
    },
    on(emittedEventType, handler) {
      if (!listeners) {
        listeners = new Map();
      }
      let eventListeners = listeners.get(emittedEventType);
      if (!eventListeners) {
        eventListeners = new Set();
        listeners.set(emittedEventType, eventListeners);
      }
      const wrappedHandler = handler.bind(undefined);
      eventListeners.add(wrappedHandler);
      return {
        unsubscribe() {
          eventListeners.delete(wrappedHandler);
        }
      };
    },
    transition: logic.transition,
    // TODO: fix this
    sessionId: uniqueId(),
    send(event) {
      inspectionObservers.get(store)?.forEach(observer => {
        observer.next?.({
          type: '@xstate.event',
          event,
          sourceRef: undefined,
          actorRef: store,
          rootId: store.sessionId
        });
      });
      receive(event);
    },
    getSnapshot() {
      return currentSnapshot;
    },
    get() {
      return atom.get();
    },
    getInitialSnapshot() {
      return initialSnapshot;
    },
    subscribe: atom.subscribe.bind(atom),
    [symbolObservable]() {
      return this;
    },
    inspect: observerOrFn => {
      const observer = toObserver(observerOrFn);
      inspectionObservers.set(store, inspectionObservers.get(store) ?? new Set());
      inspectionObservers.get(store).add(observer);
      observer.next?.({
        type: '@xstate.actor',
        actorRef: store,
        rootId: store.sessionId
      });
      observer.next?.({
        type: '@xstate.snapshot',
        snapshot: initialSnapshot,
        event: {
          type: '@xstate.init'
        },
        actorRef: store,
        rootId: store.sessionId
      });
      return {
        unsubscribe() {
          return inspectionObservers.get(store)?.delete(observer);
        }
      };
    },
    trigger: new Proxy({}, {
      get: (_, eventType) => {
        return payload => {
          store.send({
            ...payload,
            type: eventType
          });
        };
      }
    }),
    select(selector, equalityFn = Object.is) {
      return createAtom(() => selector(store.get().context), {
        compare: equalityFn
      });
    }
  };
  return store;
}

/**
 * Creates a **store** that has its own internal state and can be sent events
 * that update its internal state based on transitions.
 *
 * @example
 *
 * ```ts
 * const store = createStore({
 *   context: { count: 0, name: 'Ada' },
 *   on: {
 *     inc: (context, event: { by: number }) => ({
 *       ...context,
 *       count: context.count + event.by
 *     })
 *   }
 * });
 *
 * store.subscribe((snapshot) => {
 *   console.log(snapshot);
 * });
 *
 * store.send({ type: 'inc', by: 5 });
 * // Logs { context: { count: 5, name: 'Ada' }, status: 'active', ... }
 * ```
 *
 * @param config - The store configuration object
 * @param config.context - The initial state of the store
 * @param config.on - An object mapping event types to transition functions
 * @param config.emits - An object mapping emitted event types to handlers
 * @returns A store instance with methods to send events and subscribe to state
 *   changes
 */

function createStore(definitionOrLogic) {
  if ('transition' in definitionOrLogic) {
    return createStoreCore(definitionOrLogic);
  }
  const transition = createStoreTransition(definitionOrLogic.on);
  const logic = {
    getInitialSnapshot: () => ({
      status: 'active',
      context: definitionOrLogic.context,
      output: undefined,
      error: undefined
    }),
    transition
  };
  return createStoreCore(logic, definitionOrLogic.emits);
}
function _createStoreConfig(definition) {
  return definition;
}
const createStoreConfig = _createStoreConfig;

/**
 * Creates a `Store` with a provided producer (such as Immer's `producer(…)` A
 * store has its own internal state and can receive events.
 *
 * @example
 *
 * ```ts
 * import { produce } from 'immer';
 *
 * const store = createStoreWithProducer(produce, {
 *   context: { count: 0 },
 *   on: {
 *     inc: (context, event: { by: number }) => {
 *       context.count += event.by;
 *     }
 *   }
 * });
 *
 * store.subscribe((snapshot) => {
 *   console.log(snapshot);
 * });
 *
 * store.send({ type: 'inc', by: 5 });
 * // Logs { context: { count: 5 }, status: 'active', ... }
 * ```
 */
function createStoreWithProducer(producer, config) {
  const transition = createStoreTransition(config.on, producer);
  const logic = {
    getInitialSnapshot: () => ({
      status: 'active',
      context: config.context,
      output: undefined,
      error: undefined
    }),
    transition
  };
  return createStoreCore(logic, config.emits);
}
/**
 * Creates a store transition function that handles state updates based on
 * events.
 *
 * @param transitions - An object mapping event types to transition functions
 * @param producer - Optional producer function (e.g., Immer's produce) for
 *   immutable updates
 * @returns A transition function that takes a snapshot and event and returns a
 *   new snapshot with effects
 */
function createStoreTransition(transitions, producer) {
  return (snapshot, event) => {
    const currentContext = snapshot.context;
    const assigner = transitions?.[event.type];
    const effects = [];
    const enqueue = {
      emit: new Proxy({}, {
        get: (_, eventType) => {
          return payload => {
            effects.push({
              ...payload,
              type: eventType
            });
          };
        }
      }),
      effect: fn => {
        effects.push(fn);
      }
    };
    if (!assigner) {
      return [snapshot, effects];
    }
    const nextContext = producer ? producer(currentContext, draftContext => assigner(draftContext, event, enqueue)) : assigner(currentContext, event, enqueue) ?? currentContext;
    return [nextContext === currentContext ? snapshot : {
      ...snapshot,
      context: nextContext
    }, effects];
  };
}

/**
 * Generates a unique 6-character identifier.
 *
 * @returns A random string identifier
 */
function uniqueId() {
  return Math.random().toString(36).slice(6);
}

export { createStore as a, createStoreWithProducer as b, createStoreTransition as c, createStoreConfig as d, createAtom as e, createAsyncAtom as f };
