import type { Module, ReadOnlyGraph, SerializerOptions } from "metro";
type Bundle = {
    modules: readonly [number, string][];
    post: string;
    pre: string;
};
type BundleMetadata = {
    pre: number;
    post: number;
    modules: readonly [number, number][];
};
type MetroBaseJSBundle = (entryPoint: string, preModules: readonly Module[], graph: ReadOnlyGraph, options: SerializerOptions) => Bundle;
type MetroBundleToString = (bundle: Bundle) => {
    code: string;
    metadata: BundleMetadata;
};
/**
 * Finds the installation path of Metro.
 * @param projectRoot The root of the project; defaults to the current working directory
 * @returns The path to the Metro installation; `undefined` if Metro could not be found
 */
export declare function findMetroPath(projectRoot?: string): string | undefined;
/**
 * Returns Metro version number.
 * @param projectRoot The root of the project; defaults to the current working directory
 * @returns Metro version number; `undefined` if Metro could not be found
 */
export declare function getMetroVersion(projectRoot?: string): string | undefined;
export declare function requireModuleFromMetro(moduleName: "metro", fromDir?: string): typeof import("metro");
export declare function requireModuleFromMetro(moduleName: "metro/src/DeltaBundler/Serializers/baseJSBundle", fromDir?: string): MetroBaseJSBundle;
export declare function requireModuleFromMetro(moduleName: "metro/src/Server", fromDir?: string): typeof import("metro/private/Server").default;
export declare function requireModuleFromMetro(moduleName: "metro/src/lib/TerminalReporter", fromDir?: string): typeof import("metro/private/lib/TerminalReporter").TerminalReporter;
export declare function requireModuleFromMetro(moduleName: "metro/src/lib/bundleToString", fromDir?: string): MetroBundleToString;
export declare function requireModuleFromMetro(moduleName: "metro/src/shared/output/bundle", fromDir?: string): typeof import("metro/private/shared/output/bundle");
export declare function requireModuleFromMetro(moduleName: "metro-config", fromDir?: string): typeof import("metro-config");
export declare function requireModuleFromMetro(moduleName: "metro-core", fromDir?: string): typeof import("metro-core");
export declare function requireModuleFromMetro(moduleName: "metro-resolver", fromDir?: string): typeof import("metro-resolver");
export declare function requireModuleFromMetro(moduleName: "metro-source-map", fromDir?: string): typeof import("metro-source-map");
export {};
//# sourceMappingURL=metro.d.ts.map