import fs from 'fs'
import { name } from '../../package.json'
import { buildCSS } from '../css'

type InjectThemesConfig = {
    themes: Array<string>
    dtsPath?: string
    input: string
}

const buildDtsFile = (dtsPath: string, stringifiedThemes: string) => {
    const oldDtsContent = fs.existsSync(dtsPath)
        ? fs.readFileSync(dtsPath, 'utf-8')
        : ''
    const dtsContent = [
        `// NOTE: This file is generated by ${name} and it should not be edited manually.`,
        `/// <reference types="${name}/types" />`,
        '',
        `declare module '${name}' {`,
        `    export interface UniwindConfig {`,
        `        themes: readonly ${stringifiedThemes}`,
        `    }`,
        `}`,
        '',
        `export {}`,
        '',
    ].join('\n')

    if (oldDtsContent === dtsContent) {
        return
    }

    fs.writeFileSync(
        dtsPath,
        dtsContent,
    )
}

export const injectThemes = async ({
    themes,
    dtsPath = 'uniwind-types.d.ts',
    input,
}: InjectThemesConfig) => {
    const stringifiedThemes = `[${themes.map(theme => `'${theme}'`).join(', ')}]`

    buildDtsFile(dtsPath, stringifiedThemes)
    await buildCSS(themes, input)

    // js generation
    return `globalThis.__uniwindThemes__ = ${stringifiedThemes};`
}
