import { useEffect, useState } from "react";
import { Uniwind } from "../core/index.js";
import { CSSListener } from "../core/web/index.js";
export const useUniwind = () => {
  const [theme, setTheme] = useState(Uniwind.currentTheme);
  const [hasAdaptiveThemes, setHasAdaptiveThemes] = useState(Uniwind.hasAdaptiveThemes);
  useEffect(() => {
    const dispose = CSSListener.addThemeListener(() => {
      setTheme(Uniwind.currentTheme);
      setHasAdaptiveThemes(Uniwind.hasAdaptiveThemes);
    });
    return () => {
      dispose();
    };
  }, []);
  return {
    theme,
    hasAdaptiveThemes
  };
};
