import { jsx } from "react/jsx-runtime";
import { View as RNView } from "react-native";
import { copyComponentProperties } from "../utils.js";
import { useStyle } from "./useStyle.js";
export const View = copyComponentProperties(RNView, (props) => {
  const style = useStyle(props.className);
  return /* @__PURE__ */ jsx(
    RNView,
    {
      ...props,
      style: [style, props.style]
    }
  );
});
export default View;
