import { jsx } from "react/jsx-runtime";
import { SectionList as RNSectionList } from "react-native";
import { useUniwindAccent } from "../../hooks/index.js";
import { copyComponentProperties } from "../utils.js";
import { useStyle } from "./useStyle.js";
export const SectionList = copyComponentProperties(RNSectionList, (props) => {
  const style = useStyle(props.className);
  const contentContainerStyle = useStyle(props.contentContainerClassName);
  const listFooterComponentStyle = useStyle(props.ListFooterComponentClassName);
  const listHeaderComponentStyle = useStyle(props.ListHeaderComponentClassName);
  const endFillColor = useUniwindAccent(props.endFillColorClassName);
  return /* @__PURE__ */ jsx(
    RNSectionList,
    {
      ...props,
      style: [style, props.style],
      contentContainerStyle: [contentContainerStyle, props.contentContainerStyle],
      ListFooterComponentStyle: [listFooterComponentStyle, props.ListFooterComponentStyle],
      ListHeaderComponentStyle: [listHeaderComponentStyle, props.ListHeaderComponentStyle],
      endFillColor: props.endFillColor ?? endFillColor
    }
  );
});
export default SectionList;
