import { jsx } from "react/jsx-runtime";
import { ScrollView as RNScrollView } from "react-native";
import { useUniwindAccent } from "../../hooks/index.js";
import { copyComponentProperties } from "../utils.js";
import { useStyle } from "./useStyle.js";
export const ScrollView = copyComponentProperties(RNScrollView, (props) => {
  const style = useStyle(props.className);
  const contentContainerStyle = useStyle(props.contentContainerClassName);
  const endFillColor = useUniwindAccent(props.endFillColorClassName);
  return /* @__PURE__ */ jsx(
    RNScrollView,
    {
      ...props,
      style: [style, props.style],
      contentContainerStyle: [contentContainerStyle, props.contentContainerStyle],
      endFillColor: props.endFillColor ?? endFillColor
    }
  );
});
export default ScrollView;
