"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResolveClassNames = void 0;
var _react = require("react");
var _native = require("../core/native");
const emptyState = {
  styles: {},
  dependencies: []
};
const useResolveClassNames = (className, state) => {
  const [uniwindState, recreate] = (0, _react.useReducer)(() => className !== "" ? _native.UniwindStore.getStyles(className, state) : emptyState, className !== "" ? _native.UniwindStore.getStyles(className, state) : emptyState);
  (0, _react.useEffect)(() => {
    if (className !== "") {
      recreate();
    }
  }, [className, state?.isDisabled, state?.isPressed, state?.isFocused]);
  (0, _react.useEffect)(() => {
    if (uniwindState.dependencies.length > 0) {
      const dispose = _native.UniwindStore.subscribe(recreate, uniwindState.dependencies);
      return dispose;
    }
  }, [uniwindState.dependencies, className]);
  return uniwindState.styles;
};
exports.useResolveClassNames = useResolveClassNames;