"use strict";
// src/api/RegisterShareService.ts
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegisterShareService = void 0;
class RegisterShareService {
    constructor(fetchWrapper) {
        this.fetchWrapper = fetchWrapper;
    }
    /**
     * Registers a user's sharing of a GIF or sticker.
     *
     * @param params - An object containing the parameters for the request, including the ID of the shared object.
     * @returns A promise that resolves when the share is registered.
     *          The API response does not include a body, so the success is determined by the HTTP status code.
     */
    registerShare(params) {
        return __awaiter(this, void 0, void 0, function* () {
            const endpoint = 'registershare';
            yield this.fetchWrapper.get(endpoint, params);
        });
    }
}
exports.RegisterShareService = RegisterShareService;
