import { FetchWrapper } from '../utils/FetchWrapper';
export interface AutocompleteParams {
    q: string;
    country?: string;
    locale?: string;
    limit?: number;
}
export interface AutocompleteResponse {
    results: string[];
}
export declare class AutocompleteService {
    private fetchWrapper;
    constructor(fetchWrapper: FetchWrapper);
    /**
     * Fetches a list of completed search terms for a given partial search term.
     *
     * @param params - An object containing the search parameters.
     * @returns A promise that resolves to an AutocompleteResponse containing the completed search terms.
     */
    getAutocomplete(params: AutocompleteParams): Promise<AutocompleteResponse>;
}
