"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findSourcemap = findSourcemap;
exports.generateSourcemap = generateSourcemap;
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _os = _interopRequireDefault(require("os"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
// Copy of https://github.com/react-native-community/cli/blob/13.x/packages/cli-hermes/src/profileHermes/metroBundleOptions.ts as `cli-hermes` was recently removed from React Native Community CLI

function getTempFilePath(filename) {
  return _path.default.join(_os.default.tmpdir(), filename);
}
function writeJsonSync(targetPath, data) {
  let json;
  try {
    json = JSON.stringify(data);
  } catch (e) {
    throw new Error(`Failed to serialize data to json before writing to ${targetPath}`, e);
  }
  try {
    _fs.default.writeFileSync(targetPath, json, 'utf-8');
  } catch (e) {
    throw new Error(`Failed to write json to ${targetPath}`, e);
  }
}
async function getSourcemapFromServer(port, {
  platform,
  dev,
  minify,
  host
}) {
  console.log('Getting source maps from Metro packager server');
  const requestURL = `http://${host}:${port}/index.map?platform=${platform}&dev=${dev}&minify=${minify}`;
  console.log(`Downloading from ${requestURL}`);
  try {
    const res = await fetch(requestURL);
    const data = await res.json();
    if (typeof data !== 'object') {
      console.log(`Failed to fetch source map from "${requestURL}", unexpected response format.`);
      return undefined;
    }
    return data;
  } catch (e) {
    console.log(`Failed to fetch source map from "${requestURL}"`);
    return undefined;
  }
}

/**
 * Generate a sourcemap by fetching it from a running metro server
 */
async function generateSourcemap(port, bundleOptions) {
  // Fetch the source map to a temp directory
  const sourceMapPath = getTempFilePath('index.map');
  const sourceMapResult = await getSourcemapFromServer(port, bundleOptions);
  if (sourceMapResult) {
    console.log('Using source maps from Metro packager server');
    writeJsonSync(sourceMapPath, sourceMapResult);
    console.log(`Successfully obtained the source map and stored it in ${sourceMapPath}`);
    return sourceMapPath;
  } else {
    console.log('Error: Cannot obtain source maps from Metro packager server');
    return undefined;
  }
}

/**
 *
 * @param ctx
 */
async function findSourcemap(ctx, port, bundleOptions) {
  const intermediateBuildPath = _path.default.join(ctx.root, 'android', 'app', 'build', 'intermediates', 'sourcemaps', 'react', 'debug', 'index.android.bundle.packager.map');
  const generatedBuildPath = _path.default.join(ctx.root, 'android', 'app', 'build', 'generated', 'sourcemaps', 'react', 'debug', 'index.android.bundle.map');
  if (_fs.default.existsSync(generatedBuildPath)) {
    console.log(`Getting the source map from ${generateSourcemap}`);
    return generatedBuildPath;
  } else if (_fs.default.existsSync(intermediateBuildPath)) {
    console.log(`Getting the source map from ${intermediateBuildPath}`);
    return intermediateBuildPath;
  } else {
    return generateSourcemap(port, bundleOptions);
  }
}
//# sourceMappingURL=sourcemapUtils.js.map