"use strict";

import { View } from 'react-native';
import useSymbolicMarkerRendererProps from "./useSymbolicMarkerRendererStyles.js";
import { jsx as _jsx } from "react/jsx-runtime";
export default function CircleSymbolRenderer(props) {
  const {
    prefixSize,
    prefixStyle
  } = useSymbolicMarkerRendererProps(props);
  const style = {
    borderColor: props.color,
    borderWidth: prefixSize / 10,
    borderRadius: prefixSize,
    ...prefixStyle
  };
  return /*#__PURE__*/_jsx(View, {
    style: style
  });
}
//# sourceMappingURL=CircleSymbolRenderer.js.map