"use strict";

import React, { useContext } from 'react';
const DocumentMetadataContext = /*#__PURE__*/React.createContext({
  baseUrl: '',
  baseTarget: '_self',
  lang: 'en',
  links: [],
  meta: [],
  title: '',
  dir: 'ltr'
});
const DocumentMetadataProvider = DocumentMetadataContext.Provider;

/**
 * Get access to the parsed HTML metadata anywhere in the render tree.
 */
export function useDocumentMetadata() {
  return useContext(DocumentMetadataContext);
}
export default DocumentMetadataProvider;
//# sourceMappingURL=DocumentMetadataProvider.js.map