/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @lightSyntaxTransform
 * @noflow
 * @nolint
 * @preventMunge
 * @preserve-invariant-messages
 */

"use no memo";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __knownSymbol = (name, symbol) => (symbol = Symbol[name]) ? symbol : Symbol.for("Symbol." + name);
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __pow = Math.pow;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var __privateWrapper = (obj, member, setter, getter) => ({
  set _(value) {
    __privateSet(obj, member, value, setter);
  },
  get _() {
    return __privateGet(obj, member, getter);
  }
});
var __await = function(promise, isYieldStar) {
  this[0] = promise;
  this[1] = isYieldStar;
};
var __yieldStar = (value) => {
  var obj = value[__knownSymbol("asyncIterator")], isAwait = false, method, it = {};
  if (obj == null) {
    obj = value[__knownSymbol("iterator")]();
    method = (k) => it[k] = (x) => obj[k](x);
  } else {
    obj = obj.call(value);
    method = (k) => it[k] = (v) => {
      if (isAwait) {
        isAwait = false;
        if (k === "throw") throw v;
        return v;
      }
      isAwait = true;
      return {
        done: false,
        value: new __await(new Promise((resolve) => {
          var x = obj[k](v);
          if (!(x instanceof Object)) __typeError("Object expected");
          resolve(x);
        }), 1)
      };
    };
  }
  return it[__knownSymbol("iterator")] = () => it, method("next"), "throw" in obj ? method("throw") : it.throw = (x) => {
    throw x;
  }, "return" in obj && method("return"), it;
};

// ../../node_modules/invariant/invariant.js
var require_invariant = __commonJS({
  "../../node_modules/invariant/invariant.js"(exports2, module2) {
    "use strict";
    var NODE_ENV = process.env.NODE_ENV;
    var invariant5 = function(condition, format, a, b, c, d, e, f) {
      if (NODE_ENV !== "production") {
        if (format === void 0) {
          throw new Error("invariant requires an error message argument");
        }
      }
      if (!condition) {
        var error;
        if (format === void 0) {
          error = new Error(
            "Minified exception occurred; use the non-minified dev environment for the full error message and additional helpful warnings."
          );
        } else {
          var args = [a, b, c, d, e, f];
          var argIndex = 0;
          error = new Error(
            format.replace(/%s/g, function() {
              return args[argIndex++];
            })
          );
          error.name = "Invariant Violation";
        }
        error.framesToPop = 1;
        throw error;
      }
    };
    module2.exports = invariant5;
  }
});

// ../../node_modules/@babel/types/lib/utils/shallowEqual.js
var require_shallowEqual = __commonJS({
  "../../node_modules/@babel/types/lib/utils/shallowEqual.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = shallowEqual;
    function shallowEqual(actual, expected) {
      const keys = Object.keys(expected);
      for (const key of keys) {
        if (actual[key] !== expected[key]) {
          return false;
        }
      }
      return true;
    }
  }
});

// ../../node_modules/@babel/types/lib/utils/deprecationWarning.js
var require_deprecationWarning = __commonJS({
  "../../node_modules/@babel/types/lib/utils/deprecationWarning.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = deprecationWarning;
    var warnings = /* @__PURE__ */ new Set();
    function deprecationWarning(oldName, newName, prefix = "") {
      if (warnings.has(oldName)) return;
      warnings.add(oldName);
      const {
        internal,
        trace
      } = captureShortStackTrace(1, 2);
      if (internal) {
        return;
      }
      console.warn(`${prefix}\`${oldName}\` has been deprecated, please migrate to \`${newName}\`
${trace}`);
    }
    function captureShortStackTrace(skip, length) {
      const {
        stackTraceLimit,
        prepareStackTrace
      } = Error;
      let stackTrace;
      Error.stackTraceLimit = 1 + skip + length;
      Error.prepareStackTrace = function(err, stack) {
        stackTrace = stack;
      };
      new Error().stack;
      Error.stackTraceLimit = stackTraceLimit;
      Error.prepareStackTrace = prepareStackTrace;
      if (!stackTrace) return {
        internal: false,
        trace: ""
      };
      const shortStackTrace = stackTrace.slice(1 + skip, 1 + skip + length);
      return {
        internal: /[\\/]@babel[\\/]/.test(shortStackTrace[1].getFileName()),
        trace: shortStackTrace.map((frame) => `    at ${frame}`).join("\n")
      };
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/generated/index.js
var require_generated = __commonJS({
  "../../node_modules/@babel/types/lib/validators/generated/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.isAccessor = isAccessor;
    exports2.isAnyTypeAnnotation = isAnyTypeAnnotation;
    exports2.isArgumentPlaceholder = isArgumentPlaceholder;
    exports2.isArrayExpression = isArrayExpression;
    exports2.isArrayPattern = isArrayPattern;
    exports2.isArrayTypeAnnotation = isArrayTypeAnnotation;
    exports2.isArrowFunctionExpression = isArrowFunctionExpression;
    exports2.isAssignmentExpression = isAssignmentExpression;
    exports2.isAssignmentPattern = isAssignmentPattern;
    exports2.isAwaitExpression = isAwaitExpression;
    exports2.isBigIntLiteral = isBigIntLiteral;
    exports2.isBinary = isBinary;
    exports2.isBinaryExpression = isBinaryExpression;
    exports2.isBindExpression = isBindExpression;
    exports2.isBlock = isBlock;
    exports2.isBlockParent = isBlockParent;
    exports2.isBlockStatement = isBlockStatement;
    exports2.isBooleanLiteral = isBooleanLiteral;
    exports2.isBooleanLiteralTypeAnnotation = isBooleanLiteralTypeAnnotation;
    exports2.isBooleanTypeAnnotation = isBooleanTypeAnnotation;
    exports2.isBreakStatement = isBreakStatement;
    exports2.isCallExpression = isCallExpression;
    exports2.isCatchClause = isCatchClause;
    exports2.isClass = isClass;
    exports2.isClassAccessorProperty = isClassAccessorProperty;
    exports2.isClassBody = isClassBody;
    exports2.isClassDeclaration = isClassDeclaration;
    exports2.isClassExpression = isClassExpression;
    exports2.isClassImplements = isClassImplements;
    exports2.isClassMethod = isClassMethod;
    exports2.isClassPrivateMethod = isClassPrivateMethod;
    exports2.isClassPrivateProperty = isClassPrivateProperty;
    exports2.isClassProperty = isClassProperty;
    exports2.isCompletionStatement = isCompletionStatement;
    exports2.isConditional = isConditional;
    exports2.isConditionalExpression = isConditionalExpression;
    exports2.isContinueStatement = isContinueStatement;
    exports2.isDebuggerStatement = isDebuggerStatement;
    exports2.isDecimalLiteral = isDecimalLiteral;
    exports2.isDeclaration = isDeclaration;
    exports2.isDeclareClass = isDeclareClass;
    exports2.isDeclareExportAllDeclaration = isDeclareExportAllDeclaration;
    exports2.isDeclareExportDeclaration = isDeclareExportDeclaration;
    exports2.isDeclareFunction = isDeclareFunction;
    exports2.isDeclareInterface = isDeclareInterface;
    exports2.isDeclareModule = isDeclareModule;
    exports2.isDeclareModuleExports = isDeclareModuleExports;
    exports2.isDeclareOpaqueType = isDeclareOpaqueType;
    exports2.isDeclareTypeAlias = isDeclareTypeAlias;
    exports2.isDeclareVariable = isDeclareVariable;
    exports2.isDeclaredPredicate = isDeclaredPredicate;
    exports2.isDecorator = isDecorator;
    exports2.isDirective = isDirective;
    exports2.isDirectiveLiteral = isDirectiveLiteral;
    exports2.isDoExpression = isDoExpression;
    exports2.isDoWhileStatement = isDoWhileStatement;
    exports2.isEmptyStatement = isEmptyStatement;
    exports2.isEmptyTypeAnnotation = isEmptyTypeAnnotation;
    exports2.isEnumBody = isEnumBody;
    exports2.isEnumBooleanBody = isEnumBooleanBody;
    exports2.isEnumBooleanMember = isEnumBooleanMember;
    exports2.isEnumDeclaration = isEnumDeclaration;
    exports2.isEnumDefaultedMember = isEnumDefaultedMember;
    exports2.isEnumMember = isEnumMember;
    exports2.isEnumNumberBody = isEnumNumberBody;
    exports2.isEnumNumberMember = isEnumNumberMember;
    exports2.isEnumStringBody = isEnumStringBody;
    exports2.isEnumStringMember = isEnumStringMember;
    exports2.isEnumSymbolBody = isEnumSymbolBody;
    exports2.isExistsTypeAnnotation = isExistsTypeAnnotation;
    exports2.isExportAllDeclaration = isExportAllDeclaration;
    exports2.isExportDeclaration = isExportDeclaration;
    exports2.isExportDefaultDeclaration = isExportDefaultDeclaration;
    exports2.isExportDefaultSpecifier = isExportDefaultSpecifier;
    exports2.isExportNamedDeclaration = isExportNamedDeclaration;
    exports2.isExportNamespaceSpecifier = isExportNamespaceSpecifier;
    exports2.isExportSpecifier = isExportSpecifier;
    exports2.isExpression = isExpression2;
    exports2.isExpressionStatement = isExpressionStatement;
    exports2.isExpressionWrapper = isExpressionWrapper;
    exports2.isFile = isFile;
    exports2.isFlow = isFlow;
    exports2.isFlowBaseAnnotation = isFlowBaseAnnotation;
    exports2.isFlowDeclaration = isFlowDeclaration;
    exports2.isFlowPredicate = isFlowPredicate;
    exports2.isFlowType = isFlowType;
    exports2.isFor = isFor;
    exports2.isForInStatement = isForInStatement;
    exports2.isForOfStatement = isForOfStatement;
    exports2.isForStatement = isForStatement;
    exports2.isForXStatement = isForXStatement;
    exports2.isFunction = isFunction;
    exports2.isFunctionDeclaration = isFunctionDeclaration;
    exports2.isFunctionExpression = isFunctionExpression;
    exports2.isFunctionParent = isFunctionParent;
    exports2.isFunctionTypeAnnotation = isFunctionTypeAnnotation;
    exports2.isFunctionTypeParam = isFunctionTypeParam;
    exports2.isGenericTypeAnnotation = isGenericTypeAnnotation;
    exports2.isIdentifier = isIdentifier;
    exports2.isIfStatement = isIfStatement;
    exports2.isImmutable = isImmutable;
    exports2.isImport = isImport;
    exports2.isImportAttribute = isImportAttribute;
    exports2.isImportDeclaration = isImportDeclaration;
    exports2.isImportDefaultSpecifier = isImportDefaultSpecifier;
    exports2.isImportExpression = isImportExpression;
    exports2.isImportNamespaceSpecifier = isImportNamespaceSpecifier;
    exports2.isImportOrExportDeclaration = isImportOrExportDeclaration;
    exports2.isImportSpecifier = isImportSpecifier;
    exports2.isIndexedAccessType = isIndexedAccessType;
    exports2.isInferredPredicate = isInferredPredicate;
    exports2.isInterfaceDeclaration = isInterfaceDeclaration;
    exports2.isInterfaceExtends = isInterfaceExtends;
    exports2.isInterfaceTypeAnnotation = isInterfaceTypeAnnotation;
    exports2.isInterpreterDirective = isInterpreterDirective;
    exports2.isIntersectionTypeAnnotation = isIntersectionTypeAnnotation;
    exports2.isJSX = isJSX;
    exports2.isJSXAttribute = isJSXAttribute;
    exports2.isJSXClosingElement = isJSXClosingElement;
    exports2.isJSXClosingFragment = isJSXClosingFragment;
    exports2.isJSXElement = isJSXElement;
    exports2.isJSXEmptyExpression = isJSXEmptyExpression;
    exports2.isJSXExpressionContainer = isJSXExpressionContainer;
    exports2.isJSXFragment = isJSXFragment;
    exports2.isJSXIdentifier = isJSXIdentifier;
    exports2.isJSXMemberExpression = isJSXMemberExpression;
    exports2.isJSXNamespacedName = isJSXNamespacedName;
    exports2.isJSXOpeningElement = isJSXOpeningElement;
    exports2.isJSXOpeningFragment = isJSXOpeningFragment;
    exports2.isJSXSpreadAttribute = isJSXSpreadAttribute;
    exports2.isJSXSpreadChild = isJSXSpreadChild;
    exports2.isJSXText = isJSXText;
    exports2.isLVal = isLVal;
    exports2.isLabeledStatement = isLabeledStatement;
    exports2.isLiteral = isLiteral;
    exports2.isLogicalExpression = isLogicalExpression;
    exports2.isLoop = isLoop;
    exports2.isMemberExpression = isMemberExpression2;
    exports2.isMetaProperty = isMetaProperty;
    exports2.isMethod = isMethod;
    exports2.isMiscellaneous = isMiscellaneous;
    exports2.isMixedTypeAnnotation = isMixedTypeAnnotation;
    exports2.isModuleDeclaration = isModuleDeclaration;
    exports2.isModuleExpression = isModuleExpression;
    exports2.isModuleSpecifier = isModuleSpecifier;
    exports2.isNewExpression = isNewExpression;
    exports2.isNoop = isNoop;
    exports2.isNullLiteral = isNullLiteral;
    exports2.isNullLiteralTypeAnnotation = isNullLiteralTypeAnnotation;
    exports2.isNullableTypeAnnotation = isNullableTypeAnnotation;
    exports2.isNumberLiteral = isNumberLiteral;
    exports2.isNumberLiteralTypeAnnotation = isNumberLiteralTypeAnnotation;
    exports2.isNumberTypeAnnotation = isNumberTypeAnnotation;
    exports2.isNumericLiteral = isNumericLiteral;
    exports2.isObjectExpression = isObjectExpression;
    exports2.isObjectMember = isObjectMember;
    exports2.isObjectMethod = isObjectMethod;
    exports2.isObjectPattern = isObjectPattern;
    exports2.isObjectProperty = isObjectProperty;
    exports2.isObjectTypeAnnotation = isObjectTypeAnnotation;
    exports2.isObjectTypeCallProperty = isObjectTypeCallProperty;
    exports2.isObjectTypeIndexer = isObjectTypeIndexer;
    exports2.isObjectTypeInternalSlot = isObjectTypeInternalSlot;
    exports2.isObjectTypeProperty = isObjectTypeProperty;
    exports2.isObjectTypeSpreadProperty = isObjectTypeSpreadProperty;
    exports2.isOpaqueType = isOpaqueType;
    exports2.isOptionalCallExpression = isOptionalCallExpression;
    exports2.isOptionalIndexedAccessType = isOptionalIndexedAccessType;
    exports2.isOptionalMemberExpression = isOptionalMemberExpression2;
    exports2.isParenthesizedExpression = isParenthesizedExpression;
    exports2.isPattern = isPattern;
    exports2.isPatternLike = isPatternLike;
    exports2.isPipelineBareFunction = isPipelineBareFunction;
    exports2.isPipelinePrimaryTopicReference = isPipelinePrimaryTopicReference;
    exports2.isPipelineTopicExpression = isPipelineTopicExpression;
    exports2.isPlaceholder = isPlaceholder;
    exports2.isPrivate = isPrivate;
    exports2.isPrivateName = isPrivateName;
    exports2.isProgram = isProgram;
    exports2.isProperty = isProperty;
    exports2.isPureish = isPureish;
    exports2.isQualifiedTypeIdentifier = isQualifiedTypeIdentifier;
    exports2.isRecordExpression = isRecordExpression;
    exports2.isRegExpLiteral = isRegExpLiteral;
    exports2.isRegexLiteral = isRegexLiteral;
    exports2.isRestElement = isRestElement;
    exports2.isRestProperty = isRestProperty;
    exports2.isReturnStatement = isReturnStatement;
    exports2.isScopable = isScopable;
    exports2.isSequenceExpression = isSequenceExpression;
    exports2.isSpreadElement = isSpreadElement;
    exports2.isSpreadProperty = isSpreadProperty;
    exports2.isStandardized = isStandardized;
    exports2.isStatement = isStatement2;
    exports2.isStaticBlock = isStaticBlock;
    exports2.isStringLiteral = isStringLiteral;
    exports2.isStringLiteralTypeAnnotation = isStringLiteralTypeAnnotation;
    exports2.isStringTypeAnnotation = isStringTypeAnnotation;
    exports2.isSuper = isSuper;
    exports2.isSwitchCase = isSwitchCase;
    exports2.isSwitchStatement = isSwitchStatement;
    exports2.isSymbolTypeAnnotation = isSymbolTypeAnnotation;
    exports2.isTSAnyKeyword = isTSAnyKeyword;
    exports2.isTSArrayType = isTSArrayType;
    exports2.isTSAsExpression = isTSAsExpression;
    exports2.isTSBaseType = isTSBaseType;
    exports2.isTSBigIntKeyword = isTSBigIntKeyword;
    exports2.isTSBooleanKeyword = isTSBooleanKeyword;
    exports2.isTSCallSignatureDeclaration = isTSCallSignatureDeclaration;
    exports2.isTSConditionalType = isTSConditionalType;
    exports2.isTSConstructSignatureDeclaration = isTSConstructSignatureDeclaration;
    exports2.isTSConstructorType = isTSConstructorType;
    exports2.isTSDeclareFunction = isTSDeclareFunction;
    exports2.isTSDeclareMethod = isTSDeclareMethod;
    exports2.isTSEntityName = isTSEntityName;
    exports2.isTSEnumDeclaration = isTSEnumDeclaration;
    exports2.isTSEnumMember = isTSEnumMember;
    exports2.isTSExportAssignment = isTSExportAssignment;
    exports2.isTSExpressionWithTypeArguments = isTSExpressionWithTypeArguments;
    exports2.isTSExternalModuleReference = isTSExternalModuleReference;
    exports2.isTSFunctionType = isTSFunctionType;
    exports2.isTSImportEqualsDeclaration = isTSImportEqualsDeclaration;
    exports2.isTSImportType = isTSImportType;
    exports2.isTSIndexSignature = isTSIndexSignature;
    exports2.isTSIndexedAccessType = isTSIndexedAccessType;
    exports2.isTSInferType = isTSInferType;
    exports2.isTSInstantiationExpression = isTSInstantiationExpression;
    exports2.isTSInterfaceBody = isTSInterfaceBody;
    exports2.isTSInterfaceDeclaration = isTSInterfaceDeclaration;
    exports2.isTSIntersectionType = isTSIntersectionType;
    exports2.isTSIntrinsicKeyword = isTSIntrinsicKeyword;
    exports2.isTSLiteralType = isTSLiteralType;
    exports2.isTSMappedType = isTSMappedType;
    exports2.isTSMethodSignature = isTSMethodSignature;
    exports2.isTSModuleBlock = isTSModuleBlock;
    exports2.isTSModuleDeclaration = isTSModuleDeclaration;
    exports2.isTSNamedTupleMember = isTSNamedTupleMember;
    exports2.isTSNamespaceExportDeclaration = isTSNamespaceExportDeclaration;
    exports2.isTSNeverKeyword = isTSNeverKeyword;
    exports2.isTSNonNullExpression = isTSNonNullExpression;
    exports2.isTSNullKeyword = isTSNullKeyword;
    exports2.isTSNumberKeyword = isTSNumberKeyword;
    exports2.isTSObjectKeyword = isTSObjectKeyword;
    exports2.isTSOptionalType = isTSOptionalType;
    exports2.isTSParameterProperty = isTSParameterProperty;
    exports2.isTSParenthesizedType = isTSParenthesizedType;
    exports2.isTSPropertySignature = isTSPropertySignature;
    exports2.isTSQualifiedName = isTSQualifiedName;
    exports2.isTSRestType = isTSRestType;
    exports2.isTSSatisfiesExpression = isTSSatisfiesExpression;
    exports2.isTSStringKeyword = isTSStringKeyword;
    exports2.isTSSymbolKeyword = isTSSymbolKeyword;
    exports2.isTSThisType = isTSThisType;
    exports2.isTSTupleType = isTSTupleType;
    exports2.isTSType = isTSType2;
    exports2.isTSTypeAliasDeclaration = isTSTypeAliasDeclaration;
    exports2.isTSTypeAnnotation = isTSTypeAnnotation;
    exports2.isTSTypeAssertion = isTSTypeAssertion;
    exports2.isTSTypeElement = isTSTypeElement;
    exports2.isTSTypeLiteral = isTSTypeLiteral;
    exports2.isTSTypeOperator = isTSTypeOperator;
    exports2.isTSTypeParameter = isTSTypeParameter;
    exports2.isTSTypeParameterDeclaration = isTSTypeParameterDeclaration;
    exports2.isTSTypeParameterInstantiation = isTSTypeParameterInstantiation;
    exports2.isTSTypePredicate = isTSTypePredicate;
    exports2.isTSTypeQuery = isTSTypeQuery;
    exports2.isTSTypeReference = isTSTypeReference;
    exports2.isTSUndefinedKeyword = isTSUndefinedKeyword;
    exports2.isTSUnionType = isTSUnionType;
    exports2.isTSUnknownKeyword = isTSUnknownKeyword;
    exports2.isTSVoidKeyword = isTSVoidKeyword;
    exports2.isTaggedTemplateExpression = isTaggedTemplateExpression;
    exports2.isTemplateElement = isTemplateElement;
    exports2.isTemplateLiteral = isTemplateLiteral;
    exports2.isTerminatorless = isTerminatorless;
    exports2.isThisExpression = isThisExpression;
    exports2.isThisTypeAnnotation = isThisTypeAnnotation;
    exports2.isThrowStatement = isThrowStatement;
    exports2.isTopicReference = isTopicReference;
    exports2.isTryStatement = isTryStatement;
    exports2.isTupleExpression = isTupleExpression;
    exports2.isTupleTypeAnnotation = isTupleTypeAnnotation;
    exports2.isTypeAlias = isTypeAlias;
    exports2.isTypeAnnotation = isTypeAnnotation;
    exports2.isTypeCastExpression = isTypeCastExpression;
    exports2.isTypeParameter = isTypeParameter;
    exports2.isTypeParameterDeclaration = isTypeParameterDeclaration;
    exports2.isTypeParameterInstantiation = isTypeParameterInstantiation;
    exports2.isTypeScript = isTypeScript;
    exports2.isTypeofTypeAnnotation = isTypeofTypeAnnotation;
    exports2.isUnaryExpression = isUnaryExpression;
    exports2.isUnaryLike = isUnaryLike;
    exports2.isUnionTypeAnnotation = isUnionTypeAnnotation;
    exports2.isUpdateExpression = isUpdateExpression;
    exports2.isUserWhitespacable = isUserWhitespacable;
    exports2.isV8IntrinsicIdentifier = isV8IntrinsicIdentifier;
    exports2.isVariableDeclaration = isVariableDeclaration2;
    exports2.isVariableDeclarator = isVariableDeclarator;
    exports2.isVariance = isVariance;
    exports2.isVoidTypeAnnotation = isVoidTypeAnnotation;
    exports2.isWhile = isWhile;
    exports2.isWhileStatement = isWhileStatement;
    exports2.isWithStatement = isWithStatement;
    exports2.isYieldExpression = isYieldExpression;
    var _shallowEqual = require_shallowEqual();
    var _deprecationWarning = require_deprecationWarning();
    function isArrayExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "ArrayExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isAssignmentExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "AssignmentExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBinaryExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "BinaryExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isInterpreterDirective(node, opts) {
      if (!node) return false;
      if (node.type !== "InterpreterDirective") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDirective(node, opts) {
      if (!node) return false;
      if (node.type !== "Directive") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDirectiveLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "DirectiveLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBlockStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "BlockStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBreakStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "BreakStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isCallExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "CallExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isCatchClause(node, opts) {
      if (!node) return false;
      if (node.type !== "CatchClause") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isConditionalExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "ConditionalExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isContinueStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "ContinueStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDebuggerStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "DebuggerStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDoWhileStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "DoWhileStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEmptyStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "EmptyStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExpressionStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "ExpressionStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFile(node, opts) {
      if (!node) return false;
      if (node.type !== "File") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isForInStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "ForInStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isForStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "ForStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFunctionDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "FunctionDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFunctionExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "FunctionExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isIdentifier(node, opts) {
      if (!node) return false;
      if (node.type !== "Identifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isIfStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "IfStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isLabeledStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "LabeledStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isStringLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "StringLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isNumericLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "NumericLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isNullLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "NullLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBooleanLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "BooleanLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isRegExpLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "RegExpLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isLogicalExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "LogicalExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isMemberExpression2(node, opts) {
      if (!node) return false;
      if (node.type !== "MemberExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isNewExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "NewExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isProgram(node, opts) {
      if (!node) return false;
      if (node.type !== "Program") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectMethod(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectMethod") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectProperty(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isRestElement(node, opts) {
      if (!node) return false;
      if (node.type !== "RestElement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isReturnStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "ReturnStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isSequenceExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "SequenceExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isParenthesizedExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "ParenthesizedExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isSwitchCase(node, opts) {
      if (!node) return false;
      if (node.type !== "SwitchCase") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isSwitchStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "SwitchStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isThisExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "ThisExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isThrowStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "ThrowStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTryStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "TryStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isUnaryExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "UnaryExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isUpdateExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "UpdateExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isVariableDeclaration2(node, opts) {
      if (!node) return false;
      if (node.type !== "VariableDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isVariableDeclarator(node, opts) {
      if (!node) return false;
      if (node.type !== "VariableDeclarator") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isWhileStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "WhileStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isWithStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "WithStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isAssignmentPattern(node, opts) {
      if (!node) return false;
      if (node.type !== "AssignmentPattern") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isArrayPattern(node, opts) {
      if (!node) return false;
      if (node.type !== "ArrayPattern") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isArrowFunctionExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "ArrowFunctionExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClassBody(node, opts) {
      if (!node) return false;
      if (node.type !== "ClassBody") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClassExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "ClassExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClassDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "ClassDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExportAllDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "ExportAllDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExportDefaultDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "ExportDefaultDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExportNamedDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "ExportNamedDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExportSpecifier(node, opts) {
      if (!node) return false;
      if (node.type !== "ExportSpecifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isForOfStatement(node, opts) {
      if (!node) return false;
      if (node.type !== "ForOfStatement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isImportDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "ImportDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isImportDefaultSpecifier(node, opts) {
      if (!node) return false;
      if (node.type !== "ImportDefaultSpecifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isImportNamespaceSpecifier(node, opts) {
      if (!node) return false;
      if (node.type !== "ImportNamespaceSpecifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isImportSpecifier(node, opts) {
      if (!node) return false;
      if (node.type !== "ImportSpecifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isImportExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "ImportExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isMetaProperty(node, opts) {
      if (!node) return false;
      if (node.type !== "MetaProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClassMethod(node, opts) {
      if (!node) return false;
      if (node.type !== "ClassMethod") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectPattern(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectPattern") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isSpreadElement(node, opts) {
      if (!node) return false;
      if (node.type !== "SpreadElement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isSuper(node, opts) {
      if (!node) return false;
      if (node.type !== "Super") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTaggedTemplateExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "TaggedTemplateExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTemplateElement(node, opts) {
      if (!node) return false;
      if (node.type !== "TemplateElement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTemplateLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "TemplateLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isYieldExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "YieldExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isAwaitExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "AwaitExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isImport(node, opts) {
      if (!node) return false;
      if (node.type !== "Import") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBigIntLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "BigIntLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExportNamespaceSpecifier(node, opts) {
      if (!node) return false;
      if (node.type !== "ExportNamespaceSpecifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isOptionalMemberExpression2(node, opts) {
      if (!node) return false;
      if (node.type !== "OptionalMemberExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isOptionalCallExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "OptionalCallExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClassProperty(node, opts) {
      if (!node) return false;
      if (node.type !== "ClassProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClassAccessorProperty(node, opts) {
      if (!node) return false;
      if (node.type !== "ClassAccessorProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClassPrivateProperty(node, opts) {
      if (!node) return false;
      if (node.type !== "ClassPrivateProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClassPrivateMethod(node, opts) {
      if (!node) return false;
      if (node.type !== "ClassPrivateMethod") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isPrivateName(node, opts) {
      if (!node) return false;
      if (node.type !== "PrivateName") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isStaticBlock(node, opts) {
      if (!node) return false;
      if (node.type !== "StaticBlock") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isAnyTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "AnyTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isArrayTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "ArrayTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBooleanTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "BooleanTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBooleanLiteralTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "BooleanLiteralTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isNullLiteralTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "NullLiteralTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClassImplements(node, opts) {
      if (!node) return false;
      if (node.type !== "ClassImplements") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareClass(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareClass") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareFunction(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareFunction") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareInterface(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareInterface") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareModule(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareModule") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareModuleExports(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareModuleExports") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareTypeAlias(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareTypeAlias") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareOpaqueType(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareOpaqueType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareVariable(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareVariable") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareExportDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareExportDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclareExportAllDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclareExportAllDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclaredPredicate(node, opts) {
      if (!node) return false;
      if (node.type !== "DeclaredPredicate") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExistsTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "ExistsTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFunctionTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "FunctionTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFunctionTypeParam(node, opts) {
      if (!node) return false;
      if (node.type !== "FunctionTypeParam") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isGenericTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "GenericTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isInferredPredicate(node, opts) {
      if (!node) return false;
      if (node.type !== "InferredPredicate") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isInterfaceExtends(node, opts) {
      if (!node) return false;
      if (node.type !== "InterfaceExtends") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isInterfaceDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "InterfaceDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isInterfaceTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "InterfaceTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isIntersectionTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "IntersectionTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isMixedTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "MixedTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEmptyTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "EmptyTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isNullableTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "NullableTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isNumberLiteralTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "NumberLiteralTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isNumberTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "NumberTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectTypeInternalSlot(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectTypeInternalSlot") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectTypeCallProperty(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectTypeCallProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectTypeIndexer(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectTypeIndexer") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectTypeProperty(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectTypeProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectTypeSpreadProperty(node, opts) {
      if (!node) return false;
      if (node.type !== "ObjectTypeSpreadProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isOpaqueType(node, opts) {
      if (!node) return false;
      if (node.type !== "OpaqueType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isQualifiedTypeIdentifier(node, opts) {
      if (!node) return false;
      if (node.type !== "QualifiedTypeIdentifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isStringLiteralTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "StringLiteralTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isStringTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "StringTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isSymbolTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "SymbolTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isThisTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "ThisTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTupleTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "TupleTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTypeofTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "TypeofTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTypeAlias(node, opts) {
      if (!node) return false;
      if (node.type !== "TypeAlias") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "TypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTypeCastExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "TypeCastExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTypeParameter(node, opts) {
      if (!node) return false;
      if (node.type !== "TypeParameter") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTypeParameterDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TypeParameterDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTypeParameterInstantiation(node, opts) {
      if (!node) return false;
      if (node.type !== "TypeParameterInstantiation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isUnionTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "UnionTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isVariance(node, opts) {
      if (!node) return false;
      if (node.type !== "Variance") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isVoidTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "VoidTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "EnumDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumBooleanBody(node, opts) {
      if (!node) return false;
      if (node.type !== "EnumBooleanBody") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumNumberBody(node, opts) {
      if (!node) return false;
      if (node.type !== "EnumNumberBody") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumStringBody(node, opts) {
      if (!node) return false;
      if (node.type !== "EnumStringBody") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumSymbolBody(node, opts) {
      if (!node) return false;
      if (node.type !== "EnumSymbolBody") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumBooleanMember(node, opts) {
      if (!node) return false;
      if (node.type !== "EnumBooleanMember") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumNumberMember(node, opts) {
      if (!node) return false;
      if (node.type !== "EnumNumberMember") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumStringMember(node, opts) {
      if (!node) return false;
      if (node.type !== "EnumStringMember") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumDefaultedMember(node, opts) {
      if (!node) return false;
      if (node.type !== "EnumDefaultedMember") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isIndexedAccessType(node, opts) {
      if (!node) return false;
      if (node.type !== "IndexedAccessType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isOptionalIndexedAccessType(node, opts) {
      if (!node) return false;
      if (node.type !== "OptionalIndexedAccessType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXAttribute(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXAttribute") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXClosingElement(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXClosingElement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXElement(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXElement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXEmptyExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXEmptyExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXExpressionContainer(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXExpressionContainer") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXSpreadChild(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXSpreadChild") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXIdentifier(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXIdentifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXMemberExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXMemberExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXNamespacedName(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXNamespacedName") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXOpeningElement(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXOpeningElement") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXSpreadAttribute(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXSpreadAttribute") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXText(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXText") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXFragment(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXFragment") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXOpeningFragment(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXOpeningFragment") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSXClosingFragment(node, opts) {
      if (!node) return false;
      if (node.type !== "JSXClosingFragment") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isNoop(node, opts) {
      if (!node) return false;
      if (node.type !== "Noop") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isPlaceholder(node, opts) {
      if (!node) return false;
      if (node.type !== "Placeholder") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isV8IntrinsicIdentifier(node, opts) {
      if (!node) return false;
      if (node.type !== "V8IntrinsicIdentifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isArgumentPlaceholder(node, opts) {
      if (!node) return false;
      if (node.type !== "ArgumentPlaceholder") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBindExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "BindExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isImportAttribute(node, opts) {
      if (!node) return false;
      if (node.type !== "ImportAttribute") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDecorator(node, opts) {
      if (!node) return false;
      if (node.type !== "Decorator") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDoExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "DoExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExportDefaultSpecifier(node, opts) {
      if (!node) return false;
      if (node.type !== "ExportDefaultSpecifier") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isRecordExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "RecordExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTupleExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "TupleExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDecimalLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "DecimalLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isModuleExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "ModuleExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTopicReference(node, opts) {
      if (!node) return false;
      if (node.type !== "TopicReference") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isPipelineTopicExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "PipelineTopicExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isPipelineBareFunction(node, opts) {
      if (!node) return false;
      if (node.type !== "PipelineBareFunction") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isPipelinePrimaryTopicReference(node, opts) {
      if (!node) return false;
      if (node.type !== "PipelinePrimaryTopicReference") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSParameterProperty(node, opts) {
      if (!node) return false;
      if (node.type !== "TSParameterProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSDeclareFunction(node, opts) {
      if (!node) return false;
      if (node.type !== "TSDeclareFunction") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSDeclareMethod(node, opts) {
      if (!node) return false;
      if (node.type !== "TSDeclareMethod") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSQualifiedName(node, opts) {
      if (!node) return false;
      if (node.type !== "TSQualifiedName") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSCallSignatureDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TSCallSignatureDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSConstructSignatureDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TSConstructSignatureDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSPropertySignature(node, opts) {
      if (!node) return false;
      if (node.type !== "TSPropertySignature") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSMethodSignature(node, opts) {
      if (!node) return false;
      if (node.type !== "TSMethodSignature") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSIndexSignature(node, opts) {
      if (!node) return false;
      if (node.type !== "TSIndexSignature") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSAnyKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSAnyKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSBooleanKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSBooleanKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSBigIntKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSBigIntKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSIntrinsicKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSIntrinsicKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSNeverKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSNeverKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSNullKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSNullKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSNumberKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSNumberKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSObjectKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSObjectKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSStringKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSStringKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSSymbolKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSSymbolKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSUndefinedKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSUndefinedKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSUnknownKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSUnknownKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSVoidKeyword(node, opts) {
      if (!node) return false;
      if (node.type !== "TSVoidKeyword") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSThisType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSThisType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSFunctionType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSFunctionType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSConstructorType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSConstructorType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeReference(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeReference") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypePredicate(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypePredicate") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeQuery(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeQuery") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeLiteral(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSArrayType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSArrayType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTupleType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTupleType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSOptionalType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSOptionalType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSRestType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSRestType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSNamedTupleMember(node, opts) {
      if (!node) return false;
      if (node.type !== "TSNamedTupleMember") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSUnionType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSUnionType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSIntersectionType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSIntersectionType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSConditionalType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSConditionalType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSInferType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSInferType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSParenthesizedType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSParenthesizedType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeOperator(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeOperator") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSIndexedAccessType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSIndexedAccessType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSMappedType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSMappedType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSLiteralType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSLiteralType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSExpressionWithTypeArguments(node, opts) {
      if (!node) return false;
      if (node.type !== "TSExpressionWithTypeArguments") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSInterfaceDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TSInterfaceDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSInterfaceBody(node, opts) {
      if (!node) return false;
      if (node.type !== "TSInterfaceBody") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeAliasDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeAliasDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSInstantiationExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "TSInstantiationExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSAsExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "TSAsExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSSatisfiesExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "TSSatisfiesExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeAssertion(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeAssertion") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSEnumDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TSEnumDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSEnumMember(node, opts) {
      if (!node) return false;
      if (node.type !== "TSEnumMember") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSModuleDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TSModuleDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSModuleBlock(node, opts) {
      if (!node) return false;
      if (node.type !== "TSModuleBlock") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSImportType(node, opts) {
      if (!node) return false;
      if (node.type !== "TSImportType") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSImportEqualsDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TSImportEqualsDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSExternalModuleReference(node, opts) {
      if (!node) return false;
      if (node.type !== "TSExternalModuleReference") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSNonNullExpression(node, opts) {
      if (!node) return false;
      if (node.type !== "TSNonNullExpression") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSExportAssignment(node, opts) {
      if (!node) return false;
      if (node.type !== "TSExportAssignment") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSNamespaceExportDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TSNamespaceExportDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeAnnotation(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeAnnotation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeParameterInstantiation(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeParameterInstantiation") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeParameterDeclaration(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeParameterDeclaration") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeParameter(node, opts) {
      if (!node) return false;
      if (node.type !== "TSTypeParameter") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isStandardized(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ArrayExpression":
        case "AssignmentExpression":
        case "BinaryExpression":
        case "InterpreterDirective":
        case "Directive":
        case "DirectiveLiteral":
        case "BlockStatement":
        case "BreakStatement":
        case "CallExpression":
        case "CatchClause":
        case "ConditionalExpression":
        case "ContinueStatement":
        case "DebuggerStatement":
        case "DoWhileStatement":
        case "EmptyStatement":
        case "ExpressionStatement":
        case "File":
        case "ForInStatement":
        case "ForStatement":
        case "FunctionDeclaration":
        case "FunctionExpression":
        case "Identifier":
        case "IfStatement":
        case "LabeledStatement":
        case "StringLiteral":
        case "NumericLiteral":
        case "NullLiteral":
        case "BooleanLiteral":
        case "RegExpLiteral":
        case "LogicalExpression":
        case "MemberExpression":
        case "NewExpression":
        case "Program":
        case "ObjectExpression":
        case "ObjectMethod":
        case "ObjectProperty":
        case "RestElement":
        case "ReturnStatement":
        case "SequenceExpression":
        case "ParenthesizedExpression":
        case "SwitchCase":
        case "SwitchStatement":
        case "ThisExpression":
        case "ThrowStatement":
        case "TryStatement":
        case "UnaryExpression":
        case "UpdateExpression":
        case "VariableDeclaration":
        case "VariableDeclarator":
        case "WhileStatement":
        case "WithStatement":
        case "AssignmentPattern":
        case "ArrayPattern":
        case "ArrowFunctionExpression":
        case "ClassBody":
        case "ClassExpression":
        case "ClassDeclaration":
        case "ExportAllDeclaration":
        case "ExportDefaultDeclaration":
        case "ExportNamedDeclaration":
        case "ExportSpecifier":
        case "ForOfStatement":
        case "ImportDeclaration":
        case "ImportDefaultSpecifier":
        case "ImportNamespaceSpecifier":
        case "ImportSpecifier":
        case "ImportExpression":
        case "MetaProperty":
        case "ClassMethod":
        case "ObjectPattern":
        case "SpreadElement":
        case "Super":
        case "TaggedTemplateExpression":
        case "TemplateElement":
        case "TemplateLiteral":
        case "YieldExpression":
        case "AwaitExpression":
        case "Import":
        case "BigIntLiteral":
        case "ExportNamespaceSpecifier":
        case "OptionalMemberExpression":
        case "OptionalCallExpression":
        case "ClassProperty":
        case "ClassAccessorProperty":
        case "ClassPrivateProperty":
        case "ClassPrivateMethod":
        case "PrivateName":
        case "StaticBlock":
          break;
        case "Placeholder":
          switch (node.expectedNode) {
            case "Identifier":
            case "StringLiteral":
            case "BlockStatement":
            case "ClassBody":
              break;
            default:
              return false;
          }
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExpression2(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ArrayExpression":
        case "AssignmentExpression":
        case "BinaryExpression":
        case "CallExpression":
        case "ConditionalExpression":
        case "FunctionExpression":
        case "Identifier":
        case "StringLiteral":
        case "NumericLiteral":
        case "NullLiteral":
        case "BooleanLiteral":
        case "RegExpLiteral":
        case "LogicalExpression":
        case "MemberExpression":
        case "NewExpression":
        case "ObjectExpression":
        case "SequenceExpression":
        case "ParenthesizedExpression":
        case "ThisExpression":
        case "UnaryExpression":
        case "UpdateExpression":
        case "ArrowFunctionExpression":
        case "ClassExpression":
        case "ImportExpression":
        case "MetaProperty":
        case "Super":
        case "TaggedTemplateExpression":
        case "TemplateLiteral":
        case "YieldExpression":
        case "AwaitExpression":
        case "Import":
        case "BigIntLiteral":
        case "OptionalMemberExpression":
        case "OptionalCallExpression":
        case "TypeCastExpression":
        case "JSXElement":
        case "JSXFragment":
        case "BindExpression":
        case "DoExpression":
        case "RecordExpression":
        case "TupleExpression":
        case "DecimalLiteral":
        case "ModuleExpression":
        case "TopicReference":
        case "PipelineTopicExpression":
        case "PipelineBareFunction":
        case "PipelinePrimaryTopicReference":
        case "TSInstantiationExpression":
        case "TSAsExpression":
        case "TSSatisfiesExpression":
        case "TSTypeAssertion":
        case "TSNonNullExpression":
          break;
        case "Placeholder":
          switch (node.expectedNode) {
            case "Expression":
            case "Identifier":
            case "StringLiteral":
              break;
            default:
              return false;
          }
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBinary(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "BinaryExpression":
        case "LogicalExpression":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isScopable(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "BlockStatement":
        case "CatchClause":
        case "DoWhileStatement":
        case "ForInStatement":
        case "ForStatement":
        case "FunctionDeclaration":
        case "FunctionExpression":
        case "Program":
        case "ObjectMethod":
        case "SwitchStatement":
        case "WhileStatement":
        case "ArrowFunctionExpression":
        case "ClassExpression":
        case "ClassDeclaration":
        case "ForOfStatement":
        case "ClassMethod":
        case "ClassPrivateMethod":
        case "StaticBlock":
        case "TSModuleBlock":
          break;
        case "Placeholder":
          if (node.expectedNode === "BlockStatement") break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBlockParent(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "BlockStatement":
        case "CatchClause":
        case "DoWhileStatement":
        case "ForInStatement":
        case "ForStatement":
        case "FunctionDeclaration":
        case "FunctionExpression":
        case "Program":
        case "ObjectMethod":
        case "SwitchStatement":
        case "WhileStatement":
        case "ArrowFunctionExpression":
        case "ForOfStatement":
        case "ClassMethod":
        case "ClassPrivateMethod":
        case "StaticBlock":
        case "TSModuleBlock":
          break;
        case "Placeholder":
          if (node.expectedNode === "BlockStatement") break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isBlock(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "BlockStatement":
        case "Program":
        case "TSModuleBlock":
          break;
        case "Placeholder":
          if (node.expectedNode === "BlockStatement") break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isStatement2(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "BlockStatement":
        case "BreakStatement":
        case "ContinueStatement":
        case "DebuggerStatement":
        case "DoWhileStatement":
        case "EmptyStatement":
        case "ExpressionStatement":
        case "ForInStatement":
        case "ForStatement":
        case "FunctionDeclaration":
        case "IfStatement":
        case "LabeledStatement":
        case "ReturnStatement":
        case "SwitchStatement":
        case "ThrowStatement":
        case "TryStatement":
        case "VariableDeclaration":
        case "WhileStatement":
        case "WithStatement":
        case "ClassDeclaration":
        case "ExportAllDeclaration":
        case "ExportDefaultDeclaration":
        case "ExportNamedDeclaration":
        case "ForOfStatement":
        case "ImportDeclaration":
        case "DeclareClass":
        case "DeclareFunction":
        case "DeclareInterface":
        case "DeclareModule":
        case "DeclareModuleExports":
        case "DeclareTypeAlias":
        case "DeclareOpaqueType":
        case "DeclareVariable":
        case "DeclareExportDeclaration":
        case "DeclareExportAllDeclaration":
        case "InterfaceDeclaration":
        case "OpaqueType":
        case "TypeAlias":
        case "EnumDeclaration":
        case "TSDeclareFunction":
        case "TSInterfaceDeclaration":
        case "TSTypeAliasDeclaration":
        case "TSEnumDeclaration":
        case "TSModuleDeclaration":
        case "TSImportEqualsDeclaration":
        case "TSExportAssignment":
        case "TSNamespaceExportDeclaration":
          break;
        case "Placeholder":
          switch (node.expectedNode) {
            case "Statement":
            case "Declaration":
            case "BlockStatement":
              break;
            default:
              return false;
          }
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTerminatorless(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "BreakStatement":
        case "ContinueStatement":
        case "ReturnStatement":
        case "ThrowStatement":
        case "YieldExpression":
        case "AwaitExpression":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isCompletionStatement(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "BreakStatement":
        case "ContinueStatement":
        case "ReturnStatement":
        case "ThrowStatement":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isConditional(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ConditionalExpression":
        case "IfStatement":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isLoop(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "DoWhileStatement":
        case "ForInStatement":
        case "ForStatement":
        case "WhileStatement":
        case "ForOfStatement":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isWhile(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "DoWhileStatement":
        case "WhileStatement":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExpressionWrapper(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ExpressionStatement":
        case "ParenthesizedExpression":
        case "TypeCastExpression":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFor(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ForInStatement":
        case "ForStatement":
        case "ForOfStatement":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isForXStatement(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ForInStatement":
        case "ForOfStatement":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFunction(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "FunctionDeclaration":
        case "FunctionExpression":
        case "ObjectMethod":
        case "ArrowFunctionExpression":
        case "ClassMethod":
        case "ClassPrivateMethod":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFunctionParent(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "FunctionDeclaration":
        case "FunctionExpression":
        case "ObjectMethod":
        case "ArrowFunctionExpression":
        case "ClassMethod":
        case "ClassPrivateMethod":
        case "StaticBlock":
        case "TSModuleBlock":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isPureish(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "FunctionDeclaration":
        case "FunctionExpression":
        case "StringLiteral":
        case "NumericLiteral":
        case "NullLiteral":
        case "BooleanLiteral":
        case "RegExpLiteral":
        case "ArrowFunctionExpression":
        case "BigIntLiteral":
        case "DecimalLiteral":
          break;
        case "Placeholder":
          if (node.expectedNode === "StringLiteral") break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isDeclaration(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "FunctionDeclaration":
        case "VariableDeclaration":
        case "ClassDeclaration":
        case "ExportAllDeclaration":
        case "ExportDefaultDeclaration":
        case "ExportNamedDeclaration":
        case "ImportDeclaration":
        case "DeclareClass":
        case "DeclareFunction":
        case "DeclareInterface":
        case "DeclareModule":
        case "DeclareModuleExports":
        case "DeclareTypeAlias":
        case "DeclareOpaqueType":
        case "DeclareVariable":
        case "DeclareExportDeclaration":
        case "DeclareExportAllDeclaration":
        case "InterfaceDeclaration":
        case "OpaqueType":
        case "TypeAlias":
        case "EnumDeclaration":
        case "TSDeclareFunction":
        case "TSInterfaceDeclaration":
        case "TSTypeAliasDeclaration":
        case "TSEnumDeclaration":
        case "TSModuleDeclaration":
          break;
        case "Placeholder":
          if (node.expectedNode === "Declaration") break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isPatternLike(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "Identifier":
        case "RestElement":
        case "AssignmentPattern":
        case "ArrayPattern":
        case "ObjectPattern":
        case "TSAsExpression":
        case "TSSatisfiesExpression":
        case "TSTypeAssertion":
        case "TSNonNullExpression":
          break;
        case "Placeholder":
          switch (node.expectedNode) {
            case "Pattern":
            case "Identifier":
              break;
            default:
              return false;
          }
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isLVal(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "Identifier":
        case "MemberExpression":
        case "RestElement":
        case "AssignmentPattern":
        case "ArrayPattern":
        case "ObjectPattern":
        case "TSParameterProperty":
        case "TSAsExpression":
        case "TSSatisfiesExpression":
        case "TSTypeAssertion":
        case "TSNonNullExpression":
          break;
        case "Placeholder":
          switch (node.expectedNode) {
            case "Pattern":
            case "Identifier":
              break;
            default:
              return false;
          }
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSEntityName(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "Identifier":
        case "TSQualifiedName":
          break;
        case "Placeholder":
          if (node.expectedNode === "Identifier") break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isLiteral(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "StringLiteral":
        case "NumericLiteral":
        case "NullLiteral":
        case "BooleanLiteral":
        case "RegExpLiteral":
        case "TemplateLiteral":
        case "BigIntLiteral":
        case "DecimalLiteral":
          break;
        case "Placeholder":
          if (node.expectedNode === "StringLiteral") break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isImmutable(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "StringLiteral":
        case "NumericLiteral":
        case "NullLiteral":
        case "BooleanLiteral":
        case "BigIntLiteral":
        case "JSXAttribute":
        case "JSXClosingElement":
        case "JSXElement":
        case "JSXExpressionContainer":
        case "JSXSpreadChild":
        case "JSXOpeningElement":
        case "JSXText":
        case "JSXFragment":
        case "JSXOpeningFragment":
        case "JSXClosingFragment":
        case "DecimalLiteral":
          break;
        case "Placeholder":
          if (node.expectedNode === "StringLiteral") break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isUserWhitespacable(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ObjectMethod":
        case "ObjectProperty":
        case "ObjectTypeInternalSlot":
        case "ObjectTypeCallProperty":
        case "ObjectTypeIndexer":
        case "ObjectTypeProperty":
        case "ObjectTypeSpreadProperty":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isMethod(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ObjectMethod":
        case "ClassMethod":
        case "ClassPrivateMethod":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isObjectMember(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ObjectMethod":
        case "ObjectProperty":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isProperty(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ObjectProperty":
        case "ClassProperty":
        case "ClassAccessorProperty":
        case "ClassPrivateProperty":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isUnaryLike(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "UnaryExpression":
        case "SpreadElement":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isPattern(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "AssignmentPattern":
        case "ArrayPattern":
        case "ObjectPattern":
          break;
        case "Placeholder":
          if (node.expectedNode === "Pattern") break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isClass(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ClassExpression":
        case "ClassDeclaration":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isImportOrExportDeclaration(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ExportAllDeclaration":
        case "ExportDefaultDeclaration":
        case "ExportNamedDeclaration":
        case "ImportDeclaration":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isExportDeclaration(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ExportAllDeclaration":
        case "ExportDefaultDeclaration":
        case "ExportNamedDeclaration":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isModuleSpecifier(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ExportSpecifier":
        case "ImportDefaultSpecifier":
        case "ImportNamespaceSpecifier":
        case "ImportSpecifier":
        case "ExportNamespaceSpecifier":
        case "ExportDefaultSpecifier":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isAccessor(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ClassAccessorProperty":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isPrivate(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "ClassPrivateProperty":
        case "ClassPrivateMethod":
        case "PrivateName":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFlow(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "AnyTypeAnnotation":
        case "ArrayTypeAnnotation":
        case "BooleanTypeAnnotation":
        case "BooleanLiteralTypeAnnotation":
        case "NullLiteralTypeAnnotation":
        case "ClassImplements":
        case "DeclareClass":
        case "DeclareFunction":
        case "DeclareInterface":
        case "DeclareModule":
        case "DeclareModuleExports":
        case "DeclareTypeAlias":
        case "DeclareOpaqueType":
        case "DeclareVariable":
        case "DeclareExportDeclaration":
        case "DeclareExportAllDeclaration":
        case "DeclaredPredicate":
        case "ExistsTypeAnnotation":
        case "FunctionTypeAnnotation":
        case "FunctionTypeParam":
        case "GenericTypeAnnotation":
        case "InferredPredicate":
        case "InterfaceExtends":
        case "InterfaceDeclaration":
        case "InterfaceTypeAnnotation":
        case "IntersectionTypeAnnotation":
        case "MixedTypeAnnotation":
        case "EmptyTypeAnnotation":
        case "NullableTypeAnnotation":
        case "NumberLiteralTypeAnnotation":
        case "NumberTypeAnnotation":
        case "ObjectTypeAnnotation":
        case "ObjectTypeInternalSlot":
        case "ObjectTypeCallProperty":
        case "ObjectTypeIndexer":
        case "ObjectTypeProperty":
        case "ObjectTypeSpreadProperty":
        case "OpaqueType":
        case "QualifiedTypeIdentifier":
        case "StringLiteralTypeAnnotation":
        case "StringTypeAnnotation":
        case "SymbolTypeAnnotation":
        case "ThisTypeAnnotation":
        case "TupleTypeAnnotation":
        case "TypeofTypeAnnotation":
        case "TypeAlias":
        case "TypeAnnotation":
        case "TypeCastExpression":
        case "TypeParameter":
        case "TypeParameterDeclaration":
        case "TypeParameterInstantiation":
        case "UnionTypeAnnotation":
        case "Variance":
        case "VoidTypeAnnotation":
        case "EnumDeclaration":
        case "EnumBooleanBody":
        case "EnumNumberBody":
        case "EnumStringBody":
        case "EnumSymbolBody":
        case "EnumBooleanMember":
        case "EnumNumberMember":
        case "EnumStringMember":
        case "EnumDefaultedMember":
        case "IndexedAccessType":
        case "OptionalIndexedAccessType":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFlowType(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "AnyTypeAnnotation":
        case "ArrayTypeAnnotation":
        case "BooleanTypeAnnotation":
        case "BooleanLiteralTypeAnnotation":
        case "NullLiteralTypeAnnotation":
        case "ExistsTypeAnnotation":
        case "FunctionTypeAnnotation":
        case "GenericTypeAnnotation":
        case "InterfaceTypeAnnotation":
        case "IntersectionTypeAnnotation":
        case "MixedTypeAnnotation":
        case "EmptyTypeAnnotation":
        case "NullableTypeAnnotation":
        case "NumberLiteralTypeAnnotation":
        case "NumberTypeAnnotation":
        case "ObjectTypeAnnotation":
        case "StringLiteralTypeAnnotation":
        case "StringTypeAnnotation":
        case "SymbolTypeAnnotation":
        case "ThisTypeAnnotation":
        case "TupleTypeAnnotation":
        case "TypeofTypeAnnotation":
        case "UnionTypeAnnotation":
        case "VoidTypeAnnotation":
        case "IndexedAccessType":
        case "OptionalIndexedAccessType":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFlowBaseAnnotation(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "AnyTypeAnnotation":
        case "BooleanTypeAnnotation":
        case "NullLiteralTypeAnnotation":
        case "MixedTypeAnnotation":
        case "EmptyTypeAnnotation":
        case "NumberTypeAnnotation":
        case "StringTypeAnnotation":
        case "SymbolTypeAnnotation":
        case "ThisTypeAnnotation":
        case "VoidTypeAnnotation":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFlowDeclaration(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "DeclareClass":
        case "DeclareFunction":
        case "DeclareInterface":
        case "DeclareModule":
        case "DeclareModuleExports":
        case "DeclareTypeAlias":
        case "DeclareOpaqueType":
        case "DeclareVariable":
        case "DeclareExportDeclaration":
        case "DeclareExportAllDeclaration":
        case "InterfaceDeclaration":
        case "OpaqueType":
        case "TypeAlias":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isFlowPredicate(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "DeclaredPredicate":
        case "InferredPredicate":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumBody(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "EnumBooleanBody":
        case "EnumNumberBody":
        case "EnumStringBody":
        case "EnumSymbolBody":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isEnumMember(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "EnumBooleanMember":
        case "EnumNumberMember":
        case "EnumStringMember":
        case "EnumDefaultedMember":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isJSX(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "JSXAttribute":
        case "JSXClosingElement":
        case "JSXElement":
        case "JSXEmptyExpression":
        case "JSXExpressionContainer":
        case "JSXSpreadChild":
        case "JSXIdentifier":
        case "JSXMemberExpression":
        case "JSXNamespacedName":
        case "JSXOpeningElement":
        case "JSXSpreadAttribute":
        case "JSXText":
        case "JSXFragment":
        case "JSXOpeningFragment":
        case "JSXClosingFragment":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isMiscellaneous(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "Noop":
        case "Placeholder":
        case "V8IntrinsicIdentifier":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTypeScript(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "TSParameterProperty":
        case "TSDeclareFunction":
        case "TSDeclareMethod":
        case "TSQualifiedName":
        case "TSCallSignatureDeclaration":
        case "TSConstructSignatureDeclaration":
        case "TSPropertySignature":
        case "TSMethodSignature":
        case "TSIndexSignature":
        case "TSAnyKeyword":
        case "TSBooleanKeyword":
        case "TSBigIntKeyword":
        case "TSIntrinsicKeyword":
        case "TSNeverKeyword":
        case "TSNullKeyword":
        case "TSNumberKeyword":
        case "TSObjectKeyword":
        case "TSStringKeyword":
        case "TSSymbolKeyword":
        case "TSUndefinedKeyword":
        case "TSUnknownKeyword":
        case "TSVoidKeyword":
        case "TSThisType":
        case "TSFunctionType":
        case "TSConstructorType":
        case "TSTypeReference":
        case "TSTypePredicate":
        case "TSTypeQuery":
        case "TSTypeLiteral":
        case "TSArrayType":
        case "TSTupleType":
        case "TSOptionalType":
        case "TSRestType":
        case "TSNamedTupleMember":
        case "TSUnionType":
        case "TSIntersectionType":
        case "TSConditionalType":
        case "TSInferType":
        case "TSParenthesizedType":
        case "TSTypeOperator":
        case "TSIndexedAccessType":
        case "TSMappedType":
        case "TSLiteralType":
        case "TSExpressionWithTypeArguments":
        case "TSInterfaceDeclaration":
        case "TSInterfaceBody":
        case "TSTypeAliasDeclaration":
        case "TSInstantiationExpression":
        case "TSAsExpression":
        case "TSSatisfiesExpression":
        case "TSTypeAssertion":
        case "TSEnumDeclaration":
        case "TSEnumMember":
        case "TSModuleDeclaration":
        case "TSModuleBlock":
        case "TSImportType":
        case "TSImportEqualsDeclaration":
        case "TSExternalModuleReference":
        case "TSNonNullExpression":
        case "TSExportAssignment":
        case "TSNamespaceExportDeclaration":
        case "TSTypeAnnotation":
        case "TSTypeParameterInstantiation":
        case "TSTypeParameterDeclaration":
        case "TSTypeParameter":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSTypeElement(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "TSCallSignatureDeclaration":
        case "TSConstructSignatureDeclaration":
        case "TSPropertySignature":
        case "TSMethodSignature":
        case "TSIndexSignature":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSType2(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "TSAnyKeyword":
        case "TSBooleanKeyword":
        case "TSBigIntKeyword":
        case "TSIntrinsicKeyword":
        case "TSNeverKeyword":
        case "TSNullKeyword":
        case "TSNumberKeyword":
        case "TSObjectKeyword":
        case "TSStringKeyword":
        case "TSSymbolKeyword":
        case "TSUndefinedKeyword":
        case "TSUnknownKeyword":
        case "TSVoidKeyword":
        case "TSThisType":
        case "TSFunctionType":
        case "TSConstructorType":
        case "TSTypeReference":
        case "TSTypePredicate":
        case "TSTypeQuery":
        case "TSTypeLiteral":
        case "TSArrayType":
        case "TSTupleType":
        case "TSOptionalType":
        case "TSRestType":
        case "TSUnionType":
        case "TSIntersectionType":
        case "TSConditionalType":
        case "TSInferType":
        case "TSParenthesizedType":
        case "TSTypeOperator":
        case "TSIndexedAccessType":
        case "TSMappedType":
        case "TSLiteralType":
        case "TSExpressionWithTypeArguments":
        case "TSImportType":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isTSBaseType(node, opts) {
      if (!node) return false;
      switch (node.type) {
        case "TSAnyKeyword":
        case "TSBooleanKeyword":
        case "TSBigIntKeyword":
        case "TSIntrinsicKeyword":
        case "TSNeverKeyword":
        case "TSNullKeyword":
        case "TSNumberKeyword":
        case "TSObjectKeyword":
        case "TSStringKeyword":
        case "TSSymbolKeyword":
        case "TSUndefinedKeyword":
        case "TSUnknownKeyword":
        case "TSVoidKeyword":
        case "TSThisType":
        case "TSLiteralType":
          break;
        default:
          return false;
      }
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isNumberLiteral(node, opts) {
      (0, _deprecationWarning.default)("isNumberLiteral", "isNumericLiteral");
      if (!node) return false;
      if (node.type !== "NumberLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isRegexLiteral(node, opts) {
      (0, _deprecationWarning.default)("isRegexLiteral", "isRegExpLiteral");
      if (!node) return false;
      if (node.type !== "RegexLiteral") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isRestProperty(node, opts) {
      (0, _deprecationWarning.default)("isRestProperty", "isRestElement");
      if (!node) return false;
      if (node.type !== "RestProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isSpreadProperty(node, opts) {
      (0, _deprecationWarning.default)("isSpreadProperty", "isSpreadElement");
      if (!node) return false;
      if (node.type !== "SpreadProperty") return false;
      return opts == null || (0, _shallowEqual.default)(node, opts);
    }
    function isModuleDeclaration(node, opts) {
      (0, _deprecationWarning.default)("isModuleDeclaration", "isImportOrExportDeclaration");
      return isImportOrExportDeclaration(node, opts);
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/matchesPattern.js
var require_matchesPattern = __commonJS({
  "../../node_modules/@babel/types/lib/validators/matchesPattern.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = matchesPattern;
    var _index = require_generated();
    function matchesPattern(member, match, allowPartial) {
      if (!(0, _index.isMemberExpression)(member)) return false;
      const parts = Array.isArray(match) ? match : match.split(".");
      const nodes = [];
      let node;
      for (node = member; (0, _index.isMemberExpression)(node); node = node.object) {
        nodes.push(node.property);
      }
      nodes.push(node);
      if (nodes.length < parts.length) return false;
      if (!allowPartial && nodes.length > parts.length) return false;
      for (let i = 0, j = nodes.length - 1; i < parts.length; i++, j--) {
        const node2 = nodes[j];
        let value;
        if ((0, _index.isIdentifier)(node2)) {
          value = node2.name;
        } else if ((0, _index.isStringLiteral)(node2)) {
          value = node2.value;
        } else if ((0, _index.isThisExpression)(node2)) {
          value = "this";
        } else {
          return false;
        }
        if (parts[i] !== value) return false;
      }
      return true;
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/buildMatchMemberExpression.js
var require_buildMatchMemberExpression = __commonJS({
  "../../node_modules/@babel/types/lib/validators/buildMatchMemberExpression.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = buildMatchMemberExpression;
    var _matchesPattern = require_matchesPattern();
    function buildMatchMemberExpression(match, allowPartial) {
      const parts = match.split(".");
      return (member) => (0, _matchesPattern.default)(member, parts, allowPartial);
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/react/isReactComponent.js
var require_isReactComponent = __commonJS({
  "../../node_modules/@babel/types/lib/validators/react/isReactComponent.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _buildMatchMemberExpression = require_buildMatchMemberExpression();
    var isReactComponent = (0, _buildMatchMemberExpression.default)("React.Component");
    var _default = exports2.default = isReactComponent;
  }
});

// ../../node_modules/@babel/types/lib/validators/react/isCompatTag.js
var require_isCompatTag = __commonJS({
  "../../node_modules/@babel/types/lib/validators/react/isCompatTag.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isCompatTag;
    function isCompatTag(tagName) {
      return !!tagName && /^[a-z]/.test(tagName);
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isType.js
var require_isType = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isType.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isType;
    var _index = require_definitions();
    function isType(nodeType, targetType) {
      if (nodeType === targetType) return true;
      if (nodeType == null) return false;
      if (_index.ALIAS_KEYS[targetType]) return false;
      const aliases = _index.FLIPPED_ALIAS_KEYS[targetType];
      if (aliases) {
        if (aliases[0] === nodeType) return true;
        for (const alias of aliases) {
          if (nodeType === alias) return true;
        }
      }
      return false;
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isPlaceholderType.js
var require_isPlaceholderType = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isPlaceholderType.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isPlaceholderType;
    var _index = require_definitions();
    function isPlaceholderType(placeholderType, targetType) {
      if (placeholderType === targetType) return true;
      const aliases = _index.PLACEHOLDERS_ALIAS[placeholderType];
      if (aliases) {
        for (const alias of aliases) {
          if (targetType === alias) return true;
        }
      }
      return false;
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/is.js
var require_is = __commonJS({
  "../../node_modules/@babel/types/lib/validators/is.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = is;
    var _shallowEqual = require_shallowEqual();
    var _isType = require_isType();
    var _isPlaceholderType = require_isPlaceholderType();
    var _index = require_definitions();
    function is(type, node, opts) {
      if (!node) return false;
      const matches = (0, _isType.default)(node.type, type);
      if (!matches) {
        if (!opts && node.type === "Placeholder" && type in _index.FLIPPED_ALIAS_KEYS) {
          return (0, _isPlaceholderType.default)(node.expectedNode, type);
        }
        return false;
      }
      if (opts === void 0) {
        return true;
      } else {
        return (0, _shallowEqual.default)(node, opts);
      }
    }
  }
});

// ../../node_modules/@babel/helper-validator-identifier/lib/identifier.js
var require_identifier = __commonJS({
  "../../node_modules/@babel/helper-validator-identifier/lib/identifier.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.isIdentifierChar = isIdentifierChar;
    exports2.isIdentifierName = isIdentifierName;
    exports2.isIdentifierStart = isIdentifierStart;
    var nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C8A\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CD\uA7D0\uA7D1\uA7D3\uA7D5-\uA7DC\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
    var nonASCIIidentifierChars = "\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u0897-\u089F\u08CA-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3C\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0CF3\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECE\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u180F-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF-\u1ACE\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DFF\u200C\u200D\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\u30FB\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F\uFF65";
    var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
    var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
    nonASCIIidentifierStartChars = nonASCIIidentifierChars = null;
    var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 4, 51, 13, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 39, 27, 10, 22, 251, 41, 7, 1, 17, 2, 60, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 31, 9, 2, 0, 3, 0, 2, 37, 2, 0, 26, 0, 2, 0, 45, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 200, 32, 32, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 26, 3994, 6, 582, 6842, 29, 1763, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 433, 44, 212, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 42, 9, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 229, 29, 3, 0, 496, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6, 4191];
    var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 7, 9, 32, 4, 318, 1, 80, 3, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 68, 8, 2, 0, 3, 0, 2, 3, 2, 4, 2, 0, 15, 1, 83, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 7, 19, 58, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 343, 9, 54, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 10, 5350, 0, 7, 14, 11465, 27, 2343, 9, 87, 9, 39, 4, 60, 6, 26, 9, 535, 9, 470, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4178, 9, 519, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 245, 1, 2, 9, 726, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
    function isInAstralSet(code, set) {
      let pos = 65536;
      for (let i = 0, length = set.length; i < length; i += 2) {
        pos += set[i];
        if (pos > code) return false;
        pos += set[i + 1];
        if (pos >= code) return true;
      }
      return false;
    }
    function isIdentifierStart(code) {
      if (code < 65) return code === 36;
      if (code <= 90) return true;
      if (code < 97) return code === 95;
      if (code <= 122) return true;
      if (code <= 65535) {
        return code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code));
      }
      return isInAstralSet(code, astralIdentifierStartCodes);
    }
    function isIdentifierChar(code) {
      if (code < 48) return code === 36;
      if (code < 58) return true;
      if (code < 65) return false;
      if (code <= 90) return true;
      if (code < 97) return code === 95;
      if (code <= 122) return true;
      if (code <= 65535) {
        return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
      }
      return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
    }
    function isIdentifierName(name) {
      let isFirst = true;
      for (let i = 0; i < name.length; i++) {
        let cp = name.charCodeAt(i);
        if ((cp & 64512) === 55296 && i + 1 < name.length) {
          const trail = name.charCodeAt(++i);
          if ((trail & 64512) === 56320) {
            cp = 65536 + ((cp & 1023) << 10) + (trail & 1023);
          }
        }
        if (isFirst) {
          isFirst = false;
          if (!isIdentifierStart(cp)) {
            return false;
          }
        } else if (!isIdentifierChar(cp)) {
          return false;
        }
      }
      return !isFirst;
    }
  }
});

// ../../node_modules/@babel/helper-validator-identifier/lib/keyword.js
var require_keyword = __commonJS({
  "../../node_modules/@babel/helper-validator-identifier/lib/keyword.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.isKeyword = isKeyword;
    exports2.isReservedWord = isReservedWord;
    exports2.isStrictBindOnlyReservedWord = isStrictBindOnlyReservedWord;
    exports2.isStrictBindReservedWord = isStrictBindReservedWord;
    exports2.isStrictReservedWord = isStrictReservedWord;
    var reservedWords = {
      keyword: ["break", "case", "catch", "continue", "debugger", "default", "do", "else", "finally", "for", "function", "if", "return", "switch", "throw", "try", "var", "const", "while", "with", "new", "this", "super", "class", "extends", "export", "import", "null", "true", "false", "in", "instanceof", "typeof", "void", "delete"],
      strict: ["implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"],
      strictBind: ["eval", "arguments"]
    };
    var keywords = new Set(reservedWords.keyword);
    var reservedWordsStrictSet = new Set(reservedWords.strict);
    var reservedWordsStrictBindSet = new Set(reservedWords.strictBind);
    function isReservedWord(word, inModule) {
      return inModule && word === "await" || word === "enum";
    }
    function isStrictReservedWord(word, inModule) {
      return isReservedWord(word, inModule) || reservedWordsStrictSet.has(word);
    }
    function isStrictBindOnlyReservedWord(word) {
      return reservedWordsStrictBindSet.has(word);
    }
    function isStrictBindReservedWord(word, inModule) {
      return isStrictReservedWord(word, inModule) || isStrictBindOnlyReservedWord(word);
    }
    function isKeyword(word) {
      return keywords.has(word);
    }
  }
});

// ../../node_modules/@babel/helper-validator-identifier/lib/index.js
var require_lib = __commonJS({
  "../../node_modules/@babel/helper-validator-identifier/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    Object.defineProperty(exports2, "isIdentifierChar", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierChar;
      }
    });
    Object.defineProperty(exports2, "isIdentifierName", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierName;
      }
    });
    Object.defineProperty(exports2, "isIdentifierStart", {
      enumerable: true,
      get: function() {
        return _identifier.isIdentifierStart;
      }
    });
    Object.defineProperty(exports2, "isKeyword", {
      enumerable: true,
      get: function() {
        return _keyword.isKeyword;
      }
    });
    Object.defineProperty(exports2, "isReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isReservedWord;
      }
    });
    Object.defineProperty(exports2, "isStrictBindOnlyReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictBindOnlyReservedWord;
      }
    });
    Object.defineProperty(exports2, "isStrictBindReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictBindReservedWord;
      }
    });
    Object.defineProperty(exports2, "isStrictReservedWord", {
      enumerable: true,
      get: function() {
        return _keyword.isStrictReservedWord;
      }
    });
    var _identifier = require_identifier();
    var _keyword = require_keyword();
  }
});

// ../../node_modules/@babel/types/lib/validators/isValidIdentifier.js
var require_isValidIdentifier = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isValidIdentifier.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isValidIdentifier4;
    var _helperValidatorIdentifier = require_lib();
    function isValidIdentifier4(name, reserved = true) {
      if (typeof name !== "string") return false;
      if (reserved) {
        if ((0, _helperValidatorIdentifier.isKeyword)(name) || (0, _helperValidatorIdentifier.isStrictReservedWord)(name, true)) {
          return false;
        }
      }
      return (0, _helperValidatorIdentifier.isIdentifierName)(name);
    }
  }
});

// ../../node_modules/@babel/helper-string-parser/lib/index.js
var require_lib2 = __commonJS({
  "../../node_modules/@babel/helper-string-parser/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.readCodePoint = readCodePoint;
    exports2.readInt = readInt;
    exports2.readStringContents = readStringContents;
    var _isDigit = function isDigit(code) {
      return code >= 48 && code <= 57;
    };
    var forbiddenNumericSeparatorSiblings = {
      decBinOct: /* @__PURE__ */ new Set([46, 66, 69, 79, 95, 98, 101, 111]),
      hex: /* @__PURE__ */ new Set([46, 88, 95, 120])
    };
    var isAllowedNumericSeparatorSibling = {
      bin: (ch) => ch === 48 || ch === 49,
      oct: (ch) => ch >= 48 && ch <= 55,
      dec: (ch) => ch >= 48 && ch <= 57,
      hex: (ch) => ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102
    };
    function readStringContents(type, input, pos, lineStart, curLine, errors) {
      const initialPos = pos;
      const initialLineStart = lineStart;
      const initialCurLine = curLine;
      let out = "";
      let firstInvalidLoc = null;
      let chunkStart = pos;
      const {
        length
      } = input;
      for (; ; ) {
        if (pos >= length) {
          errors.unterminated(initialPos, initialLineStart, initialCurLine);
          out += input.slice(chunkStart, pos);
          break;
        }
        const ch = input.charCodeAt(pos);
        if (isStringEnd(type, ch, input, pos)) {
          out += input.slice(chunkStart, pos);
          break;
        }
        if (ch === 92) {
          out += input.slice(chunkStart, pos);
          const res = readEscapedChar(input, pos, lineStart, curLine, type === "template", errors);
          if (res.ch === null && !firstInvalidLoc) {
            firstInvalidLoc = {
              pos,
              lineStart,
              curLine
            };
          } else {
            out += res.ch;
          }
          ({
            pos,
            lineStart,
            curLine
          } = res);
          chunkStart = pos;
        } else if (ch === 8232 || ch === 8233) {
          ++pos;
          ++curLine;
          lineStart = pos;
        } else if (ch === 10 || ch === 13) {
          if (type === "template") {
            out += input.slice(chunkStart, pos) + "\n";
            ++pos;
            if (ch === 13 && input.charCodeAt(pos) === 10) {
              ++pos;
            }
            ++curLine;
            chunkStart = lineStart = pos;
          } else {
            errors.unterminated(initialPos, initialLineStart, initialCurLine);
          }
        } else {
          ++pos;
        }
      }
      return {
        pos,
        str: out,
        firstInvalidLoc,
        lineStart,
        curLine,
        containsInvalid: !!firstInvalidLoc
      };
    }
    function isStringEnd(type, ch, input, pos) {
      if (type === "template") {
        return ch === 96 || ch === 36 && input.charCodeAt(pos + 1) === 123;
      }
      return ch === (type === "double" ? 34 : 39);
    }
    function readEscapedChar(input, pos, lineStart, curLine, inTemplate, errors) {
      const throwOnInvalid = !inTemplate;
      pos++;
      const res = (ch2) => ({
        pos,
        ch: ch2,
        lineStart,
        curLine
      });
      const ch = input.charCodeAt(pos++);
      switch (ch) {
        case 110:
          return res("\n");
        case 114:
          return res("\r");
        case 120: {
          let code;
          ({
            code,
            pos
          } = readHexChar(input, pos, lineStart, curLine, 2, false, throwOnInvalid, errors));
          return res(code === null ? null : String.fromCharCode(code));
        }
        case 117: {
          let code;
          ({
            code,
            pos
          } = readCodePoint(input, pos, lineStart, curLine, throwOnInvalid, errors));
          return res(code === null ? null : String.fromCodePoint(code));
        }
        case 116:
          return res("	");
        case 98:
          return res("\b");
        case 118:
          return res("\v");
        case 102:
          return res("\f");
        case 13:
          if (input.charCodeAt(pos) === 10) {
            ++pos;
          }
        case 10:
          lineStart = pos;
          ++curLine;
        case 8232:
        case 8233:
          return res("");
        case 56:
        case 57:
          if (inTemplate) {
            return res(null);
          } else {
            errors.strictNumericEscape(pos - 1, lineStart, curLine);
          }
        default:
          if (ch >= 48 && ch <= 55) {
            const startPos = pos - 1;
            const match = /^[0-7]+/.exec(input.slice(startPos, pos + 2));
            let octalStr = match[0];
            let octal = parseInt(octalStr, 8);
            if (octal > 255) {
              octalStr = octalStr.slice(0, -1);
              octal = parseInt(octalStr, 8);
            }
            pos += octalStr.length - 1;
            const next = input.charCodeAt(pos);
            if (octalStr !== "0" || next === 56 || next === 57) {
              if (inTemplate) {
                return res(null);
              } else {
                errors.strictNumericEscape(startPos, lineStart, curLine);
              }
            }
            return res(String.fromCharCode(octal));
          }
          return res(String.fromCharCode(ch));
      }
    }
    function readHexChar(input, pos, lineStart, curLine, len, forceLen, throwOnInvalid, errors) {
      const initialPos = pos;
      let n;
      ({
        n,
        pos
      } = readInt(input, pos, lineStart, curLine, 16, len, forceLen, false, errors, !throwOnInvalid));
      if (n === null) {
        if (throwOnInvalid) {
          errors.invalidEscapeSequence(initialPos, lineStart, curLine);
        } else {
          pos = initialPos - 1;
        }
      }
      return {
        code: n,
        pos
      };
    }
    function readInt(input, pos, lineStart, curLine, radix, len, forceLen, allowNumSeparator, errors, bailOnError) {
      const start = pos;
      const forbiddenSiblings = radix === 16 ? forbiddenNumericSeparatorSiblings.hex : forbiddenNumericSeparatorSiblings.decBinOct;
      const isAllowedSibling = radix === 16 ? isAllowedNumericSeparatorSibling.hex : radix === 10 ? isAllowedNumericSeparatorSibling.dec : radix === 8 ? isAllowedNumericSeparatorSibling.oct : isAllowedNumericSeparatorSibling.bin;
      let invalid = false;
      let total = 0;
      for (let i = 0, e = len == null ? Infinity : len; i < e; ++i) {
        const code = input.charCodeAt(pos);
        let val;
        if (code === 95 && allowNumSeparator !== "bail") {
          const prev = input.charCodeAt(pos - 1);
          const next = input.charCodeAt(pos + 1);
          if (!allowNumSeparator) {
            if (bailOnError) return {
              n: null,
              pos
            };
            errors.numericSeparatorInEscapeSequence(pos, lineStart, curLine);
          } else if (Number.isNaN(next) || !isAllowedSibling(next) || forbiddenSiblings.has(prev) || forbiddenSiblings.has(next)) {
            if (bailOnError) return {
              n: null,
              pos
            };
            errors.unexpectedNumericSeparator(pos, lineStart, curLine);
          }
          ++pos;
          continue;
        }
        if (code >= 97) {
          val = code - 97 + 10;
        } else if (code >= 65) {
          val = code - 65 + 10;
        } else if (_isDigit(code)) {
          val = code - 48;
        } else {
          val = Infinity;
        }
        if (val >= radix) {
          if (val <= 9 && bailOnError) {
            return {
              n: null,
              pos
            };
          } else if (val <= 9 && errors.invalidDigit(pos, lineStart, curLine, radix)) {
            val = 0;
          } else if (forceLen) {
            val = 0;
            invalid = true;
          } else {
            break;
          }
        }
        ++pos;
        total = total * radix + val;
      }
      if (pos === start || len != null && pos - start !== len || invalid) {
        return {
          n: null,
          pos
        };
      }
      return {
        n: total,
        pos
      };
    }
    function readCodePoint(input, pos, lineStart, curLine, throwOnInvalid, errors) {
      const ch = input.charCodeAt(pos);
      let code;
      if (ch === 123) {
        ++pos;
        ({
          code,
          pos
        } = readHexChar(input, pos, lineStart, curLine, input.indexOf("}", pos) - pos, true, throwOnInvalid, errors));
        ++pos;
        if (code !== null && code > 1114111) {
          if (throwOnInvalid) {
            errors.invalidCodePoint(pos, lineStart, curLine);
          } else {
            return {
              code: null,
              pos
            };
          }
        }
      } else {
        ({
          code,
          pos
        } = readHexChar(input, pos, lineStart, curLine, 4, false, throwOnInvalid, errors));
      }
      return {
        code,
        pos
      };
    }
  }
});

// ../../node_modules/@babel/types/lib/constants/index.js
var require_constants = __commonJS({
  "../../node_modules/@babel/types/lib/constants/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.UPDATE_OPERATORS = exports2.UNARY_OPERATORS = exports2.STRING_UNARY_OPERATORS = exports2.STATEMENT_OR_BLOCK_KEYS = exports2.NUMBER_UNARY_OPERATORS = exports2.NUMBER_BINARY_OPERATORS = exports2.NOT_LOCAL_BINDING = exports2.LOGICAL_OPERATORS = exports2.INHERIT_KEYS = exports2.FOR_INIT_KEYS = exports2.FLATTENABLE_KEYS = exports2.EQUALITY_BINARY_OPERATORS = exports2.COMPARISON_BINARY_OPERATORS = exports2.COMMENT_KEYS = exports2.BOOLEAN_UNARY_OPERATORS = exports2.BOOLEAN_NUMBER_BINARY_OPERATORS = exports2.BOOLEAN_BINARY_OPERATORS = exports2.BLOCK_SCOPED_SYMBOL = exports2.BINARY_OPERATORS = exports2.ASSIGNMENT_OPERATORS = void 0;
    var STATEMENT_OR_BLOCK_KEYS = exports2.STATEMENT_OR_BLOCK_KEYS = ["consequent", "body", "alternate"];
    var FLATTENABLE_KEYS = exports2.FLATTENABLE_KEYS = ["body", "expressions"];
    var FOR_INIT_KEYS = exports2.FOR_INIT_KEYS = ["left", "init"];
    var COMMENT_KEYS = exports2.COMMENT_KEYS = ["leadingComments", "trailingComments", "innerComments"];
    var LOGICAL_OPERATORS = exports2.LOGICAL_OPERATORS = ["||", "&&", "??"];
    var UPDATE_OPERATORS = exports2.UPDATE_OPERATORS = ["++", "--"];
    var BOOLEAN_NUMBER_BINARY_OPERATORS = exports2.BOOLEAN_NUMBER_BINARY_OPERATORS = [">", "<", ">=", "<="];
    var EQUALITY_BINARY_OPERATORS = exports2.EQUALITY_BINARY_OPERATORS = ["==", "===", "!=", "!=="];
    var COMPARISON_BINARY_OPERATORS = exports2.COMPARISON_BINARY_OPERATORS = [...EQUALITY_BINARY_OPERATORS, "in", "instanceof"];
    var BOOLEAN_BINARY_OPERATORS = exports2.BOOLEAN_BINARY_OPERATORS = [...COMPARISON_BINARY_OPERATORS, ...BOOLEAN_NUMBER_BINARY_OPERATORS];
    var NUMBER_BINARY_OPERATORS = exports2.NUMBER_BINARY_OPERATORS = ["-", "/", "%", "*", "**", "&", "|", ">>", ">>>", "<<", "^"];
    var BINARY_OPERATORS = exports2.BINARY_OPERATORS = ["+", ...NUMBER_BINARY_OPERATORS, ...BOOLEAN_BINARY_OPERATORS, "|>"];
    var ASSIGNMENT_OPERATORS = exports2.ASSIGNMENT_OPERATORS = ["=", "+=", ...NUMBER_BINARY_OPERATORS.map((op) => op + "="), ...LOGICAL_OPERATORS.map((op) => op + "=")];
    var BOOLEAN_UNARY_OPERATORS = exports2.BOOLEAN_UNARY_OPERATORS = ["delete", "!"];
    var NUMBER_UNARY_OPERATORS = exports2.NUMBER_UNARY_OPERATORS = ["+", "-", "~"];
    var STRING_UNARY_OPERATORS = exports2.STRING_UNARY_OPERATORS = ["typeof"];
    var UNARY_OPERATORS = exports2.UNARY_OPERATORS = ["void", "throw", ...BOOLEAN_UNARY_OPERATORS, ...NUMBER_UNARY_OPERATORS, ...STRING_UNARY_OPERATORS];
    var INHERIT_KEYS = exports2.INHERIT_KEYS = {
      optional: ["typeAnnotation", "typeParameters", "returnType"],
      force: ["start", "loc", "end"]
    };
    var BLOCK_SCOPED_SYMBOL = exports2.BLOCK_SCOPED_SYMBOL = Symbol.for("var used to be block scoped");
    var NOT_LOCAL_BINDING = exports2.NOT_LOCAL_BINDING = Symbol.for("should not be considered a local binding");
  }
});

// ../../node_modules/@babel/types/lib/definitions/utils.js
var require_utils = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.VISITOR_KEYS = exports2.NODE_PARENT_VALIDATIONS = exports2.NODE_FIELDS = exports2.FLIPPED_ALIAS_KEYS = exports2.DEPRECATED_KEYS = exports2.BUILDER_KEYS = exports2.ALIAS_KEYS = void 0;
    exports2.arrayOf = arrayOf;
    exports2.arrayOfType = arrayOfType;
    exports2.assertEach = assertEach;
    exports2.assertNodeOrValueType = assertNodeOrValueType;
    exports2.assertNodeType = assertNodeType;
    exports2.assertOneOf = assertOneOf;
    exports2.assertOptionalChainStart = assertOptionalChainStart;
    exports2.assertShape = assertShape;
    exports2.assertValueType = assertValueType;
    exports2.chain = chain;
    exports2.default = defineType;
    exports2.defineAliasedType = defineAliasedType;
    exports2.validate = validate2;
    exports2.validateArrayOfType = validateArrayOfType;
    exports2.validateOptional = validateOptional;
    exports2.validateOptionalType = validateOptionalType;
    exports2.validateType = validateType;
    var _is = require_is();
    var _validate = require_validate();
    var VISITOR_KEYS = exports2.VISITOR_KEYS = {};
    var ALIAS_KEYS = exports2.ALIAS_KEYS = {};
    var FLIPPED_ALIAS_KEYS = exports2.FLIPPED_ALIAS_KEYS = {};
    var NODE_FIELDS = exports2.NODE_FIELDS = {};
    var BUILDER_KEYS = exports2.BUILDER_KEYS = {};
    var DEPRECATED_KEYS = exports2.DEPRECATED_KEYS = {};
    var NODE_PARENT_VALIDATIONS = exports2.NODE_PARENT_VALIDATIONS = {};
    function getType(val) {
      if (Array.isArray(val)) {
        return "array";
      } else if (val === null) {
        return "null";
      } else {
        return typeof val;
      }
    }
    function validate2(validate3) {
      return {
        validate: validate3
      };
    }
    function validateType(...typeNames) {
      return validate2(assertNodeType(...typeNames));
    }
    function validateOptional(validate3) {
      return {
        validate: validate3,
        optional: true
      };
    }
    function validateOptionalType(...typeNames) {
      return {
        validate: assertNodeType(...typeNames),
        optional: true
      };
    }
    function arrayOf(elementType) {
      return chain(assertValueType("array"), assertEach(elementType));
    }
    function arrayOfType(...typeNames) {
      return arrayOf(assertNodeType(...typeNames));
    }
    function validateArrayOfType(...typeNames) {
      return validate2(arrayOfType(...typeNames));
    }
    function assertEach(callback) {
      const childValidator = process.env.BABEL_TYPES_8_BREAKING ? _validate.validateChild : () => {
      };
      function validator(node, key, val) {
        if (!Array.isArray(val)) return;
        for (let i = 0; i < val.length; i++) {
          const subkey = `${key}[${i}]`;
          const v = val[i];
          callback(node, subkey, v);
          childValidator(node, subkey, v);
        }
      }
      validator.each = callback;
      return validator;
    }
    function assertOneOf(...values) {
      function validate3(node, key, val) {
        if (!values.includes(val)) {
          throw new TypeError(`Property ${key} expected value to be one of ${JSON.stringify(values)} but got ${JSON.stringify(val)}`);
        }
      }
      validate3.oneOf = values;
      return validate3;
    }
    function assertNodeType(...types) {
      function validate3(node, key, val) {
        for (const type of types) {
          if ((0, _is.default)(type, val)) {
            (0, _validate.validateChild)(node, key, val);
            return;
          }
        }
        throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} but instead got ${JSON.stringify(val == null ? void 0 : val.type)}`);
      }
      validate3.oneOfNodeTypes = types;
      return validate3;
    }
    function assertNodeOrValueType(...types) {
      function validate3(node, key, val) {
        for (const type of types) {
          if (getType(val) === type || (0, _is.default)(type, val)) {
            (0, _validate.validateChild)(node, key, val);
            return;
          }
        }
        throw new TypeError(`Property ${key} of ${node.type} expected node to be of a type ${JSON.stringify(types)} but instead got ${JSON.stringify(val == null ? void 0 : val.type)}`);
      }
      validate3.oneOfNodeOrValueTypes = types;
      return validate3;
    }
    function assertValueType(type) {
      function validate3(node, key, val) {
        const valid = getType(val) === type;
        if (!valid) {
          throw new TypeError(`Property ${key} expected type of ${type} but got ${getType(val)}`);
        }
      }
      validate3.type = type;
      return validate3;
    }
    function assertShape(shape) {
      function validate3(node, key, val) {
        const errors = [];
        for (const property of Object.keys(shape)) {
          try {
            (0, _validate.validateField)(node, property, val[property], shape[property]);
          } catch (error) {
            if (error instanceof TypeError) {
              errors.push(error.message);
              continue;
            }
            throw error;
          }
        }
        if (errors.length) {
          throw new TypeError(`Property ${key} of ${node.type} expected to have the following:
${errors.join("\n")}`);
        }
      }
      validate3.shapeOf = shape;
      return validate3;
    }
    function assertOptionalChainStart() {
      function validate3(node) {
        var _current3;
        let current = node;
        while (node) {
          const {
            type
          } = current;
          if (type === "OptionalCallExpression") {
            if (current.optional) return;
            current = current.callee;
            continue;
          }
          if (type === "OptionalMemberExpression") {
            if (current.optional) return;
            current = current.object;
            continue;
          }
          break;
        }
        throw new TypeError(`Non-optional ${node.type} must chain from an optional OptionalMemberExpression or OptionalCallExpression. Found chain from ${(_current3 = current) == null ? void 0 : _current3.type}`);
      }
      return validate3;
    }
    function chain(...fns) {
      function validate3(...args) {
        for (const fn of fns) {
          fn(...args);
        }
      }
      validate3.chainOf = fns;
      if (fns.length >= 2 && "type" in fns[0] && fns[0].type === "array" && !("each" in fns[1])) {
        throw new Error(`An assertValueType("array") validator can only be followed by an assertEach(...) validator.`);
      }
      return validate3;
    }
    var validTypeOpts = /* @__PURE__ */ new Set(["aliases", "builder", "deprecatedAlias", "fields", "inherits", "visitor", "validate"]);
    var validFieldKeys = /* @__PURE__ */ new Set(["default", "optional", "deprecated", "validate"]);
    var store = {};
    function defineAliasedType(...aliases) {
      return (type, opts = {}) => {
        let defined = opts.aliases;
        if (!defined) {
          var _store$opts$inherits$, _defined;
          if (opts.inherits) defined = (_store$opts$inherits$ = store[opts.inherits].aliases) == null ? void 0 : _store$opts$inherits$.slice();
          (_defined = defined) != null ? _defined : defined = [];
          opts.aliases = defined;
        }
        const additional = aliases.filter((a) => !defined.includes(a));
        defined.unshift(...additional);
        defineType(type, opts);
      };
    }
    function defineType(type, opts = {}) {
      const inherits = opts.inherits && store[opts.inherits] || {};
      let fields = opts.fields;
      if (!fields) {
        fields = {};
        if (inherits.fields) {
          const keys = Object.getOwnPropertyNames(inherits.fields);
          for (const key of keys) {
            const field = inherits.fields[key];
            const def = field.default;
            if (Array.isArray(def) ? def.length > 0 : def && typeof def === "object") {
              throw new Error("field defaults can only be primitives or empty arrays currently");
            }
            fields[key] = {
              default: Array.isArray(def) ? [] : def,
              optional: field.optional,
              deprecated: field.deprecated,
              validate: field.validate
            };
          }
        }
      }
      const visitor = opts.visitor || inherits.visitor || [];
      const aliases = opts.aliases || inherits.aliases || [];
      const builder = opts.builder || inherits.builder || opts.visitor || [];
      for (const k of Object.keys(opts)) {
        if (!validTypeOpts.has(k)) {
          throw new Error(`Unknown type option "${k}" on ${type}`);
        }
      }
      if (opts.deprecatedAlias) {
        DEPRECATED_KEYS[opts.deprecatedAlias] = type;
      }
      for (const key of visitor.concat(builder)) {
        fields[key] = fields[key] || {};
      }
      for (const key of Object.keys(fields)) {
        const field = fields[key];
        if (field.default !== void 0 && !builder.includes(key)) {
          field.optional = true;
        }
        if (field.default === void 0) {
          field.default = null;
        } else if (!field.validate && field.default != null) {
          field.validate = assertValueType(getType(field.default));
        }
        for (const k of Object.keys(field)) {
          if (!validFieldKeys.has(k)) {
            throw new Error(`Unknown field key "${k}" on ${type}.${key}`);
          }
        }
      }
      VISITOR_KEYS[type] = opts.visitor = visitor;
      BUILDER_KEYS[type] = opts.builder = builder;
      NODE_FIELDS[type] = opts.fields = fields;
      ALIAS_KEYS[type] = opts.aliases = aliases;
      aliases.forEach((alias) => {
        FLIPPED_ALIAS_KEYS[alias] = FLIPPED_ALIAS_KEYS[alias] || [];
        FLIPPED_ALIAS_KEYS[alias].push(type);
      });
      if (opts.validate) {
        NODE_PARENT_VALIDATIONS[type] = opts.validate;
      }
      store[type] = opts;
    }
  }
});

// ../../node_modules/@babel/types/lib/definitions/core.js
var require_core = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/core.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.patternLikeCommon = exports2.importAttributes = exports2.functionTypeAnnotationCommon = exports2.functionDeclarationCommon = exports2.functionCommon = exports2.classMethodOrPropertyCommon = exports2.classMethodOrDeclareMethodCommon = void 0;
    var _is = require_is();
    var _isValidIdentifier = require_isValidIdentifier();
    var _helperValidatorIdentifier = require_lib();
    var _helperStringParser = require_lib2();
    var _index = require_constants();
    var _utils = require_utils();
    var defineType = (0, _utils.defineAliasedType)("Standardized");
    defineType("ArrayExpression", {
      fields: {
        elements: {
          validate: (0, _utils.arrayOf)((0, _utils.assertNodeOrValueType)("null", "Expression", "SpreadElement")),
          default: !process.env.BABEL_TYPES_8_BREAKING ? [] : void 0
        }
      },
      visitor: ["elements"],
      aliases: ["Expression"]
    });
    defineType("AssignmentExpression", {
      fields: {
        operator: {
          validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertValueType)("string") : Object.assign(function() {
            const identifier4 = (0, _utils.assertOneOf)(..._index.ASSIGNMENT_OPERATORS);
            const pattern = (0, _utils.assertOneOf)("=");
            return function(node, key, val) {
              const validator = (0, _is.default)("Pattern", node.left) ? pattern : identifier4;
              validator(node, key, val);
            };
          }(), {
            type: "string"
          })
        },
        left: {
          validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("LVal", "OptionalMemberExpression") : (0, _utils.assertNodeType)("Identifier", "MemberExpression", "OptionalMemberExpression", "ArrayPattern", "ObjectPattern", "TSAsExpression", "TSSatisfiesExpression", "TSTypeAssertion", "TSNonNullExpression")
        },
        right: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      },
      builder: ["operator", "left", "right"],
      visitor: ["left", "right"],
      aliases: ["Expression"]
    });
    defineType("BinaryExpression", {
      builder: ["operator", "left", "right"],
      fields: {
        operator: {
          validate: (0, _utils.assertOneOf)(..._index.BINARY_OPERATORS)
        },
        left: {
          validate: function() {
            const expression = (0, _utils.assertNodeType)("Expression");
            const inOp = (0, _utils.assertNodeType)("Expression", "PrivateName");
            const validator = Object.assign(function(node, key, val) {
              const validator2 = node.operator === "in" ? inOp : expression;
              validator2(node, key, val);
            }, {
              oneOfNodeTypes: ["Expression", "PrivateName"]
            });
            return validator;
          }()
        },
        right: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      },
      visitor: ["left", "right"],
      aliases: ["Binary", "Expression"]
    });
    defineType("InterpreterDirective", {
      builder: ["value"],
      fields: {
        value: {
          validate: (0, _utils.assertValueType)("string")
        }
      }
    });
    defineType("Directive", {
      visitor: ["value"],
      fields: {
        value: {
          validate: (0, _utils.assertNodeType)("DirectiveLiteral")
        }
      }
    });
    defineType("DirectiveLiteral", {
      builder: ["value"],
      fields: {
        value: {
          validate: (0, _utils.assertValueType)("string")
        }
      }
    });
    defineType("BlockStatement", {
      builder: ["body", "directives"],
      visitor: ["directives", "body"],
      fields: {
        directives: {
          validate: (0, _utils.arrayOfType)("Directive"),
          default: []
        },
        body: (0, _utils.validateArrayOfType)("Statement")
      },
      aliases: ["Scopable", "BlockParent", "Block", "Statement"]
    });
    defineType("BreakStatement", {
      visitor: ["label"],
      fields: {
        label: {
          validate: (0, _utils.assertNodeType)("Identifier"),
          optional: true
        }
      },
      aliases: ["Statement", "Terminatorless", "CompletionStatement"]
    });
    defineType("CallExpression", {
      visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
      builder: ["callee", "arguments"],
      aliases: ["Expression"],
      fields: Object.assign({
        callee: {
          validate: (0, _utils.assertNodeType)("Expression", "Super", "V8IntrinsicIdentifier")
        },
        arguments: (0, _utils.validateArrayOfType)("Expression", "SpreadElement", "ArgumentPlaceholder")
      }, !process.env.BABEL_TYPES_8_BREAKING ? {
        optional: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        }
      } : {}, {
        typeArguments: {
          validate: (0, _utils.assertNodeType)("TypeParameterInstantiation"),
          optional: true
        },
        typeParameters: {
          validate: (0, _utils.assertNodeType)("TSTypeParameterInstantiation"),
          optional: true
        }
      })
    });
    defineType("CatchClause", {
      visitor: ["param", "body"],
      fields: {
        param: {
          validate: (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern"),
          optional: true
        },
        body: {
          validate: (0, _utils.assertNodeType)("BlockStatement")
        }
      },
      aliases: ["Scopable", "BlockParent"]
    });
    defineType("ConditionalExpression", {
      visitor: ["test", "consequent", "alternate"],
      fields: {
        test: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        consequent: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        alternate: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      },
      aliases: ["Expression", "Conditional"]
    });
    defineType("ContinueStatement", {
      visitor: ["label"],
      fields: {
        label: {
          validate: (0, _utils.assertNodeType)("Identifier"),
          optional: true
        }
      },
      aliases: ["Statement", "Terminatorless", "CompletionStatement"]
    });
    defineType("DebuggerStatement", {
      aliases: ["Statement"]
    });
    defineType("DoWhileStatement", {
      builder: ["test", "body"],
      visitor: ["body", "test"],
      fields: {
        test: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        body: {
          validate: (0, _utils.assertNodeType)("Statement")
        }
      },
      aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"]
    });
    defineType("EmptyStatement", {
      aliases: ["Statement"]
    });
    defineType("ExpressionStatement", {
      visitor: ["expression"],
      fields: {
        expression: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      },
      aliases: ["Statement", "ExpressionWrapper"]
    });
    defineType("File", {
      builder: ["program", "comments", "tokens"],
      visitor: ["program"],
      fields: {
        program: {
          validate: (0, _utils.assertNodeType)("Program")
        },
        comments: {
          validate: !process.env.BABEL_TYPES_8_BREAKING ? Object.assign(() => {
          }, {
            each: {
              oneOfNodeTypes: ["CommentBlock", "CommentLine"]
            }
          }) : (0, _utils.assertEach)((0, _utils.assertNodeType)("CommentBlock", "CommentLine")),
          optional: true
        },
        tokens: {
          validate: (0, _utils.assertEach)(Object.assign(() => {
          }, {
            type: "any"
          })),
          optional: true
        }
      }
    });
    defineType("ForInStatement", {
      visitor: ["left", "right", "body"],
      aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
      fields: {
        left: {
          validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("VariableDeclaration", "LVal") : (0, _utils.assertNodeType)("VariableDeclaration", "Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern", "TSAsExpression", "TSSatisfiesExpression", "TSTypeAssertion", "TSNonNullExpression")
        },
        right: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        body: {
          validate: (0, _utils.assertNodeType)("Statement")
        }
      }
    });
    defineType("ForStatement", {
      visitor: ["init", "test", "update", "body"],
      aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop"],
      fields: {
        init: {
          validate: (0, _utils.assertNodeType)("VariableDeclaration", "Expression"),
          optional: true
        },
        test: {
          validate: (0, _utils.assertNodeType)("Expression"),
          optional: true
        },
        update: {
          validate: (0, _utils.assertNodeType)("Expression"),
          optional: true
        },
        body: {
          validate: (0, _utils.assertNodeType)("Statement")
        }
      }
    });
    var functionCommon = () => ({
      params: (0, _utils.validateArrayOfType)("Identifier", "Pattern", "RestElement"),
      generator: {
        default: false
      },
      async: {
        default: false
      }
    });
    exports2.functionCommon = functionCommon;
    var functionTypeAnnotationCommon = () => ({
      returnType: {
        validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
        optional: true
      },
      typeParameters: {
        validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
        optional: true
      }
    });
    exports2.functionTypeAnnotationCommon = functionTypeAnnotationCommon;
    var functionDeclarationCommon = () => Object.assign({}, functionCommon(), {
      declare: {
        validate: (0, _utils.assertValueType)("boolean"),
        optional: true
      },
      id: {
        validate: (0, _utils.assertNodeType)("Identifier"),
        optional: true
      }
    });
    exports2.functionDeclarationCommon = functionDeclarationCommon;
    defineType("FunctionDeclaration", {
      builder: ["id", "params", "body", "generator", "async"],
      visitor: ["id", "typeParameters", "params", "returnType", "body"],
      fields: Object.assign({}, functionDeclarationCommon(), functionTypeAnnotationCommon(), {
        body: {
          validate: (0, _utils.assertNodeType)("BlockStatement")
        },
        predicate: {
          validate: (0, _utils.assertNodeType)("DeclaredPredicate", "InferredPredicate"),
          optional: true
        }
      }),
      aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Statement", "Pureish", "Declaration"],
      validate: !process.env.BABEL_TYPES_8_BREAKING ? void 0 : function() {
        const identifier4 = (0, _utils.assertNodeType)("Identifier");
        return function(parent, key, node) {
          if (!(0, _is.default)("ExportDefaultDeclaration", parent)) {
            identifier4(node, "id", node.id);
          }
        };
      }()
    });
    defineType("FunctionExpression", {
      inherits: "FunctionDeclaration",
      aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
      fields: Object.assign({}, functionCommon(), functionTypeAnnotationCommon(), {
        id: {
          validate: (0, _utils.assertNodeType)("Identifier"),
          optional: true
        },
        body: {
          validate: (0, _utils.assertNodeType)("BlockStatement")
        },
        predicate: {
          validate: (0, _utils.assertNodeType)("DeclaredPredicate", "InferredPredicate"),
          optional: true
        }
      })
    });
    var patternLikeCommon = () => ({
      typeAnnotation: {
        validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
        optional: true
      },
      optional: {
        validate: (0, _utils.assertValueType)("boolean"),
        optional: true
      },
      decorators: {
        validate: (0, _utils.arrayOfType)("Decorator"),
        optional: true
      }
    });
    exports2.patternLikeCommon = patternLikeCommon;
    defineType("Identifier", {
      builder: ["name"],
      visitor: ["typeAnnotation", "decorators"],
      aliases: ["Expression", "PatternLike", "LVal", "TSEntityName"],
      fields: Object.assign({}, patternLikeCommon(), {
        name: {
          validate: process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.chain)((0, _utils.assertValueType)("string"), Object.assign(function(node, key, val) {
            if (!(0, _isValidIdentifier.default)(val, false)) {
              throw new TypeError(`"${val}" is not a valid identifier name`);
            }
          }, {
            type: "string"
          })) : (0, _utils.assertValueType)("string")
        }
      }),
      validate: process.env.BABEL_TYPES_8_BREAKING ? function(parent, key, node) {
        const match = /\.(\w+)$/.exec(key);
        if (!match) return;
        const [, parentKey] = match;
        const nonComp = {
          computed: false
        };
        if (parentKey === "property") {
          if ((0, _is.default)("MemberExpression", parent, nonComp)) return;
          if ((0, _is.default)("OptionalMemberExpression", parent, nonComp)) return;
        } else if (parentKey === "key") {
          if ((0, _is.default)("Property", parent, nonComp)) return;
          if ((0, _is.default)("Method", parent, nonComp)) return;
        } else if (parentKey === "exported") {
          if ((0, _is.default)("ExportSpecifier", parent)) return;
        } else if (parentKey === "imported") {
          if ((0, _is.default)("ImportSpecifier", parent, {
            imported: node
          })) return;
        } else if (parentKey === "meta") {
          if ((0, _is.default)("MetaProperty", parent, {
            meta: node
          })) return;
        }
        if (((0, _helperValidatorIdentifier.isKeyword)(node.name) || (0, _helperValidatorIdentifier.isReservedWord)(node.name, false)) && node.name !== "this") {
          throw new TypeError(`"${node.name}" is not a valid identifier`);
        }
      } : void 0
    });
    defineType("IfStatement", {
      visitor: ["test", "consequent", "alternate"],
      aliases: ["Statement", "Conditional"],
      fields: {
        test: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        consequent: {
          validate: (0, _utils.assertNodeType)("Statement")
        },
        alternate: {
          optional: true,
          validate: (0, _utils.assertNodeType)("Statement")
        }
      }
    });
    defineType("LabeledStatement", {
      visitor: ["label", "body"],
      aliases: ["Statement"],
      fields: {
        label: {
          validate: (0, _utils.assertNodeType)("Identifier")
        },
        body: {
          validate: (0, _utils.assertNodeType)("Statement")
        }
      }
    });
    defineType("StringLiteral", {
      builder: ["value"],
      fields: {
        value: {
          validate: (0, _utils.assertValueType)("string")
        }
      },
      aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    });
    defineType("NumericLiteral", {
      builder: ["value"],
      deprecatedAlias: "NumberLiteral",
      fields: {
        value: {
          validate: (0, _utils.chain)((0, _utils.assertValueType)("number"), Object.assign(function(node, key, val) {
            if (1 / val < 0 || !Number.isFinite(val)) {
              const error = new Error(`NumericLiterals must be non-negative finite numbers. You can use t.valueToNode(${val}) instead.`);
              {
              }
            }
          }, {
            type: "number"
          }))
        }
      },
      aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    });
    defineType("NullLiteral", {
      aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    });
    defineType("BooleanLiteral", {
      builder: ["value"],
      fields: {
        value: {
          validate: (0, _utils.assertValueType)("boolean")
        }
      },
      aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    });
    defineType("RegExpLiteral", {
      builder: ["pattern", "flags"],
      deprecatedAlias: "RegexLiteral",
      aliases: ["Expression", "Pureish", "Literal"],
      fields: {
        pattern: {
          validate: (0, _utils.assertValueType)("string")
        },
        flags: {
          validate: process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.chain)((0, _utils.assertValueType)("string"), Object.assign(function(node, key, val) {
            const invalid = /[^gimsuy]/.exec(val);
            if (invalid) {
              throw new TypeError(`"${invalid[0]}" is not a valid RegExp flag`);
            }
          }, {
            type: "string"
          })) : (0, _utils.assertValueType)("string"),
          default: ""
        }
      }
    });
    defineType("LogicalExpression", {
      builder: ["operator", "left", "right"],
      visitor: ["left", "right"],
      aliases: ["Binary", "Expression"],
      fields: {
        operator: {
          validate: (0, _utils.assertOneOf)(..._index.LOGICAL_OPERATORS)
        },
        left: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        right: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    defineType("MemberExpression", {
      builder: ["object", "property", "computed", ...!process.env.BABEL_TYPES_8_BREAKING ? ["optional"] : []],
      visitor: ["object", "property"],
      aliases: ["Expression", "LVal"],
      fields: Object.assign({
        object: {
          validate: (0, _utils.assertNodeType)("Expression", "Super")
        },
        property: {
          validate: function() {
            const normal = (0, _utils.assertNodeType)("Identifier", "PrivateName");
            const computed = (0, _utils.assertNodeType)("Expression");
            const validator = function(node, key, val) {
              const validator2 = node.computed ? computed : normal;
              validator2(node, key, val);
            };
            validator.oneOfNodeTypes = ["Expression", "Identifier", "PrivateName"];
            return validator;
          }()
        },
        computed: {
          default: false
        }
      }, !process.env.BABEL_TYPES_8_BREAKING ? {
        optional: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        }
      } : {})
    });
    defineType("NewExpression", {
      inherits: "CallExpression"
    });
    defineType("Program", {
      visitor: ["directives", "body"],
      builder: ["body", "directives", "sourceType", "interpreter"],
      fields: {
        sourceType: {
          validate: (0, _utils.assertOneOf)("script", "module"),
          default: "script"
        },
        interpreter: {
          validate: (0, _utils.assertNodeType)("InterpreterDirective"),
          default: null,
          optional: true
        },
        directives: {
          validate: (0, _utils.arrayOfType)("Directive"),
          default: []
        },
        body: (0, _utils.validateArrayOfType)("Statement")
      },
      aliases: ["Scopable", "BlockParent", "Block"]
    });
    defineType("ObjectExpression", {
      visitor: ["properties"],
      aliases: ["Expression"],
      fields: {
        properties: (0, _utils.validateArrayOfType)("ObjectMethod", "ObjectProperty", "SpreadElement")
      }
    });
    defineType("ObjectMethod", {
      builder: ["kind", "key", "params", "body", "computed", "generator", "async"],
      visitor: ["decorators", "key", "typeParameters", "params", "returnType", "body"],
      fields: Object.assign({}, functionCommon(), functionTypeAnnotationCommon(), {
        kind: Object.assign({
          validate: (0, _utils.assertOneOf)("method", "get", "set")
        }, !process.env.BABEL_TYPES_8_BREAKING ? {
          default: "method"
        } : {}),
        computed: {
          default: false
        },
        key: {
          validate: function() {
            const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "BigIntLiteral");
            const computed = (0, _utils.assertNodeType)("Expression");
            const validator = function(node, key, val) {
              const validator2 = node.computed ? computed : normal;
              validator2(node, key, val);
            };
            validator.oneOfNodeTypes = ["Expression", "Identifier", "StringLiteral", "NumericLiteral", "BigIntLiteral"];
            return validator;
          }()
        },
        decorators: {
          validate: (0, _utils.arrayOfType)("Decorator"),
          optional: true
        },
        body: {
          validate: (0, _utils.assertNodeType)("BlockStatement")
        }
      }),
      aliases: ["UserWhitespacable", "Function", "Scopable", "BlockParent", "FunctionParent", "Method", "ObjectMember"]
    });
    defineType("ObjectProperty", {
      builder: ["key", "value", "computed", "shorthand", ...!process.env.BABEL_TYPES_8_BREAKING ? ["decorators"] : []],
      fields: {
        computed: {
          default: false
        },
        key: {
          validate: function() {
            const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "BigIntLiteral", "DecimalLiteral", "PrivateName");
            const computed = (0, _utils.assertNodeType)("Expression");
            const validator = Object.assign(function(node, key, val) {
              const validator2 = node.computed ? computed : normal;
              validator2(node, key, val);
            }, {
              oneOfNodeTypes: ["Expression", "Identifier", "StringLiteral", "NumericLiteral", "BigIntLiteral", "DecimalLiteral", "PrivateName"]
            });
            return validator;
          }()
        },
        value: {
          validate: (0, _utils.assertNodeType)("Expression", "PatternLike")
        },
        shorthand: {
          validate: process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.chain)((0, _utils.assertValueType)("boolean"), Object.assign(function(node, key, shorthand) {
            if (!shorthand) return;
            if (node.computed) {
              throw new TypeError("Property shorthand of ObjectProperty cannot be true if computed is true");
            }
            if (!(0, _is.default)("Identifier", node.key)) {
              throw new TypeError("Property shorthand of ObjectProperty cannot be true if key is not an Identifier");
            }
          }, {
            type: "boolean"
          })) : (0, _utils.assertValueType)("boolean"),
          default: false
        },
        decorators: {
          validate: (0, _utils.arrayOfType)("Decorator"),
          optional: true
        }
      },
      visitor: ["key", "value", "decorators"],
      aliases: ["UserWhitespacable", "Property", "ObjectMember"],
      validate: !process.env.BABEL_TYPES_8_BREAKING ? void 0 : function() {
        const pattern = (0, _utils.assertNodeType)("Identifier", "Pattern", "TSAsExpression", "TSSatisfiesExpression", "TSNonNullExpression", "TSTypeAssertion");
        const expression = (0, _utils.assertNodeType)("Expression");
        return function(parent, key, node) {
          const validator = (0, _is.default)("ObjectPattern", parent) ? pattern : expression;
          validator(node, "value", node.value);
        };
      }()
    });
    defineType("RestElement", {
      visitor: ["argument", "typeAnnotation"],
      builder: ["argument"],
      aliases: ["LVal", "PatternLike"],
      deprecatedAlias: "RestProperty",
      fields: Object.assign({}, patternLikeCommon(), {
        argument: {
          validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("LVal") : (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern", "MemberExpression", "TSAsExpression", "TSSatisfiesExpression", "TSTypeAssertion", "TSNonNullExpression")
        }
      }),
      validate: process.env.BABEL_TYPES_8_BREAKING ? function(parent, key) {
        const match = /(\w+)\[(\d+)\]/.exec(key);
        if (!match) throw new Error("Internal Babel error: malformed key.");
        const [, listKey, index] = match;
        if (parent[listKey].length > +index + 1) {
          throw new TypeError(`RestElement must be last element of ${listKey}`);
        }
      } : void 0
    });
    defineType("ReturnStatement", {
      visitor: ["argument"],
      aliases: ["Statement", "Terminatorless", "CompletionStatement"],
      fields: {
        argument: {
          validate: (0, _utils.assertNodeType)("Expression"),
          optional: true
        }
      }
    });
    defineType("SequenceExpression", {
      visitor: ["expressions"],
      fields: {
        expressions: (0, _utils.validateArrayOfType)("Expression")
      },
      aliases: ["Expression"]
    });
    defineType("ParenthesizedExpression", {
      visitor: ["expression"],
      aliases: ["Expression", "ExpressionWrapper"],
      fields: {
        expression: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    defineType("SwitchCase", {
      visitor: ["test", "consequent"],
      fields: {
        test: {
          validate: (0, _utils.assertNodeType)("Expression"),
          optional: true
        },
        consequent: (0, _utils.validateArrayOfType)("Statement")
      }
    });
    defineType("SwitchStatement", {
      visitor: ["discriminant", "cases"],
      aliases: ["Statement", "BlockParent", "Scopable"],
      fields: {
        discriminant: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        cases: (0, _utils.validateArrayOfType)("SwitchCase")
      }
    });
    defineType("ThisExpression", {
      aliases: ["Expression"]
    });
    defineType("ThrowStatement", {
      visitor: ["argument"],
      aliases: ["Statement", "Terminatorless", "CompletionStatement"],
      fields: {
        argument: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    defineType("TryStatement", {
      visitor: ["block", "handler", "finalizer"],
      aliases: ["Statement"],
      fields: {
        block: {
          validate: process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.chain)((0, _utils.assertNodeType)("BlockStatement"), Object.assign(function(node) {
            if (!node.handler && !node.finalizer) {
              throw new TypeError("TryStatement expects either a handler or finalizer, or both");
            }
          }, {
            oneOfNodeTypes: ["BlockStatement"]
          })) : (0, _utils.assertNodeType)("BlockStatement")
        },
        handler: {
          optional: true,
          validate: (0, _utils.assertNodeType)("CatchClause")
        },
        finalizer: {
          optional: true,
          validate: (0, _utils.assertNodeType)("BlockStatement")
        }
      }
    });
    defineType("UnaryExpression", {
      builder: ["operator", "argument", "prefix"],
      fields: {
        prefix: {
          default: true
        },
        argument: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        operator: {
          validate: (0, _utils.assertOneOf)(..._index.UNARY_OPERATORS)
        }
      },
      visitor: ["argument"],
      aliases: ["UnaryLike", "Expression"]
    });
    defineType("UpdateExpression", {
      builder: ["operator", "argument", "prefix"],
      fields: {
        prefix: {
          default: false
        },
        argument: {
          validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("Expression") : (0, _utils.assertNodeType)("Identifier", "MemberExpression")
        },
        operator: {
          validate: (0, _utils.assertOneOf)(..._index.UPDATE_OPERATORS)
        }
      },
      visitor: ["argument"],
      aliases: ["Expression"]
    });
    defineType("VariableDeclaration", {
      builder: ["kind", "declarations"],
      visitor: ["declarations"],
      aliases: ["Statement", "Declaration"],
      fields: {
        declare: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        kind: {
          validate: (0, _utils.assertOneOf)("var", "let", "const", "using", "await using")
        },
        declarations: (0, _utils.validateArrayOfType)("VariableDeclarator")
      },
      validate: process.env.BABEL_TYPES_8_BREAKING ? (() => {
        const withoutInit = (0, _utils.assertNodeType)("Identifier");
        return function(parent, key, node) {
          if ((0, _is.default)("ForXStatement", parent, {
            left: node
          })) {
            if (node.declarations.length !== 1) {
              throw new TypeError(`Exactly one VariableDeclarator is required in the VariableDeclaration of a ${parent.type}`);
            }
          } else {
            node.declarations.forEach((decl) => {
              if (!decl.init) withoutInit(decl, "id", decl.id);
            });
          }
        };
      })() : void 0
    });
    defineType("VariableDeclarator", {
      visitor: ["id", "init"],
      fields: {
        id: {
          validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertNodeType)("LVal") : (0, _utils.assertNodeType)("Identifier", "ArrayPattern", "ObjectPattern")
        },
        definite: {
          optional: true,
          validate: (0, _utils.assertValueType)("boolean")
        },
        init: {
          optional: true,
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    defineType("WhileStatement", {
      visitor: ["test", "body"],
      aliases: ["Statement", "BlockParent", "Loop", "While", "Scopable"],
      fields: {
        test: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        body: {
          validate: (0, _utils.assertNodeType)("Statement")
        }
      }
    });
    defineType("WithStatement", {
      visitor: ["object", "body"],
      aliases: ["Statement"],
      fields: {
        object: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        body: {
          validate: (0, _utils.assertNodeType)("Statement")
        }
      }
    });
    defineType("AssignmentPattern", {
      visitor: ["left", "right", "decorators"],
      builder: ["left", "right"],
      aliases: ["Pattern", "PatternLike", "LVal"],
      fields: Object.assign({}, patternLikeCommon(), {
        left: {
          validate: (0, _utils.assertNodeType)("Identifier", "ObjectPattern", "ArrayPattern", "MemberExpression", "TSAsExpression", "TSSatisfiesExpression", "TSTypeAssertion", "TSNonNullExpression")
        },
        right: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        decorators: {
          validate: (0, _utils.arrayOfType)("Decorator"),
          optional: true
        }
      })
    });
    defineType("ArrayPattern", {
      visitor: ["elements", "typeAnnotation"],
      builder: ["elements"],
      aliases: ["Pattern", "PatternLike", "LVal"],
      fields: Object.assign({}, patternLikeCommon(), {
        elements: {
          validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeOrValueType)("null", "PatternLike", "LVal")))
        }
      })
    });
    defineType("ArrowFunctionExpression", {
      builder: ["params", "body", "async"],
      visitor: ["typeParameters", "params", "returnType", "body"],
      aliases: ["Scopable", "Function", "BlockParent", "FunctionParent", "Expression", "Pureish"],
      fields: Object.assign({}, functionCommon(), functionTypeAnnotationCommon(), {
        expression: {
          validate: (0, _utils.assertValueType)("boolean")
        },
        body: {
          validate: (0, _utils.assertNodeType)("BlockStatement", "Expression")
        },
        predicate: {
          validate: (0, _utils.assertNodeType)("DeclaredPredicate", "InferredPredicate"),
          optional: true
        }
      })
    });
    defineType("ClassBody", {
      visitor: ["body"],
      fields: {
        body: (0, _utils.validateArrayOfType)("ClassMethod", "ClassPrivateMethod", "ClassProperty", "ClassPrivateProperty", "ClassAccessorProperty", "TSDeclareMethod", "TSIndexSignature", "StaticBlock")
      }
    });
    defineType("ClassExpression", {
      builder: ["id", "superClass", "body", "decorators"],
      visitor: ["decorators", "id", "typeParameters", "superClass", "superTypeParameters", "mixins", "implements", "body"],
      aliases: ["Scopable", "Class", "Expression"],
      fields: {
        id: {
          validate: (0, _utils.assertNodeType)("Identifier"),
          optional: true
        },
        typeParameters: {
          validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
          optional: true
        },
        body: {
          validate: (0, _utils.assertNodeType)("ClassBody")
        },
        superClass: {
          optional: true,
          validate: (0, _utils.assertNodeType)("Expression")
        },
        superTypeParameters: {
          validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
          optional: true
        },
        implements: {
          validate: (0, _utils.arrayOfType)("TSExpressionWithTypeArguments", "ClassImplements"),
          optional: true
        },
        decorators: {
          validate: (0, _utils.arrayOfType)("Decorator"),
          optional: true
        },
        mixins: {
          validate: (0, _utils.assertNodeType)("InterfaceExtends"),
          optional: true
        }
      }
    });
    defineType("ClassDeclaration", {
      inherits: "ClassExpression",
      aliases: ["Scopable", "Class", "Statement", "Declaration"],
      fields: {
        id: {
          validate: (0, _utils.assertNodeType)("Identifier"),
          optional: true
        },
        typeParameters: {
          validate: (0, _utils.assertNodeType)("TypeParameterDeclaration", "TSTypeParameterDeclaration", "Noop"),
          optional: true
        },
        body: {
          validate: (0, _utils.assertNodeType)("ClassBody")
        },
        superClass: {
          optional: true,
          validate: (0, _utils.assertNodeType)("Expression")
        },
        superTypeParameters: {
          validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
          optional: true
        },
        implements: {
          validate: (0, _utils.arrayOfType)("TSExpressionWithTypeArguments", "ClassImplements"),
          optional: true
        },
        decorators: {
          validate: (0, _utils.arrayOfType)("Decorator"),
          optional: true
        },
        mixins: {
          validate: (0, _utils.assertNodeType)("InterfaceExtends"),
          optional: true
        },
        declare: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        abstract: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        }
      },
      validate: !process.env.BABEL_TYPES_8_BREAKING ? void 0 : function() {
        const identifier4 = (0, _utils.assertNodeType)("Identifier");
        return function(parent, key, node) {
          if (!(0, _is.default)("ExportDefaultDeclaration", parent)) {
            identifier4(node, "id", node.id);
          }
        };
      }()
    });
    var importAttributes = exports2.importAttributes = {
      attributes: {
        optional: true,
        validate: (0, _utils.arrayOfType)("ImportAttribute")
      },
      assertions: {
        deprecated: true,
        optional: true,
        validate: (0, _utils.arrayOfType)("ImportAttribute")
      }
    };
    defineType("ExportAllDeclaration", {
      builder: ["source"],
      visitor: ["source", "attributes", "assertions"],
      aliases: ["Statement", "Declaration", "ImportOrExportDeclaration", "ExportDeclaration"],
      fields: Object.assign({
        source: {
          validate: (0, _utils.assertNodeType)("StringLiteral")
        },
        exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
      }, importAttributes)
    });
    defineType("ExportDefaultDeclaration", {
      visitor: ["declaration"],
      aliases: ["Statement", "Declaration", "ImportOrExportDeclaration", "ExportDeclaration"],
      fields: {
        declaration: (0, _utils.validateType)("TSDeclareFunction", "FunctionDeclaration", "ClassDeclaration", "Expression"),
        exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("value"))
      }
    });
    defineType("ExportNamedDeclaration", {
      builder: ["declaration", "specifiers", "source"],
      visitor: process.env ? ["declaration", "specifiers", "source", "attributes"] : ["declaration", "specifiers", "source", "attributes", "assertions"],
      aliases: ["Statement", "Declaration", "ImportOrExportDeclaration", "ExportDeclaration"],
      fields: Object.assign({
        declaration: {
          optional: true,
          validate: process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.chain)((0, _utils.assertNodeType)("Declaration"), Object.assign(function(node, key, val) {
            if (val && node.specifiers.length) {
              throw new TypeError("Only declaration or specifiers is allowed on ExportNamedDeclaration");
            }
            if (val && node.source) {
              throw new TypeError("Cannot export a declaration from a source");
            }
          }, {
            oneOfNodeTypes: ["Declaration"]
          })) : (0, _utils.assertNodeType)("Declaration")
        }
      }, importAttributes, {
        specifiers: {
          default: [],
          validate: (0, _utils.arrayOf)(function() {
            const sourced = (0, _utils.assertNodeType)("ExportSpecifier", "ExportDefaultSpecifier", "ExportNamespaceSpecifier");
            const sourceless = (0, _utils.assertNodeType)("ExportSpecifier");
            if (!process.env.BABEL_TYPES_8_BREAKING) return sourced;
            return Object.assign(function(node, key, val) {
              const validator = node.source ? sourced : sourceless;
              validator(node, key, val);
            }, {
              oneOfNodeTypes: ["ExportSpecifier", "ExportDefaultSpecifier", "ExportNamespaceSpecifier"]
            });
          }())
        },
        source: {
          validate: (0, _utils.assertNodeType)("StringLiteral"),
          optional: true
        },
        exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
      })
    });
    defineType("ExportSpecifier", {
      visitor: ["local", "exported"],
      aliases: ["ModuleSpecifier"],
      fields: {
        local: {
          validate: (0, _utils.assertNodeType)("Identifier")
        },
        exported: {
          validate: (0, _utils.assertNodeType)("Identifier", "StringLiteral")
        },
        exportKind: {
          validate: (0, _utils.assertOneOf)("type", "value"),
          optional: true
        }
      }
    });
    defineType("ForOfStatement", {
      visitor: ["left", "right", "body"],
      builder: ["left", "right", "body", "await"],
      aliases: ["Scopable", "Statement", "For", "BlockParent", "Loop", "ForXStatement"],
      fields: {
        left: {
          validate: function() {
            if (!process.env.BABEL_TYPES_8_BREAKING) {
              return (0, _utils.assertNodeType)("VariableDeclaration", "LVal");
            }
            const declaration = (0, _utils.assertNodeType)("VariableDeclaration");
            const lval = (0, _utils.assertNodeType)("Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern", "TSAsExpression", "TSSatisfiesExpression", "TSTypeAssertion", "TSNonNullExpression");
            return Object.assign(function(node, key, val) {
              if ((0, _is.default)("VariableDeclaration", val)) {
                declaration(node, key, val);
              } else {
                lval(node, key, val);
              }
            }, {
              oneOfNodeTypes: ["VariableDeclaration", "Identifier", "MemberExpression", "ArrayPattern", "ObjectPattern", "TSAsExpression", "TSSatisfiesExpression", "TSTypeAssertion", "TSNonNullExpression"]
            });
          }()
        },
        right: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        body: {
          validate: (0, _utils.assertNodeType)("Statement")
        },
        await: {
          default: false
        }
      }
    });
    defineType("ImportDeclaration", {
      builder: ["specifiers", "source"],
      visitor: ["specifiers", "source", "attributes", "assertions"],
      aliases: ["Statement", "Declaration", "ImportOrExportDeclaration"],
      fields: Object.assign({}, importAttributes, {
        module: {
          optional: true,
          validate: (0, _utils.assertValueType)("boolean")
        },
        phase: {
          default: null,
          validate: (0, _utils.assertOneOf)("source", "defer")
        },
        specifiers: (0, _utils.validateArrayOfType)("ImportSpecifier", "ImportDefaultSpecifier", "ImportNamespaceSpecifier"),
        source: {
          validate: (0, _utils.assertNodeType)("StringLiteral")
        },
        importKind: {
          validate: (0, _utils.assertOneOf)("type", "typeof", "value"),
          optional: true
        }
      })
    });
    defineType("ImportDefaultSpecifier", {
      visitor: ["local"],
      aliases: ["ModuleSpecifier"],
      fields: {
        local: {
          validate: (0, _utils.assertNodeType)("Identifier")
        }
      }
    });
    defineType("ImportNamespaceSpecifier", {
      visitor: ["local"],
      aliases: ["ModuleSpecifier"],
      fields: {
        local: {
          validate: (0, _utils.assertNodeType)("Identifier")
        }
      }
    });
    defineType("ImportSpecifier", {
      visitor: ["imported", "local"],
      builder: ["local", "imported"],
      aliases: ["ModuleSpecifier"],
      fields: {
        local: {
          validate: (0, _utils.assertNodeType)("Identifier")
        },
        imported: {
          validate: (0, _utils.assertNodeType)("Identifier", "StringLiteral")
        },
        importKind: {
          validate: (0, _utils.assertOneOf)("type", "typeof", "value"),
          optional: true
        }
      }
    });
    defineType("ImportExpression", {
      visitor: ["source", "options"],
      aliases: ["Expression"],
      fields: {
        phase: {
          default: null,
          validate: (0, _utils.assertOneOf)("source", "defer")
        },
        source: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        options: {
          validate: (0, _utils.assertNodeType)("Expression"),
          optional: true
        }
      }
    });
    defineType("MetaProperty", {
      visitor: ["meta", "property"],
      aliases: ["Expression"],
      fields: {
        meta: {
          validate: process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.chain)((0, _utils.assertNodeType)("Identifier"), Object.assign(function(node, key, val) {
            let property;
            switch (val.name) {
              case "function":
                property = "sent";
                break;
              case "new":
                property = "target";
                break;
              case "import":
                property = "meta";
                break;
            }
            if (!(0, _is.default)("Identifier", node.property, {
              name: property
            })) {
              throw new TypeError("Unrecognised MetaProperty");
            }
          }, {
            oneOfNodeTypes: ["Identifier"]
          })) : (0, _utils.assertNodeType)("Identifier")
        },
        property: {
          validate: (0, _utils.assertNodeType)("Identifier")
        }
      }
    });
    var classMethodOrPropertyCommon = () => ({
      abstract: {
        validate: (0, _utils.assertValueType)("boolean"),
        optional: true
      },
      accessibility: {
        validate: (0, _utils.assertOneOf)("public", "private", "protected"),
        optional: true
      },
      static: {
        default: false
      },
      override: {
        default: false
      },
      computed: {
        default: false
      },
      optional: {
        validate: (0, _utils.assertValueType)("boolean"),
        optional: true
      },
      key: {
        validate: (0, _utils.chain)(function() {
          const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "BigIntLiteral");
          const computed = (0, _utils.assertNodeType)("Expression");
          return function(node, key, val) {
            const validator = node.computed ? computed : normal;
            validator(node, key, val);
          };
        }(), (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "BigIntLiteral", "Expression"))
      }
    });
    exports2.classMethodOrPropertyCommon = classMethodOrPropertyCommon;
    var classMethodOrDeclareMethodCommon = () => Object.assign({}, functionCommon(), classMethodOrPropertyCommon(), {
      params: (0, _utils.validateArrayOfType)("Identifier", "Pattern", "RestElement", "TSParameterProperty"),
      kind: {
        validate: (0, _utils.assertOneOf)("get", "set", "method", "constructor"),
        default: "method"
      },
      access: {
        validate: (0, _utils.chain)((0, _utils.assertValueType)("string"), (0, _utils.assertOneOf)("public", "private", "protected")),
        optional: true
      },
      decorators: {
        validate: (0, _utils.arrayOfType)("Decorator"),
        optional: true
      }
    });
    exports2.classMethodOrDeclareMethodCommon = classMethodOrDeclareMethodCommon;
    defineType("ClassMethod", {
      aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method"],
      builder: ["kind", "key", "params", "body", "computed", "static", "generator", "async"],
      visitor: ["decorators", "key", "typeParameters", "params", "returnType", "body"],
      fields: Object.assign({}, classMethodOrDeclareMethodCommon(), functionTypeAnnotationCommon(), {
        body: {
          validate: (0, _utils.assertNodeType)("BlockStatement")
        }
      })
    });
    defineType("ObjectPattern", {
      visitor: ["properties", "typeAnnotation", "decorators"],
      builder: ["properties"],
      aliases: ["Pattern", "PatternLike", "LVal"],
      fields: Object.assign({}, patternLikeCommon(), {
        properties: (0, _utils.validateArrayOfType)("RestElement", "ObjectProperty")
      })
    });
    defineType("SpreadElement", {
      visitor: ["argument"],
      aliases: ["UnaryLike"],
      deprecatedAlias: "SpreadProperty",
      fields: {
        argument: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    defineType("Super", {
      aliases: ["Expression"]
    });
    defineType("TaggedTemplateExpression", {
      visitor: ["tag", "typeParameters", "quasi"],
      builder: ["tag", "quasi"],
      aliases: ["Expression"],
      fields: {
        tag: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        quasi: {
          validate: (0, _utils.assertNodeType)("TemplateLiteral")
        },
        typeParameters: {
          validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
          optional: true
        }
      }
    });
    defineType("TemplateElement", {
      builder: ["value", "tail"],
      fields: {
        value: {
          validate: (0, _utils.chain)((0, _utils.assertShape)({
            raw: {
              validate: (0, _utils.assertValueType)("string")
            },
            cooked: {
              validate: (0, _utils.assertValueType)("string"),
              optional: true
            }
          }), function templateElementCookedValidator(node) {
            const raw = node.value.raw;
            let unterminatedCalled = false;
            const error = () => {
              throw new Error("Internal @babel/types error.");
            };
            const {
              str,
              firstInvalidLoc
            } = (0, _helperStringParser.readStringContents)("template", raw, 0, 0, 0, {
              unterminated() {
                unterminatedCalled = true;
              },
              strictNumericEscape: error,
              invalidEscapeSequence: error,
              numericSeparatorInEscapeSequence: error,
              unexpectedNumericSeparator: error,
              invalidDigit: error,
              invalidCodePoint: error
            });
            if (!unterminatedCalled) throw new Error("Invalid raw");
            node.value.cooked = firstInvalidLoc ? null : str;
          })
        },
        tail: {
          default: false
        }
      }
    });
    defineType("TemplateLiteral", {
      visitor: ["quasis", "expressions"],
      aliases: ["Expression", "Literal"],
      fields: {
        quasis: (0, _utils.validateArrayOfType)("TemplateElement"),
        expressions: {
          validate: (0, _utils.chain)((0, _utils.assertValueType)("array"), (0, _utils.assertEach)((0, _utils.assertNodeType)("Expression", "TSType")), function(node, key, val) {
            if (node.quasis.length !== val.length + 1) {
              throw new TypeError(`Number of ${node.type} quasis should be exactly one more than the number of expressions.
Expected ${val.length + 1} quasis but got ${node.quasis.length}`);
            }
          })
        }
      }
    });
    defineType("YieldExpression", {
      builder: ["argument", "delegate"],
      visitor: ["argument"],
      aliases: ["Expression", "Terminatorless"],
      fields: {
        delegate: {
          validate: process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.chain)((0, _utils.assertValueType)("boolean"), Object.assign(function(node, key, val) {
            if (val && !node.argument) {
              throw new TypeError("Property delegate of YieldExpression cannot be true if there is no argument");
            }
          }, {
            type: "boolean"
          })) : (0, _utils.assertValueType)("boolean"),
          default: false
        },
        argument: {
          optional: true,
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    defineType("AwaitExpression", {
      builder: ["argument"],
      visitor: ["argument"],
      aliases: ["Expression", "Terminatorless"],
      fields: {
        argument: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    defineType("Import", {
      aliases: ["Expression"]
    });
    defineType("BigIntLiteral", {
      builder: ["value"],
      fields: {
        value: {
          validate: (0, _utils.assertValueType)("string")
        }
      },
      aliases: ["Expression", "Pureish", "Literal", "Immutable"]
    });
    defineType("ExportNamespaceSpecifier", {
      visitor: ["exported"],
      aliases: ["ModuleSpecifier"],
      fields: {
        exported: {
          validate: (0, _utils.assertNodeType)("Identifier")
        }
      }
    });
    defineType("OptionalMemberExpression", {
      builder: ["object", "property", "computed", "optional"],
      visitor: ["object", "property"],
      aliases: ["Expression"],
      fields: {
        object: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        property: {
          validate: function() {
            const normal = (0, _utils.assertNodeType)("Identifier");
            const computed = (0, _utils.assertNodeType)("Expression");
            const validator = Object.assign(function(node, key, val) {
              const validator2 = node.computed ? computed : normal;
              validator2(node, key, val);
            }, {
              oneOfNodeTypes: ["Expression", "Identifier"]
            });
            return validator;
          }()
        },
        computed: {
          default: false
        },
        optional: {
          validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertValueType)("boolean") : (0, _utils.chain)((0, _utils.assertValueType)("boolean"), (0, _utils.assertOptionalChainStart)())
        }
      }
    });
    defineType("OptionalCallExpression", {
      visitor: ["callee", "arguments", "typeParameters", "typeArguments"],
      builder: ["callee", "arguments", "optional"],
      aliases: ["Expression"],
      fields: {
        callee: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        arguments: (0, _utils.validateArrayOfType)("Expression", "SpreadElement", "ArgumentPlaceholder"),
        optional: {
          validate: !process.env.BABEL_TYPES_8_BREAKING ? (0, _utils.assertValueType)("boolean") : (0, _utils.chain)((0, _utils.assertValueType)("boolean"), (0, _utils.assertOptionalChainStart)())
        },
        typeArguments: {
          validate: (0, _utils.assertNodeType)("TypeParameterInstantiation"),
          optional: true
        },
        typeParameters: {
          validate: (0, _utils.assertNodeType)("TSTypeParameterInstantiation"),
          optional: true
        }
      }
    });
    defineType("ClassProperty", {
      visitor: ["decorators", "key", "typeAnnotation", "value"],
      builder: ["key", "value", "typeAnnotation", "decorators", "computed", "static"],
      aliases: ["Property"],
      fields: Object.assign({}, classMethodOrPropertyCommon(), {
        value: {
          validate: (0, _utils.assertNodeType)("Expression"),
          optional: true
        },
        definite: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        typeAnnotation: {
          validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
          optional: true
        },
        decorators: {
          validate: (0, _utils.arrayOfType)("Decorator"),
          optional: true
        },
        readonly: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        declare: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        variance: {
          validate: (0, _utils.assertNodeType)("Variance"),
          optional: true
        }
      })
    });
    defineType("ClassAccessorProperty", {
      visitor: ["decorators", "key", "typeAnnotation", "value"],
      builder: ["key", "value", "typeAnnotation", "decorators", "computed", "static"],
      aliases: ["Property", "Accessor"],
      fields: Object.assign({}, classMethodOrPropertyCommon(), {
        key: {
          validate: (0, _utils.chain)(function() {
            const normal = (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "BigIntLiteral", "PrivateName");
            const computed = (0, _utils.assertNodeType)("Expression");
            return function(node, key, val) {
              const validator = node.computed ? computed : normal;
              validator(node, key, val);
            };
          }(), (0, _utils.assertNodeType)("Identifier", "StringLiteral", "NumericLiteral", "BigIntLiteral", "Expression", "PrivateName"))
        },
        value: {
          validate: (0, _utils.assertNodeType)("Expression"),
          optional: true
        },
        definite: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        typeAnnotation: {
          validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
          optional: true
        },
        decorators: {
          validate: (0, _utils.arrayOfType)("Decorator"),
          optional: true
        },
        readonly: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        declare: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        variance: {
          validate: (0, _utils.assertNodeType)("Variance"),
          optional: true
        }
      })
    });
    defineType("ClassPrivateProperty", {
      visitor: ["decorators", "key", "typeAnnotation", "value"],
      builder: ["key", "value", "decorators", "static"],
      aliases: ["Property", "Private"],
      fields: {
        key: {
          validate: (0, _utils.assertNodeType)("PrivateName")
        },
        value: {
          validate: (0, _utils.assertNodeType)("Expression"),
          optional: true
        },
        typeAnnotation: {
          validate: (0, _utils.assertNodeType)("TypeAnnotation", "TSTypeAnnotation", "Noop"),
          optional: true
        },
        decorators: {
          validate: (0, _utils.arrayOfType)("Decorator"),
          optional: true
        },
        static: {
          validate: (0, _utils.assertValueType)("boolean"),
          default: false
        },
        readonly: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        definite: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        variance: {
          validate: (0, _utils.assertNodeType)("Variance"),
          optional: true
        }
      }
    });
    defineType("ClassPrivateMethod", {
      builder: ["kind", "key", "params", "body", "static"],
      visitor: ["decorators", "key", "typeParameters", "params", "returnType", "body"],
      aliases: ["Function", "Scopable", "BlockParent", "FunctionParent", "Method", "Private"],
      fields: Object.assign({}, classMethodOrDeclareMethodCommon(), functionTypeAnnotationCommon(), {
        kind: {
          validate: (0, _utils.assertOneOf)("get", "set", "method"),
          default: "method"
        },
        key: {
          validate: (0, _utils.assertNodeType)("PrivateName")
        },
        body: {
          validate: (0, _utils.assertNodeType)("BlockStatement")
        }
      })
    });
    defineType("PrivateName", {
      visitor: ["id"],
      aliases: ["Private"],
      fields: {
        id: {
          validate: (0, _utils.assertNodeType)("Identifier")
        }
      }
    });
    defineType("StaticBlock", {
      visitor: ["body"],
      fields: {
        body: (0, _utils.validateArrayOfType)("Statement")
      },
      aliases: ["Scopable", "BlockParent", "FunctionParent"]
    });
  }
});

// ../../node_modules/@babel/types/lib/definitions/flow.js
var require_flow = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/flow.js"() {
    "use strict";
    var _core = require_core();
    var _utils = require_utils();
    var defineType = (0, _utils.defineAliasedType)("Flow");
    var defineInterfaceishType = (name) => {
      const isDeclareClass = name === "DeclareClass";
      defineType(name, {
        builder: ["id", "typeParameters", "extends", "body"],
        visitor: ["id", "typeParameters", "extends", ...isDeclareClass ? ["mixins", "implements"] : [], "body"],
        aliases: ["FlowDeclaration", "Statement", "Declaration"],
        fields: Object.assign({
          id: (0, _utils.validateType)("Identifier"),
          typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
          extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends"))
        }, isDeclareClass ? {
          mixins: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
          implements: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ClassImplements"))
        } : {}, {
          body: (0, _utils.validateType)("ObjectTypeAnnotation")
        })
      });
    };
    defineType("AnyTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("ArrayTypeAnnotation", {
      visitor: ["elementType"],
      aliases: ["FlowType"],
      fields: {
        elementType: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("BooleanTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("BooleanLiteralTypeAnnotation", {
      builder: ["value"],
      aliases: ["FlowType"],
      fields: {
        value: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("NullLiteralTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("ClassImplements", {
      visitor: ["id", "typeParameters"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
      }
    });
    defineInterfaceishType("DeclareClass");
    defineType("DeclareFunction", {
      visitor: ["id"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        predicate: (0, _utils.validateOptionalType)("DeclaredPredicate")
      }
    });
    defineInterfaceishType("DeclareInterface");
    defineType("DeclareModule", {
      builder: ["id", "body", "kind"],
      visitor: ["id", "body"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: {
        id: (0, _utils.validateType)("Identifier", "StringLiteral"),
        body: (0, _utils.validateType)("BlockStatement"),
        kind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("CommonJS", "ES"))
      }
    });
    defineType("DeclareModuleExports", {
      visitor: ["typeAnnotation"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: {
        typeAnnotation: (0, _utils.validateType)("TypeAnnotation")
      }
    });
    defineType("DeclareTypeAlias", {
      visitor: ["id", "typeParameters", "right"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
        right: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("DeclareOpaqueType", {
      visitor: ["id", "typeParameters", "supertype"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
        supertype: (0, _utils.validateOptionalType)("FlowType"),
        impltype: (0, _utils.validateOptionalType)("FlowType")
      }
    });
    defineType("DeclareVariable", {
      visitor: ["id"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: {
        id: (0, _utils.validateType)("Identifier")
      }
    });
    defineType("DeclareExportDeclaration", {
      visitor: ["declaration", "specifiers", "source", "attributes"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: Object.assign({
        declaration: (0, _utils.validateOptionalType)("Flow"),
        specifiers: (0, _utils.validateOptional)((0, _utils.arrayOfType)("ExportSpecifier", "ExportNamespaceSpecifier")),
        source: (0, _utils.validateOptionalType)("StringLiteral"),
        default: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
      }, _core.importAttributes)
    });
    defineType("DeclareExportAllDeclaration", {
      visitor: ["source", "attributes"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: Object.assign({
        source: (0, _utils.validateType)("StringLiteral"),
        exportKind: (0, _utils.validateOptional)((0, _utils.assertOneOf)("type", "value"))
      }, _core.importAttributes)
    });
    defineType("DeclaredPredicate", {
      visitor: ["value"],
      aliases: ["FlowPredicate"],
      fields: {
        value: (0, _utils.validateType)("Flow")
      }
    });
    defineType("ExistsTypeAnnotation", {
      aliases: ["FlowType"]
    });
    defineType("FunctionTypeAnnotation", {
      visitor: ["typeParameters", "params", "rest", "returnType"],
      aliases: ["FlowType"],
      fields: {
        typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
        params: (0, _utils.validateArrayOfType)("FunctionTypeParam"),
        rest: (0, _utils.validateOptionalType)("FunctionTypeParam"),
        this: (0, _utils.validateOptionalType)("FunctionTypeParam"),
        returnType: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("FunctionTypeParam", {
      visitor: ["name", "typeAnnotation"],
      fields: {
        name: (0, _utils.validateOptionalType)("Identifier"),
        typeAnnotation: (0, _utils.validateType)("FlowType"),
        optional: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("GenericTypeAnnotation", {
      visitor: ["id", "typeParameters"],
      aliases: ["FlowType"],
      fields: {
        id: (0, _utils.validateType)("Identifier", "QualifiedTypeIdentifier"),
        typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
      }
    });
    defineType("InferredPredicate", {
      aliases: ["FlowPredicate"]
    });
    defineType("InterfaceExtends", {
      visitor: ["id", "typeParameters"],
      fields: {
        id: (0, _utils.validateType)("Identifier", "QualifiedTypeIdentifier"),
        typeParameters: (0, _utils.validateOptionalType)("TypeParameterInstantiation")
      }
    });
    defineInterfaceishType("InterfaceDeclaration");
    defineType("InterfaceTypeAnnotation", {
      visitor: ["extends", "body"],
      aliases: ["FlowType"],
      fields: {
        extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("InterfaceExtends")),
        body: (0, _utils.validateType)("ObjectTypeAnnotation")
      }
    });
    defineType("IntersectionTypeAnnotation", {
      visitor: ["types"],
      aliases: ["FlowType"],
      fields: {
        types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
      }
    });
    defineType("MixedTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("EmptyTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("NullableTypeAnnotation", {
      visitor: ["typeAnnotation"],
      aliases: ["FlowType"],
      fields: {
        typeAnnotation: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("NumberLiteralTypeAnnotation", {
      builder: ["value"],
      aliases: ["FlowType"],
      fields: {
        value: (0, _utils.validate)((0, _utils.assertValueType)("number"))
      }
    });
    defineType("NumberTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("ObjectTypeAnnotation", {
      visitor: ["properties", "indexers", "callProperties", "internalSlots"],
      aliases: ["FlowType"],
      builder: ["properties", "indexers", "callProperties", "internalSlots", "exact"],
      fields: {
        properties: (0, _utils.validate)((0, _utils.arrayOfType)("ObjectTypeProperty", "ObjectTypeSpreadProperty")),
        indexers: {
          validate: (0, _utils.arrayOfType)("ObjectTypeIndexer"),
          optional: true,
          default: []
        },
        callProperties: {
          validate: (0, _utils.arrayOfType)("ObjectTypeCallProperty"),
          optional: true,
          default: []
        },
        internalSlots: {
          validate: (0, _utils.arrayOfType)("ObjectTypeInternalSlot"),
          optional: true,
          default: []
        },
        exact: {
          validate: (0, _utils.assertValueType)("boolean"),
          default: false
        },
        inexact: (0, _utils.validateOptional)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("ObjectTypeInternalSlot", {
      visitor: ["id", "value"],
      builder: ["id", "value", "optional", "static", "method"],
      aliases: ["UserWhitespacable"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        value: (0, _utils.validateType)("FlowType"),
        optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
        static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
        method: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("ObjectTypeCallProperty", {
      visitor: ["value"],
      aliases: ["UserWhitespacable"],
      fields: {
        value: (0, _utils.validateType)("FlowType"),
        static: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("ObjectTypeIndexer", {
      visitor: ["variance", "id", "key", "value"],
      builder: ["id", "key", "value", "variance"],
      aliases: ["UserWhitespacable"],
      fields: {
        id: (0, _utils.validateOptionalType)("Identifier"),
        key: (0, _utils.validateType)("FlowType"),
        value: (0, _utils.validateType)("FlowType"),
        static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
        variance: (0, _utils.validateOptionalType)("Variance")
      }
    });
    defineType("ObjectTypeProperty", {
      visitor: ["key", "value", "variance"],
      aliases: ["UserWhitespacable"],
      fields: {
        key: (0, _utils.validateType)("Identifier", "StringLiteral"),
        value: (0, _utils.validateType)("FlowType"),
        kind: (0, _utils.validate)((0, _utils.assertOneOf)("init", "get", "set")),
        static: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
        proto: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
        optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
        variance: (0, _utils.validateOptionalType)("Variance"),
        method: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("ObjectTypeSpreadProperty", {
      visitor: ["argument"],
      aliases: ["UserWhitespacable"],
      fields: {
        argument: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("OpaqueType", {
      visitor: ["id", "typeParameters", "supertype", "impltype"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
        supertype: (0, _utils.validateOptionalType)("FlowType"),
        impltype: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("QualifiedTypeIdentifier", {
      visitor: ["qualification", "id"],
      builder: ["id", "qualification"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        qualification: (0, _utils.validateType)("Identifier", "QualifiedTypeIdentifier")
      }
    });
    defineType("StringLiteralTypeAnnotation", {
      builder: ["value"],
      aliases: ["FlowType"],
      fields: {
        value: (0, _utils.validate)((0, _utils.assertValueType)("string"))
      }
    });
    defineType("StringTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("SymbolTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("ThisTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("TupleTypeAnnotation", {
      visitor: ["types"],
      aliases: ["FlowType"],
      fields: {
        types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
      }
    });
    defineType("TypeofTypeAnnotation", {
      visitor: ["argument"],
      aliases: ["FlowType"],
      fields: {
        argument: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("TypeAlias", {
      visitor: ["id", "typeParameters", "right"],
      aliases: ["FlowDeclaration", "Statement", "Declaration"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        typeParameters: (0, _utils.validateOptionalType)("TypeParameterDeclaration"),
        right: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("TypeAnnotation", {
      visitor: ["typeAnnotation"],
      fields: {
        typeAnnotation: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("TypeCastExpression", {
      visitor: ["expression", "typeAnnotation"],
      aliases: ["ExpressionWrapper", "Expression"],
      fields: {
        expression: (0, _utils.validateType)("Expression"),
        typeAnnotation: (0, _utils.validateType)("TypeAnnotation")
      }
    });
    defineType("TypeParameter", {
      visitor: ["bound", "default", "variance"],
      fields: {
        name: (0, _utils.validate)((0, _utils.assertValueType)("string")),
        bound: (0, _utils.validateOptionalType)("TypeAnnotation"),
        default: (0, _utils.validateOptionalType)("FlowType"),
        variance: (0, _utils.validateOptionalType)("Variance")
      }
    });
    defineType("TypeParameterDeclaration", {
      visitor: ["params"],
      fields: {
        params: (0, _utils.validate)((0, _utils.arrayOfType)("TypeParameter"))
      }
    });
    defineType("TypeParameterInstantiation", {
      visitor: ["params"],
      fields: {
        params: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
      }
    });
    defineType("UnionTypeAnnotation", {
      visitor: ["types"],
      aliases: ["FlowType"],
      fields: {
        types: (0, _utils.validate)((0, _utils.arrayOfType)("FlowType"))
      }
    });
    defineType("Variance", {
      builder: ["kind"],
      fields: {
        kind: (0, _utils.validate)((0, _utils.assertOneOf)("minus", "plus"))
      }
    });
    defineType("VoidTypeAnnotation", {
      aliases: ["FlowType", "FlowBaseAnnotation"]
    });
    defineType("EnumDeclaration", {
      aliases: ["Statement", "Declaration"],
      visitor: ["id", "body"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        body: (0, _utils.validateType)("EnumBooleanBody", "EnumNumberBody", "EnumStringBody", "EnumSymbolBody")
      }
    });
    defineType("EnumBooleanBody", {
      aliases: ["EnumBody"],
      visitor: ["members"],
      fields: {
        explicitType: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
        members: (0, _utils.validateArrayOfType)("EnumBooleanMember"),
        hasUnknownMembers: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("EnumNumberBody", {
      aliases: ["EnumBody"],
      visitor: ["members"],
      fields: {
        explicitType: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
        members: (0, _utils.validateArrayOfType)("EnumNumberMember"),
        hasUnknownMembers: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("EnumStringBody", {
      aliases: ["EnumBody"],
      visitor: ["members"],
      fields: {
        explicitType: (0, _utils.validate)((0, _utils.assertValueType)("boolean")),
        members: (0, _utils.validateArrayOfType)("EnumStringMember", "EnumDefaultedMember"),
        hasUnknownMembers: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("EnumSymbolBody", {
      aliases: ["EnumBody"],
      visitor: ["members"],
      fields: {
        members: (0, _utils.validateArrayOfType)("EnumDefaultedMember"),
        hasUnknownMembers: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
      }
    });
    defineType("EnumBooleanMember", {
      aliases: ["EnumMember"],
      visitor: ["id"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        init: (0, _utils.validateType)("BooleanLiteral")
      }
    });
    defineType("EnumNumberMember", {
      aliases: ["EnumMember"],
      visitor: ["id", "init"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        init: (0, _utils.validateType)("NumericLiteral")
      }
    });
    defineType("EnumStringMember", {
      aliases: ["EnumMember"],
      visitor: ["id", "init"],
      fields: {
        id: (0, _utils.validateType)("Identifier"),
        init: (0, _utils.validateType)("StringLiteral")
      }
    });
    defineType("EnumDefaultedMember", {
      aliases: ["EnumMember"],
      visitor: ["id"],
      fields: {
        id: (0, _utils.validateType)("Identifier")
      }
    });
    defineType("IndexedAccessType", {
      visitor: ["objectType", "indexType"],
      aliases: ["FlowType"],
      fields: {
        objectType: (0, _utils.validateType)("FlowType"),
        indexType: (0, _utils.validateType)("FlowType")
      }
    });
    defineType("OptionalIndexedAccessType", {
      visitor: ["objectType", "indexType"],
      aliases: ["FlowType"],
      fields: {
        objectType: (0, _utils.validateType)("FlowType"),
        indexType: (0, _utils.validateType)("FlowType"),
        optional: (0, _utils.validate)((0, _utils.assertValueType)("boolean"))
      }
    });
  }
});

// ../../node_modules/@babel/types/lib/definitions/jsx.js
var require_jsx = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/jsx.js"() {
    "use strict";
    var _utils = require_utils();
    var defineType = (0, _utils.defineAliasedType)("JSX");
    defineType("JSXAttribute", {
      visitor: ["name", "value"],
      aliases: ["Immutable"],
      fields: {
        name: {
          validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXNamespacedName")
        },
        value: {
          optional: true,
          validate: (0, _utils.assertNodeType)("JSXElement", "JSXFragment", "StringLiteral", "JSXExpressionContainer")
        }
      }
    });
    defineType("JSXClosingElement", {
      visitor: ["name"],
      aliases: ["Immutable"],
      fields: {
        name: {
          validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
        }
      }
    });
    defineType("JSXElement", {
      builder: ["openingElement", "closingElement", "children", "selfClosing"],
      visitor: ["openingElement", "children", "closingElement"],
      aliases: ["Immutable", "Expression"],
      fields: Object.assign({
        openingElement: {
          validate: (0, _utils.assertNodeType)("JSXOpeningElement")
        },
        closingElement: {
          optional: true,
          validate: (0, _utils.assertNodeType)("JSXClosingElement")
        },
        children: (0, _utils.validateArrayOfType)("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")
      }, {
        selfClosing: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        }
      })
    });
    defineType("JSXEmptyExpression", {});
    defineType("JSXExpressionContainer", {
      visitor: ["expression"],
      aliases: ["Immutable"],
      fields: {
        expression: {
          validate: (0, _utils.assertNodeType)("Expression", "JSXEmptyExpression")
        }
      }
    });
    defineType("JSXSpreadChild", {
      visitor: ["expression"],
      aliases: ["Immutable"],
      fields: {
        expression: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    defineType("JSXIdentifier", {
      builder: ["name"],
      fields: {
        name: {
          validate: (0, _utils.assertValueType)("string")
        }
      }
    });
    defineType("JSXMemberExpression", {
      visitor: ["object", "property"],
      fields: {
        object: {
          validate: (0, _utils.assertNodeType)("JSXMemberExpression", "JSXIdentifier")
        },
        property: {
          validate: (0, _utils.assertNodeType)("JSXIdentifier")
        }
      }
    });
    defineType("JSXNamespacedName", {
      visitor: ["namespace", "name"],
      fields: {
        namespace: {
          validate: (0, _utils.assertNodeType)("JSXIdentifier")
        },
        name: {
          validate: (0, _utils.assertNodeType)("JSXIdentifier")
        }
      }
    });
    defineType("JSXOpeningElement", {
      builder: ["name", "attributes", "selfClosing"],
      visitor: ["name", "attributes"],
      aliases: ["Immutable"],
      fields: {
        name: {
          validate: (0, _utils.assertNodeType)("JSXIdentifier", "JSXMemberExpression", "JSXNamespacedName")
        },
        selfClosing: {
          default: false
        },
        attributes: (0, _utils.validateArrayOfType)("JSXAttribute", "JSXSpreadAttribute"),
        typeParameters: {
          validate: (0, _utils.assertNodeType)("TypeParameterInstantiation", "TSTypeParameterInstantiation"),
          optional: true
        }
      }
    });
    defineType("JSXSpreadAttribute", {
      visitor: ["argument"],
      fields: {
        argument: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    defineType("JSXText", {
      aliases: ["Immutable"],
      builder: ["value"],
      fields: {
        value: {
          validate: (0, _utils.assertValueType)("string")
        }
      }
    });
    defineType("JSXFragment", {
      builder: ["openingFragment", "closingFragment", "children"],
      visitor: ["openingFragment", "children", "closingFragment"],
      aliases: ["Immutable", "Expression"],
      fields: {
        openingFragment: {
          validate: (0, _utils.assertNodeType)("JSXOpeningFragment")
        },
        closingFragment: {
          validate: (0, _utils.assertNodeType)("JSXClosingFragment")
        },
        children: (0, _utils.validateArrayOfType)("JSXText", "JSXExpressionContainer", "JSXSpreadChild", "JSXElement", "JSXFragment")
      }
    });
    defineType("JSXOpeningFragment", {
      aliases: ["Immutable"]
    });
    defineType("JSXClosingFragment", {
      aliases: ["Immutable"]
    });
  }
});

// ../../node_modules/@babel/types/lib/definitions/placeholders.js
var require_placeholders = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/placeholders.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.PLACEHOLDERS_FLIPPED_ALIAS = exports2.PLACEHOLDERS_ALIAS = exports2.PLACEHOLDERS = void 0;
    var _utils = require_utils();
    var PLACEHOLDERS = exports2.PLACEHOLDERS = ["Identifier", "StringLiteral", "Expression", "Statement", "Declaration", "BlockStatement", "ClassBody", "Pattern"];
    var PLACEHOLDERS_ALIAS = exports2.PLACEHOLDERS_ALIAS = {
      Declaration: ["Statement"],
      Pattern: ["PatternLike", "LVal"]
    };
    for (const type of PLACEHOLDERS) {
      const alias = _utils.ALIAS_KEYS[type];
      if (alias != null && alias.length) PLACEHOLDERS_ALIAS[type] = alias;
    }
    var PLACEHOLDERS_FLIPPED_ALIAS = exports2.PLACEHOLDERS_FLIPPED_ALIAS = {};
    Object.keys(PLACEHOLDERS_ALIAS).forEach((type) => {
      PLACEHOLDERS_ALIAS[type].forEach((alias) => {
        if (!hasOwnProperty.call(PLACEHOLDERS_FLIPPED_ALIAS, alias)) {
          PLACEHOLDERS_FLIPPED_ALIAS[alias] = [];
        }
        PLACEHOLDERS_FLIPPED_ALIAS[alias].push(type);
      });
    });
  }
});

// ../../node_modules/@babel/types/lib/definitions/misc.js
var require_misc = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/misc.js"() {
    "use strict";
    var _utils = require_utils();
    var _placeholders = require_placeholders();
    var _core = require_core();
    var defineType = (0, _utils.defineAliasedType)("Miscellaneous");
    {
      defineType("Noop", {
        visitor: []
      });
    }
    defineType("Placeholder", {
      visitor: [],
      builder: ["expectedNode", "name"],
      fields: Object.assign({
        name: {
          validate: (0, _utils.assertNodeType)("Identifier")
        },
        expectedNode: {
          validate: (0, _utils.assertOneOf)(..._placeholders.PLACEHOLDERS)
        }
      }, (0, _core.patternLikeCommon)())
    });
    defineType("V8IntrinsicIdentifier", {
      builder: ["name"],
      fields: {
        name: {
          validate: (0, _utils.assertValueType)("string")
        }
      }
    });
  }
});

// ../../node_modules/@babel/types/lib/definitions/experimental.js
var require_experimental = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/experimental.js"() {
    "use strict";
    var _utils = require_utils();
    (0, _utils.default)("ArgumentPlaceholder", {});
    (0, _utils.default)("BindExpression", {
      visitor: ["object", "callee"],
      aliases: ["Expression"],
      fields: !process.env.BABEL_TYPES_8_BREAKING ? {
        object: {
          validate: Object.assign(() => {
          }, {
            oneOfNodeTypes: ["Expression"]
          })
        },
        callee: {
          validate: Object.assign(() => {
          }, {
            oneOfNodeTypes: ["Expression"]
          })
        }
      } : {
        object: {
          validate: (0, _utils.assertNodeType)("Expression")
        },
        callee: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    (0, _utils.default)("ImportAttribute", {
      visitor: ["key", "value"],
      fields: {
        key: {
          validate: (0, _utils.assertNodeType)("Identifier", "StringLiteral")
        },
        value: {
          validate: (0, _utils.assertNodeType)("StringLiteral")
        }
      }
    });
    (0, _utils.default)("Decorator", {
      visitor: ["expression"],
      fields: {
        expression: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      }
    });
    (0, _utils.default)("DoExpression", {
      visitor: ["body"],
      builder: ["body", "async"],
      aliases: ["Expression"],
      fields: {
        body: {
          validate: (0, _utils.assertNodeType)("BlockStatement")
        },
        async: {
          validate: (0, _utils.assertValueType)("boolean"),
          default: false
        }
      }
    });
    (0, _utils.default)("ExportDefaultSpecifier", {
      visitor: ["exported"],
      aliases: ["ModuleSpecifier"],
      fields: {
        exported: {
          validate: (0, _utils.assertNodeType)("Identifier")
        }
      }
    });
    (0, _utils.default)("RecordExpression", {
      visitor: ["properties"],
      aliases: ["Expression"],
      fields: {
        properties: (0, _utils.validateArrayOfType)("ObjectProperty", "SpreadElement")
      }
    });
    (0, _utils.default)("TupleExpression", {
      fields: {
        elements: {
          validate: (0, _utils.arrayOfType)("Expression", "SpreadElement"),
          default: []
        }
      },
      visitor: ["elements"],
      aliases: ["Expression"]
    });
    {
      (0, _utils.default)("DecimalLiteral", {
        builder: ["value"],
        fields: {
          value: {
            validate: (0, _utils.assertValueType)("string")
          }
        },
        aliases: ["Expression", "Pureish", "Literal", "Immutable"]
      });
    }
    (0, _utils.default)("ModuleExpression", {
      visitor: ["body"],
      fields: {
        body: {
          validate: (0, _utils.assertNodeType)("Program")
        }
      },
      aliases: ["Expression"]
    });
    (0, _utils.default)("TopicReference", {
      aliases: ["Expression"]
    });
    (0, _utils.default)("PipelineTopicExpression", {
      builder: ["expression"],
      visitor: ["expression"],
      fields: {
        expression: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      },
      aliases: ["Expression"]
    });
    (0, _utils.default)("PipelineBareFunction", {
      builder: ["callee"],
      visitor: ["callee"],
      fields: {
        callee: {
          validate: (0, _utils.assertNodeType)("Expression")
        }
      },
      aliases: ["Expression"]
    });
    (0, _utils.default)("PipelinePrimaryTopicReference", {
      aliases: ["Expression"]
    });
  }
});

// ../../node_modules/@babel/types/lib/definitions/typescript.js
var require_typescript = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/typescript.js"() {
    "use strict";
    var _utils = require_utils();
    var _core = require_core();
    var _is = require_is();
    var defineType = (0, _utils.defineAliasedType)("TypeScript");
    var bool = (0, _utils.assertValueType)("boolean");
    var tSFunctionTypeAnnotationCommon = () => ({
      returnType: {
        validate: (0, _utils.assertNodeType)("TSTypeAnnotation", "Noop"),
        optional: true
      },
      typeParameters: {
        validate: (0, _utils.assertNodeType)("TSTypeParameterDeclaration", "Noop"),
        optional: true
      }
    });
    defineType("TSParameterProperty", {
      aliases: ["LVal"],
      visitor: ["parameter"],
      fields: {
        accessibility: {
          validate: (0, _utils.assertOneOf)("public", "private", "protected"),
          optional: true
        },
        readonly: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        parameter: {
          validate: (0, _utils.assertNodeType)("Identifier", "AssignmentPattern")
        },
        override: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        decorators: {
          validate: (0, _utils.arrayOfType)("Decorator"),
          optional: true
        }
      }
    });
    defineType("TSDeclareFunction", {
      aliases: ["Statement", "Declaration"],
      visitor: ["id", "typeParameters", "params", "returnType"],
      fields: Object.assign({}, (0, _core.functionDeclarationCommon)(), tSFunctionTypeAnnotationCommon())
    });
    defineType("TSDeclareMethod", {
      visitor: ["decorators", "key", "typeParameters", "params", "returnType"],
      fields: Object.assign({}, (0, _core.classMethodOrDeclareMethodCommon)(), tSFunctionTypeAnnotationCommon())
    });
    defineType("TSQualifiedName", {
      aliases: ["TSEntityName"],
      visitor: ["left", "right"],
      fields: {
        left: (0, _utils.validateType)("TSEntityName"),
        right: (0, _utils.validateType)("Identifier")
      }
    });
    var signatureDeclarationCommon = () => ({
      typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
      ["parameters"]: (0, _utils.validateArrayOfType)("ArrayPattern", "Identifier", "ObjectPattern", "RestElement"),
      ["typeAnnotation"]: (0, _utils.validateOptionalType)("TSTypeAnnotation")
    });
    var callConstructSignatureDeclaration = {
      aliases: ["TSTypeElement"],
      visitor: ["typeParameters", "parameters", "typeAnnotation"],
      fields: signatureDeclarationCommon()
    };
    defineType("TSCallSignatureDeclaration", callConstructSignatureDeclaration);
    defineType("TSConstructSignatureDeclaration", callConstructSignatureDeclaration);
    var namedTypeElementCommon = () => ({
      key: (0, _utils.validateType)("Expression"),
      computed: {
        default: false
      },
      optional: (0, _utils.validateOptional)(bool)
    });
    defineType("TSPropertySignature", {
      aliases: ["TSTypeElement"],
      visitor: ["key", "typeAnnotation"],
      fields: Object.assign({}, namedTypeElementCommon(), {
        readonly: (0, _utils.validateOptional)(bool),
        typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation"),
        kind: {
          validate: (0, _utils.assertOneOf)("get", "set")
        }
      })
    });
    defineType("TSMethodSignature", {
      aliases: ["TSTypeElement"],
      visitor: ["key", "typeParameters", "parameters", "typeAnnotation"],
      fields: Object.assign({}, signatureDeclarationCommon(), namedTypeElementCommon(), {
        kind: {
          validate: (0, _utils.assertOneOf)("method", "get", "set")
        }
      })
    });
    defineType("TSIndexSignature", {
      aliases: ["TSTypeElement"],
      visitor: ["parameters", "typeAnnotation"],
      fields: {
        readonly: (0, _utils.validateOptional)(bool),
        static: (0, _utils.validateOptional)(bool),
        parameters: (0, _utils.validateArrayOfType)("Identifier"),
        typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation")
      }
    });
    var tsKeywordTypes = ["TSAnyKeyword", "TSBooleanKeyword", "TSBigIntKeyword", "TSIntrinsicKeyword", "TSNeverKeyword", "TSNullKeyword", "TSNumberKeyword", "TSObjectKeyword", "TSStringKeyword", "TSSymbolKeyword", "TSUndefinedKeyword", "TSUnknownKeyword", "TSVoidKeyword"];
    for (const type of tsKeywordTypes) {
      defineType(type, {
        aliases: ["TSType", "TSBaseType"],
        visitor: [],
        fields: {}
      });
    }
    defineType("TSThisType", {
      aliases: ["TSType", "TSBaseType"],
      visitor: [],
      fields: {}
    });
    var fnOrCtrBase = {
      aliases: ["TSType"],
      visitor: ["typeParameters", "parameters", "typeAnnotation"]
    };
    defineType("TSFunctionType", Object.assign({}, fnOrCtrBase, {
      fields: signatureDeclarationCommon()
    }));
    defineType("TSConstructorType", Object.assign({}, fnOrCtrBase, {
      fields: Object.assign({}, signatureDeclarationCommon(), {
        abstract: (0, _utils.validateOptional)(bool)
      })
    }));
    defineType("TSTypeReference", {
      aliases: ["TSType"],
      visitor: ["typeName", "typeParameters"],
      fields: {
        typeName: (0, _utils.validateType)("TSEntityName"),
        typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
      }
    });
    defineType("TSTypePredicate", {
      aliases: ["TSType"],
      visitor: ["parameterName", "typeAnnotation"],
      builder: ["parameterName", "typeAnnotation", "asserts"],
      fields: {
        parameterName: (0, _utils.validateType)("Identifier", "TSThisType"),
        typeAnnotation: (0, _utils.validateOptionalType)("TSTypeAnnotation"),
        asserts: (0, _utils.validateOptional)(bool)
      }
    });
    defineType("TSTypeQuery", {
      aliases: ["TSType"],
      visitor: ["exprName", "typeParameters"],
      fields: {
        exprName: (0, _utils.validateType)("TSEntityName", "TSImportType"),
        typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
      }
    });
    defineType("TSTypeLiteral", {
      aliases: ["TSType"],
      visitor: ["members"],
      fields: {
        members: (0, _utils.validateArrayOfType)("TSTypeElement")
      }
    });
    defineType("TSArrayType", {
      aliases: ["TSType"],
      visitor: ["elementType"],
      fields: {
        elementType: (0, _utils.validateType)("TSType")
      }
    });
    defineType("TSTupleType", {
      aliases: ["TSType"],
      visitor: ["elementTypes"],
      fields: {
        elementTypes: (0, _utils.validateArrayOfType)("TSType", "TSNamedTupleMember")
      }
    });
    defineType("TSOptionalType", {
      aliases: ["TSType"],
      visitor: ["typeAnnotation"],
      fields: {
        typeAnnotation: (0, _utils.validateType)("TSType")
      }
    });
    defineType("TSRestType", {
      aliases: ["TSType"],
      visitor: ["typeAnnotation"],
      fields: {
        typeAnnotation: (0, _utils.validateType)("TSType")
      }
    });
    defineType("TSNamedTupleMember", {
      visitor: ["label", "elementType"],
      builder: ["label", "elementType", "optional"],
      fields: {
        label: (0, _utils.validateType)("Identifier"),
        optional: {
          validate: bool,
          default: false
        },
        elementType: (0, _utils.validateType)("TSType")
      }
    });
    var unionOrIntersection = {
      aliases: ["TSType"],
      visitor: ["types"],
      fields: {
        types: (0, _utils.validateArrayOfType)("TSType")
      }
    };
    defineType("TSUnionType", unionOrIntersection);
    defineType("TSIntersectionType", unionOrIntersection);
    defineType("TSConditionalType", {
      aliases: ["TSType"],
      visitor: ["checkType", "extendsType", "trueType", "falseType"],
      fields: {
        checkType: (0, _utils.validateType)("TSType"),
        extendsType: (0, _utils.validateType)("TSType"),
        trueType: (0, _utils.validateType)("TSType"),
        falseType: (0, _utils.validateType)("TSType")
      }
    });
    defineType("TSInferType", {
      aliases: ["TSType"],
      visitor: ["typeParameter"],
      fields: {
        typeParameter: (0, _utils.validateType)("TSTypeParameter")
      }
    });
    defineType("TSParenthesizedType", {
      aliases: ["TSType"],
      visitor: ["typeAnnotation"],
      fields: {
        typeAnnotation: (0, _utils.validateType)("TSType")
      }
    });
    defineType("TSTypeOperator", {
      aliases: ["TSType"],
      visitor: ["typeAnnotation"],
      fields: {
        operator: (0, _utils.validate)((0, _utils.assertValueType)("string")),
        typeAnnotation: (0, _utils.validateType)("TSType")
      }
    });
    defineType("TSIndexedAccessType", {
      aliases: ["TSType"],
      visitor: ["objectType", "indexType"],
      fields: {
        objectType: (0, _utils.validateType)("TSType"),
        indexType: (0, _utils.validateType)("TSType")
      }
    });
    defineType("TSMappedType", {
      aliases: ["TSType"],
      visitor: ["typeParameter", "nameType", "typeAnnotation"],
      builder: ["typeParameter", "typeAnnotation", "nameType"],
      fields: Object.assign({}, {
        typeParameter: (0, _utils.validateType)("TSTypeParameter")
      }, {
        readonly: (0, _utils.validateOptional)((0, _utils.assertOneOf)(true, false, "+", "-")),
        optional: (0, _utils.validateOptional)((0, _utils.assertOneOf)(true, false, "+", "-")),
        typeAnnotation: (0, _utils.validateOptionalType)("TSType"),
        nameType: (0, _utils.validateOptionalType)("TSType")
      })
    });
    defineType("TSLiteralType", {
      aliases: ["TSType", "TSBaseType"],
      visitor: ["literal"],
      fields: {
        literal: {
          validate: function() {
            const unaryExpression2 = (0, _utils.assertNodeType)("NumericLiteral", "BigIntLiteral");
            const unaryOperator = (0, _utils.assertOneOf)("-");
            const literal = (0, _utils.assertNodeType)("NumericLiteral", "StringLiteral", "BooleanLiteral", "BigIntLiteral", "TemplateLiteral");
            function validator(parent, key, node) {
              if ((0, _is.default)("UnaryExpression", node)) {
                unaryOperator(node, "operator", node.operator);
                unaryExpression2(node, "argument", node.argument);
              } else {
                literal(parent, key, node);
              }
            }
            validator.oneOfNodeTypes = ["NumericLiteral", "StringLiteral", "BooleanLiteral", "BigIntLiteral", "TemplateLiteral", "UnaryExpression"];
            return validator;
          }()
        }
      }
    });
    var expressionWithTypeArguments = {
      aliases: ["TSType"],
      visitor: ["expression", "typeParameters"],
      fields: {
        expression: (0, _utils.validateType)("TSEntityName"),
        typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
      }
    };
    {
      defineType("TSExpressionWithTypeArguments", expressionWithTypeArguments);
    }
    defineType("TSInterfaceDeclaration", {
      aliases: ["Statement", "Declaration"],
      visitor: ["id", "typeParameters", "extends", "body"],
      fields: {
        declare: (0, _utils.validateOptional)(bool),
        id: (0, _utils.validateType)("Identifier"),
        typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
        extends: (0, _utils.validateOptional)((0, _utils.arrayOfType)("TSExpressionWithTypeArguments")),
        body: (0, _utils.validateType)("TSInterfaceBody")
      }
    });
    defineType("TSInterfaceBody", {
      visitor: ["body"],
      fields: {
        body: (0, _utils.validateArrayOfType)("TSTypeElement")
      }
    });
    defineType("TSTypeAliasDeclaration", {
      aliases: ["Statement", "Declaration"],
      visitor: ["id", "typeParameters", "typeAnnotation"],
      fields: {
        declare: (0, _utils.validateOptional)(bool),
        id: (0, _utils.validateType)("Identifier"),
        typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterDeclaration"),
        typeAnnotation: (0, _utils.validateType)("TSType")
      }
    });
    defineType("TSInstantiationExpression", {
      aliases: ["Expression"],
      visitor: ["expression", "typeParameters"],
      fields: {
        expression: (0, _utils.validateType)("Expression"),
        typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation")
      }
    });
    var TSTypeExpression = {
      aliases: ["Expression", "LVal", "PatternLike"],
      visitor: ["expression", "typeAnnotation"],
      fields: {
        expression: (0, _utils.validateType)("Expression"),
        typeAnnotation: (0, _utils.validateType)("TSType")
      }
    };
    defineType("TSAsExpression", TSTypeExpression);
    defineType("TSSatisfiesExpression", TSTypeExpression);
    defineType("TSTypeAssertion", {
      aliases: ["Expression", "LVal", "PatternLike"],
      visitor: ["typeAnnotation", "expression"],
      fields: {
        typeAnnotation: (0, _utils.validateType)("TSType"),
        expression: (0, _utils.validateType)("Expression")
      }
    });
    defineType("TSEnumDeclaration", {
      aliases: ["Statement", "Declaration"],
      visitor: ["id", "members"],
      fields: {
        declare: (0, _utils.validateOptional)(bool),
        const: (0, _utils.validateOptional)(bool),
        id: (0, _utils.validateType)("Identifier"),
        members: (0, _utils.validateArrayOfType)("TSEnumMember"),
        initializer: (0, _utils.validateOptionalType)("Expression")
      }
    });
    defineType("TSEnumMember", {
      visitor: ["id", "initializer"],
      fields: {
        id: (0, _utils.validateType)("Identifier", "StringLiteral"),
        initializer: (0, _utils.validateOptionalType)("Expression")
      }
    });
    defineType("TSModuleDeclaration", {
      aliases: ["Statement", "Declaration"],
      visitor: ["id", "body"],
      fields: Object.assign({
        kind: {
          validate: (0, _utils.assertOneOf)("global", "module", "namespace")
        },
        declare: (0, _utils.validateOptional)(bool)
      }, {
        global: (0, _utils.validateOptional)(bool)
      }, {
        id: (0, _utils.validateType)("Identifier", "StringLiteral"),
        body: (0, _utils.validateType)("TSModuleBlock", "TSModuleDeclaration")
      })
    });
    defineType("TSModuleBlock", {
      aliases: ["Scopable", "Block", "BlockParent", "FunctionParent"],
      visitor: ["body"],
      fields: {
        body: (0, _utils.validateArrayOfType)("Statement")
      }
    });
    defineType("TSImportType", {
      aliases: ["TSType"],
      visitor: ["argument", "qualifier", "typeParameters"],
      fields: {
        argument: (0, _utils.validateType)("StringLiteral"),
        qualifier: (0, _utils.validateOptionalType)("TSEntityName"),
        typeParameters: (0, _utils.validateOptionalType)("TSTypeParameterInstantiation"),
        options: {
          validate: (0, _utils.assertNodeType)("Expression"),
          optional: true
        }
      }
    });
    defineType("TSImportEqualsDeclaration", {
      aliases: ["Statement"],
      visitor: ["id", "moduleReference"],
      fields: {
        isExport: (0, _utils.validate)(bool),
        id: (0, _utils.validateType)("Identifier"),
        moduleReference: (0, _utils.validateType)("TSEntityName", "TSExternalModuleReference"),
        importKind: {
          validate: (0, _utils.assertOneOf)("type", "value"),
          optional: true
        }
      }
    });
    defineType("TSExternalModuleReference", {
      visitor: ["expression"],
      fields: {
        expression: (0, _utils.validateType)("StringLiteral")
      }
    });
    defineType("TSNonNullExpression", {
      aliases: ["Expression", "LVal", "PatternLike"],
      visitor: ["expression"],
      fields: {
        expression: (0, _utils.validateType)("Expression")
      }
    });
    defineType("TSExportAssignment", {
      aliases: ["Statement"],
      visitor: ["expression"],
      fields: {
        expression: (0, _utils.validateType)("Expression")
      }
    });
    defineType("TSNamespaceExportDeclaration", {
      aliases: ["Statement"],
      visitor: ["id"],
      fields: {
        id: (0, _utils.validateType)("Identifier")
      }
    });
    defineType("TSTypeAnnotation", {
      visitor: ["typeAnnotation"],
      fields: {
        typeAnnotation: {
          validate: (0, _utils.assertNodeType)("TSType")
        }
      }
    });
    defineType("TSTypeParameterInstantiation", {
      visitor: ["params"],
      fields: {
        params: (0, _utils.validateArrayOfType)("TSType")
      }
    });
    defineType("TSTypeParameterDeclaration", {
      visitor: ["params"],
      fields: {
        params: (0, _utils.validateArrayOfType)("TSTypeParameter")
      }
    });
    defineType("TSTypeParameter", {
      builder: ["constraint", "default", "name"],
      visitor: ["constraint", "default"],
      fields: {
        name: {
          validate: (0, _utils.assertValueType)("string")
        },
        in: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        out: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        const: {
          validate: (0, _utils.assertValueType)("boolean"),
          optional: true
        },
        constraint: {
          validate: (0, _utils.assertNodeType)("TSType"),
          optional: true
        },
        default: {
          validate: (0, _utils.assertNodeType)("TSType"),
          optional: true
        }
      }
    });
  }
});

// ../../node_modules/@babel/types/lib/definitions/deprecated-aliases.js
var require_deprecated_aliases = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/deprecated-aliases.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.DEPRECATED_ALIASES = void 0;
    var DEPRECATED_ALIASES = exports2.DEPRECATED_ALIASES = {
      ModuleDeclaration: "ImportOrExportDeclaration"
    };
  }
});

// ../../node_modules/@babel/types/lib/definitions/index.js
var require_definitions = __commonJS({
  "../../node_modules/@babel/types/lib/definitions/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    Object.defineProperty(exports2, "ALIAS_KEYS", {
      enumerable: true,
      get: function() {
        return _utils.ALIAS_KEYS;
      }
    });
    Object.defineProperty(exports2, "BUILDER_KEYS", {
      enumerable: true,
      get: function() {
        return _utils.BUILDER_KEYS;
      }
    });
    Object.defineProperty(exports2, "DEPRECATED_ALIASES", {
      enumerable: true,
      get: function() {
        return _deprecatedAliases.DEPRECATED_ALIASES;
      }
    });
    Object.defineProperty(exports2, "DEPRECATED_KEYS", {
      enumerable: true,
      get: function() {
        return _utils.DEPRECATED_KEYS;
      }
    });
    Object.defineProperty(exports2, "FLIPPED_ALIAS_KEYS", {
      enumerable: true,
      get: function() {
        return _utils.FLIPPED_ALIAS_KEYS;
      }
    });
    Object.defineProperty(exports2, "NODE_FIELDS", {
      enumerable: true,
      get: function() {
        return _utils.NODE_FIELDS;
      }
    });
    Object.defineProperty(exports2, "NODE_PARENT_VALIDATIONS", {
      enumerable: true,
      get: function() {
        return _utils.NODE_PARENT_VALIDATIONS;
      }
    });
    Object.defineProperty(exports2, "PLACEHOLDERS", {
      enumerable: true,
      get: function() {
        return _placeholders.PLACEHOLDERS;
      }
    });
    Object.defineProperty(exports2, "PLACEHOLDERS_ALIAS", {
      enumerable: true,
      get: function() {
        return _placeholders.PLACEHOLDERS_ALIAS;
      }
    });
    Object.defineProperty(exports2, "PLACEHOLDERS_FLIPPED_ALIAS", {
      enumerable: true,
      get: function() {
        return _placeholders.PLACEHOLDERS_FLIPPED_ALIAS;
      }
    });
    exports2.TYPES = void 0;
    Object.defineProperty(exports2, "VISITOR_KEYS", {
      enumerable: true,
      get: function() {
        return _utils.VISITOR_KEYS;
      }
    });
    require_core();
    require_flow();
    require_jsx();
    require_misc();
    require_experimental();
    require_typescript();
    var _utils = require_utils();
    var _placeholders = require_placeholders();
    var _deprecatedAliases = require_deprecated_aliases();
    Object.keys(_deprecatedAliases.DEPRECATED_ALIASES).forEach((deprecatedAlias) => {
      _utils.FLIPPED_ALIAS_KEYS[deprecatedAlias] = _utils.FLIPPED_ALIAS_KEYS[_deprecatedAliases.DEPRECATED_ALIASES[deprecatedAlias]];
    });
    var TYPES = exports2.TYPES = [].concat(Object.keys(_utils.VISITOR_KEYS), Object.keys(_utils.FLIPPED_ALIAS_KEYS), Object.keys(_utils.DEPRECATED_KEYS));
  }
});

// ../../node_modules/@babel/types/lib/validators/validate.js
var require_validate = __commonJS({
  "../../node_modules/@babel/types/lib/validators/validate.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = validate2;
    exports2.validateChild = validateChild;
    exports2.validateField = validateField;
    exports2.validateInternal = validateInternal;
    var _index = require_definitions();
    function validate2(node, key, val) {
      if (!node) return;
      const fields = _index.NODE_FIELDS[node.type];
      if (!fields) return;
      const field = fields[key];
      validateField(node, key, val, field);
      validateChild(node, key, val);
    }
    function validateInternal(field, node, key, val, maybeNode) {
      if (!(field != null && field.validate)) return;
      if (field.optional && val == null) return;
      field.validate(node, key, val);
      if (maybeNode) {
        var _NODE_PARENT_VALIDATI;
        const type = val.type;
        if (type == null) return;
        (_NODE_PARENT_VALIDATI = _index.NODE_PARENT_VALIDATIONS[type]) == null || _NODE_PARENT_VALIDATI.call(_index.NODE_PARENT_VALIDATIONS, node, key, val);
      }
    }
    function validateField(node, key, val, field) {
      if (!(field != null && field.validate)) return;
      if (field.optional && val == null) return;
      field.validate(node, key, val);
    }
    function validateChild(node, key, val) {
      var _NODE_PARENT_VALIDATI2;
      const type = val == null ? void 0 : val.type;
      if (type == null) return;
      (_NODE_PARENT_VALIDATI2 = _index.NODE_PARENT_VALIDATIONS[type]) == null || _NODE_PARENT_VALIDATI2.call(_index.NODE_PARENT_VALIDATIONS, node, key, val);
    }
  }
});

// ../../node_modules/@babel/types/lib/builders/generated/index.js
var require_generated2 = __commonJS({
  "../../node_modules/@babel/types/lib/builders/generated/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.anyTypeAnnotation = anyTypeAnnotation;
    exports2.argumentPlaceholder = argumentPlaceholder;
    exports2.arrayExpression = arrayExpression2;
    exports2.arrayPattern = arrayPattern2;
    exports2.arrayTypeAnnotation = arrayTypeAnnotation;
    exports2.arrowFunctionExpression = arrowFunctionExpression2;
    exports2.assignmentExpression = assignmentExpression2;
    exports2.assignmentPattern = assignmentPattern;
    exports2.awaitExpression = awaitExpression2;
    exports2.bigIntLiteral = bigIntLiteral;
    exports2.binaryExpression = binaryExpression2;
    exports2.bindExpression = bindExpression;
    exports2.blockStatement = blockStatement3;
    exports2.booleanLiteral = booleanLiteral2;
    exports2.booleanLiteralTypeAnnotation = booleanLiteralTypeAnnotation;
    exports2.booleanTypeAnnotation = booleanTypeAnnotation;
    exports2.breakStatement = breakStatement2;
    exports2.callExpression = callExpression3;
    exports2.catchClause = catchClause2;
    exports2.classAccessorProperty = classAccessorProperty;
    exports2.classBody = classBody;
    exports2.classDeclaration = classDeclaration;
    exports2.classExpression = classExpression;
    exports2.classImplements = classImplements;
    exports2.classMethod = classMethod;
    exports2.classPrivateMethod = classPrivateMethod;
    exports2.classPrivateProperty = classPrivateProperty;
    exports2.classProperty = classProperty;
    exports2.conditionalExpression = conditionalExpression3;
    exports2.continueStatement = continueStatement2;
    exports2.debuggerStatement = debuggerStatement2;
    exports2.decimalLiteral = decimalLiteral;
    exports2.declareClass = declareClass;
    exports2.declareExportAllDeclaration = declareExportAllDeclaration;
    exports2.declareExportDeclaration = declareExportDeclaration;
    exports2.declareFunction = declareFunction;
    exports2.declareInterface = declareInterface;
    exports2.declareModule = declareModule;
    exports2.declareModuleExports = declareModuleExports;
    exports2.declareOpaqueType = declareOpaqueType;
    exports2.declareTypeAlias = declareTypeAlias;
    exports2.declareVariable = declareVariable;
    exports2.declaredPredicate = declaredPredicate;
    exports2.decorator = decorator;
    exports2.directive = directive2;
    exports2.directiveLiteral = directiveLiteral2;
    exports2.doExpression = doExpression;
    exports2.doWhileStatement = doWhileStatement2;
    exports2.emptyStatement = emptyStatement2;
    exports2.emptyTypeAnnotation = emptyTypeAnnotation;
    exports2.enumBooleanBody = enumBooleanBody;
    exports2.enumBooleanMember = enumBooleanMember;
    exports2.enumDeclaration = enumDeclaration;
    exports2.enumDefaultedMember = enumDefaultedMember;
    exports2.enumNumberBody = enumNumberBody;
    exports2.enumNumberMember = enumNumberMember;
    exports2.enumStringBody = enumStringBody;
    exports2.enumStringMember = enumStringMember;
    exports2.enumSymbolBody = enumSymbolBody;
    exports2.existsTypeAnnotation = existsTypeAnnotation;
    exports2.exportAllDeclaration = exportAllDeclaration;
    exports2.exportDefaultDeclaration = exportDefaultDeclaration2;
    exports2.exportDefaultSpecifier = exportDefaultSpecifier;
    exports2.exportNamedDeclaration = exportNamedDeclaration;
    exports2.exportNamespaceSpecifier = exportNamespaceSpecifier;
    exports2.exportSpecifier = exportSpecifier;
    exports2.expressionStatement = expressionStatement2;
    exports2.file = file;
    exports2.forInStatement = forInStatement2;
    exports2.forOfStatement = forOfStatement2;
    exports2.forStatement = forStatement2;
    exports2.functionDeclaration = functionDeclaration3;
    exports2.functionExpression = functionExpression2;
    exports2.functionTypeAnnotation = functionTypeAnnotation;
    exports2.functionTypeParam = functionTypeParam;
    exports2.genericTypeAnnotation = genericTypeAnnotation;
    exports2.identifier = identifier4;
    exports2.ifStatement = ifStatement3;
    exports2.import = _import;
    exports2.importAttribute = importAttribute;
    exports2.importDeclaration = importDeclaration2;
    exports2.importDefaultSpecifier = importDefaultSpecifier;
    exports2.importExpression = importExpression;
    exports2.importNamespaceSpecifier = importNamespaceSpecifier;
    exports2.importSpecifier = importSpecifier2;
    exports2.indexedAccessType = indexedAccessType;
    exports2.inferredPredicate = inferredPredicate;
    exports2.interfaceDeclaration = interfaceDeclaration;
    exports2.interfaceExtends = interfaceExtends;
    exports2.interfaceTypeAnnotation = interfaceTypeAnnotation;
    exports2.interpreterDirective = interpreterDirective;
    exports2.intersectionTypeAnnotation = intersectionTypeAnnotation;
    exports2.jSXAttribute = exports2.jsxAttribute = jsxAttribute2;
    exports2.jSXClosingElement = exports2.jsxClosingElement = jsxClosingElement2;
    exports2.jSXClosingFragment = exports2.jsxClosingFragment = jsxClosingFragment2;
    exports2.jSXElement = exports2.jsxElement = jsxElement2;
    exports2.jSXEmptyExpression = exports2.jsxEmptyExpression = jsxEmptyExpression;
    exports2.jSXExpressionContainer = exports2.jsxExpressionContainer = jsxExpressionContainer2;
    exports2.jSXFragment = exports2.jsxFragment = jsxFragment2;
    exports2.jSXIdentifier = exports2.jsxIdentifier = jsxIdentifier2;
    exports2.jSXMemberExpression = exports2.jsxMemberExpression = jsxMemberExpression2;
    exports2.jSXNamespacedName = exports2.jsxNamespacedName = jsxNamespacedName2;
    exports2.jSXOpeningElement = exports2.jsxOpeningElement = jsxOpeningElement2;
    exports2.jSXOpeningFragment = exports2.jsxOpeningFragment = jsxOpeningFragment2;
    exports2.jSXSpreadAttribute = exports2.jsxSpreadAttribute = jsxSpreadAttribute2;
    exports2.jSXSpreadChild = exports2.jsxSpreadChild = jsxSpreadChild;
    exports2.jSXText = exports2.jsxText = jsxText2;
    exports2.labeledStatement = labeledStatement2;
    exports2.logicalExpression = logicalExpression2;
    exports2.memberExpression = memberExpression2;
    exports2.metaProperty = metaProperty2;
    exports2.mixedTypeAnnotation = mixedTypeAnnotation;
    exports2.moduleExpression = moduleExpression;
    exports2.newExpression = newExpression2;
    exports2.noop = noop;
    exports2.nullLiteral = nullLiteral2;
    exports2.nullLiteralTypeAnnotation = nullLiteralTypeAnnotation;
    exports2.nullableTypeAnnotation = nullableTypeAnnotation;
    exports2.numberLiteral = NumberLiteral;
    exports2.numberLiteralTypeAnnotation = numberLiteralTypeAnnotation;
    exports2.numberTypeAnnotation = numberTypeAnnotation;
    exports2.numericLiteral = numericLiteral2;
    exports2.objectExpression = objectExpression2;
    exports2.objectMethod = objectMethod2;
    exports2.objectPattern = objectPattern2;
    exports2.objectProperty = objectProperty2;
    exports2.objectTypeAnnotation = objectTypeAnnotation;
    exports2.objectTypeCallProperty = objectTypeCallProperty;
    exports2.objectTypeIndexer = objectTypeIndexer;
    exports2.objectTypeInternalSlot = objectTypeInternalSlot;
    exports2.objectTypeProperty = objectTypeProperty;
    exports2.objectTypeSpreadProperty = objectTypeSpreadProperty;
    exports2.opaqueType = opaqueType;
    exports2.optionalCallExpression = optionalCallExpression2;
    exports2.optionalIndexedAccessType = optionalIndexedAccessType;
    exports2.optionalMemberExpression = optionalMemberExpression2;
    exports2.parenthesizedExpression = parenthesizedExpression;
    exports2.pipelineBareFunction = pipelineBareFunction;
    exports2.pipelinePrimaryTopicReference = pipelinePrimaryTopicReference;
    exports2.pipelineTopicExpression = pipelineTopicExpression;
    exports2.placeholder = placeholder;
    exports2.privateName = privateName;
    exports2.program = program;
    exports2.qualifiedTypeIdentifier = qualifiedTypeIdentifier;
    exports2.recordExpression = recordExpression;
    exports2.regExpLiteral = regExpLiteral2;
    exports2.regexLiteral = RegexLiteral;
    exports2.restElement = restElement3;
    exports2.restProperty = RestProperty;
    exports2.returnStatement = returnStatement3;
    exports2.sequenceExpression = sequenceExpression2;
    exports2.spreadElement = spreadElement3;
    exports2.spreadProperty = SpreadProperty;
    exports2.staticBlock = staticBlock;
    exports2.stringLiteral = stringLiteral3;
    exports2.stringLiteralTypeAnnotation = stringLiteralTypeAnnotation;
    exports2.stringTypeAnnotation = stringTypeAnnotation;
    exports2.super = _super;
    exports2.switchCase = switchCase2;
    exports2.switchStatement = switchStatement2;
    exports2.symbolTypeAnnotation = symbolTypeAnnotation;
    exports2.taggedTemplateExpression = taggedTemplateExpression2;
    exports2.templateElement = templateElement2;
    exports2.templateLiteral = templateLiteral2;
    exports2.thisExpression = thisExpression;
    exports2.thisTypeAnnotation = thisTypeAnnotation;
    exports2.throwStatement = throwStatement2;
    exports2.topicReference = topicReference;
    exports2.tryStatement = tryStatement2;
    exports2.tSAnyKeyword = exports2.tsAnyKeyword = tsAnyKeyword;
    exports2.tSArrayType = exports2.tsArrayType = tsArrayType;
    exports2.tSAsExpression = exports2.tsAsExpression = tsAsExpression2;
    exports2.tSBigIntKeyword = exports2.tsBigIntKeyword = tsBigIntKeyword;
    exports2.tSBooleanKeyword = exports2.tsBooleanKeyword = tsBooleanKeyword;
    exports2.tSCallSignatureDeclaration = exports2.tsCallSignatureDeclaration = tsCallSignatureDeclaration;
    exports2.tSConditionalType = exports2.tsConditionalType = tsConditionalType;
    exports2.tSConstructSignatureDeclaration = exports2.tsConstructSignatureDeclaration = tsConstructSignatureDeclaration;
    exports2.tSConstructorType = exports2.tsConstructorType = tsConstructorType;
    exports2.tSDeclareFunction = exports2.tsDeclareFunction = tsDeclareFunction;
    exports2.tSDeclareMethod = exports2.tsDeclareMethod = tsDeclareMethod;
    exports2.tSEnumDeclaration = exports2.tsEnumDeclaration = tsEnumDeclaration;
    exports2.tSEnumMember = exports2.tsEnumMember = tsEnumMember;
    exports2.tSExportAssignment = exports2.tsExportAssignment = tsExportAssignment;
    exports2.tSExpressionWithTypeArguments = exports2.tsExpressionWithTypeArguments = tsExpressionWithTypeArguments;
    exports2.tSExternalModuleReference = exports2.tsExternalModuleReference = tsExternalModuleReference;
    exports2.tSFunctionType = exports2.tsFunctionType = tsFunctionType;
    exports2.tSImportEqualsDeclaration = exports2.tsImportEqualsDeclaration = tsImportEqualsDeclaration;
    exports2.tSImportType = exports2.tsImportType = tsImportType;
    exports2.tSIndexSignature = exports2.tsIndexSignature = tsIndexSignature;
    exports2.tSIndexedAccessType = exports2.tsIndexedAccessType = tsIndexedAccessType;
    exports2.tSInferType = exports2.tsInferType = tsInferType;
    exports2.tSInstantiationExpression = exports2.tsInstantiationExpression = tsInstantiationExpression;
    exports2.tSInterfaceBody = exports2.tsInterfaceBody = tsInterfaceBody;
    exports2.tSInterfaceDeclaration = exports2.tsInterfaceDeclaration = tsInterfaceDeclaration;
    exports2.tSIntersectionType = exports2.tsIntersectionType = tsIntersectionType;
    exports2.tSIntrinsicKeyword = exports2.tsIntrinsicKeyword = tsIntrinsicKeyword;
    exports2.tSLiteralType = exports2.tsLiteralType = tsLiteralType;
    exports2.tSMappedType = exports2.tsMappedType = tsMappedType;
    exports2.tSMethodSignature = exports2.tsMethodSignature = tsMethodSignature;
    exports2.tSModuleBlock = exports2.tsModuleBlock = tsModuleBlock;
    exports2.tSModuleDeclaration = exports2.tsModuleDeclaration = tsModuleDeclaration;
    exports2.tSNamedTupleMember = exports2.tsNamedTupleMember = tsNamedTupleMember;
    exports2.tSNamespaceExportDeclaration = exports2.tsNamespaceExportDeclaration = tsNamespaceExportDeclaration;
    exports2.tSNeverKeyword = exports2.tsNeverKeyword = tsNeverKeyword;
    exports2.tSNonNullExpression = exports2.tsNonNullExpression = tsNonNullExpression;
    exports2.tSNullKeyword = exports2.tsNullKeyword = tsNullKeyword;
    exports2.tSNumberKeyword = exports2.tsNumberKeyword = tsNumberKeyword;
    exports2.tSObjectKeyword = exports2.tsObjectKeyword = tsObjectKeyword;
    exports2.tSOptionalType = exports2.tsOptionalType = tsOptionalType;
    exports2.tSParameterProperty = exports2.tsParameterProperty = tsParameterProperty;
    exports2.tSParenthesizedType = exports2.tsParenthesizedType = tsParenthesizedType;
    exports2.tSPropertySignature = exports2.tsPropertySignature = tsPropertySignature;
    exports2.tSQualifiedName = exports2.tsQualifiedName = tsQualifiedName;
    exports2.tSRestType = exports2.tsRestType = tsRestType;
    exports2.tSSatisfiesExpression = exports2.tsSatisfiesExpression = tsSatisfiesExpression2;
    exports2.tSStringKeyword = exports2.tsStringKeyword = tsStringKeyword;
    exports2.tSSymbolKeyword = exports2.tsSymbolKeyword = tsSymbolKeyword;
    exports2.tSThisType = exports2.tsThisType = tsThisType;
    exports2.tSTupleType = exports2.tsTupleType = tsTupleType;
    exports2.tSTypeAliasDeclaration = exports2.tsTypeAliasDeclaration = tsTypeAliasDeclaration;
    exports2.tSTypeAnnotation = exports2.tsTypeAnnotation = tsTypeAnnotation;
    exports2.tSTypeAssertion = exports2.tsTypeAssertion = tsTypeAssertion;
    exports2.tSTypeLiteral = exports2.tsTypeLiteral = tsTypeLiteral;
    exports2.tSTypeOperator = exports2.tsTypeOperator = tsTypeOperator;
    exports2.tSTypeParameter = exports2.tsTypeParameter = tsTypeParameter;
    exports2.tSTypeParameterDeclaration = exports2.tsTypeParameterDeclaration = tsTypeParameterDeclaration;
    exports2.tSTypeParameterInstantiation = exports2.tsTypeParameterInstantiation = tsTypeParameterInstantiation;
    exports2.tSTypePredicate = exports2.tsTypePredicate = tsTypePredicate;
    exports2.tSTypeQuery = exports2.tsTypeQuery = tsTypeQuery;
    exports2.tSTypeReference = exports2.tsTypeReference = tsTypeReference;
    exports2.tSUndefinedKeyword = exports2.tsUndefinedKeyword = tsUndefinedKeyword;
    exports2.tSUnionType = exports2.tsUnionType = tsUnionType;
    exports2.tSUnknownKeyword = exports2.tsUnknownKeyword = tsUnknownKeyword;
    exports2.tSVoidKeyword = exports2.tsVoidKeyword = tsVoidKeyword;
    exports2.tupleExpression = tupleExpression;
    exports2.tupleTypeAnnotation = tupleTypeAnnotation;
    exports2.typeAlias = typeAlias;
    exports2.typeAnnotation = typeAnnotation2;
    exports2.typeCastExpression = typeCastExpression2;
    exports2.typeParameter = typeParameter;
    exports2.typeParameterDeclaration = typeParameterDeclaration;
    exports2.typeParameterInstantiation = typeParameterInstantiation2;
    exports2.typeofTypeAnnotation = typeofTypeAnnotation;
    exports2.unaryExpression = unaryExpression2;
    exports2.unionTypeAnnotation = unionTypeAnnotation;
    exports2.updateExpression = updateExpression2;
    exports2.v8IntrinsicIdentifier = v8IntrinsicIdentifier;
    exports2.variableDeclaration = variableDeclaration3;
    exports2.variableDeclarator = variableDeclarator3;
    exports2.variance = variance;
    exports2.voidTypeAnnotation = voidTypeAnnotation;
    exports2.whileStatement = whileStatement2;
    exports2.withStatement = withStatement;
    exports2.yieldExpression = yieldExpression;
    var _validate = require_validate();
    var _deprecationWarning = require_deprecationWarning();
    var utils = require_utils();
    var {
      validateInternal: validate2
    } = _validate;
    var {
      NODE_FIELDS
    } = utils;
    function arrayExpression2(elements = []) {
      const node = {
        type: "ArrayExpression",
        elements
      };
      const defs = NODE_FIELDS.ArrayExpression;
      validate2(defs.elements, node, "elements", elements, 1);
      return node;
    }
    function assignmentExpression2(operator, left, right) {
      const node = {
        type: "AssignmentExpression",
        operator,
        left,
        right
      };
      const defs = NODE_FIELDS.AssignmentExpression;
      validate2(defs.operator, node, "operator", operator);
      validate2(defs.left, node, "left", left, 1);
      validate2(defs.right, node, "right", right, 1);
      return node;
    }
    function binaryExpression2(operator, left, right) {
      const node = {
        type: "BinaryExpression",
        operator,
        left,
        right
      };
      const defs = NODE_FIELDS.BinaryExpression;
      validate2(defs.operator, node, "operator", operator);
      validate2(defs.left, node, "left", left, 1);
      validate2(defs.right, node, "right", right, 1);
      return node;
    }
    function interpreterDirective(value) {
      const node = {
        type: "InterpreterDirective",
        value
      };
      const defs = NODE_FIELDS.InterpreterDirective;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function directive2(value) {
      const node = {
        type: "Directive",
        value
      };
      const defs = NODE_FIELDS.Directive;
      validate2(defs.value, node, "value", value, 1);
      return node;
    }
    function directiveLiteral2(value) {
      const node = {
        type: "DirectiveLiteral",
        value
      };
      const defs = NODE_FIELDS.DirectiveLiteral;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function blockStatement3(body, directives = []) {
      const node = {
        type: "BlockStatement",
        body,
        directives
      };
      const defs = NODE_FIELDS.BlockStatement;
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.directives, node, "directives", directives, 1);
      return node;
    }
    function breakStatement2(label = null) {
      const node = {
        type: "BreakStatement",
        label
      };
      const defs = NODE_FIELDS.BreakStatement;
      validate2(defs.label, node, "label", label, 1);
      return node;
    }
    function callExpression3(callee, _arguments) {
      const node = {
        type: "CallExpression",
        callee,
        arguments: _arguments
      };
      const defs = NODE_FIELDS.CallExpression;
      validate2(defs.callee, node, "callee", callee, 1);
      validate2(defs.arguments, node, "arguments", _arguments, 1);
      return node;
    }
    function catchClause2(param = null, body) {
      const node = {
        type: "CatchClause",
        param,
        body
      };
      const defs = NODE_FIELDS.CatchClause;
      validate2(defs.param, node, "param", param, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function conditionalExpression3(test, consequent, alternate) {
      const node = {
        type: "ConditionalExpression",
        test,
        consequent,
        alternate
      };
      const defs = NODE_FIELDS.ConditionalExpression;
      validate2(defs.test, node, "test", test, 1);
      validate2(defs.consequent, node, "consequent", consequent, 1);
      validate2(defs.alternate, node, "alternate", alternate, 1);
      return node;
    }
    function continueStatement2(label = null) {
      const node = {
        type: "ContinueStatement",
        label
      };
      const defs = NODE_FIELDS.ContinueStatement;
      validate2(defs.label, node, "label", label, 1);
      return node;
    }
    function debuggerStatement2() {
      return {
        type: "DebuggerStatement"
      };
    }
    function doWhileStatement2(test, body) {
      const node = {
        type: "DoWhileStatement",
        test,
        body
      };
      const defs = NODE_FIELDS.DoWhileStatement;
      validate2(defs.test, node, "test", test, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function emptyStatement2() {
      return {
        type: "EmptyStatement"
      };
    }
    function expressionStatement2(expression) {
      const node = {
        type: "ExpressionStatement",
        expression
      };
      const defs = NODE_FIELDS.ExpressionStatement;
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function file(program2, comments = null, tokens = null) {
      const node = {
        type: "File",
        program: program2,
        comments,
        tokens
      };
      const defs = NODE_FIELDS.File;
      validate2(defs.program, node, "program", program2, 1);
      validate2(defs.comments, node, "comments", comments, 1);
      validate2(defs.tokens, node, "tokens", tokens);
      return node;
    }
    function forInStatement2(left, right, body) {
      const node = {
        type: "ForInStatement",
        left,
        right,
        body
      };
      const defs = NODE_FIELDS.ForInStatement;
      validate2(defs.left, node, "left", left, 1);
      validate2(defs.right, node, "right", right, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function forStatement2(init = null, test = null, update2 = null, body) {
      const node = {
        type: "ForStatement",
        init,
        test,
        update: update2,
        body
      };
      const defs = NODE_FIELDS.ForStatement;
      validate2(defs.init, node, "init", init, 1);
      validate2(defs.test, node, "test", test, 1);
      validate2(defs.update, node, "update", update2, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function functionDeclaration3(id = null, params, body, generator = false, async = false) {
      const node = {
        type: "FunctionDeclaration",
        id,
        params,
        body,
        generator,
        async
      };
      const defs = NODE_FIELDS.FunctionDeclaration;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.params, node, "params", params, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.generator, node, "generator", generator);
      validate2(defs.async, node, "async", async);
      return node;
    }
    function functionExpression2(id = null, params, body, generator = false, async = false) {
      const node = {
        type: "FunctionExpression",
        id,
        params,
        body,
        generator,
        async
      };
      const defs = NODE_FIELDS.FunctionExpression;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.params, node, "params", params, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.generator, node, "generator", generator);
      validate2(defs.async, node, "async", async);
      return node;
    }
    function identifier4(name) {
      const node = {
        type: "Identifier",
        name
      };
      const defs = NODE_FIELDS.Identifier;
      validate2(defs.name, node, "name", name);
      return node;
    }
    function ifStatement3(test, consequent, alternate = null) {
      const node = {
        type: "IfStatement",
        test,
        consequent,
        alternate
      };
      const defs = NODE_FIELDS.IfStatement;
      validate2(defs.test, node, "test", test, 1);
      validate2(defs.consequent, node, "consequent", consequent, 1);
      validate2(defs.alternate, node, "alternate", alternate, 1);
      return node;
    }
    function labeledStatement2(label, body) {
      const node = {
        type: "LabeledStatement",
        label,
        body
      };
      const defs = NODE_FIELDS.LabeledStatement;
      validate2(defs.label, node, "label", label, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function stringLiteral3(value) {
      const node = {
        type: "StringLiteral",
        value
      };
      const defs = NODE_FIELDS.StringLiteral;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function numericLiteral2(value) {
      const node = {
        type: "NumericLiteral",
        value
      };
      const defs = NODE_FIELDS.NumericLiteral;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function nullLiteral2() {
      return {
        type: "NullLiteral"
      };
    }
    function booleanLiteral2(value) {
      const node = {
        type: "BooleanLiteral",
        value
      };
      const defs = NODE_FIELDS.BooleanLiteral;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function regExpLiteral2(pattern, flags = "") {
      const node = {
        type: "RegExpLiteral",
        pattern,
        flags
      };
      const defs = NODE_FIELDS.RegExpLiteral;
      validate2(defs.pattern, node, "pattern", pattern);
      validate2(defs.flags, node, "flags", flags);
      return node;
    }
    function logicalExpression2(operator, left, right) {
      const node = {
        type: "LogicalExpression",
        operator,
        left,
        right
      };
      const defs = NODE_FIELDS.LogicalExpression;
      validate2(defs.operator, node, "operator", operator);
      validate2(defs.left, node, "left", left, 1);
      validate2(defs.right, node, "right", right, 1);
      return node;
    }
    function memberExpression2(object, property, computed = false, optional = null) {
      const node = {
        type: "MemberExpression",
        object,
        property,
        computed,
        optional
      };
      const defs = NODE_FIELDS.MemberExpression;
      validate2(defs.object, node, "object", object, 1);
      validate2(defs.property, node, "property", property, 1);
      validate2(defs.computed, node, "computed", computed);
      validate2(defs.optional, node, "optional", optional);
      return node;
    }
    function newExpression2(callee, _arguments) {
      const node = {
        type: "NewExpression",
        callee,
        arguments: _arguments
      };
      const defs = NODE_FIELDS.NewExpression;
      validate2(defs.callee, node, "callee", callee, 1);
      validate2(defs.arguments, node, "arguments", _arguments, 1);
      return node;
    }
    function program(body, directives = [], sourceType = "script", interpreter = null) {
      const node = {
        type: "Program",
        body,
        directives,
        sourceType,
        interpreter
      };
      const defs = NODE_FIELDS.Program;
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.directives, node, "directives", directives, 1);
      validate2(defs.sourceType, node, "sourceType", sourceType);
      validate2(defs.interpreter, node, "interpreter", interpreter, 1);
      return node;
    }
    function objectExpression2(properties) {
      const node = {
        type: "ObjectExpression",
        properties
      };
      const defs = NODE_FIELDS.ObjectExpression;
      validate2(defs.properties, node, "properties", properties, 1);
      return node;
    }
    function objectMethod2(kind = "method", key, params, body, computed = false, generator = false, async = false) {
      const node = {
        type: "ObjectMethod",
        kind,
        key,
        params,
        body,
        computed,
        generator,
        async
      };
      const defs = NODE_FIELDS.ObjectMethod;
      validate2(defs.kind, node, "kind", kind);
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.params, node, "params", params, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.computed, node, "computed", computed);
      validate2(defs.generator, node, "generator", generator);
      validate2(defs.async, node, "async", async);
      return node;
    }
    function objectProperty2(key, value, computed = false, shorthand = false, decorators = null) {
      const node = {
        type: "ObjectProperty",
        key,
        value,
        computed,
        shorthand,
        decorators
      };
      const defs = NODE_FIELDS.ObjectProperty;
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.value, node, "value", value, 1);
      validate2(defs.computed, node, "computed", computed);
      validate2(defs.shorthand, node, "shorthand", shorthand);
      validate2(defs.decorators, node, "decorators", decorators, 1);
      return node;
    }
    function restElement3(argument) {
      const node = {
        type: "RestElement",
        argument
      };
      const defs = NODE_FIELDS.RestElement;
      validate2(defs.argument, node, "argument", argument, 1);
      return node;
    }
    function returnStatement3(argument = null) {
      const node = {
        type: "ReturnStatement",
        argument
      };
      const defs = NODE_FIELDS.ReturnStatement;
      validate2(defs.argument, node, "argument", argument, 1);
      return node;
    }
    function sequenceExpression2(expressions) {
      const node = {
        type: "SequenceExpression",
        expressions
      };
      const defs = NODE_FIELDS.SequenceExpression;
      validate2(defs.expressions, node, "expressions", expressions, 1);
      return node;
    }
    function parenthesizedExpression(expression) {
      const node = {
        type: "ParenthesizedExpression",
        expression
      };
      const defs = NODE_FIELDS.ParenthesizedExpression;
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function switchCase2(test = null, consequent) {
      const node = {
        type: "SwitchCase",
        test,
        consequent
      };
      const defs = NODE_FIELDS.SwitchCase;
      validate2(defs.test, node, "test", test, 1);
      validate2(defs.consequent, node, "consequent", consequent, 1);
      return node;
    }
    function switchStatement2(discriminant, cases) {
      const node = {
        type: "SwitchStatement",
        discriminant,
        cases
      };
      const defs = NODE_FIELDS.SwitchStatement;
      validate2(defs.discriminant, node, "discriminant", discriminant, 1);
      validate2(defs.cases, node, "cases", cases, 1);
      return node;
    }
    function thisExpression() {
      return {
        type: "ThisExpression"
      };
    }
    function throwStatement2(argument) {
      const node = {
        type: "ThrowStatement",
        argument
      };
      const defs = NODE_FIELDS.ThrowStatement;
      validate2(defs.argument, node, "argument", argument, 1);
      return node;
    }
    function tryStatement2(block, handler = null, finalizer = null) {
      const node = {
        type: "TryStatement",
        block,
        handler,
        finalizer
      };
      const defs = NODE_FIELDS.TryStatement;
      validate2(defs.block, node, "block", block, 1);
      validate2(defs.handler, node, "handler", handler, 1);
      validate2(defs.finalizer, node, "finalizer", finalizer, 1);
      return node;
    }
    function unaryExpression2(operator, argument, prefix = true) {
      const node = {
        type: "UnaryExpression",
        operator,
        argument,
        prefix
      };
      const defs = NODE_FIELDS.UnaryExpression;
      validate2(defs.operator, node, "operator", operator);
      validate2(defs.argument, node, "argument", argument, 1);
      validate2(defs.prefix, node, "prefix", prefix);
      return node;
    }
    function updateExpression2(operator, argument, prefix = false) {
      const node = {
        type: "UpdateExpression",
        operator,
        argument,
        prefix
      };
      const defs = NODE_FIELDS.UpdateExpression;
      validate2(defs.operator, node, "operator", operator);
      validate2(defs.argument, node, "argument", argument, 1);
      validate2(defs.prefix, node, "prefix", prefix);
      return node;
    }
    function variableDeclaration3(kind, declarations) {
      const node = {
        type: "VariableDeclaration",
        kind,
        declarations
      };
      const defs = NODE_FIELDS.VariableDeclaration;
      validate2(defs.kind, node, "kind", kind);
      validate2(defs.declarations, node, "declarations", declarations, 1);
      return node;
    }
    function variableDeclarator3(id, init = null) {
      const node = {
        type: "VariableDeclarator",
        id,
        init
      };
      const defs = NODE_FIELDS.VariableDeclarator;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.init, node, "init", init, 1);
      return node;
    }
    function whileStatement2(test, body) {
      const node = {
        type: "WhileStatement",
        test,
        body
      };
      const defs = NODE_FIELDS.WhileStatement;
      validate2(defs.test, node, "test", test, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function withStatement(object, body) {
      const node = {
        type: "WithStatement",
        object,
        body
      };
      const defs = NODE_FIELDS.WithStatement;
      validate2(defs.object, node, "object", object, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function assignmentPattern(left, right) {
      const node = {
        type: "AssignmentPattern",
        left,
        right
      };
      const defs = NODE_FIELDS.AssignmentPattern;
      validate2(defs.left, node, "left", left, 1);
      validate2(defs.right, node, "right", right, 1);
      return node;
    }
    function arrayPattern2(elements) {
      const node = {
        type: "ArrayPattern",
        elements
      };
      const defs = NODE_FIELDS.ArrayPattern;
      validate2(defs.elements, node, "elements", elements, 1);
      return node;
    }
    function arrowFunctionExpression2(params, body, async = false) {
      const node = {
        type: "ArrowFunctionExpression",
        params,
        body,
        async,
        expression: null
      };
      const defs = NODE_FIELDS.ArrowFunctionExpression;
      validate2(defs.params, node, "params", params, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.async, node, "async", async);
      return node;
    }
    function classBody(body) {
      const node = {
        type: "ClassBody",
        body
      };
      const defs = NODE_FIELDS.ClassBody;
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function classExpression(id = null, superClass = null, body, decorators = null) {
      const node = {
        type: "ClassExpression",
        id,
        superClass,
        body,
        decorators
      };
      const defs = NODE_FIELDS.ClassExpression;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.superClass, node, "superClass", superClass, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.decorators, node, "decorators", decorators, 1);
      return node;
    }
    function classDeclaration(id = null, superClass = null, body, decorators = null) {
      const node = {
        type: "ClassDeclaration",
        id,
        superClass,
        body,
        decorators
      };
      const defs = NODE_FIELDS.ClassDeclaration;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.superClass, node, "superClass", superClass, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.decorators, node, "decorators", decorators, 1);
      return node;
    }
    function exportAllDeclaration(source) {
      const node = {
        type: "ExportAllDeclaration",
        source
      };
      const defs = NODE_FIELDS.ExportAllDeclaration;
      validate2(defs.source, node, "source", source, 1);
      return node;
    }
    function exportDefaultDeclaration2(declaration) {
      const node = {
        type: "ExportDefaultDeclaration",
        declaration
      };
      const defs = NODE_FIELDS.ExportDefaultDeclaration;
      validate2(defs.declaration, node, "declaration", declaration, 1);
      return node;
    }
    function exportNamedDeclaration(declaration = null, specifiers = [], source = null) {
      const node = {
        type: "ExportNamedDeclaration",
        declaration,
        specifiers,
        source
      };
      const defs = NODE_FIELDS.ExportNamedDeclaration;
      validate2(defs.declaration, node, "declaration", declaration, 1);
      validate2(defs.specifiers, node, "specifiers", specifiers, 1);
      validate2(defs.source, node, "source", source, 1);
      return node;
    }
    function exportSpecifier(local, exported) {
      const node = {
        type: "ExportSpecifier",
        local,
        exported
      };
      const defs = NODE_FIELDS.ExportSpecifier;
      validate2(defs.local, node, "local", local, 1);
      validate2(defs.exported, node, "exported", exported, 1);
      return node;
    }
    function forOfStatement2(left, right, body, _await = false) {
      const node = {
        type: "ForOfStatement",
        left,
        right,
        body,
        await: _await
      };
      const defs = NODE_FIELDS.ForOfStatement;
      validate2(defs.left, node, "left", left, 1);
      validate2(defs.right, node, "right", right, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.await, node, "await", _await);
      return node;
    }
    function importDeclaration2(specifiers, source) {
      const node = {
        type: "ImportDeclaration",
        specifiers,
        source
      };
      const defs = NODE_FIELDS.ImportDeclaration;
      validate2(defs.specifiers, node, "specifiers", specifiers, 1);
      validate2(defs.source, node, "source", source, 1);
      return node;
    }
    function importDefaultSpecifier(local) {
      const node = {
        type: "ImportDefaultSpecifier",
        local
      };
      const defs = NODE_FIELDS.ImportDefaultSpecifier;
      validate2(defs.local, node, "local", local, 1);
      return node;
    }
    function importNamespaceSpecifier(local) {
      const node = {
        type: "ImportNamespaceSpecifier",
        local
      };
      const defs = NODE_FIELDS.ImportNamespaceSpecifier;
      validate2(defs.local, node, "local", local, 1);
      return node;
    }
    function importSpecifier2(local, imported) {
      const node = {
        type: "ImportSpecifier",
        local,
        imported
      };
      const defs = NODE_FIELDS.ImportSpecifier;
      validate2(defs.local, node, "local", local, 1);
      validate2(defs.imported, node, "imported", imported, 1);
      return node;
    }
    function importExpression(source, options = null) {
      const node = {
        type: "ImportExpression",
        source,
        options
      };
      const defs = NODE_FIELDS.ImportExpression;
      validate2(defs.source, node, "source", source, 1);
      validate2(defs.options, node, "options", options, 1);
      return node;
    }
    function metaProperty2(meta2, property) {
      const node = {
        type: "MetaProperty",
        meta: meta2,
        property
      };
      const defs = NODE_FIELDS.MetaProperty;
      validate2(defs.meta, node, "meta", meta2, 1);
      validate2(defs.property, node, "property", property, 1);
      return node;
    }
    function classMethod(kind = "method", key, params, body, computed = false, _static = false, generator = false, async = false) {
      const node = {
        type: "ClassMethod",
        kind,
        key,
        params,
        body,
        computed,
        static: _static,
        generator,
        async
      };
      const defs = NODE_FIELDS.ClassMethod;
      validate2(defs.kind, node, "kind", kind);
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.params, node, "params", params, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.computed, node, "computed", computed);
      validate2(defs.static, node, "static", _static);
      validate2(defs.generator, node, "generator", generator);
      validate2(defs.async, node, "async", async);
      return node;
    }
    function objectPattern2(properties) {
      const node = {
        type: "ObjectPattern",
        properties
      };
      const defs = NODE_FIELDS.ObjectPattern;
      validate2(defs.properties, node, "properties", properties, 1);
      return node;
    }
    function spreadElement3(argument) {
      const node = {
        type: "SpreadElement",
        argument
      };
      const defs = NODE_FIELDS.SpreadElement;
      validate2(defs.argument, node, "argument", argument, 1);
      return node;
    }
    function _super() {
      return {
        type: "Super"
      };
    }
    function taggedTemplateExpression2(tag, quasi) {
      const node = {
        type: "TaggedTemplateExpression",
        tag,
        quasi
      };
      const defs = NODE_FIELDS.TaggedTemplateExpression;
      validate2(defs.tag, node, "tag", tag, 1);
      validate2(defs.quasi, node, "quasi", quasi, 1);
      return node;
    }
    function templateElement2(value, tail = false) {
      const node = {
        type: "TemplateElement",
        value,
        tail
      };
      const defs = NODE_FIELDS.TemplateElement;
      validate2(defs.value, node, "value", value);
      validate2(defs.tail, node, "tail", tail);
      return node;
    }
    function templateLiteral2(quasis, expressions) {
      const node = {
        type: "TemplateLiteral",
        quasis,
        expressions
      };
      const defs = NODE_FIELDS.TemplateLiteral;
      validate2(defs.quasis, node, "quasis", quasis, 1);
      validate2(defs.expressions, node, "expressions", expressions, 1);
      return node;
    }
    function yieldExpression(argument = null, delegate = false) {
      const node = {
        type: "YieldExpression",
        argument,
        delegate
      };
      const defs = NODE_FIELDS.YieldExpression;
      validate2(defs.argument, node, "argument", argument, 1);
      validate2(defs.delegate, node, "delegate", delegate);
      return node;
    }
    function awaitExpression2(argument) {
      const node = {
        type: "AwaitExpression",
        argument
      };
      const defs = NODE_FIELDS.AwaitExpression;
      validate2(defs.argument, node, "argument", argument, 1);
      return node;
    }
    function _import() {
      return {
        type: "Import"
      };
    }
    function bigIntLiteral(value) {
      const node = {
        type: "BigIntLiteral",
        value
      };
      const defs = NODE_FIELDS.BigIntLiteral;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function exportNamespaceSpecifier(exported) {
      const node = {
        type: "ExportNamespaceSpecifier",
        exported
      };
      const defs = NODE_FIELDS.ExportNamespaceSpecifier;
      validate2(defs.exported, node, "exported", exported, 1);
      return node;
    }
    function optionalMemberExpression2(object, property, computed = false, optional) {
      const node = {
        type: "OptionalMemberExpression",
        object,
        property,
        computed,
        optional
      };
      const defs = NODE_FIELDS.OptionalMemberExpression;
      validate2(defs.object, node, "object", object, 1);
      validate2(defs.property, node, "property", property, 1);
      validate2(defs.computed, node, "computed", computed);
      validate2(defs.optional, node, "optional", optional);
      return node;
    }
    function optionalCallExpression2(callee, _arguments, optional) {
      const node = {
        type: "OptionalCallExpression",
        callee,
        arguments: _arguments,
        optional
      };
      const defs = NODE_FIELDS.OptionalCallExpression;
      validate2(defs.callee, node, "callee", callee, 1);
      validate2(defs.arguments, node, "arguments", _arguments, 1);
      validate2(defs.optional, node, "optional", optional);
      return node;
    }
    function classProperty(key, value = null, typeAnnotation3 = null, decorators = null, computed = false, _static = false) {
      const node = {
        type: "ClassProperty",
        key,
        value,
        typeAnnotation: typeAnnotation3,
        decorators,
        computed,
        static: _static
      };
      const defs = NODE_FIELDS.ClassProperty;
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.value, node, "value", value, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      validate2(defs.decorators, node, "decorators", decorators, 1);
      validate2(defs.computed, node, "computed", computed);
      validate2(defs.static, node, "static", _static);
      return node;
    }
    function classAccessorProperty(key, value = null, typeAnnotation3 = null, decorators = null, computed = false, _static = false) {
      const node = {
        type: "ClassAccessorProperty",
        key,
        value,
        typeAnnotation: typeAnnotation3,
        decorators,
        computed,
        static: _static
      };
      const defs = NODE_FIELDS.ClassAccessorProperty;
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.value, node, "value", value, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      validate2(defs.decorators, node, "decorators", decorators, 1);
      validate2(defs.computed, node, "computed", computed);
      validate2(defs.static, node, "static", _static);
      return node;
    }
    function classPrivateProperty(key, value = null, decorators = null, _static = false) {
      const node = {
        type: "ClassPrivateProperty",
        key,
        value,
        decorators,
        static: _static
      };
      const defs = NODE_FIELDS.ClassPrivateProperty;
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.value, node, "value", value, 1);
      validate2(defs.decorators, node, "decorators", decorators, 1);
      validate2(defs.static, node, "static", _static);
      return node;
    }
    function classPrivateMethod(kind = "method", key, params, body, _static = false) {
      const node = {
        type: "ClassPrivateMethod",
        kind,
        key,
        params,
        body,
        static: _static
      };
      const defs = NODE_FIELDS.ClassPrivateMethod;
      validate2(defs.kind, node, "kind", kind);
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.params, node, "params", params, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.static, node, "static", _static);
      return node;
    }
    function privateName(id) {
      const node = {
        type: "PrivateName",
        id
      };
      const defs = NODE_FIELDS.PrivateName;
      validate2(defs.id, node, "id", id, 1);
      return node;
    }
    function staticBlock(body) {
      const node = {
        type: "StaticBlock",
        body
      };
      const defs = NODE_FIELDS.StaticBlock;
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function anyTypeAnnotation() {
      return {
        type: "AnyTypeAnnotation"
      };
    }
    function arrayTypeAnnotation(elementType) {
      const node = {
        type: "ArrayTypeAnnotation",
        elementType
      };
      const defs = NODE_FIELDS.ArrayTypeAnnotation;
      validate2(defs.elementType, node, "elementType", elementType, 1);
      return node;
    }
    function booleanTypeAnnotation() {
      return {
        type: "BooleanTypeAnnotation"
      };
    }
    function booleanLiteralTypeAnnotation(value) {
      const node = {
        type: "BooleanLiteralTypeAnnotation",
        value
      };
      const defs = NODE_FIELDS.BooleanLiteralTypeAnnotation;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function nullLiteralTypeAnnotation() {
      return {
        type: "NullLiteralTypeAnnotation"
      };
    }
    function classImplements(id, typeParameters = null) {
      const node = {
        type: "ClassImplements",
        id,
        typeParameters
      };
      const defs = NODE_FIELDS.ClassImplements;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      return node;
    }
    function declareClass(id, typeParameters = null, _extends = null, body) {
      const node = {
        type: "DeclareClass",
        id,
        typeParameters,
        extends: _extends,
        body
      };
      const defs = NODE_FIELDS.DeclareClass;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.extends, node, "extends", _extends, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function declareFunction(id) {
      const node = {
        type: "DeclareFunction",
        id
      };
      const defs = NODE_FIELDS.DeclareFunction;
      validate2(defs.id, node, "id", id, 1);
      return node;
    }
    function declareInterface(id, typeParameters = null, _extends = null, body) {
      const node = {
        type: "DeclareInterface",
        id,
        typeParameters,
        extends: _extends,
        body
      };
      const defs = NODE_FIELDS.DeclareInterface;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.extends, node, "extends", _extends, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function declareModule(id, body, kind = null) {
      const node = {
        type: "DeclareModule",
        id,
        body,
        kind
      };
      const defs = NODE_FIELDS.DeclareModule;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.kind, node, "kind", kind);
      return node;
    }
    function declareModuleExports(typeAnnotation3) {
      const node = {
        type: "DeclareModuleExports",
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.DeclareModuleExports;
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function declareTypeAlias(id, typeParameters = null, right) {
      const node = {
        type: "DeclareTypeAlias",
        id,
        typeParameters,
        right
      };
      const defs = NODE_FIELDS.DeclareTypeAlias;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.right, node, "right", right, 1);
      return node;
    }
    function declareOpaqueType(id, typeParameters = null, supertype = null) {
      const node = {
        type: "DeclareOpaqueType",
        id,
        typeParameters,
        supertype
      };
      const defs = NODE_FIELDS.DeclareOpaqueType;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.supertype, node, "supertype", supertype, 1);
      return node;
    }
    function declareVariable(id) {
      const node = {
        type: "DeclareVariable",
        id
      };
      const defs = NODE_FIELDS.DeclareVariable;
      validate2(defs.id, node, "id", id, 1);
      return node;
    }
    function declareExportDeclaration(declaration = null, specifiers = null, source = null, attributes = null) {
      const node = {
        type: "DeclareExportDeclaration",
        declaration,
        specifiers,
        source,
        attributes
      };
      const defs = NODE_FIELDS.DeclareExportDeclaration;
      validate2(defs.declaration, node, "declaration", declaration, 1);
      validate2(defs.specifiers, node, "specifiers", specifiers, 1);
      validate2(defs.source, node, "source", source, 1);
      validate2(defs.attributes, node, "attributes", attributes, 1);
      return node;
    }
    function declareExportAllDeclaration(source, attributes = null) {
      const node = {
        type: "DeclareExportAllDeclaration",
        source,
        attributes
      };
      const defs = NODE_FIELDS.DeclareExportAllDeclaration;
      validate2(defs.source, node, "source", source, 1);
      validate2(defs.attributes, node, "attributes", attributes, 1);
      return node;
    }
    function declaredPredicate(value) {
      const node = {
        type: "DeclaredPredicate",
        value
      };
      const defs = NODE_FIELDS.DeclaredPredicate;
      validate2(defs.value, node, "value", value, 1);
      return node;
    }
    function existsTypeAnnotation() {
      return {
        type: "ExistsTypeAnnotation"
      };
    }
    function functionTypeAnnotation(typeParameters = null, params, rest = null, returnType) {
      const node = {
        type: "FunctionTypeAnnotation",
        typeParameters,
        params,
        rest,
        returnType
      };
      const defs = NODE_FIELDS.FunctionTypeAnnotation;
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.params, node, "params", params, 1);
      validate2(defs.rest, node, "rest", rest, 1);
      validate2(defs.returnType, node, "returnType", returnType, 1);
      return node;
    }
    function functionTypeParam(name = null, typeAnnotation3) {
      const node = {
        type: "FunctionTypeParam",
        name,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.FunctionTypeParam;
      validate2(defs.name, node, "name", name, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function genericTypeAnnotation(id, typeParameters = null) {
      const node = {
        type: "GenericTypeAnnotation",
        id,
        typeParameters
      };
      const defs = NODE_FIELDS.GenericTypeAnnotation;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      return node;
    }
    function inferredPredicate() {
      return {
        type: "InferredPredicate"
      };
    }
    function interfaceExtends(id, typeParameters = null) {
      const node = {
        type: "InterfaceExtends",
        id,
        typeParameters
      };
      const defs = NODE_FIELDS.InterfaceExtends;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      return node;
    }
    function interfaceDeclaration(id, typeParameters = null, _extends = null, body) {
      const node = {
        type: "InterfaceDeclaration",
        id,
        typeParameters,
        extends: _extends,
        body
      };
      const defs = NODE_FIELDS.InterfaceDeclaration;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.extends, node, "extends", _extends, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function interfaceTypeAnnotation(_extends = null, body) {
      const node = {
        type: "InterfaceTypeAnnotation",
        extends: _extends,
        body
      };
      const defs = NODE_FIELDS.InterfaceTypeAnnotation;
      validate2(defs.extends, node, "extends", _extends, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function intersectionTypeAnnotation(types) {
      const node = {
        type: "IntersectionTypeAnnotation",
        types
      };
      const defs = NODE_FIELDS.IntersectionTypeAnnotation;
      validate2(defs.types, node, "types", types, 1);
      return node;
    }
    function mixedTypeAnnotation() {
      return {
        type: "MixedTypeAnnotation"
      };
    }
    function emptyTypeAnnotation() {
      return {
        type: "EmptyTypeAnnotation"
      };
    }
    function nullableTypeAnnotation(typeAnnotation3) {
      const node = {
        type: "NullableTypeAnnotation",
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.NullableTypeAnnotation;
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function numberLiteralTypeAnnotation(value) {
      const node = {
        type: "NumberLiteralTypeAnnotation",
        value
      };
      const defs = NODE_FIELDS.NumberLiteralTypeAnnotation;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function numberTypeAnnotation() {
      return {
        type: "NumberTypeAnnotation"
      };
    }
    function objectTypeAnnotation(properties, indexers = [], callProperties = [], internalSlots = [], exact = false) {
      const node = {
        type: "ObjectTypeAnnotation",
        properties,
        indexers,
        callProperties,
        internalSlots,
        exact
      };
      const defs = NODE_FIELDS.ObjectTypeAnnotation;
      validate2(defs.properties, node, "properties", properties, 1);
      validate2(defs.indexers, node, "indexers", indexers, 1);
      validate2(defs.callProperties, node, "callProperties", callProperties, 1);
      validate2(defs.internalSlots, node, "internalSlots", internalSlots, 1);
      validate2(defs.exact, node, "exact", exact);
      return node;
    }
    function objectTypeInternalSlot(id, value, optional, _static, method) {
      const node = {
        type: "ObjectTypeInternalSlot",
        id,
        value,
        optional,
        static: _static,
        method
      };
      const defs = NODE_FIELDS.ObjectTypeInternalSlot;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.value, node, "value", value, 1);
      validate2(defs.optional, node, "optional", optional);
      validate2(defs.static, node, "static", _static);
      validate2(defs.method, node, "method", method);
      return node;
    }
    function objectTypeCallProperty(value) {
      const node = {
        type: "ObjectTypeCallProperty",
        value,
        static: null
      };
      const defs = NODE_FIELDS.ObjectTypeCallProperty;
      validate2(defs.value, node, "value", value, 1);
      return node;
    }
    function objectTypeIndexer(id = null, key, value, variance2 = null) {
      const node = {
        type: "ObjectTypeIndexer",
        id,
        key,
        value,
        variance: variance2,
        static: null
      };
      const defs = NODE_FIELDS.ObjectTypeIndexer;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.value, node, "value", value, 1);
      validate2(defs.variance, node, "variance", variance2, 1);
      return node;
    }
    function objectTypeProperty(key, value, variance2 = null) {
      const node = {
        type: "ObjectTypeProperty",
        key,
        value,
        variance: variance2,
        kind: null,
        method: null,
        optional: null,
        proto: null,
        static: null
      };
      const defs = NODE_FIELDS.ObjectTypeProperty;
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.value, node, "value", value, 1);
      validate2(defs.variance, node, "variance", variance2, 1);
      return node;
    }
    function objectTypeSpreadProperty(argument) {
      const node = {
        type: "ObjectTypeSpreadProperty",
        argument
      };
      const defs = NODE_FIELDS.ObjectTypeSpreadProperty;
      validate2(defs.argument, node, "argument", argument, 1);
      return node;
    }
    function opaqueType(id, typeParameters = null, supertype = null, impltype) {
      const node = {
        type: "OpaqueType",
        id,
        typeParameters,
        supertype,
        impltype
      };
      const defs = NODE_FIELDS.OpaqueType;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.supertype, node, "supertype", supertype, 1);
      validate2(defs.impltype, node, "impltype", impltype, 1);
      return node;
    }
    function qualifiedTypeIdentifier(id, qualification) {
      const node = {
        type: "QualifiedTypeIdentifier",
        id,
        qualification
      };
      const defs = NODE_FIELDS.QualifiedTypeIdentifier;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.qualification, node, "qualification", qualification, 1);
      return node;
    }
    function stringLiteralTypeAnnotation(value) {
      const node = {
        type: "StringLiteralTypeAnnotation",
        value
      };
      const defs = NODE_FIELDS.StringLiteralTypeAnnotation;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function stringTypeAnnotation() {
      return {
        type: "StringTypeAnnotation"
      };
    }
    function symbolTypeAnnotation() {
      return {
        type: "SymbolTypeAnnotation"
      };
    }
    function thisTypeAnnotation() {
      return {
        type: "ThisTypeAnnotation"
      };
    }
    function tupleTypeAnnotation(types) {
      const node = {
        type: "TupleTypeAnnotation",
        types
      };
      const defs = NODE_FIELDS.TupleTypeAnnotation;
      validate2(defs.types, node, "types", types, 1);
      return node;
    }
    function typeofTypeAnnotation(argument) {
      const node = {
        type: "TypeofTypeAnnotation",
        argument
      };
      const defs = NODE_FIELDS.TypeofTypeAnnotation;
      validate2(defs.argument, node, "argument", argument, 1);
      return node;
    }
    function typeAlias(id, typeParameters = null, right) {
      const node = {
        type: "TypeAlias",
        id,
        typeParameters,
        right
      };
      const defs = NODE_FIELDS.TypeAlias;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.right, node, "right", right, 1);
      return node;
    }
    function typeAnnotation2(typeAnnotation3) {
      const node = {
        type: "TypeAnnotation",
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TypeAnnotation;
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function typeCastExpression2(expression, typeAnnotation3) {
      const node = {
        type: "TypeCastExpression",
        expression,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TypeCastExpression;
      validate2(defs.expression, node, "expression", expression, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function typeParameter(bound = null, _default = null, variance2 = null) {
      const node = {
        type: "TypeParameter",
        bound,
        default: _default,
        variance: variance2,
        name: null
      };
      const defs = NODE_FIELDS.TypeParameter;
      validate2(defs.bound, node, "bound", bound, 1);
      validate2(defs.default, node, "default", _default, 1);
      validate2(defs.variance, node, "variance", variance2, 1);
      return node;
    }
    function typeParameterDeclaration(params) {
      const node = {
        type: "TypeParameterDeclaration",
        params
      };
      const defs = NODE_FIELDS.TypeParameterDeclaration;
      validate2(defs.params, node, "params", params, 1);
      return node;
    }
    function typeParameterInstantiation2(params) {
      const node = {
        type: "TypeParameterInstantiation",
        params
      };
      const defs = NODE_FIELDS.TypeParameterInstantiation;
      validate2(defs.params, node, "params", params, 1);
      return node;
    }
    function unionTypeAnnotation(types) {
      const node = {
        type: "UnionTypeAnnotation",
        types
      };
      const defs = NODE_FIELDS.UnionTypeAnnotation;
      validate2(defs.types, node, "types", types, 1);
      return node;
    }
    function variance(kind) {
      const node = {
        type: "Variance",
        kind
      };
      const defs = NODE_FIELDS.Variance;
      validate2(defs.kind, node, "kind", kind);
      return node;
    }
    function voidTypeAnnotation() {
      return {
        type: "VoidTypeAnnotation"
      };
    }
    function enumDeclaration(id, body) {
      const node = {
        type: "EnumDeclaration",
        id,
        body
      };
      const defs = NODE_FIELDS.EnumDeclaration;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function enumBooleanBody(members) {
      const node = {
        type: "EnumBooleanBody",
        members,
        explicitType: null,
        hasUnknownMembers: null
      };
      const defs = NODE_FIELDS.EnumBooleanBody;
      validate2(defs.members, node, "members", members, 1);
      return node;
    }
    function enumNumberBody(members) {
      const node = {
        type: "EnumNumberBody",
        members,
        explicitType: null,
        hasUnknownMembers: null
      };
      const defs = NODE_FIELDS.EnumNumberBody;
      validate2(defs.members, node, "members", members, 1);
      return node;
    }
    function enumStringBody(members) {
      const node = {
        type: "EnumStringBody",
        members,
        explicitType: null,
        hasUnknownMembers: null
      };
      const defs = NODE_FIELDS.EnumStringBody;
      validate2(defs.members, node, "members", members, 1);
      return node;
    }
    function enumSymbolBody(members) {
      const node = {
        type: "EnumSymbolBody",
        members,
        hasUnknownMembers: null
      };
      const defs = NODE_FIELDS.EnumSymbolBody;
      validate2(defs.members, node, "members", members, 1);
      return node;
    }
    function enumBooleanMember(id) {
      const node = {
        type: "EnumBooleanMember",
        id,
        init: null
      };
      const defs = NODE_FIELDS.EnumBooleanMember;
      validate2(defs.id, node, "id", id, 1);
      return node;
    }
    function enumNumberMember(id, init) {
      const node = {
        type: "EnumNumberMember",
        id,
        init
      };
      const defs = NODE_FIELDS.EnumNumberMember;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.init, node, "init", init, 1);
      return node;
    }
    function enumStringMember(id, init) {
      const node = {
        type: "EnumStringMember",
        id,
        init
      };
      const defs = NODE_FIELDS.EnumStringMember;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.init, node, "init", init, 1);
      return node;
    }
    function enumDefaultedMember(id) {
      const node = {
        type: "EnumDefaultedMember",
        id
      };
      const defs = NODE_FIELDS.EnumDefaultedMember;
      validate2(defs.id, node, "id", id, 1);
      return node;
    }
    function indexedAccessType(objectType, indexType) {
      const node = {
        type: "IndexedAccessType",
        objectType,
        indexType
      };
      const defs = NODE_FIELDS.IndexedAccessType;
      validate2(defs.objectType, node, "objectType", objectType, 1);
      validate2(defs.indexType, node, "indexType", indexType, 1);
      return node;
    }
    function optionalIndexedAccessType(objectType, indexType) {
      const node = {
        type: "OptionalIndexedAccessType",
        objectType,
        indexType,
        optional: null
      };
      const defs = NODE_FIELDS.OptionalIndexedAccessType;
      validate2(defs.objectType, node, "objectType", objectType, 1);
      validate2(defs.indexType, node, "indexType", indexType, 1);
      return node;
    }
    function jsxAttribute2(name, value = null) {
      const node = {
        type: "JSXAttribute",
        name,
        value
      };
      const defs = NODE_FIELDS.JSXAttribute;
      validate2(defs.name, node, "name", name, 1);
      validate2(defs.value, node, "value", value, 1);
      return node;
    }
    function jsxClosingElement2(name) {
      const node = {
        type: "JSXClosingElement",
        name
      };
      const defs = NODE_FIELDS.JSXClosingElement;
      validate2(defs.name, node, "name", name, 1);
      return node;
    }
    function jsxElement2(openingElement, closingElement = null, children, selfClosing = null) {
      const node = {
        type: "JSXElement",
        openingElement,
        closingElement,
        children,
        selfClosing
      };
      const defs = NODE_FIELDS.JSXElement;
      validate2(defs.openingElement, node, "openingElement", openingElement, 1);
      validate2(defs.closingElement, node, "closingElement", closingElement, 1);
      validate2(defs.children, node, "children", children, 1);
      validate2(defs.selfClosing, node, "selfClosing", selfClosing);
      return node;
    }
    function jsxEmptyExpression() {
      return {
        type: "JSXEmptyExpression"
      };
    }
    function jsxExpressionContainer2(expression) {
      const node = {
        type: "JSXExpressionContainer",
        expression
      };
      const defs = NODE_FIELDS.JSXExpressionContainer;
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function jsxSpreadChild(expression) {
      const node = {
        type: "JSXSpreadChild",
        expression
      };
      const defs = NODE_FIELDS.JSXSpreadChild;
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function jsxIdentifier2(name) {
      const node = {
        type: "JSXIdentifier",
        name
      };
      const defs = NODE_FIELDS.JSXIdentifier;
      validate2(defs.name, node, "name", name);
      return node;
    }
    function jsxMemberExpression2(object, property) {
      const node = {
        type: "JSXMemberExpression",
        object,
        property
      };
      const defs = NODE_FIELDS.JSXMemberExpression;
      validate2(defs.object, node, "object", object, 1);
      validate2(defs.property, node, "property", property, 1);
      return node;
    }
    function jsxNamespacedName2(namespace, name) {
      const node = {
        type: "JSXNamespacedName",
        namespace,
        name
      };
      const defs = NODE_FIELDS.JSXNamespacedName;
      validate2(defs.namespace, node, "namespace", namespace, 1);
      validate2(defs.name, node, "name", name, 1);
      return node;
    }
    function jsxOpeningElement2(name, attributes, selfClosing = false) {
      const node = {
        type: "JSXOpeningElement",
        name,
        attributes,
        selfClosing
      };
      const defs = NODE_FIELDS.JSXOpeningElement;
      validate2(defs.name, node, "name", name, 1);
      validate2(defs.attributes, node, "attributes", attributes, 1);
      validate2(defs.selfClosing, node, "selfClosing", selfClosing);
      return node;
    }
    function jsxSpreadAttribute2(argument) {
      const node = {
        type: "JSXSpreadAttribute",
        argument
      };
      const defs = NODE_FIELDS.JSXSpreadAttribute;
      validate2(defs.argument, node, "argument", argument, 1);
      return node;
    }
    function jsxText2(value) {
      const node = {
        type: "JSXText",
        value
      };
      const defs = NODE_FIELDS.JSXText;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function jsxFragment2(openingFragment, closingFragment, children) {
      const node = {
        type: "JSXFragment",
        openingFragment,
        closingFragment,
        children
      };
      const defs = NODE_FIELDS.JSXFragment;
      validate2(defs.openingFragment, node, "openingFragment", openingFragment, 1);
      validate2(defs.closingFragment, node, "closingFragment", closingFragment, 1);
      validate2(defs.children, node, "children", children, 1);
      return node;
    }
    function jsxOpeningFragment2() {
      return {
        type: "JSXOpeningFragment"
      };
    }
    function jsxClosingFragment2() {
      return {
        type: "JSXClosingFragment"
      };
    }
    function noop() {
      return {
        type: "Noop"
      };
    }
    function placeholder(expectedNode, name) {
      const node = {
        type: "Placeholder",
        expectedNode,
        name
      };
      const defs = NODE_FIELDS.Placeholder;
      validate2(defs.expectedNode, node, "expectedNode", expectedNode);
      validate2(defs.name, node, "name", name, 1);
      return node;
    }
    function v8IntrinsicIdentifier(name) {
      const node = {
        type: "V8IntrinsicIdentifier",
        name
      };
      const defs = NODE_FIELDS.V8IntrinsicIdentifier;
      validate2(defs.name, node, "name", name);
      return node;
    }
    function argumentPlaceholder() {
      return {
        type: "ArgumentPlaceholder"
      };
    }
    function bindExpression(object, callee) {
      const node = {
        type: "BindExpression",
        object,
        callee
      };
      const defs = NODE_FIELDS.BindExpression;
      validate2(defs.object, node, "object", object, 1);
      validate2(defs.callee, node, "callee", callee, 1);
      return node;
    }
    function importAttribute(key, value) {
      const node = {
        type: "ImportAttribute",
        key,
        value
      };
      const defs = NODE_FIELDS.ImportAttribute;
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.value, node, "value", value, 1);
      return node;
    }
    function decorator(expression) {
      const node = {
        type: "Decorator",
        expression
      };
      const defs = NODE_FIELDS.Decorator;
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function doExpression(body, async = false) {
      const node = {
        type: "DoExpression",
        body,
        async
      };
      const defs = NODE_FIELDS.DoExpression;
      validate2(defs.body, node, "body", body, 1);
      validate2(defs.async, node, "async", async);
      return node;
    }
    function exportDefaultSpecifier(exported) {
      const node = {
        type: "ExportDefaultSpecifier",
        exported
      };
      const defs = NODE_FIELDS.ExportDefaultSpecifier;
      validate2(defs.exported, node, "exported", exported, 1);
      return node;
    }
    function recordExpression(properties) {
      const node = {
        type: "RecordExpression",
        properties
      };
      const defs = NODE_FIELDS.RecordExpression;
      validate2(defs.properties, node, "properties", properties, 1);
      return node;
    }
    function tupleExpression(elements = []) {
      const node = {
        type: "TupleExpression",
        elements
      };
      const defs = NODE_FIELDS.TupleExpression;
      validate2(defs.elements, node, "elements", elements, 1);
      return node;
    }
    function decimalLiteral(value) {
      const node = {
        type: "DecimalLiteral",
        value
      };
      const defs = NODE_FIELDS.DecimalLiteral;
      validate2(defs.value, node, "value", value);
      return node;
    }
    function moduleExpression(body) {
      const node = {
        type: "ModuleExpression",
        body
      };
      const defs = NODE_FIELDS.ModuleExpression;
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function topicReference() {
      return {
        type: "TopicReference"
      };
    }
    function pipelineTopicExpression(expression) {
      const node = {
        type: "PipelineTopicExpression",
        expression
      };
      const defs = NODE_FIELDS.PipelineTopicExpression;
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function pipelineBareFunction(callee) {
      const node = {
        type: "PipelineBareFunction",
        callee
      };
      const defs = NODE_FIELDS.PipelineBareFunction;
      validate2(defs.callee, node, "callee", callee, 1);
      return node;
    }
    function pipelinePrimaryTopicReference() {
      return {
        type: "PipelinePrimaryTopicReference"
      };
    }
    function tsParameterProperty(parameter) {
      const node = {
        type: "TSParameterProperty",
        parameter
      };
      const defs = NODE_FIELDS.TSParameterProperty;
      validate2(defs.parameter, node, "parameter", parameter, 1);
      return node;
    }
    function tsDeclareFunction(id = null, typeParameters = null, params, returnType = null) {
      const node = {
        type: "TSDeclareFunction",
        id,
        typeParameters,
        params,
        returnType
      };
      const defs = NODE_FIELDS.TSDeclareFunction;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.params, node, "params", params, 1);
      validate2(defs.returnType, node, "returnType", returnType, 1);
      return node;
    }
    function tsDeclareMethod(decorators = null, key, typeParameters = null, params, returnType = null) {
      const node = {
        type: "TSDeclareMethod",
        decorators,
        key,
        typeParameters,
        params,
        returnType
      };
      const defs = NODE_FIELDS.TSDeclareMethod;
      validate2(defs.decorators, node, "decorators", decorators, 1);
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.params, node, "params", params, 1);
      validate2(defs.returnType, node, "returnType", returnType, 1);
      return node;
    }
    function tsQualifiedName(left, right) {
      const node = {
        type: "TSQualifiedName",
        left,
        right
      };
      const defs = NODE_FIELDS.TSQualifiedName;
      validate2(defs.left, node, "left", left, 1);
      validate2(defs.right, node, "right", right, 1);
      return node;
    }
    function tsCallSignatureDeclaration(typeParameters = null, parameters, typeAnnotation3 = null) {
      const node = {
        type: "TSCallSignatureDeclaration",
        typeParameters,
        parameters,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSCallSignatureDeclaration;
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.parameters, node, "parameters", parameters, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsConstructSignatureDeclaration(typeParameters = null, parameters, typeAnnotation3 = null) {
      const node = {
        type: "TSConstructSignatureDeclaration",
        typeParameters,
        parameters,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSConstructSignatureDeclaration;
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.parameters, node, "parameters", parameters, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsPropertySignature(key, typeAnnotation3 = null) {
      const node = {
        type: "TSPropertySignature",
        key,
        typeAnnotation: typeAnnotation3,
        kind: null
      };
      const defs = NODE_FIELDS.TSPropertySignature;
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsMethodSignature(key, typeParameters = null, parameters, typeAnnotation3 = null) {
      const node = {
        type: "TSMethodSignature",
        key,
        typeParameters,
        parameters,
        typeAnnotation: typeAnnotation3,
        kind: null
      };
      const defs = NODE_FIELDS.TSMethodSignature;
      validate2(defs.key, node, "key", key, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.parameters, node, "parameters", parameters, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsIndexSignature(parameters, typeAnnotation3 = null) {
      const node = {
        type: "TSIndexSignature",
        parameters,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSIndexSignature;
      validate2(defs.parameters, node, "parameters", parameters, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsAnyKeyword() {
      return {
        type: "TSAnyKeyword"
      };
    }
    function tsBooleanKeyword() {
      return {
        type: "TSBooleanKeyword"
      };
    }
    function tsBigIntKeyword() {
      return {
        type: "TSBigIntKeyword"
      };
    }
    function tsIntrinsicKeyword() {
      return {
        type: "TSIntrinsicKeyword"
      };
    }
    function tsNeverKeyword() {
      return {
        type: "TSNeverKeyword"
      };
    }
    function tsNullKeyword() {
      return {
        type: "TSNullKeyword"
      };
    }
    function tsNumberKeyword() {
      return {
        type: "TSNumberKeyword"
      };
    }
    function tsObjectKeyword() {
      return {
        type: "TSObjectKeyword"
      };
    }
    function tsStringKeyword() {
      return {
        type: "TSStringKeyword"
      };
    }
    function tsSymbolKeyword() {
      return {
        type: "TSSymbolKeyword"
      };
    }
    function tsUndefinedKeyword() {
      return {
        type: "TSUndefinedKeyword"
      };
    }
    function tsUnknownKeyword() {
      return {
        type: "TSUnknownKeyword"
      };
    }
    function tsVoidKeyword() {
      return {
        type: "TSVoidKeyword"
      };
    }
    function tsThisType() {
      return {
        type: "TSThisType"
      };
    }
    function tsFunctionType(typeParameters = null, parameters, typeAnnotation3 = null) {
      const node = {
        type: "TSFunctionType",
        typeParameters,
        parameters,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSFunctionType;
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.parameters, node, "parameters", parameters, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsConstructorType(typeParameters = null, parameters, typeAnnotation3 = null) {
      const node = {
        type: "TSConstructorType",
        typeParameters,
        parameters,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSConstructorType;
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.parameters, node, "parameters", parameters, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsTypeReference(typeName, typeParameters = null) {
      const node = {
        type: "TSTypeReference",
        typeName,
        typeParameters
      };
      const defs = NODE_FIELDS.TSTypeReference;
      validate2(defs.typeName, node, "typeName", typeName, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      return node;
    }
    function tsTypePredicate(parameterName, typeAnnotation3 = null, asserts = null) {
      const node = {
        type: "TSTypePredicate",
        parameterName,
        typeAnnotation: typeAnnotation3,
        asserts
      };
      const defs = NODE_FIELDS.TSTypePredicate;
      validate2(defs.parameterName, node, "parameterName", parameterName, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      validate2(defs.asserts, node, "asserts", asserts);
      return node;
    }
    function tsTypeQuery(exprName, typeParameters = null) {
      const node = {
        type: "TSTypeQuery",
        exprName,
        typeParameters
      };
      const defs = NODE_FIELDS.TSTypeQuery;
      validate2(defs.exprName, node, "exprName", exprName, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      return node;
    }
    function tsTypeLiteral(members) {
      const node = {
        type: "TSTypeLiteral",
        members
      };
      const defs = NODE_FIELDS.TSTypeLiteral;
      validate2(defs.members, node, "members", members, 1);
      return node;
    }
    function tsArrayType(elementType) {
      const node = {
        type: "TSArrayType",
        elementType
      };
      const defs = NODE_FIELDS.TSArrayType;
      validate2(defs.elementType, node, "elementType", elementType, 1);
      return node;
    }
    function tsTupleType(elementTypes) {
      const node = {
        type: "TSTupleType",
        elementTypes
      };
      const defs = NODE_FIELDS.TSTupleType;
      validate2(defs.elementTypes, node, "elementTypes", elementTypes, 1);
      return node;
    }
    function tsOptionalType(typeAnnotation3) {
      const node = {
        type: "TSOptionalType",
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSOptionalType;
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsRestType(typeAnnotation3) {
      const node = {
        type: "TSRestType",
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSRestType;
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsNamedTupleMember(label, elementType, optional = false) {
      const node = {
        type: "TSNamedTupleMember",
        label,
        elementType,
        optional
      };
      const defs = NODE_FIELDS.TSNamedTupleMember;
      validate2(defs.label, node, "label", label, 1);
      validate2(defs.elementType, node, "elementType", elementType, 1);
      validate2(defs.optional, node, "optional", optional);
      return node;
    }
    function tsUnionType(types) {
      const node = {
        type: "TSUnionType",
        types
      };
      const defs = NODE_FIELDS.TSUnionType;
      validate2(defs.types, node, "types", types, 1);
      return node;
    }
    function tsIntersectionType(types) {
      const node = {
        type: "TSIntersectionType",
        types
      };
      const defs = NODE_FIELDS.TSIntersectionType;
      validate2(defs.types, node, "types", types, 1);
      return node;
    }
    function tsConditionalType(checkType, extendsType, trueType, falseType) {
      const node = {
        type: "TSConditionalType",
        checkType,
        extendsType,
        trueType,
        falseType
      };
      const defs = NODE_FIELDS.TSConditionalType;
      validate2(defs.checkType, node, "checkType", checkType, 1);
      validate2(defs.extendsType, node, "extendsType", extendsType, 1);
      validate2(defs.trueType, node, "trueType", trueType, 1);
      validate2(defs.falseType, node, "falseType", falseType, 1);
      return node;
    }
    function tsInferType(typeParameter2) {
      const node = {
        type: "TSInferType",
        typeParameter: typeParameter2
      };
      const defs = NODE_FIELDS.TSInferType;
      validate2(defs.typeParameter, node, "typeParameter", typeParameter2, 1);
      return node;
    }
    function tsParenthesizedType(typeAnnotation3) {
      const node = {
        type: "TSParenthesizedType",
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSParenthesizedType;
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsTypeOperator(typeAnnotation3) {
      const node = {
        type: "TSTypeOperator",
        typeAnnotation: typeAnnotation3,
        operator: null
      };
      const defs = NODE_FIELDS.TSTypeOperator;
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsIndexedAccessType(objectType, indexType) {
      const node = {
        type: "TSIndexedAccessType",
        objectType,
        indexType
      };
      const defs = NODE_FIELDS.TSIndexedAccessType;
      validate2(defs.objectType, node, "objectType", objectType, 1);
      validate2(defs.indexType, node, "indexType", indexType, 1);
      return node;
    }
    function tsMappedType(typeParameter2, typeAnnotation3 = null, nameType = null) {
      const node = {
        type: "TSMappedType",
        typeParameter: typeParameter2,
        typeAnnotation: typeAnnotation3,
        nameType
      };
      const defs = NODE_FIELDS.TSMappedType;
      validate2(defs.typeParameter, node, "typeParameter", typeParameter2, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      validate2(defs.nameType, node, "nameType", nameType, 1);
      return node;
    }
    function tsLiteralType(literal) {
      const node = {
        type: "TSLiteralType",
        literal
      };
      const defs = NODE_FIELDS.TSLiteralType;
      validate2(defs.literal, node, "literal", literal, 1);
      return node;
    }
    function tsExpressionWithTypeArguments(expression, typeParameters = null) {
      const node = {
        type: "TSExpressionWithTypeArguments",
        expression,
        typeParameters
      };
      const defs = NODE_FIELDS.TSExpressionWithTypeArguments;
      validate2(defs.expression, node, "expression", expression, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      return node;
    }
    function tsInterfaceDeclaration(id, typeParameters = null, _extends = null, body) {
      const node = {
        type: "TSInterfaceDeclaration",
        id,
        typeParameters,
        extends: _extends,
        body
      };
      const defs = NODE_FIELDS.TSInterfaceDeclaration;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.extends, node, "extends", _extends, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function tsInterfaceBody(body) {
      const node = {
        type: "TSInterfaceBody",
        body
      };
      const defs = NODE_FIELDS.TSInterfaceBody;
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function tsTypeAliasDeclaration(id, typeParameters = null, typeAnnotation3) {
      const node = {
        type: "TSTypeAliasDeclaration",
        id,
        typeParameters,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSTypeAliasDeclaration;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsInstantiationExpression(expression, typeParameters = null) {
      const node = {
        type: "TSInstantiationExpression",
        expression,
        typeParameters
      };
      const defs = NODE_FIELDS.TSInstantiationExpression;
      validate2(defs.expression, node, "expression", expression, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      return node;
    }
    function tsAsExpression2(expression, typeAnnotation3) {
      const node = {
        type: "TSAsExpression",
        expression,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSAsExpression;
      validate2(defs.expression, node, "expression", expression, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsSatisfiesExpression2(expression, typeAnnotation3) {
      const node = {
        type: "TSSatisfiesExpression",
        expression,
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSSatisfiesExpression;
      validate2(defs.expression, node, "expression", expression, 1);
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsTypeAssertion(typeAnnotation3, expression) {
      const node = {
        type: "TSTypeAssertion",
        typeAnnotation: typeAnnotation3,
        expression
      };
      const defs = NODE_FIELDS.TSTypeAssertion;
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function tsEnumDeclaration(id, members) {
      const node = {
        type: "TSEnumDeclaration",
        id,
        members
      };
      const defs = NODE_FIELDS.TSEnumDeclaration;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.members, node, "members", members, 1);
      return node;
    }
    function tsEnumMember(id, initializer = null) {
      const node = {
        type: "TSEnumMember",
        id,
        initializer
      };
      const defs = NODE_FIELDS.TSEnumMember;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.initializer, node, "initializer", initializer, 1);
      return node;
    }
    function tsModuleDeclaration(id, body) {
      const node = {
        type: "TSModuleDeclaration",
        id,
        body,
        kind: null
      };
      const defs = NODE_FIELDS.TSModuleDeclaration;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function tsModuleBlock(body) {
      const node = {
        type: "TSModuleBlock",
        body
      };
      const defs = NODE_FIELDS.TSModuleBlock;
      validate2(defs.body, node, "body", body, 1);
      return node;
    }
    function tsImportType(argument, qualifier = null, typeParameters = null) {
      const node = {
        type: "TSImportType",
        argument,
        qualifier,
        typeParameters
      };
      const defs = NODE_FIELDS.TSImportType;
      validate2(defs.argument, node, "argument", argument, 1);
      validate2(defs.qualifier, node, "qualifier", qualifier, 1);
      validate2(defs.typeParameters, node, "typeParameters", typeParameters, 1);
      return node;
    }
    function tsImportEqualsDeclaration(id, moduleReference) {
      const node = {
        type: "TSImportEqualsDeclaration",
        id,
        moduleReference,
        isExport: null
      };
      const defs = NODE_FIELDS.TSImportEqualsDeclaration;
      validate2(defs.id, node, "id", id, 1);
      validate2(defs.moduleReference, node, "moduleReference", moduleReference, 1);
      return node;
    }
    function tsExternalModuleReference(expression) {
      const node = {
        type: "TSExternalModuleReference",
        expression
      };
      const defs = NODE_FIELDS.TSExternalModuleReference;
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function tsNonNullExpression(expression) {
      const node = {
        type: "TSNonNullExpression",
        expression
      };
      const defs = NODE_FIELDS.TSNonNullExpression;
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function tsExportAssignment(expression) {
      const node = {
        type: "TSExportAssignment",
        expression
      };
      const defs = NODE_FIELDS.TSExportAssignment;
      validate2(defs.expression, node, "expression", expression, 1);
      return node;
    }
    function tsNamespaceExportDeclaration(id) {
      const node = {
        type: "TSNamespaceExportDeclaration",
        id
      };
      const defs = NODE_FIELDS.TSNamespaceExportDeclaration;
      validate2(defs.id, node, "id", id, 1);
      return node;
    }
    function tsTypeAnnotation(typeAnnotation3) {
      const node = {
        type: "TSTypeAnnotation",
        typeAnnotation: typeAnnotation3
      };
      const defs = NODE_FIELDS.TSTypeAnnotation;
      validate2(defs.typeAnnotation, node, "typeAnnotation", typeAnnotation3, 1);
      return node;
    }
    function tsTypeParameterInstantiation(params) {
      const node = {
        type: "TSTypeParameterInstantiation",
        params
      };
      const defs = NODE_FIELDS.TSTypeParameterInstantiation;
      validate2(defs.params, node, "params", params, 1);
      return node;
    }
    function tsTypeParameterDeclaration(params) {
      const node = {
        type: "TSTypeParameterDeclaration",
        params
      };
      const defs = NODE_FIELDS.TSTypeParameterDeclaration;
      validate2(defs.params, node, "params", params, 1);
      return node;
    }
    function tsTypeParameter(constraint = null, _default = null, name) {
      const node = {
        type: "TSTypeParameter",
        constraint,
        default: _default,
        name
      };
      const defs = NODE_FIELDS.TSTypeParameter;
      validate2(defs.constraint, node, "constraint", constraint, 1);
      validate2(defs.default, node, "default", _default, 1);
      validate2(defs.name, node, "name", name);
      return node;
    }
    function NumberLiteral(value) {
      (0, _deprecationWarning.default)("NumberLiteral", "NumericLiteral", "The node type ");
      return numericLiteral2(value);
    }
    function RegexLiteral(pattern, flags = "") {
      (0, _deprecationWarning.default)("RegexLiteral", "RegExpLiteral", "The node type ");
      return regExpLiteral2(pattern, flags);
    }
    function RestProperty(argument) {
      (0, _deprecationWarning.default)("RestProperty", "RestElement", "The node type ");
      return restElement3(argument);
    }
    function SpreadProperty(argument) {
      (0, _deprecationWarning.default)("SpreadProperty", "SpreadElement", "The node type ");
      return spreadElement3(argument);
    }
  }
});

// ../../node_modules/@babel/types/lib/utils/react/cleanJSXElementLiteralChild.js
var require_cleanJSXElementLiteralChild = __commonJS({
  "../../node_modules/@babel/types/lib/utils/react/cleanJSXElementLiteralChild.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = cleanJSXElementLiteralChild;
    var _index = require_generated2();
    var _index2 = require_lib3();
    function cleanJSXElementLiteralChild(child, args) {
      const lines = child.value.split(/\r\n|\n|\r/);
      let lastNonEmptyLine = 0;
      for (let i = 0; i < lines.length; i++) {
        if (/[^ \t]/.exec(lines[i])) {
          lastNonEmptyLine = i;
        }
      }
      let str = "";
      for (let i = 0; i < lines.length; i++) {
        const line = lines[i];
        const isFirstLine = i === 0;
        const isLastLine = i === lines.length - 1;
        const isLastNonEmptyLine = i === lastNonEmptyLine;
        let trimmedLine = line.replace(/\t/g, " ");
        if (!isFirstLine) {
          trimmedLine = trimmedLine.replace(/^ +/, "");
        }
        if (!isLastLine) {
          trimmedLine = trimmedLine.replace(/ +$/, "");
        }
        if (trimmedLine) {
          if (!isLastNonEmptyLine) {
            trimmedLine += " ";
          }
          str += trimmedLine;
        }
      }
      if (str) args.push((0, _index2.inherits)((0, _index.stringLiteral)(str), child));
    }
  }
});

// ../../node_modules/@babel/types/lib/builders/react/buildChildren.js
var require_buildChildren = __commonJS({
  "../../node_modules/@babel/types/lib/builders/react/buildChildren.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = buildChildren;
    var _index = require_generated();
    var _cleanJSXElementLiteralChild = require_cleanJSXElementLiteralChild();
    function buildChildren(node) {
      const elements = [];
      for (let i = 0; i < node.children.length; i++) {
        let child = node.children[i];
        if ((0, _index.isJSXText)(child)) {
          (0, _cleanJSXElementLiteralChild.default)(child, elements);
          continue;
        }
        if ((0, _index.isJSXExpressionContainer)(child)) child = child.expression;
        if ((0, _index.isJSXEmptyExpression)(child)) continue;
        elements.push(child);
      }
      return elements;
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isNode.js
var require_isNode = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isNode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isNode;
    var _index = require_definitions();
    function isNode(node) {
      return !!(node && _index.VISITOR_KEYS[node.type]);
    }
  }
});

// ../../node_modules/@babel/types/lib/asserts/assertNode.js
var require_assertNode = __commonJS({
  "../../node_modules/@babel/types/lib/asserts/assertNode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = assertNode;
    var _isNode = require_isNode();
    function assertNode(node) {
      if (!(0, _isNode.default)(node)) {
        var _node$type;
        const type = (_node$type = node == null ? void 0 : node.type) != null ? _node$type : JSON.stringify(node);
        throw new TypeError(`Not a valid node of type "${type}"`);
      }
    }
  }
});

// ../../node_modules/@babel/types/lib/asserts/generated/index.js
var require_generated3 = __commonJS({
  "../../node_modules/@babel/types/lib/asserts/generated/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.assertAccessor = assertAccessor;
    exports2.assertAnyTypeAnnotation = assertAnyTypeAnnotation;
    exports2.assertArgumentPlaceholder = assertArgumentPlaceholder;
    exports2.assertArrayExpression = assertArrayExpression;
    exports2.assertArrayPattern = assertArrayPattern;
    exports2.assertArrayTypeAnnotation = assertArrayTypeAnnotation;
    exports2.assertArrowFunctionExpression = assertArrowFunctionExpression;
    exports2.assertAssignmentExpression = assertAssignmentExpression;
    exports2.assertAssignmentPattern = assertAssignmentPattern;
    exports2.assertAwaitExpression = assertAwaitExpression;
    exports2.assertBigIntLiteral = assertBigIntLiteral;
    exports2.assertBinary = assertBinary;
    exports2.assertBinaryExpression = assertBinaryExpression;
    exports2.assertBindExpression = assertBindExpression;
    exports2.assertBlock = assertBlock;
    exports2.assertBlockParent = assertBlockParent;
    exports2.assertBlockStatement = assertBlockStatement;
    exports2.assertBooleanLiteral = assertBooleanLiteral;
    exports2.assertBooleanLiteralTypeAnnotation = assertBooleanLiteralTypeAnnotation;
    exports2.assertBooleanTypeAnnotation = assertBooleanTypeAnnotation;
    exports2.assertBreakStatement = assertBreakStatement;
    exports2.assertCallExpression = assertCallExpression;
    exports2.assertCatchClause = assertCatchClause;
    exports2.assertClass = assertClass;
    exports2.assertClassAccessorProperty = assertClassAccessorProperty;
    exports2.assertClassBody = assertClassBody;
    exports2.assertClassDeclaration = assertClassDeclaration;
    exports2.assertClassExpression = assertClassExpression;
    exports2.assertClassImplements = assertClassImplements;
    exports2.assertClassMethod = assertClassMethod;
    exports2.assertClassPrivateMethod = assertClassPrivateMethod;
    exports2.assertClassPrivateProperty = assertClassPrivateProperty;
    exports2.assertClassProperty = assertClassProperty;
    exports2.assertCompletionStatement = assertCompletionStatement;
    exports2.assertConditional = assertConditional;
    exports2.assertConditionalExpression = assertConditionalExpression;
    exports2.assertContinueStatement = assertContinueStatement;
    exports2.assertDebuggerStatement = assertDebuggerStatement;
    exports2.assertDecimalLiteral = assertDecimalLiteral;
    exports2.assertDeclaration = assertDeclaration;
    exports2.assertDeclareClass = assertDeclareClass;
    exports2.assertDeclareExportAllDeclaration = assertDeclareExportAllDeclaration;
    exports2.assertDeclareExportDeclaration = assertDeclareExportDeclaration;
    exports2.assertDeclareFunction = assertDeclareFunction;
    exports2.assertDeclareInterface = assertDeclareInterface;
    exports2.assertDeclareModule = assertDeclareModule;
    exports2.assertDeclareModuleExports = assertDeclareModuleExports;
    exports2.assertDeclareOpaqueType = assertDeclareOpaqueType;
    exports2.assertDeclareTypeAlias = assertDeclareTypeAlias;
    exports2.assertDeclareVariable = assertDeclareVariable;
    exports2.assertDeclaredPredicate = assertDeclaredPredicate;
    exports2.assertDecorator = assertDecorator;
    exports2.assertDirective = assertDirective;
    exports2.assertDirectiveLiteral = assertDirectiveLiteral;
    exports2.assertDoExpression = assertDoExpression;
    exports2.assertDoWhileStatement = assertDoWhileStatement;
    exports2.assertEmptyStatement = assertEmptyStatement;
    exports2.assertEmptyTypeAnnotation = assertEmptyTypeAnnotation;
    exports2.assertEnumBody = assertEnumBody;
    exports2.assertEnumBooleanBody = assertEnumBooleanBody;
    exports2.assertEnumBooleanMember = assertEnumBooleanMember;
    exports2.assertEnumDeclaration = assertEnumDeclaration;
    exports2.assertEnumDefaultedMember = assertEnumDefaultedMember;
    exports2.assertEnumMember = assertEnumMember;
    exports2.assertEnumNumberBody = assertEnumNumberBody;
    exports2.assertEnumNumberMember = assertEnumNumberMember;
    exports2.assertEnumStringBody = assertEnumStringBody;
    exports2.assertEnumStringMember = assertEnumStringMember;
    exports2.assertEnumSymbolBody = assertEnumSymbolBody;
    exports2.assertExistsTypeAnnotation = assertExistsTypeAnnotation;
    exports2.assertExportAllDeclaration = assertExportAllDeclaration;
    exports2.assertExportDeclaration = assertExportDeclaration;
    exports2.assertExportDefaultDeclaration = assertExportDefaultDeclaration;
    exports2.assertExportDefaultSpecifier = assertExportDefaultSpecifier;
    exports2.assertExportNamedDeclaration = assertExportNamedDeclaration;
    exports2.assertExportNamespaceSpecifier = assertExportNamespaceSpecifier;
    exports2.assertExportSpecifier = assertExportSpecifier;
    exports2.assertExpression = assertExpression;
    exports2.assertExpressionStatement = assertExpressionStatement;
    exports2.assertExpressionWrapper = assertExpressionWrapper;
    exports2.assertFile = assertFile;
    exports2.assertFlow = assertFlow;
    exports2.assertFlowBaseAnnotation = assertFlowBaseAnnotation;
    exports2.assertFlowDeclaration = assertFlowDeclaration;
    exports2.assertFlowPredicate = assertFlowPredicate;
    exports2.assertFlowType = assertFlowType;
    exports2.assertFor = assertFor;
    exports2.assertForInStatement = assertForInStatement;
    exports2.assertForOfStatement = assertForOfStatement;
    exports2.assertForStatement = assertForStatement;
    exports2.assertForXStatement = assertForXStatement;
    exports2.assertFunction = assertFunction;
    exports2.assertFunctionDeclaration = assertFunctionDeclaration;
    exports2.assertFunctionExpression = assertFunctionExpression;
    exports2.assertFunctionParent = assertFunctionParent;
    exports2.assertFunctionTypeAnnotation = assertFunctionTypeAnnotation;
    exports2.assertFunctionTypeParam = assertFunctionTypeParam;
    exports2.assertGenericTypeAnnotation = assertGenericTypeAnnotation;
    exports2.assertIdentifier = assertIdentifier;
    exports2.assertIfStatement = assertIfStatement;
    exports2.assertImmutable = assertImmutable;
    exports2.assertImport = assertImport;
    exports2.assertImportAttribute = assertImportAttribute;
    exports2.assertImportDeclaration = assertImportDeclaration;
    exports2.assertImportDefaultSpecifier = assertImportDefaultSpecifier;
    exports2.assertImportExpression = assertImportExpression;
    exports2.assertImportNamespaceSpecifier = assertImportNamespaceSpecifier;
    exports2.assertImportOrExportDeclaration = assertImportOrExportDeclaration;
    exports2.assertImportSpecifier = assertImportSpecifier;
    exports2.assertIndexedAccessType = assertIndexedAccessType;
    exports2.assertInferredPredicate = assertInferredPredicate;
    exports2.assertInterfaceDeclaration = assertInterfaceDeclaration;
    exports2.assertInterfaceExtends = assertInterfaceExtends;
    exports2.assertInterfaceTypeAnnotation = assertInterfaceTypeAnnotation;
    exports2.assertInterpreterDirective = assertInterpreterDirective;
    exports2.assertIntersectionTypeAnnotation = assertIntersectionTypeAnnotation;
    exports2.assertJSX = assertJSX;
    exports2.assertJSXAttribute = assertJSXAttribute;
    exports2.assertJSXClosingElement = assertJSXClosingElement;
    exports2.assertJSXClosingFragment = assertJSXClosingFragment;
    exports2.assertJSXElement = assertJSXElement;
    exports2.assertJSXEmptyExpression = assertJSXEmptyExpression;
    exports2.assertJSXExpressionContainer = assertJSXExpressionContainer;
    exports2.assertJSXFragment = assertJSXFragment;
    exports2.assertJSXIdentifier = assertJSXIdentifier;
    exports2.assertJSXMemberExpression = assertJSXMemberExpression;
    exports2.assertJSXNamespacedName = assertJSXNamespacedName;
    exports2.assertJSXOpeningElement = assertJSXOpeningElement;
    exports2.assertJSXOpeningFragment = assertJSXOpeningFragment;
    exports2.assertJSXSpreadAttribute = assertJSXSpreadAttribute;
    exports2.assertJSXSpreadChild = assertJSXSpreadChild;
    exports2.assertJSXText = assertJSXText;
    exports2.assertLVal = assertLVal;
    exports2.assertLabeledStatement = assertLabeledStatement;
    exports2.assertLiteral = assertLiteral;
    exports2.assertLogicalExpression = assertLogicalExpression;
    exports2.assertLoop = assertLoop;
    exports2.assertMemberExpression = assertMemberExpression;
    exports2.assertMetaProperty = assertMetaProperty;
    exports2.assertMethod = assertMethod;
    exports2.assertMiscellaneous = assertMiscellaneous;
    exports2.assertMixedTypeAnnotation = assertMixedTypeAnnotation;
    exports2.assertModuleDeclaration = assertModuleDeclaration;
    exports2.assertModuleExpression = assertModuleExpression;
    exports2.assertModuleSpecifier = assertModuleSpecifier;
    exports2.assertNewExpression = assertNewExpression;
    exports2.assertNoop = assertNoop;
    exports2.assertNullLiteral = assertNullLiteral;
    exports2.assertNullLiteralTypeAnnotation = assertNullLiteralTypeAnnotation;
    exports2.assertNullableTypeAnnotation = assertNullableTypeAnnotation;
    exports2.assertNumberLiteral = assertNumberLiteral;
    exports2.assertNumberLiteralTypeAnnotation = assertNumberLiteralTypeAnnotation;
    exports2.assertNumberTypeAnnotation = assertNumberTypeAnnotation;
    exports2.assertNumericLiteral = assertNumericLiteral;
    exports2.assertObjectExpression = assertObjectExpression;
    exports2.assertObjectMember = assertObjectMember;
    exports2.assertObjectMethod = assertObjectMethod;
    exports2.assertObjectPattern = assertObjectPattern;
    exports2.assertObjectProperty = assertObjectProperty;
    exports2.assertObjectTypeAnnotation = assertObjectTypeAnnotation;
    exports2.assertObjectTypeCallProperty = assertObjectTypeCallProperty;
    exports2.assertObjectTypeIndexer = assertObjectTypeIndexer;
    exports2.assertObjectTypeInternalSlot = assertObjectTypeInternalSlot;
    exports2.assertObjectTypeProperty = assertObjectTypeProperty;
    exports2.assertObjectTypeSpreadProperty = assertObjectTypeSpreadProperty;
    exports2.assertOpaqueType = assertOpaqueType;
    exports2.assertOptionalCallExpression = assertOptionalCallExpression;
    exports2.assertOptionalIndexedAccessType = assertOptionalIndexedAccessType;
    exports2.assertOptionalMemberExpression = assertOptionalMemberExpression;
    exports2.assertParenthesizedExpression = assertParenthesizedExpression;
    exports2.assertPattern = assertPattern;
    exports2.assertPatternLike = assertPatternLike;
    exports2.assertPipelineBareFunction = assertPipelineBareFunction;
    exports2.assertPipelinePrimaryTopicReference = assertPipelinePrimaryTopicReference;
    exports2.assertPipelineTopicExpression = assertPipelineTopicExpression;
    exports2.assertPlaceholder = assertPlaceholder;
    exports2.assertPrivate = assertPrivate;
    exports2.assertPrivateName = assertPrivateName;
    exports2.assertProgram = assertProgram;
    exports2.assertProperty = assertProperty;
    exports2.assertPureish = assertPureish;
    exports2.assertQualifiedTypeIdentifier = assertQualifiedTypeIdentifier;
    exports2.assertRecordExpression = assertRecordExpression;
    exports2.assertRegExpLiteral = assertRegExpLiteral;
    exports2.assertRegexLiteral = assertRegexLiteral;
    exports2.assertRestElement = assertRestElement;
    exports2.assertRestProperty = assertRestProperty;
    exports2.assertReturnStatement = assertReturnStatement;
    exports2.assertScopable = assertScopable;
    exports2.assertSequenceExpression = assertSequenceExpression;
    exports2.assertSpreadElement = assertSpreadElement;
    exports2.assertSpreadProperty = assertSpreadProperty;
    exports2.assertStandardized = assertStandardized;
    exports2.assertStatement = assertStatement;
    exports2.assertStaticBlock = assertStaticBlock;
    exports2.assertStringLiteral = assertStringLiteral;
    exports2.assertStringLiteralTypeAnnotation = assertStringLiteralTypeAnnotation;
    exports2.assertStringTypeAnnotation = assertStringTypeAnnotation;
    exports2.assertSuper = assertSuper;
    exports2.assertSwitchCase = assertSwitchCase;
    exports2.assertSwitchStatement = assertSwitchStatement;
    exports2.assertSymbolTypeAnnotation = assertSymbolTypeAnnotation;
    exports2.assertTSAnyKeyword = assertTSAnyKeyword;
    exports2.assertTSArrayType = assertTSArrayType;
    exports2.assertTSAsExpression = assertTSAsExpression;
    exports2.assertTSBaseType = assertTSBaseType;
    exports2.assertTSBigIntKeyword = assertTSBigIntKeyword;
    exports2.assertTSBooleanKeyword = assertTSBooleanKeyword;
    exports2.assertTSCallSignatureDeclaration = assertTSCallSignatureDeclaration;
    exports2.assertTSConditionalType = assertTSConditionalType;
    exports2.assertTSConstructSignatureDeclaration = assertTSConstructSignatureDeclaration;
    exports2.assertTSConstructorType = assertTSConstructorType;
    exports2.assertTSDeclareFunction = assertTSDeclareFunction;
    exports2.assertTSDeclareMethod = assertTSDeclareMethod;
    exports2.assertTSEntityName = assertTSEntityName;
    exports2.assertTSEnumDeclaration = assertTSEnumDeclaration;
    exports2.assertTSEnumMember = assertTSEnumMember;
    exports2.assertTSExportAssignment = assertTSExportAssignment;
    exports2.assertTSExpressionWithTypeArguments = assertTSExpressionWithTypeArguments;
    exports2.assertTSExternalModuleReference = assertTSExternalModuleReference;
    exports2.assertTSFunctionType = assertTSFunctionType;
    exports2.assertTSImportEqualsDeclaration = assertTSImportEqualsDeclaration;
    exports2.assertTSImportType = assertTSImportType;
    exports2.assertTSIndexSignature = assertTSIndexSignature;
    exports2.assertTSIndexedAccessType = assertTSIndexedAccessType;
    exports2.assertTSInferType = assertTSInferType;
    exports2.assertTSInstantiationExpression = assertTSInstantiationExpression;
    exports2.assertTSInterfaceBody = assertTSInterfaceBody;
    exports2.assertTSInterfaceDeclaration = assertTSInterfaceDeclaration;
    exports2.assertTSIntersectionType = assertTSIntersectionType;
    exports2.assertTSIntrinsicKeyword = assertTSIntrinsicKeyword;
    exports2.assertTSLiteralType = assertTSLiteralType;
    exports2.assertTSMappedType = assertTSMappedType;
    exports2.assertTSMethodSignature = assertTSMethodSignature;
    exports2.assertTSModuleBlock = assertTSModuleBlock;
    exports2.assertTSModuleDeclaration = assertTSModuleDeclaration;
    exports2.assertTSNamedTupleMember = assertTSNamedTupleMember;
    exports2.assertTSNamespaceExportDeclaration = assertTSNamespaceExportDeclaration;
    exports2.assertTSNeverKeyword = assertTSNeverKeyword;
    exports2.assertTSNonNullExpression = assertTSNonNullExpression;
    exports2.assertTSNullKeyword = assertTSNullKeyword;
    exports2.assertTSNumberKeyword = assertTSNumberKeyword;
    exports2.assertTSObjectKeyword = assertTSObjectKeyword;
    exports2.assertTSOptionalType = assertTSOptionalType;
    exports2.assertTSParameterProperty = assertTSParameterProperty;
    exports2.assertTSParenthesizedType = assertTSParenthesizedType;
    exports2.assertTSPropertySignature = assertTSPropertySignature;
    exports2.assertTSQualifiedName = assertTSQualifiedName;
    exports2.assertTSRestType = assertTSRestType;
    exports2.assertTSSatisfiesExpression = assertTSSatisfiesExpression;
    exports2.assertTSStringKeyword = assertTSStringKeyword;
    exports2.assertTSSymbolKeyword = assertTSSymbolKeyword;
    exports2.assertTSThisType = assertTSThisType;
    exports2.assertTSTupleType = assertTSTupleType;
    exports2.assertTSType = assertTSType;
    exports2.assertTSTypeAliasDeclaration = assertTSTypeAliasDeclaration;
    exports2.assertTSTypeAnnotation = assertTSTypeAnnotation;
    exports2.assertTSTypeAssertion = assertTSTypeAssertion;
    exports2.assertTSTypeElement = assertTSTypeElement;
    exports2.assertTSTypeLiteral = assertTSTypeLiteral;
    exports2.assertTSTypeOperator = assertTSTypeOperator;
    exports2.assertTSTypeParameter = assertTSTypeParameter;
    exports2.assertTSTypeParameterDeclaration = assertTSTypeParameterDeclaration;
    exports2.assertTSTypeParameterInstantiation = assertTSTypeParameterInstantiation;
    exports2.assertTSTypePredicate = assertTSTypePredicate;
    exports2.assertTSTypeQuery = assertTSTypeQuery;
    exports2.assertTSTypeReference = assertTSTypeReference;
    exports2.assertTSUndefinedKeyword = assertTSUndefinedKeyword;
    exports2.assertTSUnionType = assertTSUnionType;
    exports2.assertTSUnknownKeyword = assertTSUnknownKeyword;
    exports2.assertTSVoidKeyword = assertTSVoidKeyword;
    exports2.assertTaggedTemplateExpression = assertTaggedTemplateExpression;
    exports2.assertTemplateElement = assertTemplateElement;
    exports2.assertTemplateLiteral = assertTemplateLiteral;
    exports2.assertTerminatorless = assertTerminatorless;
    exports2.assertThisExpression = assertThisExpression;
    exports2.assertThisTypeAnnotation = assertThisTypeAnnotation;
    exports2.assertThrowStatement = assertThrowStatement;
    exports2.assertTopicReference = assertTopicReference;
    exports2.assertTryStatement = assertTryStatement;
    exports2.assertTupleExpression = assertTupleExpression;
    exports2.assertTupleTypeAnnotation = assertTupleTypeAnnotation;
    exports2.assertTypeAlias = assertTypeAlias;
    exports2.assertTypeAnnotation = assertTypeAnnotation;
    exports2.assertTypeCastExpression = assertTypeCastExpression;
    exports2.assertTypeParameter = assertTypeParameter;
    exports2.assertTypeParameterDeclaration = assertTypeParameterDeclaration;
    exports2.assertTypeParameterInstantiation = assertTypeParameterInstantiation;
    exports2.assertTypeScript = assertTypeScript;
    exports2.assertTypeofTypeAnnotation = assertTypeofTypeAnnotation;
    exports2.assertUnaryExpression = assertUnaryExpression;
    exports2.assertUnaryLike = assertUnaryLike;
    exports2.assertUnionTypeAnnotation = assertUnionTypeAnnotation;
    exports2.assertUpdateExpression = assertUpdateExpression;
    exports2.assertUserWhitespacable = assertUserWhitespacable;
    exports2.assertV8IntrinsicIdentifier = assertV8IntrinsicIdentifier;
    exports2.assertVariableDeclaration = assertVariableDeclaration;
    exports2.assertVariableDeclarator = assertVariableDeclarator;
    exports2.assertVariance = assertVariance;
    exports2.assertVoidTypeAnnotation = assertVoidTypeAnnotation;
    exports2.assertWhile = assertWhile;
    exports2.assertWhileStatement = assertWhileStatement;
    exports2.assertWithStatement = assertWithStatement;
    exports2.assertYieldExpression = assertYieldExpression;
    var _is = require_is();
    var _deprecationWarning = require_deprecationWarning();
    function assert(type, node, opts) {
      if (!(0, _is.default)(type, node, opts)) {
        throw new Error(`Expected type "${type}" with option ${JSON.stringify(opts)}, but instead got "${node.type}".`);
      }
    }
    function assertArrayExpression(node, opts) {
      assert("ArrayExpression", node, opts);
    }
    function assertAssignmentExpression(node, opts) {
      assert("AssignmentExpression", node, opts);
    }
    function assertBinaryExpression(node, opts) {
      assert("BinaryExpression", node, opts);
    }
    function assertInterpreterDirective(node, opts) {
      assert("InterpreterDirective", node, opts);
    }
    function assertDirective(node, opts) {
      assert("Directive", node, opts);
    }
    function assertDirectiveLiteral(node, opts) {
      assert("DirectiveLiteral", node, opts);
    }
    function assertBlockStatement(node, opts) {
      assert("BlockStatement", node, opts);
    }
    function assertBreakStatement(node, opts) {
      assert("BreakStatement", node, opts);
    }
    function assertCallExpression(node, opts) {
      assert("CallExpression", node, opts);
    }
    function assertCatchClause(node, opts) {
      assert("CatchClause", node, opts);
    }
    function assertConditionalExpression(node, opts) {
      assert("ConditionalExpression", node, opts);
    }
    function assertContinueStatement(node, opts) {
      assert("ContinueStatement", node, opts);
    }
    function assertDebuggerStatement(node, opts) {
      assert("DebuggerStatement", node, opts);
    }
    function assertDoWhileStatement(node, opts) {
      assert("DoWhileStatement", node, opts);
    }
    function assertEmptyStatement(node, opts) {
      assert("EmptyStatement", node, opts);
    }
    function assertExpressionStatement(node, opts) {
      assert("ExpressionStatement", node, opts);
    }
    function assertFile(node, opts) {
      assert("File", node, opts);
    }
    function assertForInStatement(node, opts) {
      assert("ForInStatement", node, opts);
    }
    function assertForStatement(node, opts) {
      assert("ForStatement", node, opts);
    }
    function assertFunctionDeclaration(node, opts) {
      assert("FunctionDeclaration", node, opts);
    }
    function assertFunctionExpression(node, opts) {
      assert("FunctionExpression", node, opts);
    }
    function assertIdentifier(node, opts) {
      assert("Identifier", node, opts);
    }
    function assertIfStatement(node, opts) {
      assert("IfStatement", node, opts);
    }
    function assertLabeledStatement(node, opts) {
      assert("LabeledStatement", node, opts);
    }
    function assertStringLiteral(node, opts) {
      assert("StringLiteral", node, opts);
    }
    function assertNumericLiteral(node, opts) {
      assert("NumericLiteral", node, opts);
    }
    function assertNullLiteral(node, opts) {
      assert("NullLiteral", node, opts);
    }
    function assertBooleanLiteral(node, opts) {
      assert("BooleanLiteral", node, opts);
    }
    function assertRegExpLiteral(node, opts) {
      assert("RegExpLiteral", node, opts);
    }
    function assertLogicalExpression(node, opts) {
      assert("LogicalExpression", node, opts);
    }
    function assertMemberExpression(node, opts) {
      assert("MemberExpression", node, opts);
    }
    function assertNewExpression(node, opts) {
      assert("NewExpression", node, opts);
    }
    function assertProgram(node, opts) {
      assert("Program", node, opts);
    }
    function assertObjectExpression(node, opts) {
      assert("ObjectExpression", node, opts);
    }
    function assertObjectMethod(node, opts) {
      assert("ObjectMethod", node, opts);
    }
    function assertObjectProperty(node, opts) {
      assert("ObjectProperty", node, opts);
    }
    function assertRestElement(node, opts) {
      assert("RestElement", node, opts);
    }
    function assertReturnStatement(node, opts) {
      assert("ReturnStatement", node, opts);
    }
    function assertSequenceExpression(node, opts) {
      assert("SequenceExpression", node, opts);
    }
    function assertParenthesizedExpression(node, opts) {
      assert("ParenthesizedExpression", node, opts);
    }
    function assertSwitchCase(node, opts) {
      assert("SwitchCase", node, opts);
    }
    function assertSwitchStatement(node, opts) {
      assert("SwitchStatement", node, opts);
    }
    function assertThisExpression(node, opts) {
      assert("ThisExpression", node, opts);
    }
    function assertThrowStatement(node, opts) {
      assert("ThrowStatement", node, opts);
    }
    function assertTryStatement(node, opts) {
      assert("TryStatement", node, opts);
    }
    function assertUnaryExpression(node, opts) {
      assert("UnaryExpression", node, opts);
    }
    function assertUpdateExpression(node, opts) {
      assert("UpdateExpression", node, opts);
    }
    function assertVariableDeclaration(node, opts) {
      assert("VariableDeclaration", node, opts);
    }
    function assertVariableDeclarator(node, opts) {
      assert("VariableDeclarator", node, opts);
    }
    function assertWhileStatement(node, opts) {
      assert("WhileStatement", node, opts);
    }
    function assertWithStatement(node, opts) {
      assert("WithStatement", node, opts);
    }
    function assertAssignmentPattern(node, opts) {
      assert("AssignmentPattern", node, opts);
    }
    function assertArrayPattern(node, opts) {
      assert("ArrayPattern", node, opts);
    }
    function assertArrowFunctionExpression(node, opts) {
      assert("ArrowFunctionExpression", node, opts);
    }
    function assertClassBody(node, opts) {
      assert("ClassBody", node, opts);
    }
    function assertClassExpression(node, opts) {
      assert("ClassExpression", node, opts);
    }
    function assertClassDeclaration(node, opts) {
      assert("ClassDeclaration", node, opts);
    }
    function assertExportAllDeclaration(node, opts) {
      assert("ExportAllDeclaration", node, opts);
    }
    function assertExportDefaultDeclaration(node, opts) {
      assert("ExportDefaultDeclaration", node, opts);
    }
    function assertExportNamedDeclaration(node, opts) {
      assert("ExportNamedDeclaration", node, opts);
    }
    function assertExportSpecifier(node, opts) {
      assert("ExportSpecifier", node, opts);
    }
    function assertForOfStatement(node, opts) {
      assert("ForOfStatement", node, opts);
    }
    function assertImportDeclaration(node, opts) {
      assert("ImportDeclaration", node, opts);
    }
    function assertImportDefaultSpecifier(node, opts) {
      assert("ImportDefaultSpecifier", node, opts);
    }
    function assertImportNamespaceSpecifier(node, opts) {
      assert("ImportNamespaceSpecifier", node, opts);
    }
    function assertImportSpecifier(node, opts) {
      assert("ImportSpecifier", node, opts);
    }
    function assertImportExpression(node, opts) {
      assert("ImportExpression", node, opts);
    }
    function assertMetaProperty(node, opts) {
      assert("MetaProperty", node, opts);
    }
    function assertClassMethod(node, opts) {
      assert("ClassMethod", node, opts);
    }
    function assertObjectPattern(node, opts) {
      assert("ObjectPattern", node, opts);
    }
    function assertSpreadElement(node, opts) {
      assert("SpreadElement", node, opts);
    }
    function assertSuper(node, opts) {
      assert("Super", node, opts);
    }
    function assertTaggedTemplateExpression(node, opts) {
      assert("TaggedTemplateExpression", node, opts);
    }
    function assertTemplateElement(node, opts) {
      assert("TemplateElement", node, opts);
    }
    function assertTemplateLiteral(node, opts) {
      assert("TemplateLiteral", node, opts);
    }
    function assertYieldExpression(node, opts) {
      assert("YieldExpression", node, opts);
    }
    function assertAwaitExpression(node, opts) {
      assert("AwaitExpression", node, opts);
    }
    function assertImport(node, opts) {
      assert("Import", node, opts);
    }
    function assertBigIntLiteral(node, opts) {
      assert("BigIntLiteral", node, opts);
    }
    function assertExportNamespaceSpecifier(node, opts) {
      assert("ExportNamespaceSpecifier", node, opts);
    }
    function assertOptionalMemberExpression(node, opts) {
      assert("OptionalMemberExpression", node, opts);
    }
    function assertOptionalCallExpression(node, opts) {
      assert("OptionalCallExpression", node, opts);
    }
    function assertClassProperty(node, opts) {
      assert("ClassProperty", node, opts);
    }
    function assertClassAccessorProperty(node, opts) {
      assert("ClassAccessorProperty", node, opts);
    }
    function assertClassPrivateProperty(node, opts) {
      assert("ClassPrivateProperty", node, opts);
    }
    function assertClassPrivateMethod(node, opts) {
      assert("ClassPrivateMethod", node, opts);
    }
    function assertPrivateName(node, opts) {
      assert("PrivateName", node, opts);
    }
    function assertStaticBlock(node, opts) {
      assert("StaticBlock", node, opts);
    }
    function assertAnyTypeAnnotation(node, opts) {
      assert("AnyTypeAnnotation", node, opts);
    }
    function assertArrayTypeAnnotation(node, opts) {
      assert("ArrayTypeAnnotation", node, opts);
    }
    function assertBooleanTypeAnnotation(node, opts) {
      assert("BooleanTypeAnnotation", node, opts);
    }
    function assertBooleanLiteralTypeAnnotation(node, opts) {
      assert("BooleanLiteralTypeAnnotation", node, opts);
    }
    function assertNullLiteralTypeAnnotation(node, opts) {
      assert("NullLiteralTypeAnnotation", node, opts);
    }
    function assertClassImplements(node, opts) {
      assert("ClassImplements", node, opts);
    }
    function assertDeclareClass(node, opts) {
      assert("DeclareClass", node, opts);
    }
    function assertDeclareFunction(node, opts) {
      assert("DeclareFunction", node, opts);
    }
    function assertDeclareInterface(node, opts) {
      assert("DeclareInterface", node, opts);
    }
    function assertDeclareModule(node, opts) {
      assert("DeclareModule", node, opts);
    }
    function assertDeclareModuleExports(node, opts) {
      assert("DeclareModuleExports", node, opts);
    }
    function assertDeclareTypeAlias(node, opts) {
      assert("DeclareTypeAlias", node, opts);
    }
    function assertDeclareOpaqueType(node, opts) {
      assert("DeclareOpaqueType", node, opts);
    }
    function assertDeclareVariable(node, opts) {
      assert("DeclareVariable", node, opts);
    }
    function assertDeclareExportDeclaration(node, opts) {
      assert("DeclareExportDeclaration", node, opts);
    }
    function assertDeclareExportAllDeclaration(node, opts) {
      assert("DeclareExportAllDeclaration", node, opts);
    }
    function assertDeclaredPredicate(node, opts) {
      assert("DeclaredPredicate", node, opts);
    }
    function assertExistsTypeAnnotation(node, opts) {
      assert("ExistsTypeAnnotation", node, opts);
    }
    function assertFunctionTypeAnnotation(node, opts) {
      assert("FunctionTypeAnnotation", node, opts);
    }
    function assertFunctionTypeParam(node, opts) {
      assert("FunctionTypeParam", node, opts);
    }
    function assertGenericTypeAnnotation(node, opts) {
      assert("GenericTypeAnnotation", node, opts);
    }
    function assertInferredPredicate(node, opts) {
      assert("InferredPredicate", node, opts);
    }
    function assertInterfaceExtends(node, opts) {
      assert("InterfaceExtends", node, opts);
    }
    function assertInterfaceDeclaration(node, opts) {
      assert("InterfaceDeclaration", node, opts);
    }
    function assertInterfaceTypeAnnotation(node, opts) {
      assert("InterfaceTypeAnnotation", node, opts);
    }
    function assertIntersectionTypeAnnotation(node, opts) {
      assert("IntersectionTypeAnnotation", node, opts);
    }
    function assertMixedTypeAnnotation(node, opts) {
      assert("MixedTypeAnnotation", node, opts);
    }
    function assertEmptyTypeAnnotation(node, opts) {
      assert("EmptyTypeAnnotation", node, opts);
    }
    function assertNullableTypeAnnotation(node, opts) {
      assert("NullableTypeAnnotation", node, opts);
    }
    function assertNumberLiteralTypeAnnotation(node, opts) {
      assert("NumberLiteralTypeAnnotation", node, opts);
    }
    function assertNumberTypeAnnotation(node, opts) {
      assert("NumberTypeAnnotation", node, opts);
    }
    function assertObjectTypeAnnotation(node, opts) {
      assert("ObjectTypeAnnotation", node, opts);
    }
    function assertObjectTypeInternalSlot(node, opts) {
      assert("ObjectTypeInternalSlot", node, opts);
    }
    function assertObjectTypeCallProperty(node, opts) {
      assert("ObjectTypeCallProperty", node, opts);
    }
    function assertObjectTypeIndexer(node, opts) {
      assert("ObjectTypeIndexer", node, opts);
    }
    function assertObjectTypeProperty(node, opts) {
      assert("ObjectTypeProperty", node, opts);
    }
    function assertObjectTypeSpreadProperty(node, opts) {
      assert("ObjectTypeSpreadProperty", node, opts);
    }
    function assertOpaqueType(node, opts) {
      assert("OpaqueType", node, opts);
    }
    function assertQualifiedTypeIdentifier(node, opts) {
      assert("QualifiedTypeIdentifier", node, opts);
    }
    function assertStringLiteralTypeAnnotation(node, opts) {
      assert("StringLiteralTypeAnnotation", node, opts);
    }
    function assertStringTypeAnnotation(node, opts) {
      assert("StringTypeAnnotation", node, opts);
    }
    function assertSymbolTypeAnnotation(node, opts) {
      assert("SymbolTypeAnnotation", node, opts);
    }
    function assertThisTypeAnnotation(node, opts) {
      assert("ThisTypeAnnotation", node, opts);
    }
    function assertTupleTypeAnnotation(node, opts) {
      assert("TupleTypeAnnotation", node, opts);
    }
    function assertTypeofTypeAnnotation(node, opts) {
      assert("TypeofTypeAnnotation", node, opts);
    }
    function assertTypeAlias(node, opts) {
      assert("TypeAlias", node, opts);
    }
    function assertTypeAnnotation(node, opts) {
      assert("TypeAnnotation", node, opts);
    }
    function assertTypeCastExpression(node, opts) {
      assert("TypeCastExpression", node, opts);
    }
    function assertTypeParameter(node, opts) {
      assert("TypeParameter", node, opts);
    }
    function assertTypeParameterDeclaration(node, opts) {
      assert("TypeParameterDeclaration", node, opts);
    }
    function assertTypeParameterInstantiation(node, opts) {
      assert("TypeParameterInstantiation", node, opts);
    }
    function assertUnionTypeAnnotation(node, opts) {
      assert("UnionTypeAnnotation", node, opts);
    }
    function assertVariance(node, opts) {
      assert("Variance", node, opts);
    }
    function assertVoidTypeAnnotation(node, opts) {
      assert("VoidTypeAnnotation", node, opts);
    }
    function assertEnumDeclaration(node, opts) {
      assert("EnumDeclaration", node, opts);
    }
    function assertEnumBooleanBody(node, opts) {
      assert("EnumBooleanBody", node, opts);
    }
    function assertEnumNumberBody(node, opts) {
      assert("EnumNumberBody", node, opts);
    }
    function assertEnumStringBody(node, opts) {
      assert("EnumStringBody", node, opts);
    }
    function assertEnumSymbolBody(node, opts) {
      assert("EnumSymbolBody", node, opts);
    }
    function assertEnumBooleanMember(node, opts) {
      assert("EnumBooleanMember", node, opts);
    }
    function assertEnumNumberMember(node, opts) {
      assert("EnumNumberMember", node, opts);
    }
    function assertEnumStringMember(node, opts) {
      assert("EnumStringMember", node, opts);
    }
    function assertEnumDefaultedMember(node, opts) {
      assert("EnumDefaultedMember", node, opts);
    }
    function assertIndexedAccessType(node, opts) {
      assert("IndexedAccessType", node, opts);
    }
    function assertOptionalIndexedAccessType(node, opts) {
      assert("OptionalIndexedAccessType", node, opts);
    }
    function assertJSXAttribute(node, opts) {
      assert("JSXAttribute", node, opts);
    }
    function assertJSXClosingElement(node, opts) {
      assert("JSXClosingElement", node, opts);
    }
    function assertJSXElement(node, opts) {
      assert("JSXElement", node, opts);
    }
    function assertJSXEmptyExpression(node, opts) {
      assert("JSXEmptyExpression", node, opts);
    }
    function assertJSXExpressionContainer(node, opts) {
      assert("JSXExpressionContainer", node, opts);
    }
    function assertJSXSpreadChild(node, opts) {
      assert("JSXSpreadChild", node, opts);
    }
    function assertJSXIdentifier(node, opts) {
      assert("JSXIdentifier", node, opts);
    }
    function assertJSXMemberExpression(node, opts) {
      assert("JSXMemberExpression", node, opts);
    }
    function assertJSXNamespacedName(node, opts) {
      assert("JSXNamespacedName", node, opts);
    }
    function assertJSXOpeningElement(node, opts) {
      assert("JSXOpeningElement", node, opts);
    }
    function assertJSXSpreadAttribute(node, opts) {
      assert("JSXSpreadAttribute", node, opts);
    }
    function assertJSXText(node, opts) {
      assert("JSXText", node, opts);
    }
    function assertJSXFragment(node, opts) {
      assert("JSXFragment", node, opts);
    }
    function assertJSXOpeningFragment(node, opts) {
      assert("JSXOpeningFragment", node, opts);
    }
    function assertJSXClosingFragment(node, opts) {
      assert("JSXClosingFragment", node, opts);
    }
    function assertNoop(node, opts) {
      assert("Noop", node, opts);
    }
    function assertPlaceholder(node, opts) {
      assert("Placeholder", node, opts);
    }
    function assertV8IntrinsicIdentifier(node, opts) {
      assert("V8IntrinsicIdentifier", node, opts);
    }
    function assertArgumentPlaceholder(node, opts) {
      assert("ArgumentPlaceholder", node, opts);
    }
    function assertBindExpression(node, opts) {
      assert("BindExpression", node, opts);
    }
    function assertImportAttribute(node, opts) {
      assert("ImportAttribute", node, opts);
    }
    function assertDecorator(node, opts) {
      assert("Decorator", node, opts);
    }
    function assertDoExpression(node, opts) {
      assert("DoExpression", node, opts);
    }
    function assertExportDefaultSpecifier(node, opts) {
      assert("ExportDefaultSpecifier", node, opts);
    }
    function assertRecordExpression(node, opts) {
      assert("RecordExpression", node, opts);
    }
    function assertTupleExpression(node, opts) {
      assert("TupleExpression", node, opts);
    }
    function assertDecimalLiteral(node, opts) {
      assert("DecimalLiteral", node, opts);
    }
    function assertModuleExpression(node, opts) {
      assert("ModuleExpression", node, opts);
    }
    function assertTopicReference(node, opts) {
      assert("TopicReference", node, opts);
    }
    function assertPipelineTopicExpression(node, opts) {
      assert("PipelineTopicExpression", node, opts);
    }
    function assertPipelineBareFunction(node, opts) {
      assert("PipelineBareFunction", node, opts);
    }
    function assertPipelinePrimaryTopicReference(node, opts) {
      assert("PipelinePrimaryTopicReference", node, opts);
    }
    function assertTSParameterProperty(node, opts) {
      assert("TSParameterProperty", node, opts);
    }
    function assertTSDeclareFunction(node, opts) {
      assert("TSDeclareFunction", node, opts);
    }
    function assertTSDeclareMethod(node, opts) {
      assert("TSDeclareMethod", node, opts);
    }
    function assertTSQualifiedName(node, opts) {
      assert("TSQualifiedName", node, opts);
    }
    function assertTSCallSignatureDeclaration(node, opts) {
      assert("TSCallSignatureDeclaration", node, opts);
    }
    function assertTSConstructSignatureDeclaration(node, opts) {
      assert("TSConstructSignatureDeclaration", node, opts);
    }
    function assertTSPropertySignature(node, opts) {
      assert("TSPropertySignature", node, opts);
    }
    function assertTSMethodSignature(node, opts) {
      assert("TSMethodSignature", node, opts);
    }
    function assertTSIndexSignature(node, opts) {
      assert("TSIndexSignature", node, opts);
    }
    function assertTSAnyKeyword(node, opts) {
      assert("TSAnyKeyword", node, opts);
    }
    function assertTSBooleanKeyword(node, opts) {
      assert("TSBooleanKeyword", node, opts);
    }
    function assertTSBigIntKeyword(node, opts) {
      assert("TSBigIntKeyword", node, opts);
    }
    function assertTSIntrinsicKeyword(node, opts) {
      assert("TSIntrinsicKeyword", node, opts);
    }
    function assertTSNeverKeyword(node, opts) {
      assert("TSNeverKeyword", node, opts);
    }
    function assertTSNullKeyword(node, opts) {
      assert("TSNullKeyword", node, opts);
    }
    function assertTSNumberKeyword(node, opts) {
      assert("TSNumberKeyword", node, opts);
    }
    function assertTSObjectKeyword(node, opts) {
      assert("TSObjectKeyword", node, opts);
    }
    function assertTSStringKeyword(node, opts) {
      assert("TSStringKeyword", node, opts);
    }
    function assertTSSymbolKeyword(node, opts) {
      assert("TSSymbolKeyword", node, opts);
    }
    function assertTSUndefinedKeyword(node, opts) {
      assert("TSUndefinedKeyword", node, opts);
    }
    function assertTSUnknownKeyword(node, opts) {
      assert("TSUnknownKeyword", node, opts);
    }
    function assertTSVoidKeyword(node, opts) {
      assert("TSVoidKeyword", node, opts);
    }
    function assertTSThisType(node, opts) {
      assert("TSThisType", node, opts);
    }
    function assertTSFunctionType(node, opts) {
      assert("TSFunctionType", node, opts);
    }
    function assertTSConstructorType(node, opts) {
      assert("TSConstructorType", node, opts);
    }
    function assertTSTypeReference(node, opts) {
      assert("TSTypeReference", node, opts);
    }
    function assertTSTypePredicate(node, opts) {
      assert("TSTypePredicate", node, opts);
    }
    function assertTSTypeQuery(node, opts) {
      assert("TSTypeQuery", node, opts);
    }
    function assertTSTypeLiteral(node, opts) {
      assert("TSTypeLiteral", node, opts);
    }
    function assertTSArrayType(node, opts) {
      assert("TSArrayType", node, opts);
    }
    function assertTSTupleType(node, opts) {
      assert("TSTupleType", node, opts);
    }
    function assertTSOptionalType(node, opts) {
      assert("TSOptionalType", node, opts);
    }
    function assertTSRestType(node, opts) {
      assert("TSRestType", node, opts);
    }
    function assertTSNamedTupleMember(node, opts) {
      assert("TSNamedTupleMember", node, opts);
    }
    function assertTSUnionType(node, opts) {
      assert("TSUnionType", node, opts);
    }
    function assertTSIntersectionType(node, opts) {
      assert("TSIntersectionType", node, opts);
    }
    function assertTSConditionalType(node, opts) {
      assert("TSConditionalType", node, opts);
    }
    function assertTSInferType(node, opts) {
      assert("TSInferType", node, opts);
    }
    function assertTSParenthesizedType(node, opts) {
      assert("TSParenthesizedType", node, opts);
    }
    function assertTSTypeOperator(node, opts) {
      assert("TSTypeOperator", node, opts);
    }
    function assertTSIndexedAccessType(node, opts) {
      assert("TSIndexedAccessType", node, opts);
    }
    function assertTSMappedType(node, opts) {
      assert("TSMappedType", node, opts);
    }
    function assertTSLiteralType(node, opts) {
      assert("TSLiteralType", node, opts);
    }
    function assertTSExpressionWithTypeArguments(node, opts) {
      assert("TSExpressionWithTypeArguments", node, opts);
    }
    function assertTSInterfaceDeclaration(node, opts) {
      assert("TSInterfaceDeclaration", node, opts);
    }
    function assertTSInterfaceBody(node, opts) {
      assert("TSInterfaceBody", node, opts);
    }
    function assertTSTypeAliasDeclaration(node, opts) {
      assert("TSTypeAliasDeclaration", node, opts);
    }
    function assertTSInstantiationExpression(node, opts) {
      assert("TSInstantiationExpression", node, opts);
    }
    function assertTSAsExpression(node, opts) {
      assert("TSAsExpression", node, opts);
    }
    function assertTSSatisfiesExpression(node, opts) {
      assert("TSSatisfiesExpression", node, opts);
    }
    function assertTSTypeAssertion(node, opts) {
      assert("TSTypeAssertion", node, opts);
    }
    function assertTSEnumDeclaration(node, opts) {
      assert("TSEnumDeclaration", node, opts);
    }
    function assertTSEnumMember(node, opts) {
      assert("TSEnumMember", node, opts);
    }
    function assertTSModuleDeclaration(node, opts) {
      assert("TSModuleDeclaration", node, opts);
    }
    function assertTSModuleBlock(node, opts) {
      assert("TSModuleBlock", node, opts);
    }
    function assertTSImportType(node, opts) {
      assert("TSImportType", node, opts);
    }
    function assertTSImportEqualsDeclaration(node, opts) {
      assert("TSImportEqualsDeclaration", node, opts);
    }
    function assertTSExternalModuleReference(node, opts) {
      assert("TSExternalModuleReference", node, opts);
    }
    function assertTSNonNullExpression(node, opts) {
      assert("TSNonNullExpression", node, opts);
    }
    function assertTSExportAssignment(node, opts) {
      assert("TSExportAssignment", node, opts);
    }
    function assertTSNamespaceExportDeclaration(node, opts) {
      assert("TSNamespaceExportDeclaration", node, opts);
    }
    function assertTSTypeAnnotation(node, opts) {
      assert("TSTypeAnnotation", node, opts);
    }
    function assertTSTypeParameterInstantiation(node, opts) {
      assert("TSTypeParameterInstantiation", node, opts);
    }
    function assertTSTypeParameterDeclaration(node, opts) {
      assert("TSTypeParameterDeclaration", node, opts);
    }
    function assertTSTypeParameter(node, opts) {
      assert("TSTypeParameter", node, opts);
    }
    function assertStandardized(node, opts) {
      assert("Standardized", node, opts);
    }
    function assertExpression(node, opts) {
      assert("Expression", node, opts);
    }
    function assertBinary(node, opts) {
      assert("Binary", node, opts);
    }
    function assertScopable(node, opts) {
      assert("Scopable", node, opts);
    }
    function assertBlockParent(node, opts) {
      assert("BlockParent", node, opts);
    }
    function assertBlock(node, opts) {
      assert("Block", node, opts);
    }
    function assertStatement(node, opts) {
      assert("Statement", node, opts);
    }
    function assertTerminatorless(node, opts) {
      assert("Terminatorless", node, opts);
    }
    function assertCompletionStatement(node, opts) {
      assert("CompletionStatement", node, opts);
    }
    function assertConditional(node, opts) {
      assert("Conditional", node, opts);
    }
    function assertLoop(node, opts) {
      assert("Loop", node, opts);
    }
    function assertWhile(node, opts) {
      assert("While", node, opts);
    }
    function assertExpressionWrapper(node, opts) {
      assert("ExpressionWrapper", node, opts);
    }
    function assertFor(node, opts) {
      assert("For", node, opts);
    }
    function assertForXStatement(node, opts) {
      assert("ForXStatement", node, opts);
    }
    function assertFunction(node, opts) {
      assert("Function", node, opts);
    }
    function assertFunctionParent(node, opts) {
      assert("FunctionParent", node, opts);
    }
    function assertPureish(node, opts) {
      assert("Pureish", node, opts);
    }
    function assertDeclaration(node, opts) {
      assert("Declaration", node, opts);
    }
    function assertPatternLike(node, opts) {
      assert("PatternLike", node, opts);
    }
    function assertLVal(node, opts) {
      assert("LVal", node, opts);
    }
    function assertTSEntityName(node, opts) {
      assert("TSEntityName", node, opts);
    }
    function assertLiteral(node, opts) {
      assert("Literal", node, opts);
    }
    function assertImmutable(node, opts) {
      assert("Immutable", node, opts);
    }
    function assertUserWhitespacable(node, opts) {
      assert("UserWhitespacable", node, opts);
    }
    function assertMethod(node, opts) {
      assert("Method", node, opts);
    }
    function assertObjectMember(node, opts) {
      assert("ObjectMember", node, opts);
    }
    function assertProperty(node, opts) {
      assert("Property", node, opts);
    }
    function assertUnaryLike(node, opts) {
      assert("UnaryLike", node, opts);
    }
    function assertPattern(node, opts) {
      assert("Pattern", node, opts);
    }
    function assertClass(node, opts) {
      assert("Class", node, opts);
    }
    function assertImportOrExportDeclaration(node, opts) {
      assert("ImportOrExportDeclaration", node, opts);
    }
    function assertExportDeclaration(node, opts) {
      assert("ExportDeclaration", node, opts);
    }
    function assertModuleSpecifier(node, opts) {
      assert("ModuleSpecifier", node, opts);
    }
    function assertAccessor(node, opts) {
      assert("Accessor", node, opts);
    }
    function assertPrivate(node, opts) {
      assert("Private", node, opts);
    }
    function assertFlow(node, opts) {
      assert("Flow", node, opts);
    }
    function assertFlowType(node, opts) {
      assert("FlowType", node, opts);
    }
    function assertFlowBaseAnnotation(node, opts) {
      assert("FlowBaseAnnotation", node, opts);
    }
    function assertFlowDeclaration(node, opts) {
      assert("FlowDeclaration", node, opts);
    }
    function assertFlowPredicate(node, opts) {
      assert("FlowPredicate", node, opts);
    }
    function assertEnumBody(node, opts) {
      assert("EnumBody", node, opts);
    }
    function assertEnumMember(node, opts) {
      assert("EnumMember", node, opts);
    }
    function assertJSX(node, opts) {
      assert("JSX", node, opts);
    }
    function assertMiscellaneous(node, opts) {
      assert("Miscellaneous", node, opts);
    }
    function assertTypeScript(node, opts) {
      assert("TypeScript", node, opts);
    }
    function assertTSTypeElement(node, opts) {
      assert("TSTypeElement", node, opts);
    }
    function assertTSType(node, opts) {
      assert("TSType", node, opts);
    }
    function assertTSBaseType(node, opts) {
      assert("TSBaseType", node, opts);
    }
    function assertNumberLiteral(node, opts) {
      (0, _deprecationWarning.default)("assertNumberLiteral", "assertNumericLiteral");
      assert("NumberLiteral", node, opts);
    }
    function assertRegexLiteral(node, opts) {
      (0, _deprecationWarning.default)("assertRegexLiteral", "assertRegExpLiteral");
      assert("RegexLiteral", node, opts);
    }
    function assertRestProperty(node, opts) {
      (0, _deprecationWarning.default)("assertRestProperty", "assertRestElement");
      assert("RestProperty", node, opts);
    }
    function assertSpreadProperty(node, opts) {
      (0, _deprecationWarning.default)("assertSpreadProperty", "assertSpreadElement");
      assert("SpreadProperty", node, opts);
    }
    function assertModuleDeclaration(node, opts) {
      (0, _deprecationWarning.default)("assertModuleDeclaration", "assertImportOrExportDeclaration");
      assert("ModuleDeclaration", node, opts);
    }
  }
});

// ../../node_modules/@babel/types/lib/builders/flow/createTypeAnnotationBasedOnTypeof.js
var require_createTypeAnnotationBasedOnTypeof = __commonJS({
  "../../node_modules/@babel/types/lib/builders/flow/createTypeAnnotationBasedOnTypeof.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _index = require_generated2();
    var _default = exports2.default = createTypeAnnotationBasedOnTypeof;
    function createTypeAnnotationBasedOnTypeof(type) {
      switch (type) {
        case "string":
          return (0, _index.stringTypeAnnotation)();
        case "number":
          return (0, _index.numberTypeAnnotation)();
        case "undefined":
          return (0, _index.voidTypeAnnotation)();
        case "boolean":
          return (0, _index.booleanTypeAnnotation)();
        case "function":
          return (0, _index.genericTypeAnnotation)((0, _index.identifier)("Function"));
        case "object":
          return (0, _index.genericTypeAnnotation)((0, _index.identifier)("Object"));
        case "symbol":
          return (0, _index.genericTypeAnnotation)((0, _index.identifier)("Symbol"));
        case "bigint":
          return (0, _index.anyTypeAnnotation)();
      }
      throw new Error("Invalid typeof value: " + type);
    }
  }
});

// ../../node_modules/@babel/types/lib/modifications/flow/removeTypeDuplicates.js
var require_removeTypeDuplicates = __commonJS({
  "../../node_modules/@babel/types/lib/modifications/flow/removeTypeDuplicates.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = removeTypeDuplicates;
    var _index = require_generated();
    function getQualifiedName(node) {
      return (0, _index.isIdentifier)(node) ? node.name : `${node.id.name}.${getQualifiedName(node.qualification)}`;
    }
    function removeTypeDuplicates(nodesIn) {
      const nodes = Array.from(nodesIn);
      const generics = /* @__PURE__ */ new Map();
      const bases = /* @__PURE__ */ new Map();
      const typeGroups = /* @__PURE__ */ new Set();
      const types = [];
      for (let i = 0; i < nodes.length; i++) {
        const node = nodes[i];
        if (!node) continue;
        if (types.includes(node)) {
          continue;
        }
        if ((0, _index.isAnyTypeAnnotation)(node)) {
          return [node];
        }
        if ((0, _index.isFlowBaseAnnotation)(node)) {
          bases.set(node.type, node);
          continue;
        }
        if ((0, _index.isUnionTypeAnnotation)(node)) {
          if (!typeGroups.has(node.types)) {
            nodes.push(...node.types);
            typeGroups.add(node.types);
          }
          continue;
        }
        if ((0, _index.isGenericTypeAnnotation)(node)) {
          const name = getQualifiedName(node.id);
          if (generics.has(name)) {
            let existing = generics.get(name);
            if (existing.typeParameters) {
              if (node.typeParameters) {
                existing.typeParameters.params.push(...node.typeParameters.params);
                existing.typeParameters.params = removeTypeDuplicates(existing.typeParameters.params);
              }
            } else {
              existing = node.typeParameters;
            }
          } else {
            generics.set(name, node);
          }
          continue;
        }
        types.push(node);
      }
      for (const [, baseType] of bases) {
        types.push(baseType);
      }
      for (const [, genericName] of generics) {
        types.push(genericName);
      }
      return types;
    }
  }
});

// ../../node_modules/@babel/types/lib/builders/flow/createFlowUnionType.js
var require_createFlowUnionType = __commonJS({
  "../../node_modules/@babel/types/lib/builders/flow/createFlowUnionType.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = createFlowUnionType;
    var _index = require_generated2();
    var _removeTypeDuplicates = require_removeTypeDuplicates();
    function createFlowUnionType(types) {
      const flattened = (0, _removeTypeDuplicates.default)(types);
      if (flattened.length === 1) {
        return flattened[0];
      } else {
        return (0, _index.unionTypeAnnotation)(flattened);
      }
    }
  }
});

// ../../node_modules/@babel/types/lib/modifications/typescript/removeTypeDuplicates.js
var require_removeTypeDuplicates2 = __commonJS({
  "../../node_modules/@babel/types/lib/modifications/typescript/removeTypeDuplicates.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = removeTypeDuplicates;
    var _index = require_generated();
    function getQualifiedName(node) {
      return (0, _index.isIdentifier)(node) ? node.name : `${node.right.name}.${getQualifiedName(node.left)}`;
    }
    function removeTypeDuplicates(nodesIn) {
      const nodes = Array.from(nodesIn);
      const generics = /* @__PURE__ */ new Map();
      const bases = /* @__PURE__ */ new Map();
      const typeGroups = /* @__PURE__ */ new Set();
      const types = [];
      for (let i = 0; i < nodes.length; i++) {
        const node = nodes[i];
        if (!node) continue;
        if (types.includes(node)) {
          continue;
        }
        if ((0, _index.isTSAnyKeyword)(node)) {
          return [node];
        }
        if ((0, _index.isTSBaseType)(node)) {
          bases.set(node.type, node);
          continue;
        }
        if ((0, _index.isTSUnionType)(node)) {
          if (!typeGroups.has(node.types)) {
            nodes.push(...node.types);
            typeGroups.add(node.types);
          }
          continue;
        }
        if ((0, _index.isTSTypeReference)(node) && node.typeParameters) {
          const name = getQualifiedName(node.typeName);
          if (generics.has(name)) {
            let existing = generics.get(name);
            if (existing.typeParameters) {
              if (node.typeParameters) {
                existing.typeParameters.params.push(...node.typeParameters.params);
                existing.typeParameters.params = removeTypeDuplicates(existing.typeParameters.params);
              }
            } else {
              existing = node.typeParameters;
            }
          } else {
            generics.set(name, node);
          }
          continue;
        }
        types.push(node);
      }
      for (const [, baseType] of bases) {
        types.push(baseType);
      }
      for (const [, genericName] of generics) {
        types.push(genericName);
      }
      return types;
    }
  }
});

// ../../node_modules/@babel/types/lib/builders/typescript/createTSUnionType.js
var require_createTSUnionType = __commonJS({
  "../../node_modules/@babel/types/lib/builders/typescript/createTSUnionType.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = createTSUnionType;
    var _index = require_generated2();
    var _removeTypeDuplicates = require_removeTypeDuplicates2();
    var _index2 = require_generated();
    function createTSUnionType(typeAnnotations) {
      const types = typeAnnotations.map((type) => {
        return (0, _index2.isTSTypeAnnotation)(type) ? type.typeAnnotation : type;
      });
      const flattened = (0, _removeTypeDuplicates.default)(types);
      if (flattened.length === 1) {
        return flattened[0];
      } else {
        return (0, _index.tsUnionType)(flattened);
      }
    }
  }
});

// ../../node_modules/@babel/types/lib/builders/generated/uppercase.js
var require_uppercase = __commonJS({
  "../../node_modules/@babel/types/lib/builders/generated/uppercase.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    Object.defineProperty(exports2, "AnyTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.anyTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "ArgumentPlaceholder", {
      enumerable: true,
      get: function() {
        return _index.argumentPlaceholder;
      }
    });
    Object.defineProperty(exports2, "ArrayExpression", {
      enumerable: true,
      get: function() {
        return _index.arrayExpression;
      }
    });
    Object.defineProperty(exports2, "ArrayPattern", {
      enumerable: true,
      get: function() {
        return _index.arrayPattern;
      }
    });
    Object.defineProperty(exports2, "ArrayTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.arrayTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "ArrowFunctionExpression", {
      enumerable: true,
      get: function() {
        return _index.arrowFunctionExpression;
      }
    });
    Object.defineProperty(exports2, "AssignmentExpression", {
      enumerable: true,
      get: function() {
        return _index.assignmentExpression;
      }
    });
    Object.defineProperty(exports2, "AssignmentPattern", {
      enumerable: true,
      get: function() {
        return _index.assignmentPattern;
      }
    });
    Object.defineProperty(exports2, "AwaitExpression", {
      enumerable: true,
      get: function() {
        return _index.awaitExpression;
      }
    });
    Object.defineProperty(exports2, "BigIntLiteral", {
      enumerable: true,
      get: function() {
        return _index.bigIntLiteral;
      }
    });
    Object.defineProperty(exports2, "BinaryExpression", {
      enumerable: true,
      get: function() {
        return _index.binaryExpression;
      }
    });
    Object.defineProperty(exports2, "BindExpression", {
      enumerable: true,
      get: function() {
        return _index.bindExpression;
      }
    });
    Object.defineProperty(exports2, "BlockStatement", {
      enumerable: true,
      get: function() {
        return _index.blockStatement;
      }
    });
    Object.defineProperty(exports2, "BooleanLiteral", {
      enumerable: true,
      get: function() {
        return _index.booleanLiteral;
      }
    });
    Object.defineProperty(exports2, "BooleanLiteralTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.booleanLiteralTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "BooleanTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.booleanTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "BreakStatement", {
      enumerable: true,
      get: function() {
        return _index.breakStatement;
      }
    });
    Object.defineProperty(exports2, "CallExpression", {
      enumerable: true,
      get: function() {
        return _index.callExpression;
      }
    });
    Object.defineProperty(exports2, "CatchClause", {
      enumerable: true,
      get: function() {
        return _index.catchClause;
      }
    });
    Object.defineProperty(exports2, "ClassAccessorProperty", {
      enumerable: true,
      get: function() {
        return _index.classAccessorProperty;
      }
    });
    Object.defineProperty(exports2, "ClassBody", {
      enumerable: true,
      get: function() {
        return _index.classBody;
      }
    });
    Object.defineProperty(exports2, "ClassDeclaration", {
      enumerable: true,
      get: function() {
        return _index.classDeclaration;
      }
    });
    Object.defineProperty(exports2, "ClassExpression", {
      enumerable: true,
      get: function() {
        return _index.classExpression;
      }
    });
    Object.defineProperty(exports2, "ClassImplements", {
      enumerable: true,
      get: function() {
        return _index.classImplements;
      }
    });
    Object.defineProperty(exports2, "ClassMethod", {
      enumerable: true,
      get: function() {
        return _index.classMethod;
      }
    });
    Object.defineProperty(exports2, "ClassPrivateMethod", {
      enumerable: true,
      get: function() {
        return _index.classPrivateMethod;
      }
    });
    Object.defineProperty(exports2, "ClassPrivateProperty", {
      enumerable: true,
      get: function() {
        return _index.classPrivateProperty;
      }
    });
    Object.defineProperty(exports2, "ClassProperty", {
      enumerable: true,
      get: function() {
        return _index.classProperty;
      }
    });
    Object.defineProperty(exports2, "ConditionalExpression", {
      enumerable: true,
      get: function() {
        return _index.conditionalExpression;
      }
    });
    Object.defineProperty(exports2, "ContinueStatement", {
      enumerable: true,
      get: function() {
        return _index.continueStatement;
      }
    });
    Object.defineProperty(exports2, "DebuggerStatement", {
      enumerable: true,
      get: function() {
        return _index.debuggerStatement;
      }
    });
    Object.defineProperty(exports2, "DecimalLiteral", {
      enumerable: true,
      get: function() {
        return _index.decimalLiteral;
      }
    });
    Object.defineProperty(exports2, "DeclareClass", {
      enumerable: true,
      get: function() {
        return _index.declareClass;
      }
    });
    Object.defineProperty(exports2, "DeclareExportAllDeclaration", {
      enumerable: true,
      get: function() {
        return _index.declareExportAllDeclaration;
      }
    });
    Object.defineProperty(exports2, "DeclareExportDeclaration", {
      enumerable: true,
      get: function() {
        return _index.declareExportDeclaration;
      }
    });
    Object.defineProperty(exports2, "DeclareFunction", {
      enumerable: true,
      get: function() {
        return _index.declareFunction;
      }
    });
    Object.defineProperty(exports2, "DeclareInterface", {
      enumerable: true,
      get: function() {
        return _index.declareInterface;
      }
    });
    Object.defineProperty(exports2, "DeclareModule", {
      enumerable: true,
      get: function() {
        return _index.declareModule;
      }
    });
    Object.defineProperty(exports2, "DeclareModuleExports", {
      enumerable: true,
      get: function() {
        return _index.declareModuleExports;
      }
    });
    Object.defineProperty(exports2, "DeclareOpaqueType", {
      enumerable: true,
      get: function() {
        return _index.declareOpaqueType;
      }
    });
    Object.defineProperty(exports2, "DeclareTypeAlias", {
      enumerable: true,
      get: function() {
        return _index.declareTypeAlias;
      }
    });
    Object.defineProperty(exports2, "DeclareVariable", {
      enumerable: true,
      get: function() {
        return _index.declareVariable;
      }
    });
    Object.defineProperty(exports2, "DeclaredPredicate", {
      enumerable: true,
      get: function() {
        return _index.declaredPredicate;
      }
    });
    Object.defineProperty(exports2, "Decorator", {
      enumerable: true,
      get: function() {
        return _index.decorator;
      }
    });
    Object.defineProperty(exports2, "Directive", {
      enumerable: true,
      get: function() {
        return _index.directive;
      }
    });
    Object.defineProperty(exports2, "DirectiveLiteral", {
      enumerable: true,
      get: function() {
        return _index.directiveLiteral;
      }
    });
    Object.defineProperty(exports2, "DoExpression", {
      enumerable: true,
      get: function() {
        return _index.doExpression;
      }
    });
    Object.defineProperty(exports2, "DoWhileStatement", {
      enumerable: true,
      get: function() {
        return _index.doWhileStatement;
      }
    });
    Object.defineProperty(exports2, "EmptyStatement", {
      enumerable: true,
      get: function() {
        return _index.emptyStatement;
      }
    });
    Object.defineProperty(exports2, "EmptyTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.emptyTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "EnumBooleanBody", {
      enumerable: true,
      get: function() {
        return _index.enumBooleanBody;
      }
    });
    Object.defineProperty(exports2, "EnumBooleanMember", {
      enumerable: true,
      get: function() {
        return _index.enumBooleanMember;
      }
    });
    Object.defineProperty(exports2, "EnumDeclaration", {
      enumerable: true,
      get: function() {
        return _index.enumDeclaration;
      }
    });
    Object.defineProperty(exports2, "EnumDefaultedMember", {
      enumerable: true,
      get: function() {
        return _index.enumDefaultedMember;
      }
    });
    Object.defineProperty(exports2, "EnumNumberBody", {
      enumerable: true,
      get: function() {
        return _index.enumNumberBody;
      }
    });
    Object.defineProperty(exports2, "EnumNumberMember", {
      enumerable: true,
      get: function() {
        return _index.enumNumberMember;
      }
    });
    Object.defineProperty(exports2, "EnumStringBody", {
      enumerable: true,
      get: function() {
        return _index.enumStringBody;
      }
    });
    Object.defineProperty(exports2, "EnumStringMember", {
      enumerable: true,
      get: function() {
        return _index.enumStringMember;
      }
    });
    Object.defineProperty(exports2, "EnumSymbolBody", {
      enumerable: true,
      get: function() {
        return _index.enumSymbolBody;
      }
    });
    Object.defineProperty(exports2, "ExistsTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.existsTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "ExportAllDeclaration", {
      enumerable: true,
      get: function() {
        return _index.exportAllDeclaration;
      }
    });
    Object.defineProperty(exports2, "ExportDefaultDeclaration", {
      enumerable: true,
      get: function() {
        return _index.exportDefaultDeclaration;
      }
    });
    Object.defineProperty(exports2, "ExportDefaultSpecifier", {
      enumerable: true,
      get: function() {
        return _index.exportDefaultSpecifier;
      }
    });
    Object.defineProperty(exports2, "ExportNamedDeclaration", {
      enumerable: true,
      get: function() {
        return _index.exportNamedDeclaration;
      }
    });
    Object.defineProperty(exports2, "ExportNamespaceSpecifier", {
      enumerable: true,
      get: function() {
        return _index.exportNamespaceSpecifier;
      }
    });
    Object.defineProperty(exports2, "ExportSpecifier", {
      enumerable: true,
      get: function() {
        return _index.exportSpecifier;
      }
    });
    Object.defineProperty(exports2, "ExpressionStatement", {
      enumerable: true,
      get: function() {
        return _index.expressionStatement;
      }
    });
    Object.defineProperty(exports2, "File", {
      enumerable: true,
      get: function() {
        return _index.file;
      }
    });
    Object.defineProperty(exports2, "ForInStatement", {
      enumerable: true,
      get: function() {
        return _index.forInStatement;
      }
    });
    Object.defineProperty(exports2, "ForOfStatement", {
      enumerable: true,
      get: function() {
        return _index.forOfStatement;
      }
    });
    Object.defineProperty(exports2, "ForStatement", {
      enumerable: true,
      get: function() {
        return _index.forStatement;
      }
    });
    Object.defineProperty(exports2, "FunctionDeclaration", {
      enumerable: true,
      get: function() {
        return _index.functionDeclaration;
      }
    });
    Object.defineProperty(exports2, "FunctionExpression", {
      enumerable: true,
      get: function() {
        return _index.functionExpression;
      }
    });
    Object.defineProperty(exports2, "FunctionTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.functionTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "FunctionTypeParam", {
      enumerable: true,
      get: function() {
        return _index.functionTypeParam;
      }
    });
    Object.defineProperty(exports2, "GenericTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.genericTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "Identifier", {
      enumerable: true,
      get: function() {
        return _index.identifier;
      }
    });
    Object.defineProperty(exports2, "IfStatement", {
      enumerable: true,
      get: function() {
        return _index.ifStatement;
      }
    });
    Object.defineProperty(exports2, "Import", {
      enumerable: true,
      get: function() {
        return _index.import;
      }
    });
    Object.defineProperty(exports2, "ImportAttribute", {
      enumerable: true,
      get: function() {
        return _index.importAttribute;
      }
    });
    Object.defineProperty(exports2, "ImportDeclaration", {
      enumerable: true,
      get: function() {
        return _index.importDeclaration;
      }
    });
    Object.defineProperty(exports2, "ImportDefaultSpecifier", {
      enumerable: true,
      get: function() {
        return _index.importDefaultSpecifier;
      }
    });
    Object.defineProperty(exports2, "ImportExpression", {
      enumerable: true,
      get: function() {
        return _index.importExpression;
      }
    });
    Object.defineProperty(exports2, "ImportNamespaceSpecifier", {
      enumerable: true,
      get: function() {
        return _index.importNamespaceSpecifier;
      }
    });
    Object.defineProperty(exports2, "ImportSpecifier", {
      enumerable: true,
      get: function() {
        return _index.importSpecifier;
      }
    });
    Object.defineProperty(exports2, "IndexedAccessType", {
      enumerable: true,
      get: function() {
        return _index.indexedAccessType;
      }
    });
    Object.defineProperty(exports2, "InferredPredicate", {
      enumerable: true,
      get: function() {
        return _index.inferredPredicate;
      }
    });
    Object.defineProperty(exports2, "InterfaceDeclaration", {
      enumerable: true,
      get: function() {
        return _index.interfaceDeclaration;
      }
    });
    Object.defineProperty(exports2, "InterfaceExtends", {
      enumerable: true,
      get: function() {
        return _index.interfaceExtends;
      }
    });
    Object.defineProperty(exports2, "InterfaceTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.interfaceTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "InterpreterDirective", {
      enumerable: true,
      get: function() {
        return _index.interpreterDirective;
      }
    });
    Object.defineProperty(exports2, "IntersectionTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.intersectionTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "JSXAttribute", {
      enumerable: true,
      get: function() {
        return _index.jsxAttribute;
      }
    });
    Object.defineProperty(exports2, "JSXClosingElement", {
      enumerable: true,
      get: function() {
        return _index.jsxClosingElement;
      }
    });
    Object.defineProperty(exports2, "JSXClosingFragment", {
      enumerable: true,
      get: function() {
        return _index.jsxClosingFragment;
      }
    });
    Object.defineProperty(exports2, "JSXElement", {
      enumerable: true,
      get: function() {
        return _index.jsxElement;
      }
    });
    Object.defineProperty(exports2, "JSXEmptyExpression", {
      enumerable: true,
      get: function() {
        return _index.jsxEmptyExpression;
      }
    });
    Object.defineProperty(exports2, "JSXExpressionContainer", {
      enumerable: true,
      get: function() {
        return _index.jsxExpressionContainer;
      }
    });
    Object.defineProperty(exports2, "JSXFragment", {
      enumerable: true,
      get: function() {
        return _index.jsxFragment;
      }
    });
    Object.defineProperty(exports2, "JSXIdentifier", {
      enumerable: true,
      get: function() {
        return _index.jsxIdentifier;
      }
    });
    Object.defineProperty(exports2, "JSXMemberExpression", {
      enumerable: true,
      get: function() {
        return _index.jsxMemberExpression;
      }
    });
    Object.defineProperty(exports2, "JSXNamespacedName", {
      enumerable: true,
      get: function() {
        return _index.jsxNamespacedName;
      }
    });
    Object.defineProperty(exports2, "JSXOpeningElement", {
      enumerable: true,
      get: function() {
        return _index.jsxOpeningElement;
      }
    });
    Object.defineProperty(exports2, "JSXOpeningFragment", {
      enumerable: true,
      get: function() {
        return _index.jsxOpeningFragment;
      }
    });
    Object.defineProperty(exports2, "JSXSpreadAttribute", {
      enumerable: true,
      get: function() {
        return _index.jsxSpreadAttribute;
      }
    });
    Object.defineProperty(exports2, "JSXSpreadChild", {
      enumerable: true,
      get: function() {
        return _index.jsxSpreadChild;
      }
    });
    Object.defineProperty(exports2, "JSXText", {
      enumerable: true,
      get: function() {
        return _index.jsxText;
      }
    });
    Object.defineProperty(exports2, "LabeledStatement", {
      enumerable: true,
      get: function() {
        return _index.labeledStatement;
      }
    });
    Object.defineProperty(exports2, "LogicalExpression", {
      enumerable: true,
      get: function() {
        return _index.logicalExpression;
      }
    });
    Object.defineProperty(exports2, "MemberExpression", {
      enumerable: true,
      get: function() {
        return _index.memberExpression;
      }
    });
    Object.defineProperty(exports2, "MetaProperty", {
      enumerable: true,
      get: function() {
        return _index.metaProperty;
      }
    });
    Object.defineProperty(exports2, "MixedTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.mixedTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "ModuleExpression", {
      enumerable: true,
      get: function() {
        return _index.moduleExpression;
      }
    });
    Object.defineProperty(exports2, "NewExpression", {
      enumerable: true,
      get: function() {
        return _index.newExpression;
      }
    });
    Object.defineProperty(exports2, "Noop", {
      enumerable: true,
      get: function() {
        return _index.noop;
      }
    });
    Object.defineProperty(exports2, "NullLiteral", {
      enumerable: true,
      get: function() {
        return _index.nullLiteral;
      }
    });
    Object.defineProperty(exports2, "NullLiteralTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.nullLiteralTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "NullableTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.nullableTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "NumberLiteral", {
      enumerable: true,
      get: function() {
        return _index.numberLiteral;
      }
    });
    Object.defineProperty(exports2, "NumberLiteralTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.numberLiteralTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "NumberTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.numberTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "NumericLiteral", {
      enumerable: true,
      get: function() {
        return _index.numericLiteral;
      }
    });
    Object.defineProperty(exports2, "ObjectExpression", {
      enumerable: true,
      get: function() {
        return _index.objectExpression;
      }
    });
    Object.defineProperty(exports2, "ObjectMethod", {
      enumerable: true,
      get: function() {
        return _index.objectMethod;
      }
    });
    Object.defineProperty(exports2, "ObjectPattern", {
      enumerable: true,
      get: function() {
        return _index.objectPattern;
      }
    });
    Object.defineProperty(exports2, "ObjectProperty", {
      enumerable: true,
      get: function() {
        return _index.objectProperty;
      }
    });
    Object.defineProperty(exports2, "ObjectTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.objectTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "ObjectTypeCallProperty", {
      enumerable: true,
      get: function() {
        return _index.objectTypeCallProperty;
      }
    });
    Object.defineProperty(exports2, "ObjectTypeIndexer", {
      enumerable: true,
      get: function() {
        return _index.objectTypeIndexer;
      }
    });
    Object.defineProperty(exports2, "ObjectTypeInternalSlot", {
      enumerable: true,
      get: function() {
        return _index.objectTypeInternalSlot;
      }
    });
    Object.defineProperty(exports2, "ObjectTypeProperty", {
      enumerable: true,
      get: function() {
        return _index.objectTypeProperty;
      }
    });
    Object.defineProperty(exports2, "ObjectTypeSpreadProperty", {
      enumerable: true,
      get: function() {
        return _index.objectTypeSpreadProperty;
      }
    });
    Object.defineProperty(exports2, "OpaqueType", {
      enumerable: true,
      get: function() {
        return _index.opaqueType;
      }
    });
    Object.defineProperty(exports2, "OptionalCallExpression", {
      enumerable: true,
      get: function() {
        return _index.optionalCallExpression;
      }
    });
    Object.defineProperty(exports2, "OptionalIndexedAccessType", {
      enumerable: true,
      get: function() {
        return _index.optionalIndexedAccessType;
      }
    });
    Object.defineProperty(exports2, "OptionalMemberExpression", {
      enumerable: true,
      get: function() {
        return _index.optionalMemberExpression;
      }
    });
    Object.defineProperty(exports2, "ParenthesizedExpression", {
      enumerable: true,
      get: function() {
        return _index.parenthesizedExpression;
      }
    });
    Object.defineProperty(exports2, "PipelineBareFunction", {
      enumerable: true,
      get: function() {
        return _index.pipelineBareFunction;
      }
    });
    Object.defineProperty(exports2, "PipelinePrimaryTopicReference", {
      enumerable: true,
      get: function() {
        return _index.pipelinePrimaryTopicReference;
      }
    });
    Object.defineProperty(exports2, "PipelineTopicExpression", {
      enumerable: true,
      get: function() {
        return _index.pipelineTopicExpression;
      }
    });
    Object.defineProperty(exports2, "Placeholder", {
      enumerable: true,
      get: function() {
        return _index.placeholder;
      }
    });
    Object.defineProperty(exports2, "PrivateName", {
      enumerable: true,
      get: function() {
        return _index.privateName;
      }
    });
    Object.defineProperty(exports2, "Program", {
      enumerable: true,
      get: function() {
        return _index.program;
      }
    });
    Object.defineProperty(exports2, "QualifiedTypeIdentifier", {
      enumerable: true,
      get: function() {
        return _index.qualifiedTypeIdentifier;
      }
    });
    Object.defineProperty(exports2, "RecordExpression", {
      enumerable: true,
      get: function() {
        return _index.recordExpression;
      }
    });
    Object.defineProperty(exports2, "RegExpLiteral", {
      enumerable: true,
      get: function() {
        return _index.regExpLiteral;
      }
    });
    Object.defineProperty(exports2, "RegexLiteral", {
      enumerable: true,
      get: function() {
        return _index.regexLiteral;
      }
    });
    Object.defineProperty(exports2, "RestElement", {
      enumerable: true,
      get: function() {
        return _index.restElement;
      }
    });
    Object.defineProperty(exports2, "RestProperty", {
      enumerable: true,
      get: function() {
        return _index.restProperty;
      }
    });
    Object.defineProperty(exports2, "ReturnStatement", {
      enumerable: true,
      get: function() {
        return _index.returnStatement;
      }
    });
    Object.defineProperty(exports2, "SequenceExpression", {
      enumerable: true,
      get: function() {
        return _index.sequenceExpression;
      }
    });
    Object.defineProperty(exports2, "SpreadElement", {
      enumerable: true,
      get: function() {
        return _index.spreadElement;
      }
    });
    Object.defineProperty(exports2, "SpreadProperty", {
      enumerable: true,
      get: function() {
        return _index.spreadProperty;
      }
    });
    Object.defineProperty(exports2, "StaticBlock", {
      enumerable: true,
      get: function() {
        return _index.staticBlock;
      }
    });
    Object.defineProperty(exports2, "StringLiteral", {
      enumerable: true,
      get: function() {
        return _index.stringLiteral;
      }
    });
    Object.defineProperty(exports2, "StringLiteralTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.stringLiteralTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "StringTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.stringTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "Super", {
      enumerable: true,
      get: function() {
        return _index.super;
      }
    });
    Object.defineProperty(exports2, "SwitchCase", {
      enumerable: true,
      get: function() {
        return _index.switchCase;
      }
    });
    Object.defineProperty(exports2, "SwitchStatement", {
      enumerable: true,
      get: function() {
        return _index.switchStatement;
      }
    });
    Object.defineProperty(exports2, "SymbolTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.symbolTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "TSAnyKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsAnyKeyword;
      }
    });
    Object.defineProperty(exports2, "TSArrayType", {
      enumerable: true,
      get: function() {
        return _index.tsArrayType;
      }
    });
    Object.defineProperty(exports2, "TSAsExpression", {
      enumerable: true,
      get: function() {
        return _index.tsAsExpression;
      }
    });
    Object.defineProperty(exports2, "TSBigIntKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsBigIntKeyword;
      }
    });
    Object.defineProperty(exports2, "TSBooleanKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsBooleanKeyword;
      }
    });
    Object.defineProperty(exports2, "TSCallSignatureDeclaration", {
      enumerable: true,
      get: function() {
        return _index.tsCallSignatureDeclaration;
      }
    });
    Object.defineProperty(exports2, "TSConditionalType", {
      enumerable: true,
      get: function() {
        return _index.tsConditionalType;
      }
    });
    Object.defineProperty(exports2, "TSConstructSignatureDeclaration", {
      enumerable: true,
      get: function() {
        return _index.tsConstructSignatureDeclaration;
      }
    });
    Object.defineProperty(exports2, "TSConstructorType", {
      enumerable: true,
      get: function() {
        return _index.tsConstructorType;
      }
    });
    Object.defineProperty(exports2, "TSDeclareFunction", {
      enumerable: true,
      get: function() {
        return _index.tsDeclareFunction;
      }
    });
    Object.defineProperty(exports2, "TSDeclareMethod", {
      enumerable: true,
      get: function() {
        return _index.tsDeclareMethod;
      }
    });
    Object.defineProperty(exports2, "TSEnumDeclaration", {
      enumerable: true,
      get: function() {
        return _index.tsEnumDeclaration;
      }
    });
    Object.defineProperty(exports2, "TSEnumMember", {
      enumerable: true,
      get: function() {
        return _index.tsEnumMember;
      }
    });
    Object.defineProperty(exports2, "TSExportAssignment", {
      enumerable: true,
      get: function() {
        return _index.tsExportAssignment;
      }
    });
    Object.defineProperty(exports2, "TSExpressionWithTypeArguments", {
      enumerable: true,
      get: function() {
        return _index.tsExpressionWithTypeArguments;
      }
    });
    Object.defineProperty(exports2, "TSExternalModuleReference", {
      enumerable: true,
      get: function() {
        return _index.tsExternalModuleReference;
      }
    });
    Object.defineProperty(exports2, "TSFunctionType", {
      enumerable: true,
      get: function() {
        return _index.tsFunctionType;
      }
    });
    Object.defineProperty(exports2, "TSImportEqualsDeclaration", {
      enumerable: true,
      get: function() {
        return _index.tsImportEqualsDeclaration;
      }
    });
    Object.defineProperty(exports2, "TSImportType", {
      enumerable: true,
      get: function() {
        return _index.tsImportType;
      }
    });
    Object.defineProperty(exports2, "TSIndexSignature", {
      enumerable: true,
      get: function() {
        return _index.tsIndexSignature;
      }
    });
    Object.defineProperty(exports2, "TSIndexedAccessType", {
      enumerable: true,
      get: function() {
        return _index.tsIndexedAccessType;
      }
    });
    Object.defineProperty(exports2, "TSInferType", {
      enumerable: true,
      get: function() {
        return _index.tsInferType;
      }
    });
    Object.defineProperty(exports2, "TSInstantiationExpression", {
      enumerable: true,
      get: function() {
        return _index.tsInstantiationExpression;
      }
    });
    Object.defineProperty(exports2, "TSInterfaceBody", {
      enumerable: true,
      get: function() {
        return _index.tsInterfaceBody;
      }
    });
    Object.defineProperty(exports2, "TSInterfaceDeclaration", {
      enumerable: true,
      get: function() {
        return _index.tsInterfaceDeclaration;
      }
    });
    Object.defineProperty(exports2, "TSIntersectionType", {
      enumerable: true,
      get: function() {
        return _index.tsIntersectionType;
      }
    });
    Object.defineProperty(exports2, "TSIntrinsicKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsIntrinsicKeyword;
      }
    });
    Object.defineProperty(exports2, "TSLiteralType", {
      enumerable: true,
      get: function() {
        return _index.tsLiteralType;
      }
    });
    Object.defineProperty(exports2, "TSMappedType", {
      enumerable: true,
      get: function() {
        return _index.tsMappedType;
      }
    });
    Object.defineProperty(exports2, "TSMethodSignature", {
      enumerable: true,
      get: function() {
        return _index.tsMethodSignature;
      }
    });
    Object.defineProperty(exports2, "TSModuleBlock", {
      enumerable: true,
      get: function() {
        return _index.tsModuleBlock;
      }
    });
    Object.defineProperty(exports2, "TSModuleDeclaration", {
      enumerable: true,
      get: function() {
        return _index.tsModuleDeclaration;
      }
    });
    Object.defineProperty(exports2, "TSNamedTupleMember", {
      enumerable: true,
      get: function() {
        return _index.tsNamedTupleMember;
      }
    });
    Object.defineProperty(exports2, "TSNamespaceExportDeclaration", {
      enumerable: true,
      get: function() {
        return _index.tsNamespaceExportDeclaration;
      }
    });
    Object.defineProperty(exports2, "TSNeverKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsNeverKeyword;
      }
    });
    Object.defineProperty(exports2, "TSNonNullExpression", {
      enumerable: true,
      get: function() {
        return _index.tsNonNullExpression;
      }
    });
    Object.defineProperty(exports2, "TSNullKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsNullKeyword;
      }
    });
    Object.defineProperty(exports2, "TSNumberKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsNumberKeyword;
      }
    });
    Object.defineProperty(exports2, "TSObjectKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsObjectKeyword;
      }
    });
    Object.defineProperty(exports2, "TSOptionalType", {
      enumerable: true,
      get: function() {
        return _index.tsOptionalType;
      }
    });
    Object.defineProperty(exports2, "TSParameterProperty", {
      enumerable: true,
      get: function() {
        return _index.tsParameterProperty;
      }
    });
    Object.defineProperty(exports2, "TSParenthesizedType", {
      enumerable: true,
      get: function() {
        return _index.tsParenthesizedType;
      }
    });
    Object.defineProperty(exports2, "TSPropertySignature", {
      enumerable: true,
      get: function() {
        return _index.tsPropertySignature;
      }
    });
    Object.defineProperty(exports2, "TSQualifiedName", {
      enumerable: true,
      get: function() {
        return _index.tsQualifiedName;
      }
    });
    Object.defineProperty(exports2, "TSRestType", {
      enumerable: true,
      get: function() {
        return _index.tsRestType;
      }
    });
    Object.defineProperty(exports2, "TSSatisfiesExpression", {
      enumerable: true,
      get: function() {
        return _index.tsSatisfiesExpression;
      }
    });
    Object.defineProperty(exports2, "TSStringKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsStringKeyword;
      }
    });
    Object.defineProperty(exports2, "TSSymbolKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsSymbolKeyword;
      }
    });
    Object.defineProperty(exports2, "TSThisType", {
      enumerable: true,
      get: function() {
        return _index.tsThisType;
      }
    });
    Object.defineProperty(exports2, "TSTupleType", {
      enumerable: true,
      get: function() {
        return _index.tsTupleType;
      }
    });
    Object.defineProperty(exports2, "TSTypeAliasDeclaration", {
      enumerable: true,
      get: function() {
        return _index.tsTypeAliasDeclaration;
      }
    });
    Object.defineProperty(exports2, "TSTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.tsTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "TSTypeAssertion", {
      enumerable: true,
      get: function() {
        return _index.tsTypeAssertion;
      }
    });
    Object.defineProperty(exports2, "TSTypeLiteral", {
      enumerable: true,
      get: function() {
        return _index.tsTypeLiteral;
      }
    });
    Object.defineProperty(exports2, "TSTypeOperator", {
      enumerable: true,
      get: function() {
        return _index.tsTypeOperator;
      }
    });
    Object.defineProperty(exports2, "TSTypeParameter", {
      enumerable: true,
      get: function() {
        return _index.tsTypeParameter;
      }
    });
    Object.defineProperty(exports2, "TSTypeParameterDeclaration", {
      enumerable: true,
      get: function() {
        return _index.tsTypeParameterDeclaration;
      }
    });
    Object.defineProperty(exports2, "TSTypeParameterInstantiation", {
      enumerable: true,
      get: function() {
        return _index.tsTypeParameterInstantiation;
      }
    });
    Object.defineProperty(exports2, "TSTypePredicate", {
      enumerable: true,
      get: function() {
        return _index.tsTypePredicate;
      }
    });
    Object.defineProperty(exports2, "TSTypeQuery", {
      enumerable: true,
      get: function() {
        return _index.tsTypeQuery;
      }
    });
    Object.defineProperty(exports2, "TSTypeReference", {
      enumerable: true,
      get: function() {
        return _index.tsTypeReference;
      }
    });
    Object.defineProperty(exports2, "TSUndefinedKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsUndefinedKeyword;
      }
    });
    Object.defineProperty(exports2, "TSUnionType", {
      enumerable: true,
      get: function() {
        return _index.tsUnionType;
      }
    });
    Object.defineProperty(exports2, "TSUnknownKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsUnknownKeyword;
      }
    });
    Object.defineProperty(exports2, "TSVoidKeyword", {
      enumerable: true,
      get: function() {
        return _index.tsVoidKeyword;
      }
    });
    Object.defineProperty(exports2, "TaggedTemplateExpression", {
      enumerable: true,
      get: function() {
        return _index.taggedTemplateExpression;
      }
    });
    Object.defineProperty(exports2, "TemplateElement", {
      enumerable: true,
      get: function() {
        return _index.templateElement;
      }
    });
    Object.defineProperty(exports2, "TemplateLiteral", {
      enumerable: true,
      get: function() {
        return _index.templateLiteral;
      }
    });
    Object.defineProperty(exports2, "ThisExpression", {
      enumerable: true,
      get: function() {
        return _index.thisExpression;
      }
    });
    Object.defineProperty(exports2, "ThisTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.thisTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "ThrowStatement", {
      enumerable: true,
      get: function() {
        return _index.throwStatement;
      }
    });
    Object.defineProperty(exports2, "TopicReference", {
      enumerable: true,
      get: function() {
        return _index.topicReference;
      }
    });
    Object.defineProperty(exports2, "TryStatement", {
      enumerable: true,
      get: function() {
        return _index.tryStatement;
      }
    });
    Object.defineProperty(exports2, "TupleExpression", {
      enumerable: true,
      get: function() {
        return _index.tupleExpression;
      }
    });
    Object.defineProperty(exports2, "TupleTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.tupleTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "TypeAlias", {
      enumerable: true,
      get: function() {
        return _index.typeAlias;
      }
    });
    Object.defineProperty(exports2, "TypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.typeAnnotation;
      }
    });
    Object.defineProperty(exports2, "TypeCastExpression", {
      enumerable: true,
      get: function() {
        return _index.typeCastExpression;
      }
    });
    Object.defineProperty(exports2, "TypeParameter", {
      enumerable: true,
      get: function() {
        return _index.typeParameter;
      }
    });
    Object.defineProperty(exports2, "TypeParameterDeclaration", {
      enumerable: true,
      get: function() {
        return _index.typeParameterDeclaration;
      }
    });
    Object.defineProperty(exports2, "TypeParameterInstantiation", {
      enumerable: true,
      get: function() {
        return _index.typeParameterInstantiation;
      }
    });
    Object.defineProperty(exports2, "TypeofTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.typeofTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "UnaryExpression", {
      enumerable: true,
      get: function() {
        return _index.unaryExpression;
      }
    });
    Object.defineProperty(exports2, "UnionTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.unionTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "UpdateExpression", {
      enumerable: true,
      get: function() {
        return _index.updateExpression;
      }
    });
    Object.defineProperty(exports2, "V8IntrinsicIdentifier", {
      enumerable: true,
      get: function() {
        return _index.v8IntrinsicIdentifier;
      }
    });
    Object.defineProperty(exports2, "VariableDeclaration", {
      enumerable: true,
      get: function() {
        return _index.variableDeclaration;
      }
    });
    Object.defineProperty(exports2, "VariableDeclarator", {
      enumerable: true,
      get: function() {
        return _index.variableDeclarator;
      }
    });
    Object.defineProperty(exports2, "Variance", {
      enumerable: true,
      get: function() {
        return _index.variance;
      }
    });
    Object.defineProperty(exports2, "VoidTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _index.voidTypeAnnotation;
      }
    });
    Object.defineProperty(exports2, "WhileStatement", {
      enumerable: true,
      get: function() {
        return _index.whileStatement;
      }
    });
    Object.defineProperty(exports2, "WithStatement", {
      enumerable: true,
      get: function() {
        return _index.withStatement;
      }
    });
    Object.defineProperty(exports2, "YieldExpression", {
      enumerable: true,
      get: function() {
        return _index.yieldExpression;
      }
    });
    var _index = require_generated2();
  }
});

// ../../node_modules/@babel/types/lib/builders/productions.js
var require_productions = __commonJS({
  "../../node_modules/@babel/types/lib/builders/productions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.buildUndefinedNode = buildUndefinedNode;
    var _index = require_generated2();
    function buildUndefinedNode() {
      return (0, _index.unaryExpression)("void", (0, _index.numericLiteral)(0), true);
    }
  }
});

// ../../node_modules/@babel/types/lib/clone/cloneNode.js
var require_cloneNode = __commonJS({
  "../../node_modules/@babel/types/lib/clone/cloneNode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = cloneNode2;
    var _index = require_definitions();
    var _index2 = require_generated();
    var {
      hasOwn
    } = {
      hasOwn: Function.call.bind(Object.prototype.hasOwnProperty)
    };
    function cloneIfNode(obj, deep, withoutLoc, commentsCache) {
      if (obj && typeof obj.type === "string") {
        return cloneNodeInternal(obj, deep, withoutLoc, commentsCache);
      }
      return obj;
    }
    function cloneIfNodeOrArray(obj, deep, withoutLoc, commentsCache) {
      if (Array.isArray(obj)) {
        return obj.map((node) => cloneIfNode(node, deep, withoutLoc, commentsCache));
      }
      return cloneIfNode(obj, deep, withoutLoc, commentsCache);
    }
    function cloneNode2(node, deep = true, withoutLoc = false) {
      return cloneNodeInternal(node, deep, withoutLoc, /* @__PURE__ */ new Map());
    }
    function cloneNodeInternal(node, deep = true, withoutLoc = false, commentsCache) {
      if (!node) return node;
      const {
        type
      } = node;
      const newNode = {
        type: node.type
      };
      if ((0, _index2.isIdentifier)(node)) {
        newNode.name = node.name;
        if (hasOwn(node, "optional") && typeof node.optional === "boolean") {
          newNode.optional = node.optional;
        }
        if (hasOwn(node, "typeAnnotation")) {
          newNode.typeAnnotation = deep ? cloneIfNodeOrArray(node.typeAnnotation, true, withoutLoc, commentsCache) : node.typeAnnotation;
        }
        if (hasOwn(node, "decorators")) {
          newNode.decorators = deep ? cloneIfNodeOrArray(node.decorators, true, withoutLoc, commentsCache) : node.decorators;
        }
      } else if (!hasOwn(_index.NODE_FIELDS, type)) {
        throw new Error(`Unknown node type: "${type}"`);
      } else {
        for (const field of Object.keys(_index.NODE_FIELDS[type])) {
          if (hasOwn(node, field)) {
            if (deep) {
              newNode[field] = (0, _index2.isFile)(node) && field === "comments" ? maybeCloneComments(node.comments, deep, withoutLoc, commentsCache) : cloneIfNodeOrArray(node[field], true, withoutLoc, commentsCache);
            } else {
              newNode[field] = node[field];
            }
          }
        }
      }
      if (hasOwn(node, "loc")) {
        if (withoutLoc) {
          newNode.loc = null;
        } else {
          newNode.loc = node.loc;
        }
      }
      if (hasOwn(node, "leadingComments")) {
        newNode.leadingComments = maybeCloneComments(node.leadingComments, deep, withoutLoc, commentsCache);
      }
      if (hasOwn(node, "innerComments")) {
        newNode.innerComments = maybeCloneComments(node.innerComments, deep, withoutLoc, commentsCache);
      }
      if (hasOwn(node, "trailingComments")) {
        newNode.trailingComments = maybeCloneComments(node.trailingComments, deep, withoutLoc, commentsCache);
      }
      if (hasOwn(node, "extra")) {
        newNode.extra = Object.assign({}, node.extra);
      }
      return newNode;
    }
    function maybeCloneComments(comments, deep, withoutLoc, commentsCache) {
      if (!comments || !deep) {
        return comments;
      }
      return comments.map((comment) => {
        const cache = commentsCache.get(comment);
        if (cache) return cache;
        const {
          type,
          value,
          loc
        } = comment;
        const ret = {
          type,
          value,
          loc
        };
        if (withoutLoc) {
          ret.loc = null;
        }
        commentsCache.set(comment, ret);
        return ret;
      });
    }
  }
});

// ../../node_modules/@babel/types/lib/clone/clone.js
var require_clone = __commonJS({
  "../../node_modules/@babel/types/lib/clone/clone.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = clone;
    var _cloneNode = require_cloneNode();
    function clone(node) {
      return (0, _cloneNode.default)(node, false);
    }
  }
});

// ../../node_modules/@babel/types/lib/clone/cloneDeep.js
var require_cloneDeep = __commonJS({
  "../../node_modules/@babel/types/lib/clone/cloneDeep.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = cloneDeep;
    var _cloneNode = require_cloneNode();
    function cloneDeep(node) {
      return (0, _cloneNode.default)(node);
    }
  }
});

// ../../node_modules/@babel/types/lib/clone/cloneDeepWithoutLoc.js
var require_cloneDeepWithoutLoc = __commonJS({
  "../../node_modules/@babel/types/lib/clone/cloneDeepWithoutLoc.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = cloneDeepWithoutLoc;
    var _cloneNode = require_cloneNode();
    function cloneDeepWithoutLoc(node) {
      return (0, _cloneNode.default)(node, true, true);
    }
  }
});

// ../../node_modules/@babel/types/lib/clone/cloneWithoutLoc.js
var require_cloneWithoutLoc = __commonJS({
  "../../node_modules/@babel/types/lib/clone/cloneWithoutLoc.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = cloneWithoutLoc;
    var _cloneNode = require_cloneNode();
    function cloneWithoutLoc(node) {
      return (0, _cloneNode.default)(node, false, true);
    }
  }
});

// ../../node_modules/@babel/types/lib/comments/addComments.js
var require_addComments = __commonJS({
  "../../node_modules/@babel/types/lib/comments/addComments.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = addComments;
    function addComments(node, type, comments) {
      if (!comments || !node) return node;
      const key = `${type}Comments`;
      if (node[key]) {
        if (type === "leading") {
          node[key] = comments.concat(node[key]);
        } else {
          node[key].push(...comments);
        }
      } else {
        node[key] = comments;
      }
      return node;
    }
  }
});

// ../../node_modules/@babel/types/lib/comments/addComment.js
var require_addComment = __commonJS({
  "../../node_modules/@babel/types/lib/comments/addComment.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = addComment2;
    var _addComments = require_addComments();
    function addComment2(node, type, content, line) {
      return (0, _addComments.default)(node, type, [{
        type: line ? "CommentLine" : "CommentBlock",
        value: content
      }]);
    }
  }
});

// ../../node_modules/@babel/types/lib/utils/inherit.js
var require_inherit = __commonJS({
  "../../node_modules/@babel/types/lib/utils/inherit.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = inherit;
    function inherit(key, child, parent) {
      if (child && parent) {
        child[key] = Array.from(new Set([].concat(child[key], parent[key]).filter(Boolean)));
      }
    }
  }
});

// ../../node_modules/@babel/types/lib/comments/inheritInnerComments.js
var require_inheritInnerComments = __commonJS({
  "../../node_modules/@babel/types/lib/comments/inheritInnerComments.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = inheritInnerComments;
    var _inherit = require_inherit();
    function inheritInnerComments(child, parent) {
      (0, _inherit.default)("innerComments", child, parent);
    }
  }
});

// ../../node_modules/@babel/types/lib/comments/inheritLeadingComments.js
var require_inheritLeadingComments = __commonJS({
  "../../node_modules/@babel/types/lib/comments/inheritLeadingComments.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = inheritLeadingComments;
    var _inherit = require_inherit();
    function inheritLeadingComments(child, parent) {
      (0, _inherit.default)("leadingComments", child, parent);
    }
  }
});

// ../../node_modules/@babel/types/lib/comments/inheritTrailingComments.js
var require_inheritTrailingComments = __commonJS({
  "../../node_modules/@babel/types/lib/comments/inheritTrailingComments.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = inheritTrailingComments;
    var _inherit = require_inherit();
    function inheritTrailingComments(child, parent) {
      (0, _inherit.default)("trailingComments", child, parent);
    }
  }
});

// ../../node_modules/@babel/types/lib/comments/inheritsComments.js
var require_inheritsComments = __commonJS({
  "../../node_modules/@babel/types/lib/comments/inheritsComments.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = inheritsComments;
    var _inheritTrailingComments = require_inheritTrailingComments();
    var _inheritLeadingComments = require_inheritLeadingComments();
    var _inheritInnerComments = require_inheritInnerComments();
    function inheritsComments(child, parent) {
      (0, _inheritTrailingComments.default)(child, parent);
      (0, _inheritLeadingComments.default)(child, parent);
      (0, _inheritInnerComments.default)(child, parent);
      return child;
    }
  }
});

// ../../node_modules/@babel/types/lib/comments/removeComments.js
var require_removeComments = __commonJS({
  "../../node_modules/@babel/types/lib/comments/removeComments.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = removeComments;
    var _index = require_constants();
    function removeComments(node) {
      _index.COMMENT_KEYS.forEach((key) => {
        node[key] = null;
      });
      return node;
    }
  }
});

// ../../node_modules/@babel/types/lib/constants/generated/index.js
var require_generated4 = __commonJS({
  "../../node_modules/@babel/types/lib/constants/generated/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.WHILE_TYPES = exports2.USERWHITESPACABLE_TYPES = exports2.UNARYLIKE_TYPES = exports2.TYPESCRIPT_TYPES = exports2.TSTYPE_TYPES = exports2.TSTYPEELEMENT_TYPES = exports2.TSENTITYNAME_TYPES = exports2.TSBASETYPE_TYPES = exports2.TERMINATORLESS_TYPES = exports2.STATEMENT_TYPES = exports2.STANDARDIZED_TYPES = exports2.SCOPABLE_TYPES = exports2.PUREISH_TYPES = exports2.PROPERTY_TYPES = exports2.PRIVATE_TYPES = exports2.PATTERN_TYPES = exports2.PATTERNLIKE_TYPES = exports2.OBJECTMEMBER_TYPES = exports2.MODULESPECIFIER_TYPES = exports2.MODULEDECLARATION_TYPES = exports2.MISCELLANEOUS_TYPES = exports2.METHOD_TYPES = exports2.LVAL_TYPES = exports2.LOOP_TYPES = exports2.LITERAL_TYPES = exports2.JSX_TYPES = exports2.IMPORTOREXPORTDECLARATION_TYPES = exports2.IMMUTABLE_TYPES = exports2.FUNCTION_TYPES = exports2.FUNCTIONPARENT_TYPES = exports2.FOR_TYPES = exports2.FORXSTATEMENT_TYPES = exports2.FLOW_TYPES = exports2.FLOWTYPE_TYPES = exports2.FLOWPREDICATE_TYPES = exports2.FLOWDECLARATION_TYPES = exports2.FLOWBASEANNOTATION_TYPES = exports2.EXPRESSION_TYPES = exports2.EXPRESSIONWRAPPER_TYPES = exports2.EXPORTDECLARATION_TYPES = exports2.ENUMMEMBER_TYPES = exports2.ENUMBODY_TYPES = exports2.DECLARATION_TYPES = exports2.CONDITIONAL_TYPES = exports2.COMPLETIONSTATEMENT_TYPES = exports2.CLASS_TYPES = exports2.BLOCK_TYPES = exports2.BLOCKPARENT_TYPES = exports2.BINARY_TYPES = exports2.ACCESSOR_TYPES = void 0;
    var _index = require_definitions();
    var STANDARDIZED_TYPES = exports2.STANDARDIZED_TYPES = _index.FLIPPED_ALIAS_KEYS["Standardized"];
    var EXPRESSION_TYPES = exports2.EXPRESSION_TYPES = _index.FLIPPED_ALIAS_KEYS["Expression"];
    var BINARY_TYPES = exports2.BINARY_TYPES = _index.FLIPPED_ALIAS_KEYS["Binary"];
    var SCOPABLE_TYPES = exports2.SCOPABLE_TYPES = _index.FLIPPED_ALIAS_KEYS["Scopable"];
    var BLOCKPARENT_TYPES = exports2.BLOCKPARENT_TYPES = _index.FLIPPED_ALIAS_KEYS["BlockParent"];
    var BLOCK_TYPES = exports2.BLOCK_TYPES = _index.FLIPPED_ALIAS_KEYS["Block"];
    var STATEMENT_TYPES = exports2.STATEMENT_TYPES = _index.FLIPPED_ALIAS_KEYS["Statement"];
    var TERMINATORLESS_TYPES = exports2.TERMINATORLESS_TYPES = _index.FLIPPED_ALIAS_KEYS["Terminatorless"];
    var COMPLETIONSTATEMENT_TYPES = exports2.COMPLETIONSTATEMENT_TYPES = _index.FLIPPED_ALIAS_KEYS["CompletionStatement"];
    var CONDITIONAL_TYPES = exports2.CONDITIONAL_TYPES = _index.FLIPPED_ALIAS_KEYS["Conditional"];
    var LOOP_TYPES = exports2.LOOP_TYPES = _index.FLIPPED_ALIAS_KEYS["Loop"];
    var WHILE_TYPES = exports2.WHILE_TYPES = _index.FLIPPED_ALIAS_KEYS["While"];
    var EXPRESSIONWRAPPER_TYPES = exports2.EXPRESSIONWRAPPER_TYPES = _index.FLIPPED_ALIAS_KEYS["ExpressionWrapper"];
    var FOR_TYPES = exports2.FOR_TYPES = _index.FLIPPED_ALIAS_KEYS["For"];
    var FORXSTATEMENT_TYPES = exports2.FORXSTATEMENT_TYPES = _index.FLIPPED_ALIAS_KEYS["ForXStatement"];
    var FUNCTION_TYPES = exports2.FUNCTION_TYPES = _index.FLIPPED_ALIAS_KEYS["Function"];
    var FUNCTIONPARENT_TYPES = exports2.FUNCTIONPARENT_TYPES = _index.FLIPPED_ALIAS_KEYS["FunctionParent"];
    var PUREISH_TYPES = exports2.PUREISH_TYPES = _index.FLIPPED_ALIAS_KEYS["Pureish"];
    var DECLARATION_TYPES = exports2.DECLARATION_TYPES = _index.FLIPPED_ALIAS_KEYS["Declaration"];
    var PATTERNLIKE_TYPES = exports2.PATTERNLIKE_TYPES = _index.FLIPPED_ALIAS_KEYS["PatternLike"];
    var LVAL_TYPES = exports2.LVAL_TYPES = _index.FLIPPED_ALIAS_KEYS["LVal"];
    var TSENTITYNAME_TYPES = exports2.TSENTITYNAME_TYPES = _index.FLIPPED_ALIAS_KEYS["TSEntityName"];
    var LITERAL_TYPES = exports2.LITERAL_TYPES = _index.FLIPPED_ALIAS_KEYS["Literal"];
    var IMMUTABLE_TYPES = exports2.IMMUTABLE_TYPES = _index.FLIPPED_ALIAS_KEYS["Immutable"];
    var USERWHITESPACABLE_TYPES = exports2.USERWHITESPACABLE_TYPES = _index.FLIPPED_ALIAS_KEYS["UserWhitespacable"];
    var METHOD_TYPES = exports2.METHOD_TYPES = _index.FLIPPED_ALIAS_KEYS["Method"];
    var OBJECTMEMBER_TYPES = exports2.OBJECTMEMBER_TYPES = _index.FLIPPED_ALIAS_KEYS["ObjectMember"];
    var PROPERTY_TYPES = exports2.PROPERTY_TYPES = _index.FLIPPED_ALIAS_KEYS["Property"];
    var UNARYLIKE_TYPES = exports2.UNARYLIKE_TYPES = _index.FLIPPED_ALIAS_KEYS["UnaryLike"];
    var PATTERN_TYPES = exports2.PATTERN_TYPES = _index.FLIPPED_ALIAS_KEYS["Pattern"];
    var CLASS_TYPES = exports2.CLASS_TYPES = _index.FLIPPED_ALIAS_KEYS["Class"];
    var IMPORTOREXPORTDECLARATION_TYPES = exports2.IMPORTOREXPORTDECLARATION_TYPES = _index.FLIPPED_ALIAS_KEYS["ImportOrExportDeclaration"];
    var EXPORTDECLARATION_TYPES = exports2.EXPORTDECLARATION_TYPES = _index.FLIPPED_ALIAS_KEYS["ExportDeclaration"];
    var MODULESPECIFIER_TYPES = exports2.MODULESPECIFIER_TYPES = _index.FLIPPED_ALIAS_KEYS["ModuleSpecifier"];
    var ACCESSOR_TYPES = exports2.ACCESSOR_TYPES = _index.FLIPPED_ALIAS_KEYS["Accessor"];
    var PRIVATE_TYPES = exports2.PRIVATE_TYPES = _index.FLIPPED_ALIAS_KEYS["Private"];
    var FLOW_TYPES = exports2.FLOW_TYPES = _index.FLIPPED_ALIAS_KEYS["Flow"];
    var FLOWTYPE_TYPES = exports2.FLOWTYPE_TYPES = _index.FLIPPED_ALIAS_KEYS["FlowType"];
    var FLOWBASEANNOTATION_TYPES = exports2.FLOWBASEANNOTATION_TYPES = _index.FLIPPED_ALIAS_KEYS["FlowBaseAnnotation"];
    var FLOWDECLARATION_TYPES = exports2.FLOWDECLARATION_TYPES = _index.FLIPPED_ALIAS_KEYS["FlowDeclaration"];
    var FLOWPREDICATE_TYPES = exports2.FLOWPREDICATE_TYPES = _index.FLIPPED_ALIAS_KEYS["FlowPredicate"];
    var ENUMBODY_TYPES = exports2.ENUMBODY_TYPES = _index.FLIPPED_ALIAS_KEYS["EnumBody"];
    var ENUMMEMBER_TYPES = exports2.ENUMMEMBER_TYPES = _index.FLIPPED_ALIAS_KEYS["EnumMember"];
    var JSX_TYPES = exports2.JSX_TYPES = _index.FLIPPED_ALIAS_KEYS["JSX"];
    var MISCELLANEOUS_TYPES = exports2.MISCELLANEOUS_TYPES = _index.FLIPPED_ALIAS_KEYS["Miscellaneous"];
    var TYPESCRIPT_TYPES = exports2.TYPESCRIPT_TYPES = _index.FLIPPED_ALIAS_KEYS["TypeScript"];
    var TSTYPEELEMENT_TYPES = exports2.TSTYPEELEMENT_TYPES = _index.FLIPPED_ALIAS_KEYS["TSTypeElement"];
    var TSTYPE_TYPES = exports2.TSTYPE_TYPES = _index.FLIPPED_ALIAS_KEYS["TSType"];
    var TSBASETYPE_TYPES = exports2.TSBASETYPE_TYPES = _index.FLIPPED_ALIAS_KEYS["TSBaseType"];
    var MODULEDECLARATION_TYPES = exports2.MODULEDECLARATION_TYPES = IMPORTOREXPORTDECLARATION_TYPES;
  }
});

// ../../node_modules/@babel/types/lib/converters/toBlock.js
var require_toBlock = __commonJS({
  "../../node_modules/@babel/types/lib/converters/toBlock.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = toBlock;
    var _index = require_generated();
    var _index2 = require_generated2();
    function toBlock(node, parent) {
      if ((0, _index.isBlockStatement)(node)) {
        return node;
      }
      let blockNodes = [];
      if ((0, _index.isEmptyStatement)(node)) {
        blockNodes = [];
      } else {
        if (!(0, _index.isStatement)(node)) {
          if ((0, _index.isFunction)(parent)) {
            node = (0, _index2.returnStatement)(node);
          } else {
            node = (0, _index2.expressionStatement)(node);
          }
        }
        blockNodes = [node];
      }
      return (0, _index2.blockStatement)(blockNodes);
    }
  }
});

// ../../node_modules/@babel/types/lib/converters/ensureBlock.js
var require_ensureBlock = __commonJS({
  "../../node_modules/@babel/types/lib/converters/ensureBlock.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = ensureBlock;
    var _toBlock = require_toBlock();
    function ensureBlock(node, key = "body") {
      const result = (0, _toBlock.default)(node[key], node);
      node[key] = result;
      return result;
    }
  }
});

// ../../node_modules/@babel/types/lib/converters/toIdentifier.js
var require_toIdentifier = __commonJS({
  "../../node_modules/@babel/types/lib/converters/toIdentifier.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = toIdentifier;
    var _isValidIdentifier = require_isValidIdentifier();
    var _helperValidatorIdentifier = require_lib();
    function toIdentifier(input) {
      input = input + "";
      let name = "";
      for (const c of input) {
        name += (0, _helperValidatorIdentifier.isIdentifierChar)(c.codePointAt(0)) ? c : "-";
      }
      name = name.replace(/^[-0-9]+/, "");
      name = name.replace(/[-\s]+(.)?/g, function(match, c) {
        return c ? c.toUpperCase() : "";
      });
      if (!(0, _isValidIdentifier.default)(name)) {
        name = `_${name}`;
      }
      return name || "_";
    }
  }
});

// ../../node_modules/@babel/types/lib/converters/toBindingIdentifierName.js
var require_toBindingIdentifierName = __commonJS({
  "../../node_modules/@babel/types/lib/converters/toBindingIdentifierName.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = toBindingIdentifierName;
    var _toIdentifier = require_toIdentifier();
    function toBindingIdentifierName(name) {
      name = (0, _toIdentifier.default)(name);
      if (name === "eval" || name === "arguments") name = "_" + name;
      return name;
    }
  }
});

// ../../node_modules/@babel/types/lib/converters/toComputedKey.js
var require_toComputedKey = __commonJS({
  "../../node_modules/@babel/types/lib/converters/toComputedKey.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = toComputedKey;
    var _index = require_generated();
    var _index2 = require_generated2();
    function toComputedKey(node, key = node.key || node.property) {
      if (!node.computed && (0, _index.isIdentifier)(key)) key = (0, _index2.stringLiteral)(key.name);
      return key;
    }
  }
});

// ../../node_modules/@babel/types/lib/converters/toExpression.js
var require_toExpression = __commonJS({
  "../../node_modules/@babel/types/lib/converters/toExpression.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _index = require_generated();
    var _default = exports2.default = toExpression;
    function toExpression(node) {
      if ((0, _index.isExpressionStatement)(node)) {
        node = node.expression;
      }
      if ((0, _index.isExpression)(node)) {
        return node;
      }
      if ((0, _index.isClass)(node)) {
        node.type = "ClassExpression";
      } else if ((0, _index.isFunction)(node)) {
        node.type = "FunctionExpression";
      }
      if (!(0, _index.isExpression)(node)) {
        throw new Error(`cannot turn ${node.type} to an expression`);
      }
      return node;
    }
  }
});

// ../../node_modules/@babel/types/lib/traverse/traverseFast.js
var require_traverseFast = __commonJS({
  "../../node_modules/@babel/types/lib/traverse/traverseFast.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = traverseFast;
    var _index = require_definitions();
    function traverseFast(node, enter, opts) {
      if (!node) return;
      const keys = _index.VISITOR_KEYS[node.type];
      if (!keys) return;
      opts = opts || {};
      enter(node, opts);
      for (const key of keys) {
        const subNode = node[key];
        if (Array.isArray(subNode)) {
          for (const node2 of subNode) {
            traverseFast(node2, enter, opts);
          }
        } else {
          traverseFast(subNode, enter, opts);
        }
      }
    }
  }
});

// ../../node_modules/@babel/types/lib/modifications/removeProperties.js
var require_removeProperties = __commonJS({
  "../../node_modules/@babel/types/lib/modifications/removeProperties.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = removeProperties;
    var _index = require_constants();
    var CLEAR_KEYS = ["tokens", "start", "end", "loc", "raw", "rawValue"];
    var CLEAR_KEYS_PLUS_COMMENTS = [..._index.COMMENT_KEYS, "comments", ...CLEAR_KEYS];
    function removeProperties(node, opts = {}) {
      const map = opts.preserveComments ? CLEAR_KEYS : CLEAR_KEYS_PLUS_COMMENTS;
      for (const key of map) {
        if (node[key] != null) node[key] = void 0;
      }
      for (const key of Object.keys(node)) {
        if (key[0] === "_" && node[key] != null) node[key] = void 0;
      }
      const symbols = Object.getOwnPropertySymbols(node);
      for (const sym of symbols) {
        node[sym] = null;
      }
    }
  }
});

// ../../node_modules/@babel/types/lib/modifications/removePropertiesDeep.js
var require_removePropertiesDeep = __commonJS({
  "../../node_modules/@babel/types/lib/modifications/removePropertiesDeep.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = removePropertiesDeep;
    var _traverseFast = require_traverseFast();
    var _removeProperties = require_removeProperties();
    function removePropertiesDeep(tree, opts) {
      (0, _traverseFast.default)(tree, _removeProperties.default, opts);
      return tree;
    }
  }
});

// ../../node_modules/@babel/types/lib/converters/toKeyAlias.js
var require_toKeyAlias = __commonJS({
  "../../node_modules/@babel/types/lib/converters/toKeyAlias.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = toKeyAlias;
    var _index = require_generated();
    var _cloneNode = require_cloneNode();
    var _removePropertiesDeep = require_removePropertiesDeep();
    function toKeyAlias(node, key = node.key) {
      let alias;
      if (node.kind === "method") {
        return toKeyAlias.increment() + "";
      } else if ((0, _index.isIdentifier)(key)) {
        alias = key.name;
      } else if ((0, _index.isStringLiteral)(key)) {
        alias = JSON.stringify(key.value);
      } else {
        alias = JSON.stringify((0, _removePropertiesDeep.default)((0, _cloneNode.default)(key)));
      }
      if (node.computed) {
        alias = `[${alias}]`;
      }
      if (node.static) {
        alias = `static:${alias}`;
      }
      return alias;
    }
    toKeyAlias.uid = 0;
    toKeyAlias.increment = function() {
      if (toKeyAlias.uid >= Number.MAX_SAFE_INTEGER) {
        return toKeyAlias.uid = 0;
      } else {
        return toKeyAlias.uid++;
      }
    };
  }
});

// ../../node_modules/@babel/types/lib/converters/toStatement.js
var require_toStatement = __commonJS({
  "../../node_modules/@babel/types/lib/converters/toStatement.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _index = require_generated();
    var _index2 = require_generated2();
    var _default = exports2.default = toStatement;
    function toStatement(node, ignore) {
      if ((0, _index.isStatement)(node)) {
        return node;
      }
      let mustHaveId = false;
      let newType;
      if ((0, _index.isClass)(node)) {
        mustHaveId = true;
        newType = "ClassDeclaration";
      } else if ((0, _index.isFunction)(node)) {
        mustHaveId = true;
        newType = "FunctionDeclaration";
      } else if ((0, _index.isAssignmentExpression)(node)) {
        return (0, _index2.expressionStatement)(node);
      }
      if (mustHaveId && !node.id) {
        newType = false;
      }
      if (!newType) {
        if (ignore) {
          return false;
        } else {
          throw new Error(`cannot turn ${node.type} to a statement`);
        }
      }
      node.type = newType;
      return node;
    }
  }
});

// ../../node_modules/@babel/types/lib/converters/valueToNode.js
var require_valueToNode = __commonJS({
  "../../node_modules/@babel/types/lib/converters/valueToNode.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _isValidIdentifier = require_isValidIdentifier();
    var _index = require_generated2();
    var _default = exports2.default = valueToNode;
    var objectToString = Function.call.bind(Object.prototype.toString);
    function isRegExp(value) {
      return objectToString(value) === "[object RegExp]";
    }
    function isPlainObject(value) {
      if (typeof value !== "object" || value === null || Object.prototype.toString.call(value) !== "[object Object]") {
        return false;
      }
      const proto = Object.getPrototypeOf(value);
      return proto === null || Object.getPrototypeOf(proto) === null;
    }
    function valueToNode(value) {
      if (value === void 0) {
        return (0, _index.identifier)("undefined");
      }
      if (value === true || value === false) {
        return (0, _index.booleanLiteral)(value);
      }
      if (value === null) {
        return (0, _index.nullLiteral)();
      }
      if (typeof value === "string") {
        return (0, _index.stringLiteral)(value);
      }
      if (typeof value === "number") {
        let result;
        if (Number.isFinite(value)) {
          result = (0, _index.numericLiteral)(Math.abs(value));
        } else {
          let numerator;
          if (Number.isNaN(value)) {
            numerator = (0, _index.numericLiteral)(0);
          } else {
            numerator = (0, _index.numericLiteral)(1);
          }
          result = (0, _index.binaryExpression)("/", numerator, (0, _index.numericLiteral)(0));
        }
        if (value < 0 || Object.is(value, -0)) {
          result = (0, _index.unaryExpression)("-", result);
        }
        return result;
      }
      if (isRegExp(value)) {
        const pattern = value.source;
        const flags = /\/([a-z]*)$/.exec(value.toString())[1];
        return (0, _index.regExpLiteral)(pattern, flags);
      }
      if (Array.isArray(value)) {
        return (0, _index.arrayExpression)(value.map(valueToNode));
      }
      if (isPlainObject(value)) {
        const props = [];
        for (const key of Object.keys(value)) {
          let nodeKey;
          if ((0, _isValidIdentifier.default)(key)) {
            nodeKey = (0, _index.identifier)(key);
          } else {
            nodeKey = (0, _index.stringLiteral)(key);
          }
          props.push((0, _index.objectProperty)(nodeKey, valueToNode(value[key])));
        }
        return (0, _index.objectExpression)(props);
      }
      throw new Error("don't know how to turn this value into a node");
    }
  }
});

// ../../node_modules/@babel/types/lib/modifications/appendToMemberExpression.js
var require_appendToMemberExpression = __commonJS({
  "../../node_modules/@babel/types/lib/modifications/appendToMemberExpression.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = appendToMemberExpression;
    var _index = require_generated2();
    function appendToMemberExpression(member, append, computed = false) {
      member.object = (0, _index.memberExpression)(member.object, member.property, member.computed);
      member.property = append;
      member.computed = !!computed;
      return member;
    }
  }
});

// ../../node_modules/@babel/types/lib/modifications/inherits.js
var require_inherits = __commonJS({
  "../../node_modules/@babel/types/lib/modifications/inherits.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = inherits;
    var _index = require_constants();
    var _inheritsComments = require_inheritsComments();
    function inherits(child, parent) {
      if (!child || !parent) return child;
      for (const key of _index.INHERIT_KEYS.optional) {
        if (child[key] == null) {
          child[key] = parent[key];
        }
      }
      for (const key of Object.keys(parent)) {
        if (key[0] === "_" && key !== "__clone") {
          child[key] = parent[key];
        }
      }
      for (const key of _index.INHERIT_KEYS.force) {
        child[key] = parent[key];
      }
      (0, _inheritsComments.default)(child, parent);
      return child;
    }
  }
});

// ../../node_modules/@babel/types/lib/modifications/prependToMemberExpression.js
var require_prependToMemberExpression = __commonJS({
  "../../node_modules/@babel/types/lib/modifications/prependToMemberExpression.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = prependToMemberExpression;
    var _index = require_generated2();
    var _index2 = require_lib3();
    function prependToMemberExpression(member, prepend) {
      if ((0, _index2.isSuper)(member.object)) {
        throw new Error("Cannot prepend node to super property access (`super.foo`).");
      }
      member.object = (0, _index.memberExpression)(prepend, member.object);
      return member;
    }
  }
});

// ../../node_modules/@babel/types/lib/retrievers/getAssignmentIdentifiers.js
var require_getAssignmentIdentifiers = __commonJS({
  "../../node_modules/@babel/types/lib/retrievers/getAssignmentIdentifiers.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = getAssignmentIdentifiers;
    function getAssignmentIdentifiers(node) {
      const search = [].concat(node);
      const ids = /* @__PURE__ */ Object.create(null);
      while (search.length) {
        const id = search.pop();
        if (!id) continue;
        switch (id.type) {
          case "ArrayPattern":
            search.push(...id.elements);
            break;
          case "AssignmentExpression":
          case "AssignmentPattern":
          case "ForInStatement":
          case "ForOfStatement":
            search.push(id.left);
            break;
          case "ObjectPattern":
            search.push(...id.properties);
            break;
          case "ObjectProperty":
            search.push(id.value);
            break;
          case "RestElement":
          case "UpdateExpression":
            search.push(id.argument);
            break;
          case "UnaryExpression":
            if (id.operator === "delete") {
              search.push(id.argument);
            }
            break;
          case "Identifier":
            ids[id.name] = id;
            break;
          default:
            break;
        }
      }
      return ids;
    }
  }
});

// ../../node_modules/@babel/types/lib/retrievers/getBindingIdentifiers.js
var require_getBindingIdentifiers = __commonJS({
  "../../node_modules/@babel/types/lib/retrievers/getBindingIdentifiers.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = getBindingIdentifiers;
    var _index = require_generated();
    function getBindingIdentifiers(node, duplicates, outerOnly, newBindingsOnly) {
      const search = [].concat(node);
      const ids = /* @__PURE__ */ Object.create(null);
      while (search.length) {
        const id = search.shift();
        if (!id) continue;
        if (newBindingsOnly && ((0, _index.isAssignmentExpression)(id) || (0, _index.isUnaryExpression)(id) || (0, _index.isUpdateExpression)(id))) {
          continue;
        }
        if ((0, _index.isIdentifier)(id)) {
          if (duplicates) {
            const _ids = ids[id.name] = ids[id.name] || [];
            _ids.push(id);
          } else {
            ids[id.name] = id;
          }
          continue;
        }
        if ((0, _index.isExportDeclaration)(id) && !(0, _index.isExportAllDeclaration)(id)) {
          if ((0, _index.isDeclaration)(id.declaration)) {
            search.push(id.declaration);
          }
          continue;
        }
        if (outerOnly) {
          if ((0, _index.isFunctionDeclaration)(id)) {
            search.push(id.id);
            continue;
          }
          if ((0, _index.isFunctionExpression)(id)) {
            continue;
          }
        }
        const keys2 = getBindingIdentifiers.keys[id.type];
        if (keys2) {
          for (let i = 0; i < keys2.length; i++) {
            const key = keys2[i];
            const nodes = id[key];
            if (nodes) {
              if (Array.isArray(nodes)) {
                search.push(...nodes);
              } else {
                search.push(nodes);
              }
            }
          }
        }
      }
      return ids;
    }
    var keys = {
      DeclareClass: ["id"],
      DeclareFunction: ["id"],
      DeclareModule: ["id"],
      DeclareVariable: ["id"],
      DeclareInterface: ["id"],
      DeclareTypeAlias: ["id"],
      DeclareOpaqueType: ["id"],
      InterfaceDeclaration: ["id"],
      TypeAlias: ["id"],
      OpaqueType: ["id"],
      CatchClause: ["param"],
      LabeledStatement: ["label"],
      UnaryExpression: ["argument"],
      AssignmentExpression: ["left"],
      ImportSpecifier: ["local"],
      ImportNamespaceSpecifier: ["local"],
      ImportDefaultSpecifier: ["local"],
      ImportDeclaration: ["specifiers"],
      ExportSpecifier: ["exported"],
      ExportNamespaceSpecifier: ["exported"],
      ExportDefaultSpecifier: ["exported"],
      FunctionDeclaration: ["id", "params"],
      FunctionExpression: ["id", "params"],
      ArrowFunctionExpression: ["params"],
      ObjectMethod: ["params"],
      ClassMethod: ["params"],
      ClassPrivateMethod: ["params"],
      ForInStatement: ["left"],
      ForOfStatement: ["left"],
      ClassDeclaration: ["id"],
      ClassExpression: ["id"],
      RestElement: ["argument"],
      UpdateExpression: ["argument"],
      ObjectProperty: ["value"],
      AssignmentPattern: ["left"],
      ArrayPattern: ["elements"],
      ObjectPattern: ["properties"],
      VariableDeclaration: ["declarations"],
      VariableDeclarator: ["id"]
    };
    getBindingIdentifiers.keys = keys;
  }
});

// ../../node_modules/@babel/types/lib/retrievers/getOuterBindingIdentifiers.js
var require_getOuterBindingIdentifiers = __commonJS({
  "../../node_modules/@babel/types/lib/retrievers/getOuterBindingIdentifiers.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    var _getBindingIdentifiers = require_getBindingIdentifiers();
    var _default = exports2.default = getOuterBindingIdentifiers;
    function getOuterBindingIdentifiers(node, duplicates) {
      return (0, _getBindingIdentifiers.default)(node, duplicates, true);
    }
  }
});

// ../../node_modules/@babel/types/lib/retrievers/getFunctionName.js
var require_getFunctionName = __commonJS({
  "../../node_modules/@babel/types/lib/retrievers/getFunctionName.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = getFunctionName3;
    var _index = require_generated();
    function getNameFromLiteralId(id) {
      if ((0, _index.isNullLiteral)(id)) {
        return "null";
      }
      if ((0, _index.isRegExpLiteral)(id)) {
        return `/${id.pattern}/${id.flags}`;
      }
      if ((0, _index.isTemplateLiteral)(id)) {
        return id.quasis.map((quasi) => quasi.value.raw).join("");
      }
      if (id.value !== void 0) {
        return String(id.value);
      }
      return null;
    }
    function getObjectMemberKey(node) {
      if (!node.computed || (0, _index.isLiteral)(node.key)) {
        return node.key;
      }
    }
    function getFunctionName3(node, parent) {
      if ("id" in node && node.id) {
        return {
          name: node.id.name,
          originalNode: node.id
        };
      }
      let prefix = "";
      let id;
      if ((0, _index.isObjectProperty)(parent, {
        value: node
      })) {
        id = getObjectMemberKey(parent);
      } else if ((0, _index.isObjectMethod)(node) || (0, _index.isClassMethod)(node)) {
        id = getObjectMemberKey(node);
        if (node.kind === "get") prefix = "get ";
        else if (node.kind === "set") prefix = "set ";
      } else if ((0, _index.isVariableDeclarator)(parent, {
        init: node
      })) {
        id = parent.id;
      } else if ((0, _index.isAssignmentExpression)(parent, {
        operator: "=",
        right: node
      })) {
        id = parent.left;
      }
      if (!id) return null;
      const name = (0, _index.isLiteral)(id) ? getNameFromLiteralId(id) : (0, _index.isIdentifier)(id) ? id.name : (0, _index.isPrivateName)(id) ? id.id.name : null;
      if (name == null) return null;
      return {
        name: prefix + name,
        originalNode: id
      };
    }
  }
});

// ../../node_modules/@babel/types/lib/traverse/traverse.js
var require_traverse = __commonJS({
  "../../node_modules/@babel/types/lib/traverse/traverse.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = traverse;
    var _index = require_definitions();
    function traverse(node, handlers, state) {
      if (typeof handlers === "function") {
        handlers = {
          enter: handlers
        };
      }
      const {
        enter,
        exit
      } = handlers;
      traverseSimpleImpl(node, enter, exit, state, []);
    }
    function traverseSimpleImpl(node, enter, exit, state, ancestors) {
      const keys = _index.VISITOR_KEYS[node.type];
      if (!keys) return;
      if (enter) enter(node, ancestors, state);
      for (const key of keys) {
        const subNode = node[key];
        if (Array.isArray(subNode)) {
          for (let i = 0; i < subNode.length; i++) {
            const child = subNode[i];
            if (!child) continue;
            ancestors.push({
              node,
              key,
              index: i
            });
            traverseSimpleImpl(child, enter, exit, state, ancestors);
            ancestors.pop();
          }
        } else if (subNode) {
          ancestors.push({
            node,
            key
          });
          traverseSimpleImpl(subNode, enter, exit, state, ancestors);
          ancestors.pop();
        }
      }
      if (exit) exit(node, ancestors, state);
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isBinding.js
var require_isBinding = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isBinding.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isBinding;
    var _getBindingIdentifiers = require_getBindingIdentifiers();
    function isBinding(node, parent, grandparent) {
      if (grandparent && node.type === "Identifier" && parent.type === "ObjectProperty" && grandparent.type === "ObjectExpression") {
        return false;
      }
      const keys = _getBindingIdentifiers.default.keys[parent.type];
      if (keys) {
        for (let i = 0; i < keys.length; i++) {
          const key = keys[i];
          const val = parent[key];
          if (Array.isArray(val)) {
            if (val.includes(node)) return true;
          } else {
            if (val === node) return true;
          }
        }
      }
      return false;
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isLet.js
var require_isLet = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isLet.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isLet;
    var _index = require_generated();
    var _index2 = require_constants();
    function isLet(node) {
      return (0, _index.isVariableDeclaration)(node) && (node.kind !== "var" || node[_index2.BLOCK_SCOPED_SYMBOL]);
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isBlockScoped.js
var require_isBlockScoped = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isBlockScoped.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isBlockScoped;
    var _index = require_generated();
    var _isLet = require_isLet();
    function isBlockScoped(node) {
      return (0, _index.isFunctionDeclaration)(node) || (0, _index.isClassDeclaration)(node) || (0, _isLet.default)(node);
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isImmutable.js
var require_isImmutable = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isImmutable.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isImmutable;
    var _isType = require_isType();
    var _index = require_generated();
    function isImmutable(node) {
      if ((0, _isType.default)(node.type, "Immutable")) return true;
      if ((0, _index.isIdentifier)(node)) {
        if (node.name === "undefined") {
          return true;
        } else {
          return false;
        }
      }
      return false;
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isNodesEquivalent.js
var require_isNodesEquivalent = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isNodesEquivalent.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isNodesEquivalent2;
    var _index = require_definitions();
    function isNodesEquivalent2(a, b) {
      if (typeof a !== "object" || typeof b !== "object" || a == null || b == null) {
        return a === b;
      }
      if (a.type !== b.type) {
        return false;
      }
      const fields = Object.keys(_index.NODE_FIELDS[a.type] || a.type);
      const visitorKeys = _index.VISITOR_KEYS[a.type];
      for (const field of fields) {
        const val_a = a[field];
        const val_b = b[field];
        if (typeof val_a !== typeof val_b) {
          return false;
        }
        if (val_a == null && val_b == null) {
          continue;
        } else if (val_a == null || val_b == null) {
          return false;
        }
        if (Array.isArray(val_a)) {
          if (!Array.isArray(val_b)) {
            return false;
          }
          if (val_a.length !== val_b.length) {
            return false;
          }
          for (let i = 0; i < val_a.length; i++) {
            if (!isNodesEquivalent2(val_a[i], val_b[i])) {
              return false;
            }
          }
          continue;
        }
        if (typeof val_a === "object" && !(visitorKeys != null && visitorKeys.includes(field))) {
          for (const key of Object.keys(val_a)) {
            if (val_a[key] !== val_b[key]) {
              return false;
            }
          }
          continue;
        }
        if (!isNodesEquivalent2(val_a, val_b)) {
          return false;
        }
      }
      return true;
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isReferenced.js
var require_isReferenced = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isReferenced.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isReferenced;
    function isReferenced(node, parent, grandparent) {
      switch (parent.type) {
        case "MemberExpression":
        case "OptionalMemberExpression":
          if (parent.property === node) {
            return !!parent.computed;
          }
          return parent.object === node;
        case "JSXMemberExpression":
          return parent.object === node;
        case "VariableDeclarator":
          return parent.init === node;
        case "ArrowFunctionExpression":
          return parent.body === node;
        case "PrivateName":
          return false;
        case "ClassMethod":
        case "ClassPrivateMethod":
        case "ObjectMethod":
          if (parent.key === node) {
            return !!parent.computed;
          }
          return false;
        case "ObjectProperty":
          if (parent.key === node) {
            return !!parent.computed;
          }
          return !grandparent || grandparent.type !== "ObjectPattern";
        case "ClassProperty":
        case "ClassAccessorProperty":
          if (parent.key === node) {
            return !!parent.computed;
          }
          return true;
        case "ClassPrivateProperty":
          return parent.key !== node;
        case "ClassDeclaration":
        case "ClassExpression":
          return parent.superClass === node;
        case "AssignmentExpression":
          return parent.right === node;
        case "AssignmentPattern":
          return parent.right === node;
        case "LabeledStatement":
          return false;
        case "CatchClause":
          return false;
        case "RestElement":
          return false;
        case "BreakStatement":
        case "ContinueStatement":
          return false;
        case "FunctionDeclaration":
        case "FunctionExpression":
          return false;
        case "ExportNamespaceSpecifier":
        case "ExportDefaultSpecifier":
          return false;
        case "ExportSpecifier":
          if (grandparent != null && grandparent.source) {
            return false;
          }
          return parent.local === node;
        case "ImportDefaultSpecifier":
        case "ImportNamespaceSpecifier":
        case "ImportSpecifier":
          return false;
        case "ImportAttribute":
          return false;
        case "JSXAttribute":
          return false;
        case "ObjectPattern":
        case "ArrayPattern":
          return false;
        case "MetaProperty":
          return false;
        case "ObjectTypeProperty":
          return parent.key !== node;
        case "TSEnumMember":
          return parent.id !== node;
        case "TSPropertySignature":
          if (parent.key === node) {
            return !!parent.computed;
          }
          return true;
      }
      return true;
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isScope.js
var require_isScope = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isScope.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isScope;
    var _index = require_generated();
    function isScope(node, parent) {
      if ((0, _index.isBlockStatement)(node) && ((0, _index.isFunction)(parent) || (0, _index.isCatchClause)(parent))) {
        return false;
      }
      if ((0, _index.isPattern)(node) && ((0, _index.isFunction)(parent) || (0, _index.isCatchClause)(parent))) {
        return true;
      }
      return (0, _index.isScopable)(node);
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isSpecifierDefault.js
var require_isSpecifierDefault = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isSpecifierDefault.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isSpecifierDefault;
    var _index = require_generated();
    function isSpecifierDefault(specifier) {
      return (0, _index.isImportDefaultSpecifier)(specifier) || (0, _index.isIdentifier)(specifier.imported || specifier.exported, {
        name: "default"
      });
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isValidES3Identifier.js
var require_isValidES3Identifier = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isValidES3Identifier.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isValidES3Identifier;
    var _isValidIdentifier = require_isValidIdentifier();
    var RESERVED_WORDS_ES3_ONLY = /* @__PURE__ */ new Set(["abstract", "boolean", "byte", "char", "double", "enum", "final", "float", "goto", "implements", "int", "interface", "long", "native", "package", "private", "protected", "public", "short", "static", "synchronized", "throws", "transient", "volatile"]);
    function isValidES3Identifier(name) {
      return (0, _isValidIdentifier.default)(name) && !RESERVED_WORDS_ES3_ONLY.has(name);
    }
  }
});

// ../../node_modules/@babel/types/lib/validators/isVar.js
var require_isVar = __commonJS({
  "../../node_modules/@babel/types/lib/validators/isVar.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = isVar;
    var _index = require_generated();
    var _index2 = require_constants();
    function isVar(node) {
      return (0, _index.isVariableDeclaration)(node, {
        kind: "var"
      }) && !node[_index2.BLOCK_SCOPED_SYMBOL];
    }
  }
});

// ../../node_modules/@babel/types/lib/converters/gatherSequenceExpressions.js
var require_gatherSequenceExpressions = __commonJS({
  "../../node_modules/@babel/types/lib/converters/gatherSequenceExpressions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = gatherSequenceExpressions;
    var _getBindingIdentifiers = require_getBindingIdentifiers();
    var _index = require_generated();
    var _index2 = require_generated2();
    var _productions = require_productions();
    var _cloneNode = require_cloneNode();
    function gatherSequenceExpressions(nodes, declars) {
      const exprs = [];
      let ensureLastUndefined = true;
      for (const node of nodes) {
        if (!(0, _index.isEmptyStatement)(node)) {
          ensureLastUndefined = false;
        }
        if ((0, _index.isExpression)(node)) {
          exprs.push(node);
        } else if ((0, _index.isExpressionStatement)(node)) {
          exprs.push(node.expression);
        } else if ((0, _index.isVariableDeclaration)(node)) {
          if (node.kind !== "var") return;
          for (const declar of node.declarations) {
            const bindings = (0, _getBindingIdentifiers.default)(declar);
            for (const key of Object.keys(bindings)) {
              declars.push({
                kind: node.kind,
                id: (0, _cloneNode.default)(bindings[key])
              });
            }
            if (declar.init) {
              exprs.push((0, _index2.assignmentExpression)("=", declar.id, declar.init));
            }
          }
          ensureLastUndefined = true;
        } else if ((0, _index.isIfStatement)(node)) {
          const consequent = node.consequent ? gatherSequenceExpressions([node.consequent], declars) : (0, _productions.buildUndefinedNode)();
          const alternate = node.alternate ? gatherSequenceExpressions([node.alternate], declars) : (0, _productions.buildUndefinedNode)();
          if (!consequent || !alternate) return;
          exprs.push((0, _index2.conditionalExpression)(node.test, consequent, alternate));
        } else if ((0, _index.isBlockStatement)(node)) {
          const body = gatherSequenceExpressions(node.body, declars);
          if (!body) return;
          exprs.push(body);
        } else if ((0, _index.isEmptyStatement)(node)) {
          if (nodes.indexOf(node) === 0) {
            ensureLastUndefined = true;
          }
        } else {
          return;
        }
      }
      if (ensureLastUndefined) {
        exprs.push((0, _productions.buildUndefinedNode)());
      }
      if (exprs.length === 1) {
        return exprs[0];
      } else {
        return (0, _index2.sequenceExpression)(exprs);
      }
    }
  }
});

// ../../node_modules/@babel/types/lib/converters/toSequenceExpression.js
var require_toSequenceExpression = __commonJS({
  "../../node_modules/@babel/types/lib/converters/toSequenceExpression.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = toSequenceExpression;
    var _gatherSequenceExpressions = require_gatherSequenceExpressions();
    function toSequenceExpression(nodes, scope) {
      if (!(nodes != null && nodes.length)) return;
      const declars = [];
      const result = (0, _gatherSequenceExpressions.default)(nodes, declars);
      if (!result) return;
      for (const declar of declars) {
        scope.push(declar);
      }
      return result;
    }
  }
});

// ../../node_modules/@babel/types/lib/index.js
var require_lib3 = __commonJS({
  "../../node_modules/@babel/types/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    var _exportNames = {
      react: true,
      assertNode: true,
      createTypeAnnotationBasedOnTypeof: true,
      createUnionTypeAnnotation: true,
      createFlowUnionType: true,
      createTSUnionType: true,
      cloneNode: true,
      clone: true,
      cloneDeep: true,
      cloneDeepWithoutLoc: true,
      cloneWithoutLoc: true,
      addComment: true,
      addComments: true,
      inheritInnerComments: true,
      inheritLeadingComments: true,
      inheritsComments: true,
      inheritTrailingComments: true,
      removeComments: true,
      ensureBlock: true,
      toBindingIdentifierName: true,
      toBlock: true,
      toComputedKey: true,
      toExpression: true,
      toIdentifier: true,
      toKeyAlias: true,
      toStatement: true,
      valueToNode: true,
      appendToMemberExpression: true,
      inherits: true,
      prependToMemberExpression: true,
      removeProperties: true,
      removePropertiesDeep: true,
      removeTypeDuplicates: true,
      getAssignmentIdentifiers: true,
      getBindingIdentifiers: true,
      getOuterBindingIdentifiers: true,
      getFunctionName: true,
      traverse: true,
      traverseFast: true,
      shallowEqual: true,
      is: true,
      isBinding: true,
      isBlockScoped: true,
      isImmutable: true,
      isLet: true,
      isNode: true,
      isNodesEquivalent: true,
      isPlaceholderType: true,
      isReferenced: true,
      isScope: true,
      isSpecifierDefault: true,
      isType: true,
      isValidES3Identifier: true,
      isValidIdentifier: true,
      isVar: true,
      matchesPattern: true,
      validate: true,
      buildMatchMemberExpression: true,
      __internal__deprecationWarning: true
    };
    Object.defineProperty(exports2, "__internal__deprecationWarning", {
      enumerable: true,
      get: function() {
        return _deprecationWarning.default;
      }
    });
    Object.defineProperty(exports2, "addComment", {
      enumerable: true,
      get: function() {
        return _addComment.default;
      }
    });
    Object.defineProperty(exports2, "addComments", {
      enumerable: true,
      get: function() {
        return _addComments.default;
      }
    });
    Object.defineProperty(exports2, "appendToMemberExpression", {
      enumerable: true,
      get: function() {
        return _appendToMemberExpression.default;
      }
    });
    Object.defineProperty(exports2, "assertNode", {
      enumerable: true,
      get: function() {
        return _assertNode.default;
      }
    });
    Object.defineProperty(exports2, "buildMatchMemberExpression", {
      enumerable: true,
      get: function() {
        return _buildMatchMemberExpression.default;
      }
    });
    Object.defineProperty(exports2, "clone", {
      enumerable: true,
      get: function() {
        return _clone.default;
      }
    });
    Object.defineProperty(exports2, "cloneDeep", {
      enumerable: true,
      get: function() {
        return _cloneDeep.default;
      }
    });
    Object.defineProperty(exports2, "cloneDeepWithoutLoc", {
      enumerable: true,
      get: function() {
        return _cloneDeepWithoutLoc.default;
      }
    });
    Object.defineProperty(exports2, "cloneNode", {
      enumerable: true,
      get: function() {
        return _cloneNode.default;
      }
    });
    Object.defineProperty(exports2, "cloneWithoutLoc", {
      enumerable: true,
      get: function() {
        return _cloneWithoutLoc.default;
      }
    });
    Object.defineProperty(exports2, "createFlowUnionType", {
      enumerable: true,
      get: function() {
        return _createFlowUnionType.default;
      }
    });
    Object.defineProperty(exports2, "createTSUnionType", {
      enumerable: true,
      get: function() {
        return _createTSUnionType.default;
      }
    });
    Object.defineProperty(exports2, "createTypeAnnotationBasedOnTypeof", {
      enumerable: true,
      get: function() {
        return _createTypeAnnotationBasedOnTypeof.default;
      }
    });
    Object.defineProperty(exports2, "createUnionTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _createFlowUnionType.default;
      }
    });
    Object.defineProperty(exports2, "ensureBlock", {
      enumerable: true,
      get: function() {
        return _ensureBlock.default;
      }
    });
    Object.defineProperty(exports2, "getAssignmentIdentifiers", {
      enumerable: true,
      get: function() {
        return _getAssignmentIdentifiers.default;
      }
    });
    Object.defineProperty(exports2, "getBindingIdentifiers", {
      enumerable: true,
      get: function() {
        return _getBindingIdentifiers.default;
      }
    });
    Object.defineProperty(exports2, "getFunctionName", {
      enumerable: true,
      get: function() {
        return _getFunctionName.default;
      }
    });
    Object.defineProperty(exports2, "getOuterBindingIdentifiers", {
      enumerable: true,
      get: function() {
        return _getOuterBindingIdentifiers.default;
      }
    });
    Object.defineProperty(exports2, "inheritInnerComments", {
      enumerable: true,
      get: function() {
        return _inheritInnerComments.default;
      }
    });
    Object.defineProperty(exports2, "inheritLeadingComments", {
      enumerable: true,
      get: function() {
        return _inheritLeadingComments.default;
      }
    });
    Object.defineProperty(exports2, "inheritTrailingComments", {
      enumerable: true,
      get: function() {
        return _inheritTrailingComments.default;
      }
    });
    Object.defineProperty(exports2, "inherits", {
      enumerable: true,
      get: function() {
        return _inherits.default;
      }
    });
    Object.defineProperty(exports2, "inheritsComments", {
      enumerable: true,
      get: function() {
        return _inheritsComments.default;
      }
    });
    Object.defineProperty(exports2, "is", {
      enumerable: true,
      get: function() {
        return _is.default;
      }
    });
    Object.defineProperty(exports2, "isBinding", {
      enumerable: true,
      get: function() {
        return _isBinding.default;
      }
    });
    Object.defineProperty(exports2, "isBlockScoped", {
      enumerable: true,
      get: function() {
        return _isBlockScoped.default;
      }
    });
    Object.defineProperty(exports2, "isImmutable", {
      enumerable: true,
      get: function() {
        return _isImmutable.default;
      }
    });
    Object.defineProperty(exports2, "isLet", {
      enumerable: true,
      get: function() {
        return _isLet.default;
      }
    });
    Object.defineProperty(exports2, "isNode", {
      enumerable: true,
      get: function() {
        return _isNode.default;
      }
    });
    Object.defineProperty(exports2, "isNodesEquivalent", {
      enumerable: true,
      get: function() {
        return _isNodesEquivalent.default;
      }
    });
    Object.defineProperty(exports2, "isPlaceholderType", {
      enumerable: true,
      get: function() {
        return _isPlaceholderType.default;
      }
    });
    Object.defineProperty(exports2, "isReferenced", {
      enumerable: true,
      get: function() {
        return _isReferenced.default;
      }
    });
    Object.defineProperty(exports2, "isScope", {
      enumerable: true,
      get: function() {
        return _isScope.default;
      }
    });
    Object.defineProperty(exports2, "isSpecifierDefault", {
      enumerable: true,
      get: function() {
        return _isSpecifierDefault.default;
      }
    });
    Object.defineProperty(exports2, "isType", {
      enumerable: true,
      get: function() {
        return _isType.default;
      }
    });
    Object.defineProperty(exports2, "isValidES3Identifier", {
      enumerable: true,
      get: function() {
        return _isValidES3Identifier.default;
      }
    });
    Object.defineProperty(exports2, "isValidIdentifier", {
      enumerable: true,
      get: function() {
        return _isValidIdentifier.default;
      }
    });
    Object.defineProperty(exports2, "isVar", {
      enumerable: true,
      get: function() {
        return _isVar.default;
      }
    });
    Object.defineProperty(exports2, "matchesPattern", {
      enumerable: true,
      get: function() {
        return _matchesPattern.default;
      }
    });
    Object.defineProperty(exports2, "prependToMemberExpression", {
      enumerable: true,
      get: function() {
        return _prependToMemberExpression.default;
      }
    });
    exports2.react = void 0;
    Object.defineProperty(exports2, "removeComments", {
      enumerable: true,
      get: function() {
        return _removeComments.default;
      }
    });
    Object.defineProperty(exports2, "removeProperties", {
      enumerable: true,
      get: function() {
        return _removeProperties.default;
      }
    });
    Object.defineProperty(exports2, "removePropertiesDeep", {
      enumerable: true,
      get: function() {
        return _removePropertiesDeep.default;
      }
    });
    Object.defineProperty(exports2, "removeTypeDuplicates", {
      enumerable: true,
      get: function() {
        return _removeTypeDuplicates.default;
      }
    });
    Object.defineProperty(exports2, "shallowEqual", {
      enumerable: true,
      get: function() {
        return _shallowEqual.default;
      }
    });
    Object.defineProperty(exports2, "toBindingIdentifierName", {
      enumerable: true,
      get: function() {
        return _toBindingIdentifierName.default;
      }
    });
    Object.defineProperty(exports2, "toBlock", {
      enumerable: true,
      get: function() {
        return _toBlock.default;
      }
    });
    Object.defineProperty(exports2, "toComputedKey", {
      enumerable: true,
      get: function() {
        return _toComputedKey.default;
      }
    });
    Object.defineProperty(exports2, "toExpression", {
      enumerable: true,
      get: function() {
        return _toExpression.default;
      }
    });
    Object.defineProperty(exports2, "toIdentifier", {
      enumerable: true,
      get: function() {
        return _toIdentifier.default;
      }
    });
    Object.defineProperty(exports2, "toKeyAlias", {
      enumerable: true,
      get: function() {
        return _toKeyAlias.default;
      }
    });
    Object.defineProperty(exports2, "toStatement", {
      enumerable: true,
      get: function() {
        return _toStatement.default;
      }
    });
    Object.defineProperty(exports2, "traverse", {
      enumerable: true,
      get: function() {
        return _traverse.default;
      }
    });
    Object.defineProperty(exports2, "traverseFast", {
      enumerable: true,
      get: function() {
        return _traverseFast.default;
      }
    });
    Object.defineProperty(exports2, "validate", {
      enumerable: true,
      get: function() {
        return _validate.default;
      }
    });
    Object.defineProperty(exports2, "valueToNode", {
      enumerable: true,
      get: function() {
        return _valueToNode.default;
      }
    });
    var _isReactComponent = require_isReactComponent();
    var _isCompatTag = require_isCompatTag();
    var _buildChildren = require_buildChildren();
    var _assertNode = require_assertNode();
    var _index = require_generated3();
    Object.keys(_index).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
      if (key in exports2 && exports2[key] === _index[key]) return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _index[key];
        }
      });
    });
    var _createTypeAnnotationBasedOnTypeof = require_createTypeAnnotationBasedOnTypeof();
    var _createFlowUnionType = require_createFlowUnionType();
    var _createTSUnionType = require_createTSUnionType();
    var _index2 = require_generated2();
    Object.keys(_index2).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
      if (key in exports2 && exports2[key] === _index2[key]) return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _index2[key];
        }
      });
    });
    var _uppercase = require_uppercase();
    Object.keys(_uppercase).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
      if (key in exports2 && exports2[key] === _uppercase[key]) return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _uppercase[key];
        }
      });
    });
    var _productions = require_productions();
    Object.keys(_productions).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
      if (key in exports2 && exports2[key] === _productions[key]) return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _productions[key];
        }
      });
    });
    var _cloneNode = require_cloneNode();
    var _clone = require_clone();
    var _cloneDeep = require_cloneDeep();
    var _cloneDeepWithoutLoc = require_cloneDeepWithoutLoc();
    var _cloneWithoutLoc = require_cloneWithoutLoc();
    var _addComment = require_addComment();
    var _addComments = require_addComments();
    var _inheritInnerComments = require_inheritInnerComments();
    var _inheritLeadingComments = require_inheritLeadingComments();
    var _inheritsComments = require_inheritsComments();
    var _inheritTrailingComments = require_inheritTrailingComments();
    var _removeComments = require_removeComments();
    var _index3 = require_generated4();
    Object.keys(_index3).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
      if (key in exports2 && exports2[key] === _index3[key]) return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _index3[key];
        }
      });
    });
    var _index4 = require_constants();
    Object.keys(_index4).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
      if (key in exports2 && exports2[key] === _index4[key]) return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _index4[key];
        }
      });
    });
    var _ensureBlock = require_ensureBlock();
    var _toBindingIdentifierName = require_toBindingIdentifierName();
    var _toBlock = require_toBlock();
    var _toComputedKey = require_toComputedKey();
    var _toExpression = require_toExpression();
    var _toIdentifier = require_toIdentifier();
    var _toKeyAlias = require_toKeyAlias();
    var _toStatement = require_toStatement();
    var _valueToNode = require_valueToNode();
    var _index5 = require_definitions();
    Object.keys(_index5).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
      if (key in exports2 && exports2[key] === _index5[key]) return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _index5[key];
        }
      });
    });
    var _appendToMemberExpression = require_appendToMemberExpression();
    var _inherits = require_inherits();
    var _prependToMemberExpression = require_prependToMemberExpression();
    var _removeProperties = require_removeProperties();
    var _removePropertiesDeep = require_removePropertiesDeep();
    var _removeTypeDuplicates = require_removeTypeDuplicates();
    var _getAssignmentIdentifiers = require_getAssignmentIdentifiers();
    var _getBindingIdentifiers = require_getBindingIdentifiers();
    var _getOuterBindingIdentifiers = require_getOuterBindingIdentifiers();
    var _getFunctionName = require_getFunctionName();
    var _traverse = require_traverse();
    Object.keys(_traverse).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
      if (key in exports2 && exports2[key] === _traverse[key]) return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _traverse[key];
        }
      });
    });
    var _traverseFast = require_traverseFast();
    var _shallowEqual = require_shallowEqual();
    var _is = require_is();
    var _isBinding = require_isBinding();
    var _isBlockScoped = require_isBlockScoped();
    var _isImmutable = require_isImmutable();
    var _isLet = require_isLet();
    var _isNode = require_isNode();
    var _isNodesEquivalent = require_isNodesEquivalent();
    var _isPlaceholderType = require_isPlaceholderType();
    var _isReferenced = require_isReferenced();
    var _isScope = require_isScope();
    var _isSpecifierDefault = require_isSpecifierDefault();
    var _isType = require_isType();
    var _isValidES3Identifier = require_isValidES3Identifier();
    var _isValidIdentifier = require_isValidIdentifier();
    var _isVar = require_isVar();
    var _matchesPattern = require_matchesPattern();
    var _validate = require_validate();
    var _buildMatchMemberExpression = require_buildMatchMemberExpression();
    var _index6 = require_generated();
    Object.keys(_index6).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
      if (key in exports2 && exports2[key] === _index6[key]) return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _index6[key];
        }
      });
    });
    var _deprecationWarning = require_deprecationWarning();
    var react = exports2.react = {
      isReactComponent: _isReactComponent.default,
      isCompatTag: _isCompatTag.default,
      buildChildren: _buildChildren.default
    };
    {
      exports2.toSequenceExpression = require_toSequenceExpression().default;
    }
    if (process.env.BABEL_TYPES_8_BREAKING) {
      console.warn("BABEL_TYPES_8_BREAKING is not supported anymore. Use the latest Babel 8.0.0 pre-release instead!");
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/base64.js
var require_base64 = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/base64.js"(exports2) {
    "use strict";
    var intToCharMap = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");
    exports2.encode = function(number) {
      if (0 <= number && number < intToCharMap.length) {
        return intToCharMap[number];
      }
      throw new TypeError("Must be between 0 and 63: " + number);
    };
    exports2.decode = function(charCode) {
      var bigA = 65;
      var bigZ = 90;
      var littleA = 97;
      var littleZ = 122;
      var zero = 48;
      var nine = 57;
      var plus = 43;
      var slash = 47;
      var littleOffset = 26;
      var numberOffset = 52;
      if (bigA <= charCode && charCode <= bigZ) {
        return charCode - bigA;
      }
      if (littleA <= charCode && charCode <= littleZ) {
        return charCode - littleA + littleOffset;
      }
      if (zero <= charCode && charCode <= nine) {
        return charCode - zero + numberOffset;
      }
      if (charCode == plus) {
        return 62;
      }
      if (charCode == slash) {
        return 63;
      }
      return -1;
    };
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/base64-vlq.js
var require_base64_vlq = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/base64-vlq.js"(exports2) {
    "use strict";
    var base64 = require_base64();
    var VLQ_BASE_SHIFT = 5;
    var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
    var VLQ_BASE_MASK = VLQ_BASE - 1;
    var VLQ_CONTINUATION_BIT = VLQ_BASE;
    function toVLQSigned(aValue) {
      return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
    }
    function fromVLQSigned(aValue) {
      var isNegative = (aValue & 1) === 1;
      var shifted = aValue >> 1;
      return isNegative ? -shifted : shifted;
    }
    exports2.encode = function base64VLQ_encode(aValue) {
      var encoded = "";
      var digit;
      var vlq = toVLQSigned(aValue);
      do {
        digit = vlq & VLQ_BASE_MASK;
        vlq >>>= VLQ_BASE_SHIFT;
        if (vlq > 0) {
          digit |= VLQ_CONTINUATION_BIT;
        }
        encoded += base64.encode(digit);
      } while (vlq > 0);
      return encoded;
    };
    exports2.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
      var strLen = aStr.length;
      var result = 0;
      var shift = 0;
      var continuation, digit;
      do {
        if (aIndex >= strLen) {
          throw new Error("Expected more digits in base 64 VLQ value.");
        }
        digit = base64.decode(aStr.charCodeAt(aIndex++));
        if (digit === -1) {
          throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
        }
        continuation = !!(digit & VLQ_CONTINUATION_BIT);
        digit &= VLQ_BASE_MASK;
        result = result + (digit << shift);
        shift += VLQ_BASE_SHIFT;
      } while (continuation);
      aOutParam.value = fromVLQSigned(result);
      aOutParam.rest = aIndex;
    };
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/util.js
var require_util = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/util.js"(exports2) {
    "use strict";
    function getArg(aArgs, aName, aDefaultValue) {
      if (aName in aArgs) {
        return aArgs[aName];
      } else if (arguments.length === 3) {
        return aDefaultValue;
      } else {
        throw new Error('"' + aName + '" is a required argument.');
      }
    }
    exports2.getArg = getArg;
    var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.]*)(?::(\d+))?(\S*)$/;
    var dataUrlRegexp = /^data:.+\,.+$/;
    function urlParse(aUrl) {
      var match = aUrl.match(urlRegexp);
      if (!match) {
        return null;
      }
      return {
        scheme: match[1],
        auth: match[2],
        host: match[3],
        port: match[4],
        path: match[5]
      };
    }
    exports2.urlParse = urlParse;
    function urlGenerate(aParsedUrl) {
      var url = "";
      if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ":";
      }
      url += "//";
      if (aParsedUrl.auth) {
        url += aParsedUrl.auth + "@";
      }
      if (aParsedUrl.host) {
        url += aParsedUrl.host;
      }
      if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
      }
      if (aParsedUrl.path) {
        url += aParsedUrl.path;
      }
      return url;
    }
    exports2.urlGenerate = urlGenerate;
    function normalize(aPath) {
      var path = aPath;
      var url = urlParse(aPath);
      if (url) {
        if (!url.path) {
          return aPath;
        }
        path = url.path;
      }
      var isAbsolute = exports2.isAbsolute(path);
      var parts = path.split(/\/+/);
      for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
        part = parts[i];
        if (part === ".") {
          parts.splice(i, 1);
        } else if (part === "..") {
          up++;
        } else if (up > 0) {
          if (part === "") {
            parts.splice(i + 1, up);
            up = 0;
          } else {
            parts.splice(i, 2);
            up--;
          }
        }
      }
      path = parts.join("/");
      if (path === "") {
        path = isAbsolute ? "/" : ".";
      }
      if (url) {
        url.path = path;
        return urlGenerate(url);
      }
      return path;
    }
    exports2.normalize = normalize;
    function join(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      if (aPath === "") {
        aPath = ".";
      }
      var aPathUrl = urlParse(aPath);
      var aRootUrl = urlParse(aRoot);
      if (aRootUrl) {
        aRoot = aRootUrl.path || "/";
      }
      if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
          aPathUrl.scheme = aRootUrl.scheme;
        }
        return urlGenerate(aPathUrl);
      }
      if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
      }
      if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
      }
      var joined = aPath.charAt(0) === "/" ? aPath : normalize(aRoot.replace(/\/+$/, "") + "/" + aPath);
      if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
      }
      return joined;
    }
    exports2.join = join;
    exports2.isAbsolute = function(aPath) {
      return aPath.charAt(0) === "/" || !!aPath.match(urlRegexp);
    };
    function relative(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      aRoot = aRoot.replace(/\/$/, "");
      var level = 0;
      while (aPath.indexOf(aRoot + "/") !== 0) {
        var index = aRoot.lastIndexOf("/");
        if (index < 0) {
          return aPath;
        }
        aRoot = aRoot.slice(0, index);
        if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
          return aPath;
        }
        ++level;
      }
      return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
    }
    exports2.relative = relative;
    var supportsNullProto = function() {
      var obj = /* @__PURE__ */ Object.create(null);
      return !("__proto__" in obj);
    }();
    function identity(s) {
      return s;
    }
    function toSetString(aStr) {
      if (isProtoString(aStr)) {
        return "$" + aStr;
      }
      return aStr;
    }
    exports2.toSetString = supportsNullProto ? identity : toSetString;
    function fromSetString(aStr) {
      if (isProtoString(aStr)) {
        return aStr.slice(1);
      }
      return aStr;
    }
    exports2.fromSetString = supportsNullProto ? identity : fromSetString;
    function isProtoString(s) {
      if (!s) {
        return false;
      }
      var length = s.length;
      if (length < 9) {
        return false;
      }
      if (s.charCodeAt(length - 1) !== 95 || s.charCodeAt(length - 2) !== 95 || s.charCodeAt(length - 3) !== 111 || s.charCodeAt(length - 4) !== 116 || s.charCodeAt(length - 5) !== 111 || s.charCodeAt(length - 6) !== 114 || s.charCodeAt(length - 7) !== 112 || s.charCodeAt(length - 8) !== 95 || s.charCodeAt(length - 9) !== 95) {
        return false;
      }
      for (var i = length - 10; i >= 0; i--) {
        if (s.charCodeAt(i) !== 36) {
          return false;
        }
      }
      return true;
    }
    function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
      var cmp = mappingA.source - mappingB.source;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      return mappingA.name - mappingB.name;
    }
    exports2.compareByOriginalPositions = compareByOriginalPositions;
    function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
      }
      cmp = mappingA.source - mappingB.source;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return mappingA.name - mappingB.name;
    }
    exports2.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;
    function strcmp(aStr1, aStr2) {
      if (aStr1 === aStr2) {
        return 0;
      }
      if (aStr1 > aStr2) {
        return 1;
      }
      return -1;
    }
    function compareByGeneratedPositionsInflated(mappingA, mappingB) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/array-set.js
var require_array_set = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/array-set.js"(exports2) {
    "use strict";
    var util = require_util();
    var has = Object.prototype.hasOwnProperty;
    var hasNativeMap = typeof Map !== "undefined";
    function ArraySet() {
      this._array = [];
      this._set = hasNativeMap ? /* @__PURE__ */ new Map() : /* @__PURE__ */ Object.create(null);
    }
    ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
      var set = new ArraySet();
      for (var i = 0, len = aArray.length; i < len; i++) {
        set.add(aArray[i], aAllowDuplicates);
      }
      return set;
    };
    ArraySet.prototype.size = function ArraySet_size() {
      return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
    };
    ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
      var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
      var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
      var idx = this._array.length;
      if (!isDuplicate || aAllowDuplicates) {
        this._array.push(aStr);
      }
      if (!isDuplicate) {
        if (hasNativeMap) {
          this._set.set(aStr, idx);
        } else {
          this._set[sStr] = idx;
        }
      }
    };
    ArraySet.prototype.has = function ArraySet_has(aStr) {
      if (hasNativeMap) {
        return this._set.has(aStr);
      } else {
        var sStr = util.toSetString(aStr);
        return has.call(this._set, sStr);
      }
    };
    ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
      if (hasNativeMap) {
        var idx = this._set.get(aStr);
        if (idx >= 0) {
          return idx;
        }
      } else {
        var sStr = util.toSetString(aStr);
        if (has.call(this._set, sStr)) {
          return this._set[sStr];
        }
      }
      throw new Error('"' + aStr + '" is not in the set.');
    };
    ArraySet.prototype.at = function ArraySet_at(aIdx) {
      if (aIdx >= 0 && aIdx < this._array.length) {
        return this._array[aIdx];
      }
      throw new Error("No element indexed by " + aIdx);
    };
    ArraySet.prototype.toArray = function ArraySet_toArray() {
      return this._array.slice();
    };
    exports2.ArraySet = ArraySet;
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/mapping-list.js
var require_mapping_list = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/mapping-list.js"(exports2) {
    "use strict";
    var util = require_util();
    function generatedPositionAfter(mappingA, mappingB) {
      var lineA = mappingA.generatedLine;
      var lineB = mappingB.generatedLine;
      var columnA = mappingA.generatedColumn;
      var columnB = mappingB.generatedColumn;
      return lineB > lineA || lineB == lineA && columnB >= columnA || util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
    }
    function MappingList() {
      this._array = [];
      this._sorted = true;
      this._last = { generatedLine: -1, generatedColumn: 0 };
    }
    MappingList.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
      this._array.forEach(aCallback, aThisArg);
    };
    MappingList.prototype.add = function MappingList_add(aMapping) {
      if (generatedPositionAfter(this._last, aMapping)) {
        this._last = aMapping;
        this._array.push(aMapping);
      } else {
        this._sorted = false;
        this._array.push(aMapping);
      }
    };
    MappingList.prototype.toArray = function MappingList_toArray() {
      if (!this._sorted) {
        this._array.sort(util.compareByGeneratedPositionsInflated);
        this._sorted = true;
      }
      return this._array;
    };
    exports2.MappingList = MappingList;
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/source-map-generator.js
var require_source_map_generator = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/source-map-generator.js"(exports2) {
    "use strict";
    var base64VLQ = require_base64_vlq();
    var util = require_util();
    var ArraySet = require_array_set().ArraySet;
    var MappingList = require_mapping_list().MappingList;
    function SourceMapGenerator(aArgs) {
      if (!aArgs) {
        aArgs = {};
      }
      this._file = util.getArg(aArgs, "file", null);
      this._sourceRoot = util.getArg(aArgs, "sourceRoot", null);
      this._skipValidation = util.getArg(aArgs, "skipValidation", false);
      this._sources = new ArraySet();
      this._names = new ArraySet();
      this._mappings = new MappingList();
      this._sourcesContents = null;
    }
    SourceMapGenerator.prototype._version = 3;
    SourceMapGenerator.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator({
        file: aSourceMapConsumer.file,
        sourceRoot
      });
      aSourceMapConsumer.eachMapping(function(mapping) {
        var newMapping = {
          generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }
        };
        if (mapping.source != null) {
          newMapping.source = mapping.source;
          if (sourceRoot != null) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }
          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };
          if (mapping.name != null) {
            newMapping.name = mapping.name;
          }
        }
        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };
    SourceMapGenerator.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, "generated");
      var original = util.getArg(aArgs, "original", null);
      var source = util.getArg(aArgs, "source", null);
      var name = util.getArg(aArgs, "name", null);
      if (!this._skipValidation) {
        this._validateMapping(generated, original, source, name);
      }
      if (source != null) {
        source = String(source);
        if (!this._sources.has(source)) {
          this._sources.add(source);
        }
      }
      if (name != null) {
        name = String(name);
        if (!this._names.has(name)) {
          this._names.add(name);
        }
      }
      this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source,
        name
      });
    };
    SourceMapGenerator.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
      }
      if (aSourceContent != null) {
        if (!this._sourcesContents) {
          this._sourcesContents = /* @__PURE__ */ Object.create(null);
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else if (this._sourcesContents) {
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };
    SourceMapGenerator.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      var sourceFile = aSourceFile;
      if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
          throw new Error(
            `SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's "file" property. Both were omitted.`
          );
        }
        sourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
      }
      var newSources = new ArraySet();
      var newNames = new ArraySet();
      this._mappings.unsortedForEach(function(mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source != null) {
            mapping.source = original.source;
            if (aSourceMapPath != null) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot != null) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name != null) {
              mapping.name = original.name;
            }
          }
        }
        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
          newSources.add(source);
        }
        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
          newNames.add(name);
        }
      }, this);
      this._sources = newSources;
      this._names = newNames;
      aSourceMapConsumer.sources.forEach(function(sourceFile2) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile2);
        if (content != null) {
          if (aSourceMapPath != null) {
            sourceFile2 = util.join(aSourceMapPath, sourceFile2);
          }
          if (sourceRoot != null) {
            sourceFile2 = util.relative(sourceRoot, sourceFile2);
          }
          this.setSourceContent(sourceFile2, content);
        }
      }, this);
    };
    SourceMapGenerator.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
      if (aOriginal && typeof aOriginal.line !== "number" && typeof aOriginal.column !== "number") {
        throw new Error(
          "original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values."
        );
      }
      if (aGenerated && "line" in aGenerated && "column" in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
        return;
      } else if (aGenerated && "line" in aGenerated && "column" in aGenerated && aOriginal && "line" in aOriginal && "column" in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
        return;
      } else {
        throw new Error("Invalid mapping: " + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        }));
      }
    };
    SourceMapGenerator.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result = "";
      var next;
      var mapping;
      var nameIdx;
      var sourceIdx;
      var mappings = this._mappings.toArray();
      for (var i = 0, len = mappings.length; i < len; i++) {
        mapping = mappings[i];
        next = "";
        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            next += ";";
            previousGeneratedLine++;
          }
        } else {
          if (i > 0) {
            if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
              continue;
            }
            next += ",";
          }
        }
        next += base64VLQ.encode(mapping.generatedColumn - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;
        if (mapping.source != null) {
          sourceIdx = this._sources.indexOf(mapping.source);
          next += base64VLQ.encode(sourceIdx - previousSource);
          previousSource = sourceIdx;
          next += base64VLQ.encode(mapping.originalLine - 1 - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;
          next += base64VLQ.encode(mapping.originalColumn - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;
          if (mapping.name != null) {
            nameIdx = this._names.indexOf(mapping.name);
            next += base64VLQ.encode(nameIdx - previousName);
            previousName = nameIdx;
          }
        }
        result += next;
      }
      return result;
    };
    SourceMapGenerator.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function(source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot != null) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
      }, this);
    };
    SourceMapGenerator.prototype.toJSON = function SourceMapGenerator_toJSON() {
      var map = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._file != null) {
        map.file = this._file;
      }
      if (this._sourceRoot != null) {
        map.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
      }
      return map;
    };
    SourceMapGenerator.prototype.toString = function SourceMapGenerator_toString() {
      return JSON.stringify(this.toJSON());
    };
    exports2.SourceMapGenerator = SourceMapGenerator;
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/binary-search.js
var require_binary_search = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/binary-search.js"(exports2) {
    "use strict";
    exports2.GREATEST_LOWER_BOUND = 1;
    exports2.LEAST_UPPER_BOUND = 2;
    function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
      var mid = Math.floor((aHigh - aLow) / 2) + aLow;
      var cmp = aCompare(aNeedle, aHaystack[mid], true);
      if (cmp === 0) {
        return mid;
      } else if (cmp > 0) {
        if (aHigh - mid > 1) {
          return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return aHigh < aHaystack.length ? aHigh : -1;
        } else {
          return mid;
        }
      } else {
        if (mid - aLow > 1) {
          return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return mid;
        } else {
          return aLow < 0 ? -1 : aLow;
        }
      }
    }
    exports2.search = function search(aNeedle, aHaystack, aCompare, aBias) {
      if (aHaystack.length === 0) {
        return -1;
      }
      var index = recursiveSearch(
        -1,
        aHaystack.length,
        aNeedle,
        aHaystack,
        aCompare,
        aBias || exports2.GREATEST_LOWER_BOUND
      );
      if (index < 0) {
        return -1;
      }
      while (index - 1 >= 0) {
        if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
          break;
        }
        --index;
      }
      return index;
    };
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/quick-sort.js
var require_quick_sort = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/quick-sort.js"(exports2) {
    "use strict";
    function swap(ary, x, y) {
      var temp = ary[x];
      ary[x] = ary[y];
      ary[y] = temp;
    }
    function randomIntInRange(low, high) {
      return Math.round(low + Math.random() * (high - low));
    }
    function doQuickSort(ary, comparator, p, r) {
      if (p < r) {
        var pivotIndex = randomIntInRange(p, r);
        var i = p - 1;
        swap(ary, pivotIndex, r);
        var pivot = ary[r];
        for (var j = p; j < r; j++) {
          if (comparator(ary[j], pivot) <= 0) {
            i += 1;
            swap(ary, i, j);
          }
        }
        swap(ary, i + 1, j);
        var q = i + 1;
        doQuickSort(ary, comparator, p, q - 1);
        doQuickSort(ary, comparator, q + 1, r);
      }
    }
    exports2.quickSort = function(ary, comparator) {
      doQuickSort(ary, comparator, 0, ary.length - 1);
    };
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/source-map-consumer.js
var require_source_map_consumer = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/source-map-consumer.js"(exports2) {
    "use strict";
    var util = require_util();
    var binarySearch = require_binary_search();
    var ArraySet = require_array_set().ArraySet;
    var base64VLQ = require_base64_vlq();
    var quickSort = require_quick_sort().quickSort;
    function SourceMapConsumer(aSourceMap) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ""));
      }
      return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap) : new BasicSourceMapConsumer(sourceMap);
    }
    SourceMapConsumer.fromSourceMap = function(aSourceMap) {
      return BasicSourceMapConsumer.fromSourceMap(aSourceMap);
    };
    SourceMapConsumer.prototype._version = 3;
    SourceMapConsumer.prototype.__generatedMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_generatedMappings", {
      get: function() {
        if (!this.__generatedMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
      }
    });
    SourceMapConsumer.prototype.__originalMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_originalMappings", {
      get: function() {
        if (!this.__originalMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
      }
    });
    SourceMapConsumer.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
      var c = aStr.charAt(index);
      return c === ";" || c === ",";
    };
    SourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      throw new Error("Subclasses must implement _parseMappings");
    };
    SourceMapConsumer.GENERATED_ORDER = 1;
    SourceMapConsumer.ORIGINAL_ORDER = 2;
    SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
    SourceMapConsumer.LEAST_UPPER_BOUND = 2;
    SourceMapConsumer.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
      var mappings;
      switch (order) {
        case SourceMapConsumer.GENERATED_ORDER:
          mappings = this._generatedMappings;
          break;
        case SourceMapConsumer.ORIGINAL_ORDER:
          mappings = this._originalMappings;
          break;
        default:
          throw new Error("Unknown order of iteration.");
      }
      var sourceRoot = this.sourceRoot;
      mappings.map(function(mapping) {
        var source = mapping.source === null ? null : this._sources.at(mapping.source);
        if (source != null && sourceRoot != null) {
          source = util.join(sourceRoot, source);
        }
        return {
          source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name === null ? null : this._names.at(mapping.name)
        };
      }, this).forEach(aCallback, context);
    };
    SourceMapConsumer.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
      var line = util.getArg(aArgs, "line");
      var needle = {
        source: util.getArg(aArgs, "source"),
        originalLine: line,
        originalColumn: util.getArg(aArgs, "column", 0)
      };
      if (this.sourceRoot != null) {
        needle.source = util.relative(this.sourceRoot, needle.source);
      }
      if (!this._sources.has(needle.source)) {
        return [];
      }
      needle.source = this._sources.indexOf(needle.source);
      var mappings = [];
      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        binarySearch.LEAST_UPPER_BOUND
      );
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (aArgs.column === void 0) {
          var originalLine = mapping.originalLine;
          while (mapping && mapping.originalLine === originalLine) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        } else {
          var originalColumn = mapping.originalColumn;
          while (mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        }
      }
      return mappings;
    };
    exports2.SourceMapConsumer = SourceMapConsumer;
    function BasicSourceMapConsumer(aSourceMap) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ""));
      }
      var version = util.getArg(sourceMap, "version");
      var sources = util.getArg(sourceMap, "sources");
      var names = util.getArg(sourceMap, "names", []);
      var sourceRoot = util.getArg(sourceMap, "sourceRoot", null);
      var sourcesContent = util.getArg(sourceMap, "sourcesContent", null);
      var mappings = util.getArg(sourceMap, "mappings");
      var file = util.getArg(sourceMap, "file", null);
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      sources = sources.map(String).map(util.normalize).map(function(source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source) ? util.relative(sourceRoot, source) : source;
      });
      this._names = ArraySet.fromArray(names.map(String), true);
      this._sources = ArraySet.fromArray(sources, true);
      this.sourceRoot = sourceRoot;
      this.sourcesContent = sourcesContent;
      this._mappings = mappings;
      this.file = file;
    }
    BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;
    BasicSourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap) {
      var smc = Object.create(BasicSourceMapConsumer.prototype);
      var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
      var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(
        smc._sources.toArray(),
        smc.sourceRoot
      );
      smc.file = aSourceMap._file;
      var generatedMappings = aSourceMap._mappings.toArray().slice();
      var destGeneratedMappings = smc.__generatedMappings = [];
      var destOriginalMappings = smc.__originalMappings = [];
      for (var i = 0, length = generatedMappings.length; i < length; i++) {
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping();
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;
        if (srcMapping.source) {
          destMapping.source = sources.indexOf(srcMapping.source);
          destMapping.originalLine = srcMapping.originalLine;
          destMapping.originalColumn = srcMapping.originalColumn;
          if (srcMapping.name) {
            destMapping.name = names.indexOf(srcMapping.name);
          }
          destOriginalMappings.push(destMapping);
        }
        destGeneratedMappings.push(destMapping);
      }
      quickSort(smc.__originalMappings, util.compareByOriginalPositions);
      return smc;
    };
    BasicSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(BasicSourceMapConsumer.prototype, "sources", {
      get: function() {
        return this._sources.toArray().map(function(s) {
          return this.sourceRoot != null ? util.join(this.sourceRoot, s) : s;
        }, this);
      }
    });
    function Mapping() {
      this.generatedLine = 0;
      this.generatedColumn = 0;
      this.source = null;
      this.originalLine = null;
      this.originalColumn = null;
      this.name = null;
    }
    BasicSourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var length = aStr.length;
      var index = 0;
      var cachedSegments = {};
      var temp = {};
      var originalMappings = [];
      var generatedMappings = [];
      var mapping, str, segment, end, value;
      while (index < length) {
        if (aStr.charAt(index) === ";") {
          generatedLine++;
          index++;
          previousGeneratedColumn = 0;
        } else if (aStr.charAt(index) === ",") {
          index++;
        } else {
          mapping = new Mapping();
          mapping.generatedLine = generatedLine;
          for (end = index; end < length; end++) {
            if (this._charIsMappingSeparator(aStr, end)) {
              break;
            }
          }
          str = aStr.slice(index, end);
          segment = cachedSegments[str];
          if (segment) {
            index += str.length;
          } else {
            segment = [];
            while (index < end) {
              base64VLQ.decode(aStr, index, temp);
              value = temp.value;
              index = temp.rest;
              segment.push(value);
            }
            if (segment.length === 2) {
              throw new Error("Found a source, but no line and column");
            }
            if (segment.length === 3) {
              throw new Error("Found a source and line, but no column");
            }
            cachedSegments[str] = segment;
          }
          mapping.generatedColumn = previousGeneratedColumn + segment[0];
          previousGeneratedColumn = mapping.generatedColumn;
          if (segment.length > 1) {
            mapping.source = previousSource + segment[1];
            previousSource += segment[1];
            mapping.originalLine = previousOriginalLine + segment[2];
            previousOriginalLine = mapping.originalLine;
            mapping.originalLine += 1;
            mapping.originalColumn = previousOriginalColumn + segment[3];
            previousOriginalColumn = mapping.originalColumn;
            if (segment.length > 4) {
              mapping.name = previousName + segment[4];
              previousName += segment[4];
            }
          }
          generatedMappings.push(mapping);
          if (typeof mapping.originalLine === "number") {
            originalMappings.push(mapping);
          }
        }
      }
      quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
      this.__generatedMappings = generatedMappings;
      quickSort(originalMappings, util.compareByOriginalPositions);
      this.__originalMappings = originalMappings;
    };
    BasicSourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
      if (aNeedle[aLineName] <= 0) {
        throw new TypeError("Line must be greater than or equal to 1, got " + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError("Column must be greater than or equal to 0, got " + aNeedle[aColumnName]);
      }
      return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
    };
    BasicSourceMapConsumer.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
      for (var index = 0; index < this._generatedMappings.length; ++index) {
        var mapping = this._generatedMappings[index];
        if (index + 1 < this._generatedMappings.length) {
          var nextMapping = this._generatedMappings[index + 1];
          if (mapping.generatedLine === nextMapping.generatedLine) {
            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
            continue;
          }
        }
        mapping.lastGeneratedColumn = Infinity;
      }
    };
    BasicSourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(
        needle,
        this._generatedMappings,
        "generatedLine",
        "generatedColumn",
        util.compareByGeneratedPositionsDeflated,
        util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND)
      );
      if (index >= 0) {
        var mapping = this._generatedMappings[index];
        if (mapping.generatedLine === needle.generatedLine) {
          var source = util.getArg(mapping, "source", null);
          if (source !== null) {
            source = this._sources.at(source);
            if (this.sourceRoot != null) {
              source = util.join(this.sourceRoot, source);
            }
          }
          var name = util.getArg(mapping, "name", null);
          if (name !== null) {
            name = this._names.at(name);
          }
          return {
            source,
            line: util.getArg(mapping, "originalLine", null),
            column: util.getArg(mapping, "originalColumn", null),
            name
          };
        }
      }
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };
    BasicSourceMapConsumer.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
      if (!this.sourcesContent) {
        return false;
      }
      return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function(sc) {
        return sc == null;
      });
    };
    BasicSourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      if (!this.sourcesContent) {
        return null;
      }
      if (this.sourceRoot != null) {
        aSource = util.relative(this.sourceRoot, aSource);
      }
      if (this._sources.has(aSource)) {
        return this.sourcesContent[this._sources.indexOf(aSource)];
      }
      var url;
      if (this.sourceRoot != null && (url = util.urlParse(this.sourceRoot))) {
        var fileUriAbsPath = aSource.replace(/^file:\/\//, "");
        if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
        }
        if ((!url.path || url.path == "/") && this._sources.has("/" + aSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + aSource)];
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };
    BasicSourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
      var source = util.getArg(aArgs, "source");
      if (this.sourceRoot != null) {
        source = util.relative(this.sourceRoot, source);
      }
      if (!this._sources.has(source)) {
        return {
          line: null,
          column: null,
          lastColumn: null
        };
      }
      source = this._sources.indexOf(source);
      var needle = {
        source,
        originalLine: util.getArg(aArgs, "line"),
        originalColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND)
      );
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (mapping.source === needle.source) {
          return {
            line: util.getArg(mapping, "generatedLine", null),
            column: util.getArg(mapping, "generatedColumn", null),
            lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
          };
        }
      }
      return {
        line: null,
        column: null,
        lastColumn: null
      };
    };
    exports2.BasicSourceMapConsumer = BasicSourceMapConsumer;
    function IndexedSourceMapConsumer(aSourceMap) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ""));
      }
      var version = util.getArg(sourceMap, "version");
      var sections = util.getArg(sourceMap, "sections");
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      this._sources = new ArraySet();
      this._names = new ArraySet();
      var lastOffset = {
        line: -1,
        column: 0
      };
      this._sections = sections.map(function(s) {
        if (s.url) {
          throw new Error("Support for url field in sections not implemented.");
        }
        var offset = util.getArg(s, "offset");
        var offsetLine = util.getArg(offset, "line");
        var offsetColumn = util.getArg(offset, "column");
        if (offsetLine < lastOffset.line || offsetLine === lastOffset.line && offsetColumn < lastOffset.column) {
          throw new Error("Section offsets must be ordered and non-overlapping.");
        }
        lastOffset = offset;
        return {
          generatedOffset: {
            // The offset fields are 0-based, but we use 1-based indices when
            // encoding/decoding from VLQ.
            generatedLine: offsetLine + 1,
            generatedColumn: offsetColumn + 1
          },
          consumer: new SourceMapConsumer(util.getArg(s, "map"))
        };
      });
    }
    IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;
    IndexedSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(IndexedSourceMapConsumer.prototype, "sources", {
      get: function() {
        var sources = [];
        for (var i = 0; i < this._sections.length; i++) {
          for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
            sources.push(this._sections[i].consumer.sources[j]);
          }
        }
        return sources;
      }
    });
    IndexedSourceMapConsumer.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var sectionIndex = binarySearch.search(
        needle,
        this._sections,
        function(needle2, section2) {
          var cmp = needle2.generatedLine - section2.generatedOffset.generatedLine;
          if (cmp) {
            return cmp;
          }
          return needle2.generatedColumn - section2.generatedOffset.generatedColumn;
        }
      );
      var section = this._sections[sectionIndex];
      if (!section) {
        return {
          source: null,
          line: null,
          column: null,
          name: null
        };
      }
      return section.consumer.originalPositionFor({
        line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
        bias: aArgs.bias
      });
    };
    IndexedSourceMapConsumer.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
      return this._sections.every(function(s) {
        return s.consumer.hasContentsOfAllSources();
      });
    };
    IndexedSourceMapConsumer.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var content = section.consumer.sourceContentFor(aSource, true);
        if (content) {
          return content;
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };
    IndexedSourceMapConsumer.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        if (section.consumer.sources.indexOf(util.getArg(aArgs, "source")) === -1) {
          continue;
        }
        var generatedPosition = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition) {
          var ret = {
            line: generatedPosition.line + (section.generatedOffset.generatedLine - 1),
            column: generatedPosition.column + (section.generatedOffset.generatedLine === generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0)
          };
          return ret;
        }
      }
      return {
        line: null,
        column: null
      };
    };
    IndexedSourceMapConsumer.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      this.__generatedMappings = [];
      this.__originalMappings = [];
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for (var j = 0; j < sectionMappings.length; j++) {
          var mapping = sectionMappings[j];
          var source = section.consumer._sources.at(mapping.source);
          if (section.consumer.sourceRoot !== null) {
            source = util.join(section.consumer.sourceRoot, source);
          }
          this._sources.add(source);
          source = this._sources.indexOf(source);
          var name = section.consumer._names.at(mapping.name);
          this._names.add(name);
          name = this._names.indexOf(name);
          var adjustedMapping = {
            source,
            generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
            generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name
          };
          this.__generatedMappings.push(adjustedMapping);
          if (typeof adjustedMapping.originalLine === "number") {
            this.__originalMappings.push(adjustedMapping);
          }
        }
      }
      quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
      quickSort(this.__originalMappings, util.compareByOriginalPositions);
    };
    exports2.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/lib/source-node.js
var require_source_node = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/lib/source-node.js"(exports2) {
    "use strict";
    var SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    var util = require_util();
    var REGEX_NEWLINE = /(\r?\n)/;
    var NEWLINE_CODE = 10;
    var isSourceNode = "$$$isSourceNode$$$";
    function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
      this.children = [];
      this.sourceContents = {};
      this.line = aLine == null ? null : aLine;
      this.column = aColumn == null ? null : aColumn;
      this.source = aSource == null ? null : aSource;
      this.name = aName == null ? null : aName;
      this[isSourceNode] = true;
      if (aChunks != null) this.add(aChunks);
    }
    SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
      var node = new SourceNode();
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var remainingLinesIndex = 0;
      var shiftNextLine = function() {
        var lineContents = getNextLine();
        var newLine = getNextLine() || "";
        return lineContents + newLine;
        function getNextLine() {
          return remainingLinesIndex < remainingLines.length ? remainingLines[remainingLinesIndex++] : void 0;
        }
      };
      var lastGeneratedLine = 1, lastGeneratedColumn = 0;
      var lastMapping = null;
      aSourceMapConsumer.eachMapping(function(mapping) {
        if (lastMapping !== null) {
          if (lastGeneratedLine < mapping.generatedLine) {
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
          } else {
            var nextLine = remainingLines[remainingLinesIndex];
            var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
            remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            lastMapping = mapping;
            return;
          }
        }
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[remainingLinesIndex];
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      if (remainingLinesIndex < remainingLines.length) {
        if (lastMapping) {
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        node.add(remainingLines.splice(remainingLinesIndex).join(""));
      }
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aRelativePath != null) {
            sourceFile = util.join(aRelativePath, sourceFile);
          }
          node.setSourceContent(sourceFile, content);
        }
      });
      return node;
      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === void 0) {
          node.add(code);
        } else {
          var source = aRelativePath ? util.join(aRelativePath, mapping.source) : mapping.source;
          node.add(new SourceNode(
            mapping.originalLine,
            mapping.originalColumn,
            source,
            code,
            mapping.name
          ));
        }
      }
    };
    SourceNode.prototype.add = function SourceNode_add(aChunk) {
      if (Array.isArray(aChunk)) {
        aChunk.forEach(function(chunk) {
          this.add(chunk);
        }, this);
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        if (aChunk) {
          this.children.push(aChunk);
        }
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
      if (Array.isArray(aChunk)) {
        for (var i = aChunk.length - 1; i >= 0; i--) {
          this.prepend(aChunk[i]);
        }
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        this.children.unshift(aChunk);
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.walk = function SourceNode_walk(aFn) {
      var chunk;
      for (var i = 0, len = this.children.length; i < len; i++) {
        chunk = this.children[i];
        if (chunk[isSourceNode]) {
          chunk.walk(aFn);
        } else {
          if (chunk !== "") {
            aFn(chunk, {
              source: this.source,
              line: this.line,
              column: this.column,
              name: this.name
            });
          }
        }
      }
    };
    SourceNode.prototype.join = function SourceNode_join(aSep) {
      var newChildren;
      var i;
      var len = this.children.length;
      if (len > 0) {
        newChildren = [];
        for (i = 0; i < len - 1; i++) {
          newChildren.push(this.children[i]);
          newChildren.push(aSep);
        }
        newChildren.push(this.children[i]);
        this.children = newChildren;
      }
      return this;
    };
    SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
      var lastChild = this.children[this.children.length - 1];
      if (lastChild[isSourceNode]) {
        lastChild.replaceRight(aPattern, aReplacement);
      } else if (typeof lastChild === "string") {
        this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
      } else {
        this.children.push("".replace(aPattern, aReplacement));
      }
      return this;
    };
    SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };
    SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
      for (var i = 0, len = this.children.length; i < len; i++) {
        if (this.children[i][isSourceNode]) {
          this.children[i].walkSourceContents(aFn);
        }
      }
      var sources = Object.keys(this.sourceContents);
      for (var i = 0, len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };
    SourceNode.prototype.toString = function SourceNode_toString() {
      var str = "";
      this.walk(function(chunk) {
        str += chunk;
      });
      return str;
    };
    SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
      var generated = {
        code: "",
        line: 1,
        column: 0
      };
      var map = new SourceMapGenerator(aArgs);
      var sourceMappingActive = false;
      var lastOriginalSource = null;
      var lastOriginalLine = null;
      var lastOriginalColumn = null;
      var lastOriginalName = null;
      this.walk(function(chunk, original) {
        generated.code += chunk;
        if (original.source !== null && original.line !== null && original.column !== null) {
          if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
          lastOriginalSource = original.source;
          lastOriginalLine = original.line;
          lastOriginalColumn = original.column;
          lastOriginalName = original.name;
          sourceMappingActive = true;
        } else if (sourceMappingActive) {
          map.addMapping({
            generated: {
              line: generated.line,
              column: generated.column
            }
          });
          lastOriginalSource = null;
          sourceMappingActive = false;
        }
        for (var idx = 0, length = chunk.length; idx < length; idx++) {
          if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
            generated.line++;
            generated.column = 0;
            if (idx + 1 === length) {
              lastOriginalSource = null;
              sourceMappingActive = false;
            } else if (sourceMappingActive) {
              map.addMapping({
                source: original.source,
                original: {
                  line: original.line,
                  column: original.column
                },
                generated: {
                  line: generated.line,
                  column: generated.column
                },
                name: original.name
              });
            }
          } else {
            generated.column++;
          }
        }
      });
      this.walkSourceContents(function(sourceFile, sourceContent) {
        map.setSourceContent(sourceFile, sourceContent);
      });
      return { code: generated.code, map };
    };
    exports2.SourceNode = SourceNode;
  }
});

// ../babel-plugin-react-compiler/node_modules/source-map/source-map.js
var require_source_map = __commonJS({
  "../babel-plugin-react-compiler/node_modules/source-map/source-map.js"(exports2) {
    "use strict";
    exports2.SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    exports2.SourceMapConsumer = require_source_map_consumer().SourceMapConsumer;
    exports2.SourceNode = require_source_node().SourceNode;
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/source-map.js
var require_source_map2 = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/source-map.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    function _sourceMap() {
      const data = _interopRequireDefault(require_source_map());
      _sourceMap = function() {
        return data;
      };
      return data;
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var SourceMap = class {
      constructor(opts, code) {
        this._cachedMap = null;
        this._code = code;
        this._opts = opts;
        this._rawMappings = [];
      }
      get() {
        if (!this._cachedMap) {
          const map = this._cachedMap = new (_sourceMap()).default.SourceMapGenerator({
            sourceRoot: this._opts.sourceRoot
          });
          const code = this._code;
          if (typeof code === "string") {
            map.setSourceContent(this._opts.sourceFileName, code);
          } else if (typeof code === "object") {
            Object.keys(code).forEach((sourceFileName) => {
              map.setSourceContent(sourceFileName, code[sourceFileName]);
            });
          }
          this._rawMappings.forEach(map.addMapping, map);
        }
        return this._cachedMap.toJSON();
      }
      getRawMappings() {
        return this._rawMappings.slice();
      }
      mark(generatedLine, generatedColumn, line, column, identifierName, filename, force) {
        if (this._lastGenLine !== generatedLine && line === null) return;
        if (!force && this._lastGenLine === generatedLine && this._lastSourceLine === line && this._lastSourceColumn === column) {
          return;
        }
        this._cachedMap = null;
        this._lastGenLine = generatedLine;
        this._lastSourceLine = line;
        this._lastSourceColumn = column;
        this._rawMappings.push({
          name: identifierName || void 0,
          generated: {
            line: generatedLine,
            column: generatedColumn
          },
          source: line == null ? void 0 : filename || this._opts.sourceFileName,
          original: line == null ? void 0 : {
            line,
            column
          }
        });
      }
    };
    exports2.default = SourceMap;
  }
});

// ../../node_modules/lodash/_trimmedEndIndex.js
var require_trimmedEndIndex = __commonJS({
  "../../node_modules/lodash/_trimmedEndIndex.js"(exports2, module2) {
    "use strict";
    var reWhitespace = /\s/;
    function trimmedEndIndex(string) {
      var index = string.length;
      while (index-- && reWhitespace.test(string.charAt(index))) {
      }
      return index;
    }
    module2.exports = trimmedEndIndex;
  }
});

// ../../node_modules/lodash/_baseTrim.js
var require_baseTrim = __commonJS({
  "../../node_modules/lodash/_baseTrim.js"(exports2, module2) {
    "use strict";
    var trimmedEndIndex = require_trimmedEndIndex();
    var reTrimStart = /^\s+/;
    function baseTrim(string) {
      return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, "") : string;
    }
    module2.exports = baseTrim;
  }
});

// ../../node_modules/lodash/isObject.js
var require_isObject = __commonJS({
  "../../node_modules/lodash/isObject.js"(exports2, module2) {
    "use strict";
    function isObject(value) {
      var type = typeof value;
      return value != null && (type == "object" || type == "function");
    }
    module2.exports = isObject;
  }
});

// ../../node_modules/lodash/_freeGlobal.js
var require_freeGlobal = __commonJS({
  "../../node_modules/lodash/_freeGlobal.js"(exports2, module2) {
    "use strict";
    var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
    module2.exports = freeGlobal;
  }
});

// ../../node_modules/lodash/_root.js
var require_root = __commonJS({
  "../../node_modules/lodash/_root.js"(exports2, module2) {
    "use strict";
    var freeGlobal = require_freeGlobal();
    var freeSelf = typeof self == "object" && self && self.Object === Object && self;
    var root = freeGlobal || freeSelf || Function("return this")();
    module2.exports = root;
  }
});

// ../../node_modules/lodash/_Symbol.js
var require_Symbol = __commonJS({
  "../../node_modules/lodash/_Symbol.js"(exports2, module2) {
    "use strict";
    var root = require_root();
    var Symbol2 = root.Symbol;
    module2.exports = Symbol2;
  }
});

// ../../node_modules/lodash/_getRawTag.js
var require_getRawTag = __commonJS({
  "../../node_modules/lodash/_getRawTag.js"(exports2, module2) {
    "use strict";
    var Symbol2 = require_Symbol();
    var objectProto = Object.prototype;
    var hasOwnProperty3 = objectProto.hasOwnProperty;
    var nativeObjectToString = objectProto.toString;
    var symToStringTag = Symbol2 ? Symbol2.toStringTag : void 0;
    function getRawTag(value) {
      var isOwn = hasOwnProperty3.call(value, symToStringTag), tag = value[symToStringTag];
      try {
        value[symToStringTag] = void 0;
        var unmasked = true;
      } catch (e) {
      }
      var result = nativeObjectToString.call(value);
      if (unmasked) {
        if (isOwn) {
          value[symToStringTag] = tag;
        } else {
          delete value[symToStringTag];
        }
      }
      return result;
    }
    module2.exports = getRawTag;
  }
});

// ../../node_modules/lodash/_objectToString.js
var require_objectToString = __commonJS({
  "../../node_modules/lodash/_objectToString.js"(exports2, module2) {
    "use strict";
    var objectProto = Object.prototype;
    var nativeObjectToString = objectProto.toString;
    function objectToString(value) {
      return nativeObjectToString.call(value);
    }
    module2.exports = objectToString;
  }
});

// ../../node_modules/lodash/_baseGetTag.js
var require_baseGetTag = __commonJS({
  "../../node_modules/lodash/_baseGetTag.js"(exports2, module2) {
    "use strict";
    var Symbol2 = require_Symbol();
    var getRawTag = require_getRawTag();
    var objectToString = require_objectToString();
    var nullTag = "[object Null]";
    var undefinedTag = "[object Undefined]";
    var symToStringTag = Symbol2 ? Symbol2.toStringTag : void 0;
    function baseGetTag(value) {
      if (value == null) {
        return value === void 0 ? undefinedTag : nullTag;
      }
      return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString(value);
    }
    module2.exports = baseGetTag;
  }
});

// ../../node_modules/lodash/isObjectLike.js
var require_isObjectLike = __commonJS({
  "../../node_modules/lodash/isObjectLike.js"(exports2, module2) {
    "use strict";
    function isObjectLike(value) {
      return value != null && typeof value == "object";
    }
    module2.exports = isObjectLike;
  }
});

// ../../node_modules/lodash/isSymbol.js
var require_isSymbol = __commonJS({
  "../../node_modules/lodash/isSymbol.js"(exports2, module2) {
    "use strict";
    var baseGetTag = require_baseGetTag();
    var isObjectLike = require_isObjectLike();
    var symbolTag = "[object Symbol]";
    function isSymbol(value) {
      return typeof value == "symbol" || isObjectLike(value) && baseGetTag(value) == symbolTag;
    }
    module2.exports = isSymbol;
  }
});

// ../../node_modules/lodash/toNumber.js
var require_toNumber = __commonJS({
  "../../node_modules/lodash/toNumber.js"(exports2, module2) {
    "use strict";
    var baseTrim = require_baseTrim();
    var isObject = require_isObject();
    var isSymbol = require_isSymbol();
    var NAN = 0 / 0;
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    var reIsBinary = /^0b[01]+$/i;
    var reIsOctal = /^0o[0-7]+$/i;
    var freeParseInt = parseInt;
    function toNumber(value) {
      if (typeof value == "number") {
        return value;
      }
      if (isSymbol(value)) {
        return NAN;
      }
      if (isObject(value)) {
        var other = typeof value.valueOf == "function" ? value.valueOf() : value;
        value = isObject(other) ? other + "" : other;
      }
      if (typeof value != "string") {
        return value === 0 ? value : +value;
      }
      value = baseTrim(value);
      var isBinary = reIsBinary.test(value);
      return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
    }
    module2.exports = toNumber;
  }
});

// ../../node_modules/lodash/toFinite.js
var require_toFinite = __commonJS({
  "../../node_modules/lodash/toFinite.js"(exports2, module2) {
    "use strict";
    var toNumber = require_toNumber();
    var INFINITY = 1 / 0;
    var MAX_INTEGER = 17976931348623157e292;
    function toFinite(value) {
      if (!value) {
        return value === 0 ? value : 0;
      }
      value = toNumber(value);
      if (value === INFINITY || value === -INFINITY) {
        var sign = value < 0 ? -1 : 1;
        return sign * MAX_INTEGER;
      }
      return value === value ? value : 0;
    }
    module2.exports = toFinite;
  }
});

// ../../node_modules/lodash/toInteger.js
var require_toInteger = __commonJS({
  "../../node_modules/lodash/toInteger.js"(exports2, module2) {
    "use strict";
    var toFinite = require_toFinite();
    function toInteger(value) {
      var result = toFinite(value), remainder = result % 1;
      return result === result ? remainder ? result - remainder : result : 0;
    }
    module2.exports = toInteger;
  }
});

// ../../node_modules/lodash/isInteger.js
var require_isInteger = __commonJS({
  "../../node_modules/lodash/isInteger.js"(exports2, module2) {
    "use strict";
    var toInteger = require_toInteger();
    function isInteger(value) {
      return typeof value == "number" && value == toInteger(value);
    }
    module2.exports = isInteger;
  }
});

// ../../node_modules/lodash/_baseRepeat.js
var require_baseRepeat = __commonJS({
  "../../node_modules/lodash/_baseRepeat.js"(exports2, module2) {
    "use strict";
    var MAX_SAFE_INTEGER = 9007199254740991;
    var nativeFloor = Math.floor;
    function baseRepeat(string, n) {
      var result = "";
      if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
        return result;
      }
      do {
        if (n % 2) {
          result += string;
        }
        n = nativeFloor(n / 2);
        if (n) {
          string += string;
        }
      } while (n);
      return result;
    }
    module2.exports = baseRepeat;
  }
});

// ../../node_modules/lodash/eq.js
var require_eq = __commonJS({
  "../../node_modules/lodash/eq.js"(exports2, module2) {
    "use strict";
    function eq(value, other) {
      return value === other || value !== value && other !== other;
    }
    module2.exports = eq;
  }
});

// ../../node_modules/lodash/isFunction.js
var require_isFunction = __commonJS({
  "../../node_modules/lodash/isFunction.js"(exports2, module2) {
    "use strict";
    var baseGetTag = require_baseGetTag();
    var isObject = require_isObject();
    var asyncTag = "[object AsyncFunction]";
    var funcTag = "[object Function]";
    var genTag = "[object GeneratorFunction]";
    var proxyTag = "[object Proxy]";
    function isFunction(value) {
      if (!isObject(value)) {
        return false;
      }
      var tag = baseGetTag(value);
      return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
    }
    module2.exports = isFunction;
  }
});

// ../../node_modules/lodash/isLength.js
var require_isLength = __commonJS({
  "../../node_modules/lodash/isLength.js"(exports2, module2) {
    "use strict";
    var MAX_SAFE_INTEGER = 9007199254740991;
    function isLength(value) {
      return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    module2.exports = isLength;
  }
});

// ../../node_modules/lodash/isArrayLike.js
var require_isArrayLike = __commonJS({
  "../../node_modules/lodash/isArrayLike.js"(exports2, module2) {
    "use strict";
    var isFunction = require_isFunction();
    var isLength = require_isLength();
    function isArrayLike(value) {
      return value != null && isLength(value.length) && !isFunction(value);
    }
    module2.exports = isArrayLike;
  }
});

// ../../node_modules/lodash/_isIndex.js
var require_isIndex = __commonJS({
  "../../node_modules/lodash/_isIndex.js"(exports2, module2) {
    "use strict";
    var MAX_SAFE_INTEGER = 9007199254740991;
    var reIsUint = /^(?:0|[1-9]\d*)$/;
    function isIndex(value, length) {
      var type = typeof value;
      length = length == null ? MAX_SAFE_INTEGER : length;
      return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
    }
    module2.exports = isIndex;
  }
});

// ../../node_modules/lodash/_isIterateeCall.js
var require_isIterateeCall = __commonJS({
  "../../node_modules/lodash/_isIterateeCall.js"(exports2, module2) {
    "use strict";
    var eq = require_eq();
    var isArrayLike = require_isArrayLike();
    var isIndex = require_isIndex();
    var isObject = require_isObject();
    function isIterateeCall(value, index, object) {
      if (!isObject(object)) {
        return false;
      }
      var type = typeof index;
      if (type == "number" ? isArrayLike(object) && isIndex(index, object.length) : type == "string" && index in object) {
        return eq(object[index], value);
      }
      return false;
    }
    module2.exports = isIterateeCall;
  }
});

// ../../node_modules/lodash/_arrayMap.js
var require_arrayMap = __commonJS({
  "../../node_modules/lodash/_arrayMap.js"(exports2, module2) {
    "use strict";
    function arrayMap(array, iteratee) {
      var index = -1, length = array == null ? 0 : array.length, result = Array(length);
      while (++index < length) {
        result[index] = iteratee(array[index], index, array);
      }
      return result;
    }
    module2.exports = arrayMap;
  }
});

// ../../node_modules/lodash/isArray.js
var require_isArray = __commonJS({
  "../../node_modules/lodash/isArray.js"(exports2, module2) {
    "use strict";
    var isArray = Array.isArray;
    module2.exports = isArray;
  }
});

// ../../node_modules/lodash/_baseToString.js
var require_baseToString = __commonJS({
  "../../node_modules/lodash/_baseToString.js"(exports2, module2) {
    "use strict";
    var Symbol2 = require_Symbol();
    var arrayMap = require_arrayMap();
    var isArray = require_isArray();
    var isSymbol = require_isSymbol();
    var INFINITY = 1 / 0;
    var symbolProto = Symbol2 ? Symbol2.prototype : void 0;
    var symbolToString = symbolProto ? symbolProto.toString : void 0;
    function baseToString(value) {
      if (typeof value == "string") {
        return value;
      }
      if (isArray(value)) {
        return arrayMap(value, baseToString) + "";
      }
      if (isSymbol(value)) {
        return symbolToString ? symbolToString.call(value) : "";
      }
      var result = value + "";
      return result == "0" && 1 / value == -INFINITY ? "-0" : result;
    }
    module2.exports = baseToString;
  }
});

// ../../node_modules/lodash/toString.js
var require_toString = __commonJS({
  "../../node_modules/lodash/toString.js"(exports2, module2) {
    "use strict";
    var baseToString = require_baseToString();
    function toString(value) {
      return value == null ? "" : baseToString(value);
    }
    module2.exports = toString;
  }
});

// ../../node_modules/lodash/repeat.js
var require_repeat = __commonJS({
  "../../node_modules/lodash/repeat.js"(exports2, module2) {
    "use strict";
    var baseRepeat = require_baseRepeat();
    var isIterateeCall = require_isIterateeCall();
    var toInteger = require_toInteger();
    var toString = require_toString();
    function repeat(string, n, guard) {
      if (guard ? isIterateeCall(string, n, guard) : n === void 0) {
        n = 1;
      } else {
        n = toInteger(n);
      }
      return baseRepeat(toString(string), n);
    }
    module2.exports = repeat;
  }
});

// ../../node_modules/trim-right/index.js
var require_trim_right = __commonJS({
  "../../node_modules/trim-right/index.js"(exports2, module2) {
    "use strict";
    module2.exports = function(str) {
      var tail = str.length;
      while (/[\s\uFEFF\u00A0]/.test(str[tail - 1])) {
        tail--;
      }
      return str.slice(0, tail);
    };
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/buffer.js
var require_buffer = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/buffer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    function _trimRight() {
      const data = _interopRequireDefault(require_trim_right());
      _trimRight = function() {
        return data;
      };
      return data;
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var SPACES_RE = /^[ \t]+$/;
    var Buffer2 = class {
      constructor(map) {
        this._map = null;
        this._buf = [];
        this._last = "";
        this._queue = [];
        this._position = {
          line: 1,
          column: 0
        };
        this._sourcePosition = {
          identifierName: null,
          line: null,
          column: null,
          filename: null
        };
        this._disallowedPop = null;
        this._map = map;
      }
      get() {
        this._flush();
        const map = this._map;
        const result = {
          code: (0, _trimRight().default)(this._buf.join("")),
          map: null,
          rawMappings: map && map.getRawMappings()
        };
        if (map) {
          Object.defineProperty(result, "map", {
            configurable: true,
            enumerable: true,
            get() {
              return this.map = map.get();
            },
            set(value) {
              Object.defineProperty(this, "map", {
                value,
                writable: true
              });
            }
          });
        }
        return result;
      }
      append(str) {
        this._flush();
        const {
          line,
          column,
          filename,
          identifierName,
          force
        } = this._sourcePosition;
        this._append(str, line, column, identifierName, filename, force);
      }
      queue(str) {
        if (str === "\n") {
          while (this._queue.length > 0 && SPACES_RE.test(this._queue[0][0])) {
            this._queue.shift();
          }
        }
        const {
          line,
          column,
          filename,
          identifierName,
          force
        } = this._sourcePosition;
        this._queue.unshift([str, line, column, identifierName, filename, force]);
      }
      _flush() {
        let item;
        while (item = this._queue.pop()) this._append(...item);
      }
      _append(str, line, column, identifierName, filename, force) {
        if (this._map && str[0] !== "\n") {
          this._map.mark(this._position.line, this._position.column, line, column, identifierName, filename, force);
        }
        this._buf.push(str);
        this._last = str[str.length - 1];
        for (let i = 0; i < str.length; i++) {
          if (str[i] === "\n") {
            this._position.line++;
            this._position.column = 0;
          } else {
            this._position.column++;
          }
        }
      }
      removeTrailingNewline() {
        if (this._queue.length > 0 && this._queue[0][0] === "\n") {
          this._queue.shift();
        }
      }
      removeLastSemicolon() {
        if (this._queue.length > 0 && this._queue[0][0] === ";") {
          this._queue.shift();
        }
      }
      endsWith(suffix) {
        if (suffix.length === 1) {
          let last;
          if (this._queue.length > 0) {
            const str = this._queue[0][0];
            last = str[str.length - 1];
          } else {
            last = this._last;
          }
          return last === suffix;
        }
        const end = this._last + this._queue.reduce((acc, item) => item[0] + acc, "");
        if (suffix.length <= end.length) {
          return end.slice(-suffix.length) === suffix;
        }
        return false;
      }
      hasContent() {
        return this._queue.length > 0 || !!this._last;
      }
      exactSource(loc, cb) {
        this.source("start", loc, true);
        cb();
        this.source("end", loc);
        this._disallowPop("start", loc);
      }
      source(prop, loc, force) {
        if (prop && !loc) return;
        this._normalizePosition(prop, loc, this._sourcePosition, force);
      }
      withSource(prop, loc, cb) {
        if (!this._map) return cb();
        const originalLine = this._sourcePosition.line;
        const originalColumn = this._sourcePosition.column;
        const originalFilename = this._sourcePosition.filename;
        const originalIdentifierName = this._sourcePosition.identifierName;
        this.source(prop, loc);
        cb();
        if ((!this._sourcePosition.force || this._sourcePosition.line !== originalLine || this._sourcePosition.column !== originalColumn || this._sourcePosition.filename !== originalFilename) && (!this._disallowedPop || this._disallowedPop.line !== originalLine || this._disallowedPop.column !== originalColumn || this._disallowedPop.filename !== originalFilename)) {
          this._sourcePosition.line = originalLine;
          this._sourcePosition.column = originalColumn;
          this._sourcePosition.filename = originalFilename;
          this._sourcePosition.identifierName = originalIdentifierName;
          this._sourcePosition.force = false;
          this._disallowedPop = null;
        }
      }
      _disallowPop(prop, loc) {
        if (prop && !loc) return;
        this._disallowedPop = this._normalizePosition(prop, loc);
      }
      _normalizePosition(prop, loc, targetObj, force) {
        const pos = loc ? loc[prop] : null;
        if (targetObj === void 0) {
          targetObj = {
            identifierName: null,
            line: null,
            column: null,
            filename: null,
            force: false
          };
        }
        const origLine = targetObj.line;
        const origColumn = targetObj.column;
        const origFilename = targetObj.filename;
        targetObj.identifierName = prop === "start" && loc && loc.identifierName || null;
        targetObj.line = pos ? pos.line : null;
        targetObj.column = pos ? pos.column : null;
        targetObj.filename = loc && loc.filename || null;
        if (force || targetObj.line !== origLine || targetObj.column !== origColumn || targetObj.filename !== origFilename) {
          targetObj.force = force;
        }
        return targetObj;
      }
      getCurrentColumn() {
        const extra = this._queue.reduce((acc, item) => item[0] + acc, "");
        const lastIndex = extra.lastIndexOf("\n");
        return lastIndex === -1 ? this._position.column + extra.length : extra.length - 1 - lastIndex;
      }
      getCurrentLine() {
        const extra = this._queue.reduce((acc, item) => item[0] + acc, "");
        let count = 0;
        for (let i = 0; i < extra.length; i++) {
          if (extra[i] === "\n") count++;
        }
        return this._position.line + count;
      }
    };
    exports2.default = Buffer2;
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/node/whitespace.js
var require_whitespace = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/node/whitespace.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.list = exports2.nodes = void 0;
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function crawl(node, state = {}) {
      if (t5().isMemberExpression(node)) {
        crawl(node.object, state);
        if (node.computed) crawl(node.property, state);
      } else if (t5().isBinary(node) || t5().isAssignmentExpression(node)) {
        crawl(node.left, state);
        crawl(node.right, state);
      } else if (t5().isCallExpression(node)) {
        state.hasCall = true;
        crawl(node.callee, state);
      } else if (t5().isFunction(node)) {
        state.hasFunction = true;
      } else if (t5().isIdentifier(node)) {
        state.hasHelper = state.hasHelper || isHelper(node.callee);
      }
      return state;
    }
    function isHelper(node) {
      if (t5().isMemberExpression(node)) {
        return isHelper(node.object) || isHelper(node.property);
      } else if (t5().isIdentifier(node)) {
        return node.name === "require" || node.name[0] === "_";
      } else if (t5().isCallExpression(node)) {
        return isHelper(node.callee);
      } else if (t5().isBinary(node) || t5().isAssignmentExpression(node)) {
        return t5().isIdentifier(node.left) && isHelper(node.left) || isHelper(node.right);
      } else {
        return false;
      }
    }
    function isType(node) {
      return t5().isLiteral(node) || t5().isObjectExpression(node) || t5().isArrayExpression(node) || t5().isIdentifier(node) || t5().isMemberExpression(node);
    }
    var nodes = {
      AssignmentExpression(node) {
        const state = crawl(node.right);
        if (state.hasCall && state.hasHelper || state.hasFunction) {
          return {
            before: state.hasFunction,
            after: true
          };
        }
      },
      SwitchCase(node, parent) {
        return {
          before: node.consequent.length || parent.cases[0] === node,
          after: !node.consequent.length && parent.cases[parent.cases.length - 1] === node
        };
      },
      LogicalExpression(node) {
        if (t5().isFunction(node.left) || t5().isFunction(node.right)) {
          return {
            after: true
          };
        }
      },
      Literal(node) {
        if (node.value === "use strict") {
          return {
            after: true
          };
        }
      },
      CallExpression(node) {
        if (t5().isFunction(node.callee) || isHelper(node)) {
          return {
            before: true,
            after: true
          };
        }
      },
      VariableDeclaration(node) {
        for (let i = 0; i < node.declarations.length; i++) {
          const declar = node.declarations[i];
          let enabled = isHelper(declar.id) && !isType(declar.init);
          if (!enabled) {
            const state = crawl(declar.init);
            enabled = isHelper(declar.init) && state.hasCall || state.hasFunction;
          }
          if (enabled) {
            return {
              before: true,
              after: true
            };
          }
        }
      },
      IfStatement(node) {
        if (t5().isBlockStatement(node.consequent)) {
          return {
            before: true,
            after: true
          };
        }
      }
    };
    exports2.nodes = nodes;
    nodes.ObjectProperty = nodes.ObjectTypeProperty = nodes.ObjectMethod = function(node, parent) {
      if (parent.properties[0] === node) {
        return {
          before: true
        };
      }
    };
    nodes.ObjectTypeCallProperty = function(node, parent) {
      if (parent.callProperties[0] === node && (!parent.properties || !parent.properties.length)) {
        return {
          before: true
        };
      }
    };
    nodes.ObjectTypeIndexer = function(node, parent) {
      if (parent.indexers[0] === node && (!parent.properties || !parent.properties.length) && (!parent.callProperties || !parent.callProperties.length)) {
        return {
          before: true
        };
      }
    };
    nodes.ObjectTypeInternalSlot = function(node, parent) {
      if (parent.internalSlots[0] === node && (!parent.properties || !parent.properties.length) && (!parent.callProperties || !parent.callProperties.length) && (!parent.indexers || !parent.indexers.length)) {
        return {
          before: true
        };
      }
    };
    var list = {
      VariableDeclaration(node) {
        return node.declarations.map((decl) => decl.init);
      },
      ArrayExpression(node) {
        return node.elements;
      },
      ObjectExpression(node) {
        return node.properties;
      }
    };
    exports2.list = list;
    [["Function", true], ["Class", true], ["Loop", true], ["LabeledStatement", true], ["SwitchStatement", true], ["TryStatement", true]].forEach(function([type, amounts]) {
      if (typeof amounts === "boolean") {
        amounts = {
          after: amounts,
          before: amounts
        };
      }
      [type].concat(t5().FLIPPED_ALIAS_KEYS[type] || []).forEach(function(type2) {
        nodes[type2] = function() {
          return amounts;
        };
      });
    });
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/node/parentheses.js
var require_parentheses = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/node/parentheses.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.FunctionTypeAnnotation = exports2.NullableTypeAnnotation = NullableTypeAnnotation;
    exports2.UpdateExpression = UpdateExpression;
    exports2.ObjectExpression = ObjectExpression;
    exports2.DoExpression = DoExpression;
    exports2.Binary = Binary;
    exports2.IntersectionTypeAnnotation = exports2.UnionTypeAnnotation = UnionTypeAnnotation;
    exports2.TSAsExpression = TSAsExpression;
    exports2.TSTypeAssertion = TSTypeAssertion;
    exports2.BinaryExpression = BinaryExpression;
    exports2.SequenceExpression = SequenceExpression;
    exports2.AwaitExpression = exports2.YieldExpression = YieldExpression;
    exports2.ClassExpression = ClassExpression;
    exports2.UnaryLike = UnaryLike;
    exports2.FunctionExpression = FunctionExpression7;
    exports2.ArrowFunctionExpression = ArrowFunctionExpression;
    exports2.ConditionalExpression = ConditionalExpression;
    exports2.OptionalMemberExpression = OptionalMemberExpression;
    exports2.AssignmentExpression = AssignmentExpression;
    exports2.NewExpression = NewExpression2;
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    var PRECEDENCE = {
      "||": 0,
      "&&": 1,
      "|": 2,
      "^": 3,
      "&": 4,
      "==": 5,
      "===": 5,
      "!=": 5,
      "!==": 5,
      "<": 6,
      ">": 6,
      "<=": 6,
      ">=": 6,
      in: 6,
      instanceof: 6,
      ">>": 7,
      "<<": 7,
      ">>>": 7,
      "+": 8,
      "-": 8,
      "*": 9,
      "/": 9,
      "%": 9,
      "**": 10
    };
    var isClassExtendsClause = (node, parent) => (t5().isClassDeclaration(parent) || t5().isClassExpression(parent)) && parent.superClass === node;
    function NullableTypeAnnotation(node, parent) {
      return t5().isArrayTypeAnnotation(parent);
    }
    function UpdateExpression(node, parent) {
      return t5().isMemberExpression(parent, {
        object: node
      }) || t5().isCallExpression(parent, {
        callee: node
      }) || t5().isNewExpression(parent, {
        callee: node
      }) || isClassExtendsClause(node, parent);
    }
    function ObjectExpression(node, parent, printStack) {
      return isFirstInStatement(printStack, {
        considerArrow: true
      });
    }
    function DoExpression(node, parent, printStack) {
      return isFirstInStatement(printStack);
    }
    function Binary(node, parent) {
      if (node.operator === "**" && t5().isBinaryExpression(parent, {
        operator: "**"
      })) {
        return parent.left === node;
      }
      if (isClassExtendsClause(node, parent)) {
        return true;
      }
      if ((t5().isCallExpression(parent) || t5().isNewExpression(parent)) && parent.callee === node || t5().isUnaryLike(parent) || t5().isMemberExpression(parent) && parent.object === node || t5().isAwaitExpression(parent)) {
        return true;
      }
      if (t5().isBinary(parent)) {
        const parentOp = parent.operator;
        const parentPos = PRECEDENCE[parentOp];
        const nodeOp = node.operator;
        const nodePos = PRECEDENCE[nodeOp];
        if (parentPos === nodePos && parent.right === node && !t5().isLogicalExpression(parent) || parentPos > nodePos) {
          return true;
        }
      }
      return false;
    }
    function UnionTypeAnnotation(node, parent) {
      return t5().isArrayTypeAnnotation(parent) || t5().isNullableTypeAnnotation(parent) || t5().isIntersectionTypeAnnotation(parent) || t5().isUnionTypeAnnotation(parent);
    }
    function TSAsExpression() {
      return true;
    }
    function TSTypeAssertion() {
      return true;
    }
    function BinaryExpression(node, parent) {
      return node.operator === "in" && (t5().isVariableDeclarator(parent) || t5().isFor(parent));
    }
    function SequenceExpression(node, parent) {
      if (t5().isForStatement(parent) || t5().isThrowStatement(parent) || t5().isReturnStatement(parent) || t5().isIfStatement(parent) && parent.test === node || t5().isWhileStatement(parent) && parent.test === node || t5().isForInStatement(parent) && parent.right === node || t5().isSwitchStatement(parent) && parent.discriminant === node || t5().isExpressionStatement(parent) && parent.expression === node) {
        return false;
      }
      return true;
    }
    function YieldExpression(node, parent) {
      return t5().isBinary(parent) || t5().isUnaryLike(parent) || t5().isCallExpression(parent) || t5().isMemberExpression(parent) || t5().isNewExpression(parent) || t5().isAwaitExpression(parent) && t5().isYieldExpression(node) || t5().isConditionalExpression(parent) && node === parent.test || isClassExtendsClause(node, parent);
    }
    function ClassExpression(node, parent, printStack) {
      return isFirstInStatement(printStack, {
        considerDefaultExports: true
      });
    }
    function UnaryLike(node, parent) {
      return t5().isMemberExpression(parent, {
        object: node
      }) || t5().isCallExpression(parent, {
        callee: node
      }) || t5().isNewExpression(parent, {
        callee: node
      }) || t5().isBinaryExpression(parent, {
        operator: "**",
        left: node
      }) || isClassExtendsClause(node, parent);
    }
    function FunctionExpression7(node, parent, printStack) {
      return isFirstInStatement(printStack, {
        considerDefaultExports: true
      });
    }
    function ArrowFunctionExpression(node, parent) {
      return t5().isExportDeclaration(parent) || ConditionalExpression(node, parent);
    }
    function ConditionalExpression(node, parent) {
      if (t5().isUnaryLike(parent) || t5().isBinary(parent) || t5().isConditionalExpression(parent, {
        test: node
      }) || t5().isAwaitExpression(parent) || t5().isOptionalMemberExpression(parent) || t5().isTaggedTemplateExpression(parent) || t5().isTSTypeAssertion(parent) || t5().isTSAsExpression(parent)) {
        return true;
      }
      return UnaryLike(node, parent);
    }
    function OptionalMemberExpression(node, parent) {
      return t5().isCallExpression(parent) || t5().isMemberExpression(parent);
    }
    function AssignmentExpression(node) {
      if (t5().isObjectPattern(node.left)) {
        return true;
      } else {
        return ConditionalExpression(...arguments);
      }
    }
    function NewExpression2(node, parent) {
      return isClassExtendsClause(node, parent);
    }
    function isFirstInStatement(printStack, {
      considerArrow = false,
      considerDefaultExports = false
    } = {}) {
      let i = printStack.length - 1;
      let node = printStack[i];
      i--;
      let parent = printStack[i];
      while (i > 0) {
        if (t5().isExpressionStatement(parent, {
          expression: node
        }) || t5().isTaggedTemplateExpression(parent) || considerDefaultExports && t5().isExportDefaultDeclaration(parent, {
          declaration: node
        }) || considerArrow && t5().isArrowFunctionExpression(parent, {
          body: node
        })) {
          return true;
        }
        if (t5().isCallExpression(parent, {
          callee: node
        }) || t5().isSequenceExpression(parent) && parent.expressions[0] === node || t5().isMemberExpression(parent, {
          object: node
        }) || t5().isConditional(parent, {
          test: node
        }) || t5().isBinary(parent, {
          left: node
        }) || t5().isAssignmentExpression(parent, {
          left: node
        })) {
          node = parent;
          i--;
          parent = printStack[i];
        } else {
          return false;
        }
      }
      return false;
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/node/index.js
var require_node = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/node/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.needsWhitespace = needsWhitespace;
    exports2.needsWhitespaceBefore = needsWhitespaceBefore;
    exports2.needsWhitespaceAfter = needsWhitespaceAfter;
    exports2.needsParens = needsParens;
    var whitespace = _interopRequireWildcard(require_whitespace());
    var parens = _interopRequireWildcard(require_parentheses());
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function expandAliases(obj) {
      const newObj = {};
      function add(type, func) {
        const fn = newObj[type];
        newObj[type] = fn ? function(node, parent, stack) {
          const result = fn(node, parent, stack);
          return result == null ? func(node, parent, stack) : result;
        } : func;
      }
      for (const type of Object.keys(obj)) {
        const aliases = t5().FLIPPED_ALIAS_KEYS[type];
        if (aliases) {
          for (const alias of aliases) {
            add(alias, obj[type]);
          }
        } else {
          add(type, obj[type]);
        }
      }
      return newObj;
    }
    var expandedParens = expandAliases(parens);
    var expandedWhitespaceNodes = expandAliases(whitespace.nodes);
    var expandedWhitespaceList = expandAliases(whitespace.list);
    function find(obj, node, parent, printStack) {
      const fn = obj[node.type];
      return fn ? fn(node, parent, printStack) : null;
    }
    function isOrHasCallExpression(node) {
      if (t5().isCallExpression(node)) {
        return true;
      }
      if (t5().isMemberExpression(node)) {
        return isOrHasCallExpression(node.object) || !node.computed && isOrHasCallExpression(node.property);
      } else {
        return false;
      }
    }
    function needsWhitespace(node, parent, type) {
      if (!node) return 0;
      if (t5().isExpressionStatement(node)) {
        node = node.expression;
      }
      let linesInfo = find(expandedWhitespaceNodes, node, parent);
      if (!linesInfo) {
        const items = find(expandedWhitespaceList, node, parent);
        if (items) {
          for (let i = 0; i < items.length; i++) {
            linesInfo = needsWhitespace(items[i], node, type);
            if (linesInfo) break;
          }
        }
      }
      if (typeof linesInfo === "object" && linesInfo !== null) {
        return linesInfo[type] || 0;
      }
      return 0;
    }
    function needsWhitespaceBefore(node, parent) {
      return needsWhitespace(node, parent, "before");
    }
    function needsWhitespaceAfter(node, parent) {
      return needsWhitespace(node, parent, "after");
    }
    function needsParens(node, parent, printStack) {
      if (!parent) return false;
      if (t5().isNewExpression(parent) && parent.callee === node) {
        if (isOrHasCallExpression(node)) return true;
      }
      return find(expandedParens, node, parent, printStack);
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/template-literals.js
var require_template_literals = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/template-literals.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.TaggedTemplateExpression = TaggedTemplateExpression;
    exports2.TemplateElement = TemplateElement;
    exports2.TemplateLiteral = TemplateLiteral;
    function TaggedTemplateExpression(node) {
      this.print(node.tag, node);
      this.print(node.typeParameters, node);
      this.print(node.quasi, node);
    }
    function TemplateElement(node, parent) {
      const isFirst = parent.quasis[0] === node;
      const isLast = parent.quasis[parent.quasis.length - 1] === node;
      const value = (isFirst ? "`" : "}") + node.value.raw + (isLast ? "`" : "${");
      this.token(value);
    }
    function TemplateLiteral(node) {
      const quasis = node.quasis;
      for (let i = 0; i < quasis.length; i++) {
        this.print(quasis[i], node);
        if (i + 1 < quasis.length) {
          this.print(node.expressions[i], node);
        }
      }
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/expressions.js
var require_expressions = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/expressions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.UnaryExpression = UnaryExpression;
    exports2.DoExpression = DoExpression;
    exports2.ParenthesizedExpression = ParenthesizedExpression;
    exports2.UpdateExpression = UpdateExpression;
    exports2.ConditionalExpression = ConditionalExpression;
    exports2.NewExpression = NewExpression2;
    exports2.SequenceExpression = SequenceExpression;
    exports2.ThisExpression = ThisExpression;
    exports2.Super = Super;
    exports2.Decorator = Decorator;
    exports2.OptionalMemberExpression = OptionalMemberExpression;
    exports2.OptionalCallExpression = OptionalCallExpression;
    exports2.CallExpression = CallExpression5;
    exports2.Import = Import;
    exports2.EmptyStatement = EmptyStatement;
    exports2.ExpressionStatement = ExpressionStatement;
    exports2.AssignmentPattern = AssignmentPattern;
    exports2.LogicalExpression = exports2.BinaryExpression = exports2.AssignmentExpression = AssignmentExpression;
    exports2.BindExpression = BindExpression;
    exports2.MemberExpression = MemberExpression;
    exports2.MetaProperty = MetaProperty;
    exports2.PrivateName = PrivateName;
    exports2.AwaitExpression = exports2.YieldExpression = void 0;
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    var n = _interopRequireWildcard(require_node());
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function UnaryExpression(node) {
      if (node.operator === "void" || node.operator === "delete" || node.operator === "typeof" || node.operator === "throw") {
        this.word(node.operator);
        this.space();
      } else {
        this.token(node.operator);
      }
      this.print(node.argument, node);
    }
    function DoExpression(node) {
      this.word("do");
      this.space();
      this.print(node.body, node);
    }
    function ParenthesizedExpression(node) {
      this.token("(");
      this.print(node.expression, node);
      this.token(")");
    }
    function UpdateExpression(node) {
      if (node.prefix) {
        this.token(node.operator);
        this.print(node.argument, node);
      } else {
        this.startTerminatorless(true);
        this.print(node.argument, node);
        this.endTerminatorless();
        this.token(node.operator);
      }
    }
    function ConditionalExpression(node) {
      this.print(node.test, node);
      this.space();
      this.token("?");
      this.space();
      this.print(node.consequent, node);
      this.space();
      this.token(":");
      this.space();
      this.print(node.alternate, node);
    }
    function NewExpression2(node, parent) {
      this.word("new");
      this.space();
      this.print(node.callee, node);
      if (this.format.minified && node.arguments.length === 0 && !node.optional && !t5().isCallExpression(parent, {
        callee: node
      }) && !t5().isMemberExpression(parent) && !t5().isNewExpression(parent)) {
        return;
      }
      this.print(node.typeArguments, node);
      this.print(node.typeParameters, node);
      if (node.optional) {
        this.token("?.");
      }
      this.token("(");
      this.printList(node.arguments, node);
      this.token(")");
    }
    function SequenceExpression(node) {
      this.printList(node.expressions, node);
    }
    function ThisExpression() {
      this.word("this");
    }
    function Super() {
      this.word("super");
    }
    function Decorator(node) {
      this.token("@");
      this.print(node.expression, node);
      this.newline();
    }
    function OptionalMemberExpression(node) {
      this.print(node.object, node);
      if (!node.computed && t5().isMemberExpression(node.property)) {
        throw new TypeError("Got a MemberExpression for MemberExpression property");
      }
      let computed = node.computed;
      if (t5().isLiteral(node.property) && typeof node.property.value === "number") {
        computed = true;
      }
      if (node.optional) {
        this.token("?.");
      }
      if (computed) {
        this.token("[");
        this.print(node.property, node);
        this.token("]");
      } else {
        if (!node.optional) {
          this.token(".");
        }
        this.print(node.property, node);
      }
    }
    function OptionalCallExpression(node) {
      this.print(node.callee, node);
      this.print(node.typeArguments, node);
      this.print(node.typeParameters, node);
      if (node.optional) {
        this.token("?.");
      }
      this.token("(");
      this.printList(node.arguments, node);
      this.token(")");
    }
    function CallExpression5(node) {
      this.print(node.callee, node);
      this.print(node.typeArguments, node);
      this.print(node.typeParameters, node);
      this.token("(");
      this.printList(node.arguments, node);
      this.token(")");
    }
    function Import() {
      this.word("import");
    }
    function buildYieldAwait(keyword) {
      return function(node) {
        this.word(keyword);
        if (node.delegate) {
          this.token("*");
        }
        if (node.argument) {
          this.space();
          const terminatorState = this.startTerminatorless();
          this.print(node.argument, node);
          this.endTerminatorless(terminatorState);
        }
      };
    }
    var YieldExpression = buildYieldAwait("yield");
    exports2.YieldExpression = YieldExpression;
    var AwaitExpression = buildYieldAwait("await");
    exports2.AwaitExpression = AwaitExpression;
    function EmptyStatement() {
      this.semicolon(true);
    }
    function ExpressionStatement(node) {
      this.print(node.expression, node);
      this.semicolon();
    }
    function AssignmentPattern(node) {
      this.print(node.left, node);
      if (node.left.optional) this.token("?");
      this.print(node.left.typeAnnotation, node);
      this.space();
      this.token("=");
      this.space();
      this.print(node.right, node);
    }
    function AssignmentExpression(node, parent) {
      const parens = this.inForStatementInitCounter && node.operator === "in" && !n.needsParens(node, parent);
      if (parens) {
        this.token("(");
      }
      this.print(node.left, node);
      this.space();
      if (node.operator === "in" || node.operator === "instanceof") {
        this.word(node.operator);
      } else {
        this.token(node.operator);
      }
      this.space();
      this.print(node.right, node);
      if (parens) {
        this.token(")");
      }
    }
    function BindExpression(node) {
      this.print(node.object, node);
      this.token("::");
      this.print(node.callee, node);
    }
    function MemberExpression(node) {
      this.print(node.object, node);
      if (!node.computed && t5().isMemberExpression(node.property)) {
        throw new TypeError("Got a MemberExpression for MemberExpression property");
      }
      let computed = node.computed;
      if (t5().isLiteral(node.property) && typeof node.property.value === "number") {
        computed = true;
      }
      if (computed) {
        this.token("[");
        this.print(node.property, node);
        this.token("]");
      } else {
        this.token(".");
        this.print(node.property, node);
      }
    }
    function MetaProperty(node) {
      this.print(node.meta, node);
      this.token(".");
      this.print(node.property, node);
    }
    function PrivateName(node) {
      this.token("#");
      this.print(node.id, node);
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/statements.js
var require_statements = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/statements.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.WithStatement = WithStatement;
    exports2.IfStatement = IfStatement;
    exports2.ForStatement = ForStatement;
    exports2.WhileStatement = WhileStatement;
    exports2.DoWhileStatement = DoWhileStatement;
    exports2.LabeledStatement = LabeledStatement;
    exports2.TryStatement = TryStatement;
    exports2.CatchClause = CatchClause;
    exports2.SwitchStatement = SwitchStatement;
    exports2.SwitchCase = SwitchCase;
    exports2.DebuggerStatement = DebuggerStatement;
    exports2.VariableDeclaration = VariableDeclaration;
    exports2.VariableDeclarator = VariableDeclarator;
    exports2.ThrowStatement = exports2.BreakStatement = exports2.ReturnStatement = exports2.ContinueStatement = exports2.ForOfStatement = exports2.ForInStatement = void 0;
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function WithStatement(node) {
      this.word("with");
      this.space();
      this.token("(");
      this.print(node.object, node);
      this.token(")");
      this.printBlock(node);
    }
    function IfStatement(node) {
      this.word("if");
      this.space();
      this.token("(");
      this.print(node.test, node);
      this.token(")");
      this.space();
      const needsBlock = node.alternate && t5().isIfStatement(getLastStatement(node.consequent));
      if (needsBlock) {
        this.token("{");
        this.newline();
        this.indent();
      }
      this.printAndIndentOnComments(node.consequent, node);
      if (needsBlock) {
        this.dedent();
        this.newline();
        this.token("}");
      }
      if (node.alternate) {
        if (this.endsWith("}")) this.space();
        this.word("else");
        this.space();
        this.printAndIndentOnComments(node.alternate, node);
      }
    }
    function getLastStatement(statement) {
      if (!t5().isStatement(statement.body)) return statement;
      return getLastStatement(statement.body);
    }
    function ForStatement(node) {
      this.word("for");
      this.space();
      this.token("(");
      this.inForStatementInitCounter++;
      this.print(node.init, node);
      this.inForStatementInitCounter--;
      this.token(";");
      if (node.test) {
        this.space();
        this.print(node.test, node);
      }
      this.token(";");
      if (node.update) {
        this.space();
        this.print(node.update, node);
      }
      this.token(")");
      this.printBlock(node);
    }
    function WhileStatement(node) {
      this.word("while");
      this.space();
      this.token("(");
      this.print(node.test, node);
      this.token(")");
      this.printBlock(node);
    }
    var buildForXStatement = function(op) {
      return function(node) {
        this.word("for");
        this.space();
        if (op === "of" && node.await) {
          this.word("await");
          this.space();
        }
        this.token("(");
        this.print(node.left, node);
        this.space();
        this.word(op);
        this.space();
        this.print(node.right, node);
        this.token(")");
        this.printBlock(node);
      };
    };
    var ForInStatement = buildForXStatement("in");
    exports2.ForInStatement = ForInStatement;
    var ForOfStatement = buildForXStatement("of");
    exports2.ForOfStatement = ForOfStatement;
    function DoWhileStatement(node) {
      this.word("do");
      this.space();
      this.print(node.body, node);
      this.space();
      this.word("while");
      this.space();
      this.token("(");
      this.print(node.test, node);
      this.token(")");
      this.semicolon();
    }
    function buildLabelStatement(prefix, key = "label") {
      return function(node) {
        this.word(prefix);
        const label = node[key];
        if (label) {
          this.space();
          const isLabel = key == "label";
          const terminatorState = this.startTerminatorless(isLabel);
          this.print(label, node);
          this.endTerminatorless(terminatorState);
        }
        this.semicolon();
      };
    }
    var ContinueStatement = buildLabelStatement("continue");
    exports2.ContinueStatement = ContinueStatement;
    var ReturnStatement = buildLabelStatement("return", "argument");
    exports2.ReturnStatement = ReturnStatement;
    var BreakStatement = buildLabelStatement("break");
    exports2.BreakStatement = BreakStatement;
    var ThrowStatement = buildLabelStatement("throw", "argument");
    exports2.ThrowStatement = ThrowStatement;
    function LabeledStatement(node) {
      this.print(node.label, node);
      this.token(":");
      this.space();
      this.print(node.body, node);
    }
    function TryStatement(node) {
      this.word("try");
      this.space();
      this.print(node.block, node);
      this.space();
      if (node.handlers) {
        this.print(node.handlers[0], node);
      } else {
        this.print(node.handler, node);
      }
      if (node.finalizer) {
        this.space();
        this.word("finally");
        this.space();
        this.print(node.finalizer, node);
      }
    }
    function CatchClause(node) {
      this.word("catch");
      this.space();
      if (node.param) {
        this.token("(");
        this.print(node.param, node);
        this.token(")");
        this.space();
      }
      this.print(node.body, node);
    }
    function SwitchStatement(node) {
      this.word("switch");
      this.space();
      this.token("(");
      this.print(node.discriminant, node);
      this.token(")");
      this.space();
      this.token("{");
      this.printSequence(node.cases, node, {
        indent: true,
        addNewlines(leading, cas) {
          if (!leading && node.cases[node.cases.length - 1] === cas) return -1;
        }
      });
      this.token("}");
    }
    function SwitchCase(node) {
      if (node.test) {
        this.word("case");
        this.space();
        this.print(node.test, node);
        this.token(":");
      } else {
        this.word("default");
        this.token(":");
      }
      if (node.consequent.length) {
        this.newline();
        this.printSequence(node.consequent, node, {
          indent: true
        });
      }
    }
    function DebuggerStatement() {
      this.word("debugger");
      this.semicolon();
    }
    function variableDeclarationIndent() {
      this.token(",");
      this.newline();
      if (this.endsWith("\n")) for (let i = 0; i < 4; i++) this.space(true);
    }
    function constDeclarationIndent() {
      this.token(",");
      this.newline();
      if (this.endsWith("\n")) for (let i = 0; i < 6; i++) this.space(true);
    }
    function VariableDeclaration(node, parent) {
      if (node.declare) {
        this.word("declare");
        this.space();
      }
      this.word(node.kind);
      this.space();
      let hasInits = false;
      if (!t5().isFor(parent)) {
        for (const declar of node.declarations) {
          if (declar.init) {
            hasInits = true;
          }
        }
      }
      let separator;
      if (hasInits) {
        separator = node.kind === "const" ? constDeclarationIndent : variableDeclarationIndent;
      }
      this.printList(node.declarations, node, {
        separator
      });
      if (t5().isFor(parent)) {
        if (parent.left === node || parent.init === node) return;
      }
      this.semicolon();
    }
    function VariableDeclarator(node) {
      this.print(node.id, node);
      if (node.definite) this.token("!");
      this.print(node.id.typeAnnotation, node);
      if (node.init) {
        this.space();
        this.token("=");
        this.space();
        this.print(node.init, node);
      }
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/classes.js
var require_classes = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/classes.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.ClassExpression = exports2.ClassDeclaration = ClassDeclaration;
    exports2.ClassBody = ClassBody;
    exports2.ClassProperty = ClassProperty;
    exports2.ClassPrivateProperty = ClassPrivateProperty;
    exports2.ClassMethod = ClassMethod;
    exports2.ClassPrivateMethod = ClassPrivateMethod;
    exports2._classMethodHead = _classMethodHead;
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function ClassDeclaration(node, parent) {
      if (!this.format.decoratorsBeforeExport || !t5().isExportDefaultDeclaration(parent) && !t5().isExportNamedDeclaration(parent)) {
        this.printJoin(node.decorators, node);
      }
      if (node.declare) {
        this.word("declare");
        this.space();
      }
      if (node.abstract) {
        this.word("abstract");
        this.space();
      }
      this.word("class");
      if (node.id) {
        this.space();
        this.print(node.id, node);
      }
      this.print(node.typeParameters, node);
      if (node.superClass) {
        this.space();
        this.word("extends");
        this.space();
        this.print(node.superClass, node);
        this.print(node.superTypeParameters, node);
      }
      if (node.implements) {
        this.space();
        this.word("implements");
        this.space();
        this.printList(node.implements, node);
      }
      this.space();
      this.print(node.body, node);
    }
    function ClassBody(node) {
      this.token("{");
      this.printInnerComments(node);
      if (node.body.length === 0) {
        this.token("}");
      } else {
        this.newline();
        this.indent();
        this.printSequence(node.body, node);
        this.dedent();
        if (!this.endsWith("\n")) this.newline();
        this.rightBrace();
      }
    }
    function ClassProperty(node) {
      this.printJoin(node.decorators, node);
      if (node.accessibility) {
        this.word(node.accessibility);
        this.space();
      }
      if (node.static) {
        this.word("static");
        this.space();
      }
      if (node.abstract) {
        this.word("abstract");
        this.space();
      }
      if (node.readonly) {
        this.word("readonly");
        this.space();
      }
      if (node.computed) {
        this.token("[");
        this.print(node.key, node);
        this.token("]");
      } else {
        this._variance(node);
        this.print(node.key, node);
      }
      if (node.optional) {
        this.token("?");
      }
      if (node.definite) {
        this.token("!");
      }
      this.print(node.typeAnnotation, node);
      if (node.value) {
        this.space();
        this.token("=");
        this.space();
        this.print(node.value, node);
      }
      this.semicolon();
    }
    function ClassPrivateProperty(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this.print(node.key, node);
      this.print(node.typeAnnotation, node);
      if (node.value) {
        this.space();
        this.token("=");
        this.space();
        this.print(node.value, node);
      }
      this.semicolon();
    }
    function ClassMethod(node) {
      this._classMethodHead(node);
      this.space();
      this.print(node.body, node);
    }
    function ClassPrivateMethod(node) {
      this._classMethodHead(node);
      this.space();
      this.print(node.body, node);
    }
    function _classMethodHead(node) {
      this.printJoin(node.decorators, node);
      if (node.accessibility) {
        this.word(node.accessibility);
        this.space();
      }
      if (node.abstract) {
        this.word("abstract");
        this.space();
      }
      if (node.static) {
        this.word("static");
        this.space();
      }
      this._methodHead(node);
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/methods.js
var require_methods = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/methods.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2._params = _params;
    exports2._parameters = _parameters;
    exports2._param = _param;
    exports2._methodHead = _methodHead;
    exports2._predicate = _predicate;
    exports2._functionHead = _functionHead;
    exports2.FunctionDeclaration = exports2.FunctionExpression = FunctionExpression7;
    exports2.ArrowFunctionExpression = ArrowFunctionExpression;
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function _params(node) {
      this.print(node.typeParameters, node);
      this.token("(");
      this._parameters(node.params, node);
      this.token(")");
      this.print(node.returnType, node);
    }
    function _parameters(parameters, parent) {
      for (let i = 0; i < parameters.length; i++) {
        this._param(parameters[i], parent);
        if (i < parameters.length - 1) {
          this.token(",");
          this.space();
        }
      }
    }
    function _param(parameter, parent) {
      this.printJoin(parameter.decorators, parameter);
      this.print(parameter, parent);
      if (parameter.optional) this.token("?");
      this.print(parameter.typeAnnotation, parameter);
    }
    function _methodHead(node) {
      const kind = node.kind;
      const key = node.key;
      if (kind === "get" || kind === "set") {
        this.word(kind);
        this.space();
      }
      if (node.async) {
        this.word("async");
        this.space();
      }
      if (kind === "method" || kind === "init") {
        if (node.generator) {
          this.token("*");
        }
      }
      if (node.computed) {
        this.token("[");
        this.print(key, node);
        this.token("]");
      } else {
        this.print(key, node);
      }
      if (node.optional) {
        this.token("?");
      }
      this._params(node);
    }
    function _predicate(node) {
      if (node.predicate) {
        if (!node.returnType) {
          this.token(":");
        }
        this.space();
        this.print(node.predicate, node);
      }
    }
    function _functionHead(node) {
      if (node.async) {
        this.word("async");
        this.space();
      }
      this.word("function");
      if (node.generator) this.token("*");
      this.space();
      if (node.id) {
        this.print(node.id, node);
      }
      this._params(node);
      this._predicate(node);
    }
    function FunctionExpression7(node) {
      this._functionHead(node);
      this.space();
      this.print(node.body, node);
    }
    function ArrowFunctionExpression(node) {
      if (node.async) {
        this.word("async");
        this.space();
      }
      const firstParam = node.params[0];
      if (node.params.length === 1 && t5().isIdentifier(firstParam) && !hasTypes(node, firstParam)) {
        if (this.format.retainLines && node.loc && node.body.loc && node.loc.start.line < node.body.loc.start.line) {
          this.token("(");
          if (firstParam.loc && firstParam.loc.start.line > node.loc.start.line) {
            this.indent();
            this.print(firstParam, node);
            this.dedent();
            this._catchUp("start", node.body.loc);
          } else {
            this.print(firstParam, node);
          }
          this.token(")");
        } else {
          this.print(firstParam, node);
        }
      } else {
        this._params(node);
      }
      this._predicate(node);
      this.space();
      this.token("=>");
      this.space();
      this.print(node.body, node);
    }
    function hasTypes(node, param) {
      return node.typeParameters || node.returnType || param.typeAnnotation || param.optional || param.trailingComments;
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/modules.js
var require_modules = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/modules.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.ImportSpecifier = ImportSpecifier;
    exports2.ImportDefaultSpecifier = ImportDefaultSpecifier;
    exports2.ExportDefaultSpecifier = ExportDefaultSpecifier;
    exports2.ExportSpecifier = ExportSpecifier;
    exports2.ExportNamespaceSpecifier = ExportNamespaceSpecifier;
    exports2.ExportAllDeclaration = ExportAllDeclaration;
    exports2.ExportNamedDeclaration = ExportNamedDeclaration;
    exports2.ExportDefaultDeclaration = ExportDefaultDeclaration;
    exports2.ImportDeclaration = ImportDeclaration;
    exports2.ImportNamespaceSpecifier = ImportNamespaceSpecifier;
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function ImportSpecifier(node) {
      if (node.importKind === "type" || node.importKind === "typeof") {
        this.word(node.importKind);
        this.space();
      }
      this.print(node.imported, node);
      if (node.local && node.local.name !== node.imported.name) {
        this.space();
        this.word("as");
        this.space();
        this.print(node.local, node);
      }
    }
    function ImportDefaultSpecifier(node) {
      this.print(node.local, node);
    }
    function ExportDefaultSpecifier(node) {
      this.print(node.exported, node);
    }
    function ExportSpecifier(node) {
      this.print(node.local, node);
      if (node.exported && node.local.name !== node.exported.name) {
        this.space();
        this.word("as");
        this.space();
        this.print(node.exported, node);
      }
    }
    function ExportNamespaceSpecifier(node) {
      this.token("*");
      this.space();
      this.word("as");
      this.space();
      this.print(node.exported, node);
    }
    function ExportAllDeclaration(node) {
      this.word("export");
      this.space();
      if (node.exportKind === "type") {
        this.word("type");
        this.space();
      }
      this.token("*");
      this.space();
      this.word("from");
      this.space();
      this.print(node.source, node);
      this.semicolon();
    }
    function ExportNamedDeclaration(node) {
      if (this.format.decoratorsBeforeExport && t5().isClassDeclaration(node.declaration)) {
        this.printJoin(node.declaration.decorators, node);
      }
      this.word("export");
      this.space();
      ExportDeclaration.apply(this, arguments);
    }
    function ExportDefaultDeclaration(node) {
      if (this.format.decoratorsBeforeExport && t5().isClassDeclaration(node.declaration)) {
        this.printJoin(node.declaration.decorators, node);
      }
      this.word("export");
      this.space();
      this.word("default");
      this.space();
      ExportDeclaration.apply(this, arguments);
    }
    function ExportDeclaration(node) {
      if (node.declaration) {
        const declar = node.declaration;
        this.print(declar, node);
        if (!t5().isStatement(declar)) this.semicolon();
      } else {
        if (node.exportKind === "type") {
          this.word("type");
          this.space();
        }
        const specifiers = node.specifiers.slice(0);
        let hasSpecial = false;
        while (true) {
          const first = specifiers[0];
          if (t5().isExportDefaultSpecifier(first) || t5().isExportNamespaceSpecifier(first)) {
            hasSpecial = true;
            this.print(specifiers.shift(), node);
            if (specifiers.length) {
              this.token(",");
              this.space();
            }
          } else {
            break;
          }
        }
        if (specifiers.length || !specifiers.length && !hasSpecial) {
          this.token("{");
          if (specifiers.length) {
            this.space();
            this.printList(specifiers, node);
            this.space();
          }
          this.token("}");
        }
        if (node.source) {
          this.space();
          this.word("from");
          this.space();
          this.print(node.source, node);
        }
        this.semicolon();
      }
    }
    function ImportDeclaration(node) {
      this.word("import");
      this.space();
      if (node.importKind === "type" || node.importKind === "typeof") {
        this.word(node.importKind);
        this.space();
      }
      const specifiers = node.specifiers.slice(0);
      if (specifiers && specifiers.length) {
        while (true) {
          const first = specifiers[0];
          if (t5().isImportDefaultSpecifier(first) || t5().isImportNamespaceSpecifier(first)) {
            this.print(specifiers.shift(), node);
            if (specifiers.length) {
              this.token(",");
              this.space();
            }
          } else {
            break;
          }
        }
        if (specifiers.length) {
          this.token("{");
          this.space();
          this.printList(specifiers, node);
          this.space();
          this.token("}");
        }
        this.space();
        this.word("from");
        this.space();
      }
      this.print(node.source, node);
      this.semicolon();
    }
    function ImportNamespaceSpecifier(node) {
      this.token("*");
      this.space();
      this.word("as");
      this.space();
      this.print(node.local, node);
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/jsesc/jsesc.js
var require_jsesc = __commonJS({
  "../babel-plugin-react-compiler/node_modules/jsesc/jsesc.js"(exports2, module2) {
    "use strict";
    var object = {};
    var hasOwnProperty3 = object.hasOwnProperty;
    var forOwn = (object2, callback) => {
      for (const key in object2) {
        if (hasOwnProperty3.call(object2, key)) {
          callback(key, object2[key]);
        }
      }
    };
    var extend = (destination, source) => {
      if (!source) {
        return destination;
      }
      forOwn(source, (key, value) => {
        destination[key] = value;
      });
      return destination;
    };
    var forEach = (array, callback) => {
      const length = array.length;
      let index = -1;
      while (++index < length) {
        callback(array[index]);
      }
    };
    var toString = object.toString;
    var isArray = Array.isArray;
    var isBuffer = Buffer.isBuffer;
    var isObject = (value) => {
      return toString.call(value) == "[object Object]";
    };
    var isString = (value) => {
      return typeof value == "string" || toString.call(value) == "[object String]";
    };
    var isNumber = (value) => {
      return typeof value == "number" || toString.call(value) == "[object Number]";
    };
    var isFunction = (value) => {
      return typeof value == "function";
    };
    var isMap = (value) => {
      return toString.call(value) == "[object Map]";
    };
    var isSet = (value) => {
      return toString.call(value) == "[object Set]";
    };
    var singleEscapes = {
      '"': '\\"',
      "'": "\\'",
      "\\": "\\\\",
      "\b": "\\b",
      "\f": "\\f",
      "\n": "\\n",
      "\r": "\\r",
      "	": "\\t"
      // `\v` is omitted intentionally, because in IE < 9, '\v' == 'v'.
      // '\v': '\\x0B'
    };
    var regexSingleEscape = /["'\\\b\f\n\r\t]/;
    var regexDigit = /[0-9]/;
    var regexWhitelist = /[ !#-&\(-\[\]-_a-~]/;
    var jsesc = (argument, options) => {
      const increaseIndentation = () => {
        oldIndent = indent;
        ++options.indentLevel;
        indent = options.indent.repeat(options.indentLevel);
      };
      const defaults = {
        "escapeEverything": false,
        "minimal": false,
        "isScriptContext": false,
        "quotes": "single",
        "wrap": false,
        "es6": false,
        "json": false,
        "compact": true,
        "lowercaseHex": false,
        "numbers": "decimal",
        "indent": "	",
        "indentLevel": 0,
        "__inline1__": false,
        "__inline2__": false
      };
      const json = options && options.json;
      if (json) {
        defaults.quotes = "double";
        defaults.wrap = true;
      }
      options = extend(defaults, options);
      if (options.quotes != "single" && options.quotes != "double" && options.quotes != "backtick") {
        options.quotes = "single";
      }
      const quote = options.quotes == "double" ? '"' : options.quotes == "backtick" ? "`" : "'";
      const compact = options.compact;
      const lowercaseHex = options.lowercaseHex;
      let indent = options.indent.repeat(options.indentLevel);
      let oldIndent = "";
      const inline1 = options.__inline1__;
      const inline2 = options.__inline2__;
      const newLine = compact ? "" : "\n";
      let result;
      let isEmpty = true;
      const useBinNumbers = options.numbers == "binary";
      const useOctNumbers = options.numbers == "octal";
      const useDecNumbers = options.numbers == "decimal";
      const useHexNumbers = options.numbers == "hexadecimal";
      if (json && argument && isFunction(argument.toJSON)) {
        argument = argument.toJSON();
      }
      if (!isString(argument)) {
        if (isMap(argument)) {
          if (argument.size == 0) {
            return "new Map()";
          }
          if (!compact) {
            options.__inline1__ = true;
            options.__inline2__ = false;
          }
          return "new Map(" + jsesc(Array.from(argument), options) + ")";
        }
        if (isSet(argument)) {
          if (argument.size == 0) {
            return "new Set()";
          }
          return "new Set(" + jsesc(Array.from(argument), options) + ")";
        }
        if (isBuffer(argument)) {
          if (argument.length == 0) {
            return "Buffer.from([])";
          }
          return "Buffer.from(" + jsesc(Array.from(argument), options) + ")";
        }
        if (isArray(argument)) {
          result = [];
          options.wrap = true;
          if (inline1) {
            options.__inline1__ = false;
            options.__inline2__ = true;
          }
          if (!inline2) {
            increaseIndentation();
          }
          forEach(argument, (value) => {
            isEmpty = false;
            if (inline2) {
              options.__inline2__ = false;
            }
            result.push(
              (compact || inline2 ? "" : indent) + jsesc(value, options)
            );
          });
          if (isEmpty) {
            return "[]";
          }
          if (inline2) {
            return "[" + result.join(", ") + "]";
          }
          return "[" + newLine + result.join("," + newLine) + newLine + (compact ? "" : oldIndent) + "]";
        } else if (isNumber(argument)) {
          if (json) {
            return JSON.stringify(argument);
          }
          if (useDecNumbers) {
            return String(argument);
          }
          if (useHexNumbers) {
            let hexadecimal = argument.toString(16);
            if (!lowercaseHex) {
              hexadecimal = hexadecimal.toUpperCase();
            }
            return "0x" + hexadecimal;
          }
          if (useBinNumbers) {
            return "0b" + argument.toString(2);
          }
          if (useOctNumbers) {
            return "0o" + argument.toString(8);
          }
        } else if (!isObject(argument)) {
          if (json) {
            return JSON.stringify(argument) || "null";
          }
          return String(argument);
        } else {
          result = [];
          options.wrap = true;
          increaseIndentation();
          forOwn(argument, (key, value) => {
            isEmpty = false;
            result.push(
              (compact ? "" : indent) + jsesc(key, options) + ":" + (compact ? "" : " ") + jsesc(value, options)
            );
          });
          if (isEmpty) {
            return "{}";
          }
          return "{" + newLine + result.join("," + newLine) + newLine + (compact ? "" : oldIndent) + "}";
        }
      }
      const string = argument;
      let index = -1;
      const length = string.length;
      result = "";
      while (++index < length) {
        const character = string.charAt(index);
        if (options.es6) {
          const first = string.charCodeAt(index);
          if (
            // check if it’s the start of a surrogate pair
            first >= 55296 && first <= 56319 && // high surrogate
            length > index + 1
          ) {
            const second = string.charCodeAt(index + 1);
            if (second >= 56320 && second <= 57343) {
              const codePoint = (first - 55296) * 1024 + second - 56320 + 65536;
              let hexadecimal2 = codePoint.toString(16);
              if (!lowercaseHex) {
                hexadecimal2 = hexadecimal2.toUpperCase();
              }
              result += "\\u{" + hexadecimal2 + "}";
              ++index;
              continue;
            }
          }
        }
        if (!options.escapeEverything) {
          if (regexWhitelist.test(character)) {
            result += character;
            continue;
          }
          if (character == '"') {
            result += quote == character ? '\\"' : character;
            continue;
          }
          if (character == "`") {
            result += quote == character ? "\\`" : character;
            continue;
          }
          if (character == "'") {
            result += quote == character ? "\\'" : character;
            continue;
          }
        }
        if (character == "\0" && !json && !regexDigit.test(string.charAt(index + 1))) {
          result += "\\0";
          continue;
        }
        if (regexSingleEscape.test(character)) {
          result += singleEscapes[character];
          continue;
        }
        const charCode = character.charCodeAt(0);
        if (options.minimal && charCode != 8232 && charCode != 8233) {
          result += character;
          continue;
        }
        let hexadecimal = charCode.toString(16);
        if (!lowercaseHex) {
          hexadecimal = hexadecimal.toUpperCase();
        }
        const longhand = hexadecimal.length > 2 || json;
        const escaped = "\\" + (longhand ? "u" : "x") + ("0000" + hexadecimal).slice(longhand ? -4 : -2);
        result += escaped;
        continue;
      }
      if (options.wrap) {
        result = quote + result + quote;
      }
      if (quote == "`") {
        result = result.replace(/\$\{/g, "\\${");
      }
      if (options.isScriptContext) {
        return result.replace(/<\/(script|style)/gi, "<\\/$1").replace(/<!--/g, json ? "\\u003C!--" : "\\x3C!--");
      }
      return result;
    };
    jsesc.version = "2.5.2";
    module2.exports = jsesc;
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/types.js
var require_types = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/types.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.Identifier = Identifier28;
    exports2.SpreadElement = exports2.RestElement = RestElement;
    exports2.ObjectPattern = exports2.ObjectExpression = ObjectExpression;
    exports2.ObjectMethod = ObjectMethod3;
    exports2.ObjectProperty = ObjectProperty4;
    exports2.ArrayPattern = exports2.ArrayExpression = ArrayExpression5;
    exports2.RegExpLiteral = RegExpLiteral;
    exports2.BooleanLiteral = BooleanLiteral;
    exports2.NullLiteral = NullLiteral;
    exports2.NumericLiteral = NumericLiteral;
    exports2.StringLiteral = StringLiteral;
    exports2.BigIntLiteral = BigIntLiteral;
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    function _jsesc() {
      const data = _interopRequireDefault(require_jsesc());
      _jsesc = function() {
        return data;
      };
      return data;
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function Identifier28(node) {
      this.exactSource(node.loc, () => {
        this.word(node.name);
      });
    }
    function RestElement(node) {
      this.token("...");
      this.print(node.argument, node);
    }
    function ObjectExpression(node) {
      const props = node.properties;
      this.token("{");
      this.printInnerComments(node);
      if (props.length) {
        this.space();
        this.printList(props, node, {
          indent: true,
          statement: true
        });
        this.space();
      }
      this.token("}");
    }
    function ObjectMethod3(node) {
      this.printJoin(node.decorators, node);
      this._methodHead(node);
      this.space();
      this.print(node.body, node);
    }
    function ObjectProperty4(node) {
      this.printJoin(node.decorators, node);
      if (node.computed) {
        this.token("[");
        this.print(node.key, node);
        this.token("]");
      } else {
        if (t5().isAssignmentPattern(node.value) && t5().isIdentifier(node.key) && node.key.name === node.value.left.name) {
          this.print(node.value, node);
          return;
        }
        this.print(node.key, node);
        if (node.shorthand && t5().isIdentifier(node.key) && t5().isIdentifier(node.value) && node.key.name === node.value.name) {
          return;
        }
      }
      this.token(":");
      this.space();
      this.print(node.value, node);
    }
    function ArrayExpression5(node) {
      const elems = node.elements;
      const len = elems.length;
      this.token("[");
      this.printInnerComments(node);
      for (let i = 0; i < elems.length; i++) {
        const elem = elems[i];
        if (elem) {
          if (i > 0) this.space();
          this.print(elem, node);
          if (i < len - 1) this.token(",");
        } else {
          this.token(",");
        }
      }
      this.token("]");
    }
    function RegExpLiteral(node) {
      this.word(`/${node.pattern}/${node.flags}`);
    }
    function BooleanLiteral(node) {
      this.word(node.value ? "true" : "false");
    }
    function NullLiteral() {
      this.word("null");
    }
    function NumericLiteral(node) {
      const raw = this.getPossibleRaw(node);
      const value = node.value + "";
      if (raw == null) {
        this.number(value);
      } else if (this.format.minified) {
        this.number(raw.length < value.length ? raw : value);
      } else {
        this.number(raw);
      }
    }
    function StringLiteral(node) {
      const raw = this.getPossibleRaw(node);
      if (!this.format.minified && raw != null) {
        this.token(raw);
        return;
      }
      const opts = this.format.jsescOption;
      if (this.format.jsonCompatibleStrings) {
        opts.json = true;
      }
      const val = (0, _jsesc().default)(node.value, opts);
      return this.token(val);
    }
    function BigIntLiteral(node) {
      const raw = this.getPossibleRaw(node);
      if (!this.format.minified && raw != null) {
        this.token(raw);
        return;
      }
      this.token(node.value);
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/flow.js
var require_flow2 = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/flow.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.AnyTypeAnnotation = AnyTypeAnnotation;
    exports2.ArrayTypeAnnotation = ArrayTypeAnnotation;
    exports2.BooleanTypeAnnotation = BooleanTypeAnnotation;
    exports2.BooleanLiteralTypeAnnotation = BooleanLiteralTypeAnnotation;
    exports2.NullLiteralTypeAnnotation = NullLiteralTypeAnnotation;
    exports2.DeclareClass = DeclareClass;
    exports2.DeclareFunction = DeclareFunction;
    exports2.InferredPredicate = InferredPredicate;
    exports2.DeclaredPredicate = DeclaredPredicate;
    exports2.DeclareInterface = DeclareInterface;
    exports2.DeclareModule = DeclareModule;
    exports2.DeclareModuleExports = DeclareModuleExports;
    exports2.DeclareTypeAlias = DeclareTypeAlias;
    exports2.DeclareOpaqueType = DeclareOpaqueType;
    exports2.DeclareVariable = DeclareVariable;
    exports2.DeclareExportDeclaration = DeclareExportDeclaration;
    exports2.DeclareExportAllDeclaration = DeclareExportAllDeclaration;
    exports2.ExistsTypeAnnotation = ExistsTypeAnnotation;
    exports2.FunctionTypeAnnotation = FunctionTypeAnnotation;
    exports2.FunctionTypeParam = FunctionTypeParam;
    exports2.GenericTypeAnnotation = exports2.ClassImplements = exports2.InterfaceExtends = InterfaceExtends;
    exports2._interfaceish = _interfaceish;
    exports2._variance = _variance;
    exports2.InterfaceDeclaration = InterfaceDeclaration;
    exports2.InterfaceTypeAnnotation = InterfaceTypeAnnotation;
    exports2.IntersectionTypeAnnotation = IntersectionTypeAnnotation;
    exports2.MixedTypeAnnotation = MixedTypeAnnotation;
    exports2.EmptyTypeAnnotation = EmptyTypeAnnotation;
    exports2.NullableTypeAnnotation = NullableTypeAnnotation;
    exports2.NumberTypeAnnotation = NumberTypeAnnotation;
    exports2.StringTypeAnnotation = StringTypeAnnotation;
    exports2.ThisTypeAnnotation = ThisTypeAnnotation;
    exports2.TupleTypeAnnotation = TupleTypeAnnotation;
    exports2.TypeofTypeAnnotation = TypeofTypeAnnotation;
    exports2.TypeAlias = TypeAlias;
    exports2.TypeAnnotation = TypeAnnotation;
    exports2.TypeParameterDeclaration = exports2.TypeParameterInstantiation = TypeParameterInstantiation;
    exports2.TypeParameter = TypeParameter;
    exports2.OpaqueType = OpaqueType;
    exports2.ObjectTypeAnnotation = ObjectTypeAnnotation;
    exports2.ObjectTypeInternalSlot = ObjectTypeInternalSlot;
    exports2.ObjectTypeCallProperty = ObjectTypeCallProperty;
    exports2.ObjectTypeIndexer = ObjectTypeIndexer;
    exports2.ObjectTypeProperty = ObjectTypeProperty;
    exports2.ObjectTypeSpreadProperty = ObjectTypeSpreadProperty;
    exports2.QualifiedTypeIdentifier = QualifiedTypeIdentifier;
    exports2.UnionTypeAnnotation = UnionTypeAnnotation;
    exports2.TypeCastExpression = TypeCastExpression;
    exports2.Variance = Variance;
    exports2.VoidTypeAnnotation = VoidTypeAnnotation;
    Object.defineProperty(exports2, "NumberLiteralTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _types2.NumericLiteral;
      }
    });
    Object.defineProperty(exports2, "StringLiteralTypeAnnotation", {
      enumerable: true,
      get: function() {
        return _types2.StringLiteral;
      }
    });
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    var _modules = require_modules();
    var _types2 = require_types();
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function AnyTypeAnnotation() {
      this.word("any");
    }
    function ArrayTypeAnnotation(node) {
      this.print(node.elementType, node);
      this.token("[");
      this.token("]");
    }
    function BooleanTypeAnnotation() {
      this.word("boolean");
    }
    function BooleanLiteralTypeAnnotation(node) {
      this.word(node.value ? "true" : "false");
    }
    function NullLiteralTypeAnnotation() {
      this.word("null");
    }
    function DeclareClass(node, parent) {
      if (!t5().isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.word("class");
      this.space();
      this._interfaceish(node);
    }
    function DeclareFunction(node, parent) {
      if (!t5().isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.word("function");
      this.space();
      this.print(node.id, node);
      this.print(node.id.typeAnnotation.typeAnnotation, node);
      if (node.predicate) {
        this.space();
        this.print(node.predicate, node);
      }
      this.semicolon();
    }
    function InferredPredicate() {
      this.token("%");
      this.word("checks");
    }
    function DeclaredPredicate(node) {
      this.token("%");
      this.word("checks");
      this.token("(");
      this.print(node.value, node);
      this.token(")");
    }
    function DeclareInterface(node) {
      this.word("declare");
      this.space();
      this.InterfaceDeclaration(node);
    }
    function DeclareModule(node) {
      this.word("declare");
      this.space();
      this.word("module");
      this.space();
      this.print(node.id, node);
      this.space();
      this.print(node.body, node);
    }
    function DeclareModuleExports(node) {
      this.word("declare");
      this.space();
      this.word("module");
      this.token(".");
      this.word("exports");
      this.print(node.typeAnnotation, node);
    }
    function DeclareTypeAlias(node) {
      this.word("declare");
      this.space();
      this.TypeAlias(node);
    }
    function DeclareOpaqueType(node, parent) {
      if (!t5().isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.OpaqueType(node);
    }
    function DeclareVariable(node, parent) {
      if (!t5().isDeclareExportDeclaration(parent)) {
        this.word("declare");
        this.space();
      }
      this.word("var");
      this.space();
      this.print(node.id, node);
      this.print(node.id.typeAnnotation, node);
      this.semicolon();
    }
    function DeclareExportDeclaration(node) {
      this.word("declare");
      this.space();
      this.word("export");
      this.space();
      if (node.default) {
        this.word("default");
        this.space();
      }
      FlowExportDeclaration.apply(this, arguments);
    }
    function DeclareExportAllDeclaration() {
      this.word("declare");
      this.space();
      _modules.ExportAllDeclaration.apply(this, arguments);
    }
    function FlowExportDeclaration(node) {
      if (node.declaration) {
        const declar = node.declaration;
        this.print(declar, node);
        if (!t5().isStatement(declar)) this.semicolon();
      } else {
        this.token("{");
        if (node.specifiers.length) {
          this.space();
          this.printList(node.specifiers, node);
          this.space();
        }
        this.token("}");
        if (node.source) {
          this.space();
          this.word("from");
          this.space();
          this.print(node.source, node);
        }
        this.semicolon();
      }
    }
    function ExistsTypeAnnotation() {
      this.token("*");
    }
    function FunctionTypeAnnotation(node, parent) {
      this.print(node.typeParameters, node);
      this.token("(");
      this.printList(node.params, node);
      if (node.rest) {
        if (node.params.length) {
          this.token(",");
          this.space();
        }
        this.token("...");
        this.print(node.rest, node);
      }
      this.token(")");
      if (parent.type === "ObjectTypeCallProperty" || parent.type === "DeclareFunction" || parent.type === "ObjectTypeProperty" && parent.method) {
        this.token(":");
      } else {
        this.space();
        this.token("=>");
      }
      this.space();
      this.print(node.returnType, node);
    }
    function FunctionTypeParam(node) {
      this.print(node.name, node);
      if (node.optional) this.token("?");
      if (node.name) {
        this.token(":");
        this.space();
      }
      this.print(node.typeAnnotation, node);
    }
    function InterfaceExtends(node) {
      this.print(node.id, node);
      this.print(node.typeParameters, node);
    }
    function _interfaceish(node) {
      this.print(node.id, node);
      this.print(node.typeParameters, node);
      if (node.extends.length) {
        this.space();
        this.word("extends");
        this.space();
        this.printList(node.extends, node);
      }
      if (node.mixins && node.mixins.length) {
        this.space();
        this.word("mixins");
        this.space();
        this.printList(node.mixins, node);
      }
      if (node.implements && node.implements.length) {
        this.space();
        this.word("implements");
        this.space();
        this.printList(node.implements, node);
      }
      this.space();
      this.print(node.body, node);
    }
    function _variance(node) {
      if (node.variance) {
        if (node.variance.kind === "plus") {
          this.token("+");
        } else if (node.variance.kind === "minus") {
          this.token("-");
        }
      }
    }
    function InterfaceDeclaration(node) {
      this.word("interface");
      this.space();
      this._interfaceish(node);
    }
    function andSeparator() {
      this.space();
      this.token("&");
      this.space();
    }
    function InterfaceTypeAnnotation(node) {
      this.word("interface");
      if (node.extends && node.extends.length) {
        this.space();
        this.word("extends");
        this.space();
        this.printList(node.extends, node);
      }
      this.space();
      this.print(node.body, node);
    }
    function IntersectionTypeAnnotation(node) {
      this.printJoin(node.types, node, {
        separator: andSeparator
      });
    }
    function MixedTypeAnnotation() {
      this.word("mixed");
    }
    function EmptyTypeAnnotation() {
      this.word("empty");
    }
    function NullableTypeAnnotation(node) {
      this.token("?");
      this.print(node.typeAnnotation, node);
    }
    function NumberTypeAnnotation() {
      this.word("number");
    }
    function StringTypeAnnotation() {
      this.word("string");
    }
    function ThisTypeAnnotation() {
      this.word("this");
    }
    function TupleTypeAnnotation(node) {
      this.token("[");
      this.printList(node.types, node);
      this.token("]");
    }
    function TypeofTypeAnnotation(node) {
      this.word("typeof");
      this.space();
      this.print(node.argument, node);
    }
    function TypeAlias(node) {
      this.word("type");
      this.space();
      this.print(node.id, node);
      this.print(node.typeParameters, node);
      this.space();
      this.token("=");
      this.space();
      this.print(node.right, node);
      this.semicolon();
    }
    function TypeAnnotation(node) {
      this.token(":");
      this.space();
      if (node.optional) this.token("?");
      this.print(node.typeAnnotation, node);
    }
    function TypeParameterInstantiation(node) {
      this.token("<");
      this.printList(node.params, node, {});
      this.token(">");
    }
    function TypeParameter(node) {
      this._variance(node);
      this.word(node.name);
      if (node.bound) {
        this.print(node.bound, node);
      }
      if (node.default) {
        this.space();
        this.token("=");
        this.space();
        this.print(node.default, node);
      }
    }
    function OpaqueType(node) {
      this.word("opaque");
      this.space();
      this.word("type");
      this.space();
      this.print(node.id, node);
      this.print(node.typeParameters, node);
      if (node.supertype) {
        this.token(":");
        this.space();
        this.print(node.supertype, node);
      }
      if (node.impltype) {
        this.space();
        this.token("=");
        this.space();
        this.print(node.impltype, node);
      }
      this.semicolon();
    }
    function ObjectTypeAnnotation(node) {
      if (node.exact) {
        this.token("{|");
      } else {
        this.token("{");
      }
      const props = node.properties.concat(node.callProperties || [], node.indexers || [], node.internalSlots || []);
      if (props.length) {
        this.space();
        this.printJoin(props, node, {
          addNewlines(leading) {
            if (leading && !props[0]) return 1;
          },
          indent: true,
          statement: true,
          iterator: () => {
            if (props.length !== 1) {
              this.token(",");
              this.space();
            }
          }
        });
        this.space();
      }
      if (node.exact) {
        this.token("|}");
      } else {
        this.token("}");
      }
    }
    function ObjectTypeInternalSlot(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this.token("[");
      this.token("[");
      this.print(node.id, node);
      this.token("]");
      this.token("]");
      if (node.optional) this.token("?");
      if (!node.method) {
        this.token(":");
        this.space();
      }
      this.print(node.value, node);
    }
    function ObjectTypeCallProperty(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this.print(node.value, node);
    }
    function ObjectTypeIndexer(node) {
      if (node.static) {
        this.word("static");
        this.space();
      }
      this._variance(node);
      this.token("[");
      if (node.id) {
        this.print(node.id, node);
        this.token(":");
        this.space();
      }
      this.print(node.key, node);
      this.token("]");
      this.token(":");
      this.space();
      this.print(node.value, node);
    }
    function ObjectTypeProperty(node) {
      if (node.proto) {
        this.word("proto");
        this.space();
      }
      if (node.static) {
        this.word("static");
        this.space();
      }
      this._variance(node);
      this.print(node.key, node);
      if (node.optional) this.token("?");
      if (!node.method) {
        this.token(":");
        this.space();
      }
      this.print(node.value, node);
    }
    function ObjectTypeSpreadProperty(node) {
      this.token("...");
      this.print(node.argument, node);
    }
    function QualifiedTypeIdentifier(node) {
      this.print(node.qualification, node);
      this.token(".");
      this.print(node.id, node);
    }
    function orSeparator() {
      this.space();
      this.token("|");
      this.space();
    }
    function UnionTypeAnnotation(node) {
      this.printJoin(node.types, node, {
        separator: orSeparator
      });
    }
    function TypeCastExpression(node) {
      this.token("(");
      this.print(node.expression, node);
      this.print(node.typeAnnotation, node);
      this.token(")");
    }
    function Variance(node) {
      if (node.kind === "plus") {
        this.token("+");
      } else {
        this.token("-");
      }
    }
    function VoidTypeAnnotation() {
      this.word("void");
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/base.js
var require_base = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/base.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.File = File;
    exports2.Program = Program;
    exports2.BlockStatement = BlockStatement;
    exports2.Noop = Noop;
    exports2.Directive = Directive;
    exports2.InterpreterDirective = InterpreterDirective;
    Object.defineProperty(exports2, "DirectiveLiteral", {
      enumerable: true,
      get: function() {
        return _types.StringLiteral;
      }
    });
    var _types = require_types();
    function File(node) {
      if (node.program) {
        this.print(node.program.interpreter, node);
      }
      this.print(node.program, node);
    }
    function Program(node) {
      this.printInnerComments(node, false);
      this.printSequence(node.directives, node);
      if (node.directives && node.directives.length) this.newline();
      this.printSequence(node.body, node);
    }
    function BlockStatement(node) {
      this.token("{");
      this.printInnerComments(node);
      const hasDirectives = node.directives && node.directives.length;
      if (node.body.length || hasDirectives) {
        this.newline();
        this.printSequence(node.directives, node, {
          indent: true
        });
        if (hasDirectives) this.newline();
        this.printSequence(node.body, node, {
          indent: true
        });
        this.removeTrailingNewline();
        this.source("end", node.loc);
        if (!this.endsWith("\n")) this.newline();
        this.rightBrace();
      } else {
        this.source("end", node.loc);
        this.token("}");
      }
    }
    function Noop() {
    }
    function Directive(node) {
      this.print(node.value, node);
      this.semicolon();
    }
    function InterpreterDirective(node) {
      this.token(`#!${node.value}
`);
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/jsx.js
var require_jsx2 = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/jsx.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.JSXAttribute = JSXAttribute;
    exports2.JSXIdentifier = JSXIdentifier;
    exports2.JSXNamespacedName = JSXNamespacedName;
    exports2.JSXMemberExpression = JSXMemberExpression;
    exports2.JSXSpreadAttribute = JSXSpreadAttribute;
    exports2.JSXExpressionContainer = JSXExpressionContainer;
    exports2.JSXSpreadChild = JSXSpreadChild;
    exports2.JSXText = JSXText;
    exports2.JSXElement = JSXElement;
    exports2.JSXOpeningElement = JSXOpeningElement;
    exports2.JSXClosingElement = JSXClosingElement;
    exports2.JSXEmptyExpression = JSXEmptyExpression;
    exports2.JSXFragment = JSXFragment;
    exports2.JSXOpeningFragment = JSXOpeningFragment;
    exports2.JSXClosingFragment = JSXClosingFragment;
    function JSXAttribute(node) {
      this.print(node.name, node);
      if (node.value) {
        this.token("=");
        this.print(node.value, node);
      }
    }
    function JSXIdentifier(node) {
      this.word(node.name);
    }
    function JSXNamespacedName(node) {
      this.print(node.namespace, node);
      this.token(":");
      this.print(node.name, node);
    }
    function JSXMemberExpression(node) {
      this.print(node.object, node);
      this.token(".");
      this.print(node.property, node);
    }
    function JSXSpreadAttribute(node) {
      this.token("{");
      this.token("...");
      this.print(node.argument, node);
      this.token("}");
    }
    function JSXExpressionContainer(node) {
      this.token("{");
      this.print(node.expression, node);
      this.token("}");
    }
    function JSXSpreadChild(node) {
      this.token("{");
      this.token("...");
      this.print(node.expression, node);
      this.token("}");
    }
    function JSXText(node) {
      const raw = this.getPossibleRaw(node);
      if (raw != null) {
        this.token(raw);
      } else {
        this.token(node.value);
      }
    }
    function JSXElement(node) {
      const open = node.openingElement;
      this.print(open, node);
      if (open.selfClosing) return;
      this.indent();
      for (const child of node.children) {
        this.print(child, node);
      }
      this.dedent();
      this.print(node.closingElement, node);
    }
    function spaceSeparator() {
      this.space();
    }
    function JSXOpeningElement(node) {
      this.token("<");
      this.print(node.name, node);
      this.print(node.typeParameters, node);
      if (node.attributes.length > 0) {
        this.space();
        this.printJoin(node.attributes, node, {
          separator: spaceSeparator
        });
      }
      if (node.selfClosing) {
        this.space();
        this.token("/>");
      } else {
        this.token(">");
      }
    }
    function JSXClosingElement(node) {
      this.token("</");
      this.print(node.name, node);
      this.token(">");
    }
    function JSXEmptyExpression(node) {
      this.printInnerComments(node);
    }
    function JSXFragment(node) {
      this.print(node.openingFragment, node);
      this.indent();
      for (const child of node.children) {
        this.print(child, node);
      }
      this.dedent();
      this.print(node.closingFragment, node);
    }
    function JSXOpeningFragment() {
      this.token("<");
      this.token(">");
    }
    function JSXClosingFragment() {
      this.token("</");
      this.token(">");
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/typescript.js
var require_typescript2 = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/typescript.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.TSTypeAnnotation = TSTypeAnnotation;
    exports2.TSTypeParameterDeclaration = exports2.TSTypeParameterInstantiation = TSTypeParameterInstantiation;
    exports2.TSTypeParameter = TSTypeParameter;
    exports2.TSParameterProperty = TSParameterProperty;
    exports2.TSDeclareFunction = TSDeclareFunction;
    exports2.TSDeclareMethod = TSDeclareMethod;
    exports2.TSQualifiedName = TSQualifiedName;
    exports2.TSCallSignatureDeclaration = TSCallSignatureDeclaration;
    exports2.TSConstructSignatureDeclaration = TSConstructSignatureDeclaration;
    exports2.TSPropertySignature = TSPropertySignature;
    exports2.tsPrintPropertyOrMethodName = tsPrintPropertyOrMethodName;
    exports2.TSMethodSignature = TSMethodSignature;
    exports2.TSIndexSignature = TSIndexSignature;
    exports2.TSAnyKeyword = TSAnyKeyword;
    exports2.TSUnknownKeyword = TSUnknownKeyword;
    exports2.TSNumberKeyword = TSNumberKeyword;
    exports2.TSObjectKeyword = TSObjectKeyword;
    exports2.TSBooleanKeyword = TSBooleanKeyword;
    exports2.TSStringKeyword = TSStringKeyword;
    exports2.TSSymbolKeyword = TSSymbolKeyword;
    exports2.TSVoidKeyword = TSVoidKeyword;
    exports2.TSUndefinedKeyword = TSUndefinedKeyword;
    exports2.TSNullKeyword = TSNullKeyword;
    exports2.TSNeverKeyword = TSNeverKeyword;
    exports2.TSThisType = TSThisType;
    exports2.TSFunctionType = TSFunctionType;
    exports2.TSConstructorType = TSConstructorType;
    exports2.tsPrintFunctionOrConstructorType = tsPrintFunctionOrConstructorType;
    exports2.TSTypeReference = TSTypeReference;
    exports2.TSTypePredicate = TSTypePredicate;
    exports2.TSTypeQuery = TSTypeQuery;
    exports2.TSTypeLiteral = TSTypeLiteral;
    exports2.tsPrintTypeLiteralOrInterfaceBody = tsPrintTypeLiteralOrInterfaceBody;
    exports2.tsPrintBraced = tsPrintBraced;
    exports2.TSArrayType = TSArrayType;
    exports2.TSTupleType = TSTupleType;
    exports2.TSOptionalType = TSOptionalType;
    exports2.TSRestType = TSRestType;
    exports2.TSUnionType = TSUnionType;
    exports2.TSIntersectionType = TSIntersectionType;
    exports2.tsPrintUnionOrIntersectionType = tsPrintUnionOrIntersectionType;
    exports2.TSConditionalType = TSConditionalType;
    exports2.TSInferType = TSInferType;
    exports2.TSParenthesizedType = TSParenthesizedType;
    exports2.TSTypeOperator = TSTypeOperator;
    exports2.TSIndexedAccessType = TSIndexedAccessType;
    exports2.TSMappedType = TSMappedType;
    exports2.TSLiteralType = TSLiteralType;
    exports2.TSExpressionWithTypeArguments = TSExpressionWithTypeArguments;
    exports2.TSInterfaceDeclaration = TSInterfaceDeclaration;
    exports2.TSInterfaceBody = TSInterfaceBody;
    exports2.TSTypeAliasDeclaration = TSTypeAliasDeclaration;
    exports2.TSAsExpression = TSAsExpression;
    exports2.TSTypeAssertion = TSTypeAssertion;
    exports2.TSEnumDeclaration = TSEnumDeclaration;
    exports2.TSEnumMember = TSEnumMember;
    exports2.TSModuleDeclaration = TSModuleDeclaration;
    exports2.TSModuleBlock = TSModuleBlock;
    exports2.TSImportEqualsDeclaration = TSImportEqualsDeclaration;
    exports2.TSExternalModuleReference = TSExternalModuleReference;
    exports2.TSNonNullExpression = TSNonNullExpression;
    exports2.TSExportAssignment = TSExportAssignment;
    exports2.TSNamespaceExportDeclaration = TSNamespaceExportDeclaration;
    exports2.tsPrintSignatureDeclarationBase = tsPrintSignatureDeclarationBase;
    function TSTypeAnnotation(node) {
      this.token(":");
      this.space();
      if (node.optional) this.token("?");
      this.print(node.typeAnnotation, node);
    }
    function TSTypeParameterInstantiation(node) {
      this.token("<");
      this.printList(node.params, node, {});
      this.token(">");
    }
    function TSTypeParameter(node) {
      this.word(node.name);
      if (node.constraint) {
        this.space();
        this.word("extends");
        this.space();
        this.print(node.constraint, node);
      }
      if (node.default) {
        this.space();
        this.token("=");
        this.space();
        this.print(node.default, node);
      }
    }
    function TSParameterProperty(node) {
      if (node.accessibility) {
        this.word(node.accessibility);
        this.space();
      }
      if (node.readonly) {
        this.word("readonly");
        this.space();
      }
      this._param(node.parameter);
    }
    function TSDeclareFunction(node) {
      if (node.declare) {
        this.word("declare");
        this.space();
      }
      this._functionHead(node);
      this.token(";");
    }
    function TSDeclareMethod(node) {
      this._classMethodHead(node);
      this.token(";");
    }
    function TSQualifiedName(node) {
      this.print(node.left, node);
      this.token(".");
      this.print(node.right, node);
    }
    function TSCallSignatureDeclaration(node) {
      this.tsPrintSignatureDeclarationBase(node);
    }
    function TSConstructSignatureDeclaration(node) {
      this.word("new");
      this.space();
      this.tsPrintSignatureDeclarationBase(node);
    }
    function TSPropertySignature(node) {
      const {
        readonly,
        initializer
      } = node;
      if (readonly) {
        this.word("readonly");
        this.space();
      }
      this.tsPrintPropertyOrMethodName(node);
      this.print(node.typeAnnotation, node);
      if (initializer) {
        this.space();
        this.token("=");
        this.space();
        this.print(initializer, node);
      }
      this.token(";");
    }
    function tsPrintPropertyOrMethodName(node) {
      if (node.computed) {
        this.token("[");
      }
      this.print(node.key, node);
      if (node.computed) {
        this.token("]");
      }
      if (node.optional) {
        this.token("?");
      }
    }
    function TSMethodSignature(node) {
      this.tsPrintPropertyOrMethodName(node);
      this.tsPrintSignatureDeclarationBase(node);
      this.token(";");
    }
    function TSIndexSignature(node) {
      const {
        readonly
      } = node;
      if (readonly) {
        this.word("readonly");
        this.space();
      }
      this.token("[");
      this._parameters(node.parameters, node);
      this.token("]");
      this.print(node.typeAnnotation, node);
      this.token(";");
    }
    function TSAnyKeyword() {
      this.word("any");
    }
    function TSUnknownKeyword() {
      this.word("unknown");
    }
    function TSNumberKeyword() {
      this.word("number");
    }
    function TSObjectKeyword() {
      this.word("object");
    }
    function TSBooleanKeyword() {
      this.word("boolean");
    }
    function TSStringKeyword() {
      this.word("string");
    }
    function TSSymbolKeyword() {
      this.word("symbol");
    }
    function TSVoidKeyword() {
      this.word("void");
    }
    function TSUndefinedKeyword() {
      this.word("undefined");
    }
    function TSNullKeyword() {
      this.word("null");
    }
    function TSNeverKeyword() {
      this.word("never");
    }
    function TSThisType() {
      this.word("this");
    }
    function TSFunctionType(node) {
      this.tsPrintFunctionOrConstructorType(node);
    }
    function TSConstructorType(node) {
      this.word("new");
      this.space();
      this.tsPrintFunctionOrConstructorType(node);
    }
    function tsPrintFunctionOrConstructorType(node) {
      const {
        typeParameters,
        parameters
      } = node;
      this.print(typeParameters, node);
      this.token("(");
      this._parameters(parameters, node);
      this.token(")");
      this.space();
      this.token("=>");
      this.space();
      this.print(node.typeAnnotation.typeAnnotation, node);
    }
    function TSTypeReference(node) {
      this.print(node.typeName, node);
      this.print(node.typeParameters, node);
    }
    function TSTypePredicate(node) {
      this.print(node.parameterName);
      this.space();
      this.word("is");
      this.space();
      this.print(node.typeAnnotation.typeAnnotation);
    }
    function TSTypeQuery(node) {
      this.word("typeof");
      this.space();
      this.print(node.exprName);
    }
    function TSTypeLiteral(node) {
      this.tsPrintTypeLiteralOrInterfaceBody(node.members, node);
    }
    function tsPrintTypeLiteralOrInterfaceBody(members, node) {
      this.tsPrintBraced(members, node);
    }
    function tsPrintBraced(members, node) {
      this.token("{");
      if (members.length) {
        this.indent();
        this.newline();
        for (const member of members) {
          this.print(member, node);
          this.newline();
        }
        this.dedent();
        this.rightBrace();
      } else {
        this.token("}");
      }
    }
    function TSArrayType(node) {
      this.print(node.elementType);
      this.token("[]");
    }
    function TSTupleType(node) {
      this.token("[");
      this.printList(node.elementTypes, node);
      this.token("]");
    }
    function TSOptionalType(node) {
      this.print(node.typeAnnotation, node);
      this.token("?");
    }
    function TSRestType(node) {
      this.token("...");
      this.print(node.typeAnnotation, node);
    }
    function TSUnionType(node) {
      this.tsPrintUnionOrIntersectionType(node, "|");
    }
    function TSIntersectionType(node) {
      this.tsPrintUnionOrIntersectionType(node, "&");
    }
    function tsPrintUnionOrIntersectionType(node, sep) {
      this.printJoin(node.types, node, {
        separator() {
          this.space();
          this.token(sep);
          this.space();
        }
      });
    }
    function TSConditionalType(node) {
      this.print(node.checkType);
      this.space();
      this.word("extends");
      this.space();
      this.print(node.extendsType);
      this.space();
      this.token("?");
      this.space();
      this.print(node.trueType);
      this.space();
      this.token(":");
      this.space();
      this.print(node.falseType);
    }
    function TSInferType(node) {
      this.token("infer");
      this.space();
      this.print(node.typeParameter);
    }
    function TSParenthesizedType(node) {
      this.token("(");
      this.print(node.typeAnnotation, node);
      this.token(")");
    }
    function TSTypeOperator(node) {
      this.token(node.operator);
      this.space();
      this.print(node.typeAnnotation, node);
    }
    function TSIndexedAccessType(node) {
      this.print(node.objectType, node);
      this.token("[");
      this.print(node.indexType, node);
      this.token("]");
    }
    function TSMappedType(node) {
      const {
        readonly,
        typeParameter,
        optional
      } = node;
      this.token("{");
      this.space();
      if (readonly) {
        tokenIfPlusMinus(this, readonly);
        this.word("readonly");
        this.space();
      }
      this.token("[");
      this.word(typeParameter.name);
      this.space();
      this.word("in");
      this.space();
      this.print(typeParameter.constraint, typeParameter);
      this.token("]");
      if (optional) {
        tokenIfPlusMinus(this, optional);
        this.token("?");
      }
      this.token(":");
      this.space();
      this.print(node.typeAnnotation, node);
      this.space();
      this.token("}");
    }
    function tokenIfPlusMinus(self2, tok) {
      if (tok !== true) {
        self2.token(tok);
      }
    }
    function TSLiteralType(node) {
      this.print(node.literal, node);
    }
    function TSExpressionWithTypeArguments(node) {
      this.print(node.expression, node);
      this.print(node.typeParameters, node);
    }
    function TSInterfaceDeclaration(node) {
      const {
        declare,
        id,
        typeParameters,
        extends: extendz,
        body
      } = node;
      if (declare) {
        this.word("declare");
        this.space();
      }
      this.word("interface");
      this.space();
      this.print(id, node);
      this.print(typeParameters, node);
      if (extendz) {
        this.space();
        this.word("extends");
        this.space();
        this.printList(extendz, node);
      }
      this.space();
      this.print(body, node);
    }
    function TSInterfaceBody(node) {
      this.tsPrintTypeLiteralOrInterfaceBody(node.body, node);
    }
    function TSTypeAliasDeclaration(node) {
      const {
        declare,
        id,
        typeParameters,
        typeAnnotation: typeAnnotation2
      } = node;
      if (declare) {
        this.word("declare");
        this.space();
      }
      this.word("type");
      this.space();
      this.print(id, node);
      this.print(typeParameters, node);
      this.space();
      this.token("=");
      this.space();
      this.print(typeAnnotation2, node);
      this.token(";");
    }
    function TSAsExpression(node) {
      const {
        expression,
        typeAnnotation: typeAnnotation2
      } = node;
      this.print(expression, node);
      this.space();
      this.word("as");
      this.space();
      this.print(typeAnnotation2, node);
    }
    function TSTypeAssertion(node) {
      const {
        typeAnnotation: typeAnnotation2,
        expression
      } = node;
      this.token("<");
      this.print(typeAnnotation2, node);
      this.token(">");
      this.space();
      this.print(expression, node);
    }
    function TSEnumDeclaration(node) {
      const {
        declare,
        const: isConst,
        id,
        members
      } = node;
      if (declare) {
        this.word("declare");
        this.space();
      }
      if (isConst) {
        this.word("const");
        this.space();
      }
      this.word("enum");
      this.space();
      this.print(id, node);
      this.space();
      this.tsPrintBraced(members, node);
    }
    function TSEnumMember(node) {
      const {
        id,
        initializer
      } = node;
      this.print(id, node);
      if (initializer) {
        this.space();
        this.token("=");
        this.space();
        this.print(initializer, node);
      }
      this.token(",");
    }
    function TSModuleDeclaration(node) {
      const {
        declare,
        id
      } = node;
      if (declare) {
        this.word("declare");
        this.space();
      }
      if (!node.global) {
        this.word(id.type === "Identifier" ? "namespace" : "module");
        this.space();
      }
      this.print(id, node);
      if (!node.body) {
        this.token(";");
        return;
      }
      let body = node.body;
      while (body.type === "TSModuleDeclaration") {
        this.token(".");
        this.print(body.id, body);
        body = body.body;
      }
      this.space();
      this.print(body, node);
    }
    function TSModuleBlock(node) {
      this.tsPrintBraced(node.body, node);
    }
    function TSImportEqualsDeclaration(node) {
      const {
        isExport,
        id,
        moduleReference
      } = node;
      if (isExport) {
        this.word("export");
        this.space();
      }
      this.word("import");
      this.space();
      this.print(id, node);
      this.space();
      this.token("=");
      this.space();
      this.print(moduleReference, node);
      this.token(";");
    }
    function TSExternalModuleReference(node) {
      this.token("require(");
      this.print(node.expression, node);
      this.token(")");
    }
    function TSNonNullExpression(node) {
      this.print(node.expression, node);
      this.token("!");
    }
    function TSExportAssignment(node) {
      this.word("export");
      this.space();
      this.token("=");
      this.space();
      this.print(node.expression, node);
      this.token(";");
    }
    function TSNamespaceExportDeclaration(node) {
      this.word("export");
      this.space();
      this.word("as");
      this.space();
      this.word("namespace");
      this.space();
      this.print(node.id, node);
    }
    function tsPrintSignatureDeclarationBase(node) {
      const {
        typeParameters,
        parameters
      } = node;
      this.print(typeParameters, node);
      this.token("(");
      this._parameters(parameters, node);
      this.token(")");
      this.print(node.typeAnnotation, node);
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/index.js
var require_generators = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/generators/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    var _templateLiterals = require_template_literals();
    Object.keys(_templateLiterals).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _templateLiterals[key];
        }
      });
    });
    var _expressions = require_expressions();
    Object.keys(_expressions).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _expressions[key];
        }
      });
    });
    var _statements = require_statements();
    Object.keys(_statements).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _statements[key];
        }
      });
    });
    var _classes = require_classes();
    Object.keys(_classes).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _classes[key];
        }
      });
    });
    var _methods = require_methods();
    Object.keys(_methods).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _methods[key];
        }
      });
    });
    var _modules = require_modules();
    Object.keys(_modules).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _modules[key];
        }
      });
    });
    var _types = require_types();
    Object.keys(_types).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _types[key];
        }
      });
    });
    var _flow = require_flow2();
    Object.keys(_flow).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _flow[key];
        }
      });
    });
    var _base = require_base();
    Object.keys(_base).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _base[key];
        }
      });
    });
    var _jsx = require_jsx2();
    Object.keys(_jsx).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _jsx[key];
        }
      });
    });
    var _typescript = require_typescript2();
    Object.keys(_typescript).forEach(function(key) {
      if (key === "default" || key === "__esModule") return;
      Object.defineProperty(exports2, key, {
        enumerable: true,
        get: function() {
          return _typescript[key];
        }
      });
    });
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/printer.js
var require_printer = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/printer.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = void 0;
    function _isInteger() {
      const data = _interopRequireDefault(require_isInteger());
      _isInteger = function() {
        return data;
      };
      return data;
    }
    function _repeat() {
      const data = _interopRequireDefault(require_repeat());
      _repeat = function() {
        return data;
      };
      return data;
    }
    var _buffer = _interopRequireDefault(require_buffer());
    var n = _interopRequireWildcard(require_node());
    function t5() {
      const data = _interopRequireWildcard(require_lib3());
      t5 = function() {
        return data;
      };
      return data;
    }
    var generatorFunctions = _interopRequireWildcard(require_generators());
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var SCIENTIFIC_NOTATION = /e/i;
    var ZERO_DECIMAL_INTEGER = /\.0+$/;
    var NON_DECIMAL_LITERAL = /^0[box]/;
    var Printer = class {
      constructor(format, map) {
        this.inForStatementInitCounter = 0;
        this._printStack = [];
        this._indent = 0;
        this._insideAux = false;
        this._printedCommentStarts = {};
        this._parenPushNewlineState = null;
        this._noLineTerminator = false;
        this._printAuxAfterOnNextUserNode = false;
        this._printedComments = /* @__PURE__ */ new WeakSet();
        this._endsWithInteger = false;
        this._endsWithWord = false;
        this.format = format || {};
        this._buf = new _buffer.default(map);
      }
      generate(ast) {
        this.print(ast);
        this._maybeAddAuxComment();
        return this._buf.get();
      }
      indent() {
        if (this.format.compact || this.format.concise) return;
        this._indent++;
      }
      dedent() {
        if (this.format.compact || this.format.concise) return;
        this._indent--;
      }
      semicolon(force = false) {
        this._maybeAddAuxComment();
        this._append(";", !force);
      }
      rightBrace() {
        if (this.format.minified) {
          this._buf.removeLastSemicolon();
        }
        this.token("}");
      }
      space(force = false) {
        if (this.format.compact) return;
        if (this._buf.hasContent() && !this.endsWith(" ") && !this.endsWith("\n") || force) {
          this._space();
        }
      }
      word(str) {
        if (this._endsWithWord || this.endsWith("/") && str.indexOf("/") === 0) {
          this._space();
        }
        this._maybeAddAuxComment();
        this._append(str);
        this._endsWithWord = true;
      }
      number(str) {
        this.word(str);
        this._endsWithInteger = (0, _isInteger().default)(+str) && !NON_DECIMAL_LITERAL.test(str) && !SCIENTIFIC_NOTATION.test(str) && !ZERO_DECIMAL_INTEGER.test(str) && str[str.length - 1] !== ".";
      }
      token(str) {
        if (str === "--" && this.endsWith("!") || str[0] === "+" && this.endsWith("+") || str[0] === "-" && this.endsWith("-") || str[0] === "." && this._endsWithInteger) {
          this._space();
        }
        this._maybeAddAuxComment();
        this._append(str);
      }
      newline(i) {
        if (this.format.retainLines || this.format.compact) return;
        if (this.format.concise) {
          this.space();
          return;
        }
        if (this.endsWith("\n\n")) return;
        if (typeof i !== "number") i = 1;
        i = Math.min(2, i);
        if (this.endsWith("{\n") || this.endsWith(":\n")) i--;
        if (i <= 0) return;
        for (let j = 0; j < i; j++) {
          this._newline();
        }
      }
      endsWith(str) {
        return this._buf.endsWith(str);
      }
      removeTrailingNewline() {
        this._buf.removeTrailingNewline();
      }
      exactSource(loc, cb) {
        this._catchUp("start", loc);
        this._buf.exactSource(loc, cb);
      }
      source(prop, loc) {
        this._catchUp(prop, loc);
        this._buf.source(prop, loc);
      }
      withSource(prop, loc, cb) {
        this._catchUp(prop, loc);
        this._buf.withSource(prop, loc, cb);
      }
      _space() {
        this._append(" ", true);
      }
      _newline() {
        this._append("\n", true);
      }
      _append(str, queue = false) {
        this._maybeAddParen(str);
        this._maybeIndent(str);
        if (queue) this._buf.queue(str);
        else this._buf.append(str);
        this._endsWithWord = false;
        this._endsWithInteger = false;
      }
      _maybeIndent(str) {
        if (this._indent && this.endsWith("\n") && str[0] !== "\n") {
          this._buf.queue(this._getIndent());
        }
      }
      _maybeAddParen(str) {
        const parenPushNewlineState = this._parenPushNewlineState;
        if (!parenPushNewlineState) return;
        this._parenPushNewlineState = null;
        let i;
        for (i = 0; i < str.length && str[i] === " "; i++) continue;
        if (i === str.length) return;
        const cha = str[i];
        if (cha !== "\n") {
          if (cha !== "/") return;
          if (i + 1 === str.length) return;
          const chaPost = str[i + 1];
          if (chaPost !== "/" && chaPost !== "*") return;
        }
        this.token("(");
        this.indent();
        parenPushNewlineState.printed = true;
      }
      _catchUp(prop, loc) {
        if (!this.format.retainLines) return;
        const pos = loc ? loc[prop] : null;
        if (pos && pos.line !== null) {
          const count = pos.line - this._buf.getCurrentLine();
          for (let i = 0; i < count; i++) {
            this._newline();
          }
        }
      }
      _getIndent() {
        return (0, _repeat().default)(this.format.indent.style, this._indent);
      }
      startTerminatorless(isLabel = false) {
        if (isLabel) {
          this._noLineTerminator = true;
          return null;
        } else {
          return this._parenPushNewlineState = {
            printed: false
          };
        }
      }
      endTerminatorless(state) {
        this._noLineTerminator = false;
        if (state && state.printed) {
          this.dedent();
          this.newline();
          this.token(")");
        }
      }
      print(node, parent) {
        if (!node) return;
        const oldConcise = this.format.concise;
        if (node._compact) {
          this.format.concise = true;
        }
        const printMethod = this[node.type];
        if (!printMethod) {
          throw new ReferenceError(`unknown node of type ${JSON.stringify(node.type)} with constructor ${JSON.stringify(node && node.constructor.name)}`);
        }
        this._printStack.push(node);
        const oldInAux = this._insideAux;
        this._insideAux = !node.loc;
        this._maybeAddAuxComment(this._insideAux && !oldInAux);
        let needsParens = n.needsParens(node, parent, this._printStack);
        if (this.format.retainFunctionParens && node.type === "FunctionExpression" && node.extra && node.extra.parenthesized) {
          needsParens = true;
        }
        if (needsParens) this.token("(");
        this._printLeadingComments(node);
        const loc = t5().isProgram(node) || t5().isFile(node) ? null : node.loc;
        this.withSource("start", loc, () => {
          this[node.type](node, parent);
        });
        this._printTrailingComments(node);
        if (needsParens) this.token(")");
        this._printStack.pop();
        this.format.concise = oldConcise;
        this._insideAux = oldInAux;
      }
      _maybeAddAuxComment(enteredPositionlessNode) {
        if (enteredPositionlessNode) this._printAuxBeforeComment();
        if (!this._insideAux) this._printAuxAfterComment();
      }
      _printAuxBeforeComment() {
        if (this._printAuxAfterOnNextUserNode) return;
        this._printAuxAfterOnNextUserNode = true;
        const comment = this.format.auxiliaryCommentBefore;
        if (comment) {
          this._printComment({
            type: "CommentBlock",
            value: comment
          });
        }
      }
      _printAuxAfterComment() {
        if (!this._printAuxAfterOnNextUserNode) return;
        this._printAuxAfterOnNextUserNode = false;
        const comment = this.format.auxiliaryCommentAfter;
        if (comment) {
          this._printComment({
            type: "CommentBlock",
            value: comment
          });
        }
      }
      getPossibleRaw(node) {
        const extra = node.extra;
        if (extra && extra.raw != null && extra.rawValue != null && node.value === extra.rawValue) {
          return extra.raw;
        }
      }
      printJoin(nodes, parent, opts = {}) {
        if (!nodes || !nodes.length) return;
        if (opts.indent) this.indent();
        const newlineOpts = {
          addNewlines: opts.addNewlines
        };
        for (let i = 0; i < nodes.length; i++) {
          const node = nodes[i];
          if (!node) continue;
          if (opts.statement) this._printNewline(true, node, parent, newlineOpts);
          this.print(node, parent);
          if (opts.iterator) {
            opts.iterator(node, i);
          }
          if (opts.separator && i < nodes.length - 1) {
            opts.separator.call(this);
          }
          if (opts.statement) this._printNewline(false, node, parent, newlineOpts);
        }
        if (opts.indent) this.dedent();
      }
      printAndIndentOnComments(node, parent) {
        const indent = node.leadingComments && node.leadingComments.length > 0;
        if (indent) this.indent();
        this.print(node, parent);
        if (indent) this.dedent();
      }
      printBlock(parent) {
        const node = parent.body;
        if (!t5().isEmptyStatement(node)) {
          this.space();
        }
        this.print(node, parent);
      }
      _printTrailingComments(node) {
        this._printComments(this._getComments(false, node));
      }
      _printLeadingComments(node) {
        this._printComments(this._getComments(true, node));
      }
      printInnerComments(node, indent = true) {
        if (!node.innerComments || !node.innerComments.length) return;
        if (indent) this.indent();
        this._printComments(node.innerComments);
        if (indent) this.dedent();
      }
      printSequence(nodes, parent, opts = {}) {
        opts.statement = true;
        return this.printJoin(nodes, parent, opts);
      }
      printList(items, parent, opts = {}) {
        if (opts.separator == null) {
          opts.separator = commaSeparator;
        }
        return this.printJoin(items, parent, opts);
      }
      _printNewline(leading, node, parent, opts) {
        if (this.format.retainLines || this.format.compact) return;
        if (this.format.concise) {
          this.space();
          return;
        }
        let lines = 0;
        if (this._buf.hasContent()) {
          if (!leading) lines++;
          if (opts.addNewlines) lines += opts.addNewlines(leading, node) || 0;
          const needs = leading ? n.needsWhitespaceBefore : n.needsWhitespaceAfter;
          if (needs(node, parent)) lines++;
        }
        this.newline(lines);
      }
      _getComments(leading, node) {
        return node && (leading ? node.leadingComments : node.trailingComments) || [];
      }
      _printComment(comment) {
        if (!this.format.shouldPrintComment(comment.value)) return;
        if (comment.ignore) return;
        if (this._printedComments.has(comment)) return;
        this._printedComments.add(comment);
        if (comment.start != null) {
          if (this._printedCommentStarts[comment.start]) return;
          this._printedCommentStarts[comment.start] = true;
        }
        const isBlockComment = comment.type === "CommentBlock";
        this.newline(this._buf.hasContent() && !this._noLineTerminator && isBlockComment ? 1 : 0);
        if (!this.endsWith("[") && !this.endsWith("{")) this.space();
        let val = !isBlockComment && !this._noLineTerminator ? `//${comment.value}
` : `/*${comment.value}*/`;
        if (isBlockComment && this.format.indent.adjustMultilineComment) {
          const offset = comment.loc && comment.loc.start.column;
          if (offset) {
            const newlineRegex = new RegExp("\\n\\s{1," + offset + "}", "g");
            val = val.replace(newlineRegex, "\n");
          }
          const indentSize = Math.max(this._getIndent().length, this._buf.getCurrentColumn());
          val = val.replace(/\n(?!$)/g, `
${(0, _repeat().default)(" ", indentSize)}`);
        }
        if (this.endsWith("/")) this._space();
        this.withSource("start", comment.loc, () => {
          this._append(val);
        });
        this.newline(isBlockComment && !this._noLineTerminator ? 1 : 0);
      }
      _printComments(comments) {
        if (!comments || !comments.length) return;
        for (const comment of comments) {
          this._printComment(comment);
        }
      }
    };
    exports2.default = Printer;
    Object.assign(Printer.prototype, generatorFunctions);
    function commaSeparator() {
      this.token(",");
      this.space();
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/@babel/generator/lib/index.js
var require_lib4 = __commonJS({
  "../babel-plugin-react-compiler/node_modules/@babel/generator/lib/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = _default;
    exports2.CodeGenerator = void 0;
    var _sourceMap = _interopRequireDefault(require_source_map2());
    var _printer = _interopRequireDefault(require_printer());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var Generator = class extends _printer.default {
      constructor(ast, opts = {}, code) {
        const format = normalizeOptions(code, opts);
        const map = opts.sourceMaps ? new _sourceMap.default(opts, code) : null;
        super(format, map);
        this.ast = ast;
      }
      generate() {
        return super.generate(this.ast);
      }
    };
    function normalizeOptions(code, opts) {
      const format = {
        auxiliaryCommentBefore: opts.auxiliaryCommentBefore,
        auxiliaryCommentAfter: opts.auxiliaryCommentAfter,
        shouldPrintComment: opts.shouldPrintComment,
        retainLines: opts.retainLines,
        retainFunctionParens: opts.retainFunctionParens,
        comments: opts.comments == null || opts.comments,
        compact: opts.compact,
        minified: opts.minified,
        concise: opts.concise,
        jsonCompatibleStrings: opts.jsonCompatibleStrings,
        indent: {
          adjustMultilineComment: true,
          style: "  ",
          base: 0
        },
        decoratorsBeforeExport: !!opts.decoratorsBeforeExport,
        jsescOption: Object.assign({
          quotes: "double",
          wrap: true
        }, opts.jsescOption)
      };
      if (format.minified) {
        format.compact = true;
        format.shouldPrintComment = format.shouldPrintComment || (() => format.comments);
      } else {
        format.shouldPrintComment = format.shouldPrintComment || ((value) => format.comments || value.indexOf("@license") >= 0 || value.indexOf("@preserve") >= 0);
      }
      if (format.compact === "auto") {
        format.compact = code.length > 5e5;
        if (format.compact) {
          console.error(`[BABEL] Note: The code generator has deoptimised the styling of ${opts.filename} as it exceeds the max of ${"500KB"}.`);
        }
      }
      if (format.compact) {
        format.indent.adjustMultilineComment = false;
      }
      return format;
    }
    var CodeGenerator = class {
      constructor(ast, opts, code) {
        this._generator = new Generator(ast, opts, code);
      }
      generate() {
        return this._generator.generate();
      }
    };
    exports2.CodeGenerator = CodeGenerator;
    function _default(ast, opts, code) {
      const gen = new Generator(ast, opts, code);
      return gen.generate();
    }
  }
});

// ../../node_modules/color-convert/node_modules/color-name/index.js
var require_color_name = __commonJS({
  "../../node_modules/color-convert/node_modules/color-name/index.js"(exports2, module2) {
    "use strict";
    module2.exports = {
      "aliceblue": [240, 248, 255],
      "antiquewhite": [250, 235, 215],
      "aqua": [0, 255, 255],
      "aquamarine": [127, 255, 212],
      "azure": [240, 255, 255],
      "beige": [245, 245, 220],
      "bisque": [255, 228, 196],
      "black": [0, 0, 0],
      "blanchedalmond": [255, 235, 205],
      "blue": [0, 0, 255],
      "blueviolet": [138, 43, 226],
      "brown": [165, 42, 42],
      "burlywood": [222, 184, 135],
      "cadetblue": [95, 158, 160],
      "chartreuse": [127, 255, 0],
      "chocolate": [210, 105, 30],
      "coral": [255, 127, 80],
      "cornflowerblue": [100, 149, 237],
      "cornsilk": [255, 248, 220],
      "crimson": [220, 20, 60],
      "cyan": [0, 255, 255],
      "darkblue": [0, 0, 139],
      "darkcyan": [0, 139, 139],
      "darkgoldenrod": [184, 134, 11],
      "darkgray": [169, 169, 169],
      "darkgreen": [0, 100, 0],
      "darkgrey": [169, 169, 169],
      "darkkhaki": [189, 183, 107],
      "darkmagenta": [139, 0, 139],
      "darkolivegreen": [85, 107, 47],
      "darkorange": [255, 140, 0],
      "darkorchid": [153, 50, 204],
      "darkred": [139, 0, 0],
      "darksalmon": [233, 150, 122],
      "darkseagreen": [143, 188, 143],
      "darkslateblue": [72, 61, 139],
      "darkslategray": [47, 79, 79],
      "darkslategrey": [47, 79, 79],
      "darkturquoise": [0, 206, 209],
      "darkviolet": [148, 0, 211],
      "deeppink": [255, 20, 147],
      "deepskyblue": [0, 191, 255],
      "dimgray": [105, 105, 105],
      "dimgrey": [105, 105, 105],
      "dodgerblue": [30, 144, 255],
      "firebrick": [178, 34, 34],
      "floralwhite": [255, 250, 240],
      "forestgreen": [34, 139, 34],
      "fuchsia": [255, 0, 255],
      "gainsboro": [220, 220, 220],
      "ghostwhite": [248, 248, 255],
      "gold": [255, 215, 0],
      "goldenrod": [218, 165, 32],
      "gray": [128, 128, 128],
      "green": [0, 128, 0],
      "greenyellow": [173, 255, 47],
      "grey": [128, 128, 128],
      "honeydew": [240, 255, 240],
      "hotpink": [255, 105, 180],
      "indianred": [205, 92, 92],
      "indigo": [75, 0, 130],
      "ivory": [255, 255, 240],
      "khaki": [240, 230, 140],
      "lavender": [230, 230, 250],
      "lavenderblush": [255, 240, 245],
      "lawngreen": [124, 252, 0],
      "lemonchiffon": [255, 250, 205],
      "lightblue": [173, 216, 230],
      "lightcoral": [240, 128, 128],
      "lightcyan": [224, 255, 255],
      "lightgoldenrodyellow": [250, 250, 210],
      "lightgray": [211, 211, 211],
      "lightgreen": [144, 238, 144],
      "lightgrey": [211, 211, 211],
      "lightpink": [255, 182, 193],
      "lightsalmon": [255, 160, 122],
      "lightseagreen": [32, 178, 170],
      "lightskyblue": [135, 206, 250],
      "lightslategray": [119, 136, 153],
      "lightslategrey": [119, 136, 153],
      "lightsteelblue": [176, 196, 222],
      "lightyellow": [255, 255, 224],
      "lime": [0, 255, 0],
      "limegreen": [50, 205, 50],
      "linen": [250, 240, 230],
      "magenta": [255, 0, 255],
      "maroon": [128, 0, 0],
      "mediumaquamarine": [102, 205, 170],
      "mediumblue": [0, 0, 205],
      "mediumorchid": [186, 85, 211],
      "mediumpurple": [147, 112, 219],
      "mediumseagreen": [60, 179, 113],
      "mediumslateblue": [123, 104, 238],
      "mediumspringgreen": [0, 250, 154],
      "mediumturquoise": [72, 209, 204],
      "mediumvioletred": [199, 21, 133],
      "midnightblue": [25, 25, 112],
      "mintcream": [245, 255, 250],
      "mistyrose": [255, 228, 225],
      "moccasin": [255, 228, 181],
      "navajowhite": [255, 222, 173],
      "navy": [0, 0, 128],
      "oldlace": [253, 245, 230],
      "olive": [128, 128, 0],
      "olivedrab": [107, 142, 35],
      "orange": [255, 165, 0],
      "orangered": [255, 69, 0],
      "orchid": [218, 112, 214],
      "palegoldenrod": [238, 232, 170],
      "palegreen": [152, 251, 152],
      "paleturquoise": [175, 238, 238],
      "palevioletred": [219, 112, 147],
      "papayawhip": [255, 239, 213],
      "peachpuff": [255, 218, 185],
      "peru": [205, 133, 63],
      "pink": [255, 192, 203],
      "plum": [221, 160, 221],
      "powderblue": [176, 224, 230],
      "purple": [128, 0, 128],
      "rebeccapurple": [102, 51, 153],
      "red": [255, 0, 0],
      "rosybrown": [188, 143, 143],
      "royalblue": [65, 105, 225],
      "saddlebrown": [139, 69, 19],
      "salmon": [250, 128, 114],
      "sandybrown": [244, 164, 96],
      "seagreen": [46, 139, 87],
      "seashell": [255, 245, 238],
      "sienna": [160, 82, 45],
      "silver": [192, 192, 192],
      "skyblue": [135, 206, 235],
      "slateblue": [106, 90, 205],
      "slategray": [112, 128, 144],
      "slategrey": [112, 128, 144],
      "snow": [255, 250, 250],
      "springgreen": [0, 255, 127],
      "steelblue": [70, 130, 180],
      "tan": [210, 180, 140],
      "teal": [0, 128, 128],
      "thistle": [216, 191, 216],
      "tomato": [255, 99, 71],
      "turquoise": [64, 224, 208],
      "violet": [238, 130, 238],
      "wheat": [245, 222, 179],
      "white": [255, 255, 255],
      "whitesmoke": [245, 245, 245],
      "yellow": [255, 255, 0],
      "yellowgreen": [154, 205, 50]
    };
  }
});

// ../../node_modules/color-convert/conversions.js
var require_conversions = __commonJS({
  "../../node_modules/color-convert/conversions.js"(exports2, module2) {
    "use strict";
    var cssKeywords = require_color_name();
    var reverseKeywords = {};
    for (key in cssKeywords) {
      if (cssKeywords.hasOwnProperty(key)) {
        reverseKeywords[cssKeywords[key]] = key;
      }
    }
    var key;
    var convert = module2.exports = {
      rgb: { channels: 3, labels: "rgb" },
      hsl: { channels: 3, labels: "hsl" },
      hsv: { channels: 3, labels: "hsv" },
      hwb: { channels: 3, labels: "hwb" },
      cmyk: { channels: 4, labels: "cmyk" },
      xyz: { channels: 3, labels: "xyz" },
      lab: { channels: 3, labels: "lab" },
      lch: { channels: 3, labels: "lch" },
      hex: { channels: 1, labels: ["hex"] },
      keyword: { channels: 1, labels: ["keyword"] },
      ansi16: { channels: 1, labels: ["ansi16"] },
      ansi256: { channels: 1, labels: ["ansi256"] },
      hcg: { channels: 3, labels: ["h", "c", "g"] },
      apple: { channels: 3, labels: ["r16", "g16", "b16"] },
      gray: { channels: 1, labels: ["gray"] }
    };
    for (model in convert) {
      if (convert.hasOwnProperty(model)) {
        if (!("channels" in convert[model])) {
          throw new Error("missing channels property: " + model);
        }
        if (!("labels" in convert[model])) {
          throw new Error("missing channel labels property: " + model);
        }
        if (convert[model].labels.length !== convert[model].channels) {
          throw new Error("channel and label counts mismatch: " + model);
        }
        channels = convert[model].channels;
        labels = convert[model].labels;
        delete convert[model].channels;
        delete convert[model].labels;
        Object.defineProperty(convert[model], "channels", { value: channels });
        Object.defineProperty(convert[model], "labels", { value: labels });
      }
    }
    var channels;
    var labels;
    var model;
    convert.rgb.hsl = function(rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var min = Math.min(r, g, b);
      var max = Math.max(r, g, b);
      var delta = max - min;
      var h;
      var s;
      var l;
      if (max === min) {
        h = 0;
      } else if (r === max) {
        h = (g - b) / delta;
      } else if (g === max) {
        h = 2 + (b - r) / delta;
      } else if (b === max) {
        h = 4 + (r - g) / delta;
      }
      h = Math.min(h * 60, 360);
      if (h < 0) {
        h += 360;
      }
      l = (min + max) / 2;
      if (max === min) {
        s = 0;
      } else if (l <= 0.5) {
        s = delta / (max + min);
      } else {
        s = delta / (2 - max - min);
      }
      return [h, s * 100, l * 100];
    };
    convert.rgb.hsv = function(rgb) {
      var rdif;
      var gdif;
      var bdif;
      var h;
      var s;
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var v = Math.max(r, g, b);
      var diff = v - Math.min(r, g, b);
      var diffc = function(c) {
        return (v - c) / 6 / diff + 1 / 2;
      };
      if (diff === 0) {
        h = s = 0;
      } else {
        s = diff / v;
        rdif = diffc(r);
        gdif = diffc(g);
        bdif = diffc(b);
        if (r === v) {
          h = bdif - gdif;
        } else if (g === v) {
          h = 1 / 3 + rdif - bdif;
        } else if (b === v) {
          h = 2 / 3 + gdif - rdif;
        }
        if (h < 0) {
          h += 1;
        } else if (h > 1) {
          h -= 1;
        }
      }
      return [
        h * 360,
        s * 100,
        v * 100
      ];
    };
    convert.rgb.hwb = function(rgb) {
      var r = rgb[0];
      var g = rgb[1];
      var b = rgb[2];
      var h = convert.rgb.hsl(rgb)[0];
      var w = 1 / 255 * Math.min(r, Math.min(g, b));
      b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));
      return [h, w * 100, b * 100];
    };
    convert.rgb.cmyk = function(rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var c;
      var m;
      var y;
      var k;
      k = Math.min(1 - r, 1 - g, 1 - b);
      c = (1 - r - k) / (1 - k) || 0;
      m = (1 - g - k) / (1 - k) || 0;
      y = (1 - b - k) / (1 - k) || 0;
      return [c * 100, m * 100, y * 100, k * 100];
    };
    function comparativeDistance(x, y) {
      return Math.pow(x[0] - y[0], 2) + Math.pow(x[1] - y[1], 2) + Math.pow(x[2] - y[2], 2);
    }
    convert.rgb.keyword = function(rgb) {
      var reversed = reverseKeywords[rgb];
      if (reversed) {
        return reversed;
      }
      var currentClosestDistance = Infinity;
      var currentClosestKeyword;
      for (var keyword in cssKeywords) {
        if (cssKeywords.hasOwnProperty(keyword)) {
          var value = cssKeywords[keyword];
          var distance = comparativeDistance(rgb, value);
          if (distance < currentClosestDistance) {
            currentClosestDistance = distance;
            currentClosestKeyword = keyword;
          }
        }
      }
      return currentClosestKeyword;
    };
    convert.keyword.rgb = function(keyword) {
      return cssKeywords[keyword];
    };
    convert.rgb.xyz = function(rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
      g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
      b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;
      var x = r * 0.4124 + g * 0.3576 + b * 0.1805;
      var y = r * 0.2126 + g * 0.7152 + b * 0.0722;
      var z5 = r * 0.0193 + g * 0.1192 + b * 0.9505;
      return [x * 100, y * 100, z5 * 100];
    };
    convert.rgb.lab = function(rgb) {
      var xyz = convert.rgb.xyz(rgb);
      var x = xyz[0];
      var y = xyz[1];
      var z5 = xyz[2];
      var l;
      var a;
      var b;
      x /= 95.047;
      y /= 100;
      z5 /= 108.883;
      x = x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y = y > 8856e-6 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
      z5 = z5 > 8856e-6 ? Math.pow(z5, 1 / 3) : 7.787 * z5 + 16 / 116;
      l = 116 * y - 16;
      a = 500 * (x - y);
      b = 200 * (y - z5);
      return [l, a, b];
    };
    convert.hsl.rgb = function(hsl) {
      var h = hsl[0] / 360;
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var t1;
      var t22;
      var t32;
      var rgb;
      var val;
      if (s === 0) {
        val = l * 255;
        return [val, val, val];
      }
      if (l < 0.5) {
        t22 = l * (1 + s);
      } else {
        t22 = l + s - l * s;
      }
      t1 = 2 * l - t22;
      rgb = [0, 0, 0];
      for (var i = 0; i < 3; i++) {
        t32 = h + 1 / 3 * -(i - 1);
        if (t32 < 0) {
          t32++;
        }
        if (t32 > 1) {
          t32--;
        }
        if (6 * t32 < 1) {
          val = t1 + (t22 - t1) * 6 * t32;
        } else if (2 * t32 < 1) {
          val = t22;
        } else if (3 * t32 < 2) {
          val = t1 + (t22 - t1) * (2 / 3 - t32) * 6;
        } else {
          val = t1;
        }
        rgb[i] = val * 255;
      }
      return rgb;
    };
    convert.hsl.hsv = function(hsl) {
      var h = hsl[0];
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var smin = s;
      var lmin = Math.max(l, 0.01);
      var sv;
      var v;
      l *= 2;
      s *= l <= 1 ? l : 2 - l;
      smin *= lmin <= 1 ? lmin : 2 - lmin;
      v = (l + s) / 2;
      sv = l === 0 ? 2 * smin / (lmin + smin) : 2 * s / (l + s);
      return [h, sv * 100, v * 100];
    };
    convert.hsv.rgb = function(hsv) {
      var h = hsv[0] / 60;
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var hi = Math.floor(h) % 6;
      var f = h - Math.floor(h);
      var p = 255 * v * (1 - s);
      var q = 255 * v * (1 - s * f);
      var t5 = 255 * v * (1 - s * (1 - f));
      v *= 255;
      switch (hi) {
        case 0:
          return [v, t5, p];
        case 1:
          return [q, v, p];
        case 2:
          return [p, v, t5];
        case 3:
          return [p, q, v];
        case 4:
          return [t5, p, v];
        case 5:
          return [v, p, q];
      }
    };
    convert.hsv.hsl = function(hsv) {
      var h = hsv[0];
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var vmin = Math.max(v, 0.01);
      var lmin;
      var sl;
      var l;
      l = (2 - s) * v;
      lmin = (2 - s) * vmin;
      sl = s * vmin;
      sl /= lmin <= 1 ? lmin : 2 - lmin;
      sl = sl || 0;
      l /= 2;
      return [h, sl * 100, l * 100];
    };
    convert.hwb.rgb = function(hwb) {
      var h = hwb[0] / 360;
      var wh = hwb[1] / 100;
      var bl = hwb[2] / 100;
      var ratio = wh + bl;
      var i;
      var v;
      var f;
      var n;
      if (ratio > 1) {
        wh /= ratio;
        bl /= ratio;
      }
      i = Math.floor(6 * h);
      v = 1 - bl;
      f = 6 * h - i;
      if ((i & 1) !== 0) {
        f = 1 - f;
      }
      n = wh + f * (v - wh);
      var r;
      var g;
      var b;
      switch (i) {
        default:
        case 6:
        case 0:
          r = v;
          g = n;
          b = wh;
          break;
        case 1:
          r = n;
          g = v;
          b = wh;
          break;
        case 2:
          r = wh;
          g = v;
          b = n;
          break;
        case 3:
          r = wh;
          g = n;
          b = v;
          break;
        case 4:
          r = n;
          g = wh;
          b = v;
          break;
        case 5:
          r = v;
          g = wh;
          b = n;
          break;
      }
      return [r * 255, g * 255, b * 255];
    };
    convert.cmyk.rgb = function(cmyk) {
      var c = cmyk[0] / 100;
      var m = cmyk[1] / 100;
      var y = cmyk[2] / 100;
      var k = cmyk[3] / 100;
      var r;
      var g;
      var b;
      r = 1 - Math.min(1, c * (1 - k) + k);
      g = 1 - Math.min(1, m * (1 - k) + k);
      b = 1 - Math.min(1, y * (1 - k) + k);
      return [r * 255, g * 255, b * 255];
    };
    convert.xyz.rgb = function(xyz) {
      var x = xyz[0] / 100;
      var y = xyz[1] / 100;
      var z5 = xyz[2] / 100;
      var r;
      var g;
      var b;
      r = x * 3.2406 + y * -1.5372 + z5 * -0.4986;
      g = x * -0.9689 + y * 1.8758 + z5 * 0.0415;
      b = x * 0.0557 + y * -0.204 + z5 * 1.057;
      r = r > 31308e-7 ? 1.055 * Math.pow(r, 1 / 2.4) - 0.055 : r * 12.92;
      g = g > 31308e-7 ? 1.055 * Math.pow(g, 1 / 2.4) - 0.055 : g * 12.92;
      b = b > 31308e-7 ? 1.055 * Math.pow(b, 1 / 2.4) - 0.055 : b * 12.92;
      r = Math.min(Math.max(0, r), 1);
      g = Math.min(Math.max(0, g), 1);
      b = Math.min(Math.max(0, b), 1);
      return [r * 255, g * 255, b * 255];
    };
    convert.xyz.lab = function(xyz) {
      var x = xyz[0];
      var y = xyz[1];
      var z5 = xyz[2];
      var l;
      var a;
      var b;
      x /= 95.047;
      y /= 100;
      z5 /= 108.883;
      x = x > 8856e-6 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
      y = y > 8856e-6 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
      z5 = z5 > 8856e-6 ? Math.pow(z5, 1 / 3) : 7.787 * z5 + 16 / 116;
      l = 116 * y - 16;
      a = 500 * (x - y);
      b = 200 * (y - z5);
      return [l, a, b];
    };
    convert.lab.xyz = function(lab) {
      var l = lab[0];
      var a = lab[1];
      var b = lab[2];
      var x;
      var y;
      var z5;
      y = (l + 16) / 116;
      x = a / 500 + y;
      z5 = y - b / 200;
      var y2 = Math.pow(y, 3);
      var x2 = Math.pow(x, 3);
      var z22 = Math.pow(z5, 3);
      y = y2 > 8856e-6 ? y2 : (y - 16 / 116) / 7.787;
      x = x2 > 8856e-6 ? x2 : (x - 16 / 116) / 7.787;
      z5 = z22 > 8856e-6 ? z22 : (z5 - 16 / 116) / 7.787;
      x *= 95.047;
      y *= 100;
      z5 *= 108.883;
      return [x, y, z5];
    };
    convert.lab.lch = function(lab) {
      var l = lab[0];
      var a = lab[1];
      var b = lab[2];
      var hr;
      var h;
      var c;
      hr = Math.atan2(b, a);
      h = hr * 360 / 2 / Math.PI;
      if (h < 0) {
        h += 360;
      }
      c = Math.sqrt(a * a + b * b);
      return [l, c, h];
    };
    convert.lch.lab = function(lch) {
      var l = lch[0];
      var c = lch[1];
      var h = lch[2];
      var a;
      var b;
      var hr;
      hr = h / 360 * 2 * Math.PI;
      a = c * Math.cos(hr);
      b = c * Math.sin(hr);
      return [l, a, b];
    };
    convert.rgb.ansi16 = function(args) {
      var r = args[0];
      var g = args[1];
      var b = args[2];
      var value = 1 in arguments ? arguments[1] : convert.rgb.hsv(args)[2];
      value = Math.round(value / 50);
      if (value === 0) {
        return 30;
      }
      var ansi = 30 + (Math.round(b / 255) << 2 | Math.round(g / 255) << 1 | Math.round(r / 255));
      if (value === 2) {
        ansi += 60;
      }
      return ansi;
    };
    convert.hsv.ansi16 = function(args) {
      return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
    };
    convert.rgb.ansi256 = function(args) {
      var r = args[0];
      var g = args[1];
      var b = args[2];
      if (r === g && g === b) {
        if (r < 8) {
          return 16;
        }
        if (r > 248) {
          return 231;
        }
        return Math.round((r - 8) / 247 * 24) + 232;
      }
      var ansi = 16 + 36 * Math.round(r / 255 * 5) + 6 * Math.round(g / 255 * 5) + Math.round(b / 255 * 5);
      return ansi;
    };
    convert.ansi16.rgb = function(args) {
      var color = args % 10;
      if (color === 0 || color === 7) {
        if (args > 50) {
          color += 3.5;
        }
        color = color / 10.5 * 255;
        return [color, color, color];
      }
      var mult = (~~(args > 50) + 1) * 0.5;
      var r = (color & 1) * mult * 255;
      var g = (color >> 1 & 1) * mult * 255;
      var b = (color >> 2 & 1) * mult * 255;
      return [r, g, b];
    };
    convert.ansi256.rgb = function(args) {
      if (args >= 232) {
        var c = (args - 232) * 10 + 8;
        return [c, c, c];
      }
      args -= 16;
      var rem;
      var r = Math.floor(args / 36) / 5 * 255;
      var g = Math.floor((rem = args % 36) / 6) / 5 * 255;
      var b = rem % 6 / 5 * 255;
      return [r, g, b];
    };
    convert.rgb.hex = function(args) {
      var integer = ((Math.round(args[0]) & 255) << 16) + ((Math.round(args[1]) & 255) << 8) + (Math.round(args[2]) & 255);
      var string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert.hex.rgb = function(args) {
      var match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
      if (!match) {
        return [0, 0, 0];
      }
      var colorString = match[0];
      if (match[0].length === 3) {
        colorString = colorString.split("").map(function(char) {
          return char + char;
        }).join("");
      }
      var integer = parseInt(colorString, 16);
      var r = integer >> 16 & 255;
      var g = integer >> 8 & 255;
      var b = integer & 255;
      return [r, g, b];
    };
    convert.rgb.hcg = function(rgb) {
      var r = rgb[0] / 255;
      var g = rgb[1] / 255;
      var b = rgb[2] / 255;
      var max = Math.max(Math.max(r, g), b);
      var min = Math.min(Math.min(r, g), b);
      var chroma = max - min;
      var grayscale;
      var hue;
      if (chroma < 1) {
        grayscale = min / (1 - chroma);
      } else {
        grayscale = 0;
      }
      if (chroma <= 0) {
        hue = 0;
      } else if (max === r) {
        hue = (g - b) / chroma % 6;
      } else if (max === g) {
        hue = 2 + (b - r) / chroma;
      } else {
        hue = 4 + (r - g) / chroma + 4;
      }
      hue /= 6;
      hue %= 1;
      return [hue * 360, chroma * 100, grayscale * 100];
    };
    convert.hsl.hcg = function(hsl) {
      var s = hsl[1] / 100;
      var l = hsl[2] / 100;
      var c = 1;
      var f = 0;
      if (l < 0.5) {
        c = 2 * s * l;
      } else {
        c = 2 * s * (1 - l);
      }
      if (c < 1) {
        f = (l - 0.5 * c) / (1 - c);
      }
      return [hsl[0], c * 100, f * 100];
    };
    convert.hsv.hcg = function(hsv) {
      var s = hsv[1] / 100;
      var v = hsv[2] / 100;
      var c = s * v;
      var f = 0;
      if (c < 1) {
        f = (v - c) / (1 - c);
      }
      return [hsv[0], c * 100, f * 100];
    };
    convert.hcg.rgb = function(hcg) {
      var h = hcg[0] / 360;
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      if (c === 0) {
        return [g * 255, g * 255, g * 255];
      }
      var pure = [0, 0, 0];
      var hi = h % 1 * 6;
      var v = hi % 1;
      var w = 1 - v;
      var mg = 0;
      switch (Math.floor(hi)) {
        case 0:
          pure[0] = 1;
          pure[1] = v;
          pure[2] = 0;
          break;
        case 1:
          pure[0] = w;
          pure[1] = 1;
          pure[2] = 0;
          break;
        case 2:
          pure[0] = 0;
          pure[1] = 1;
          pure[2] = v;
          break;
        case 3:
          pure[0] = 0;
          pure[1] = w;
          pure[2] = 1;
          break;
        case 4:
          pure[0] = v;
          pure[1] = 0;
          pure[2] = 1;
          break;
        default:
          pure[0] = 1;
          pure[1] = 0;
          pure[2] = w;
      }
      mg = (1 - c) * g;
      return [
        (c * pure[0] + mg) * 255,
        (c * pure[1] + mg) * 255,
        (c * pure[2] + mg) * 255
      ];
    };
    convert.hcg.hsv = function(hcg) {
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      var v = c + g * (1 - c);
      var f = 0;
      if (v > 0) {
        f = c / v;
      }
      return [hcg[0], f * 100, v * 100];
    };
    convert.hcg.hsl = function(hcg) {
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      var l = g * (1 - c) + 0.5 * c;
      var s = 0;
      if (l > 0 && l < 0.5) {
        s = c / (2 * l);
      } else if (l >= 0.5 && l < 1) {
        s = c / (2 * (1 - l));
      }
      return [hcg[0], s * 100, l * 100];
    };
    convert.hcg.hwb = function(hcg) {
      var c = hcg[1] / 100;
      var g = hcg[2] / 100;
      var v = c + g * (1 - c);
      return [hcg[0], (v - c) * 100, (1 - v) * 100];
    };
    convert.hwb.hcg = function(hwb) {
      var w = hwb[1] / 100;
      var b = hwb[2] / 100;
      var v = 1 - b;
      var c = v - w;
      var g = 0;
      if (c < 1) {
        g = (v - c) / (1 - c);
      }
      return [hwb[0], c * 100, g * 100];
    };
    convert.apple.rgb = function(apple) {
      return [apple[0] / 65535 * 255, apple[1] / 65535 * 255, apple[2] / 65535 * 255];
    };
    convert.rgb.apple = function(rgb) {
      return [rgb[0] / 255 * 65535, rgb[1] / 255 * 65535, rgb[2] / 255 * 65535];
    };
    convert.gray.rgb = function(args) {
      return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
    };
    convert.gray.hsl = convert.gray.hsv = function(args) {
      return [0, 0, args[0]];
    };
    convert.gray.hwb = function(gray) {
      return [0, 100, gray[0]];
    };
    convert.gray.cmyk = function(gray) {
      return [0, 0, 0, gray[0]];
    };
    convert.gray.lab = function(gray) {
      return [gray[0], 0, 0];
    };
    convert.gray.hex = function(gray) {
      var val = Math.round(gray[0] / 100 * 255) & 255;
      var integer = (val << 16) + (val << 8) + val;
      var string = integer.toString(16).toUpperCase();
      return "000000".substring(string.length) + string;
    };
    convert.rgb.gray = function(rgb) {
      var val = (rgb[0] + rgb[1] + rgb[2]) / 3;
      return [val / 255 * 100];
    };
  }
});

// ../../node_modules/color-convert/route.js
var require_route = __commonJS({
  "../../node_modules/color-convert/route.js"(exports2, module2) {
    "use strict";
    var conversions = require_conversions();
    function buildGraph() {
      var graph = {};
      var models = Object.keys(conversions);
      for (var len = models.length, i = 0; i < len; i++) {
        graph[models[i]] = {
          // http://jsperf.com/1-vs-infinity
          // micro-opt, but this is simple.
          distance: -1,
          parent: null
        };
      }
      return graph;
    }
    function deriveBFS(fromModel) {
      var graph = buildGraph();
      var queue = [fromModel];
      graph[fromModel].distance = 0;
      while (queue.length) {
        var current = queue.pop();
        var adjacents = Object.keys(conversions[current]);
        for (var len = adjacents.length, i = 0; i < len; i++) {
          var adjacent = adjacents[i];
          var node = graph[adjacent];
          if (node.distance === -1) {
            node.distance = graph[current].distance + 1;
            node.parent = current;
            queue.unshift(adjacent);
          }
        }
      }
      return graph;
    }
    function link(from, to) {
      return function(args) {
        return to(from(args));
      };
    }
    function wrapConversion(toModel, graph) {
      var path = [graph[toModel].parent, toModel];
      var fn = conversions[graph[toModel].parent][toModel];
      var cur = graph[toModel].parent;
      while (graph[cur].parent) {
        path.unshift(graph[cur].parent);
        fn = link(conversions[graph[cur].parent][cur], fn);
        cur = graph[cur].parent;
      }
      fn.conversion = path;
      return fn;
    }
    module2.exports = function(fromModel) {
      var graph = deriveBFS(fromModel);
      var conversion = {};
      var models = Object.keys(graph);
      for (var len = models.length, i = 0; i < len; i++) {
        var toModel = models[i];
        var node = graph[toModel];
        if (node.parent === null) {
          continue;
        }
        conversion[toModel] = wrapConversion(toModel, graph);
      }
      return conversion;
    };
  }
});

// ../../node_modules/color-convert/index.js
var require_color_convert = __commonJS({
  "../../node_modules/color-convert/index.js"(exports2, module2) {
    "use strict";
    var conversions = require_conversions();
    var route = require_route();
    var convert = {};
    var models = Object.keys(conversions);
    function wrapRaw(fn) {
      var wrappedFn = function(args) {
        if (args === void 0 || args === null) {
          return args;
        }
        if (arguments.length > 1) {
          args = Array.prototype.slice.call(arguments);
        }
        return fn(args);
      };
      if ("conversion" in fn) {
        wrappedFn.conversion = fn.conversion;
      }
      return wrappedFn;
    }
    function wrapRounded(fn) {
      var wrappedFn = function(args) {
        if (args === void 0 || args === null) {
          return args;
        }
        if (arguments.length > 1) {
          args = Array.prototype.slice.call(arguments);
        }
        var result = fn(args);
        if (typeof result === "object") {
          for (var len = result.length, i = 0; i < len; i++) {
            result[i] = Math.round(result[i]);
          }
        }
        return result;
      };
      if ("conversion" in fn) {
        wrappedFn.conversion = fn.conversion;
      }
      return wrappedFn;
    }
    models.forEach(function(fromModel) {
      convert[fromModel] = {};
      Object.defineProperty(convert[fromModel], "channels", { value: conversions[fromModel].channels });
      Object.defineProperty(convert[fromModel], "labels", { value: conversions[fromModel].labels });
      var routes = route(fromModel);
      var routeModels = Object.keys(routes);
      routeModels.forEach(function(toModel) {
        var fn = routes[toModel];
        convert[fromModel][toModel] = wrapRounded(fn);
        convert[fromModel][toModel].raw = wrapRaw(fn);
      });
    });
    module2.exports = convert;
  }
});

// ../babel-plugin-react-compiler/node_modules/ansi-styles/index.js
var require_ansi_styles = __commonJS({
  "../babel-plugin-react-compiler/node_modules/ansi-styles/index.js"(exports2, module2) {
    "use strict";
    var colorConvert = require_color_convert();
    var wrapAnsi16 = (fn, offset) => function() {
      const code = fn.apply(colorConvert, arguments);
      return `\x1B[${code + offset}m`;
    };
    var wrapAnsi256 = (fn, offset) => function() {
      const code = fn.apply(colorConvert, arguments);
      return `\x1B[${38 + offset};5;${code}m`;
    };
    var wrapAnsi16m = (fn, offset) => function() {
      const rgb = fn.apply(colorConvert, arguments);
      return `\x1B[${38 + offset};2;${rgb[0]};${rgb[1]};${rgb[2]}m`;
    };
    function assembleStyles() {
      const codes = /* @__PURE__ */ new Map();
      const styles = {
        modifier: {
          reset: [0, 0],
          // 21 isn't widely supported and 22 does the same thing
          bold: [1, 22],
          dim: [2, 22],
          italic: [3, 23],
          underline: [4, 24],
          inverse: [7, 27],
          hidden: [8, 28],
          strikethrough: [9, 29]
        },
        color: {
          black: [30, 39],
          red: [31, 39],
          green: [32, 39],
          yellow: [33, 39],
          blue: [34, 39],
          magenta: [35, 39],
          cyan: [36, 39],
          white: [37, 39],
          gray: [90, 39],
          // Bright color
          redBright: [91, 39],
          greenBright: [92, 39],
          yellowBright: [93, 39],
          blueBright: [94, 39],
          magentaBright: [95, 39],
          cyanBright: [96, 39],
          whiteBright: [97, 39]
        },
        bgColor: {
          bgBlack: [40, 49],
          bgRed: [41, 49],
          bgGreen: [42, 49],
          bgYellow: [43, 49],
          bgBlue: [44, 49],
          bgMagenta: [45, 49],
          bgCyan: [46, 49],
          bgWhite: [47, 49],
          // Bright color
          bgBlackBright: [100, 49],
          bgRedBright: [101, 49],
          bgGreenBright: [102, 49],
          bgYellowBright: [103, 49],
          bgBlueBright: [104, 49],
          bgMagentaBright: [105, 49],
          bgCyanBright: [106, 49],
          bgWhiteBright: [107, 49]
        }
      };
      styles.color.grey = styles.color.gray;
      for (const groupName of Object.keys(styles)) {
        const group = styles[groupName];
        for (const styleName of Object.keys(group)) {
          const style = group[styleName];
          styles[styleName] = {
            open: `\x1B[${style[0]}m`,
            close: `\x1B[${style[1]}m`
          };
          group[styleName] = styles[styleName];
          codes.set(style[0], style[1]);
        }
        Object.defineProperty(styles, groupName, {
          value: group,
          enumerable: false
        });
        Object.defineProperty(styles, "codes", {
          value: codes,
          enumerable: false
        });
      }
      const ansi2ansi = (n) => n;
      const rgb2rgb = (r, g, b) => [r, g, b];
      styles.color.close = "\x1B[39m";
      styles.bgColor.close = "\x1B[49m";
      styles.color.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 0)
      };
      styles.color.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 0)
      };
      styles.color.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 0)
      };
      styles.bgColor.ansi = {
        ansi: wrapAnsi16(ansi2ansi, 10)
      };
      styles.bgColor.ansi256 = {
        ansi256: wrapAnsi256(ansi2ansi, 10)
      };
      styles.bgColor.ansi16m = {
        rgb: wrapAnsi16m(rgb2rgb, 10)
      };
      for (let key of Object.keys(colorConvert)) {
        if (typeof colorConvert[key] !== "object") {
          continue;
        }
        const suite = colorConvert[key];
        if (key === "ansi16") {
          key = "ansi";
        }
        if ("ansi16" in suite) {
          styles.color.ansi[key] = wrapAnsi16(suite.ansi16, 0);
          styles.bgColor.ansi[key] = wrapAnsi16(suite.ansi16, 10);
        }
        if ("ansi256" in suite) {
          styles.color.ansi256[key] = wrapAnsi256(suite.ansi256, 0);
          styles.bgColor.ansi256[key] = wrapAnsi256(suite.ansi256, 10);
        }
        if ("rgb" in suite) {
          styles.color.ansi16m[key] = wrapAnsi16m(suite.rgb, 0);
          styles.bgColor.ansi16m[key] = wrapAnsi16m(suite.rgb, 10);
        }
      }
      return styles;
    }
    Object.defineProperty(module2, "exports", {
      enumerable: true,
      get: assembleStyles
    });
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/collections.js
var require_collections = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/collections.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.printIteratorEntries = printIteratorEntries;
    exports2.printIteratorValues = printIteratorValues;
    exports2.printListItems = printListItems;
    exports2.printObjectProperties = printObjectProperties;
    var getKeysOfEnumerableProperties = (object) => {
      const keys = Object.keys(object).sort();
      if (Object.getOwnPropertySymbols) {
        Object.getOwnPropertySymbols(object).forEach((symbol) => {
          if (Object.getOwnPropertyDescriptor(object, symbol).enumerable) {
            keys.push(symbol);
          }
        });
      }
      return keys;
    };
    function printIteratorEntries(iterator, config, indentation, depth, refs, printer, separator = ": ") {
      let result = "";
      let current = iterator.next();
      if (!current.done) {
        result += config.spacingOuter;
        const indentationNext = indentation + config.indent;
        while (!current.done) {
          const name = printer(
            current.value[0],
            config,
            indentationNext,
            depth,
            refs
          );
          const value = printer(
            current.value[1],
            config,
            indentationNext,
            depth,
            refs
          );
          result += indentationNext + name + separator + value;
          current = iterator.next();
          if (!current.done) {
            result += "," + config.spacingInner;
          } else if (!config.min) {
            result += ",";
          }
        }
        result += config.spacingOuter + indentation;
      }
      return result;
    }
    function printIteratorValues(iterator, config, indentation, depth, refs, printer) {
      let result = "";
      let current = iterator.next();
      if (!current.done) {
        result += config.spacingOuter;
        const indentationNext = indentation + config.indent;
        while (!current.done) {
          result += indentationNext + printer(current.value, config, indentationNext, depth, refs);
          current = iterator.next();
          if (!current.done) {
            result += "," + config.spacingInner;
          } else if (!config.min) {
            result += ",";
          }
        }
        result += config.spacingOuter + indentation;
      }
      return result;
    }
    function printListItems(list, config, indentation, depth, refs, printer) {
      let result = "";
      if (list.length) {
        result += config.spacingOuter;
        const indentationNext = indentation + config.indent;
        for (let i = 0; i < list.length; i++) {
          result += indentationNext + printer(list[i], config, indentationNext, depth, refs);
          if (i < list.length - 1) {
            result += "," + config.spacingInner;
          } else if (!config.min) {
            result += ",";
          }
        }
        result += config.spacingOuter + indentation;
      }
      return result;
    }
    function printObjectProperties(val, config, indentation, depth, refs, printer) {
      let result = "";
      const keys = getKeysOfEnumerableProperties(val);
      if (keys.length) {
        result += config.spacingOuter;
        const indentationNext = indentation + config.indent;
        for (let i = 0; i < keys.length; i++) {
          const key = keys[i];
          const name = printer(key, config, indentationNext, depth, refs);
          const value = printer(val[key], config, indentationNext, depth, refs);
          result += indentationNext + name + ": " + value;
          if (i < keys.length - 1) {
            result += "," + config.spacingInner;
          } else if (!config.min) {
            result += ",";
          }
        }
        result += config.spacingOuter + indentation;
      }
      return result;
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/AsymmetricMatcher.js
var require_AsymmetricMatcher = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/AsymmetricMatcher.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = exports2.test = exports2.serialize = void 0;
    var _collections = require_collections();
    var Symbol2 = global["jest-symbol-do-not-touch"] || global.Symbol;
    var asymmetricMatcher = Symbol2.for("jest.asymmetricMatcher");
    var SPACE = " ";
    var serialize = (val, config, indentation, depth, refs, printer) => {
      const stringedValue = val.toString();
      if (stringedValue === "ArrayContaining" || stringedValue === "ArrayNotContaining") {
        if (++depth > config.maxDepth) {
          return "[" + stringedValue + "]";
        }
        return stringedValue + SPACE + "[" + (0, _collections.printListItems)(
          val.sample,
          config,
          indentation,
          depth,
          refs,
          printer
        ) + "]";
      }
      if (stringedValue === "ObjectContaining" || stringedValue === "ObjectNotContaining") {
        if (++depth > config.maxDepth) {
          return "[" + stringedValue + "]";
        }
        return stringedValue + SPACE + "{" + (0, _collections.printObjectProperties)(
          val.sample,
          config,
          indentation,
          depth,
          refs,
          printer
        ) + "}";
      }
      if (stringedValue === "StringMatching" || stringedValue === "StringNotMatching") {
        return stringedValue + SPACE + printer(val.sample, config, indentation, depth, refs);
      }
      if (stringedValue === "StringContaining" || stringedValue === "StringNotContaining") {
        return stringedValue + SPACE + printer(val.sample, config, indentation, depth, refs);
      }
      return val.toAsymmetricMatcher();
    };
    exports2.serialize = serialize;
    var test = (val) => val && val.$$typeof === asymmetricMatcher;
    exports2.test = test;
    var plugin = {
      serialize,
      test
    };
    var _default = plugin;
    exports2.default = _default;
  }
});

// ../babel-plugin-react-compiler/node_modules/ansi-regex/index.js
var require_ansi_regex = __commonJS({
  "../babel-plugin-react-compiler/node_modules/ansi-regex/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (options) => {
      options = Object.assign({
        onlyFirst: false
      }, options);
      const pattern = [
        "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
        "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"
      ].join("|");
      return new RegExp(pattern, options.onlyFirst ? void 0 : "g");
    };
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/ConvertAnsi.js
var require_ConvertAnsi = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/ConvertAnsi.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = exports2.serialize = exports2.test = void 0;
    var _ansiRegex = _interopRequireDefault(require_ansi_regex());
    var _ansiStyles = _interopRequireDefault(require_ansi_styles());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var toHumanReadableAnsi = (text) => text.replace((0, _ansiRegex.default)(), (match) => {
      switch (match) {
        case _ansiStyles.default.red.close:
        case _ansiStyles.default.green.close:
        case _ansiStyles.default.cyan.close:
        case _ansiStyles.default.gray.close:
        case _ansiStyles.default.white.close:
        case _ansiStyles.default.yellow.close:
        case _ansiStyles.default.bgRed.close:
        case _ansiStyles.default.bgGreen.close:
        case _ansiStyles.default.bgYellow.close:
        case _ansiStyles.default.inverse.close:
        case _ansiStyles.default.dim.close:
        case _ansiStyles.default.bold.close:
        case _ansiStyles.default.reset.open:
        case _ansiStyles.default.reset.close:
          return "</>";
        case _ansiStyles.default.red.open:
          return "<red>";
        case _ansiStyles.default.green.open:
          return "<green>";
        case _ansiStyles.default.cyan.open:
          return "<cyan>";
        case _ansiStyles.default.gray.open:
          return "<gray>";
        case _ansiStyles.default.white.open:
          return "<white>";
        case _ansiStyles.default.yellow.open:
          return "<yellow>";
        case _ansiStyles.default.bgRed.open:
          return "<bgRed>";
        case _ansiStyles.default.bgGreen.open:
          return "<bgGreen>";
        case _ansiStyles.default.bgYellow.open:
          return "<bgYellow>";
        case _ansiStyles.default.inverse.open:
          return "<inverse>";
        case _ansiStyles.default.dim.open:
          return "<dim>";
        case _ansiStyles.default.bold.open:
          return "<bold>";
        default:
          return "";
      }
    });
    var test = (val) => typeof val === "string" && !!val.match((0, _ansiRegex.default)());
    exports2.test = test;
    var serialize = (val, config, indentation, depth, refs, printer) => printer(toHumanReadableAnsi(val), config, indentation, depth, refs);
    exports2.serialize = serialize;
    var plugin = {
      serialize,
      test
    };
    var _default = plugin;
    exports2.default = _default;
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/DOMCollection.js
var require_DOMCollection = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/DOMCollection.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = exports2.serialize = exports2.test = void 0;
    var _collections = require_collections();
    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};
        var ownKeys = Object.keys(source);
        if (typeof Object.getOwnPropertySymbols === "function") {
          ownKeys = ownKeys.concat(
            Object.getOwnPropertySymbols(source).filter(function(sym) {
              return Object.getOwnPropertyDescriptor(source, sym).enumerable;
            })
          );
        }
        ownKeys.forEach(function(key) {
          _defineProperty(target, key, source[key]);
        });
      }
      return target;
    }
    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, {
          value,
          enumerable: true,
          configurable: true,
          writable: true
        });
      } else {
        obj[key] = value;
      }
      return obj;
    }
    var SPACE = " ";
    var OBJECT_NAMES = ["DOMStringMap", "NamedNodeMap"];
    var ARRAY_REGEXP = /^(HTML\w*Collection|NodeList)$/;
    var testName = (name) => OBJECT_NAMES.indexOf(name) !== -1 || ARRAY_REGEXP.test(name);
    var test = (val) => val && val.constructor && val.constructor.name && testName(val.constructor.name);
    exports2.test = test;
    var propsReducer = (props, attribute) => {
      props[attribute.name] = attribute.value;
      return props;
    };
    var serialize = (collection, config, indentation, depth, refs, printer) => {
      const name = collection.constructor.name;
      if (++depth > config.maxDepth) {
        return "[" + name + "]";
      }
      return (config.min ? "" : name + SPACE) + (OBJECT_NAMES.indexOf(name) !== -1 ? "{" + (0, _collections.printObjectProperties)(
        name === "NamedNodeMap" ? Array.prototype.reduce.call(collection, propsReducer, {}) : _objectSpread({}, collection),
        config,
        indentation,
        depth,
        refs,
        printer
      ) + "}" : "[" + (0, _collections.printListItems)(
        Array.from(collection),
        config,
        indentation,
        depth,
        refs,
        printer
      ) + "]");
    };
    exports2.serialize = serialize;
    var plugin = {
      serialize,
      test
    };
    var _default = plugin;
    exports2.default = _default;
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/lib/escapeHTML.js
var require_escapeHTML = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/lib/escapeHTML.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = escapeHTML;
    function escapeHTML(str) {
      return str.replace(/</g, "&lt;").replace(/>/g, "&gt;");
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/lib/markup.js
var require_markup = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/lib/markup.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.printElementAsLeaf = exports2.printElement = exports2.printComment = exports2.printText = exports2.printChildren = exports2.printProps = void 0;
    var _escapeHTML = _interopRequireDefault(require_escapeHTML());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var printProps = (keys, props, config, indentation, depth, refs, printer) => {
      const indentationNext = indentation + config.indent;
      const colors = config.colors;
      return keys.map((key) => {
        const value = props[key];
        let printed = printer(value, config, indentationNext, depth, refs);
        if (typeof value !== "string") {
          if (printed.indexOf("\n") !== -1) {
            printed = config.spacingOuter + indentationNext + printed + config.spacingOuter + indentation;
          }
          printed = "{" + printed + "}";
        }
        return config.spacingInner + indentation + colors.prop.open + key + colors.prop.close + "=" + colors.value.open + printed + colors.value.close;
      }).join("");
    };
    exports2.printProps = printProps;
    var printChildren = (children, config, indentation, depth, refs, printer) => children.map(
      (child) => config.spacingOuter + indentation + (typeof child === "string" ? printText(child, config) : printer(child, config, indentation, depth, refs))
    ).join("");
    exports2.printChildren = printChildren;
    var printText = (text, config) => {
      const contentColor = config.colors.content;
      return contentColor.open + (0, _escapeHTML.default)(text) + contentColor.close;
    };
    exports2.printText = printText;
    var printComment = (comment, config) => {
      const commentColor = config.colors.comment;
      return commentColor.open + "<!--" + (0, _escapeHTML.default)(comment) + "-->" + commentColor.close;
    };
    exports2.printComment = printComment;
    var printElement = (type, printedProps, printedChildren, config, indentation) => {
      const tagColor = config.colors.tag;
      return tagColor.open + "<" + type + (printedProps && tagColor.close + printedProps + config.spacingOuter + indentation + tagColor.open) + (printedChildren ? ">" + tagColor.close + printedChildren + config.spacingOuter + indentation + tagColor.open + "</" + type : (printedProps && !config.min ? "" : " ") + "/") + ">" + tagColor.close;
    };
    exports2.printElement = printElement;
    var printElementAsLeaf = (type, config) => {
      const tagColor = config.colors.tag;
      return tagColor.open + "<" + type + tagColor.close + " \u2026" + tagColor.open + " />" + tagColor.close;
    };
    exports2.printElementAsLeaf = printElementAsLeaf;
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/DOMElement.js
var require_DOMElement = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/DOMElement.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = exports2.serialize = exports2.test = void 0;
    var _markup = require_markup();
    var ELEMENT_NODE = 1;
    var TEXT_NODE = 3;
    var COMMENT_NODE = 8;
    var FRAGMENT_NODE = 11;
    var ELEMENT_REGEXP = /^((HTML|SVG)\w*)?Element$/;
    var testNode = (nodeType, name) => nodeType === ELEMENT_NODE && ELEMENT_REGEXP.test(name) || nodeType === TEXT_NODE && name === "Text" || nodeType === COMMENT_NODE && name === "Comment" || nodeType === FRAGMENT_NODE && name === "DocumentFragment";
    var test = (val) => val && val.constructor && val.constructor.name && testNode(val.nodeType, val.constructor.name);
    exports2.test = test;
    function nodeIsText(node) {
      return node.nodeType === TEXT_NODE;
    }
    function nodeIsComment(node) {
      return node.nodeType === COMMENT_NODE;
    }
    function nodeIsFragment(node) {
      return node.nodeType === FRAGMENT_NODE;
    }
    var serialize = (node, config, indentation, depth, refs, printer) => {
      if (nodeIsText(node)) {
        return (0, _markup.printText)(node.data, config);
      }
      if (nodeIsComment(node)) {
        return (0, _markup.printComment)(node.data, config);
      }
      const type = nodeIsFragment(node) ? `DocumentFragment` : node.tagName.toLowerCase();
      if (++depth > config.maxDepth) {
        return (0, _markup.printElementAsLeaf)(type, config);
      }
      return (0, _markup.printElement)(
        type,
        (0, _markup.printProps)(
          nodeIsFragment(node) ? [] : Array.from(node.attributes).map((attr) => attr.name).sort(),
          nodeIsFragment(node) ? [] : Array.from(node.attributes).reduce((props, attribute) => {
            props[attribute.name] = attribute.value;
            return props;
          }, {}),
          config,
          indentation + config.indent,
          depth,
          refs,
          printer
        ),
        (0, _markup.printChildren)(
          Array.prototype.slice.call(node.childNodes || node.children),
          config,
          indentation + config.indent,
          depth,
          refs,
          printer
        ),
        config,
        indentation
      );
    };
    exports2.serialize = serialize;
    var plugin = {
      serialize,
      test
    };
    var _default = plugin;
    exports2.default = _default;
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/Immutable.js
var require_Immutable = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/Immutable.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = exports2.test = exports2.serialize = void 0;
    var _collections = require_collections();
    var IS_ITERABLE_SENTINEL = "@@__IMMUTABLE_ITERABLE__@@";
    var IS_LIST_SENTINEL = "@@__IMMUTABLE_LIST__@@";
    var IS_KEYED_SENTINEL = "@@__IMMUTABLE_KEYED__@@";
    var IS_MAP_SENTINEL = "@@__IMMUTABLE_MAP__@@";
    var IS_ORDERED_SENTINEL = "@@__IMMUTABLE_ORDERED__@@";
    var IS_RECORD_SENTINEL = "@@__IMMUTABLE_RECORD__@@";
    var IS_SEQ_SENTINEL = "@@__IMMUTABLE_SEQ__@@";
    var IS_SET_SENTINEL = "@@__IMMUTABLE_SET__@@";
    var IS_STACK_SENTINEL = "@@__IMMUTABLE_STACK__@@";
    var getImmutableName = (name) => "Immutable." + name;
    var printAsLeaf = (name) => "[" + name + "]";
    var SPACE = " ";
    var LAZY = "\u2026";
    var printImmutableEntries = (val, config, indentation, depth, refs, printer, type) => ++depth > config.maxDepth ? printAsLeaf(getImmutableName(type)) : getImmutableName(type) + SPACE + "{" + (0, _collections.printIteratorEntries)(
      val.entries(),
      config,
      indentation,
      depth,
      refs,
      printer
    ) + "}";
    var getRecordEntries = (val) => {
      let i = 0;
      return {
        next() {
          if (i < val._keys.length) {
            const key = val._keys[i++];
            return {
              done: false,
              value: [key, val.get(key)]
            };
          }
          return {
            done: true
          };
        }
      };
    };
    var printImmutableRecord = (val, config, indentation, depth, refs, printer) => {
      const name = getImmutableName(val._name || "Record");
      return ++depth > config.maxDepth ? printAsLeaf(name) : name + SPACE + "{" + (0, _collections.printIteratorEntries)(
        getRecordEntries(val),
        config,
        indentation,
        depth,
        refs,
        printer
      ) + "}";
    };
    var printImmutableSeq = (val, config, indentation, depth, refs, printer) => {
      const name = getImmutableName("Seq");
      if (++depth > config.maxDepth) {
        return printAsLeaf(name);
      }
      if (val[IS_KEYED_SENTINEL]) {
        return name + SPACE + "{" + // from Immutable collection of entries or from ECMAScript object
        (val._iter || val._object ? (0, _collections.printIteratorEntries)(
          val.entries(),
          config,
          indentation,
          depth,
          refs,
          printer
        ) : LAZY) + "}";
      }
      return name + SPACE + "[" + (val._iter || // from Immutable collection of values
      val._array || // from ECMAScript array
      val._collection || // from ECMAScript collection in immutable v4
      val._iterable ? (0, _collections.printIteratorValues)(
        val.values(),
        config,
        indentation,
        depth,
        refs,
        printer
      ) : LAZY) + "]";
    };
    var printImmutableValues = (val, config, indentation, depth, refs, printer, type) => ++depth > config.maxDepth ? printAsLeaf(getImmutableName(type)) : getImmutableName(type) + SPACE + "[" + (0, _collections.printIteratorValues)(
      val.values(),
      config,
      indentation,
      depth,
      refs,
      printer
    ) + "]";
    var serialize = (val, config, indentation, depth, refs, printer) => {
      if (val[IS_MAP_SENTINEL]) {
        return printImmutableEntries(
          val,
          config,
          indentation,
          depth,
          refs,
          printer,
          val[IS_ORDERED_SENTINEL] ? "OrderedMap" : "Map"
        );
      }
      if (val[IS_LIST_SENTINEL]) {
        return printImmutableValues(
          val,
          config,
          indentation,
          depth,
          refs,
          printer,
          "List"
        );
      }
      if (val[IS_SET_SENTINEL]) {
        return printImmutableValues(
          val,
          config,
          indentation,
          depth,
          refs,
          printer,
          val[IS_ORDERED_SENTINEL] ? "OrderedSet" : "Set"
        );
      }
      if (val[IS_STACK_SENTINEL]) {
        return printImmutableValues(
          val,
          config,
          indentation,
          depth,
          refs,
          printer,
          "Stack"
        );
      }
      if (val[IS_SEQ_SENTINEL]) {
        return printImmutableSeq(val, config, indentation, depth, refs, printer);
      }
      return printImmutableRecord(val, config, indentation, depth, refs, printer);
    };
    exports2.serialize = serialize;
    var test = (val) => val && (val[IS_ITERABLE_SENTINEL] === true || val[IS_RECORD_SENTINEL] === true);
    exports2.test = test;
    var plugin = {
      serialize,
      test
    };
    var _default = plugin;
    exports2.default = _default;
  }
});

// ../babel-plugin-react-compiler/node_modules/react-is/cjs/react-is.production.min.js
var require_react_is_production_min = __commonJS({
  "../babel-plugin-react-compiler/node_modules/react-is/cjs/react-is.production.min.js"(exports2) {
    "use strict";
    var b = "function" === typeof Symbol && Symbol.for;
    var c = b ? Symbol.for("react.element") : 60103;
    var d = b ? Symbol.for("react.portal") : 60106;
    var e = b ? Symbol.for("react.fragment") : 60107;
    var f = b ? Symbol.for("react.strict_mode") : 60108;
    var g = b ? Symbol.for("react.profiler") : 60114;
    var h = b ? Symbol.for("react.provider") : 60109;
    var k = b ? Symbol.for("react.context") : 60110;
    var l = b ? Symbol.for("react.async_mode") : 60111;
    var m = b ? Symbol.for("react.concurrent_mode") : 60111;
    var n = b ? Symbol.for("react.forward_ref") : 60112;
    var p = b ? Symbol.for("react.suspense") : 60113;
    var q = b ? Symbol.for("react.suspense_list") : 60120;
    var r = b ? Symbol.for("react.memo") : 60115;
    var t5 = b ? Symbol.for("react.lazy") : 60116;
    var v = b ? Symbol.for("react.block") : 60121;
    var w = b ? Symbol.for("react.fundamental") : 60117;
    var x = b ? Symbol.for("react.responder") : 60118;
    var y = b ? Symbol.for("react.scope") : 60119;
    function z5(a) {
      if ("object" === typeof a && null !== a) {
        var u = a.$$typeof;
        switch (u) {
          case c:
            switch (a = a.type, a) {
              case l:
              case m:
              case e:
              case g:
              case f:
              case p:
                return a;
              default:
                switch (a = a && a.$$typeof, a) {
                  case k:
                  case n:
                  case t5:
                  case r:
                  case h:
                    return a;
                  default:
                    return u;
                }
            }
          case d:
            return u;
        }
      }
    }
    function A(a) {
      return z5(a) === m;
    }
    exports2.AsyncMode = l;
    exports2.ConcurrentMode = m;
    exports2.ContextConsumer = k;
    exports2.ContextProvider = h;
    exports2.Element = c;
    exports2.ForwardRef = n;
    exports2.Fragment = e;
    exports2.Lazy = t5;
    exports2.Memo = r;
    exports2.Portal = d;
    exports2.Profiler = g;
    exports2.StrictMode = f;
    exports2.Suspense = p;
    exports2.isAsyncMode = function(a) {
      return A(a) || z5(a) === l;
    };
    exports2.isConcurrentMode = A;
    exports2.isContextConsumer = function(a) {
      return z5(a) === k;
    };
    exports2.isContextProvider = function(a) {
      return z5(a) === h;
    };
    exports2.isElement = function(a) {
      return "object" === typeof a && null !== a && a.$$typeof === c;
    };
    exports2.isForwardRef = function(a) {
      return z5(a) === n;
    };
    exports2.isFragment = function(a) {
      return z5(a) === e;
    };
    exports2.isLazy = function(a) {
      return z5(a) === t5;
    };
    exports2.isMemo = function(a) {
      return z5(a) === r;
    };
    exports2.isPortal = function(a) {
      return z5(a) === d;
    };
    exports2.isProfiler = function(a) {
      return z5(a) === g;
    };
    exports2.isStrictMode = function(a) {
      return z5(a) === f;
    };
    exports2.isSuspense = function(a) {
      return z5(a) === p;
    };
    exports2.isValidElementType = function(a) {
      return "string" === typeof a || "function" === typeof a || a === e || a === m || a === g || a === f || a === p || a === q || "object" === typeof a && null !== a && (a.$$typeof === t5 || a.$$typeof === r || a.$$typeof === h || a.$$typeof === k || a.$$typeof === n || a.$$typeof === w || a.$$typeof === x || a.$$typeof === y || a.$$typeof === v);
    };
    exports2.typeOf = z5;
  }
});

// ../babel-plugin-react-compiler/node_modules/react-is/cjs/react-is.development.js
var require_react_is_development = __commonJS({
  "../babel-plugin-react-compiler/node_modules/react-is/cjs/react-is.development.js"(exports2) {
    "use strict";
    if (process.env.NODE_ENV !== "production") {
      (function() {
        "use strict";
        var hasSymbol = typeof Symbol === "function" && Symbol.for;
        var REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for("react.element") : 60103;
        var REACT_PORTAL_TYPE = hasSymbol ? Symbol.for("react.portal") : 60106;
        var REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for("react.fragment") : 60107;
        var REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for("react.strict_mode") : 60108;
        var REACT_PROFILER_TYPE = hasSymbol ? Symbol.for("react.profiler") : 60114;
        var REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for("react.provider") : 60109;
        var REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for("react.context") : 60110;
        var REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for("react.async_mode") : 60111;
        var REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for("react.concurrent_mode") : 60111;
        var REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for("react.forward_ref") : 60112;
        var REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for("react.suspense") : 60113;
        var REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for("react.suspense_list") : 60120;
        var REACT_MEMO_TYPE = hasSymbol ? Symbol.for("react.memo") : 60115;
        var REACT_LAZY_TYPE = hasSymbol ? Symbol.for("react.lazy") : 60116;
        var REACT_BLOCK_TYPE = hasSymbol ? Symbol.for("react.block") : 60121;
        var REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for("react.fundamental") : 60117;
        var REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for("react.responder") : 60118;
        var REACT_SCOPE_TYPE = hasSymbol ? Symbol.for("react.scope") : 60119;
        function isValidElementType(type) {
          return typeof type === "string" || typeof type === "function" || // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.
          type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === "object" && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE || type.$$typeof === REACT_SCOPE_TYPE || type.$$typeof === REACT_BLOCK_TYPE);
        }
        function typeOf(object) {
          if (typeof object === "object" && object !== null) {
            var $$typeof = object.$$typeof;
            switch ($$typeof) {
              case REACT_ELEMENT_TYPE:
                var type = object.type;
                switch (type) {
                  case REACT_ASYNC_MODE_TYPE:
                  case REACT_CONCURRENT_MODE_TYPE:
                  case REACT_FRAGMENT_TYPE:
                  case REACT_PROFILER_TYPE:
                  case REACT_STRICT_MODE_TYPE:
                  case REACT_SUSPENSE_TYPE:
                    return type;
                  default:
                    var $$typeofType = type && type.$$typeof;
                    switch ($$typeofType) {
                      case REACT_CONTEXT_TYPE:
                      case REACT_FORWARD_REF_TYPE:
                      case REACT_LAZY_TYPE:
                      case REACT_MEMO_TYPE:
                      case REACT_PROVIDER_TYPE:
                        return $$typeofType;
                      default:
                        return $$typeof;
                    }
                }
              case REACT_PORTAL_TYPE:
                return $$typeof;
            }
          }
          return void 0;
        }
        var AsyncMode = REACT_ASYNC_MODE_TYPE;
        var ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;
        var ContextConsumer = REACT_CONTEXT_TYPE;
        var ContextProvider = REACT_PROVIDER_TYPE;
        var Element = REACT_ELEMENT_TYPE;
        var ForwardRef = REACT_FORWARD_REF_TYPE;
        var Fragment = REACT_FRAGMENT_TYPE;
        var Lazy = REACT_LAZY_TYPE;
        var Memo = REACT_MEMO_TYPE;
        var Portal = REACT_PORTAL_TYPE;
        var Profiler = REACT_PROFILER_TYPE;
        var StrictMode = REACT_STRICT_MODE_TYPE;
        var Suspense = REACT_SUSPENSE_TYPE;
        var hasWarnedAboutDeprecatedIsAsyncMode = false;
        function isAsyncMode(object) {
          {
            if (!hasWarnedAboutDeprecatedIsAsyncMode) {
              hasWarnedAboutDeprecatedIsAsyncMode = true;
              console["warn"]("The ReactIs.isAsyncMode() alias has been deprecated, and will be removed in React 17+. Update your code to use ReactIs.isConcurrentMode() instead. It has the exact same API.");
            }
          }
          return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;
        }
        function isConcurrentMode(object) {
          return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;
        }
        function isContextConsumer(object) {
          return typeOf(object) === REACT_CONTEXT_TYPE;
        }
        function isContextProvider(object) {
          return typeOf(object) === REACT_PROVIDER_TYPE;
        }
        function isElement(object) {
          return typeof object === "object" && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
        }
        function isForwardRef(object) {
          return typeOf(object) === REACT_FORWARD_REF_TYPE;
        }
        function isFragment(object) {
          return typeOf(object) === REACT_FRAGMENT_TYPE;
        }
        function isLazy(object) {
          return typeOf(object) === REACT_LAZY_TYPE;
        }
        function isMemo(object) {
          return typeOf(object) === REACT_MEMO_TYPE;
        }
        function isPortal(object) {
          return typeOf(object) === REACT_PORTAL_TYPE;
        }
        function isProfiler(object) {
          return typeOf(object) === REACT_PROFILER_TYPE;
        }
        function isStrictMode(object) {
          return typeOf(object) === REACT_STRICT_MODE_TYPE;
        }
        function isSuspense(object) {
          return typeOf(object) === REACT_SUSPENSE_TYPE;
        }
        exports2.AsyncMode = AsyncMode;
        exports2.ConcurrentMode = ConcurrentMode;
        exports2.ContextConsumer = ContextConsumer;
        exports2.ContextProvider = ContextProvider;
        exports2.Element = Element;
        exports2.ForwardRef = ForwardRef;
        exports2.Fragment = Fragment;
        exports2.Lazy = Lazy;
        exports2.Memo = Memo;
        exports2.Portal = Portal;
        exports2.Profiler = Profiler;
        exports2.StrictMode = StrictMode;
        exports2.Suspense = Suspense;
        exports2.isAsyncMode = isAsyncMode;
        exports2.isConcurrentMode = isConcurrentMode;
        exports2.isContextConsumer = isContextConsumer;
        exports2.isContextProvider = isContextProvider;
        exports2.isElement = isElement;
        exports2.isForwardRef = isForwardRef;
        exports2.isFragment = isFragment;
        exports2.isLazy = isLazy;
        exports2.isMemo = isMemo;
        exports2.isPortal = isPortal;
        exports2.isProfiler = isProfiler;
        exports2.isStrictMode = isStrictMode;
        exports2.isSuspense = isSuspense;
        exports2.isValidElementType = isValidElementType;
        exports2.typeOf = typeOf;
      })();
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/react-is/index.js
var require_react_is = __commonJS({
  "../babel-plugin-react-compiler/node_modules/react-is/index.js"(exports2, module2) {
    "use strict";
    if (process.env.NODE_ENV === "production") {
      module2.exports = require_react_is_production_min();
    } else {
      module2.exports = require_react_is_development();
    }
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/ReactElement.js
var require_ReactElement = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/ReactElement.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = exports2.test = exports2.serialize = void 0;
    var ReactIs = _interopRequireWildcard(require_react_is());
    var _markup = require_markup();
    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};
        if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
              var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
              if (desc.get || desc.set) {
                Object.defineProperty(newObj, key, desc);
              } else {
                newObj[key] = obj[key];
              }
            }
          }
        }
        newObj.default = obj;
        return newObj;
      }
    }
    var getChildren = (arg, children = []) => {
      if (Array.isArray(arg)) {
        arg.forEach((item) => {
          getChildren(item, children);
        });
      } else if (arg != null && arg !== false) {
        children.push(arg);
      }
      return children;
    };
    var getType = (element) => {
      const type = element.type;
      if (typeof type === "string") {
        return type;
      }
      if (typeof type === "function") {
        return type.displayName || type.name || "Unknown";
      }
      if (ReactIs.isFragment(element)) {
        return "React.Fragment";
      }
      if (ReactIs.isSuspense(element)) {
        return "React.Suspense";
      }
      if (typeof type === "object" && type !== null) {
        if (ReactIs.isContextProvider(element)) {
          return "Context.Provider";
        }
        if (ReactIs.isContextConsumer(element)) {
          return "Context.Consumer";
        }
        if (ReactIs.isForwardRef(element)) {
          const functionName = type.render.displayName || type.render.name || "";
          return functionName !== "" ? "ForwardRef(" + functionName + ")" : "ForwardRef";
        }
        if (ReactIs.isMemo(type)) {
          const functionName = type.displayName || type.type.displayName || type.type.name || "";
          return functionName !== "" ? "Memo(" + functionName + ")" : "Memo";
        }
      }
      return "UNDEFINED";
    };
    var getPropKeys = (element) => {
      const props = element.props;
      return Object.keys(props).filter((key) => key !== "children" && props[key] !== void 0).sort();
    };
    var serialize = (element, config, indentation, depth, refs, printer) => ++depth > config.maxDepth ? (0, _markup.printElementAsLeaf)(getType(element), config) : (0, _markup.printElement)(
      getType(element),
      (0, _markup.printProps)(
        getPropKeys(element),
        element.props,
        config,
        indentation + config.indent,
        depth,
        refs,
        printer
      ),
      (0, _markup.printChildren)(
        getChildren(element.props.children),
        config,
        indentation + config.indent,
        depth,
        refs,
        printer
      ),
      config,
      indentation
    );
    exports2.serialize = serialize;
    var test = (val) => val && ReactIs.isElement(val);
    exports2.test = test;
    var plugin = {
      serialize,
      test
    };
    var _default = plugin;
    exports2.default = _default;
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/ReactTestComponent.js
var require_ReactTestComponent = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/plugins/ReactTestComponent.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", {
      value: true
    });
    exports2.default = exports2.test = exports2.serialize = void 0;
    var _markup = require_markup();
    var Symbol2 = global["jest-symbol-do-not-touch"] || global.Symbol;
    var testSymbol = Symbol2.for("react.test.json");
    var getPropKeys = (object) => {
      const props = object.props;
      return props ? Object.keys(props).filter((key) => props[key] !== void 0).sort() : [];
    };
    var serialize = (object, config, indentation, depth, refs, printer) => ++depth > config.maxDepth ? (0, _markup.printElementAsLeaf)(object.type, config) : (0, _markup.printElement)(
      object.type,
      object.props ? (0, _markup.printProps)(
        getPropKeys(object),
        object.props,
        config,
        indentation + config.indent,
        depth,
        refs,
        printer
      ) : "",
      object.children ? (0, _markup.printChildren)(
        object.children,
        config,
        indentation + config.indent,
        depth,
        refs,
        printer
      ) : "",
      config,
      indentation
    );
    exports2.serialize = serialize;
    var test = (val) => val && val.$$typeof === testSymbol;
    exports2.test = test;
    var plugin = {
      serialize,
      test
    };
    var _default = plugin;
    exports2.default = _default;
  }
});

// ../babel-plugin-react-compiler/node_modules/pretty-format/build/index.js
var require_build = __commonJS({
  "../babel-plugin-react-compiler/node_modules/pretty-format/build/index.js"(exports2, module2) {
    "use strict";
    var _ansiStyles = _interopRequireDefault(require_ansi_styles());
    var _collections = require_collections();
    var _AsymmetricMatcher = _interopRequireDefault(
      require_AsymmetricMatcher()
    );
    var _ConvertAnsi = _interopRequireDefault(require_ConvertAnsi());
    var _DOMCollection = _interopRequireDefault(require_DOMCollection());
    var _DOMElement = _interopRequireDefault(require_DOMElement());
    var _Immutable = _interopRequireDefault(require_Immutable());
    var _ReactElement = _interopRequireDefault(require_ReactElement());
    var _ReactTestComponent = _interopRequireDefault(
      require_ReactTestComponent()
    );
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }
    var Symbol2 = global["jest-symbol-do-not-touch"] || global.Symbol;
    var toString = Object.prototype.toString;
    var toISOString = Date.prototype.toISOString;
    var errorToString = Error.prototype.toString;
    var regExpToString = RegExp.prototype.toString;
    var symbolToString = Symbol2.prototype.toString;
    var getConstructorName = (val) => typeof val.constructor === "function" && val.constructor.name || "Object";
    var isWindow = (val) => typeof window !== "undefined" && val === window;
    var SYMBOL_REGEXP = /^Symbol\((.*)\)(.*)$/;
    var NEWLINE_REGEXP = /\n/gi;
    var PrettyFormatPluginError = class extends Error {
      constructor(message, stack) {
        super(message);
        this.stack = stack;
        this.name = this.constructor.name;
      }
    };
    function isToStringedArrayType(toStringed) {
      return toStringed === "[object Array]" || toStringed === "[object ArrayBuffer]" || toStringed === "[object DataView]" || toStringed === "[object Float32Array]" || toStringed === "[object Float64Array]" || toStringed === "[object Int8Array]" || toStringed === "[object Int16Array]" || toStringed === "[object Int32Array]" || toStringed === "[object Uint8Array]" || toStringed === "[object Uint8ClampedArray]" || toStringed === "[object Uint16Array]" || toStringed === "[object Uint32Array]";
    }
    function printNumber(val) {
      return Object.is(val, -0) ? "-0" : String(val);
    }
    function printBigInt(val) {
      return String(`${val}n`);
    }
    function printFunction2(val, printFunctionName) {
      if (!printFunctionName) {
        return "[Function]";
      }
      return "[Function " + (val.name || "anonymous") + "]";
    }
    function printSymbol(val) {
      return symbolToString.call(val).replace(SYMBOL_REGEXP, "Symbol($1)");
    }
    function printError(val) {
      return "[" + errorToString.call(val) + "]";
    }
    function printBasicValue(val, printFunctionName, escapeRegex, escapeString) {
      if (val === true || val === false) {
        return "" + val;
      }
      if (val === void 0) {
        return "undefined";
      }
      if (val === null) {
        return "null";
      }
      const typeOf = typeof val;
      if (typeOf === "number") {
        return printNumber(val);
      }
      if (typeOf === "bigint") {
        return printBigInt(val);
      }
      if (typeOf === "string") {
        if (escapeString) {
          return '"' + val.replace(/"|\\/g, "\\$&") + '"';
        }
        return '"' + val + '"';
      }
      if (typeOf === "function") {
        return printFunction2(val, printFunctionName);
      }
      if (typeOf === "symbol") {
        return printSymbol(val);
      }
      const toStringed = toString.call(val);
      if (toStringed === "[object WeakMap]") {
        return "WeakMap {}";
      }
      if (toStringed === "[object WeakSet]") {
        return "WeakSet {}";
      }
      if (toStringed === "[object Function]" || toStringed === "[object GeneratorFunction]") {
        return printFunction2(val, printFunctionName);
      }
      if (toStringed === "[object Symbol]") {
        return printSymbol(val);
      }
      if (toStringed === "[object Date]") {
        return isNaN(+val) ? "Date { NaN }" : toISOString.call(val);
      }
      if (toStringed === "[object Error]") {
        return printError(val);
      }
      if (toStringed === "[object RegExp]") {
        if (escapeRegex) {
          return regExpToString.call(val).replace(/[\\^$*+?.()|[\]{}]/g, "\\$&");
        }
        return regExpToString.call(val);
      }
      if (val instanceof Error) {
        return printError(val);
      }
      return null;
    }
    function printComplexValue(val, config, indentation, depth, refs, hasCalledToJSON) {
      if (refs.indexOf(val) !== -1) {
        return "[Circular]";
      }
      refs = refs.slice();
      refs.push(val);
      const hitMaxDepth = ++depth > config.maxDepth;
      const min = config.min;
      if (config.callToJSON && !hitMaxDepth && val.toJSON && typeof val.toJSON === "function" && !hasCalledToJSON) {
        return printer(val.toJSON(), config, indentation, depth, refs, true);
      }
      const toStringed = toString.call(val);
      if (toStringed === "[object Arguments]") {
        return hitMaxDepth ? "[Arguments]" : (min ? "" : "Arguments ") + "[" + (0, _collections.printListItems)(
          val,
          config,
          indentation,
          depth,
          refs,
          printer
        ) + "]";
      }
      if (isToStringedArrayType(toStringed)) {
        return hitMaxDepth ? "[" + val.constructor.name + "]" : (min ? "" : val.constructor.name + " ") + "[" + (0, _collections.printListItems)(
          val,
          config,
          indentation,
          depth,
          refs,
          printer
        ) + "]";
      }
      if (toStringed === "[object Map]") {
        return hitMaxDepth ? "[Map]" : "Map {" + (0, _collections.printIteratorEntries)(
          val.entries(),
          config,
          indentation,
          depth,
          refs,
          printer,
          " => "
        ) + "}";
      }
      if (toStringed === "[object Set]") {
        return hitMaxDepth ? "[Set]" : "Set {" + (0, _collections.printIteratorValues)(
          val.values(),
          config,
          indentation,
          depth,
          refs,
          printer
        ) + "}";
      }
      return hitMaxDepth || isWindow(val) ? "[" + getConstructorName(val) + "]" : (min ? "" : getConstructorName(val) + " ") + "{" + (0, _collections.printObjectProperties)(
        val,
        config,
        indentation,
        depth,
        refs,
        printer
      ) + "}";
    }
    function isNewPlugin(plugin) {
      return plugin.serialize != null;
    }
    function printPlugin(plugin, val, config, indentation, depth, refs) {
      let printed;
      try {
        printed = isNewPlugin(plugin) ? plugin.serialize(val, config, indentation, depth, refs, printer) : plugin.print(
          val,
          (valChild) => printer(valChild, config, indentation, depth, refs),
          (str) => {
            const indentationNext = indentation + config.indent;
            return indentationNext + str.replace(NEWLINE_REGEXP, "\n" + indentationNext);
          },
          {
            edgeSpacing: config.spacingOuter,
            min: config.min,
            spacing: config.spacingInner
          },
          config.colors
        );
      } catch (error) {
        throw new PrettyFormatPluginError(error.message, error.stack);
      }
      if (typeof printed !== "string") {
        throw new Error(
          `pretty-format: Plugin must return type "string" but instead returned "${typeof printed}".`
        );
      }
      return printed;
    }
    function findPlugin(plugins, val) {
      for (let p = 0; p < plugins.length; p++) {
        try {
          if (plugins[p].test(val)) {
            return plugins[p];
          }
        } catch (error) {
          throw new PrettyFormatPluginError(error.message, error.stack);
        }
      }
      return null;
    }
    function printer(val, config, indentation, depth, refs, hasCalledToJSON) {
      const plugin = findPlugin(config.plugins, val);
      if (plugin !== null) {
        return printPlugin(plugin, val, config, indentation, depth, refs);
      }
      const basicResult = printBasicValue(
        val,
        config.printFunctionName,
        config.escapeRegex,
        config.escapeString
      );
      if (basicResult !== null) {
        return basicResult;
      }
      return printComplexValue(
        val,
        config,
        indentation,
        depth,
        refs,
        hasCalledToJSON
      );
    }
    var DEFAULT_THEME = {
      comment: "gray",
      content: "reset",
      prop: "yellow",
      tag: "cyan",
      value: "green"
    };
    var DEFAULT_THEME_KEYS = Object.keys(DEFAULT_THEME);
    var DEFAULT_OPTIONS = {
      callToJSON: true,
      escapeRegex: false,
      escapeString: true,
      highlight: false,
      indent: 2,
      maxDepth: Infinity,
      min: false,
      plugins: [],
      printFunctionName: true,
      theme: DEFAULT_THEME
    };
    function validateOptions(options) {
      Object.keys(options).forEach((key) => {
        if (!DEFAULT_OPTIONS.hasOwnProperty(key)) {
          throw new Error(`pretty-format: Unknown option "${key}".`);
        }
      });
      if (options.min && options.indent !== void 0 && options.indent !== 0) {
        throw new Error(
          'pretty-format: Options "min" and "indent" cannot be used together.'
        );
      }
      if (options.theme !== void 0) {
        if (options.theme === null) {
          throw new Error(`pretty-format: Option "theme" must not be null.`);
        }
        if (typeof options.theme !== "object") {
          throw new Error(
            `pretty-format: Option "theme" must be of type "object" but instead received "${typeof options.theme}".`
          );
        }
      }
    }
    var getColorsHighlight = (options) => DEFAULT_THEME_KEYS.reduce((colors, key) => {
      const value = options.theme && options.theme[key] !== void 0 ? options.theme[key] : DEFAULT_THEME[key];
      const color = value && _ansiStyles.default[value];
      if (color && typeof color.close === "string" && typeof color.open === "string") {
        colors[key] = color;
      } else {
        throw new Error(
          `pretty-format: Option "theme" has a key "${key}" whose value "${value}" is undefined in ansi-styles.`
        );
      }
      return colors;
    }, /* @__PURE__ */ Object.create(null));
    var getColorsEmpty = () => DEFAULT_THEME_KEYS.reduce((colors, key) => {
      colors[key] = {
        close: "",
        open: ""
      };
      return colors;
    }, /* @__PURE__ */ Object.create(null));
    var getPrintFunctionName = (options) => options && options.printFunctionName !== void 0 ? options.printFunctionName : DEFAULT_OPTIONS.printFunctionName;
    var getEscapeRegex = (options) => options && options.escapeRegex !== void 0 ? options.escapeRegex : DEFAULT_OPTIONS.escapeRegex;
    var getEscapeString = (options) => options && options.escapeString !== void 0 ? options.escapeString : DEFAULT_OPTIONS.escapeString;
    var getConfig = (options) => ({
      callToJSON: options && options.callToJSON !== void 0 ? options.callToJSON : DEFAULT_OPTIONS.callToJSON,
      colors: options && options.highlight ? getColorsHighlight(options) : getColorsEmpty(),
      escapeRegex: getEscapeRegex(options),
      escapeString: getEscapeString(options),
      indent: options && options.min ? "" : createIndent(
        options && options.indent !== void 0 ? options.indent : DEFAULT_OPTIONS.indent
      ),
      maxDepth: options && options.maxDepth !== void 0 ? options.maxDepth : DEFAULT_OPTIONS.maxDepth,
      min: options && options.min !== void 0 ? options.min : DEFAULT_OPTIONS.min,
      plugins: options && options.plugins !== void 0 ? options.plugins : DEFAULT_OPTIONS.plugins,
      printFunctionName: getPrintFunctionName(options),
      spacingInner: options && options.min ? " " : "\n",
      spacingOuter: options && options.min ? "" : "\n"
    });
    function createIndent(indent) {
      return new Array(indent + 1).join(" ");
    }
    function prettyFormat3(val, options) {
      if (options) {
        validateOptions(options);
        if (options.plugins) {
          const plugin = findPlugin(options.plugins, val);
          if (plugin !== null) {
            return printPlugin(plugin, val, getConfig(options), "", 0, []);
          }
        }
      }
      const basicResult = printBasicValue(
        val,
        getPrintFunctionName(options),
        getEscapeRegex(options),
        getEscapeString(options)
      );
      if (basicResult !== null) {
        return basicResult;
      }
      return printComplexValue(val, getConfig(options), "", 0, []);
    }
    prettyFormat3.plugins = {
      AsymmetricMatcher: _AsymmetricMatcher.default,
      ConvertAnsi: _ConvertAnsi.default,
      DOMCollection: _DOMCollection.default,
      DOMElement: _DOMElement.default,
      Immutable: _Immutable.default,
      ReactElement: _ReactElement.default,
      ReactTestComponent: _ReactTestComponent.default
    };
    module2.exports = prettyFormat3;
  }
});

// src/index.ts
var index_exports = {};
__export(index_exports, {
  configs: () => configs,
  meta: () => meta,
  rules: () => rules
});
module.exports = __toCommonJS(index_exports);

// src/rules/ReactCompilerRule.ts
var import_core2 = require("@babel/core");
var import_plugin_proposal_private_methods = __toESM(require("@babel/plugin-proposal-private-methods"));

// ../babel-plugin-react-compiler/src/Babel/RunReactCompilerBabelPlugin.ts
var import_core = require("@babel/core");
var BabelParser = __toESM(require("@babel/parser"));
var import_invariant4 = __toESM(require_invariant());

// ../babel-plugin-react-compiler/src/Entrypoint/Gating.ts
var t = __toESM(require_lib3());

// ../babel-plugin-react-compiler/src/Utils/Result.ts
function Ok(val) {
  return new OkImpl(val);
}
var OkImpl = class _OkImpl {
  constructor(val) {
    this.val = val;
  }
  map(fn) {
    return new _OkImpl(fn(this.val));
  }
  mapErr(_fn) {
    return this;
  }
  mapOr(_fallback, fn) {
    return fn(this.val);
  }
  mapOrElse(_fallback, fn) {
    return fn(this.val);
  }
  andThen(fn) {
    return fn(this.val);
  }
  and(res) {
    return res;
  }
  or(_res) {
    return this;
  }
  orElse(_fn) {
    return this;
  }
  isOk() {
    return true;
  }
  isErr() {
    return false;
  }
  expect(_msg) {
    return this.val;
  }
  expectErr(msg) {
    throw new Error(`${msg}: ${this.val}`);
  }
  unwrap() {
    return this.val;
  }
  unwrapOr(_fallback) {
    return this.val;
  }
  unwrapOrElse(_fallback) {
    return this.val;
  }
  unwrapErr() {
    if (this.val instanceof Error) {
      throw this.val;
    }
    throw new Error(`Can't unwrap \`Ok\` to \`Err\`: ${this.val}`);
  }
};
function Err(val) {
  return new ErrImpl(val);
}
var ErrImpl = class _ErrImpl {
  constructor(val) {
    this.val = val;
  }
  map(_fn) {
    return this;
  }
  mapErr(fn) {
    return new _ErrImpl(fn(this.val));
  }
  mapOr(fallback, _fn) {
    return fallback;
  }
  mapOrElse(fallback, _fn) {
    return fallback();
  }
  andThen(_fn) {
    return this;
  }
  and(_res) {
    return this;
  }
  or(res) {
    return res;
  }
  orElse(fn) {
    return fn(this.val);
  }
  isOk() {
    return false;
  }
  isErr() {
    return true;
  }
  expect(msg) {
    throw new Error(`${msg}: ${this.val}`);
  }
  expectErr(_msg) {
    return this.val;
  }
  unwrap() {
    if (this.val instanceof Error) {
      throw this.val;
    }
    throw new Error(`Can't unwrap \`Err\` to \`Ok\`: ${this.val}`);
  }
  unwrapOr(fallback) {
    return fallback;
  }
  unwrapOrElse(fallback) {
    return fallback(this.val);
  }
  unwrapErr() {
    return this.val;
  }
};

// ../babel-plugin-react-compiler/src/Utils/utils.ts
function assertExhaustive(_, errorMsg) {
  throw new Error(errorMsg);
}
function retainWhere(array, predicate) {
  let writeIndex = 0;
  for (let readIndex = 0; readIndex < array.length; readIndex++) {
    const item = array[readIndex];
    if (predicate(item) === true) {
      array[writeIndex++] = item;
    }
  }
  array.length = writeIndex;
}
function retainWhere_Set(items, predicate) {
  for (const item of items) {
    if (!predicate(item)) {
      items.delete(item);
    }
  }
}
function getOrInsertWith(m, key, makeDefault) {
  if (m.has(key)) {
    return m.get(key);
  } else {
    const defaultValue = makeDefault();
    m.set(key, defaultValue);
    return defaultValue;
  }
}
function getOrInsertDefault(m, key, defaultValue) {
  if (m.has(key)) {
    return m.get(key);
  } else {
    m.set(key, defaultValue);
    return defaultValue;
  }
}
function Set_equal(a, b) {
  if (a.size !== b.size) {
    return false;
  }
  for (const item of a) {
    if (!b.has(item)) {
      return false;
    }
  }
  return true;
}
function Set_union(a, b) {
  const union = new Set(a);
  for (const item of b) {
    union.add(item);
  }
  return union;
}
function Set_intersect(sets) {
  if (sets.length === 0 || sets.some((s) => s.size === 0)) {
    return /* @__PURE__ */ new Set();
  } else if (sets.length === 1) {
    return new Set(sets[0]);
  }
  const result = /* @__PURE__ */ new Set();
  const first = sets[0];
  outer: for (const e of first) {
    for (let i = 1; i < sets.length; i++) {
      if (!sets[i].has(e)) {
        continue outer;
      }
    }
    result.add(e);
  }
  return result;
}
function Iterable_some(iter, pred) {
  for (const item of iter) {
    if (pred(item)) {
      return true;
    }
  }
  return false;
}
function Set_filter(source, fn) {
  const result = /* @__PURE__ */ new Set();
  for (const entry of source) {
    if (fn(entry)) {
      result.add(entry);
    }
  }
  return result;
}
function hasNode(input) {
  return input.node != null;
}
function hasOwnProperty2(obj, key) {
  return Object.prototype.hasOwnProperty.call(obj, key);
}

// ../babel-plugin-react-compiler/src/CompilerError.ts
var CompilerErrorDetail = class {
  constructor(options) {
    this.options = options;
  }
  get reason() {
    return this.options.reason;
  }
  get description() {
    return this.options.description;
  }
  get severity() {
    return this.options.severity;
  }
  get loc() {
    return this.options.loc;
  }
  get suggestions() {
    return this.options.suggestions;
  }
  printErrorMessage() {
    const buffer = [`${this.severity}: ${this.reason}`];
    if (this.description != null) {
      buffer.push(`. ${this.description}`);
    }
    if (this.loc != null && typeof this.loc !== "symbol") {
      buffer.push(` (${this.loc.start.line}:${this.loc.end.line})`);
    }
    return buffer.join("");
  }
  toString() {
    return this.printErrorMessage();
  }
};
var CompilerError = class _CompilerError extends Error {
  constructor(...args) {
    super(...args);
    this.details = [];
    this.name = "ReactCompilerError";
    this.details = [];
  }
  static invariant(condition, options) {
    if (!condition) {
      const errors = new _CompilerError();
      errors.pushErrorDetail(
        new CompilerErrorDetail(__spreadProps(__spreadValues({}, options), {
          severity: "Invariant" /* Invariant */
        }))
      );
      throw errors;
    }
  }
  static throwTodo(options) {
    const errors = new _CompilerError();
    errors.pushErrorDetail(
      new CompilerErrorDetail(__spreadProps(__spreadValues({}, options), { severity: "Todo" /* Todo */ }))
    );
    throw errors;
  }
  static throwInvalidJS(options) {
    const errors = new _CompilerError();
    errors.pushErrorDetail(
      new CompilerErrorDetail(__spreadProps(__spreadValues({}, options), {
        severity: "InvalidJS" /* InvalidJS */
      }))
    );
    throw errors;
  }
  static throwInvalidReact(options) {
    const errors = new _CompilerError();
    errors.pushErrorDetail(
      new CompilerErrorDetail(__spreadProps(__spreadValues({}, options), {
        severity: "InvalidReact" /* InvalidReact */
      }))
    );
    throw errors;
  }
  static throwInvalidConfig(options) {
    const errors = new _CompilerError();
    errors.pushErrorDetail(
      new CompilerErrorDetail(__spreadProps(__spreadValues({}, options), {
        severity: "InvalidConfig" /* InvalidConfig */
      }))
    );
    throw errors;
  }
  static throw(options) {
    const errors = new _CompilerError();
    errors.pushErrorDetail(new CompilerErrorDetail(options));
    throw errors;
  }
  get message() {
    return this.toString();
  }
  set message(_message) {
  }
  toString() {
    if (Array.isArray(this.details)) {
      return this.details.map((detail) => detail.toString()).join("\n\n");
    }
    return this.name;
  }
  push(options) {
    var _a;
    const detail = new CompilerErrorDetail({
      reason: options.reason,
      description: (_a = options.description) != null ? _a : null,
      severity: options.severity,
      suggestions: options.suggestions,
      loc: typeof options.loc === "symbol" ? null : options.loc
    });
    return this.pushErrorDetail(detail);
  }
  pushErrorDetail(detail) {
    this.details.push(detail);
    return detail;
  }
  hasErrors() {
    return this.details.length > 0;
  }
  asResult() {
    return this.hasErrors() ? Err(this) : Ok(void 0);
  }
  /*
   * An error is critical if it means the compiler has entered into a broken state and cannot
   * continue safely. Other expected errors such as Todos mean that we can skip over that component
   * but otherwise continue compiling the rest of the app.
   */
  isCritical() {
    return this.details.some((detail) => {
      switch (detail.severity) {
        case "Invariant" /* Invariant */:
        case "InvalidJS" /* InvalidJS */:
        case "InvalidReact" /* InvalidReact */:
        case "InvalidConfig" /* InvalidConfig */:
          return true;
        case "CannotPreserveMemoization" /* CannotPreserveMemoization */:
        case "Todo" /* Todo */:
          return false;
        default:
          assertExhaustive(detail.severity, "Unhandled error severity");
      }
    });
  }
};

// ../babel-plugin-react-compiler/src/Entrypoint/Gating.ts
function insertAdditionalFunctionDeclaration(fnPath, compiled, programContext, gatingFunctionIdentifierName) {
  var _a, _b;
  const originalFnName = fnPath.node.id;
  const originalFnParams = fnPath.node.params;
  const compiledParams = fnPath.node.params;
  CompilerError.invariant(originalFnName != null && compiled.id != null, {
    reason: "Expected function declarations that are referenced elsewhere to have a named identifier",
    loc: (_a = fnPath.node.loc) != null ? _a : null
  });
  CompilerError.invariant(originalFnParams.length === compiledParams.length, {
    reason: "Expected React Compiler optimized function declarations to have the same number of parameters as source",
    loc: (_b = fnPath.node.loc) != null ? _b : null
  });
  const gatingCondition = t.identifier(
    programContext.newUid(`${gatingFunctionIdentifierName}_result`)
  );
  const unoptimizedFnName = t.identifier(
    programContext.newUid(`${originalFnName.name}_unoptimized`)
  );
  const optimizedFnName = t.identifier(
    programContext.newUid(`${originalFnName.name}_optimized`)
  );
  compiled.id.name = optimizedFnName.name;
  fnPath.get("id").replaceInline(unoptimizedFnName);
  const newParams = [];
  const genNewArgs = [];
  for (let i = 0; i < originalFnParams.length; i++) {
    const argName = `arg${i}`;
    if (originalFnParams[i].type === "RestElement") {
      newParams.push(t.restElement(t.identifier(argName)));
      genNewArgs.push(() => t.spreadElement(t.identifier(argName)));
    } else {
      newParams.push(t.identifier(argName));
      genNewArgs.push(() => t.identifier(argName));
    }
  }
  fnPath.insertAfter(
    t.functionDeclaration(
      originalFnName,
      newParams,
      t.blockStatement([
        t.ifStatement(
          gatingCondition,
          t.returnStatement(
            t.callExpression(
              compiled.id,
              genNewArgs.map((fn) => fn())
            )
          ),
          t.returnStatement(
            t.callExpression(
              unoptimizedFnName,
              genNewArgs.map((fn) => fn())
            )
          )
        )
      ])
    )
  );
  fnPath.insertBefore(
    t.variableDeclaration("const", [
      t.variableDeclarator(
        gatingCondition,
        t.callExpression(t.identifier(gatingFunctionIdentifierName), [])
      )
    ])
  );
  fnPath.insertBefore(compiled);
}
function insertGatedFunctionDeclaration(fnPath, compiled, programContext, gating, referencedBeforeDeclaration) {
  var _a;
  const gatingImportedName = programContext.addImportSpecifier(gating).name;
  if (referencedBeforeDeclaration && fnPath.isFunctionDeclaration()) {
    CompilerError.invariant(compiled.type === "FunctionDeclaration", {
      reason: "Expected compiled node type to match input type",
      description: `Got ${compiled.type} but expected FunctionDeclaration`,
      loc: (_a = fnPath.node.loc) != null ? _a : null
    });
    insertAdditionalFunctionDeclaration(
      fnPath,
      compiled,
      programContext,
      gatingImportedName
    );
  } else {
    const gatingExpression = t.conditionalExpression(
      t.callExpression(t.identifier(gatingImportedName), []),
      buildFunctionExpression(compiled),
      buildFunctionExpression(fnPath.node)
    );
    if (fnPath.parentPath.node.type !== "ExportDefaultDeclaration" && fnPath.node.type === "FunctionDeclaration" && fnPath.node.id != null) {
      fnPath.replaceWith(
        t.variableDeclaration("const", [
          t.variableDeclarator(fnPath.node.id, gatingExpression)
        ])
      );
    } else if (fnPath.parentPath.node.type === "ExportDefaultDeclaration" && fnPath.node.type !== "ArrowFunctionExpression" && fnPath.node.id != null) {
      fnPath.insertAfter(
        t.exportDefaultDeclaration(t.identifier(fnPath.node.id.name))
      );
      fnPath.parentPath.replaceWith(
        t.variableDeclaration("const", [
          t.variableDeclarator(
            t.identifier(fnPath.node.id.name),
            gatingExpression
          )
        ])
      );
    } else {
      fnPath.replaceWith(gatingExpression);
    }
  }
}
function buildFunctionExpression(node) {
  var _a, _b;
  if (node.type === "ArrowFunctionExpression" || node.type === "FunctionExpression") {
    return node;
  } else {
    const fn = {
      type: "FunctionExpression",
      async: node.async,
      generator: node.generator,
      loc: (_a = node.loc) != null ? _a : null,
      id: (_b = node.id) != null ? _b : null,
      params: node.params,
      body: node.body
    };
    return fn;
  }
}

// ../babel-plugin-react-compiler/src/Entrypoint/Imports.ts
var t4 = __toESM(require_lib3());

// ../babel-plugin-react-compiler/src/HIR/HIR.ts
var t2 = __toESM(require_lib3());

// ../babel-plugin-react-compiler/src/HIR/Types.ts
var opaqueTypeId = Symbol();
function makeTypeId(id) {
  CompilerError.invariant(id >= 0 && Number.isInteger(id), {
    reason: "Expected instruction id to be a non-negative integer",
    description: null,
    loc: null,
    suggestions: null
  });
  return id;
}
var typeCounter = 0;
function makeType() {
  return {
    kind: "Type",
    id: makeTypeId(typeCounter++)
  };
}
function typeEquals(tA, tB) {
  if (tA.kind !== tB.kind) return false;
  return typeVarEquals(tA, tB) || funcTypeEquals(tA, tB) || objectTypeEquals(tA, tB) || primitiveTypeEquals(tA, tB) || polyTypeEquals(tA, tB) || phiTypeEquals(tA, tB) || propTypeEquals(tA, tB) || objectMethodTypeEquals(tA, tB);
}
function typeVarEquals(tA, tB) {
  if (tA.kind === "Type" && tB.kind === "Type") {
    return tA.id === tB.id;
  }
  return false;
}
function typeKindCheck(tA, tb, type) {
  return tA.kind === type && tb.kind === type;
}
function objectMethodTypeEquals(tA, tB) {
  return typeKindCheck(tA, tB, "ObjectMethod");
}
function propTypeEquals(tA, tB) {
  if (tA.kind === "Property" && tB.kind === "Property") {
    if (!typeEquals(tA.objectType, tB.objectType)) {
      return false;
    }
    return tA.propertyName === tB.propertyName && tA.objectName === tB.objectName;
  }
  return false;
}
function primitiveTypeEquals(tA, tB) {
  return typeKindCheck(tA, tB, "Primitive");
}
function polyTypeEquals(tA, tB) {
  return typeKindCheck(tA, tB, "Poly");
}
function objectTypeEquals(tA, tB) {
  if (tA.kind === "Object" && tB.kind == "Object") {
    return tA.shapeId === tB.shapeId;
  }
  return false;
}
function funcTypeEquals(tA, tB) {
  if (tA.kind !== "Function" || tB.kind !== "Function") {
    return false;
  }
  return typeEquals(tA.return, tB.return);
}
function phiTypeEquals(tA, tB) {
  if (tA.kind === "Phi" && tB.kind === "Phi") {
    if (tA.operands.length !== tB.operands.length) {
      return false;
    }
    let operands = new Set(tA.operands);
    for (let i = 0; i < tB.operands.length; i++) {
      if (!operands.has(tB.operands[i])) {
        return false;
      }
    }
  }
  return false;
}

// ../babel-plugin-react-compiler/src/HIR/HIR.ts
var import_zod = require("zod");
var GeneratedSource = Symbol();
function isStatementBlockKind(kind) {
  return kind === "block" || kind === "catch";
}
function isExpressionBlockKind(kind) {
  return !isStatementBlockKind(kind);
}
function convertHoistedLValueKind(kind) {
  switch (kind) {
    case "HoistedLet" /* HoistedLet */:
      return "Let" /* Let */;
    case "HoistedConst" /* HoistedConst */:
      return "Const" /* Const */;
    case "HoistedFunction" /* HoistedFunction */:
      return "Function" /* Function */;
    case "Let" /* Let */:
    case "Const" /* Const */:
    case "Function" /* Function */:
    case "Reassign" /* Reassign */:
    case "Catch" /* Catch */:
      return null;
    default:
      assertExhaustive(kind, "Unexpected lvalue kind");
  }
}
var opaqueValidIdentifierName = Symbol();
function makeTemporaryIdentifier(id, loc) {
  return {
    id,
    name: null,
    declarationId: makeDeclarationId(id),
    mutableRange: { start: makeInstructionId(0), end: makeInstructionId(0) },
    scope: null,
    type: makeType(),
    loc
  };
}
function forkTemporaryIdentifier(id, source) {
  return __spreadProps(__spreadValues({}, source), {
    mutableRange: { start: makeInstructionId(0), end: makeInstructionId(0) },
    id
  });
}
function makeIdentifierName(name) {
  CompilerError.invariant(t2.isValidIdentifier(name), {
    reason: `Expected a valid identifier name`,
    loc: GeneratedSource,
    description: `\`${name}\` is not a valid JavaScript identifier`,
    suggestions: null
  });
  return {
    kind: "named",
    value: name
  };
}
function promoteTemporary(identifier4) {
  CompilerError.invariant(identifier4.name === null, {
    reason: `Expected a temporary (unnamed) identifier`,
    loc: GeneratedSource,
    description: `Identifier already has a name, \`${identifier4.name}\``,
    suggestions: null
  });
  identifier4.name = {
    kind: "promoted",
    value: `#t${identifier4.declarationId}`
  };
}
function isPromotedTemporary(name) {
  return name.startsWith("#t");
}
function promoteTemporaryJsxTag(identifier4) {
  CompilerError.invariant(identifier4.name === null, {
    reason: `Expected a temporary (unnamed) identifier`,
    loc: GeneratedSource,
    description: `Identifier already has a name, \`${identifier4.name}\``,
    suggestions: null
  });
  identifier4.name = {
    kind: "promoted",
    value: `#T${identifier4.declarationId}`
  };
}
function isPromotedJsxTemporary(name) {
  return name.startsWith("#T");
}
var ValueKind = /* @__PURE__ */ ((ValueKind2) => {
  ValueKind2["MaybeFrozen"] = "maybefrozen";
  ValueKind2["Frozen"] = "frozen";
  ValueKind2["Primitive"] = "primitive";
  ValueKind2["Global"] = "global";
  ValueKind2["Mutable"] = "mutable";
  ValueKind2["Context"] = "context";
  return ValueKind2;
})(ValueKind || {});
var ValueKindSchema = import_zod.z.enum([
  "maybefrozen" /* MaybeFrozen */,
  "frozen" /* Frozen */,
  "primitive" /* Primitive */,
  "global" /* Global */,
  "mutable" /* Mutable */,
  "context" /* Context */
]);
var Effect = /* @__PURE__ */ ((Effect2) => {
  Effect2["Unknown"] = "<unknown>";
  Effect2["Freeze"] = "freeze";
  Effect2["Read"] = "read";
  Effect2["Capture"] = "capture";
  Effect2["ConditionallyMutateIterator"] = "mutate-iterator?";
  Effect2["ConditionallyMutate"] = "mutate?";
  Effect2["Mutate"] = "mutate";
  Effect2["Store"] = "store";
  return Effect2;
})(Effect || {});
var EffectSchema = import_zod.z.enum([
  "read" /* Read */,
  "mutate" /* Mutate */,
  "mutate?" /* ConditionallyMutate */,
  "mutate-iterator?" /* ConditionallyMutateIterator */,
  "capture" /* Capture */,
  "store" /* Store */,
  "freeze" /* Freeze */
]);
function isMutableEffect(effect, location) {
  switch (effect) {
    case "capture" /* Capture */:
    case "store" /* Store */:
    case "mutate?" /* ConditionallyMutate */:
    case "mutate-iterator?" /* ConditionallyMutateIterator */:
    case "mutate" /* Mutate */: {
      return true;
    }
    case "<unknown>" /* Unknown */: {
      CompilerError.invariant(false, {
        reason: "Unexpected unknown effect",
        description: null,
        loc: location,
        suggestions: null
      });
    }
    case "read" /* Read */:
    case "freeze" /* Freeze */: {
      return false;
    }
    default: {
      assertExhaustive(effect, `Unexpected effect \`${effect}\``);
    }
  }
}
var opaquePropertyLiteral = Symbol();
function makePropertyLiteral(value) {
  return value;
}
function areEqualPaths(a, b) {
  return a.length === b.length && a.every(
    (item, ix) => item.property === b[ix].property && item.optional === b[ix].optional
  );
}
function getPlaceScope(id, place) {
  const scope = place.identifier.scope;
  if (scope !== null && isScopeActive(scope, id)) {
    return scope;
  }
  return null;
}
function isScopeActive(scope, id) {
  return id >= scope.range.start && id < scope.range.end;
}
var opaqueBlockId = Symbol();
function makeBlockId(id) {
  CompilerError.invariant(id >= 0 && Number.isInteger(id), {
    reason: "Expected block id to be a non-negative integer",
    description: null,
    loc: null,
    suggestions: null
  });
  return id;
}
var opaqueScopeId = Symbol();
function makeScopeId(id) {
  CompilerError.invariant(id >= 0 && Number.isInteger(id), {
    reason: "Expected block id to be a non-negative integer",
    description: null,
    loc: null,
    suggestions: null
  });
  return id;
}
var opaqueIdentifierId = Symbol();
function makeIdentifierId(id) {
  CompilerError.invariant(id >= 0 && Number.isInteger(id), {
    reason: "Expected identifier id to be a non-negative integer",
    description: null,
    loc: null,
    suggestions: null
  });
  return id;
}
var opageDeclarationId = Symbol();
function makeDeclarationId(id) {
  CompilerError.invariant(id >= 0 && Number.isInteger(id), {
    reason: "Expected declaration id to be a non-negative integer",
    description: null,
    loc: null,
    suggestions: null
  });
  return id;
}
var opaqueInstructionId = Symbol();
function makeInstructionId(id) {
  CompilerError.invariant(id >= 0 && Number.isInteger(id), {
    reason: "Expected instruction id to be a non-negative integer",
    description: null,
    loc: null,
    suggestions: null
  });
  return id;
}
function isObjectMethodType(id) {
  return id.type.kind == "ObjectMethod";
}
function isObjectType(id) {
  return id.type.kind === "Object";
}
function isPrimitiveType(id) {
  return id.type.kind === "Primitive";
}
function isArrayType(id) {
  return id.type.kind === "Object" && id.type.shapeId === "BuiltInArray";
}
function isMapType(id) {
  return id.type.kind === "Object" && id.type.shapeId === "BuiltInMap";
}
function isSetType(id) {
  return id.type.kind === "Object" && id.type.shapeId === "BuiltInSet";
}
function isPropsType(id) {
  return id.type.kind === "Object" && id.type.shapeId === "BuiltInProps";
}
function isRefValueType(id) {
  return id.type.kind === "Object" && id.type.shapeId === "BuiltInRefValue";
}
function isUseRefType(id) {
  return id.type.kind === "Object" && id.type.shapeId === "BuiltInUseRefId";
}
function isUseStateType(id) {
  return id.type.kind === "Object" && id.type.shapeId === "BuiltInUseState";
}
function isRefOrRefValue(id) {
  return isUseRefType(id) || isRefValueType(id);
}
function isRefOrRefLikeMutableType(type) {
  return type.kind === "Object" && (type.shapeId === "BuiltInUseRefId" || type.shapeId == "ReanimatedSharedValueId");
}
function isSetStateType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInSetState";
}
function isStartTransitionType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInStartTransition";
}
function isSetActionStateType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInSetActionState";
}
function isUseReducerType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInUseReducer";
}
function isDispatcherType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInDispatch";
}
function isFireFunctionType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInFireFunction";
}
function isStableType(id) {
  return isSetStateType(id) || isSetActionStateType(id) || isDispatcherType(id) || isUseRefType(id) || isStartTransitionType(id);
}
function isStableTypeContainer(id) {
  const type_ = id.type;
  if (type_.kind !== "Object") {
    return false;
  }
  return isUseStateType(id) || // setState
  type_.shapeId === "BuiltInUseActionState" || // setActionState
  isUseReducerType(id) || // dispatcher
  type_.shapeId === "BuiltInUseTransition";
}
function evaluatesToStableTypeOrContainer(env, { value }) {
  if (value.kind === "CallExpression" || value.kind === "MethodCall") {
    const callee = value.kind === "CallExpression" ? value.callee : value.property;
    const calleeHookKind = getHookKind(env, callee.identifier);
    switch (calleeHookKind) {
      case "useState":
      case "useReducer":
      case "useActionState":
      case "useRef":
      case "useTransition":
        return true;
    }
  }
  return false;
}
function isUseEffectHookType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInUseEffectHook";
}
function isUseLayoutEffectHookType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInUseLayoutEffectHook";
}
function isUseInsertionEffectHookType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInUseInsertionEffectHook";
}
function isUseContextHookType(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInUseContextHook";
}
function getHookKind(env, id) {
  return getHookKindForType(env, id.type);
}
function isUseOperator(id) {
  return id.type.kind === "Function" && id.type.shapeId === "BuiltInUseOperator";
}
function getHookKindForType(env, type) {
  var _a;
  if (type.kind === "Function") {
    const signature = env.getFunctionSignature(type);
    return (_a = signature == null ? void 0 : signature.hookKind) != null ? _a : null;
  }
  return null;
}

// ../babel-plugin-react-compiler/src/HIR/PrintHIR.ts
var import_generator = __toESM(require_lib4());

// ../babel-plugin-react-compiler/src/ReactiveScopes/PrintReactiveFunction.ts
function printReactiveScopeSummary(scope) {
  const items = [];
  items.push("scope");
  items.push(`@${scope.id}`);
  items.push(`[${scope.range.start}:${scope.range.end}]`);
  items.push(
    `dependencies=[${Array.from(scope.dependencies).map((dep) => printDependency(dep)).join(", ")}]`
  );
  items.push(
    `declarations=[${Array.from(scope.declarations).map(
      ([, decl]) => printIdentifier(__spreadProps(__spreadValues({}, decl.identifier), { scope: decl.scope }))
    ).join(", ")}]`
  );
  items.push(
    `reassignments=[${Array.from(scope.reassignments).map(
      (reassign) => printIdentifier(reassign)
    )}]`
  );
  if (scope.earlyReturnValue !== null) {
    items.push(
      `earlyReturn={id: ${printIdentifier(
        scope.earlyReturnValue.value
      )}, label: ${scope.earlyReturnValue.label}}}`
    );
  }
  return items.join(" ");
}
function printDependency(dependency) {
  const identifier4 = printIdentifier(dependency.identifier) + printType(dependency.identifier.type);
  return `${identifier4}${dependency.path.map((token) => `${token.optional ? "?." : "."}${token.property}`).join("")}`;
}

// ../babel-plugin-react-compiler/src/HIR/PrintHIR.ts
function printFunction(fn) {
  const output = [];
  let definition = "";
  if (fn.id !== null) {
    definition += fn.id;
  }
  if (fn.params.length !== 0) {
    definition += "(" + fn.params.map((param) => {
      if (param.kind === "Identifier") {
        return printPlace(param);
      } else {
        return `...${printPlace(param.place)}`;
      }
    }).join(", ") + ")";
  }
  if (definition.length !== 0) {
    output.push(definition);
  }
  output.push(printType(fn.returnType));
  output.push(printHIR(fn.body));
  output.push(...fn.directives);
  return output.join("\n");
}
function printHIR(ir, options = null) {
  var _a;
  let output = [];
  let indent = " ".repeat((_a = options == null ? void 0 : options.indent) != null ? _a : 0);
  const push = (text, indent2 = "  ") => {
    output.push(`${indent2}${text}`);
  };
  for (const [blockId, block] of ir.blocks) {
    output.push(`bb${blockId} (${block.kind}):`);
    if (block.preds.size > 0) {
      const preds = ["predecessor blocks:"];
      for (const pred of block.preds) {
        preds.push(`bb${pred}`);
      }
      push(preds.join(" "));
    }
    for (const phi of block.phis) {
      push(printPhi(phi));
    }
    for (const instr of block.instructions) {
      push(printInstruction(instr));
    }
    const terminal = printTerminal(block.terminal);
    if (Array.isArray(terminal)) {
      terminal.forEach((line) => push(line));
    } else {
      push(terminal);
    }
  }
  return output.map((line) => indent + line).join("\n");
}
function printMixedHIR(value) {
  if (!("kind" in value)) {
    return printInstruction(value);
  }
  switch (value.kind) {
    case "try":
    case "maybe-throw":
    case "sequence":
    case "label":
    case "optional":
    case "branch":
    case "if":
    case "logical":
    case "ternary":
    case "return":
    case "switch":
    case "throw":
    case "while":
    case "for":
    case "unreachable":
    case "unsupported":
    case "goto":
    case "do-while":
    case "for-in":
    case "for-of":
    case "scope":
    case "pruned-scope": {
      const terminal = printTerminal(value);
      if (Array.isArray(terminal)) {
        return terminal.join("; ");
      }
      return terminal;
    }
    default: {
      return printInstructionValue(value);
    }
  }
}
function printInstruction(instr) {
  const id = `[${instr.id}]`;
  const value = printInstructionValue(instr.value);
  if (instr.lvalue !== null) {
    return `${id} ${printPlace(instr.lvalue)} = ${value}`;
  } else {
    return `${id} ${value}`;
  }
}
function printPhi(phi) {
  const items = [];
  items.push(printPlace(phi.place));
  items.push(printMutableRange(phi.place.identifier));
  items.push(printType(phi.place.identifier.type));
  items.push(": phi(");
  const phis = [];
  for (const [blockId, place] of phi.operands) {
    phis.push(`bb${blockId}: ${printPlace(place)}`);
  }
  items.push(phis.join(", "));
  items.push(")");
  return items.join("");
}
function printTerminal(terminal) {
  let value;
  switch (terminal.kind) {
    case "if": {
      value = `[${terminal.id}] If (${printPlace(terminal.test)}) then:bb${terminal.consequent} else:bb${terminal.alternate}${terminal.fallthrough ? ` fallthrough=bb${terminal.fallthrough}` : ""}`;
      break;
    }
    case "branch": {
      value = `[${terminal.id}] Branch (${printPlace(terminal.test)}) then:bb${terminal.consequent} else:bb${terminal.alternate} fallthrough:bb${terminal.fallthrough}`;
      break;
    }
    case "logical": {
      value = `[${terminal.id}] Logical ${terminal.operator} test:bb${terminal.test} fallthrough=bb${terminal.fallthrough}`;
      break;
    }
    case "ternary": {
      value = `[${terminal.id}] Ternary test:bb${terminal.test} fallthrough=bb${terminal.fallthrough}`;
      break;
    }
    case "optional": {
      value = `[${terminal.id}] Optional (optional=${terminal.optional}) test:bb${terminal.test} fallthrough=bb${terminal.fallthrough}`;
      break;
    }
    case "throw": {
      value = `[${terminal.id}] Throw ${printPlace(terminal.value)}`;
      break;
    }
    case "return": {
      value = `[${terminal.id}] Return${terminal.value != null ? " " + printPlace(terminal.value) : ""}`;
      break;
    }
    case "goto": {
      value = `[${terminal.id}] Goto${terminal.variant === "Continue" /* Continue */ ? "(Continue)" : ""} bb${terminal.block}`;
      break;
    }
    case "switch": {
      const output = [];
      output.push(`[${terminal.id}] Switch (${printPlace(terminal.test)})`);
      terminal.cases.forEach((case_) => {
        if (case_.test !== null) {
          output.push(`  Case ${printPlace(case_.test)}: bb${case_.block}`);
        } else {
          output.push(`  Default: bb${case_.block}`);
        }
      });
      if (terminal.fallthrough) {
        output.push(`  Fallthrough: bb${terminal.fallthrough}`);
      }
      value = output;
      break;
    }
    case "do-while": {
      value = `[${terminal.id}] DoWhile loop=${`bb${terminal.loop}`} test=bb${terminal.test} fallthrough=${`bb${terminal.fallthrough}`}`;
      break;
    }
    case "while": {
      value = `[${terminal.id}] While test=bb${terminal.test} loop=${terminal.loop !== null ? `bb${terminal.loop}` : ""} fallthrough=${terminal.fallthrough ? `bb${terminal.fallthrough}` : ""}`;
      break;
    }
    case "for": {
      value = `[${terminal.id}] For init=bb${terminal.init} test=bb${terminal.test} loop=bb${terminal.loop} update=bb${terminal.update} fallthrough=bb${terminal.fallthrough}`;
      break;
    }
    case "for-of": {
      value = `[${terminal.id}] ForOf init=bb${terminal.init} test=bb${terminal.test} loop=bb${terminal.loop} fallthrough=bb${terminal.fallthrough}`;
      break;
    }
    case "for-in": {
      value = `[${terminal.id}] ForIn init=bb${terminal.init} loop=bb${terminal.loop} fallthrough=bb${terminal.fallthrough}`;
      break;
    }
    case "label": {
      value = `[${terminal.id}] Label block=bb${terminal.block} fallthrough=${terminal.fallthrough ? `bb${terminal.fallthrough}` : ""}`;
      break;
    }
    case "sequence": {
      value = `[${terminal.id}] Sequence block=bb${terminal.block} fallthrough=bb${terminal.fallthrough}`;
      break;
    }
    case "unreachable": {
      value = `[${terminal.id}] Unreachable`;
      break;
    }
    case "unsupported": {
      value = `[${terminal.id}] Unsupported`;
      break;
    }
    case "maybe-throw": {
      value = `[${terminal.id}] MaybeThrow continuation=bb${terminal.continuation} handler=bb${terminal.handler}`;
      break;
    }
    case "scope": {
      value = `[${terminal.id}] Scope ${printReactiveScopeSummary(
        terminal.scope
      )} block=bb${terminal.block} fallthrough=bb${terminal.fallthrough}`;
      break;
    }
    case "pruned-scope": {
      value = `[${terminal.id}] <pruned> Scope ${printReactiveScopeSummary(
        terminal.scope
      )} block=bb${terminal.block} fallthrough=bb${terminal.fallthrough}`;
      break;
    }
    case "try": {
      value = `[${terminal.id}] Try block=bb${terminal.block} handler=bb${terminal.handler}${terminal.handlerBinding !== null ? ` handlerBinding=(${printPlace(terminal.handlerBinding)})` : ""} fallthrough=${terminal.fallthrough != null ? `bb${terminal.fallthrough}` : ""}`;
      break;
    }
    default: {
      assertExhaustive(
        terminal,
        `Unexpected terminal kind \`${terminal}\``
      );
    }
  }
  return value;
}
function printHole() {
  return "<hole>";
}
function printObjectPropertyKey(key) {
  switch (key.kind) {
    case "identifier":
      return key.name;
    case "string":
      return `"${key.name}"`;
    case "computed": {
      return `[${printPlace(key.name)}]`;
    }
    case "number": {
      return String(key.name);
    }
  }
}
function printInstructionValue(instrValue) {
  var _a, _b, _c, _d;
  let value = "";
  switch (instrValue.kind) {
    case "ArrayExpression": {
      value = `Array [${instrValue.elements.map((element) => {
        if (element.kind === "Identifier") {
          return printPlace(element);
        } else if (element.kind === "Hole") {
          return printHole();
        } else {
          return `...${printPlace(element.place)}`;
        }
      }).join(", ")}]`;
      break;
    }
    case "ObjectExpression": {
      const properties = [];
      if (instrValue.properties !== null) {
        for (const property of instrValue.properties) {
          if (property.kind === "ObjectProperty") {
            properties.push(
              `${printObjectPropertyKey(property.key)}: ${printPlace(
                property.place
              )}`
            );
          } else {
            properties.push(`...${printPlace(property.place)}`);
          }
        }
      }
      value = `Object { ${properties.join(", ")} }`;
      break;
    }
    case "UnaryExpression": {
      value = `Unary ${printPlace(instrValue.value)}`;
      break;
    }
    case "BinaryExpression": {
      value = `Binary ${printPlace(instrValue.left)} ${instrValue.operator} ${printPlace(instrValue.right)}`;
      break;
    }
    case "NewExpression": {
      value = `New ${printPlace(instrValue.callee)}(${instrValue.args.map((arg) => printPattern(arg)).join(", ")})`;
      break;
    }
    case "CallExpression": {
      value = `Call ${printPlace(instrValue.callee)}(${instrValue.args.map((arg) => printPattern(arg)).join(", ")})`;
      break;
    }
    case "MethodCall": {
      value = `MethodCall ${printPlace(instrValue.receiver)}.${printPlace(
        instrValue.property
      )}(${instrValue.args.map((arg) => printPattern(arg)).join(", ")})`;
      break;
    }
    case "JSXText": {
      value = `JSXText ${JSON.stringify(instrValue.value)}`;
      break;
    }
    case "Primitive": {
      if (instrValue.value === void 0) {
        value = "<undefined>";
      } else {
        value = JSON.stringify(instrValue.value);
      }
      break;
    }
    case "TypeCastExpression": {
      value = `TypeCast ${printPlace(instrValue.value)}: ${printType(
        instrValue.type
      )}`;
      break;
    }
    case "JsxExpression": {
      const propItems = [];
      for (const attribute of instrValue.props) {
        if (attribute.kind === "JsxAttribute") {
          propItems.push(
            `${attribute.name}={${attribute.place !== null ? printPlace(attribute.place) : "<empty>"}}`
          );
        } else {
          propItems.push(`...${printPlace(attribute.argument)}`);
        }
      }
      const tag = instrValue.tag.kind === "Identifier" ? printPlace(instrValue.tag) : instrValue.tag.name;
      const props = propItems.length !== 0 ? " " + propItems.join(" ") : "";
      if (instrValue.children !== null) {
        const children = instrValue.children.map((child) => {
          return `{${printPlace(child)}}`;
        });
        value = `JSX <${tag}${props}${props.length > 0 ? " " : ""}>${children.join("")}</${tag}>`;
      } else {
        value = `JSX <${tag}${props}${props.length > 0 ? " " : ""}/>`;
      }
      break;
    }
    case "JsxFragment": {
      value = `JsxFragment [${instrValue.children.map((child) => printPlace(child)).join(", ")}]`;
      break;
    }
    case "UnsupportedNode": {
      value = `UnsupportedNode(${(0, import_generator.default)(instrValue.node).code})`;
      break;
    }
    case "LoadLocal": {
      value = `LoadLocal ${printPlace(instrValue.place)}`;
      break;
    }
    case "DeclareLocal": {
      value = `DeclareLocal ${instrValue.lvalue.kind} ${printPlace(
        instrValue.lvalue.place
      )}`;
      break;
    }
    case "DeclareContext": {
      value = `DeclareContext ${instrValue.lvalue.kind} ${printPlace(
        instrValue.lvalue.place
      )}`;
      break;
    }
    case "StoreLocal": {
      value = `StoreLocal ${instrValue.lvalue.kind} ${printPlace(
        instrValue.lvalue.place
      )} = ${printPlace(instrValue.value)}`;
      break;
    }
    case "LoadContext": {
      value = `LoadContext ${printPlace(instrValue.place)}`;
      break;
    }
    case "StoreContext": {
      value = `StoreContext ${instrValue.lvalue.kind} ${printPlace(
        instrValue.lvalue.place
      )} = ${printPlace(instrValue.value)}`;
      break;
    }
    case "Destructure": {
      value = `Destructure ${instrValue.lvalue.kind} ${printPattern(
        instrValue.lvalue.pattern
      )} = ${printPlace(instrValue.value)}`;
      break;
    }
    case "PropertyLoad": {
      value = `PropertyLoad ${printPlace(instrValue.object)}.${instrValue.property}`;
      break;
    }
    case "PropertyStore": {
      value = `PropertyStore ${printPlace(instrValue.object)}.${instrValue.property} = ${printPlace(instrValue.value)}`;
      break;
    }
    case "PropertyDelete": {
      value = `PropertyDelete ${printPlace(instrValue.object)}.${instrValue.property}`;
      break;
    }
    case "ComputedLoad": {
      value = `ComputedLoad ${printPlace(instrValue.object)}[${printPlace(
        instrValue.property
      )}]`;
      break;
    }
    case "ComputedStore": {
      value = `ComputedStore ${printPlace(instrValue.object)}[${printPlace(
        instrValue.property
      )}] = ${printPlace(instrValue.value)}`;
      break;
    }
    case "ComputedDelete": {
      value = `ComputedDelete ${printPlace(instrValue.object)}[${printPlace(
        instrValue.property
      )}]`;
      break;
    }
    case "ObjectMethod":
    case "FunctionExpression": {
      const kind = instrValue.kind === "FunctionExpression" ? "Function" : "ObjectMethod";
      const name = getFunctionName(instrValue, "");
      const fn = printFunction(instrValue.loweredFunc.func).split("\n").map((line) => `      ${line}`).join("\n");
      const context = instrValue.loweredFunc.func.context.map((dep) => printPlace(dep)).join(",");
      const effects = (_b = (_a = instrValue.loweredFunc.func.effects) == null ? void 0 : _a.map((effect) => {
        if (effect.kind === "ContextMutation") {
          return `ContextMutation places=[${[...effect.places].map((place) => printPlace(place)).join(", ")}] effect=${effect.effect}`;
        } else {
          return `GlobalMutation`;
        }
      }).join(", ")) != null ? _b : "";
      const type = printType(instrValue.loweredFunc.func.returnType).trim();
      value = `${kind} ${name} @context[${context}] @effects[${effects}]${type !== "" ? ` return${type}` : ""}:
${fn}`;
      break;
    }
    case "TaggedTemplateExpression": {
      value = `${printPlace(instrValue.tag)}\`${instrValue.value.raw}\``;
      break;
    }
    case "LogicalExpression": {
      value = `Logical ${printInstructionValue(instrValue.left)} ${instrValue.operator} ${printInstructionValue(instrValue.right)}`;
      break;
    }
    case "SequenceExpression": {
      value = [
        `Sequence`,
        ...instrValue.instructions.map(
          (instr) => `    ${printInstruction(instr)}`
        ),
        `    ${printInstructionValue(instrValue.value)}`
      ].join("\n");
      break;
    }
    case "ConditionalExpression": {
      value = `Ternary ${printInstructionValue(
        instrValue.test
      )} ? ${printInstructionValue(
        instrValue.consequent
      )} : ${printInstructionValue(instrValue.alternate)}`;
      break;
    }
    case "TemplateLiteral": {
      value = "`";
      CompilerError.invariant(
        instrValue.subexprs.length === instrValue.quasis.length - 1,
        {
          reason: "Bad assumption about quasi length.",
          description: null,
          loc: instrValue.loc,
          suggestions: null
        }
      );
      for (let i = 0; i < instrValue.subexprs.length; i++) {
        value += instrValue.quasis[i].raw;
        value += `\${${printPlace(instrValue.subexprs[i])}}`;
      }
      value += instrValue.quasis.at(-1).raw + "`";
      break;
    }
    case "LoadGlobal": {
      switch (instrValue.binding.kind) {
        case "Global": {
          value = `LoadGlobal(global) ${instrValue.binding.name}`;
          break;
        }
        case "ModuleLocal": {
          value = `LoadGlobal(module) ${instrValue.binding.name}`;
          break;
        }
        case "ImportDefault": {
          value = `LoadGlobal import ${instrValue.binding.name} from '${instrValue.binding.module}'`;
          break;
        }
        case "ImportNamespace": {
          value = `LoadGlobal import * as ${instrValue.binding.name} from '${instrValue.binding.module}'`;
          break;
        }
        case "ImportSpecifier": {
          if (instrValue.binding.imported !== instrValue.binding.name) {
            value = `LoadGlobal import { ${instrValue.binding.imported} as ${instrValue.binding.name} } from '${instrValue.binding.module}'`;
          } else {
            value = `LoadGlobal import { ${instrValue.binding.name} } from '${instrValue.binding.module}'`;
          }
          break;
        }
        default: {
          assertExhaustive(
            instrValue.binding,
            `Unexpected binding kind \`${instrValue.binding.kind}\``
          );
        }
      }
      break;
    }
    case "StoreGlobal": {
      value = `StoreGlobal ${instrValue.name} = ${printPlace(
        instrValue.value
      )}`;
      break;
    }
    case "OptionalExpression": {
      value = `OptionalExpression ${printInstructionValue(instrValue.value)}`;
      break;
    }
    case "RegExpLiteral": {
      value = `RegExp /${instrValue.pattern}/${instrValue.flags}`;
      break;
    }
    case "MetaProperty": {
      value = `MetaProperty ${instrValue.meta}.${instrValue.property}`;
      break;
    }
    case "Await": {
      value = `Await ${printPlace(instrValue.value)}`;
      break;
    }
    case "GetIterator": {
      value = `GetIterator collection=${printPlace(instrValue.collection)}`;
      break;
    }
    case "IteratorNext": {
      value = `IteratorNext iterator=${printPlace(
        instrValue.iterator
      )} collection=${printPlace(instrValue.collection)}`;
      break;
    }
    case "NextPropertyOf": {
      value = `NextPropertyOf ${printPlace(instrValue.value)}`;
      break;
    }
    case "Debugger": {
      value = `Debugger`;
      break;
    }
    case "PostfixUpdate": {
      value = `PostfixUpdate ${printPlace(instrValue.lvalue)} = ${printPlace(
        instrValue.value
      )} ${instrValue.operation}`;
      break;
    }
    case "PrefixUpdate": {
      value = `PrefixUpdate ${printPlace(instrValue.lvalue)} = ${instrValue.operation} ${printPlace(instrValue.value)}`;
      break;
    }
    case "StartMemoize": {
      value = `StartMemoize deps=${(_d = (_c = instrValue.deps) == null ? void 0 : _c.map((dep) => printManualMemoDependency(dep, false))) != null ? _d : "(none)"}`;
      break;
    }
    case "FinishMemoize": {
      value = `FinishMemoize decl=${printPlace(instrValue.decl)}`;
      break;
    }
    default: {
      assertExhaustive(
        instrValue,
        `Unexpected instruction kind '${instrValue.kind}'`
      );
    }
  }
  return value;
}
function isMutable(range) {
  return range.end > range.start + 1;
}
var DEBUG_MUTABLE_RANGES = false;
function printMutableRange(identifier4) {
  var _a, _b, _c;
  if (DEBUG_MUTABLE_RANGES) {
    const range2 = identifier4.mutableRange;
    const scopeRange = (_a = identifier4.scope) == null ? void 0 : _a.range;
    if (scopeRange != null && (scopeRange.start !== range2.start || scopeRange.end !== range2.end)) {
      return `[${range2.start}:${range2.end}] scope=[${scopeRange.start}:${scopeRange.end}]`;
    }
    return isMutable(range2) ? `[${range2.start}:${range2.end}]` : "";
  }
  const range = (_c = (_b = identifier4.scope) == null ? void 0 : _b.range) != null ? _c : identifier4.mutableRange;
  return isMutable(range) ? `[${range.start}:${range.end}]` : "";
}
function printPattern(pattern) {
  switch (pattern.kind) {
    case "ArrayPattern": {
      return "[ " + pattern.items.map((item) => {
        if (item.kind === "Hole") {
          return "<hole>";
        }
        return printPattern(item);
      }).join(", ") + " ]";
    }
    case "ObjectPattern": {
      return "{ " + pattern.properties.map((item) => {
        switch (item.kind) {
          case "ObjectProperty": {
            return `${printObjectPropertyKey(item.key)}: ${printPattern(
              item.place
            )}`;
          }
          case "Spread": {
            return printPattern(item);
          }
          default: {
            assertExhaustive(item, "Unexpected object property kind");
          }
        }
      }).join(", ") + " }";
    }
    case "Spread": {
      return `...${printPlace(pattern.place)}`;
    }
    case "Identifier": {
      return printPlace(pattern);
    }
    default: {
      assertExhaustive(
        pattern,
        `Unexpected pattern kind \`${pattern.kind}\``
      );
    }
  }
}
function printPlace(place) {
  const items = [
    place.effect,
    " ",
    printIdentifier(place.identifier),
    printMutableRange(place.identifier),
    printType(place.identifier.type),
    place.reactive ? "{reactive}" : null
  ];
  return items.filter((x) => x != null).join("");
}
function printIdentifier(id) {
  return `${printName(id.name)}$${id.id}${printScope(id.scope)}`;
}
function printName(name) {
  if (name === null) {
    return "";
  }
  return name.value;
}
function printScope(scope) {
  return `${scope !== null ? `_@${scope.id}` : ""}`;
}
function printManualMemoDependency(val, nameOnly) {
  var _a;
  let rootStr;
  if (val.root.kind === "Global") {
    rootStr = val.root.identifierName;
  } else {
    CompilerError.invariant(((_a = val.root.value.identifier.name) == null ? void 0 : _a.kind) === "named", {
      reason: "DepsValidation: expected named local variable in depslist",
      suggestions: null,
      loc: val.root.value.loc
    });
    rootStr = nameOnly ? val.root.value.identifier.name.value : printIdentifier(val.root.value.identifier);
  }
  return `${rootStr}${val.path.map((v) => `${v.optional ? "?." : "."}${v.property}`).join("")}`;
}
function printType(type) {
  if (type.kind === "Type") return "";
  if (type.kind === "Object" && type.shapeId != null) {
    return `:T${type.kind}<${type.shapeId}>`;
  } else if (type.kind === "Function" && type.shapeId != null) {
    return `:T${type.kind}<${type.shapeId}>`;
  } else {
    return `:T${type.kind}`;
  }
}
function printSourceLocation(loc) {
  if (typeof loc === "symbol") {
    return "generated";
  } else {
    return `${loc.start.line}:${loc.start.column}:${loc.end.line}:${loc.end.column}`;
  }
}
function printSourceLocationLine(loc) {
  if (typeof loc === "symbol") {
    return "generated";
  } else {
    return `${loc.start.line}:${loc.end.line}`;
  }
}
function getFunctionName(instrValue, defaultValue) {
  var _a;
  switch (instrValue.kind) {
    case "FunctionExpression":
      return (_a = instrValue.name) != null ? _a : defaultValue;
    case "ObjectMethod":
      return defaultValue;
  }
}

// ../babel-plugin-react-compiler/src/HIR/visitors.ts
function* eachInstructionLValue(instr) {
  if (instr.lvalue !== null) {
    yield instr.lvalue;
  }
  yield* __yieldStar(eachInstructionValueLValue(instr.value));
}
function* eachInstructionValueLValue(value) {
  switch (value.kind) {
    case "DeclareContext":
    case "StoreContext":
    case "DeclareLocal":
    case "StoreLocal": {
      yield value.lvalue.place;
      break;
    }
    case "Destructure": {
      yield* __yieldStar(eachPatternOperand(value.lvalue.pattern));
      break;
    }
    case "PostfixUpdate":
    case "PrefixUpdate": {
      yield value.lvalue;
      break;
    }
  }
}
function* eachInstructionOperand(instr) {
  yield* __yieldStar(eachInstructionValueOperand(instr.value));
}
function* eachInstructionValueOperand(instrValue) {
  switch (instrValue.kind) {
    case "NewExpression":
    case "CallExpression": {
      yield instrValue.callee;
      yield* __yieldStar(eachCallArgument(instrValue.args));
      break;
    }
    case "BinaryExpression": {
      yield instrValue.left;
      yield instrValue.right;
      break;
    }
    case "MethodCall": {
      yield instrValue.receiver;
      yield instrValue.property;
      yield* __yieldStar(eachCallArgument(instrValue.args));
      break;
    }
    case "DeclareContext":
    case "DeclareLocal": {
      break;
    }
    case "LoadLocal":
    case "LoadContext": {
      yield instrValue.place;
      break;
    }
    case "StoreLocal": {
      yield instrValue.value;
      break;
    }
    case "StoreContext": {
      yield instrValue.lvalue.place;
      yield instrValue.value;
      break;
    }
    case "StoreGlobal": {
      yield instrValue.value;
      break;
    }
    case "Destructure": {
      yield instrValue.value;
      break;
    }
    case "PropertyLoad": {
      yield instrValue.object;
      break;
    }
    case "PropertyDelete": {
      yield instrValue.object;
      break;
    }
    case "PropertyStore": {
      yield instrValue.object;
      yield instrValue.value;
      break;
    }
    case "ComputedLoad": {
      yield instrValue.object;
      yield instrValue.property;
      break;
    }
    case "ComputedDelete": {
      yield instrValue.object;
      yield instrValue.property;
      break;
    }
    case "ComputedStore": {
      yield instrValue.object;
      yield instrValue.property;
      yield instrValue.value;
      break;
    }
    case "UnaryExpression": {
      yield instrValue.value;
      break;
    }
    case "JsxExpression": {
      if (instrValue.tag.kind === "Identifier") {
        yield instrValue.tag;
      }
      for (const attribute of instrValue.props) {
        switch (attribute.kind) {
          case "JsxAttribute": {
            yield attribute.place;
            break;
          }
          case "JsxSpreadAttribute": {
            yield attribute.argument;
            break;
          }
          default: {
            assertExhaustive(
              attribute,
              `Unexpected attribute kind \`${attribute.kind}\``
            );
          }
        }
      }
      if (instrValue.children) {
        yield* __yieldStar(instrValue.children);
      }
      break;
    }
    case "JsxFragment": {
      yield* __yieldStar(instrValue.children);
      break;
    }
    case "ObjectExpression": {
      for (const property of instrValue.properties) {
        if (property.kind === "ObjectProperty" && property.key.kind === "computed") {
          yield property.key.name;
        }
        yield property.place;
      }
      break;
    }
    case "ArrayExpression": {
      for (const element of instrValue.elements) {
        if (element.kind === "Identifier") {
          yield element;
        } else if (element.kind === "Spread") {
          yield element.place;
        }
      }
      break;
    }
    case "ObjectMethod":
    case "FunctionExpression": {
      yield* __yieldStar(instrValue.loweredFunc.func.context);
      break;
    }
    case "TaggedTemplateExpression": {
      yield instrValue.tag;
      break;
    }
    case "TypeCastExpression": {
      yield instrValue.value;
      break;
    }
    case "TemplateLiteral": {
      yield* __yieldStar(instrValue.subexprs);
      break;
    }
    case "Await": {
      yield instrValue.value;
      break;
    }
    case "GetIterator": {
      yield instrValue.collection;
      break;
    }
    case "IteratorNext": {
      yield instrValue.iterator;
      yield instrValue.collection;
      break;
    }
    case "NextPropertyOf": {
      yield instrValue.value;
      break;
    }
    case "PostfixUpdate":
    case "PrefixUpdate": {
      yield instrValue.value;
      break;
    }
    case "StartMemoize": {
      if (instrValue.deps != null) {
        for (const dep of instrValue.deps) {
          if (dep.root.kind === "NamedLocal") {
            yield dep.root.value;
          }
        }
      }
      break;
    }
    case "FinishMemoize": {
      yield instrValue.decl;
      break;
    }
    case "Debugger":
    case "RegExpLiteral":
    case "MetaProperty":
    case "LoadGlobal":
    case "UnsupportedNode":
    case "Primitive":
    case "JSXText": {
      break;
    }
    default: {
      assertExhaustive(
        instrValue,
        `Unexpected instruction kind \`${instrValue.kind}\``
      );
    }
  }
}
function* eachCallArgument(args) {
  for (const arg of args) {
    if (arg.kind === "Identifier") {
      yield arg;
    } else {
      yield arg.place;
    }
  }
}
function doesPatternContainSpreadElement(pattern) {
  switch (pattern.kind) {
    case "ArrayPattern": {
      for (const item of pattern.items) {
        if (item.kind === "Spread") {
          return true;
        }
      }
      break;
    }
    case "ObjectPattern": {
      for (const property of pattern.properties) {
        if (property.kind === "Spread") {
          return true;
        }
      }
      break;
    }
    default: {
      assertExhaustive(
        pattern,
        `Unexpected pattern kind \`${pattern.kind}\``
      );
    }
  }
  return false;
}
function* eachPatternOperand(pattern) {
  switch (pattern.kind) {
    case "ArrayPattern": {
      for (const item of pattern.items) {
        if (item.kind === "Identifier") {
          yield item;
        } else if (item.kind === "Spread") {
          yield item.place;
        } else if (item.kind === "Hole") {
          continue;
        } else {
          assertExhaustive(
            item,
            `Unexpected item kind \`${item.kind}\``
          );
        }
      }
      break;
    }
    case "ObjectPattern": {
      for (const property of pattern.properties) {
        if (property.kind === "ObjectProperty") {
          yield property.place;
        } else if (property.kind === "Spread") {
          yield property.place;
        } else {
          assertExhaustive(
            property,
            `Unexpected item kind \`${property.kind}\``
          );
        }
      }
      break;
    }
    default: {
      assertExhaustive(
        pattern,
        `Unexpected pattern kind \`${pattern.kind}\``
      );
    }
  }
}
function mapInstructionLValues(instr, fn) {
  switch (instr.value.kind) {
    case "DeclareLocal":
    case "StoreLocal": {
      const lvalue = instr.value.lvalue;
      lvalue.place = fn(lvalue.place);
      break;
    }
    case "Destructure": {
      mapPatternOperands(instr.value.lvalue.pattern, fn);
      break;
    }
    case "PostfixUpdate":
    case "PrefixUpdate": {
      instr.value.lvalue = fn(instr.value.lvalue);
      break;
    }
  }
  if (instr.lvalue !== null) {
    instr.lvalue = fn(instr.lvalue);
  }
}
function mapInstructionOperands(instr, fn) {
  mapInstructionValueOperands(instr.value, fn);
}
function mapInstructionValueOperands(instrValue, fn) {
  switch (instrValue.kind) {
    case "BinaryExpression": {
      instrValue.left = fn(instrValue.left);
      instrValue.right = fn(instrValue.right);
      break;
    }
    case "PropertyLoad": {
      instrValue.object = fn(instrValue.object);
      break;
    }
    case "PropertyDelete": {
      instrValue.object = fn(instrValue.object);
      break;
    }
    case "PropertyStore": {
      instrValue.object = fn(instrValue.object);
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "ComputedLoad": {
      instrValue.object = fn(instrValue.object);
      instrValue.property = fn(instrValue.property);
      break;
    }
    case "ComputedDelete": {
      instrValue.object = fn(instrValue.object);
      instrValue.property = fn(instrValue.property);
      break;
    }
    case "ComputedStore": {
      instrValue.object = fn(instrValue.object);
      instrValue.property = fn(instrValue.property);
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "DeclareContext":
    case "DeclareLocal": {
      break;
    }
    case "LoadLocal":
    case "LoadContext": {
      instrValue.place = fn(instrValue.place);
      break;
    }
    case "StoreLocal": {
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "StoreContext": {
      instrValue.lvalue.place = fn(instrValue.lvalue.place);
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "StoreGlobal": {
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "Destructure": {
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "NewExpression":
    case "CallExpression": {
      instrValue.callee = fn(instrValue.callee);
      instrValue.args = mapCallArguments(instrValue.args, fn);
      break;
    }
    case "MethodCall": {
      instrValue.receiver = fn(instrValue.receiver);
      instrValue.property = fn(instrValue.property);
      instrValue.args = mapCallArguments(instrValue.args, fn);
      break;
    }
    case "UnaryExpression": {
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "JsxExpression": {
      if (instrValue.tag.kind === "Identifier") {
        instrValue.tag = fn(instrValue.tag);
      }
      for (const attribute of instrValue.props) {
        switch (attribute.kind) {
          case "JsxAttribute": {
            attribute.place = fn(attribute.place);
            break;
          }
          case "JsxSpreadAttribute": {
            attribute.argument = fn(attribute.argument);
            break;
          }
          default: {
            assertExhaustive(
              attribute,
              `Unexpected attribute kind \`${attribute.kind}\``
            );
          }
        }
      }
      if (instrValue.children) {
        instrValue.children = instrValue.children.map((p) => fn(p));
      }
      break;
    }
    case "ObjectExpression": {
      for (const property of instrValue.properties) {
        if (property.kind === "ObjectProperty" && property.key.kind === "computed") {
          property.key.name = fn(property.key.name);
        }
        property.place = fn(property.place);
      }
      break;
    }
    case "ArrayExpression": {
      instrValue.elements = instrValue.elements.map((element) => {
        if (element.kind === "Identifier") {
          return fn(element);
        } else if (element.kind === "Spread") {
          element.place = fn(element.place);
          return element;
        } else {
          return element;
        }
      });
      break;
    }
    case "JsxFragment": {
      instrValue.children = instrValue.children.map((e) => fn(e));
      break;
    }
    case "ObjectMethod":
    case "FunctionExpression": {
      instrValue.loweredFunc.func.context = instrValue.loweredFunc.func.context.map((d) => fn(d));
      break;
    }
    case "TaggedTemplateExpression": {
      instrValue.tag = fn(instrValue.tag);
      break;
    }
    case "TypeCastExpression": {
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "TemplateLiteral": {
      instrValue.subexprs = instrValue.subexprs.map(fn);
      break;
    }
    case "Await": {
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "GetIterator": {
      instrValue.collection = fn(instrValue.collection);
      break;
    }
    case "IteratorNext": {
      instrValue.iterator = fn(instrValue.iterator);
      instrValue.collection = fn(instrValue.collection);
      break;
    }
    case "NextPropertyOf": {
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "PostfixUpdate":
    case "PrefixUpdate": {
      instrValue.value = fn(instrValue.value);
      break;
    }
    case "StartMemoize": {
      if (instrValue.deps != null) {
        for (const dep of instrValue.deps) {
          if (dep.root.kind === "NamedLocal") {
            dep.root.value = fn(dep.root.value);
          }
        }
      }
      break;
    }
    case "FinishMemoize": {
      instrValue.decl = fn(instrValue.decl);
      break;
    }
    case "Debugger":
    case "RegExpLiteral":
    case "MetaProperty":
    case "LoadGlobal":
    case "UnsupportedNode":
    case "Primitive":
    case "JSXText": {
      break;
    }
    default: {
      assertExhaustive(instrValue, "Unexpected instruction kind");
    }
  }
}
function mapCallArguments(args, fn) {
  return args.map((arg) => {
    if (arg.kind === "Identifier") {
      return fn(arg);
    } else {
      arg.place = fn(arg.place);
      return arg;
    }
  });
}
function mapPatternOperands(pattern, fn) {
  switch (pattern.kind) {
    case "ArrayPattern": {
      pattern.items = pattern.items.map((item) => {
        if (item.kind === "Identifier") {
          return fn(item);
        } else if (item.kind === "Spread") {
          item.place = fn(item.place);
          return item;
        } else {
          return item;
        }
      });
      break;
    }
    case "ObjectPattern": {
      for (const property of pattern.properties) {
        property.place = fn(property.place);
      }
      break;
    }
    default: {
      assertExhaustive(
        pattern,
        `Unexpected pattern kind \`${pattern.kind}\``
      );
    }
  }
}
function mapTerminalSuccessors(terminal, fn) {
  switch (terminal.kind) {
    case "goto": {
      const target = fn(terminal.block);
      return {
        kind: "goto",
        block: target,
        variant: terminal.variant,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "if": {
      const consequent = fn(terminal.consequent);
      const alternate = fn(terminal.alternate);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "if",
        test: terminal.test,
        consequent,
        alternate,
        fallthrough,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "branch": {
      const consequent = fn(terminal.consequent);
      const alternate = fn(terminal.alternate);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "branch",
        test: terminal.test,
        consequent,
        alternate,
        fallthrough,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "switch": {
      const cases = terminal.cases.map((case_) => {
        const target = fn(case_.block);
        return {
          test: case_.test,
          block: target
        };
      });
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "switch",
        test: terminal.test,
        cases,
        fallthrough,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "logical": {
      const test = fn(terminal.test);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "logical",
        test,
        fallthrough,
        operator: terminal.operator,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "ternary": {
      const test = fn(terminal.test);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "ternary",
        test,
        fallthrough,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "optional": {
      const test = fn(terminal.test);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "optional",
        optional: terminal.optional,
        test,
        fallthrough,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "return": {
      return {
        kind: "return",
        loc: terminal.loc,
        value: terminal.value,
        id: makeInstructionId(0)
      };
    }
    case "throw": {
      return terminal;
    }
    case "do-while": {
      const loop = fn(terminal.loop);
      const test = fn(terminal.test);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "do-while",
        loc: terminal.loc,
        test,
        loop,
        fallthrough,
        id: makeInstructionId(0)
      };
    }
    case "while": {
      const test = fn(terminal.test);
      const loop = fn(terminal.loop);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "while",
        loc: terminal.loc,
        test,
        loop,
        fallthrough,
        id: makeInstructionId(0)
      };
    }
    case "for": {
      const init = fn(terminal.init);
      const test = fn(terminal.test);
      const update2 = terminal.update !== null ? fn(terminal.update) : null;
      const loop = fn(terminal.loop);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "for",
        loc: terminal.loc,
        init,
        test,
        update: update2,
        loop,
        fallthrough,
        id: makeInstructionId(0)
      };
    }
    case "for-of": {
      const init = fn(terminal.init);
      const loop = fn(terminal.loop);
      const test = fn(terminal.test);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "for-of",
        loc: terminal.loc,
        init,
        test,
        loop,
        fallthrough,
        id: makeInstructionId(0)
      };
    }
    case "for-in": {
      const init = fn(terminal.init);
      const loop = fn(terminal.loop);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "for-in",
        loc: terminal.loc,
        init,
        loop,
        fallthrough,
        id: makeInstructionId(0)
      };
    }
    case "label": {
      const block = fn(terminal.block);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "label",
        block,
        fallthrough,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "sequence": {
      const block = fn(terminal.block);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "sequence",
        block,
        fallthrough,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "maybe-throw": {
      const continuation = fn(terminal.continuation);
      const handler = fn(terminal.handler);
      return {
        kind: "maybe-throw",
        continuation,
        handler,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "try": {
      const block = fn(terminal.block);
      const handler = fn(terminal.handler);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: "try",
        block,
        handlerBinding: terminal.handlerBinding,
        handler,
        fallthrough,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "scope":
    case "pruned-scope": {
      const block = fn(terminal.block);
      const fallthrough = fn(terminal.fallthrough);
      return {
        kind: terminal.kind,
        scope: terminal.scope,
        block,
        fallthrough,
        id: makeInstructionId(0),
        loc: terminal.loc
      };
    }
    case "unreachable":
    case "unsupported": {
      return terminal;
    }
    default: {
      assertExhaustive(
        terminal,
        `Unexpected terminal kind \`${terminal.kind}\``
      );
    }
  }
}
function terminalHasFallthrough(terminal) {
  switch (terminal.kind) {
    case "maybe-throw":
    case "goto":
    case "return":
    case "throw":
    case "unreachable":
    case "unsupported": {
      const _ = terminal.fallthrough;
      return false;
    }
    case "branch":
    case "try":
    case "do-while":
    case "for-of":
    case "for-in":
    case "for":
    case "if":
    case "label":
    case "logical":
    case "optional":
    case "sequence":
    case "switch":
    case "ternary":
    case "while":
    case "scope":
    case "pruned-scope": {
      const _ = terminal.fallthrough;
      return true;
    }
    default: {
      assertExhaustive(
        terminal,
        `Unexpected terminal kind \`${terminal.kind}\``
      );
    }
  }
}
function terminalFallthrough(terminal) {
  if (terminalHasFallthrough(terminal)) {
    return terminal.fallthrough;
  } else {
    return null;
  }
}
function* eachTerminalSuccessor(terminal) {
  switch (terminal.kind) {
    case "goto": {
      yield terminal.block;
      break;
    }
    case "if": {
      yield terminal.consequent;
      yield terminal.alternate;
      break;
    }
    case "branch": {
      yield terminal.consequent;
      yield terminal.alternate;
      break;
    }
    case "switch": {
      for (const case_ of terminal.cases) {
        yield case_.block;
      }
      break;
    }
    case "optional":
    case "ternary":
    case "logical": {
      yield terminal.test;
      break;
    }
    case "return": {
      break;
    }
    case "throw": {
      break;
    }
    case "do-while": {
      yield terminal.loop;
      break;
    }
    case "while": {
      yield terminal.test;
      break;
    }
    case "for": {
      yield terminal.init;
      break;
    }
    case "for-of": {
      yield terminal.init;
      break;
    }
    case "for-in": {
      yield terminal.init;
      break;
    }
    case "label": {
      yield terminal.block;
      break;
    }
    case "sequence": {
      yield terminal.block;
      break;
    }
    case "maybe-throw": {
      yield terminal.continuation;
      yield terminal.handler;
      break;
    }
    case "try": {
      yield terminal.block;
      break;
    }
    case "scope":
    case "pruned-scope": {
      yield terminal.block;
      break;
    }
    case "unreachable":
    case "unsupported":
      break;
    default: {
      assertExhaustive(
        terminal,
        `Unexpected terminal kind \`${terminal.kind}\``
      );
    }
  }
}
function mapTerminalOperands(terminal, fn) {
  switch (terminal.kind) {
    case "if": {
      terminal.test = fn(terminal.test);
      break;
    }
    case "branch": {
      terminal.test = fn(terminal.test);
      break;
    }
    case "switch": {
      terminal.test = fn(terminal.test);
      for (const case_ of terminal.cases) {
        if (case_.test === null) {
          continue;
        }
        case_.test = fn(case_.test);
      }
      break;
    }
    case "return":
    case "throw": {
      terminal.value = fn(terminal.value);
      break;
    }
    case "try": {
      if (terminal.handlerBinding !== null) {
        terminal.handlerBinding = fn(terminal.handlerBinding);
      } else {
        terminal.handlerBinding = null;
      }
      break;
    }
    case "maybe-throw":
    case "sequence":
    case "label":
    case "optional":
    case "ternary":
    case "logical":
    case "do-while":
    case "while":
    case "for":
    case "for-of":
    case "for-in":
    case "goto":
    case "unreachable":
    case "unsupported":
    case "scope":
    case "pruned-scope": {
      break;
    }
    default: {
      assertExhaustive(
        terminal,
        `Unexpected terminal kind \`${terminal.kind}\``
      );
    }
  }
}
function* eachTerminalOperand(terminal) {
  switch (terminal.kind) {
    case "if": {
      yield terminal.test;
      break;
    }
    case "branch": {
      yield terminal.test;
      break;
    }
    case "switch": {
      yield terminal.test;
      for (const case_ of terminal.cases) {
        if (case_.test === null) {
          continue;
        }
        yield case_.test;
      }
      break;
    }
    case "return":
    case "throw": {
      yield terminal.value;
      break;
    }
    case "try": {
      if (terminal.handlerBinding !== null) {
        yield terminal.handlerBinding;
      }
      break;
    }
    case "maybe-throw":
    case "sequence":
    case "label":
    case "optional":
    case "ternary":
    case "logical":
    case "do-while":
    case "while":
    case "for":
    case "for-of":
    case "for-in":
    case "goto":
    case "unreachable":
    case "unsupported":
    case "scope":
    case "pruned-scope": {
      break;
    }
    default: {
      assertExhaustive(
        terminal,
        `Unexpected terminal kind \`${terminal.kind}\``
      );
    }
  }
}
var _activeScopes;
var ScopeBlockTraversal = class {
  constructor() {
    // Live stack of active scopes
    __privateAdd(this, _activeScopes, []);
    this.blockInfos = /* @__PURE__ */ new Map();
  }
  recordScopes(block) {
    var _a, _b;
    const blockInfo = this.blockInfos.get(block.id);
    if ((blockInfo == null ? void 0 : blockInfo.kind) === "begin") {
      __privateGet(this, _activeScopes).push(blockInfo.scope.id);
    } else if ((blockInfo == null ? void 0 : blockInfo.kind) === "end") {
      const top = __privateGet(this, _activeScopes).at(-1);
      CompilerError.invariant(blockInfo.scope.id === top, {
        reason: "Expected traversed block fallthrough to match top-most active scope",
        loc: (_b = (_a = block.instructions[0]) == null ? void 0 : _a.loc) != null ? _b : block.terminal.id
      });
      __privateGet(this, _activeScopes).pop();
    }
    if (block.terminal.kind === "scope" || block.terminal.kind === "pruned-scope") {
      CompilerError.invariant(
        !this.blockInfos.has(block.terminal.block) && !this.blockInfos.has(block.terminal.fallthrough),
        {
          reason: "Expected unique scope blocks and fallthroughs",
          loc: block.terminal.loc
        }
      );
      this.blockInfos.set(block.terminal.block, {
        kind: "begin",
        scope: block.terminal.scope,
        pruned: block.terminal.kind === "pruned-scope",
        fallthrough: block.terminal.fallthrough
      });
      this.blockInfos.set(block.terminal.fallthrough, {
        kind: "end",
        scope: block.terminal.scope,
        pruned: block.terminal.kind === "pruned-scope"
      });
    }
  }
  /**
   * @returns if the given scope is currently 'active', i.e. if the scope start
   * block but not the scope fallthrough has been recorded.
   */
  isScopeActive(scopeId) {
    return __privateGet(this, _activeScopes).indexOf(scopeId) !== -1;
  }
  /**
   * The current, innermost active scope.
   */
  get currentScope() {
    var _a;
    return (_a = __privateGet(this, _activeScopes).at(-1)) != null ? _a : null;
  }
};
_activeScopes = new WeakMap();

// ../babel-plugin-react-compiler/src/HIR/AssertConsistentIdentifiers.ts
function assertConsistentIdentifiers(fn) {
  const identifiers = /* @__PURE__ */ new Map();
  const assignments = /* @__PURE__ */ new Set();
  for (const [, block] of fn.body.blocks) {
    for (const phi of block.phis) {
      validate(identifiers, phi.place.identifier);
      for (const [, operand] of phi.operands) {
        validate(identifiers, operand.identifier);
      }
    }
    for (const instr of block.instructions) {
      CompilerError.invariant(instr.lvalue.identifier.name === null, {
        reason: `Expected all lvalues to be temporaries`,
        description: `Found named lvalue \`${instr.lvalue.identifier.name}\``,
        loc: instr.lvalue.loc,
        suggestions: null
      });
      CompilerError.invariant(!assignments.has(instr.lvalue.identifier.id), {
        reason: `Expected lvalues to be assigned exactly once`,
        description: `Found duplicate assignment of '${printPlace(
          instr.lvalue
        )}'`,
        loc: instr.lvalue.loc,
        suggestions: null
      });
      assignments.add(instr.lvalue.identifier.id);
      for (const operand of eachInstructionLValue(instr)) {
        validate(identifiers, operand.identifier, operand.loc);
      }
      for (const operand of eachInstructionValueOperand(instr.value)) {
        validate(identifiers, operand.identifier, operand.loc);
      }
    }
    for (const operand of eachTerminalOperand(block.terminal)) {
      validate(identifiers, operand.identifier, operand.loc);
    }
  }
}
function validate(identifiers, identifier4, loc = null) {
  const previous = identifiers.get(identifier4.id);
  if (previous === void 0) {
    identifiers.set(identifier4.id, identifier4);
  } else {
    CompilerError.invariant(identifier4 === previous, {
      reason: `Duplicate identifier object`,
      description: `Found duplicate identifier object for id ${identifier4.id}`,
      loc: loc != null ? loc : GeneratedSource,
      suggestions: null
    });
  }
}

// ../babel-plugin-react-compiler/src/HIR/AssertTerminalBlocksExist.ts
function assertTerminalSuccessorsExist(fn) {
  for (const [, block] of fn.body.blocks) {
    mapTerminalSuccessors(block.terminal, (successor) => {
      var _a;
      CompilerError.invariant(fn.body.blocks.has(successor), {
        reason: `Terminal successor references unknown block`,
        description: `Block bb${successor} does not exist for terminal '${printTerminal(
          block.terminal
        )}'`,
        loc: (_a = block.terminal.loc) != null ? _a : GeneratedSource,
        suggestions: null
      });
      return successor;
    });
  }
}
function assertTerminalPredsExist(fn) {
  for (const [, block] of fn.body.blocks) {
    for (const pred of block.preds) {
      const predBlock = fn.body.blocks.get(pred);
      CompilerError.invariant(predBlock != null, {
        reason: "Expected predecessor block to exist",
        description: `Block ${block.id} references non-existent ${pred}`,
        loc: GeneratedSource
      });
      CompilerError.invariant(
        [...eachTerminalSuccessor(predBlock.terminal)].includes(block.id),
        {
          reason: "Terminal successor does not reference correct predecessor",
          description: `Block bb${block.id} has bb${predBlock.id} as a predecessor, but bb${predBlock.id}'s successors do not include bb${block.id}`,
          loc: GeneratedSource
        }
      );
    }
  }
}

// ../babel-plugin-react-compiler/src/HIR/AssertValidBlockNesting.ts
function getScopes(fn) {
  const scopes = /* @__PURE__ */ new Set();
  function visitPlace2(place) {
    const scope = place.identifier.scope;
    if (scope != null) {
      if (scope.range.start !== scope.range.end) {
        scopes.add(scope);
      }
    }
  }
  for (const [, block] of fn.body.blocks) {
    for (const instr of block.instructions) {
      for (const operand of eachInstructionLValue(instr)) {
        visitPlace2(operand);
      }
      for (const operand of eachInstructionOperand(instr)) {
        visitPlace2(operand);
      }
    }
    for (const operand of eachTerminalOperand(block.terminal)) {
      visitPlace2(operand);
    }
  }
  return scopes;
}
function rangePreOrderComparator(a, b) {
  const startDiff = a.start - b.start;
  if (startDiff !== 0) return startDiff;
  return b.end - a.end;
}
function recursivelyTraverseItems(items, getRange, context, enter, exit) {
  items.sort((a, b) => rangePreOrderComparator(getRange(a), getRange(b)));
  let activeItems = [];
  const ranges = items.map(getRange);
  for (let i = 0; i < items.length; i++) {
    const curr2 = items[i];
    const currRange = ranges[i];
    for (let i2 = activeItems.length - 1; i2 >= 0; i2--) {
      const maybeParent = activeItems[i2];
      const maybeParentRange = getRange(maybeParent);
      const disjoint = currRange.start >= maybeParentRange.end;
      const nested = currRange.end <= maybeParentRange.end;
      CompilerError.invariant(disjoint || nested, {
        reason: "Invalid nesting in program blocks or scopes",
        description: `Items overlap but are not nested: ${maybeParentRange.start}:${maybeParentRange.end}(${currRange.start}:${currRange.end})`,
        loc: GeneratedSource
      });
      if (disjoint) {
        exit(maybeParent, context);
        activeItems.length = i2;
      } else {
        break;
      }
    }
    enter(curr2, context);
    activeItems.push(curr2);
  }
  let curr = activeItems.pop();
  while (curr != null) {
    exit(curr, context);
    curr = activeItems.pop();
  }
}
var no_op = () => {
};
function assertValidBlockNesting(fn) {
  var _a, _b;
  const scopes = getScopes(fn);
  const blocks = [...scopes].map((scope) => __spreadValues({
    kind: "Scope",
    id: scope.id
  }, scope.range));
  for (const [, block] of fn.body.blocks) {
    const fallthroughId = terminalFallthrough(block.terminal);
    if (fallthroughId != null) {
      const fallthrough = fn.body.blocks.get(fallthroughId);
      const end = (_b = (_a = fallthrough.instructions[0]) == null ? void 0 : _a.id) != null ? _b : fallthrough.terminal.id;
      blocks.push({
        kind: "ProgramBlockSubtree",
        id: block.id,
        start: block.terminal.id,
        end
      });
    }
  }
  recursivelyTraverseItems(blocks, (block) => block, null, no_op, no_op);
}

// ../babel-plugin-react-compiler/src/HIR/AssertValidMutableRanges.ts
var import_invariant = __toESM(require_invariant());
function assertValidMutableRanges(fn) {
  for (const [, block] of fn.body.blocks) {
    for (const phi of block.phis) {
      visitIdentifier(phi.place.identifier);
      for (const [, operand] of phi.operands) {
        visitIdentifier(operand.identifier);
      }
    }
    for (const instr of block.instructions) {
      for (const operand of eachInstructionLValue(instr)) {
        visitIdentifier(operand.identifier);
      }
      for (const operand of eachInstructionOperand(instr)) {
        visitIdentifier(operand.identifier);
      }
    }
    for (const operand of eachTerminalOperand(block.terminal)) {
      visitIdentifier(operand.identifier);
    }
  }
}
function visitIdentifier(identifier4) {
  validateMutableRange(identifier4.mutableRange);
  if (identifier4.scope !== null) {
    validateMutableRange(identifier4.scope.range);
  }
}
function validateMutableRange(mutableRange) {
  (0, import_invariant.default)(
    mutableRange.start === 0 && mutableRange.end === 0 || mutableRange.end > mutableRange.start,
    "Identifier scope mutableRange was invalid: [%s:%s]",
    mutableRange.start,
    mutableRange.end
  );
}

// ../babel-plugin-react-compiler/src/HIR/BuildHIR.ts
var import_invariant2 = __toESM(require_invariant());

// ../babel-plugin-react-compiler/src/HIR/HIRBuilder.ts
function newBlock(id, kind) {
  return { id, kind, instructions: [] };
}
var _completed, _current, _entry, _scopes, _context, _bindings, _env, _exceptionHandlerStack, _HIRBuilder_instances, resolveBabelBinding_fn;
var HIRBuilder = class {
  constructor(env, parentFunction, bindings = null, context = null) {
    __privateAdd(this, _HIRBuilder_instances);
    __privateAdd(this, _completed, /* @__PURE__ */ new Map());
    __privateAdd(this, _current);
    __privateAdd(this, _entry);
    __privateAdd(this, _scopes, []);
    __privateAdd(this, _context);
    __privateAdd(this, _bindings);
    __privateAdd(this, _env);
    __privateAdd(this, _exceptionHandlerStack, []);
    this.errors = new CompilerError();
    /**
     * Traversal context: counts the number of `fbt` tag parents
     * of the current babel node.
     */
    this.fbtDepth = 0;
    __privateSet(this, _env, env);
    __privateSet(this, _bindings, bindings != null ? bindings : /* @__PURE__ */ new Map());
    this.parentFunction = parentFunction;
    __privateSet(this, _context, context != null ? context : []);
    __privateSet(this, _entry, makeBlockId(env.nextBlockId));
    __privateSet(this, _current, newBlock(__privateGet(this, _entry), "block"));
  }
  get nextIdentifierId() {
    return __privateGet(this, _env).nextIdentifierId;
  }
  get context() {
    return __privateGet(this, _context);
  }
  get bindings() {
    return __privateGet(this, _bindings);
  }
  get environment() {
    return __privateGet(this, _env);
  }
  currentBlockKind() {
    return __privateGet(this, _current).kind;
  }
  // Push a statement or expression onto the current block
  push(instruction) {
    __privateGet(this, _current).instructions.push(instruction);
    const exceptionHandler = __privateGet(this, _exceptionHandlerStack).at(-1);
    if (exceptionHandler !== void 0) {
      const continuationBlock = this.reserve(this.currentBlockKind());
      this.terminateWithContinuation(
        {
          kind: "maybe-throw",
          continuation: continuationBlock.id,
          handler: exceptionHandler,
          id: makeInstructionId(0),
          loc: instruction.loc
        },
        continuationBlock
      );
    }
  }
  enterTryCatch(handler, fn) {
    __privateGet(this, _exceptionHandlerStack).push(handler);
    fn();
    __privateGet(this, _exceptionHandlerStack).pop();
  }
  resolveThrowHandler() {
    const handler = __privateGet(this, _exceptionHandlerStack).at(-1);
    return handler != null ? handler : null;
  }
  makeTemporary(loc) {
    const id = this.nextIdentifierId;
    return makeTemporaryIdentifier(id, loc);
  }
  /*
   * Maps an Identifier (or JSX identifier) Babel node to an internal `Identifier`
   * which represents the variable being referenced, according to the JS scoping rules.
   *
   * Because Forget does not preserve _all_ block scopes in the input (only those that
   * happen to occur from control flow), this resolution ensures that different variables
   * with the same name are mapped to a unique name. Concretely, this function maintains
   * the invariant that all references to a given variable will return an `Identifier`
   * with the same (unique for the function) `name` and `id`.
   *
   * Example:
   *
   * ```javascript
   * function foo() {
   *    const x = 0;
   *    {
   *      const x = 1;
   *    }
   *    return x;
   * }
   * ```
   *
   * The above converts as follows:
   *
   * ```
   * Const Identifier { name: 'x', id: 0 } = Primitive { value: 0 };
   * Const Identifier { name: 'x_0', id: 1 } = Primitive { value: 1 };
   * Return Identifier { name: 'x', id: 0};
   * ```
   */
  resolveIdentifier(path) {
    const originalName = path.node.name;
    const babelBinding = __privateMethod(this, _HIRBuilder_instances, resolveBabelBinding_fn).call(this, path);
    if (babelBinding == null) {
      return { kind: "Global", name: originalName };
    }
    const outerBinding = this.parentFunction.scope.parent.getBinding(originalName);
    if (babelBinding === outerBinding) {
      const path2 = babelBinding.path;
      if (path2.isImportDefaultSpecifier()) {
        const importDeclaration2 = path2.parentPath;
        return {
          kind: "ImportDefault",
          name: originalName,
          module: importDeclaration2.node.source.value
        };
      } else if (path2.isImportSpecifier()) {
        const importDeclaration2 = path2.parentPath;
        return {
          kind: "ImportSpecifier",
          name: originalName,
          module: importDeclaration2.node.source.value,
          imported: path2.node.imported.type === "Identifier" ? path2.node.imported.name : path2.node.imported.value
        };
      } else if (path2.isImportNamespaceSpecifier()) {
        const importDeclaration2 = path2.parentPath;
        return {
          kind: "ImportNamespace",
          name: originalName,
          module: importDeclaration2.node.source.value
        };
      } else {
        return {
          kind: "ModuleLocal",
          name: originalName
        };
      }
    }
    const resolvedBinding = this.resolveBinding(babelBinding.identifier);
    if (resolvedBinding.name && resolvedBinding.name.value !== originalName) {
      babelBinding.scope.rename(originalName, resolvedBinding.name.value);
    }
    return {
      kind: "Identifier",
      identifier: resolvedBinding,
      bindingKind: babelBinding.kind
    };
  }
  isContextIdentifier(path) {
    const binding = __privateMethod(this, _HIRBuilder_instances, resolveBabelBinding_fn).call(this, path);
    if (binding) {
      const outerBinding = this.parentFunction.scope.parent.getBinding(
        path.node.name
      );
      if (binding === outerBinding) {
        return false;
      }
      return __privateGet(this, _env).isContextIdentifier(binding.identifier);
    } else {
      return false;
    }
  }
  resolveBinding(node) {
    var _a, _b;
    if (node.name === "fbt") {
      CompilerError.throwTodo({
        reason: 'Support local variables named "fbt"',
        loc: (_a = node.loc) != null ? _a : null
      });
    }
    const originalName = node.name;
    let name = originalName;
    let index = 0;
    while (true) {
      const mapping = __privateGet(this, _bindings).get(name);
      if (mapping === void 0) {
        const id = this.nextIdentifierId;
        const identifier4 = {
          id,
          declarationId: makeDeclarationId(id),
          name: makeIdentifierName(name),
          mutableRange: {
            start: makeInstructionId(0),
            end: makeInstructionId(0)
          },
          scope: null,
          type: makeType(),
          loc: (_b = node.loc) != null ? _b : GeneratedSource
        };
        __privateGet(this, _env).programContext.addNewReference(name);
        __privateGet(this, _bindings).set(name, { node, identifier: identifier4 });
        return identifier4;
      } else if (mapping.node === node) {
        return mapping.identifier;
      } else {
        name = `${originalName}_${index++}`;
      }
    }
  }
  // Construct a final CFG from this context
  build() {
    var _a, _b;
    let ir = {
      blocks: __privateGet(this, _completed),
      entry: __privateGet(this, _entry)
    };
    const rpoBlocks = getReversePostorderedBlocks(ir);
    for (const [id, block] of ir.blocks) {
      if (!rpoBlocks.has(id) && block.instructions.some(
        (instr) => instr.value.kind === "FunctionExpression"
      )) {
        CompilerError.throwTodo({
          reason: `Support functions with unreachable code that may contain hoisted declarations`,
          loc: (_b = (_a = block.instructions[0]) == null ? void 0 : _a.loc) != null ? _b : block.terminal.loc,
          description: null,
          suggestions: null
        });
      }
    }
    ir.blocks = rpoBlocks;
    removeUnreachableForUpdates(ir);
    removeDeadDoWhileStatements(ir);
    removeUnnecessaryTryCatch(ir);
    markInstructionIds(ir);
    markPredecessors(ir);
    return ir;
  }
  // Terminate the current block w the given terminal, and start a new block
  terminate(terminal, nextBlockKind) {
    const { id: blockId, kind, instructions } = __privateGet(this, _current);
    __privateGet(this, _completed).set(blockId, {
      kind,
      id: blockId,
      instructions,
      terminal,
      preds: /* @__PURE__ */ new Set(),
      phis: /* @__PURE__ */ new Set()
    });
    if (nextBlockKind) {
      const nextId = __privateGet(this, _env).nextBlockId;
      __privateSet(this, _current, newBlock(nextId, nextBlockKind));
    }
  }
  /*
   * Terminate the current block w the given terminal, and set the previously
   * reserved block as the new current block
   */
  terminateWithContinuation(terminal, continuation) {
    const { id: blockId, kind, instructions } = __privateGet(this, _current);
    __privateGet(this, _completed).set(blockId, {
      kind,
      id: blockId,
      instructions,
      terminal,
      preds: /* @__PURE__ */ new Set(),
      phis: /* @__PURE__ */ new Set()
    });
    __privateSet(this, _current, continuation);
  }
  /*
   * Reserve a block so that it can be referenced prior to construction.
   * Make this the current block with `terminateWithContinuation()` or
   * call `complete()` to save it without setting it as the current block.
   */
  reserve(kind) {
    return newBlock(makeBlockId(__privateGet(this, _env).nextBlockId), kind);
  }
  // Save a previously reserved block as completed
  complete(block, terminal) {
    const { id: blockId, kind, instructions } = block;
    __privateGet(this, _completed).set(blockId, {
      kind,
      id: blockId,
      instructions,
      terminal,
      preds: /* @__PURE__ */ new Set(),
      phis: /* @__PURE__ */ new Set()
    });
  }
  /*
   * Sets the given wip block as the current block, executes the provided callback to populate the block
   * up to its terminal, and then resets the previous actively block.
   */
  enterReserved(wip, fn) {
    const current = __privateGet(this, _current);
    __privateSet(this, _current, wip);
    const terminal = fn();
    const { id: blockId, kind, instructions } = __privateGet(this, _current);
    __privateGet(this, _completed).set(blockId, {
      kind,
      id: blockId,
      instructions,
      terminal,
      preds: /* @__PURE__ */ new Set(),
      phis: /* @__PURE__ */ new Set()
    });
    __privateSet(this, _current, current);
  }
  /*
   * Create a new block and execute the provided callback with the new block
   * set as the current, resetting to the previously active block upon exit.
   * The lambda must return a terminal node, which is used to terminate the
   * newly constructed block.
   */
  enter(nextBlockKind, fn) {
    const wip = this.reserve(nextBlockKind);
    this.enterReserved(wip, () => {
      return fn(wip.id);
    });
    return wip.id;
  }
  label(label, breakBlock, fn) {
    __privateGet(this, _scopes).push({
      kind: "label",
      breakBlock,
      label
    });
    const value = fn();
    const last = __privateGet(this, _scopes).pop();
    CompilerError.invariant(
      last != null && last.kind === "label" && last.label === label && last.breakBlock === breakBlock,
      {
        reason: "Mismatched label",
        description: null,
        loc: null,
        suggestions: null
      }
    );
    return value;
  }
  switch(label, breakBlock, fn) {
    __privateGet(this, _scopes).push({
      kind: "switch",
      breakBlock,
      label
    });
    const value = fn();
    const last = __privateGet(this, _scopes).pop();
    CompilerError.invariant(
      last != null && last.kind === "switch" && last.label === label && last.breakBlock === breakBlock,
      {
        reason: "Mismatched label",
        description: null,
        loc: null,
        suggestions: null
      }
    );
    return value;
  }
  /*
   * Executes the provided lambda inside a scope in which the provided loop
   * information is cached for lookup with `lookupBreak()` and `lookupContinue()`
   */
  loop(label, continueBlock, breakBlock, fn) {
    __privateGet(this, _scopes).push({
      kind: "loop",
      label,
      continueBlock,
      breakBlock
    });
    const value = fn();
    const last = __privateGet(this, _scopes).pop();
    CompilerError.invariant(
      last != null && last.kind === "loop" && last.label === label && last.continueBlock === continueBlock && last.breakBlock === breakBlock,
      {
        reason: "Mismatched loops",
        description: null,
        loc: null,
        suggestions: null
      }
    );
    return value;
  }
  /*
   * Lookup the block target for a break statement, based on loops and switch statements
   * in scope. Throws if there is no available location to break.
   */
  lookupBreak(label) {
    for (let ii = __privateGet(this, _scopes).length - 1; ii >= 0; ii--) {
      const scope = __privateGet(this, _scopes)[ii];
      if (label === null && (scope.kind === "loop" || scope.kind === "switch") || label === scope.label) {
        return scope.breakBlock;
      }
    }
    CompilerError.invariant(false, {
      reason: "Expected a loop or switch to be in scope",
      description: null,
      loc: null,
      suggestions: null
    });
  }
  /*
   * Lookup the block target for a continue statement, based on loops
   * in scope. Throws if there is no available location to continue, or if the given
   * label does not correspond to a loop (this should also be validated at parse time).
   */
  lookupContinue(label) {
    for (let ii = __privateGet(this, _scopes).length - 1; ii >= 0; ii--) {
      const scope = __privateGet(this, _scopes)[ii];
      if (scope.kind === "loop") {
        if (label === null || label === scope.label) {
          return scope.continueBlock;
        }
      } else if (label !== null && scope.label === label) {
        CompilerError.invariant(false, {
          reason: "Continue may only refer to a labeled loop",
          description: null,
          loc: null,
          suggestions: null
        });
      }
    }
    CompilerError.invariant(false, {
      reason: "Expected a loop to be in scope",
      description: null,
      loc: null,
      suggestions: null
    });
  }
};
_completed = new WeakMap();
_current = new WeakMap();
_entry = new WeakMap();
_scopes = new WeakMap();
_context = new WeakMap();
_bindings = new WeakMap();
_env = new WeakMap();
_exceptionHandlerStack = new WeakMap();
_HIRBuilder_instances = new WeakSet();
resolveBabelBinding_fn = function(path) {
  const originalName = path.node.name;
  const binding = path.scope.getBinding(originalName);
  if (binding == null) {
    return null;
  }
  return binding;
};
function removeUnreachableForUpdates(fn) {
  for (const [, block] of fn.blocks) {
    if (block.terminal.kind === "for" && block.terminal.update !== null && !fn.blocks.has(block.terminal.update)) {
      block.terminal.update = null;
    }
  }
}
function removeDeadDoWhileStatements(func) {
  const visited = /* @__PURE__ */ new Set();
  for (const [_, block] of func.blocks) {
    visited.add(block.id);
  }
  for (const [_, block] of func.blocks) {
    if (block.terminal.kind === "do-while") {
      if (!visited.has(block.terminal.test)) {
        block.terminal = {
          kind: "goto",
          block: block.terminal.loop,
          variant: "Break" /* Break */,
          id: block.terminal.id,
          loc: block.terminal.loc
        };
      }
    }
  }
}
function reversePostorderBlocks(func) {
  const rpoBlocks = getReversePostorderedBlocks(func);
  func.blocks = rpoBlocks;
}
function getReversePostorderedBlocks(func) {
  const visited = /* @__PURE__ */ new Set();
  const used = /* @__PURE__ */ new Set();
  const usedFallthroughs = /* @__PURE__ */ new Set();
  const postorder = [];
  function visit3(blockId, isUsed) {
    const wasUsed = used.has(blockId);
    const wasVisited = visited.has(blockId);
    visited.add(blockId);
    if (isUsed) {
      used.add(blockId);
    }
    if (wasVisited && (wasUsed || !isUsed)) {
      return;
    }
    const block = func.blocks.get(blockId);
    const successors = [...eachTerminalSuccessor(block.terminal)].reverse();
    const fallthrough = terminalFallthrough(block.terminal);
    if (fallthrough != null) {
      if (isUsed) {
        usedFallthroughs.add(fallthrough);
      }
      visit3(fallthrough, false);
    }
    for (const successor of successors) {
      visit3(successor, isUsed);
    }
    if (!wasVisited) {
      postorder.push(blockId);
    }
  }
  visit3(func.entry, true);
  const blocks = /* @__PURE__ */ new Map();
  for (const blockId of postorder.reverse()) {
    const block = func.blocks.get(blockId);
    if (used.has(blockId)) {
      blocks.set(blockId, func.blocks.get(blockId));
    } else if (usedFallthroughs.has(blockId)) {
      blocks.set(blockId, __spreadProps(__spreadValues({}, block), {
        instructions: [],
        terminal: {
          kind: "unreachable",
          id: block.terminal.id,
          loc: block.terminal.loc
        }
      }));
    }
  }
  return blocks;
}
function markInstructionIds(func) {
  let id = 0;
  const visited = /* @__PURE__ */ new Set();
  for (const [_, block] of func.blocks) {
    for (const instr of block.instructions) {
      CompilerError.invariant(!visited.has(instr), {
        reason: `${printInstruction(instr)} already visited!`,
        description: null,
        loc: instr.loc,
        suggestions: null
      });
      visited.add(instr);
      instr.id = makeInstructionId(++id);
    }
    block.terminal.id = makeInstructionId(++id);
  }
}
function markPredecessors(func) {
  for (const [, block] of func.blocks) {
    block.preds.clear();
  }
  const visited = /* @__PURE__ */ new Set();
  function visit3(blockId, prevBlock) {
    const block = func.blocks.get(blockId);
    if (block == null) {
      return;
    }
    CompilerError.invariant(block != null, {
      reason: "unexpected missing block",
      description: `block ${blockId}`,
      loc: GeneratedSource
    });
    if (prevBlock) {
      block.preds.add(prevBlock.id);
    }
    if (visited.has(blockId)) {
      return;
    }
    visited.add(blockId);
    const { terminal } = block;
    for (const successor of eachTerminalSuccessor(terminal)) {
      visit3(successor, block);
    }
  }
  visit3(func.entry, null);
}
function removeUnnecessaryTryCatch(fn) {
  for (const [, block] of fn.blocks) {
    if (block.terminal.kind === "try" && !fn.blocks.has(block.terminal.handler)) {
      const handlerId = block.terminal.handler;
      const fallthroughId = block.terminal.fallthrough;
      const fallthrough = fn.blocks.get(fallthroughId);
      block.terminal = {
        kind: "goto",
        block: block.terminal.block,
        id: makeInstructionId(0),
        loc: block.terminal.loc,
        variant: "Break" /* Break */
      };
      if (fallthrough != null) {
        if (fallthrough.preds.size === 1 && fallthrough.preds.has(handlerId)) {
          fn.blocks.delete(fallthroughId);
        } else {
          fallthrough.preds.delete(handlerId);
        }
      }
    }
  }
}
function createTemporaryPlace(env, loc) {
  return {
    kind: "Identifier",
    identifier: makeTemporaryIdentifier(env.nextIdentifierId, loc),
    reactive: false,
    effect: "<unknown>" /* Unknown */,
    loc: GeneratedSource
  };
}
function clonePlaceToTemporary(env, place) {
  const temp = createTemporaryPlace(env, place.loc);
  temp.effect = place.effect;
  temp.identifier.type = place.identifier.type;
  temp.reactive = place.reactive;
  return temp;
}
function fixScopeAndIdentifierRanges(func) {
  var _a, _b;
  for (const [, block] of func.blocks) {
    const terminal = block.terminal;
    if (terminal.kind === "scope" || terminal.kind === "pruned-scope") {
      const fallthroughBlock = func.blocks.get(terminal.fallthrough);
      const firstId = (_b = (_a = fallthroughBlock.instructions[0]) == null ? void 0 : _a.id) != null ? _b : fallthroughBlock.terminal.id;
      terminal.scope.range.start = terminal.id;
      terminal.scope.range.end = firstId;
    }
  }
}

// ../babel-plugin-react-compiler/src/HIR/ObjectShape.ts
var PRIMITIVE_TYPE = {
  kind: "Primitive"
};
var nextAnonId = 0;
function createAnonId() {
  return `<generated_${nextAnonId++}>`;
}
function addFunction(registry, properties, fn, id = null, isConstructor = false) {
  const shapeId = id != null ? id : createAnonId();
  addShape(registry, shapeId, properties, __spreadProps(__spreadValues({}, fn), {
    hookKind: null
  }));
  return {
    kind: "Function",
    return: fn.returnType,
    shapeId,
    isConstructor
  };
}
function addHook(registry, fn, id = null) {
  const shapeId = id != null ? id : createAnonId();
  addShape(registry, shapeId, [], fn);
  return {
    kind: "Function",
    return: fn.returnType,
    shapeId,
    isConstructor: false
  };
}
function addObject(registry, id, properties) {
  const shapeId = id != null ? id : createAnonId();
  addShape(registry, shapeId, properties, null);
  return {
    kind: "Object",
    shapeId
  };
}
function addShape(registry, id, properties, functionType) {
  const shape = {
    properties: new Map(properties),
    functionType
  };
  CompilerError.invariant(!registry.has(id), {
    reason: `[ObjectShape] Could not add shape to registry: name ${id} already exists.`,
    description: null,
    loc: null,
    suggestions: null
  });
  registry.set(id, shape);
  return shape;
}
var BuiltInPropsId = "BuiltInProps";
var BuiltInArrayId = "BuiltInArray";
var BuiltInSetId = "BuiltInSet";
var BuiltInMapId = "BuiltInMap";
var BuiltInWeakSetId = "BuiltInWeakSet";
var BuiltInWeakMapId = "BuiltInWeakMap";
var BuiltInFunctionId = "BuiltInFunction";
var BuiltInJsxId = "BuiltInJsx";
var BuiltInObjectId = "BuiltInObject";
var BuiltInUseStateId = "BuiltInUseState";
var BuiltInSetStateId = "BuiltInSetState";
var BuiltInUseActionStateId = "BuiltInUseActionState";
var BuiltInSetActionStateId = "BuiltInSetActionState";
var BuiltInUseRefId = "BuiltInUseRefId";
var BuiltInRefValueId = "BuiltInRefValue";
var BuiltInMixedReadonlyId = "BuiltInMixedReadonly";
var BuiltInUseEffectHookId = "BuiltInUseEffectHook";
var BuiltInUseLayoutEffectHookId = "BuiltInUseLayoutEffectHook";
var BuiltInUseInsertionEffectHookId = "BuiltInUseInsertionEffectHook";
var BuiltInUseOperatorId = "BuiltInUseOperator";
var BuiltInUseReducerId = "BuiltInUseReducer";
var BuiltInDispatchId = "BuiltInDispatch";
var BuiltInUseContextHookId = "BuiltInUseContextHook";
var BuiltInUseTransitionId = "BuiltInUseTransition";
var BuiltInStartTransitionId = "BuiltInStartTransition";
var BuiltInFireId = "BuiltInFire";
var BuiltInFireFunctionId = "BuiltInFireFunction";
var ReanimatedSharedValueId = "ReanimatedSharedValueId";
var BUILTIN_SHAPES = /* @__PURE__ */ new Map();
addObject(BUILTIN_SHAPES, BuiltInPropsId, [
  ["ref", { kind: "Object", shapeId: BuiltInUseRefId }]
]);
addObject(BUILTIN_SHAPES, BuiltInArrayId, [
  [
    "indexOf",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "read" /* Read */,
      returnType: { kind: "Primitive" },
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "includes",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "read" /* Read */,
      returnType: { kind: "Primitive" },
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "pop",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "store" /* Store */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "at",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "concat",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "capture" /* Capture */,
      returnType: {
        kind: "Object",
        shapeId: BuiltInArrayId
      },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  ["length", PRIMITIVE_TYPE],
  [
    "push",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "capture" /* Capture */,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "store" /* Store */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "slice",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "read" /* Read */,
      returnType: {
        kind: "Object",
        shapeId: BuiltInArrayId
      },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "map",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Object", shapeId: BuiltInArrayId },
      /*
       * callee is ConditionallyMutate because items of the array
       * flow into the lambda and may be mutated there, even though
       * the array object itself is not modified
       */
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "mutable" /* Mutable */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "flatMap",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Object", shapeId: BuiltInArrayId },
      /*
       * callee is ConditionallyMutate because items of the array
       * flow into the lambda and may be mutated there, even though
       * the array object itself is not modified
       */
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "mutable" /* Mutable */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "filter",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Object", shapeId: BuiltInArrayId },
      /*
       * callee is ConditionallyMutate because items of the array
       * flow into the lambda and may be mutated there, even though
       * the array object itself is not modified
       */
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "mutable" /* Mutable */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "every",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Primitive" },
      /*
       * callee is ConditionallyMutate because items of the array
       * flow into the lambda and may be mutated there, even though
       * the array object itself is not modified
       */
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "primitive" /* Primitive */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "some",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Primitive" },
      /*
       * callee is ConditionallyMutate because items of the array
       * flow into the lambda and may be mutated there, even though
       * the array object itself is not modified
       */
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "primitive" /* Primitive */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "find",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Poly" },
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "mutable" /* Mutable */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "findIndex",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Primitive" },
      /*
       * callee is ConditionallyMutate because items of the array
       * flow into the lambda and may be mutated there, even though
       * the array object itself is not modified
       */
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "primitive" /* Primitive */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "join",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "read" /* Read */,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ]
  // TODO: rest of Array properties
]);
addObject(BUILTIN_SHAPES, BuiltInObjectId, [
  [
    "toString",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ]
  /*
   * TODO:
   * hasOwnProperty, isPrototypeOf, propertyIsEnumerable, toLocaleString, valueOf
   */
]);
addObject(BUILTIN_SHAPES, BuiltInSetId, [
  [
    /**
     * add(value)
     * Parameters
     *   value: the value of the element to add to the Set object.
     * Returns the Set object with added value.
     */
    "add",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["capture" /* Capture */],
      restParam: null,
      returnType: { kind: "Object", shapeId: BuiltInSetId },
      calleeEffect: "store" /* Store */,
      // returnValueKind is technically dependent on the ValueKind of the set itself
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    /**
     * clear()
     * Parameters none
     * Returns undefined
     */
    "clear",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "store" /* Store */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    /**
     * setInstance.delete(value)
     * Returns true if value was already in Set; otherwise false.
     */
    "delete",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "store" /* Store */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "has",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  ["size", PRIMITIVE_TYPE],
  [
    /**
     * difference(other)
     * Parameters
     *   other: A Set object, or set-like object.
     * Returns a new Set object containing elements in this set but not in the other set.
     */
    "difference",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["capture" /* Capture */],
      restParam: null,
      returnType: { kind: "Object", shapeId: BuiltInSetId },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    /**
     * union(other)
     * Parameters
     *   other: A Set object, or set-like object.
     * Returns a new Set object containing elements in either this set or the other set.
     */
    "union",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["capture" /* Capture */],
      restParam: null,
      returnType: { kind: "Object", shapeId: BuiltInSetId },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    /**
     * symmetricalDifference(other)
     * Parameters
     *   other: A Set object, or set-like object.
     * A new Set object containing elements which are in either this set or the other set, but not in both.
     */
    "symmetricalDifference",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["capture" /* Capture */],
      restParam: null,
      returnType: { kind: "Object", shapeId: BuiltInSetId },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    /**
     * isSubsetOf(other)
     * Parameters
     *   other: A Set object, or set-like object.
     * Returns true if all elements in this set are also in the other set, and false otherwise.
     */
    "isSubsetOf",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    /**
     * isSupersetOf(other)
     * Parameters
     *  other: A Set object, or set-like object.
     * Returns true if all elements in the other set are also in this set, and false otherwise.
     */
    "isSupersetOf",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    /**
     * forEach(callbackFn)
     * forEach(callbackFn, thisArg)
     */
    "forEach",
    addFunction(BUILTIN_SHAPES, [], {
      /**
       * see Array.map explanation for why arguments are marked `ConditionallyMutate`
       */
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "primitive" /* Primitive */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  /**
   * Iterators
   */
  [
    "entries",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "keys",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "values",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ]
]);
addObject(BUILTIN_SHAPES, BuiltInMapId, [
  [
    /**
     * clear()
     * Parameters none
     * Returns undefined
     */
    "clear",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "store" /* Store */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "delete",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "store" /* Store */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "get",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "has",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    /**
     * Params
     *   key: the key of the element to add to the Map object. The key may be
     *   any JavaScript type (any primitive value or any type of JavaScript
     *   object).
     *   value: the value of the element to add to the Map object.
     * Returns the Map object.
     */
    "set",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["capture" /* Capture */, "capture" /* Capture */],
      restParam: null,
      returnType: { kind: "Object", shapeId: BuiltInMapId },
      calleeEffect: "store" /* Store */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  ["size", PRIMITIVE_TYPE],
  [
    "forEach",
    addFunction(BUILTIN_SHAPES, [], {
      /**
       * see Array.map explanation for why arguments are marked `ConditionallyMutate`
       */
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "primitive" /* Primitive */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  /**
   * Iterators
   */
  [
    "entries",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "keys",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "values",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ]
]);
addObject(BUILTIN_SHAPES, BuiltInWeakSetId, [
  [
    /**
     * add(value)
     * Parameters
     *   value: the value of the element to add to the Set object.
     * Returns the Set object with added value.
     */
    "add",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["capture" /* Capture */],
      restParam: null,
      returnType: { kind: "Object", shapeId: BuiltInWeakSetId },
      calleeEffect: "store" /* Store */,
      // returnValueKind is technically dependent on the ValueKind of the set itself
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    /**
     * setInstance.delete(value)
     * Returns true if value was already in Set; otherwise false.
     */
    "delete",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "store" /* Store */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "has",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ]
]);
addObject(BUILTIN_SHAPES, BuiltInWeakMapId, [
  [
    "delete",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "store" /* Store */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "get",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: { kind: "Poly" },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "has",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    /**
     * Params
     *   key: the key of the element to add to the Map object. The key may be
     *   any JavaScript type (any primitive value or any type of JavaScript
     *   object).
     *   value: the value of the element to add to the Map object.
     * Returns the Map object.
     */
    "set",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["capture" /* Capture */, "capture" /* Capture */],
      restParam: null,
      returnType: { kind: "Object", shapeId: BuiltInWeakMapId },
      calleeEffect: "store" /* Store */,
      returnValueKind: "mutable" /* Mutable */
    })
  ]
]);
addObject(BUILTIN_SHAPES, BuiltInUseStateId, [
  ["0", { kind: "Poly" }],
  [
    "1",
    addFunction(
      BUILTIN_SHAPES,
      [],
      {
        positionalParams: [],
        restParam: "freeze" /* Freeze */,
        returnType: PRIMITIVE_TYPE,
        calleeEffect: "read" /* Read */,
        returnValueKind: "primitive" /* Primitive */
      },
      BuiltInSetStateId
    )
  ]
]);
addObject(BUILTIN_SHAPES, BuiltInUseTransitionId, [
  ["0", { kind: "Primitive" }],
  [
    "1",
    addFunction(
      BUILTIN_SHAPES,
      [],
      {
        positionalParams: [],
        restParam: null,
        returnType: PRIMITIVE_TYPE,
        calleeEffect: "read" /* Read */,
        returnValueKind: "primitive" /* Primitive */
      },
      BuiltInStartTransitionId
    )
  ]
]);
addObject(BUILTIN_SHAPES, BuiltInUseActionStateId, [
  ["0", { kind: "Poly" }],
  [
    "1",
    addFunction(
      BUILTIN_SHAPES,
      [],
      {
        positionalParams: [],
        restParam: "freeze" /* Freeze */,
        returnType: PRIMITIVE_TYPE,
        calleeEffect: "read" /* Read */,
        returnValueKind: "primitive" /* Primitive */
      },
      BuiltInSetActionStateId
    )
  ]
]);
addObject(BUILTIN_SHAPES, BuiltInUseReducerId, [
  ["0", { kind: "Poly" }],
  [
    "1",
    addFunction(
      BUILTIN_SHAPES,
      [],
      {
        positionalParams: [],
        restParam: "freeze" /* Freeze */,
        returnType: PRIMITIVE_TYPE,
        calleeEffect: "read" /* Read */,
        returnValueKind: "primitive" /* Primitive */
      },
      BuiltInDispatchId
    )
  ]
]);
addObject(BUILTIN_SHAPES, BuiltInUseRefId, [
  ["current", { kind: "Object", shapeId: BuiltInRefValueId }]
]);
addObject(BUILTIN_SHAPES, BuiltInRefValueId, [
  ["*", { kind: "Object", shapeId: BuiltInRefValueId }]
]);
addObject(BUILTIN_SHAPES, BuiltInMixedReadonlyId, [
  [
    "toString",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "read" /* Read */,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "indexOf",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "read" /* Read */,
      returnType: { kind: "Primitive" },
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "includes",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "read" /* Read */,
      returnType: { kind: "Primitive" },
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  [
    "at",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: ["read" /* Read */],
      restParam: null,
      returnType: { kind: "Object", shapeId: BuiltInMixedReadonlyId },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "frozen" /* Frozen */
    })
  ],
  [
    "map",
    addFunction(BUILTIN_SHAPES, [], {
      /**
       * Note `map`'s arguments are annotated as Effect.ConditionallyMutate as
       * calling `<array>.map(fn)` might invoke `fn`, which means replaying its
       * effects.
       *
       * (Note that Effect.Read / Effect.Capture on a function type means
       * potential data dependency or aliasing respectively.)
       */
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Object", shapeId: BuiltInArrayId },
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "mutable" /* Mutable */,
      noAlias: true
    })
  ],
  [
    "flatMap",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Object", shapeId: BuiltInArrayId },
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "mutable" /* Mutable */,
      noAlias: true
    })
  ],
  [
    "filter",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Object", shapeId: BuiltInArrayId },
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "mutable" /* Mutable */,
      noAlias: true
    })
  ],
  [
    "concat",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "capture" /* Capture */,
      returnType: {
        kind: "Object",
        shapeId: BuiltInArrayId
      },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "slice",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "read" /* Read */,
      returnType: {
        kind: "Object",
        shapeId: BuiltInArrayId
      },
      calleeEffect: "capture" /* Capture */,
      returnValueKind: "mutable" /* Mutable */
    })
  ],
  [
    "every",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Primitive" },
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "primitive" /* Primitive */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "some",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Primitive" },
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "primitive" /* Primitive */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "find",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Object", shapeId: BuiltInMixedReadonlyId },
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "frozen" /* Frozen */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "findIndex",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "mutate?" /* ConditionallyMutate */,
      returnType: { kind: "Primitive" },
      calleeEffect: "mutate?" /* ConditionallyMutate */,
      returnValueKind: "primitive" /* Primitive */,
      noAlias: true,
      mutableOnlyIfOperandsAreMutable: true
    })
  ],
  [
    "join",
    addFunction(BUILTIN_SHAPES, [], {
      positionalParams: [],
      restParam: "read" /* Read */,
      returnType: PRIMITIVE_TYPE,
      calleeEffect: "read" /* Read */,
      returnValueKind: "primitive" /* Primitive */
    })
  ],
  ["*", { kind: "Object", shapeId: BuiltInMixedReadonlyId }]
]);
addObject(BUILTIN_SHAPES, BuiltInJsxId, []);
addObject(BUILTIN_SHAPES, BuiltInFunctionId, []);
var DefaultMutatingHook = addHook(
  BUILTIN_SHAPES,
  {
    positionalParams: [],
    restParam: "mutate?" /* ConditionallyMutate */,
    returnType: { kind: "Poly" },
    calleeEffect: "read" /* Read */,
    hookKind: "Custom",
    returnValueKind: "mutable" /* Mutable */
  },
  "DefaultMutatingHook"
);
var DefaultNonmutatingHook = addHook(
  BUILTIN_SHAPES,
  {
    positionalParams: [],
    restParam: "freeze" /* Freeze */,
    returnType: { kind: "Poly" },
    calleeEffect: "read" /* Read */,
    hookKind: "Custom",
    returnValueKind: "frozen" /* Frozen */
  },
  "DefaultNonmutatingHook"
);

// ../babel-plugin-react-compiler/src/HIR/BuildHIR.ts
function lower(func, env, bindings = null, capturedRefs = [], parent = null) {
  var _a, _b, _c;
  const builder = new HIRBuilder(env, parent != null ? parent : func, bindings, capturedRefs);
  const context = [];
  for (const ref of capturedRefs != null ? capturedRefs : []) {
    context.push({
      kind: "Identifier",
      identifier: builder.resolveBinding(ref),
      effect: "<unknown>" /* Unknown */,
      reactive: false,
      loc: (_a = ref.loc) != null ? _a : GeneratedSource
    });
  }
  let id = null;
  if (func.isFunctionDeclaration() || func.isFunctionExpression()) {
    const idNode = func.get("id");
    if (hasNode(idNode)) {
      id = idNode.node.name;
    }
  }
  const params = [];
  func.get("params").forEach((param) => {
    var _a2, _b2, _c2, _d, _e, _f, _g, _h, _i;
    if (param.isIdentifier()) {
      const binding = builder.resolveIdentifier(param);
      if (binding.kind !== "Identifier") {
        builder.errors.push({
          reason: `(BuildHIR::lower) Could not find binding for param \`${param.node.name}\``,
          severity: "Invariant" /* Invariant */,
          loc: (_a2 = param.node.loc) != null ? _a2 : null,
          suggestions: null
        });
        return;
      }
      const place = {
        kind: "Identifier",
        identifier: binding.identifier,
        effect: "<unknown>" /* Unknown */,
        reactive: false,
        loc: (_b2 = param.node.loc) != null ? _b2 : GeneratedSource
      };
      params.push(place);
    } else if (param.isObjectPattern() || param.isArrayPattern() || param.isAssignmentPattern()) {
      const place = {
        kind: "Identifier",
        identifier: builder.makeTemporary((_c2 = param.node.loc) != null ? _c2 : GeneratedSource),
        effect: "<unknown>" /* Unknown */,
        reactive: false,
        loc: (_d = param.node.loc) != null ? _d : GeneratedSource
      };
      promoteTemporary(place.identifier);
      params.push(place);
      lowerAssignment(
        builder,
        (_e = param.node.loc) != null ? _e : GeneratedSource,
        "Let" /* Let */,
        param,
        place,
        "Assignment"
      );
    } else if (param.isRestElement()) {
      const place = {
        kind: "Identifier",
        identifier: builder.makeTemporary((_f = param.node.loc) != null ? _f : GeneratedSource),
        effect: "<unknown>" /* Unknown */,
        reactive: false,
        loc: (_g = param.node.loc) != null ? _g : GeneratedSource
      };
      params.push({
        kind: "Spread",
        place
      });
      lowerAssignment(
        builder,
        (_h = param.node.loc) != null ? _h : GeneratedSource,
        "Let" /* Let */,
        param.get("argument"),
        place,
        "Assignment"
      );
    } else {
      builder.errors.push({
        reason: `(BuildHIR::lower) Handle ${param.node.type} params`,
        severity: "Todo" /* Todo */,
        loc: (_i = param.node.loc) != null ? _i : null,
        suggestions: null
      });
    }
  });
  let directives = [];
  const body = func.get("body");
  if (body.isExpression()) {
    const fallthrough = builder.reserve("block");
    const terminal = {
      kind: "return",
      loc: GeneratedSource,
      value: lowerExpressionToTemporary(builder, body),
      id: makeInstructionId(0)
    };
    builder.terminateWithContinuation(terminal, fallthrough);
  } else if (body.isBlockStatement()) {
    lowerStatement(builder, body);
    directives = body.get("directives").map((d) => d.node.value.value);
  } else {
    builder.errors.push({
      severity: "InvalidJS" /* InvalidJS */,
      reason: `Unexpected function body kind`,
      description: `Expected function body to be an expression or a block statement, got \`${body.type}\``,
      loc: (_b = body.node.loc) != null ? _b : null,
      suggestions: null
    });
  }
  if (builder.errors.hasErrors()) {
    return Err(builder.errors);
  }
  builder.terminate(
    {
      kind: "return",
      loc: GeneratedSource,
      value: lowerValueToTemporary(builder, {
        kind: "Primitive",
        value: void 0,
        loc: GeneratedSource
      }),
      id: makeInstructionId(0)
    },
    null
  );
  return Ok({
    id,
    params,
    fnType: parent == null ? env.fnType : "Other",
    returnTypeAnnotation: null,
    // TODO: extract the actual return type node if present
    returnType: makeType(),
    body: builder.build(),
    context,
    generator: func.node.generator === true,
    async: func.node.async === true,
    loc: (_c = func.node.loc) != null ? _c : GeneratedSource,
    env,
    effects: null,
    directives
  });
}
function lowerStatement(builder, stmtPath, label = null) {
  var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _A, _B, _C, _D, _E, _F, _G, _H, _I, _J, _K, _L, _M, _N, _O, _P, _Q, _R, _S, _T, _U, _V, _W, _X, _Y, _Z, __, _$;
  const stmtNode = stmtPath.node;
  switch (stmtNode.type) {
    case "ThrowStatement": {
      const stmt = stmtPath;
      const value = lowerExpressionToTemporary(builder, stmt.get("argument"));
      const handler = builder.resolveThrowHandler();
      if (handler != null) {
        builder.errors.push({
          reason: "(BuildHIR::lowerStatement) Support ThrowStatement inside of try/catch",
          severity: "Todo" /* Todo */,
          loc: (_a = stmt.node.loc) != null ? _a : null,
          suggestions: null
        });
      }
      const terminal = {
        kind: "throw",
        value,
        id: makeInstructionId(0),
        loc: (_b = stmt.node.loc) != null ? _b : GeneratedSource
      };
      builder.terminate(terminal, "block");
      return;
    }
    case "ReturnStatement": {
      const stmt = stmtPath;
      const argument = stmt.get("argument");
      let value;
      if (argument.node === null) {
        value = lowerValueToTemporary(builder, {
          kind: "Primitive",
          value: void 0,
          loc: GeneratedSource
        });
      } else {
        value = lowerExpressionToTemporary(
          builder,
          argument
        );
      }
      const terminal = {
        kind: "return",
        loc: (_c = stmt.node.loc) != null ? _c : GeneratedSource,
        value,
        id: makeInstructionId(0)
      };
      builder.terminate(terminal, "block");
      return;
    }
    case "IfStatement": {
      const stmt = stmtPath;
      const continuationBlock = builder.reserve("block");
      const consequentBlock = builder.enter("block", (_blockId) => {
        var _a2;
        const consequent = stmt.get("consequent");
        lowerStatement(builder, consequent);
        return {
          kind: "goto",
          block: continuationBlock.id,
          variant: "Break" /* Break */,
          id: makeInstructionId(0),
          loc: (_a2 = consequent.node.loc) != null ? _a2 : GeneratedSource
        };
      });
      let alternateBlock;
      const alternate = stmt.get("alternate");
      if (hasNode(alternate)) {
        alternateBlock = builder.enter("block", (_blockId) => {
          var _a2, _b2;
          lowerStatement(builder, alternate);
          return {
            kind: "goto",
            block: continuationBlock.id,
            variant: "Break" /* Break */,
            id: makeInstructionId(0),
            loc: (_b2 = (_a2 = alternate.node) == null ? void 0 : _a2.loc) != null ? _b2 : GeneratedSource
          };
        });
      } else {
        alternateBlock = continuationBlock.id;
      }
      const test = lowerExpressionToTemporary(builder, stmt.get("test"));
      const terminal = {
        kind: "if",
        test,
        consequent: consequentBlock,
        alternate: alternateBlock,
        fallthrough: continuationBlock.id,
        id: makeInstructionId(0),
        loc: (_d = stmt.node.loc) != null ? _d : GeneratedSource
      };
      builder.terminateWithContinuation(terminal, continuationBlock);
      return;
    }
    case "BlockStatement": {
      const stmt = stmtPath;
      const statements = stmt.get("body");
      const hoistableIdentifiers = /* @__PURE__ */ new Set();
      for (const [, binding] of Object.entries(stmt.scope.bindings)) {
        if (binding.kind !== "param") {
          hoistableIdentifiers.add(binding.identifier);
        }
      }
      for (const s of statements) {
        const willHoist = /* @__PURE__ */ new Set();
        let fnDepth = s.isFunctionDeclaration() ? 1 : 0;
        const withFunctionContext = {
          enter: () => {
            fnDepth++;
          },
          exit: () => {
            fnDepth--;
          }
        };
        s.traverse({
          FunctionExpression: withFunctionContext,
          FunctionDeclaration: withFunctionContext,
          ArrowFunctionExpression: withFunctionContext,
          ObjectMethod: withFunctionContext,
          Identifier(id) {
            const id2 = id;
            if (!id2.isReferencedIdentifier() && // isReferencedIdentifier is broken and returns false for reassignments
            id.parent.type !== "AssignmentExpression") {
              return;
            }
            const binding = id.scope.getBinding(id.node.name);
            if (binding != null && hoistableIdentifiers.has(binding.identifier) && (fnDepth > 0 || binding.kind === "hoisted")) {
              willHoist.add(id);
            }
          }
        });
        s.traverse({
          Identifier(path) {
            if (hoistableIdentifiers.has(path.node)) {
              hoistableIdentifiers.delete(path.node);
            }
          }
        });
        for (const id of willHoist) {
          const binding = stmt.scope.getBinding(id.node.name);
          CompilerError.invariant(binding != null, {
            reason: "Expected to find binding for hoisted identifier",
            description: `Could not find a binding for ${id.node.name}`,
            suggestions: null,
            loc: (_e = id.node.loc) != null ? _e : GeneratedSource
          });
          if (builder.environment.isHoistedIdentifier(binding.identifier)) {
            continue;
          }
          let kind;
          if (binding.kind === "const" || binding.kind === "var") {
            kind = "HoistedConst" /* HoistedConst */;
          } else if (binding.kind === "let") {
            kind = "HoistedLet" /* HoistedLet */;
          } else if (binding.path.isFunctionDeclaration()) {
            kind = "HoistedFunction" /* HoistedFunction */;
          } else if (!binding.path.isVariableDeclarator()) {
            builder.errors.push({
              severity: "Todo" /* Todo */,
              reason: "Unsupported declaration type for hoisting",
              description: `variable "${binding.identifier.name}" declared with ${binding.path.type}`,
              suggestions: null,
              loc: (_f = id.parentPath.node.loc) != null ? _f : GeneratedSource
            });
            continue;
          } else {
            builder.errors.push({
              severity: "Todo" /* Todo */,
              reason: "Handle non-const declarations for hoisting",
              description: `variable "${binding.identifier.name}" declared with ${binding.kind}`,
              suggestions: null,
              loc: (_g = id.parentPath.node.loc) != null ? _g : GeneratedSource
            });
            continue;
          }
          const identifier4 = builder.resolveIdentifier(id);
          CompilerError.invariant(identifier4.kind === "Identifier", {
            reason: "Expected hoisted binding to be a local identifier, not a global",
            loc: (_h = id.node.loc) != null ? _h : GeneratedSource
          });
          const place = {
            effect: "<unknown>" /* Unknown */,
            identifier: identifier4.identifier,
            kind: "Identifier",
            reactive: false,
            loc: (_i = id.node.loc) != null ? _i : GeneratedSource
          };
          lowerValueToTemporary(builder, {
            kind: "DeclareContext",
            lvalue: {
              kind,
              place
            },
            loc: (_j = id.node.loc) != null ? _j : GeneratedSource
          });
          builder.environment.addHoistedIdentifier(binding.identifier);
        }
        lowerStatement(builder, s);
      }
      return;
    }
    case "BreakStatement": {
      const stmt = stmtPath;
      const block = builder.lookupBreak((_l = (_k = stmt.node.label) == null ? void 0 : _k.name) != null ? _l : null);
      builder.terminate(
        {
          kind: "goto",
          block,
          variant: "Break" /* Break */,
          id: makeInstructionId(0),
          loc: (_m = stmt.node.loc) != null ? _m : GeneratedSource
        },
        "block"
      );
      return;
    }
    case "ContinueStatement": {
      const stmt = stmtPath;
      const block = builder.lookupContinue((_o = (_n = stmt.node.label) == null ? void 0 : _n.name) != null ? _o : null);
      builder.terminate(
        {
          kind: "goto",
          block,
          variant: "Continue" /* Continue */,
          id: makeInstructionId(0),
          loc: (_p = stmt.node.loc) != null ? _p : GeneratedSource
        },
        "block"
      );
      return;
    }
    case "ForStatement": {
      const stmt = stmtPath;
      const testBlock = builder.reserve("loop");
      const continuationBlock = builder.reserve("block");
      const initBlock = builder.enter("loop", (_blockId) => {
        var _a2, _b2, _c2, _d2;
        const init = stmt.get("init");
        if (!init.isVariableDeclaration()) {
          builder.errors.push({
            reason: "(BuildHIR::lowerStatement) Handle non-variable initialization in ForStatement",
            severity: "Todo" /* Todo */,
            loc: (_a2 = stmt.node.loc) != null ? _a2 : null,
            suggestions: null
          });
          return {
            kind: "unsupported",
            id: makeInstructionId(0),
            loc: (_c2 = (_b2 = init.node) == null ? void 0 : _b2.loc) != null ? _c2 : GeneratedSource
          };
        }
        lowerStatement(builder, init);
        return {
          kind: "goto",
          block: testBlock.id,
          variant: "Break" /* Break */,
          id: makeInstructionId(0),
          loc: (_d2 = init.node.loc) != null ? _d2 : GeneratedSource
        };
      });
      let updateBlock = null;
      const update2 = stmt.get("update");
      if (hasNode(update2)) {
        updateBlock = builder.enter("loop", (_blockId) => {
          var _a2, _b2;
          lowerExpressionToTemporary(builder, update2);
          return {
            kind: "goto",
            block: testBlock.id,
            variant: "Break" /* Break */,
            id: makeInstructionId(0),
            loc: (_b2 = (_a2 = update2.node) == null ? void 0 : _a2.loc) != null ? _b2 : GeneratedSource
          };
        });
      }
      const bodyBlock = builder.enter("block", (_blockId) => {
        return builder.loop(
          label,
          updateBlock != null ? updateBlock : testBlock.id,
          continuationBlock.id,
          () => {
            var _a2;
            const body = stmt.get("body");
            lowerStatement(builder, body);
            return {
              kind: "goto",
              block: updateBlock != null ? updateBlock : testBlock.id,
              variant: "Continue" /* Continue */,
              id: makeInstructionId(0),
              loc: (_a2 = body.node.loc) != null ? _a2 : GeneratedSource
            };
          }
        );
      });
      builder.terminateWithContinuation(
        {
          kind: "for",
          loc: (_q = stmtNode.loc) != null ? _q : GeneratedSource,
          init: initBlock,
          test: testBlock.id,
          update: updateBlock,
          loop: bodyBlock,
          fallthrough: continuationBlock.id,
          id: makeInstructionId(0)
        },
        testBlock
      );
      const test = stmt.get("test");
      if (test.node == null) {
        builder.errors.push({
          reason: `(BuildHIR::lowerStatement) Handle empty test in ForStatement`,
          severity: "Todo" /* Todo */,
          loc: (_r = stmt.node.loc) != null ? _r : null,
          suggestions: null
        });
      } else {
        builder.terminateWithContinuation(
          {
            kind: "branch",
            test: lowerExpressionToTemporary(
              builder,
              test
            ),
            consequent: bodyBlock,
            alternate: continuationBlock.id,
            fallthrough: continuationBlock.id,
            id: makeInstructionId(0),
            loc: (_s = stmt.node.loc) != null ? _s : GeneratedSource
          },
          continuationBlock
        );
      }
      return;
    }
    case "WhileStatement": {
      const stmt = stmtPath;
      const conditionalBlock = builder.reserve("loop");
      const continuationBlock = builder.reserve("block");
      const loopBlock = builder.enter("block", (_blockId) => {
        return builder.loop(
          label,
          conditionalBlock.id,
          continuationBlock.id,
          () => {
            var _a2;
            const body = stmt.get("body");
            lowerStatement(builder, body);
            return {
              kind: "goto",
              block: conditionalBlock.id,
              variant: "Continue" /* Continue */,
              id: makeInstructionId(0),
              loc: (_a2 = body.node.loc) != null ? _a2 : GeneratedSource
            };
          }
        );
      });
      const loc = (_t = stmt.node.loc) != null ? _t : GeneratedSource;
      builder.terminateWithContinuation(
        {
          kind: "while",
          loc,
          test: conditionalBlock.id,
          loop: loopBlock,
          fallthrough: continuationBlock.id,
          id: makeInstructionId(0)
        },
        conditionalBlock
      );
      const test = lowerExpressionToTemporary(builder, stmt.get("test"));
      const terminal = {
        kind: "branch",
        test,
        consequent: loopBlock,
        alternate: continuationBlock.id,
        fallthrough: conditionalBlock.id,
        id: makeInstructionId(0),
        loc: (_u = stmt.node.loc) != null ? _u : GeneratedSource
      };
      builder.terminateWithContinuation(terminal, continuationBlock);
      return;
    }
    case "LabeledStatement": {
      const stmt = stmtPath;
      const label2 = stmt.node.label.name;
      const body = stmt.get("body");
      switch (body.node.type) {
        case "ForInStatement":
        case "ForOfStatement":
        case "ForStatement":
        case "WhileStatement":
        case "DoWhileStatement": {
          lowerStatement(builder, stmt.get("body"), label2);
          break;
        }
        default: {
          const continuationBlock = builder.reserve("block");
          const block = builder.enter("block", () => {
            var _a2;
            const body2 = stmt.get("body");
            builder.label(label2, continuationBlock.id, () => {
              lowerStatement(builder, body2);
            });
            return {
              kind: "goto",
              block: continuationBlock.id,
              variant: "Break" /* Break */,
              id: makeInstructionId(0),
              loc: (_a2 = body2.node.loc) != null ? _a2 : GeneratedSource
            };
          });
          builder.terminateWithContinuation(
            {
              kind: "label",
              block,
              fallthrough: continuationBlock.id,
              id: makeInstructionId(0),
              loc: (_v = stmt.node.loc) != null ? _v : GeneratedSource
            },
            continuationBlock
          );
        }
      }
      return;
    }
    case "SwitchStatement": {
      const stmt = stmtPath;
      const continuationBlock = builder.reserve("block");
      let fallthrough = continuationBlock.id;
      const cases = [];
      let hasDefault = false;
      for (let ii = stmt.get("cases").length - 1; ii >= 0; ii--) {
        const case_ = stmt.get("cases")[ii];
        const testExpr = case_.get("test");
        if (testExpr.node == null) {
          if (hasDefault) {
            builder.errors.push({
              reason: `Expected at most one \`default\` branch in a switch statement, this code should have failed to parse`,
              severity: "InvalidJS" /* InvalidJS */,
              loc: (_w = case_.node.loc) != null ? _w : null,
              suggestions: null
            });
            break;
          }
          hasDefault = true;
        }
        const block = builder.enter("block", (_blockId) => {
          return builder.switch(label, continu