"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsiSkottieAnimation = void 0;
var _Host = require("./Host");
var _JsiSkTypeface = require("./JsiSkTypeface");
var _JsiSkColor = require("./JsiSkColor");
var _JsiSkRect = require("./JsiSkRect");
class JsiSkottieAnimation extends _Host.HostObject {
  constructor(CanvasKit, ref) {
    super(CanvasKit, ref, "SkottieAnimation");
  }
  getOpacityProps() {
    return this.ref.getOpacityProps();
  }
  getTextProps() {
    return this.ref.getTextProps();
  }
  getColorProps() {
    return this.ref.getColorProps().map(({
      key,
      value
    }) => ({
      key,
      value: (0, _JsiSkColor.Color)(value)
    }));
  }
  getTransformProps() {
    return this.ref.getTransformProps().map(({
      key,
      value
    }) => ({
      key,
      value: {
        anchor: {
          x: value.anchor[0],
          y: value.anchor[1]
        },
        position: {
          x: value.position[0],
          y: value.position[1]
        },
        scale: {
          x: value.scale[0],
          y: value.scale[1]
        },
        rotation: value.rotation,
        skew: value.skew,
        skewAxis: value.skew_axis
      }
    }));
  }
  setColor(key, color) {
    return this.ref.setColor(key, color);
  }
  setText(key, text, size) {
    return this.ref.setText(key, text, size);
  }
  setOpacity(key, opacity) {
    return this.ref.setOpacity(key, opacity);
  }
  setTransform(key, anchor, position, scale, rotation, skew, skewAxis) {
    const a = Float32Array.of(anchor.x, anchor.y);
    const p = Float32Array.of(position.x, position.y);
    const s = Float32Array.of(scale.x, scale.y);
    return this.ref.setTransform(key, a, p, s, rotation, skew, skewAxis);
  }
  getSlotInfo() {
    return this.ref.getSlotInfo();
  }
  setColorSlot(key, color) {
    return this.ref.setColorSlot(key, color);
  }
  setScalarSlot(key, scalar) {
    return this.ref.setScalarSlot(key, scalar);
  }
  setVec2Slot(key, vec2) {
    return this.ref.setVec2Slot(key, Float32Array.of(vec2.x, vec2.y));
  }
  setTextSlot(key, text) {
    var _text$text, _text$textSize, _text$minTextSize, _text$maxTextSize, _text$strokeWidth, _text$lineHeight, _text$lineShift;
    const txt = {
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-expect-error
      typeface: text.typeface && text.typeface instanceof _JsiSkTypeface.JsiSkTypeface ? text.typeface.ref : null,
      text: (_text$text = text.text) !== null && _text$text !== void 0 ? _text$text : "",
      textSize: (_text$textSize = text.textSize) !== null && _text$textSize !== void 0 ? _text$textSize : 0,
      minTextSize: (_text$minTextSize = text.minTextSize) !== null && _text$minTextSize !== void 0 ? _text$minTextSize : 0,
      maxTextSize: (_text$maxTextSize = text.maxTextSize) !== null && _text$maxTextSize !== void 0 ? _text$maxTextSize : Number.MAX_VALUE,
      strokeWidth: (_text$strokeWidth = text.strokeWidth) !== null && _text$strokeWidth !== void 0 ? _text$strokeWidth : 0,
      lineHeight: (_text$lineHeight = text.lineHeight) !== null && _text$lineHeight !== void 0 ? _text$lineHeight : 0,
      lineShift: (_text$lineShift = text.lineShift) !== null && _text$lineShift !== void 0 ? _text$lineShift : 0,
      ascent: text.ascent,
      maxLines: text.maxLines,
      // TODO: implement
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      //@ts-expect-error
      horizAlign: this.CanvasKit.TextAlign.Left,
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      //@ts-expect-error
      vertAlign: this.CanvasKit.VerticalTextAlign.Top,
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      //@ts-expect-error
      strokeJoin: this.CanvasKit.StrokeJoin.Miter,
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      //@ts-expect-error
      direction: this.CanvasKit.TextDirection.LTR,
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-expect-error
      linebreak: this.CanvasKit.LineBreakType.HardLineBreak,
      // eslint-disable-next-line @typescript-eslint/ban-ts-comment
      // @ts-expect-error
      resize: this.CanvasKit.ResizePolicy.None,
      boundingBox: text.boundingBox ? this.CanvasKit.XYWHRect(text.boundingBox.x, text.boundingBox.y, text.boundingBox.width, text.boundingBox.height) : [0, 0, 0, 0],
      fillColor: text.fillColor ? (0, _JsiSkColor.Color)(text.fillColor) : this.CanvasKit.TRANSPARENT,
      strokeColor: text.strokeColor ? (0, _JsiSkColor.Color)(text.strokeColor) : this.CanvasKit.TRANSPARENT
    };
    return this.ref.setTextSlot(key, txt);
  }
  setImageSlot(key, assetName) {
    return this.ref.setImageSlot(key, assetName);
  }
  getColorSlot(key) {
    const color = this.ref.getColorSlot(key);
    return color;
  }
  getScalarSlot(key) {
    return this.ref.getScalarSlot(key);
  }
  getVec2Slot(key) {
    const vec2 = this.ref.getVec2Slot(key);
    if (!vec2) {
      return null;
    }
    return {
      x: vec2[0],
      y: vec2[1]
    };
  }
  getTextSlot(key) {
    const result = this.ref.getTextSlot(key);
    const textSlot = {};
    if (result) {
      if (result.typeface) {
        textSlot.typeface = new _JsiSkTypeface.JsiSkTypeface(this.CanvasKit, result.typeface);
      }
      if (result.text) {
        textSlot.text = result.text;
      }
      if (result.textSize) {
        textSlot.textSize = result.textSize;
      }
      if (result.minTextSize) {
        textSlot.minTextSize = result.minTextSize;
      }
      if (result.maxTextSize) {
        textSlot.maxTextSize = result.maxTextSize;
      }
      if (result.strokeWidth) {
        textSlot.strokeWidth = result.strokeWidth;
      }
      if (result.lineHeight) {
        textSlot.lineHeight = result.lineHeight;
      }
      if (result.lineShift) {
        textSlot.lineShift = result.lineShift;
      }
      if (result.ascent) {
        textSlot.ascent = result.ascent;
      }
      if (result.maxLines) {
        textSlot.maxLines = result.maxLines;
      }
      // if (result.horizAlign) {
      //   textSlot.horizAlign = result.horizAlign;
      // }
      // if (result.vertAlign) {
      //   textSlot.vertAlign = result.vertAlign;
      // }
      // if (result.strokeJoin) {
      //   textSlot.strokeJoin = result.strokeJoin;
      // }
      // if (result.direction) {
      //   textSlot.direction = result.direction;
      // }
      // if (result.linebreak) {
      //   textSlot.linebreak = result.linebreak;
      // }
      // if (result.resize) {
      //   textSlot.resize = result.resize;
      // }
      // if (result.boundingBox) {
      //   textSlot.boundingBox = new JsiSkRect(
      //     this.CanvasKit,
      //     result.boundingBox
      //   );
      // }
      // if (result.fillColor) {
      //   textSlot.fillColor = Color(result.fillColor);
      // }
      // if (result.strokeColor) {
      //   textSlot.strokeColor = Color(result.strokeColor);
      // }
    }
    return textSlot;
  }
  duration() {
    return this.ref.duration();
  }
  fps() {
    return this.ref.fps();
  }
  render(canvas, dstRect) {
    const [width, height] = this.ref.size();
    this.ref.render(canvas.ref, dstRect && dstRect instanceof _JsiSkRect.JsiSkRect ? dstRect.ref : Float32Array.of(0, 0, width, height));
  }
  seekFrame(frame, damageRect) {
    const result = this.ref.seekFrame(frame);
    if (damageRect && damageRect instanceof _JsiSkRect.JsiSkRect) {
      damageRect.ref[0] = result[0];
      damageRect.ref[1] = result[1];
      damageRect.ref[2] = result[2];
      damageRect.ref[3] = result[3];
    }
  }
  size() {
    const [width, height] = this.ref.size();
    return {
      width,
      height
    };
  }
  version() {
    return this.ref.version();
  }
  dispose() {
    this.ref.delete();
  }
}
exports.JsiSkottieAnimation = JsiSkottieAnimation;
//# sourceMappingURL=JsiSkottieAnimation.js.map