import type { Resolution } from "metro-resolver";
import type { ResolutionContextCompat } from "../types";
/**
 * Returns whether the file at specified path is an asset.
 */
export declare function isAssetFile(context: ResolutionContextCompat, filePath: string): boolean;
/**
 * Resolve a file path as an asset. Returns the set of files found after
 * expanding asset resolutions (e.g. `icon@2x.png`).
 *
 * @see {@link https://github.com/facebook/metro/commit/6e6f36fd982b9226b7daafd1c942c7be32f9af40}
 */
export declare function resolveAsset(context: ResolutionContextCompat, filePath: string): Resolution;
//# sourceMappingURL=assets.d.ts.map