import type { PackageModuleRef } from "@rnx-kit/tools-node/module";
import type { ModuleResolver, ResolutionContextCompat } from "../types";
type Resolver = (fromDir: string, moduleId: string) => string;
type ResolverOptions = {
    extensions: string[];
    mainFields: string[];
};
type Options = Partial<ResolverOptions> & {
    test: (moduleName: string) => boolean;
};
export declare function remapLibToSrc({ originModulePath }: ResolutionContextCompat, ref: PackageModuleRef, resolver: Resolver): string | undefined;
export declare function resolveModule(fromDir: string, moduleId: string, resolver: Resolver, { mainFields }: ResolverOptions): string;
export declare function resolveModulePath({ originModulePath }: ResolutionContextCompat, ref: PackageModuleRef, resolver: Resolver, options: ResolverOptions): PackageModuleRef;
export declare function remapImportPath(pluginOptions: Options): ModuleResolver;
export {};
//# sourceMappingURL=remapImportPath.d.ts.map